# Perl script for a POV-Ray animation, requires wheel.pov
# by Jussi Kantola

#
# 1st let's define some macros...
#
$Pi = 3.14592654;
$P2 = $Pi/4;
$P3 = $Pi/2;
$P4 = (3*$Pi)/4;

#
# loop to create the required values
#

for ($t = 0; $t <= 60; $t++)
   {
   $Sphere1_Rad = sin(($Pi-(($Pi/180)*$t*3)));     # Sphere radiuses
   $Sphere2_Rad = sin(($Pi-(($Pi/180)*$t*3))+$P2); # they fluctuate
   $Sphere3_Rad = sin(($Pi-(($Pi/180)*$t*3))+$P3); # in different 
   $Sphere4_Rad = sin(($Pi-(($Pi/180)*$t*3))+$P4); # phases!

   $TRad = sqrt(sin($Pi-($Pi/180)*$t*3)*sin($Pi-($Pi/180)*$t*3));
   $WheelRot = 12*$t;

   $L1X = 3*sin(((2*$Pi)-(($Pi/360)*$t*12)));  # spotlights
   $L1Z = 3*cos(((2*$Pi)-(($Pi/360)*$t*12)));
   $L2X = 2*sin(((2*$Pi)+(($Pi/360)*$t*12)));
   $L2Z = 2*cos(((2*$Pi)+(($Pi/360)*$t*12)));

   open (MOVIE, ">wheel$t.pov");
      print (MOVIE "#declare Sphere1_Rad = $Sphere1_Rad\n");
      print (MOVIE "#declare Sphere2_Rad = $Sphere2_Rad\n");
      print (MOVIE "#declare Sphere3_Rad = $Sphere3_Rad\n");
      print (MOVIE "#declare Sphere4_Rad = $Sphere4_Rad\n");
      print (MOVIE "#declare TRad = 5*$TRad\n");
      print (MOVIE "#declare WheelRot = $WheelRot\n");
      print (MOVIE "#declare L1X = $L1X\n");
      print (MOVIE "#declare L1Z = $L1Z\n");
      print (MOVIE "#declare L2X = $L2X\n");
      print (MOVIE "#declare L2Z = $L2Z\n");
   close (MOVIE);
   }

# now we create a shell script to do the dirty job
# This one creates a MPEG animation using Andy Hung's software
#

open (ANIMATE, ">animate");
for ($t = 0; $t <= 60; $t++)
   {
   print (ANIMATE "# wheel$t.pov:\n");
   print (ANIMATE "cat wheel.pov >> wheel$t.pov\n");
   print (ANIMATE "ftpov -iwheel$t.pov -owheel$t.tga wheel.def\n");
   print (ANIMATE "cjpeg -quality 90 -restart 1 wheel$t.tga > wheel$t.jpg\n");
   print (ANIMATE "tgatoppm wheel$t.tga | ppmtoyuvsplit wheel$t\n");
   print (ANIMATE "rm wheel$t.tga\n");
   }
print (ANIMATE "mpeg -a 0 -b 60 -h 160 -v 120 -PF wheel -s wheel.mpg\n");
close (ANIMATE);
chmod 755, "animate";

# run this to remove all the unnecessary files after you've created
# the animation...
#

open (CLEAN, ">clean");
  print (CLEAN "rm wheel[0-9]*.jpg\n");
  print (CLEAN "rm wheel[0-9]*.pov\n");
  print (CLEAN "rm wheel*.[Y,U,V]\n");
close (CLEAN);
chmod 755, "clean";

# a defaults file for pov-ray
#

open (DEFS, ">wheel.def");
   print (DEFS "+a0.4 +b32 -c -d +ft +mb1 -p +q9 +v +w160 +h120 -x\n");
close (DEFS);
