#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

/* Camera*/
camera {
   location <0.0, 0.0, 0.0>
   translate <   -0.7500000,   -4.000000,    2.0000>
   direction <0,   1.43, 0>
   up <0, 0, 1>
   sky  <0, 0, 1>
   right <1.33, 0, 0>
   look_at <1.2, .5, 1>
}

/* Light1 */
light_source { 
        <1.5000, -2.0000, 2.0000> color red 1.00 green 1.00 blue 1.00
        spotlight
        point_at <0.5000, 0.5000, 0.0000>
        tightness 0
        radius 40
        falloff 80.0
    }

/* Light 2*/
light_source {
        <-5000, -8.0000, 7.0000> color red 1.00 green 1.00 blue 1.00
        spotlight
        point_at <0.5000, 0.5000, 0.0000>
        tightness 0
        radius 40
        falloff 80.0
    }


object { //Sky
   sphere { <0.0, -1000.0, 0.0> 9999000 }
   texture {
    pigment {
        gradient <0, 0, 1 >
        colour_map {
            [0.0 0.15 colour OrangeRed colour MidnightBlue]
            [0.15 1.01 colour MidnightBlue colour Black]
            }
        }
    finish {
        ambient 0.7
        diffuse 0.0
        }
    scale <10, 10, 10000000>
    }
}

object {
    plane { <0, 0, -1> 0 translate <0, 0, 200>}
    texture {
        turbulence 0.0
        pigment {
            bozo
            colour_map {
            [0.0 0.1   colour red 0.9 green 0.9 blue 0.9
            colour red 0.8 green 0.8 blue 0.8 filter 0.5 ]
            [0.1 0.5   colour red 0.8 green 0.8 blue 0.8 filter 0.5
            colour red 1.0 green 1.0 blue 1.0 filter 1.0 ]
            [0.5 1 colour red 1.0 green 1.0 blue 1.0 filter 1.0
            colour red 1.0 green 1.0 blue 1.0 filter 1.0]
            }
        }
        scale <600, 200, 200>
    }
}


object {
    plane {<0, 0, 1> 0
        texture {
            White_Marble
            finish {
                ambient 0.3
                //reflection 0.4
            }
            scale <6, 1, 1> rotate <0, 0, 30>
        }
    }
}


#declare TIMES_ROMAN = texture {
    pigment { color Red }
    finish { ambient 0.3 diffuse 0.65 phong 0.5 phong_size 40.0}
}

object {
    union { // a
        #include "tms_pcnt.inc  "
        texture { TIMES_ROMAN }
        rotate <-90, 0, 0> scale <6, 6, 0.25> translate <-0.5, -0.5, 0.25>
        }
    }

object {
    union { // a
        #include "tms_doll.inc  "
        texture { White_Wood scale <.1 .8 .1> rotate < 3 3 3 >}
        rotate <-90, 0, 0> scale <2.5, 2.5, 0.2> rotate <75, -10, -20> translate <0.3, 1.25, 0.2>
        }
    }