#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "tms_rom.mtr"

#declare Plastic = texture {
    pigment {
        colour red 1.0 green 0.0 blue 1.0
    }
    finish {
        ambient 0.3
        diffuse 0.3
        phong 0.6
        phong_size 45.0
        //reflection 0.25
    }
}
/* Camera*/
camera {
   location <0.0, 0.0, 0.0>
   translate <-2, -8, 5>
   direction <0, 1.8, 0>
   up <0, 0, 1>
   sky  <0, 0, 1>
   right <1.5, 0, 0>
   look_at <0, 0, 0>
}

/* Light1 */
/*light_source {
    <-6, -4, 3> color red 0.5 green 0.5 blue 0.5
}
*/
/* Light 2*/
light_source {
    <-2, 4, 4> color red 0.5 green 0.5 blue 0.5
}
/* Light 3*/
light_source {
    <-2, 4, 4> color red 0.5 green 0.5 blue 0.5
    rotate <0, 0, 120>
}
/* Light 4*/
light_source {
    <-2, 4, 4> color red 1.00 green 1.00 blue 1.00
    rotate <0, 0, -120>
}

object {
    plane { <0, 0, -1> 0 translate <0, 0, 0>}
    texture {
    pigment {
        colour red 0.8 green 0.8 blue 0.8
    }
    finish { Shiny reflection 0.3 }
    }
}

#declare LETTER = texture {
    pigment {
        colour red 0 green 0.5 blue 1
    }
    finish {
        ambient 0.3
        diffuse 0.3
        phong 0.6
        phong_size 45.0
        //reflection 0.25
    }

}
union { #include "tms_al.inc  " translate <-TMS_AL_WID/2-TMS_AL_MIN    , 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*0 > texture { LETTER pigment {colour red  0/21 green 0.5 blue 20/21}}}
union { #include "tms_nl.inc  " translate <-TMS_NL_WID/2-TMS_NL_MIN    , 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*1 > texture { LETTER pigment {colour red  1/21 green 0.5 blue 19/21}}}
union { #include "tms_dl.inc  " translate <-TMS_DL_WID/2-TMS_DL_MIN    , 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*2 > texture { LETTER pigment {colour red  2/21 green 0.5 blue 18/21}}}
union { #include "tms_yl.inc  " translate <-TMS_YL_WID/2-TMS_YL_MIN    , 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*3 > texture { LETTER pigment {colour red  3/21 green 0.5 blue 17/21}}}
union { #include "tms_at.inc  " translate <-TMS_AT_WID/2-TMS_AT_MIN    , 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*4 > texture { LETTER pigment {colour red  4/21 green 0.5 blue 16/21}}}
union { #include "tms_ol.inc  " translate <-TMS_OL_WID/2-TMS_OL_MIN    , 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*5 > texture { LETTER pigment {colour red  5/21 green 0.5 blue 15/21}}}
union { #include "tms_sl.inc  " translate <-TMS_SL_WID/2-TMS_SL_MIN    , 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*6 > texture { LETTER pigment {colour red  6/21 green 0.5 blue 14/21}}}
union { #include "tms_el.inc  " translate <-TMS_EL_WID/2-TMS_EL_MIN    , 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*7 > texture { LETTER pigment {colour red  7/21 green 0.5 blue 13/21}}}
union { #include "tms_al.inc  " translate <-TMS_AL_WID/2-TMS_AL_MIN    , 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*8 > texture { LETTER pigment {colour red  8/21 green 0.5 blue 12/21}}}
union { #include "tms_stop.inc" translate <-TMS_STOP_WID/2-TMS_STOP_MIN, 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*9 > texture { LETTER pigment {colour red  9/21 green 0.5 blue 11/21}}}
union { #include "tms_dl.inc  " translate <-TMS_DL_WID/2-TMS_DL_MIN    , 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*10> texture { LETTER pigment {colour red 10/21 green 0.5 blue 10/21}}}
union { #include "tms_el.inc  " translate <-TMS_EL_WID/2-TMS_EL_MIN    , 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*11> texture { LETTER pigment {colour red 11/21 green 0.5 blue  9/21}}}
union { #include "tms_ml.inc  " translate <-TMS_ML_WID/2-TMS_ML_MIN    , 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*12> texture { LETTER pigment {colour red 12/21 green 0.5 blue  8/21}}}
union { #include "tms_ol.inc  " translate <-TMS_OL_WID/2-TMS_OL_MIN    , 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*13> texture { LETTER pigment {colour red 13/21 green 0.5 blue  7/21}}}
union { #include "tms_nl.inc  " translate <-TMS_NL_WID/2-TMS_NL_MIN    , 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*14> texture { LETTER pigment {colour red 14/21 green 0.5 blue  6/21}}}
union { #include "tms_stop.inc" translate <-TMS_STOP_WID/2-TMS_STOP_MIN, 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*15> texture { LETTER pigment {colour red 15/21 green 0.5 blue  5/21}}}
union { #include "tms_cl.inc  " translate <-TMS_CL_WID/2-TMS_CL_MIN    , 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*16> texture { LETTER pigment {colour red 16/21 green 0.5 blue  4/21}}}
union { #include "tms_ol.inc  " translate <-TMS_OL_WID/2-TMS_OL_MIN    , 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*17> texture { LETTER pigment {colour red 17/21 green 0.5 blue  3/21}}}
union { #include "tms_stop.inc" translate <-TMS_STOP_WID/2-TMS_STOP_MIN, 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*18> texture { LETTER pigment {colour red 18/21 green 0.5 blue  2/21}}}
union { #include "tms_ul.inc  " translate <-TMS_UL_WID/2-TMS_UL_MIN    , 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*19> texture { LETTER pigment {colour red 19/21 green 0.5 blue  1/21}}}
union { #include "tms_kl.inc  " translate <-TMS_KL_WID/2-TMS_KL_MIN    , 0, 0> scale <1.2, 0.21, 1.2> translate <0, 2.5, 0.6> rotate <0, 0, -360/21*20> texture { LETTER pigment {colour red 20/21 green 0.5 blue  0/21}}}
