#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

#declare Plastic = texture {
    pigment {
        colour red 1.0 green 0.0 blue 1.0
    }
    finish {
        ambient 0.3
        diffuse 0.3
        phong 0.6
        phong_size 45.0
        //reflection 0.25
    }
}

/* Camera*/
camera {
   location <0.0, 0.0, 0.0>
   translate <0.20000, -4.000000, 0.3>
   direction <0, 1.8, 0>
   up <0, 0, 1>
   sky  <0, 0, 1>
   right <1.33, 0, 0>
   look_at <0.2, 0, 0.5>
}

/* Light1 */
light_source {
    <-4.000, -8.0000, 0.3000> color red 1.00 green 1.00 blue 1.00
}

/* Light 2*/
light_source {
    <2, -4.0000, 2.0000> color red 1.00 green 1.00 blue 1.00
}

/* Light 3*/
/*light_source {
    <3, 24.0000, 10.0000> color red 1.00 green 1.00 blue 1.00
}
*/
/*
object {
    plane { <0, 0, -1> 0 translate <0, 0, 0>}
    texture {
        pigment { colour red 0.8 green 0.8 blue 0.8 }
        finish  { Shiny reflection 0.3 }
    }
}
*/

#declare TEXT = texture {
    pigment { White_Marble }
    finish {
        ambient 0.3
        diffuse 0.3
        phong 0.6
        phong_size 45.0
//        reflection 0.25
    }
    scale <0.3, 0.3, 0.3>
}
#declare FOUR = texture {
    pigment { White_Wood }
    finish {
        ambient 0.3
        diffuse 0.3
        phong 0.6
        phong_size 45.0
//        reflection 0.25
    }
    scale <0.3, 0.3, 0.3>
}

union { #include "tms_tu.inc" scale <1, 10.25, 1> translate <-1, 0, 0.7> texture {TEXT}}
union { #include "tms_el.inc" scale <1, 10.25, 1> translate <-0.4, 0, 0.7> texture {TEXT}}
union { #include "tms_xl.inc" scale <1, 10.25, 1> translate <0.05, 0, 0.7> texture {TEXT}}
union { #include "tms_tl.inc" scale <1, 10.25, 1> translate <0.55, 0, 0.7> texture {TEXT}}
union { #include "tms_4.inc" scale <1, 10.25, 1> translate <0.96, 0, 0.7> texture {FOUR}}

#declare TIMES_ROMAN = texture {
    pigment {
        granite
        turbulence 1
        colour_map { // Nice Rainbow Hues
            [ 0.0000 0.1666 colour red 0.0 green 0.0 blue 1.0 colour red 1.0 green 0.0 blue 1.0]
            [ 0.1666 0.3333 colour red 1.0 green 0.0 blue 1.0 colour red 1.0 green 0.0 blue 0.0]
            [ 0.3333 0.5000 colour red 1.0 green 0.0 blue 0.0 colour red 1.0 green 1.0 blue 0.0]
            [ 0.5000 0.6666 colour red 1.0 green 1.0 blue 0.0 colour red 0.0 green 1.0 blue 0.0]
            [ 0.6666 0.8333 colour red 0.0 green 1.0 blue 0.0 colour red 0.0 green 1.0 blue 1.0]
            [ 0.8333 1.0000 colour red 0.0 green 1.0 blue 1.0 colour red 0.0 green 0.0 blue 1.0]
        }
    }
    finish {
        ambient 0.3
        diffuse 0.3
        phong 0.6
        phong_size 45
    }
    scale <1, 1, 1>
}

union { #include "tms_pu.inc" scale <1.5, 10.25, 1> translate <-1.0, 0, 0>  texture {TIMES_ROMAN}}
union { #include "tms_ol.inc" scale <1.5, 10.25, 1> translate <-0.2, 0, 0>  texture {TIMES_ROMAN}}
union { #include "tms_vu.inc" scale <1.5, 10.25, 1> translate <0.30, 0, 0.0>  texture {TIMES_ROMAN}}

object { // Water
    sphere { <0.0, 0, -6400.0> 6399.99 }
    texture {
        pigment {
            colour SeaGreen
        }
        finish {
            ambient 0.1
            diffuse 0.1
            reflection 0.5
            specular 0.4
            roughness 0.03
        }
        normal {
            ripples 0.35
            frequency 30.0
            turbulence 0.17
            scale <7.0, 7.0, 7.0>
        }
    }
}

object { // Deep Water 
    sphere { <0.0, 0, -6400.0> 6399.0 }
    texture {
        pigment {
            colour SeaGreen
        }
        finish {
            ambient 0.2
            diffuse 0.0
        }
    }
}

object { //Sky
    sphere { <0.0, 0, -1000.0> 9999000 }
    texture {
        pigment {
            gradient <0, 0, 1>
            colour_map {
                [0.0 0.5 colour OrangeRed colour Navy]
                [0.5 1.01 colour Navy colour Navy]
            }
        }
        finish {
            ambient 0.7
            diffuse 0.0
        }
        scale <10, 10, 10000000>
    }
}
