// Persistence of Vision Raytracer
// Them!  They're in your dreams.  They're in your town. They're even in 
// your pumpkins! It's Them!  By Douglas Otwell
// The tentacle was modeled with Robert Flores' Worm v0.4 
//   and Truman Brown's CTDS.
// The small gourd was modeled with Truman Brown's CircleMaster, Hype,
//   and TTG.
// The pumpkin stem was done with my own Swoop.

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "arm1.inc"
#include "arm2.inc"
#include "gourd.inc"
#include "gourd2.inc"

//----------------------------------------------------------------------------
// Lights, camera ....
//----------------------------------------------------------------------------
camera {
   location  <-4.0  9.0  -36.0>
   direction <0.0 0.0  2.0>
   up        <0.0  1.0  0.0>
   right     <1.33333 0.0 0.0>
   look_at   <2.0 1.0 0.0>
}

object {light_source {<0 10 -35> color White}}

object {light_source {<-12 10 2> color White}}
//----------------------------------------------------------------------------
// pumpkinoid (difference)
//
// description: One segment of the pumpkin shell
//----------------------------------------------------------------------------
#declare pumpkinoid = difference {
   quadric {Ellipsoid scale <2 5 4>}
   quadric {Ellipsoid scale <2 4.8 3.8>}
}

//----------------------------------------------------------------------------
// pumpkin_shell (object)
//
// description: Orange wrinkly pumpkin shell of hollowed ellipsoids
//    contains: pumpkinoid
//----------------------------------------------------------------------------
#declare shell_texture = texture {
   color Orange
   phong 0.5
   wrinkles 0.4
   scale <0.4 0.4 0.4>
}

#declare pumpkin_shell = object {
   difference {
      union {
         difference {pumpkinoid translate <0 0 -3> rotate <0 0 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 15 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 30 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 45 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 60 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 75 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 90 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 105 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 120 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 135 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 150 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 165 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 180 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 -15 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 -30 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 -45 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 -60 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 -75 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 -90 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 -105 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 -120 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 -135 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 -150 0>}
         difference {pumpkinoid translate <0 0 -3> rotate <0 -165 0>}
      }
      quadric {Ellipsoid scale <6.5 4.5 6.5>}
      //Eye
      intersection {
         plane {<0 1 0> -1.05 inverse}
         plane {<0 1 0> -1.05 inverse rotate <0 0 120> }
         plane {<0 1 0> -1.05 inverse rotate <0 0 240> }
         plane {<0 0 1> 0}
         rotate <30 20 0>
      }
      // Grin
      union {
         box {<0 0 -20> <1.5 3 0> 
            rotate <0 0 45>
            translate <1.061 0 0>
            rotate <-20 -15 0>
         }
         intersection {
            plane {<0 1 0> 0 inverse}
            plane {<0 1 0> 0 inverse rotate <0 0 90>}
            plane {<0 1 0> 0 rotate <0 0 70> translate <-1.5 0 0>}
            plane {<0 0 1> 0}
            rotate <0 0 -45>
            translate <1.061 0 0>
            rotate <-20 -15 0>
         }
         box {<-1.5 0 -20> <0 3 0> 
            rotate <0 0 -45>
            translate <-1.061 0 0>
            rotate <-20 -15 0>
         }
         intersection {
            plane {<0 1 0> 0 inverse}
            plane {<0 1 0> 0 rotate <0 0 90>}
            plane {<0 1 0> 0 rotate <0 0 -70> translate <1.5 0 0>}
            plane {<0 0 1> 0}
            rotate <0 0 45>
            translate <-1.061 0 0>
            rotate <-20 -15 0>
         }
         translate <0 -2.061 0>
         scale <1.04 1.04 1.04>
         translate <0 2.061 0>
      }
   }
   texture {shell_texture}
   bounded_by {sphere {<0 0 0> 7}}
}

//----------------------------------------------------------------------------
// pumpkin_inside (object)
//
// description: Yellow meaty inside
//----------------------------------------------------------------------------
#declare pumpkin_inside = object {
   difference {
      union {
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 0 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 15 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 30 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 45 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 60 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 75 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 90 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 105 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 120 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 135 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 150 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 165 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 180 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 -15 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 -30 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 -45 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 -60 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 -75 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 -90 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 -105 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 -120 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 -135 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 -150 0>}
         quadric {Ellipsoid scale <1.9 4.9 3.9> translate <0 0 -3> rotate <0 -165 0>}
      }
      quadric {Ellipsoid scale <6.25 4.25 6.25>}
      //Eye
      intersection {
         plane {<0 1 0> -1 inverse}
         plane {<0 1 0> -1 inverse rotate <0 0 120> }
         plane {<0 1 0> -1 inverse rotate <0 0 240> }
         plane {<0 0 1> 0}
         rotate <30 20 0>
      }
      // Grin
      box {<0 0 -20> <1.5 3 0> 
         rotate <0 0 45>
         translate <1.061 0 0>
         rotate <-20 -15 0>
      }
      intersection {
         plane {<0 1 0> 0 inverse}
         plane {<0 1 0> 0 inverse rotate <0 0 90>}
         plane {<0 1 0> 0 rotate <0 0 70> translate <-1.5 0 0>}
         plane {<0 0 1> 0}
         rotate <0 0 -45>
         translate <1.061 0 0>
         rotate <-20 -15 0>
      }
      box {<-1.5 0 -20> <0 3 0> 
         rotate <0 0 -45>
         translate <-1.061 0 0>
         rotate <-20 -15 0>
      }
      intersection {
         plane {<0 1 0> 0 inverse}
         plane {<0 1 0> 0 rotate <0 0 90>}
         plane {<0 1 0> 0 rotate <0 0 -70> translate <1.5 0 0>}
         plane {<0 0 1> 0}
         rotate <0 0 45>
         translate <-1.061 0 0>
         rotate <-20 -15 0>
      }
   }
   texture {
      color red 1.0 green 0.85 blue 0.5
      phong 1
      wrinkles 0.5
      scale <1 1 1>
   }
   bounded_by {sphere {<0 0 0> 7}}
}
   
   
//----------------------------------------------------------------------------
// stem (composite)
//
// description: pumpkin stem created with Swoop
//----------------------------------------------------------------------------
#declare stem_texture = texture { 0.2
   color Tan 
}

#declare stem_side1_C1 =  texture {stem_texture}
#declare stem_side3_C1 =  texture {stem_texture}
#declare stem_side5_C1 =  texture {stem_texture}
#declare stem_side7_C1 =  texture {stem_texture}
#declare stem_side9_C1 =  texture {stem_texture}
#declare stem_side11_C1 = texture {stem_texture}
#declare stem_side13_C1 = texture {stem_texture}
#declare stem_side15_C1 = texture {stem_texture}

#declare stem = composite {  /* All Objects */
   #include "stem.inc"
   bounded_by {
      box { <-0.5730 0.0000 -1.2000> <4.2000 3.4271 1.2000> }
   }
   translate <-3 0 0>
}

//----------------------------------------------------------------------------
// pumpkin (object)
//
// description: A grinning pumpkin in the process of being carved
//    contains: pumpkin_shell, pumpkin_inside, stem
//----------------------------------------------------------------------------
#declare pumpkin = composite {
   object {pumpkin_shell}
   object {pumpkin_inside}
   composite {stem translate <0 4 0> rotate <0 150 0>} 
}

//----------------------------------------------------------------------------
// handle (object)
//
// description: Black bakelite knife handle
//----------------------------------------------------------------------------
#declare handle = object {
   union {
      intersection {
         box {<0 -0.7 -0.45> <5 0.7 -0.05>}
         plane {<0 1 0> 0 rotate <-30 0 0> translate <0 0.7 0>}
         plane {<0 1 0> 0 inverse rotate <30 0 0> translate <0 -0.7 0>}
         plane {<0 0 1> 0 inverse rotate <0 30 0>}
      }
      intersection {
         intersection {Cone_Y translate <0 1 0> scale <0.7 0.7 0.7>}
         plane {<0 1 0> 0.4 }
         rotate <-90 0 0>
         translate <5 0 -0.05>
      }
   }
   texture {color Gray20 phong 0.5 phong_size 8}
   translate <0 0 0>
}

//----------------------------------------------------------------------------
// blade (object)
//
// description: Stainless steel blade, tang and rivets   
//----------------------------------------------------------------------------
#declare blade = object {
   union {
      // blade
      intersection {
         intersection {Disk_Z scale <20 20 0.05> translate <0 18.5 0>}
         quadric {
            QCone_Z 
            translate <0 0 -1>
            scale <20 20 1.5>
            translate <0 18.5 0>
         }
         quadric {
            QCone_Z 
            translate <0 0 1>
            scale <20 20 1.5>
            translate <0 18.5 0>
         }
         plane {<0 1 0> 0.7}
         plane {<1 0 0> 0.5}
         
      }
      // tang
      box {<0 -0.7 -0.05> <5 0.7 0.05>}
      intersection {Disk_Z scale <0.7 0.7 0.05> translate <5 0 0>}
      // rivets
      intersection {Disk_Z scale <0.3 0.3 0.451> translate <2 0 0>}
      intersection {Disk_Z scale <0.3 0.3 0.451> translate <4 0 0>}
   }
   texture {Chrome_Texture}
}

//----------------------------------------------------------------------------
// knife (composite)
//
// description: Chef's knife, perfect for carving pumpkins and other things...
//    contains: handle, blade
//----------------------------------------------------------------------------
#declare knife = composite {
   object {handle}
   object {handle rotate <180 0 0>} 
   object {blade}
   bounded_by {box {<-12 -1.5 -0.5> <7 1.5 0.5>}}
}
 
//----------------------------------------------------------------------------
// gourd (composite)
//
// description: Gourd modeled with Truman Brown's suite of utilities
//----------------------------------------------------------------------------
#declare gourd_texture = texture {
   leopard
   turbulence 0.9
   color_map {
      [0.0  0.01  color HuntersGreen color HuntersGreen]
      [0.01 0.4   color HuntersGreen color White]
      [0.4  1.001 color White color White]
   }
   scale <0.2 0.8 0.2>
}
texture {
   gradient <0 1 0>
   color_map {
      [0.0 0.5 color Clear color Clear]
      [0.50 0.65 color Orange alpha 0.6 color Orange]
      [0.55 1.001 color Orange color Orange]
   }
   phong 0.5
   phong_size 10
   scale <24 24 24>
   translate <0 -12 0>
}

#declare gourd = composite {
   object {
      gourd
      translate <0 2.8284 0>
      texture {gourd_texture}
   }
   object {
      gourd2
      texture {gourd_texture}
   }
   object {
      union {
         intersection {
            quartic {
            <    1.000000 0.000000 0.000000 0.000000 2.000000
                 0.000000 0.000000 2.000000 0.000000 -32.500000
                 0.000000 0.000000 0.000000 0.000000 0.000000
                 0.000000 0.000000 0.000000 0.000000 0.000000
                 1.000000 0.000000 0.000000 2.000000 0.000000
                 31.500000 0.000000 0.000000 0.000000 0.000000
                 1.000000 0.000000 -32.500000 0.000000 248.062500 >
                 rotate <90 0 0>
            }
            plane {<0 1 0> 0 inverse}
            plane {<0 1 0> 0 inverse rotate <0 0 60>}
         }
         sphere {<0 0 0> 0.5 translate <4 0 0> rotate <0 0 60>}
      }

      translate <0 4.2436 0>
      texture {gourd_texture}
      translate <4 0 0>
   }
   
}

//----------------------------------------------------------------------------
// The Scene
//
// description: A Jack'o'Lantern being carved by ... Them!  Velvet curtains 
//    and table covering, and a small gourd complete the scene.
//----------------------------------------------------------------------------


// Wall
object {
   quadric {Cylinder_Y scale <72 72 72>}
   texture {
      bozo
      turbulence 0.0
      color_map {
         [0.0 0.5  color Black color MidnightBlue ]
         [0.5 0.8  color MidnightBlue color Black]
         [0.8 1.01 color Black color Black]
      }
      ambient 0.5 diffuse 0.0
      scale <6 100 6>
   }
}
// Table
object {
   box {<-24 -1 -24> <12 0 12>}
   texture {
      bozo
      turbulence 0.5
      color_map {
         [0.0 0.3  color Black color Scarlet]
         [0.3 0.8  color Scarlet color Black]
         [0.8 1.01 color Black color Black]
      }
      ambient 0.5 diffuse 0.0
      scale <5 5 100>
      rotate <0 45 0>
   }
   translate <0 -5 0>
}

composite {pumpkin}

composite {
   gourd 
   scale <0.5 0.5 0.5>
   rotate <90 -75 0>
   translate <-5 -3.75 -7>
}


composite {
   object {arm1}

   composite {
      object {
         arm2 
         rotate <-90 0 0> 
      }
      composite {
         knife
         rotate <90 0 90>
         translate <0 -2 0.9>
      }
      
      rotate <0 0 -30>
      translate <9 4.75 0>
   }

   rotate <-90 0 0>
   translate <0 0 -5>
   rotate <30 20 0>
}


