//---- Slug Like Creature


//--- Slug Textures

#declare Cream = color red .9  green .85 blue .8
#declare BruisedFlesh = color red .69  green .33 blue .33


//---- Main Body Texture
#declare BodyTexture =
texture {
  wood 
  turbulence .01
    color_map {
     [0 .1 color Red color Red]
     [.1 .14 color Black color Black]
     [.14 .4 color Cream color Cream]
     [.4 1 color Cream color Gold]
    }
   ambient .1
   diffuse .5
   scale <8 8 8>
   translate <0 1.5 0>
}  
texture {
  gradient <0 1 0>
    color_map {
     [0 .15 color DarkGreen color BruisedFlesh]
     [.15 .24 color BruisedFlesh color Gold]
     [.24 1 color Gold color Clear]
    }
   ambient .1
   diffuse .5
   scale <9 10 9>
   translate <0 -3.5 0>
}  
texture {
   color Clear
   bumps 1
   frequency .010
   scale <.1 .1 .1>
   ambient .1
   diffuse .5
   phong .7
   phong_size 80
}  


//--- Leg Texture
#declare LegTexture =
texture {
  gradient <0 1 0>
  turbulence 0
    color_map {
     [0 .2 color Black color Red]
     [.2 .5 color Red color Gold]
     [.5 1 color Gold color Gold]
    }
   ambient .1
   diffuse .5
   phong 1
   phong_size 70
   scale <1 7 1>
}  

//---- Horn Texture
#declare YourTexture =
    texture {
	gradient <0 0 1>
	color_map {
	[0 .4 color Cream color Gold]
	[.4 .7 color Gold color Scarlet]
   	[.7 1 color Scarlet color Black]
	}
	ambient .1
	diffuse .5
	phong 1
	scale <1 1 11.5>
    }

//---- Head Texture
#declare HeadCheese =
texture {
  wood
  color_map {
   [0 .3 color Black color Violet]
   [.3 .6 color Violet color Scarlet]
   [.6 .8 color Scarlet color Gold]
   [.8 1 color Gold color Cream]
  }
  ambient .2
  phong 1
  scale <8 8 1>
}
texture {
   color Clear
   bumps 1
   frequency .010
   scale <.1 .1 .1>
   ambient .1
   diffuse .5
   phong .7
   phong_size 80
}  

//---- Alternative Head Pulpt
#declare HeadTexture =
texture {
   gradient <0 0 1>
   color_map {
	[0 .5 color Cream color Clear]
        [.5 1 color Clear color Clear]
       }
  ambient .1
  diffuse .4
  phong 1
  scale <1 1 2>
  translate <0 0 -2>
}
texture {
  color Clear
  bumps 1
  frequency .010
  scale <.1 .1 .1>
}




//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//--- Slug Leg

#declare Dot =
    quadric {
       < 1.0  1.0  1.0>
       < 0.0  0.0  0.0>
       < 0.0  0.0  0.0>
        -1.0
scale <.98 .98 .98>
    }

#declare Connector_1 = 
   object {
      quadric {
         < 0.0  1.0  1.0>
         < 0.0  0.0  0.0>
         < 0.0  0.0  0.0>
          -1.0
      }
      clipped_by {
         plane { < 1.0  0.0  0.0> 1.0 }
         plane { <-1.0  0.0  0.0> 0.0 }
      }
   }

#declare Connector_2 =
   quadric {
      < 1.0 -1.0  1.0>
      < 0.0  0.0  0.0>
      < 0.0  0.0  0.0>
        0.0
      rotate < 0.0  0.0  90.0>
   }


//---- Make one Slug Leg
#declare Leg =
   composite {
      object {
         quadric {
            Dot
            scale     < 0.100000  0.100000  0.100000>
            translate <-6.500000  0.100000  0.000000>
         }
         texture {
            LegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.297156 }
            plane {     < 1.000000  0.000000  0.000000>  0.099052 inverse }
         }
         translate <-0.099052  0.000000  0.000000>
         scale     < 7.211103  1.000000  1.000000>
         translate < 0.013736  0.000000  0.000000>
         rotate    < 0.000000  0.000000  74.054604>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-6.500000  0.100000  0.000000>
         texture {
            LegTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.300000  0.300000  0.300000>
            translate <-6.900000  1.500000  0.000000>
         }
         texture {
            LegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.397553 }
            plane {     < 1.000000  0.000000  0.000000>  0.298165 inverse }
         }
         translate <-0.298165  0.000000  0.000000>
         scale     < 9.000000  1.000000  1.000000>
         translate < 0.033129  0.000000  0.000000>
         rotate    < 0.000000  0.000000  83.659808>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-6.900000  1.500000  0.000000>
         texture {
            LegTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.400000  0.400000  0.400000>
            translate <-7.000000  2.400000  0.000000>
         }
         texture {
            LegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.497947 }
            plane {     < 1.000000  0.000000  0.000000>  0.398357 inverse }
         }
         translate <-0.398357  0.000000  0.000000>
         scale     < 11.000000  1.000000  1.000000>
         translate < 0.036214  0.000000  0.000000>
         rotate    < 0.000000  0.000000  84.805571>
         translate <-7.000000  2.400000  0.000000>
         texture {
            LegTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.500000  0.500000  0.500000>
            translate <-6.900000  3.500000  0.000000>
         }
         texture {
            LegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.596460 }
            plane {     < 1.000000  0.000000  0.000000>  0.497050 inverse }
         }
         translate <-0.497050  0.000000  0.000000>
         scale     < 9.165151  1.000000  1.000000>
         translate < 0.054233  0.000000  0.000000>
         rotate    < 0.000000  0.000000  77.471192>
         translate <-6.900000  3.500000  0.000000>
         texture {
            LegTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.600000  0.600000  0.600000>
            translate <-6.700000  4.400000  0.000000>
         }
         texture {
            LegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.692179 }
            plane {     < 1.000000  0.000000  0.000000>  0.593296 inverse }
         }
         translate <-0.593296  0.000000  0.000000>
         scale     < 6.633250  1.000000  1.000000>
         translate < 0.089443  0.000000  0.000000>
         rotate    < 0.000000  0.000000  63.434949>
         translate <-6.700000  4.400000  0.000000>
         texture {
            LegTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.700000  0.700000  0.700000>
            translate <-6.400000  5.000000  0.000000>
         }
         texture {
            LegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.834176 }
            plane {     < 1.000000  0.000000  0.000000>  0.686969 inverse }
         }
         translate <-0.686969  0.000000  0.000000>
         scale     < 5.109903  1.000000  1.000000>
         translate < 0.134439  0.000000  0.000000>
         rotate    < 0.000000  0.000000  39.805571>
         translate <-6.400000  5.000000  0.000000>
         texture {
            LegTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.850000  0.850000  0.850000>
            translate <-5.800000  5.500000  0.000000>
         }
         texture {
            LegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.982540 }
            plane {     < 1.000000  0.000000  0.000000>  0.835159 inverse }
         }
         translate <-0.835159  0.000000  0.000000>
         scale     < 5.280993  1.000000  1.000000>
         translate < 0.158144  0.000000  0.000000>
         rotate    < 0.000000  0.000000  29.744881>
         translate <-5.800000  5.500000  0.000000>
         texture {
            LegTexture
         }
      }
      object {
         quadric {
            Dot
            translate <-5.100000  5.900000  0.000000>
         }
         texture {
            LegTexture
         }
      }

      bounded_by {
	box { UnitBox scale <2 4 1.2> translate <-5.8 3.9 0> }
      }
   }


//--- Slug's Body & Head

//--- Main Body Section
#declare B1 =
object {
 union {
  union {
   intersection {
    quadric {
            <0.073046018991965 -0.034925127830533 0.073046018991965>
            <0.000000000000000  0.000000000000000 0.000000000000000>
            <0.000000000000000  0.000000000000000 0.000000000000000>
            -1.0
     }
    plane { <0.0 1.0 0.0> 2.3 }
    plane { <0.0 1.0 0.0> -2.3 inverse }
    rotate <90 0 0>
   }
    quadric { Sphere scale <4.05 4.05 2.6> translate <0 0 -2.6> }
    quadric { Sphere scale <4.05 4.05 2.6> translate <0 0 2.6> }
    scale <1 .8 1> 
  }
    quadric { Sphere scale <1.9 1.9 1> rotate <-20 0 0> translate <0 -.8 -4.8> }
    quadric { Sphere scale <1.9 1.9 1> rotate <20 0 0> translate <0 -.8 4.8> }
 } 
    texture { BodyTexture } 
	bounded_by {
	box { UnitBox scale <4.2 3.4 6.2> }
        }
}



//--- Complete Body Section
#declare BS =
composite {
  object { B1 translate <0 7 0> }
  composite { Leg rotate <0 -90 0>}
  composite { Leg rotate <0 90 0> }
	bounded_by {
	box { UnitBox scale <4.2 5.3 7.8> translate <0 5.1 0> }
        }
}


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//---- Head Horns
#declare Horn =
   composite {
      object {
         quadric {
            Dot
            scale     < 0.970000  0.970000  0.970000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.967528 }
            plane {     < 1.000000  0.000000  0.000000>  0.937605 inverse }
         }
         translate <-0.967528  0.000000  0.000000>
         scale     < 13.981666  1.000000  1.000000>
         translate <-0.069200  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  134.452764  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.940000  0.940000  0.940000>
            translate <-0.294500  0.000000 -0.300180>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.937605 }
            plane {     < 1.000000  0.000000  0.000000>  0.907681 inverse }
         }
         translate <-0.937605  0.000000  0.000000>
         scale     < 13.981696  1.000000  1.000000>
         translate <-0.067059  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  131.112482  0.000000>
         translate <-0.294500  0.000000 -0.300180>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.910000  0.910000  0.910000>
            translate <-0.571010  0.000000 -0.617010>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.907681 }
            plane {     < 1.000000  0.000000  0.000000>  0.877758 inverse }
         }
         translate <-0.907681  0.000000  0.000000>
         scale     < 13.981624  1.000000  1.000000>
         translate <-0.064920  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  127.772453  0.000000>
         translate <-0.571010  0.000000 -0.617010>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.880000  0.880000  0.880000>
            translate <-0.828590  0.000000 -0.949410>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.877758 }
            plane {     < 1.000000  0.000000  0.000000>  0.847834 inverse }
         }
         translate <-0.877758  0.000000  0.000000>
         scale     < 13.981903  1.000000  1.000000>
         translate <-0.062778  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  124.432247  0.000000>
         translate <-0.828590  0.000000 -0.949410>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.850000  0.850000  0.850000>
            translate <-1.066370  0.000000 -1.296260>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.847834 }
            plane {     < 1.000000  0.000000  0.000000>  0.817911 inverse }
         }
         translate <-0.847834  0.000000  0.000000>
         scale     < 13.981642  1.000000  1.000000>
         translate <-0.060639  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  121.091572  0.000000>
         translate <-1.066370  0.000000 -1.296260>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.820000  0.820000  0.820000>
            translate <-1.283530  0.000000 -1.656370>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.817911 }
            plane {     < 1.000000  0.000000  0.000000>  0.787987 inverse }
         }
         translate <-0.817911  0.000000  0.000000>
         scale     < 13.981762  1.000000  1.000000>
         translate <-0.058498  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  117.749657  0.000000>
         translate <-1.283530  0.000000 -1.656370>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.790000  0.790000  0.790000>
            translate <-1.479330  0.000000 -2.028530>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.787987 }
            plane {     < 1.000000  0.000000  0.000000>  0.758064 inverse }
         }
         translate <-0.787987  0.000000  0.000000>
         scale     < 13.981669  1.000000  1.000000>
         translate <-0.056359  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  114.410578  0.000000>
         translate <-1.479330  0.000000 -2.028530>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.760000  0.760000  0.760000>
            translate <-1.653120  0.000000 -2.411460>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.758064 }
            plane {     < 1.000000  0.000000  0.000000>  0.728140 inverse }
         }
         translate <-0.758064  0.000000  0.000000>
         scale     < 13.981774  1.000000  1.000000>
         translate <-0.054218  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  111.069694  0.000000>
         translate <-1.653120  0.000000 -2.411460>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.730000  0.730000  0.730000>
            translate <-1.804300  0.000000 -2.803870>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.728140 }
            plane {     < 1.000000  0.000000  0.000000>  0.698216 inverse }
         }
         translate <-0.728140  0.000000  0.000000>
         scale     < 13.981721  1.000000  1.000000>
         translate <-0.052078  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  107.729619  0.000000>
         translate <-1.804300  0.000000 -2.803870>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.700000  0.700000  0.700000>
            translate <-1.932360  0.000000 -3.204420>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.698216 }
            plane {     < 1.000000  0.000000  0.000000>  0.668293 inverse }
         }
         translate <-0.698216  0.000000  0.000000>
         scale     < 13.981654  1.000000  1.000000>
         translate <-0.049938  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  104.388840  0.000000>
         translate <-1.932360  0.000000 -3.204420>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.670000  0.670000  0.670000>
            translate <-2.036860  0.000000 -3.611750>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.668293 }
            plane {     < 1.000000  0.000000  0.000000>  0.638369 inverse }
         }
         translate <-0.668293  0.000000  0.000000>
         scale     < 13.981766  1.000000  1.000000>
         translate <-0.047797  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  101.048605  0.000000>
         translate <-2.036860  0.000000 -3.611750>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.640000  0.640000  0.640000>
            translate <-2.117450  0.000000 -4.024480>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.638369 }
            plane {     < 1.000000  0.000000  0.000000>  0.608446 inverse }
         }
         translate <-0.638369  0.000000  0.000000>
         scale     < 13.981641  1.000000  1.000000>
         translate <-0.045658  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  97.709080  0.000000>
         translate <-2.117450  0.000000 -4.024480>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.610000  0.610000  0.610000>
            translate <-2.173860  0.000000 -4.441200>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.608446 }
            plane {     < 1.000000  0.000000  0.000000>  0.578522 inverse }
         }
         translate <-0.608446  0.000000  0.000000>
         scale     < 13.981646  1.000000  1.000000>
         translate <-0.043517  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  94.366938  0.000000>
         translate <-2.173860  0.000000 -4.441200>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.580000  0.580000  0.580000>
            translate <-2.205880  0.000000 -4.860500>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.578522 }
            plane {     < 1.000000  0.000000  0.000000>  0.548599 inverse }
         }
         translate <-0.578522  0.000000  0.000000>
         scale     < 13.981872  1.000000  1.000000>
         translate <-0.041377  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  91.027360  0.000000>
         translate <-2.205880  0.000000 -4.860500>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.550000  0.550000  0.550000>
            translate <-2.213420  0.000000 -5.280960>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.548599 }
            plane {     < 1.000000  0.000000  0.000000>  0.518675 inverse }
         }
         translate <-0.548599  0.000000  0.000000>
         scale     < 13.981703  1.000000  1.000000>
         translate <-0.039237  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  87.687226  0.000000>
         translate <-2.213420  0.000000 -5.280960>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.520000  0.520000  0.520000>
            translate <-2.196450  0.000000 -5.701140>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.518675 }
            plane {     < 1.000000  0.000000  0.000000>  0.488752 inverse }
         }
         translate <-0.518675  0.000000  0.000000>
         scale     < 13.981812  1.000000  1.000000>
         translate <-0.037096  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  84.346076  0.000000>
         translate <-2.196450  0.000000 -5.701140>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.490000  0.490000  0.490000>
            translate <-2.155020  0.000000 -6.119620>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.488752 }
            plane {     < 1.000000  0.000000  0.000000>  0.458828 inverse }
         }
         translate <-0.488752  0.000000  0.000000>
         scale     < 13.981630  1.000000  1.000000>
         translate <-0.034957  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  81.006053  0.000000>
         translate <-2.155020  0.000000 -6.119620>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.460000  0.460000  0.460000>
            translate <-2.089280  0.000000 -6.534970>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.458828 }
            plane {     < 1.000000  0.000000  0.000000>  0.428904 inverse }
         }
         translate <-0.458828  0.000000  0.000000>
         scale     < 13.981834  1.000000  1.000000>
         translate <-0.032816  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  77.665821  0.000000>
         translate <-2.089280  0.000000 -6.534970>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.430000  0.430000  0.430000>
            translate <-1.999450  0.000000 -6.945790>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.428904 }
            plane {     < 1.000000  0.000000  0.000000>  0.398981 inverse }
         }
         translate <-0.428904  0.000000  0.000000>
         scale     < 13.981628  1.000000  1.000000>
         translate <-0.030676  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  74.324480  0.000000>
         translate <-1.999450  0.000000 -6.945790>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.400000  0.400000  0.400000>
            translate <-1.885830  0.000000 -7.350670>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.398981 }
            plane {     < 1.000000  0.000000  0.000000>  0.369057 inverse }
         }
         translate <-0.398981  0.000000  0.000000>
         scale     < 13.981906  1.000000  1.000000>
         translate <-0.028536  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  70.984254  0.000000>
         translate <-1.885830  0.000000 -7.350670>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.370000  0.370000  0.370000>
            translate <-1.748810  0.000000 -7.748250>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.369057 }
            plane {     < 1.000000  0.000000  0.000000>  0.339134 inverse }
         }
         translate <-0.369057  0.000000  0.000000>
         scale     < 13.981535  1.000000  1.000000>
         translate <-0.026396  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  67.643729  0.000000>
         translate <-1.748810  0.000000 -7.748250>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.340000  0.340000  0.340000>
            translate <-1.588860  0.000000 -8.137160>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.339134 }
            plane {     < 1.000000  0.000000  0.000000>  0.309210 inverse }
         }
         translate <-0.339134  0.000000  0.000000>
         scale     < 13.981869  1.000000  1.000000>
         translate <-0.024255  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  64.303868  0.000000>
         translate <-1.588860  0.000000 -8.137160>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.310000  0.310000  0.310000>
            translate <-1.406520  0.000000 -8.516100>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.309210 }
            plane {     < 1.000000  0.000000  0.000000>  0.279287 inverse }
         }
         translate <-0.309210  0.000000  0.000000>
         scale     < 13.981526  1.000000  1.000000>
         translate <-0.022116  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  60.962732  0.000000>
         translate <-1.406520  0.000000 -8.516100>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.280000  0.280000  0.280000>
            translate <-1.202410  0.000000 -8.883760>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.279287 }
            plane {     < 1.000000  0.000000  0.000000>  0.249363 inverse }
         }
         translate <-0.279287  0.000000  0.000000>
         scale     < 13.981816  1.000000  1.000000>
         translate <-0.019975  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  57.622437  0.000000>
         translate <-1.202410  0.000000 -8.883760>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.250000  0.250000  0.250000>
            translate <-0.977220  0.000000 -9.238910>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.249363 }
            plane {     < 1.000000  0.000000  0.000000>  0.219439 inverse }
         }
         translate <-0.249363  0.000000  0.000000>
         scale     < 13.981649  1.000000  1.000000>
         translate <-0.017835  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  54.281761  0.000000>
         translate <-0.977220  0.000000 -9.238910>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.220000  0.220000  0.220000>
            translate <-0.731720  0.000000 -9.580330>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.219439 }
            plane {     < 1.000000  0.000000  0.000000>  0.189516 inverse }
         }
         translate <-0.219439  0.000000  0.000000>
         scale     < 13.981634  1.000000  1.000000>
         translate <-0.015695  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  50.942491  0.000000>
         translate <-0.731720  0.000000 -9.580330>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.190000  0.190000  0.190000>
            translate <-0.466750  0.000000 -9.906870>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.189516 }
            plane {     < 1.000000  0.000000  0.000000>  0.159592 inverse }
         }
         translate <-0.189516  0.000000  0.000000>
         scale     < 13.981810  1.000000  1.000000>
         translate <-0.013554  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  47.602125  0.000000>
         translate <-0.466750  0.000000 -9.906870>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.160000  0.160000  0.160000>
            translate <-0.183200  0.000000 -10.217420>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.159592 }
            plane {     < 1.000000  0.000000  0.000000>  0.129669 inverse }
         }
         translate <-0.159592  0.000000  0.000000>
         scale     < 13.981724  1.000000  1.000000>
         translate <-0.011414  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  44.260069  0.000000>
         translate <-0.183200  0.000000 -10.217420>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.130000  0.130000  0.130000>
            translate < 0.117970  0.000000 -10.510910>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.129669 }
            plane {     < 1.000000  0.000000  0.000000>  0.099745 inverse }
         }
         translate <-0.129669  0.000000  0.000000>
         scale     < 13.981898  1.000000  1.000000>
         translate <-0.009274  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  40.920355  0.000000>
         translate < 0.117970  0.000000 -10.510910>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.100000  0.100000  0.100000>
            translate < 0.435730  0.000000 -10.786360>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.099745 }
            plane {     < 1.000000  0.000000  0.000000>  0.069822 inverse }
         }
         translate <-0.099745  0.000000  0.000000>
         scale     < 13.981494  1.000000  1.000000>
         translate <-0.007134  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  37.580056  0.000000>
         translate < 0.435730  0.000000 -10.786360>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.070000  0.070000  0.070000>
            translate < 0.768990  0.000000 -11.042820>
         }
         texture {
            YourTexture
         }
      }
      bounded_by {
         quadric {
            Dot
            scale < 7.040532  7.040532  7.040532>
            translate <-0.907940  0.000000 -5.071410>
         }
      }
   }




//---- Torus's for Head

#declare MT1 = 
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -32.040000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        28.800000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -32.040000 0.000000 207.360000 >
   }

#declare MT2 = 
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -20.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        16.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -20.000000 0.000000 64.000000 >
   }

#declare MT3 = 
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -6.800000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        6.160000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -6.800000 0.000000 9.486400 >
   }


//---- Small Curved Fang
#declare Fang =
object {
  difference {
   quadric { Cylinder_Y scale <1.1 1 1> translate <.9 0 -.2> }
   quadric { Cylinder_Y scale <1 1 1> translate <1.2 0 .15> }
   plane { <0 1 0> 0 rotate < 0 0 -7> translate <2 0 0> inverse}
   plane { <0 1 0> 0 rotate < 0 0 7> translate <2 0 0> }
  }
    texture {
       gradient <0 0 1>
       color_map {
	[0 .1 color White color Wheat]
        [.1 .3 color Wheat color Gold]
	[.3 1 color Gold color Red]
       }
	ambient .3
	diffuse .4
	phong 1
	scale <1 1 1>
	translate <0 0 -1.2>
    }
       bounded_by {
       box { UnitBox scale <4 2 4> translate <.9 0 -.3> }           
       }
scale <1 .8 1>
translate <-2.6 0 -3.4>
}


//---- Head Section
//---- Complete Head

#declare Head =
composite {
 composite {
 object {
  union {
   difference {
    quadric { Sphere scale <4.25 4.25 4> translate <0 0 -2.8> }
    quadric { Sphere scale <4.8 4.8 4.4> translate <0 0 -4.8> }
   }
    quartic { MT1 rotate <90 0 0> scale <1 1 1.1> translate <0 0 -2.8> }
    quartic { MT2 rotate <90 0 0> scale <1.1 1.1 1.7> translate <0 0 -1.3> }
  }
     texture { BodyTexture }
       bounded_by {
       box { UnitBox scale <6 6 6> translate <0 0 -1.5> }           
       }
 }
 //--- Mouth
 object {
  union {
    quartic { MT2 rotate <90 0 0> scale <1.1 1.1 1> translate <0 0 -2.8> }
    quartic { MT3 rotate <90 0 0> translate <0 0 -2.4> }
    intersection { Disk_Z scale <2 2 .01> translate <0 0 -2.4> }
  }
     texture { HeadCheese }
       bounded_by {
       box { UnitBox scale <6 6 6> translate <0 0 -1.5> }           
       }
 }
 object { Fang rotate <0 0 0> }
 object { Fang rotate <0 0 30> }
 object { Fang rotate <0 0 60> }
 object { Fang rotate <0 0 90> }
 object { Fang rotate <0 0 120> }
 object { Fang rotate <0 0 150> }
 object { Fang rotate <0 0 180> }
 object { Fang rotate <0 0 210> }
 object { Fang rotate <0 0 240> }
 object { Fang rotate <0 0 270> }
 object { Fang rotate <0 0 300> }
 object { Fang rotate <0 0 330> }
 composite {
 composite { Horn translate <-4 0 -2> rotate <0 0 -45> }
 composite { Horn translate <-4 0 -2> rotate <0 0 45> }
 composite { Horn translate <-4 0 -2> rotate <0 0 135> }
 composite { Horn translate <-4 0 -2> rotate <0 0 225> }
 scale <1 1 1>
 }
 scale <1.1 1 1.1>
 rotate <0 -90 0>
 translate <1.5 7 0> 
 }
 composite { BS }
}




//----- Body Translated in +Z direction for ground sweep
#declare BS1 = composite { BS translate <0 0 15>  }



//---- Complete Slug in a Left Twist
composite {
  //--- Tail
  composite { BS  rotate <0 90 0> translate <0 10 0> rotate <-15 0 0> translate <15 -10 0> } 
  composite { BS  rotate <0 90 0> translate <0 10 0> rotate <-30 0 0> translate <15 -10 0> } 
  composite { BS  rotate <0 90 0> translate <0 10 0> rotate <-45 0 0> translate <15 -10 0> } 
  composite { BS  rotate <0 90 0> translate <0 10 0> rotate <-60 0 0> translate <15 -10 0> } 
  composite { BS  rotate <0 90 0> translate <0 10 0> rotate <-75 0 0> translate <15 -10 0> } 
  composite { BS  rotate <0 90 0> translate <0 10 0> rotate <-90 0 0> translate <15 -10 0> } 
  composite { BS  rotate <0 90 0> translate <0 10 0> rotate <-105 0 0> translate <15 -10 0> } 
  composite { BS1 rotate <0 0 0> }
  composite { BS1 rotate <0 22.5 0> }
  composite { BS1 rotate <0 45 0> }
  composite { BS1 rotate <0 67.5 0> }
  composite { BS1 rotate <0 90 0> }
  composite { BS translate <0 -15 0> rotate <0 0 -18> translate <0 15 15> }
  composite { BS translate <0 -15 0> rotate <0 0 -36> translate <0 15 15> }
  composite { BS rotate <9 0 0> translate <0 -15 0> rotate <0 0 -54> translate <0 15 15> }
  composite { BS rotate <18 0 0> translate <0 -15 0> rotate <0 0 -72> translate <0 15 15> }
  composite { BS rotate <27 0 0> translate <0 -15 0> rotate <0 0 -90> translate <0 15 15> }
  composite { BS  rotate <0 0 -90> rotate <0 -36 0> translate <0 0 15> rotate <-15 0 0> translate <-15 15 0> } 
  composite { BS  rotate <0 0 -90> rotate <0 -45 0> translate <0 0 15> rotate <-30 0 0> translate <-15 15 0> } 
  composite { BS  rotate <0 0 -90> rotate <0 -54 0> translate <0 0 15> rotate <-45 0 0> translate <-15 15 0> } 
  composite { BS  rotate <0 0 -90> rotate <0 -63 0> translate <0 0 15> rotate <-60 0 0> translate <-15 15 0> } 
  composite { BS  rotate <0 0 -90> rotate <0 -72 0> translate <0 0 15> rotate <-75 0 0> translate <-15 15 0> } 
  composite { BS  rotate <0 0 -90> rotate <0 -81 0> translate <0 0 15> rotate <-90 0 0> translate <-15 15 0> } 
  composite { BS  rotate <0 0 -90> rotate <0 -81 0> translate <0 0 15> rotate <-105 0 0> translate <-15 15 0> } 
  composite { Head  rotate <0 180 0> rotate <0 0 -90> rotate <0 -90 0> translate <0 0 15> rotate <-120 0 0> translate <-15 15 0> } 
rotate <0 -45 0>
scale <23 23 23>
translate <-260 800 -1100>
//--- to lazy to compute bound
}









