//--- Fast Rending Plants




//---- Texture for the right side of leaf
#declare Leaf_Texture_R = 
texture {
	color DarkGreen 
	ambient .35
	diffuse .5
	waves .8
	frequency .05
	phong .75
	phong_size 40
	scale <10 .01 10>
	rotate <0 0 45>
}
texture {
	wood
	color_map {
	[0 .5 color Black alpha .8 color DarkGreen alpha .7]
	[.5 1 color DarkGreen alpha .7 color Yellow alpha .7]
	}
	diffuse .5
	scale <30 40 20>
	} 


//---- Texture for left side of leaf
#declare Leaf_Texture_L = 
texture {
	color DarkGreen
	ambient .35
	diffuse .5
	waves .8
	frequency .05
	phong .75
	phong_size 40
	scale <10 .01 10>
	rotate <0 0 -45>
}
texture {
	wood
	color_map {
	[0 .5 color Black alpha .8 color DarkGreen alpha .7]
	[.5 1 color DarkGreen alpha .7 color Yellow alpha .7]
	}
	diffuse .5
	scale <30 40 20>
	} 


//--- Texture for leaf stem
#declare StemTexture = 
texture {
	color DarkGreen 
	ambient .35
	diffuse .5
	waves .8
	frequency .05
	phong .75
	phong_size 40
	scale <10 .1 10>
	rotate <0 0 45>
}


//----- Right 1/2 of leaf
#declare Leaf_R = 
object {
     quadric { Sphere scale <10 20 8> translate <5 0 0> }
	clipped_by {
	  quadric { Sphere scale <12.5 30 12.5> translate <0 15 0> }
	  quadric { Cylinder_X scale <1 22 8> translate <0 0 1.7> inverse }
	  plane { <1 0 0> 0 inverse }
	}
		texture {
		Leaf_Texture_R
		}
}


//--- Left 1/2 of leaf
#declare Leaf_L = 
object {
     quadric { Sphere scale <10 20 8> translate <-5 0 0> }
	clipped_by {
	  quadric { Sphere scale <12.5 30 12.5> translate <0 15 0> }
	  quadric { Cylinder_X scale <1 22 8> translate <0 0 1.7> inverse }
	  plane { <1 0 0> 0 }
	}
		texture {
		Leaf_Texture_L
		}
}


#declare Stem = 
object {
  difference {
   intersection { Disk_Z scale <41.5 41.5 1.5> translate <-36.5 19.9 0> }
   quadric { Cylinder_Z scale <42.8 40 1> translate <-39.8 20.1 0> }
   plane { <0 1 0> 0 }
  }
    texture { StemTexture }  
     bounded_by {
     box { UnitBox scale <48 48 5> translate <-36.5 20 0> }
     }
rotate <0 -90 0>
}



//---- Plant stalk

#declare T_Texture = 
    texture {
       gradient <1 0 0>
	turbulence .1
	color_map {
	[0 .6 color DarkGreen color DarkGreen]
	[.6 .8 color DarkGreen color MediumForestGreen]
	[.8 1 color Khaki color Tan]
	}
       .07
       ambient   0.2
       diffuse   0.5
    }
    texture {
       color Clear
       waves .5
       scale <20 2 20  >
       phong .6
       phong_size 20


    }
   




#declare Dot =
    quadric {
       < 1.0  1.0  1.0>
       < 0.0  0.0  0.0>
       < 0.0  0.0  0.0>
        -1.0
    }

#declare Connector_1 = 
   object {
      quadric {
         < 0.0  1.0  1.0>
         < 0.0  0.0  0.0>
         < 0.0  0.0  0.0>
          -1.0
      }
      clipped_by {
         plane { < 1.0  0.0  0.0> 1.0 }
         plane { <-1.0  0.0  0.0> 0.0 }
      }
   }

#declare Connector_2 =
   quadric {
      < 1.0 -1.0  1.0>
      < 0.0  0.0  0.0>
      < 0.0  0.0  0.0>
        0.0
      rotate < 0.0  0.0  90.0>
   }

/*----------------------------------------------------------------------------*/

#declare Stalk =
   composite {

      object {
         quadric {
            Dot
            scale     < 9.333330  9.333330  9.333330>
         }
         texture {
            T_Texture
         }
      }


      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  9.312603 }
            plane {     < 1.000000  0.000000  0.000000>  8.647423 inverse }
         }

         texture { T_Texture }

         translate <-9.312603  0.000000  0.000000>
         scale     < 14.979824  1.000000  1.000000>
         translate <-0.621676  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  87.614085>
         rotate    < 0.000000  60.000128  0.000000>
         }


      object {
         quadric {
            Dot
            scale     < 8.666670  8.666670  8.666670>
            translate < 0.208330  10.000000 -0.360840>
         }
         texture {
            T_Texture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  8.647489 }
            plane {     < 1.000000  0.000000  0.000000>  7.982295 inverse }
         }

         texture { T_Texture }       

	  translate <-8.647489  0.000000  0.000000>
         scale     < 15.005653  1.000000  1.000000>
         translate <-0.576282  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  85.872172>
         rotate    < 0.000000  149.999582  0.000000>
         translate < 0.208330  10.000000 -0.360840>
      }


      object {
         quadric {
            Dot
            scale     < 8.000000  8.000000  8.000000>
            translate <-0.416670  20.000000 -0.721690>
         }
         texture {
            T_Texture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  7.982416 }
            plane {     < 1.000000  0.000000  0.000000>  7.317212 inverse }
         }

         texture { T_Texture }

         translate <-7.982416  0.000000  0.000000>
         scale     < 15.057626  1.000000  1.000000>
         translate <-0.530124  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  83.709142>
         rotate    < 0.000000 -139.106407  0.000000>
         translate <-0.416670  20.000000 -0.721690>
      }


      object {
         quadric {
            Dot
            scale     < 7.333330  7.333330  7.333330>
            translate <-1.250000  30.000000  0.000000>
         }
         texture {
           T_Texture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  7.317376 }
            plane {     < 1.000000  0.000000  0.000000>  6.652167 inverse }
         }


         texture { T_Texture }

         translate <-7.317376  0.000000  0.000000>
         scale     < 15.135480  1.000000  1.000000>
         translate <-0.483458  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  81.456245>
         rotate    < 0.000000 -73.897810  0.000000>
         translate <-1.250000  30.000000  0.000000>
      }



      object {
         quadric {
            Dot
            scale     < 6.666670  6.666670  6.666670>
            translate <-0.833330  40.000000  1.443380>
         }
         texture {
            T_Texture
         }
      }


      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  6.652361 }
            plane {     < 1.000000  0.000000  0.000000>  5.987122 inverse }
         }

         texture { T_Texture }

         translate <-6.652361  0.000000  0.000000>
         scale     < 15.238136  1.000000  1.000000>
         translate <-0.436560  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  79.190028>
         rotate    < 0.000000 -10.893279  0.000000>
         translate <-0.833330  40.000000  1.443380>
      }



      object {
         quadric {
            Dot
            scale     < 6.000000  6.000000  6.000000>
            translate < 1.041670  50.000000  1.804220>
         }
         texture {
            T_Texture
         }
      }



      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  5.987334 }
            plane {     < 1.000000  0.000000  0.000000>  5.322071 inverse }
         }

         texture { T_Texture }

         translate <-5.987334  0.000000  0.000000>
         scale     < 15.365773  1.000000  1.000000>
         translate <-0.389654  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  76.938992>
         rotate    < 0.000000  51.051795  0.000000>
         translate < 1.041670  50.000000  1.804220>
      }



      object {
         quadric {
            Dot
            scale     < 5.333330  5.333330  5.333330>
            translate < 2.500000  60.000000 -0.000000>
         }
         texture {
            T_Texture
         }
      }


      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  5.322290 }
            plane {     < 1.000000  0.000000  0.000000>  4.657010 inverse }
         }

         texture { T_Texture }

         translate <-5.322290  0.000000  0.000000>
         scale     < 15.517788  1.000000  1.000000>
         translate <-0.342980  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  74.718236>
         rotate    < 0.000000  112.410955  0.000000>
         translate < 2.500000  60.000000 -0.000000>
      }



      object {
         quadric {
            Dot
            scale     < 4.666670  4.666670  4.666670>
            translate < 1.458330  70.000000 -2.525910>
         }
         texture {
            T_Texture
         }
      }




      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  4.657224 }
            plane {     < 1.000000  0.000000  0.000000>  3.991903 inverse }
         }

         texture { T_Texture }

         translate <-4.657224  0.000000  0.000000>
         scale     < 15.692774  1.000000  1.000000>
         translate <-0.296775  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  72.537656>
         rotate    < 0.000000  173.413295  0.000000>
         translate < 1.458330  70.000000 -2.525910>
      }



      object {
         quadric {
            Dot
            scale     < 4.000000  4.000000  4.000000>
            translate <-1.666670  80.000000 -2.886750>
         }
         texture {
            T_Texture
         }
      }



      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  3.992103 }
            plane {     < 1.000000  0.000000  0.000000>  3.326749 inverse }
         }

         texture { T_Texture }

         translate <-3.992103  0.000000  0.000000>
         scale     < 15.890659  1.000000  1.000000>
         translate <-0.251223  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  70.404278>
         rotate    < 0.000000 -125.817495  0.000000>
         translate <-1.666670  80.000000 -2.886750>
      }



      object {
         quadric {
            Dot
            scale     < 3.333330  3.333330  3.333330>
            translate <-3.750000  90.000000  0.000000>
         }
         texture {
            T_Texture
         }
      }



      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  3.326927 }
            plane {     < 1.000000  0.000000  0.000000>  2.661548 inverse }
         }

         texture { T_Texture }

         translate <-3.326927  0.000000  0.000000>
         scale     < 16.110621  1.000000  1.000000>
         translate <-0.206505  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  68.323422>
         rotate    < 0.000000 -65.208680  0.000000>
         translate <-3.750000  90.000000  0.000000>
      }



      object {
         quadric {
            Dot
            scale     < 2.666670  2.666670  2.666670>
            translate <-2.083330  100.000000  3.608440>
         }
         texture {
            T_Texture
         }
      }



      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  2.661697 }
            plane {     < 1.000000  0.000000  0.000000>  1.996270 inverse }
         }

         texture { T_Texture }

         translate <-2.661697  0.000000  0.000000>
         scale     < 16.351045  1.000000  1.000000>
         translate <-0.162785  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  66.299220>
         rotate    < 0.000000 -4.714953  0.000000>
         translate <-2.083330  100.000000  3.608440>
      }




      object {
         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate < 2.291670  110.000000  3.969280>
         }
         texture {
            T_Texture
         }
      }



      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.996386 }
            plane {     < 1.000000  0.000000  0.000000>  1.330921 inverse }
         }

         texture { T_Texture }

         translate <-1.996386  0.000000  0.000000>
         scale     < 16.611751  1.000000  1.000000>
         translate <-0.120179  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  64.334645>
         rotate    < 0.000000  55.693393  0.000000>
         translate < 2.291670  110.000000  3.969280>
      }




      object {
         quadric {
            Dot
            scale     < 1.333330  1.333330  1.333330>
            translate < 5.000000  120.000000 -0.000000>
         }
         texture {
            T_Texture
         }
      }
      bounded_by {
         quadric {
            Dot
            scale < 73.318661  73.318661  73.318661>
            translate < 0.000000  56.000000  0.000000>
         }
      }
   }





//--- Complete Leaf & Stem
#declare Leaf1 =
composite {
   object { Leaf_L rotate <90 0 0>  translate <0 54 -38> }
   object { Leaf_R rotate <90 0 0>  translate <0 54 -38> }
   object { Stem }
     bounded_by {
     box { UnitBox scale <20 40 36> translate <0 38 -28> }
     }
}


//--- A 17 Leaf Plant
#declare Plant17 =
composite {
composite { Stalk scale <1 1 1> }
composite { Leaf1 scale <.6 .6 .6> rotate <-20 0 0> rotate <0 30 0> translate <5 119 0> }
composite { Leaf1 scale <.4 .4 .4> rotate <-20 0 0> rotate <0 -30 0> translate <5 119 0> }
composite { Leaf1 scale <.7 .7 .7> rotate <-20 0 0> rotate <0 20 0> translate <-2 100 3.6> }
composite { Leaf1 scale <.7 .7 .7> rotate <-20 0 0> rotate <0 120 0> translate <-2 100 3.6> }
composite { Leaf1 scale <.65 .65 .65> rotate <-20 0 0> rotate <0 240 0> translate <-2 100 3.6> }
composite { Leaf1 scale <.4 .4 .4> rotate <-20 0 0> rotate <0 -40 0> translate <-2 100 3.6> }
composite { Leaf1 scale <.5 .5 .5> rotate <-20 0 0> rotate <0 -20 0> translate <-3.75 90 -2> }
composite { Leaf1 scale <.5 .5 .5> rotate <-20 0 0> rotate <0 140 0> translate <-3.75 90 -2> }
composite { Leaf1 scale <.6 .6 .6> rotate <-20 0 0> rotate <0 180 0> translate <-1.66 80 -2> }
composite { Leaf1 scale <.6 .6 .6> rotate <-20 0 0> rotate <0 50 0> translate <-1.66 80 -2> }
composite { Leaf1 scale <.6 .6 .6> rotate <-20 0 0> rotate <0 -50 0> translate <-1.66 80 -2> }
composite { Leaf1 scale <.5 .5 .5> rotate <-20 0 0> rotate <0 -110 0> translate <-1.66 80 -2> }
composite { Leaf1 scale <.6 .6 .6> rotate <-20 0 0> rotate <0 110 0> translate <-1.66 80 -2> }
composite { Leaf1 scale <.5 .5 .5> rotate <-20 0 0> rotate <0 10 0> translate <-1.66 80 -2> }
composite { Leaf1 scale <.6 .6 .6> rotate <-20 0 0> rotate <0 30 0> translate <2.5 60 -2> }
composite { Leaf1 scale <.5 .5 .5> rotate <-20 0 0> rotate <0 -40 0> translate <4.5 60 -2> }
composite { Leaf1 scale <.5 .5 .5> rotate <-20 0 0> rotate <0 100 0> translate <5.5 60 0> }
	bounded_by {
	box { UnitBox scale <60 120 60> translate <0 90 0> }
	}
}

//--- A 6 Leaf Plant
#declare Plant6 =
composite {
composite { Stalk scale <1 1 1> }
composite { Leaf1 scale <.6 .6 .6> rotate <-20 0 0> rotate <0 30 0> translate <5 119 0> }
composite { Leaf1 scale <.4 .4 .4> rotate <-20 0 0> rotate <0 -30 0> translate <5 119 0> }
composite { Leaf1 scale <.7 .7 .7> rotate <-20 0 0> rotate <0 -20 0> translate <-2 100 3.6> }
composite { Leaf1 scale <.7 .7 .7> rotate <-20 0 0> rotate <0 -70 0> translate <-2 100 3.6> }
composite { Leaf1 scale <.65 .65 .65> rotate <-20 0 0> rotate <0 -180 0> translate <-2 100 3.6> }
composite { Leaf1 scale <.4 .4 .4> rotate <-20 0 0> rotate <0 -40 0> translate <-2 100 3.6> }
	bounded_by {
	box { UnitBox scale <60 120 60> translate <0 90 0> }
	}

}

//--- A 3 Leaf Plant
#declare Plant3 =
composite {
composite { Stalk scale <1 1 1> }
composite { Leaf1 scale <.6 .6 .6> rotate <-20 0 0> rotate <0 30 0> translate <5 119 0> }
composite { Leaf1 scale <.4 .4 .4> rotate <-20 0 0> rotate <0 -30 0> translate <5 119 0> }
composite { Leaf1 scale <.7 .7 .7> rotate <-20 0 0> rotate <0 -20 0> translate <-2 100 3.6> }
	bounded_by {
	box { UnitBox scale <60 100 60> translate <0 90 0> }
	}

}


//---- Complete Plant
//---- On Left
composite {
composite { Plant17 }
composite { Plant6 scale <.7 .7 .7> rotate <0 0 0> translate <20 0 -10> }
composite { Plant6 scale <.7 .7 .7> rotate <0 200 0> translate <-15 0 15> }
composite { Plant17 scale <.55 .55 .55> translate <-10 0 -11> }
composite { Plant3 scale <.6 .6 .6> translate <3 0 9> }
	bounded_by {
	box { UnitBox scale <90 100 90> translate <0 90 0> }
	}
scale <7 7 7> 
translate <-200 600 610>
}


//---- Complete Plant
composite {
composite { Plant17 }
composite { Plant6 scale <.7 .7 .7> rotate <0 0 0> translate <20 0 -10> }
composite { Plant6 scale <.7 .7 .7> rotate <0 200 0> translate <-25 0 15> }
composite { Plant17 scale <.55 .55 .55> translate <-6 0 -11> }
composite { Plant17 scale <.6 .6 .6> translate <12 0 9> }
	bounded_by {
	box { UnitBox scale <100 80 100> translate <0 49 0> }
	}
scale <5  5 5> 
translate <1800 600 910>
}






