// Persistence of Vision Raytracer
// Petals, An as yet undiscovered flowering plant
// By Douglas Otwell

//----------------------------------------------------------------------------
// INSTRUCTIONS:  This data file is designed to be rendered in two passes,
//   with a post-processing step in between.  This accomplishes the depth-
//   of-field effect.  An image processor such as Piclab is needed to smooth
//   the first rendering, which is then used as a backdrop for render #2.
// Step 1.)  Render this file as is.  This will render just the two
//           background plants and sky.
// Step 2.)  Take the result and smooth it with an image processor. I used
//           twelve SMOOTH commands in Piclab. Save the result as 
//           PETALSBG.TGA
// Step 3.)  Comment out the "Background scene" section at the end of this
//           file.  Remove the comments around "Final Scene".  Render.
//----------------------------------------------------------------------------


#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

camera {
   location  <0.0  90.0  -120.0>
   direction <0.0 0.0  2.0>
   up        <0.0  1.0  0.0>
   right     <1.33333 0.0 0.0>
   look_at   <0.0 65.0 0.0>
}

object {  
   light_source {<20 120 -50> color White}
}
object {  
   light_source {<-20 120 -50> color White}
}


#declare leaf_texture = texture {
   leopard
   turbulence 1.0
   color_map {
      [0.0 0.1   color ForestGreen  color MediumForestGreen]
      [0.1 0.4   color MediumForestGreen  color White]
      [0.4 0.6   color White color GreenYellow]
      [0.6 1.001 color GreenYellow color GreenYellow]
   }
   scale <0.1 0.1 0.1>
   phong 1.0 phong_size 70.0
}
#declare stem_texture = texture {
   bozo
   turbulence 1.0
   color_map {
      [0.0 0.6   color MediumSeaGreen color MediumSeaGreen]
      [0.6 1.001 color MediumSeaGreen color YellowGreen]
   }
   phong 0.8 phong_size 70.0
   scale <0.5 0.5 0.5>
}
#declare sepal_texture = texture {
   color MediumSeaGreen 
   phong 0.8 phong_size 10.0
   bumps 1.0
   scale <0.5 12 0.5>
}
#declare petal_texture = texture {
   gradient <0 1 0>
   color_map {
      [0.0 0.8 color White color Violet]
      [0.8 1.001 color Violet color Violet]
   }
   scale <1 18 1>
   translate <0 -6 0>
   bumps 1.0
   scale <0.5 0.5 0.5>

   ambient 0.3
   diffuse 0.6
}

/* Texture declarations for object 'leaf1_side1' */
#declare leaf_side2_C1 = texture {leaf_texture}
#declare leaf_side4_C1 = texture {leaf_texture}
#declare leaf_side1_C1 = texture {color MediumSeaGreen}
#declare leaf_side6_C1 = texture {color MediumSeaGreen}

#declare leaf = composite {  /* All Objects */
    #include "leaf2.inc"

    bounded_by {
        box { <-1.8000 0.0000 -1.0000> <1.8000 12.0000 3.2154> }
    }

    /*
        Scene extents
        X - Min:  -1.8000  Max:   1.8000
        Y - Min:   0.0000  Max:  12.0000
        Z - Min:  -1.0000  Max:   3.2154
    */
}

#declare leaves = composite {
   composite {
      leaf
      scale <1 1.4 1>
      rotate <0 10 0>
      translate <0 0 3>
      rotate <0 -55 0>
   }
   composite {
      leaf
      rotate <0 10 0>
      translate <0 0 3>
      rotate <0 -10 0>
   }
   composite {
      leaf
      scale <1 1.2 1>
      rotate <0 10 0>
      translate <0 0 3>
      rotate <0 45 0>
   }
   composite {
      leaf
      rotate <0 10 0>
      translate <0 0 3>
      rotate <0 115 0>
   }
   composite {
      leaf
      scale <1 1.2 1>
      rotate <0 10 0>
      translate <0 0 3>
      rotate <0 265 0>
   }
}

#declare blossom1 = composite {
   object {
      union {
         quadric {Ellipsoid scale <3 6 1.2>}
         quadric {Ellipsoid scale <3 6 1.0> rotate <0 60 0>}
         quadric {Ellipsoid scale <3 6 1.4> rotate <0 120 0>}
      }
      clipped_by {
            quadric {Ellipsoid inverse scale <3 3 3> translate <0 -4 0>}
      }
      texture {petal_texture}
      bounded_by {sphere {<0 0 0> 6}}
   }
   object {
      quadric {Ellipsoid scale <1.6 3 1.5>}
      texture {sepal_texture}
      translate <0 5 0>
   }
}

#declare blossom2 = composite {
   object {
      union {
         quadric {Ellipsoid scale <4 6 1.4>}
         quadric {Ellipsoid scale <4 6 1.6> rotate <0 60 0>}
         quadric {Ellipsoid scale <4 6 1.8> rotate <0 120 0>}
      }
      clipped_by {
            quadric {Ellipsoid inverse scale <6 6 6> translate <0 -5 0>}
      }
      texture {petal_texture}
      bounded_by {sphere {<0 0 0> 6}}
   }
   object {
      quadric {Ellipsoid scale <1.5 3 1.6>}
      texture {sepal_texture}
      translate <0 5 0>
   }
}

#declare stem = object {
   intersection {
      quartic {
         < 1  0  0  0  2
           0  0  2  0 -50.32
           0  0  0  0  0
           0  0  0  0  0
           1  0  0  2  0
           49.68 0  0  0  0
           1  0 -50.32 0 617.0256>
      }
      plane {<0 0 1> 0 inverse}
      plane {<0 0 1> 0 inverse rotate <0 45 0>}
   }
   bounded_by {box {<-5.4 -0.4 -5.4> <5.4 0.4 5.4>}}

   texture {stem_texture}
   rotate <-90 0 0>
}

#declare branch1 = composite {
   composite {
      blossom1
      translate <-5 -8 0>
      rotate <0 0 -45>
   }
   object {stem}
   translate <-5 0 0>
}
#declare branch2 = composite {
   composite {
      blossom2
      translate <-5 -8 0>
      rotate <0 0 -45>
   }
   object {stem}
   translate <-5 0 0>
}

#declare tier1 = composite {
   composite {branch1}
   composite {branch1 rotate <0 72 0>}
   composite {branch2 rotate <0 144 0>}
   composite {branch1 rotate <0 216 0>}
   composite {branch2 rotate <0 288 0>}
}

#declare tier2 = composite {
   composite {branch2}
   composite {branch1 rotate <0 72 0>}
   composite {branch2 rotate <0 144 0>}
   composite {branch1 rotate <0 216 0>}
   composite {branch2 rotate <0 288 0>}
}


// Plant
#declare plant = composite {
   composite {
      composite {tier2 translate <0 40 0>}
      composite {tier2 rotate <0 40 0> translate <0 48 0>}
      composite {tier2 rotate <0 70 0> translate <0 56 0>}
      composite {tier1 rotate <0 20 0> translate <0 64 0>}
      composite {tier1 rotate <0 50 0> translate <0 72 0>}
      composite {branch1 rotate <0 20 0> translate <0 78 0>}
      composite {branch1 rotate <0 150 0> translate <0 81 0>}
      composite {branch1 rotate <0 240 0> translate <0 83 0>}
   }

   composite {
      leaves
      scale <7 7 7>
   }
   
   object {
      intersection {
         Cone_Y 
         translate <0 1 0>
         scale <1.6 55.33 1.6>
      }
      clipped_by {plane {<0 1 0> 83}}
      texture {stem_texture}
   }
   object {
      intersection {
         Cone_Y 
         translate <0 1 0>
         scale <0.4 5 0.4>
         rotate <10 -60 0>
         translate <0 83 0>
      }
      texture {stem_texture}
   }

}

//----------------------------------------------------------------------------
// Background scene
//----------------------------------------------------------------------------

composite {plant rotate <0 180 0> translate <-40 0 50>}
composite {plant rotate <0 180 0> translate <40 0 50>}

// Sky
object {
   sphere {<0 0 0> 2000 inverse} 
   texture {
      gradient <0 1 0>
      color_map {
         [0.0  0.01 color Gray color Gray]
         [0.01 0.35 color Gray color Gray15]
         [0.35 0.55 color Gray15 color SkyBlue]
         [0.55 1.0  color SkyBlue color SkyBlue]
      }
      ambient 1.0
      diffuse 0.0

      scale <4000 4000 4000>
      translate <0 -2000 0>
   }
}


//----------------------------------------------------------------------------
// Final scene
//----------------------------------------------------------------------------

/* remove this line to render the final scene

composite {plant}

//  The background image_mapped plane is scaled and positioned so that the
//    image fills the screen and is at right angles to the line of sight
object {
   plane {<0 0 1> 45 inverse}
   texture {
      image_map {<1 -1 0> tga "petalsbg.tga" once interpolate 4}
      translate <-0.5 -0.5 0>
      scale <113.33 84.90 1>

      ambient 1.0
      diffuse 0.0
   }
   rotate <11.77 0 0>
   translate <0 65 0>
}

remove this line to render the final scene */

