// Persistence of Vision Raytracer
// Twister objects were generated using the POV-Ray utility "twister.exe"
// and then hand-tweaked.

#include "include.inc"
#declare Pale_Pink   = color red 0.88 green 0.74 blue 0.77
#declare Pale_Blue   = color red 0.65 green 0.80 blue 0.91
#declare Pale_Green  = color red 0.68 green 0.84 blue 0.74
#declare Pale_Yellow = color red 0.88 green 0.88 blue 0.74

// These declarations are required for the twist files.
// If you change the _type_ of object used, you must also reflect that
// change in the particular twist.inc file.  Watch out for exceeding the
// scale of the bounding shape in the twist.inc files, too.
//-----------------------------------------------------------------
// Shapes used for each twister
// ----------------------------
#declare Part1 = intersection { Disk_X scale < 5.00 0.25 0.25 > }
#declare Part2 = quadric { Ellipsoid scale < 2.00 2.0 0.5 > }
#declare Part3 = union {
    quadric { Ellipsoid scale < 0.25 0.25 0.25 > translate <-5.25 0 0> }
    quadric { Ellipsoid scale < 0.25 0.25 0.25 > translate < 5.25 0 0> }
}

// Textures for each twister
// ----------------------------
#declare Texture1 =
 texture {
    color blue 0.5
    metallic
    brilliance 7
    phong 0.85 phong_size 50
    ambient 0.2
    reflection 0.85
}
#declare Texture2 =  texture { color White reflection 0.95 }
#declare Texture3 =  texture {
    Silver_Metal
    gradient <0 1 0>
    color_map {
        [0.00 0.25 color Pale_Pink color Pale_Green]
        [0.25 0.50 color Pale_Green color Pale_Blue]
        [0.50 0.75 color Pale_Blue color Pale_Yellow]
        [0.75 1.00 color Pale_Yellow color Pale_Pink]
    }
//    scale <1 10 1>
    }

// Now, include the twister data (as objects)
// ----------------------------
#include "twist1.inc"
#include "twist2.inc"
#include "twist3.inc"

// This sets things up for a possible animation.
// Note that twister #2 is 90 degrees out of sync with the others
// ----------------------------
#declare RotateY1 = 0
#declare RotateY2 = 90
#declare RotateY3 = 0

// Now, start the scene description
// ----------------------------
camera {
   location <0 0  -25>
   direction <0 0  FoV_45>
   up  <0  1  0>
   right <1.33333 0 0>
   look_at <0 0 0>
}

object { light_source  { <-10 10 -20>  color White  } }
#declare The_Twist = composite {
    object { Macaroni1 rotate <0 RotateY1 0> }
    object { Macaroni2 rotate <0 RotateY2 0> }
    object { Macaroni3 rotate <0 RotateY3 0> }
}

composite { The_Twist
    translate <0 -10 0>  // Centered on 0 y
}
