// Persistence of Vision Raytracer
// Twister objects were generated using the POV-Ray utility "twister.exe"
// and then hand-tweaked.

#include "include.inc"

// These declarations are required for the twist files.
// If you change the _type_ of object used, you must also reflect that
// change in the particular twist.inc file.  Watch out for exceeding the
// scale of the bounding shape in the twist.inc files, too.
//-----------------------------------------------------------------
// Shapes used for each twister
// ----------------------------
#declare Part1 = intersection { Disk_X scale < 5.00 0.25 0.25 > }
#declare Part2 = quadric { Ellipsoid scale < 2.00 2.0 0.5 > }
#declare Part3 = union {
    quadric { Ellipsoid scale < 0.2 0.2 0.2 > translate <-6 0 0> }
    quadric { Ellipsoid scale < 0.2 0.2 0.2 > translate < 6 0 0> }
}

// Textures for each twister
// ----------------------------
#declare Texture1 =
 texture {
    color Gray20
    phong 0.5 phong_size 50
    ambient 0.2
    reflection 0.85
}
#declare Texture2 =  texture { Copper_Metal reflection 0.95 }
#declare Texture3 =  texture { Silver_Metal }

// Now, include the twister data (as objects)
// ----------------------------
#include "twist1.inc"
#include "twist2.inc"
#include "twist3.inc"

// This sets things up for a possible animation.
// Note that twister #2 is 90 degrees out of sync with the others
// ----------------------------
#declare RotateY1 = 0
#declare RotateY2 = 90
#declare RotateY3 = 0

// Now, start the scene description
// ----------------------------
camera {
   location <0 0  -25>
   direction <0 0  FoV_45>
   up  <0  1  0>
   right <1.33333 0 0>
   look_at <0 0 0>
}

object { light_source  { <-10 10 -20>  color White  } }
#declare The_Twist = composite {
    object { Macaroni1 rotate <0 RotateY1 0> }
    object { Macaroni2 rotate <0 RotateY2 0> }
    object { Macaroni3 rotate <0 RotateY3 0> }
}

composite { The_Twist
    translate <0 -10 0>  // Centered on 0 y
    rotate <0 0 90>      // Turn major axis to x
    rotate <0 45 0>      // Pivot right side toward camera
}
