// Persistence of Vision Raytracer Version 1.0
// Back to simple 2d paths,  but with a different sort of tile.
#include "colors.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "textures.inc"

camera {
    location <0 12 -15>
    direction <0 0 1>
    up  <0 1 0>
    right <1.33333 0 0>
    look_at <0 3 0>
}


object {
   light_source { <10 50 -50>
   colour red 0.95 green 0.95 blue 0.85
    }
}
object {
   light_source { <-5 150 -50>
   colour Gray35
    }
}


#include "tile9.inc"

#declare Block = composite {
composite { Tiles rotate <90 0 0> translate <0 6 0> }     // Top
composite { Tiles                 translate <0 0 -6>}     // Front
composite { Tiles rotate <0 90 0> translate <6 0 0> }     // Right
}

composite { Block rotate <0 45 0>}
object {
    sphere { <0 8 0> 2 }
    texture {
        0.0125            // minimize banding
        color Color2
        reflection 0.85
        specular 1
        roughness 0.001
    }
}
object {
    sphere { <3 7 -2> 1 }
    texture {
        color Color1
        reflection 0.85
        specular 1
        roughness 0.001
    }
}
object {
    sphere { <-3 8.5 -6> 0.5 }    // This one floats
    texture {
        color Orange
        reflection 0.85
        specular 1
        roughness 0.001
    }
}
