// Persistence of Vision Raytracer Version 1.0
// Image by Dan Farmer
// 5x5x5 matrix of 3-path Truchet tiles
#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

camera {
    location <15 15 -45>
    direction <0 0 4>
    up  <0 1 0>
    right <1.33333 0 0>
    look_at <0 0 0>
}

object {
   light_source { <-10 25 -15>
   color White
   spotlight
   point_at <0 0 0>
   tightness 20
   radius 8
   falloff 15
    }
}

object { light_source { <15 50 50>  color SteelBlue } }


#declare TTex = texture {
    Shiny
    color White
    ambient 0.2
    brilliance 3
}


//  Outer radius: 1.25  Inner radius: 0.75
#declare Torus = quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -2.125000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        1.875000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -2.125000 0.000000 0.878906 >
        texture { TTex }
}

#declare Tile = object {
    union {
        quartic { Torus  rotate <90 0 0> translate <-1 1 0>   }
        quartic { Torus  rotate <0 0 0>  translate <1 0 1>    }
        quartic { Torus  rotate <0 0 -90> translate <0 -1 -1> }
    }
    clipped_by { box { UnitBox }}
    bounded_by { box { UnitBox scale < 1.001 1.001 1.001> }}
}

// Note that these can be applied in any order.
#declare Tile1= object { Tile rotate <0  0 -180> }
#declare Tile2= object { Tile rotate <0  0  -90> }
#declare Tile3= object { Tile rotate <0  0    0> }
#declare Tile4= object { Tile rotate <0  0   90> }
#declare Tile5= object { Tile rotate <0  0  180> }

// Arrange 5 tiles into a row
#declare T5x1x1 = composite {
    object { Tile1 translate <-4 0 0>}
    object { Tile2 translate <-2 0 0>}
    object { Tile3 translate < 0 0 0>}
    object { Tile4 translate <+2 0 0>}
    object { Tile5 translate <+4 0 0>}
    bounded_by {
        box { UnitBox scale < 5.001 1.001 1.001> }
    }
}

// Arrange 5 rows into a 5x1x5 "plane"
#declare T5x1x5 = composite {
    composite { T5x1x1 rotate < 0  0  0> translate <0 0 -4> }
    composite { T5x1x1 rotate < 0  0  0> translate <0 0 -2> }
    composite { T5x1x1 rotate < 0  0  0> translate <0 0  0> }
    composite { T5x1x1 rotate < 0  0  0> translate <0 0  2> }
    composite { T5x1x1 rotate < 0  0  0> translate <0 0  4> }
    bounded_by {
        box { UnitBox scale < 5.001 1.001 5.001> }
    }
}

#declare T5x5x5 = composite {
    composite { T5x1x5 rotate < 90  0  0> translate <0 -4 0> }
    composite { T5x1x5 rotate <  0  0  0> translate <0  2 0> }
    composite { T5x1x5 rotate <  0  0  0> translate <0  0 0> }
    composite { T5x1x5 rotate <  0  0  0> translate <0 -2 0> }
    composite { T5x1x5 rotate <-90  0  0> translate <0 -4 0> }
    bounded_by {
        box { UnitBox scale < 5.001 5.001 5.001> }
    }
}

composite { T5x5x5 }


