// Persistence of Vision Raytracer Version 1.0
//  3 path Truchet tiles.  Very well bounded, traces in about 6 hours at
// 640x480  +a0.2 on a 486/33.
// Image by Dan Farmer
#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

camera {
    location <15 30 -60>
    direction <0 0 4>
    up  <0 1 0>
    right <1.33333 0 0>
    look_at <0 0 0>
}

object {
   light_source { <5 50 -50>
   colour red 0.85 green 0.85 blue 0.85
   spotlight
   point_at <0 0 0>
   tightness 60
   radius 8
   falloff 16
    }
}
object {
   light_source { <5 100 150>
   colour red 0.4 green 0.4 blue 0.4
   spotlight
   point_at <0 0 0>
   tightness 60
   radius 8
   falloff 16
    }
}

//  Outer radius: 1.25  Inner radius: 0.75
#declare Torus = quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -2.125000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        1.875000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -2.125000 0.000000 0.878906 >
 }/* end_quartic */

// Untransformed torus lines in x/z plane
// Create a 3-Path tile using these elbow macaroni pieces
#declare Tile = object {
    union {
        quartic { Torus rotate <90 0 0> translate <-1 1 0>   }
        quartic { Torus rotate <0 0 0>  translate <1 0 1>    }
        quartic { Torus rotate <0 0 -90> translate <0 -1 -1> }
    }
    clipped_by {
        box { UnitBox scale < 1.25 1.25 1.25 > }
    }
    texture {
        Shiny
        color White
    }
    bounded_by {
        box { UnitBox scale < 1.26 1.26 1.26> }
    }
    color Red
}

// Note that these can be applied in any order.
#declare Tile1= object { Tile rotate <  0   0   0> }
#declare Tile2= object { Tile rotate < 90   0   0> }
#declare Tile3= object { Tile rotate <180   0   0> }
#declare Tile4= object { Tile rotate <270   0   0> }
#declare Tile5= object { Tile rotate <  0  90   0> }
#declare Tile6= object { Tile rotate <  0 180   0> }
#declare Tile7= object { Tile rotate <  0 270   0> }
#declare Tile8= object { Tile rotate <  0   0  90> }
#declare Tile9= object { Tile rotate <  0   0 180> }

// A 3 x 1 x 3 layer of "tiles"
#declare Layer = composite {
    composite {   // Center Row
        object { Tile1 translate <-2.5 0 0>}
        object { Tile2 translate <0 0 0>}
        object { Tile3 translate <+2.5 0 0>}
        bounded_by {
            box { UnitBox scale < 5.1 1.26 1.26> }
        }
    }
    composite {   // Front row
        object { Tile4 translate <-2.5 0 0>}
        object { Tile5 translate <0 0 0>}
        object { Tile6 translate <+2.5 0 0>}
        bounded_by {
            box { UnitBox scale < 3.76 1.26 1.26> }
        }
        rotate <90 0 0>
        translate <0 0 2.5>
    }
    composite {   // Back row
        object { Tile7 translate <-2.5 0 0>}
        object { Tile8 translate <0 0 0>}
        object { Tile9 translate <+2.5 0 0>}
        bounded_by {
            box { UnitBox scale < 3.76 1.26 1.26> }
        }
        rotate <270 0 0>
        translate <0 0 -2.5>
    }
    bounded_by {
        box { UnitBox scale < 3.76 1.26 5.1> }
    }
}

// Three layers stacked into a 3 x 3 x 3 tile cube
#declare Cube3x3x3 = composite {
    composite { Layer translate <0 2.5 0> }
    composite { Layer}
    composite { Layer translate <0 -2.5 0> }
    bounded_by {
        box { UnitBox scale < 3.76 3.76 3.76> }
    }
}

#declare Row9x3x9 = composite {
composite { Cube3x3x3 }
composite { Cube3x3x3 translate <7.5 0 0> }
composite { Cube3x3x3 rotate <90 0 0> translate < -7.5 0 0> }
    bounded_by {
        box { UnitBox scale < 11.26 3.76 11.26> }
    }
}
composite { Row9x3x9 }
/*
#declare Layer9x6x9 = composite {
    composite { Row9x3x9 translate <0 0 0>   }
    composite { Row9x3x9 translate <0 0 -7.5>}
    composite { Row9x3x9 translate <0 0  7.5>}

    composite { Row9x3x9 translate <0 7.5   0>  }
    composite { Row9x3x9 translate <0 7.5  -7.5>}
    composite { Row9x3x9 translate <0 7.7   7.5>}
    bounded_by {
        box { UnitBox scale < 11.26 11.26 11.26> }
    }
}

composite { Layer9x6x9 }
*/

