// Persistence of Vision Raytracer Version 1.0
#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

camera {
    location <15 50 -60>
    direction <0 0 4>
    up  <0 1 0>
    right <1.33333 0 0>
    look_at <0 1 0>
}

object {
   light_source { <5 50 -50>
   colour red 0.85 green 0.85 blue 0.85
   spotlight
   point_at <0 0 0>
   tightness 60
   radius 8
   falloff 16
    }
}
object {
   light_source { <5 100 150>
   colour red 0.4 green 0.4 blue 0.4
   spotlight
   point_at <0 0 0>
   tightness 60
   radius 8
   falloff 16
    }
}



//  Outer radius: 1.25  Inner radius: 0.75
#declare Torus = quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -2.125000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        1.875000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -2.125000 0.000000 0.878906 >
 }/* end_quartic */

// This really should be just a CSG, with no texture at this point, but
// a current limitation in the parser won't allow me to CLIP without
// declaring the piece as an object.  I could've used an intersection
// instead, but with much more overhead, too.
#declare Quarter_Torus = object {
  quartic { Torus rotate <90 0 0>  }
  clipped_by {
      plane { <-1 0 0> 0  }
      plane { <0  1 0> 0  }
   }
  color Red
  texture {
    Gold_Texture
   }
}


// A tile is a square space with opposing corners having symmetrical patterns
// so the patterns will still match up when rotated 90 degrees.

#declare Tile = composite {
    object { Quarter_Torus translate <-1 1 0>  }/* end_object */
    object { Quarter_Torus rotate <0 0 180> translate <1 -1 0>  }/* end_object */
    bounded_by {
        sphere { <0 0 0> 1.77  }
     }
}
// A special code generator that I wrote "flips" the tiles by 90 degrees
// based on a random "coinflip".  To keep things clearer,  I've designed
// each attitude as a separate tile piece.
#declare EvenTile = composite {
    composite { Tile  }
}
#declare OddTile = composite {
    composite { Tile  }
    rotate <0 0 90>
}

// read in the file holding the truchet tile grid data
#include "tile.inc"


// Build a Chrome_Texture frame.  Four separate pieces are used so that each
// can have a slightly different pattern to the woodgrain.
#declare XFramePiece1 = object { box { UnitBox scale <6.5 0.5 0.5> }
    texture { Chrome_Texture rotate <0 -85 0> translate <-3 0 0> }
}
#declare XFramePiece2 = object { box { UnitBox scale <6.5 0.5 0.5> }
    texture { Chrome_Texture  rotate <0 90 0> translate <-2.5 0 0> }
}
#declare YFramePiece1 = object { box { UnitBox scale <0.5 6.5 0.5> }
    texture { Chrome_Texture  rotate <0 0 0> translate <85 0 1> }
}
#declare YFramePiece2 = object { box { UnitBox scale <0.5 6.5 0.5> }
    texture { Chrome_Texture  rotate <0 5 0> translate <87 0 -1>}
}

// Threaded rod,  4 will be used to hold the frame together at the corners
#declare Rod = object {
    intersection {Z_Disk scale <0.25 0.25 7> }
    texture { Chrome_Texture
        gradient <0 0 1>                        // threads
        color_map {
            [0.0 0.5 color DimGray color LightGray ]
            [0.5 1.0 color LightGray color DimGray ]
        }
        scale <1 1 0.1>
        rotate <0 1 0>                          // pitch the threads a bit
    }
}

// This is one complete unit which will be repeated four times below.
#declare Piece = composite {
    composite { Tiles }
    object {XFramePiece1 translate <0.5 -6.5 0> }
    object {YFramePiece1 rotate <0 0 180> translate <-6.5 -0.5 0> }
    object {XFramePiece2 rotate <0 0 180> translate <-0.5  6.5 0> }
    object {YFramePiece2 translate < 6.5 0.5 0> }
}


// Build the finished piece.  3 copies of the framed object are stacked
// along the Z axis, and are tied together with steel rods in each of the
// four corners.
composite {
    composite {Piece}
    composite {Piece rotate <0 0 180> translate <0 0 6> }
    composite {Piece rotate <0 0 90> translate <0 0 -6> }


    object { Rod  translate <-6.5  6.5 0> }
    object { Rod  translate <-6.5 -6.5 0> }
    object { Rod  translate < 6.5 -6.5 0> }
    object { Rod  translate < 6.5  6.5 0> }
}

// A floor plane
object {
    plane { <0 1 0> -7 }
    texture {
        color LightGray
        reflection 0.25
    }
}
