// Persistence of Vision Raytracer Version 1.0
#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

camera {
    location <15 50 -60>
    direction <0 0 4>
    up  <0 1 0>
    right <1.33333 0 0>
    look_at <0 1 0>
}

object {
   light_source { <5 50 -50>
   colour red 0.85 green 0.85 blue 0.85
   spotlight
   point_at <0 0 0>
   tightness 60
   radius 8
   falloff 16
    }
}
object {
   light_source { <5 100 150>
   colour red 0.2 green 0.2 blue 0.2
   spotlight
   point_at <0 0 0>
   tightness 60
   radius 8
   falloff 16
    }
}


#declare VeryDarkWood1 = color red 0.30 green 0.15 blue 0.09
#declare DarkWood1 =  color red 0.60 green 0.30 blue 0.18
#declare Wooden = texture {
        wood
        turbulence 0.04
        octaves 3
        scale <0.2 0.2 1>
        colour_map {
            [0.00 0.10 color DarkWood1 color DarkWood1]
            [0.10 0.90 color DarkWood1 color VeryDarkWood1]
            [0.90 1.01  color VeryDarkWood1  color VeryDarkWood1 ]
         }
        ambient 0.2
        diffuse 0.8
        specular 0.25
        roughness 0.01
        reflection 0.1
}


// read in the file holding the truchet tile grid data
#include "tile.inc"


// Build a wooden frame.  Four separate pieces are used so that each
// can have a slightly different pattern to the woodgrain.
#declare XFramePiece1 = object { box { UnitBox scale <6.5 0.5 0.5> }
    texture { Wooden rotate <0 -85 0> translate <-3 0 0> }
}
#declare XFramePiece2 = object { box { UnitBox scale <6.5 0.5 0.5> }
    texture { Wooden  rotate <0 90 0> translate <-2.5 0 0> }
}
#declare YFramePiece1 = object { box { UnitBox scale <0.5 6.5 0.5> }
    texture { Wooden  rotate <0 0 0> translate <85 0 1> }
}
#declare YFramePiece2 = object { box { UnitBox scale <0.5 6.5 0.5> }
    texture { Wooden  rotate <0 5 0> translate <87 3 -1>}
}

// Threaded rod,  4 will be used to hold the frame together at the corners
#declare Rod = object {
    intersection {Z_Disk scale <0.25 0.25 7> }
    texture { Chrome_Texture
        gradient <0 0 1>                        // threads
        color_map {
            [0.0 0.5 color DimGray color LightGray ]
            [0.5 1.0 color LightGray color DimGray ]
        }
        scale <1 1 0.1>
        rotate <0 1 0>                          // pitch the threads a bit
    }
}

// This is one complete unit which will be repeated four times below.
#declare Piece = composite {
    composite { Tiles }
    object {XFramePiece1 translate <0.5 -6.5 0> }
    object {YFramePiece1 rotate <0 0 180> translate <-6.5 -0.5 0> }
    object {XFramePiece2 rotate <0 0 180> translate <-0.5  6.5 0> }
    object {YFramePiece2 translate < 6.5 0.5 0> }
}


// Build the finished piece.  3 copies of the framed object are stacked
// along the Z axis, and are tied together with steel rods in each of the
// four corners.
composite {
    composite {Piece}
    composite {Piece rotate <0 0 180> translate <0 0 6> }
    composite {Piece rotate <0 0 90> translate <0 0 -6> }


    object { Rod  translate <-6.5  6.5 0> }
    object { Rod  translate <-6.5 -6.5 0> }
    object { Rod  translate < 6.5 -6.5 0> }
    object { Rod  translate < 6.5  6.5 0> }
}

// A floor plane
object {
    plane { <0 1 0> -7 }
    texture {
        color DimGray
        reflection 0.25
    }
}
