// Persistence of Vision Raytracer Version 1.0
#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

camera {
    location <0 0 -15>
    direction <0 0 1>
    up  <0 1 0>
    right <1.33333 0 0>
    look_at <0 0 0>
}


object {
   light_source { <5 100 -250>
   colour red 0.85 green 0.85 blue 0.85
    }
}
object {
   light_source { <5 -100 -25>
   colour red 0.1 green 0.1 blue 0.1
    }
}


#declare VeryDarkWood1 = color red 0.30 green 0.15 blue 0.09
#declare DarkWood1 =  color red 0.60 green 0.30 blue 0.18
#declare Wooden = texture {
        wood
        turbulence 0.04
        octaves 3
        scale <0.2 0.2 1>
        colour_map {
            [0.00 0.10 color DarkWood1 color DarkWood1]
            [0.10 0.90 color DarkWood1 color VeryDarkWood1]
            [0.90 1.01  color VeryDarkWood1  color VeryDarkWood1 ]
         }
        ambient 0.2
        diffuse 0.8
}

//  Outer radius: 1.25  Inner radius: 0.75
#declare Torus = quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -2.125000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        1.875000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -2.125000 0.000000 0.878906 >
 }/* end_quartic */

#declare Quarter_Torus = object {
  quartic { Torus rotate <90 0 0>  }
  clipped_by {
      plane { <-1 0 0> 0  }
      plane { <0  1 0> 0  }
   }
  color Red
  texture {
      bumps 0.35
      scale <0.15 0.15 0.15>
      color red 0.89 green 0.47 blue 0.20
      ambient 0.2
      diffuse 0.8
      reflection 0.15
      brilliance 8.0
      specular 1
      roughness 0.001
   }
}

#declare Tile = composite {
    object { Quarter_Torus translate <-1 1 0>  }/* end_object */
    object { Quarter_Torus rotate <0 0 180> translate <1 -1 0>  }/* end_object */
    bounded_by {
        sphere { <0 0 0> 1.77  }
     }
}

#declare EvenTile = composite {
    composite { Tile  }
}

#declare OddTile = composite {
    composite { Tile  }
    rotate <0 0 90>
}

#include "tile.inc"


#declare XFramePiece1 = object { box { UnitBox scale <6.5 0.5 0.5> }
    texture { Wooden rotate <0 -85 0> translate <-3 0 0> }
}
#declare XFramePiece2 = object { box { UnitBox scale <6.5 0.5 0.5> }
    texture { Wooden  rotate <0 90 0> translate <-2.5 0 0> }
}

#declare YFramePiece1 = object { box { UnitBox scale <0.5 6.5 0.5> }
    texture { Wooden  rotate <0 0 0> translate <85 0 1> }
}
#declare YFramePiece2 = object { box { UnitBox scale <0.5 6.5 0.5> }
    texture { Wooden  rotate <0 5 0> translate <87 0 -1>}
}

#declare Rod = object {
    intersection {Z_Disk scale <0.25 0.25 5> }
    texture { Chrome_Texture
        gradient <0 0 1>                        // threads
        color_map {
            [0.0 0.5 color DimGray color LightGray ]
            [0.5 1.0 color LightGray color DimGray ]
        }
        scale <1 1 0.1>
        rotate <0 1 0>                          // pitch the threads a bit
    }
}

#declare Piece = composite {
    composite { Tiles }
    object {XFramePiece1 translate <0.5 -6.5 0> }
    object {YFramePiece1 rotate <0 0 180> translate <-6.5 -0.5 0> }
    object {XFramePiece2 rotate <0 0 180> translate <-0.5  6.5 0> }
    object {YFramePiece2 translate < 6.5 0.5 0> }
}


composite {
    composite {Piece}
    composite {Piece rotate <0 0 180> translate <0 0 4> }
    composite {Piece rotate <0 0 90> translate <0 0 -4> }


    object { Rod  translate <-6.5  6.5 0> }
    object { Rod  translate <-6.5 -6.5 0> }
    object { Rod  translate < 6.5 -6.5 0> }
    object { Rod  translate < 6.5  6.5 0> }
}

