
#declare Color1 = color red 0.30 green 0.15 blue 0.09
#declare Color2 = color red 0.60 green 0.30 blue 0.18
#declare Color3 = color Black
#declare TileTexture = texture {
        wood
        color_map {
            [0.0 0.33 color Color1 color Color2]
            [0.33 0.66 color Color2 color Color2]
            [0.66 1.0 color Color1 color Color1]
        }
    ambient 0.2
    diffuse 0.75
}

#declare Tile1 = object {
    triangle { <-1 1 0.0> <1 -1 0.0> <-1 -1 0.0> }
    texture { TileTexture
        translate <-1 -1 0>
    }
}
#declare Tile2 = object {
    triangle { <-1 1 0.0> <1 -1 0.0> <1 1 0.0>   }
    texture { TileTexture
        translate <1 1 0>
    }
}

// Make a square (x.y) from two triangles.
// Make two copies, one rotated by 90 degrees.
#declare EvenTile = composite { object { Tile1 } object { Tile2 } }
#declare OddTile = composite { EvenTile  rotate <0 0 90> }


// Persistence of Vision Raytracer Version 1.0
#declare Tiles1 = composite {
    composite { OddTile translate <  1   1   0>  }
    composite { EvenTile translate <  1   3   0>  }
    composite { OddTile translate <  1   5   0>  }
    composite { EvenTile translate <  1   7   0>  }
    composite { EvenTile translate <  1   9   0>  }
    composite { EvenTile translate <  1  11   0>  }
    bounded_by { box { UnitBox scale <1 12.5 1> translate <1 0 0> }}

}

#declare Tiles2 = composite {
    composite { OddTile translate <  3   1   0>  }
    composite { OddTile translate <  3   3   0>  }
    composite { EvenTile translate <  3   5   0>  }
    composite { OddTile translate <  3   7   0>  }
    composite { OddTile translate <  3   9   0>  }
    composite { OddTile translate <  3  11   0>  }
    bounded_by { box { UnitBox scale <1 12.5 1> translate <3 0 0> }}
}
#declare Tiles3 = composite {
    composite { EvenTile translate <  5   1   0>  }
    composite { EvenTile translate <  5   3   0>  }
    composite { EvenTile translate <  5   5   0>  }
    composite { EvenTile translate <  5   7   0>  }
    composite { OddTile translate <  5   9   0>  }
    composite { OddTile translate <  5  11   0>  }
    bounded_by { box { UnitBox scale <1 12.5 1> translate <5 0 0> }}
}
#declare Tiles4 = composite {
    composite { EvenTile translate <  7   1   0>  }
    composite { OddTile translate <  7   3   0>  }
    composite { EvenTile translate <  7   5   0>  }
    composite { OddTile translate <  7   7   0>  }
    composite { OddTile translate <  7   9   0>  }
    composite { EvenTile translate <  7  11   0>  }
    bounded_by { box { UnitBox scale <1 12.5 1> translate <7 0 0> }}
}
#declare Tiles5 = composite {
    composite { OddTile translate <  9   1   0>  }
    composite { OddTile translate <  9   3   0>  }
    composite { OddTile translate <  9   5   0>  }
    composite { EvenTile translate <  9   7   0>  }
    composite { OddTile translate <  9   9   0>  }
    composite { OddTile translate <  9  11   0>  }
    bounded_by { box { UnitBox scale <1 12.5 1> translate <9 0 0> }}
}
#declare Tiles6 = composite {
    composite { OddTile translate < 11   1   0>  }
    composite { EvenTile translate < 11   3   0>  }
    composite { OddTile translate < 11   5   0>  }
    composite { OddTile translate < 11   7   0>  }
    composite { EvenTile translate < 11   9   0>  }
    composite { OddTile translate < 11  11   0>  }
    bounded_by { box { UnitBox scale <1 12.5 1> translate <11 0 0> }}
}


#declare Tiles = composite {
    composite {Tiles1}
    composite {Tiles2}
    composite {Tiles3}
    composite {Tiles4}
    composite {Tiles5}
    composite {Tiles6}
    translate <-6 -6 0>
    bounded_by { box { UnitBox scale <12.5 12.5 1> }}
}
