
//  Outer radius: 1.25  Inner radius: 0.75
#declare Torus = quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -2.125000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        1.875000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -2.125000 0.000000 0.878906 >
 }/* end_quartic */

// This really should be just a CSG, with no texture at this point, but
// a current limitation in the parser won't allow me to CLIP without
// declaring the piece as an object.  I could've used an intersection
// instead, but with much more overhead, too.
#declare Quarter_Torus = object {
  quartic { Torus rotate <90 0 0>  }
  clipped_by {
      plane { <-1 0 0> 0  }
      plane { <0  1 0> 0  }
   }
  color Red
  texture {
      color red 0.89 green 0.47 blue 0.20
      ambient 0.2
      diffuse 0.8
      reflection 0.15
      brilliance 8.0
      specular 1
      roughness 0.001
   }
}


// A tile is a square space with opposing corners having symmetrical patterns
// so the patterns will still match up when rotated 90 degrees.

#declare Tile = composite {
    object { Quarter_Torus translate <-1 1 0>  }
    object { Quarter_Torus rotate <0 0 180> translate <1 -1 0>  }
    bounded_by {
        sphere { <0 0 0> 1.77  }
     }
}
// A special code generator that I wrote "flips" the tiles by 90 degrees
// based on a random "coinflip".  To keep things clearer,  I've designed
// each attitude as a separate tile piece.
#declare EvenTile = composite {
    composite { Tile  }
}
#declare OddTile = composite {
    composite { Tile  }
    rotate <0 0 90>
}

// Persistence of Vision Raytracer Version 1.0
#declare Tiles1 = composite {
    composite { OddTile translate <  1   1   0>  }
    composite { EvenTile translate <  1   3   0>  }
    composite { OddTile translate <  1   5   0>  }
    composite { EvenTile translate <  1   7   0>  }
    composite { EvenTile translate <  1   9   0>  }
    composite { EvenTile translate <  1  11   0>  }
    bounded_by { box { UnitBox scale <1 12.5 1> translate <1 0 0> }}

}

#declare Tiles2 = composite {
    composite { OddTile translate <  3   1   0>  }
    composite { OddTile translate <  3   3   0>  }
    composite { EvenTile translate <  3   5   0>  }
    composite { OddTile translate <  3   7   0>  }
    composite { OddTile translate <  3   9   0>  }
    composite { OddTile translate <  3  11   0>  }
    bounded_by { box { UnitBox scale <1 12.5 1> translate <3 0 0> }}
}
#declare Tiles3 = composite {
    composite { EvenTile translate <  5   1   0>  }
    composite { EvenTile translate <  5   3   0>  }
    composite { EvenTile translate <  5   5   0>  }
    composite { EvenTile translate <  5   7   0>  }
    composite { OddTile translate <  5   9   0>  }
    composite { OddTile translate <  5  11   0>  }
    bounded_by { box { UnitBox scale <1 12.5 1> translate <5 0 0> }}
}
#declare Tiles4 = composite {
    composite { EvenTile translate <  7   1   0>  }
    composite { OddTile translate <  7   3   0>  }
    composite { EvenTile translate <  7   5   0>  }
    composite { OddTile translate <  7   7   0>  }
    composite { OddTile translate <  7   9   0>  }
    composite { EvenTile translate <  7  11   0>  }
    bounded_by { box { UnitBox scale <1 12.5 1> translate <7 0 0> }}
}
#declare Tiles5 = composite {
    composite { OddTile translate <  9   1   0>  }
    composite { OddTile translate <  9   3   0>  }
    composite { OddTile translate <  9   5   0>  }
    composite { EvenTile translate <  9   7   0>  }
    composite { OddTile translate <  9   9   0>  }
    composite { OddTile translate <  9  11   0>  }
    bounded_by { box { UnitBox scale <1 12.5 1> translate <9 0 0> }}
}
#declare Tiles6 = composite {
    composite { OddTile translate < 11   1   0>  }
    composite { EvenTile translate < 11   3   0>  }
    composite { OddTile translate < 11   5   0>  }
    composite { OddTile translate < 11   7   0>  }
    composite { EvenTile translate < 11   9   0>  }
    composite { OddTile translate < 11  11   0>  }
    bounded_by { box { UnitBox scale <1 12.5 1> translate <11 0 0> }}
}


#declare Tiles = composite {
    composite {Tiles1}
    composite {Tiles2}
    composite {Tiles3}
    composite {Tiles4}
    composite {Tiles5}
    composite {Tiles6}
    translate <-6 -6 0>
    bounded_by { box { UnitBox scale <12.5 12.5 1> }}
}
