#include "include.inc"
#declare Ellipsoid = quadric { Sphere }


#declare Light_Wood = texture {
    wood
    turbulence 0.04
    octaves 3
    scale <0.02 0.02 1>
    colour_map {
        [0.0 0.8  colour red 0.93 green 0.71 blue 0.532
                  colour red 0.98 green 0.81 blue 0.6]
        [0.8 1.01 colour red 0.8 green 0.533 blue 0.466
                  colour red 0.85 green 0.75 blue 0.35]
    }
    rotate <90 0 0>            // rotate for a vertical cylinder
    translate <-0.25 0 -0.25>  // since no wood is perfect
    rotate <1.5 0 0.75>        // ditto
}

camera {
   location <0.0  0  -5.25>
   direction <0.0 0.0  1.0>
   up  <0.0  1.0  0.0>
   right <1.33333 0.0 0.0>
   look_at <0 0 0>
}
#declare Amb = 0.25
object { light_source  { <10 10 -20>  color White  } }
object { light_source  { <-20 15 -10>  color red Amb green Amb blue Amb  } }
default { texture { ambient Amb } }

#declare Spool = object {
    union {
        quadric { Ellipsoid scale <1 0.2 1> translate <0 1 0>  texture { Light_Wood  } }
        intersection { Y_Disk scale <0.75 1 0.75> }
        quadric { Ellipsoid scale <1 0.2 1> translate <0 -1 0> texture { Light_Wood  } }
    }
}


#declare YellowThread = texture {
    gradient <0 1 0>
    color_map {
        [0.0  0.5  color Yellow color red 0.2 green 0.2]
        [0.5  1.0 color red 0.15 green 0.15 color Yellow  ]
    }
    scale <1 0.025 1>
}

#declare GreenThread = texture {
    gradient <0 1 0>
    color_map {
        [0.0  0.5 color HuntersGreen color green 0.25]
        [0.5  1.0 color green 0.2 color HuntersGreen  ]
    }
    scale <1 0.025 1>
}
#declare BlueVioletThread = texture {
    gradient <0 1 0>
    color_map {
        [0.0  0.5 color BlueViolet color red 0.2 green 0.1 blue 0.2]
        [0.5  1.0 color  red 0.15 green 0.075 blue 0.15 color BlueViolet  ]
    }
    scale <1 0.025 1>
}
#declare RedThread = texture {
    gradient <0 1 0>
    color_map {
        [0.0  0.5 color Scarlet color red 0.5]
        [0.5  1.0 color red 0.25 color Scarlet  ]
    }
    scale <1 0.025 1>
}
object { Spool texture { YellowThread } }
object { Spool texture { GreenThread } translate <-1.75 0  0> }
object { Spool texture { BlueVioletThread }  translate <-1.5 2.2 0> }
object { Spool texture { RedThread scale <0.5 1 0.5> } rotate <0 0 90> rotate <0 30 0> translate <1.25 0 -3.25> }
