// A spiral blob, data points came from Truman Brown's spiral.exe.
// I converted them to blob points with a simple awk script.
// Not a real impressive image (I never uploaded it anywhere) but an
// interesting idea.
#include "include.inc"

camera {
    location  <0 10 -40>
    direction <0 0 2>
    up <0 1 0>
    right <1.3333 0 0>
    look_at <0 0 0>
}

object { light_source { <-15 100 -150> color red 1 green 1 blue 1}}
object { light_source { <-15 10  -150> color Gray75 }}

#declare Density = 0.85
object {
    blob {
        threshold 0.95
        component Density 2.000 < 10.000 0.000 0.000 >
        component Density 1.986 < 9.839 0.048 1.786 >
        component Density 1.971 < 9.282 0.095 3.484 >
        component Density 1.957 < 8.437 0.143 5.041 >
        component Density 1.943 < 7.337 0.190 6.410 >
        component Density 1.929 < 6.021 0.238 7.550 >
        component Density 1.914 < 4.536 0.286 8.429 >
        component Density 1.900 < 2.931 0.333 9.021 >
        component Density 1.886 < 1.262 0.381 9.315 >
        component Density 1.871 < -0.418 0.429 9.305 >
        component Density 1.857 < -2.054 0.476 8.997 >
        component Density 1.843 < -3.593 0.524 8.407 >
        component Density 1.829 < -4.990 0.571 7.559 >
        component Density 1.814 < -6.200 0.619 6.485 >
        component Density 1.800 < -7.189 0.667 5.223 >
        component Density 1.786 < -7.929 0.714 3.818 >
        component Density 1.771 < -8.400 0.762 2.318 >
        component Density 1.757 < -8.594 0.810 0.773 >
        component Density 1.743 < -8.508 0.857 -0.766 >
        component Density 1.729 < -8.152 0.905 -2.250 >
        component Density 1.714 < -7.542 0.952 -3.632 >
        component Density 1.700 < -6.703 1.000 -4.870 >
        component Density 1.686 < -5.667 1.048 -5.927 >
        component Density 1.671 < -4.470 1.095 -6.772 >
        component Density 1.657 < -3.155 1.143 -7.382 >
        component Density 1.643 < -1.767 1.190 -7.744 >
        component Density 1.629 < -0.353 1.238 -7.849 >
        component Density 1.614 < 1.043 1.286 -7.701 >
        component Density 1.600 < 2.375 1.333 -7.310 >
        component Density 1.586 < 3.601 1.381 -6.693 >
        component Density 1.571 < 4.685 1.429 -5.875 >
        component Density 1.557 < 5.594 1.476 -4.888 >
        component Density 1.543 < 6.303 1.524 -3.766 >
        component Density 1.529 < 6.794 1.571 -2.550 >
        component Density 1.514 < 7.056 1.619 -1.281 >
        component Density 1.500 < 7.086 1.667 0.000 >
        component Density 1.486 < 6.888 1.714 1.250 >
        component Density 1.471 < 6.473 1.762 2.430 >
        component Density 1.457 < 5.862 1.810 3.502 >
        component Density 1.443 < 5.078 1.857 4.436 >
        component Density 1.429 < 4.151 1.905 5.205 >
        component Density 1.414 < 3.114 1.952 5.787 >
        component Density 1.400 < 2.004 2.000 6.168 >
        component Density 1.386 < 0.859 2.048 6.342 >
        component Density 1.371 < -0.283 2.095 6.308 >
        component Density 1.357 < -1.386 2.143 6.072 >
        component Density 1.343 < -2.414 2.190 5.649 >
        component Density 1.329 < -3.337 2.238 5.055 >
        component Density 1.314 < -4.127 2.286 4.316 >
        component Density 1.300 < -4.762 2.333 3.460 >
        component Density 1.286 < -5.226 2.381 2.517 >
        component Density 1.271 < -5.508 2.429 1.520 >
        component Density 1.257 < -5.606 2.476 0.505 >
        component Density 1.243 < -5.521 2.524 -0.497 >
        component Density 1.229 < -5.260 2.571 -1.452 >
        component Density 1.214 < -4.839 2.619 -2.331 >
        component Density 1.200 < -4.276 2.667 -3.107 >
        component Density 1.186 < -3.594 2.714 -3.759 >
        component Density 1.171 < -2.817 2.762 -4.268 >
        component Density 1.157 < -1.976 2.810 -4.624 >
        component Density 1.143 < -1.100 2.857 -4.819 >
        component Density 1.129 < -0.218 2.905 -4.852 >
        component Density 1.114 < 0.640 2.952 -4.728 >
        component Density 1.100 < 1.448 3.000 -4.456 >
        component Density 1.086 < 2.180 3.048 -4.051 >
        component Density 1.071 < 2.815 3.095 -3.529 >
        component Density 1.057 < 3.335 3.143 -2.914 >
        component Density 1.043 < 3.728 3.190 -2.227 >
        component Density 1.029 < 3.986 3.238 -1.496 >
        component Density 1.014 < 4.104 3.286 -0.745 >
        component Density 1.000 < 4.086 3.333 0.000 >
        component Density 0.986 < 3.936 3.381 0.714 >
        component Density 0.971 < 3.665 3.429 1.375 >
        component Density 0.957 < 3.287 3.476 1.964 >
        component Density 0.943 < 2.819 3.524 2.463 >
        component Density 0.929 < 2.280 3.571 2.859 >
        component Density 0.914 < 1.692 3.619 3.145 >
        component Density 0.900 < 1.077 3.667 3.315 >
        component Density 0.886 < 0.456 3.714 3.369 >
        component Density 0.871 < -0.149 3.762 3.311 >
        component Density 0.857 < -0.718 3.810 3.148 >
        component Density 0.843 < -1.235 3.857 2.890 >
        component Density 0.829 < -1.684 3.905 2.551 >
        component Density 0.814 < -2.053 3.952 2.148 >
        component Density 0.800 < -2.335 4.000 1.696 >
        component Density 0.786 < -2.523 4.048 1.215 >
        component Density 0.771 < -2.616 4.095 0.722 >
        component Density 0.757 < -2.618 4.143 0.236 >
        component Density 0.743 < -2.533 4.190 -0.228 >
        component Density 0.729 < -2.369 4.238 -0.654 >
        component Density 0.714 < -2.137 4.286 -1.029 >
        component Density 0.700 < -1.849 4.333 -1.344 >
        component Density 0.686 < -1.520 4.381 -1.590 >
        component Density 0.671 < -1.165 4.429 -1.765 >
        component Density 0.657 < -0.797 4.476 -1.865 >
        component Density 0.643 < -0.432 4.524 -1.894 >
        component Density 0.629 < -0.083 4.571 -1.855 >
        component Density 0.614 < 0.238 4.619 -1.755 >
        component Density 0.600 < 0.521 4.667 -1.603 >
        component Density 0.586 < 0.758 4.714 -1.409 >
        component Density 0.571 < 0.944 4.762 -1.184 >
        component Density 0.557 < 1.076 4.810 -0.940 >
        component Density 0.543 < 1.153 4.857 -0.689 >
        component Density 0.529 < 1.177 4.905 -0.442 >
        component Density 0.514 < 1.153 4.952 -0.209 >
        component Density 0.500 < 1.086 5.000 0.000 >
    sturm
    }
    texture {
        specular 1
        roughness 0.0005
        color red 1 green 0.65 blue 0.15
        ambient 0.15
        diffuse 0.7
    }
}

object { plane { <0 1 0> -2 }
    texture { color Gray15 reflection 0.5 }
}
