// Persistence of Vision Raytracer
// This data file makes a good starting point for developing tests and
// new data files.  It is also used as the benchmark for the timing tests.
// 3 hours 640 480 @-a  / 33-486
#include "include.inc"


#declare YourTexture =    /* change to your preference */
    texture {
       Dull
       leopard
       bumps 0.75
       color_map {
        [0.0 0.3 color Black color Black ]
        [0.3 0.5 color Black color Orange]
        [0.5 1.0 color Orange color Yellow]
       }
    }
#include "spider1.inc"



camera {
   location <10  18  -20>
   direction <0.0 0.0  1.0>
   up  <0.0  1.0  0.0>
   right <1.33333 0.0 0.0>
   look_at <0 0 0>
 }

// Light source
object { light_source { <-30 50 -15> color White  }}
object { light_source { <30 20 -15> color DimGray  }}

object { sphere { <0 0 0> 1000 texture {color DimGray } } }

#declare LegPair = composite {
    composite { LegThing }
    composite { LegThing rotate <0 180 0>}
}

#declare Spider = composite {
    composite { LegPair rotate <0  15 0>}
    composite { LegPair rotate <0  30 0>}
    composite { LegPair rotate <0 -30 0>}
    composite { LegPair rotate <0 -15 0>}

    object { quadric { Sphere}           // Head / Abdoment
        scale <3 2 3>
        translate <0 5 0>
        color Cyan
        texture {
            YourTexture
//            bumps 0.75
            scale<.25 .75 .25>
        }
    }

    object { quadric { Sphere}           // Thorax (rear-end)
        scale <6 3 6>
        rotate <-40 0 0>
        translate <0 5 8>
        color Red
        texture {
            YourTexture
            scale <0.175 1 0.175>      // don't know if this really works!
//            bumps 0.75
            scale<.75 .75 .75>
        }
     }
    object {                              // Mandables
        quadric { Sphere  scale <1.5 0.75 1.5> }
        clipped_by {
            quadric { Sphere  inverse scale <1.25 1 1.25> translate <0 0.15 -0.30>}
        }
        translate <0 6 -4>
        color Blue
        texture {           // Still using YourTexture colormap
            Chrome_Metal
            phong 1 phong_size 200
        }
    }
    object {                              // Eyes
        union {
            quadric { Sphere scale <1 1 1> translate <-0.65 0 0> }
            quadric { Sphere scale <1 1 1> translate <+0.65 0 0> }
        }
        translate <0 6.5 -2.5>
        color Yellow
        texture {
            YourTexture
            granite
            phong 0.5 phong_size 200
        }
    }
}

composite { Spider rotate <0 -15 0> translate <0 0 -5> }
composite { Spider rotate <0 180 0>  translate <0 0 -15>}


object { plane { <0 1 0> 0 }
    texture {
        YourTexture
        granite
        scale <5 5 5>
    }
}

