// Persistence of Vision Raytracer
// This data file makes a good starting point for developing tests and
// new data files.  It is also used as the benchmark for the timing tests.
#include "include.inc"
#include "spider1.inc"

camera {
   location <10  18  -20>
   direction <0.0 0.0  1.0>
   up  <0.0  1.0  0.0>
   right <1.33333 0.0 0.0>
   look_at <0 0 0>
 }

// Light source
object { light_source { <-30 50 -15> color White  }}
object { light_source { <30 20 -15> color DimGray  }}

object { sphere { <0 0 0> 1000 texture {color DimGray } } }

#declare LegPair = composite {
    composite { LegThing }
    composite { LegThing rotate <0 180 0>}
}

#declare Spider = composite {
    composite { LegPair rotate <0  15 0>}
    composite { LegPair rotate <0  30 0>}
    composite { LegPair rotate <0 -30 0>}
    composite { LegPair rotate <0 -15 0>}

    object { quadric { Sphere}           // Head / Abdoment
        scale <3 2 3>
        translate <0 5 0>
        texture {
            YourTexture
            bumps 0.75
            scale<.25 .75 .25>
        }
    }

    object { quadric { Sphere}           // Thorax (rear-end)
        rotate <30 0 0>
        scale <6 3 6>
        translate <0 5 9>
        texture {
            YourTexture
            scale <0.175 1 0.175>
            scale<.75 .75 .75>
        }
     }
    object {                              // Mandables
        quadric { Sphere  scale <1.5 0.75 1.5> }
        clipped_by {
            quadric { Sphere  inverse scale <1.25 1 1.25> translate <0 0.15 -0.30>}
        }
        translate <0 6 -4>
        texture {           // Still using YourTexture colormap
            Gold_Metal
            phong 1 phong_size 200
        }
    }
    object {                              // Eyes
        union {
            quadric { Sphere scale <1 1 1> translate <-0.65 0 0> }
            quadric { Sphere scale <1 1 1> translate <+0.65 0 0> }
        }
        translate <0 6.5 -2.5>
        texture {
            YourTexture
            granite
            phong 0.5 phong_size 200
        }
    }
}

composite { Spider translate <0 0 -5> }
composite { Spider rotate <0 -40 0>  translate <-18 0 13>}

object { plane { <0 1 0> 0 }
    texture {
        YourTexture
        bozo
        turbulence 0.45
        scale <10 10 10>
    }
}
