// Persistence Of Vision raytracer version 1.0 sample file.
// NOTE: This version of roman.pov has been modified by Dan Farmer.
// First stage of the Tower of Pisa
// warning:  This picture can take a very long time to ray trace
// due to the large number of objects.  You have been warned :->  
// Time: 640x480 without anti-aliasing, approx 1:30 on 486/33
//       (6 hrs 42 minutes with +a0.3)
#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#declare Stone = texture {
   stone16
   scale <6 6 6>
   ambient 0.25
   diffuse 0.7
   specular 0.75
   roughness 0.001
}

camera {
   location <0.0 10.0 -120.0>   // I'm kinda thinking of feet here
   direction <0.0 0.1 1.0>
   up <0.0 1.0 0.0>
   right <1.3333 0.0 0.0>
   look_at <0 28 0>
}

#declare Beam = quadric { Cylinder_Y inverse
    scale <0.35 20.0 0.35>       // ie: this would be 20 feet tall
    translate <2.0 0.0 0.0>
}

// create a sample column for the base of the structure
#declare BaseColumn = object {
    difference   {
        intersection {
             quadric { Beam                         }
             quadric { Beam rotate <0.0 -25.7  0.0> }
             quadric { Beam rotate <0.0 -51.4  0.0> }
             quadric { Beam rotate <0.0 -77.1  0.0> }
             quadric { Beam rotate <0.0 -102.8 0.0> }
             quadric { Beam rotate <0.0 -128.5 0.0> }
             quadric { Beam rotate <0.0 -154.2 0.0> }
             quadric { Beam rotate <0.0 -179.9 0.0> }
             quadric { Beam rotate <0.0 -205.6 0.0> }
             quadric { Beam rotate <0.0 -231.3 0.0> }
             quadric { Beam rotate <0.0 -257.0 0.0> }
             quadric { Beam rotate <0.0 -282.7 0.0> }
             quadric { Beam rotate <0.0 -308.4 0.0> }
             quadric { Beam rotate <0.0 -334.1 0.0> }
         }
        quadric { Cylinder_Y inverse scale <2 1 2>  }
    }

     clipped_by {
         plane { <0.0 1.0 0.0> 40.0 }
         plane { <0.0 -1.0 0.0> 0.0 }
     }

   bounded_by {
     intersection {
        plane { <0.0 1.0 0.0> 40.0 }
        plane { <0.0 -1.0 0.0> 0.0 }
         quadric {
            Cylinder_Y
            scale <2.51 1.0 2.51>
         }
     }
   }

   texture { Stone }
   colour red 0.8 green 0.0 blue 0.0
   scale <1.25 1 1.25>                      // after-thought
}

// and a rectangular pad to serve as a footing for the column
#declare BasePad = object {
   box { UnitBox scale <3 1 3> }
   texture { Stone }
   colour red 0.6 green 0.6 blue 0.4
}

// and define a basic arch to span the columns
#declare BaseArch = object {
   intersection {
      quadric { Cylinder_X scale <1.0 10.5 10.5> }
      quadric { Cylinder_X scale <1.0 8.5 8.5> inverse }
      plane { <1.0 0.0 0.0> 2.0 }
      plane { <-1.0 0.0 0.0> 2.0 }
      plane { <0.0 -1.0 0.0> 0.0 }
   }

   bounded_by {
     box { UnitBox scale <2 6.25 12.5 > translate <0 6.25 0> }
   }
   texture { Stone }
   colour red 0.8 green 0.8 blue 0.8
}

// and finally define the first floor floor
#declare BaseFloor = object {
   intersection {
      quadric { Cylinder_Y scale <50.0 50.0 50.0> }
      quadric { Cylinder_Y scale <40.0 40.0 40.0> inverse }
      plane { <0.0 1.0 0.0> 2.0 }
      plane { <0.0 -1.0 0.0> 2.0 }
   }
   texture { Stone }
   colour red 0.8 green 0.8 blue 0.6
}

// place a ring of 14 columns with footings around the base
#declare FullColumn = composite {
   object { BaseArch   translate <45.0 42.0 2.0>  rotate <0.0 -10.85 0.0> }
   object { BasePad    translate <45.0 41.0 0.0>  }
   object { BaseColumn translate <45.0 0.0 0.0>   }
   object { BasePad    translate <45.0 -1.0 0.0>  }
}

#declare Level1 = composite {
   object { BaseFloor translate <0.0 54.25 0.0>   }
   composite { FullColumn }
   composite { FullColumn rotate <0.0 -25.7   0.0> }
   composite { FullColumn rotate <0.0 -51.4   0.0> }
   composite { FullColumn rotate <0.0 -77.1   0.0> }
   composite { FullColumn rotate <0.0 -102.8  0.0> }
   composite { FullColumn rotate <0.0 -128.5  0.0> }
   composite { FullColumn rotate <0.0 -154.2  0.0> }
   composite { FullColumn rotate <0.0 -179.9  0.0> }
   composite { FullColumn rotate <0.0 -205.6  0.0> }
   composite { FullColumn rotate <0.0 -231.3  0.0> }
   composite { FullColumn rotate <0.0 -257.0  0.0> }
   composite { FullColumn rotate <0.0 -282.7  0.0> }
   composite { FullColumn rotate <0.0 -308.4  0.0> }
   composite { FullColumn rotate <0.0 -334.1  0.0> }
   object { BaseFloor  }

   bounded_by {
      intersection { 
         quadric { Cylinder_Y scale <55.0 1.0 55.0> }
         plane { <0.0  -1.0  0.0> 0.0 }
         plane { <0.0  1.0   0.0> 60.0 }
      }
   }
}

composite { Level1 }

// Add the sky to the picture
object {
   sphere { <0.0 0.0 0.0> 3000.0 }

   texture {
      bozo
      turbulence 0.75
      colour_map {
          [0.0 0.6  colour red 0.375 green 0.375 blue 0.75
                    colour red 0.375 green 0.375 blue 0.75]
          [0.6 0.8  colour red 0.375 green 0.375 blue 0.75
                    colour red 1.0   green 1.0   blue 1.0]
          [0.8 1.0  colour red 1.0   green 1.0   blue 1.0
                    colour red 0.85   green 0.85   blue 0.85]
      }
      scale <1000.0  200.0  1000.0>
      ambient 0.5
      diffuse 0.0
   }
   colour red 0.5 green 0.5 blue 1.0
}


// Define the desert floor
object {
   plane { <0.0 1.0 0.0> -1.0 }

   texture {
      0.05  /* This value dithers the colours */
      colour red 1.0 green 0.66 blue 0.2
      ripples 0.5
      frequency 2000.0
      scale <50000.0 50000.0 50000.0>
      ambient 0.25
      diffuse 0.7
   }
   colour red 1.0 green 0.66 blue 0.2
}

// Add a light source
object {
    light_source { <60.0  50.0  -110.0>
    colour White
    }
}
