// Persistence of Vision Raytracer Version 1.0
// Requires PLASMA.GIF
// A pearly sphere hovers between the points of two fractured surfaces.
//
// By Dan Farmer
/*
    The rock was generated with FRGEN v1.1 from file sphere.fr
    Options in effect: -sx0.1 -sy0.1 -sz0.1 -bx0 -by0 -bz0 -r2 -e3432
*/

#include "include.inc"

camera {
   location <0  0  -4>
   direction <0.0 0.0  1.0>
   up  <0.0  1.0  0.0>
   right <1.33333 0.0 0.0>
   look_at <0 0 0>
}

object {
   light_source { <15 0.5 -5>
   colour red 1 green 0.3
   }
}
object {
   light_source { <-10 -0.5 -45>
   colour red 0.5 green 0.7 blue 1
   }
}


/*** Stand-in for the core sample
#declare Core = composite
    object {
        intersection { Y_Disk translate <0 -1 0> }
        texture { color White }
    }
}
**/


// Core Sample
#declare Ruffness = 1
#declare Column_Texture = texture {
    0.015
    ambient 0.15
    diffuse 0.6
    reflection 0.25
    brilliance 5
    color Gray95
}

#declare Core1 = composite {

    object {
        height_field { gif "plasma.gif" }
        translate <-0.5 0 -0.5>
        scale <6 1 6>
        clipped_by {
            quadric { Cylinder_Y }
        }
        texture { Column_Texture }
        scale <1 Ruffness 1>
    }

    object {
        quadric { Cylinder_Y }
        clipped_by {
            height_field { gif "plasma.gif"
            translate <-0.5 0 -0.5>
            scale <6 1 6>
            inverse
            }
        }
        texture { Column_Texture }
        scale <1 Ruffness 1>
    }
}


#declare Core2 = composite {

    object {
        height_field { gif "plasma.gif" }
        translate <-0.5 0 -0.5>
        rotate <180 0 0>
        scale <6 1 6>
        clipped_by {
            quadric { Cylinder_Y }
        }
        texture { Column_Texture }
        scale <1 Ruffness 1>
    }

    object {
        quadric { Cylinder_Y
        }
        clipped_by {
            height_field { gif "plasma.gif"
            translate <-0.5 0 -0.5>
            rotate <180 0 0>
            scale <6 1 6>
            inverse
            }
        }
        texture { Column_Texture }
        scale <1 Ruffness 1>
    }
}


//object { sphere { <0 0 0> 100000 } texture { 0.025 color Gray25 ambient 1 } }
//object { plane { <0 1 0> -9 } texture { 0.025 color Gray25 reflection 0.5 }}
composite { Core1
    scale <2 2 2>
    translate <0 -2 0>
}
composite { Core2
    scale <2 2 2>
    rotate <0 180 0>
    translate <0 2 0>
}

object {
    sphere {<0 0 0> 0.20 }
    texture {
        Metal
        color White
        reflection 0.85
    }
    translate <0 0 -1.5>
}
