// Persistence of Vision Raytracer Version 1.0
// A rock, a fractured cylinder of rock, and a polished rock sphere.
// Requires PLASMA.GIF
/*
    The rock was generated with FRGEN v1.1 from file sphere.fr
    Options in effect: -sx0.1 -sy0.1 -sz0.1 -bx0 -by0 -bz0 -r2 -e3432
*/

#include "include.inc"

camera {
   location <0  12  -30>
   direction <0.0 0.0  1.0>
   up  <0.0  1.0  0.0>
   right <1.33333 0.0 0.0>
   look_at <0 -1 0>
}

object {
   light_source { <15 50 -50>
   colour White
   spotlight
   point_at <0 0 0>
   tightness 60
   radius 8
   falloff 16
    }
}
object {
   light_source { <-15 100 -15>
   colour red 0.25 green 0.2 blue 1
   spotlight
   point_at <0 0 0>
   tightness 60
   radius 8
   falloff 16
    }
}

#declare GreenStone = texture {
    Stone18
    ambient 0.1
    diffuse 0.55
    reflection 0.12
}

#declare Rock = composite {
    object {
	union {
	    triangle { < 0.000 8.800 0.000> < 1.463 7.998 -0.256> < 1.067 8.197 1.281> }
	    triangle { < 2.581 6.935 0.031> < 2.412 7.120 1.224> < 1.463 7.998 -0.256> }
	    triangle { < 2.221 7.306 2.418> < 1.067 8.197 1.281> < 2.412 7.120 1.224> }
	    triangle { < 1.463 7.998 -0.256> < 2.412 7.120 1.224> < 1.067 8.197 1.281> }
	    triangle { < 6.390 6.380 0.060> < 6.133 6.536 0.918> < 4.218 6.976 0.323> }
	    triangle { < 5.864 6.628 1.916> < 4.077 6.600 1.183> < 6.133 6.536 0.918> }
	    triangle { < 2.581 6.935 0.031> < 4.218 6.976 0.323> < 4.077 6.600 1.183> }
	    triangle { < 6.133 6.536 0.918> < 4.077 6.600 1.183> < 4.218 6.976 0.323> }
	    triangle { < 4.480 6.380 4.560> < 3.133 6.643 3.270> < 5.417 6.803 3.426> }
	    triangle { < 2.221 7.306 2.418> < 3.722 6.665 2.136> < 3.133 6.643 3.270> }
	    triangle { < 5.864 6.628 1.916> < 5.417 6.803 3.426> < 3.722 6.665 2.136> }
	    triangle { < 3.133 6.643 3.270> < 3.722 6.665 2.136> < 5.417 6.803 3.426> }
	    triangle { < 2.581 6.935 0.031> < 4.077 6.600 1.183> < 2.412 7.120 1.224> }
	    triangle { < 5.864 6.628 1.916> < 3.722 6.665 2.136> < 4.077 6.600 1.183> }
	    triangle { < 2.221 7.306 2.418> < 2.412 7.120 1.224> < 3.722 6.665 2.136> }
	    triangle { < 4.077 6.600 1.183> < 3.722 6.665 2.136> < 2.412 7.120 1.224> }
	}

	bounded_by {
	    sphere { < 3.195 7.590 2.152> 4.038 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 6.390 6.380 0.060> < 7.068 4.760 0.108> < 6.571 5.201 1.591> }
	    triangle { < 7.380 3.478 0.422> < 6.885 3.473 1.935> < 7.068 4.760 0.108> }
	    triangle { < 6.577 3.765 3.085> < 6.571 5.201 1.591> < 6.885 3.473 1.935> }
	    triangle { < 7.068 4.760 0.108> < 6.885 3.473 1.935> < 6.571 5.201 1.591> }
	    triangle { < 8.990 0.000 0.080> < 8.596 -0.229 1.889> < 8.073 1.406 0.453> }
	    triangle { < 8.257 0.184 3.505> < 7.861 1.423 2.341> < 8.596 -0.229 1.889> }
	    triangle { < 7.380 3.478 0.422> < 8.073 1.406 0.453> < 7.861 1.423 2.341> }
	    triangle { < 8.596 -0.229 1.889> < 7.861 1.423 2.341> < 8.073 1.406 0.453> }
	    triangle { < 6.300 0.000 6.420> < 6.150 1.780 5.009> < 7.418 0.418 5.269> }
	    triangle { < 6.577 3.765 3.085> < 7.533 2.132 3.450> < 6.150 1.780 5.009> }
	    triangle { < 8.257 0.184 3.505> < 7.418 0.418 5.269> < 7.533 2.132 3.450> }
	    triangle { < 6.150 1.780 5.009> < 7.533 2.132 3.450> < 7.418 0.418 5.269> }
	    triangle { < 7.380 3.478 0.422> < 7.861 1.423 2.341> < 6.885 3.473 1.935> }
	    triangle { < 8.257 0.184 3.505> < 7.533 2.132 3.450> < 7.861 1.423 2.341> }
	    triangle { < 6.577 3.765 3.085> < 6.885 3.473 1.935> < 7.533 2.132 3.450> }
	    triangle { < 7.861 1.423 2.341> < 7.533 2.132 3.450> < 6.885 3.473 1.935> }
	}

	bounded_by {
	    sphere { < 7.570 3.076 3.240> 4.735 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 6.390 6.380 0.060> < 6.571 5.201 1.591> < 6.133 6.536 0.918> }
	    triangle { < 6.577 3.765 3.085> < 6.037 5.184 2.620> < 6.571 5.201 1.591> }
	    triangle { < 5.864 6.628 1.916> < 6.133 6.536 0.918> < 6.037 5.184 2.620> }
	    triangle { < 6.571 5.201 1.591> < 6.037 5.184 2.620> < 6.133 6.536 0.918> }
	    triangle { < 6.300 0.000 6.420> < 5.690 1.547 5.881> < 6.150 1.780 5.009> }
	    triangle { < 5.177 2.636 5.478> < 5.907 3.148 4.386> < 5.690 1.547 5.881> }
	    triangle { < 6.577 3.765 3.085> < 6.150 1.780 5.009> < 5.907 3.148 4.386> }
	    triangle { < 5.690 1.547 5.881> < 5.907 3.148 4.386> < 6.150 1.780 5.009> }
	    triangle { < 4.480 6.380 4.560> < 5.417 6.803 3.426> < 4.446 4.763 5.211> }
	    triangle { < 5.864 6.628 1.916> < 5.671 4.783 3.505> < 5.417 6.803 3.426> }
	    triangle { < 5.177 2.636 5.478> < 4.446 4.763 5.211> < 5.671 4.783 3.505> }
	    triangle { < 5.417 6.803 3.426> < 5.671 4.783 3.505> < 4.446 4.763 5.211> }
	    triangle { < 6.577 3.765 3.085> < 5.907 3.148 4.386> < 6.037 5.184 2.620> }
	    triangle { < 5.177 2.636 5.478> < 5.671 4.783 3.505> < 5.907 3.148 4.386> }
	    triangle { < 5.864 6.628 1.916> < 6.037 5.184 2.620> < 5.671 4.783 3.505> }
	    triangle { < 5.907 3.148 4.386> < 5.671 4.783 3.505> < 6.037 5.184 2.620> }
	}

	bounded_by {
	    sphere { < 5.511 3.401 3.240> 4.723 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 8.990 0.000 0.080> < 8.024 -1.599 0.437> < 7.910 -1.420 1.602> }
	    triangle { < 7.405 -3.854 0.310> < 6.670 -3.811 1.530> < 8.024 -1.599 0.437> }
	    triangle { < 6.307 -3.776 3.044> < 7.910 -1.420 1.602> < 6.670 -3.811 1.530> }
	    triangle { < 8.024 -1.599 0.437> < 6.670 -3.811 1.530> < 7.910 -1.420 1.602> }
	    triangle { < 6.390 -6.380 0.060> < 6.032 -6.294 1.476> < 6.648 -4.933 0.334> }
	    triangle { < 5.645 -5.968 2.781> < 6.453 -4.666 1.457> < 6.032 -6.294 1.476> }
	    triangle { < 7.405 -3.854 0.310> < 6.648 -4.933 0.334> < 6.453 -4.666 1.457> }
	    triangle { < 6.032 -6.294 1.476> < 6.453 -4.666 1.457> < 6.648 -4.933 0.334> }
	    triangle { < 4.480 -6.380 4.560> < 5.253 -4.731 4.098> < 5.273 -6.200 3.781> }
	    triangle { < 6.307 -3.776 3.044> < 6.107 -4.913 2.933> < 5.253 -4.731 4.098> }
	    triangle { < 5.645 -5.968 2.781> < 5.273 -6.200 3.781> < 6.107 -4.913 2.933> }
	    triangle { < 5.253 -4.731 4.098> < 6.107 -4.913 2.933> < 5.273 -6.200 3.781> }
	    triangle { < 7.405 -3.854 0.310> < 6.453 -4.666 1.457> < 6.670 -3.811 1.530> }
	    triangle { < 5.645 -5.968 2.781> < 6.107 -4.913 2.933> < 6.453 -4.666 1.457> }
	    triangle { < 6.307 -3.776 3.044> < 6.670 -3.811 1.530> < 6.107 -4.913 2.933> }
	    triangle { < 6.453 -4.666 1.457> < 6.107 -4.913 2.933> < 6.670 -3.811 1.530> }
	}

	bounded_by {
	    sphere { < 6.735 -3.190 2.310> 4.508 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 8.990 0.000 0.080> < 7.910 -1.420 1.602> < 8.596 -0.229 1.889> }
	    triangle { < 6.307 -3.776 3.044> < 6.947 -1.591 3.195> < 7.910 -1.420 1.602> }
	    triangle { < 8.257 0.184 3.505> < 8.596 -0.229 1.889> < 6.947 -1.591 3.195> }
	    triangle { < 7.910 -1.420 1.602> < 6.947 -1.591 3.195> < 8.596 -0.229 1.889> }
	    triangle { < 4.480 -6.380 4.560> < 5.000 -4.781 5.040> < 5.253 -4.731 4.098> }
	    triangle { < 5.067 -3.049 5.163> < 5.826 -3.634 4.263> < 5.000 -4.781 5.040> }
	    triangle { < 6.307 -3.776 3.044> < 5.253 -4.731 4.098> < 5.826 -3.634 4.263> }
	    triangle { < 5.000 -4.781 5.040> < 5.826 -3.634 4.263> < 5.253 -4.731 4.098> }
	    triangle { < 6.300 0.000 6.420> < 7.418 0.418 5.269> < 5.750 -1.382 5.443> }
	    triangle { < 8.257 0.184 3.505> < 7.004 -1.412 4.498> < 7.418 0.418 5.269> }
	    triangle { < 5.067 -3.049 5.163> < 5.750 -1.382 5.443> < 7.004 -1.412 4.498> }
	    triangle { < 7.418 0.418 5.269> < 7.004 -1.412 4.498> < 5.750 -1.382 5.443> }
	    triangle { < 6.307 -3.776 3.044> < 5.826 -3.634 4.263> < 6.947 -1.591 3.195> }
	    triangle { < 5.067 -3.049 5.163> < 7.004 -1.412 4.498> < 5.826 -3.634 4.263> }
	    triangle { < 8.257 0.184 3.505> < 6.947 -1.591 3.195> < 7.004 -1.412 4.498> }
	    triangle { < 5.826 -3.634 4.263> < 7.004 -1.412 4.498> < 6.947 -1.591 3.195> }
	}

	bounded_by {
	    sphere { < 6.735 -2.981 3.250> 4.901 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 6.390 -6.380 0.060> < 5.097 -6.604 0.187> < 6.032 -6.294 1.476> }
	    triangle { < 3.335 -7.381 0.138> < 4.371 -6.930 1.631> < 5.097 -6.604 0.187> }
	    triangle { < 5.645 -5.968 2.781> < 6.032 -6.294 1.476> < 4.371 -6.930 1.631> }
	    triangle { < 5.097 -6.604 0.187> < 4.371 -6.930 1.631> < 6.032 -6.294 1.476> }
	    triangle { < 0.000 -8.800 0.000> < 1.079 -8.382 1.359> < 1.920 -7.955 -0.046> }
	    triangle { < 1.612 -7.643 2.286> < 2.413 -7.433 1.248> < 1.079 -8.382 1.359> }
	    triangle { < 3.335 -7.381 0.138> < 1.920 -7.955 -0.046> < 2.413 -7.433 1.248> }
	    triangle { < 1.079 -8.382 1.359> < 2.413 -7.433 1.248> < 1.920 -7.955 -0.046> }
	    triangle { < 4.480 -6.380 4.560> < 5.273 -6.200 3.781> < 2.798 -6.947 3.672> }
	    triangle { < 5.645 -5.968 2.781> < 3.673 -6.710 2.233> < 5.273 -6.200 3.781> }
	    triangle { < 1.612 -7.643 2.286> < 2.798 -6.947 3.672> < 3.673 -6.710 2.233> }
	    triangle { < 5.273 -6.200 3.781> < 3.673 -6.710 2.233> < 2.798 -6.947 3.672> }
	    triangle { < 3.335 -7.381 0.138> < 2.413 -7.433 1.248> < 4.371 -6.930 1.631> }
	    triangle { < 1.612 -7.643 2.286> < 3.673 -6.710 2.233> < 2.413 -7.433 1.248> }
	    triangle { < 5.645 -5.968 2.781> < 4.371 -6.930 1.631> < 3.673 -6.710 2.233> }
	    triangle { < 2.413 -7.433 1.248> < 3.673 -6.710 2.233> < 4.371 -6.930 1.631> }
	}

	bounded_by {
	    sphere { < 3.195 -7.384 2.257> 4.160 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 0.000 8.800 0.000> < 1.067 8.197 1.281> <-0.032 8.400 1.914> }
	    triangle { < 2.221 7.306 2.418> < 0.883 7.241 3.009> < 1.067 8.197 1.281> }
	    triangle { <-0.144 7.531 3.613> <-0.032 8.400 1.914> < 0.883 7.241 3.009> }
	    triangle { < 1.067 8.197 1.281> < 0.883 7.241 3.009> <-0.032 8.400 1.914> }
	    triangle { < 4.480 6.380 4.560> < 3.608 6.345 4.804> < 3.133 6.643 3.270> }
	    triangle { < 2.670 6.515 5.031> < 2.534 6.987 3.625> < 3.608 6.345 4.804> }
	    triangle { < 2.221 7.306 2.418> < 3.133 6.643 3.270> < 2.534 6.987 3.625> }
	    triangle { < 3.608 6.345 4.804> < 2.534 6.987 3.625> < 3.133 6.643 3.270> }
	    triangle { <-0.050 6.380 6.390> <-0.218 6.984 4.734> < 1.127 6.613 5.979> }
	    triangle { <-0.144 7.531 3.613> < 1.205 6.884 4.355> <-0.218 6.984 4.734> }
	    triangle { < 2.670 6.515 5.031> < 1.127 6.613 5.979> < 1.205 6.884 4.355> }
	    triangle { <-0.218 6.984 4.734> < 1.205 6.884 4.355> < 1.127 6.613 5.979> }
	    triangle { < 2.221 7.306 2.418> < 2.534 6.987 3.625> < 0.883 7.241 3.009> }
	    triangle { < 2.670 6.515 5.031> < 1.205 6.884 4.355> < 2.534 6.987 3.625> }
	    triangle { <-0.144 7.531 3.613> < 0.883 7.241 3.009> < 1.205 6.884 4.355> }
	    triangle { < 2.534 6.987 3.625> < 1.205 6.884 4.355> < 0.883 7.241 3.009> }
	}

	bounded_by {
	    sphere { < 2.131 7.572 3.195> 4.048 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 4.480 6.380 4.560> < 4.446 4.763 5.211> < 2.483 4.477 5.753> }
	    triangle { < 5.177 2.636 5.478> < 3.551 2.616 6.094> < 4.446 4.763 5.211> }
	    triangle { < 1.504 2.791 6.958> < 2.483 4.477 5.753> < 3.551 2.616 6.094> }
	    triangle { < 4.446 4.763 5.211> < 3.551 2.616 6.094> < 2.483 4.477 5.753> }
	    triangle { < 6.300 0.000 6.420> < 4.951 -0.235 7.183> < 5.690 1.547 5.881> }
	    triangle { < 3.258 -0.123 8.319> < 4.150 0.972 7.241> < 4.951 -0.235 7.183> }
	    triangle { < 5.177 2.636 5.478> < 5.690 1.547 5.881> < 4.150 0.972 7.241> }
	    triangle { < 4.951 -0.235 7.183> < 4.150 0.972 7.241> < 5.690 1.547 5.881> }
	    triangle { <-0.080 0.000 8.990> < 0.839 1.166 7.687> < 1.628 -0.251 8.767> }
	    triangle { < 1.504 2.791 6.958> < 2.490 1.244 7.938> < 0.839 1.166 7.687> }
	    triangle { < 3.258 -0.123 8.319> < 1.628 -0.251 8.767> < 2.490 1.244 7.938> }
	    triangle { < 0.839 1.166 7.687> < 2.490 1.244 7.938> < 1.628 -0.251 8.767> }
	    triangle { < 5.177 2.636 5.478> < 4.150 0.972 7.241> < 3.551 2.616 6.094> }
	    triangle { < 3.258 -0.123 8.319> < 2.490 1.244 7.938> < 4.150 0.972 7.241> }
	    triangle { < 1.504 2.791 6.958> < 3.551 2.616 6.094> < 2.490 1.244 7.938> }
	    triangle { < 4.150 0.972 7.241> < 2.490 1.244 7.938> < 3.551 2.616 6.094> }
	}

	bounded_by {
	    sphere { < 3.110 3.064 6.775> 4.947 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 4.480 6.380 4.560> < 2.483 4.477 5.753> < 3.608 6.345 4.804> }
	    triangle { < 1.504 2.791 6.958> < 2.479 4.339 5.733> < 2.483 4.477 5.753> }
	    triangle { < 2.670 6.515 5.031> < 3.608 6.345 4.804> < 2.479 4.339 5.733> }
	    triangle { < 2.483 4.477 5.753> < 2.479 4.339 5.733> < 3.608 6.345 4.804> }
	    triangle { <-0.080 0.000 8.990> <-0.238 1.399 7.809> < 0.839 1.166 7.687> }
	    triangle { <-0.431 3.465 7.316> < 0.369 3.249 7.048> <-0.238 1.399 7.809> }
	    triangle { < 1.504 2.791 6.958> < 0.839 1.166 7.687> < 0.369 3.249 7.048> }
	    triangle { <-0.238 1.399 7.809> < 0.369 3.249 7.048> < 0.839 1.166 7.687> }
	    triangle { <-0.050 6.380 6.390> < 1.127 6.613 5.979> <-0.154 4.994 6.826> }
	    triangle { < 2.670 6.515 5.031> < 0.853 4.853 6.635> < 1.127 6.613 5.979> }
	    triangle { <-0.431 3.465 7.316> <-0.154 4.994 6.826> < 0.853 4.853 6.635> }
	    triangle { < 1.127 6.613 5.979> < 0.853 4.853 6.635> <-0.154 4.994 6.826> }
	    triangle { < 1.504 2.791 6.958> < 0.369 3.249 7.048> < 2.479 4.339 5.733> }
	    triangle { <-0.431 3.465 7.316> < 0.853 4.853 6.635> < 0.369 3.249 7.048> }
	    triangle { < 2.670 6.515 5.031> < 2.479 4.339 5.733> < 0.853 4.853 6.635> }
	    triangle { < 0.369 3.249 7.048> < 0.853 4.853 6.635> < 2.479 4.339 5.733> }
	}

	bounded_by {
	    sphere { < 2.025 3.307 6.775> 4.515 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 6.300 0.000 6.420> < 5.750 -1.382 5.443> < 5.184 -2.087 6.547> }
	    triangle { < 5.067 -3.049 5.163> < 4.378 -3.346 5.799> < 5.750 -1.382 5.443> }
	    triangle { < 3.959 -3.381 6.651> < 5.184 -2.087 6.547> < 4.378 -3.346 5.799> }
	    triangle { < 5.750 -1.382 5.443> < 4.378 -3.346 5.799> < 5.184 -2.087 6.547> }
	    triangle { < 4.480 -6.380 4.560> < 3.515 -6.434 4.842> < 5.000 -4.781 5.040> }
	    triangle { < 2.336 -6.794 5.032> < 3.560 -5.355 4.871> < 3.515 -6.434 4.842> }
	    triangle { < 5.067 -3.049 5.163> < 5.000 -4.781 5.040> < 3.560 -5.355 4.871> }
	    triangle { < 3.515 -6.434 4.842> < 3.560 -5.355 4.871> < 5.000 -4.781 5.040> }
	    triangle { <-0.050 -6.380 6.390> < 2.027 -5.243 6.640> < 1.003 -6.519 5.520> }
	    triangle { < 3.959 -3.381 6.651> < 3.071 -4.975 5.825> < 2.027 -5.243 6.640> }
	    triangle { < 2.336 -6.794 5.032> < 1.003 -6.519 5.520> < 3.071 -4.975 5.825> }
	    triangle { < 2.027 -5.243 6.640> < 3.071 -4.975 5.825> < 1.003 -6.519 5.520> }
	    triangle { < 5.067 -3.049 5.163> < 3.560 -5.355 4.871> < 4.378 -3.346 5.799> }
	    triangle { < 2.336 -6.794 5.032> < 3.071 -4.975 5.825> < 3.560 -5.355 4.871> }
	    triangle { < 3.959 -3.381 6.651> < 4.378 -3.346 5.799> < 3.071 -4.975 5.825> }
	    triangle { < 3.560 -5.355 4.871> < 3.071 -4.975 5.825> < 4.378 -3.346 5.799> }
	}

	bounded_by {
	    sphere { < 3.125 -3.397 5.606> 4.721 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 6.300 0.000 6.420> < 5.184 -2.087 6.547> < 4.951 -0.235 7.183> }
	    triangle { < 3.959 -3.381 6.651> < 3.820 -1.743 7.243> < 5.184 -2.087 6.547> }
	    triangle { < 3.258 -0.123 8.319> < 4.951 -0.235 7.183> < 3.820 -1.743 7.243> }
	    triangle { < 5.184 -2.087 6.547> < 3.820 -1.743 7.243> < 4.951 -0.235 7.183> }
	    triangle { <-0.050 -6.380 6.390> < 0.034 -5.043 7.086> < 2.027 -5.243 6.640> }
	    triangle { <-0.293 -3.841 7.278> < 1.561 -3.874 6.817> < 0.034 -5.043 7.086> }
	    triangle { < 3.959 -3.381 6.651> < 2.027 -5.243 6.640> < 1.561 -3.874 6.817> }
	    triangle { < 0.034 -5.043 7.086> < 1.561 -3.874 6.817> < 2.027 -5.243 6.640> }
	    triangle { <-0.080 0.000 8.990> < 1.628 -0.251 8.767> <-0.313 -2.074 7.905> }
	    triangle { < 3.258 -0.123 8.319> < 1.668 -2.007 7.313> < 1.628 -0.251 8.767> }
	    triangle { <-0.293 -3.841 7.278> <-0.313 -2.074 7.905> < 1.668 -2.007 7.313> }
	    triangle { < 1.628 -0.251 8.767> < 1.668 -2.007 7.313> <-0.313 -2.074 7.905> }
	    triangle { < 3.959 -3.381 6.651> < 1.561 -3.874 6.817> < 3.820 -1.743 7.243> }
	    triangle { <-0.293 -3.841 7.278> < 1.668 -2.007 7.313> < 1.561 -3.874 6.817> }
	    triangle { < 3.258 -0.123 8.319> < 3.820 -1.743 7.243> < 1.668 -2.007 7.313> }
	    triangle { < 1.561 -3.874 6.817> < 1.668 -2.007 7.313> < 3.820 -1.743 7.243> }
	}

	bounded_by {
	    sphere { < 2.994 -3.190 7.690> 4.767 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 4.480 -6.380 4.560> < 2.798 -6.947 3.672> < 3.515 -6.434 4.842> }
	    triangle { < 1.612 -7.643 2.286> < 1.794 -7.371 3.810> < 2.798 -6.947 3.672> }
	    triangle { < 2.336 -6.794 5.032> < 3.515 -6.434 4.842> < 1.794 -7.371 3.810> }
	    triangle { < 2.798 -6.947 3.672> < 1.794 -7.371 3.810> < 3.515 -6.434 4.842> }
	    triangle { < 0.000 -8.800 0.000> <-0.495 -8.055 1.526> < 1.079 -8.382 1.359> }
	    triangle { <-0.524 -7.886 3.826> < 0.281 -7.554 2.811> <-0.495 -8.055 1.526> }
	    triangle { < 1.612 -7.643 2.286> < 1.079 -8.382 1.359> < 0.281 -7.554 2.811> }
	    triangle { <-0.495 -8.055 1.526> < 0.281 -7.554 2.811> < 1.079 -8.382 1.359> }
	    triangle { <-0.050 -6.380 6.390> < 1.003 -6.519 5.520> < 0.009 -7.427 5.228> }
	    triangle { < 2.336 -6.794 5.032> < 0.920 -7.134 4.304> < 1.003 -6.519 5.520> }
	    triangle { <-0.524 -7.886 3.826> < 0.009 -7.427 5.228> < 0.920 -7.134 4.304> }
	    triangle { < 1.003 -6.519 5.520> < 0.920 -7.134 4.304> < 0.009 -7.427 5.228> }
	    triangle { < 1.612 -7.643 2.286> < 0.281 -7.554 2.811> < 1.794 -7.371 3.810> }
	    triangle { <-0.524 -7.886 3.826> < 0.920 -7.134 4.304> < 0.281 -7.554 2.811> }
	    triangle { < 2.336 -6.794 5.032> < 1.794 -7.371 3.810> < 0.920 -7.134 4.304> }
	    triangle { < 0.281 -7.554 2.811> < 0.920 -7.134 4.304> < 1.794 -7.371 3.810> }
	}

	bounded_by {
	    sphere { < 1.978 -7.590 3.195> 3.973 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 0.000 8.800 0.000> <-0.032 8.400 1.914> <-0.947 8.189 1.170> }
	    triangle { <-0.144 7.531 3.613> <-1.310 7.267 2.544> <-0.032 8.400 1.914> }
	    triangle { <-2.153 7.403 1.739> <-0.947 8.189 1.170> <-1.310 7.267 2.544> }
	    triangle { <-0.032 8.400 1.914> <-1.310 7.267 2.544> <-0.947 8.189 1.170> }
	    triangle { <-0.050 6.380 6.390> <-1.650 6.683 5.880> <-0.218 6.984 4.734> }
	    triangle { <-2.783 6.467 5.819> <-1.628 6.666 4.486> <-1.650 6.683 5.880> }
	    triangle { <-0.144 7.531 3.613> <-0.218 6.984 4.734> <-1.628 6.666 4.486> }
	    triangle { <-1.650 6.683 5.880> <-1.628 6.666 4.486> <-0.218 6.984 4.734> }
	    triangle { <-4.560 6.380 4.480> <-3.526 7.162 3.114> <-3.550 6.641 4.947> }
	    triangle { <-2.153 7.403 1.739> <-2.271 6.968 3.817> <-3.526 7.162 3.114> }
	    triangle { <-2.783 6.467 5.819> <-3.550 6.641 4.947> <-2.271 6.968 3.817> }
	    triangle { <-3.526 7.162 3.114> <-2.271 6.968 3.817> <-3.550 6.641 4.947> }
	    triangle { <-0.144 7.531 3.613> <-1.628 6.666 4.486> <-1.310 7.267 2.544> }
	    triangle { <-2.783 6.467 5.819> <-2.271 6.968 3.817> <-1.628 6.666 4.486> }
	    triangle { <-2.153 7.403 1.739> <-1.310 7.267 2.544> <-2.271 6.968 3.817> }
	    triangle { <-1.628 6.666 4.486> <-2.271 6.968 3.817> <-1.310 7.267 2.544> }
	}

	bounded_by {
	    sphere { <-2.280 7.590 3.195> 4.107 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { <-0.050 6.380 6.390> <-0.154 4.994 6.826> <-1.680 4.878 6.198> }
	    triangle { <-0.431 3.465 7.316> <-1.509 3.466 6.802> <-0.154 4.994 6.826> }
	    triangle { <-2.810 3.635 6.099> <-1.680 4.878 6.198> <-1.509 3.466 6.802> }
	    triangle { <-0.154 4.994 6.826> <-1.509 3.466 6.802> <-1.680 4.878 6.198> }
	    triangle { <-0.080 0.000 8.990> <-1.365 0.380 8.177> <-0.238 1.399 7.809> }
	    triangle { <-2.591 0.229 7.752> <-1.864 1.984 7.918> <-1.365 0.380 8.177> }
	    triangle { <-0.431 3.465 7.316> <-0.238 1.399 7.809> <-1.864 1.984 7.918> }
	    triangle { <-1.365 0.380 8.177> <-1.864 1.984 7.918> <-0.238 1.399 7.809> }
	    triangle { <-6.410 0.000 6.300> <-4.393 2.096 5.924> <-4.554 0.448 6.642> }
	    triangle { <-2.810 3.635 6.099> <-2.540 2.161 6.748> <-4.393 2.096 5.924> }
	    triangle { <-2.591 0.229 7.752> <-4.554 0.448 6.642> <-2.540 2.161 6.748> }
	    triangle { <-4.393 2.096 5.924> <-2.540 2.161 6.748> <-4.554 0.448 6.642> }
	    triangle { <-0.431 3.465 7.316> <-1.864 1.984 7.918> <-1.509 3.466 6.802> }
	    triangle { <-2.591 0.229 7.752> <-2.540 2.161 6.748> <-1.864 1.984 7.918> }
	    triangle { <-2.810 3.635 6.099> <-1.509 3.466 6.802> <-2.540 2.161 6.748> }
	    triangle { <-1.864 1.984 7.918> <-2.540 2.161 6.748> <-1.509 3.466 6.802> }
	}

	bounded_by {
	    sphere { <-3.230 3.190 7.457> 4.738 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { <-0.050 6.380 6.390> <-1.680 4.878 6.198> <-1.650 6.683 5.880> }
	    triangle { <-2.810 3.635 6.099> <-2.895 4.769 5.692> <-1.680 4.878 6.198> }
	    triangle { <-2.783 6.467 5.819> <-1.650 6.683 5.880> <-2.895 4.769 5.692> }
	    triangle { <-1.680 4.878 6.198> <-2.895 4.769 5.692> <-1.650 6.683 5.880> }
	    triangle { <-6.410 0.000 6.300> <-6.078 1.670 5.591> <-4.393 2.096 5.924> }
	    triangle { <-5.155 2.719 5.273> <-4.208 3.363 5.506> <-6.078 1.670 5.591> }
	    triangle { <-2.810 3.635 6.099> <-4.393 2.096 5.924> <-4.208 3.363 5.506> }
	    triangle { <-6.078 1.670 5.591> <-4.208 3.363 5.506> <-4.393 2.096 5.924> }
	    triangle { <-4.560 6.380 4.480> <-3.550 6.641 4.947> <-4.606 4.661 4.625> }
	    triangle { <-2.783 6.467 5.819> <-3.844 4.553 5.429> <-3.550 6.641 4.947> }
	    triangle { <-5.155 2.719 5.273> <-4.606 4.661 4.625> <-3.844 4.553 5.429> }
	    triangle { <-3.550 6.641 4.947> <-3.844 4.553 5.429> <-4.606 4.661 4.625> }
	    triangle { <-2.810 3.635 6.099> <-4.208 3.363 5.506> <-2.895 4.769 5.692> }
	    triangle { <-5.155 2.719 5.273> <-3.844 4.553 5.429> <-4.208 3.363 5.506> }
	    triangle { <-2.783 6.467 5.819> <-2.895 4.769 5.692> <-3.844 4.553 5.429> }
	    triangle { <-4.208 3.363 5.506> <-3.844 4.553 5.429> <-2.895 4.769 5.692> }
	}

	bounded_by {
	    sphere { <-3.230 3.342 5.435> 4.693 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { <-0.080 0.000 8.990> <-0.313 -2.074 7.905> <-1.388 -1.740 7.604> }
	    triangle { <-0.293 -3.841 7.278> <-1.387 -3.613 7.100> <-0.313 -2.074 7.905> }
	    triangle { <-2.904 -3.896 6.799> <-1.388 -1.740 7.604> <-1.387 -3.613 7.100> }
	    triangle { <-0.313 -2.074 7.905> <-1.387 -3.613 7.100> <-1.388 -1.740 7.604> }
	    triangle { <-0.050 -6.380 6.390> <-1.342 -6.578 5.694> < 0.034 -5.043 7.086> }
	    triangle { <-2.188 -6.773 5.459> <-0.910 -5.412 6.147> <-1.342 -6.578 5.694> }
	    triangle { <-0.293 -3.841 7.278> < 0.034 -5.043 7.086> <-0.910 -5.412 6.147> }
	    triangle { <-1.342 -6.578 5.694> <-0.910 -5.412 6.147> < 0.034 -5.043 7.086> }
	    triangle { <-4.560 -6.380 4.480> <-3.423 -5.211 5.958> <-3.385 -6.341 4.786> }
	    triangle { <-2.904 -3.896 6.799> <-2.458 -5.236 5.979> <-3.423 -5.211 5.958> }
	    triangle { <-2.188 -6.773 5.459> <-3.385 -6.341 4.786> <-2.458 -5.236 5.979> }
	    triangle { <-3.423 -5.211 5.958> <-2.458 -5.236 5.979> <-3.385 -6.341 4.786> }
	    triangle { <-0.293 -3.841 7.278> <-0.910 -5.412 6.147> <-1.387 -3.613 7.100> }
	    triangle { <-2.188 -6.773 5.459> <-2.458 -5.236 5.979> <-0.910 -5.412 6.147> }
	    triangle { <-2.904 -3.896 6.799> <-1.387 -3.613 7.100> <-2.458 -5.236 5.979> }
	    triangle { <-0.910 -5.412 6.147> <-2.458 -5.236 5.979> <-1.387 -3.613 7.100> }
	}

	bounded_by {
	    sphere { <-2.263 -3.386 6.735> 4.617 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { <-0.080 0.000 8.990> <-1.388 -1.740 7.604> <-1.365 0.380 8.177> }
	    triangle { <-2.904 -3.896 6.799> <-2.783 -1.851 7.063> <-1.388 -1.740 7.604> }
	    triangle { <-2.591 0.229 7.752> <-1.365 0.380 8.177> <-2.783 -1.851 7.063> }
	    triangle { <-1.388 -1.740 7.604> <-2.783 -1.851 7.063> <-1.365 0.380 8.177> }
	    triangle { <-4.560 -6.380 4.480> <-4.948 -4.853 5.026> <-3.423 -5.211 5.958> }
	    triangle { <-4.973 -3.131 5.169> <-4.082 -3.332 6.077> <-4.948 -4.853 5.026> }
	    triangle { <-2.904 -3.896 6.799> <-3.423 -5.211 5.958> <-4.082 -3.332 6.077> }
	    triangle { <-4.948 -4.853 5.026> <-4.082 -3.332 6.077> <-3.423 -5.211 5.958> }
	    triangle { <-6.410 0.000 6.300> <-4.554 0.448 6.642> <-5.715 -1.694 5.974> }
	    triangle { <-2.591 0.229 7.752> <-3.907 -1.484 6.925> <-4.554 0.448 6.642> }
	    triangle { <-4.973 -3.131 5.169> <-5.715 -1.694 5.974> <-3.907 -1.484 6.925> }
	    triangle { <-4.554 0.448 6.642> <-3.907 -1.484 6.925> <-5.715 -1.694 5.974> }
	    triangle { <-2.904 -3.896 6.799> <-4.082 -3.332 6.077> <-2.783 -1.851 7.063> }
	    triangle { <-4.973 -3.131 5.169> <-3.907 -1.484 6.925> <-4.082 -3.332 6.077> }
	    triangle { <-2.591 0.229 7.752> <-2.783 -1.851 7.063> <-3.907 -1.484 6.925> }
	    triangle { <-4.082 -3.332 6.077> <-3.907 -1.484 6.925> <-2.783 -1.851 7.063> }
	}

	bounded_by {
	    sphere { <-3.245 -2.966 6.735> 4.889 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { <-0.050 -6.380 6.390> < 0.009 -7.427 5.228> <-1.342 -6.578 5.694> }
	    triangle { <-0.524 -7.886 3.826> <-1.189 -7.555 4.543> < 0.009 -7.427 5.228> }
	    triangle { <-2.188 -6.773 5.459> <-1.342 -6.578 5.694> <-1.189 -7.555 4.543> }
	    triangle { < 0.009 -7.427 5.228> <-1.189 -7.555 4.543> <-1.342 -6.578 5.694> }
	    triangle { < 0.000 -8.800 0.000> <-1.779 -8.600 1.470> <-0.495 -8.055 1.526> }
	    triangle { <-2.852 -7.866 2.388> <-1.902 -7.782 2.976> <-1.779 -8.600 1.470> }
	    triangle { <-0.524 -7.886 3.826> <-0.495 -8.055 1.526> <-1.902 -7.782 2.976> }
	    triangle { <-1.779 -8.600 1.470> <-1.902 -7.782 2.976> <-0.495 -8.055 1.526> }
	    triangle { <-4.560 -6.380 4.480> <-3.385 -6.341 4.786> <-3.808 -7.392 3.493> }
	    triangle { <-2.188 -6.773 5.459> <-2.785 -7.613 3.963> <-3.385 -6.341 4.786> }
	    triangle { <-2.852 -7.866 2.388> <-3.808 -7.392 3.493> <-2.785 -7.613 3.963> }
	    triangle { <-3.385 -6.341 4.786> <-2.785 -7.613 3.963> <-3.808 -7.392 3.493> }
	    triangle { <-0.524 -7.886 3.826> <-1.902 -7.782 2.976> <-1.189 -7.555 4.543> }
	    triangle { <-2.852 -7.866 2.388> <-2.785 -7.613 3.963> <-1.902 -7.782 2.976> }
	    triangle { <-2.188 -6.773 5.459> <-1.189 -7.555 4.543> <-2.785 -7.613 3.963> }
	    triangle { <-1.902 -7.782 2.976> <-2.785 -7.613 3.963> <-1.189 -7.555 4.543> }
	}

	bounded_by {
	    sphere { <-2.275 -7.571 3.195> 4.111 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 0.000 8.800 0.000> <-0.947 8.189 1.170> <-1.639 8.036 0.291> }
	    triangle { <-2.153 7.403 1.739> <-2.570 7.243 0.966> <-0.947 8.189 1.170> }
	    triangle { <-2.789 7.151 0.046> <-1.639 8.036 0.291> <-2.570 7.243 0.966> }
	    triangle { <-0.947 8.189 1.170> <-2.570 7.243 0.966> <-1.639 8.036 0.291> }
	    triangle { <-4.560 6.380 4.480> <-5.097 6.462 3.111> <-3.526 7.162 3.114> }
	    triangle { <-5.204 6.817 2.116> <-3.834 7.155 1.829> <-5.097 6.462 3.111> }
	    triangle { <-2.153 7.403 1.739> <-3.526 7.162 3.114> <-3.834 7.155 1.829> }
	    triangle { <-5.097 6.462 3.111> <-3.834 7.155 1.829> <-3.526 7.162 3.114> }
	    triangle { <-6.390 6.380 -0.050> <-4.690 6.772 -0.196> <-5.989 6.842 1.069> }
	    triangle { <-2.789 7.151 0.046> <-3.893 6.802 0.914> <-4.690 6.772 -0.196> }
	    triangle { <-5.204 6.817 2.116> <-5.989 6.842 1.069> <-3.893 6.802 0.914> }
	    triangle { <-4.690 6.772 -0.196> <-3.893 6.802 0.914> <-5.989 6.842 1.069> }
	    triangle { <-2.153 7.403 1.739> <-3.834 7.155 1.829> <-2.570 7.243 0.966> }
	    triangle { <-5.204 6.817 2.116> <-3.893 6.802 0.914> <-3.834 7.155 1.829> }
	    triangle { <-2.789 7.151 0.046> <-2.570 7.243 0.966> <-3.893 6.802 0.914> }
	    triangle { <-3.834 7.155 1.829> <-3.893 6.802 0.914> <-2.570 7.243 0.966> }
	}

	bounded_by {
	    sphere { <-3.195 7.590 2.142> 4.059 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { <-4.560 6.380 4.480> <-4.606 4.661 4.625> <-5.580 5.200 3.483> }
	    triangle { <-5.155 2.719 5.273> <-6.272 2.949 4.213> <-4.606 4.661 4.625> }
	    triangle { <-7.440 3.519 3.076> <-5.580 5.200 3.483> <-6.272 2.949 4.213> }
	    triangle { <-4.606 4.661 4.625> <-6.272 2.949 4.213> <-5.580 5.200 3.483> }
	    triangle { <-6.410 0.000 6.300> <-7.210 -0.162 4.867> <-6.078 1.670 5.591> }
	    triangle { <-8.129 -0.572 2.926> <-6.362 1.271 3.809> <-7.210 -0.162 4.867> }
	    triangle { <-5.155 2.719 5.273> <-6.078 1.670 5.591> <-6.362 1.271 3.809> }
	    triangle { <-7.210 -0.162 4.867> <-6.362 1.271 3.809> <-6.078 1.670 5.591> }
	    triangle { <-8.990 0.000 -0.070> <-8.522 1.830 1.985> <-8.430 -0.030 1.609> }
	    triangle { <-7.440 3.519 3.076> <-7.671 1.185 3.167> <-8.522 1.830 1.985> }
	    triangle { <-8.129 -0.572 2.926> <-8.430 -0.030 1.609> <-7.671 1.185 3.167> }
	    triangle { <-8.522 1.830 1.985> <-7.671 1.185 3.167> <-8.430 -0.030 1.609> }
	    triangle { <-5.155 2.719 5.273> <-6.362 1.271 3.809> <-6.272 2.949 4.213> }
	    triangle { <-8.129 -0.572 2.926> <-7.671 1.185 3.167> <-6.362 1.271 3.809> }
	    triangle { <-7.440 3.519 3.076> <-6.272 2.949 4.213> <-7.671 1.185 3.167> }
	    triangle { <-6.362 1.271 3.809> <-7.671 1.185 3.167> <-6.272 2.949 4.213> }
	}

	bounded_by {
	    sphere { <-6.775 2.904 3.115> 4.846 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { <-4.560 6.380 4.480> <-5.580 5.200 3.483> <-5.097 6.462 3.111> }
	    triangle { <-7.440 3.519 3.076> <-6.422 4.871 2.798> <-5.580 5.200 3.483> }
	    triangle { <-5.204 6.817 2.116> <-5.097 6.462 3.111> <-6.422 4.871 2.798> }
	    triangle { <-5.580 5.200 3.483> <-6.422 4.871 2.798> <-5.097 6.462 3.111> }
	    triangle { <-8.990 0.000 -0.070> <-8.241 2.189 0.434> <-8.522 1.830 1.985> }
	    triangle { <-7.734 3.675 0.385> <-7.709 3.475 1.687> <-8.241 2.189 0.434> }
	    triangle { <-7.440 3.519 3.076> <-8.522 1.830 1.985> <-7.709 3.475 1.687> }
	    triangle { <-8.241 2.189 0.434> <-7.709 3.475 1.687> <-8.522 1.830 1.985> }
	    triangle { <-6.390 6.380 -0.050> <-5.989 6.842 1.069> <-7.079 4.839 0.404> }
	    triangle { <-5.204 6.817 2.116> <-6.599 4.819 1.229> <-5.989 6.842 1.069> }
	    triangle { <-7.734 3.675 0.385> <-7.079 4.839 0.404> <-6.599 4.819 1.229> }
	    triangle { <-5.989 6.842 1.069> <-6.599 4.819 1.229> <-7.079 4.839 0.404> }
	    triangle { <-7.440 3.519 3.076> <-7.709 3.475 1.687> <-6.422 4.871 2.798> }
	    triangle { <-7.734 3.675 0.385> <-6.599 4.819 1.229> <-7.709 3.475 1.687> }
	    triangle { <-5.204 6.817 2.116> <-6.422 4.871 2.798> <-6.599 4.819 1.229> }
	    triangle { <-7.709 3.475 1.687> <-6.599 4.819 1.229> <-6.422 4.871 2.798> }
	}

	bounded_by {
	    sphere { <-6.775 3.421 2.205> 4.667 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { <-6.410 0.000 6.300> <-5.715 -1.694 5.974> <-6.619 -1.546 4.863> }
	    triangle { <-4.973 -3.131 5.169> <-6.066 -3.310 4.559> <-5.715 -1.694 5.974> }
	    triangle { <-7.187 -2.930 3.394> <-6.619 -1.546 4.863> <-6.066 -3.310 4.559> }
	    triangle { <-5.715 -1.694 5.974> <-6.066 -3.310 4.559> <-6.619 -1.546 4.863> }
	    triangle { <-4.560 -6.380 4.480> <-4.852 -6.436 3.267> <-4.948 -4.853 5.026> }
	    triangle { <-5.128 -6.145 1.744> <-4.620 -4.321 3.407> <-4.852 -6.436 3.267> }
	    triangle { <-4.973 -3.131 5.169> <-4.948 -4.853 5.026> <-4.620 -4.321 3.407> }
	    triangle { <-4.852 -6.436 3.267> <-4.620 -4.321 3.407> <-4.948 -4.853 5.026> }
	    triangle { <-6.390 -6.380 -0.050> <-6.931 -4.358 2.044> <-5.973 -6.121 1.052> }
	    triangle { <-7.187 -2.930 3.394> <-5.743 -4.602 2.777> <-6.931 -4.358 2.044> }
	    triangle { <-5.128 -6.145 1.744> <-5.973 -6.121 1.052> <-5.743 -4.602 2.777> }
	    triangle { <-6.931 -4.358 2.044> <-5.743 -4.602 2.777> <-5.973 -6.121 1.052> }
	    triangle { <-4.973 -3.131 5.169> <-4.620 -4.321 3.407> <-6.066 -3.310 4.559> }
	    triangle { <-5.128 -6.145 1.744> <-5.743 -4.602 2.777> <-4.620 -4.321 3.407> }
	    triangle { <-7.187 -2.930 3.394> <-6.066 -3.310 4.559> <-5.743 -4.602 2.777> }
	    triangle { <-4.620 -4.321 3.407> <-5.743 -4.602 2.777> <-6.066 -3.310 4.559> }
	}

	bounded_by {
	    sphere { <-5.874 -3.218 3.125> 4.552 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { <-6.410 0.000 6.300> <-6.619 -1.546 4.863> <-7.210 -0.162 4.867> }
	    triangle { <-7.187 -2.930 3.394> <-7.571 -1.566 3.405> <-6.619 -1.546 4.863> }
	    triangle { <-8.129 -0.572 2.926> <-7.210 -0.162 4.867> <-7.571 -1.566 3.405> }
	    triangle { <-6.619 -1.546 4.863> <-7.571 -1.566 3.405> <-7.210 -0.162 4.867> }
	    triangle { <-6.390 -6.380 -0.050> <-6.914 -4.356 0.593> <-6.931 -4.358 2.044> }
	    triangle { <-8.182 -2.710 0.535> <-7.617 -2.847 2.022> <-6.914 -4.356 0.593> }
	    triangle { <-7.187 -2.930 3.394> <-6.931 -4.358 2.044> <-7.617 -2.847 2.022> }
	    triangle { <-6.914 -4.356 0.593> <-7.617 -2.847 2.022> <-6.931 -4.358 2.044> }
	    triangle { <-8.990 0.000 -0.070> <-8.430 -0.030 1.609> <-8.369 -1.640 -0.000> }
	    triangle { <-8.129 -0.572 2.926> <-7.971 -1.457 1.413> <-8.430 -0.030 1.609> }
	    triangle { <-8.182 -2.710 0.535> <-8.369 -1.640 -0.000> <-7.971 -1.457 1.413> }
	    triangle { <-8.430 -0.030 1.609> <-7.971 -1.457 1.413> <-8.369 -1.640 -0.000> }
	    triangle { <-7.187 -2.930 3.394> <-7.617 -2.847 2.022> <-7.571 -1.566 3.405> }
	    triangle { <-8.182 -2.710 0.535> <-7.971 -1.457 1.413> <-7.617 -2.847 2.022> }
	    triangle { <-8.129 -0.572 2.926> <-7.571 -1.566 3.405> <-7.971 -1.457 1.413> }
	    triangle { <-7.617 -2.847 2.022> <-7.971 -1.457 1.413> <-7.571 -1.566 3.405> }
	}

	bounded_by {
	    sphere { <-7.690 -3.190 3.115> 4.692 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { <-4.560 -6.380 4.480> <-3.808 -7.392 3.493> <-4.852 -6.436 3.267> }
	    triangle { <-2.852 -7.866 2.388> <-4.108 -7.047 2.084> <-3.808 -7.392 3.493> }
	    triangle { <-5.128 -6.145 1.744> <-4.852 -6.436 3.267> <-4.108 -7.047 2.084> }
	    triangle { <-3.808 -7.392 3.493> <-4.108 -7.047 2.084> <-4.852 -6.436 3.267> }
	    triangle { < 0.000 -8.800 0.000> <-1.478 -8.155 0.074> <-1.779 -8.600 1.470> }
	    triangle { <-2.708 -7.596 0.012> <-2.605 -7.665 1.292> <-1.478 -8.155 0.074> }
	    triangle { <-2.852 -7.866 2.388> <-1.779 -8.600 1.470> <-2.605 -7.665 1.292> }
	    triangle { <-1.478 -8.155 0.074> <-2.605 -7.665 1.292> <-1.779 -8.600 1.470> }
	    triangle { <-6.390 -6.380 -0.050> <-5.973 -6.121 1.052> <-4.425 -7.366 -0.101> }
	    triangle { <-5.128 -6.145 1.744> <-4.062 -6.554 0.952> <-5.973 -6.121 1.052> }
	    triangle { <-2.708 -7.596 0.012> <-4.425 -7.366 -0.101> <-4.062 -6.554 0.952> }
	    triangle { <-5.973 -6.121 1.052> <-4.062 -6.554 0.952> <-4.425 -7.366 -0.101> }
	    triangle { <-2.852 -7.866 2.388> <-2.605 -7.665 1.292> <-4.108 -7.047 2.084> }
	    triangle { <-2.708 -7.596 0.012> <-4.062 -6.554 0.952> <-2.605 -7.665 1.292> }
	    triangle { <-5.128 -6.145 1.744> <-4.108 -7.047 2.084> <-4.062 -6.554 0.952> }
	    triangle { <-2.605 -7.665 1.292> <-4.062 -6.554 0.952> <-4.108 -7.047 2.084> }
	}

	bounded_by {
	    sphere { <-3.195 -7.460 2.189> 4.098 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 0.000 8.800 0.000> <-1.639 8.036 0.291> <-0.928 8.173 -1.390> }
	    triangle { <-2.789 7.151 0.046> <-2.391 7.032 -1.185> <-1.639 8.036 0.291> }
	    triangle { <-2.259 7.306 -2.142> <-0.928 8.173 -1.390> <-2.391 7.032 -1.185> }
	    triangle { <-1.639 8.036 0.291> <-2.391 7.032 -1.185> <-0.928 8.173 -1.390> }
	    triangle { <-6.390 6.380 -0.050> <-6.126 6.183 -1.091> <-4.690 6.772 -0.196> }
	    triangle { <-5.653 6.422 -2.114> <-4.415 6.728 -0.805> <-6.126 6.183 -1.091> }
	    triangle { <-2.789 7.151 0.046> <-4.690 6.772 -0.196> <-4.415 6.728 -0.805> }
	    triangle { <-6.126 6.183 -1.091> <-4.415 6.728 -0.805> <-4.690 6.772 -0.196> }
	    triangle { <-4.480 6.380 -4.560> <-3.083 6.582 -3.122> <-5.274 6.468 -3.593> }
	    triangle { <-2.259 7.306 -2.142> <-4.180 6.827 -1.921> <-3.083 6.582 -3.122> }
	    triangle { <-5.653 6.422 -2.114> <-5.274 6.468 -3.593> <-4.180 6.827 -1.921> }
	    triangle { <-3.083 6.582 -3.122> <-4.180 6.827 -1.921> <-5.274 6.468 -3.593> }
	    triangle { <-2.789 7.151 0.046> <-4.415 6.728 -0.805> <-2.391 7.032 -1.185> }
	    triangle { <-5.653 6.422 -2.114> <-4.180 6.827 -1.921> <-4.415 6.728 -0.805> }
	    triangle { <-2.259 7.306 -2.142> <-2.391 7.032 -1.185> <-4.180 6.827 -1.921> }
	    triangle { <-4.415 6.728 -0.805> <-4.180 6.827 -1.921> <-2.391 7.032 -1.185> }
	}

	bounded_by {
	    sphere { <-3.195 7.491 -2.135> 4.059 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { <-6.390 6.380 -0.050> <-7.079 4.839 0.404> <-6.161 4.909 -1.232> }
	    triangle { <-7.734 3.675 0.385> <-6.749 3.642 -1.527> <-7.079 4.839 0.404> }
	    triangle { <-5.525 3.633 -2.810> <-6.161 4.909 -1.232> <-6.749 3.642 -1.527> }
	    triangle { <-7.079 4.839 0.404> <-6.749 3.642 -1.527> <-6.161 4.909 -1.232> }
	    triangle { <-8.990 0.000 -0.070> <-8.697 0.197 -1.436> <-8.241 2.189 0.434> }
	    triangle { <-8.336 0.654 -2.824> <-8.368 2.115 -1.176> <-8.697 0.197 -1.436> }
	    triangle { <-7.734 3.675 0.385> <-8.241 2.189 0.434> <-8.368 2.115 -1.176> }
	    triangle { <-8.697 0.197 -1.436> <-8.368 2.115 -1.176> <-8.241 2.189 0.434> }
	    triangle { <-6.310 0.000 -6.410> <-5.463 1.943 -4.881> <-7.449 0.061 -5.028> }
	    triangle { <-5.525 3.633 -2.810> <-6.992 2.439 -2.571> <-5.463 1.943 -4.881> }
	    triangle { <-8.336 0.654 -2.824> <-7.449 0.061 -5.028> <-6.992 2.439 -2.571> }
	    triangle { <-5.463 1.943 -4.881> <-6.992 2.439 -2.571> <-7.449 0.061 -5.028> }
	    triangle { <-7.734 3.675 0.385> <-8.368 2.115 -1.176> <-6.749 3.642 -1.527> }
	    triangle { <-8.336 0.654 -2.824> <-6.992 2.439 -2.571> <-8.368 2.115 -1.176> }
	    triangle { <-5.525 3.633 -2.810> <-6.749 3.642 -1.527> <-6.992 2.439 -2.571> }
	    triangle { <-8.368 2.115 -1.176> <-6.992 2.439 -2.571> <-6.749 3.642 -1.527> }
	}

	bounded_by {
	    sphere { <-7.226 3.190 -2.988> 4.767 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { <-6.390 6.380 -0.050> <-6.161 4.909 -1.232> <-6.126 6.183 -1.091> }
	    triangle { <-5.525 3.633 -2.810> <-5.537 4.825 -2.201> <-6.161 4.909 -1.232> }
	    triangle { <-5.653 6.422 -2.114> <-6.126 6.183 -1.091> <-5.537 4.825 -2.201> }
	    triangle { <-6.161 4.909 -1.232> <-5.537 4.825 -2.201> <-6.126 6.183 -1.091> }
	    triangle { <-6.310 0.000 -6.410> <-5.580 1.215 -6.070> <-5.463 1.943 -4.881> }
	    triangle { <-4.902 2.873 -5.892> <-5.361 3.088 -4.028> <-5.580 1.215 -6.070> }
	    triangle { <-5.525 3.633 -2.810> <-5.463 1.943 -4.881> <-5.361 3.088 -4.028> }
	    triangle { <-5.580 1.215 -6.070> <-5.361 3.088 -4.028> <-5.463 1.943 -4.881> }
	    triangle { <-4.480 6.380 -4.560> <-5.274 6.468 -3.593> <-4.900 4.872 -5.432> }
	    triangle { <-5.653 6.422 -2.114> <-5.625 4.443 -3.780> <-5.274 6.468 -3.593> }
	    triangle { <-4.902 2.873 -5.892> <-4.900 4.872 -5.432> <-5.625 4.443 -3.780> }
	    triangle { <-5.274 6.468 -3.593> <-5.625 4.443 -3.780> <-4.900 4.872 -5.432> }
	    triangle { <-5.525 3.633 -2.810> <-5.361 3.088 -4.028> <-5.537 4.825 -2.201> }
	    triangle { <-4.902 2.873 -5.892> <-5.625 4.443 -3.780> <-5.361 3.088 -4.028> }
	    triangle { <-5.653 6.422 -2.114> <-5.537 4.825 -2.201> <-5.625 4.443 -3.780> }
	    triangle { <-5.361 3.088 -4.028> <-5.625 4.443 -3.780> <-5.537 4.825 -2.201> }
	}

	bounded_by {
	    sphere { <-5.435 3.234 -3.230> 4.619 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { <-8.990 0.000 -0.070> <-8.369 -1.640 -0.000> <-7.804 -1.455 -1.577> }
	    triangle { <-8.182 -2.710 0.535> <-7.562 -2.465 -1.061> <-8.369 -1.640 -0.000> }
	    triangle { <-6.611 -2.318 -2.304> <-7.804 -1.455 -1.577> <-7.562 -2.465 -1.061> }
	    triangle { <-8.369 -1.640 -0.000> <-7.562 -2.465 -1.061> <-7.804 -1.455 -1.577> }
	    triangle { <-6.390 -6.380 -0.050> <-5.960 -6.658 -1.338> <-6.914 -4.356 0.593> }
	    triangle { <-5.556 -6.741 -2.418> <-6.593 -4.326 -1.450> <-5.960 -6.658 -1.338> }
	    triangle { <-8.182 -2.710 0.535> <-6.914 -4.356 0.593> <-6.593 -4.326 -1.450> }
	    triangle { <-5.960 -6.658 -1.338> <-6.593 -4.326 -1.450> <-6.914 -4.356 0.593> }
	    triangle { <-4.480 -6.380 -4.560> <-5.280 -3.915 -3.198> <-4.908 -6.767 -3.443> }
	    triangle { <-6.611 -2.318 -2.304> <-6.091 -4.145 -2.082> <-5.280 -3.915 -3.198> }
	    triangle { <-5.556 -6.741 -2.418> <-4.908 -6.767 -3.443> <-6.091 -4.145 -2.082> }
	    triangle { <-5.280 -3.915 -3.198> <-6.091 -4.145 -2.082> <-4.908 -6.767 -3.443> }
	    triangle { <-8.182 -2.710 0.535> <-6.593 -4.326 -1.450> <-7.562 -2.465 -1.061> }
	    triangle { <-5.556 -6.741 -2.418> <-6.091 -4.145 -2.082> <-6.593 -4.326 -1.450> }
	    triangle { <-6.611 -2.318 -2.304> <-7.562 -2.465 -1.061> <-6.091 -4.145 -2.082> }
	    triangle { <-6.593 -4.326 -1.450> <-6.091 -4.145 -2.082> <-7.562 -2.465 -1.061> }
	}

	bounded_by {
	    sphere { <-6.735 -3.383 -1.984> 4.550 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { <-8.990 0.000 -0.070> <-7.804 -1.455 -1.577> <-8.697 0.197 -1.436> }
	    triangle { <-6.611 -2.318 -2.304> <-7.482 -0.964 -2.569> <-7.804 -1.455 -1.577> }
	    triangle { <-8.336 0.654 -2.824> <-8.697 0.197 -1.436> <-7.482 -0.964 -2.569> }
	    triangle { <-7.804 -1.455 -1.577> <-7.482 -0.964 -2.569> <-8.697 0.197 -1.436> }
	    triangle { <-4.480 -6.380 -4.560> <-4.845 -4.951 -5.157> <-5.280 -3.915 -3.198> }
	    triangle { <-5.104 -3.249 -5.863> <-6.076 -2.643 -3.795> <-4.845 -4.951 -5.157> }
	    triangle { <-6.611 -2.318 -2.304> <-5.280 -3.915 -3.198> <-6.076 -2.643 -3.795> }
	    triangle { <-4.845 -4.951 -5.157> <-6.076 -2.643 -3.795> <-5.280 -3.915 -3.198> }
	    triangle { <-6.310 0.000 -6.410> <-7.449 0.061 -5.028> <-5.442 -1.683 -5.955> }
	    triangle { <-8.336 0.654 -2.824> <-7.206 -1.086 -4.196> <-7.449 0.061 -5.028> }
	    triangle { <-5.104 -3.249 -5.863> <-5.442 -1.683 -5.955> <-7.206 -1.086 -4.196> }
	    triangle { <-7.449 0.061 -5.028> <-7.206 -1.086 -4.196> <-5.442 -1.683 -5.955> }
	    triangle { <-6.611 -2.318 -2.304> <-6.076 -2.643 -3.795> <-7.482 -0.964 -2.569> }
	    triangle { <-5.104 -3.249 -5.863> <-7.206 -1.086 -4.196> <-6.076 -2.643 -3.795> }
	    triangle { <-8.336 0.654 -2.824> <-7.482 -0.964 -2.569> <-7.206 -1.086 -4.196> }
	    triangle { <-6.076 -2.643 -3.795> <-7.206 -1.086 -4.196> <-7.482 -0.964 -2.569> }
	}

	bounded_by {
	    sphere { <-6.735 -2.863 -3.240> 4.830 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { <-6.390 -6.380 -0.050> <-4.425 -7.366 -0.101> <-5.960 -6.658 -1.338> }
	    triangle { <-2.708 -7.596 0.012> <-4.323 -7.181 -0.932> <-4.425 -7.366 -0.101> }
	    triangle { <-5.556 -6.741 -2.418> <-5.960 -6.658 -1.338> <-4.323 -7.181 -0.932> }
	    triangle { <-4.425 -7.366 -0.101> <-4.323 -7.181 -0.932> <-5.960 -6.658 -1.338> }
	    triangle { < 0.000 -8.800 0.000> <-1.116 -7.958 -1.516> <-1.478 -8.155 0.074> }
	    triangle { <-2.868 -7.643 -2.274> <-2.759 -7.423 -1.349> <-1.116 -7.958 -1.516> }
	    triangle { <-2.708 -7.596 0.012> <-1.478 -8.155 0.074> <-2.759 -7.423 -1.349> }
	    triangle { <-1.116 -7.958 -1.516> <-2.759 -7.423 -1.349> <-1.478 -8.155 0.074> }
	    triangle { <-4.480 -6.380 -4.560> <-4.908 -6.767 -3.443> <-3.617 -7.070 -3.296> }
	    triangle { <-5.556 -6.741 -2.418> <-4.223 -7.469 -2.288> <-4.908 -6.767 -3.443> }
	    triangle { <-2.868 -7.643 -2.274> <-3.617 -7.070 -3.296> <-4.223 -7.469 -2.288> }
	    triangle { <-4.908 -6.767 -3.443> <-4.223 -7.469 -2.288> <-3.617 -7.070 -3.296> }
	    triangle { <-2.708 -7.596 0.012> <-2.759 -7.423 -1.349> <-4.323 -7.181 -0.932> }
	    triangle { <-2.868 -7.643 -2.274> <-4.223 -7.469 -2.288> <-2.759 -7.423 -1.349> }
	    triangle { <-5.556 -6.741 -2.418> <-4.323 -7.181 -0.932> <-4.223 -7.469 -2.288> }
	    triangle { <-2.759 -7.423 -1.349> <-4.223 -7.469 -2.288> <-4.323 -7.181 -0.932> }
	}

	bounded_by {
	    sphere { <-3.195 -7.590 -2.243> 4.087 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 0.000 8.800 0.000> <-0.928 8.173 -1.390> <-0.430 8.407 -2.147> }
	    triangle { <-2.259 7.306 -2.142> <-1.057 7.465 -2.916> <-0.928 8.173 -1.390> }
	    triangle { <-0.345 7.684 -3.638> <-0.430 8.407 -2.147> <-1.057 7.465 -2.916> }
	    triangle { <-0.928 8.173 -1.390> <-1.057 7.465 -2.916> <-0.430 8.407 -2.147> }
	    triangle { <-4.480 6.380 -4.560> <-2.962 6.103 -5.178> <-3.083 6.582 -3.122> }
	    triangle { <-1.959 5.899 -5.805> <-2.017 6.489 -4.090> <-2.962 6.103 -5.178> }
	    triangle { <-2.259 7.306 -2.142> <-3.083 6.582 -3.122> <-2.017 6.489 -4.090> }
	    triangle { <-2.962 6.103 -5.178> <-2.017 6.489 -4.090> <-3.083 6.582 -3.122> }
	    triangle { < 0.040 6.380 -6.390> <-0.356 7.139 -4.941> <-1.151 6.316 -6.213> }
	    triangle { <-0.345 7.684 -3.638> <-1.353 6.838 -4.533> <-0.356 7.139 -4.941> }
	    triangle { <-1.959 5.899 -5.805> <-1.151 6.316 -6.213> <-1.353 6.838 -4.533> }
	    triangle { <-0.356 7.139 -4.941> <-1.353 6.838 -4.533> <-1.151 6.316 -6.213> }
	    triangle { <-2.259 7.306 -2.142> <-2.017 6.489 -4.090> <-1.057 7.465 -2.916> }
	    triangle { <-1.959 5.899 -5.805> <-1.353 6.838 -4.533> <-2.017 6.489 -4.090> }
	    triangle { <-0.345 7.684 -3.638> <-1.057 7.465 -2.916> <-1.353 6.838 -4.533> }
	    triangle { <-2.017 6.489 -4.090> <-1.353 6.838 -4.533> <-1.057 7.465 -2.916> }
	}

	bounded_by {
	    sphere { <-2.220 7.350 -3.195> 4.152 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { <-4.480 6.380 -4.560> <-4.900 4.872 -5.432> <-3.215 4.109 -5.575> }
	    triangle { <-4.902 2.873 -5.892> <-3.419 2.427 -6.629> <-4.900 4.872 -5.432> }
	    triangle { <-2.411 2.483 -7.293> <-3.215 4.109 -5.575> <-3.419 2.427 -6.629> }
	    triangle { <-4.900 4.872 -5.432> <-3.419 2.427 -6.629> <-3.215 4.109 -5.575> }
	    triangle { <-6.310 0.000 -6.410> <-4.637 -0.193 -7.579> <-5.580 1.215 -6.070> }
	    triangle { <-3.302 -0.439 -8.114> <-4.210 1.259 -7.176> <-4.637 -0.193 -7.579> }
	    triangle { <-4.902 2.873 -5.892> <-5.580 1.215 -6.070> <-4.210 1.259 -7.176> }
	    triangle { <-4.637 -0.193 -7.579> <-4.210 1.259 -7.176> <-5.580 1.215 -6.070> }
	    triangle { < 0.060 0.000 -8.990> <-1.304 1.564 -8.500> <-1.711 0.064 -8.566> }
	    triangle { <-2.411 2.483 -7.293> <-2.981 1.184 -7.854> <-1.304 1.564 -8.500> }
	    triangle { <-3.302 -0.439 -8.114> <-1.711 0.064 -8.566> <-2.981 1.184 -7.854> }
	    triangle { <-1.304 1.564 -8.500> <-2.981 1.184 -7.854> <-1.711 0.064 -8.566> }
	    triangle { <-4.902 2.873 -5.892> <-4.210 1.259 -7.176> <-3.419 2.427 -6.629> }
	    triangle { <-3.302 -0.439 -8.114> <-2.981 1.184 -7.854> <-4.210 1.259 -7.176> }
	    triangle { <-2.411 2.483 -7.293> <-3.419 2.427 -6.629> <-2.981 1.184 -7.854> }
	    triangle { <-4.210 1.259 -7.176> <-2.981 1.184 -7.854> <-3.419 2.427 -6.629> }
	}

	bounded_by {
	    sphere { <-3.125 2.970 -6.775> 4.886 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { <-4.480 6.380 -4.560> <-3.215 4.109 -5.575> <-2.962 6.103 -5.178> }
	    triangle { <-2.411 2.483 -7.293> <-2.062 4.389 -6.625> <-3.215 4.109 -5.575> }
	    triangle { <-1.959 5.899 -5.805> <-2.962 6.103 -5.178> <-2.062 4.389 -6.625> }
	    triangle { <-3.215 4.109 -5.575> <-2.062 4.389 -6.625> <-2.962 6.103 -5.178> }
	    triangle { < 0.060 0.000 -8.990> < 0.601 1.541 -8.499> <-1.304 1.564 -8.500> }
	    triangle { < 0.674 2.849 -7.347> <-0.665 2.543 -7.171> < 0.601 1.541 -8.499> }
	    triangle { <-2.411 2.483 -7.293> <-1.304 1.564 -8.500> <-0.665 2.543 -7.171> }
	    triangle { < 0.601 1.541 -8.499> <-0.665 2.543 -7.171> <-1.304 1.564 -8.500> }
	    triangle { < 0.040 6.380 -6.390> <-1.151 6.316 -6.213> < 0.200 4.668 -6.927> }
	    triangle { <-1.959 5.899 -5.805> <-0.730 4.667 -6.463> <-1.151 6.316 -6.213> }
	    triangle { < 0.674 2.849 -7.347> < 0.200 4.668 -6.927> <-0.730 4.667 -6.463> }
	    triangle { <-1.151 6.316 -6.213> <-0.730 4.667 -6.463> < 0.200 4.668 -6.927> }
	    triangle { <-2.411 2.483 -7.293> <-0.665 2.543 -7.171> <-2.062 4.389 -6.625> }
	    triangle { < 0.674 2.849 -7.347> <-0.730 4.667 -6.463> <-0.665 2.543 -7.171> }
	    triangle { <-1.959 5.899 -5.805> <-2.062 4.389 -6.625> <-0.730 4.667 -6.463> }
	    triangle { <-0.665 2.543 -7.171> <-0.730 4.667 -6.463> <-2.062 4.389 -6.625> }
	}

	bounded_by {
	    sphere { <-1.903 3.190 -6.775> 4.661 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { <-6.310 0.000 -6.410> <-5.442 -1.683 -5.955> <-5.038 -2.150 -6.391> }
	    triangle { <-5.104 -3.249 -5.863> <-4.612 -3.244 -5.740> <-5.442 -1.683 -5.955> }
	    triangle { <-3.968 -3.464 -5.581> <-5.038 -2.150 -6.391> <-4.612 -3.244 -5.740> }
	    triangle { <-5.442 -1.683 -5.955> <-4.612 -3.244 -5.740> <-5.038 -2.150 -6.391> }
	    triangle { <-4.480 -6.380 -4.560> <-3.042 -6.382 -4.679> <-4.845 -4.951 -5.157> }
	    triangle { <-1.906 -6.178 -5.055> <-3.332 -4.346 -5.892> <-3.042 -6.382 -4.679> }
	    triangle { <-5.104 -3.249 -5.863> <-4.845 -4.951 -5.157> <-3.332 -4.346 -5.892> }
	    triangle { <-3.042 -6.382 -4.679> <-3.332 -4.346 -5.892> <-4.845 -4.951 -5.157> }
	    triangle { < 0.040 -6.380 -6.390> <-1.795 -5.225 -6.364> <-0.941 -6.202 -5.680> }
	    triangle { <-3.968 -3.464 -5.581> <-2.889 -4.479 -5.638> <-1.795 -5.225 -6.364> }
	    triangle { <-1.906 -6.178 -5.055> <-0.941 -6.202 -5.680> <-2.889 -4.479 -5.638> }
	    triangle { <-1.795 -5.225 -6.364> <-2.889 -4.479 -5.638> <-0.941 -6.202 -5.680> }
	    triangle { <-5.104 -3.249 -5.863> <-3.332 -4.346 -5.892> <-4.612 -3.244 -5.740> }
	    triangle { <-1.906 -6.178 -5.055> <-2.889 -4.479 -5.638> <-3.332 -4.346 -5.892> }
	    triangle { <-3.968 -3.464 -5.581> <-4.612 -3.244 -5.740> <-2.889 -4.479 -5.638> }
	    triangle { <-3.332 -4.346 -5.892> <-2.889 -4.479 -5.638> <-4.612 -3.244 -5.740> }
	}

	bounded_by {
	    sphere { <-3.135 -3.191 -5.485> 4.595 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { <-6.310 0.000 -6.410> <-5.038 -2.150 -6.391> <-4.637 -0.193 -7.579> }
	    triangle { <-3.968 -3.464 -5.581> <-3.530 -2.249 -7.046> <-5.038 -2.150 -6.391> }
	    triangle { <-3.302 -0.439 -8.114> <-4.637 -0.193 -7.579> <-3.530 -2.249 -7.046> }
	    triangle { <-5.038 -2.150 -6.391> <-3.530 -2.249 -7.046> <-4.637 -0.193 -7.579> }
	    triangle { < 0.040 -6.380 -6.390> < 0.076 -5.129 -6.881> <-1.795 -5.225 -6.364> }
	    triangle { < 0.209 -3.225 -7.440> <-2.032 -3.598 -6.520> < 0.076 -5.129 -6.881> }
	    triangle { <-3.968 -3.464 -5.581> <-1.795 -5.225 -6.364> <-2.032 -3.598 -6.520> }
	    triangle { < 0.076 -5.129 -6.881> <-2.032 -3.598 -6.520> <-1.795 -5.225 -6.364> }
	    triangle { < 0.060 0.000 -8.990> <-1.711 0.064 -8.566> < 0.330 -1.944 -8.017> }
	    triangle { <-3.302 -0.439 -8.114> <-1.562 -2.021 -8.037> <-1.711 0.064 -8.566> }
	    triangle { < 0.209 -3.225 -7.440> < 0.330 -1.944 -8.017> <-1.562 -2.021 -8.037> }
	    triangle { <-1.711 0.064 -8.566> <-1.562 -2.021 -8.037> < 0.330 -1.944 -8.017> }
	    triangle { <-3.968 -3.464 -5.581> <-2.032 -3.598 -6.520> <-3.530 -2.249 -7.046> }
	    triangle { < 0.209 -3.225 -7.440> <-1.562 -2.021 -8.037> <-2.032 -3.598 -6.520> }
	    triangle { <-3.302 -0.439 -8.114> <-3.530 -2.249 -7.046> <-1.562 -2.021 -8.037> }
	    triangle { <-2.032 -3.598 -6.520> <-1.562 -2.021 -8.037> <-3.530 -2.249 -7.046> }
	}

	bounded_by {
	    sphere { <-2.990 -3.158 -7.285> 4.710 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { <-4.480 -6.380 -4.560> <-3.617 -7.070 -3.296> <-3.042 -6.382 -4.679> }
	    triangle { <-2.868 -7.643 -2.274> <-2.464 -6.805 -3.363> <-3.617 -7.070 -3.296> }
	    triangle { <-1.906 -6.178 -5.055> <-3.042 -6.382 -4.679> <-2.464 -6.805 -3.363> }
	    triangle { <-3.617 -7.070 -3.296> <-2.464 -6.805 -3.363> <-3.042 -6.382 -4.679> }
	    triangle { < 0.000 -8.800 0.000> < 0.097 -8.656 -1.567> <-1.116 -7.958 -1.516> }
	    triangle { <-0.262 -8.021 -2.608> <-1.628 -7.677 -2.272> < 0.097 -8.656 -1.567> }
	    triangle { <-2.868 -7.643 -2.274> <-1.116 -7.958 -1.516> <-1.628 -7.677 -2.272> }
	    triangle { < 0.097 -8.656 -1.567> <-1.628 -7.677 -2.272> <-1.116 -7.958 -1.516> }
	    triangle { < 0.040 -6.380 -6.390> <-0.941 -6.202 -5.680> <-0.274 -6.807 -4.408> }
	    triangle { <-1.906 -6.178 -5.055> <-1.362 -7.344 -3.585> <-0.941 -6.202 -5.680> }
	    triangle { <-0.262 -8.021 -2.608> <-0.274 -6.807 -4.408> <-1.362 -7.344 -3.585> }
	    triangle { <-0.941 -6.202 -5.680> <-1.362 -7.344 -3.585> <-0.274 -6.807 -4.408> }
	    triangle { <-2.868 -7.643 -2.274> <-1.628 -7.677 -2.272> <-2.464 -6.805 -3.363> }
	    triangle { <-0.262 -8.021 -2.608> <-1.362 -7.344 -3.585> <-1.628 -7.677 -2.272> }
	    triangle { <-1.906 -6.178 -5.055> <-2.464 -6.805 -3.363> <-1.362 -7.344 -3.585> }
	    triangle { <-1.628 -7.677 -2.272> <-1.362 -7.344 -3.585> <-2.464 -6.805 -3.363> }
	}

	bounded_by {
	    sphere { <-2.192 -7.489 -3.195> 4.090 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 0.000 8.800 0.000> <-0.430 8.407 -2.147> < 1.134 8.089 -1.047> }
	    triangle { <-0.345 7.684 -3.638> < 1.131 7.609 -2.990> <-0.430 8.407 -2.147> }
	    triangle { < 2.170 7.547 -1.783> < 1.134 8.089 -1.047> < 1.131 7.609 -2.990> }
	    triangle { <-0.430 8.407 -2.147> < 1.131 7.609 -2.990> < 1.134 8.089 -1.047> }
	    triangle { < 0.040 6.380 -6.390> < 1.391 6.604 -5.768> <-0.356 7.139 -4.941> }
	    triangle { < 2.466 6.673 -5.636> < 1.106 7.107 -4.974> < 1.391 6.604 -5.768> }
	    triangle { <-0.345 7.684 -3.638> <-0.356 7.139 -4.941> < 1.106 7.107 -4.974> }
	    triangle { < 1.391 6.604 -5.768> < 1.106 7.107 -4.974> <-0.356 7.139 -4.941> }
	    triangle { < 4.550 6.380 -4.480> < 3.074 6.705 -3.220> < 3.324 6.440 -5.033> }
	    triangle { < 2.170 7.547 -1.783> < 2.002 6.939 -4.045> < 3.074 6.705 -3.220> }
	    triangle { < 2.466 6.673 -5.636> < 3.324 6.440 -5.033> < 2.002 6.939 -4.045> }
	    triangle { < 3.074 6.705 -3.220> < 2.002 6.939 -4.045> < 3.324 6.440 -5.033> }
	    triangle { <-0.345 7.684 -3.638> < 1.106 7.107 -4.974> < 1.131 7.609 -2.990> }
	    triangle { < 2.466 6.673 -5.636> < 2.002 6.939 -4.045> < 1.106 7.107 -4.974> }
	    triangle { < 2.170 7.547 -1.783> < 1.131 7.609 -2.990> < 2.002 6.939 -4.045> }
	    triangle { < 1.106 7.107 -4.974> < 2.002 6.939 -4.045> < 1.131 7.609 -2.990> }
	}

	bounded_by {
	    sphere { < 2.060 7.590 -3.195> 3.989 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 0.040 6.380 -6.390> < 0.200 4.668 -6.927> < 2.275 4.545 -6.750> }
	    triangle { < 0.674 2.849 -7.347> < 2.056 3.450 -6.849> < 0.200 4.668 -6.927> }
	    triangle { < 3.811 3.528 -6.631> < 2.275 4.545 -6.750> < 2.056 3.450 -6.849> }
	    triangle { < 0.200 4.668 -6.927> < 2.056 3.450 -6.849> < 2.275 4.545 -6.750> }
	    triangle { < 0.060 0.000 -8.990> < 1.168 -0.107 -8.055> < 0.601 1.541 -8.499> }
	    triangle { < 2.546 -0.289 -7.226> < 1.910 1.318 -7.161> < 1.168 -0.107 -8.055> }
	    triangle { < 0.674 2.849 -7.347> < 0.601 1.541 -8.499> < 1.910 1.318 -7.161> }
	    triangle { < 1.168 -0.107 -8.055> < 1.910 1.318 -7.161> < 0.601 1.541 -8.499> }
	    triangle { < 6.400 0.000 -6.310> < 4.951 1.605 -6.341> < 4.379 -0.418 -6.504> }
	    triangle { < 3.811 3.528 -6.631> < 3.212 1.796 -6.805> < 4.951 1.605 -6.341> }
	    triangle { < 2.546 -0.289 -7.226> < 4.379 -0.418 -6.504> < 3.212 1.796 -6.805> }
	    triangle { < 4.951 1.605 -6.341> < 3.212 1.796 -6.805> < 4.379 -0.418 -6.504> }
	    triangle { < 0.674 2.849 -7.347> < 1.910 1.318 -7.161> < 2.056 3.450 -6.849> }
	    triangle { < 2.546 -0.289 -7.226> < 3.212 1.796 -6.805> < 1.910 1.318 -7.161> }
	    triangle { < 3.811 3.528 -6.631> < 2.056 3.450 -6.849> < 3.212 1.796 -6.805> }
	    triangle { < 1.910 1.318 -7.161> < 3.212 1.796 -6.805> < 2.056 3.450 -6.849> }
	}

	bounded_by {
	    sphere { < 3.220 2.981 -7.650> 4.822 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 0.040 6.380 -6.390> < 2.275 4.545 -6.750> < 1.391 6.604 -5.768> }
	    triangle { < 3.811 3.528 -6.631> < 2.798 5.028 -6.297> < 2.275 4.545 -6.750> }
	    triangle { < 2.466 6.673 -5.636> < 1.391 6.604 -5.768> < 2.798 5.028 -6.297> }
	    triangle { < 2.275 4.545 -6.750> < 2.798 5.028 -6.297> < 1.391 6.604 -5.768> }
	    triangle { < 6.400 0.000 -6.310> < 5.812 1.494 -5.852> < 4.951 1.605 -6.341> }
	    triangle { < 5.776 2.736 -5.047> < 4.732 3.334 -5.941> < 5.812 1.494 -5.852> }
	    triangle { < 3.811 3.528 -6.631> < 4.951 1.605 -6.341> < 4.732 3.334 -5.941> }
	    triangle { < 5.812 1.494 -5.852> < 4.732 3.334 -5.941> < 4.951 1.605 -6.341> }
	    triangle { < 4.550 6.380 -4.480> < 3.324 6.440 -5.033> < 4.920 4.207 -4.401> }
	    triangle { < 2.466 6.673 -5.636> < 3.939 5.116 -4.987> < 3.324 6.440 -5.033> }
	    triangle { < 5.776 2.736 -5.047> < 4.920 4.207 -4.401> < 3.939 5.116 -4.987> }
	    triangle { < 3.324 6.440 -5.033> < 3.939 5.116 -4.987> < 4.920 4.207 -4.401> }
	    triangle { < 3.811 3.528 -6.631> < 4.732 3.334 -5.941> < 2.798 5.028 -6.297> }
	    triangle { < 5.776 2.736 -5.047> < 3.939 5.116 -4.987> < 4.732 3.334 -5.941> }
	    triangle { < 2.466 6.673 -5.636> < 2.798 5.028 -6.297> < 3.939 5.116 -4.987> }
	    triangle { < 4.732 3.334 -5.941> < 3.939 5.116 -4.987> < 2.798 5.028 -6.297> }
	}

	bounded_by {
	    sphere { < 3.220 3.336 -5.575> 4.667 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 0.060 0.000 -8.990> < 0.330 -1.944 -8.017> < 1.254 -1.691 -8.082> }
	    triangle { < 0.209 -3.225 -7.440> < 1.037 -3.205 -7.468> < 0.330 -1.944 -8.017> }
	    triangle { < 1.999 -2.947 -7.561> < 1.254 -1.691 -8.082> < 1.037 -3.205 -7.468> }
	    triangle { < 0.330 -1.944 -8.017> < 1.037 -3.205 -7.468> < 1.254 -1.691 -8.082> }
	    triangle { < 0.040 -6.380 -6.390> < 1.406 -6.288 -5.930> < 0.076 -5.129 -6.881> }
	    triangle { < 2.744 -6.000 -5.805> < 1.374 -4.919 -7.014> < 1.406 -6.288 -5.930> }
	    triangle { < 0.209 -3.225 -7.440> < 0.076 -5.129 -6.881> < 1.374 -4.919 -7.014> }
	    triangle { < 1.406 -6.288 -5.930> < 1.374 -4.919 -7.014> < 0.076 -5.129 -6.881> }
	    triangle { < 4.550 -6.380 -4.480> < 3.485 -4.389 -6.539> < 3.690 -6.044 -5.130> }
	    triangle { < 1.999 -2.947 -7.561> < 2.440 -4.341 -6.682> < 3.485 -4.389 -6.539> }
	    triangle { < 2.744 -6.000 -5.805> < 3.690 -6.044 -5.130> < 2.440 -4.341 -6.682> }
	    triangle { < 3.485 -4.389 -6.539> < 2.440 -4.341 -6.682> < 3.690 -6.044 -5.130> }
	    triangle { < 0.209 -3.225 -7.440> < 1.374 -4.919 -7.014> < 1.037 -3.205 -7.468> }
	    triangle { < 2.744 -6.000 -5.805> < 2.440 -4.341 -6.682> < 1.374 -4.919 -7.014> }
	    triangle { < 1.999 -2.947 -7.561> < 1.037 -3.205 -7.468> < 2.440 -4.341 -6.682> }
	    triangle { < 1.374 -4.919 -7.014> < 2.440 -4.341 -6.682> < 1.037 -3.205 -7.468> }
	}

	bounded_by {
	    sphere { < 2.295 -3.190 -6.735> 4.511 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 0.060 0.000 -8.990> < 1.254 -1.691 -8.082> < 1.168 -0.107 -8.055> }
	    triangle { < 1.999 -2.947 -7.561> < 2.448 -1.593 -7.205> < 1.254 -1.691 -8.082> }
	    triangle { < 2.546 -0.289 -7.226> < 1.168 -0.107 -8.055> < 2.448 -1.593 -7.205> }
	    triangle { < 1.254 -1.691 -8.082> < 2.448 -1.593 -7.205> < 1.168 -0.107 -8.055> }
	    triangle { < 4.550 -6.380 -4.480> < 4.962 -4.462 -4.513> < 3.485 -4.389 -6.539> }
	    triangle { < 5.958 -3.113 -5.151> < 4.368 -2.672 -6.679> < 4.962 -4.462 -4.513> }
	    triangle { < 1.999 -2.947 -7.561> < 3.485 -4.389 -6.539> < 4.368 -2.672 -6.679> }
	    triangle { < 4.962 -4.462 -4.513> < 4.368 -2.672 -6.679> < 3.485 -4.389 -6.539> }
	    triangle { < 6.400 0.000 -6.310> < 4.379 -0.418 -6.504> < 6.034 -1.879 -5.948> }
	    triangle { < 2.546 -0.289 -7.226> < 4.250 -1.887 -5.707> < 4.379 -0.418 -6.504> }
	    triangle { < 5.958 -3.113 -5.151> < 6.034 -1.879 -5.948> < 4.250 -1.887 -5.707> }
	    triangle { < 4.379 -0.418 -6.504> < 4.250 -1.887 -5.707> < 6.034 -1.879 -5.948> }
	    triangle { < 1.999 -2.947 -7.561> < 4.368 -2.672 -6.679> < 2.448 -1.593 -7.205> }
	    triangle { < 5.958 -3.113 -5.151> < 4.250 -1.887 -5.707> < 4.368 -2.672 -6.679> }
	    triangle { < 2.546 -0.289 -7.226> < 2.448 -1.593 -7.205> < 4.250 -1.887 -5.707> }
	    triangle { < 4.368 -2.672 -6.679> < 4.250 -1.887 -5.707> < 2.448 -1.593 -7.205> }
	}

	bounded_by {
	    sphere { < 3.230 -3.190 -6.735> 5.031 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 0.040 -6.380 -6.390> <-0.274 -6.807 -4.408> < 1.406 -6.288 -5.930> }
	    triangle { <-0.262 -8.021 -2.608> < 0.932 -7.056 -3.759> <-0.274 -6.807 -4.408> }
	    triangle { < 2.744 -6.000 -5.805> < 1.406 -6.288 -5.930> < 0.932 -7.056 -3.759> }
	    triangle { <-0.274 -6.807 -4.408> < 0.932 -7.056 -3.759> < 1.406 -6.288 -5.930> }
	    triangle { < 0.000 -8.800 0.000> < 1.106 -8.359 -0.651> < 0.097 -8.656 -1.567> }
	    triangle { < 1.935 -8.009 -1.685> < 0.700 -8.027 -2.044> < 1.106 -8.359 -0.651> }
	    triangle { <-0.262 -8.021 -2.608> < 0.097 -8.656 -1.567> < 0.700 -8.027 -2.044> }
	    triangle { < 1.106 -8.359 -0.651> < 0.700 -8.027 -2.044> < 0.097 -8.656 -1.567> }
	    triangle { < 4.550 -6.380 -4.480> < 3.690 -6.044 -5.130> < 3.265 -7.602 -3.348> }
	    triangle { < 2.744 -6.000 -5.805> < 2.571 -6.658 -4.084> < 3.690 -6.044 -5.130> }
	    triangle { < 1.935 -8.009 -1.685> < 3.265 -7.602 -3.348> < 2.571 -6.658 -4.084> }
	    triangle { < 3.690 -6.044 -5.130> < 2.571 -6.658 -4.084> < 3.265 -7.602 -3.348> }
	    triangle { <-0.262 -8.021 -2.608> < 0.700 -8.027 -2.044> < 0.932 -7.056 -3.759> }
	    triangle { < 1.935 -8.009 -1.685> < 2.571 -6.658 -4.084> < 0.700 -8.027 -2.044> }
	    triangle { < 2.744 -6.000 -5.805> < 0.932 -7.056 -3.759> < 2.571 -6.658 -4.084> }
	    triangle { < 0.700 -8.027 -2.044> < 2.571 -6.658 -4.084> < 0.932 -7.056 -3.759> }
	}

	bounded_by {
	    sphere { < 2.138 -7.400 -3.195> 4.092 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 0.000 8.800 0.000> < 1.134 8.089 -1.047> < 1.463 7.998 -0.256> }
	    triangle { < 2.170 7.547 -1.783> < 2.289 7.097 -0.701> < 1.134 8.089 -1.047> }
	    triangle { < 2.581 6.935 0.031> < 1.463 7.998 -0.256> < 2.289 7.097 -0.701> }
	    triangle { < 1.134 8.089 -1.047> < 2.289 7.097 -0.701> < 1.463 7.998 -0.256> }
	    triangle { < 4.550 6.380 -4.480> < 4.629 6.382 -3.059> < 3.074 6.705 -3.220> }
	    triangle { < 5.224 6.160 -1.877> < 3.900 6.725 -1.815> < 4.629 6.382 -3.059> }
	    triangle { < 2.170 7.547 -1.783> < 3.074 6.705 -3.220> < 3.900 6.725 -1.815> }
	    triangle { < 4.629 6.382 -3.059> < 3.900 6.725 -1.815> < 3.074 6.705 -3.220> }
	    triangle { < 6.390 6.380 0.060> < 4.218 6.976 0.323> < 5.813 6.123 -0.886> }
	    triangle { < 2.581 6.935 0.031> < 3.920 6.311 -1.119> < 4.218 6.976 0.323> }
	    triangle { < 5.224 6.160 -1.877> < 5.813 6.123 -0.886> < 3.920 6.311 -1.119> }
	    triangle { < 4.218 6.976 0.323> < 3.920 6.311 -1.119> < 5.813 6.123 -0.886> }
	    triangle { < 2.170 7.547 -1.783> < 3.900 6.725 -1.815> < 2.289 7.097 -0.701> }
	    triangle { < 5.224 6.160 -1.877> < 3.920 6.311 -1.119> < 3.900 6.725 -1.815> }
	    triangle { < 2.581 6.935 0.031> < 2.289 7.097 -0.701> < 3.920 6.311 -1.119> }
	    triangle { < 3.900 6.725 -1.815> < 3.920 6.311 -1.119> < 2.289 7.097 -0.701> }
	}

	bounded_by {
	    sphere { < 3.195 7.462 -2.079> 4.040 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 4.550 6.380 -4.480> < 4.920 4.207 -4.401> < 5.690 5.025 -3.297> }
	    triangle { < 5.776 2.736 -5.047> < 6.296 3.042 -3.780> < 4.920 4.207 -4.401> }
	    triangle { < 6.828 3.068 -2.077> < 5.690 5.025 -3.297> < 6.296 3.042 -3.780> }
	    triangle { < 4.920 4.207 -4.401> < 6.296 3.042 -3.780> < 5.690 5.025 -3.297> }
	    triangle { < 6.400 0.000 -6.310> < 6.881 0.122 -4.821> < 5.812 1.494 -5.852> }
	    triangle { < 7.017 -0.420 -2.794> < 6.352 0.938 -4.185> < 6.881 0.122 -4.821> }
	    triangle { < 5.776 2.736 -5.047> < 5.812 1.494 -5.852> < 6.352 0.938 -4.185> }
	    triangle { < 6.881 0.122 -4.821> < 6.352 0.938 -4.185> < 5.812 1.494 -5.852> }
	    triangle { < 8.990 0.000 0.080> < 7.814 1.251 -0.708> < 8.145 0.028 -1.595> }
	    triangle { < 6.828 3.068 -2.077> < 6.964 1.628 -2.261> < 7.814 1.251 -0.708> }
	    triangle { < 7.017 -0.420 -2.794> < 8.145 0.028 -1.595> < 6.964 1.628 -2.261> }
	    triangle { < 7.814 1.251 -0.708> < 6.964 1.628 -2.261> < 8.145 0.028 -1.595> }
	    triangle { < 5.776 2.736 -5.047> < 6.352 0.938 -4.185> < 6.296 3.042 -3.780> }
	    triangle { < 7.017 -0.420 -2.794> < 6.964 1.628 -2.261> < 6.352 0.938 -4.185> }
	    triangle { < 6.828 3.068 -2.077> < 6.296 3.042 -3.780> < 6.964 1.628 -2.261> }
	    triangle { < 6.352 0.938 -4.185> < 6.964 1.628 -2.261> < 6.296 3.042 -3.780> }
	}

	bounded_by {
	    sphere { < 6.770 2.980 -3.115> 4.901 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 4.550 6.380 -4.480> < 5.690 5.025 -3.297> < 4.629 6.382 -3.059> }
	    triangle { < 6.828 3.068 -2.077> < 5.786 4.686 -2.232> < 5.690 5.025 -3.297> }
	    triangle { < 5.224 6.160 -1.877> < 4.629 6.382 -3.059> < 5.786 4.686 -2.232> }
	    triangle { < 5.690 5.025 -3.297> < 5.786 4.686 -2.232> < 4.629 6.382 -3.059> }
	    triangle { < 8.990 0.000 0.080> < 8.073 1.406 0.453> < 7.814 1.251 -0.708> }
	    triangle { < 7.380 3.478 0.422> < 7.077 3.244 -0.902> < 8.073 1.406 0.453> }
	    triangle { < 6.828 3.068 -2.077> < 7.814 1.251 -0.708> < 7.077 3.244 -0.902> }
	    triangle { < 8.073 1.406 0.453> < 7.077 3.244 -0.902> < 7.814 1.251 -0.708> }
	    triangle { < 6.390 6.380 0.060> < 5.813 6.123 -0.886> < 7.068 4.760 0.108> }
	    triangle { < 5.224 6.160 -1.877> < 6.541 5.228 -0.460> < 5.813 6.123 -0.886> }
	    triangle { < 7.380 3.478 0.422> < 7.068 4.760 0.108> < 6.541 5.228 -0.460> }
	    triangle { < 5.813 6.123 -0.886> < 6.541 5.228 -0.460> < 7.068 4.760 0.108> }
	    triangle { < 6.828 3.068 -2.077> < 7.077 3.244 -0.902> < 5.786 4.686 -2.232> }
	    triangle { < 7.380 3.478 0.422> < 6.541 5.228 -0.460> < 7.077 3.244 -0.902> }
	    triangle { < 5.224 6.160 -1.877> < 5.786 4.686 -2.232> < 6.541 5.228 -0.460> }
	    triangle { < 7.077 3.244 -0.902> < 6.541 5.228 -0.460> < 5.786 4.686 -2.232> }
	}

	bounded_by {
	    sphere { < 6.770 3.191 -2.013> 4.603 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 6.400 0.000 -6.310> < 6.034 -1.879 -5.948> < 6.337 -1.231 -4.911> }
	    triangle { < 5.958 -3.113 -5.151> < 6.495 -2.889 -4.716> < 6.034 -1.879 -5.948> }
	    triangle { < 6.971 -2.657 -3.968> < 6.337 -1.231 -4.911> < 6.495 -2.889 -4.716> }
	    triangle { < 6.034 -1.879 -5.948> < 6.495 -2.889 -4.716> < 6.337 -1.231 -4.911> }
	    triangle { < 4.550 -6.380 -4.480> < 4.993 -6.241 -3.294> < 4.962 -4.462 -4.513> }
	    triangle { < 5.314 -6.441 -2.453> < 5.768 -4.465 -3.920> < 4.993 -6.241 -3.294> }
	    triangle { < 5.958 -3.113 -5.151> < 4.962 -4.462 -4.513> < 5.768 -4.465 -3.920> }
	    triangle { < 4.993 -6.241 -3.294> < 5.768 -4.465 -3.920> < 4.962 -4.462 -4.513> }
	    triangle { < 6.390 -6.380 0.060> < 6.204 -4.326 -2.213> < 5.794 -6.433 -1.469> }
	    triangle { < 6.971 -2.657 -3.968> < 6.100 -4.976 -3.558> < 6.204 -4.326 -2.213> }
	    triangle { < 5.314 -6.441 -2.453> < 5.794 -6.433 -1.469> < 6.100 -4.976 -3.558> }
	    triangle { < 6.204 -4.326 -2.213> < 6.100 -4.976 -3.558> < 5.794 -6.433 -1.469> }
	    triangle { < 5.958 -3.113 -5.151> < 5.768 -4.465 -3.920> < 6.495 -2.889 -4.716> }
	    triangle { < 5.314 -6.441 -2.453> < 6.100 -4.976 -3.558> < 5.768 -4.465 -3.920> }
	    triangle { < 6.971 -2.657 -3.968> < 6.495 -2.889 -4.716> < 6.100 -4.976 -3.558> }
	    triangle { < 5.768 -4.465 -3.920> < 6.100 -4.976 -3.558> < 6.495 -2.889 -4.716> }
	}

	bounded_by {
	    sphere { < 5.761 -3.220 -3.125> 4.574 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 6.400 0.000 -6.310> < 6.337 -1.231 -4.911> < 6.881 0.122 -4.821> }
	    triangle { < 6.971 -2.657 -3.968> < 6.834 -1.686 -3.297> < 6.337 -1.231 -4.911> }
	    triangle { < 7.017 -0.420 -2.794> < 6.881 0.122 -4.821> < 6.834 -1.686 -3.297> }
	    triangle { < 6.337 -1.231 -4.911> < 6.834 -1.686 -3.297> < 6.881 0.122 -4.821> }
	    triangle { < 6.390 -6.380 0.060> < 6.648 -4.933 0.334> < 6.204 -4.326 -2.213> }
	    triangle { < 7.405 -3.854 0.310> < 7.506 -3.361 -2.122> < 6.648 -4.933 0.334> }
	    triangle { < 6.971 -2.657 -3.968> < 6.204 -4.326 -2.213> < 7.506 -3.361 -2.122> }
	    triangle { < 6.648 -4.933 0.334> < 7.506 -3.361 -2.122> < 6.204 -4.326 -2.213> }
	    triangle { < 8.990 0.000 0.080> < 8.145 0.028 -1.595> < 8.024 -1.599 0.437> }
	    triangle { < 7.017 -0.420 -2.794> < 7.635 -2.035 -1.231> < 8.145 0.028 -1.595> }
	    triangle { < 7.405 -3.854 0.310> < 8.024 -1.599 0.437> < 7.635 -2.035 -1.231> }
	    triangle { < 8.145 0.028 -1.595> < 7.635 -2.035 -1.231> < 8.024 -1.599 0.437> }
	    triangle { < 6.971 -2.657 -3.968> < 7.506 -3.361 -2.122> < 6.834 -1.686 -3.297> }
	    triangle { < 7.405 -3.854 0.310> < 7.635 -2.035 -1.231> < 7.506 -3.361 -2.122> }
	    triangle { < 7.017 -0.420 -2.794> < 6.834 -1.686 -3.297> < 7.635 -2.035 -1.231> }
	    triangle { < 7.506 -3.361 -2.122> < 7.635 -2.035 -1.231> < 6.834 -1.686 -3.297> }
	}

	bounded_by {
	    sphere { < 7.597 -3.129 -2.937> 4.754 }
	}

    texture { GreenStone }
    }

    object {
	union {
	    triangle { < 4.550 -6.380 -4.480> < 3.265 -7.602 -3.348> < 4.993 -6.241 -3.294> }
	    triangle { < 1.935 -8.009 -1.685> < 3.804 -7.114 -1.744> < 3.265 -7.602 -3.348> }
	    triangle { < 5.314 -6.441 -2.453> < 4.993 -6.241 -3.294> < 3.804 -7.114 -1.744> }
	    triangle { < 3.265 -7.602 -3.348> < 3.804 -7.114 -1.744> < 4.993 -6.241 -3.294> }
	    triangle { < 0.000 -8.800 0.000> < 1.920 -7.955 -0.046> < 1.106 -8.359 -0.651> }
	    triangle { < 3.335 -7.381 0.138> < 2.502 -7.863 -0.689> < 1.920 -7.955 -0.046> }
	    triangle { < 1.935 -8.009 -1.685> < 1.106 -8.359 -0.651> < 2.502 -7.863 -0.689> }
	    triangle { < 1.920 -7.955 -0.046> < 2.502 -7.863 -0.689> < 1.106 -8.359 -0.651> }
	    triangle { < 6.390 -6.380 0.060> < 5.794 -6.433 -1.469> < 5.097 -6.604 0.187> }
	    triangle { < 5.314 -6.441 -2.453> < 4.516 -6.627 -0.986> < 5.794 -6.433 -1.469> }
	    triangle { < 3.335 -7.381 0.138> < 5.097 -6.604 0.187> < 4.516 -6.627 -0.986> }
	    triangle { < 5.794 -6.433 -1.469> < 4.516 -6.627 -0.986> < 5.097 -6.604 0.187> }
	    triangle { < 1.935 -8.009 -1.685> < 2.502 -7.863 -0.689> < 3.804 -7.114 -1.744> }
	    triangle { < 3.335 -7.381 0.138> < 4.516 -6.627 -0.986> < 2.502 -7.863 -0.689> }
	    triangle { < 5.314 -6.441 -2.453> < 3.804 -7.114 -1.744> < 4.516 -6.627 -0.986> }
	    triangle { < 2.502 -7.863 -0.689> < 4.516 -6.627 -0.986> < 3.804 -7.114 -1.744> }
	}

	bounded_by {
	    sphere { < 3.195 -7.521 -2.146> 4.056 }
	}

    texture { GreenStone }
    }

    bounded_by { box { UnitBox scale <8.99 8.99 8.99> } }
}


// Quicktest stand-in for the rock
// #declare Rock = composite {
//     object { sphere { <0 0 0> 8.99 }
//        texture { GreenStone }
//     }
//}

#declare Stone_Sphere = object {
    sphere { <0 -5 0> 4 }
    texture { GreenStone
        phong 1
        phong_size 150
        reflection 0.25
    }
}

/*** Stand-in for the core sample
#declare Core = composite
    object {
        intersection { Y_Disk translate <0 -1 0> }
        texture { color White }
    }
}
***/


// Core Sample
#declare Ruffness = 2
#declare Column_Texture = texture {
    Stone18
    ambient 0.1
    diffuse 0.55
    reflection 0.12
}

#declare Core = composite {

    object {
        height_field { gif "plasma.gif" }
        translate <-0.5 0 -0.5>
        scale <6 1 6>
        clipped_by {
            quadric { Cylinder_Y }
        }
        texture { Column_Texture }
        scale <1 Ruffness 1>
    }

    object {
        quadric { Cylinder_Y }
        clipped_by {
            height_field { gif "plasma.gif"
            translate <-0.5 0 -0.5>
            scale <6 1 6>
            inverse
            }
        }
        texture { Column_Texture }
        scale <1 2 1>
    }
    object {
        intersection { Y_Disk translate <0 -1 0> }
        texture { Column_Texture }
        scale <1 3 1>
    }

}


object { sphere { <0 0 0> 100000 } texture { 0.025 color Gray25 } }
object { plane { <0 1 0> -9 } texture { 0.025 color Gray25 reflection 0.5 }}
composite { Rock }   // bottom on 8.99y
object { Stone_Sphere translate <0 0 -10> rotate <0 -30 0> }
composite { Core
    scale <2 3 2>
    rotate <-90 -20 0>
    translate <-14 -6 0>
}
