/* 486/33
 7 hrs 30 min w/ +a0.2 @ 640x480
ͻ
  Persistence of Vision Raytracer Ver 1.0.ibmztc                        
ĺ
  mandel.pov statistics                                                 
ĺ
 Image Resolution 640 pixels wide x 480 pixels high                     
 # Rays Calculated     :      948570                                    
 # Pixels Calculated   :      307840                                    
 # Pixels Supersampled :       41874                                    
ĺ
   Ray - Shape Intersection Tests                                      
   Type             Tests    Succeeded   Percentage                     
ĺ
  Sphere        173192721      892301        0.52                       
  Plane           1518161      684706       45.10                       
  Box            63246765     3866171        6.11                       
  Bounds         63246765     3866323        6.11                       
ĺ
  Calls to DNoise Routine :          10                                 
ĺ
  Shadow Ray Tests        :     1906897                                 
  Blocking Objects Found  :      198124                                 
  Reflected Rays          :      263864                                 
ĺ
  Rendering Time          :       8 hours 59 minutes 45.00 seconds      
ĺ
ͼ
*/

#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"

// Colors are from Fractint's GOODEGA map
// Converted from 0-255 range to PoV's 0-1 range
#declare c0 = 0.0
#declare c84 = 0.328125
#declare c168 = 0.65625
#declare c252 = 0.984375

#declare Color1  =  color red c0   green c0   blue c84
#declare Color2  =  color red c0   green c0   blue c168
#declare Color3  =  color red c0   green c0   blue c252
#declare Color4  =  color red c0   green c84  blue c252
#declare Color5  =  color red c0   green c168 blue c252
#declare Color6  =  color red c0   green c252 blue c252
#declare Color7  =  color red c252 green c252 blue c168
#declare Color8  =  color red c252 green c252 blue c0
#declare Color9  =  color red c252 green c168 blue c0
#declare Color10 =  color red c252 green c84  blue c0
#declare Color11 =  color red c252 green c0   blue c0
#declare Color12 =  color red c168 green c0   blue c0
#declare Color13 =  color red c84  green c0   blue c0
#declare Color14 =  color red c252 green c252 blue c84
#declare Color15 =  color red c252 green c84  blue c0
#declare Color16 =  color red c252 green c252 blue c252



camera {
   location <100.0  150.0  -250.0>
   direction <0.0 0.0  1.0>
   up  <0.0  1.0  0.0>
   right <1.33333 0.0 0.0>
   look_at <0 0 0>
 }

// Light source
object { light_source { <10 200 -50> color White }}

default {
    texture {
        Shiny
        ambient 0.2
        diffuse 0.8
        phong 1 phong_size 100
    }
}


object {
    plane { <0 1 0> -4.53333  }
    texture {
        color LightGray
        ambient 0.2
        diffuse 0.8
        reflection 0.25
    }
}

default { texture { Phong_Shiny ambient 0.1 } }
composite {
    #include "mandel.inc"
    bounded_by {
        box { UnitBox scale <323 174 4> }
    }
    rotate <90 0 0>
}
