// Persistence of Vision Raytracer
// Intersection of two cylinders,  with holes cut from each one, in pink
// marblized stone.
// Image by Dan Farmer.
// Demonstrates CSG intersection,  layered stone texture.
// Time: about 3 hours @640x480+a0.2 on 486/33


#include "include.inc"

camera {
   location <0.0  8  -30>
   direction <0.0 0.0  1.0>
   up  <0.0  1.0  0.0>
   right <1.33333 0.0 0.0>
   look_at <0 0 0>
}


// Light source
#declare Light1 = 0.95
#declare Light2 = 0.75

object { light_source
    { <-1 5 -15>
    color red Light1 green Light1 blue Light1
      spotlight
      point_at <0 0 0>
      tightness 2
      radius  30
      falloff 50
    }
}

object { light_source
    { <-10 5 -10>
    color red Light2 green Light2 blue Light2
      spotlight
      point_at <-2.5 0 -2.5>
      tightness 5
      radius  30
      falloff 50
    }
}


object { light_source
    { <10 9 -10>
    color red Light2 green Light2 blue Light2
      spotlight
      point_at <-10 10 0>
      tightness 2
      radius  30
      falloff 50
    }
}

#declare Annulus = 0.98
object {
    intersection {
        quadric { Cylinder_X }
        quadric { Cylinder_Y }
        quadric { Cylinder_X inverse scale < 1  Annulus Annulus > }
        quadric { Cylinder_Y inverse scale < Annulus  1 Annulus > }

    }
    // Underlying surface is very subtly mottled with bozo
    texture {
        Silver_Metal
        specular 1 roughness 0.00001
        reflection 0.125
        ambient 0.25
    }

scale <10 10 10>
rotate <0 45 0>
}

object {
    plane {<0 1 0> -10 }
    texture {
        0.025
        color NeonBlue
        ambient 0.125
        diffuse 0.6
        reflection 0.25
    }
}
