// Persistence of Vision Raytracer
// Intersection of two cylinders,  with holes cut from each one, in pink
// marblized stone.
// Image by Dan Farmer.
// Demonstrates CSG intersection,  layered stone texture.
// Time: about 3 hours @640x480+a0.2 on 486/33


#include "include.inc"

camera {
   location <0.0  10  -27>
   direction <0.0 0.0  1.0>
   up  <0.0  1.0  0.0>
   right <1.33333 0.0 0.0>
   look_at <0 0 0>
}


// Light source
#declare Light1 = 0.9
#declare Light2 = 0.5
object { light_source { <-10 20 -25> color red Light1 green Light1 blue Light1 }}
object { light_source { <0 0 0> color red Light2 green Light2 blue Light2   }}

//#declare Color1A = color DustyRose
#declare Color1A = color LightSteelBlue
#declare Color1B = color DarkSlateGray
#declare Color2A = color DarkSlateGray
#declare Annulus = 0.95
object {
    intersection {
        quadric { Cylinder_X }
        quadric { Cylinder_Y }
        quadric { Cylinder_X inverse scale < 1  Annulus Annulus > }
        quadric { Cylinder_Y inverse scale < Annulus  1 Annulus > }

    }
    // Underlying surface is very subtly mottled with bozo
    texture {
        ambient 0.25
        bozo
        turbulence 0.25
        color_map {
            [0.0 1.0 color red 0.9 green 0.75 blue 0.75
                     color red 0.6 green 0.6 blue 0.6 ]
        }
        scale <.4 .4 .4>
    }

    // Second layer texture has some alpha values, yet a fair amount of color
    // Viening is kept quite thin.
    texture {
        Glossy
        granite
        color_map {
            [0.0 0.9 color Color1A alpha 1 color Color1A alpha 0.5 ]
            [0.9 1.0  color Color1B color Color1B ]
        }
        scale <2 2 2>
        phong 0.25
        phong_size 75
        brilliance 4
    }

bounded_by {
    sphere { <0 0 0> 1.5 }
}
scale <10 10 10>
rotate <0 45 0>
}

