// Persistence of Vision Raytracer
// This data file makes a good starting point for developing tests and
// new data files.  It is also used as the benchmark for the timing tests.

#include "include.inc"

// debugging texture redefinitions for quicker debugging
//#declare Glass = texture { color Red }
//#declare Glass2 = texture { color Yellow }
//#declare Green_Glass = texture { color Green }

camera {
   location <-4  8  -30>
   direction <0.0 0.0  3.0>
   up  <0.0  1.0  0.0>
   right <1.33333 0.0 0.0>
   look_at <3 1 0>
}

// Use for fast debugging without color effects
//object { light_source  { <-40 10   1.25>  color White  } }


#declare Intensity = 0.35
object { light_source  { <-40 10   1.25>   color red   Intensity } }
object { light_source  { <-40 10  -2.50 >  color green Intensity } }
object { light_source  { <-40 10  -3.25>   color blue  Intensity } }
object { light_source  { <-40 11   1.25>   color red   Intensity } }
object { light_source  { <-40 11  -2.50 >  color green Intensity } }
object { light_source  { <-40 11  -3.25>   color blue  Intensity } }



object { sphere { <0 0 0>  10000 texture {color White ambient 1 } } }
object { plane { <0 1 0> 0 }
    texture {
        0.05 color White ambient .1 reflection 0.1
//          checker color White color Black
    }
}


#declare Shape1 = object {
    intersection {
        intersection { Y_Disk }
        plane { <0 1 0> 1 rotate <0 0 45> translate <1 0 0> texture { Green_Glass}}
    }
    texture { Glass2 }
    translate <2 0 0>
}

object { Shape1
    scale <1 2 1>
}
object { Shape1
    scale <1 3 1>
    translate <0 3 0>
    rotate <0 -30 0>
}
object { Shape1
    scale <1 2.5 1>
    translate <0 2.5 0>
    rotate <0 30 0>
}


/* A set of axis to help me align everything...
object { quadric { Cylinder_X }
    texture { color Cyan }
    scale <1 0.125 0.125>
    translate <0 1 0>
}
object { quadric { Cylinder_Z }
    texture { color Blue }
    scale <0.125 0.125 1>
    translate <0 1 0>
}
*/
