// Persistence of Vision Raytracer
// Flyrod & flyreel by Dan Farmer  May '92
// 5 hours 17 min on 33/486 +a0.1 640x480
#include "include.inc"
#declare Bamboo1 = colour  red   1.00 green   0.78 blue   0.46
#declare Bamboo2 = colour  red   0.97 green   0.82 blue   0.47


camera {
   location <0  0  -28>
   direction <0.0 0.0  3.0>
   up  <0.0  1.0  0.0>
   right <1.33333 0.0 0.0>
   look_at <-1.75 -3 0>
}

object { light_source  { < 10  30 -30>  color White } }
object { light_source  { <-200 150 -50>  color Gray75  } }

#declare Reel_Texture = texture {
    0.1
    specular 1
    roughness 0.005
    phong 1
    phong_size 150
    color Gray20
}

#declare Nickle_Silver = texture {
    0.25
    Metal
    color red 0.94 green 0.93 blue 0.83
}


#declare Cork = texture {
    0.05
    granite
    colour_map {
        [0.0 0.6  colour red 0.93 green 0.71 blue 0.532
                  colour red 0.98 green 0.81 blue 0.60]
        [0.6 0.65 colour red 0.50 green 0.30 blue 0.20
                  colour red 0.50 green 0.30 blue 0.20]
        [0.65 1.0 colour red 0.80 green 0.53 blue 0.46
                  colour red 0.85 green 0.75 blue 0.35]
    }
    scale <0.25 0.25 0.25>
    specular 0.1 roughness 0.5 // Very dull
    ambient 0.1
    diffuse 0.5
}

#declare RoseWood = texture {
    DMFWood3
    rotate <0 875 0>              // For x cylinder on reelseat (almost 90)
    ambient 0.35
    specular 0.75 roughness 0.075
    reflection 0.12
}

// Torus, Outer 2.23, inner 2.075.
// Used as beaded rim on flyreel frame
#declare Split_Torus =
    intersection {
        quartic {
           <    1.000000 0.000000 0.000000 0.000000 2.000000
                0.000000 0.000000 2.000000 0.000000 -9.368125
                0.000000 0.000000 0.000000 0.000000 0.000000
                0.000000 0.000000 0.000000 0.000000 0.000000
                1.000000 0.000000 0.000000 2.000000 0.000000
                9.337500 0.000000 0.000000 0.000000 0.000000
                1.000000 0.000000 -9.368125 0.000000 21.797227
            >
        }
    plane {<0 1 0> 0}
    rotate <90 0 0>
}





#declare FlyRod = composite {

    // Cork flyrod handle
    object {
        union {
            intersection { X_Disk }
            quadric { Ellipsoid translate <1 0 0> }
        }
        color Red
        texture { Cork scale <2 1 1> }
        scale <5 1 1>
    }

    // Reelseat
    object {
        intersection { X_Disk scale <2 0.75 0.75> translate <-7 0 0> }
        color Orange
        texture { RoseWood
            DMFWood3
            rotate <0 90 0>
            ambient 0.25
            specular 0.95 roughness 0.0025
        }
    }


    // Metal Cap and band for end of reelseat
    object {
        union {
            intersection { X_Disk scale <0.5 0.78 0.76> translate <-9.5 0 0> } // Cap
            intersection { X_Disk scale <0.05 0.82 0.82> translate <-9.05 0 0> }
            quadric { Ellipsoid
                texture {
                    Nickle_Silver
                    bump_map {
                            <0 -1 1>
                            gif "c:\pov\maps\monogram.gif"
                            bump_size -10
                            interpolate 4
                    }
                    rotate <0 180 0>
                    translate <0 -0.5 0.5>
                    scale <1 2.5 2.5>      // Monogram is smallish ;-]
                }
                scale <0.20 0.80 0.80> translate <-10 0 0>
            }

            intersection { X_Disk scale <0.05 0.82 0.82> translate <-6.7 0 0> } // Band
            intersection { X_Disk scale <0.25 0.78 0.76> translate <-6.5 0 0> } // Band
            intersection { X_Disk scale <0.05 0.82 0.82> translate <-6.3 0 0> } // Band
        }
        color Yellow
        texture {
            Nickle_Silver
        }
    }

    object {
        // Bamboo flyrod (sorry, it's not tapered)
        intersection { Hexagon
            rotate <30 0 0>
        }
        color Green
        texture {
            Shiny
            gradient <1 0 0>
            color_map {
                [0.0 0.02 color red 0.35 color red 0.35]
                [0.02 0.03 color Yellow color Yellow]
                [0.03 0.07 color red 0.35 color red 0.35]
                [0.07 0.08 color Yellow color Yellow]
                [0.08 0.1 color red 0.35 color red 0.35]
                [0.1 0.3 color Bamboo1 color Bamboo2]
                [0.3 0.4 color Bamboo2 color Bamboo2]
                [0.4 1.0 color Bamboo2 color Bamboo1]
            }
            scale <0.1 1 1>
            translate <-1 0 0>
        }

        scale <100 0.25 0.25>
        translate <110 0 0>
    }

}    // end of flyrod composite


// A round headed screw.  I tried using a gradient for the slot, but
// this looks *much* better.
#declare Screw = difference {
    quadric { Ellipsoid }
    box { UnitBox scale <1 0.1 1> translate <0 0 -1>}
    scale <1 1 0.2>       // Scale to unit proportions
    scale <.05 .05 .05>     // Now, rescale to *useable* proportions

}

// This is the reel release lever
#declare Release = union {
    box { UnitBox scale <0.15 0.0875 0.015> }
    intersection { Z_Disk scale <0.0875 0.0875 0.015> translate <-0.15 0 0>}
    translate <-0.15 0 0>    // Right edge at x=0
}

#declare UL_Brace_Corner = difference {
    box { UnitBox}
    quadric {Cylinder_X scale <1 2.35 2.35> translate <0 1 1>}
    scale <0.075 0.25 0.25 >
}
#declare UR_Brace_Corner = difference {
    box { UnitBox}
    quadric {Cylinder_X scale <1 2.35 2.35> translate <0 1 -1>}
    scale <0.075 0.25 0.25 >
}
#declare LL_Brace_Corner = difference {
    box { UnitBox}
    quadric {Cylinder_X scale <1 2.35 2.35> translate <0 -1 1>}
    scale <0.075 0.25 0.25 >
}
#declare LR_Brace_Corner = difference {
    box { UnitBox}
    quadric {Cylinder_X scale <1 2.35 2.35> translate <0 -1 -1>}
    scale <0.075 0.25 0.25 >
}

#declare Brace =  union {
        box { UnitBox scale <0.075 0.075 0.85 > }
        difference { UL_Brace_Corner translate <0  0.325 -0.6>}
        difference { LL_Brace_Corner translate <0 -0.325 -0.6>}
        difference { UR_Brace_Corner translate <0  0.325 +0.6>}
        difference { LR_Brace_Corner translate <0 -0.325 +0.6>}
    }

#declare Reel = composite {

    // Flyline (off the reel)
    object {
        union {
            intersection { X_Disk
                scale <30 0.055 0.055>
                translate <30 -2 0>
       //         rotate <0 0 5>
            }
            intersection { X_Disk
                scale <30 0.055 0.055>
                translate <60 -2 0>
            }
        }
        texture { color White }
    }



    // Inner spool w/line on it
    // This is simply a Z_Disk with separate textures on each part.
    // The gradients are to simulate the flyline
    object {
        intersection {
            quadric { Cylinder_Z
                texture {
                    gradient <0 0 1>
                    color_map {
                        [0.0  0.25 color DimGray color White]
                        [0.25 0.75 color White color White]
                        [0.75  1.0 color White  color DimGray  ]
                    }
                    scale <1 1 0.1 >
                    ambient 0.15
                }
            }
            plane { <0 0 1> -1 inverse
                texture {
                    wood
                    turbulence 0
                    color_map {
                        [0.0  0.25 color DimGray color White]
                        [0.25 0.75 color White color White]
                        [0.75  1.0 color White  color DimGray  ]
                    }
                    scale <0.1 0.1 1 >
                    ambient 0.15
                }
            }

            plane { <0 0 1>  1
                texture {
                    wood
                    turbulence 0
                    color_map {
                        [0.0  0.25 color DimGray color White]
                        [0.25 0.75 color White color White]
                        [0.75  1.0 color White  color DimGray  ]
                    }
                    scale <0.1 0.1 1 >
                    ambient 0.15
                }
            }
        }
        color Blue
        scale <1.65 1.65 1>
    }

    // Flanges
    object {
        difference {
            difference {
                union {
                    intersection { Z_Disk scale <2 2 0.15> translate <0 0 -1> }
                    intersection { Z_Disk scale <2 2 0.15> translate <0 0  1> }
                }
                union {
                    intersection { Z_Disk scale <1.95 1.95 0.075> translate <0 0 -1.15> }
                    intersection { Z_Disk scale <1.95 1.95 0.075> translate <0 0  1.15> }
                }
            }
            union {
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> }
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0  22.5>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0  45>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0  67.5>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0  90>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 112.5>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 135>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 157.5>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 180>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 202.5>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 225>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 247.5>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 270>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 292.5>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 315>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 337.5>}

                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> }
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0  22.5>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0  45>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0  67.5>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0  90>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 112.5>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 135>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 157.5>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 180>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 202.5>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 225>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 247.5>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 270>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 292.5>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 315>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 337.5>}
            }
        }
        bounded_by { intersection { Z_Disk scale <2.1 2.1 1.2> } }
        color Cyan
        texture { Reel_Texture }
    }

    // Handle
    object {
        union {
            intersection { Z_Disk scale <0.2 0.2 0.5>
                translate <0 1.5 -1.5>
                rotate <0 0 22.5>
            }
            // Button on the end of the handle
            quadric { Ellipsoid  scale <0.15 0.15 0.025>
                translate <0 1.5 -2>
                rotate <0 0 22.5>
                texture { Nickle_Silver }
            }
        }
        color Magenta
        texture {
            specular 1  roughness 0.05
            phong 1 phong_size 150
            color Gray25
        }
    } // end of handle


    // Hub cap
    object {
        union {
            intersection { Z_Disk scale <0.35 0.35 0.1>  }
            quadric { Ellipsoid scale <0.25 0.25 0.15> }
            union { Release translate <-0.25 0 0>}
            union {
                difference { Screw translate < 0.25 0 -0.1> }
                difference { Screw translate <-0.25 0 -0.1> }
                rotate <0 0 60>
            }
        }
        bounded_by { sphere { <0 0 0> 0.75 } }
        translate <0 0 -1.1>
        texture { Nickle_Silver }
    } // end of hub cap


    // Reel Frame
    object {
        union {
            difference {
                union {
                    intersection { Z_Disk scale <2.25 2.25 0.10> translate <0 0 -1> }
                    intersection { Z_Disk scale <2.25 2.25 0.10> translate <0 0  1> }
                }
                union {
                    quadric { Cylinder_Z scale <2.075 2.075 1> }
                    quadric { Cylinder_Z scale <2.075 2.075 1> }
                }
            }
            // Crossbars
            union { Brace translate < 2.1725 0 0> }
            union { Brace rotate <0 0 90> translate <0 -2.1725 0> }
            union { Brace translate <-2.1725 0 0> }
            // Beaded rim
            intersection { Split_Torus translate <0 0 -1.10>}
            intersection { Split_Torus rotate <180 0 0> translate <0 0 +1.10>}
        }
        color Red
        texture { Reel_Texture }
        bounded_by { intersection { Z_Disk scale <2.4 2.4 1.21> } }
    } // end of reel frame


    // Reel Foot
    object {
        union {
            intersection {
                difference {
                    intersection {X_Disk scale <1.75 0.77 0.77> }
                    intersection {X_Disk scale <1.85 0.75 0.75> }
                }
                plane { <0 1 0> -0.40 }
                quadric { Cylinder_Y scale <1.75 0.75 1>}
            }
            box { UnitBox scale <0.5 0.075 0.50> translate <0 -0.825 0> }
            box { UnitBox scale <0.25 0.075 0.85> translate <0 -0.975 0> color Green }
        }
        color Orange
        texture { Reel_Texture }
        bounded_by {
            box { UnitBox scale <1.85 1 0.85> }
        }
        translate <0 2.77 0>
    }  // end of reel foot
}




// White reflecting plane to highlight the metal textures
//object { plane { <0 0 1> -500 rotate <0 -45 0> texture { color White ambient 1} } }




// Wooded environment map, reflected in the end cap on the reelseat.
// Looks sort of like leaves and branches, if you use your imagination.
#declare Woods = object { plane { <0 0 1> -2000 }
    texture {
        bozo
        turbulence 0.25
        color_map {
            [0.0 0.25 color ForestGreen color ForestGreen]
            [0.25 0.35 color ForestGreen color GreenYellow]
            [0.35 0.50 color GreenYellow color ForestGreen]
            [0.50 0.8 color ForestGreen color green 0.1]
            [0.80 1.0 color green 0.1 color ForestGreen]
        }
        scale <10 10 10>
    }
    texture {
        marble
        turbulence 0.65
        octaves 3
        color_map {
            [0.0 0.7 color Clear color Clear]
            [0.7 1.0 color DarkWood color DarkWood]
        }
        scale <50 100 1>
    }
    texture {
        bozo
        turbulence 0.25
        color_map {
            [0.0 0.25 color ForestGreen color ForestGreen]
            [0.25 0.35 color ForestGreen color GreenYellow]
            [0.35 0.50 color Clear color Clear]
            [0.50 0.8 color ForestGreen color green 0.1]
            [0.80 1.0 color green 0.1 color ForestGreen]
        }

    scale <125 250 1>
    }
}

object { Woods                  }
object { Woods rotate <0  60 0> }
object { Woods rotate <0 -60 0> }

#declare DarkSummerSky = color red 0.055 green 0.175 blue 0.22
// Sky sphere
object { quadric { Ellipsoid scale <10000 5000 10000> } texture {0.035 color DarkSummerSky ambient 1 diffuse 0} }

composite {
    composite {Reel translate <-8 -2.75  0> }
    composite {FlyRod}
    rotate <0 -65 0>
}

// Simple plane to simulate water, but only in the reflection
object { plane { <0 1 0> -2000 }
    texture {
        waves 1
        frequency 100
        scale <25 1 25>
        translate <-1000 0 -1000>
        reflection 0.25
        specular 1 roughness 0.01
        color red .11 green .35 blue 0.44
        ambient .5
    }
}
