// Persistence of Vision Raytracer
// Flyrod & flyreel by Dan Farmer  May '92
// 5 hours 17 min on 33/486 +a0.1 640x480
#include "include.inc"
#declare Bamboo1 = colour  red   1.00 green   0.78 blue   0.46
#declare Bamboo2 = colour  red   0.97 green   0.82 blue   0.47

#declare Reel_Texture = texture {
    0.1
    Shiny
    color Gray50
}

#declare Nickle_Silver = texture {
    0.25
    Metal
    color red 0.94 green 0.93 blue 0.83
}


#declare Cork = texture {
    0.05
    granite
    colour_map {
        [0.0 0.6  colour red 0.93 green 0.71 blue 0.532
                  colour red 0.98 green 0.81 blue 0.60]
        [0.6 0.65 colour red 0.50 green 0.30 blue 0.20
                  colour red 0.50 green 0.30 blue 0.20]
        [0.65 1.0 colour red 0.80 green 0.53 blue 0.46
                  colour red 0.85 green 0.75 blue 0.35]
    }
    scale <0.25 0.25 0.25>
    specular 0.1 roughness 0.5 // Very dull
    ambient 0.1
    diffuse 0.5
}

#declare RoseWood = texture {
    DMFWood3
    rotate <0 875 0>              // For x cylinder on reelseat (almost 90)
    ambient 0.3
    specular 0.85 roughness 0.005
}

// Torus, Outer 2.23, inner 2.075.
// Used as beaded rim on flyreel frame
#declare Split_Torus =
    intersection {
        quartic {
           <    1.000000 0.000000 0.000000 0.000000 2.000000
                0.000000 0.000000 2.000000 0.000000 -9.368125
                0.000000 0.000000 0.000000 0.000000 0.000000
                0.000000 0.000000 0.000000 0.000000 0.000000
                1.000000 0.000000 0.000000 2.000000 0.000000
                9.337500 0.000000 0.000000 0.000000 0.000000
                1.000000 0.000000 -9.368125 0.000000 21.797227
            >
        }
    plane {<0 1 0> 0}
    rotate <90 0 0>
}



// Closeup view of the reel set and reel
camera {
   location <-18.0  2  -20>
   direction <0.0 0.0  3.0>
   up  <0.0  1.0  0.0>
   right <1.33333 0.0 0.0>
   look_at <-6 -2 0>
}

object { light_source  { <-2  30 -20>  color White  } }
object { light_source  { < -20 5 -5>  color Gray75  } }
object { sphere {<0 0 0> 10000 } texture {0.035 color DimGray ambient 1 diffuse 0} }

// Reflecting plane for metal textures
object { plane { <0 0 1> -500 } texture { color White ambient 1 } }

#declare FlyRod = composite {

    // Cork flyrod handle
    object {
        union {
            intersection { X_Disk }
            quadric { Ellipsoid translate <1 0 0> }
        }
        color Red
        texture { Cork scale <2 1 1> }
        scale <5 1 1>
    }

    // Reelseat
    object {
        intersection { X_Disk scale <2 0.75 0.75> translate <-7 0 0> }
        color Orange
        texture { RoseWood
            DMFWood3
            rotate <0 90 0>
            ambient 0.25
            specular 0.85 roughness 0.005
        }
    }

    // Metal Cap and band for end of reelseat
    object {
        union {
            intersection { X_Disk scale <0.5 0.78 0.76> translate <-9.5 0 0> } // Cap
            intersection { X_Disk scale <0.05 0.82 0.82> translate <-9.05 0 0> }
            quadric { Ellipsoid   scale <0.20 0.80 0.80> translate <-10 0 0> }

            intersection { X_Disk scale <0.05 0.82 0.82> translate <-6.7 0 0> } // Band
            intersection { X_Disk scale <0.25 0.78 0.76> translate <-6.5 0 0> } // Band
            intersection { X_Disk scale <0.05 0.82 0.82> translate <-6.3 0 0> } // Band
        }
        color Yellow
        texture {
            Nickle_Silver
        }
    }


    object {
        // Bamboo flyrod (sorry, it's not tapered)
        intersection { Hexagon
            rotate <30 0 0>
        }
        color Green
        texture {
            Glossy
            gradient <1 0 0>
            color_map {
                [0.0 0.02 color green 0.35 color green 0.35]
                [0.02 0.03 color Yellow color Yellow]
                [0.03 0.07 color green 0.35 color green 0.35]
                [0.07 0.08 color Yellow color Yellow]
                [0.08 0.1 color green 0.35 color green 0.35]
                [0.1 1.0 color Bamboo1 color Bamboo2]
            }
            scale <0.1 1 1>
            translate <-1 0 0>
        }


/* ----------
        // Graphite flyrod (tapered)
        union {
            intersection { HalfCone_Y
                rotate <0 0 -90>
            }
        }
        color Green
        texture {
            Glossy
            gradient <1 0 0>
            color_map {
                [0.0 0.02 color Red color Red]
                [0.02 0.03 color Black color Black]
                [0.03 0.07 color Red color Red]
                [0.07 0.08 color Black color Black]
                [0.08 0.1 color Red color Red]
                [0.1 1.0 color Gray50 color Gray50]
            }
            scale <0.1 1 1>
            translate <-1 0 0>
        }
----------------*/
        scale <100 0.25 0.25>
        translate <110 0 0>
    }

}    // end of flyrod composite


// A round headed screw.  I tried using a gradient for the slot, but
// this looks *much* better.
#declare Screw = difference {
        quadric { Ellipsoid }
        box { UnitBox scale <1 0.1 1> translate <0 0 -1>}
        scale <1 1 0.2>       // Scale to unit proportions
        scale <.05 .05 .05>     // Now, rescale to *useable* proportions

}

// This is the reel release lever
#declare Release = union {
        box { UnitBox scale <0.15 0.0875 0.015> }
        intersection { Z_Disk scale <0.0875 0.0875 0.015> translate <-0.15 0 0>}
        translate <-0.15 0 0>    // Right edge at x=0
}

#declare UL_Brace_Corner = difference {
    box { UnitBox}
    quadric {Cylinder_X scale <1 2.35 2.35> translate <0 1 1>}
    scale <0.075 0.25 0.25 >
}
#declare UR_Brace_Corner = difference {
    box { UnitBox}
    quadric {Cylinder_X scale <1 2.35 2.35> translate <0 1 -1>}
    scale <0.075 0.25 0.25 >
}
#declare LL_Brace_Corner = difference {
    box { UnitBox}
    quadric {Cylinder_X scale <1 2.35 2.35> translate <0 -1 1>}
    scale <0.075 0.25 0.25 >
}
#declare LR_Brace_Corner = difference {
    box { UnitBox}
    quadric {Cylinder_X scale <1 2.35 2.35> translate <0 -1 -1>}
    scale <0.075 0.25 0.25 >
}

#declare Brace =  union {
        box { UnitBox scale <0.075 0.075 0.85 > }
        difference { UL_Brace_Corner translate <0  0.325 -0.6>}
        difference { LL_Brace_Corner translate <0 -0.325 -0.6>}
        difference { UR_Brace_Corner translate <0  0.325 +0.6>}
        difference { LR_Brace_Corner translate <0 -0.325 +0.6>}
    }

#declare Reel = composite {

    // Flyline (off the reel)
    object {
        intersection { X_Disk
            scale <100 0.075 0.075>
        }
        texture { color White }
        translate <100 -2 0>
        rotate <0 0 5>
    }



    // Inner spool w/line on it
    // This is simply a Z_Disk with separate textures on each part.
    // The gradients are to simulate the flyline
    object {
        intersection {
            quadric { Cylinder_Z
                texture {
                    gradient <0 0 1>
                    color_map {
                        [0.0  0.25 color DimGray color White]
                        [0.25 0.75 color White color White]
                        [0.75  1.0 color White  color DimGray  ]
                    }
                    scale <1 1 0.1 >
                    ambient 0.3
                }
            }
            plane { <0 0 1> -1 inverse
                texture {
                    wood
                    turbulence 0
                    color_map {
                        [0.0  0.25 color DimGray color White]
                        [0.25 0.75 color White color White]
                        [0.75  1.0 color White  color DimGray  ]
                    }
                    scale <0.1 0.1 1 >
                    ambient 0.3
                }
            }

            plane { <0 0 1>  1
                texture {
                    wood
                    turbulence 0
                    color_map {
                        [0.0  0.25 color DimGray color White]
                        [0.25 0.75 color White color White]
                        [0.75  1.0 color White  color DimGray  ]
                    }
                    scale <0.1 0.1 1 >
                    ambient 0.3
                }
            }
        }
        color Blue
        scale <1.65 1.65 1>
    }

    // Flanges
    object {
        difference {
            difference {
                union {
                    intersection { Z_Disk scale <2 2 0.15> translate <0 0 -1> }
                    intersection { Z_Disk scale <2 2 0.15> translate <0 0  1> }
                }
                union {
                    intersection { Z_Disk scale <1.95 1.95 0.075> translate <0 0 -1.15> }
                    intersection { Z_Disk scale <1.95 1.95 0.075> translate <0 0  1.15> }
                }
            }
            union {
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> }
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0  22.5>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0  45>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0  67.5>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0  90>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 112.5>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 135>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 157.5>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 180>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 202.5>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 225>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 247.5>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 270>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 292.5>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 315>}
                quadric { Cylinder_Z scale <0.2 0.2 1> translate <0 1.5 0> rotate <0 0 337.5>}

                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> }
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0  22.5>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0  45>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0  67.5>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0  90>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 112.5>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 135>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 157.5>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 180>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 202.5>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 225>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 247.5>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 270>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 292.5>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 315>}
                quadric { Cylinder_Z scale <0.125 0.125 1> translate <0 1 0> rotate <0 0 337.5>}
            }
        }
        bounded_by { intersection { Z_Disk scale <2.1 2.1 1.2> } }
        color Cyan
        texture { Reel_Texture }
    }

    // Handle
    object {
        union {
            intersection { Z_Disk scale <0.2 0.2 0.5>
                translate <0 1.5 -1.5>
                rotate <0 0 22.5>
            }
            // Button on the end of the handle
            quadric { Ellipsoid  scale <0.15 0.15 0.025>
                translate <0 1.5 -2>
                rotate <0 0 22.5>
                texture { Nickle_Silver }
            }
        }
        color Magenta
        texture { Shiny color Black }
    } // end of handle


    // Hub cap
    object {
        union {
            intersection { Z_Disk scale <0.35 0.35 0.1>  }
            quadric { Ellipsoid scale <0.25 0.25 0.15> }
            union { Release translate <-0.25 0 0>}
            union {
                difference { Screw translate < 0.25 0 -0.1> }
                difference { Screw translate <-0.25 0 -0.1> }
                rotate <0 0 60>
            }
        }
        bounded_by { sphere { <0 0 0> 0.75 } }
        translate <0 0 -1.1>
        texture { Nickle_Silver }
    } // end of hub cap

    // Reel Frame
    object {
        union {
            difference {
                union {
                    intersection { Z_Disk scale <2.25 2.25 0.15> translate <0 0 -1> }
                    intersection { Z_Disk scale <2.25 2.25 0.15> translate <0 0  1> }
                }
                union {
                    quadric { Cylinder_Z scale <2.075 2.075 1> }
                    quadric { Cylinder_Z scale <2.075 2.075 1> }
                }
            }
            // Crossbars
            union { Brace translate < 2.1725 0 0> }
            union { Brace rotate <0 0 90> translate <0 -2.1725 0> }
            union { Brace translate <-2.1725 0 0> }
            // Beaded rim
            intersection { Split_Torus translate <0 0 -1.15>}
            intersection { Split_Torus rotate <180 0 0> translate <0 0 +1.15>}
        }
        color Red
        texture { Reel_Texture }
        bounded_by { intersection { Z_Disk scale <2.4 2.4 1.21> } }
    } // end of reel frame

    // Reel Foot
    object {
        union {
            intersection {
                difference {
                    intersection {X_Disk scale <1.75 0.77 0.77> }
                    intersection {X_Disk scale <1.85 0.75 0.75> }
                }
                plane { <0 1 0> -0.40 }
                quadric { Cylinder_Y scale <1.75 0.75 1>}
            }
            box { UnitBox scale <0.5 0.075 0.50> translate <0 -0.825 0> }
            box { UnitBox scale <0.25 0.075 0.85> translate <0 -0.975 0> color Green }
        }
        color Orange
        texture { Reel_Texture }
        bounded_by {
            box { UnitBox scale <1.85 1 0.85> }
        }
        translate <0 2.77 0>
    }  // end of reel foot
}

composite {
    composite {Reel translate <-8 -2.75  0> }
    composite {FlyRod}
}
