// Persistence Of Vision raytracer version 1.0 sample file.
// By Dan Farmer
#include "include.inc"

camera {
   location  <0 1 -4>
   direction <0 0 FoV_45>
   up        <0 1 0>
   right     <1.333 0 0>
   look_at   <0 0 0>
   }

object {
   light_source {
      <15 25 -20>
      color red 1 green 1 blue 0.85
      }
   }
object {
   light_source {
      < 5 -10 -25>
      color red 0.85 green 0.85 blue 1
      }
   }

object {
   light_source {
      < 0 -0.1 0>
      color White
      }
   }

object {
    blob {
        threshold 0.6
        component 1.0 1.0  <-0.900  0.000  0.000>
        component 1.0 1.0  < 0.900  0.000  0.000>
        component 1.0 1.0  < 0.000  0.000 -0.900>
        component 1.0 1.0  < 0.000  0.000  0.900>
      sturm
    }
    texture {
        Metal
        onion
        color_map {
            [0.0 0.20  color Blue  color Green]
            [0.20 0.40  color Green  color Yellow]
            [0.40 0.60  color Yellow color Orange]
            [0.60 0.85 color Orange color Red]
            [0.80 1.0 color Red color Blue]
        }
    }
    rotate <90 0 0>
    scale <0.5 1 0.5>
}
object {
    quadric { Ellipsoid scale <0.5 0.5 0.5> }
    texture {
    Metal
    color White
    }
    scale <0.5 1 0.5>
}
