//---- Trumans excellent Sword ........ 1312 AD


#include "gold.inc"


#declare QSphere =
   quadric {
      Sphere
   }

#declare blade_texture =
   texture {
      metallic
      color Gold
      ambient 0.2
      diffuse 0.8
      phong 1.0
      phong_size 100
      roughness 0.000001
      brilliance 2
      reflection 0.2
   }

#declare handle_texture =
   texture {
      color Sienna
      ambient 0.15
      diffuse 0.8
      specular 1.0
      roughness 0.000001
      brilliance 2.0
   }

#declare handle_ball_texture =
   texture {
      color      OldGold
      ambient    0.2
      diffuse    0.7
      brilliance 1.5
      specular   1.0
      roughness  0.00000001
      reflection 0.7
   }

#declare hand_plate_texture =
   texture {
      handle_ball_texture
   }

#declare grip_texture =
   texture {
      marble
      turbulence 1.00
      color_map {
          [0.00 0.10 color red 0.42 green 0.26 blue 0.15
                     color red 0.00 green 0.00 blue 0.00]
          [0.10 0.90 color red 0.00 green 0.00 blue 0.00
                     color red 0.52 green 0.37 blue 0.26]
          [0.90 1.01 color red 0.52 green 0.37 blue 0.26
                     color red 0.42 green 0.26 blue 0.15]
      }
      ambient 0.2
      diffuse 0.7
      phong 1.0
      phong_size 50
      scale <2 2 2>
   }

#declare handle_ball =
   object {
     sphere { <0 0 0> 5 }
   }

#declare blade =
   object {
      difference {
         union {
            intersection {
               union {
                  quadric {
                     QSphere
                     scale <105 4.5 1>
                  }
                  difference {
                     quadric {
                        QSphere
                        scale <10 10 1>
                     }
                     quadric {
                        QSphere
                        scale <10 12 2>
                        translate <-6 0 0>
                     }
                     translate <-10 0 0>
                  }
               }
               plane { <0 0 -1> 0 rotate <-1.2 0 0> translate <0 0 -0.5> }
               plane { <0 0 -1> 0 rotate < 1.2 0 0> translate <0 0 -0.5> }
               plane { <0 0  1> 0 rotate < 1.2 0 0> translate <0 0 0.5> }
               plane { <0 0  1> 0 rotate <-1.2 0 0> translate <0 0 0.5> }
               plane { <1 0  0> 0 }
            }
         }
         quadric {  // groove in blade : side 1
            QSphere
            scale <100 0.8 0.6>
            translate <0 0 -0.65>
         }
         quadric {  // groove in blade : side 2
            QSphere
            scale <100 0.8 0.6>
            translate <0 0 0.65>
         }
      }
      bounded_by {
         sphere { <-53 0 0> 54 }
      }
   }

#declare hand_plate =
   object {
      union {
         union {
            quadric { QSphere scale <2.0 6 6> }
            quadric { QSphere scale <2.4 4 4> }
            quadric { QSphere scale <2.6 2 2> }
            translate <0 0 5>
         }
         union {
            quadric { QSphere scale <2.0 6 6> }
            quadric { QSphere scale <2.4 4 4> }
            quadric { QSphere scale <2.6 2 2> }
            translate <0 0 -5>
         }
      }
      bounded_by {
         sphere { <0 0 0> 22 }
      }
   }

#declare handle =
   object {
      intersection {
         quadric {
            QSphere
            scale <19 3.3 1.5>
            translate <18 0 0>
         }
         plane { <-1 0 0> -2 }
      }
      bounded_by {
         sphere { <18 0 0> 20 }
      }
   }

#declare rubber_bump =
   quadric {
      QSphere
      scale <1.5 2.5 1.92>
      rotate <0 0 -20>
   }

#declare grip =
   object {
      union { // rubber on grip
         quadric { rubber_bump translate < 3 0 0> }
         quadric { rubber_bump translate < 4 0 0> }
         quadric { rubber_bump translate < 5 0 0> }
         quadric { rubber_bump translate < 6 0 0> }
         quadric { rubber_bump translate < 7 0 0> }
         quadric { rubber_bump translate < 8 0 0> }
         quadric { rubber_bump translate < 9 0 0> }
         quadric { rubber_bump translate <10 0 0> }
         quadric { rubber_bump translate <11 0 0> }
         quadric { rubber_bump translate <12 0 0> }
         quadric { rubber_bump translate <13 0 0> }
         quadric { rubber_bump translate <14 0 0> }
         quadric { rubber_bump translate <15 0 0> }
         quadric { rubber_bump translate <16 0 0> }
         quadric { rubber_bump translate <17 0 0> }
         quadric { rubber_bump translate <18 0 0> }
         quadric { rubber_bump translate <19 0 0> }
         quadric { rubber_bump translate <20 0 0> }
         quadric { rubber_bump translate <21 0 0> }
         quadric { rubber_bump translate <22 0 0> }
         quadric { rubber_bump translate <23 0 0> }
         quadric { rubber_bump translate <24 0 0> }
         quadric { rubber_bump translate <25 0 0> }
         quadric { rubber_bump translate <26 0 0> }
         quadric { rubber_bump translate <27 0 0> }
         quadric { rubber_bump translate <28 0 0> }
         quadric { rubber_bump translate <29 0 0> }
         quadric { rubber_bump translate <30 0 0> }
         quadric { rubber_bump translate <31 0 0> }
         quadric { rubber_bump translate <32 0 0> }
         quadric { rubber_bump translate <33 0 0> }
         quadric { rubber_bump translate <34 0 0> }
         quadric { rubber_bump translate <35 0 0> }
         quadric { rubber_bump translate <36 0 0> }
         quadric { rubber_bump translate <37 0 0> }
         quadric { rubber_bump translate <38 0 0> }
      }
      bounded_by {
         sphere { <18 0 0> 20 }
      }
   }

#declare sword =
   composite {
      object { handle_ball translate <38 0 0> texture { handle_ball_texture } }
      object { blade                          texture { gold2   } }
      object { grip                           texture { grip_texture        } }
      object { handle                         texture { handle_texture      } }
      object { hand_plate                     texture { hand_plate_texture  } }
      bounded_by {
         quadric {
            QSphere
            scale <150 20 20>
         }
      }
      translate <45 0 0>
   }
