//----- Birthday Cake, Slice, & #1



// Makes a GREAT chocolate frosting
#declare Icing = 
    texture {
        specular 0.25  roughness 0.025
        color SemiSweetChoc
        bumps 1
        scale <0.1 0.2 0.1>
    }

// Red Gum Balls
#declare GumBall =
object {
    sphere {<0 .5 0> .2 }
	texture {	
	color Red
	phong 1
	phong_size 80
	ambient .2
	}
translate <1.4 0 0>
}

#declare CakeTorus =
   quartic { 
      < 1 0 0 0 2 0 0 2 0 -5.00000000000
        0 0 0 0 0 0 0 0 0 0
        1 0 0 2 0 4.00000000000 0 0 0 0
        1 0 -5.00000000000 0 4.00000000000 >
        sturm
}



//----- Chocklate Outside
#declare Cake = composite {
  object {
    union {
        quartic { CakeTorus }  // rounded cake edge
        quadric { Sphere scale <1.5 0.001 1.5> translate <0 0.5 0> } // Cake top
        intersection { Y_Disk  scale <2 0.5 2> translate <0 -0.5 0>}  // Cake sides
        intersection { Y_Disk  scale <1.5 0.5 1.5> translate <0 0 0>} 
    }
	  texture { 
	  Icing
          }
		clipped_by {   //----Cut a Slice out of the cake
		   box { UnitBox inverse		
		   rotate <0 45 0>
		   scale <1.5 3 3>
		   translate <0 0 -4.5> 
		   }
			intersection { Y_Disk inverse
			scale < .6 .7 .6 >
			translate < 0 -.4 0>
			}
		}
				bounded_by {
				sphere { <0 0 0> 3 }
				}

    }

//------ Fluffy cake inside
    object {
	intersection {
       		union {
        	quartic { CakeTorus scale <.99 .99 .99>  }  // rounded cake edge
            	quadric { Sphere scale <1.499 0.0001 1.499> translate <0 0.5 0> } // Cake top
            	intersection { Y_Disk  scale <1.999 0.5 1.999> translate <0 -0.5 0>}  // Cake sides
                intersection { Y_Disk  scale <1.5 0.5 1.5> translate <0 0 0>} 
	        }
			box { UnitBox inverse 	
			rotate <0 45 0>
			scale <1.5 3 3>
			translate <0 0 -4.55> 
			}
			intersection { Y_Disk inverse
			scale < .6 .7 .6 >
			translate < 0 -.4 0>

			}
	}
        texture {
            gradient <0 1 0>
		color_map {
		[0.0 0.1 color SemiSweetChoc color SemiSweetChoc]
		[0.1 1.1 color Gold color Gold]
		}
		.1
		ambient .5 
		diffuse .8
	   translate <0 -.2 0>	
        }
	texture {
	color Clear
	bumps 1
	scale <.03 .03 .03>
	rotate <-45 0 0>
	phong 1
	ambient .2	
	diffuse .8 
	}
				bounded_by {
				sphere { <0 0 0> 3 }
				}
    }

//--- If someone can find a better frosting decoration, please do. <g> MM

object { GumBall rotate <0 0 0> }
object { GumBall rotate <0 50 0> }
object { GumBall rotate <0 130 0> }
object { GumBall rotate <0 180 0> }
object { GumBall rotate <0 240 0> }
object { GumBall rotate <0 300 0> }
    translate <0 1 0>
}


// The number "1".  Base is on y=0
#declare One = object {
    union {
        box { UnitBox scale <5.5 1.5 1> translate <0 1.5 0> }     // Foot
        box { UnitBox scale <2.5 6.5 1> translate <0 9.5 0> }     // Body
        difference {
            box { UnitBox        scale <1.5 2.5 1>  translate <-4.0 13.5 0> }   // Serif
            quadric { Cylinder_Z scale <3.0 3.0 1>  translate <-5.5 16.0 0> }
        }
    }
    bounded_by { box { UnitBox scale <5.501 16.01 1.01> translate <0 16 0> } }
    color White
    scale <0.0625 0.0625 0.0625>   // Normalize to unit size (on height)
    translate <0 -0.03125 0>
    translate <0 -0.5 0>
}


    // The big "1" decoration, sunk slightly (0.05) into the "frosting"
#declare One_Candle =
    object { One
        texture {
	color Gray
	ambient .2
	specular .5
	reflection .4
        }
    scale <1 1 3>       // make it thicker
    rotate <0 -10 0>
    translate <0 1.99 0>
    }




// A platter for the cake : Bottom of platter at Y=0
#declare Platter = 
object {
    quadric {Sphere scale <1 0.25 1> }
    clipped_by {
        plane { <0 1 0> 0}
    }
    texture {
        Phong_Glossy
        onion
        color_map {
            [0.0 0.85 color White color White]
            [0.85 1.0 color Blue color Blue]
        }
	reflection .3
	scale <0.05 0.05 0.05>
  	ambient 0.2
    }
    scale <2.5 2 2.5>
    translate <0 0.5 0>  
    translate <0 -0.245 0>
}



//-------- The Slice out of the cake
#declare Slice =
composite {
    object {
          union {
          quartic { CakeTorus }  // rounded cake edge
          quadric { Sphere scale <1.5 0.001 1.5> translate <0 0.5 0> } // Cake top
          intersection { Y_Disk  scale <2 0.5 2> translate <0 -0.5 0>}  // Cake sides
          intersection { Y_Disk  scale <1.5 0.5 1.5> translate <0 0 0>} 
          }
        texture {
	Icing
        }
		clipped_by {
		plane { <1 0 0> 0 rotate <0 20 0> inverse }
		plane { <1 0 0> 0 rotate <0 -20 0>  }
		}
		
			bounded_by {
			sphere { <0 0 0> 3 }
			}

    }

//------ Fluffy cake inside
    object {
	difference {
          union {
          quartic { CakeTorus scale <.99 .99 .99>  }  // rounded cake edge
          quadric { Sphere scale <1.499 0.0001 1.499> translate <0 0.5 0> } // Cake top
          intersection { Y_Disk  scale <1.999 0.5 1.999> translate <0 -0.5 0>}  // Cake sides
          intersection { Y_Disk  scale <1.5 0.5 1.5> translate <0 0 0>} 
	  }
		plane { <1 0 0> 0 rotate <0 20 0> }
		plane { <1 0 0> 0 rotate <0 -20 0> inverse }
         }

        texture {
            gradient <0 1 0>
		color_map {
		[0.0 0.1 color SemiSweetChoc color SemiSweetChoc]
		[0.1 1.1 color Gold color Gold]
		}
		.1
		ambient .5 
		diffuse .8
	   translate <0 -.2 0>	
        }
	texture {
	color Clear
        specular 0.25  
	roughness 0.025
	bumps 1
	rotate <-45 0 0>
	scale <.03 .03 .02>
	ambient .2	
	diffuse .8 
	}
				bounded_by {
				sphere { <0 0 0> 3 }
				}
    }


object { GumBall rotate <0 90 0> }
	translate <0 1 0>
}







//---- One Slice of Cake on a smaller platter
#declare Serving =
composite {
	object { Platter scale <.7 .7 .7> translate <0  0  -1> }
	composite { Slice translate <0 -.15 0> scale <.9 .9 .9> }
}









		














