// Persistence Of Vision raytracer version 1.0 
// Two fairly simple csg shapes
// A roofless ruined building
// A rock that was put in mainly to fill a hole in the picture


#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "shapesq.inc"

#declare text = texture 
	{
	
	Stone19
   }

#declare text1 = texture 
	{
	
	Stone1
   }




#declare block1 =
	union {
	box {UnitBox
	scale <1.0 1.15 1.05>}
	quadric {Ellipsoid
	scale < 1.0 1.2 1.1 >}
	}

#declare block2 =
	union {
	box {UnitBox
	scale <1.1 0.9 1.07>}
	quadric { Ellipsoid
	scale < 1.1 1.0 1.1 > }
	}

#declare block3 =
	union {
	box {UnitBox
	scale <0.9 0.8 0.95>}
	quadric {Ellipsoid
	scale < 1.0 1.0 1.0 >}
	}

#declare rock1 =
	quartic {Bicorn
	scale <6 5 4> }

#declare rock2 =
	quartic {Bicorn
	scale <5 5 6> }

#declare rock3 =
	quartic {Bicorn
	scale <7 3.6 7> }
	
#declare rock =
	object {
	union {
	quartic {rock3}
	quartic {rock1 translate <2.0 0.0 -3.0>}
	quartic {rock2 translate <3.0 0.0 -2.0>}
	quartic {rock2 translate <-4.0 0.0 2.0>}
	quartic {rock1 translate <-5.0 0.0 3.0>}
	}
	texture {text1 dents 0.8 scale <5 5 5> }
	bounded_by {
	sphere {<0.0 0.0 0.0> 10.0 }
	}
}
	
	

#declare wall1 =
	box {UnitBox
	scale <12.0 8.0 1.0>
	}

#declare wall2 =
	union {
	box {wall1 }
	union {block1 translate <2.0 7.3 -0.15> }
	union {block2 translate <4.0 2.0  -0.2> }
	union {block3 translate <12.0 -7.0 -0.15> }
	union {block3 translate <11.8 -6.0 -0.15> }
	union {block3 translate <11.6 -5.0 -0.15> }
	union {block3 translate <3.0 7.4 -0.1> }
	union {block1 translate <-3.0 7.6 -0.15> }
	union {block2 translate <-7.0 3.0  -0.2> }
	}

#declare Thewall =
object {
	union {
	difference {
	union {wall2 }
	box {UnitBox
	scale < 2.5 2.5 2.5>
	translate <2.0 4.0 0.0> }
	}
	difference {
	union {wall2 }
	box {UnitBox 
	scale < 2.5 7.5 2.5>
	translate <0 -7.8 0.0> }
	rotate <0 -90 0>
	translate <-11.0 0.0 10.0>
	}
	difference {
	union {wall2}
	box {UnitBox
	scale <4.0 4.0 4.0>
	rotate <0 0 40>
	translate <10.0 6.0 0.0> }
	translate < 0.0 0.0 23.0>
	}
	difference {
	union {wall2 }
	box {UnitBox 
	scale < 2.5 7.5 2.5>
	translate <0 -7.8 0.0> }
	box {UnitBox
	scale <12 12 12>
	translate <0 14.0 0>
	rotate <0 0 10> }
	rotate <0 -90 0>
	translate <11.0 0.0 10.0>
	}
	
	 }
	
	
	texture { text }
	bounded_by {
	box {UnitBox scale <20 20 20>}
	}
	
}


	