// Persistence of Vision Raytracer
// Mount Barnsley by Paul Cotterill
// Main height field derived from a Barnsleym3 fractal
// For convenience foreground height field uses a gif that came with POV v1.0
// The birds are meant to be looked at from a distance and at an angle,
// close-up they are revealed as crude wooden models.


#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"
#include "shapesq.inc"
#include "bird1.inc"
#include "mywall.inc"



#declare ScaleX = 1.0    
#declare ScaleZ = 1.0      

camera {
   location <-150.0 250.0  -750.0>
   direction <0.0  0.0  2.25> 
   up <0.0  1.0  0.0>        
   right <1.333333 0.0 0.0>
   look_at <-40.0 50.0  -10.0>
}


#declare MainLight = color red 0.75 green 0.75 blue 0.75
#declare FillLight = color red 0.23 green 0.23 blue 0.25
// Light source (main)
object { light_source { <-500.0  300.0  -340.0> color MainLight } }
object { light_source { <-50.0  300.0  -340.0> color FillLight } }



object {
   height_field  {
     
      gif "mount2.gif"
      scale <640 256 480>
      water_level 0.0
   }
// A pink-tinged cloud texture for the mountains.
   texture {
	bozo
	turbulence 0.5
	color_map {
	[0.0 0.1 color red 0.8 green 0.7 blue 0.7
	color red 0.8 green 0.7 blue 0.7]
	[0.1 0.5 color red 0.8 green 0.7 blue 0.7
	color red 1.0 green 0.9 blue 0.9]
	[0.5 1.0 color red 1.0 green 0.9 blue 0.9 
	color red 1.0 green 1.0 blue 1.0 ]
	}
      
   }
   scale <ScaleX 0.5 ScaleZ> // Reduce the height, scale to 360 x 480 
   translate <-340 0.0 -240>  // Center the image by half of ScaleX and ScaleZ
	rotate < 0 15 0>
   color Brown
 
}

object {
   height_field  {
     
      gif "fract003.gif"
      scale <320 256 200>
      water_level 1.0
   }

texture {
	bozo
	turbulence 0.5
	color_map {
	[0.0 0.1 color red 0.8 green 0.7 blue 0.7
	color red 0.8 green 0.7 blue 0.7]
	[0.1 0.5 color red 0.8 green 0.7 blue 0.7
	color red 1.0 green 0.9 blue 0.9]
	[0.5 1.0 color red 1.0 green 0.9 blue 0.9 
	color red 1.0 green 1.0 blue 1.0 ]
	}
      
   }
  texture {
	bozo
	turbulence 0.5
	
	color_map {
	[0.0 0.1 color red 0.6 green 0.7 blue 0.9
	color red 0.2 green 0.7 blue 0.8]
	[0.1 0.5 color red 0.2 green 0.7 blue 0.8
	color red 0.1 green 0.7 blue 0.5]
	[0.5 1.0 color red 0.1 green 0.7 blue 0.5 alpha 0.5
	color red 0.1 green 0.6 blue 0.3 alpha 1.0]
	}
      
   }


   scale <1.3 0.4 1.3> 
   translate <-300 10.0 -440>  
   rotate < 0 5 0>
   color Brown
 
}



// Sky sphere 
object {
   sphere { <0.0  0.0  0.0> 2000.0 }
   color SummerSky
   texture {
      gradient <0 1 0> 
      color_map {
         [0.00 0.15 color red 0.75 green 0.85 blue 0.95 color red 0.1 green 0.7 blue 0.9] 
         [0.15 0.45 color red 0.1 green 0.7 blue 0.9 color red 0.1 green 0.6 blue 0.85]    
         [0.45 0.87 color red 0.1 green 0.6 blue 0.85   color red 0.1 green 0.5 blue 0.75 ] 
         [0.87 1.01 color red 0.1 green 0.5 blue 0.75  color red 0.1 green 0.3 blue 0.5 ] 
      }
      scale <1000 1000 1000>      // Big enough to surround the universe
      translate <0.0 -240.0 0.0>  // This ajusts for the viewer position 
      ambient 1.0                 // Keep objects from casting shadows 
      diffuse 0.0                 // All light comes from ambient sources 
   }
}
// Cloud sphere
object {
   sphere { <0.0  0.0  0.0> 1800.0 }


   texture {
         turbulence .5
         bozo
         color_map {
           // transparent to transparent 
           [ 0 .6  color red 1 green 1 blue 1 alpha 1  
       
       
                   color red 1 green 1 blue 1 alpha 1]
           // transparent to white 
           [.6 .8  color red 1 green 1 blue 1 alpha 1  
                   color red 1 green 1 blue 1]
           // white to grey 
           [.8 1  color red 1 green 1 blue 1
                  color red 0.8 green 0.8 blue 0.8]
           }
       scale <250  88  450>
       }
       
}


composite {
	bird
	rotate <45 0 0>
	rotate <0 0 30>
	scale <6 6 6>
	translate <-5 130 120>
	
	}

composite {
	bird
	rotate <20 0 0>
	rotate <0 0 -20>
	scale <6 6 6>
	translate <-20 155 150>
	
	}

composite {
	bird
	rotate <35 0 0>
	rotate <0 0 20>
	scale <6 6 6>
	translate <-55 170 180>
	
	}



object {
	Thewall
	scale <2.5 2.5 2.5>
	translate <-54 78 -418>
	rotate <0 20 0>
	}

object {
	rock
	rotate <0 -18 0>
	scale <3.5 3.5 3.5>
	translate <-68 110 -478>
	
	
}