/*
 * z:include/image.h -- Written by QWEB from source file image.qq
 */
#line 3005 "image.qq"
#ifndef TOOLS_IMAGE_H
#define TOOLS_IMAGE_H

#include <moni.h>

#line 38 "image.qq"
typedef unsigned char            ImageValue;
#line 390 "image.qq"
typedef union un_ImageProtocol  *ImageProtocolID;
#line 244 "image.qq"
typedef struct st_ImLoaderLocal {
	void             *priv_data;
	int               result;
	const char       *filename;
	Monitor          *monitor;
	ImageProtocolID (*begin) (void *, int type);
	void            (*done) (void *, ImageProtocolID);
} ImLoaderLocal;
#line 275 "image.qq"
typedef struct st_ImSaverLocal {
	void            *priv_data;
	int              result;
	int              type;
	const char      *filename;
	Monitor         *monitor;
	int            (*sendData) (void *, ImageProtocolID, int);
} ImSaverLocal;
#line 340 "image.qq"
typedef struct st_ColorProtocol {
	int              type;
	void            *priv_data;
	void           (*setSize) (void *, int, int, int);
	int            (*sendLine) (void *, int, const ImageValue *,
				    const ImageValue *);
	int            (*done) (void *, int);
} ColorProtocol;
#line 363 "image.qq"
typedef struct st_IndexProtocol {
	int              type;
	void            *priv_data;
	void           (*setSize) (void *, int, int, int);
	void           (*numColors) (void *, int);
	void           (*setMap) (void *, int, ImageValue[3]);
	int            (*sendLine) (void *, int, const ImageValue *,
				    const ImageValue *);
	int            (*done) (void *, int);
} IndexProtocol;
#line 382 "image.qq"
typedef union un_ImageProtocol {
	int              type;
	ColorProtocol    color;
	IndexProtocol    index;
} ImageProtocol;
#line 28 "image.qq"
#define IMG_RGB24       0
#define IMG_GREY8       1
#define IMG_INDEX8      2
#line 299 "image.qq"
#define IPSTAT_OK                0
#define IPSTAT_NOREC             1
#define IPSTAT_BADFILE           2
#define IPSTAT_ABORT             3
#define IPSTAT_FAILED           99
#line 421 "image.qq"
#define IMGF_ALPHA               1
#define IMGF_REVERSE             2
#line 430 "image.qq"
#define IP_SETSIZE(p,w,h,f)     (*(p)->setSize) ((p)->priv_data,w,h,f)
#define IP_NUMCOLORS(p,n)       (*(p)->numColors) ((p)->priv_data,n)
#define IP_SETMAP(p,i,val)      (*(p)->setMap) ((p)->priv_data,i,val)
#define IP_SENDLINE(p,ln,d,a)   (*(p)->sendLine) ((p)->priv_data,ln,d,a)
#define IP_DONE(p,err)          (*(p)->done) ((p)->priv_data,err)

#line 3014 "image.qq"
#endif
