/*  
     uppwer.pov - File to render all upper case letters.

     Created by:

     Michael Hartman
     hartmms@eng.auburn.edu 
     http://www.eng.auburn.edu/~hartmms/home.html
     Auburn University

*/ 
     
#include "font.inc"


camera {  
     location <24, -40, 9>
     direction <0.0,     0.0,  2.5>
     sky       <0.0,     0.0,  1.0>  // Use right handed-system!
     up        <0.0,     0.0,  1.0>  // Where Z is up
     right     <1.3333,  0.0,  0.0>  // Set aspect ratio
     look_at <5.75, 0, (3.25+THICK*4)> 
}

light_source {  
     <20,30,66>
     color rgb <1.000, 1.000, 1.000>
}
light_source {   
     <0,-20,10>
     color rgb <1.000, 1.000, 1.000>
}

// Floor

plane { z,0 pigment { color rgb <0.5, 0.5, 0.5>} 
}        

// Letters

union {
     object {  font_A       translate <0, 0, (7.5+THICK*6) > }
     object {  font_B       translate <1.5, 0, (7.5+THICK*6)> }
     object {  font_C       translate <3.0, 0, (7.5+THICK*6)> }
     object {  font_D       translate <4.5, 0, (7.5+THICK*6)> }
     object {  font_E       translate <6.0, 0, (7.5+THICK*6)> }
     object {  font_F       translate <7.5, 0, (7.5+THICK*6)> }
     object {  font_G       translate <9, 0, (7.5+THICK*6)>   }
     object {  font_H       translate <10.5, 0, (7.5+THICK*6)> }
                     
     object {  font_I       translate <-0.75, 0, (5+THICK*4)> }
     object {  font_J       translate <0.75, 0, (5+THICK*4) > }
     object {  font_K       translate <2.25, 0, (5+THICK*4) > }
     object {  font_L       translate <3.75, 0, (5+THICK*4) > }
     object {  font_M       translate <5.25, 0, (5+THICK*4) > }
     object {  font_N       translate <6.75, 0, (5+THICK*4) > }
     object {  font_O       translate <8.25, 0, (5+THICK*4) > }
     object {  font_P       translate <9.75, 0, (5+THICK*4) > }
     object {  font_Q       translate <11.25, 0, (5+THICK*4)> }
                                                        
     object {  font_R       translate <-0.75, 0, (2.5+THICK*2)> }
     object {  font_S       translate <0.75, 0, (2.5+THICK*2) > }
     object {  font_T       translate <2.25, 0, (2.5+THICK*2) > }
     object {  font_U       translate <3.75, 0, (2.5+THICK*2) > }
     object {  font_V       translate <5.25, 0, (2.5+THICK*2) > }
     object {  font_W       translate <6.75, 0, (2.5+THICK*2) > }
     object {  font_X       translate <8.25, 0, (2.5+THICK*2) > }
     object {  font_Y       translate <9.75, 0, (2.5+THICK*2) > }    
     object {  font_Z       translate <11.25, 0, (2.5+THICK*2) > }    

     pigment { color rgb <0, 0, 1> }  // Color them blue
}
