/*  
     rest.pov - File to render rest of characters.

     Created by:

     Michael Hartman
     hartmms@eng.auburn.edu 
     http://www.eng.auburn.edu/~hartmms/home.html
     Auburn University

*/ 
     
#include "font.inc"

camera {  //  Camera StdCam
     location <24, -40, 9>
     direction <0.0,     0.0,  2.5>
     sky       <0.0,     0.0,  1.0>    // Use right handed-system!
     up        <0.0,     0.0,  1.0>    // Where Z is up
     right   <1.3333,  0.0,  0.0>      // Set aspect ratio
     look_at <5.75, 0, (3.25+THICK*4)> 
}

light_source {   
     <20,30,66>        
     color rgb <1.000, 1.000, 1.000>
}
light_source {   
     <0,-20,10>
     color rgb <1.000, 1.000, 1.000>
}

// Floor

plane { z,0 pigment { color rgb <0.5, 0.5, 0.5>} }        

// Characters 

union {
     object {  font_0           translate <0, 0, (7.5+THICK*6) > }
     object {  font_1           translate <1.5, 0, (7.5+THICK*6)> }
     object {  font_2           translate <3.0, 0, (7.5+THICK*6)> }
     object {  font_3           translate <4.5, 0, (7.5+THICK*6)> }
     object {  font_4           translate <6.0, 0, (7.5+THICK*6)> }
     object {  font_5           translate <7.5, 0, (7.5+THICK*6)> }
     object {  font_6           translate <9, 0, (7.5+THICK*6)>   }
     object {  font_7           translate <10.5, 0, (7.5+THICK*6)> }
                     
     object {  font_8           translate <-0.75, 0, (5+THICK*4)> }
     object {  font_9           translate <0.75, 0, (5+THICK*4) > }
     object {  font_angstrom    translate <3.75, 0, (5+THICK*4) > }
     object {  font_exclamation translate <5.25, 0, (5+THICK*4) > }
     object {  font_pound       translate <6.75, 0, (5+THICK*4) > }
     object {  font_dollar      translate <8.25, 0, (5+THICK*4) > }
     object {  font_up          translate <9.75, 0, (5+THICK*4) > }
     object {  font_slash       translate <11.25, 0, (5+THICK*4)> }
                                                        
     object {  font_backslash   translate <-0.75, 0, (2.5+THICK*2)> }
     object {  font_percent     translate <0.75, 0, (2.5+THICK*2) > }
     object {  font_star        translate <2.25, 0, (2.5+THICK*2) > }
     object {  font_leftp       translate <3.75, 0, (2.5+THICK*2) > }
     object {  font_rightp      translate <5.25, 0, (2.5+THICK*2) > }
     object {  font_plus        translate <6.75, 0, (2.5+THICK*2) > }
     object {  font_minus       translate <8.25, 0, (2.5+THICK*2) > }
     object {  font_apostrophe  translate <9.75, 0, (2.5+THICK*2) > }
     object {  font_quote       translate <11.25, 0, (2.5+THICK*2) > }

     pigment { color rgb <0, 0, 1> }  // Color them blue
}
