/*  
     lower.pov - File to render all lower case letters.

     Created by:

     Michael Hartman
     hartmms@eng.auburn.edu 
     http://www.eng.auburn.edu/~hartmms/home.html
     Auburn University

*/ 
     
#include "font.inc"

camera {  
     location <24, -40, 9>
     direction <0.0,     0.0,  2.5>
     sky       <0.0,     0.0,  1.0>  // Use right handed-system!
     up        <0.0,     0.0,  1.0>  // Where Z is up
     right     <1.3333,  0.0,  0.0>  // Set aspect ratio 
     look_at <5.75, 0, (3.25+THICK*4)> 
}

light_source {   
     <20,30,66>
     color rgb <1.000, 1.000, 1.000>
}
light_source {   
     <0,-20,10>
     color rgb <1.000, 1.000, 1.000>
}

// Floor 

plane { <0, 0, 1>,0 
        pigment { color rgb <0.5, 0.5, 0.5>} 
}        

// Letters

union {
     object {  font_a       translate <0, 0, (7.5+THICK*6) > }
     object {  font_b       translate <1.5, 0, (7.5+THICK*6)> }
     object {  font_c       translate <3.0, 0, (7.5+THICK*6)> }
     object {  font_d       translate <4.5, 0, (7.5+THICK*6)> }
     object {  font_e       translate <6.0, 0, (7.5+THICK*6)> }
     object {  font_f       translate <7.5, 0, (7.5+THICK*6)> }
     object {  font_g       translate <9, 0, (7.5+THICK*6)>   }
     object {  font_h       translate <10.5, 0, (7.5+THICK*6)> }
                     
     object {  font_i       translate <-0.75, 0, (5+THICK*4)> }
     object {  font_j       translate <0.75, 0, (5+THICK*4) > }
     object {  font_k       translate <2.25, 0, (5+THICK*4) > }
     object {  font_l       translate <3.75, 0, (5+THICK*4) > }
     object {  font_m       translate <5.25, 0, (5+THICK*4) > }
     object {  font_n       translate <6.75, 0, (5+THICK*4) > }
     object {  font_o       translate <8.25, 0, (5+THICK*4) > }
     object {  font_p       translate <9.75, 0, (5+THICK*4) > }
     object {  font_q       translate <11.25, 0, (5+THICK*4)> }
                                                        
     object {  font_r       translate <-0.75, 0, (2.5+THICK*2)> }
     object {  font_s       translate <0.75, 0, (2.5+THICK*2) > }
     object {  font_t       translate <2.25, 0, (2.5+THICK*2) > }
     object {  font_u       translate <3.75, 0, (2.5+THICK*2) > }
     object {  font_v       translate <5.25, 0, (2.5+THICK*2) > }
     object {  font_w       translate <6.75, 0, (2.5+THICK*2) > }
     object {  font_x       translate <8.25, 0, (2.5+THICK*2) > }
     object {  font_y       translate <9.75, 0, (2.5+THICK*2) > }    
     object {  font_z       translate <11.25, 0, (2.5+THICK*2) > }    

     pigment { color rgb <0, 0, 1> }  // Color them blue
}
