/*
     font.inc v1.0 - 3D geometries of letters, numbers, and special 
                     characters.  Better (I think) than what comes 
                     with POVRay.
     
     Converted from Rayshade to POVRay by 
     
     Michael Hartman
     hartmms@eng.auburn.edu 
     http://www.eng.auburn.edu/~hartmms/home.html
     Auburn University
     
     I bounded all characters by a box to speed rendering, since
     the letters include a lot of objects. I added a couple of items 
     as well.

     If you have any hints or additions, feel free to add them, but 
     let me know since I'm keeping an updated version of this file.
     
     credits from rayshade file.... 
     (     Based on upper case letters created by somebody.  (Sorry, but   )
     (     I can't remember who first posted this)  I hope that someone    )
     (     will see this and add his/her name to this header.              )
     (                                                                     )
     (     Lower case letters, numbers, special characters, and small      )
     (     changes to upper case letters by Dan Peisach and Eric Fontano,  )
     (     Rosenstiel Medical Science Center, Brandeis University.         )
*/

/* 
     All characters have the origion at the bottom left corner.
     You can change the following declare statements to suit your needs. 
*/

#declare THICK=0.1           // Thickness of letters, 0.25 is nice too.
#declare BOUND=THICK+0.1     // Changes BOUNDing box size if thicker letters.
#declare RATIO=0.7           // DO NOT SET BELOW 0.6. 
#declare ARATIO=(1-RATIO)    // Used for lower case letters.
#declare GAP=(1-2*(1-RATIO)) // Used for lower case letters.
#declare HEIGHT=2.0          /* Height (not including lower 
                                extensions) of chars. */


/* common character parts */

#declare toparc=
    object  {
    torus  { 0.5, THICK translate <0.5,0,1.5> }
    clipped_by { box  { <-1,-1,1.5> <2, 1, 3>  } }
}

#declare botarc=
     object {
     torus {  0.5, THICK translate <0.5, 0, 0.5> }
     clipped_by { box  { <-1, -1, -1> <2, 1, 0.5> } }
}

#declare upperquarter=
object {
     torus {  0.5, THICK translate <0.5, 0, 1.5> }
     clipped_by { box  { <0.5, -1, 1.5> <2, 1, 3> } }
}

#declare upperleftquarter=
object {
     torus { 0.5,THICK  translate <0.5, 0, 1.5> }
     clipped_by  { box  { <0.5,-1,1.5> <-2,1,3> } }
}

#declare upperarc=
object {
     torus  { 0.5,THICK  translate <0.5,0,1.5> }
     clipped_by  { box  { <0.5, -1, 0>  <2, 1, 3> } }
}

#declare lowerquarter=
object {
     torus { 0.5, THICK translate <0.5, 0, 0.5> }
     clipped_by  { box  { <0.5, -1, -1>  <2, 1, 0.5> } }
}

#declare lowerleftquarter=
     object {
     torus { 0.5, THICK translate <0.5, 0, 0.5> }
     clipped_by { box { <-1, -1, -1>  <0.5, 1, 0.5>  } }
}

#declare lowerarc=
object {
     torus { 0.5,THICK translate <0.5, 0, 0.5> }
     clipped_by  { box  { <0.5, -1, -1> <2, 1, 2> } }
}

#declare corner=
object {
     torus { THICK,THICK  }
     clipped_by  { box  { <0, -1, 0> <1, 1, 1> } }
}

#declare upperleft=   
object { 
     corner                        
     rotate <0,-90,0> translate <THICK, 0, (2-THICK)> 
}

#declare lowerleft=   
object {
     corner                    
     rotate <0,180,0> translate <THICK, 0, THICK>
}


/* Capital letter declarations */

#declare font_A=
union {
     cylinder { <0, 0, 0> <0.5, 0, 2>, THICK }
     cylinder { <1, 0, 0> <0.5, 0, 2>, THICK }
     cylinder { <(0.5-0.5*0.5), 0, 0.7> <(0.5+0.5*0.5), 0, 0.7>, THICK }
     sphere {   <0.5, 0, 2>, THICK }
     sphere {   <0, 0, 0>, THICK }
     sphere {   <1, 0, 0>, THICK }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}

#declare font_B=
union {
     cylinder {  <0, 0, 0> <0, 0, 2>, THICK }
     cylinder {  <0, 0, 2> <0.5, 0, 2>, THICK }
     cylinder {  <0, 0, 1> <0.5, 0, 1>, THICK }
     cylinder {  <0, 0, 0> <0.5, 0, 0>, THICK }
     object { upperarc }
     object { lowerarc }
     sphere {  <0, 0, 0>, THICK }
     sphere {  <0, 0, 2>, THICK }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

     
}

#declare font_C=
union {
     object { toparc }
     cylinder {  <0, 0, 0.5> <0, 0, 1.5>, THICK }
     object { botarc }
     sphere { <1, 0, 1.5>, THICK }
     sphere { <1, 0, 0.5>, THICK }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }
}

#declare font_D=
union {
     cylinder { <0, 0, 0> <0, 0, 2>, THICK }
     cylinder { <0, 0, 2> <0.5, 0, 2>, THICK }
     cylinder { <1, 0, 0.5> <1, 0, 1.5>, THICK }
     cylinder { <0, 0, 0> <0.5, 0, 0>, THICK }
     object { upperquarter }
     object { lowerquarter }
     sphere { <0, 0, 0>, THICK }
     sphere { <0, 0, 2>, THICK }
     bounded_by {
          box { <-BOUND, -BOUND, -BOUND> <1+THICK, BOUND, 2+THICK> }
     }
}

#declare font_E=
union {
     cylinder {  <0, 0, 0> <0, 0, 2>, THICK }
     cylinder {  <0, 0, 0> <1, 0, 0>, THICK }
     cylinder {  <0, 0, 2> <1, 0, 2>, THICK }
     cylinder {  <0, 0, 1> <0.75, 0, 1>, THICK }
     sphere { <0, 0, 0>, THICK }
     sphere { <0, 0, 2>, THICK }
     sphere { <1, 0, 0>, THICK }
     sphere { <1, 0, 2>, THICK }
     sphere { <0.75, 0, 1>, THICK }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}

#declare font_F=
union {
     cylinder { <0, 0, 0> <0, 0, 2>, THICK }
     cylinder { <0, 0, 2> <1, 0, 2>, THICK }
     cylinder { <0, 0, 1> <0.75, 0, 1>, THICK }
     sphere { <0, 0, 0>, THICK }    
     sphere { <0, 0, 2>, THICK }
     sphere { <1, 0, 2>, THICK }
     sphere { <0.75, 0, 1>, THICK }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}

#declare font_G=
union {
     object { toparc }
     cylinder { <0, 0, 0.5> <0, 0, 1.5>, THICK }
     object { botarc }
     cylinder { <1, 0, 0.8> <1, 0, 0.5>, THICK }
     sphere { <1, 0, 1.5>, THICK }
     cylinder { <0.6, 0, 0.8> <1, 0, 0.8>, THICK }
     sphere { <1, 0, 0.8>, THICK }
     sphere { <0.6, 0, 0.8>, THICK }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}

#declare font_H=
union {
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2>, THICK }             
          translate <0, 0, 0>
     }
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2>, THICK }             
          translate <1, 0, 0>
     }
     cylinder {  <0, 0, 1> <1, 0, 1>, THICK }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}


#declare font_I=
union {
     cylinder { <0.5, 0, 0> <0.5, 0, 2>, THICK }
     cylinder { <0, 0, 0>   <1, 0, 0>, THICK } 
     cylinder { <0, 0, 2>   <1, 0, 2>, THICK }
     sphere { <0, 0, 0>, THICK }
     sphere { <1, 0, 0>, THICK } 
     sphere { <0, 0, 2>, THICK }
     sphere { <1, 0, 2>, THICK }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}

#declare font_J=
union {

     union {     
          cylinder { <0, 0, 0> <0, 0, 1.5>, THICK }
          sphere {  <0, 0, 0>, THICK }                       
          rotate <0,180,0> 
          translate <1, 0, 2> 
     }
     object { botarc }
     sphere { <0, 0, 0.5>, THICK }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }
}

#declare font_K=
union {
     cylinder { <0, 0, 0> <0, 0, 2>, THICK } 
     cylinder { <1, 0, 2> <0, 0, 1>, THICK }
     cylinder { <1, 0, 0> <0.5, 0, 1.5>, THICK }
     sphere { <0, 0, 0>, THICK }
     sphere { <0, 0, 2>, THICK }
     sphere { <1, 0, 2>, THICK }
     sphere { <1, 0, 0>, THICK }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}

#declare font_L=
union {
     cylinder {  <0, 0, 0> <0, 0, 2>, THICK }
     cylinder {  <0, 0, 0> <1, 0, 0>, THICK }
     sphere { <0, 0, 0>, THICK }
     sphere { <0, 0, 2>, THICK } 
     sphere { <1, 0, 0>, THICK }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}

#declare font_M=
union {
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2>, THICK }             
     }
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2>, THICK }             
          translate <1, 0, 0>
     }
     cylinder { <0, 0, 2> <0.5, 0, 1>, THICK } 
     cylinder { <1, 0, 2> <0.5, 0, 1>, THICK }
     sphere { <0.5, 0, 1>, THICK }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}

#declare font_N=
union {
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2>, THICK }             
     }
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2>, THICK }             
          translate <1, 0, 0> 
     }
     cylinder { <0, 0, 2> <1, 0, 0>, THICK }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}

#declare font_O=
union {
     object { toparc }
     cylinder { <0, 0, 0.5> <0, 0, 1.5>, THICK } 
     object { botarc }
     cylinder { <1, 0, 0.5> <1, 0, 1.5>, THICK } 
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}

#declare font_P=
union {
     cylinder {  <0, 0, 0> <0, 0, 2>, THICK } 
     cylinder {  <0, 0, 2> <0.5, 0, 2>, THICK }
     cylinder {  <0, 0, 1> <0.5, 0, 1>, THICK }
     object { upperarc }
     sphere { <0, 0, 0>, THICK } 
     sphere { <0, 0, 2>, THICK }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}

#declare font_Q=
union {
     object { toparc }
     cylinder { <0, 0, 0.5> <0, 0, 1.5>, THICK }
     object { botarc }
     cylinder { <1, 0, 0.5> <1, 0, 1.5>, THICK }
     cylinder { <1, 0, 0> <0.6, 0, 0.8>, THICK }
     sphere { <1, 0, 0>, THICK }
     sphere { <0.6, 0 ,0.8>, THICK }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}

#declare font_R=
union {
     cylinder { <0, 0, 0> <0, 0, 2>, THICK }
     cylinder { <0, 0, 2> <0.5, 0, 2>, THICK }
     cylinder { <0, 0, 1> <0.5, 0, 1>, THICK }
     object { upperarc }
     sphere { <0, 0, 0>, THICK }
     sphere { <0, 0, 2>, THICK }
     object { upperarc }
     object { upperquarter translate <0, 0, -1> }
     union {     
          cylinder { <0, 0, 0> <0, 0, 0.5>, THICK }
          sphere {  <0, 0, 0>, THICK }                       
          translate <1, 0, 0> 
     }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}

#declare font_S=
union {
     sphere { <1, 0, 1.5>, THICK }
     object { toparc }
     object { lowerleftquarter  translate <0, 0, 1> }
     object { upperquarter translate <0, 0, -1> }
     object { botarc }
     sphere { <0, 0, 0.5>, THICK }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}

#declare font_T=
union {
     union {     
          cylinder { <0, 0, 0> <0, 0, 2>, THICK }
          sphere {  <0, 0, 0>, THICK }                       
          translate <0.5, 0, 0> 
     }
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 1>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 1>, THICK }             
          rotate <0,90,0> 
          translate <0, 0, 2> 
     }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}

#declare font_U=
union {
     cylinder { <0, 0, 0.5> <0, 0, 2>, THICK } 
     object { botarc }
     cylinder { <1, 0, 0.5> <1, 0, 2>, THICK }
     sphere { <0, 0, 2>, THICK }
     sphere { <1, 0, 2>, THICK }
}

#declare font_V=
union {
     cylinder { <0.5, 0, 0> <0, 0, 2>, THICK }
     cylinder { <0.5, 0, 0> <1, 0, 2>, THICK }
     sphere { <0, 0, 2>, THICK }
     sphere { <1, 0, 2>, THICK }
     sphere { <0.5, 0, 0>, THICK }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}

#declare font_W=
union {
     sphere { <0, 0, 2>, THICK }
     cylinder { <0, 0, 2> <0.15, 0, 0>, THICK } 
     sphere { <0.15, 0, 0>, THICK }
     cylinder { <0.15, 0, 0> <0.5, 0, 1>, THICK }
     sphere { <0.5, 0, 1>, THICK }
     cylinder { <.85, 0, 0> <0.5, 0, 1>, THICK }
     sphere { <.85, 0, 0>, THICK } 
     cylinder { <.85, 0, 0> <1, 0, 2>, THICK }
     sphere { <1, 0, 2>, THICK }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}

#declare font_X=
union {
     cylinder { <1, 0, 0> <0, 0, 2>, THICK }
     cylinder { <0, 0, 0> <1, 0, 2>, THICK }
     sphere { <0, 0, 2>, THICK }
     sphere { <1, 0, 2>, THICK }
     sphere { <1, 0, 0>, THICK }
     sphere { <0, 0, 0>, THICK }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}

#declare font_Y=
union {
     cylinder { <0, 0, 2> <0.5, 0, 1>, THICK }
     cylinder { <1, 0, 2> <0.5, 0, 1>, THICK } 
     sphere { <0, 0, 2>, THICK }
     sphere { <1, 0, 2>, THICK }

     union {                                      
          cylinder { <0, 0, 0> <0, 0, 1>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 1>, THICK }             
          translate <0.5, 0, 0> 
     }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}

#declare font_Z=
union {
     cylinder { <0, 0, 2> <1, 0, 2>, THICK }
     cylinder { <0, 0, 0> <1, 0, 2>, THICK }
     cylinder { <0, 0, 0> <1, 0, 0>, THICK }
     sphere { <0, 0, 2>, THICK }
     sphere { <1, 0, 2>, THICK }
     sphere { <1, 0, 0>, THICK }
     sphere { <0, 0, 0>, THICK }
     bounded_by { 
       box {  <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND,2+THICK> } 
     }

}


/* Lower case letter definitions */ 


#declare  font_a=
union { 
     object { toparc  translate <0, 0, (-2*ARATIO)> }
     object { botarc }
     cylinder { <0, 0, 0.5> <0, 0, (0.5+GAP)>, THICK }
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2*RATIO>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2*RATIO>, THICK }             
          translate <1, 0, 0>  
     }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_b=
union { 
     object { toparc  translate <0, 0, (-2*ARATIO)> }
     object { botarc }
     cylinder { <1, 0, 0.5> <1, 0, (0.5+GAP)>, THICK  }
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2>, THICK }             
     }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_c=
union { 
     object { toparc  translate <0, 0, (-2*ARATIO)> }
     cylinder { <0, 0, 0.5> <0, 0, (0.5+GAP)>, THICK }
     object { botarc }
     sphere { <1, 0, (0.5+GAP)>, THICK }
     sphere { <1, 0, 0.5>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }
}
                
#declare  font_d=
union { 
     object { toparc  translate <0, 0, (-2*ARATIO)> }
     object { botarc }
     cylinder { <0, 0, 0.5> <0, 0, (0.5+GAP)>, THICK }
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2>, THICK }             
          translate <1, 0, 0> 
     }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_e=
union { 
     object { toparc  translate <0, 0, (-2*ARATIO)> }
     cylinder { <0, 0, 0.5> <0, 0, (0.5+GAP)>, THICK } 
     object { botarc }
     sphere { <1, 0, (0.5+GAP)>, THICK }
     cylinder { <0, 0, (0.5+GAP)> <1, 0, (0.5+GAP)>, THICK }
     sphere { <1, 0, 0.5>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_f=
union { 
     sphere { <.5, 0, 0>, THICK }
     cylinder { <.5, 0, 0>  <.5, 0, 1.5>, THICK }
     object { upperleftquarter  translate <0.5, 0, 0> }
     sphere { <1, 0, 2>, THICK }
     cylinder { <0.2, 0, 1> <0.8, 0, 1>, THICK }
     sphere { <0.2, 0, 1>, THICK }
     sphere { <0.8, 0, 1>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}                 

#declare  font_g=
union { 
     object { toparc  translate <0, 0, (-2*ARATIO)> }
     object { botarc }
     cylinder { <0, 0, 0.5> <0, 0, (0.5+GAP)>, THICK }
     cylinder { <1, 0, (2*RATIO)>  <1, 0, (0-GAP)>, THICK }
     object { botarc  translate <0, 0, (-0.5-GAP)> } 
     sphere { <1, 0, (2*RATIO)>, THICK }
     sphere { <0, 0, (0-GAP)>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-1-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_h=
union { 
     object { toparc  translate <0, 0, (-2*ARATIO)> }
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2>, THICK }             
     }
     cylinder { <1, 0, 0> <1, 0 ,(0.5+GAP)>, THICK } 
     sphere { <1, 0, 0>, THICK }  
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_i=
union { 
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2*RATIO>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2*RATIO>, THICK }             
          translate <0.5, 0, 0> 
     }
     sphere { <0.5, 0, (2*RATIO+GAP+THICK)>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_j=
union { 
     cylinder { <1, 0, (2*RATIO)> <1, 0, (0-GAP)>, THICK }
     object { botarc  translate <0, 0, (-0.5-GAP)> } 
     sphere { <1, 0, (2*RATIO)>, THICK } 
     sphere { <0, 0, (0-GAP)>, THICK }
     sphere { <1, 0, (2*RATIO+GAP+THICK)>, THICK } 
     bounded_by {
          box { <-BOUND,-BOUND,-1-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_k=
union { 
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2>, THICK }             
     }
     cylinder { <0, 0, (0.6*RATIO)> <1, 0, (2*RATIO)>, THICK } 
     cylinder { <0.4, 0, (0.6*RATIO+0.4*1.4*RATIO)> <1, 0, 0>, THICK }
     sphere { <1, 0, 0>, THICK } 
     sphere { <1, 0, (2*RATIO)>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_l=
union {                                      
     cylinder { <0, 0, 0> <0, 0, 2>, THICK }
     sphere { <0, 0, 0>, THICK }
     sphere { <0, 0, 2>, THICK }             
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

     translate <0.5, 0, 0>
}


#declare  font_m=
union { 
     object {
          torus { 0.25, THICK  translate <0.25, 0, (2*RATIO-0.25)> }
          clipped_by { box { <-1, -1, (2*RATIO-0.25)> <1, 1, 3> } }
     } 
     object {
          torus { 0.25, THICK  translate <0.25, 0, (2*RATIO-0.25)> }
          clipped_by { box { <-1, -1, (2*RATIO-0.25)> <1, 1, 3> } }
          translate <0.5, 0, 0> 
     }          
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2*RATIO>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2*RATIO>, THICK }             
     }
     cylinder { <0.5, 0, 0> <0.5, 0, (2*RATIO-0.25)>, THICK }
     cylinder { <1.0, 0, 0> <1.0, 0, (2*RATIO-0.25)>, THICK }
     sphere { <0.5, 0, 0>, THICK }
     sphere { <1, 0, 0>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}


#declare  font_n=
union { 
     object { toparc  translate <0, 0, (-2*ARATIO)> }
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2*RATIO>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2*RATIO>, THICK }             
     }
     cylinder { <1, 0, 0> <1, 0, (0.5+GAP)>, THICK }
     sphere { <1, 0, 0>, THICK } 
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_o=
union { 
     object { toparc  translate <0, 0, (-2*ARATIO)> }
     object { botarc }
     cylinder { <0, 0, 0.5> <0, 0, (0.5+GAP)>, THICK }
     cylinder { <1, 0, 0.5> <1, 0, (0.5+GAP)>, THICK }   
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_p=
union { 
     object { toparc  translate <0, 0, (-2*ARATIO)> }
     object { botarc }
     cylinder { <1, 0, 0.5> <1, 0, (0.5+GAP)>, THICK }
     cylinder { <0, 0, (2*RATIO)> <0, 0, (0-2*GAP)>, THICK }
     sphere { <0, 0, (2*RATIO)>, THICK }
     sphere { <0, 0, (0-2*GAP)>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-1-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_q=
union {        
     object { toparc  translate <0, 0, (-2*ARATIO)> }
     object { botarc }
     cylinder { <0, 0, 0.5> <0, 0, (0.5+GAP)>, THICK }
     cylinder { <1, 0, (2*RATIO)> <1, 0, (0-2*GAP)>, THICK }
     sphere { <1, 0, (2*RATIO)>, THICK }
     sphere { <1, 0, (0-2*GAP)>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-1-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_r=
union { 
     object { toparc  translate <0, 0, (-2*ARATIO)> }
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2*RATIO>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2*RATIO>, THICK }             
     }              
     sphere { <1, 0, (0.5+GAP)>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_s=
union { 
  object {
     torus { (RATIO/2), THICK  translate <(RATIO/2), 0, (1.5*RATIO)> }
     clipped_by { box { <-1, -1, (RATIO-THICK)> <(RATIO/2), 1, 3> } }
  } 
  object {
     torus { (RATIO/2), THICK  translate <(1-RATIO/2), 0, (1.5*RATIO)> }
     clipped_by { box { <(1-RATIO/2), -1, (1.5*RATIO)> <2, 1, 3> } }
  } 
  object {
     torus { (RATIO/2), THICK  translate <(RATIO/2), 0, (.5*RATIO)> }
     clipped_by { box { <-1, -1, (.5*RATIO)> <(RATIO/2), 1, -1> } }
  }
  object {
     torus { (RATIO/2), THICK  translate <(1-RATIO/2), 0, (.5*RATIO)> }
     clipped_by { box  { <(1-RATIO/2), -1, (RATIO+THICK)> <2, 1, -1> } }
  } 
  cylinder { <(RATIO/2), 0, 0> <(1-RATIO/2), 0, 0>, THICK } 
  cylinder { <(RATIO/2), 0, (RATIO)> <(1-RATIO/2), 0, (RATIO)>, THICK } 
  cylinder { <(RATIO/2), 0, (2*RATIO)> <(1-RATIO/2), 0, (2*RATIO)>, THICK } 
  sphere { <0, 0, (RATIO/2)>, THICK }
  sphere { <1, 0, (1.5*RATIO)>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_t=
union { 
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2>, THICK }             
          translate <0.5, 0, 0> 
     }
     cylinder { <0.2, 0, (2*RATIO)> <0.8, 0, (2*RATIO)>, THICK }
     sphere { <0.2, 0, (2*RATIO)>, THICK }
     sphere { <0.8, 0, (2*RATIO)>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_u=
union { 
     object {
          torus { (RATIO/2), THICK  translate <(RATIO/2), 0, (.5*RATIO)> }
          clipped_by { box { <-1, -1, (.5*RATIO)> <(RATIO/2), 1, -1> } }
     } 
     object {
          torus { (RATIO/2), THICK  translate <(1-RATIO/2), 0, (.5*RATIO)> }
          clipped_by { box { <(1-RATIO/2), -1, (.5*RATIO)> <2, 1, -1> } }
     }  
     cylinder { <(RATIO/2), 0, 0> <(1-RATIO/2), 0, 0>, THICK }  
     cylinder { <0, 0, (RATIO/2)> <0, 0, (2*RATIO)>, THICK }
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2*RATIO>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2*RATIO>, THICK }             
          translate <1, 0, 0>  
     }
     sphere { <0, 0, (2*RATIO)>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_v=
union { 
     cylinder { <0, 0, (2*RATIO)> <0.5, 0, 0>, THICK }  
     cylinder { <1, 0, (2*RATIO)> <0.5, 0, 0>, THICK } 
     sphere { <1, 0, (2*RATIO)>, THICK }
     sphere { <0, 0, (2*RATIO)>, THICK }
     sphere { <0.5, 0, 0> , THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_w=
union { 
     sphere { <0, 0, (2*RATIO)>, THICK }
     cylinder { <0, 0, (2*RATIO)> <0.25, 0, 0>, THICK }
     sphere { <0.25, 0, 0>, THICK }
     cylinder { <0.5, 0, (2*RATIO)> <0.25, 0, 0>, THICK }
     sphere { <0.5, 0, (2*RATIO)>, THICK }
     cylinder { <0.5, 0, (2*RATIO)> <0.75, 0, 0>, THICK }
     sphere { <0.75, 0, 0>, THICK }
     cylinder { <1, 0, (2*RATIO)> <0.75, 0, 0>, THICK } 
     sphere { <1, 0, (2*RATIO)>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_x=
union { 
     cylinder { <0, 0, (2*RATIO)> <1, 0, 0>, THICK } 
     cylinder { <0, 0, 0> <1, 0, (2*RATIO)>, THICK }
     sphere { <0, 0, 0>, THICK } 
     sphere { <0, 0, (2*RATIO)>, THICK }
     sphere { <1, 0, 0>, THICK } 
     sphere { <1, 0, (2*RATIO)>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_y=
union { 
     object { botarc }
     cylinder { <0, 0, 0.5> <0, 0, (2*RATIO)>, THICK }  
     cylinder { <1, 0, (2*RATIO)> <1, 0, (0-GAP)>, THICK } 
     object { botarc  translate <0, 0, (-0.5-GAP)> } 
     sphere { <0, 0, (2*RATIO)>, THICK }
     sphere { <1, 0, (2*RATIO)>, THICK }
     sphere { <0, 0, (0-GAP)>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-1-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}
                
#declare  font_z=
union { 
     cylinder { <0, 0, (2*RATIO)> <1, 0, (2*RATIO)>, THICK }
     cylinder { <1, 0, (2*RATIO)> <0, 0, 0 >, THICK }
     cylinder { <0, 0, 0> <1, 0, 0>, THICK } 
     sphere { <0, 0, (2*RATIO)>, THICK }
     sphere { <1, 0, (2*RATIO)>, THICK }
     sphere { <0, 0, 0>, THICK }
     sphere { <1, 0, 0>, THICK } 
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

/* Number definitions */

#declare  font_0=
union { 
     object { toparc }
     cylinder { <0, 0, 0.5> <0, 0, 1.5>, THICK } 
     object { botarc }
     cylinder { <1, 0, 0.5> <1, 0, 1.5>, THICK } 
     cylinder { <0, 0, 0> <1, 0 ,2 >, THICK }
     sphere { <1, 0, 2>, THICK }
     sphere { <0, 0, 0>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_1=
union { 
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2>, THICK }             
          translate <0.5, 0, 0> 
     }
     cylinder { < 0.5, 0, 2> <0.3, 0, 1.7>, THICK }
     sphere { <0.3, 0, 1.8>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_2=
union {        
     sphere { <0, 0, 1.5>, THICK }
     object { toparc }
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 0.125>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 0.125>, THICK }             
          translate <1, 0, 1.375>
     }
     object { lowerquarter translate <0, 0, 0.875> }
     object { upperleftquarter  translate <0, 0, -1.125> }
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 0.375>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 0.375>, THICK }             
     }
     cylinder { <0, 0, 0> <1, 0, 0>, THICK } 
     sphere { <1, 0, 0>, THICK } 
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_3=
union { 
     object { upperarc }
     object { lowerarc }
     object { toparc }
     object { botarc }
     sphere { <0, 0, 1.5>, THICK }
     sphere { <0, 0, 0.5>, THICK }
     sphere { <0.5, 0, 1>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_4=
union { 
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2>, THICK }
          sphere { <0, 0, 0>, THICK }  
          sphere { <0, 0, 2>, THICK }             
          translate <0.8, 0, 0> 
     }
     cylinder { <0.8, 0, 2> <0, 0, .7>, THICK }
     sphere { <0, 0, 0.7>, THICK }
     cylinder { <0, 0, 0.7> <1, 0, 0.7>, THICK }
     sphere { <1, 0, 0.7>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_5=
union { 
     object { botarc }
     sphere { <0, 0, 0.5>, THICK }
     cylinder { <1, 0, 0.5> <1, 0, 1>, THICK }
     object { toparc scale <1, 1, .75> translate <0, 0, -0.125> }
     sphere { <0, 0, 0>, THICK scale <1, 1, 0.75> translate <0, 0, 1> }
     cylinder { <0, 0, 1> <0, 0, 2>, THICK }
     sphere { <0, 0, 2>, THICK }
     sphere { <1, 0 2>, THICK }
     cylinder { <0, 0, 2> <1, 0, 2>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}  

#declare  font_6=
union { 
     object { toparc }
     object { botarc }
     object { toparc translate <0, 0, -0.875> }
     cylinder { <1, 0, 0.5> <1, 0, 0.625>, THICK }
     cylinder { <0, 0, 0.5> <0, 0, 1.5>, THICK }
     sphere { <1, 0, 1.5>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_7=
union { 
     sphere { <0, 0, 2>, THICK }
     cylinder { <0, 0, 2> <1, 0, 2>, THICK } 
     sphere { <1, 0, 2>, THICK } 
     cylinder { <1, 0, 2> <0.25, 0, 0>, THICK } 
     sphere { <0.25, 0, 0> , THICK } 
}

#declare  font_8=
union { 
     object { toparc }
     object { toparc translate <0, 0, -1> }
     object { botarc }
     object { botarc translate <0 0 1> }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_9=
union { 
     object { toparc }
     object { botarc }
     object { botarc translate <0, 0, 0.875> }
     cylinder { <1, 0, 1.5> <1, 0, 0.5>, THICK }
     cylinder { <0, 0, 1.5> <0, 0, 1.375>, THICK }
     sphere { <0, 0, 0.5>, THICK } 
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

/* Some more keyboard chars, with some other stuff. */

#declare  font_angstrom=
union { 
     cylinder { <0, 0, 0> <0.5, 0, 2>, THICK }
     cylinder { <1, 0, 0> <0.5, 0, 2>, THICK }
     cylinder { <(0.5-0.5*0.5), 0, 0.7> <(0.5+0.5*0.5), 0, 0.7>, THICK }
     sphere { <0, 0, 0>, THICK }
     sphere { <1, 0, 0>, THICK }
     torus { 0.25, (THICK/2) translate <0.5, 0, 2.2> } 
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2.5+BOUND> }
     }

}

#declare font_apostrophe=
union {                                      
     cylinder { <0, 0, 0> <0, 0, 0.5>, THICK }
     sphere { <0, 0, 0>, THICK }
     sphere { <0, 0, 0.5>, THICK }             
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }
     rotate <0,30,0> 
     translate <1, 0, 1.2> 
}

#declare font_quote=
union {                                      
     union {
          cylinder { <0, 0, 0> <0, 0, 0.5>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 0.5>, THICK }             
          translate <-0.2, 0, 1.5> 
     }
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 0.5>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 0.5>, THICK }             
          translate <0.2, 0, 1.5> 
     }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_exclamation=
union { 
     sphere { <0.5, 0, 0>, THICK } 
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 1.5>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 1.5>, THICK }             
          translate <0.5, 0, 0.5>
     }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_pound=
union { 
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2>, THICK }             
          translate <0.25, 0, 0>
     }
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2>, THICK }             
          translate <0.75, 0, 0>
     }
     cylinder { <0, 0, 0.667> <1, 0, 0.667>, THICK }
     cylinder { <0, 0, 1.333> <1, 0, 1.333>, THICK }
     sphere { <0, 0, 0.667>, THICK }
     sphere { <1, 0, 0.667>, THICK }
     sphere { <0, 0, 1.333>, THICK }
     sphere { <1, 0, 1.333>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_dollar=
union { 
     object {
          torus { (RATIO/2), THICK  translate <(RATIO/2), 0, (1.5*RATIO)> }
          clipped_by { box { <-1, -1, (RATIO-THICK)> <(RATIO/2), 1, 3> } }
          translate <0, 0, (ARATIO)>
     }                   
     object {
          torus { (RATIO/2), THICK  translate <(1-RATIO/2), 0, (1.5*RATIO)> }
          clipped_by { box { <(1-RATIO/2), -1, (1.5*RATIO)> <2, 1, 3> } }
          translate <0, 0, (ARATIO)>
     }
     object {
          torus { (RATIO/2), THICK  translate <(RATIO/2), 0, (.5*RATIO)> }
          clipped_by { box { <-1, -1, (.5*RATIO)> <(RATIO/2), 1, -1> } }
          translate <0, 0, (ARATIO)>
     }
     object {
          torus { (RATIO/2), THICK  translate <(1-RATIO/2), 0, (.5*RATIO)> }
          clipped_by { box { <(1-RATIO/2), -1, (RATIO+THICK)> <2, 1, -1> } }
          translate <0, 0, (ARATIO)>
     }
     cylinder { <(RATIO/2), 0, (ARATIO)> <(1-RATIO/2), 0, (ARATIO)>, THICK } 
     cylinder { <(RATIO/2), 0, 1> <(1-RATIO/2), 0, 1>, THICK }
     cylinder { <(RATIO/2), 0, (1+RATIO)> <(1-RATIO/2), 0, (1+RATIO)>, THICK } 
     sphere { <0, 0, (RATIO/2+ARATIO)>, THICK } 
     sphere { <1, 0, (1+0.5*RATIO)>, THICK }
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2>, THICK }             
     translate <0.333, 0, 0> 
     }
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 2>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 2>, THICK }             
          translate <0.667, 0 ,0> 
     }          
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }
     
}

#declare  font_up=
union { 
     cylinder { <.5, 0, 2> <0, 0, 1>, THICK }
     cylinder { <.5, 0, 2> <1, 0, 1>, THICK }
     sphere { <0.5, 0, 2>, THICK }
     sphere { <0, 0, 1>, THICK }
     sphere { <1, 0, 1>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_slash=
union { 
     cylinder { <0, 0, 0> <1, 0, 2>, THICK }
     sphere { <0, 0, 0>, THICK }
     sphere { <1, 0, 2>, THICK } 
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_backslash=
union { 
     cylinder { <1, 0, 0> <0, 0, 2>, THICK } 
     sphere { <1, 0, 0>, THICK } 
     sphere { <0, 0, 2>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_percent=
union { 
     torus { 0.25, THICK translate <0.25, 0, 1.75> } 
     torus { 0.25, THICK translate <0.75, 0, 0.25> }
     cylinder { <0, 0, 0> <1, 0, 2>, THICK }
     sphere { <0, 0, 0>, THICK }
     sphere { <1, 0, 2>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_star=
union { 
     cylinder { <.2, 0, .4> <.8, 0, 1.6>, THICK }
     cylinder { <.2, 0, 1.6> <.8, 0, .4>, THICK }
     cylinder { <0, 0, 1> <1, 0, 1>, THICK }
     sphere { <.2, 0, .4>, THICK }
     sphere { <.8, 0, .4>, THICK }
     sphere { <1, 0, 1>, THICK }
     sphere { <.8, 0, 1.6>, THICK }
     sphere { <.2, 0, 1.6>, THICK }
     sphere { <0, 0, 1>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_leftp=
union { 
     object {
          torus { 0.5, THICK translate <0.5, 0, 1.5> } 
          clipped_by { box { <-1, -1, 1.5> <.5, 1, 3> } } 
     }
     object {
          torus { 0.5, THICK translate <0.5, 0, .5> }    
          clipped_by { box { <-1, -1, -1> <0.5, 1, .5> } }
     }
     cylinder { <0, 0, 0.5> <0, 0, 1.5>, THICK } 
     sphere { <0.5, 0, 0>, THICK } 
     sphere { <0.5, 0, 2>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_rightp=
union { 
     object {
          torus { 0.5, THICK translate <0.5, 0, 1.5> } 
          clipped_by { box { <0.5, -1, 1.5> <2, 1, 3> } }
     }
     object {
          torus { 0.5, THICK translate <0.5, 0, .5> } 
          clipped_by { box { <0.5, -1, -1> <2, 1, 0.5> } } 
     }
     cylinder { <1, 0, 0.5> <1, 0, 1.5>, THICK } 
     sphere { <0.5, 0, 0>, THICK } 
     sphere { <0.5, 0, 2>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_plus=
union { 
     union {                                      
          cylinder { <0, 0, 0> <0, 0, 1>, THICK }
          sphere { <0, 0, 0>, THICK }
          sphere { <0, 0, 1>, THICK }             
          translate <0.5, 0, 0.5>
     }
     cylinder { <0, 0, 1> <1, 0, 1>, THICK }
     sphere { <0, 0, 1>, THICK }
     sphere { <1, 0, 1>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}

#declare  font_minus=
union { 
     cylinder { <0, 0, 1> <1, 0, 1>, THICK }
     sphere { <0, 0, 1>, THICK } 
     sphere { <1, 0, 1>, THICK }
     bounded_by {
          box { <-BOUND,-BOUND,-BOUND> <1+BOUND, BOUND, 2+BOUND> }
     }

}
