// 	A 1955 Negative Enlarger .......5/23/92 M. Miller




#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "spot.inc"
#include "w2.inc"



camera {
	location <-160 120 -300> 
	direction <0 0 1.95> 
	look_at <-40 60 0> 
	up <0 1 0> 
	right <1.3 0 0> 
}


//----- Light 1
object { light_source { <600 100 -300> color White }}

//----- Light 2
object { light_source { <-300 1000 -350> color White }}

//----- Light 3
object { light_source { <-1300 -200 100> color Firebrick }}


//****************************************************
//----- Declare Textures

//-------Gray Wrinkle Texture
#declare WrinkleGray = 
	texture { 
	color red 0.45 green 0.4 blue 0.4 
	0.03 
	roughness 0.9 
	ambient 0.3 
	diffuse 0.7 
	wrinkles 0.5
	phong 0.5 
	phong_size 10 
	scale <0.1 0.1 0.1> 
}

//-------DarkGray Wrinkle Texture
#declare DGray = texture { 
	color red 0.25 green 0.2 blue 0.2 
	0.03 
	roughness 0.9 
	ambient 0.3 
	diffuse 0.6 
	wrinkles 0.5
	phong 0.5 
	phong_size 10 
	scale <0.1 0.1 0.1> 
}



//-------Dark Red Cloth Texture
#declare BELL = texture { 
	color red 0.44 green 0.0 blue 0.17 
	0.05  
	ambient 0.3 
	diffuse 0.7 
	wrinkles 0.25
	phong 0.5 
	phong_size 10 
	scale <0.1 0.1 0.1> 
}


//-------Dark Red 
#declare Kidney = texture { 
	color red 0.3 green 0.15 blue 0.15 
	ambient 0.25 
	diffuse 0.7 
	phong 1.0 
	phong_size 90  
}


//------- Mettalic Chrome
#declare  Chrome = texture { 
	color red 0.84 green 0.84 blue 0.84 
	0.03  
	ambient 0.3 
	diffuse 0.3 
	roughness 0.9 
	metallic 
	brilliance 7.5
	reflection 0.3  
	phong 0.7 
	phong_size 10 
	scale <0.1 0.1 0.1> 
}


//------- Mettalic Gold
#declare  GOLD = texture { 
	color red 0.94 green 0.64 blue 0.20 
	0.03  
	ambient 0.3 
	diffuse 0.3 
	roughness 0.9 
	metallic 
	brilliance 7.5
	reflection 0.3  
	phong 0.7 
	phong_size 10 
	scale <0.1 0.1 0.1> 
}


//------- Black Glass
#declare  BLACK_G = texture { 
	color DimGray 
	ambient 0.3 
	diffuse 0.3 
	reflection 0.3 
	phong 2.0 
}

//------- Glass
#declare  GLASS = texture { 
	color Clear 
	ambient 0.1 
	diffuse 0.0  
	refraction 1.0 
	ior 1.0
}


//------- Wood
#declare WOOD11 = texture { 
	DMFWood4 
	scale <5 8 3> 
	rotate <0 0 0> 
	ambient 0.3 
	diffuse 0.7 
	phong 0.7 
	phong_size 60  
}


//-------- Handle for Mouth Gap Release

#declare Dot =
    quadric {
       < 1.0  1.0  1.0>
       < 0.0  0.0  0.0>
       < 0.0  0.0  0.0>
        -1.0
    }

#declare Connector_1 = 
   object {
      quadric {
         < 0.0  1.0  1.0>
         < 0.0  0.0  0.0>
         < 0.0  0.0  0.0>
          -1.0
}      
clipped_by {
         plane { < 1.0  0.0  0.0> 1.0 }
         plane { <-1.0  0.0  0.0> 0.0 }
}}


//----- Handle For Carrage Release
#declare ROD =
 composite {

object {
	quadric { Dot }
 	texture { Chrome }
}

object { Connector_1
	scale     < 10.000000  1.000000  1.000000>
  	rotate    < 0.000000  90.000000  0.000000>
  		texture { Chrome }
}

object {
	quadric { Dot
	translate < 0.000000  0.000000 -10.000000> }
		texture { Chrome }
}

object { Connector_1
	scale     < 21.189620  1.000000  1.000000>
	rotate    < 0.000000  0.000000 -19.290046>
	rotate    < 0.000000  143.130102  0.000000>
	translate < 0.000000  0.000000 -10.000000>
		texture { Chrome }
}

object {
	quadric { Dot scale <2 2 2>
	translate <-16.000000 -7.000000 -22.000000> }
		texture { Chrome }
}

bounded_by {
	quadric { Dot
	scale < 17.226506  17.226506  17.226506>
	translate <-8.000000 -3.500000 -11.000000> }}
}


//----- Cutter for Hood ...thx Dan
#declare  HOLE = difference { sphere { <0 0 0> 19.5 inverse }}


//----- Mouth Rim 
#declare RIM = object {
   difference {
	union {
	   intersection { Y_Disk scale <20.5 2 20.5> }
	   intersection { Cube scale <5 2 10> translate <22.5 0 0> }
	}
	   quadric { Cylinder_Y scale <11 1 11> translate <27.5 0 -15> }
	   quadric { Cylinder_Y scale <11 1 11> translate <27.5 0 15> }
   }
		texture { DGray }
		   bounded_by { 
		   quadric { Sphere scale <30 8 30> translate <3 0 0> }
		   }
}

//------ Knob Grip
#declare KB = intersection { Z_Disk scale <0.75 0.75 1> translate <-3.2 0 -3> }

//------ Pin Bolts
#declare PIN_BOLT = 
object {
   quadric { Sphere scale <1 1 0.5> }
	texture { Chrome }
}

//------ Small Knob
#declare S_KNOB = object {
union {
intersection { Z_Disk scale <2 2 1> translate <0 0 -1> }
intersection { Z_Disk scale <4 4 0.1> translate <0 0 -2> }
intersection { Z_Disk scale <3 3 1.2> translate <0 0 -3> }
quadric { Sphere scale <2.5 2.5 1> translate <0 0 -4.2> }
intersection { KB rotate <0 0 0> }
intersection { KB rotate <0 0 30> }
intersection { KB rotate <0 0 60> }
intersection { KB rotate <0 0 90> }
intersection { KB rotate <0 0 120> }
intersection { KB rotate <0 0 150> }
intersection { KB rotate <0 0 180> }
intersection { KB rotate <0 0 210> }
intersection { KB rotate <0 0 240> }
intersection { KB rotate <0 0 270> }
intersection { KB rotate <0 0 300> }
intersection { KB rotate <0 0 330> }}
texture { Kidney }
bounded_by { sphere { <0 0 -2> 6 }}}







//************************************************
//------ Build Light Hood

#declare L_HOOD = composite {
//----- Top Light Socket Trim
object {
union {
quadric { Sphere scale <6 2 6> translate <0 40 0> } 
intersection { Y_Disk scale <6 0.5 6> translate <0 39.5 0> }
intersection { Y_Disk scale <6.5 0.5 6.5> translate <0 38.5 0> }
intersection { X_Disk scale <2 1.5 2> translate <5.5 35.5 0> }
intersection { Y_Disk scale <6.5 0.5 6.5> translate <0 32.5 0> }}
texture { GOLD }
bounded_by { sphere { <0 35 0> 11 }}
} // end object

//----- Hood with HeatSink Fins
object {
union {
difference {
union {
intersection { Cube scale <20 20 0.5> translate <0 11 0> }
intersection { Cube scale <20 20 0.5> translate <0 11 3> }
intersection { Cube scale <20 20 0.5> translate <0 11 -3> }
intersection { Cube scale <0.5 20 20> translate <0 11 0> }
intersection { Cube scale <0.5 20 20> translate <3 11 0> }
intersection { Cube scale <0.5 20 20> translate <-3 11 0> }
quadric { Sphere scale <16 16 16>  translate <0 11 0> } 
}
plane { <0 1 0> 11 }
difference { HOLE translate <0 11 0> }}
intersection { Y_Disk scale <7.5 4 7.5> translate <0 28 0> }
intersection { Y_Disk scale <19.5 3.5 19.5> translate <0 7.5 0> }}
texture { WrinkleGray }
bounded_by { sphere { <0 11 0> 26.5  }}
}

//------ Socket & Cord Support
object {
union{
intersection { Y_Disk scale <5.5 2.5 5.5> translate <0 35.5 0> }
intersection { X_Disk scale <2.5 1 1> translate <7.5 35.5 0> }}
texture { Chrome }
bounded_by { sphere { <0 35.5 0> 12 }}}

//----- Add Top Mouth Rim
object { RIM translate <0 2 0> }
bounded_by { sphere { <0 11 0> 38 }}

} //end composite
 







//******************************************************
//------ Hieght Adjustment
#declare H_ADJUST = composite {
//------ Slider

object {
difference {
union {
quadric { Cylinder_Y scale <6 1 6> }
intersection { Cube scale <8 20 2.5> translate <0 18 0> }}
plane { <0 1 0> 0 }
plane { <0 1 0> 35 inverse }
intersection { Cube scale <1 12.5 15> translate <-4 17.5 0> }
intersection { Cube scale <5 12.5 15> translate <8 17.5 0> }
intersection { Cube scale <25 52.5 0.6> translate <0 0 0> }}
texture { WrinkleGray }
bounded_by { sphere { <0 12.5 0> 25 }}}

//---- Angle Brace
object {
union {
intersection { Cube scale <0.5 16 1.5> translate <-8.5 19 0> } 
intersection { Cube scale <2 0.5 1.5> translate <-11 34.5 0> } 
intersection { Cube scale <0.5 2 1.5> translate <-13.5 36 0> } 
intersection { Cube scale <0.5 20 1.5> rotate <0 0 24.5> translate <-16 19 0> } 
triangle { <-9 4 0> <-9 34 0> <-23 34 0> }
triangle { <-23 34 0> <-24.5 38 0> <-14 38 0> }
triangle { <-23 34 0> <-14 34 0> <-14 38 0> }
intersection { X_Disk scale <6 3 3> translate <-19 40 0> }
}
texture { WrinkleGray }
bounded_by { sphere { <-14 21 0> 28 }}}

object { S_KNOB translate <0 24 -7.6> }
object { S_KNOB translate <-19 40 -4.5> }
object { PIN_BOLT translate <-6.5 2.5 -2.5> }
object { PIN_BOLT translate <-6.5 32.5 -2.5> }
object { PIN_BOLT translate <6.5 2.5 -2.5> }
object { PIN_BOLT translate <6.5 32.5 -2.5> }

} // end composite



//************************************************************
//------- Bottom Mouth & Support Bars
#declare SUPPORT = composite {

//------- Place Bottom Rim
object { RIM translate <0 0 0> }

//------- Vertical Gap Rod Support
object {
intersection { Cube scale <3.5 4 4> translate <24 -6 0> }
texture { WrinkleGray }}

//------- Vertical Gap Rods
object {
difference {
union {
quadric { Cylinder_Y scale <1 1 1> translate <22.5 0 -2> }
quadric { Cylinder_Y scale <1 1 1> translate <22.5 0 2> }}
plane { <0 1 0> -20 }
plane { <0 1 0> 9 inverse }}
texture { Chrome }
bounded_by { sphere { <23 -6 0> 19 }}}

//------- Horizonal Adjustment Bar
object {
intersection { X_Disk scale <10 1.5 1.5> translate <36.5 -1 0> }
texture { Chrome }}

bounded_by { quadric { Sphere scale <40 25 40> translate <13 0 0> }}}



//***************************************************
//------ Bellow Side
#declare BS = object {
union {
triangle { <-8 0 0> <8 0 0> <-12 4 -4> }
triangle { <-12 4 -4> <12 4 -4> <8 0 0> }
triangle { <-12 4 -4> <12 4 -4> <9 8 -1> }
triangle { <9 8 -1> <-9 8 -1> <-12 4 -4> }
triangle { <-9 8 -1> <9 8 -1> <13 12 -5> }
triangle { <13 12 -5> <-13 12 -5> <-9 8 -1> }
triangle { <-13 12 -5> <13 12 -5> <-10 16 -2> }
triangle { <-10 16 -2> <10 16 -2> <13 12 -5> }
triangle { <-10 16 -2> <10 16 -2> <14 20 -6> }
triangle { <14 20 -6> <-14 20 -6> <-10 16 -2> }
triangle { <-14 20 -6> <14 20 -6> <-11 24 -3> }
triangle { <-11 24 -3> <11 24 -3> <14 20 -6> }
triangle { <-11 24 -3> <11 24 -3> <15 28 -7> }
triangle { <15 28 -7> <-15 28 -7> <-11 24 -3> }
triangle { <-15 28 -7> <15 28 -7> <-12 32 -4> }
triangle { <-12 32 -4> <12 32 -4> <15 28 -7> }
triangle { <-12 32 -4> <12 32 -4> <13 36 -5> }
triangle { <13 36 -5> <-13 36 -5> <-12 32 -4> }}
texture { BELL }
bounded_by { intersection { Cube scale <20 24 10> translate <0 20 -2> }}}


//------- Put Bellow Sides Together
#declare BELLOW = composite {
object { BS rotate <0 0 0> translate <0 0 -8> }
object { BS rotate <0 0 0> translate <0 0 8> }
object { BS rotate <0 90 0> translate <-8 0 0> }
object { BS rotate <0 -90 0> translate <8 0 0> }
}






//***********************************************
//------ Lens Support & Adjuster
#declare LENS_S = composite {

object {
difference {
union {
intersection { Cube scale <10.5 1.5 10.5> translate <0 -1.5 0> }
intersection { Cube scale <2.5 1.5 8> translate <13 -1.5 0> }
intersection { Cube scale <4 6.5 3> translate <16.5 -6.5 0> }}
quadric { Cylinder_Y scale <5 1 5> translate <15.5 0 -8> }
quadric { Cylinder_Y scale <5 1 5> translate <15.5 0 8> }
quadric { Cylinder_Y scale <5 1 5> translate <0 0 0> }
intersection { Cube scale <9.5 2 9.5> translate <0 -3 0> }}
texture { WrinkleGray }
bounded_by { sphere { <5 -7 0> 23 }}}

//------ Add Knob & Vertical Rod for Lens Adjustment
object { S_KNOB scale <1.2 1.2 1.2> translate <19 -10 -11> }

object {
union {
intersection { Y_Disk scale <1.5 30 1.5> translate <16 9 0> }
intersection { Z_Disk scale <1 1 5> translate <19 -10 -7> }}
texture { Chrome }
bounded_by { intersection { Cube scale <10 35 15> translate <19 9 -6> }}}}



//*************************************************
//------ Main Vertical Support Post

#declare M_POST = composite {
//---- Crown
object {
union {
difference {
quadric { Cone_Y scale <7 9 7> }
plane { <0 1 0> 0 }
plane { <0 1 0> 9 inverse }}
difference {
sphere { <0 9 0> 7 }
plane { <0 1 0> 9 }}
intersection { Y_Disk scale <6 0.5 6> translate <0 6.5 0> }}
texture { GOLD }
bounded_by { sphere { <0 8 0> 10 }}
translate <0 150 0> 
}
//---- Post
object {
intersection { Y_Disk scale <5 78 5> translate <0 78 0> }
texture { Chrome }}

bounded_by { intersection { Cube scale <8 90 8> translate <0 85 0> }}
}


//******************************************
//----Lens
#declare LENS = composite {

object {
difference {
union {
intersection { Y_Disk scale <5.5 2 5.5> translate <0 -2 0> }
intersection { Y_Disk scale <6.8 0.5 6.8> translate <0 -4.5 0> }
intersection { Y_Disk scale <6.5 0.5 6.5> translate <0 -8.5 0> }
intersection { Y_Disk scale <6 1.5 6> translate <0 -6.5 0> }}
quadric { Cylinder_Y  scale <5 1 5> }}
texture { Chrome }
bounded_by { sphere { <0 -4 0> 11 }}}

//object {
//quadric { Sphere scale <5.1 1 5.1> translate <0 -8 0> }
//texture { GLASS }}

bounded_by { sphere { <0 -4 0> 11 }}}


//**********************************************************
//------- Negative Carrage

#declare CARRAGE = object {
union {
intersection { Y_Disk scale <19 1 19> translate <0 0 0> }
intersection { X_Disk scale <8 0.3 0.3> translate <-26.5 0 0> }
sphere { <-34 0 0> 1.5 }}
texture { Chrome }
bounded_by { intersection { Cube scale <35 2 20> translate <-5 0 0> }}}


//**********************************************
//-----Base Collar
#declare COLLAR = composite {
object {
difference {
union {
intersection { Y_Disk scale <6 7 6> translate <0 7 0> }
intersection { Cube scale <3 2.5 1> translate <-8 2.5 0> }}
quadric { Cylinder_Z scale <4 4 1> translate <-11 5 0> }}
texture { WrinkleGray }
bounded_by { sphere { <-1 5 0> 19 }}}

//---- Plate & Bolts
object {
union {
intersection { Cube scale <12.5 1 12> translate <-3.5 -1 0> }
quadric { Sphere scale <2 1.5 2> translate <-13.5 0 0> }
quadric { Sphere scale <2 1.5 2> translate <0 0 9> }
quadric { Sphere scale <2 1.5 2> translate <0 0 -9> }
intersection { Z_Disk scale <1 1 3> translate <0 7 -8> }}
texture { Chrome }
bounded_by { sphere { <0 3 0> 20 }}}

object { S_KNOB translate <0 7 -10> }
bounded_by { sphere { <0 3 0> 20 }}}



//***********************************************
//----- Base
#declare BASE = composite {

object {
union {
intersection { Cube scale <60 3.5 50> translate <0 0 0> }}
texture { WOOD11 }}

object {
union {
intersection { Cube scale <56 1 46> translate <0 3.5 0> }}
texture { BLACK_G }}}


//***********************************************
//------ Side Walls
#declare WALL = composite   {
object {
plane { <0 0 1> 0 }
texture { color Black ambient 1.0 reflection 0.5 }}

object {
plane { <1 0 0> -4000 }
texture { color CadetBlue ambient 1.0 reflection 0.5 }}}



#declare REF = object {
intersection { Cube scale <200 200 1> }
texture { color Black   }
texture { 
gradient <0 1 0>
color_map {
[0.0 0.2 color Black color Black alpha 0.2 ]
[0.2 1.0 color Black alpha 0.2 color Clear ]}
reflection 0.3
scale <1 250 33> translate <0 -60 0> }}

#declare REF1 = object {
intersection { Cube scale <200 200 1> }
texture { color red 0.05 green 0.0 blue 0.05   }
texture { 
gradient <0 1 0>
color_map {
[0.0 0.2 color Black color Black alpha 0.2 ]
[0.2 1.0 color Black alpha 0.2 color Clear ]}
reflection 0.1
scale <1 250 33> translate <0 -60 0> }}

#declare REF2 = object {
intersection { Cube scale <200 200 1> }
texture { color red 0.1 green 0.0 blue 0.05   }
texture { 
gradient <0 1 0>
color_map {
[0.0 0.2 color Black color Black alpha 0.2 ]
[0.2 1.0 color Black alpha 0.2 color Clear ]}
scale <1 250 33> translate <0 -60 0> }}




//***********************************************************
//-------- ASSEMBLE COMPOSITES
composite {

composite {
composite { L_HOOD  translate <-70.5 152 0> }
composite { H_ADJUST translate <-14 107 0> }
composite { SUPPORT translate <-70.5 148 0> } 
composite { BELLOW translate <-70.5 110 0> }
composite { LENS_S translate <-70.5 110 0> }
composite { WALL rotate <0 60 0>  translate <0 0 2000> }
composite { LENS translate <-70.5 109 0> }
object { CARRAGE translate <-70.5 151 0> }
composite { ROD translate <-45 140 -4> }
object { SPOT translate <-70.5 102 0>  }
translate <0 -50 0> }  // this raises & lowers enlarger head

composite { M_POST translate <-14 -30 0> } //---should be <-14 7 0>
composite { COLLAR translate <-14 6 0> }
composite { BASE translate <-58 -0.5 0> }
object { REF translate <0 0 70> }
object { REF1 translate <150 0 65> }
object { REF2 translate <200 0 60> }

rotate <0 -15 0>
}



composite { world29 }




















