#include "colors.inc"
#include "textures.inc"

camera {
	location  <0, 0, -5>
	direction <0, 0,  1>
	up        <0, 1,  0>
	right   <4/3, 0,  0>
	look_at   <0, 0, 0>
}

light_source {<0, 0, -5> color White}
light_source {<0, 5, 0> color White}

// Object converted to POVRay V2.2 by WCVT2POV V2.0
#declare _land = texture {pigment {color Green} finish {Shiny}}
#declare _japan = texture {pigment {color Green} finish {Shiny}}
#declare _water = texture {pigment {color Blue} finish {Shiny}}

// This object has the following minimum and maximum values:
// xmin=-0.999380, xmax=0.999396
// ymin=-0.999990, ymax=0.999990
// zmin=-0.999384, zmax=0.999368

object {
	union {
		// _land
		union {
			smooth_triangle {
				<0.683205, 0.426133, 0.583750>, <-0.753707, 2.162704, 4.442815>,
				<0.672776, 0.413173, 0.604784>, <-0.762852, 2.505601, 5.397275>,
				<0.653126, 0.443453, 0.604890>, <-0.683544, 2.743071, 5.287673>
			}
			smooth_triangle {
				<0.463908, 0.380492, 0.793179>, <0.620896, 1.572018, 3.624778>,
				<0.475705, 0.412242, 0.769979>, <0.925708, 2.912005, 6.295553>,
				<0.480683, 0.374492, 0.786009>, <0.391768, 1.173358, 2.732925>
			}
			smooth_triangle {
				<0.534710, 0.450762, 0.707113>, <0.217446, 2.289453, 4.436619>,
				<0.563985, 0.458493, 0.678840>, <0.023319, 2.818694, 5.291450>,
				<0.565260, 0.422473, 0.700785>, <0.105888, 2.559534, 5.424039>
			}
			smooth_triangle {
				<0.601325, 0.378003, 0.696161>, <-0.075892, 2.280821, 5.548541>,
				<0.603647, 0.393703, 0.685362>, <-0.111074, 1.984031, 4.587646>,
				<0.616333, 0.377403, 0.683228>, <-0.201547, 2.277115, 5.547002>
			}
			smooth_triangle {
				<0.625311, 0.443133, 0.633830>, <-0.373147, 2.248787, 4.447838>,
				<0.651611, 0.414223, 0.626839>, <-0.672613, 2.927095, 6.321644>,
				<0.624979, 0.415043, 0.652880>, <-0.416061, 2.931262, 6.341631>
			}
			smooth_triangle {
				<0.651611, 0.414223, 0.626839>, <-0.672613, 2.927095, 6.321644>,
				<0.647366, 0.393623, 0.644277>, <-0.494287, 2.383416, 5.483336>,
				<0.624979, 0.415043, 0.652880>, <-0.416061, 2.931262, 6.341631>
			}
			smooth_triangle {
				<0.647366, 0.393623, 0.644277>, <-0.494287, 2.383416, 5.483336>,
				<0.633950, 0.391113, 0.658982>, <-0.313027, 1.970840, 4.584006>,
				<0.624979, 0.415043, 0.652880>, <-0.416061, 2.931262, 6.341631>
			}
			smooth_triangle {
				<0.633950, 0.391113, 0.658982>, <-0.313027, 1.970840, 4.584006>,
				<0.617882, 0.395463, 0.671524>, <-0.251175, 2.394600, 5.494970>,
				<0.624979, 0.415043, 0.652880>, <-0.416061, 2.931262, 6.341631>
			}
			smooth_triangle {
				<0.625311, 0.443133, 0.633830>, <-0.373147, 2.248787, 4.447838>,
				<0.624979, 0.415043, 0.652880>, <-0.416061, 2.931262, 6.341631>,
				<0.600977, 0.446423, 0.654706>, <-0.192987, 2.256333, 4.455709>
			}
			smooth_triangle {
				<0.617882, 0.395463, 0.671524>, <-0.251175, 2.394600, 5.494970>,
				<0.595213, 0.418923, 0.677753>, <-0.143092, 2.963105, 6.338552>,
				<0.624979, 0.415043, 0.652880>, <-0.416061, 2.931262, 6.341631>
			}
			smooth_triangle {
				<0.624979, 0.415043, 0.652880>, <-0.416061, 2.931262, 6.341631>,
				<0.595213, 0.418923, 0.677753>, <-0.143092, 2.963105, 6.338552>,
				<0.600977, 0.446423, 0.654706>, <-0.192987, 2.256333, 4.455709>
			}
			smooth_triangle {
				<0.617882, 0.395463, 0.671524>, <-0.251175, 2.394600, 5.494970>,
				<0.633950, 0.391113, 0.658982>, <-0.313027, 1.970840, 4.584006>,
				<0.631878, 0.375573, 0.669923>, <-0.321100, 2.263172, 5.546949>
			}
			smooth_triangle {
				<0.647366, 0.393623, 0.644277>, <-0.494287, 2.383416, 5.483336>,
				<0.646876, 0.375223, 0.655641>, <-0.446725, 2.262191, 5.538738>,
				<0.633950, 0.391113, 0.658982>, <-0.313027, 1.970840, 4.584006>
			}
			smooth_triangle {
				<0.633950, 0.391113, 0.658982>, <-0.313027, 1.970840, 4.584006>,
				<0.646876, 0.375223, 0.655641>, <-0.446725, 2.262191, 5.538738>,
				<0.631878, 0.375573, 0.669923>, <-0.321100, 2.263172, 5.546949>
			}
			smooth_triangle {
				<0.646876, 0.375223, 0.655641>, <-0.446725, 2.262191, 5.538738>,
				<0.647366, 0.393623, 0.644277>, <-0.494287, 2.383416, 5.483336>,
				<0.661021, 0.375213, 0.641383>, <-0.565851, 2.265943, 5.526350>
			}
			smooth_triangle {
				<0.651611, 0.414223, 0.626839>, <-0.672613, 2.927095, 6.321644>,
				<0.664501, 0.389853, 0.628946>, <-0.628429, 2.354585, 5.482225>,
				<0.647366, 0.393623, 0.644277>, <-0.494287, 2.383416, 5.483336>
			}
			smooth_triangle {
				<0.647366, 0.393623, 0.644277>, <-0.494287, 2.383416, 5.483336>,
				<0.664501, 0.389853, 0.628946>, <-0.628429, 2.354585, 5.482225>,
				<0.661021, 0.375213, 0.641383>, <-0.565851, 2.265943, 5.526350>
			}
			smooth_triangle {
				<0.664501, 0.389853, 0.628946>, <-0.628429, 2.354585, 5.482225>,
				<0.651611, 0.414223, 0.626839>, <-0.672613, 2.927095, 6.321644>,
				<0.670710, 0.399153, 0.616387>, <-0.587286, 2.012254, 4.538948>
			}
			smooth_triangle {
				<0.625311, 0.443133, 0.633830>, <-0.373147, 2.248787, 4.447838>,
				<0.653126, 0.443453, 0.604890>, <-0.683544, 2.743071, 5.287673>,
				<0.651611, 0.414223, 0.626839>, <-0.672613, 2.927095, 6.321644>
			}
			smooth_triangle {
				<0.653126, 0.443453, 0.604890>, <-0.683544, 2.743071, 5.287673>,
				<0.672776, 0.413173, 0.604784>, <-0.762852, 2.505601, 5.397275>,
				<0.651611, 0.414223, 0.626839>, <-0.672613, 2.927095, 6.321644>
			}
			smooth_triangle {
				<0.651611, 0.414223, 0.626839>, <-0.672613, 2.927095, 6.321644>,
				<0.672776, 0.413173, 0.604784>, <-0.762852, 2.505601, 5.397275>,
				<0.670710, 0.399153, 0.616387>, <-0.587286, 2.012254, 4.538948>
			}
			smooth_triangle {
				<0.595213, 0.418923, 0.677753>, <-0.143092, 2.963105, 6.338552>,
				<0.617882, 0.395463, 0.671524>, <-0.251175, 2.394600, 5.494970>,
				<0.603647, 0.393703, 0.685362>, <-0.111074, 1.984031, 4.587646>
			}
			smooth_triangle {
				<0.631878, 0.375573, 0.669923>, <-0.321100, 2.263172, 5.546949>,
				<0.616333, 0.377403, 0.683228>, <-0.201547, 2.277115, 5.547002>,
				<0.617882, 0.395463, 0.671524>, <-0.251175, 2.394600, 5.494970>
			}
			smooth_triangle {
				<0.617882, 0.395463, 0.671524>, <-0.251175, 2.394600, 5.494970>,
				<0.616333, 0.377403, 0.683228>, <-0.201547, 2.277115, 5.547002>,
				<0.603647, 0.393703, 0.685362>, <-0.111074, 1.984031, 4.587646>
			}
			smooth_triangle {
				<0.600977, 0.446423, 0.654706>, <-0.192987, 2.256333, 4.455709>,
				<0.595213, 0.418923, 0.677753>, <-0.143092, 2.963105, 6.338552>,
				<0.563985, 0.458493, 0.678840>, <0.023319, 2.818694, 5.291450>
			}
			smooth_triangle {
				<0.601325, 0.378003, 0.696161>, <-0.075892, 2.280821, 5.548541>,
				<0.586687, 0.398043, 0.697478>, <-0.004655, 2.408826, 5.494421>,
				<0.603647, 0.393703, 0.685362>, <-0.111074, 1.984031, 4.587646>
			}
			smooth_triangle {
				<0.595213, 0.418923, 0.677753>, <-0.143092, 2.963105, 6.338552>,
				<0.565260, 0.422473, 0.700785>, <0.105888, 2.559534, 5.424039>,
				<0.563985, 0.458493, 0.678840>, <0.023319, 2.818694, 5.291450>
			}
			smooth_triangle {
				<0.586687, 0.398043, 0.697478>, <-0.004655, 2.408826, 5.494421>,
				<0.595213, 0.418923, 0.677753>, <-0.143092, 2.963105, 6.338552>,
				<0.603647, 0.393703, 0.685362>, <-0.111074, 1.984031, 4.587646>
			}
			smooth_triangle {
				<0.586687, 0.398043, 0.697478>, <-0.004655, 2.408826, 5.494421>,
				<0.565260, 0.422473, 0.700785>, <0.105888, 2.559534, 5.424039>,
				<0.595213, 0.418923, 0.677753>, <-0.143092, 2.963105, 6.338552>
			}
			smooth_triangle {
				<0.601325, 0.378003, 0.696161>, <-0.075892, 2.280821, 5.548541>,
				<0.584835, 0.377133, 0.710532>, <0.055607, 2.273896, 5.551458>,
				<0.586687, 0.398043, 0.697478>, <-0.004655, 2.408826, 5.494421>
			}
			smooth_triangle {
				<0.534710, 0.450762, 0.707113>, <0.217446, 2.289453, 4.436619>,
				<0.539990, 0.409372, 0.727967>, <0.437826, 3.296486, 7.273780>,
				<0.511814, 0.448392, 0.725332>, <0.367309, 2.267541, 4.438516>
			}
			smooth_triangle {
				<0.542639, 0.368962, 0.747350>, <0.446246, 2.602736, 6.481399>,
				<0.518618, 0.368052, 0.764647>, <0.362256, 1.508054, 3.686719>,
				<0.521912, 0.390622, 0.751087>, <0.409338, 1.967016, 4.577617>
			}
			smooth_triangle {
				<0.486311, 0.450372, 0.741471>, <0.537360, 2.285612, 4.411400>,
				<0.506416, 0.416982, 0.747524>, <0.559000, 2.521740, 5.413935>,
				<0.475705, 0.412242, 0.769979>, <0.925708, 2.912005, 6.295553>
			}
			smooth_triangle {
				<0.506416, 0.416982, 0.747524>, <0.559000, 2.521740, 5.413935>,
				<0.521912, 0.390622, 0.751087>, <0.409338, 1.967016, 4.577617>,
				<0.500834, 0.388502, 0.766385>, <0.663697, 2.351841, 5.478769>
			}
			smooth_triangle {
				<0.521912, 0.390622, 0.751087>, <0.409338, 1.967016, 4.577617>,
				<0.518618, 0.368052, 0.764647>, <0.362256, 1.508054, 3.686719>,
				<0.500834, 0.388502, 0.766385>, <0.663697, 2.351841, 5.478769>
			}
			smooth_triangle {
				<0.518618, 0.368052, 0.764647>, <0.362256, 1.508054, 3.686719>,
				<0.500426, 0.367072, 0.777131>, <0.228978, 0.759862, 1.835719>,
				<0.500834, 0.388502, 0.766385>, <0.663697, 2.351841, 5.478769>
			}
			smooth_triangle {
				<0.506416, 0.416982, 0.747524>, <0.559000, 2.521740, 5.413935>,
				<0.500834, 0.388502, 0.766385>, <0.663697, 2.351841, 5.478769>,
				<0.475705, 0.412242, 0.769979>, <0.925708, 2.912005, 6.295553>
			}
			smooth_triangle {
				<0.475705, 0.412242, 0.769979>, <0.925708, 2.912005, 6.295553>,
				<0.500834, 0.388502, 0.766385>, <0.663697, 2.351841, 5.478769>,
				<0.480683, 0.374492, 0.786009>, <0.391768, 1.173358, 2.732925>
			}
			smooth_triangle {
				<0.500834, 0.388502, 0.766385>, <0.663697, 2.351841, 5.478769>,
				<0.500426, 0.367072, 0.777131>, <0.228978, 0.759862, 1.835719>,
				<0.480683, 0.374492, 0.786009>, <0.391768, 1.173358, 2.732925>
			}
			smooth_triangle {
				<0.542639, 0.368962, 0.747350>, <0.446246, 2.602736, 6.481399>,
				<0.521912, 0.390622, 0.751087>, <0.409338, 1.967016, 4.577617>,
				<0.539990, 0.409372, 0.727967>, <0.437826, 3.296486, 7.273780>
			}
			smooth_triangle {
				<0.486311, 0.450372, 0.741471>, <0.537360, 2.285612, 4.411400>,
				<0.511814, 0.448392, 0.725332>, <0.367309, 2.267541, 4.438516>,
				<0.506416, 0.416982, 0.747524>, <0.559000, 2.521740, 5.413935>
			}
			smooth_triangle {
				<0.511814, 0.448392, 0.725332>, <0.367309, 2.267541, 4.438516>,
				<0.539990, 0.409372, 0.727967>, <0.437826, 3.296486, 7.273780>,
				<0.506416, 0.416982, 0.747524>, <0.559000, 2.521740, 5.413935>
			}
			smooth_triangle {
				<0.521912, 0.390622, 0.751087>, <0.409338, 1.967016, 4.577617>,
				<0.506416, 0.416982, 0.747524>, <0.559000, 2.521740, 5.413935>,
				<0.539990, 0.409372, 0.727967>, <0.437826, 3.296486, 7.273780>
			}
			smooth_triangle {
				<0.542639, 0.368962, 0.747350>, <0.446246, 2.602736, 6.481399>,
				<0.539990, 0.409372, 0.727967>, <0.437826, 3.296486, 7.273780>,
				<0.564872, 0.376083, 0.727049>, <0.220300, 2.270296, 5.548409>
			}
			smooth_triangle {
				<0.534710, 0.450762, 0.707113>, <0.217446, 2.289453, 4.436619>,
				<0.565260, 0.422473, 0.700785>, <0.105888, 2.559534, 5.424039>,
				<0.539990, 0.409372, 0.727967>, <0.437826, 3.296486, 7.273780>
			}
			smooth_triangle {
				<0.565260, 0.422473, 0.700785>, <0.105888, 2.559534, 5.424039>,
				<0.586687, 0.398043, 0.697478>, <-0.004655, 2.408826, 5.494421>,
				<0.568556, 0.396843, 0.713005>, <0.121897, 1.998659, 4.580684>
			}
			smooth_triangle {
				<0.586687, 0.398043, 0.697478>, <-0.004655, 2.408826, 5.494421>,
				<0.584835, 0.377133, 0.710532>, <0.055607, 2.273896, 5.551458>,
				<0.568556, 0.396843, 0.713005>, <0.121897, 1.998659, 4.580684>
			}
			smooth_triangle {
				<0.584835, 0.377133, 0.710532>, <0.055607, 2.273896, 5.551458>,
				<0.564872, 0.376083, 0.727049>, <0.220300, 2.270296, 5.548409>,
				<0.568556, 0.396843, 0.713005>, <0.121897, 1.998659, 4.580684>
			}
			smooth_triangle {
				<0.565260, 0.422473, 0.700785>, <0.105888, 2.559534, 5.424039>,
				<0.568556, 0.396843, 0.713005>, <0.121897, 1.998659, 4.580684>,
				<0.539990, 0.409372, 0.727967>, <0.437826, 3.296486, 7.273780>
			}
			smooth_triangle {
				<0.568556, 0.396843, 0.713005>, <0.121897, 1.998659, 4.580684>,
				<0.564872, 0.376083, 0.727049>, <0.220300, 2.270296, 5.548409>,
				<0.539990, 0.409372, 0.727967>, <0.437826, 3.296486, 7.273780>
			}
			smooth_triangle {
				<0.221560, 0.365181, 0.898146>, <1.223792, 1.122542, 2.498204>,
				<0.236207, 0.372151, 0.891535>, <2.370385, 2.255695, 5.028503>,
				<0.240174, 0.355351, 0.897305>, <1.176440, 1.082294, 2.538441>
			}
			smooth_triangle {
				<0.486311, 0.450372, 0.741471>, <0.537360, 2.285612, 4.411400>,
				<0.475705, 0.412242, 0.769979>, <0.925708, 2.912005, 6.295553>,
				<0.446459, 0.459132, 0.760904>, <1.029965, 3.275425, 6.093771>
			}
			smooth_triangle {
				<0.240174, 0.355351, 0.897305>, <1.176440, 1.082294, 2.538441>,
				<0.236207, 0.372151, 0.891535>, <2.370385, 2.255695, 5.028503>,
				<0.254456, 0.358681, 0.892031>, <2.281343, 2.163407, 5.109809>
			}
			smooth_triangle {
				<0.236207, 0.372151, 0.891535>, <2.370385, 2.255695, 5.028503>,
				<0.252554, 0.376311, 0.885285>, <1.885231, 1.896648, 4.224227>,
				<0.254456, 0.358681, 0.892031>, <2.281343, 2.163407, 5.109809>
			}
			smooth_triangle {
				<0.254456, 0.358681, 0.892031>, <2.281343, 2.163407, 5.109809>,
				<0.252554, 0.376311, 0.885285>, <1.885231, 1.896648, 4.224227>,
				<0.270578, 0.364412, 0.884938>, <2.174282, 2.201002, 5.140130>
			}
			smooth_triangle {
				<0.252554, 0.376311, 0.885285>, <1.885231, 1.896648, 4.224227>,
				<0.265478, 0.390261, 0.875406>, <2.159962, 2.368515, 5.070637>,
				<0.270578, 0.364412, 0.884938>, <2.174282, 2.201002, 5.140130>
			}
			smooth_triangle {
				<0.270578, 0.364412, 0.884938>, <2.174282, 2.201002, 5.140130>,
				<0.265478, 0.390261, 0.875406>, <2.159962, 2.368515, 5.070637>,
				<0.290514, 0.371632, 0.875559>, <2.048755, 2.246243, 5.171755>
			}
			smooth_triangle {
				<0.265478, 0.390261, 0.875406>, <2.159962, 2.368515, 5.070637>,
				<0.290867, 0.401242, 0.862274>, <2.001106, 2.432339, 5.105056>,
				<0.290514, 0.371632, 0.875559>, <2.048755, 2.246243, 5.171755>
			}
			smooth_triangle {
				<0.290514, 0.371632, 0.875559>, <2.048755, 2.246243, 5.171755>,
				<0.290867, 0.401242, 0.862274>, <2.001106, 2.432339, 5.105056>,
				<0.314864, 0.375822, 0.865296>, <1.900168, 2.268367, 5.218493>
			}
			smooth_triangle {
				<0.290867, 0.401242, 0.862274>, <2.001106, 2.432339, 5.105056>,
				<0.318867, 0.400542, 0.852643>, <1.523923, 2.021759, 4.310419>,
				<0.314864, 0.375822, 0.865296>, <1.900168, 2.268367, 5.218493>
			}
			smooth_triangle {
				<0.314864, 0.375822, 0.865296>, <1.900168, 2.268367, 5.218493>,
				<0.318867, 0.400542, 0.852643>, <1.523923, 2.021759, 4.310419>,
				<0.341408, 0.377992, 0.854210>, <1.727378, 2.283199, 5.271632>
			}
			smooth_triangle {
				<0.318867, 0.400542, 0.852643>, <1.523923, 2.021759, 4.310419>,
				<0.343945, 0.410182, 0.838192>, <1.650561, 2.487532, 5.202363>,
				<0.341408, 0.377992, 0.854210>, <1.727378, 2.283199, 5.271632>
			}
			smooth_triangle {
				<0.341408, 0.377992, 0.854210>, <1.727378, 2.283199, 5.271632>,
				<0.343945, 0.410182, 0.838192>, <1.650561, 2.487532, 5.202363>,
				<0.372857, 0.376792, 0.841502>, <1.799093, 2.660455, 6.218155>
			}
			smooth_triangle {
				<0.343945, 0.410182, 0.838192>, <1.650561, 2.487532, 5.202363>,
				<0.380746, 0.410432, 0.821998>, <1.424135, 2.491262, 5.266903>,
				<0.372857, 0.376792, 0.841502>, <1.799093, 2.660455, 6.218155>
			}
			smooth_triangle {
				<0.372857, 0.376792, 0.841502>, <1.799093, 2.660455, 6.218155>,
				<0.380746, 0.410432, 0.821998>, <1.424135, 2.491262, 5.266903>,
				<0.398482, 0.380042, 0.828185>, <1.141152, 1.917577, 4.473467>
			}
			smooth_triangle {
				<0.446459, 0.459132, 0.760904>, <1.029965, 3.275425, 6.093771>,
				<0.442539, 0.412132, 0.789571>, <1.014753, 2.500577, 5.356641>,
				<0.402617, 0.442542, 0.794468>, <1.218040, 2.691585, 5.217621>
			}
			smooth_triangle {
				<0.402617, 0.442542, 0.794468>, <1.218040, 2.691585, 5.217621>,
				<0.442539, 0.412132, 0.789571>, <1.014753, 2.500577, 5.356641>,
				<0.418795, 0.393462, 0.811727>, <1.414803, 2.782308, 6.263611>
			}
			smooth_triangle {
				<0.442539, 0.412132, 0.789571>, <1.014753, 2.500577, 5.356641>,
				<0.445449, 0.381842, 0.803042>, <0.883203, 1.923882, 4.528918>,
				<0.418795, 0.393462, 0.811727>, <1.414803, 2.782308, 6.263611>
			}
			smooth_triangle {
				<0.402617, 0.442542, 0.794468>, <1.218040, 2.691585, 5.217621>,
				<0.418795, 0.393462, 0.811727>, <1.414803, 2.782308, 6.263611>,
				<0.380746, 0.410432, 0.821998>, <1.424135, 2.491262, 5.266903>
			}
			smooth_triangle {
				<0.418795, 0.393462, 0.811727>, <1.414803, 2.782308, 6.263611>,
				<0.398482, 0.380042, 0.828185>, <1.141152, 1.917577, 4.473467>,
				<0.380746, 0.410432, 0.821998>, <1.424135, 2.491262, 5.266903>
			}
			smooth_triangle {
				<0.445449, 0.381842, 0.803042>, <0.883203, 1.923882, 4.528918>,
				<0.442539, 0.412132, 0.789571>, <1.014753, 2.500577, 5.356641>,
				<0.463908, 0.380492, 0.793179>, <0.620896, 1.572018, 3.624778>
			}
			smooth_triangle {
				<0.446459, 0.459132, 0.760904>, <1.029965, 3.275425, 6.093771>,
				<0.475705, 0.412242, 0.769979>, <0.925708, 2.912005, 6.295553>,
				<0.442539, 0.412132, 0.789571>, <1.014753, 2.500577, 5.356641>
			}
			smooth_triangle {
				<0.442539, 0.412132, 0.789571>, <1.014753, 2.500577, 5.356641>,
				<0.475705, 0.412242, 0.769979>, <0.925708, 2.912005, 6.295553>,
				<0.463908, 0.380492, 0.793179>, <0.620896, 1.572018, 3.624778>
			}
			smooth_triangle {
				<0.202872, 0.364671, 0.902758>, <1.722141, 1.480925, 3.292236>,
				<0.204915, 0.383971, 0.894256>, <2.935907, 2.724241, 5.739372>,
				<0.221560, 0.365181, 0.898146>, <1.223792, 1.122542, 2.498204>
			}
			smooth_triangle {
				<0.343945, 0.410182, 0.838192>, <1.650561, 2.487532, 5.202363>,
				<0.345423, 0.456212, 0.813428>, <1.818999, 3.254865, 5.917284>,
				<0.380746, 0.410432, 0.821998>, <1.424135, 2.491262, 5.266903>
			}
			smooth_triangle {
				<0.592673, 0.493943, 0.627589>, <-0.281337, 2.450678, 4.341859>,
				<0.563985, 0.458493, 0.678840>, <0.023319, 2.818694, 5.291450>,
				<0.488682, 0.511622, 0.698962>, <0.414209, 2.955405, 5.199518>
			}
			smooth_triangle {
				<0.563985, 0.458493, 0.678840>, <0.023319, 2.818694, 5.291450>,
				<0.534710, 0.450762, 0.707113>, <0.217446, 2.289453, 4.436619>,
				<0.488682, 0.511622, 0.698962>, <0.414209, 2.955405, 5.199518>
			}
			smooth_triangle {
				<0.534710, 0.450762, 0.707113>, <0.217446, 2.289453, 4.436619>,
				<0.511814, 0.448392, 0.725332>, <0.367309, 2.267541, 4.438516>,
				<0.488682, 0.511622, 0.698962>, <0.414209, 2.955405, 5.199518>
			}
			smooth_triangle {
				<0.486311, 0.450372, 0.741471>, <0.537360, 2.285612, 4.411400>,
				<0.488682, 0.511622, 0.698962>, <0.414209, 2.955405, 5.199518>,
				<0.511814, 0.448392, 0.725332>, <0.367309, 2.267541, 4.438516>
			}
			smooth_triangle {
				<0.486311, 0.450372, 0.741471>, <0.537360, 2.285612, 4.411400>,
				<0.446459, 0.459132, 0.760904>, <1.029965, 3.275425, 6.093771>,
				<0.488682, 0.511622, 0.698962>, <0.414209, 2.955405, 5.199518>
			}
			smooth_triangle {
				<0.446459, 0.459132, 0.760904>, <1.029965, 3.275425, 6.093771>,
				<0.402617, 0.442542, 0.794468>, <1.218040, 2.691585, 5.217621>,
				<0.376936, 0.517442, 0.761111>, <0.807531, 1.953990, 3.393785>
			}
			smooth_triangle {
				<0.376936, 0.517442, 0.761111>, <0.807531, 1.953990, 3.393785>,
				<0.402617, 0.442542, 0.794468>, <1.218040, 2.691585, 5.217621>,
				<0.345423, 0.456212, 0.813428>, <1.818999, 3.254865, 5.917284>
			}
			smooth_triangle {
				<0.402617, 0.442542, 0.794468>, <1.218040, 2.691585, 5.217621>,
				<0.380746, 0.410432, 0.821998>, <1.424135, 2.491262, 5.266903>,
				<0.345423, 0.456212, 0.813428>, <1.818999, 3.254865, 5.917284>
			}
			smooth_triangle {
				<0.563985, 0.458493, 0.678840>, <0.023319, 2.818694, 5.291450>,
				<0.592673, 0.493943, 0.627589>, <-0.281337, 2.450678, 4.341859>,
				<0.600977, 0.446423, 0.654706>, <-0.192987, 2.256333, 4.455709>
			}
			smooth_triangle {
				<0.592673, 0.493943, 0.627589>, <-0.281337, 2.450678, 4.341859>,
				<0.625311, 0.443133, 0.633830>, <-0.373147, 2.248787, 4.447838>,
				<0.600977, 0.446423, 0.654706>, <-0.192987, 2.256333, 4.455709>
			}
			smooth_triangle {
				<0.653126, 0.443453, 0.604890>, <-0.683544, 2.743071, 5.287673>,
				<0.686742, 0.464953, 0.548916>, <-0.878926, 2.298448, 4.345247>,
				<0.683205, 0.426133, 0.583750>, <-0.753707, 2.162704, 4.442815>
			}
			smooth_triangle {
				<0.592673, 0.493943, 0.627589>, <-0.281337, 2.450678, 4.341859>,
				<0.653126, 0.443453, 0.604890>, <-0.683544, 2.743071, 5.287673>,
				<0.625311, 0.443133, 0.633830>, <-0.373147, 2.248787, 4.447838>
			}
			smooth_triangle {
				<0.592673, 0.493943, 0.627589>, <-0.281337, 2.450678, 4.341859>,
				<0.686742, 0.464953, 0.548916>, <-0.878926, 2.298448, 4.345247>,
				<0.653126, 0.443453, 0.604890>, <-0.683544, 2.743071, 5.287673>
			}
			smooth_triangle {
				<0.290867, 0.401242, 0.862274>, <2.001106, 2.432339, 5.105056>,
				<0.265478, 0.390261, 0.875406>, <2.159962, 2.368515, 5.070637>,
				<0.251769, 0.430891, 0.860266>, <2.520884, 3.064358, 5.761651>
			}
			smooth_triangle {
				<0.202859, 0.458331, 0.859011>, <3.141533, 3.718771, 6.340112>,
				<0.251769, 0.430891, 0.860266>, <2.520884, 3.064358, 5.761651>,
				<0.202638, 0.416811, 0.879952>, <2.473085, 2.524655, 4.845988>
			}
			smooth_triangle {
				<0.202638, 0.416811, 0.879952>, <2.473085, 2.524655, 4.845988>,
				<0.251769, 0.430891, 0.860266>, <2.520884, 3.064358, 5.761651>,
				<0.235706, 0.395401, 0.881603>, <2.327751, 2.402299, 4.979472>
			}
			smooth_triangle {
				<0.251769, 0.430891, 0.860266>, <2.520884, 3.064358, 5.761651>,
				<0.265478, 0.390261, 0.875406>, <2.159962, 2.368515, 5.070637>,
				<0.235706, 0.395401, 0.881603>, <2.327751, 2.402299, 4.979472>
			}
			smooth_triangle {
				<0.265478, 0.390261, 0.875406>, <2.159962, 2.368515, 5.070637>,
				<0.252554, 0.376311, 0.885285>, <1.885231, 1.896648, 4.224227>,
				<0.235706, 0.395401, 0.881603>, <2.327751, 2.402299, 4.979472>
			}
			smooth_triangle {
				<0.345423, 0.456212, 0.813428>, <1.818999, 3.254865, 5.917284>,
				<0.343945, 0.410182, 0.838192>, <1.650561, 2.487532, 5.202363>,
				<0.302359, 0.436022, 0.841169>, <1.860716, 2.664876, 5.038939>
			}
			smooth_triangle {
				<0.343945, 0.410182, 0.838192>, <1.650561, 2.487532, 5.202363>,
				<0.318867, 0.400542, 0.852643>, <1.523923, 2.021759, 4.310419>,
				<0.302359, 0.436022, 0.841169>, <1.860716, 2.664876, 5.038939>
			}
			smooth_triangle {
				<0.251769, 0.430891, 0.860266>, <2.520884, 3.064358, 5.761651>,
				<0.302359, 0.436022, 0.841169>, <1.860716, 2.664876, 5.038939>,
				<0.290867, 0.401242, 0.862274>, <2.001106, 2.432339, 5.105056>
			}
			smooth_triangle {
				<0.318867, 0.400542, 0.852643>, <1.523923, 2.021759, 4.310419>,
				<0.290867, 0.401242, 0.862274>, <2.001106, 2.432339, 5.105056>,
				<0.302359, 0.436022, 0.841169>, <1.860716, 2.664876, 5.038939>
			}
			smooth_triangle {
				<0.345423, 0.456212, 0.813428>, <1.818999, 3.254865, 5.917284>,
				<0.302359, 0.436022, 0.841169>, <1.860716, 2.664876, 5.038939>,
				<0.260292, 0.511342, 0.812333>, <1.622088, 2.374826, 4.087964>
			}
			smooth_triangle {
				<0.302359, 0.436022, 0.841169>, <1.860716, 2.664876, 5.038939>,
				<0.251769, 0.430891, 0.860266>, <2.520884, 3.064358, 5.761651>,
				<0.260292, 0.511342, 0.812333>, <1.622088, 2.374826, 4.087964>
			}
			smooth_triangle {
				<0.251769, 0.430891, 0.860266>, <2.520884, 3.064358, 5.761651>,
				<0.202859, 0.458331, 0.859011>, <3.141533, 3.718771, 6.340112>,
				<0.260292, 0.511342, 0.812333>, <1.622088, 2.374826, 4.087964>
			}
			smooth_triangle {
				<0.202638, 0.416811, 0.879952>, <2.473085, 2.524655, 4.845988>,
				<0.235706, 0.395401, 0.881603>, <2.327751, 2.402299, 4.979472>,
				<0.204915, 0.383971, 0.894256>, <2.935907, 2.724241, 5.739372>
			}
			smooth_triangle {
				<0.252554, 0.376311, 0.885285>, <1.885231, 1.896648, 4.224227>,
				<0.236207, 0.372151, 0.891535>, <2.370385, 2.255695, 5.028503>,
				<0.235706, 0.395401, 0.881603>, <2.327751, 2.402299, 4.979472>
			}
			smooth_triangle {
				<0.235706, 0.395401, 0.881603>, <2.327751, 2.402299, 4.979472>,
				<0.236207, 0.372151, 0.891535>, <2.370385, 2.255695, 5.028503>,
				<0.204915, 0.383971, 0.894256>, <2.935907, 2.724241, 5.739372>
			}
			smooth_triangle {
				<0.236207, 0.372151, 0.891535>, <2.370385, 2.255695, 5.028503>,
				<0.221560, 0.365181, 0.898146>, <1.223792, 1.122542, 2.498204>,
				<0.204915, 0.383971, 0.894256>, <2.935907, 2.724241, 5.739372>
			}
			smooth_triangle {
				<0.661021, 0.375213, 0.641383>, <-0.565851, 2.265943, 5.526350>,
				<0.659422, 0.359923, 0.651706>, <-0.516349, 2.175230, 5.567576>,
				<0.646876, 0.375223, 0.655641>, <-0.446725, 2.262191, 5.538738>
			}
			smooth_triangle {
				<0.620250, 0.316093, 0.710266>, <-0.114025, 1.908859, 5.686438>,
				<0.636438, 0.293813, 0.705507>, <-0.233929, 2.070273, 6.682068>,
				<0.619794, 0.294363, 0.719944>, <-0.076852, 1.778599, 5.729230>
			}
			smooth_triangle {
				<0.636438, 0.293813, 0.705507>, <-0.233929, 2.070273, 6.682068>,
				<0.633612, 0.271533, 0.716887>, <-0.106179, 1.119044, 3.838549>,
				<0.619794, 0.294363, 0.719944>, <-0.076852, 1.778599, 5.729230>
			}
			smooth_triangle {
				<0.633612, 0.271533, 0.716887>, <-0.106179, 1.119044, 3.838549>,
				<0.618890, 0.278393, 0.727034>, <-0.021082, 0.574778, 1.915434>,
				<0.619794, 0.294363, 0.719944>, <-0.076852, 1.778599, 5.729230>
			}
			smooth_triangle {
				<0.620250, 0.316093, 0.710266>, <-0.114025, 1.908859, 5.686438>,
				<0.619794, 0.294363, 0.719944>, <-0.076852, 1.778599, 5.729230>,
				<0.603750, 0.312913, 0.725730>, <0.023096, 1.889451, 5.694065>
			}
			smooth_triangle {
				<0.618890, 0.278393, 0.727034>, <-0.021082, 0.574778, 1.915434>,
				<0.604726, 0.292673, 0.733318>, <0.010253, 0.898602, 2.862074>,
				<0.619794, 0.294363, 0.719944>, <-0.076852, 1.778599, 5.729230>
			}
			smooth_triangle {
				<0.619794, 0.294363, 0.719944>, <-0.076852, 1.778599, 5.729230>,
				<0.604726, 0.292673, 0.733318>, <0.010253, 0.898602, 2.862074>,
				<0.603750, 0.312913, 0.725730>, <0.023096, 1.889451, 5.694065>
			}
			smooth_triangle {
				<0.620250, 0.316093, 0.710266>, <-0.114025, 1.908859, 5.686438>,
				<0.636354, 0.317773, 0.695108>, <-0.238902, 1.919794, 5.678962>,
				<0.636438, 0.293813, 0.705507>, <-0.233929, 2.070273, 6.682068>
			}
			smooth_triangle {
				<0.636438, 0.293813, 0.705507>, <-0.233929, 2.070273, 6.682068>,
				<0.636354, 0.317773, 0.695108>, <-0.238902, 1.919794, 5.678962>,
				<0.647501, 0.301483, 0.692073>, <-0.255430, 1.516279, 4.757315>
			}
			smooth_triangle {
				<0.636354, 0.317773, 0.695108>, <-0.238902, 1.919794, 5.678962>,
				<0.620250, 0.316093, 0.710266>, <-0.114025, 1.908859, 5.686438>,
				<0.620814, 0.341033, 0.698135>, <-0.187417, 2.395824, 6.573771>
			}
			smooth_triangle {
				<0.603750, 0.312913, 0.725730>, <0.023096, 1.889451, 5.694065>,
				<0.603086, 0.335683, 0.716040>, <-0.011786, 2.024674, 5.647358>,
				<0.620250, 0.316093, 0.710266>, <-0.114025, 1.908859, 5.686438>
			}
			smooth_triangle {
				<0.620250, 0.316093, 0.710266>, <-0.114025, 1.908859, 5.686438>,
				<0.603086, 0.335683, 0.716040>, <-0.011786, 2.024674, 5.647358>,
				<0.620814, 0.341033, 0.698135>, <-0.187417, 2.395824, 6.573771>
			}
			smooth_triangle {
				<0.647501, 0.301483, 0.692073>, <-0.255430, 1.516279, 4.757315>,
				<0.636354, 0.317773, 0.695108>, <-0.238902, 1.919794, 5.678962>,
				<0.651529, 0.316363, 0.681565>, <-0.368295, 1.911139, 5.675076>
			}
			smooth_triangle {
				<0.620814, 0.341033, 0.698135>, <-0.187417, 2.395824, 6.573771>,
				<0.640478, 0.337043, 0.682132>, <-0.312629, 2.033692, 5.635520>,
				<0.636354, 0.317773, 0.695108>, <-0.238902, 1.919794, 5.678962>
			}
			smooth_triangle {
				<0.636354, 0.317773, 0.695108>, <-0.238902, 1.919794, 5.678962>,
				<0.640478, 0.337043, 0.682132>, <-0.312629, 2.033692, 5.635520>,
				<0.651529, 0.316363, 0.681565>, <-0.368295, 1.911139, 5.675076>
			}
			smooth_triangle {
				<0.640478, 0.337043, 0.682132>, <-0.312629, 2.033692, 5.635520>,
				<0.620814, 0.341033, 0.698135>, <-0.187417, 2.395824, 6.573771>,
				<0.628498, 0.358303, 0.682432>, <-0.260199, 2.158859, 5.591544>
			}
			smooth_triangle {
				<0.603086, 0.335683, 0.716040>, <-0.011786, 2.024674, 5.647358>,
				<0.601630, 0.358323, 0.706231>, <-0.038824, 2.157812, 5.597796>,
				<0.620814, 0.341033, 0.698135>, <-0.187417, 2.395824, 6.573771>
			}
			smooth_triangle {
				<0.601630, 0.358323, 0.706231>, <-0.038824, 2.157812, 5.597796>,
				<0.601325, 0.378003, 0.696161>, <-0.075892, 2.280821, 5.548541>,
				<0.613843, 0.362713, 0.693359>, <-0.123838, 1.820540, 4.654724>
			}
			smooth_triangle {
				<0.601325, 0.378003, 0.696161>, <-0.075892, 2.280821, 5.548541>,
				<0.616333, 0.377403, 0.683228>, <-0.201547, 2.277115, 5.547002>,
				<0.613843, 0.362713, 0.693359>, <-0.123838, 1.820540, 4.654724>
			}
			smooth_triangle {
				<0.616333, 0.377403, 0.683228>, <-0.201547, 2.277115, 5.547002>,
				<0.628498, 0.358303, 0.682432>, <-0.260199, 2.158859, 5.591544>,
				<0.613843, 0.362713, 0.693359>, <-0.123838, 1.820540, 4.654724>
			}
			smooth_triangle {
				<0.601630, 0.358323, 0.706231>, <-0.038824, 2.157812, 5.597796>,
				<0.613843, 0.362713, 0.693359>, <-0.123838, 1.820540, 4.654724>,
				<0.620814, 0.341033, 0.698135>, <-0.187417, 2.395824, 6.573771>
			}
			smooth_triangle {
				<0.613843, 0.362713, 0.693359>, <-0.123838, 1.820540, 4.654724>,
				<0.628498, 0.358303, 0.682432>, <-0.260199, 2.158859, 5.591544>,
				<0.620814, 0.341033, 0.698135>, <-0.187417, 2.395824, 6.573771>
			}
			smooth_triangle {
				<0.651529, 0.316363, 0.681565>, <-0.368295, 1.911139, 5.675076>,
				<0.640478, 0.337043, 0.682132>, <-0.312629, 2.033692, 5.635520>,
				<0.657803, 0.332693, 0.667620>, <-0.517756, 2.340444, 6.576281>
			}
			smooth_triangle {
				<0.616333, 0.377403, 0.683228>, <-0.201547, 2.277115, 5.547002>,
				<0.631878, 0.375573, 0.669923>, <-0.321100, 2.263172, 5.546949>,
				<0.628498, 0.358303, 0.682432>, <-0.260199, 2.158859, 5.591544>
			}
			smooth_triangle {
				<0.628498, 0.358303, 0.682432>, <-0.260199, 2.158859, 5.591544>,
				<0.631878, 0.375573, 0.669923>, <-0.321100, 2.263172, 5.546949>,
				<0.646632, 0.355173, 0.666955>, <-0.463537, 2.498845, 6.521697>
			}
			smooth_triangle {
				<0.646876, 0.375223, 0.655641>, <-0.446725, 2.262191, 5.538738>,
				<0.646632, 0.355173, 0.666955>, <-0.463537, 2.498845, 6.521697>,
				<0.631878, 0.375573, 0.669923>, <-0.321100, 2.263172, 5.546949>
			}
			smooth_triangle {
				<0.646876, 0.375223, 0.655641>, <-0.446725, 2.262191, 5.538738>,
				<0.659422, 0.359923, 0.651706>, <-0.516349, 2.175230, 5.567576>,
				<0.646632, 0.355173, 0.666955>, <-0.463537, 2.498845, 6.521697>
			}
			smooth_triangle {
				<0.659422, 0.359923, 0.651706>, <-0.516349, 2.175230, 5.567576>,
				<0.660204, 0.346443, 0.658191>, <-0.408886, 1.742697, 4.668347>,
				<0.646632, 0.355173, 0.666955>, <-0.463537, 2.498845, 6.521697>
			}
			smooth_triangle {
				<0.628498, 0.358303, 0.682432>, <-0.260199, 2.158859, 5.591544>,
				<0.646632, 0.355173, 0.666955>, <-0.463537, 2.498845, 6.521697>,
				<0.640478, 0.337043, 0.682132>, <-0.312629, 2.033692, 5.635520>
			}
			smooth_triangle {
				<0.660204, 0.346443, 0.658191>, <-0.408886, 1.742697, 4.668347>,
				<0.657803, 0.332693, 0.667620>, <-0.517756, 2.340444, 6.576281>,
				<0.646632, 0.355173, 0.666955>, <-0.463537, 2.498845, 6.521697>
			}
			smooth_triangle {
				<0.646632, 0.355173, 0.666955>, <-0.463537, 2.498845, 6.521697>,
				<0.657803, 0.332693, 0.667620>, <-0.517756, 2.340444, 6.576281>,
				<0.640478, 0.337043, 0.682132>, <-0.312629, 2.033692, 5.635520>
			}
			smooth_triangle {
				<0.604726, 0.292673, 0.733318>, <0.010253, 0.898602, 2.862074>,
				<0.587496, 0.307493, 0.741223>, <0.062553, 0.947091, 2.845706>,
				<0.603750, 0.312913, 0.725730>, <0.023096, 1.889451, 5.694065>
			}
			smooth_triangle {
				<0.518618, 0.368052, 0.764647>, <0.362256, 1.508054, 3.686719>,
				<0.542639, 0.368962, 0.747350>, <0.446246, 2.602736, 6.481399>,
				<0.533224, 0.352362, 0.761986>, <0.144344, 0.722447, 1.859235>
			}
			smooth_triangle {
				<0.601325, 0.378003, 0.696161>, <-0.075892, 2.280821, 5.548541>,
				<0.601630, 0.358323, 0.706231>, <-0.038824, 2.157812, 5.597796>,
				<0.584835, 0.377133, 0.710532>, <0.055607, 2.273896, 5.551458>
			}
			smooth_triangle {
				<0.601630, 0.358323, 0.706231>, <-0.038824, 2.157812, 5.597796>,
				<0.603086, 0.335683, 0.716040>, <-0.011786, 2.024674, 5.647358>,
				<0.584746, 0.354453, 0.722187>, <0.101402, 2.137819, 5.604538>
			}
			smooth_triangle {
				<0.551069, 0.336062, 0.756633>, <0.172695, 1.046304, 2.806136>,
				<0.566691, 0.348143, 0.739439>, <0.251923, 2.102151, 5.613156>,
				<0.569372, 0.321723, 0.749277>, <0.118200, 0.995254, 2.827456>
			}
			smooth_triangle {
				<0.584746, 0.354453, 0.722187>, <0.101402, 2.137819, 5.604538>,
				<0.603086, 0.335683, 0.716040>, <-0.011786, 2.024674, 5.647358>,
				<0.586041, 0.330243, 0.732536>, <0.133478, 1.993470, 5.656880>
			}
			smooth_triangle {
				<0.603086, 0.335683, 0.716040>, <-0.011786, 2.024674, 5.647358>,
				<0.603750, 0.312913, 0.725730>, <0.023096, 1.889451, 5.694065>,
				<0.586041, 0.330243, 0.732536>, <0.133478, 1.993470, 5.656880>
			}
			smooth_triangle {
				<0.603750, 0.312913, 0.725730>, <0.023096, 1.889451, 5.694065>,
				<0.587496, 0.307493, 0.741223>, <0.062553, 0.947091, 2.845706>,
				<0.586041, 0.330243, 0.732536>, <0.133478, 1.993470, 5.656880>
			}
			smooth_triangle {
				<0.584746, 0.354453, 0.722187>, <0.101402, 2.137819, 5.604538>,
				<0.586041, 0.330243, 0.732536>, <0.133478, 1.993470, 5.656880>,
				<0.566691, 0.348143, 0.739439>, <0.251923, 2.102151, 5.613156>
			}
			smooth_triangle {
				<0.587496, 0.307493, 0.741223>, <0.062553, 0.947091, 2.845706>,
				<0.569372, 0.321723, 0.749277>, <0.118200, 0.995254, 2.827456>,
				<0.586041, 0.330243, 0.732536>, <0.133478, 1.993470, 5.656880>
			}
			smooth_triangle {
				<0.586041, 0.330243, 0.732536>, <0.133478, 1.993470, 5.656880>,
				<0.569372, 0.321723, 0.749277>, <0.118200, 0.995254, 2.827456>,
				<0.566691, 0.348143, 0.739439>, <0.251923, 2.102151, 5.613156>
			}
			smooth_triangle {
				<0.601630, 0.358323, 0.706231>, <-0.038824, 2.157812, 5.597796>,
				<0.584746, 0.354453, 0.722187>, <0.101402, 2.137819, 5.604538>,
				<0.584835, 0.377133, 0.710532>, <0.055607, 2.273896, 5.551458>
			}
			smooth_triangle {
				<0.542639, 0.368962, 0.747350>, <0.446246, 2.602736, 6.481399>,
				<0.564872, 0.376083, 0.727049>, <0.220300, 2.270296, 5.548409>,
				<0.566691, 0.348143, 0.739439>, <0.251923, 2.102151, 5.613156>
			}
			smooth_triangle {
				<0.566691, 0.348143, 0.739439>, <0.251923, 2.102151, 5.613156>,
				<0.564872, 0.376083, 0.727049>, <0.220300, 2.270296, 5.548409>,
				<0.584746, 0.354453, 0.722187>, <0.101402, 2.137819, 5.604538>
			}
			smooth_triangle {
				<0.564872, 0.376083, 0.727049>, <0.220300, 2.270296, 5.548409>,
				<0.584835, 0.377133, 0.710532>, <0.055607, 2.273896, 5.551458>,
				<0.584746, 0.354453, 0.722187>, <0.101402, 2.137819, 5.604538>
			}
			smooth_triangle {
				<0.566691, 0.348143, 0.739439>, <0.251923, 2.102151, 5.613156>,
				<0.551069, 0.336062, 0.756633>, <0.172695, 1.046304, 2.806136>,
				<0.542639, 0.368962, 0.747350>, <0.446246, 2.602736, 6.481399>
			}
			smooth_triangle {
				<0.542639, 0.368962, 0.747350>, <0.446246, 2.602736, 6.481399>,
				<0.551069, 0.336062, 0.756633>, <0.172695, 1.046304, 2.806136>,
				<0.533224, 0.352362, 0.761986>, <0.144344, 0.722447, 1.859235>
			}
			smooth_triangle {
				<0.642685, 0.231633, 0.722784>, <-0.074171, 0.466161, 1.943404>,
				<0.641557, 0.251343, 0.717177>, <-0.149721, 1.018196, 3.865129>,
				<0.654385, 0.236063, 0.710747>, <-0.272058, 1.421218, 5.822317>
			}
			smooth_triangle {
				<0.698982, 0.254083, 0.660284>, <-0.667748, 1.532869, 5.761736>,
				<0.683861, 0.250283, 0.677345>, <-0.531854, 1.510914, 5.781584>,
				<0.686619, 0.273953, 0.665293>, <-0.591466, 1.651566, 5.737161>
			}
			smooth_triangle {
				<0.665757, 0.312103, 0.669679>, <-0.475467, 1.882888, 5.676613>,
				<0.675003, 0.293523, 0.668827>, <-0.525100, 1.765230, 5.709823>,
				<0.660338, 0.296403, 0.682059>, <-0.409875, 1.785196, 5.713111>
			}
			smooth_triangle {
				<0.675003, 0.293523, 0.668827>, <-0.525100, 1.765230, 5.709823>,
				<0.669075, 0.271673, 0.683853>, <-0.515584, 1.909493, 6.713933>,
				<0.660338, 0.296403, 0.682059>, <-0.409875, 1.785196, 5.713111>
			}
			smooth_triangle {
				<0.660338, 0.296403, 0.682059>, <-0.409875, 1.785196, 5.713111>,
				<0.669075, 0.271673, 0.683853>, <-0.515584, 1.909493, 6.713933>,
				<0.652219, 0.282613, 0.695595>, <-0.320258, 1.701876, 5.744162>
			}
			smooth_triangle {
				<0.668722, 0.244003, 0.694540>, <-0.398841, 1.472747, 5.802094>,
				<0.655129, 0.259723, 0.701755>, <-0.310976, 1.564845, 5.783426>,
				<0.669075, 0.271673, 0.683853>, <-0.515584, 1.909493, 6.713933>
			}
			smooth_triangle {
				<0.669075, 0.271673, 0.683853>, <-0.515584, 1.909493, 6.713933>,
				<0.655129, 0.259723, 0.701755>, <-0.310976, 1.564845, 5.783426>,
				<0.652219, 0.282613, 0.695595>, <-0.320258, 1.701876, 5.744162>
			}
			smooth_triangle {
				<0.643908, 0.271893, 0.707502>, <-0.194216, 1.366603, 4.805322>,
				<0.652219, 0.282613, 0.695595>, <-0.320258, 1.701876, 5.744162>,
				<0.655129, 0.259723, 0.701755>, <-0.310976, 1.564845, 5.783426>
			}
			smooth_triangle {
				<0.668722, 0.244003, 0.694540>, <-0.398841, 1.472747, 5.802094>,
				<0.654385, 0.236063, 0.710747>, <-0.272058, 1.421218, 5.822317>,
				<0.655129, 0.259723, 0.701755>, <-0.310976, 1.564845, 5.783426>
			}
			smooth_triangle {
				<0.654385, 0.236063, 0.710747>, <-0.272058, 1.421218, 5.822317>,
				<0.641557, 0.251343, 0.717177>, <-0.149721, 1.018196, 3.865129>,
				<0.655129, 0.259723, 0.701755>, <-0.310976, 1.564845, 5.783426>
			}
			smooth_triangle {
				<0.643908, 0.271893, 0.707502>, <-0.194216, 1.366603, 4.805322>,
				<0.655129, 0.259723, 0.701755>, <-0.310976, 1.564845, 5.783426>,
				<0.641557, 0.251343, 0.717177>, <-0.149721, 1.018196, 3.865129>
			}
			smooth_triangle {
				<0.668722, 0.244003, 0.694540>, <-0.398841, 1.472747, 5.802094>,
				<0.669075, 0.271673, 0.683853>, <-0.515584, 1.909493, 6.713933>,
				<0.683861, 0.250283, 0.677345>, <-0.531854, 1.510914, 5.781584>
			}
			smooth_triangle {
				<0.675003, 0.293523, 0.668827>, <-0.525100, 1.765230, 5.709823>,
				<0.686619, 0.273953, 0.665293>, <-0.591466, 1.651566, 5.737161>,
				<0.669075, 0.271673, 0.683853>, <-0.515584, 1.909493, 6.713933>
			}
			smooth_triangle {
				<0.669075, 0.271673, 0.683853>, <-0.515584, 1.909493, 6.713933>,
				<0.686619, 0.273953, 0.665293>, <-0.591466, 1.651566, 5.737161>,
				<0.683861, 0.250283, 0.677345>, <-0.531854, 1.510914, 5.781584>
			}
			smooth_triangle {
				<0.699060, 0.314143, 0.633837>, <-0.901835, 2.208683, 6.580307>,
				<0.713598, 0.302013, 0.623439>, <-0.419066, 0.913738, 2.826399>,
				<0.704217, 0.293823, 0.637851>, <-0.649868, 1.477457, 4.731911>
			}
			smooth_triangle {
				<0.713598, 0.302013, 0.623439>, <-0.419066, 0.913738, 2.826399>,
				<0.716206, 0.279233, 0.631028>, <-0.407764, 0.848632, 2.848265>,
				<0.704217, 0.293823, 0.637851>, <-0.649868, 1.477457, 4.731911>
			}
			smooth_triangle {
				<0.716206, 0.279233, 0.631028>, <-0.407764, 0.848632, 2.848265>,
				<0.701650, 0.276073, 0.648529>, <-0.725563, 1.663793, 5.718274>,
				<0.704217, 0.293823, 0.637851>, <-0.649868, 1.477457, 4.731911>
			}
			smooth_triangle {
				<0.699060, 0.314143, 0.633837>, <-0.901835, 2.208683, 6.580307>,
				<0.704217, 0.293823, 0.637851>, <-0.649868, 1.477457, 4.731911>,
				<0.689892, 0.297163, 0.651816>, <-0.771859, 2.088376, 6.635825>
			}
			smooth_triangle {
				<0.704217, 0.293823, 0.637851>, <-0.649868, 1.477457, 4.731911>,
				<0.701650, 0.276073, 0.648529>, <-0.725563, 1.663793, 5.718274>,
				<0.689892, 0.297163, 0.651816>, <-0.771859, 2.088376, 6.635825>
			}
			smooth_triangle {
				<0.699060, 0.314143, 0.633837>, <-0.901835, 2.208683, 6.580307>,
				<0.689892, 0.297163, 0.651816>, <-0.771859, 2.088376, 6.635825>,
				<0.684076, 0.318463, 0.647872>, <-0.653318, 1.917954, 5.647138>
			}
			smooth_triangle {
				<0.689892, 0.297163, 0.651816>, <-0.771859, 2.088376, 6.635825>,
				<0.677374, 0.309123, 0.659331>, <-0.478637, 1.551533, 4.728730>,
				<0.684076, 0.318463, 0.647872>, <-0.653318, 1.917954, 5.647138>
			}
			smooth_triangle {
				<0.677374, 0.309123, 0.659331>, <-0.478637, 1.551533, 4.728730>,
				<0.689892, 0.297163, 0.651816>, <-0.771859, 2.088376, 6.635825>,
				<0.675003, 0.293523, 0.668827>, <-0.525100, 1.765230, 5.709823>
			}
			smooth_triangle {
				<0.701650, 0.276073, 0.648529>, <-0.725563, 1.663793, 5.718274>,
				<0.686619, 0.273953, 0.665293>, <-0.591466, 1.651566, 5.737161>,
				<0.689892, 0.297163, 0.651816>, <-0.771859, 2.088376, 6.635825>
			}
			smooth_triangle {
				<0.689892, 0.297163, 0.651816>, <-0.771859, 2.088376, 6.635825>,
				<0.686619, 0.273953, 0.665293>, <-0.591466, 1.651566, 5.737161>,
				<0.675003, 0.293523, 0.668827>, <-0.525100, 1.765230, 5.709823>
			}
			smooth_triangle {
				<0.684076, 0.318463, 0.647872>, <-0.653318, 1.917954, 5.647138>,
				<0.677374, 0.309123, 0.659331>, <-0.478637, 1.551533, 4.728730>,
				<0.671651, 0.323983, 0.658049>, <-0.548649, 1.953049, 5.646343>
			}
			smooth_triangle {
				<0.675003, 0.293523, 0.668827>, <-0.525100, 1.765230, 5.709823>,
				<0.665757, 0.312103, 0.669679>, <-0.475467, 1.882888, 5.676613>,
				<0.677374, 0.309123, 0.659331>, <-0.478637, 1.551533, 4.728730>
			}
			smooth_triangle {
				<0.677374, 0.309123, 0.659331>, <-0.478637, 1.551533, 4.728730>,
				<0.665757, 0.312103, 0.669679>, <-0.475467, 1.882888, 5.676613>,
				<0.671651, 0.323983, 0.658049>, <-0.548649, 1.953049, 5.646343>
			}
			smooth_triangle {
				<0.686619, 0.273953, 0.665293>, <-0.591466, 1.651566, 5.737161>,
				<0.701650, 0.276073, 0.648529>, <-0.725563, 1.663793, 5.718274>,
				<0.698982, 0.254083, 0.660284>, <-0.667748, 1.532869, 5.761736>
			}
			smooth_triangle {
				<0.716206, 0.279233, 0.631028>, <-0.407764, 0.848632, 2.848265>,
				<0.712822, 0.257413, 0.643998>, <-0.378463, 0.785909, 2.870188>,
				<0.701650, 0.276073, 0.648529>, <-0.725563, 1.663793, 5.718274>
			}
			smooth_triangle {
				<0.701650, 0.276073, 0.648529>, <-0.725563, 1.663793, 5.718274>,
				<0.712822, 0.257413, 0.643998>, <-0.378463, 0.785909, 2.870188>,
				<0.698982, 0.254083, 0.660284>, <-0.667748, 1.532869, 5.761736>
			}
			smooth_triangle {
				<0.671651, 0.323983, 0.658049>, <-0.548649, 1.953049, 5.646343>,
				<0.677003, 0.334103, 0.647423>, <-0.619582, 2.013581, 5.617702>,
				<0.684076, 0.318463, 0.647872>, <-0.653318, 1.917954, 5.647138>
			}
			smooth_triangle {
				<0.713598, 0.302013, 0.623439>, <-0.419066, 0.913738, 2.826399>,
				<0.699060, 0.314143, 0.633837>, <-0.901835, 2.208683, 6.580307>,
				<0.711859, 0.321923, 0.615408>, <-0.427537, 0.970906, 2.806051>
			}
			smooth_triangle {
				<0.684076, 0.318463, 0.647872>, <-0.653318, 1.917954, 5.647138>,
				<0.688680, 0.331753, 0.636215>, <-0.716717, 1.997815, 5.611723>,
				<0.699060, 0.314143, 0.633837>, <-0.901835, 2.208683, 6.580307>
			}
			smooth_triangle {
				<0.688680, 0.331753, 0.636215>, <-0.716717, 1.997815, 5.611723>,
				<0.691031, 0.344563, 0.626788>, <-0.760159, 2.076335, 5.577502>,
				<0.699894, 0.332923, 0.623241>, <-0.818345, 2.002191, 5.596213>
			}
			smooth_triangle {
				<0.691031, 0.344563, 0.626788>, <-0.760159, 2.076335, 5.577502>,
				<0.699350, 0.345213, 0.617132>, <-0.700818, 1.733767, 4.636948>,
				<0.699894, 0.332923, 0.623241>, <-0.818345, 2.002191, 5.596213>
			}
			smooth_triangle {
				<0.711859, 0.321923, 0.615408>, <-0.427537, 0.970906, 2.806051>,
				<0.699894, 0.332923, 0.623241>, <-0.818345, 2.002191, 5.596213>,
				<0.708789, 0.339433, 0.609525>, <-0.438448, 1.021112, 2.786504>
			}
			smooth_triangle {
				<0.699350, 0.345213, 0.617132>, <-0.700818, 1.733767, 4.636948>,
				<0.708789, 0.339433, 0.609525>, <-0.438448, 1.021112, 2.786504>,
				<0.699894, 0.332923, 0.623241>, <-0.818345, 2.002191, 5.596213>
			}
			smooth_triangle {
				<0.688680, 0.331753, 0.636215>, <-0.716717, 1.997815, 5.611723>,
				<0.699894, 0.332923, 0.623241>, <-0.818345, 2.002191, 5.596213>,
				<0.699060, 0.314143, 0.633837>, <-0.901835, 2.208683, 6.580307>
			}
			smooth_triangle {
				<0.699894, 0.332923, 0.623241>, <-0.818345, 2.002191, 5.596213>,
				<0.711859, 0.321923, 0.615408>, <-0.427537, 0.970906, 2.806051>,
				<0.699060, 0.314143, 0.633837>, <-0.901835, 2.208683, 6.580307>
			}
			smooth_triangle {
				<0.708789, 0.339433, 0.609525>, <-0.438448, 1.021112, 2.786504>,
				<0.699350, 0.345213, 0.617132>, <-0.700818, 1.733767, 4.636948>,
				<0.703143, 0.354983, 0.607200>, <-0.576228, 1.431444, 3.690253>
			}
			smooth_triangle {
				<0.691031, 0.344563, 0.626788>, <-0.760159, 2.076335, 5.577502>,
				<0.693615, 0.353933, 0.618667>, <-0.671976, 1.782387, 4.622733>,
				<0.699350, 0.345213, 0.617132>, <-0.700818, 1.733767, 4.636948>
			}
			smooth_triangle {
				<0.699350, 0.345213, 0.617132>, <-0.700818, 1.733767, 4.636948>,
				<0.693615, 0.353933, 0.618667>, <-0.671976, 1.782387, 4.622733>,
				<0.703143, 0.354983, 0.607200>, <-0.576228, 1.431444, 3.690253>
			}
			smooth_triangle {
				<0.693615, 0.353933, 0.618667>, <-0.671976, 1.782387, 4.622733>,
				<0.691031, 0.344563, 0.626788>, <-0.760159, 2.076335, 5.577502>,
				<0.683832, 0.357343, 0.627529>, <-0.725205, 2.159666, 5.550384>
			}
			smooth_triangle {
				<0.684076, 0.318463, 0.647872>, <-0.653318, 1.917954, 5.647138>,
				<0.677003, 0.334103, 0.647423>, <-0.619582, 2.013581, 5.617702>,
				<0.688680, 0.331753, 0.636215>, <-0.716717, 1.997815, 5.611723>
			}
			smooth_triangle {
				<0.677003, 0.334103, 0.647423>, <-0.619582, 2.013581, 5.617702>,
				<0.680370, 0.345853, 0.637653>, <-0.672095, 2.085838, 5.585196>,
				<0.688680, 0.331753, 0.636215>, <-0.716717, 1.997815, 5.611723>
			}
			smooth_triangle {
				<0.683832, 0.357343, 0.627529>, <-0.725205, 2.159666, 5.550384>,
				<0.691031, 0.344563, 0.626788>, <-0.760159, 2.076335, 5.577502>,
				<0.680370, 0.345853, 0.637653>, <-0.672095, 2.085838, 5.585196>
			}
			smooth_triangle {
				<0.691031, 0.344563, 0.626788>, <-0.760159, 2.076335, 5.577502>,
				<0.688680, 0.331753, 0.636215>, <-0.716717, 1.997815, 5.611723>,
				<0.680370, 0.345853, 0.637653>, <-0.672095, 2.085838, 5.585196>
			}
			smooth_triangle {
				<0.641557, 0.251343, 0.717177>, <-0.149721, 1.018196, 3.865129>,
				<0.633612, 0.271533, 0.716887>, <-0.106179, 1.119044, 3.838549>,
				<0.643908, 0.271893, 0.707502>, <-0.194216, 1.366603, 4.805322>
			}
			smooth_triangle {
				<0.633612, 0.271533, 0.716887>, <-0.106179, 1.119044, 3.838549>,
				<0.636438, 0.293813, 0.705507>, <-0.233929, 2.070273, 6.682068>,
				<0.643908, 0.271893, 0.707502>, <-0.194216, 1.366603, 4.805322>
			}
			smooth_triangle {
				<0.683832, 0.357343, 0.627529>, <-0.725205, 2.159666, 5.550384>,
				<0.680370, 0.345853, 0.637653>, <-0.672095, 2.085838, 5.585196>,
				<0.671675, 0.359733, 0.639192>, <-0.624229, 2.173295, 5.557270>
			}
			smooth_triangle {
				<0.643908, 0.271893, 0.707502>, <-0.194216, 1.366603, 4.805322>,
				<0.636438, 0.293813, 0.705507>, <-0.233929, 2.070273, 6.682068>,
				<0.652219, 0.282613, 0.695595>, <-0.320258, 1.701876, 5.744162>
			}
			smooth_triangle {
				<0.636438, 0.293813, 0.705507>, <-0.233929, 2.070273, 6.682068>,
				<0.647501, 0.301483, 0.692073>, <-0.255430, 1.516279, 4.757315>,
				<0.652219, 0.282613, 0.695595>, <-0.320258, 1.701876, 5.744162>
			}
			smooth_triangle {
				<0.652219, 0.282613, 0.695595>, <-0.320258, 1.701876, 5.744162>,
				<0.647501, 0.301483, 0.692073>, <-0.255430, 1.516279, 4.757315>,
				<0.660338, 0.296403, 0.682059>, <-0.409875, 1.785196, 5.713111>
			}
			smooth_triangle {
				<0.647501, 0.301483, 0.692073>, <-0.255430, 1.516279, 4.757315>,
				<0.651529, 0.316363, 0.681565>, <-0.368295, 1.911139, 5.675076>,
				<0.660338, 0.296403, 0.682059>, <-0.409875, 1.785196, 5.713111>
			}
			smooth_triangle {
				<0.660338, 0.296403, 0.682059>, <-0.409875, 1.785196, 5.713111>,
				<0.651529, 0.316363, 0.681565>, <-0.368295, 1.911139, 5.675076>,
				<0.665757, 0.312103, 0.669679>, <-0.475467, 1.882888, 5.676613>
			}
			smooth_triangle {
				<0.651529, 0.316363, 0.681565>, <-0.368295, 1.911139, 5.675076>,
				<0.657803, 0.332693, 0.667620>, <-0.517756, 2.340444, 6.576281>,
				<0.665757, 0.312103, 0.669679>, <-0.475467, 1.882888, 5.676613>
			}
			smooth_triangle {
				<0.665757, 0.312103, 0.669679>, <-0.475467, 1.882888, 5.676613>,
				<0.657803, 0.332693, 0.667620>, <-0.517756, 2.340444, 6.576281>,
				<0.671651, 0.323983, 0.658049>, <-0.548649, 1.953049, 5.646343>
			}
			smooth_triangle {
				<0.659422, 0.359923, 0.651706>, <-0.516349, 2.175230, 5.567576>,
				<0.669406, 0.347223, 0.648420>, <-0.578907, 2.096308, 5.591736>,
				<0.660204, 0.346443, 0.658191>, <-0.408886, 1.742697, 4.668347>
			}
			smooth_triangle {
				<0.660204, 0.346443, 0.658191>, <-0.408886, 1.742697, 4.668347>,
				<0.669406, 0.347223, 0.648420>, <-0.578907, 2.096308, 5.591736>,
				<0.667274, 0.336933, 0.655991>, <-0.447653, 1.691627, 4.683625>
			}
			smooth_triangle {
				<0.669406, 0.347223, 0.648420>, <-0.578907, 2.096308, 5.591736>,
				<0.677003, 0.334103, 0.647423>, <-0.619582, 2.013581, 5.617702>,
				<0.667274, 0.336933, 0.655991>, <-0.447653, 1.691627, 4.683625>
			}
			smooth_triangle {
				<0.677003, 0.334103, 0.647423>, <-0.619582, 2.013581, 5.617702>,
				<0.671651, 0.323983, 0.658049>, <-0.548649, 1.953049, 5.646343>,
				<0.667274, 0.336933, 0.655991>, <-0.447653, 1.691627, 4.683625>
			}
			smooth_triangle {
				<0.660204, 0.346443, 0.658191>, <-0.408886, 1.742697, 4.668347>,
				<0.667274, 0.336933, 0.655991>, <-0.447653, 1.691627, 4.683625>,
				<0.657803, 0.332693, 0.667620>, <-0.517756, 2.340444, 6.576281>
			}
			smooth_triangle {
				<0.667274, 0.336933, 0.655991>, <-0.447653, 1.691627, 4.683625>,
				<0.671651, 0.323983, 0.658049>, <-0.548649, 1.953049, 5.646343>,
				<0.657803, 0.332693, 0.667620>, <-0.517756, 2.340444, 6.576281>
			}
			smooth_triangle {
				<0.677003, 0.334103, 0.647423>, <-0.619582, 2.013581, 5.617702>,
				<0.669406, 0.347223, 0.648420>, <-0.578907, 2.096308, 5.591736>,
				<0.680370, 0.345853, 0.637653>, <-0.672095, 2.085838, 5.585196>
			}
			smooth_triangle {
				<0.659422, 0.359923, 0.651706>, <-0.516349, 2.175230, 5.567576>,
				<0.671675, 0.359733, 0.639192>, <-0.624229, 2.173295, 5.557270>,
				<0.669406, 0.347223, 0.648420>, <-0.578907, 2.096308, 5.591736>
			}
			smooth_triangle {
				<0.669406, 0.347223, 0.648420>, <-0.578907, 2.096308, 5.591736>,
				<0.671675, 0.359733, 0.639192>, <-0.624229, 2.173295, 5.557270>,
				<0.680370, 0.345853, 0.637653>, <-0.672095, 2.085838, 5.585196>
			}
			smooth_triangle {
				<0.659422, 0.359923, 0.651706>, <-0.516349, 2.175230, 5.567576>,
				<0.661021, 0.375213, 0.641383>, <-0.565851, 2.265943, 5.526350>,
				<0.671675, 0.359733, 0.639192>, <-0.624229, 2.173295, 5.557270>
			}
			smooth_triangle {
				<0.672776, 0.413173, 0.604784>, <-0.762852, 2.505601, 5.397275>,
				<0.684101, 0.394103, 0.604824>, <-0.815257, 2.381995, 5.445821>,
				<0.670710, 0.399153, 0.616387>, <-0.587286, 2.012254, 4.538948>
			}
			smooth_triangle {
				<0.664501, 0.389853, 0.628946>, <-0.628429, 2.354585, 5.482225>,
				<0.679847, 0.383813, 0.616121>, <-0.750715, 2.312846, 5.484801>,
				<0.675335, 0.372303, 0.628027>, <-0.685822, 2.248106, 5.520099>
			}
			smooth_triangle {
				<0.679847, 0.383813, 0.616121>, <-0.750715, 2.312846, 5.484801>,
				<0.693294, 0.379633, 0.603598>, <-0.865220, 2.288540, 5.478145>,
				<0.690406, 0.367283, 0.614454>, <-0.941454, 2.588335, 6.434974>
			}
			smooth_triangle {
				<0.693294, 0.379633, 0.603598>, <-0.865220, 2.288540, 5.478145>,
				<0.702986, 0.368263, 0.599421>, <-0.607125, 1.489808, 3.662005>,
				<0.690406, 0.367283, 0.614454>, <-0.941454, 2.588335, 6.434974>
			}
			smooth_triangle {
				<0.702986, 0.368263, 0.599421>, <-0.607125, 1.489808, 3.662005>,
				<0.703143, 0.354983, 0.607200>, <-0.576228, 1.431444, 3.690253>,
				<0.690406, 0.367283, 0.614454>, <-0.941454, 2.588335, 6.434974>
			}
			smooth_triangle {
				<0.703143, 0.354983, 0.607200>, <-0.576228, 1.431444, 3.690253>,
				<0.693615, 0.353933, 0.618667>, <-0.671976, 1.782387, 4.622733>,
				<0.690406, 0.367283, 0.614454>, <-0.941454, 2.588335, 6.434974>
			}
			smooth_triangle {
				<0.679847, 0.383813, 0.616121>, <-0.750715, 2.312846, 5.484801>,
				<0.690406, 0.367283, 0.614454>, <-0.941454, 2.588335, 6.434974>,
				<0.675335, 0.372303, 0.628027>, <-0.685822, 2.248106, 5.520099>
			}
			smooth_triangle {
				<0.693615, 0.353933, 0.618667>, <-0.671976, 1.782387, 4.622733>,
				<0.683832, 0.357343, 0.627529>, <-0.725205, 2.159666, 5.550384>,
				<0.690406, 0.367283, 0.614454>, <-0.941454, 2.588335, 6.434974>
			}
			smooth_triangle {
				<0.690406, 0.367283, 0.614454>, <-0.941454, 2.588335, 6.434974>,
				<0.683832, 0.357343, 0.627529>, <-0.725205, 2.159666, 5.550384>,
				<0.675335, 0.372303, 0.628027>, <-0.685822, 2.248106, 5.520099>
			}
			smooth_triangle {
				<0.664501, 0.389853, 0.628946>, <-0.628429, 2.354585, 5.482225>,
				<0.675335, 0.372303, 0.628027>, <-0.685822, 2.248106, 5.520099>,
				<0.661021, 0.375213, 0.641383>, <-0.565851, 2.265943, 5.526350>
			}
			smooth_triangle {
				<0.683832, 0.357343, 0.627529>, <-0.725205, 2.159666, 5.550384>,
				<0.671675, 0.359733, 0.639192>, <-0.624229, 2.173295, 5.557270>,
				<0.675335, 0.372303, 0.628027>, <-0.685822, 2.248106, 5.520099>
			}
			smooth_triangle {
				<0.675335, 0.372303, 0.628027>, <-0.685822, 2.248106, 5.520099>,
				<0.671675, 0.359733, 0.639192>, <-0.624229, 2.173295, 5.557270>,
				<0.661021, 0.375213, 0.641383>, <-0.565851, 2.265943, 5.526350>
			}
			smooth_triangle {
				<0.693294, 0.379633, 0.603598>, <-0.865220, 2.288540, 5.478145>,
				<0.679847, 0.383813, 0.616121>, <-0.750715, 2.312846, 5.484801>,
				<0.684101, 0.394103, 0.604824>, <-0.815257, 2.381995, 5.445821>
			}
			smooth_triangle {
				<0.664501, 0.389853, 0.628946>, <-0.628429, 2.354585, 5.482225>,
				<0.670710, 0.399153, 0.616387>, <-0.587286, 2.012254, 4.538948>,
				<0.679847, 0.383813, 0.616121>, <-0.750715, 2.312846, 5.484801>
			}
			smooth_triangle {
				<0.679847, 0.383813, 0.616121>, <-0.750715, 2.312846, 5.484801>,
				<0.670710, 0.399153, 0.616387>, <-0.587286, 2.012254, 4.538948>,
				<0.684101, 0.394103, 0.604824>, <-0.815257, 2.381995, 5.445821>
			}
			smooth_triangle {
				<0.736524, 0.400083, 0.535328>, <-0.638848, 1.289437, 2.630195>,
				<0.734086, 0.369463, 0.560114>, <-0.570948, 1.155321, 2.708855>,
				<0.707921, 0.406613, 0.567996>, <-1.096484, 2.469675, 5.354578>
			}
			smooth_triangle {
				<0.672776, 0.413173, 0.604784>, <-0.762852, 2.505601, 5.397275>,
				<0.692303, 0.400703, 0.590983>, <-0.922650, 2.425850, 5.408829>,
				<0.684101, 0.394103, 0.604824>, <-0.815257, 2.381995, 5.445821>
			}
			smooth_triangle {
				<0.734086, 0.369463, 0.560114>, <-0.570948, 1.155321, 2.708855>,
				<0.728128, 0.353103, 0.578154>, <-0.363556, 0.739617, 1.822281>,
				<0.709543, 0.375593, 0.587026>, <-1.529142, 3.414269, 8.184381>
			}
			smooth_triangle {
				<0.728128, 0.353103, 0.578154>, <-0.363556, 0.739617, 1.822281>,
				<0.718082, 0.353343, 0.590435>, <-0.349514, 0.733607, 1.827458>,
				<0.709543, 0.375593, 0.587026>, <-1.529142, 3.414269, 8.184381>
			}
			smooth_triangle {
				<0.718082, 0.353343, 0.590435>, <-0.349514, 0.733607, 1.827458>,
				<0.709061, 0.360463, 0.596999>, <-0.334040, 0.736493, 1.829184>,
				<0.709543, 0.375593, 0.587026>, <-1.529142, 3.414269, 8.184381>
			}
			smooth_triangle {
				<0.709061, 0.360463, 0.596999>, <-0.334040, 0.736493, 1.829184>,
				<0.702986, 0.368263, 0.599421>, <-0.607125, 1.489808, 3.662005>,
				<0.709543, 0.375593, 0.587026>, <-1.529142, 3.414269, 8.184381>
			}
			smooth_triangle {
				<0.702986, 0.368263, 0.599421>, <-0.607125, 1.489808, 3.662005>,
				<0.693294, 0.379633, 0.603598>, <-0.865220, 2.288540, 5.478145>,
				<0.709543, 0.375593, 0.587026>, <-1.529142, 3.414269, 8.184381>
			}
			smooth_triangle {
				<0.734086, 0.369463, 0.560114>, <-0.570948, 1.155321, 2.708855>,
				<0.709543, 0.375593, 0.587026>, <-1.529142, 3.414269, 8.184381>,
				<0.707921, 0.406613, 0.567996>, <-1.096484, 2.469675, 5.354578>
			}
			smooth_triangle {
				<0.707921, 0.406613, 0.567996>, <-1.096484, 2.469675, 5.354578>,
				<0.709543, 0.375593, 0.587026>, <-1.529142, 3.414269, 8.184381>,
				<0.692303, 0.400703, 0.590983>, <-0.922650, 2.425850, 5.408829>
			}
			smooth_triangle {
				<0.692303, 0.400703, 0.590983>, <-0.922650, 2.425850, 5.408829>,
				<0.709543, 0.375593, 0.587026>, <-1.529142, 3.414269, 8.184381>,
				<0.694909, 0.387573, 0.596656>, <-0.607768, 1.560123, 3.632412>
			}
			smooth_triangle {
				<0.709543, 0.375593, 0.587026>, <-1.529142, 3.414269, 8.184381>,
				<0.693294, 0.379633, 0.603598>, <-0.865220, 2.288540, 5.478145>,
				<0.694909, 0.387573, 0.596656>, <-0.607768, 1.560123, 3.632412>
			}
			smooth_triangle {
				<0.692303, 0.400703, 0.590983>, <-0.922650, 2.425850, 5.408829>,
				<0.694909, 0.387573, 0.596656>, <-0.607768, 1.560123, 3.632412>,
				<0.684101, 0.394103, 0.604824>, <-0.815257, 2.381995, 5.445821>
			}
			smooth_triangle {
				<0.694909, 0.387573, 0.596656>, <-0.607768, 1.560123, 3.632412>,
				<0.693294, 0.379633, 0.603598>, <-0.865220, 2.288540, 5.478145>,
				<0.684101, 0.394103, 0.604824>, <-0.815257, 2.381995, 5.445821>
			}
			smooth_triangle {
				<0.672776, 0.413173, 0.604784>, <-0.762852, 2.505601, 5.397275>,
				<0.683205, 0.426133, 0.583750>, <-0.753707, 2.162704, 4.442815>,
				<0.692303, 0.400703, 0.590983>, <-0.922650, 2.425850, 5.408829>
			}
			smooth_triangle {
				<0.771549, 0.424243, 0.462428>, <-0.237797, 0.457059, 0.857059>,
				<0.736524, 0.400083, 0.535328>, <-0.638848, 1.289437, 2.630195>,
				<0.686742, 0.464953, 0.548916>, <-0.878926, 2.298448, 4.345247>
			}
			smooth_triangle {
				<0.736524, 0.400083, 0.535328>, <-0.638848, 1.289437, 2.630195>,
				<0.707921, 0.406613, 0.567996>, <-1.096484, 2.469675, 5.354578>,
				<0.686742, 0.464953, 0.548916>, <-0.878926, 2.298448, 4.345247>
			}
			smooth_triangle {
				<0.686742, 0.464953, 0.548916>, <-0.878926, 2.298448, 4.345247>,
				<0.707921, 0.406613, 0.567996>, <-1.096484, 2.469675, 5.354578>,
				<0.683205, 0.426133, 0.583750>, <-0.753707, 2.162704, 4.442815>
			}
			smooth_triangle {
				<0.683205, 0.426133, 0.583750>, <-0.753707, 2.162704, 4.442815>,
				<0.707921, 0.406613, 0.567996>, <-1.096484, 2.469675, 5.354578>,
				<0.692303, 0.400703, 0.590983>, <-0.922650, 2.425850, 5.408829>
			}
			smooth_triangle {
				<0.668722, 0.244003, 0.694540>, <-0.398841, 1.472747, 5.802094>,
				<0.681760, 0.226083, 0.687894>, <-0.482412, 1.364893, 5.822146>,
				<0.666903, 0.219293, 0.704460>, <-0.348470, 1.324247, 5.841034>
			}
			smooth_triangle {
				<0.665763, 0.196243, 0.712296>, <-0.316980, 1.187383, 5.872296>,
				<0.679434, 0.202873, 0.697365>, <-0.435883, 1.224542, 5.856992>,
				<0.676872, 0.180753, 0.705886>, <-0.393391, 1.089574, 5.886651>
			}
			smooth_triangle {
				<0.696335, 0.146723, 0.694762>, <-0.165315, 0.313169, 1.968354>,
				<0.687128, 0.163993, 0.700047>, <-0.460694, 0.990159, 5.899301>,
				<0.701421, 0.167723, 0.684830>, <-0.271223, 0.515526, 2.942735>
			}
			smooth_triangle {
				<0.687128, 0.163993, 0.700047>, <-0.460694, 0.990159, 5.899301>,
				<0.676872, 0.180753, 0.705886>, <-0.393391, 1.089574, 5.886651>,
				<0.690515, 0.185913, 0.691187>, <-0.510095, 1.121125, 5.871688>
			}
			smooth_triangle {
				<0.676872, 0.180753, 0.705886>, <-0.393391, 1.089574, 5.886651>,
				<0.679434, 0.202873, 0.697365>, <-0.435883, 1.224542, 5.856992>,
				<0.690515, 0.185913, 0.691187>, <-0.510095, 1.121125, 5.871688>
			}
			smooth_triangle {
				<0.679434, 0.202873, 0.697365>, <-0.435883, 1.224542, 5.856992>,
				<0.693769, 0.208233, 0.681499>, <-0.563066, 1.257303, 5.839134>,
				<0.690515, 0.185913, 0.691187>, <-0.510095, 1.121125, 5.871688>
			}
			smooth_triangle {
				<0.687128, 0.163993, 0.700047>, <-0.460694, 0.990159, 5.899301>,
				<0.690515, 0.185913, 0.691187>, <-0.510095, 1.121125, 5.871688>,
				<0.701421, 0.167723, 0.684830>, <-0.271223, 0.515526, 2.942735>
			}
			smooth_triangle {
				<0.693769, 0.208233, 0.681499>, <-0.563066, 1.257303, 5.839134>,
				<0.703460, 0.191233, 0.676526>, <-0.296715, 0.583678, 2.927468>,
				<0.690515, 0.185913, 0.691187>, <-0.510095, 1.121125, 5.871688>
			}
			smooth_triangle {
				<0.690515, 0.185913, 0.691187>, <-0.510095, 1.121125, 5.871688>,
				<0.703460, 0.191233, 0.676526>, <-0.296715, 0.583678, 2.927468>,
				<0.701421, 0.167723, 0.684830>, <-0.271223, 0.515526, 2.942735>
			}
			smooth_triangle {
				<0.665763, 0.196243, 0.712296>, <-0.316980, 1.187383, 5.872296>,
				<0.676872, 0.180753, 0.705886>, <-0.393391, 1.089574, 5.886651>,
				<0.664545, 0.176103, 0.718670>, <-0.161839, 0.545282, 2.945472>
			}
			smooth_triangle {
				<0.696335, 0.146723, 0.694762>, <-0.165315, 0.313169, 1.968354>,
				<0.683743, 0.143443, 0.707835>, <-0.145189, 0.309724, 1.970509>,
				<0.687128, 0.163993, 0.700047>, <-0.460694, 0.990159, 5.899301>
			}
			smooth_triangle {
				<0.683743, 0.143443, 0.707835>, <-0.145189, 0.309724, 1.970509>,
				<0.672979, 0.158763, 0.714844>, <-0.191956, 0.497281, 2.952174>,
				<0.687128, 0.163993, 0.700047>, <-0.460694, 0.990159, 5.899301>
			}
			smooth_triangle {
				<0.664545, 0.176103, 0.718670>, <-0.161839, 0.545282, 2.945472>,
				<0.676872, 0.180753, 0.705886>, <-0.393391, 1.089574, 5.886651>,
				<0.672979, 0.158763, 0.714844>, <-0.191956, 0.497281, 2.952174>
			}
			smooth_triangle {
				<0.676872, 0.180753, 0.705886>, <-0.393391, 1.089574, 5.886651>,
				<0.687128, 0.163993, 0.700047>, <-0.460694, 0.990159, 5.899301>,
				<0.672979, 0.158763, 0.714844>, <-0.191956, 0.497281, 2.952174>
			}
			smooth_triangle {
				<0.693769, 0.208233, 0.681499>, <-0.563066, 1.257303, 5.839134>,
				<0.679434, 0.202873, 0.697365>, <-0.435883, 1.224542, 5.856992>,
				<0.681760, 0.226083, 0.687894>, <-0.482412, 1.364893, 5.822146>
			}
			smooth_triangle {
				<0.665763, 0.196243, 0.712296>, <-0.316980, 1.187383, 5.872296>,
				<0.666903, 0.219293, 0.704460>, <-0.348470, 1.324247, 5.841034>,
				<0.679434, 0.202873, 0.697365>, <-0.435883, 1.224542, 5.856992>
			}
			smooth_triangle {
				<0.679434, 0.202873, 0.697365>, <-0.435883, 1.224542, 5.856992>,
				<0.666903, 0.219293, 0.704460>, <-0.348470, 1.324247, 5.841034>,
				<0.681760, 0.226083, 0.687894>, <-0.482412, 1.364893, 5.822146>
			}
			smooth_triangle {
				<0.668722, 0.244003, 0.694540>, <-0.398841, 1.472747, 5.802094>,
				<0.666903, 0.219293, 0.704460>, <-0.348470, 1.324247, 5.841034>,
				<0.654385, 0.236063, 0.710747>, <-0.272058, 1.421218, 5.822317>
			}
			smooth_triangle {
				<0.650312, 0.209673, 0.722663>, <-0.171516, 0.858490, 3.902811>,
				<0.666903, 0.219293, 0.704460>, <-0.348470, 1.324247, 5.841034>,
				<0.665763, 0.196243, 0.712296>, <-0.316980, 1.187383, 5.872296>
			}
			smooth_triangle {
				<0.666903, 0.219293, 0.704460>, <-0.348470, 1.324247, 5.841034>,
				<0.650312, 0.209673, 0.722663>, <-0.171516, 0.858490, 3.902811>,
				<0.654385, 0.236063, 0.710747>, <-0.272058, 1.421218, 5.822317>
			}
			smooth_triangle {
				<0.650312, 0.209673, 0.722663>, <-0.171516, 0.858490, 3.902811>,
				<0.642685, 0.231633, 0.722784>, <-0.074171, 0.466161, 1.943404>,
				<0.654385, 0.236063, 0.710747>, <-0.272058, 1.421218, 5.822317>
			}
			smooth_triangle {
				<0.664545, 0.176103, 0.718670>, <-0.161839, 0.545282, 2.945472>,
				<0.655584, 0.188163, 0.723827>, <-0.088581, 0.388696, 1.959805>,
				<0.665763, 0.196243, 0.712296>, <-0.316980, 1.187383, 5.872296>
			}
			smooth_triangle {
				<0.665763, 0.196243, 0.712296>, <-0.316980, 1.187383, 5.872296>,
				<0.655584, 0.188163, 0.723827>, <-0.088581, 0.388696, 1.959805>,
				<0.650312, 0.209673, 0.722663>, <-0.171516, 0.858490, 3.902811>
			}
			smooth_triangle {
				<0.698982, 0.254083, 0.660284>, <-0.667748, 1.532869, 5.761736>,
				<0.712822, 0.257413, 0.643998>, <-0.378463, 0.785909, 2.870188>,
				<0.711047, 0.234953, 0.654469>, <-0.351322, 0.718042, 2.891338>
			}
			smooth_triangle {
				<0.703460, 0.191233, 0.676526>, <-0.296715, 0.583678, 2.927468>,
				<0.693769, 0.208233, 0.681499>, <-0.563066, 1.257303, 5.839134>,
				<0.709669, 0.211513, 0.663888>, <-0.326822, 0.649688, 2.910355>
			}
			smooth_triangle {
				<0.668722, 0.244003, 0.694540>, <-0.398841, 1.472747, 5.802094>,
				<0.683861, 0.250283, 0.677345>, <-0.531854, 1.510914, 5.781584>,
				<0.681760, 0.226083, 0.687894>, <-0.482412, 1.364893, 5.822146>
			}
			smooth_triangle {
				<0.681760, 0.226083, 0.687894>, <-0.482412, 1.364893, 5.822146>,
				<0.683861, 0.250283, 0.677345>, <-0.531854, 1.510914, 5.781584>,
				<0.696718, 0.231003, 0.671074>, <-0.616517, 1.393773, 5.802589>
			}
			smooth_triangle {
				<0.683861, 0.250283, 0.677345>, <-0.531854, 1.510914, 5.781584>,
				<0.698982, 0.254083, 0.660284>, <-0.667748, 1.532869, 5.761736>,
				<0.696718, 0.231003, 0.671074>, <-0.616517, 1.393773, 5.802589>
			}
			smooth_triangle {
				<0.698982, 0.254083, 0.660284>, <-0.667748, 1.532869, 5.761736>,
				<0.711047, 0.234953, 0.654469>, <-0.351322, 0.718042, 2.891338>,
				<0.696718, 0.231003, 0.671074>, <-0.616517, 1.393773, 5.802589>
			}
			smooth_triangle {
				<0.681760, 0.226083, 0.687894>, <-0.482412, 1.364893, 5.822146>,
				<0.696718, 0.231003, 0.671074>, <-0.616517, 1.393773, 5.802589>,
				<0.693769, 0.208233, 0.681499>, <-0.563066, 1.257303, 5.839134>
			}
			smooth_triangle {
				<0.711047, 0.234953, 0.654469>, <-0.351322, 0.718042, 2.891338>,
				<0.709669, 0.211513, 0.663888>, <-0.326822, 0.649688, 2.910355>,
				<0.696718, 0.231003, 0.671074>, <-0.616517, 1.393773, 5.802589>
			}
			smooth_triangle {
				<0.696718, 0.231003, 0.671074>, <-0.616517, 1.393773, 5.802589>,
				<0.709669, 0.211513, 0.663888>, <-0.326822, 0.649688, 2.910355>,
				<0.693769, 0.208233, 0.681499>, <-0.563066, 1.257303, 5.839134>
			}
			smooth_triangle {
				<0.256288, 0.340941, 0.898430>, <1.140759, 1.037444, 2.573212>,
				<0.240174, 0.355351, 0.897305>, <1.176440, 1.082294, 2.538441>,
				<0.254456, 0.358681, 0.892031>, <2.281343, 2.163407, 5.109809>
			}
			smooth_triangle {
				<0.314864, 0.375822, 0.865296>, <1.900168, 2.268367, 5.218493>,
				<0.341408, 0.377992, 0.854210>, <1.727378, 2.283199, 5.271632>,
				<0.335377, 0.351682, 0.867730>, <1.811336, 2.122656, 5.310629>
			}
			smooth_triangle {
				<0.419571, 0.361702, 0.825984>, <1.259129, 2.186101, 5.442926>,
				<0.420615, 0.338092, 0.835395>, <1.297369, 2.038327, 5.491282>,
				<0.399402, 0.356572, 0.838117>, <1.404771, 2.152808, 5.420640>
			}
			smooth_triangle {
				<0.361202, 0.351222, 0.857482>, <1.658724, 2.120303, 5.361175>,
				<0.379448, 0.325612, 0.859717>, <1.841874, 2.294022, 6.350823>,
				<0.354233, 0.325052, 0.870614>, <2.031276, 2.294166, 6.292744>
			}
			smooth_triangle {
				<0.379448, 0.325612, 0.859717>, <1.841874, 2.294022, 6.350823>,
				<0.401921, 0.309822, 0.855323>, <1.461595, 1.870532, 5.509750>,
				<0.383790, 0.297972, 0.867770>, <1.853498, 2.097033, 6.415382>
			}
			smooth_triangle {
				<0.401921, 0.309822, 0.855323>, <1.461595, 1.870532, 5.509750>,
				<0.404577, 0.287382, 0.861880>, <0.980597, 1.178389, 3.694252>,
				<0.383790, 0.297972, 0.867770>, <1.853498, 2.097033, 6.415382>
			}
			smooth_triangle {
				<0.362560, 0.299642, 0.876290>, <1.725736, 1.804508, 5.455103>,
				<0.354233, 0.325052, 0.870614>, <2.031276, 2.294166, 6.292744>,
				<0.370077, 0.312162, 0.868742>, <1.104151, 1.257122, 3.632838>
			}
			smooth_triangle {
				<0.354233, 0.325052, 0.870614>, <2.031276, 2.294166, 6.292744>,
				<0.379448, 0.325612, 0.859717>, <1.841874, 2.294022, 6.350823>,
				<0.370077, 0.312162, 0.868742>, <1.104151, 1.257122, 3.632838>
			}
			smooth_triangle {
				<0.379448, 0.325612, 0.859717>, <1.841874, 2.294022, 6.350823>,
				<0.383790, 0.297972, 0.867770>, <1.853498, 2.097033, 6.415382>,
				<0.370077, 0.312162, 0.868742>, <1.104151, 1.257122, 3.632838>
			}
			smooth_triangle {
				<0.362560, 0.299642, 0.876290>, <1.725736, 1.804508, 5.455103>,
				<0.370077, 0.312162, 0.868742>, <1.104151, 1.257122, 3.632838>,
				<0.383790, 0.297972, 0.867770>, <1.853498, 2.097033, 6.415382>
			}
			smooth_triangle {
				<0.401921, 0.309822, 0.855323>, <1.461595, 1.870532, 5.509750>,
				<0.379448, 0.325612, 0.859717>, <1.841874, 2.294022, 6.350823>,
				<0.401006, 0.332882, 0.847045>, <1.431281, 2.007171, 5.469493>
			}
			smooth_triangle {
				<0.361202, 0.351222, 0.857482>, <1.658724, 2.120303, 5.361175>,
				<0.382917, 0.348782, 0.849026>, <1.270906, 1.755390, 4.505213>,
				<0.379448, 0.325612, 0.859717>, <1.841874, 2.294022, 6.350823>
			}
			smooth_triangle {
				<0.379448, 0.325612, 0.859717>, <1.841874, 2.294022, 6.350823>,
				<0.382917, 0.348782, 0.849026>, <1.270906, 1.755390, 4.505213>,
				<0.401006, 0.332882, 0.847045>, <1.431281, 2.007171, 5.469493>
			}
			smooth_triangle {
				<0.404577, 0.287382, 0.861880>, <0.980597, 1.178389, 3.694252>,
				<0.401921, 0.309822, 0.855323>, <1.461595, 1.870532, 5.509750>,
				<0.421126, 0.296662, 0.850736>, <1.354025, 1.788414, 5.564349>
			}
			smooth_triangle {
				<0.401006, 0.332882, 0.847045>, <1.431281, 2.007171, 5.469493>,
				<0.420908, 0.317412, 0.843321>, <1.326111, 1.918307, 5.527649>,
				<0.401921, 0.309822, 0.855323>, <1.461595, 1.870532, 5.509750>
			}
			smooth_triangle {
				<0.401921, 0.309822, 0.855323>, <1.461595, 1.870532, 5.509750>,
				<0.420908, 0.317412, 0.843321>, <1.326111, 1.918307, 5.527649>,
				<0.421126, 0.296662, 0.850736>, <1.354025, 1.788414, 5.564349>
			}
			smooth_triangle {
				<0.420908, 0.317412, 0.843321>, <1.326111, 1.918307, 5.527649>,
				<0.401006, 0.332882, 0.847045>, <1.431281, 2.007171, 5.469493>,
				<0.420615, 0.338092, 0.835395>, <1.297369, 2.038327, 5.491282>
			}
			smooth_triangle {
				<0.382917, 0.348782, 0.849026>, <1.270906, 1.755390, 4.505213>,
				<0.399402, 0.356572, 0.838117>, <1.404771, 2.152808, 5.420640>,
				<0.401006, 0.332882, 0.847045>, <1.431281, 2.007171, 5.469493>
			}
			smooth_triangle {
				<0.401006, 0.332882, 0.847045>, <1.431281, 2.007171, 5.469493>,
				<0.399402, 0.356572, 0.838117>, <1.404771, 2.152808, 5.420640>,
				<0.420615, 0.338092, 0.835395>, <1.297369, 2.038327, 5.491282>
			}
			smooth_triangle {
				<0.419571, 0.361702, 0.825984>, <1.259129, 2.186101, 5.442926>,
				<0.399402, 0.356572, 0.838117>, <1.404771, 2.152808, 5.420640>,
				<0.398482, 0.380042, 0.828185>, <1.141152, 1.917577, 4.473467>
			}
			smooth_triangle {
				<0.361202, 0.351222, 0.857482>, <1.658724, 2.120303, 5.361175>,
				<0.372857, 0.376792, 0.841502>, <1.799093, 2.660455, 6.218155>,
				<0.382917, 0.348782, 0.849026>, <1.270906, 1.755390, 4.505213>
			}
			smooth_triangle {
				<0.372857, 0.376792, 0.841502>, <1.799093, 2.660455, 6.218155>,
				<0.399402, 0.356572, 0.838117>, <1.404771, 2.152808, 5.420640>,
				<0.382917, 0.348782, 0.849026>, <1.270906, 1.755390, 4.505213>
			}
			smooth_triangle {
				<0.372857, 0.376792, 0.841502>, <1.799093, 2.660455, 6.218155>,
				<0.398482, 0.380042, 0.828185>, <1.141152, 1.917577, 4.473467>,
				<0.399402, 0.356572, 0.838117>, <1.404771, 2.152808, 5.420640>
			}
			smooth_triangle {
				<0.372857, 0.376792, 0.841502>, <1.799093, 2.660455, 6.218155>,
				<0.361202, 0.351222, 0.857482>, <1.658724, 2.120303, 5.361175>,
				<0.341408, 0.377992, 0.854210>, <1.727378, 2.283199, 5.271632>
			}
			smooth_triangle {
				<0.354233, 0.325052, 0.870614>, <2.031276, 2.294166, 6.292744>,
				<0.335377, 0.351682, 0.867730>, <1.811336, 2.122656, 5.310629>,
				<0.361202, 0.351222, 0.857482>, <1.658724, 2.120303, 5.361175>
			}
			smooth_triangle {
				<0.361202, 0.351222, 0.857482>, <1.658724, 2.120303, 5.361175>,
				<0.335377, 0.351682, 0.867730>, <1.811336, 2.122656, 5.310629>,
				<0.341408, 0.377992, 0.854210>, <1.727378, 2.283199, 5.271632>
			}
			smooth_triangle {
				<0.362560, 0.299642, 0.876290>, <1.725736, 1.804508, 5.455103>,
				<0.341512, 0.305402, 0.882725>, <1.841949, 1.844784, 5.403431>,
				<0.354233, 0.325052, 0.870614>, <2.031276, 2.294166, 6.292744>
			}
			smooth_triangle {
				<0.256288, 0.340941, 0.898430>, <1.140759, 1.037444, 2.573212>,
				<0.270512, 0.342331, 0.893727>, <2.211236, 2.064115, 5.181084>,
				<0.265527, 0.321891, 0.902766>, <1.497299, 1.294420, 3.475683>
			}
			smooth_triangle {
				<0.265527, 0.321891, 0.902766>, <1.497299, 1.294420, 3.475683>,
				<0.270512, 0.342331, 0.893727>, <2.211236, 2.064115, 5.181084>,
				<0.286452, 0.320972, 0.896683>, <2.512799, 2.260572, 6.129124>
			}
			smooth_triangle {
				<0.289395, 0.346352, 0.886236>, <2.096800, 2.089599, 5.218130>,
				<0.286452, 0.320972, 0.896683>, <2.512799, 2.260572, 6.129124>,
				<0.270512, 0.342331, 0.893727>, <2.211236, 2.064115, 5.181084>
			}
			smooth_triangle {
				<0.289395, 0.346352, 0.886236>, <2.096800, 2.089599, 5.218130>,
				<0.306767, 0.327402, 0.887586>, <2.022988, 1.978810, 5.290108>,
				<0.286452, 0.320972, 0.896683>, <2.512799, 2.260572, 6.129124>
			}
			smooth_triangle {
				<0.306767, 0.327402, 0.887586>, <2.022988, 1.978810, 5.290108>,
				<0.304087, 0.309172, 0.895017>, <1.722475, 1.555766, 4.428215>,
				<0.286452, 0.320972, 0.896683>, <2.512799, 2.260572, 6.129124>
			}
			smooth_triangle {
				<0.289395, 0.346352, 0.886236>, <2.096800, 2.089599, 5.218130>,
				<0.270512, 0.342331, 0.893727>, <2.211236, 2.064115, 5.181084>,
				<0.270578, 0.364412, 0.884938>, <2.174282, 2.201002, 5.140130>
			}
			smooth_triangle {
				<0.256288, 0.340941, 0.898430>, <1.140759, 1.037444, 2.573212>,
				<0.254456, 0.358681, 0.892031>, <2.281343, 2.163407, 5.109809>,
				<0.270512, 0.342331, 0.893727>, <2.211236, 2.064115, 5.181084>
			}
			smooth_triangle {
				<0.270512, 0.342331, 0.893727>, <2.211236, 2.064115, 5.181084>,
				<0.254456, 0.358681, 0.892031>, <2.281343, 2.163407, 5.109809>,
				<0.270578, 0.364412, 0.884938>, <2.174282, 2.201002, 5.140130>
			}
			smooth_triangle {
				<0.306767, 0.327402, 0.887586>, <2.022988, 1.978810, 5.290108>,
				<0.289395, 0.346352, 0.886236>, <2.096800, 2.089599, 5.218130>,
				<0.311005, 0.350382, 0.877281>, <1.962211, 2.115896, 5.259644>
			}
			smooth_triangle {
				<0.270578, 0.364412, 0.884938>, <2.174282, 2.201002, 5.140130>,
				<0.290514, 0.371632, 0.875559>, <2.048755, 2.246243, 5.171755>,
				<0.289395, 0.346352, 0.886236>, <2.096800, 2.089599, 5.218130>
			}
			smooth_triangle {
				<0.289395, 0.346352, 0.886236>, <2.096800, 2.089599, 5.218130>,
				<0.290514, 0.371632, 0.875559>, <2.048755, 2.246243, 5.171755>,
				<0.311005, 0.350382, 0.877281>, <1.962211, 2.115896, 5.259644>
			}
			smooth_triangle {
				<0.304087, 0.309172, 0.895017>, <1.722475, 1.555766, 4.428215>,
				<0.306767, 0.327402, 0.887586>, <2.022988, 1.978810, 5.290108>,
				<0.320802, 0.308432, 0.889424>, <1.962664, 1.862407, 5.354750>
			}
			smooth_triangle {
				<0.311005, 0.350382, 0.877281>, <1.962211, 2.115896, 5.259644>,
				<0.328406, 0.328242, 0.879506>, <1.888492, 1.982803, 5.337923>,
				<0.306767, 0.327402, 0.887586>, <2.022988, 1.978810, 5.290108>
			}
			smooth_triangle {
				<0.306767, 0.327402, 0.887586>, <2.022988, 1.978810, 5.290108>,
				<0.328406, 0.328242, 0.879506>, <1.888492, 1.982803, 5.337923>,
				<0.320802, 0.308432, 0.889424>, <1.962664, 1.862407, 5.354750>
			}
			smooth_triangle {
				<0.328406, 0.328242, 0.879506>, <1.888492, 1.982803, 5.337923>,
				<0.311005, 0.350382, 0.877281>, <1.962211, 2.115896, 5.259644>,
				<0.335377, 0.351682, 0.867730>, <1.811336, 2.122656, 5.310629>
			}
			smooth_triangle {
				<0.290514, 0.371632, 0.875559>, <2.048755, 2.246243, 5.171755>,
				<0.314864, 0.375822, 0.865296>, <1.900168, 2.268367, 5.218493>,
				<0.311005, 0.350382, 0.877281>, <1.962211, 2.115896, 5.259644>
			}
			smooth_triangle {
				<0.311005, 0.350382, 0.877281>, <1.962211, 2.115896, 5.259644>,
				<0.314864, 0.375822, 0.865296>, <1.900168, 2.268367, 5.218493>,
				<0.335377, 0.351682, 0.867730>, <1.811336, 2.122656, 5.310629>
			}
			smooth_triangle {
				<0.320802, 0.308432, 0.889424>, <1.962664, 1.862407, 5.354750>,
				<0.328406, 0.328242, 0.879506>, <1.888492, 1.982803, 5.337923>,
				<0.341512, 0.305402, 0.882725>, <1.841949, 1.844784, 5.403431>
			}
			smooth_triangle {
				<0.335377, 0.351682, 0.867730>, <1.811336, 2.122656, 5.310629>,
				<0.354233, 0.325052, 0.870614>, <2.031276, 2.294166, 6.292744>,
				<0.328406, 0.328242, 0.879506>, <1.888492, 1.982803, 5.337923>
			}
			smooth_triangle {
				<0.328406, 0.328242, 0.879506>, <1.888492, 1.982803, 5.337923>,
				<0.354233, 0.325052, 0.870614>, <2.031276, 2.294166, 6.292744>,
				<0.341512, 0.305402, 0.882725>, <1.841949, 1.844784, 5.403431>
			}
			smooth_triangle {
				<0.421126, 0.296662, 0.850736>, <1.354025, 1.788414, 5.564349>,
				<0.420908, 0.317412, 0.843321>, <1.326111, 1.918307, 5.527649>,
				<0.437339, 0.305272, 0.839442>, <0.640003, 0.924079, 2.781280>
			}
			smooth_triangle {
				<0.419571, 0.361702, 0.825984>, <1.259129, 2.186101, 5.442926>,
				<0.439143, 0.338122, 0.825801>, <0.798631, 1.387064, 3.665478>,
				<0.420615, 0.338092, 0.835395>, <1.297369, 2.038327, 5.491282>
			}
			smooth_triangle {
				<0.420908, 0.317412, 0.843321>, <1.326111, 1.918307, 5.527649>,
				<0.442710, 0.320802, 0.830783>, <0.624101, 0.977743, 2.766635>,
				<0.437339, 0.305272, 0.839442>, <0.640003, 0.924079, 2.781280>
			}
			smooth_triangle {
				<0.420908, 0.317412, 0.843321>, <1.326111, 1.918307, 5.527649>,
				<0.420615, 0.338092, 0.835395>, <1.297369, 2.038327, 5.491282>,
				<0.442710, 0.320802, 0.830783>, <0.624101, 0.977743, 2.766635>
			}
			smooth_triangle {
				<0.420615, 0.338092, 0.835395>, <1.297369, 2.038327, 5.491282>,
				<0.439143, 0.338122, 0.825801>, <0.798631, 1.387064, 3.665478>,
				<0.442710, 0.320802, 0.830783>, <0.624101, 0.977743, 2.766635>
			}
			smooth_triangle {
				<0.404577, 0.287382, 0.861880>, <0.980597, 1.178389, 3.694252>,
				<0.393337, 0.275952, 0.870777>, <0.798480, 0.843102, 2.765915>,
				<0.383790, 0.297972, 0.867770>, <1.853498, 2.097033, 6.415382>
			}
			smooth_triangle {
				<0.393337, 0.275952, 0.870777>, <0.798480, 0.843102, 2.765915>,
				<0.373783, 0.274102, 0.879927>, <1.963997, 1.930752, 6.434615>,
				<0.383790, 0.297972, 0.867770>, <1.853498, 2.097033, 6.415382>
			}
			smooth_triangle {
				<0.265527, 0.321891, 0.902766>, <1.497299, 1.294420, 3.475683>,
				<0.286452, 0.320972, 0.896683>, <2.512799, 2.260572, 6.129124>,
				<0.274430, 0.301791, 0.907045>, <2.247730, 1.820770, 5.256056>
			}
			smooth_triangle {
				<0.383790, 0.297972, 0.867770>, <1.853498, 2.097033, 6.415382>,
				<0.373783, 0.274102, 0.879927>, <1.963997, 1.930752, 6.434615>,
				<0.362560, 0.299642, 0.876290>, <1.725736, 1.804508, 5.455103>
			}
			smooth_triangle {
				<0.373783, 0.274102, 0.879927>, <1.963997, 1.930752, 6.434615>,
				<0.351239, 0.282332, 0.886586>, <1.812017, 1.703852, 5.459549>,
				<0.362560, 0.299642, 0.876290>, <1.725736, 1.804508, 5.455103>
			}
			smooth_triangle {
				<0.274430, 0.301791, 0.907045>, <2.247730, 1.820770, 5.256056>,
				<0.286452, 0.320972, 0.896683>, <2.512799, 2.260572, 6.129124>,
				<0.293790, 0.296802, 0.902613>, <2.145371, 1.790282, 5.309096>
			}
			smooth_triangle {
				<0.286452, 0.320972, 0.896683>, <2.512799, 2.260572, 6.129124>,
				<0.304087, 0.309172, 0.895017>, <1.722475, 1.555766, 4.428215>,
				<0.293790, 0.296802, 0.902613>, <2.145371, 1.790282, 5.309096>
			}
			smooth_triangle {
				<0.362560, 0.299642, 0.876290>, <1.725736, 1.804508, 5.455103>,
				<0.351239, 0.282332, 0.886586>, <1.812017, 1.703852, 5.459549>,
				<0.341512, 0.305402, 0.882725>, <1.841949, 1.844784, 5.403431>
			}
			smooth_triangle {
				<0.351239, 0.282332, 0.886586>, <1.812017, 1.703852, 5.459549>,
				<0.331179, 0.287842, 0.892518>, <1.928438, 1.736916, 5.409080>,
				<0.341512, 0.305402, 0.882725>, <1.841949, 1.844784, 5.403431>
			}
			smooth_triangle {
				<0.293790, 0.296802, 0.902613>, <2.145371, 1.790282, 5.309096>,
				<0.304087, 0.309172, 0.895017>, <1.722475, 1.555766, 4.428215>,
				<0.312262, 0.291772, 0.898039>, <2.039212, 1.758266, 5.361441>
			}
			smooth_triangle {
				<0.304087, 0.309172, 0.895017>, <1.722475, 1.555766, 4.428215>,
				<0.320802, 0.308432, 0.889424>, <1.962664, 1.862407, 5.354750>,
				<0.312262, 0.291772, 0.898039>, <2.039212, 1.758266, 5.361441>
			}
			smooth_triangle {
				<0.341512, 0.305402, 0.882725>, <1.841949, 1.844784, 5.403431>,
				<0.331179, 0.287842, 0.892518>, <1.928438, 1.736916, 5.409080>,
				<0.320802, 0.308432, 0.889424>, <1.962664, 1.862407, 5.354750>
			}
			smooth_triangle {
				<0.331179, 0.287842, 0.892518>, <1.928438, 1.736916, 5.409080>,
				<0.312262, 0.291772, 0.898039>, <2.039212, 1.758266, 5.361441>,
				<0.320802, 0.308432, 0.889424>, <1.962664, 1.862407, 5.354750>
			}
			smooth_triangle {
				<0.398482, 0.380042, 0.828185>, <1.141152, 1.917577, 4.473467>,
				<0.418795, 0.393462, 0.811727>, <1.414803, 2.782308, 6.263611>,
				<0.419571, 0.361702, 0.825984>, <1.259129, 2.186101, 5.442926>
			}
			smooth_triangle {
				<0.445449, 0.381842, 0.803042>, <0.883203, 1.923882, 4.528918>,
				<0.439832, 0.362702, 0.814923>, <1.132613, 2.191571, 5.468529>,
				<0.418795, 0.393462, 0.811727>, <1.414803, 2.782308, 6.263611>
			}
			smooth_triangle {
				<0.439143, 0.338122, 0.825801>, <0.798631, 1.387064, 3.665478>,
				<0.419571, 0.361702, 0.825984>, <1.259129, 2.186101, 5.442926>,
				<0.439832, 0.362702, 0.814923>, <1.132613, 2.191571, 5.468529>
			}
			smooth_triangle {
				<0.418795, 0.393462, 0.811727>, <1.414803, 2.782308, 6.263611>,
				<0.439832, 0.362702, 0.814923>, <1.132613, 2.191571, 5.468529>,
				<0.419571, 0.361702, 0.825984>, <1.259129, 2.186101, 5.442926>
			}
			smooth_triangle {
				<0.463908, 0.380492, 0.793179>, <0.620896, 1.572018, 3.624778>,
				<0.461214, 0.359412, 0.804500>, <0.520326, 1.100783, 2.741661>,
				<0.445449, 0.381842, 0.803042>, <0.883203, 1.923882, 4.528918>
			}
			smooth_triangle {
				<0.439143, 0.338122, 0.825801>, <0.798631, 1.387064, 3.665478>,
				<0.439832, 0.362702, 0.814923>, <1.132613, 2.191571, 5.468529>,
				<0.453737, 0.340512, 0.816870>, <0.365623, 0.707439, 1.834598>
			}
			smooth_triangle {
				<0.445449, 0.381842, 0.803042>, <0.883203, 1.923882, 4.528918>,
				<0.461214, 0.359412, 0.804500>, <0.520326, 1.100783, 2.741661>,
				<0.439832, 0.362702, 0.814923>, <1.132613, 2.191571, 5.468529>
			}
			smooth_triangle {
				<0.461214, 0.359412, 0.804500>, <0.520326, 1.100783, 2.741661>,
				<0.453737, 0.340512, 0.816870>, <0.365623, 0.707439, 1.834598>,
				<0.439832, 0.362702, 0.814923>, <1.132613, 2.191571, 5.468529>
			}
			smooth_triangle {
				<0.274430, 0.301791, 0.907045>, <2.247730, 1.820770, 5.256056>,
				<0.293790, 0.296802, 0.902613>, <2.145371, 1.790282, 5.309096>,
				<0.282864, 0.280321, 0.911324>, <2.227154, 1.690825, 5.308040>
			}
			smooth_triangle {
				<0.300403, 0.238892, 0.917494>, <2.170404, 1.439611, 5.404746>,
				<0.310807, 0.255642, 0.909482>, <2.091031, 1.542041, 5.407800>,
				<0.319980, 0.235532, 0.911732>, <2.057576, 1.419601, 5.453939>
			}
			smooth_triangle {
				<0.320967, 0.271712, 0.901257>, <2.011757, 1.638841, 5.409410>,
				<0.339642, 0.266682, 0.895899>, <1.903253, 1.609250, 5.457334>,
				<0.329367, 0.251592, 0.904064>, <1.983754, 1.518180, 5.454793>
			}
			smooth_triangle {
				<0.339642, 0.266682, 0.895899>, <1.903253, 1.609250, 5.457334>,
				<0.358059, 0.259492, 0.890824>, <1.797777, 1.567095, 5.505119>,
				<0.346654, 0.246452, 0.898997>, <1.883393, 1.490454, 5.497924>
			}
			smooth_triangle {
				<0.358059, 0.259492, 0.890824>, <1.797777, 1.567095, 5.505119>,
				<0.362048, 0.236482, 0.895609>, <1.485284, 1.204752, 4.619374>,
				<0.346654, 0.246452, 0.898997>, <1.883393, 1.490454, 5.497924>
			}
			smooth_triangle {
				<0.362048, 0.236482, 0.895609>, <1.485284, 1.204752, 4.619374>,
				<0.352705, 0.231022, 0.900747>, <0.944840, 0.709241, 2.757490>,
				<0.346654, 0.246452, 0.898997>, <1.883393, 1.490454, 5.497924>
			}
			smooth_triangle {
				<0.339642, 0.266682, 0.895899>, <1.903253, 1.609250, 5.457334>,
				<0.346654, 0.246452, 0.898997>, <1.883393, 1.490454, 5.497924>,
				<0.329367, 0.251592, 0.904064>, <1.983754, 1.518180, 5.454793>
			}
			smooth_triangle {
				<0.352705, 0.231022, 0.900747>, <0.944840, 0.709241, 2.757490>,
				<0.337769, 0.232932, 0.905956>, <1.956383, 1.405828, 5.494743>,
				<0.346654, 0.246452, 0.898997>, <1.883393, 1.490454, 5.497924>
			}
			smooth_triangle {
				<0.346654, 0.246452, 0.898997>, <1.883393, 1.490454, 5.497924>,
				<0.337769, 0.232932, 0.905956>, <1.956383, 1.405828, 5.494743>,
				<0.329367, 0.251592, 0.904064>, <1.983754, 1.518180, 5.454793>
			}
			smooth_triangle {
				<0.358059, 0.259492, 0.890824>, <1.797777, 1.567095, 5.505119>,
				<0.339642, 0.266682, 0.895899>, <1.903253, 1.609250, 5.457334>,
				<0.351239, 0.282332, 0.886586>, <1.812017, 1.703852, 5.459549>
			}
			smooth_triangle {
				<0.320967, 0.271712, 0.901257>, <2.011757, 1.638841, 5.409410>,
				<0.331179, 0.287842, 0.892518>, <1.928438, 1.736916, 5.409080>,
				<0.339642, 0.266682, 0.895899>, <1.903253, 1.609250, 5.457334>
			}
			smooth_triangle {
				<0.339642, 0.266682, 0.895899>, <1.903253, 1.609250, 5.457334>,
				<0.331179, 0.287842, 0.892518>, <1.928438, 1.736916, 5.409080>,
				<0.351239, 0.282332, 0.886586>, <1.812017, 1.703852, 5.459549>
			}
			smooth_triangle {
				<0.320967, 0.271712, 0.901257>, <2.011757, 1.638841, 5.409410>,
				<0.329367, 0.251592, 0.904064>, <1.983754, 1.518180, 5.454793>,
				<0.310807, 0.255642, 0.909482>, <2.091031, 1.542041, 5.407800>
			}
			smooth_triangle {
				<0.337769, 0.232932, 0.905956>, <1.956383, 1.405828, 5.494743>,
				<0.319980, 0.235532, 0.911732>, <2.057576, 1.419601, 5.453939>,
				<0.329367, 0.251592, 0.904064>, <1.983754, 1.518180, 5.454793>
			}
			smooth_triangle {
				<0.329367, 0.251592, 0.904064>, <1.983754, 1.518180, 5.454793>,
				<0.319980, 0.235532, 0.911732>, <2.057576, 1.419601, 5.453939>,
				<0.310807, 0.255642, 0.909482>, <2.091031, 1.542041, 5.407800>
			}
			smooth_triangle {
				<0.331179, 0.287842, 0.892518>, <1.928438, 1.736916, 5.409080>,
				<0.320967, 0.271712, 0.901257>, <2.011757, 1.638841, 5.409410>,
				<0.312262, 0.291772, 0.898039>, <2.039212, 1.758266, 5.361441>
			}
			smooth_triangle {
				<0.300403, 0.238892, 0.917494>, <2.170404, 1.439611, 5.404746>,
				<0.291636, 0.259432, 0.914746>, <2.199356, 1.565289, 5.357880>,
				<0.310807, 0.255642, 0.909482>, <2.091031, 1.542041, 5.407800>
			}
			smooth_triangle {
				<0.291636, 0.259432, 0.914746>, <2.199356, 1.565289, 5.357880>,
				<0.302116, 0.276062, 0.906436>, <2.119502, 1.665102, 5.360009>,
				<0.310807, 0.255642, 0.909482>, <2.091031, 1.542041, 5.407800>
			}
			smooth_triangle {
				<0.312262, 0.291772, 0.898039>, <2.039212, 1.758266, 5.361441>,
				<0.320967, 0.271712, 0.901257>, <2.011757, 1.638841, 5.409410>,
				<0.302116, 0.276062, 0.906436>, <2.119502, 1.665102, 5.360009>
			}
			smooth_triangle {
				<0.320967, 0.271712, 0.901257>, <2.011757, 1.638841, 5.409410>,
				<0.310807, 0.255642, 0.909482>, <2.091031, 1.542041, 5.407800>,
				<0.302116, 0.276062, 0.906436>, <2.119502, 1.665102, 5.360009>
			}
			smooth_triangle {
				<0.312262, 0.291772, 0.898039>, <2.039212, 1.758266, 5.361441>,
				<0.302116, 0.276062, 0.906436>, <2.119502, 1.665102, 5.360009>,
				<0.293790, 0.296802, 0.902613>, <2.145371, 1.790282, 5.309096>
			}
			smooth_triangle {
				<0.291636, 0.259432, 0.914746>, <2.199356, 1.565289, 5.357880>,
				<0.282864, 0.280321, 0.911324>, <2.227154, 1.690825, 5.308040>,
				<0.302116, 0.276062, 0.906436>, <2.119502, 1.665102, 5.360009>
			}
			smooth_triangle {
				<0.302116, 0.276062, 0.906436>, <2.119502, 1.665102, 5.360009>,
				<0.282864, 0.280321, 0.911324>, <2.227154, 1.690825, 5.308040>,
				<0.293790, 0.296802, 0.902613>, <2.145371, 1.790282, 5.309096>
			}
			smooth_triangle {
				<0.330977, 0.214472, 0.913000>, <1.352803, 0.891106, 3.657134>,
				<0.319480, 0.202532, 0.919802>, <1.062009, 0.621317, 2.735927>,
				<0.310103, 0.218982, 0.919237>, <2.133680, 1.322682, 5.449056>
			}
			smooth_triangle {
				<0.300403, 0.238892, 0.917494>, <2.170404, 1.439611, 5.404746>,
				<0.319980, 0.235532, 0.911732>, <2.057576, 1.419601, 5.453939>,
				<0.310103, 0.218982, 0.919237>, <2.133680, 1.322682, 5.449056>
			}
			smooth_triangle {
				<0.352705, 0.231022, 0.900747>, <0.944840, 0.709241, 2.757490>,
				<0.346601, 0.218022, 0.906338>, <0.647256, 0.452663, 1.837405>,
				<0.337769, 0.232932, 0.905956>, <1.956383, 1.405828, 5.494743>
			}
			smooth_triangle {
				<0.346601, 0.218022, 0.906338>, <0.647256, 0.452663, 1.837405>,
				<0.330977, 0.214472, 0.913000>, <1.352803, 0.891106, 3.657134>,
				<0.337769, 0.232932, 0.905956>, <1.956383, 1.405828, 5.494743>
			}
			smooth_triangle {
				<0.310103, 0.218982, 0.919237>, <2.133680, 1.322682, 5.449056>,
				<0.319980, 0.235532, 0.911732>, <2.057576, 1.419601, 5.453939>,
				<0.330977, 0.214472, 0.913000>, <1.352803, 0.891106, 3.657134>
			}
			smooth_triangle {
				<0.319980, 0.235532, 0.911732>, <2.057576, 1.419601, 5.453939>,
				<0.337769, 0.232932, 0.905956>, <1.956383, 1.405828, 5.494743>,
				<0.330977, 0.214472, 0.913000>, <1.352803, 0.891106, 3.657134>
			}
			smooth_triangle {
				<0.362048, 0.236482, 0.895609>, <1.485284, 1.204752, 4.619374>,
				<0.358059, 0.259492, 0.890824>, <1.797777, 1.567095, 5.505119>,
				<0.374510, 0.250212, 0.886705>, <1.420922, 1.258042, 4.625334>
			}
			smooth_triangle {
				<0.351239, 0.282332, 0.886586>, <1.812017, 1.703852, 5.459549>,
				<0.373783, 0.274102, 0.879927>, <1.963997, 1.930752, 6.434615>,
				<0.358059, 0.259492, 0.890824>, <1.797777, 1.567095, 5.505119>
			}
			smooth_triangle {
				<0.373783, 0.274102, 0.879927>, <1.963997, 1.930752, 6.434615>,
				<0.374510, 0.250212, 0.886705>, <1.420922, 1.258042, 4.625334>,
				<0.358059, 0.259492, 0.890824>, <1.797777, 1.567095, 5.505119>
			}
			smooth_triangle {
				<0.374510, 0.250212, 0.886705>, <1.420922, 1.258042, 4.625334>,
				<0.373783, 0.274102, 0.879927>, <1.963997, 1.930752, 6.434615>,
				<0.392079, 0.251952, 0.878582>, <0.820792, 0.772814, 2.779930>
			}
			smooth_triangle {
				<0.373783, 0.274102, 0.879927>, <1.963997, 1.930752, 6.434615>,
				<0.393337, 0.275952, 0.870777>, <0.798480, 0.843102, 2.765915>,
				<0.392079, 0.251952, 0.878582>, <0.820792, 0.772814, 2.779930>
			}
			smooth_triangle {
				<0.392079, 0.251952, 0.878582>, <0.820792, 0.772814, 2.779930>,
				<0.386166, 0.228432, 0.887590>, <1.139704, 0.924328, 3.720803>,
				<0.374510, 0.250212, 0.886705>, <1.420922, 1.258042, 4.625334>
			}
			smooth_triangle {
				<0.363739, 0.213062, 0.900782>, <0.869871, 0.649386, 2.796604>,
				<0.362048, 0.236482, 0.895609>, <1.485284, 1.204752, 4.619374>,
				<0.386166, 0.228432, 0.887590>, <1.139704, 0.924328, 3.720803>
			}
			smooth_triangle {
				<0.386166, 0.228432, 0.887590>, <1.139704, 0.924328, 3.720803>,
				<0.362048, 0.236482, 0.895609>, <1.485284, 1.204752, 4.619374>,
				<0.374510, 0.250212, 0.886705>, <1.420922, 1.258042, 4.625334>
			}
			smooth_triangle {
				<0.386166, 0.228432, 0.887590>, <1.139704, 0.924328, 3.720803>,
				<0.387454, 0.203142, 0.893154>, <0.861623, 0.614589, 2.806892>,
				<0.363739, 0.213062, 0.900782>, <0.869871, 0.649386, 2.796604>
			}
			smooth_triangle {
				<0.387454, 0.203142, 0.893154>, <0.861623, 0.614589, 2.806892>,
				<0.372052, 0.192262, 0.902070>, <0.864323, 0.581285, 2.813194>,
				<0.363739, 0.213062, 0.900782>, <0.869871, 0.649386, 2.796604>
			}
			smooth_triangle {
				<0.437339, 0.305272, 0.839442>, <0.640003, 0.924079, 2.781280>,
				<0.440334, 0.285312, 0.844878>, <0.654031, 0.865322, 2.796967>,
				<0.421126, 0.296662, 0.850736>, <1.354025, 1.788414, 5.564349>
			}
			smooth_triangle {
				<0.404577, 0.287382, 0.861880>, <0.980597, 1.178389, 3.694252>,
				<0.421126, 0.296662, 0.850736>, <1.354025, 1.788414, 5.564349>,
				<0.421063, 0.273962, 0.858347>, <0.673331, 0.856136, 2.795221>
			}
			smooth_triangle {
				<0.421126, 0.296662, 0.850736>, <1.354025, 1.788414, 5.564349>,
				<0.440334, 0.285312, 0.844878>, <0.654031, 0.865322, 2.796967>,
				<0.421063, 0.273962, 0.858347>, <0.673331, 0.856136, 2.795221>
			}
			smooth_triangle {
				<0.440334, 0.285312, 0.844878>, <0.654031, 0.865322, 2.796967>,
				<0.437862, 0.271292, 0.850752>, <0.219483, 0.282584, 0.933795>,
				<0.421063, 0.273962, 0.858347>, <0.673331, 0.856136, 2.795221>
			}
			smooth_triangle {
				<0.324610, 0.031572, 0.939543>, <1.430995, 0.190498, 3.730117>,
				<0.304342, 0.022961, 0.946550>, <0.368985, 0.031994, 0.928885>,
				<0.310827, 0.044711, 0.943668>, <0.720410, 0.084190, 1.863645>
			}
			smooth_triangle {
				<0.316679, 0.068352, 0.940297>, <1.058200, 0.184604, 2.800803>,
				<0.320778, 0.093932, 0.936688>, <0.696726, 0.169842, 1.866944>,
				<0.337005, 0.070692, 0.933032>, <2.410180, 0.502120, 6.551503>
			}
			smooth_triangle {
				<0.337434, 0.106872, 0.929422>, <1.002132, 0.280273, 2.813606>,
				<0.337005, 0.070692, 0.933032>, <2.410180, 0.502120, 6.551503>,
				<0.320778, 0.093932, 0.936688>, <0.696726, 0.169842, 1.866944>
			}
			smooth_triangle {
				<0.337434, 0.106872, 0.929422>, <1.002132, 0.280273, 2.813606>,
				<0.362482, 0.085872, 0.922137>, <1.312527, 0.371656, 3.759949>,
				<0.337005, 0.070692, 0.933032>, <2.410180, 0.502120, 6.551503>
			}
			smooth_triangle {
				<0.362482, 0.085872, 0.922137>, <1.312527, 0.371656, 3.759949>,
				<0.354572, 0.063122, 0.927038>, <0.667855, 0.136876, 1.880095>,
				<0.337005, 0.070692, 0.933032>, <2.410180, 0.502120, 6.551503>
			}
			smooth_triangle {
				<0.337434, 0.106872, 0.929422>, <1.002132, 0.280273, 2.813606>,
				<0.352980, 0.119342, 0.922108>, <0.960187, 0.330035, 2.822711>,
				<0.362482, 0.085872, 0.922137>, <1.312527, 0.371656, 3.759949>
			}
			smooth_triangle {
				<0.352980, 0.119342, 0.922108>, <0.960187, 0.330035, 2.822711>,
				<0.367168, 0.113112, 0.917330>, <0.941091, 0.355220, 2.826048>,
				<0.362482, 0.085872, 0.922137>, <1.312527, 0.371656, 3.759949>
			}
			smooth_triangle {
				<0.354572, 0.063122, 0.927038>, <0.667855, 0.136876, 1.880095>,
				<0.342246, 0.044102, 0.932760>, <0.696361, 0.112662, 1.871339>,
				<0.337005, 0.070692, 0.933032>, <2.410180, 0.502120, 6.551503>
			}
			smooth_triangle {
				<0.324610, 0.031572, 0.939543>, <1.430995, 0.190498, 3.730117>,
				<0.337005, 0.070692, 0.933032>, <2.410180, 0.502120, 6.551503>,
				<0.342246, 0.044102, 0.932760>, <0.696361, 0.112662, 1.871339>
			}
			smooth_triangle {
				<0.337005, 0.070692, 0.933032>, <2.410180, 0.502120, 6.551503>,
				<0.324610, 0.031572, 0.939543>, <1.430995, 0.190498, 3.730117>,
				<0.316679, 0.068352, 0.940297>, <1.058200, 0.184604, 2.800803>
			}
			smooth_triangle {
				<0.324610, 0.031572, 0.939543>, <1.430995, 0.190498, 3.730117>,
				<0.310827, 0.044711, 0.943668>, <0.720410, 0.084190, 1.863645>,
				<0.316679, 0.068352, 0.940297>, <1.058200, 0.184604, 2.800803>
			}
			smooth_triangle {
				<0.362837, 0.138072, 0.915638>, <0.917990, 0.398913, 2.827923>,
				<0.369713, 0.159362, 0.909411>, <0.881186, 0.451556, 2.831827>,
				<0.381788, 0.132332, 0.908757>, <0.898051, 0.421971, 2.830956>
			}
			smooth_triangle {
				<0.390112, 0.176462, 0.897659>, <0.852345, 0.537176, 2.825490>,
				<0.395896, 0.147002, 0.900430>, <0.861226, 0.467966, 2.835271>,
				<0.380182, 0.170712, 0.903016>, <0.858187, 0.502778, 2.830059>
			}
			smooth_triangle {
				<0.381788, 0.132332, 0.908757>, <0.898051, 0.421971, 2.830956>,
				<0.369713, 0.159362, 0.909411>, <0.881186, 0.451556, 2.831827>,
				<0.395896, 0.147002, 0.900430>, <0.861226, 0.467966, 2.835271>
			}
			smooth_triangle {
				<0.369713, 0.159362, 0.909411>, <0.881186, 0.451556, 2.831827>,
				<0.380182, 0.170712, 0.903016>, <0.858187, 0.502778, 2.830059>,
				<0.395896, 0.147002, 0.900430>, <0.861226, 0.467966, 2.835271>
			}
			smooth_triangle {
				<0.381788, 0.132332, 0.908757>, <0.898051, 0.421971, 2.830956>,
				<0.367168, 0.113112, 0.917330>, <0.941091, 0.355220, 2.826048>,
				<0.362837, 0.138072, 0.915638>, <0.917990, 0.398913, 2.827923>
			}
			smooth_triangle {
				<0.367168, 0.113112, 0.917330>, <0.941091, 0.355220, 2.826048>,
				<0.352980, 0.119342, 0.922108>, <0.960187, 0.330035, 2.822711>,
				<0.362837, 0.138072, 0.915638>, <0.917990, 0.398913, 2.827923>
			}
			smooth_triangle {
				<0.387454, 0.203142, 0.893154>, <0.861623, 0.614589, 2.806892>,
				<0.390112, 0.176462, 0.897659>, <0.852345, 0.537176, 2.825490>,
				<0.372052, 0.192262, 0.902070>, <0.864323, 0.581285, 2.813194>
			}
			smooth_triangle {
				<0.380182, 0.170712, 0.903016>, <0.858187, 0.502778, 2.830059>,
				<0.372052, 0.192262, 0.902070>, <0.864323, 0.581285, 2.813194>,
				<0.390112, 0.176462, 0.897659>, <0.852345, 0.537176, 2.825490>
			}
			smooth_triangle {
				<0.196017, 0.346831, 0.911265>, <0.432968, 0.358013, 0.827264>,
				<0.188918, 0.355111, 0.909572>, <1.319929, 1.092253, 2.462516>,
				<0.202872, 0.364671, 0.902758>, <1.722141, 1.480925, 3.292236>
			}
			smooth_triangle {
				<0.188918, 0.355111, 0.909572>, <1.319929, 1.092253, 2.462516>,
				<0.177719, 0.373521, 0.904440>, <2.683479, 2.277040, 4.858184>,
				<0.202872, 0.364671, 0.902758>, <1.722141, 1.480925, 3.292236>
			}
			smooth_triangle {
				<0.139099, 0.493371, 0.852255>, <1.820111, 1.819533, 3.058932>,
				<0.202859, 0.458331, 0.859011>, <3.141533, 3.718771, 6.340112>,
				<0.158280, 0.432401, 0.881523>, <2.272820, 2.197753, 3.867628>
			}
			smooth_triangle {
				<0.202859, 0.458331, 0.859011>, <3.141533, 3.718771, 6.340112>,
				<0.202638, 0.416811, 0.879952>, <2.473085, 2.524655, 4.845988>,
				<0.158280, 0.432401, 0.881523>, <2.272820, 2.197753, 3.867628>
			}
			smooth_triangle {
				<0.202872, 0.364671, 0.902758>, <1.722141, 1.480925, 3.292236>,
				<0.177719, 0.373521, 0.904440>, <2.683479, 2.277040, 4.858184>,
				<0.204915, 0.383971, 0.894256>, <2.935907, 2.724241, 5.739372>
			}
			smooth_triangle {
				<0.158280, 0.432401, 0.881523>, <2.272820, 2.197753, 3.867628>,
				<0.202638, 0.416811, 0.879952>, <2.473085, 2.524655, 4.845988>,
				<0.161319, 0.396051, 0.897902>, <2.743883, 2.423543, 4.750001>
			}
			smooth_triangle {
				<0.202638, 0.416811, 0.879952>, <2.473085, 2.524655, 4.845988>,
				<0.204915, 0.383971, 0.894256>, <2.935907, 2.724241, 5.739372>,
				<0.161319, 0.396051, 0.897902>, <2.743883, 2.423543, 4.750001>
			}
			smooth_triangle {
				<0.204915, 0.383971, 0.894256>, <2.935907, 2.724241, 5.739372>,
				<0.177719, 0.373521, 0.904440>, <2.683479, 2.277040, 4.858184>,
				<0.161319, 0.396051, 0.897902>, <2.743883, 2.423543, 4.750001>
			}
			smooth_triangle {
				<0.177719, 0.373521, 0.904440>, <2.683479, 2.277040, 4.858184>,
				<0.188918, 0.355111, 0.909572>, <1.319929, 1.092253, 2.462516>,
				<0.168883, 0.366361, 0.909047>, <0.910867, 0.753492, 1.612897>
			}
			smooth_triangle {
				<0.139099, 0.493371, 0.852255>, <1.820111, 1.819533, 3.058932>,
				<0.158280, 0.432401, 0.881523>, <2.272820, 2.197753, 3.867628>,
				<0.084591, 0.391581, 0.910290>, <3.990316, 3.450996, 6.007740>
			}
			smooth_triangle {
				<0.158280, 0.432401, 0.881523>, <2.272820, 2.197753, 3.867628>,
				<0.161319, 0.396051, 0.897902>, <2.743883, 2.423543, 4.750001>,
				<0.084591, 0.391581, 0.910290>, <3.990316, 3.450996, 6.007740>
			}
			smooth_triangle {
				<0.084591, 0.391581, 0.910290>, <3.990316, 3.450996, 6.007740>,
				<0.161319, 0.396051, 0.897902>, <2.743883, 2.423543, 4.750001>,
				<0.138881, 0.373491, 0.911221>, <1.413474, 1.180881, 2.367105>
			}
			smooth_triangle {
				<0.177719, 0.373521, 0.904440>, <2.683479, 2.277040, 4.858184>,
				<0.138881, 0.373491, 0.911221>, <1.413474, 1.180881, 2.367105>,
				<0.161319, 0.396051, 0.897902>, <2.743883, 2.423543, 4.750001>
			}
			smooth_triangle {
				<0.177719, 0.373521, 0.904440>, <2.683479, 2.277040, 4.858184>,
				<0.168883, 0.366361, 0.909047>, <0.910867, 0.753492, 1.612897>,
				<0.138881, 0.373491, 0.911221>, <1.413474, 1.180881, 2.367105>
			}
			smooth_triangle {
				<0.282505, 0.197211, 0.932956>, <2.312653, 1.192030, 5.405958>,
				<0.266635, 0.215831, 0.933506>, <2.787143, 1.515567, 6.239061>,
				<0.288138, 0.220751, 0.925932>, <2.632976, 1.550221, 6.297317>
			}
			smooth_triangle {
				<0.281351, 0.242341, 0.922620>, <2.275385, 1.463392, 5.354957>,
				<0.261336, 0.241571, 0.928684>, <2.798370, 1.702960, 6.185457>,
				<0.271841, 0.262611, 0.919921>, <2.313628, 1.583784, 5.303980>
			}
			smooth_triangle {
				<0.271841, 0.262611, 0.919921>, <2.313628, 1.583784, 5.303980>,
				<0.261336, 0.241571, 0.928684>, <2.798370, 1.702960, 6.185457>,
				<0.250616, 0.266791, 0.924729>, <2.431394, 1.604881, 5.244535>
			}
			smooth_triangle {
				<0.235716, 0.246481, 0.934229>, <2.953381, 1.736635, 6.103349>,
				<0.250616, 0.266791, 0.924729>, <2.431394, 1.604881, 5.244535>,
				<0.261336, 0.241571, 0.928684>, <2.798370, 1.702960, 6.185457>
			}
			smooth_triangle {
				<0.250616, 0.266791, 0.924729>, <2.431394, 1.604881, 5.244535>,
				<0.235716, 0.246481, 0.934229>, <2.953381, 1.736635, 6.103349>,
				<0.228381, 0.275481, 0.927930>, <1.254126, 0.803331, 2.604068>
			}
			smooth_triangle {
				<0.235716, 0.246481, 0.934229>, <2.953381, 1.736635, 6.103349>,
				<0.216867, 0.258461, 0.935569>, <0.857754, 0.509152, 1.733392>,
				<0.228381, 0.275481, 0.927930>, <1.254126, 0.803331, 2.604068>
			}
			smooth_triangle {
				<0.235716, 0.246481, 0.934229>, <2.953381, 1.736635, 6.103349>,
				<0.261336, 0.241571, 0.928684>, <2.798370, 1.702960, 6.185457>,
				<0.248436, 0.225751, 0.936180>, <2.068160, 1.136971, 4.407406>
			}
			smooth_triangle {
				<0.261336, 0.241571, 0.928684>, <2.798370, 1.702960, 6.185457>,
				<0.266635, 0.215831, 0.933506>, <2.787143, 1.515567, 6.239061>,
				<0.248436, 0.225751, 0.936180>, <2.068160, 1.136971, 4.407406>
			}
			smooth_triangle {
				<0.266635, 0.215831, 0.933506>, <2.787143, 1.515567, 6.239061>,
				<0.261336, 0.241571, 0.928684>, <2.798370, 1.702960, 6.185457>,
				<0.274395, 0.230191, 0.927804>, <1.555485, 0.923986, 3.567154>
			}
			smooth_triangle {
				<0.261336, 0.241571, 0.928684>, <2.798370, 1.702960, 6.185457>,
				<0.281351, 0.242341, 0.922620>, <2.275385, 1.463392, 5.354957>,
				<0.274395, 0.230191, 0.927804>, <1.555485, 0.923986, 3.567154>
			}
			smooth_triangle {
				<0.266635, 0.215831, 0.933506>, <2.787143, 1.515567, 6.239061>,
				<0.274395, 0.230191, 0.927804>, <1.555485, 0.923986, 3.567154>,
				<0.288138, 0.220751, 0.925932>, <2.632976, 1.550221, 6.297317>
			}
			smooth_triangle {
				<0.274395, 0.230191, 0.927804>, <1.555485, 0.923986, 3.567154>,
				<0.281351, 0.242341, 0.922620>, <2.275385, 1.463392, 5.354957>,
				<0.288138, 0.220751, 0.925932>, <2.632976, 1.550221, 6.297317>
			}
			smooth_triangle {
				<0.288138, 0.220751, 0.925932>, <2.632976, 1.550221, 6.297317>,
				<0.301240, 0.200952, 0.926269>, <2.203346, 1.213931, 5.446689>,
				<0.282505, 0.197211, 0.932956>, <2.312653, 1.192030, 5.405958>
			}
			smooth_triangle {
				<0.282505, 0.197211, 0.932956>, <2.312653, 1.192030, 5.405958>,
				<0.301240, 0.200952, 0.926269>, <2.203346, 1.213931, 5.446689>,
				<0.295701, 0.180232, 0.932301>, <1.510051, 0.743208, 3.628449>
			}
			smooth_triangle {
				<0.301240, 0.200952, 0.926269>, <2.203346, 1.213931, 5.446689>,
				<0.311261, 0.185392, 0.926202>, <0.726341, 0.388094, 1.822541>,
				<0.295701, 0.180232, 0.932301>, <1.510051, 0.743208, 3.628449>
			}
			smooth_triangle {
				<0.271841, 0.262611, 0.919921>, <2.313628, 1.583784, 5.303980>,
				<0.250616, 0.266791, 0.924729>, <2.431394, 1.604881, 5.244535>,
				<0.262951, 0.284511, 0.915985>, <2.336458, 1.715150, 5.252903>
			}
			smooth_triangle {
				<0.228381, 0.275481, 0.927930>, <1.254126, 0.803331, 2.604068>,
				<0.243088, 0.289221, 0.919989>, <1.208872, 0.853764, 2.609360>,
				<0.250616, 0.266791, 0.924729>, <2.431394, 1.604881, 5.244535>
			}
			smooth_triangle {
				<0.250616, 0.266791, 0.924729>, <2.431394, 1.604881, 5.244535>,
				<0.243088, 0.289221, 0.919989>, <1.208872, 0.853764, 2.609360>,
				<0.262951, 0.284511, 0.915985>, <2.336458, 1.715150, 5.252903>
			}
			smooth_triangle {
				<0.311261, 0.185392, 0.926202>, <0.726341, 0.388094, 1.822541>,
				<0.301240, 0.200952, 0.926269>, <2.203346, 1.213931, 5.446689>,
				<0.319480, 0.202532, 0.919802>, <1.062009, 0.621317, 2.735927>
			}
			smooth_triangle {
				<0.262951, 0.284511, 0.915985>, <2.336458, 1.715150, 5.252903>,
				<0.282864, 0.280321, 0.911324>, <2.227154, 1.690825, 5.308040>,
				<0.271841, 0.262611, 0.919921>, <2.313628, 1.583784, 5.303980>
			}
			smooth_triangle {
				<0.282864, 0.280321, 0.911324>, <2.227154, 1.690825, 5.308040>,
				<0.291636, 0.259432, 0.914746>, <2.199356, 1.565289, 5.357880>,
				<0.271841, 0.262611, 0.919921>, <2.313628, 1.583784, 5.303980>
			}
			smooth_triangle {
				<0.319480, 0.202532, 0.919802>, <1.062009, 0.621317, 2.735927>,
				<0.301240, 0.200952, 0.926269>, <2.203346, 1.213931, 5.446689>,
				<0.310103, 0.218982, 0.919237>, <2.133680, 1.322682, 5.449056>
			}
			smooth_triangle {
				<0.301240, 0.200952, 0.926269>, <2.203346, 1.213931, 5.446689>,
				<0.288138, 0.220751, 0.925932>, <2.632976, 1.550221, 6.297317>,
				<0.310103, 0.218982, 0.919237>, <2.133680, 1.322682, 5.449056>
			}
			smooth_triangle {
				<0.271841, 0.262611, 0.919921>, <2.313628, 1.583784, 5.303980>,
				<0.291636, 0.259432, 0.914746>, <2.199356, 1.565289, 5.357880>,
				<0.281351, 0.242341, 0.922620>, <2.275385, 1.463392, 5.354957>
			}
			smooth_triangle {
				<0.291636, 0.259432, 0.914746>, <2.199356, 1.565289, 5.357880>,
				<0.300403, 0.238892, 0.917494>, <2.170404, 1.439611, 5.404746>,
				<0.281351, 0.242341, 0.922620>, <2.275385, 1.463392, 5.354957>
			}
			smooth_triangle {
				<0.310103, 0.218982, 0.919237>, <2.133680, 1.322682, 5.449056>,
				<0.288138, 0.220751, 0.925932>, <2.632976, 1.550221, 6.297317>,
				<0.300403, 0.238892, 0.917494>, <2.170404, 1.439611, 5.404746>
			}
			smooth_triangle {
				<0.288138, 0.220751, 0.925932>, <2.632976, 1.550221, 6.297317>,
				<0.281351, 0.242341, 0.922620>, <2.275385, 1.463392, 5.354957>,
				<0.300403, 0.238892, 0.917494>, <2.170404, 1.439611, 5.404746>
			}
			smooth_triangle {
				<0.216867, 0.258461, 0.935569>, <0.857754, 0.509152, 1.733392>,
				<0.235716, 0.246481, 0.934229>, <2.953381, 1.736635, 6.103349>,
				<0.212930, 0.236391, 0.942280>, <1.307637, 0.708445, 2.605252>
			}
			smooth_triangle {
				<0.282505, 0.197211, 0.932956>, <2.312653, 1.192030, 5.405958>,
				<0.264008, 0.190001, 0.939849>, <2.424427, 1.147339, 5.366477>,
				<0.266635, 0.215831, 0.933506>, <2.787143, 1.515567, 6.239061>
			}
			smooth_triangle {
				<0.246285, 0.181851, 0.946248>, <1.251950, 0.567834, 2.666299>,
				<0.226700, 0.193001, 0.948936>, <1.292415, 0.609616, 2.637708>,
				<0.247216, 0.204491, 0.941368>, <2.508375, 1.232564, 5.308721>
			}
			smooth_triangle {
				<0.247216, 0.204491, 0.941368>, <2.508375, 1.232564, 5.308721>,
				<0.226700, 0.193001, 0.948936>, <1.292415, 0.609616, 2.637708>,
				<0.231081, 0.219791, 0.942022>, <2.584744, 1.327137, 5.248869>
			}
			smooth_triangle {
				<0.226700, 0.193001, 0.948936>, <1.292415, 0.609616, 2.637708>,
				<0.215295, 0.211971, 0.947540>, <0.877032, 0.433616, 1.744242>,
				<0.231081, 0.219791, 0.942022>, <2.584744, 1.327137, 5.248869>
			}
			smooth_triangle {
				<0.215295, 0.211971, 0.947540>, <0.877032, 0.433616, 1.744242>,
				<0.212930, 0.236391, 0.942280>, <1.307637, 0.708445, 2.605252>,
				<0.231081, 0.219791, 0.942022>, <2.584744, 1.327137, 5.248869>
			}
			smooth_triangle {
				<0.247216, 0.204491, 0.941368>, <2.508375, 1.232564, 5.308721>,
				<0.231081, 0.219791, 0.942022>, <2.584744, 1.327137, 5.248869>,
				<0.248436, 0.225751, 0.936180>, <2.068160, 1.136971, 4.407406>
			}
			smooth_triangle {
				<0.212930, 0.236391, 0.942280>, <1.307637, 0.708445, 2.605252>,
				<0.235716, 0.246481, 0.934229>, <2.953381, 1.736635, 6.103349>,
				<0.231081, 0.219791, 0.942022>, <2.584744, 1.327137, 5.248869>
			}
			smooth_triangle {
				<0.231081, 0.219791, 0.942022>, <2.584744, 1.327137, 5.248869>,
				<0.235716, 0.246481, 0.934229>, <2.953381, 1.736635, 6.103349>,
				<0.248436, 0.225751, 0.936180>, <2.068160, 1.136971, 4.407406>
			}
			smooth_triangle {
				<0.246285, 0.181851, 0.946248>, <1.251950, 0.567834, 2.666299>,
				<0.247216, 0.204491, 0.941368>, <2.508375, 1.232564, 5.308721>,
				<0.264008, 0.190001, 0.939849>, <2.424427, 1.147339, 5.366477>
			}
			smooth_triangle {
				<0.248436, 0.225751, 0.936180>, <2.068160, 1.136971, 4.407406>,
				<0.266635, 0.215831, 0.933506>, <2.787143, 1.515567, 6.239061>,
				<0.247216, 0.204491, 0.941368>, <2.508375, 1.232564, 5.308721>
			}
			smooth_triangle {
				<0.247216, 0.204491, 0.941368>, <2.508375, 1.232564, 5.308721>,
				<0.266635, 0.215831, 0.933506>, <2.787143, 1.515567, 6.239061>,
				<0.264008, 0.190001, 0.939849>, <2.424427, 1.147339, 5.366477>
			}
			smooth_triangle {
				<0.246285, 0.181851, 0.946248>, <1.251950, 0.567834, 2.666299>,
				<0.264008, 0.190001, 0.939849>, <2.424427, 1.147339, 5.366477>,
				<0.262191, 0.165111, 0.945042>, <1.211912, 0.522453, 2.694000>
			}
			smooth_triangle {
				<0.264008, 0.190001, 0.939849>, <2.424427, 1.147339, 5.366477>,
				<0.282505, 0.197211, 0.932956>, <2.312653, 1.192030, 5.405958>,
				<0.279014, 0.174821, 0.938457>, <2.352656, 1.056375, 5.416995>
			}
			smooth_triangle {
				<0.282505, 0.197211, 0.932956>, <2.312653, 1.192030, 5.405958>,
				<0.295701, 0.180232, 0.932301>, <1.510051, 0.743208, 3.628449>,
				<0.279014, 0.174821, 0.938457>, <2.352656, 1.056375, 5.416995>
			}
			smooth_triangle {
				<0.295701, 0.180232, 0.932301>, <1.510051, 0.743208, 3.628449>,
				<0.288649, 0.160941, 0.938022>, <0.773636, 0.338463, 1.812946>,
				<0.279014, 0.174821, 0.938457>, <2.352656, 1.056375, 5.416995>
			}
			smooth_triangle {
				<0.264008, 0.190001, 0.939849>, <2.424427, 1.147339, 5.366477>,
				<0.279014, 0.174821, 0.938457>, <2.352656, 1.056375, 5.416995>,
				<0.262191, 0.165111, 0.945042>, <1.211912, 0.522453, 2.694000>
			}
			smooth_triangle {
				<0.288649, 0.160941, 0.938022>, <0.773636, 0.338463, 1.812946>,
				<0.280872, 0.154881, 0.941402>, <0.789840, 0.331318, 1.807301>,
				<0.279014, 0.174821, 0.938457>, <2.352656, 1.056375, 5.416995>
			}
			smooth_triangle {
				<0.279014, 0.174821, 0.938457>, <2.352656, 1.056375, 5.416995>,
				<0.280872, 0.154881, 0.941402>, <0.789840, 0.331318, 1.807301>,
				<0.262191, 0.165111, 0.945042>, <1.211912, 0.522453, 2.694000>
			}
			smooth_triangle {
				<0.254571, 0.305531, 0.911568>, <1.164286, 0.905809, 2.612115>,
				<0.265527, 0.321891, 0.902766>, <1.497299, 1.294420, 3.475683>,
				<0.274430, 0.301791, 0.907045>, <2.247730, 1.820770, 5.256056>
			}
			smooth_triangle {
				<0.282864, 0.280321, 0.911324>, <2.227154, 1.690825, 5.308040>,
				<0.262951, 0.284511, 0.915985>, <2.336458, 1.715150, 5.252903>,
				<0.274430, 0.301791, 0.907045>, <2.247730, 1.820770, 5.256056>
			}
			smooth_triangle {
				<0.243088, 0.289221, 0.919989>, <1.208872, 0.853764, 2.609360>,
				<0.254571, 0.305531, 0.911568>, <1.164286, 0.905809, 2.612115>,
				<0.262951, 0.284511, 0.915985>, <2.336458, 1.715150, 5.252903>
			}
			smooth_triangle {
				<0.488682, 0.511622, 0.698962>, <0.414209, 2.955405, 5.199518>,
				<0.446459, 0.459132, 0.760904>, <1.029965, 3.275425, 6.093771>,
				<0.440835, 0.515622, 0.727257>, <0.278020, 0.980054, 1.719905>
			}
			smooth_triangle {
				<0.440835, 0.515622, 0.727257>, <0.278020, 0.980054, 1.719905>,
				<0.446459, 0.459132, 0.760904>, <1.029965, 3.275425, 6.093771>,
				<0.376936, 0.517442, 0.761111>, <0.807531, 1.953990, 3.393785>
			}
			smooth_triangle {
				<0.376936, 0.517442, 0.761111>, <0.807531, 1.953990, 3.393785>,
				<0.345423, 0.456212, 0.813428>, <1.818999, 3.254865, 5.917284>,
				<0.322422, 0.516032, 0.786686>, <0.530630, 0.976014, 1.661844>
			}
			smooth_triangle {
				<0.322422, 0.516032, 0.786686>, <0.530630, 0.976014, 1.661844>,
				<0.345423, 0.456212, 0.813428>, <1.818999, 3.254865, 5.917284>,
				<0.260292, 0.511342, 0.812333>, <1.622088, 2.374826, 4.087964>
			}
			smooth_triangle {
				<0.260292, 0.511342, 0.812333>, <1.622088, 2.374826, 4.087964>,
				<0.202859, 0.458331, 0.859011>, <3.141533, 3.718771, 6.340112>,
				<0.235271, 0.508571, 0.821657>, <0.711936, 0.941978, 1.613631>
			}
			smooth_triangle {
				<0.235271, 0.508571, 0.821657>, <0.711936, 0.941978, 1.613631>,
				<0.202859, 0.458331, 0.859011>, <3.141533, 3.718771, 6.340112>,
				<0.199716, 0.503781, 0.833921>, <0.772387, 0.967136, 1.570584>
			}
			smooth_triangle {
				<0.199716, 0.503781, 0.833921>, <0.772387, 0.967136, 1.570584>,
				<0.202859, 0.458331, 0.859011>, <3.141533, 3.718771, 6.340112>,
				<0.167949, 0.498671, 0.843933>, <0.834508, 0.951704, 1.548108>
			}
			smooth_triangle {
				<0.167949, 0.498671, 0.843933>, <0.834508, 0.951704, 1.548108>,
				<0.202859, 0.458331, 0.859011>, <3.141533, 3.718771, 6.340112>,
				<0.139099, 0.493371, 0.852255>, <1.820111, 1.819533, 3.058932>
			}
			smooth_triangle {
				<0.139099, 0.493371, 0.852255>, <1.820111, 1.819533, 3.058932>,
				<0.084591, 0.391581, 0.910290>, <3.990316, 3.450996, 6.007740>,
				<0.112447, 0.487931, 0.859293>, <0.942263, 0.866657, 1.536255>
			}
			smooth_triangle {
				<0.112447, 0.487931, 0.859293>, <0.942263, 0.866657, 1.536255>,
				<0.084591, 0.391581, 0.910290>, <3.990316, 3.450996, 6.007740>,
				<0.087429, 0.482331, 0.865352>, <0.987772, 0.877367, 1.501256>
			}
			smooth_triangle {
				<0.087429, 0.482331, 0.865352>, <0.987772, 0.877367, 1.501256>,
				<0.084591, 0.391581, 0.910290>, <3.990316, 3.450996, 6.007740>,
				<0.063574, 0.476561, 0.870605>, <1.030744, 0.875410, 1.473311>
			}
			smooth_triangle {
				<0.063574, 0.476561, 0.870605>, <1.030744, 0.875410, 1.473311>,
				<0.084591, 0.391581, 0.910290>, <3.990316, 3.450996, 6.007740>,
				<0.040463, 0.470581, 0.875234>, <1.072001, 0.861804, 1.451720>
			}
			smooth_triangle {
				<0.040463, 0.470581, 0.875234>, <1.072001, 0.861804, 1.451720>,
				<0.084591, 0.391581, 0.910290>, <3.990316, 3.450996, 6.007740>,
				<0.017710, 0.464301, 0.879326>, <0.546394, 0.426062, 0.721058>
			}
			smooth_triangle {
				<0.254571, 0.305531, 0.911568>, <1.164286, 0.905809, 2.612115>,
				<0.274430, 0.301791, 0.907045>, <2.247730, 1.820770, 5.256056>,
				<0.262951, 0.284511, 0.915985>, <2.336458, 1.715150, 5.252903>
			}
			smooth_triangle {
				<0.376936, 0.517442, 0.761111>, <0.581184, 1.629637, 2.449306>,
				<0.395080, 0.570622, 0.712337>, <0.922340, 3.427076, 4.831320>,
				<0.440835, 0.515622, 0.727257>, <0.370841, 1.648807, 2.477068>
			}
			smooth_triangle {
				<0.592673, 0.493943, 0.627589>, <-0.186689, 1.574824, 2.541087>,
				<0.631146, 0.546613, 0.540348>, <-0.806807, 3.275843, 4.949714>,
				<0.686742, 0.464953, 0.548916>, <-0.536403, 1.477941, 2.549555>
			}
			smooth_triangle {
				<0.686742, 0.464953, 0.548916>, <-0.536403, 1.477941, 2.549555>,
				<0.702200, 0.519763, 0.475256>, <-1.389627, 3.108689, 4.928725>,
				<0.771549, 0.424243, 0.462428>, <-0.839376, 1.403463, 2.512467>
			}
			smooth_triangle {
				<0.703494, 0.569423, 0.412268>, <-1.636402, 3.428928, 4.636102>,
				<0.705554, 0.606013, 0.352213>, <-2.175959, 4.258240, 5.106005>,
				<0.743208, 0.551173, 0.364636>, <-1.998949, 3.326451, 4.571149>
			}
			smooth_triangle {
				<0.775311, 0.562933, 0.266644>, <-1.704097, 2.263539, 2.823014>,
				<0.778189, 0.552683, 0.279424>, <-2.505491, 3.333337, 4.313189>,
				<0.764135, 0.575463, 0.272119>, <-2.464292, 3.479744, 4.219935>
			}
			smooth_triangle {
				<0.778189, 0.552683, 0.279424>, <-2.505491, 3.333337, 4.313189>,
				<0.781602, 0.538543, 0.296964>, <-2.043270, 2.706326, 3.673297>,
				<0.764259, 0.562563, 0.297562>, <-2.360544, 3.396427, 4.344847>
			}
			smooth_triangle {
				<0.705554, 0.606013, 0.352213>, <-2.175959, 4.258240, 5.106005>,
				<0.742279, 0.577803, 0.322924>, <-2.160474, 3.481524, 4.379916>,
				<0.743208, 0.551173, 0.364636>, <-1.998949, 3.326451, 4.571149>
			}
			smooth_triangle {
				<0.743208, 0.551173, 0.364636>, <-1.998949, 3.326451, 4.571149>,
				<0.742279, 0.577803, 0.322924>, <-2.160474, 3.481524, 4.379916>,
				<0.772427, 0.535133, 0.325732>, <-2.671454, 3.764484, 5.259250>
			}
			smooth_triangle {
				<0.764259, 0.562563, 0.297562>, <-2.360544, 3.396427, 4.344847>,
				<0.772427, 0.535133, 0.325732>, <-2.671454, 3.764484, 5.259250>,
				<0.742279, 0.577803, 0.322924>, <-2.160474, 3.481524, 4.379916>
			}
			smooth_triangle {
				<0.764259, 0.562563, 0.297562>, <-2.360544, 3.396427, 4.344847>,
				<0.781602, 0.538543, 0.296964>, <-2.043270, 2.706326, 3.673297>,
				<0.772427, 0.535133, 0.325732>, <-2.671454, 3.764484, 5.259250>
			}
			smooth_triangle {
				<0.778189, 0.552683, 0.279424>, <-2.505491, 3.333337, 4.313189>,
				<0.764259, 0.562563, 0.297562>, <-2.360544, 3.396427, 4.344847>,
				<0.764135, 0.575463, 0.272119>, <-2.464292, 3.479744, 4.219935>
			}
			smooth_triangle {
				<0.705554, 0.606013, 0.352213>, <-2.175959, 4.258240, 5.106005>,
				<0.718989, 0.614123, 0.308252>, <-2.128042, 3.697850, 4.216182>,
				<0.742279, 0.577803, 0.322924>, <-2.160474, 3.481524, 4.379916>
			}
			smooth_triangle {
				<0.718989, 0.614123, 0.308252>, <-2.128042, 3.697850, 4.216182>,
				<0.744321, 0.593833, 0.287165>, <-2.320297, 3.584964, 4.212623>,
				<0.742279, 0.577803, 0.322924>, <-2.160474, 3.481524, 4.379916>
			}
			smooth_triangle {
				<0.764135, 0.575463, 0.272119>, <-2.464292, 3.479744, 4.219935>,
				<0.764259, 0.562563, 0.297562>, <-2.360544, 3.396427, 4.344847>,
				<0.744321, 0.593833, 0.287165>, <-2.320297, 3.584964, 4.212623>
			}
			smooth_triangle {
				<0.764259, 0.562563, 0.297562>, <-2.360544, 3.396427, 4.344847>,
				<0.742279, 0.577803, 0.322924>, <-2.160474, 3.481524, 4.379916>,
				<0.744321, 0.593833, 0.287165>, <-2.320297, 3.584964, 4.212623>
			}
			smooth_triangle {
				<0.772427, 0.535133, 0.325732>, <-2.671454, 3.764484, 5.259250>,
				<0.781602, 0.538543, 0.296964>, <-2.043270, 2.706326, 3.673297>,
				<0.795873, 0.513803, 0.302848>, <-2.490865, 3.095337, 4.494497>
			}
			smooth_triangle {
				<0.795873, 0.513803, 0.302848>, <-2.490865, 3.095337, 4.494497>,
				<0.781602, 0.538543, 0.296964>, <-2.043270, 2.706326, 3.673297>,
				<0.795754, 0.527483, 0.278654>, <-3.026441, 3.712198, 5.103814>
			}
			smooth_triangle {
				<0.781602, 0.538543, 0.296964>, <-2.043270, 2.706326, 3.673297>,
				<0.778189, 0.552683, 0.279424>, <-2.505491, 3.333337, 4.313189>,
				<0.795754, 0.527483, 0.278654>, <-3.026441, 3.712198, 5.103814>
			}
			smooth_triangle {
				<0.795754, 0.527483, 0.278654>, <-3.026441, 3.712198, 5.103814>,
				<0.778189, 0.552683, 0.279424>, <-2.505491, 3.333337, 4.313189>,
				<0.786698, 0.548143, 0.264113>, <-1.737577, 2.201936, 2.851054>
			}
			smooth_triangle {
				<0.778189, 0.552683, 0.279424>, <-2.505491, 3.333337, 4.313189>,
				<0.775311, 0.562933, 0.266644>, <-1.704097, 2.263539, 2.823014>,
				<0.786698, 0.548143, 0.264113>, <-1.737577, 2.201936, 2.851054>
			}
			smooth_triangle {
				<0.795873, 0.513803, 0.302848>, <-2.490865, 3.095337, 4.494497>,
				<0.798897, 0.490903, 0.331483>, <-2.391047, 2.953948, 4.640021>,
				<0.772427, 0.535133, 0.325732>, <-2.671454, 3.764484, 5.259250>
			}
			smooth_triangle {
				<0.702200, 0.519763, 0.475256>, <-1.389627, 3.108689, 4.928725>,
				<0.703494, 0.569423, 0.412268>, <-1.636402, 3.428928, 4.636102>,
				<0.752381, 0.505343, 0.409482>, <-1.858845, 3.024458, 4.828825>
			}
			smooth_triangle {
				<0.703494, 0.569423, 0.412268>, <-1.636402, 3.428928, 4.636102>,
				<0.743208, 0.551173, 0.364636>, <-1.998949, 3.326451, 4.571149>,
				<0.752381, 0.505343, 0.409482>, <-1.858845, 3.024458, 4.828825>
			}
			smooth_triangle {
				<0.798897, 0.490903, 0.331483>, <-2.391047, 2.953948, 4.640021>,
				<0.775344, 0.507213, 0.361520>, <-1.803372, 2.539770, 3.907595>,
				<0.772427, 0.535133, 0.325732>, <-2.671454, 3.764484, 5.259250>
			}
			smooth_triangle {
				<0.752381, 0.505343, 0.409482>, <-1.858845, 3.024458, 4.828825>,
				<0.743208, 0.551173, 0.364636>, <-1.998949, 3.326451, 4.571149>,
				<0.775344, 0.507213, 0.361520>, <-1.803372, 2.539770, 3.907595>
			}
			smooth_triangle {
				<0.743208, 0.551173, 0.364636>, <-1.998949, 3.326451, 4.571149>,
				<0.772427, 0.535133, 0.325732>, <-2.671454, 3.764484, 5.259250>,
				<0.775344, 0.507213, 0.361520>, <-1.803372, 2.539770, 3.907595>
			}
			smooth_triangle {
				<0.702200, 0.519763, 0.475256>, <-1.389627, 3.108689, 4.928725>,
				<0.752381, 0.505343, 0.409482>, <-1.858845, 3.024458, 4.828825>,
				<0.771549, 0.424243, 0.462428>, <-0.839376, 1.403463, 2.512467>
			}
			smooth_triangle {
				<0.798897, 0.490903, 0.331483>, <-2.391047, 2.953948, 4.640021>,
				<0.804329, 0.449653, 0.374142>, <-1.450526, 1.888800, 3.211096>,
				<0.775344, 0.507213, 0.361520>, <-1.803372, 2.539770, 3.907595>
			}
			smooth_triangle {
				<0.804329, 0.449653, 0.374142>, <-1.450526, 1.888800, 3.211096>,
				<0.752381, 0.505343, 0.409482>, <-1.858845, 3.024458, 4.828825>,
				<0.775344, 0.507213, 0.361520>, <-1.803372, 2.539770, 3.907595>
			}
			smooth_triangle {
				<0.804329, 0.449653, 0.374142>, <-1.450526, 1.888800, 3.211096>,
				<0.771549, 0.424243, 0.462428>, <-0.839376, 1.403463, 2.512467>,
				<0.752381, 0.505343, 0.409482>, <-1.858845, 3.024458, 4.828825>
			}
			smooth_triangle {
				<0.786698, 0.548143, 0.264113>, <-1.737577, 2.201936, 2.851054>,
				<0.775311, 0.562933, 0.266644>, <-1.704097, 2.263539, 2.823014>,
				<0.771708, 0.575093, 0.250713>, <-1.713962, 2.325068, 2.766081>
			}
			smooth_triangle {
				<0.718989, 0.614123, 0.308252>, <-2.128042, 3.697850, 4.216182>,
				<0.723849, 0.626133, 0.270390>, <-2.291102, 3.780669, 4.054189>,
				<0.744321, 0.593833, 0.287165>, <-2.320297, 3.584964, 4.212623>
			}
			smooth_triangle {
				<0.723849, 0.626133, 0.270390>, <-2.291102, 3.780669, 4.054189>,
				<0.749131, 0.604303, 0.250442>, <-2.901433, 4.255501, 4.738153>,
				<0.744321, 0.593833, 0.287165>, <-2.320297, 3.584964, 4.212623>
			}
			smooth_triangle {
				<0.744321, 0.593833, 0.287165>, <-2.320297, 3.584964, 4.212623>,
				<0.749131, 0.604303, 0.250442>, <-2.901433, 4.255501, 4.738153>,
				<0.764135, 0.575463, 0.272119>, <-2.464292, 3.479744, 4.219935>
			}
			smooth_triangle {
				<0.749131, 0.604303, 0.250442>, <-2.901433, 4.255501, 4.738153>,
				<0.771708, 0.575093, 0.250713>, <-1.713962, 2.325068, 2.766081>,
				<0.764135, 0.575463, 0.272119>, <-2.464292, 3.479744, 4.219935>
			}
			smooth_triangle {
				<0.775311, 0.562933, 0.266644>, <-1.704097, 2.263539, 2.823014>,
				<0.764135, 0.575463, 0.272119>, <-2.464292, 3.479744, 4.219935>,
				<0.771708, 0.575093, 0.250713>, <-1.713962, 2.325068, 2.766081>
			}
			smooth_triangle {
				<0.723849, 0.626133, 0.270390>, <-2.291102, 3.780669, 4.054189>,
				<0.718989, 0.614123, 0.308252>, <-2.128042, 3.697850, 4.216182>,
				<0.696658, 0.646403, 0.293167>, <-2.082522, 3.909225, 4.044191>
			}
			smooth_triangle {
				<0.686742, 0.464953, 0.548916>, <-0.536403, 1.477941, 2.549555>,
				<0.631146, 0.546613, 0.540348>, <-0.806807, 3.275843, 4.949714>,
				<0.702200, 0.519763, 0.475256>, <-1.389627, 3.108689, 4.928725>
			}
			smooth_triangle {
				<0.631146, 0.546613, 0.540348>, <-0.806807, 3.275843, 4.949714>,
				<0.648693, 0.591793, 0.466998>, <-1.181858, 3.558948, 4.674473>,
				<0.702200, 0.519763, 0.475256>, <-1.389627, 3.108689, 4.928725>
			}
			smooth_triangle {
				<0.702200, 0.519763, 0.475256>, <-1.389627, 3.108689, 4.928725>,
				<0.648693, 0.591793, 0.466998>, <-1.181858, 3.558948, 4.674473>,
				<0.703494, 0.569423, 0.412268>, <-1.636402, 3.428928, 4.636102>
			}
			smooth_triangle {
				<0.648693, 0.591793, 0.466998>, <-1.181858, 3.558948, 4.674473>,
				<0.656746, 0.631823, 0.398233>, <-1.477588, 3.812342, 4.382523>,
				<0.703494, 0.569423, 0.412268>, <-1.636402, 3.428928, 4.636102>
			}
			smooth_triangle {
				<0.703494, 0.569423, 0.412268>, <-1.636402, 3.428928, 4.636102>,
				<0.656746, 0.631823, 0.398233>, <-1.477588, 3.812342, 4.382523>,
				<0.705554, 0.606013, 0.352213>, <-2.175959, 4.258240, 5.106005>
			}
			smooth_triangle {
				<0.656746, 0.631823, 0.398233>, <-1.477588, 3.812342, 4.382523>,
				<0.667334, 0.658143, 0.332615>, <-2.054383, 4.632544, 4.822094>,
				<0.705554, 0.606013, 0.352213>, <-2.175959, 4.258240, 5.106005>
			}
			smooth_triangle {
				<0.696658, 0.646403, 0.293167>, <-2.082522, 3.909225, 4.044191>,
				<0.718989, 0.614123, 0.308252>, <-2.128042, 3.697850, 4.216182>,
				<0.697604, 0.631603, 0.321784>, <-1.301553, 2.540966, 2.799595>
			}
			smooth_triangle {
				<0.718989, 0.614123, 0.308252>, <-2.128042, 3.697850, 4.216182>,
				<0.705554, 0.606013, 0.352213>, <-2.175959, 4.258240, 5.106005>,
				<0.697604, 0.631603, 0.321784>, <-1.301553, 2.540966, 2.799595>
			}
			smooth_triangle {
				<0.705554, 0.606013, 0.352213>, <-2.175959, 4.258240, 5.106005>,
				<0.667334, 0.658143, 0.332615>, <-2.054383, 4.632544, 4.822094>,
				<0.697604, 0.631603, 0.321784>, <-1.301553, 2.540966, 2.799595>
			}
			smooth_triangle {
				<0.696658, 0.646403, 0.293167>, <-2.082522, 3.909225, 4.044191>,
				<0.697604, 0.631603, 0.321784>, <-1.301553, 2.540966, 2.799595>,
				<0.667334, 0.658143, 0.332615>, <-2.054383, 4.632544, 4.822094>
			}
			smooth_triangle {
				<0.667334, 0.658143, 0.332615>, <-2.054383, 4.632544, 4.822094>,
				<0.656746, 0.631823, 0.398233>, <-1.477588, 3.812342, 4.382523>,
				<0.604895, 0.698093, 0.368613>, <-1.551455, 4.914196, 4.724304>
			}
			smooth_triangle {
				<0.592673, 0.493943, 0.627589>, <-0.186689, 1.574824, 2.541087>,
				<0.546681, 0.578333, 0.596472>, <-0.221453, 4.030778, 5.703950>,
				<0.631146, 0.546613, 0.540348>, <-0.806807, 3.275843, 4.949714>
			}
			smooth_triangle {
				<0.656746, 0.631823, 0.398233>, <-1.477588, 3.812342, 4.382523>,
				<0.648693, 0.591793, 0.466998>, <-1.181858, 3.558948, 4.674473>,
				<0.598216, 0.655403, 0.449095>, <-1.032502, 3.956943, 4.380716>
			}
			smooth_triangle {
				<0.648693, 0.591793, 0.466998>, <-1.181858, 3.558948, 4.674473>,
				<0.586697, 0.614373, 0.517152>, <-0.711804, 3.681639, 4.675431>,
				<0.598216, 0.655403, 0.449095>, <-1.032502, 3.956943, 4.380716>
			}
			smooth_triangle {
				<0.433817, 0.694202, 0.564800>, <0.174511, 4.193077, 4.279083>,
				<0.497482, 0.685052, 0.521847>, <-0.269898, 4.146048, 4.319847>,
				<0.483733, 0.640442, 0.587323>, <0.048603, 3.846892, 4.595457>
			}
			smooth_triangle {
				<0.598216, 0.655403, 0.449095>, <-1.032502, 3.956943, 4.380716>,
				<0.586697, 0.614373, 0.517152>, <-0.711804, 3.681639, 4.675431>,
				<0.550427, 0.663813, 0.495474>, <-0.527740, 3.344620, 3.672885>
			}
			smooth_triangle {
				<0.586697, 0.614373, 0.517152>, <-0.711804, 3.681639, 4.675431>,
				<0.534165, 0.637873, 0.544888>, <-0.289145, 3.193075, 3.831002>,
				<0.550427, 0.663813, 0.495474>, <-0.527740, 3.344620, 3.672885>
			}
			smooth_triangle {
				<0.483733, 0.640442, 0.587323>, <0.048603, 3.846892, 4.595457>,
				<0.497482, 0.685052, 0.521847>, <-0.269898, 4.146048, 4.319847>,
				<0.534165, 0.637873, 0.544888>, <-0.289145, 3.193075, 3.831002>
			}
			smooth_triangle {
				<0.534165, 0.637873, 0.544888>, <-0.289145, 3.193075, 3.831002>,
				<0.497482, 0.685052, 0.521847>, <-0.269898, 4.146048, 4.319847>,
				<0.550427, 0.663813, 0.495474>, <-0.527740, 3.344620, 3.672885>
			}
			smooth_triangle {
				<0.656746, 0.631823, 0.398233>, <-1.477588, 3.812342, 4.382523>,
				<0.598216, 0.655403, 0.449095>, <-1.032502, 3.956943, 4.380716>,
				<0.604895, 0.698093, 0.368613>, <-1.551455, 4.914196, 4.724304>
			}
			smooth_triangle {
				<0.433817, 0.694202, 0.564800>, <0.174511, 4.193077, 4.279083>,
				<0.444277, 0.742602, 0.490177>, <-0.156587, 4.484343, 3.968651>,
				<0.497482, 0.685052, 0.521847>, <-0.269898, 4.146048, 4.319847>
			}
			smooth_triangle {
				<0.444277, 0.742602, 0.490177>, <-0.156587, 4.484343, 3.968651>,
				<0.529335, 0.718582, 0.438804>, <-0.875662, 5.069556, 4.729990>,
				<0.497482, 0.685052, 0.521847>, <-0.269898, 4.146048, 4.319847>
			}
			smooth_triangle {
				<0.604895, 0.698093, 0.368613>, <-1.551455, 4.914196, 4.724304>,
				<0.598216, 0.655403, 0.449095>, <-1.032502, 3.956943, 4.380716>,
				<0.529335, 0.718582, 0.438804>, <-0.875662, 5.069556, 4.729990>
			}
			smooth_triangle {
				<0.598216, 0.655403, 0.449095>, <-1.032502, 3.956943, 4.380716>,
				<0.550427, 0.663813, 0.495474>, <-0.527740, 3.344620, 3.672885>,
				<0.529335, 0.718582, 0.438804>, <-0.875662, 5.069556, 4.729990>
			}
			smooth_triangle {
				<0.550427, 0.663813, 0.495474>, <-0.527740, 3.344620, 3.672885>,
				<0.497482, 0.685052, 0.521847>, <-0.269898, 4.146048, 4.319847>,
				<0.529335, 0.718582, 0.438804>, <-0.875662, 5.069556, 4.729990>
			}
			smooth_triangle {
				<0.483733, 0.640442, 0.587323>, <0.048603, 3.846892, 4.595457>,
				<0.534165, 0.637873, 0.544888>, <-0.289145, 3.193075, 3.831002>,
				<0.546681, 0.578333, 0.596472>, <-0.221453, 4.030778, 5.703950>
			}
			smooth_triangle {
				<0.648693, 0.591793, 0.466998>, <-1.181858, 3.558948, 4.674473>,
				<0.631146, 0.546613, 0.540348>, <-0.806807, 3.275843, 4.949714>,
				<0.586697, 0.614373, 0.517152>, <-0.711804, 3.681639, 4.675431>
			}
			smooth_triangle {
				<0.631146, 0.546613, 0.540348>, <-0.806807, 3.275843, 4.949714>,
				<0.546681, 0.578333, 0.596472>, <-0.221453, 4.030778, 5.703950>,
				<0.586697, 0.614373, 0.517152>, <-0.711804, 3.681639, 4.675431>
			}
			smooth_triangle {
				<0.534165, 0.637873, 0.544888>, <-0.289145, 3.193075, 3.831002>,
				<0.586697, 0.614373, 0.517152>, <-0.711804, 3.681639, 4.675431>,
				<0.546681, 0.578333, 0.596472>, <-0.221453, 4.030778, 5.703950>
			}
			smooth_triangle {
				<0.433817, 0.694202, 0.564800>, <0.174511, 4.193077, 4.279083>,
				<0.483733, 0.640442, 0.587323>, <0.048603, 3.846892, 4.595457>,
				<0.421827, 0.648872, 0.624610>, <0.452648, 3.904713, 4.526377>
			}
			smooth_triangle {
				<0.592673, 0.493943, 0.627589>, <-0.186689, 1.574824, 2.541087>,
				<0.488682, 0.511622, 0.698962>, <0.126147, 1.637455, 2.507546>,
				<0.546681, 0.578333, 0.596472>, <-0.221453, 4.030778, 5.703950>
			}
			smooth_triangle {
				<0.440835, 0.515622, 0.727257>, <0.370841, 1.648807, 2.477068>,
				<0.395080, 0.570622, 0.712337>, <0.922340, 3.427076, 4.831320>,
				<0.459273, 0.585372, 0.659948>, <0.496064, 4.093740, 5.644700>
			}
			smooth_triangle {
				<0.395080, 0.570622, 0.712337>, <0.922340, 3.427076, 4.831320>,
				<0.399223, 0.616222, 0.670821>, <0.620884, 3.089646, 3.877180>,
				<0.459273, 0.585372, 0.659948>, <0.496064, 4.093740, 5.644700>
			}
			smooth_triangle {
				<0.483733, 0.640442, 0.587323>, <0.048603, 3.846892, 4.595457>,
				<0.459273, 0.585372, 0.659948>, <0.496064, 4.093740, 5.644700>,
				<0.421827, 0.648872, 0.624610>, <0.452648, 3.904713, 4.526377>
			}
			smooth_triangle {
				<0.399223, 0.616222, 0.670821>, <0.620884, 3.089646, 3.877180>,
				<0.421827, 0.648872, 0.624610>, <0.452648, 3.904713, 4.526377>,
				<0.459273, 0.585372, 0.659948>, <0.496064, 4.093740, 5.644700>
			}
			smooth_triangle {
				<0.440835, 0.515622, 0.727257>, <0.370841, 1.648807, 2.477068>,
				<0.459273, 0.585372, 0.659948>, <0.496064, 4.093740, 5.644700>,
				<0.488682, 0.511622, 0.698962>, <0.126147, 1.637455, 2.507546>
			}
			smooth_triangle {
				<0.483733, 0.640442, 0.587323>, <0.048603, 3.846892, 4.595457>,
				<0.546681, 0.578333, 0.596472>, <-0.221453, 4.030778, 5.703950>,
				<0.459273, 0.585372, 0.659948>, <0.496064, 4.093740, 5.644700>
			}
			smooth_triangle {
				<0.459273, 0.585372, 0.659948>, <0.496064, 4.093740, 5.644700>,
				<0.546681, 0.578333, 0.596472>, <-0.221453, 4.030778, 5.703950>,
				<0.488682, 0.511622, 0.698962>, <0.126147, 1.637455, 2.507546>
			}
			smooth_triangle {
				<0.444277, 0.742602, 0.490177>, <-0.156587, 4.484343, 3.968651>,
				<0.433817, 0.694202, 0.564800>, <0.174511, 4.193077, 4.279083>,
				<0.364128, 0.744362, 0.549951>, <0.515783, 5.246204, 4.590281>
			}
			smooth_triangle {
				<0.376936, 0.517442, 0.761111>, <0.581184, 1.629637, 2.449306>,
				<0.338158, 0.565572, 0.744906>, <1.320449, 3.409232, 4.752162>,
				<0.395080, 0.570622, 0.712337>, <0.922340, 3.427076, 4.831320>
			}
			smooth_triangle {
				<0.192110, 0.771531, 0.597444>, <1.405560, 4.665107, 3.491752>,
				<0.271679, 0.755352, 0.587149>, <1.169590, 5.317054, 4.386142>,
				<0.219596, 0.733621, 0.634586>, <1.191487, 3.688894, 3.152022>
			}
			smooth_triangle {
				<0.433817, 0.694202, 0.564800>, <0.174511, 4.193077, 4.279083>,
				<0.383264, 0.690882, 0.604073>, <0.471326, 3.480116, 3.553119>,
				<0.364128, 0.744362, 0.549951>, <0.515783, 5.246204, 4.590281>
			}
			smooth_triangle {
				<0.326802, 0.703042, 0.622940>, <0.905556, 4.252527, 4.126030>,
				<0.262555, 0.701572, 0.654201>, <1.311809, 4.227753, 4.042422>,
				<0.271679, 0.755352, 0.587149>, <1.169590, 5.317054, 4.386142>
			}
			smooth_triangle {
				<0.262555, 0.701572, 0.654201>, <1.311809, 4.227753, 4.042422>,
				<0.219596, 0.733621, 0.634586>, <1.191487, 3.688894, 3.152022>,
				<0.271679, 0.755352, 0.587149>, <1.169590, 5.317054, 4.386142>
			}
			smooth_triangle {
				<0.271679, 0.755352, 0.587149>, <1.169590, 5.317054, 4.386142>,
				<0.364128, 0.744362, 0.549951>, <0.515783, 5.246204, 4.590281>,
				<0.326802, 0.703042, 0.622940>, <0.905556, 4.252527, 4.126030>
			}
			smooth_triangle {
				<0.326802, 0.703042, 0.622940>, <0.905556, 4.252527, 4.126030>,
				<0.364128, 0.744362, 0.549951>, <0.515783, 5.246204, 4.590281>,
				<0.383264, 0.690882, 0.604073>, <0.471326, 3.480116, 3.553119>
			}
			smooth_triangle {
				<0.262555, 0.701572, 0.654201>, <1.311809, 4.227753, 4.042422>,
				<0.326802, 0.703042, 0.622940>, <0.905556, 4.252527, 4.126030>,
				<0.307816, 0.657452, 0.679796>, <1.217421, 3.966861, 4.327014>
			}
			smooth_triangle {
				<0.433817, 0.694202, 0.564800>, <0.174511, 4.193077, 4.279083>,
				<0.421827, 0.648872, 0.624610>, <0.452648, 3.904713, 4.526377>,
				<0.383264, 0.690882, 0.604073>, <0.471326, 3.480116, 3.553119>
			}
			smooth_triangle {
				<0.421827, 0.648872, 0.624610>, <0.452648, 3.904713, 4.526377>,
				<0.365635, 0.656392, 0.651593>, <0.842509, 3.960732, 4.422028>,
				<0.383264, 0.690882, 0.604073>, <0.471326, 3.480116, 3.553119>
			}
			smooth_triangle {
				<0.307816, 0.657452, 0.679796>, <1.217421, 3.966861, 4.327014>,
				<0.326802, 0.703042, 0.622940>, <0.905556, 4.252527, 4.126030>,
				<0.365635, 0.656392, 0.651593>, <0.842509, 3.960732, 4.422028>
			}
			smooth_triangle {
				<0.326802, 0.703042, 0.622940>, <0.905556, 4.252527, 4.126030>,
				<0.383264, 0.690882, 0.604073>, <0.471326, 3.480116, 3.553119>,
				<0.365635, 0.656392, 0.651593>, <0.842509, 3.960732, 4.422028>
			}
			smooth_triangle {
				<0.192110, 0.771531, 0.597444>, <1.405560, 4.665107, 3.491752>,
				<0.219596, 0.733621, 0.634586>, <1.191487, 3.688894, 3.152022>,
				<0.166512, 0.735261, 0.648674>, <1.747802, 4.431594, 3.641406>
			}
			smooth_triangle {
				<0.307816, 0.657452, 0.679796>, <1.217421, 3.966861, 4.327014>,
				<0.242422, 0.651481, 0.711276>, <1.892155, 4.583957, 4.932850>,
				<0.262555, 0.701572, 0.654201>, <1.311809, 4.227753, 4.042422>
			}
			smooth_triangle {
				<0.242422, 0.651481, 0.711276>, <1.892155, 4.583957, 4.932850>,
				<0.202837, 0.697601, 0.679208>, <1.692851, 4.202439, 3.927439>,
				<0.262555, 0.701572, 0.654201>, <1.311809, 4.227753, 4.042422>
			}
			smooth_triangle {
				<0.166512, 0.735261, 0.648674>, <1.747802, 4.431594, 3.641406>,
				<0.219596, 0.733621, 0.634586>, <1.191487, 3.688894, 3.152022>,
				<0.202837, 0.697601, 0.679208>, <1.692851, 4.202439, 3.927439>
			}
			smooth_triangle {
				<0.219596, 0.733621, 0.634586>, <1.191487, 3.688894, 3.152022>,
				<0.262555, 0.701572, 0.654201>, <1.311809, 4.227753, 4.042422>,
				<0.202837, 0.697601, 0.679208>, <1.692851, 4.202439, 3.927439>
			}
			smooth_triangle {
				<0.242422, 0.651481, 0.711276>, <1.892155, 4.583957, 4.932850>,
				<0.307816, 0.657452, 0.679796>, <1.217421, 3.966861, 4.327014>,
				<0.294460, 0.608652, 0.729343>, <1.467436, 3.674056, 4.504920>
			}
			smooth_triangle {
				<0.421827, 0.648872, 0.624610>, <0.452648, 3.904713, 4.526377>,
				<0.399223, 0.616222, 0.670821>, <0.620884, 3.089646, 3.877180>,
				<0.365635, 0.656392, 0.651593>, <0.842509, 3.960732, 4.422028>
			}
			smooth_triangle {
				<0.399223, 0.616222, 0.670821>, <0.620884, 3.089646, 3.877180>,
				<0.350730, 0.613812, 0.699528>, <1.096922, 3.700532, 4.588395>,
				<0.365635, 0.656392, 0.651593>, <0.842509, 3.960732, 4.422028>
			}
			smooth_triangle {
				<0.294460, 0.608652, 0.729343>, <1.467436, 3.674056, 4.504920>,
				<0.307816, 0.657452, 0.679796>, <1.217421, 3.966861, 4.327014>,
				<0.350730, 0.613812, 0.699528>, <1.096922, 3.700532, 4.588395>
			}
			smooth_triangle {
				<0.307816, 0.657452, 0.679796>, <1.217421, 3.966861, 4.327014>,
				<0.365635, 0.656392, 0.651593>, <0.842509, 3.960732, 4.422028>,
				<0.350730, 0.613812, 0.699528>, <1.096922, 3.700532, 4.588395>
			}
			smooth_triangle {
				<0.294460, 0.608652, 0.729343>, <1.467436, 3.674056, 4.504920>,
				<0.350730, 0.613812, 0.699528>, <1.096922, 3.700532, 4.588395>,
				<0.338158, 0.565572, 0.744906>, <1.320449, 3.409232, 4.752162>
			}
			smooth_triangle {
				<0.399223, 0.616222, 0.670821>, <0.620884, 3.089646, 3.877180>,
				<0.395080, 0.570622, 0.712337>, <0.922340, 3.427076, 4.831320>,
				<0.350730, 0.613812, 0.699528>, <1.096922, 3.700532, 4.588395>
			}
			smooth_triangle {
				<0.350730, 0.613812, 0.699528>, <1.096922, 3.700532, 4.588395>,
				<0.395080, 0.570622, 0.712337>, <0.922340, 3.427076, 4.831320>,
				<0.338158, 0.565572, 0.744906>, <1.320449, 3.409232, 4.752162>
			}
			smooth_triangle {
				<0.166512, 0.735261, 0.648674>, <1.747802, 4.431594, 3.641406>,
				<0.202837, 0.697601, 0.679208>, <1.692851, 4.202439, 3.927439>,
				<0.140842, 0.695321, 0.696988>, <2.381688, 4.900395, 4.388268>
			}
			smooth_triangle {
				<0.376936, 0.517442, 0.761111>, <0.581184, 1.629637, 2.449306>,
				<0.322422, 0.516032, 0.786686>, <0.770016, 1.617984, 2.404629>,
				<0.338158, 0.565572, 0.744906>, <1.320449, 3.409232, 4.752162>
			}
			smooth_triangle {
				<0.322422, 0.516032, 0.786686>, <0.770016, 1.617984, 2.404629>,
				<0.285573, 0.558932, 0.771460>, <1.671744, 3.367068, 4.671410>,
				<0.338158, 0.565572, 0.744906>, <1.320449, 3.409232, 4.752162>
			}
			smooth_triangle {
				<0.140842, 0.695321, 0.696988>, <2.381688, 4.900395, 4.388268>,
				<0.202837, 0.697601, 0.679208>, <1.692851, 4.202439, 3.927439>,
				<0.182603, 0.660111, 0.721133>, <1.939633, 3.990183, 4.034787>
			}
			smooth_triangle {
				<0.202837, 0.697601, 0.679208>, <1.692851, 4.202439, 3.927439>,
				<0.242422, 0.651481, 0.711276>, <1.892155, 4.583957, 4.932850>,
				<0.182603, 0.660111, 0.721133>, <1.939633, 3.990183, 4.034787>
			}
			smooth_triangle {
				<0.338158, 0.565572, 0.744906>, <1.320449, 3.409232, 4.752162>,
				<0.285573, 0.558932, 0.771460>, <1.671744, 3.367068, 4.671410>,
				<0.294460, 0.608652, 0.729343>, <1.467436, 3.674056, 4.504920>
			}
			smooth_triangle {
				<0.285573, 0.558932, 0.771460>, <1.671744, 3.367068, 4.671410>,
				<0.238527, 0.596101, 0.759529>, <2.125227, 4.196975, 5.178260>,
				<0.294460, 0.608652, 0.729343>, <1.467436, 3.674056, 4.504920>
			}
			smooth_triangle {
				<0.182603, 0.660111, 0.721133>, <1.939633, 3.990183, 4.034787>,
				<0.242422, 0.651481, 0.711276>, <1.892155, 4.583957, 4.932850>,
				<0.204326, 0.627671, 0.743895>, <1.600445, 3.157995, 3.527662>
			}
			smooth_triangle {
				<0.238527, 0.596101, 0.759529>, <2.125227, 4.196975, 5.178260>,
				<0.242422, 0.651481, 0.711276>, <1.892155, 4.583957, 4.932850>,
				<0.294460, 0.608652, 0.729343>, <1.467436, 3.674056, 4.504920>
			}
			smooth_triangle {
				<0.238527, 0.596101, 0.759529>, <2.125227, 4.196975, 5.178260>,
				<0.204326, 0.627671, 0.743895>, <1.600445, 3.157995, 3.527662>,
				<0.242422, 0.651481, 0.711276>, <1.892155, 4.583957, 4.932850>
			}
			smooth_triangle {
				<0.140842, 0.695321, 0.696988>, <2.381688, 4.900395, 4.388268>,
				<0.182603, 0.660111, 0.721133>, <1.939633, 3.990183, 4.034787>,
				<0.139038, 0.655801, 0.734649>, <2.188132, 3.964975, 3.933004>
			}
			smooth_triangle {
				<0.322422, 0.516032, 0.786686>, <0.770016, 1.617984, 2.404629>,
				<0.260292, 0.511342, 0.812333>, <0.927766, 1.599524, 2.361572>,
				<0.285573, 0.558932, 0.771460>, <1.671744, 3.367068, 4.671410>
			}
			smooth_triangle {
				<0.260292, 0.511342, 0.812333>, <0.927766, 1.599524, 2.361572>,
				<0.241536, 0.547881, 0.794104>, <1.955933, 3.306426, 4.605609>,
				<0.285573, 0.558932, 0.771460>, <1.671744, 3.367068, 4.671410>
			}
			smooth_triangle {
				<0.139038, 0.655801, 0.734649>, <2.188132, 3.964975, 3.933004>,
				<0.182603, 0.660111, 0.721133>, <1.939633, 3.990183, 4.034787>,
				<0.164560, 0.626931, 0.754314>, <2.511962, 4.419116, 4.809986>
			}
			smooth_triangle {
				<0.182603, 0.660111, 0.721133>, <1.939633, 3.990183, 4.034787>,
				<0.204326, 0.627671, 0.743895>, <1.600445, 3.157995, 3.527662>,
				<0.164560, 0.626931, 0.754314>, <2.511962, 4.419116, 4.809986>
			}
			smooth_triangle {
				<0.285573, 0.558932, 0.771460>, <1.671744, 3.367068, 4.671410>,
				<0.241536, 0.547881, 0.794104>, <1.955933, 3.306426, 4.605609>,
				<0.238527, 0.596101, 0.759529>, <2.125227, 4.196975, 5.178260>
			}
			smooth_triangle {
				<0.241536, 0.547881, 0.794104>, <1.955933, 3.306426, 4.605609>,
				<0.206299, 0.570111, 0.788374>, <2.086907, 3.438006, 4.450254>,
				<0.238527, 0.596101, 0.759529>, <2.125227, 4.196975, 5.178260>
			}
			smooth_triangle {
				<0.164560, 0.626931, 0.754314>, <2.511962, 4.419116, 4.809986>,
				<0.204326, 0.627671, 0.743895>, <1.600445, 3.157995, 3.527662>,
				<0.192472, 0.600311, 0.769220>, <2.080184, 3.624708, 4.302968>
			}
			smooth_triangle {
				<0.192472, 0.600311, 0.769220>, <2.080184, 3.624708, 4.302968>,
				<0.238527, 0.596101, 0.759529>, <2.125227, 4.196975, 5.178260>,
				<0.206299, 0.570111, 0.788374>, <2.086907, 3.438006, 4.450254>
			}
			smooth_triangle {
				<0.192472, 0.600311, 0.769220>, <2.080184, 3.624708, 4.302968>,
				<0.204326, 0.627671, 0.743895>, <1.600445, 3.157995, 3.527662>,
				<0.238527, 0.596101, 0.759529>, <2.125227, 4.196975, 5.178260>
			}
			smooth_triangle {
				<0.192110, 0.771531, 0.597444>, <1.405560, 4.665107, 3.491752>,
				<0.166512, 0.735261, 0.648674>, <1.747802, 4.431594, 3.641406>,
				<0.134291, 0.768251, 0.617136>, <1.473520, 3.867822, 2.798403>
			}
			smooth_triangle {
				<0.139038, 0.655801, 0.734649>, <2.188132, 3.964975, 3.933004>,
				<0.103925, 0.670751, 0.726920>, <2.326499, 4.058375, 3.754307>,
				<0.140842, 0.695321, 0.696988>, <2.381688, 4.900395, 4.388268>
			}
			smooth_triangle {
				<0.134291, 0.768251, 0.617136>, <1.473520, 3.867822, 2.798403>,
				<0.166512, 0.735261, 0.648674>, <1.747802, 4.431594, 3.641406>,
				<0.107252, 0.737221, 0.658871>, <2.059662, 4.446651, 3.454867>
			}
			smooth_triangle {
				<0.166512, 0.735261, 0.648674>, <1.747802, 4.431594, 3.641406>,
				<0.140842, 0.695321, 0.696988>, <2.381688, 4.900395, 4.388268>,
				<0.107252, 0.737221, 0.658871>, <2.059662, 4.446651, 3.454867>
			}
			smooth_triangle {
				<0.107252, 0.737221, 0.658871>, <2.059662, 4.446651, 3.454867>,
				<0.140842, 0.695321, 0.696988>, <2.381688, 4.900395, 4.388268>,
				<0.081829, 0.701571, 0.700151>, <2.328351, 4.240703, 3.543741>
			}
			smooth_triangle {
				<0.140842, 0.695321, 0.696988>, <2.381688, 4.900395, 4.388268>,
				<0.103925, 0.670751, 0.726920>, <2.326499, 4.058375, 3.754307>,
				<0.081829, 0.701571, 0.700151>, <2.328351, 4.240703, 3.543741>
			}
			smooth_triangle {
				<0.081829, 0.701571, 0.700151>, <2.328351, 4.240703, 3.543741>,
				<0.103925, 0.670751, 0.726920>, <2.326499, 4.058375, 3.754307>,
				<0.064635, 0.671771, 0.730517>, <2.524298, 4.063373, 3.619022>
			}
			smooth_triangle {
				<0.260292, 0.511342, 0.812333>, <0.927766, 1.599524, 2.361572>,
				<0.235271, 0.508571, 0.821657>, <1.046870, 1.583697, 2.322507>,
				<0.241536, 0.547881, 0.794104>, <1.955933, 3.306426, 4.605609>
			}
			smooth_triangle {
				<0.139038, 0.655801, 0.734649>, <2.188132, 3.964975, 3.933004>,
				<0.164560, 0.626931, 0.754314>, <2.511962, 4.419116, 4.809986>,
				<0.129679, 0.630891, 0.757814>, <2.330325, 3.809543, 4.005668>
			}
			smooth_triangle {
				<0.235271, 0.508571, 0.821657>, <1.046870, 1.583697, 2.322507>,
				<0.199716, 0.503781, 0.833921>, <1.148081, 1.559120, 2.291056>,
				<0.206304, 0.536391, 0.811684>, <2.187046, 3.234033, 4.554050>
			}
			smooth_triangle {
				<0.199716, 0.503781, 0.833921>, <1.148081, 1.559120, 2.291056>,
				<0.175137, 0.528371, 0.824169>, <2.383294, 3.185147, 4.490032>,
				<0.206304, 0.536391, 0.811684>, <2.187046, 3.234033, 4.554050>
			}
			smooth_triangle {
				<0.118640, 0.611751, 0.775119>, <2.456220, 3.691625, 4.041089>,
				<0.133922, 0.592331, 0.787607>, <2.833196, 4.167777, 4.857061>,
				<0.110745, 0.594691, 0.789419>, <2.548736, 3.592171, 4.073634>
			}
			smooth_triangle {
				<0.206304, 0.536391, 0.811684>, <2.187046, 3.234033, 4.554050>,
				<0.175137, 0.528371, 0.824169>, <2.383294, 3.185147, 4.490032>,
				<0.179097, 0.556901, 0.804293>, <2.288022, 3.354601, 4.415769>
			}
			smooth_triangle {
				<0.175137, 0.528371, 0.824169>, <2.383294, 3.185147, 4.490032>,
				<0.151657, 0.549711, 0.814825>, <2.457054, 3.314459, 4.354875>,
				<0.179097, 0.556901, 0.804293>, <2.288022, 3.354601, 4.415769>
			}
			smooth_triangle {
				<0.179097, 0.556901, 0.804293>, <2.288022, 3.354601, 4.415769>,
				<0.151657, 0.549711, 0.814825>, <2.457054, 3.314459, 4.354875>,
				<0.155700, 0.574711, 0.796603>, <2.371088, 3.465362, 4.284709>
			}
			smooth_triangle {
				<0.151657, 0.549711, 0.814825>, <2.457054, 3.314459, 4.354875>,
				<0.128820, 0.569461, 0.805126>, <2.941596, 4.002474, 4.931068>,
				<0.155700, 0.574711, 0.796603>, <2.371088, 3.465362, 4.284709>
			}
			smooth_triangle {
				<0.155700, 0.574711, 0.796603>, <2.371088, 3.465362, 4.284709>,
				<0.128820, 0.569461, 0.805126>, <2.941596, 4.002474, 4.931068>,
				<0.133922, 0.592331, 0.787607>, <2.833196, 4.167777, 4.857061>
			}
			smooth_triangle {
				<0.133922, 0.592331, 0.787607>, <2.833196, 4.167777, 4.857061>,
				<0.128820, 0.569461, 0.805126>, <2.941596, 4.002474, 4.931068>,
				<0.120310, 0.583931, 0.796027>, <1.683744, 2.347232, 2.766423>
			}
			smooth_triangle {
				<0.128820, 0.569461, 0.805126>, <2.941596, 4.002474, 4.931068>,
				<0.107693, 0.578871, 0.801510>, <2.613721, 3.489731, 4.121267>,
				<0.120310, 0.583931, 0.796027>, <1.683744, 2.347232, 2.766423>
			}
			smooth_triangle {
				<0.133922, 0.592331, 0.787607>, <2.833196, 4.167777, 4.857061>,
				<0.120310, 0.583931, 0.796027>, <1.683744, 2.347232, 2.766423>,
				<0.110745, 0.594691, 0.789419>, <2.548736, 3.592171, 4.073634>
			}
			smooth_triangle {
				<0.120310, 0.583931, 0.796027>, <1.683744, 2.347232, 2.766423>,
				<0.107693, 0.578871, 0.801510>, <2.613721, 3.489731, 4.121267>,
				<0.110745, 0.594691, 0.789419>, <2.548736, 3.592171, 4.073634>
			}
			smooth_triangle {
				<0.235271, 0.508571, 0.821657>, <1.046870, 1.583697, 2.322507>,
				<0.206304, 0.536391, 0.811684>, <2.187046, 3.234033, 4.554050>,
				<0.241536, 0.547881, 0.794104>, <1.955933, 3.306426, 4.605609>
			}
			smooth_triangle {
				<0.241536, 0.547881, 0.794104>, <1.955933, 3.306426, 4.605609>,
				<0.206304, 0.536391, 0.811684>, <2.187046, 3.234033, 4.554050>,
				<0.206299, 0.570111, 0.788374>, <2.086907, 3.438006, 4.450254>
			}
			smooth_triangle {
				<0.206304, 0.536391, 0.811684>, <2.187046, 3.234033, 4.554050>,
				<0.179097, 0.556901, 0.804293>, <2.288022, 3.354601, 4.415769>,
				<0.206299, 0.570111, 0.788374>, <2.086907, 3.438006, 4.450254>
			}
			smooth_triangle {
				<0.133922, 0.592331, 0.787607>, <2.833196, 4.167777, 4.857061>,
				<0.161289, 0.598081, 0.778076>, <2.265929, 3.611213, 4.220530>,
				<0.155700, 0.574711, 0.796603>, <2.371088, 3.465362, 4.284709>
			}
			smooth_triangle {
				<0.179097, 0.556901, 0.804293>, <2.288022, 3.354601, 4.415769>,
				<0.155700, 0.574711, 0.796603>, <2.371088, 3.465362, 4.284709>,
				<0.179030, 0.580281, 0.787614>, <1.851915, 2.916538, 3.613379>
			}
			smooth_triangle {
				<0.155700, 0.574711, 0.796603>, <2.371088, 3.465362, 4.284709>,
				<0.161289, 0.598081, 0.778076>, <2.265929, 3.611213, 4.220530>,
				<0.179030, 0.580281, 0.787614>, <1.851915, 2.916538, 3.613379>
			}
			smooth_triangle {
				<0.161289, 0.598081, 0.778076>, <2.265929, 3.611213, 4.220530>,
				<0.192472, 0.600311, 0.769220>, <2.080184, 3.624708, 4.302968>,
				<0.179030, 0.580281, 0.787614>, <1.851915, 2.916538, 3.613379>
			}
			smooth_triangle {
				<0.179097, 0.556901, 0.804293>, <2.288022, 3.354601, 4.415769>,
				<0.179030, 0.580281, 0.787614>, <1.851915, 2.916538, 3.613379>,
				<0.206299, 0.570111, 0.788374>, <2.086907, 3.438006, 4.450254>
			}
			smooth_triangle {
				<0.179030, 0.580281, 0.787614>, <1.851915, 2.916538, 3.613379>,
				<0.192472, 0.600311, 0.769220>, <2.080184, 3.624708, 4.302968>,
				<0.206299, 0.570111, 0.788374>, <2.086907, 3.438006, 4.450254>
			}
			smooth_triangle {
				<0.192472, 0.600311, 0.769220>, <2.080184, 3.624708, 4.302968>,
				<0.161289, 0.598081, 0.778076>, <2.265929, 3.611213, 4.220530>,
				<0.164560, 0.626931, 0.754314>, <2.511962, 4.419116, 4.809986>
			}
			smooth_triangle {
				<0.161289, 0.598081, 0.778076>, <2.265929, 3.611213, 4.220530>,
				<0.133922, 0.592331, 0.787607>, <2.833196, 4.167777, 4.857061>,
				<0.141663, 0.612231, 0.770851>, <1.939797, 3.078710, 3.428105>
			}
			smooth_triangle {
				<0.133922, 0.592331, 0.787607>, <2.833196, 4.167777, 4.857061>,
				<0.118640, 0.611751, 0.775119>, <2.456220, 3.691625, 4.041089>,
				<0.141663, 0.612231, 0.770851>, <1.939797, 3.078710, 3.428105>
			}
			smooth_triangle {
				<0.118640, 0.611751, 0.775119>, <2.456220, 3.691625, 4.041089>,
				<0.129679, 0.630891, 0.757814>, <2.330325, 3.809543, 4.005668>,
				<0.141663, 0.612231, 0.770851>, <1.939797, 3.078710, 3.428105>
			}
			smooth_triangle {
				<0.161289, 0.598081, 0.778076>, <2.265929, 3.611213, 4.220530>,
				<0.141663, 0.612231, 0.770851>, <1.939797, 3.078710, 3.428105>,
				<0.164560, 0.626931, 0.754314>, <2.511962, 4.419116, 4.809986>
			}
			smooth_triangle {
				<0.141663, 0.612231, 0.770851>, <1.939797, 3.078710, 3.428105>,
				<0.129679, 0.630891, 0.757814>, <2.330325, 3.809543, 4.005668>,
				<0.164560, 0.626931, 0.754314>, <2.511962, 4.419116, 4.809986>
			}
			smooth_triangle {
				<0.107693, 0.578871, 0.801510>, <2.613721, 3.489731, 4.121267>,
				<0.090055, 0.590731, 0.795006>, <2.666690, 3.566195, 4.020510>,
				<0.110745, 0.594691, 0.789419>, <2.548736, 3.592171, 4.073634>
			}
			smooth_triangle {
				<0.139038, 0.655801, 0.734649>, <2.188132, 3.964975, 3.933004>,
				<0.129679, 0.630891, 0.757814>, <2.330325, 3.809543, 4.005668>,
				<0.111904, 0.647491, 0.746556>, <1.977995, 3.258582, 3.234388>
			}
			smooth_triangle {
				<0.049502, 0.626861, 0.770526>, <1.353217, 1.908676, 1.877488>,
				<0.072546, 0.626561, 0.768943>, <3.079632, 4.413092, 4.475213>,
				<0.056272, 0.617071, 0.777925>, <1.364844, 1.857341, 1.919974>
			}
			smooth_triangle {
				<0.118640, 0.611751, 0.775119>, <2.456220, 3.691625, 4.041089>,
				<0.093696, 0.609761, 0.780084>, <2.593106, 3.680530, 3.964949>,
				<0.101912, 0.629531, 0.763164>, <2.490308, 3.798508, 3.919188>
			}
			smooth_triangle {
				<0.101912, 0.629531, 0.763164>, <2.490308, 3.798508, 3.919188>,
				<0.093696, 0.609761, 0.780084>, <2.593106, 3.680530, 3.964949>,
				<0.072546, 0.626561, 0.768943>, <3.079632, 4.413092, 4.475213>
			}
			smooth_triangle {
				<0.093696, 0.609761, 0.780084>, <2.593106, 3.680530, 3.964949>,
				<0.068129, 0.603951, 0.787217>, <3.189967, 4.250476, 4.554904>,
				<0.072546, 0.626561, 0.768943>, <3.079632, 4.413092, 4.475213>
			}
			smooth_triangle {
				<0.068129, 0.603951, 0.787217>, <3.189967, 4.250476, 4.554904>,
				<0.056272, 0.617071, 0.777925>, <1.364844, 1.857341, 1.919974>,
				<0.072546, 0.626561, 0.768943>, <3.079632, 4.413092, 4.475213>
			}
			smooth_triangle {
				<0.068129, 0.603951, 0.787217>, <3.189967, 4.250476, 4.554904>,
				<0.093696, 0.609761, 0.780084>, <2.593106, 3.680530, 3.964949>,
				<0.090055, 0.590731, 0.795006>, <2.666690, 3.566195, 4.020510>
			}
			smooth_triangle {
				<0.118640, 0.611751, 0.775119>, <2.456220, 3.691625, 4.041089>,
				<0.110745, 0.594691, 0.789419>, <2.548736, 3.592171, 4.073634>,
				<0.093696, 0.609761, 0.780084>, <2.593106, 3.680530, 3.964949>
			}
			smooth_triangle {
				<0.093696, 0.609761, 0.780084>, <2.593106, 3.680530, 3.964949>,
				<0.110745, 0.594691, 0.789419>, <2.548736, 3.592171, 4.073634>,
				<0.090055, 0.590731, 0.795006>, <2.666690, 3.566195, 4.020510>
			}
			smooth_triangle {
				<0.101912, 0.629531, 0.763164>, <2.490308, 3.798508, 3.919188>,
				<0.072546, 0.626561, 0.768943>, <3.079632, 4.413092, 4.475213>,
				<0.084748, 0.649191, 0.748652>, <2.512280, 3.919947, 3.782816>
			}
			smooth_triangle {
				<0.049502, 0.626861, 0.770526>, <1.353217, 1.908676, 1.877488>,
				<0.053328, 0.647041, 0.753399>, <3.108976, 4.557361, 4.307102>,
				<0.072546, 0.626561, 0.768943>, <3.079632, 4.413092, 4.475213>
			}
			smooth_triangle {
				<0.072546, 0.626561, 0.768943>, <3.079632, 4.413092, 4.475213>,
				<0.053328, 0.647041, 0.753399>, <3.108976, 4.557361, 4.307102>,
				<0.084748, 0.649191, 0.748652>, <2.512280, 3.919947, 3.782816>
			}
			smooth_triangle {
				<0.118640, 0.611751, 0.775119>, <2.456220, 3.691625, 4.041089>,
				<0.101912, 0.629531, 0.763164>, <2.490308, 3.798508, 3.919188>,
				<0.129679, 0.630891, 0.757814>, <2.330325, 3.809543, 4.005668>
			}
			smooth_triangle {
				<0.084748, 0.649191, 0.748652>, <2.512280, 3.919947, 3.782816>,
				<0.111904, 0.647491, 0.746556>, <1.977995, 3.258582, 3.234388>,
				<0.101912, 0.629531, 0.763164>, <2.490308, 3.798508, 3.919188>
			}
			smooth_triangle {
				<0.101912, 0.629531, 0.763164>, <2.490308, 3.798508, 3.919188>,
				<0.111904, 0.647491, 0.746556>, <1.977995, 3.258582, 3.234388>,
				<0.129679, 0.630891, 0.757814>, <2.330325, 3.809543, 4.005668>
			}
			smooth_triangle {
				<0.139038, 0.655801, 0.734649>, <2.188132, 3.964975, 3.933004>,
				<0.111904, 0.647491, 0.746556>, <1.977995, 3.258582, 3.234388>,
				<0.103925, 0.670751, 0.726920>, <2.326499, 4.058375, 3.754307>
			}
			smooth_triangle {
				<0.053328, 0.647041, 0.753399>, <3.108976, 4.557361, 4.307102>,
				<0.064635, 0.671771, 0.730517>, <2.524298, 4.063373, 3.619022>,
				<0.084748, 0.649191, 0.748652>, <2.512280, 3.919947, 3.782816>
			}
			smooth_triangle {
				<0.064635, 0.671771, 0.730517>, <2.524298, 4.063373, 3.619022>,
				<0.103925, 0.670751, 0.726920>, <2.326499, 4.058375, 3.754307>,
				<0.084748, 0.649191, 0.748652>, <2.512280, 3.919947, 3.782816>
			}
			smooth_triangle {
				<0.111904, 0.647491, 0.746556>, <1.977995, 3.258582, 3.234388>,
				<0.084748, 0.649191, 0.748652>, <2.512280, 3.919947, 3.782816>,
				<0.103925, 0.670751, 0.726920>, <2.326499, 4.058375, 3.754307>
			}
			smooth_triangle {
				<0.134291, 0.768251, 0.617136>, <1.473520, 3.867822, 2.798403>,
				<0.132552, 0.810561, 0.560831>, <1.554667, 4.911388, 3.055921>,
				<0.192110, 0.771531, 0.597444>, <1.405560, 4.665107, 3.491752>
			}
			smooth_triangle {
				<0.376798, 0.850442, 0.351966>, <-0.153109, 2.495881, 1.651813>,
				<0.453475, 0.833852, 0.296920>, <-0.446163, 2.441345, 1.681534>,
				<0.454845, 0.790472, 0.396719>, <-0.567881, 4.758981, 3.590383>
			}
			smooth_triangle {
				<0.628012, 0.726093, 0.259820>, <-2.201079, 5.112113, 4.238963>,
				<0.633765, 0.700973, 0.310003>, <-1.429490, 3.518277, 3.247614>,
				<0.596704, 0.733893, 0.307342>, <-1.278059, 3.694048, 3.111171>
			}
			smooth_triangle {
				<0.454845, 0.790472, 0.396719>, <-0.567881, 4.758981, 3.590383>,
				<0.535396, 0.769132, 0.333005>, <-1.338718, 5.408744, 4.218441>,
				<0.529335, 0.718582, 0.438804>, <-0.875662, 5.069556, 4.729990>
			}
			smooth_triangle {
				<0.529335, 0.718582, 0.438804>, <-0.875662, 5.069556, 4.729990>,
				<0.535396, 0.769132, 0.333005>, <-1.338718, 5.408744, 4.218441>,
				<0.604895, 0.698093, 0.368613>, <-1.551455, 4.914196, 4.724304>
			}
			smooth_triangle {
				<0.596704, 0.733893, 0.307342>, <-1.278059, 3.694048, 3.111171>,
				<0.604895, 0.698093, 0.368613>, <-1.551455, 4.914196, 4.724304>,
				<0.535396, 0.769132, 0.333005>, <-1.338718, 5.408744, 4.218441>
			}
			smooth_triangle {
				<0.596704, 0.733893, 0.307342>, <-1.278059, 3.694048, 3.111171>,
				<0.633765, 0.700973, 0.310003>, <-1.429490, 3.518277, 3.247614>,
				<0.604895, 0.698093, 0.368613>, <-1.551455, 4.914196, 4.724304>
			}
			smooth_triangle {
				<0.628012, 0.726093, 0.259820>, <-2.201079, 5.112113, 4.238963>,
				<0.596704, 0.733893, 0.307342>, <-1.278059, 3.694048, 3.111171>,
				<0.575164, 0.768013, 0.261635>, <-1.621484, 4.638801, 3.433955>
			}
			smooth_triangle {
				<0.454845, 0.790472, 0.396719>, <-0.567881, 4.758981, 3.590383>,
				<0.453475, 0.833852, 0.296920>, <-0.446163, 2.441345, 1.681534>,
				<0.535396, 0.769132, 0.333005>, <-1.338718, 5.408744, 4.218441>
			}
			smooth_triangle {
				<0.453475, 0.833852, 0.296920>, <-0.446163, 2.441345, 1.681534>,
				<0.513481, 0.814972, 0.247522>, <-0.683691, 2.398446, 1.664481>,
				<0.535396, 0.769132, 0.333005>, <-1.338718, 5.408744, 4.218441>
			}
			smooth_triangle {
				<0.513481, 0.814972, 0.247522>, <-0.683691, 2.398446, 1.664481>,
				<0.575164, 0.768013, 0.261635>, <-1.621484, 4.638801, 3.433955>,
				<0.535396, 0.769132, 0.333005>, <-1.338718, 5.408744, 4.218441>
			}
			smooth_triangle {
				<0.596704, 0.733893, 0.307342>, <-1.278059, 3.694048, 3.111171>,
				<0.535396, 0.769132, 0.333005>, <-1.338718, 5.408744, 4.218441>,
				<0.575164, 0.768013, 0.261635>, <-1.621484, 4.638801, 3.433955>
			}
			smooth_triangle {
				<0.604895, 0.698093, 0.368613>, <-1.551455, 4.914196, 4.724304>,
				<0.633765, 0.700973, 0.310003>, <-1.429490, 3.518277, 3.247614>,
				<0.667334, 0.658143, 0.332615>, <-2.054383, 4.632544, 4.822094>
			}
			smooth_triangle {
				<0.628012, 0.726093, 0.259820>, <-2.201079, 5.112113, 4.238963>,
				<0.666686, 0.683253, 0.278933>, <-1.995502, 4.122961, 3.870845>,
				<0.633765, 0.700973, 0.310003>, <-1.429490, 3.518277, 3.247614>
			}
			smooth_triangle {
				<0.633765, 0.700973, 0.310003>, <-1.429490, 3.518277, 3.247614>,
				<0.666686, 0.683253, 0.278933>, <-1.995502, 4.122961, 3.870845>,
				<0.667334, 0.658143, 0.332615>, <-2.054383, 4.632544, 4.822094>
			}
			smooth_triangle {
				<0.666686, 0.683253, 0.278933>, <-1.995502, 4.122961, 3.870845>,
				<0.628012, 0.726093, 0.259820>, <-2.201079, 5.112113, 4.238963>,
				<0.667166, 0.700693, 0.230282>, <-2.184355, 4.221656, 3.657294>
			}
			smooth_triangle {
				<0.513481, 0.814972, 0.247522>, <-0.683691, 2.398446, 1.664481>,
				<0.560921, 0.795592, 0.203746>, <-0.891077, 2.359748, 1.622012>,
				<0.575164, 0.768013, 0.261635>, <-1.621484, 4.638801, 3.433955>
			}
			smooth_triangle {
				<0.560921, 0.795592, 0.203746>, <-0.891077, 2.359748, 1.622012>,
				<0.607516, 0.757913, 0.213536>, <-1.963445, 4.576505, 3.341235>,
				<0.575164, 0.768013, 0.261635>, <-1.621484, 4.638801, 3.433955>
			}
			smooth_triangle {
				<0.667166, 0.700693, 0.230282>, <-2.184355, 4.221656, 3.657294>,
				<0.628012, 0.726093, 0.259820>, <-2.201079, 5.112113, 4.238963>,
				<0.641271, 0.729683, 0.213174>, <-1.772719, 3.668655, 2.894857>
			}
			smooth_triangle {
				<0.575164, 0.768013, 0.261635>, <-1.621484, 4.638801, 3.433955>,
				<0.607516, 0.757913, 0.213536>, <-1.963445, 4.576505, 3.341235>,
				<0.628012, 0.726093, 0.259820>, <-2.201079, 5.112113, 4.238963>
			}
			smooth_triangle {
				<0.628012, 0.726093, 0.259820>, <-2.201079, 5.112113, 4.238963>,
				<0.607516, 0.757913, 0.213536>, <-1.963445, 4.576505, 3.341235>,
				<0.641271, 0.729683, 0.213174>, <-1.772719, 3.668655, 2.894857>
			}
			smooth_triangle {
				<0.667166, 0.700693, 0.230282>, <-2.184355, 4.221656, 3.657294>,
				<0.641271, 0.729683, 0.213174>, <-1.772719, 3.668655, 2.894857>,
				<0.665577, 0.715303, 0.185638>, <-2.357253, 4.312314, 3.438534>
			}
			smooth_triangle {
				<0.560921, 0.795592, 0.203746>, <-0.891077, 2.359748, 1.622012>,
				<0.599047, 0.776563, 0.164940>, <-1.055369, 2.312480, 1.591769>,
				<0.607516, 0.757913, 0.213536>, <-1.963445, 4.576505, 3.341235>
			}
			smooth_triangle {
				<0.599047, 0.776563, 0.164940>, <-1.055369, 2.312480, 1.591769>,
				<0.634828, 0.745223, 0.175332>, <-2.250975, 4.498809, 3.266232>,
				<0.607516, 0.757913, 0.213536>, <-1.963445, 4.576505, 3.341235>
			}
			smooth_triangle {
				<0.665577, 0.715303, 0.185638>, <-2.357253, 4.312314, 3.438534>,
				<0.641271, 0.729683, 0.213174>, <-1.772719, 3.668655, 2.894857>,
				<0.634828, 0.745223, 0.175332>, <-2.250975, 4.498809, 3.266232>
			}
			smooth_triangle {
				<0.641271, 0.729683, 0.213174>, <-1.772719, 3.668655, 2.894857>,
				<0.607516, 0.757913, 0.213536>, <-1.963445, 4.576505, 3.341235>,
				<0.634828, 0.745223, 0.175332>, <-2.250975, 4.498809, 3.266232>
			}
			smooth_triangle {
				<0.667334, 0.658143, 0.332615>, <-2.054383, 4.632544, 4.822094>,
				<0.666686, 0.683253, 0.278933>, <-1.995502, 4.122961, 3.870845>,
				<0.696658, 0.646403, 0.293167>, <-2.082522, 3.909225, 4.044191>
			}
			smooth_triangle {
				<0.665577, 0.715303, 0.185638>, <-2.357253, 4.312314, 3.438534>,
				<0.695079, 0.683453, 0.197134>, <-2.442837, 4.121903, 3.607780>,
				<0.667166, 0.700693, 0.230282>, <-2.184355, 4.221656, 3.657294>
			}
			smooth_triangle {
				<0.666686, 0.683253, 0.278933>, <-1.995502, 4.122961, 3.870845>,
				<0.701162, 0.661493, 0.244769>, <-2.663347, 4.662040, 4.487048>,
				<0.696658, 0.646403, 0.293167>, <-2.082522, 3.909225, 4.044191>
			}
			smooth_triangle {
				<0.696658, 0.646403, 0.293167>, <-2.082522, 3.909225, 4.044191>,
				<0.701162, 0.661493, 0.244769>, <-2.663347, 4.662040, 4.487048>,
				<0.723849, 0.626133, 0.270390>, <-2.291102, 3.780669, 4.054189>
			}
			smooth_triangle {
				<0.701162, 0.661493, 0.244769>, <-2.663347, 4.662040, 4.487048>,
				<0.729082, 0.633633, 0.236770>, <-2.037724, 3.187633, 3.267057>,
				<0.723849, 0.626133, 0.270390>, <-2.291102, 3.780669, 4.054189>
			}
			smooth_triangle {
				<0.723849, 0.626133, 0.270390>, <-2.291102, 3.780669, 4.054189>,
				<0.729082, 0.633633, 0.236770>, <-2.037724, 3.187633, 3.267057>,
				<0.749131, 0.604303, 0.250442>, <-2.901433, 4.255501, 4.738153>
			}
			smooth_triangle {
				<0.729082, 0.633633, 0.236770>, <-2.037724, 3.187633, 3.267057>,
				<0.745467, 0.622923, 0.212970>, <-2.614320, 3.764149, 3.870435>,
				<0.749131, 0.604303, 0.250442>, <-2.901433, 4.255501, 4.738153>
			}
			smooth_triangle {
				<0.745467, 0.622923, 0.212970>, <-2.614320, 3.764149, 3.870435>,
				<0.761552, 0.600073, 0.221482>, <-1.306193, 1.824986, 1.990113>,
				<0.749131, 0.604303, 0.250442>, <-2.901433, 4.255501, 4.738153>
			}
			smooth_triangle {
				<0.761552, 0.600073, 0.221482>, <-1.306193, 1.824986, 1.990113>,
				<0.771708, 0.575093, 0.250713>, <-1.713962, 2.325068, 2.766081>,
				<0.749131, 0.604303, 0.250442>, <-2.901433, 4.255501, 4.738153>
			}
			smooth_triangle {
				<0.745467, 0.622923, 0.212970>, <-2.614320, 3.764149, 3.870435>,
				<0.729082, 0.633633, 0.236770>, <-2.037724, 3.187633, 3.267057>,
				<0.723355, 0.651233, 0.204385>, <-2.548008, 3.934070, 3.742727>
			}
			smooth_triangle {
				<0.666686, 0.683253, 0.278933>, <-1.995502, 4.122961, 3.870845>,
				<0.667166, 0.700693, 0.230282>, <-2.184355, 4.221656, 3.657294>,
				<0.701162, 0.661493, 0.244769>, <-2.663347, 4.662040, 4.487048>
			}
			smooth_triangle {
				<0.695079, 0.683453, 0.197134>, <-2.442837, 4.121903, 3.607780>,
				<0.701162, 0.661493, 0.244769>, <-2.663347, 4.662040, 4.487048>,
				<0.667166, 0.700693, 0.230282>, <-2.184355, 4.221656, 3.657294>
			}
			smooth_triangle {
				<0.701162, 0.661493, 0.244769>, <-2.663347, 4.662040, 4.487048>,
				<0.723355, 0.651233, 0.204385>, <-2.548008, 3.934070, 3.742727>,
				<0.729082, 0.633633, 0.236770>, <-2.037724, 3.187633, 3.267057>
			}
			smooth_triangle {
				<0.701162, 0.661493, 0.244769>, <-2.663347, 4.662040, 4.487048>,
				<0.695079, 0.683453, 0.197134>, <-2.442837, 4.121903, 3.607780>,
				<0.723355, 0.651233, 0.204385>, <-2.548008, 3.934070, 3.742727>
			}
			smooth_triangle {
				<0.529335, 0.718582, 0.438804>, <-0.875662, 5.069556, 4.729990>,
				<0.444277, 0.742602, 0.490177>, <-0.156587, 4.484343, 3.968651>,
				<0.454845, 0.790472, 0.396719>, <-0.567881, 4.758981, 3.590383>
			}
			smooth_triangle {
				<0.454845, 0.790472, 0.396719>, <-0.567881, 4.758981, 3.590383>,
				<0.444277, 0.742602, 0.490177>, <-0.156587, 4.484343, 3.968651>,
				<0.372825, 0.802392, 0.454185>, <0.035348, 4.837125, 3.530234>
			}
			smooth_triangle {
				<0.444277, 0.742602, 0.490177>, <-0.156587, 4.484343, 3.968651>,
				<0.364128, 0.744362, 0.549951>, <0.515783, 5.246204, 4.590281>,
				<0.372825, 0.802392, 0.454185>, <0.035348, 4.837125, 3.530234>
			}
			smooth_triangle {
				<0.132552, 0.810561, 0.560831>, <1.554667, 4.911388, 3.055921>,
				<0.224272, 0.814011, 0.525550>, <0.985727, 4.919202, 3.270923>,
				<0.192110, 0.771531, 0.597444>, <1.405560, 4.665107, 3.491752>
			}
			smooth_triangle {
				<0.372825, 0.802392, 0.454185>, <0.035348, 4.837125, 3.530234>,
				<0.364128, 0.744362, 0.549951>, <0.515783, 5.246204, 4.590281>,
				<0.304026, 0.799072, 0.508103>, <0.467460, 4.018950, 2.922137>
			}
			smooth_triangle {
				<0.364128, 0.744362, 0.549951>, <0.515783, 5.246204, 4.590281>,
				<0.271679, 0.755352, 0.587149>, <1.169590, 5.317054, 4.386142>,
				<0.304026, 0.799072, 0.508103>, <0.467460, 4.018950, 2.922137>
			}
			smooth_triangle {
				<0.192110, 0.771531, 0.597444>, <1.405560, 4.665107, 3.491752>,
				<0.224272, 0.814011, 0.525550>, <0.985727, 4.919202, 3.270923>,
				<0.271679, 0.755352, 0.587149>, <1.169590, 5.317054, 4.386142>
			}
			smooth_triangle {
				<0.271679, 0.755352, 0.587149>, <1.169590, 5.317054, 4.386142>,
				<0.224272, 0.814011, 0.525550>, <0.985727, 4.919202, 3.270923>,
				<0.304026, 0.799072, 0.508103>, <0.467460, 4.018950, 2.922137>
			}
			smooth_triangle {
				<0.454845, 0.790472, 0.396719>, <-0.567881, 4.758981, 3.590383>,
				<0.372825, 0.802392, 0.454185>, <0.035348, 4.837125, 3.530234>,
				<0.376798, 0.850442, 0.351966>, <-0.153109, 2.495881, 1.651813>
			}
			smooth_triangle {
				<0.132552, 0.810561, 0.560831>, <1.554667, 4.911388, 3.055921>,
				<0.156859, 0.862011, 0.470569>, <0.588794, 2.545611, 1.461998>,
				<0.224272, 0.814011, 0.525550>, <0.985727, 4.919202, 3.270923>
			}
			smooth_triangle {
				<0.156859, 0.862011, 0.470569>, <0.588794, 2.545611, 1.461998>,
				<0.278961, 0.861492, 0.411243>, <0.278065, 3.372940, 2.122043>,
				<0.224272, 0.814011, 0.525550>, <0.985727, 4.919202, 3.270923>
			}
			smooth_triangle {
				<0.376798, 0.850442, 0.351966>, <-0.153109, 2.495881, 1.651813>,
				<0.372825, 0.802392, 0.454185>, <0.035348, 4.837125, 3.530234>,
				<0.278961, 0.861492, 0.411243>, <0.278065, 3.372940, 2.122043>
			}
			smooth_triangle {
				<0.372825, 0.802392, 0.454185>, <0.035348, 4.837125, 3.530234>,
				<0.304026, 0.799072, 0.508103>, <0.467460, 4.018950, 2.922137>,
				<0.278961, 0.861492, 0.411243>, <0.278065, 3.372940, 2.122043>
			}
			smooth_triangle {
				<0.304026, 0.799072, 0.508103>, <0.467460, 4.018950, 2.922137>,
				<0.224272, 0.814011, 0.525550>, <0.985727, 4.919202, 3.270923>,
				<0.278961, 0.861492, 0.411243>, <0.278065, 3.372940, 2.122043>
			}
			smooth_triangle {
				<-0.146132, 0.810480, 0.557575>, <0.916485, 1.604267, 0.756739>,
				<0.012032, 0.846221, 0.522385>, <1.740575, 4.132123, 2.188913>,
				<-0.087877, 0.774690, 0.617447>, <2.772269, 4.702427, 2.461098>
			}
			smooth_triangle {
				<0.156859, 0.862011, 0.470569>, <0.588794, 2.545611, 1.461998>,
				<0.132552, 0.810561, 0.560831>, <1.554667, 4.911388, 3.055921>,
				<0.012032, 0.846221, 0.522385>, <1.740575, 4.132123, 2.188913>
			}
			smooth_triangle {
				<0.107252, 0.737221, 0.658871>, <2.059662, 4.446651, 3.454867>,
				<0.081829, 0.701571, 0.700151>, <2.328351, 4.240703, 3.543741>,
				<0.047184, 0.734851, 0.668494>, <2.361195, 4.440761, 3.264116>
			}
			smooth_triangle {
				<-0.032298, 0.727380, 0.677476>, <2.311272, 3.662452, 2.494834>,
				<0.002352, 0.724971, 0.680826>, <2.177176, 3.648444, 2.631740>,
				<-0.022699, 0.701420, 0.704706>, <2.834145, 4.233396, 3.165876>
			}
			smooth_triangle {
				<0.047184, 0.734851, 0.668494>, <2.361195, 4.440761, 3.264116>,
				<0.026335, 0.693461, 0.712410>, <3.503608, 5.589943, 4.519734>,
				<0.002352, 0.724971, 0.680826>, <2.177176, 3.648444, 2.631740>
			}
			smooth_triangle {
				<0.002352, 0.724971, 0.680826>, <2.177176, 3.648444, 2.631740>,
				<0.026335, 0.693461, 0.712410>, <3.503608, 5.589943, 4.519734>,
				<-0.022699, 0.701420, 0.704706>, <2.834145, 4.233396, 3.165876>
			}
			smooth_triangle {
				<-0.022699, 0.701420, 0.704706>, <2.834145, 4.233396, 3.165876>,
				<0.026335, 0.693461, 0.712410>, <3.503608, 5.589943, 4.519734>,
				<-0.012691, 0.677040, 0.728409>, <2.878442, 4.092903, 3.308516>
			}
			smooth_triangle {
				<0.026335, 0.693461, 0.712410>, <3.503608, 5.589943, 4.519734>,
				<0.012213, 0.663491, 0.740773>, <3.274863, 4.681918, 4.042392>,
				<-0.012691, 0.677040, 0.728409>, <2.878442, 4.092903, 3.308516>
			}
			smooth_triangle {
				<0.012213, 0.663491, 0.740773>, <3.274863, 4.681918, 4.042392>,
				<-0.011093, 0.662290, 0.741858>, <1.952686, 2.666786, 2.252024>,
				<-0.012691, 0.677040, 0.728409>, <2.878442, 4.092903, 3.308516>
			}
			smooth_triangle {
				<0.012213, 0.663491, 0.740773>, <3.274863, 4.681918, 4.042392>,
				<0.026335, 0.693461, 0.712410>, <3.503608, 5.589943, 4.519734>,
				<0.037359, 0.665671, 0.737962>, <2.231271, 3.356059, 2.957984>
			}
			smooth_triangle {
				<0.047184, 0.734851, 0.668494>, <2.361195, 4.440761, 3.264116>,
				<0.081829, 0.701571, 0.700151>, <2.328351, 4.240703, 3.543741>,
				<0.026335, 0.693461, 0.712410>, <3.503608, 5.589943, 4.519734>
			}
			smooth_triangle {
				<0.081829, 0.701571, 0.700151>, <2.328351, 4.240703, 3.543741>,
				<0.064635, 0.671771, 0.730517>, <2.524298, 4.063373, 3.619022>,
				<0.026335, 0.693461, 0.712410>, <3.503608, 5.589943, 4.519734>
			}
			smooth_triangle {
				<0.026335, 0.693461, 0.712410>, <3.503608, 5.589943, 4.519734>,
				<0.064635, 0.671771, 0.730517>, <2.524298, 4.063373, 3.619022>,
				<0.037359, 0.665671, 0.737962>, <2.231271, 3.356059, 2.957984>
			}
			smooth_triangle {
				<0.134291, 0.768251, 0.617136>, <1.473520, 3.867822, 2.798403>,
				<0.107252, 0.737221, 0.658871>, <2.059662, 4.446651, 3.454867>,
				<0.071435, 0.779671, 0.613277>, <2.051176, 4.724058, 3.062173>
			}
			smooth_triangle {
				<0.107252, 0.737221, 0.658871>, <2.059662, 4.446651, 3.454867>,
				<0.047184, 0.734851, 0.668494>, <2.361195, 4.440761, 3.264116>,
				<0.071435, 0.779671, 0.613277>, <2.051176, 4.724058, 3.062173>
			}
			smooth_triangle {
				<-0.063448, 0.739620, 0.661853>, <2.379525, 3.729191, 2.323548>,
				<-0.006950, 0.763751, 0.636977>, <2.887087, 5.414701, 3.349796>,
				<-0.032298, 0.727380, 0.677476>, <2.311272, 3.662452, 2.494834>
			}
			smooth_triangle {
				<0.071435, 0.779671, 0.613277>, <2.051176, 4.724058, 3.062173>,
				<0.047184, 0.734851, 0.668494>, <2.361195, 4.440761, 3.264116>,
				<-0.006950, 0.763751, 0.636977>, <2.887087, 5.414701, 3.349796>
			}
			smooth_triangle {
				<0.047184, 0.734851, 0.668494>, <2.361195, 4.440761, 3.264116>,
				<0.002352, 0.724971, 0.680826>, <2.177176, 3.648444, 2.631740>,
				<-0.006950, 0.763751, 0.636977>, <2.887087, 5.414701, 3.349796>
			}
			smooth_triangle {
				<0.002352, 0.724971, 0.680826>, <2.177176, 3.648444, 2.631740>,
				<-0.032298, 0.727380, 0.677476>, <2.311272, 3.662452, 2.494834>,
				<-0.006950, 0.763751, 0.636977>, <2.887087, 5.414701, 3.349796>
			}
			smooth_triangle {
				<-0.087877, 0.774690, 0.617447>, <2.772269, 4.702427, 2.461098>,
				<-0.006950, 0.763751, 0.636977>, <2.887087, 5.414701, 3.349796>,
				<-0.063448, 0.739620, 0.661853>, <2.379525, 3.729191, 2.323548>
			}
			smooth_triangle {
				<-0.006950, 0.763751, 0.636977>, <2.887087, 5.414701, 3.349796>,
				<0.012032, 0.846221, 0.522385>, <1.740575, 4.132123, 2.188913>,
				<0.071435, 0.779671, 0.613277>, <2.051176, 4.724058, 3.062173>
			}
			smooth_triangle {
				<-0.006950, 0.763751, 0.636977>, <2.887087, 5.414701, 3.349796>,
				<-0.087877, 0.774690, 0.617447>, <2.772269, 4.702427, 2.461098>,
				<0.012032, 0.846221, 0.522385>, <1.740575, 4.132123, 2.188913>
			}
			smooth_triangle {
				<0.132552, 0.810561, 0.560831>, <1.554667, 4.911388, 3.055921>,
				<0.071435, 0.779671, 0.613277>, <2.051176, 4.724058, 3.062173>,
				<0.012032, 0.846221, 0.522385>, <1.740575, 4.132123, 2.188913>
			}
			smooth_triangle {
				<0.132552, 0.810561, 0.560831>, <1.554667, 4.911388, 3.055921>,
				<0.134291, 0.768251, 0.617136>, <1.473520, 3.867822, 2.798403>,
				<0.071435, 0.779671, 0.613277>, <2.051176, 4.724058, 3.062173>
			}
			smooth_triangle {
				<-0.018291, 0.643281, 0.758263>, <1.014557, 1.306624, 1.123894>,
				<-0.036543, 0.656480, 0.746204>, <3.569261, 4.628151, 3.850472>,
				<-0.011093, 0.662290, 0.741858>, <1.952686, 2.666786, 2.252024>
			}
			smooth_triangle {
				<-0.146132, 0.810480, 0.557575>, <0.916485, 1.604267, 0.756739>,
				<-0.087877, 0.774690, 0.617447>, <2.772269, 4.702427, 2.461098>,
				<-0.203970, 0.741630, 0.630466>, <1.584352, 2.265288, 1.161789>
			}
			smooth_triangle {
				<-0.123106, 0.678810, 0.716365>, <2.169251, 2.775528, 1.892462>,
				<-0.070855, 0.703600, 0.699308>, <3.550971, 4.956922, 3.431865>,
				<-0.086083, 0.670110, 0.729839>, <3.225011, 4.054506, 3.023445>
			}
			smooth_triangle {
				<-0.070855, 0.703600, 0.699308>, <3.550971, 4.956922, 3.431865>,
				<-0.048874, 0.678380, 0.725613>, <3.035596, 4.101366, 3.153920>,
				<-0.086083, 0.670110, 0.729839>, <3.225011, 4.054506, 3.023445>
			}
			smooth_triangle {
				<-0.048874, 0.678380, 0.725613>, <3.035596, 4.101366, 3.153920>,
				<-0.064190, 0.658940, 0.742146>, <2.644034, 3.315903, 2.646996>,
				<-0.086083, 0.670110, 0.729839>, <3.225011, 4.054506, 3.023445>
			}
			smooth_triangle {
				<-0.048874, 0.678380, 0.725613>, <3.035596, 4.101366, 3.153920>,
				<-0.070855, 0.703600, 0.699308>, <3.550971, 4.956922, 3.431865>,
				<-0.022699, 0.701420, 0.704706>, <2.834145, 4.233396, 3.165876>
			}
			smooth_triangle {
				<-0.070855, 0.703600, 0.699308>, <3.550971, 4.956922, 3.431865>,
				<-0.032298, 0.727380, 0.677476>, <2.311272, 3.662452, 2.494834>,
				<-0.022699, 0.701420, 0.704706>, <2.834145, 4.233396, 3.165876>
			}
			smooth_triangle {
				<-0.022699, 0.701420, 0.704706>, <2.834145, 4.233396, 3.165876>,
				<-0.012691, 0.677040, 0.728409>, <2.878442, 4.092903, 3.308516>,
				<-0.048874, 0.678380, 0.725613>, <3.035596, 4.101366, 3.153920>
			}
			smooth_triangle {
				<-0.036543, 0.656480, 0.746204>, <3.569261, 4.628151, 3.850472>,
				<-0.012691, 0.677040, 0.728409>, <2.878442, 4.092903, 3.308516>,
				<-0.011093, 0.662290, 0.741858>, <1.952686, 2.666786, 2.252024>
			}
			smooth_triangle {
				<-0.012691, 0.677040, 0.728409>, <2.878442, 4.092903, 3.308516>,
				<-0.036543, 0.656480, 0.746204>, <3.569261, 4.628151, 3.850472>,
				<-0.048874, 0.678380, 0.725613>, <3.035596, 4.101366, 3.153920>
			}
			smooth_triangle {
				<-0.036543, 0.656480, 0.746204>, <3.569261, 4.628151, 3.850472>,
				<-0.064190, 0.658940, 0.742146>, <2.644034, 3.315903, 2.646996>,
				<-0.048874, 0.678380, 0.725613>, <3.035596, 4.101366, 3.153920>
			}
			smooth_triangle {
				<-0.163783, 0.690240, 0.697027>, <1.106192, 1.433012, 0.848489>,
				<-0.119093, 0.723160, 0.672282>, <3.155927, 4.379437, 2.606505>,
				<-0.123106, 0.678810, 0.716365>, <2.169251, 2.775528, 1.892462>
			}
			smooth_triangle {
				<-0.123106, 0.678810, 0.716365>, <2.169251, 2.775528, 1.892462>,
				<-0.119093, 0.723160, 0.672282>, <3.155927, 4.379437, 2.606505>,
				<-0.070855, 0.703600, 0.699308>, <3.550971, 4.956922, 3.431865>
			}
			smooth_triangle {
				<-0.119093, 0.723160, 0.672282>, <3.155927, 4.379437, 2.606505>,
				<-0.063448, 0.739620, 0.661853>, <2.379525, 3.729191, 2.323548>,
				<-0.070855, 0.703600, 0.699308>, <3.550971, 4.956922, 3.431865>
			}
			smooth_triangle {
				<-0.063448, 0.739620, 0.661853>, <2.379525, 3.729191, 2.323548>,
				<-0.032298, 0.727380, 0.677476>, <2.311272, 3.662452, 2.494834>,
				<-0.070855, 0.703600, 0.699308>, <3.550971, 4.956922, 3.431865>
			}
			smooth_triangle {
				<-0.119093, 0.723160, 0.672282>, <3.155927, 4.379437, 2.606505>,
				<-0.087877, 0.774690, 0.617447>, <2.772269, 4.702427, 2.461098>,
				<-0.063448, 0.739620, 0.661853>, <2.379525, 3.729191, 2.323548>
			}
			smooth_triangle {
				<-0.087877, 0.774690, 0.617447>, <2.772269, 4.702427, 2.461098>,
				<-0.119093, 0.723160, 0.672282>, <3.155927, 4.379437, 2.606505>,
				<-0.203970, 0.741630, 0.630466>, <1.584352, 2.265288, 1.161789>
			}
			smooth_triangle {
				<-0.119093, 0.723160, 0.672282>, <3.155927, 4.379437, 2.606505>,
				<-0.163783, 0.690240, 0.697027>, <1.106192, 1.433012, 0.848489>,
				<-0.203970, 0.741630, 0.630466>, <1.584352, 2.265288, 1.161789>
			}
			smooth_triangle {
				<0.034049, 0.636151, 0.763715>, <1.383358, 1.935393, 1.827493>,
				<0.014210, 0.642811, 0.758757>, <1.415985, 1.960172, 1.775404>,
				<0.030240, 0.651191, 0.751102>, <2.308327, 3.275623, 2.989511>
			}
			smooth_triangle {
				<-0.011093, 0.662290, 0.741858>, <1.952686, 2.666786, 2.252024>,
				<0.012213, 0.663491, 0.740773>, <3.274863, 4.681918, 4.042392>,
				<0.000836, 0.650241, 0.752526>, <0.954613, 1.320152, 1.160031>
			}
			smooth_triangle {
				<0.037359, 0.665671, 0.737962>, <2.231271, 3.356059, 2.957984>,
				<0.030240, 0.651191, 0.751102>, <2.308327, 3.275623, 2.989511>,
				<0.012213, 0.663491, 0.740773>, <3.274863, 4.681918, 4.042392>
			}
			smooth_triangle {
				<0.030240, 0.651191, 0.751102>, <2.308327, 3.275623, 2.989511>,
				<0.014210, 0.642811, 0.758757>, <1.415985, 1.960172, 1.775404>,
				<0.012213, 0.663491, 0.740773>, <3.274863, 4.681918, 4.042392>
			}
			smooth_triangle {
				<0.014210, 0.642811, 0.758757>, <1.415985, 1.960172, 1.775404>,
				<0.000836, 0.650241, 0.752526>, <0.954613, 1.320152, 1.160031>,
				<0.012213, 0.663491, 0.740773>, <3.274863, 4.681918, 4.042392>
			}
			smooth_triangle {
				<0.064635, 0.671771, 0.730517>, <2.524298, 4.063373, 3.619022>,
				<0.053328, 0.647041, 0.753399>, <3.108976, 4.557361, 4.307102>,
				<0.037359, 0.665671, 0.737962>, <2.231271, 3.356059, 2.957984>
			}
			smooth_triangle {
				<0.049502, 0.626861, 0.770526>, <1.353217, 1.908676, 1.877488>,
				<0.034049, 0.636151, 0.763715>, <1.383358, 1.935393, 1.827493>,
				<0.053328, 0.647041, 0.753399>, <3.108976, 4.557361, 4.307102>
			}
			smooth_triangle {
				<0.034049, 0.636151, 0.763715>, <1.383358, 1.935393, 1.827493>,
				<0.030240, 0.651191, 0.751102>, <2.308327, 3.275623, 2.989511>,
				<0.053328, 0.647041, 0.753399>, <3.108976, 4.557361, 4.307102>
			}
			smooth_triangle {
				<0.037359, 0.665671, 0.737962>, <2.231271, 3.356059, 2.957984>,
				<0.053328, 0.647041, 0.753399>, <3.108976, 4.557361, 4.307102>,
				<0.030240, 0.651191, 0.751102>, <2.308327, 3.275623, 2.989511>
			}
			smooth_triangle {
				<0.017199, 0.499741, 0.859691>, <2.693980, 2.524282, 3.371029>,
				<0.033173, 0.517831, 0.848454>, <3.656733, 3.640325, 4.728703>,
				<0.034365, 0.486861, 0.866552>, <3.728652, 3.432781, 4.826888>
			}
			smooth_triangle {
				<0.199716, 0.503781, 0.833921>, <1.148081, 1.559120, 2.291056>,
				<0.167949, 0.498671, 0.843933>, <1.241776, 1.541247, 2.254076>,
				<0.175137, 0.528371, 0.824169>, <2.383294, 3.185147, 4.490032>
			}
			smooth_triangle {
				<0.151657, 0.549711, 0.814825>, <2.457054, 3.314459, 4.354875>,
				<0.145610, 0.522691, 0.833489>, <2.559386, 3.149881, 4.417499>,
				<0.125223, 0.544471, 0.822791>, <2.607244, 3.281991, 4.291919>
			}
			smooth_triangle {
				<0.125223, 0.544471, 0.822791>, <2.607244, 3.281991, 4.291919>,
				<0.114223, 0.519581, 0.840297>, <3.184186, 3.650869, 5.051229>,
				<0.103838, 0.543101, 0.826662>, <2.271112, 2.725702, 3.522398>
			}
			smooth_triangle {
				<0.063574, 0.476561, 0.870605>, <1.545115, 1.466301, 2.112233>,
				<0.061179, 0.500061, 0.857498>, <3.043255, 3.017849, 4.197593>,
				<0.087429, 0.482331, 0.865352>, <1.476745, 1.488013, 2.145663>
			}
			smooth_triangle {
				<0.087429, 0.482331, 0.865352>, <1.476745, 1.488013, 2.145663>,
				<0.087107, 0.508741, 0.850127>, <2.891232, 3.068667, 4.267546>,
				<0.112447, 0.487931, 0.859293>, <1.402217, 1.510856, 2.179426>
			}
			smooth_triangle {
				<0.112447, 0.487931, 0.859293>, <1.402217, 1.510856, 2.179426>,
				<0.087107, 0.508741, 0.850127>, <2.891232, 3.068667, 4.267546>,
				<0.114223, 0.519581, 0.840297>, <3.184186, 3.650869, 5.051229>
			}
			smooth_triangle {
				<0.087107, 0.508741, 0.850127>, <2.891232, 3.068667, 4.267546>,
				<0.085901, 0.534491, 0.834299>, <2.842339, 3.219538, 4.188773>,
				<0.114223, 0.519581, 0.840297>, <3.184186, 3.650869, 5.051229>
			}
			smooth_triangle {
				<0.085901, 0.534491, 0.834299>, <2.842339, 3.219538, 4.188773>,
				<0.103838, 0.543101, 0.826662>, <2.271112, 2.725702, 3.522398>,
				<0.114223, 0.519581, 0.840297>, <3.184186, 3.650869, 5.051229>
			}
			smooth_triangle {
				<0.085901, 0.534491, 0.834299>, <2.842339, 3.219538, 4.188773>,
				<0.087107, 0.508741, 0.850127>, <2.891232, 3.068667, 4.267546>,
				<0.061277, 0.526361, 0.841607>, <2.980859, 3.173300, 4.127176>
			}
			smooth_triangle {
				<0.087429, 0.482331, 0.865352>, <1.476745, 1.488013, 2.145663>,
				<0.061179, 0.500061, 0.857498>, <3.043255, 3.017849, 4.197593>,
				<0.087107, 0.508741, 0.850127>, <2.891232, 3.068667, 4.267546>
			}
			smooth_triangle {
				<0.087107, 0.508741, 0.850127>, <2.891232, 3.068667, 4.267546>,
				<0.061179, 0.500061, 0.857498>, <3.043255, 3.017849, 4.197593>,
				<0.061277, 0.526361, 0.841607>, <2.980859, 3.173300, 4.127176>
			}
			smooth_triangle {
				<0.061277, 0.526361, 0.841607>, <2.980859, 3.173300, 4.127176>,
				<0.061179, 0.500061, 0.857498>, <3.043255, 3.017849, 4.197593>,
				<0.033173, 0.517831, 0.848454>, <3.656733, 3.640325, 4.728703>
			}
			smooth_triangle {
				<0.061179, 0.500061, 0.857498>, <3.043255, 3.017849, 4.197593>,
				<0.034365, 0.486861, 0.866552>, <3.728652, 3.432781, 4.826888>,
				<0.033173, 0.517831, 0.848454>, <3.656733, 3.640325, 4.728703>
			}
			smooth_triangle {
				<0.061179, 0.500061, 0.857498>, <3.043255, 3.017849, 4.197593>,
				<0.063574, 0.476561, 0.870605>, <1.545115, 1.466301, 2.112233>,
				<0.034365, 0.486861, 0.866552>, <3.728652, 3.432781, 4.826888>
			}
			smooth_triangle {
				<0.063574, 0.476561, 0.870605>, <1.545115, 1.466301, 2.112233>,
				<0.040463, 0.470581, 0.875234>, <1.067891, 0.962351, 1.390277>,
				<0.034365, 0.486861, 0.866552>, <3.728652, 3.432781, 4.826888>
			}
			smooth_triangle {
				<0.112447, 0.487931, 0.859293>, <1.402217, 1.510856, 2.179426>,
				<0.114223, 0.519581, 0.840297>, <3.184186, 3.650869, 5.051229>,
				<0.139099, 0.493371, 0.852255>, <1.327465, 1.527717, 2.214158>
			}
			smooth_triangle {
				<0.125223, 0.544471, 0.822791>, <2.607244, 3.281991, 4.291919>,
				<0.145610, 0.522691, 0.833489>, <2.559386, 3.149881, 4.417499>,
				<0.114223, 0.519581, 0.840297>, <3.184186, 3.650869, 5.051229>
			}
			smooth_triangle {
				<0.114223, 0.519581, 0.840297>, <3.184186, 3.650869, 5.051229>,
				<0.145610, 0.522691, 0.833489>, <2.559386, 3.149881, 4.417499>,
				<0.139099, 0.493371, 0.852255>, <1.327465, 1.527717, 2.214158>
			}
			smooth_triangle {
				<0.139099, 0.493371, 0.852255>, <1.327465, 1.527717, 2.214158>,
				<0.145610, 0.522691, 0.833489>, <2.559386, 3.149881, 4.417499>,
				<0.167949, 0.498671, 0.843933>, <1.241776, 1.541247, 2.254076>
			}
			smooth_triangle {
				<0.151657, 0.549711, 0.814825>, <2.457054, 3.314459, 4.354875>,
				<0.175137, 0.528371, 0.824169>, <2.383294, 3.185147, 4.490032>,
				<0.145610, 0.522691, 0.833489>, <2.559386, 3.149881, 4.417499>
			}
			smooth_triangle {
				<0.145610, 0.522691, 0.833489>, <2.559386, 3.149881, 4.417499>,
				<0.175137, 0.528371, 0.824169>, <2.383294, 3.185147, 4.490032>,
				<0.167949, 0.498671, 0.843933>, <1.241776, 1.541247, 2.254076>
			}
			smooth_triangle {
				<0.040463, 0.470581, 0.875234>, <1.067891, 0.962351, 1.390277>,
				<0.017710, 0.464301, 0.879326>, <1.090742, 0.957759, 1.375851>,
				<0.034365, 0.486861, 0.866552>, <3.728652, 3.432781, 4.826888>
			}
			smooth_triangle {
				<0.017710, 0.464301, 0.879326>, <1.090742, 0.957759, 1.375851>,
				<0.007279, 0.478961, 0.871578>, <1.642858, 1.461876, 2.040438>,
				<0.034365, 0.486861, 0.866552>, <3.728652, 3.432781, 4.826888>
			}
			smooth_triangle {
				<0.034365, 0.486861, 0.866552>, <3.728652, 3.432781, 4.826888>,
				<0.007279, 0.478961, 0.871578>, <1.642858, 1.461876, 2.040438>,
				<0.017199, 0.499741, 0.859691>, <2.693980, 2.524282, 3.371029>
			}
			smooth_triangle {
				<0.007279, 0.478961, 0.871578>, <1.642858, 1.461876, 2.040438>,
				<-0.000693, 0.494751, 0.862746>, <0.550757, 0.492458, 0.673908>,
				<0.017199, 0.499741, 0.859691>, <2.693980, 2.524282, 3.371029>
			}
			smooth_triangle {
				<0.151657, 0.549711, 0.814825>, <2.457054, 3.314459, 4.354875>,
				<0.125223, 0.544471, 0.822791>, <2.607244, 3.281991, 4.291919>,
				<0.128820, 0.569461, 0.805126>, <2.941596, 4.002474, 4.931068>
			}
			smooth_triangle {
				<0.128820, 0.569461, 0.805126>, <2.941596, 4.002474, 4.931068>,
				<0.125223, 0.544471, 0.822791>, <2.607244, 3.281991, 4.291919>,
				<0.106927, 0.560861, 0.814319>, <2.659055, 3.383127, 4.180568>
			}
			smooth_triangle {
				<0.125223, 0.544471, 0.822791>, <2.607244, 3.281991, 4.291919>,
				<0.103838, 0.543101, 0.826662>, <2.271112, 2.725702, 3.522398>,
				<0.106927, 0.560861, 0.814319>, <2.659055, 3.383127, 4.180568>
			}
			smooth_triangle {
				<0.106927, 0.560861, 0.814319>, <2.659055, 3.383127, 4.180568>,
				<0.103838, 0.543101, 0.826662>, <2.271112, 2.725702, 3.522398>,
				<0.086756, 0.555371, 0.820462>, <2.783742, 3.346826, 4.128309>
			}
			smooth_triangle {
				<0.103838, 0.543101, 0.826662>, <2.271112, 2.725702, 3.522398>,
				<0.085901, 0.534491, 0.834299>, <2.842339, 3.219538, 4.188773>,
				<0.086756, 0.555371, 0.820462>, <2.783742, 3.346826, 4.128309>
			}
			smooth_triangle {
				<0.086756, 0.555371, 0.820462>, <2.783742, 3.346826, 4.128309>,
				<0.085901, 0.534491, 0.834299>, <2.842339, 3.219538, 4.188773>,
				<0.061997, 0.552401, 0.824698>, <3.401676, 3.881774, 4.727408>
			}
			smooth_triangle {
				<0.085901, 0.534491, 0.834299>, <2.842339, 3.219538, 4.188773>,
				<0.061277, 0.526361, 0.841607>, <2.980859, 3.173300, 4.127176>,
				<0.061997, 0.552401, 0.824698>, <3.401676, 3.881774, 4.727408>
			}
			smooth_triangle {
				<0.061997, 0.552401, 0.824698>, <3.401676, 3.881774, 4.727408>,
				<0.061277, 0.526361, 0.841607>, <2.980859, 3.173300, 4.127176>,
				<0.038142, 0.543091, 0.832300>, <3.047464, 3.273469, 3.998524>
			}
			smooth_triangle {
				<0.061277, 0.526361, 0.841607>, <2.980859, 3.173300, 4.127176>,
				<0.033173, 0.517831, 0.848454>, <3.656733, 3.640325, 4.728703>,
				<0.038142, 0.543091, 0.832300>, <3.047464, 3.273469, 3.998524>
			}
			smooth_triangle {
				<0.038142, 0.543091, 0.832300>, <3.047464, 3.273469, 3.998524>,
				<0.033173, 0.517831, 0.848454>, <3.656733, 3.640325, 4.728703>,
				<0.015661, 0.539791, 0.835160>, <1.567449, 1.612934, 1.985094>
			}
			smooth_triangle {
				<0.015661, 0.539791, 0.835160>, <1.567449, 1.612934, 1.985094>,
				<0.033173, 0.517831, 0.848454>, <3.656733, 3.640325, 4.728703>,
				<0.004371, 0.525731, 0.844216>, <1.598849, 1.566652, 1.997213>
			}
			smooth_triangle {
				<0.004371, 0.525731, 0.844216>, <1.598849, 1.566652, 1.997213>,
				<0.017199, 0.499741, 0.859691>, <2.693980, 2.524282, 3.371029>,
				<0.003174, 0.509691, 0.854006>, <0.531802, 0.519623, 0.668714>
			}
			smooth_triangle {
				<0.004371, 0.525731, 0.844216>, <1.598849, 1.566652, 1.997213>,
				<0.033173, 0.517831, 0.848454>, <3.656733, 3.640325, 4.728703>,
				<0.017199, 0.499741, 0.859691>, <2.693980, 2.524282, 3.371029>
			}
			smooth_triangle {
				<0.015661, 0.539791, 0.835160>, <1.567449, 1.612934, 1.985094>,
				<0.021780, 0.555451, 0.824686>, <1.023781, 1.106135, 1.314588>,
				<0.038142, 0.543091, 0.832300>, <3.047464, 3.273469, 3.998524>
			}
			smooth_triangle {
				<0.128820, 0.569461, 0.805126>, <2.941596, 4.002474, 4.931068>,
				<0.106927, 0.560861, 0.814319>, <2.659055, 3.383127, 4.180568>,
				<0.107693, 0.578871, 0.801510>, <2.613721, 3.489731, 4.121267>
			}
			smooth_triangle {
				<0.106927, 0.560861, 0.814319>, <2.659055, 3.383127, 4.180568>,
				<0.086756, 0.555371, 0.820462>, <2.783742, 3.346826, 4.128309>,
				<0.089149, 0.572921, 0.808036>, <2.719127, 3.457168, 4.080314>
			}
			smooth_triangle {
				<0.086756, 0.555371, 0.820462>, <2.783742, 3.346826, 4.128309>,
				<0.061997, 0.552401, 0.824698>, <3.401676, 3.881774, 4.727408>,
				<0.072588, 0.567521, 0.813487>, <2.350796, 2.851473, 3.367372>
			}
			smooth_triangle {
				<0.034928, 0.565411, 0.817439>, <1.987198, 2.254040, 2.639837>,
				<0.054214, 0.572971, 0.811099>, <2.897318, 3.454107, 3.958346>,
				<0.061997, 0.552401, 0.824698>, <3.401676, 3.881774, 4.727408>
			}
			smooth_triangle {
				<0.054214, 0.572971, 0.811099>, <2.897318, 3.454107, 3.958346>,
				<0.072588, 0.567521, 0.813487>, <2.350796, 2.851473, 3.367372>,
				<0.061997, 0.552401, 0.824698>, <3.401676, 3.881774, 4.727408>
			}
			smooth_triangle {
				<0.061997, 0.552401, 0.824698>, <3.401676, 3.881774, 4.727408>,
				<0.038142, 0.543091, 0.832300>, <3.047464, 3.273469, 3.998524>,
				<0.034928, 0.565411, 0.817439>, <1.987198, 2.254040, 2.639837>
			}
			smooth_triangle {
				<0.034928, 0.565411, 0.817439>, <1.987198, 2.254040, 2.639837>,
				<0.038142, 0.543091, 0.832300>, <3.047464, 3.273469, 3.998524>,
				<0.021780, 0.555451, 0.824686>, <1.023781, 1.106135, 1.314588>
			}
			smooth_triangle {
				<0.086756, 0.555371, 0.820462>, <2.783742, 3.346826, 4.128309>,
				<0.072588, 0.567521, 0.813487>, <2.350796, 2.851473, 3.367372>,
				<0.089149, 0.572921, 0.808036>, <2.719127, 3.457168, 4.080314>
			}
			smooth_triangle {
				<0.054214, 0.572971, 0.811099>, <2.897318, 3.454107, 3.958346>,
				<0.070786, 0.583371, 0.802363>, <2.782073, 3.522832, 3.980387>,
				<0.072588, 0.567521, 0.813487>, <2.350796, 2.851473, 3.367372>
			}
			smooth_triangle {
				<0.072588, 0.567521, 0.813487>, <2.350796, 2.851473, 3.367372>,
				<0.070786, 0.583371, 0.802363>, <2.782073, 3.522832, 3.980387>,
				<0.089149, 0.572921, 0.808036>, <2.719127, 3.457168, 4.080314>
			}
			smooth_triangle {
				<0.106927, 0.560861, 0.814319>, <2.659055, 3.383127, 4.180568>,
				<0.089149, 0.572921, 0.808036>, <2.719127, 3.457168, 4.080314>,
				<0.107693, 0.578871, 0.801510>, <2.613721, 3.489731, 4.121267>
			}
			smooth_triangle {
				<0.070786, 0.583371, 0.802363>, <2.782073, 3.522832, 3.980387>,
				<0.090055, 0.590731, 0.795006>, <2.666690, 3.566195, 4.020510>,
				<0.089149, 0.572921, 0.808036>, <2.719127, 3.457168, 4.080314>
			}
			smooth_triangle {
				<0.089149, 0.572921, 0.808036>, <2.719127, 3.457168, 4.080314>,
				<0.090055, 0.590731, 0.795006>, <2.666690, 3.566195, 4.020510>,
				<0.107693, 0.578871, 0.801510>, <2.613721, 3.489731, 4.121267>
			}
			smooth_triangle {
				<0.034478, 0.577051, 0.809280>, <1.958963, 2.343657, 2.582261>,
				<0.019142, 0.586241, 0.803154>, <0.991043, 1.191853, 1.263748>,
				<0.031999, 0.600461, 0.792170>, <2.457530, 2.988575, 3.166357>
			}
			smooth_triangle {
				<0.000097, 0.604781, 0.789528>, <0.503368, 0.606143, 0.615801>,
				<0.016444, 0.608971, 0.786124>, <1.001731, 1.208256, 1.239575>,
				<0.006725, 0.595061, 0.796851>, <1.500575, 1.808067, 1.865181>
			}
			smooth_triangle {
				<0.031999, 0.600461, 0.792170>, <2.457530, 2.988575, 3.166357>,
				<0.006725, 0.595061, 0.796851>, <1.500575, 1.808067, 1.865181>,
				<0.016444, 0.608971, 0.786124>, <1.001731, 1.208256, 1.239575>
			}
			smooth_triangle {
				<0.031999, 0.600461, 0.792170>, <2.457530, 2.988575, 3.166357>,
				<0.019142, 0.586241, 0.803154>, <0.991043, 1.191853, 1.263748>,
				<0.006725, 0.595061, 0.796851>, <1.500575, 1.808067, 1.865181>
			}
			smooth_triangle {
				<0.034478, 0.577051, 0.809280>, <1.958963, 2.343657, 2.582261>,
				<0.031999, 0.600461, 0.792170>, <2.457530, 2.988575, 3.166357>,
				<0.050450, 0.591201, 0.798149>, <2.861720, 3.567443, 3.882975>
			}
			smooth_triangle {
				<0.070786, 0.583371, 0.802363>, <2.782073, 3.522832, 3.980387>,
				<0.054214, 0.572971, 0.811099>, <2.897318, 3.454107, 3.958346>,
				<0.050450, 0.591201, 0.798149>, <2.861720, 3.567443, 3.882975>
			}
			smooth_triangle {
				<0.034928, 0.565411, 0.817439>, <1.987198, 2.254040, 2.639837>,
				<0.034478, 0.577051, 0.809280>, <1.958963, 2.343657, 2.582261>,
				<0.054214, 0.572971, 0.811099>, <2.897318, 3.454107, 3.958346>
			}
			smooth_triangle {
				<0.050450, 0.591201, 0.798149>, <2.861720, 3.567443, 3.882975>,
				<0.054214, 0.572971, 0.811099>, <2.897318, 3.454107, 3.958346>,
				<0.034478, 0.577051, 0.809280>, <1.958963, 2.343657, 2.582261>
			}
			smooth_triangle {
				<0.031999, 0.600461, 0.792170>, <2.457530, 2.988575, 3.166357>,
				<0.043050, 0.608431, 0.785534>, <1.412180, 1.817746, 1.923830>,
				<0.050450, 0.591201, 0.798149>, <2.861720, 3.567443, 3.882975>
			}
			smooth_triangle {
				<0.090055, 0.590731, 0.795006>, <2.666690, 3.566195, 4.020510>,
				<0.070786, 0.583371, 0.802363>, <2.782073, 3.522832, 3.980387>,
				<0.068129, 0.603951, 0.787217>, <3.189967, 4.250476, 4.554904>
			}
			smooth_triangle {
				<0.070786, 0.583371, 0.802363>, <2.782073, 3.522832, 3.980387>,
				<0.050450, 0.591201, 0.798149>, <2.861720, 3.567443, 3.882975>,
				<0.068129, 0.603951, 0.787217>, <3.189967, 4.250476, 4.554904>
			}
			smooth_triangle {
				<0.050450, 0.591201, 0.798149>, <2.861720, 3.567443, 3.882975>,
				<0.043050, 0.608431, 0.785534>, <1.412180, 1.817746, 1.923830>,
				<0.068129, 0.603951, 0.787217>, <3.189967, 4.250476, 4.554904>
			}
			smooth_triangle {
				<0.043050, 0.608431, 0.785534>, <1.412180, 1.817746, 1.923830>,
				<0.056272, 0.617071, 0.777925>, <1.364844, 1.857341, 1.919974>,
				<0.068129, 0.603951, 0.787217>, <3.189967, 4.250476, 4.554904>
			}
			smooth_triangle {
				<-0.119509, 0.651780, 0.741622>, <1.683205, 1.973288, 1.506737>,
				<-0.123106, 0.678810, 0.716365>, <2.169251, 2.775528, 1.892462>,
				<-0.086083, 0.670110, 0.729839>, <3.225011, 4.054506, 3.023445>
			}
			smooth_triangle {
				<-0.064190, 0.658940, 0.742146>, <2.644034, 3.315903, 2.646996>,
				<-0.036543, 0.656480, 0.746204>, <3.569261, 4.628151, 3.850472>,
				<-0.059670, 0.642260, 0.757007>, <2.136500, 2.599771, 2.161651>
			}
			smooth_triangle {
				<-0.086083, 0.670110, 0.729839>, <3.225011, 4.054506, 3.023445>,
				<-0.089666, 0.646270, 0.750599>, <3.333773, 3.890910, 3.119644>,
				<-0.119509, 0.651780, 0.741622>, <1.683205, 1.973288, 1.506737>
			}
			smooth_triangle {
				<-0.089666, 0.646270, 0.750599>, <3.333773, 3.890910, 3.119644>,
				<-0.129366, 0.626620, 0.761394>, <1.717399, 1.909084, 1.551025>,
				<-0.119509, 0.651780, 0.741622>, <1.683205, 1.973288, 1.506737>
			}
			smooth_triangle {
				<-0.089666, 0.646270, 0.750599>, <3.333773, 3.890910, 3.119644>,
				<-0.078902, 0.625740, 0.768981>, <1.693464, 1.910959, 1.574407>,
				<-0.129366, 0.626620, 0.761394>, <1.717399, 1.909084, 1.551025>
			}
			smooth_triangle {
				<-0.078902, 0.625740, 0.768981>, <1.693464, 1.910959, 1.574407>,
				<-0.102767, 0.611880, 0.777271>, <0.571020, 0.636125, 0.518924>,
				<-0.129366, 0.626620, 0.761394>, <1.717399, 1.909084, 1.551025>
			}
			smooth_triangle {
				<-0.078902, 0.625740, 0.768981>, <1.693464, 1.910959, 1.574407>,
				<-0.089666, 0.646270, 0.750599>, <3.333773, 3.890910, 3.119644>,
				<-0.059670, 0.642260, 0.757007>, <2.136500, 2.599771, 2.161651>
			}
			smooth_triangle {
				<-0.086083, 0.670110, 0.729839>, <3.225011, 4.054506, 3.023445>,
				<-0.064190, 0.658940, 0.742146>, <2.644034, 3.315903, 2.646996>,
				<-0.089666, 0.646270, 0.750599>, <3.333773, 3.890910, 3.119644>
			}
			smooth_triangle {
				<-0.089666, 0.646270, 0.750599>, <3.333773, 3.890910, 3.119644>,
				<-0.064190, 0.658940, 0.742146>, <2.644034, 3.315903, 2.646996>,
				<-0.059670, 0.642260, 0.757007>, <2.136500, 2.599771, 2.161651>
			}
			smooth_triangle {
				<-0.018291, 0.643281, 0.758263>, <1.014557, 1.306624, 1.123894>,
				<-0.037818, 0.633820, 0.765484>, <1.036170, 1.297585, 1.114676>,
				<-0.036543, 0.656480, 0.746204>, <3.569261, 4.628151, 3.850472>
			}
			smooth_triangle {
				<-0.036543, 0.656480, 0.746204>, <3.569261, 4.628151, 3.850472>,
				<-0.037818, 0.633820, 0.765484>, <1.036170, 1.297585, 1.114676>,
				<-0.059670, 0.642260, 0.757007>, <2.136500, 2.599771, 2.161651>
			}
			smooth_triangle {
				<0.821995, 0.485953, 0.278004>, <-1.337070, 1.474700, 2.244185>,
				<0.829081, 0.464433, 0.293324>, <-0.875455, 0.951487, 1.525690>,
				<0.814065, 0.485253, 0.301550>, <-2.578035, 2.924237, 4.559569>
			}
			smooth_triangle {
				<0.804329, 0.449653, 0.374142>, <-1.450526, 1.888800, 3.211096>,
				<0.798897, 0.490903, 0.331483>, <-2.391047, 2.953948, 4.640021>,
				<0.826194, 0.450993, 0.321123>, <-1.248067, 1.412315, 2.333580>
			}
			smooth_triangle {
				<0.798897, 0.490903, 0.331483>, <-2.391047, 2.953948, 4.640021>,
				<0.814065, 0.485253, 0.301550>, <-2.578035, 2.924237, 4.559569>,
				<0.826194, 0.450993, 0.321123>, <-1.248067, 1.412315, 2.333580>
			}
			smooth_triangle {
				<0.829081, 0.464433, 0.293324>, <-0.875455, 0.951487, 1.525690>,
				<0.826194, 0.450993, 0.321123>, <-1.248067, 1.412315, 2.333580>,
				<0.814065, 0.485253, 0.301550>, <-2.578035, 2.924237, 4.559569>
			}
			smooth_triangle {
				<0.798897, 0.490903, 0.331483>, <-2.391047, 2.953948, 4.640021>,
				<0.795873, 0.513803, 0.302848>, <-2.490865, 3.095337, 4.494497>,
				<0.814065, 0.485253, 0.301550>, <-2.578035, 2.924237, 4.559569>
			}
			smooth_triangle {
				<0.795873, 0.513803, 0.302848>, <-2.490865, 3.095337, 4.494497>,
				<0.809884, 0.503793, 0.281757>, <-2.642250, 3.038811, 4.447120>,
				<0.814065, 0.485253, 0.301550>, <-2.578035, 2.924237, 4.559569>
			}
			smooth_triangle {
				<0.819403, 0.498473, 0.263091>, <-1.366676, 1.514878, 2.199187>,
				<0.821995, 0.485953, 0.278004>, <-1.337070, 1.474700, 2.244185>,
				<0.809884, 0.503793, 0.281757>, <-2.642250, 3.038811, 4.447120>
			}
			smooth_triangle {
				<0.809884, 0.503793, 0.281757>, <-2.642250, 3.038811, 4.447120>,
				<0.821995, 0.485953, 0.278004>, <-1.337070, 1.474700, 2.244185>,
				<0.814065, 0.485253, 0.301550>, <-2.578035, 2.924237, 4.559569>
			}
			smooth_triangle {
				<0.795873, 0.513803, 0.302848>, <-2.490865, 3.095337, 4.494497>,
				<0.795754, 0.527483, 0.278654>, <-3.026441, 3.712198, 5.103814>,
				<0.809884, 0.503793, 0.281757>, <-2.642250, 3.038811, 4.447120>
			}
			smooth_triangle {
				<0.795754, 0.527483, 0.278654>, <-3.026441, 3.712198, 5.103814>,
				<0.810809, 0.510873, 0.265917>, <-2.263559, 2.572829, 3.640370>,
				<0.809884, 0.503793, 0.281757>, <-2.642250, 3.038811, 4.447120>
			}
			smooth_triangle {
				<0.822923, 0.500913, 0.246953>, <-1.884151, 2.042868, 2.876265>,
				<0.819403, 0.498473, 0.263091>, <-1.366676, 1.514878, 2.199187>,
				<0.810809, 0.510873, 0.265917>, <-2.263559, 2.572829, 3.640370>
			}
			smooth_triangle {
				<0.810809, 0.510873, 0.265917>, <-2.263559, 2.572829, 3.640370>,
				<0.819403, 0.498473, 0.263091>, <-1.366676, 1.514878, 2.199187>,
				<0.809884, 0.503793, 0.281757>, <-2.642250, 3.038811, 4.447120>
			}
			smooth_triangle {
				<0.826334, 0.499483, 0.238308>, <-0.954926, 1.016461, 1.433012>,
				<0.834146, 0.488473, 0.233881>, <-0.479904, 0.492377, 0.726125>,
				<0.822923, 0.500913, 0.246953>, <-1.884151, 2.042868, 2.876265>
			}
			smooth_triangle {
				<0.805246, 0.523123, 0.258914>, <-1.825353, 2.100532, 2.872403>,
				<0.822923, 0.500913, 0.246953>, <-1.884151, 2.042868, 2.876265>,
				<0.810809, 0.510873, 0.265917>, <-2.263559, 2.572829, 3.640370>
			}
			smooth_triangle {
				<0.805246, 0.523123, 0.258914>, <-1.825353, 2.100532, 2.872403>,
				<0.826334, 0.499483, 0.238308>, <-0.954926, 1.016461, 1.433012>,
				<0.822923, 0.500913, 0.246953>, <-1.884151, 2.042868, 2.876265>
			}
			smooth_triangle {
				<0.805246, 0.523123, 0.258914>, <-1.825353, 2.100532, 2.872403>,
				<0.795754, 0.527483, 0.278654>, <-3.026441, 3.712198, 5.103814>,
				<0.786698, 0.548143, 0.264113>, <-1.737577, 2.201936, 2.851054>
			}
			smooth_triangle {
				<0.805246, 0.523123, 0.258914>, <-1.825353, 2.100532, 2.872403>,
				<0.810809, 0.510873, 0.265917>, <-2.263559, 2.572829, 3.640370>,
				<0.795754, 0.527483, 0.278654>, <-3.026441, 3.712198, 5.103814>
			}
			smooth_triangle {
				<0.759993, 0.611993, 0.192322>, <-1.369749, 1.868869, 1.904865>,
				<0.761552, 0.600073, 0.221482>, <-1.306193, 1.824986, 1.990113>,
				<0.745467, 0.622923, 0.212970>, <-2.614320, 3.764149, 3.870435>
			}
			smooth_triangle {
				<0.599047, 0.776563, 0.164940>, <-1.055369, 2.312480, 1.591769>,
				<0.630272, 0.758213, 0.130293>, <-1.194534, 2.261162, 1.567316>,
				<0.634828, 0.745223, 0.175332>, <-2.250975, 4.498809, 3.266232>
			}
			smooth_triangle {
				<0.742970, 0.660583, -0.027128>, <-1.765077, 1.972327, 1.411699>,
				<0.751783, 0.651073, 0.005201>, <-3.453281, 3.923172, 2.944123>,
				<0.729418, 0.676053, -0.004386>, <-1.690533, 2.016117, 1.440730>
			}
			smooth_triangle {
				<0.745467, 0.622923, 0.212970>, <-2.614320, 3.764149, 3.870435>,
				<0.746783, 0.634253, 0.170745>, <-3.250946, 4.472775, 4.289135>,
				<0.759993, 0.611993, 0.192322>, <-1.369749, 1.868869, 1.904865>
			}
			smooth_triangle {
				<0.751783, 0.651073, 0.005201>, <-3.453281, 3.923172, 2.944123>,
				<0.757610, 0.642973, 0.041549>, <-3.344472, 3.872031, 3.131058>,
				<0.736273, 0.667953, 0.029220>, <-3.290787, 4.028416, 2.988098>
			}
			smooth_triangle {
				<0.757610, 0.642973, 0.041549>, <-3.344472, 3.872031, 3.131058>,
				<0.757268, 0.638983, 0.085868>, <-3.690458, 4.492193, 3.894883>,
				<0.740757, 0.660923, 0.059750>, <-2.658848, 3.319232, 2.627350>
			}
			smooth_triangle {
				<0.757268, 0.638983, 0.085868>, <-3.690458, 4.492193, 3.894883>,
				<0.766193, 0.620443, 0.130792>, <-3.035559, 3.743775, 3.570016>,
				<0.739088, 0.653323, 0.126617>, <-2.923895, 3.937464, 3.452960>
			}
			smooth_triangle {
				<0.766193, 0.620443, 0.130792>, <-3.035559, 3.743775, 3.570016>,
				<0.746783, 0.634253, 0.170745>, <-3.250946, 4.472775, 4.289135>,
				<0.739088, 0.653323, 0.126617>, <-2.923895, 3.937464, 3.452960>
			}
			smooth_triangle {
				<0.766193, 0.620443, 0.130792>, <-3.035559, 3.743775, 3.570016>,
				<0.770016, 0.607443, 0.164892>, <-1.464911, 1.855898, 1.845657>,
				<0.746783, 0.634253, 0.170745>, <-3.250946, 4.472775, 4.289135>
			}
			smooth_triangle {
				<0.770016, 0.607443, 0.164892>, <-1.464911, 1.855898, 1.845657>,
				<0.759993, 0.611993, 0.192322>, <-1.369749, 1.868869, 1.904865>,
				<0.746783, 0.634253, 0.170745>, <-3.250946, 4.472775, 4.289135>
			}
			smooth_triangle {
				<0.739088, 0.653323, 0.126617>, <-2.923895, 3.937464, 3.452960>,
				<0.729591, 0.670103, 0.088153>, <-3.024643, 4.040591, 3.241393>,
				<0.757268, 0.638983, 0.085868>, <-3.690458, 4.492193, 3.894883>
			}
			smooth_triangle {
				<0.757268, 0.638983, 0.085868>, <-3.690458, 4.492193, 3.894883>,
				<0.729591, 0.670103, 0.088153>, <-3.024643, 4.040591, 3.241393>,
				<0.740757, 0.660923, 0.059750>, <-2.658848, 3.319232, 2.627350>
			}
			smooth_triangle {
				<0.757610, 0.642973, 0.041549>, <-3.344472, 3.872031, 3.131058>,
				<0.740757, 0.660923, 0.059750>, <-2.658848, 3.319232, 2.627350>,
				<0.736273, 0.667953, 0.029220>, <-3.290787, 4.028416, 2.988098>
			}
			smooth_triangle {
				<0.729591, 0.670103, 0.088153>, <-3.024643, 4.040591, 3.241393>,
				<0.720971, 0.682953, 0.053704>, <-3.119216, 4.122805, 3.042748>,
				<0.740757, 0.660923, 0.059750>, <-2.658848, 3.319232, 2.627350>
			}
			smooth_triangle {
				<0.740757, 0.660923, 0.059750>, <-2.658848, 3.319232, 2.627350>,
				<0.720971, 0.682953, 0.053704>, <-3.119216, 4.122805, 3.042748>,
				<0.736273, 0.667953, 0.029220>, <-3.290787, 4.028416, 2.988098>
			}
			smooth_triangle {
				<0.751783, 0.651073, 0.005201>, <-3.453281, 3.923172, 2.944123>,
				<0.736273, 0.667953, 0.029220>, <-3.290787, 4.028416, 2.988098>,
				<0.729418, 0.676053, -0.004386>, <-1.690533, 2.016117, 1.440730>
			}
			smooth_triangle {
				<0.720971, 0.682953, 0.053704>, <-3.119216, 4.122805, 3.042748>,
				<0.714420, 0.691623, 0.019216>, <-1.608276, 2.064957, 1.465468>,
				<0.736273, 0.667953, 0.029220>, <-3.290787, 4.028416, 2.988098>
			}
			smooth_triangle {
				<0.736273, 0.667953, 0.029220>, <-3.290787, 4.028416, 2.988098>,
				<0.714420, 0.691623, 0.019216>, <-1.608276, 2.064957, 1.465468>,
				<0.729418, 0.676053, -0.004386>, <-1.690533, 2.016117, 1.440730>
			}
			smooth_triangle {
				<0.714420, 0.691623, 0.019216>, <-1.608276, 2.064957, 1.465468>,
				<0.720971, 0.682953, 0.053704>, <-3.119216, 4.122805, 3.042748>,
				<0.697600, 0.707473, 0.044022>, <-1.520477, 2.111643, 1.492336>
			}
			smooth_triangle {
				<0.745467, 0.622923, 0.212970>, <-2.614320, 3.764149, 3.870435>,
				<0.723355, 0.651233, 0.204385>, <-2.548008, 3.934070, 3.742727>,
				<0.746783, 0.634253, 0.170745>, <-3.250946, 4.472775, 4.289135>
			}
			smooth_triangle {
				<0.723355, 0.651233, 0.204385>, <-2.548008, 3.934070, 3.742727>,
				<0.718411, 0.668293, 0.162400>, <-2.689498, 4.029879, 3.535918>,
				<0.746783, 0.634253, 0.170745>, <-3.250946, 4.472775, 4.289135>
			}
			smooth_triangle {
				<0.697600, 0.707473, 0.044022>, <-1.520477, 2.111643, 1.492336>,
				<0.720971, 0.682953, 0.053704>, <-3.119216, 4.122805, 3.042748>,
				<0.704331, 0.697413, 0.081556>, <-2.934880, 4.207565, 3.108737>
			}
			smooth_triangle {
				<0.720971, 0.682953, 0.053704>, <-3.119216, 4.122805, 3.042748>,
				<0.729591, 0.670103, 0.088153>, <-3.024643, 4.040591, 3.241393>,
				<0.704331, 0.697413, 0.081556>, <-2.934880, 4.207565, 3.108737>
			}
			smooth_triangle {
				<0.746783, 0.634253, 0.170745>, <-3.250946, 4.472775, 4.289135>,
				<0.718411, 0.668293, 0.162400>, <-2.689498, 4.029879, 3.535918>,
				<0.739088, 0.653323, 0.126617>, <-2.923895, 3.937464, 3.452960>
			}
			smooth_triangle {
				<0.718411, 0.668293, 0.162400>, <-2.689498, 4.029879, 3.535918>,
				<0.711623, 0.684183, 0.120801>, <-2.817226, 4.126093, 3.319226>,
				<0.739088, 0.653323, 0.126617>, <-2.923895, 3.937464, 3.452960>
			}
			smooth_triangle {
				<0.704331, 0.697413, 0.081556>, <-2.934880, 4.207565, 3.108737>,
				<0.729591, 0.670103, 0.088153>, <-3.024643, 4.040591, 3.241393>,
				<0.711623, 0.684183, 0.120801>, <-2.817226, 4.126093, 3.319226>
			}
			smooth_triangle {
				<0.729591, 0.670103, 0.088153>, <-3.024643, 4.040591, 3.241393>,
				<0.739088, 0.653323, 0.126617>, <-2.923895, 3.937464, 3.452960>,
				<0.711623, 0.684183, 0.120801>, <-2.817226, 4.126093, 3.319226>
			}
			smooth_triangle {
				<0.697600, 0.707473, 0.044022>, <-1.520477, 2.111643, 1.492336>,
				<0.704331, 0.697413, 0.081556>, <-2.934880, 4.207565, 3.108737>,
				<0.678465, 0.723763, 0.070456>, <-1.423419, 2.158988, 1.519923>
			}
			smooth_triangle {
				<0.723355, 0.651233, 0.204385>, <-2.548008, 3.934070, 3.742727>,
				<0.695079, 0.683453, 0.197134>, <-2.442837, 4.121903, 3.607780>,
				<0.718411, 0.668293, 0.162400>, <-2.689498, 4.029879, 3.535918>
			}
			smooth_triangle {
				<0.656325, 0.740633, 0.099020>, <-1.315512, 2.209000, 1.544919>,
				<0.684264, 0.713063, 0.111501>, <-2.726475, 4.301569, 3.168841>,
				<0.660924, 0.729323, 0.142756>, <-2.498302, 4.399921, 3.221091>
			}
			smooth_triangle {
				<0.660924, 0.729323, 0.142756>, <-2.498302, 4.399921, 3.221091>,
				<0.684264, 0.713063, 0.111501>, <-2.726475, 4.301569, 3.168841>,
				<0.690018, 0.699573, 0.153563>, <-2.591357, 4.218751, 3.385797>
			}
			smooth_triangle {
				<0.684264, 0.713063, 0.111501>, <-2.726475, 4.301569, 3.168841>,
				<0.711623, 0.684183, 0.120801>, <-2.817226, 4.126093, 3.319226>,
				<0.690018, 0.699573, 0.153563>, <-2.591357, 4.218751, 3.385797>
			}
			smooth_triangle {
				<0.711623, 0.684183, 0.120801>, <-2.817226, 4.126093, 3.319226>,
				<0.718411, 0.668293, 0.162400>, <-2.689498, 4.029879, 3.535918>,
				<0.690018, 0.699573, 0.153563>, <-2.591357, 4.218751, 3.385797>
			}
			smooth_triangle {
				<0.660924, 0.729323, 0.142756>, <-2.498302, 4.399921, 3.221091>,
				<0.690018, 0.699573, 0.153563>, <-2.591357, 4.218751, 3.385797>,
				<0.665577, 0.715303, 0.185638>, <-2.357253, 4.312314, 3.438534>
			}
			smooth_triangle {
				<0.718411, 0.668293, 0.162400>, <-2.689498, 4.029879, 3.535918>,
				<0.695079, 0.683453, 0.197134>, <-2.442837, 4.121903, 3.607780>,
				<0.690018, 0.699573, 0.153563>, <-2.591357, 4.218751, 3.385797>
			}
			smooth_triangle {
				<0.690018, 0.699573, 0.153563>, <-2.591357, 4.218751, 3.385797>,
				<0.695079, 0.683453, 0.197134>, <-2.442837, 4.121903, 3.607780>,
				<0.665577, 0.715303, 0.185638>, <-2.357253, 4.312314, 3.438534>
			}
			smooth_triangle {
				<0.711623, 0.684183, 0.120801>, <-2.817226, 4.126093, 3.319226>,
				<0.684264, 0.713063, 0.111501>, <-2.726475, 4.301569, 3.168841>,
				<0.704331, 0.697413, 0.081556>, <-2.934880, 4.207565, 3.108737>
			}
			smooth_triangle {
				<0.656325, 0.740633, 0.099020>, <-1.315512, 2.209000, 1.544919>,
				<0.678465, 0.723763, 0.070456>, <-1.423419, 2.158988, 1.519923>,
				<0.684264, 0.713063, 0.111501>, <-2.726475, 4.301569, 3.168841>
			}
			smooth_triangle {
				<0.684264, 0.713063, 0.111501>, <-2.726475, 4.301569, 3.168841>,
				<0.678465, 0.723763, 0.070456>, <-1.423419, 2.158988, 1.519923>,
				<0.704331, 0.697413, 0.081556>, <-2.934880, 4.207565, 3.108737>
			}
			smooth_triangle {
				<0.656325, 0.740633, 0.099020>, <-1.315512, 2.209000, 1.544919>,
				<0.660924, 0.729323, 0.142756>, <-2.498302, 4.399921, 3.221091>,
				<0.630272, 0.758213, 0.130293>, <-1.194534, 2.261162, 1.567316>
			}
			smooth_triangle {
				<0.665577, 0.715303, 0.185638>, <-2.357253, 4.312314, 3.438534>,
				<0.634828, 0.745223, 0.175332>, <-2.250975, 4.498809, 3.266232>,
				<0.660924, 0.729323, 0.142756>, <-2.498302, 4.399921, 3.221091>
			}
			smooth_triangle {
				<0.660924, 0.729323, 0.142756>, <-2.498302, 4.399921, 3.221091>,
				<0.634828, 0.745223, 0.175332>, <-2.250975, 4.498809, 3.266232>,
				<0.630272, 0.758213, 0.130293>, <-1.194534, 2.261162, 1.567316>
			}
			smooth_triangle {
				<0.799886, 0.590653, -0.020594>, <-1.855790, 1.824790, 1.491313>,
				<0.803978, 0.585293, 0.012954>, <-1.200460, 1.209610, 1.046314>,
				<0.779476, 0.617583, 0.011414>, <-4.743335, 4.963103, 4.102002>
			}
			smooth_triangle {
				<0.803978, 0.585293, 0.012954>, <-1.200460, 1.209610, 1.046314>,
				<0.799492, 0.589193, 0.052630>, <-2.868346, 2.982879, 2.802906>,
				<0.779476, 0.617583, 0.011414>, <-4.743335, 4.963103, 4.102002>
			}
			smooth_triangle {
				<0.799492, 0.589193, 0.052630>, <-2.868346, 2.982879, 2.802906>,
				<0.776549, 0.618683, 0.057523>, <-2.807110, 3.105945, 2.730850>,
				<0.779476, 0.617583, 0.011414>, <-4.743335, 4.963103, 4.102002>
			}
			smooth_triangle {
				<0.799886, 0.590653, -0.020594>, <-1.855790, 1.824790, 1.491313>,
				<0.779476, 0.617583, 0.011414>, <-4.743335, 4.963103, 4.102002>,
				<0.777532, 0.618923, -0.038663>, <-4.358973, 4.354516, 3.318900>
			}
			smooth_triangle {
				<0.779476, 0.617583, 0.011414>, <-4.743335, 4.963103, 4.102002>,
				<0.761868, 0.638963, -0.019697>, <-2.998476, 3.205560, 2.392246>,
				<0.777532, 0.618923, -0.038663>, <-4.358973, 4.354516, 3.318900>
			}
			smooth_triangle {
				<0.761868, 0.638963, -0.019697>, <-2.998476, 3.205560, 2.392246>,
				<0.779476, 0.617583, 0.011414>, <-4.743335, 4.963103, 4.102002>,
				<0.751783, 0.651073, 0.005201>, <-3.453281, 3.923172, 2.944123>
			}
			smooth_triangle {
				<0.776549, 0.618683, 0.057523>, <-2.807110, 3.105945, 2.730850>,
				<0.757610, 0.642973, 0.041549>, <-3.344472, 3.872031, 3.131058>,
				<0.779476, 0.617583, 0.011414>, <-4.743335, 4.963103, 4.102002>
			}
			smooth_triangle {
				<0.779476, 0.617583, 0.011414>, <-4.743335, 4.963103, 4.102002>,
				<0.757610, 0.642973, 0.041549>, <-3.344472, 3.872031, 3.131058>,
				<0.751783, 0.651073, 0.005201>, <-3.453281, 3.923172, 2.944123>
			}
			smooth_triangle {
				<0.777532, 0.618923, -0.038663>, <-4.358973, 4.354516, 3.318900>,
				<0.761868, 0.638963, -0.019697>, <-2.998476, 3.205560, 2.392246>,
				<0.755376, 0.645043, -0.049339>, <-1.840146, 1.922360, 1.384527>
			}
			smooth_triangle {
				<0.751783, 0.651073, 0.005201>, <-3.453281, 3.923172, 2.944123>,
				<0.742970, 0.660583, -0.027128>, <-1.765077, 1.972327, 1.411699>,
				<0.761868, 0.638963, -0.019697>, <-2.998476, 3.205560, 2.392246>
			}
			smooth_triangle {
				<0.761868, 0.638963, -0.019697>, <-2.998476, 3.205560, 2.392246>,
				<0.742970, 0.660583, -0.027128>, <-1.765077, 1.972327, 1.411699>,
				<0.755376, 0.645043, -0.049339>, <-1.840146, 1.922360, 1.384527>
			}
			smooth_triangle {
				<0.755376, 0.645043, -0.049339>, <-1.840146, 1.922360, 1.384527>,
				<0.766854, 0.629253, -0.071332>, <-1.254978, 1.261423, 0.913115>,
				<0.777532, 0.618923, -0.038663>, <-4.358973, 4.354516, 3.318900>
			}
			smooth_triangle {
				<0.766854, 0.629253, -0.071332>, <-1.254978, 1.261423, 0.913115>,
				<0.779950, 0.613473, -0.066630>, <-1.267728, 1.239529, 0.925192>,
				<0.777532, 0.618923, -0.038663>, <-4.358973, 4.354516, 3.318900>
			}
			smooth_triangle {
				<0.779950, 0.613473, -0.066630>, <-1.267728, 1.239529, 0.925192>,
				<0.795235, 0.594763, -0.054405>, <-1.269385, 1.217370, 0.952038>,
				<0.777532, 0.618923, -0.038663>, <-4.358973, 4.354516, 3.318900>
			}
			smooth_triangle {
				<0.795235, 0.594763, -0.054405>, <-1.269385, 1.217370, 0.952038>,
				<0.799886, 0.590653, -0.020594>, <-1.855790, 1.824790, 1.491313>,
				<0.777532, 0.618923, -0.038663>, <-4.358973, 4.354516, 3.318900>
			}
			smooth_triangle {
				<0.770016, 0.607443, 0.164892>, <-1.464911, 1.855898, 1.845657>,
				<0.766193, 0.620443, 0.130792>, <-3.035559, 3.743775, 3.570016>,
				<0.793693, 0.582753, 0.139855>, <-1.573852, 1.795481, 1.815606>
			}
			smooth_triangle {
				<0.757610, 0.642973, 0.041549>, <-3.344472, 3.872031, 3.131058>,
				<0.776549, 0.618683, 0.057523>, <-2.807110, 3.105945, 2.730850>,
				<0.757268, 0.638983, 0.085868>, <-3.690458, 4.492193, 3.894883>
			}
			smooth_triangle {
				<0.776549, 0.618683, 0.057523>, <-2.807110, 3.105945, 2.730850>,
				<0.799492, 0.589193, 0.052630>, <-2.868346, 2.982879, 2.802906>,
				<0.785571, 0.602343, 0.095811>, <-3.261244, 3.625840, 3.491364>
			}
			smooth_triangle {
				<0.793693, 0.582753, 0.139855>, <-1.573852, 1.795481, 1.815606>,
				<0.785571, 0.602343, 0.095811>, <-3.261244, 3.625840, 3.491364>,
				<0.814814, 0.560043, 0.107434>, <-1.675968, 1.748483, 1.769760>
			}
			smooth_triangle {
				<0.814814, 0.560043, 0.107434>, <-1.675968, 1.748483, 1.769760>,
				<0.799492, 0.589193, 0.052630>, <-2.868346, 2.982879, 2.802906>,
				<0.821001, 0.557923, 0.061539>, <-0.567543, 0.580615, 0.583765>
			}
			smooth_triangle {
				<0.814814, 0.560043, 0.107434>, <-1.675968, 1.748483, 1.769760>,
				<0.785571, 0.602343, 0.095811>, <-3.261244, 3.625840, 3.491364>,
				<0.799492, 0.589193, 0.052630>, <-2.868346, 2.982879, 2.802906>
			}
			smooth_triangle {
				<0.776549, 0.618683, 0.057523>, <-2.807110, 3.105945, 2.730850>,
				<0.785571, 0.602343, 0.095811>, <-3.261244, 3.625840, 3.491364>,
				<0.757268, 0.638983, 0.085868>, <-3.690458, 4.492193, 3.894883>
			}
			smooth_triangle {
				<0.793693, 0.582753, 0.139855>, <-1.573852, 1.795481, 1.815606>,
				<0.766193, 0.620443, 0.130792>, <-3.035559, 3.743775, 3.570016>,
				<0.785571, 0.602343, 0.095811>, <-3.261244, 3.625840, 3.491364>
			}
			smooth_triangle {
				<0.785571, 0.602343, 0.095811>, <-3.261244, 3.625840, 3.491364>,
				<0.766193, 0.620443, 0.130792>, <-3.035559, 3.743775, 3.570016>,
				<0.757268, 0.638983, 0.085868>, <-3.690458, 4.492193, 3.894883>
			}
			smooth_triangle {
				<0.635659, 0.670163, -0.368678>, <-4.367381, 4.042310, 0.762926>,
				<0.648385, 0.664443, -0.356669>, <-1.458076, 1.341761, 0.271287>,
				<0.636576, 0.677713, -0.352960>, <-2.871136, 2.732426, 0.537579>
			}
			smooth_triangle {
				<0.549476, 0.761002, -0.328710>, <-1.914139, 2.287102, 0.323299>,
				<0.549970, 0.753262, -0.345312>, <-2.596396, 3.020741, 0.363530>,
				<0.564105, 0.748842, -0.331873>, <-3.893772, 4.517135, 0.654925>
			}
			smooth_triangle {
				<0.533066, 0.807522, -0.229892>, <-2.233436, 3.246627, 0.684451>,
				<0.552678, 0.793192, -0.233465>, <-3.459152, 4.783657, 1.068852>,
				<0.542679, 0.805182, -0.215153>, <-2.802116, 4.027826, 0.958161>
			}
			smooth_triangle {
				<0.661166, 0.715733, -0.199230>, <-3.825973, 4.319163, 1.643216>,
				<0.645154, 0.726413, -0.212633>, <-3.804156, 4.382713, 1.521133>,
				<0.656550, 0.712393, -0.224846>, <-3.228699, 3.597537, 1.277050>
			}
			smooth_triangle {
				<0.629173, 0.736133, -0.226638>, <-3.783806, 4.442767, 1.392193>,
				<0.642600, 0.722463, -0.232852>, <-3.867915, 4.362160, 1.416473>,
				<0.645154, 0.726413, -0.212633>, <-3.804156, 4.382713, 1.521133>
			}
			smooth_triangle {
				<0.645154, 0.726413, -0.212633>, <-3.804156, 4.382713, 1.521133>,
				<0.642600, 0.722463, -0.232852>, <-3.867915, 4.362160, 1.416473>,
				<0.656550, 0.712393, -0.224846>, <-3.228699, 3.597537, 1.277050>
			}
			smooth_triangle {
				<0.652298, 0.712673, -0.236042>, <-2.623005, 2.867834, 0.945524>,
				<0.656550, 0.712393, -0.224846>, <-3.228699, 3.597537, 1.277050>,
				<0.642600, 0.722463, -0.232852>, <-3.867915, 4.362160, 1.416473>
			}
			smooth_triangle {
				<0.652298, 0.712673, -0.236042>, <-2.623005, 2.867834, 0.945524>,
				<0.642600, 0.722463, -0.232852>, <-3.867915, 4.362160, 1.416473>,
				<0.642841, 0.716483, -0.250051>, <-3.940728, 4.322637, 1.334418>
			}
			smooth_triangle {
				<0.629173, 0.736133, -0.226638>, <-3.783806, 4.442767, 1.392193>,
				<0.628728, 0.730003, -0.246785>, <-3.860102, 4.405885, 1.297115>,
				<0.642600, 0.722463, -0.232852>, <-3.867915, 4.362160, 1.416473>
			}
			smooth_triangle {
				<0.642600, 0.722463, -0.232852>, <-3.867915, 4.362160, 1.416473>,
				<0.628728, 0.730003, -0.246785>, <-3.860102, 4.405885, 1.297115>,
				<0.642841, 0.716483, -0.250051>, <-3.940728, 4.322637, 1.334418>
			}
			smooth_triangle {
				<0.629173, 0.736133, -0.226638>, <-3.783806, 4.442767, 1.392193>,
				<0.645154, 0.726413, -0.212633>, <-3.804156, 4.382713, 1.521133>,
				<0.631233, 0.741033, -0.203772>, <-3.704371, 4.472223, 1.506452>
			}
			smooth_triangle {
				<0.661166, 0.715733, -0.199230>, <-3.825973, 4.319163, 1.643216>,
				<0.648978, 0.729723, -0.188272>, <-3.727556, 4.403022, 1.646565>,
				<0.645154, 0.726413, -0.212633>, <-3.804156, 4.382713, 1.521133>
			}
			smooth_triangle {
				<0.645154, 0.726413, -0.212633>, <-3.804156, 4.382713, 1.521133>,
				<0.648978, 0.729723, -0.188272>, <-3.727556, 4.403022, 1.646565>,
				<0.631233, 0.741033, -0.203772>, <-3.704371, 4.472223, 1.506452>
			}
			smooth_triangle {
				<0.628728, 0.730003, -0.246785>, <-3.860102, 4.405885, 1.297115>,
				<0.629173, 0.736133, -0.226638>, <-3.783806, 4.442767, 1.392193>,
				<0.612911, 0.744623, -0.242860>, <-3.772308, 4.493319, 1.254300>
			}
			smooth_triangle {
				<0.631233, 0.741033, -0.203772>, <-3.704371, 4.472223, 1.506452>,
				<0.613163, 0.751273, -0.220749>, <-3.686943, 4.533593, 1.358412>,
				<0.629173, 0.736133, -0.226638>, <-3.783806, 4.442767, 1.392193>
			}
			smooth_triangle {
				<0.629173, 0.736133, -0.226638>, <-3.783806, 4.442767, 1.392193>,
				<0.613163, 0.751273, -0.220749>, <-3.686943, 4.533593, 1.358412>,
				<0.612911, 0.744623, -0.242860>, <-3.772308, 4.493319, 1.254300>
			}
			smooth_triangle {
				<0.613163, 0.751273, -0.220749>, <-3.686943, 4.533593, 1.358412>,
				<0.631233, 0.741033, -0.203772>, <-3.704371, 4.472223, 1.506452>,
				<0.614783, 0.756763, -0.196104>, <-3.598278, 4.567174, 1.477918>
			}
			smooth_triangle {
				<0.648978, 0.729723, -0.188272>, <-3.727556, 4.403022, 1.646565>,
				<0.634657, 0.744763, -0.177926>, <-3.619716, 4.494803, 1.638671>,
				<0.631233, 0.741033, -0.203772>, <-3.704371, 4.472223, 1.506452>
			}
			smooth_triangle {
				<0.631233, 0.741033, -0.203772>, <-3.704371, 4.472223, 1.506452>,
				<0.634657, 0.744763, -0.177926>, <-3.619716, 4.494803, 1.638671>,
				<0.614783, 0.756763, -0.196104>, <-3.598278, 4.567174, 1.477918>
			}
			smooth_triangle {
				<0.612911, 0.744623, -0.242860>, <-3.772308, 4.493319, 1.254300>,
				<0.613163, 0.751273, -0.220749>, <-3.686943, 4.533593, 1.358412>,
				<0.594950, 0.760283, -0.239015>, <-3.674578, 4.587180, 1.202910>
			}
			smooth_triangle {
				<0.614783, 0.756763, -0.196104>, <-3.598278, 4.567174, 1.477918>,
				<0.594500, 0.767542, -0.215780>, <-3.580481, 4.631994, 1.309731>,
				<0.613163, 0.751273, -0.220749>, <-3.686943, 4.533593, 1.358412>
			}
			smooth_triangle {
				<0.613163, 0.751273, -0.220749>, <-3.686943, 4.533593, 1.358412>,
				<0.594500, 0.767542, -0.215780>, <-3.580481, 4.631994, 1.309731>,
				<0.594950, 0.760283, -0.239015>, <-3.674578, 4.587180, 1.202910>
			}
			smooth_triangle {
				<0.594500, 0.767542, -0.215780>, <-3.580481, 4.631994, 1.309731>,
				<0.614783, 0.756763, -0.196104>, <-3.598278, 4.567174, 1.477918>,
				<0.595422, 0.773643, -0.189884>, <-3.483718, 4.669221, 1.432040>
			}
			smooth_triangle {
				<0.634657, 0.744763, -0.177926>, <-3.619716, 4.494803, 1.638671>,
				<0.617967, 0.760873, -0.168243>, <-3.503738, 4.592437, 1.619252>,
				<0.614783, 0.756763, -0.196104>, <-3.598278, 4.567174, 1.477918>
			}
			smooth_triangle {
				<0.614783, 0.756763, -0.196104>, <-3.598278, 4.567174, 1.477918>,
				<0.617967, 0.760873, -0.168243>, <-3.503738, 4.592437, 1.619252>,
				<0.595422, 0.773643, -0.189884>, <-3.483718, 4.669221, 1.432040>
			}
			smooth_triangle {
				<0.594950, 0.760283, -0.239015>, <-3.674578, 4.587180, 1.202910>,
				<0.594500, 0.767542, -0.215780>, <-3.580481, 4.631994, 1.309731>,
				<0.574611, 0.776712, -0.235904>, <-3.568346, 4.686504, 1.137832>
			}
			smooth_triangle {
				<0.595422, 0.773643, -0.189884>, <-3.483718, 4.669221, 1.432040>,
				<0.572392, 0.785002, -0.212724>, <-3.461765, 4.739689, 1.240841>,
				<0.594500, 0.767542, -0.215780>, <-3.580481, 4.631994, 1.309731>
			}
			smooth_triangle {
				<0.594500, 0.767542, -0.215780>, <-3.580481, 4.631994, 1.309731>,
				<0.572392, 0.785002, -0.212724>, <-3.461765, 4.739689, 1.240841>,
				<0.574611, 0.776712, -0.235904>, <-3.568346, 4.686504, 1.137832>
			}
			smooth_triangle {
				<0.572392, 0.785002, -0.212724>, <-3.461765, 4.739689, 1.240841>,
				<0.595422, 0.773643, -0.189884>, <-3.483718, 4.669221, 1.432040>,
				<0.572537, 0.791672, -0.185902>, <-3.362925, 4.777938, 1.359015>
			}
			smooth_triangle {
				<0.617967, 0.760873, -0.168243>, <-3.503738, 4.592437, 1.619252>,
				<0.598350, 0.778103, -0.160149>, <-3.382538, 4.695481, 1.580172>,
				<0.595422, 0.773643, -0.189884>, <-3.483718, 4.669221, 1.432040>
			}
			smooth_triangle {
				<0.595422, 0.773643, -0.189884>, <-3.483718, 4.669221, 1.432040>,
				<0.598350, 0.778103, -0.160149>, <-3.382538, 4.695481, 1.580172>,
				<0.572537, 0.791672, -0.185902>, <-3.362925, 4.777938, 1.359015>
			}
			smooth_triangle {
				<0.574611, 0.776712, -0.235904>, <-3.568346, 4.686504, 1.137832>,
				<0.572392, 0.785002, -0.212724>, <-3.461765, 4.739689, 1.240841>,
				<0.552678, 0.793192, -0.233465>, <-3.459152, 4.783657, 1.068852>
			}
			smooth_triangle {
				<0.572537, 0.791672, -0.185902>, <-3.362925, 4.777938, 1.359015>,
				<0.542679, 0.805182, -0.215153>, <-2.802116, 4.027826, 0.958161>,
				<0.572392, 0.785002, -0.212724>, <-3.461765, 4.739689, 1.240841>
			}
			smooth_triangle {
				<0.572392, 0.785002, -0.212724>, <-3.461765, 4.739689, 1.240841>,
				<0.542679, 0.805182, -0.215153>, <-2.802116, 4.027826, 0.958161>,
				<0.552678, 0.793192, -0.233465>, <-3.459152, 4.783657, 1.068852>
			}
			smooth_triangle {
				<0.642841, 0.716483, -0.250051>, <-3.940728, 4.322637, 1.334418>,
				<0.628728, 0.730003, -0.246785>, <-3.860102, 4.405885, 1.297115>,
				<0.629862, 0.722603, -0.265020>, <-3.937803, 4.359306, 1.218576>
			}
			smooth_triangle {
				<0.533066, 0.807522, -0.229892>, <-2.233436, 3.246627, 0.684451>,
				<0.537144, 0.798612, -0.250624>, <-1.737805, 2.396225, 0.487237>,
				<0.552678, 0.793192, -0.233465>, <-3.459152, 4.783657, 1.068852>
			}
			smooth_triangle {
				<0.537144, 0.798612, -0.250624>, <-1.737805, 2.396225, 0.487237>,
				<0.554730, 0.784642, -0.256347>, <-4.153506, 5.518553, 1.133476>,
				<0.552678, 0.793192, -0.233465>, <-3.459152, 4.783657, 1.068852>
			}
			smooth_triangle {
				<0.629862, 0.722603, -0.265020>, <-3.937803, 4.359306, 1.218576>,
				<0.628728, 0.730003, -0.246785>, <-3.860102, 4.405885, 1.297115>,
				<0.613958, 0.736883, -0.263019>, <-3.854451, 4.447440, 1.164954>
			}
			smooth_triangle {
				<0.628728, 0.730003, -0.246785>, <-3.860102, 4.405885, 1.297115>,
				<0.612911, 0.744623, -0.242860>, <-3.772308, 4.493319, 1.254300>,
				<0.613958, 0.736883, -0.263019>, <-3.854451, 4.447440, 1.164954>
			}
			smooth_triangle {
				<0.552678, 0.793192, -0.233465>, <-3.459152, 4.783657, 1.068852>,
				<0.554730, 0.784642, -0.256347>, <-4.153506, 5.518553, 1.133476>,
				<0.574611, 0.776712, -0.235904>, <-3.568346, 4.686504, 1.137832>
			}
			smooth_triangle {
				<0.554730, 0.784642, -0.256347>, <-4.153506, 5.518553, 1.133476>,
				<0.576798, 0.768082, -0.257816>, <-3.662941, 4.634787, 1.045754>,
				<0.574611, 0.776712, -0.235904>, <-3.568346, 4.686504, 1.137832>
			}
			smooth_triangle {
				<0.613958, 0.736883, -0.263019>, <-3.854451, 4.447440, 1.164954>,
				<0.612911, 0.744623, -0.242860>, <-3.772308, 4.493319, 1.254300>,
				<0.596202, 0.752123, -0.260704>, <-3.765351, 4.537670, 1.106534>
			}
			smooth_triangle {
				<0.612911, 0.744623, -0.242860>, <-3.772308, 4.493319, 1.254300>,
				<0.594950, 0.760283, -0.239015>, <-3.674578, 4.587180, 1.202910>,
				<0.596202, 0.752123, -0.260704>, <-3.765351, 4.537670, 1.106534>
			}
			smooth_triangle {
				<0.574611, 0.776712, -0.235904>, <-3.568346, 4.686504, 1.137832>,
				<0.576798, 0.768082, -0.257816>, <-3.662941, 4.634787, 1.045754>,
				<0.594950, 0.760283, -0.239015>, <-3.674578, 4.587180, 1.202910>
			}
			smooth_triangle {
				<0.594950, 0.760283, -0.239015>, <-3.674578, 4.587180, 1.202910>,
				<0.576798, 0.768082, -0.257816>, <-3.662941, 4.634787, 1.045754>,
				<0.596202, 0.752123, -0.260704>, <-3.765351, 4.537670, 1.106534>
			}
			smooth_triangle {
				<0.629862, 0.722603, -0.265020>, <-3.937803, 4.359306, 1.218576>,
				<0.613958, 0.736883, -0.263019>, <-3.854451, 4.447440, 1.164954>,
				<0.616574, 0.728413, -0.279939>, <-3.931287, 4.396628, 1.100016>
			}
			smooth_triangle {
				<0.537144, 0.798612, -0.250624>, <-1.737805, 2.396225, 0.487237>,
				<0.539537, 0.792002, -0.265974>, <-1.180282, 1.585390, 0.305478>,
				<0.554730, 0.784642, -0.256347>, <-4.153506, 5.518553, 1.133476>
			}
			smooth_triangle {
				<0.616574, 0.728413, -0.279939>, <-3.931287, 4.396628, 1.100016>,
				<0.613958, 0.736883, -0.263019>, <-3.854451, 4.447440, 1.164954>,
				<0.598302, 0.742522, -0.282517>, <-4.498422, 5.229798, 1.185142>
			}
			smooth_triangle {
				<0.613958, 0.736883, -0.263019>, <-3.854451, 4.447440, 1.164954>,
				<0.596202, 0.752123, -0.260704>, <-3.765351, 4.537670, 1.106534>,
				<0.598302, 0.742522, -0.282517>, <-4.498422, 5.229798, 1.185142>
			}
			smooth_triangle {
				<0.598302, 0.742522, -0.282517>, <-4.498422, 5.229798, 1.185142>,
				<0.596202, 0.752123, -0.260704>, <-3.765351, 4.537670, 1.106534>,
				<0.578940, 0.759142, -0.278646>, <-3.755470, 4.579448, 0.958080>
			}
			smooth_triangle {
				<0.596202, 0.752123, -0.260704>, <-3.765351, 4.537670, 1.106534>,
				<0.576798, 0.768082, -0.257816>, <-3.662941, 4.634787, 1.045754>,
				<0.578940, 0.759142, -0.278646>, <-3.755470, 4.579448, 0.958080>
			}
			smooth_triangle {
				<0.578940, 0.759142, -0.278646>, <-3.755470, 4.579448, 0.958080>,
				<0.576798, 0.768082, -0.257816>, <-3.662941, 4.634787, 1.045754>,
				<0.559912, 0.774232, -0.275995>, <-3.657194, 4.670281, 0.898148>
			}
			smooth_triangle {
				<0.576798, 0.768082, -0.257816>, <-3.662941, 4.634787, 1.045754>,
				<0.554730, 0.784642, -0.256347>, <-4.153506, 5.518553, 1.133476>,
				<0.559912, 0.774232, -0.275995>, <-3.657194, 4.670281, 0.898148>
			}
			smooth_triangle {
				<0.540890, 0.788182, -0.274458>, <-1.798414, 2.360717, 0.438523>,
				<0.554730, 0.784642, -0.256347>, <-4.153506, 5.518553, 1.133476>,
				<0.539537, 0.792002, -0.265974>, <-1.180282, 1.585390, 0.305478>
			}
			smooth_triangle {
				<0.540890, 0.788182, -0.274458>, <-1.798414, 2.360717, 0.438523>,
				<0.559912, 0.774232, -0.275995>, <-3.657194, 4.670281, 0.898148>,
				<0.554730, 0.784642, -0.256347>, <-4.153506, 5.518553, 1.133476>
			}
			smooth_triangle {
				<0.616574, 0.728413, -0.279939>, <-3.931287, 4.396628, 1.100016>,
				<0.598302, 0.742522, -0.282517>, <-4.498422, 5.229798, 1.185142>,
				<0.607129, 0.731093, -0.293279>, <-3.283268, 3.677297, 0.833677>
			}
			smooth_triangle {
				<0.540890, 0.788182, -0.274458>, <-1.798414, 2.360717, 0.438523>,
				<0.545222, 0.778582, -0.292662>, <-1.838334, 2.336759, 0.398872>,
				<0.559912, 0.774232, -0.275995>, <-3.657194, 4.670281, 0.898148>
			}
			smooth_triangle {
				<0.545222, 0.778582, -0.292662>, <-1.838334, 2.336759, 0.398872>,
				<0.561637, 0.765592, -0.295875>, <-3.742457, 4.618583, 0.809982>,
				<0.559912, 0.774232, -0.275995>, <-3.657194, 4.670281, 0.898148>
			}
			smooth_triangle {
				<0.559912, 0.774232, -0.275995>, <-3.657194, 4.670281, 0.898148>,
				<0.561637, 0.765592, -0.295875>, <-3.742457, 4.618583, 0.809982>,
				<0.578940, 0.759142, -0.278646>, <-3.755470, 4.579448, 0.958080>
			}
			smooth_triangle {
				<0.561637, 0.765592, -0.295875>, <-3.742457, 4.618583, 0.809982>,
				<0.579417, 0.751112, -0.298706>, <-3.833773, 4.532329, 0.868167>,
				<0.578940, 0.759142, -0.278646>, <-3.755470, 4.579448, 0.958080>
			}
			smooth_triangle {
				<0.579417, 0.751112, -0.298706>, <-3.833773, 4.532329, 0.868167>,
				<0.598302, 0.742522, -0.282517>, <-4.498422, 5.229798, 1.185142>,
				<0.578940, 0.759142, -0.278646>, <-3.755470, 4.579448, 0.958080>
			}
			smooth_triangle {
				<0.579417, 0.751112, -0.298706>, <-3.833773, 4.532329, 0.868167>,
				<0.594356, 0.737572, -0.303056>, <-3.918242, 4.452836, 0.902719>,
				<0.598302, 0.742522, -0.282517>, <-4.498422, 5.229798, 1.185142>
			}
			smooth_triangle {
				<0.594356, 0.737572, -0.303056>, <-3.918242, 4.452836, 0.902719>,
				<0.607129, 0.731093, -0.293279>, <-3.283268, 3.677297, 0.833677>,
				<0.598302, 0.742522, -0.282517>, <-4.498422, 5.229798, 1.185142>
			}
			smooth_triangle {
				<0.545222, 0.778582, -0.292662>, <-1.838334, 2.336759, 0.398872>,
				<0.542262, 0.772152, -0.314407>, <-1.875787, 2.313914, 0.356117>,
				<0.561637, 0.765592, -0.295875>, <-3.742457, 4.618583, 0.809982>
			}
			smooth_triangle {
				<0.594356, 0.737572, -0.303056>, <-3.918242, 4.452836, 0.902719>,
				<0.579417, 0.751112, -0.298706>, <-3.833773, 4.532329, 0.868167>,
				<0.579216, 0.743582, -0.317335>, <-3.906539, 4.486267, 0.779292>
			}
			smooth_triangle {
				<0.561637, 0.765592, -0.295875>, <-3.742457, 4.618583, 0.809982>,
				<0.542262, 0.772152, -0.314407>, <-1.875787, 2.313914, 0.356117>,
				<0.562871, 0.757212, -0.314520>, <-3.817764, 4.569933, 0.731019>
			}
			smooth_triangle {
				<0.542262, 0.772152, -0.314407>, <-1.875787, 2.313914, 0.356117>,
				<0.549476, 0.761002, -0.328710>, <-1.914139, 2.287102, 0.323299>,
				<0.562871, 0.757212, -0.314520>, <-3.817764, 4.569933, 0.731019>
			}
			smooth_triangle {
				<0.549476, 0.761002, -0.328710>, <-1.914139, 2.287102, 0.323299>,
				<0.564105, 0.748842, -0.331873>, <-3.893772, 4.517135, 0.654925>,
				<0.562871, 0.757212, -0.314520>, <-3.817764, 4.569933, 0.731019>
			}
			smooth_triangle {
				<0.561637, 0.765592, -0.295875>, <-3.742457, 4.618583, 0.809982>,
				<0.562871, 0.757212, -0.314520>, <-3.817764, 4.569933, 0.731019>,
				<0.579417, 0.751112, -0.298706>, <-3.833773, 4.532329, 0.868167>
			}
			smooth_triangle {
				<0.564105, 0.748842, -0.331873>, <-3.893772, 4.517135, 0.654925>,
				<0.579216, 0.743582, -0.317335>, <-3.906539, 4.486267, 0.779292>,
				<0.562871, 0.757212, -0.314520>, <-3.817764, 4.569933, 0.731019>
			}
			smooth_triangle {
				<0.562871, 0.757212, -0.314520>, <-3.817764, 4.569933, 0.731019>,
				<0.579216, 0.743582, -0.317335>, <-3.906539, 4.486267, 0.779292>,
				<0.579417, 0.751112, -0.298706>, <-3.833773, 4.532329, 0.868167>
			}
			smooth_triangle {
				<0.661166, 0.715733, -0.199230>, <-3.825973, 4.319163, 1.643216>,
				<0.656550, 0.712393, -0.224846>, <-3.228699, 3.597537, 1.277050>,
				<0.669746, 0.705023, -0.208544>, <-2.588780, 2.846788, 1.091745>
			}
			smooth_triangle {
				<0.656550, 0.712393, -0.224846>, <-3.228699, 3.597537, 1.277050>,
				<0.670010, 0.701133, -0.220488>, <-0.650509, 0.712870, 0.262020>,
				<0.669746, 0.705023, -0.208544>, <-2.588780, 2.846788, 1.091745>
			}
			smooth_triangle {
				<0.688991, 0.689683, -0.196810>, <-1.304972, 1.396176, 0.589362>,
				<0.697055, 0.683293, -0.190639>, <-1.973071, 2.065450, 0.916800>,
				<0.690408, 0.690613, -0.188416>, <-3.904930, 4.182111, 1.804842>
			}
			smooth_triangle {
				<0.598350, 0.778103, -0.160149>, <-3.382538, 4.695481, 1.580172>,
				<0.617967, 0.760873, -0.168243>, <-3.503738, 4.592437, 1.619252>,
				<0.622871, 0.763323, -0.135936>, <-3.399065, 4.607544, 1.789544>
			}
			smooth_triangle {
				<0.622871, 0.763323, -0.135936>, <-3.399065, 4.607544, 1.789544>,
				<0.617967, 0.760873, -0.168243>, <-3.503738, 4.592437, 1.619252>,
				<0.639604, 0.746863, -0.149037>, <-3.527838, 4.509248, 1.791804>
			}
			smooth_triangle {
				<0.617967, 0.760873, -0.168243>, <-3.503738, 4.592437, 1.619252>,
				<0.634657, 0.744763, -0.177926>, <-3.619716, 4.494803, 1.638671>,
				<0.639604, 0.746863, -0.149037>, <-3.527838, 4.509248, 1.791804>
			}
			smooth_triangle {
				<0.639604, 0.746863, -0.149037>, <-3.527838, 4.509248, 1.791804>,
				<0.634657, 0.744763, -0.177926>, <-3.619716, 4.494803, 1.638671>,
				<0.653663, 0.731903, -0.161748>, <-3.645687, 4.416510, 1.787392>
			}
			smooth_triangle {
				<0.634657, 0.744763, -0.177926>, <-3.619716, 4.494803, 1.638671>,
				<0.648978, 0.729723, -0.188272>, <-3.727556, 4.403022, 1.646565>,
				<0.653663, 0.731903, -0.161748>, <-3.645687, 4.416510, 1.787392>
			}
			smooth_triangle {
				<0.653663, 0.731903, -0.161748>, <-3.645687, 4.416510, 1.787392>,
				<0.648978, 0.729723, -0.188272>, <-3.727556, 4.403022, 1.646565>,
				<0.666534, 0.717333, -0.174023>, <-3.754050, 4.327765, 1.780387>
			}
			smooth_triangle {
				<0.648978, 0.729723, -0.188272>, <-3.727556, 4.403022, 1.646565>,
				<0.661166, 0.715733, -0.199230>, <-3.825973, 4.319163, 1.643216>,
				<0.666534, 0.717333, -0.174023>, <-3.754050, 4.327765, 1.780387>
			}
			smooth_triangle {
				<0.666534, 0.717333, -0.174023>, <-3.754050, 4.327765, 1.780387>,
				<0.661166, 0.715733, -0.199230>, <-3.825973, 4.319163, 1.643216>,
				<0.678692, 0.702583, -0.186744>, <-4.498689, 4.948538, 2.065127>
			}
			smooth_triangle {
				<0.661166, 0.715733, -0.199230>, <-3.825973, 4.319163, 1.643216>,
				<0.669746, 0.705023, -0.208544>, <-2.588780, 2.846788, 1.091745>,
				<0.678692, 0.702583, -0.186744>, <-4.498689, 4.948538, 2.065127>
			}
			smooth_triangle {
				<0.669746, 0.705023, -0.208544>, <-2.588780, 2.846788, 1.091745>,
				<0.682507, 0.693413, -0.206093>, <-1.948835, 2.110114, 0.865597>,
				<0.678692, 0.702583, -0.186744>, <-4.498689, 4.948538, 2.065127>
			}
			smooth_triangle {
				<0.682507, 0.693413, -0.206093>, <-1.948835, 2.110114, 0.865597>,
				<0.690408, 0.690613, -0.188416>, <-3.904930, 4.182111, 1.804842>,
				<0.678692, 0.702583, -0.186744>, <-4.498689, 4.948538, 2.065127>
			}
			smooth_triangle {
				<0.682507, 0.693413, -0.206093>, <-1.948835, 2.110114, 0.865597>,
				<0.688991, 0.689683, -0.196810>, <-1.304972, 1.396176, 0.589362>,
				<0.690408, 0.690613, -0.188416>, <-3.904930, 4.182111, 1.804842>
			}
			smooth_triangle {
				<0.549970, 0.753262, -0.345312>, <-2.596396, 3.020741, 0.363530>,
				<0.562638, 0.742042, -0.349179>, <-3.954468, 4.475804, 0.570040>,
				<0.564105, 0.748842, -0.331873>, <-3.893772, 4.517135, 0.654925>
			}
			smooth_triangle {
				<0.662994, 0.691273, -0.267758>, <-2.713145, 2.795990, 0.905234>,
				<0.645528, 0.707233, -0.268754>, <-4.694685, 4.977856, 1.474458>,
				<0.653350, 0.694983, -0.281492>, <-2.728510, 2.809702, 0.812147>
			}
			smooth_triangle {
				<0.616574, 0.728413, -0.279939>, <-3.931287, 4.396628, 1.100016>,
				<0.607129, 0.731093, -0.293279>, <-3.283268, 3.677297, 0.833677>,
				<0.618807, 0.720863, -0.294188>, <-4.001133, 4.347803, 1.041234>
			}
			smooth_triangle {
				<0.607129, 0.731093, -0.293279>, <-3.283268, 3.677297, 0.833677>,
				<0.594356, 0.737572, -0.303056>, <-3.918242, 4.452836, 0.902719>,
				<0.607108, 0.725632, -0.306590>, <-3.995410, 4.376902, 0.935762>
			}
			smooth_triangle {
				<0.562638, 0.742042, -0.349179>, <-3.954468, 4.475804, 0.570040>,
				<0.574033, 0.731102, -0.353676>, <-4.020774, 4.413866, 0.589504>,
				<0.579530, 0.735122, -0.335940>, <-4.640270, 5.176991, 0.812539>
			}
			smooth_triangle {
				<0.574033, 0.731102, -0.353676>, <-4.020774, 4.413866, 0.589504>,
				<0.586055, 0.725482, -0.345448>, <-3.371613, 3.648417, 0.564850>,
				<0.579530, 0.735122, -0.335940>, <-4.640270, 5.176991, 0.812539>
			}
			smooth_triangle {
				<0.607108, 0.725632, -0.306590>, <-3.995410, 4.376902, 0.935762>,
				<0.594058, 0.730762, -0.319685>, <-3.983794, 4.409719, 0.824133>,
				<0.607779, 0.718803, -0.320990>, <-4.054086, 4.335764, 0.872875>
			}
			smooth_triangle {
				<0.607779, 0.718803, -0.320990>, <-4.054086, 4.335764, 0.872875>,
				<0.594058, 0.730762, -0.319685>, <-3.983794, 4.409719, 0.824133>,
				<0.595493, 0.723153, -0.333983>, <-4.044950, 4.363927, 0.768794>
			}
			smooth_triangle {
				<0.594058, 0.730762, -0.319685>, <-3.983794, 4.409719, 0.824133>,
				<0.579530, 0.735122, -0.335940>, <-4.640270, 5.176991, 0.812539>,
				<0.595493, 0.723153, -0.333983>, <-4.044950, 4.363927, 0.768794>
			}
			smooth_triangle {
				<0.586055, 0.725482, -0.345448>, <-3.371613, 3.648417, 0.564850>,
				<0.595493, 0.723153, -0.333983>, <-4.044950, 4.363927, 0.768794>,
				<0.579530, 0.735122, -0.335940>, <-4.640270, 5.176991, 0.812539>
			}
			smooth_triangle {
				<0.562638, 0.742042, -0.349179>, <-3.954468, 4.475804, 0.570040>,
				<0.579530, 0.735122, -0.335940>, <-4.640270, 5.176991, 0.812539>,
				<0.564105, 0.748842, -0.331873>, <-3.893772, 4.517135, 0.654925>
			}
			smooth_triangle {
				<0.607108, 0.725632, -0.306590>, <-3.995410, 4.376902, 0.935762>,
				<0.594356, 0.737572, -0.303056>, <-3.918242, 4.452836, 0.902719>,
				<0.594058, 0.730762, -0.319685>, <-3.983794, 4.409719, 0.824133>
			}
			smooth_triangle {
				<0.594356, 0.737572, -0.303056>, <-3.918242, 4.452836, 0.902719>,
				<0.579216, 0.743582, -0.317335>, <-3.906539, 4.486267, 0.779292>,
				<0.594058, 0.730762, -0.319685>, <-3.983794, 4.409719, 0.824133>
			}
			smooth_triangle {
				<0.564105, 0.748842, -0.331873>, <-3.893772, 4.517135, 0.654925>,
				<0.579530, 0.735122, -0.335940>, <-4.640270, 5.176991, 0.812539>,
				<0.579216, 0.743582, -0.317335>, <-3.906539, 4.486267, 0.779292>
			}
			smooth_triangle {
				<0.579530, 0.735122, -0.335940>, <-4.640270, 5.176991, 0.812539>,
				<0.594058, 0.730762, -0.319685>, <-3.983794, 4.409719, 0.824133>,
				<0.579216, 0.743582, -0.317335>, <-3.906539, 4.486267, 0.779292>
			}
			smooth_triangle {
				<0.607779, 0.718803, -0.320990>, <-4.054086, 4.335764, 0.872875>,
				<0.595493, 0.723153, -0.333983>, <-4.044950, 4.363927, 0.768794>,
				<0.608544, 0.711722, -0.335013>, <-4.111700, 4.293037, 0.812447>
			}
			smooth_triangle {
				<0.574033, 0.731102, -0.353676>, <-4.020774, 4.413866, 0.589504>,
				<0.584440, 0.721212, -0.356925>, <-4.085302, 4.350639, 0.616036>,
				<0.586055, 0.725482, -0.345448>, <-3.371613, 3.648417, 0.564850>
			}
			smooth_triangle {
				<0.584440, 0.721212, -0.356925>, <-4.085302, 4.350639, 0.616036>,
				<0.596353, 0.716452, -0.346648>, <-4.101525, 4.320564, 0.712320>,
				<0.586055, 0.725482, -0.345448>, <-3.371613, 3.648417, 0.564850>
			}
			smooth_triangle {
				<0.608544, 0.711722, -0.335013>, <-4.111700, 4.293037, 0.812447>,
				<0.595493, 0.723153, -0.333983>, <-4.044950, 4.363927, 0.768794>,
				<0.596353, 0.716452, -0.346648>, <-4.101525, 4.320564, 0.712320>
			}
			smooth_triangle {
				<0.595493, 0.723153, -0.333983>, <-4.044950, 4.363927, 0.768794>,
				<0.586055, 0.725482, -0.345448>, <-3.371613, 3.648417, 0.564850>,
				<0.596353, 0.716452, -0.346648>, <-4.101525, 4.320564, 0.712320>
			}
			smooth_triangle {
				<0.607129, 0.731093, -0.293279>, <-3.283268, 3.677297, 0.833677>,
				<0.607108, 0.725632, -0.306590>, <-3.995410, 4.376902, 0.935762>,
				<0.618807, 0.720863, -0.294188>, <-4.001133, 4.347803, 1.041234>
			}
			smooth_triangle {
				<0.608544, 0.711722, -0.335013>, <-4.111700, 4.293037, 0.812447>,
				<0.620956, 0.706843, -0.322322>, <-4.120150, 4.263673, 0.917500>,
				<0.607779, 0.718803, -0.320990>, <-4.054086, 4.335764, 0.872875>
			}
			smooth_triangle {
				<0.620956, 0.706843, -0.322322>, <-4.120150, 4.263673, 0.917500>,
				<0.619811, 0.714123, -0.308176>, <-4.060242, 4.307390, 0.978443>,
				<0.607779, 0.718803, -0.320990>, <-4.054086, 4.335764, 0.872875>
			}
			smooth_triangle {
				<0.618807, 0.720863, -0.294188>, <-4.001133, 4.347803, 1.041234>,
				<0.607108, 0.725632, -0.306590>, <-3.995410, 4.376902, 0.935762>,
				<0.619811, 0.714123, -0.308176>, <-4.060242, 4.307390, 0.978443>
			}
			smooth_triangle {
				<0.607108, 0.725632, -0.306590>, <-3.995410, 4.376902, 0.935762>,
				<0.607779, 0.718803, -0.320990>, <-4.054086, 4.335764, 0.872875>,
				<0.619811, 0.714123, -0.308176>, <-4.060242, 4.307390, 0.978443>
			}
			smooth_triangle {
				<0.620956, 0.706843, -0.322322>, <-4.120150, 4.263673, 0.917500>,
				<0.632501, 0.702453, -0.309217>, <-4.121971, 4.237935, 1.022589>,
				<0.619811, 0.714123, -0.308176>, <-4.060242, 4.307390, 0.978443>
			}
			smooth_triangle {
				<0.629862, 0.722603, -0.265020>, <-3.937803, 4.359306, 1.218576>,
				<0.630570, 0.715763, -0.281384>, <-4.002820, 4.319362, 1.147416>,
				<0.645528, 0.707233, -0.268754>, <-4.694685, 4.977856, 1.474458>
			}
			smooth_triangle {
				<0.630570, 0.715763, -0.281384>, <-4.002820, 4.319362, 1.147416>,
				<0.631027, 0.709593, -0.295618>, <-4.062592, 4.280930, 1.079749>,
				<0.640808, 0.705293, -0.284662>, <-3.386960, 3.545784, 0.976555>
			}
			smooth_triangle {
				<0.631027, 0.709593, -0.295618>, <-4.062592, 4.280930, 1.079749>,
				<0.643095, 0.698533, -0.295953>, <-4.119437, 4.214152, 1.126047>,
				<0.640808, 0.705293, -0.284662>, <-3.386960, 3.545784, 0.976555>
			}
			smooth_triangle {
				<0.643095, 0.698533, -0.295953>, <-4.119437, 4.214152, 1.126047>,
				<0.653350, 0.694983, -0.281492>, <-2.728510, 2.809702, 0.812147>,
				<0.640808, 0.705293, -0.284662>, <-3.386960, 3.545784, 0.976555>
			}
			smooth_triangle {
				<0.630570, 0.715763, -0.281384>, <-4.002820, 4.319362, 1.147416>,
				<0.640808, 0.705293, -0.284662>, <-3.386960, 3.545784, 0.976555>,
				<0.645528, 0.707233, -0.268754>, <-4.694685, 4.977856, 1.474458>
			}
			smooth_triangle {
				<0.640808, 0.705293, -0.284662>, <-3.386960, 3.545784, 0.976555>,
				<0.653350, 0.694983, -0.281492>, <-2.728510, 2.809702, 0.812147>,
				<0.645528, 0.707233, -0.268754>, <-4.694685, 4.977856, 1.474458>
			}
			smooth_triangle {
				<0.631027, 0.709593, -0.295618>, <-4.062592, 4.280930, 1.079749>,
				<0.630570, 0.715763, -0.281384>, <-4.002820, 4.319362, 1.147416>,
				<0.618807, 0.720863, -0.294188>, <-4.001133, 4.347803, 1.041234>
			}
			smooth_triangle {
				<0.629862, 0.722603, -0.265020>, <-3.937803, 4.359306, 1.218576>,
				<0.616574, 0.728413, -0.279939>, <-3.931287, 4.396628, 1.100016>,
				<0.630570, 0.715763, -0.281384>, <-4.002820, 4.319362, 1.147416>
			}
			smooth_triangle {
				<0.630570, 0.715763, -0.281384>, <-4.002820, 4.319362, 1.147416>,
				<0.616574, 0.728413, -0.279939>, <-3.931287, 4.396628, 1.100016>,
				<0.618807, 0.720863, -0.294188>, <-4.001133, 4.347803, 1.041234>
			}
			smooth_triangle {
				<0.643095, 0.698533, -0.295953>, <-4.119437, 4.214152, 1.126047>,
				<0.631027, 0.709593, -0.295618>, <-4.062592, 4.280930, 1.079749>,
				<0.632501, 0.702453, -0.309217>, <-4.121971, 4.237935, 1.022589>
			}
			smooth_triangle {
				<0.618807, 0.720863, -0.294188>, <-4.001133, 4.347803, 1.041234>,
				<0.619811, 0.714123, -0.308176>, <-4.060242, 4.307390, 0.978443>,
				<0.631027, 0.709593, -0.295618>, <-4.062592, 4.280930, 1.079749>
			}
			smooth_triangle {
				<0.631027, 0.709593, -0.295618>, <-4.062592, 4.280930, 1.079749>,
				<0.619811, 0.714123, -0.308176>, <-4.060242, 4.307390, 0.978443>,
				<0.632501, 0.702453, -0.309217>, <-4.121971, 4.237935, 1.022589>
			}
			smooth_triangle {
				<0.629862, 0.722603, -0.265020>, <-3.937803, 4.359306, 1.218576>,
				<0.645528, 0.707233, -0.268754>, <-4.694685, 4.977856, 1.474458>,
				<0.642841, 0.716483, -0.250051>, <-3.940728, 4.322637, 1.334418>
			}
			smooth_triangle {
				<0.674449, 0.680203, -0.267501>, <-2.058474, 2.060749, 0.718105>,
				<0.673245, 0.690323, -0.243515>, <-3.397485, 3.464136, 1.205957>,
				<0.662994, 0.691273, -0.267758>, <-2.713145, 2.795990, 0.905234>
			}
			smooth_triangle {
				<0.645528, 0.707233, -0.268754>, <-4.694685, 4.977856, 1.474458>,
				<0.662994, 0.691273, -0.267758>, <-2.713145, 2.795990, 0.905234>,
				<0.657063, 0.703243, -0.250666>, <-4.013526, 4.238788, 1.385360>
			}
			smooth_triangle {
				<0.662994, 0.691273, -0.267758>, <-2.713145, 2.795990, 0.905234>,
				<0.673245, 0.690323, -0.243515>, <-3.397485, 3.464136, 1.205957>,
				<0.657063, 0.703243, -0.250666>, <-4.013526, 4.238788, 1.385360>
			}
			smooth_triangle {
				<0.673245, 0.690323, -0.243515>, <-3.397485, 3.464136, 1.205957>,
				<0.664552, 0.700703, -0.237696>, <-1.335030, 1.410258, 0.478179>,
				<0.657063, 0.703243, -0.250666>, <-4.013526, 4.238788, 1.385360>
			}
			smooth_triangle {
				<0.645528, 0.707233, -0.268754>, <-4.694685, 4.977856, 1.474458>,
				<0.657063, 0.703243, -0.250666>, <-4.013526, 4.238788, 1.385360>,
				<0.642841, 0.716483, -0.250051>, <-3.940728, 4.322637, 1.334418>
			}
			smooth_triangle {
				<0.664552, 0.700703, -0.237696>, <-1.335030, 1.410258, 0.478179>,
				<0.652298, 0.712673, -0.236042>, <-2.623005, 2.867834, 0.945524>,
				<0.657063, 0.703243, -0.250666>, <-4.013526, 4.238788, 1.385360>
			}
			smooth_triangle {
				<0.657063, 0.703243, -0.250666>, <-4.013526, 4.238788, 1.385360>,
				<0.652298, 0.712673, -0.236042>, <-2.623005, 2.867834, 0.945524>,
				<0.642841, 0.716483, -0.250051>, <-3.940728, 4.322637, 1.334418>
			}
			smooth_triangle {
				<0.695631, 0.664293, -0.252822>, <-2.078342, 2.017543, 0.780646>,
				<0.685325, 0.676993, -0.247229>, <-4.124913, 4.084530, 1.515392>,
				<0.686321, 0.669843, -0.263403>, <-1.385572, 1.356175, 0.490761>
			}
			smooth_triangle {
				<0.673245, 0.690323, -0.243515>, <-3.397485, 3.464136, 1.205957>,
				<0.674449, 0.680203, -0.267501>, <-2.058474, 2.060749, 0.718105>,
				<0.685325, 0.676993, -0.247229>, <-4.124913, 4.084530, 1.515392>
			}
			smooth_triangle {
				<0.674449, 0.680203, -0.267501>, <-2.058474, 2.060749, 0.718105>,
				<0.686321, 0.669843, -0.263403>, <-1.385572, 1.356175, 0.490761>,
				<0.685325, 0.676993, -0.247229>, <-4.124913, 4.084530, 1.515392>
			}
			smooth_triangle {
				<0.709250, 0.659533, -0.226028>, <-3.461382, 3.318009, 1.416714>,
				<0.708178, 0.664353, -0.214984>, <-2.061406, 1.996253, 0.874691>,
				<0.696990, 0.672213, -0.226823>, <-3.446559, 3.360671, 1.350923>
			}
			smooth_triangle {
				<0.673245, 0.690323, -0.243515>, <-3.397485, 3.464136, 1.205957>,
				<0.685325, 0.676993, -0.247229>, <-4.124913, 4.084530, 1.515392>,
				<0.684264, 0.684433, -0.229016>, <-1.363554, 1.367658, 0.519691>
			}
			smooth_triangle {
				<0.684264, 0.684433, -0.229016>, <-1.363554, 1.367658, 0.519691>,
				<0.685325, 0.676993, -0.247229>, <-4.124913, 4.084530, 1.515392>,
				<0.696990, 0.672213, -0.226823>, <-3.446559, 3.360671, 1.350923>
			}
			smooth_triangle {
				<0.695631, 0.664293, -0.252822>, <-2.078342, 2.017543, 0.780646>,
				<0.696990, 0.672213, -0.226823>, <-3.446559, 3.360671, 1.350923>,
				<0.685325, 0.676993, -0.247229>, <-4.124913, 4.084530, 1.515392>
			}
			smooth_triangle {
				<0.695631, 0.664293, -0.252822>, <-2.078342, 2.017543, 0.780646>,
				<0.706725, 0.655743, -0.244221>, <-2.083827, 1.997819, 0.816133>,
				<0.696990, 0.672213, -0.226823>, <-3.446559, 3.360671, 1.350923>
			}
			smooth_triangle {
				<0.706725, 0.655743, -0.244221>, <-2.083827, 1.997819, 0.816133>,
				<0.709250, 0.659533, -0.226028>, <-3.461382, 3.318009, 1.416714>,
				<0.696990, 0.672213, -0.226823>, <-3.446559, 3.360671, 1.350923>
			}
			smooth_triangle {
				<0.584440, 0.721212, -0.356925>, <-4.085302, 4.350639, 0.616036>,
				<0.594941, 0.711372, -0.359314>, <-4.142271, 4.291669, 0.648300>,
				<0.596353, 0.716452, -0.346648>, <-4.101525, 4.320564, 0.712320>
			}
			smooth_triangle {
				<0.635659, 0.670163, -0.368678>, <-4.367381, 4.042310, 0.762926>,
				<0.636576, 0.677713, -0.352960>, <-2.871136, 2.732426, 0.537579>,
				<0.623897, 0.682222, -0.366655>, <-4.306006, 4.113967, 0.728144>
			}
			smooth_triangle {
				<0.596353, 0.716452, -0.346648>, <-4.101525, 4.320564, 0.712320>,
				<0.594941, 0.711372, -0.359314>, <-4.142271, 4.291669, 0.648300>,
				<0.608114, 0.705302, -0.349076>, <-4.164502, 4.253873, 0.746896>
			}
			smooth_triangle {
				<0.594941, 0.711372, -0.359314>, <-4.142271, 4.291669, 0.648300>,
				<0.605256, 0.700773, -0.362905>, <-4.203223, 4.228151, 0.672516>,
				<0.608114, 0.705302, -0.349076>, <-4.164502, 4.253873, 0.746896>
			}
			smooth_triangle {
				<0.636576, 0.677713, -0.352960>, <-2.871136, 2.732426, 0.537579>,
				<0.621019, 0.691743, -0.353470>, <-4.945476, 4.869332, 0.908772>,
				<0.623897, 0.682222, -0.366655>, <-4.306006, 4.113967, 0.728144>
			}
			smooth_triangle {
				<0.608114, 0.705302, -0.349076>, <-4.164502, 4.253873, 0.746896>,
				<0.605256, 0.700773, -0.362905>, <-4.203223, 4.228151, 0.672516>,
				<0.621019, 0.691743, -0.353470>, <-4.945476, 4.869332, 0.908772>
			}
			smooth_triangle {
				<0.605256, 0.700773, -0.362905>, <-4.203223, 4.228151, 0.672516>,
				<0.613037, 0.691572, -0.367463>, <-3.547593, 3.477225, 0.566925>,
				<0.621019, 0.691743, -0.353470>, <-4.945476, 4.869332, 0.908772>
			}
			smooth_triangle {
				<0.613037, 0.691572, -0.367463>, <-3.547593, 3.477225, 0.566925>,
				<0.623897, 0.682222, -0.366655>, <-4.306006, 4.113967, 0.728144>,
				<0.621019, 0.691743, -0.353470>, <-4.945476, 4.869332, 0.908772>
			}
			smooth_triangle {
				<0.596353, 0.716452, -0.346648>, <-4.101525, 4.320564, 0.712320>,
				<0.608114, 0.705302, -0.349076>, <-4.164502, 4.253873, 0.746896>,
				<0.608544, 0.711722, -0.335013>, <-4.111700, 4.293037, 0.812447>
			}
			smooth_triangle {
				<0.636576, 0.677713, -0.352960>, <-2.871136, 2.732426, 0.537579>,
				<0.637317, 0.684623, -0.337983>, <-2.822277, 2.771676, 0.592531>,
				<0.621019, 0.691743, -0.353470>, <-4.945476, 4.869332, 0.908772>
			}
			smooth_triangle {
				<0.637317, 0.684623, -0.337983>, <-2.822277, 2.771676, 0.592531>,
				<0.621878, 0.699183, -0.336920>, <-4.182061, 4.216290, 0.853840>,
				<0.621019, 0.691743, -0.353470>, <-4.945476, 4.869332, 0.908772>
			}
			smooth_triangle {
				<0.608544, 0.711722, -0.335013>, <-4.111700, 4.293037, 0.812447>,
				<0.608114, 0.705302, -0.349076>, <-4.164502, 4.253873, 0.746896>,
				<0.621878, 0.699183, -0.336920>, <-4.182061, 4.216290, 0.853840>
			}
			smooth_triangle {
				<0.608114, 0.705302, -0.349076>, <-4.164502, 4.253873, 0.746896>,
				<0.621019, 0.691743, -0.353470>, <-4.945476, 4.869332, 0.908772>,
				<0.621878, 0.699183, -0.336920>, <-4.182061, 4.216290, 0.853840>
			}
			smooth_triangle {
				<0.653350, 0.694983, -0.281492>, <-2.728510, 2.809702, 0.812147>,
				<0.643095, 0.698533, -0.295953>, <-4.119437, 4.214152, 1.126047>,
				<0.655297, 0.687563, -0.294900>, <-2.079172, 2.085824, 0.570954>
			}
			smooth_triangle {
				<0.608544, 0.711722, -0.335013>, <-4.111700, 4.293037, 0.812447>,
				<0.621878, 0.699183, -0.336920>, <-4.182061, 4.216290, 0.853840>,
				<0.620956, 0.706843, -0.322322>, <-4.120150, 4.263673, 0.917500>
			}
			smooth_triangle {
				<0.621878, 0.699183, -0.336920>, <-4.182061, 4.216290, 0.853840>,
				<0.637317, 0.684623, -0.337983>, <-2.822277, 2.771676, 0.592531>,
				<0.634516, 0.694193, -0.323414>, <-4.186949, 4.187696, 0.963641>
			}
			smooth_triangle {
				<0.637317, 0.684623, -0.337983>, <-2.822277, 2.771676, 0.592531>,
				<0.648731, 0.680563, -0.324193>, <-2.110343, 2.071326, 0.505691>,
				<0.634516, 0.694193, -0.323414>, <-4.186949, 4.187696, 0.963641>
			}
			smooth_triangle {
				<0.655297, 0.687563, -0.294900>, <-2.079172, 2.085824, 0.570954>,
				<0.644927, 0.690863, -0.309670>, <-4.180157, 4.169295, 1.067580>,
				<0.654728, 0.681373, -0.310140>, <-1.401294, 1.380136, 0.362526>
			}
			smooth_triangle {
				<0.634516, 0.694193, -0.323414>, <-4.186949, 4.187696, 0.963641>,
				<0.648731, 0.680563, -0.324193>, <-2.110343, 2.071326, 0.505691>,
				<0.644927, 0.690863, -0.309670>, <-4.180157, 4.169295, 1.067580>
			}
			smooth_triangle {
				<0.648731, 0.680563, -0.324193>, <-2.110343, 2.071326, 0.505691>,
				<0.654728, 0.681373, -0.310140>, <-1.401294, 1.380136, 0.362526>,
				<0.644927, 0.690863, -0.309670>, <-4.180157, 4.169295, 1.067580>
			}
			smooth_triangle {
				<0.621878, 0.699183, -0.336920>, <-4.182061, 4.216290, 0.853840>,
				<0.634516, 0.694193, -0.323414>, <-4.186949, 4.187696, 0.963641>,
				<0.620956, 0.706843, -0.322322>, <-4.120150, 4.263673, 0.917500>
			}
			smooth_triangle {
				<0.655297, 0.687563, -0.294900>, <-2.079172, 2.085824, 0.570954>,
				<0.643095, 0.698533, -0.295953>, <-4.119437, 4.214152, 1.126047>,
				<0.644927, 0.690863, -0.309670>, <-4.180157, 4.169295, 1.067580>
			}
			smooth_triangle {
				<0.643095, 0.698533, -0.295953>, <-4.119437, 4.214152, 1.126047>,
				<0.632501, 0.702453, -0.309217>, <-4.121971, 4.237935, 1.022589>,
				<0.644927, 0.690863, -0.309670>, <-4.180157, 4.169295, 1.067580>
			}
			smooth_triangle {
				<0.620956, 0.706843, -0.322322>, <-4.120150, 4.263673, 0.917500>,
				<0.634516, 0.694193, -0.323414>, <-4.186949, 4.187696, 0.963641>,
				<0.632501, 0.702453, -0.309217>, <-4.121971, 4.237935, 1.022589>
			}
			smooth_triangle {
				<0.634516, 0.694193, -0.323414>, <-4.186949, 4.187696, 0.963641>,
				<0.644927, 0.690863, -0.309670>, <-4.180157, 4.169295, 1.067580>,
				<0.632501, 0.702453, -0.309217>, <-4.121971, 4.237935, 1.022589>
			}
			smooth_triangle {
				<0.708178, 0.664353, -0.214984>, <-2.061406, 1.996253, 0.874691>,
				<0.718268, 0.654223, -0.212590>, <-4.840704, 4.596473, 2.105866>,
				<0.712703, 0.663233, -0.203182>, <-1.370686, 1.324027, 0.606682>
			}
			smooth_triangle {
				<0.730726, 0.645783, -0.195238>, <-3.460099, 3.241795, 1.586040>,
				<0.723819, 0.653593, -0.194991>, <-2.059917, 1.965614, 0.944619>,
				<0.718268, 0.654223, -0.212590>, <-4.840704, 4.596473, 2.105866>
			}
			smooth_triangle {
				<0.723819, 0.653593, -0.194991>, <-2.059917, 1.965614, 0.944619>,
				<0.712703, 0.663233, -0.203182>, <-1.370686, 1.324027, 0.606682>,
				<0.718268, 0.654223, -0.212590>, <-4.840704, 4.596473, 2.105866>
			}
			smooth_triangle {
				<0.741916, 0.637013, -0.181327>, <-0.692809, 0.641434, 0.329511>,
				<0.734068, 0.645213, -0.184270>, <-1.375631, 1.295287, 0.655441>,
				<0.730726, 0.645783, -0.195238>, <-3.460099, 3.241795, 1.586040>
			}
			smooth_triangle {
				<0.730726, 0.645783, -0.195238>, <-3.460099, 3.241795, 1.586040>,
				<0.734068, 0.645213, -0.184270>, <-1.375631, 1.295287, 0.655441>,
				<0.723819, 0.653593, -0.194991>, <-2.059917, 1.965614, 0.944619>
			}
			smooth_triangle {
				<0.706725, 0.655743, -0.244221>, <-2.083827, 1.997819, 0.816133>,
				<0.715590, 0.650773, -0.231400>, <-2.090264, 1.971022, 0.863247>,
				<0.709250, 0.659533, -0.226028>, <-3.461382, 3.318009, 1.416714>
			}
			smooth_triangle {
				<0.715590, 0.650773, -0.231400>, <-2.090264, 1.971022, 0.863247>,
				<0.718268, 0.654223, -0.212590>, <-4.840704, 4.596473, 2.105866>,
				<0.709250, 0.659533, -0.226028>, <-3.461382, 3.318009, 1.416714>
			}
			smooth_triangle {
				<0.718268, 0.654223, -0.212590>, <-4.840704, 4.596473, 2.105866>,
				<0.708178, 0.664353, -0.214984>, <-2.061406, 1.996253, 0.874691>,
				<0.709250, 0.659533, -0.226028>, <-3.461382, 3.318009, 1.416714>
			}
			smooth_triangle {
				<0.715590, 0.650773, -0.231400>, <-2.090264, 1.971022, 0.863247>,
				<0.726640, 0.641683, -0.222121>, <-2.786174, 2.595041, 1.225628>,
				<0.718268, 0.654223, -0.212590>, <-4.840704, 4.596473, 2.105866>
			}
			smooth_triangle {
				<0.726640, 0.641683, -0.222121>, <-2.786174, 2.595041, 1.225628>,
				<0.730726, 0.645783, -0.195238>, <-3.460099, 3.241795, 1.586040>,
				<0.718268, 0.654223, -0.212590>, <-4.840704, 4.596473, 2.105866>
			}
			smooth_triangle {
				<0.753748, 0.612253, -0.214753>, <-0.712983, 0.621114, 0.325383>,
				<0.746345, 0.624423, -0.205342>, <-2.127576, 1.884160, 0.960697>,
				<0.746718, 0.620323, -0.216177>, <-1.421633, 1.251590, 0.642106>
			}
			smooth_triangle {
				<0.746718, 0.620323, -0.216177>, <-1.421633, 1.251590, 0.642106>,
				<0.746345, 0.624423, -0.205342>, <-2.127576, 1.884160, 0.960697>,
				<0.736737, 0.632993, -0.213650>, <-2.110299, 1.910644, 0.946137>
			}
			smooth_triangle {
				<0.736737, 0.632993, -0.213650>, <-2.110299, 1.910644, 0.946137>,
				<0.746345, 0.624423, -0.205342>, <-2.127576, 1.884160, 0.960697>,
				<0.738574, 0.634143, -0.203651>, <-2.098576, 1.926574, 0.939978>
			}
			smooth_triangle {
				<0.726640, 0.641683, -0.222121>, <-2.786174, 2.595041, 1.225628>,
				<0.738574, 0.634143, -0.203651>, <-2.098576, 1.926574, 0.939978>,
				<0.730726, 0.645783, -0.195238>, <-3.460099, 3.241795, 1.586040>
			}
			smooth_triangle {
				<0.726640, 0.641683, -0.222121>, <-2.786174, 2.595041, 1.225628>,
				<0.736737, 0.632993, -0.213650>, <-2.110299, 1.910644, 0.946137>,
				<0.738574, 0.634143, -0.203651>, <-2.098576, 1.926574, 0.939978>
			}
			smooth_triangle {
				<0.584440, 0.721212, -0.356925>, <-4.085302, 4.350639, 0.616036>,
				<0.574033, 0.731102, -0.353676>, <-4.020774, 4.413866, 0.589504>,
				<0.572070, 0.725802, -0.367498>, <-4.066339, 4.380690, 0.521112>
			}
			smooth_triangle {
				<0.541536, 0.745182, -0.374903>, <-1.993806, 2.233178, 0.192775>,
				<0.558778, 0.736432, -0.366801>, <-4.670777, 5.184137, 0.550910>,
				<0.548571, 0.746812, -0.361199>, <-2.625722, 3.000258, 0.319793>
			}
			smooth_triangle {
				<0.558778, 0.736432, -0.366801>, <-4.670777, 5.184137, 0.550910>,
				<0.562638, 0.742042, -0.349179>, <-3.954468, 4.475804, 0.570040>,
				<0.548571, 0.746812, -0.361199>, <-2.625722, 3.000258, 0.319793>
			}
			smooth_triangle {
				<0.562638, 0.742042, -0.349179>, <-3.954468, 4.475804, 0.570040>,
				<0.558778, 0.736432, -0.366801>, <-4.670777, 5.184137, 0.550910>,
				<0.574033, 0.731102, -0.353676>, <-4.020774, 4.413866, 0.589504>
			}
			smooth_triangle {
				<0.558778, 0.736432, -0.366801>, <-4.670777, 5.184137, 0.550910>,
				<0.572070, 0.725802, -0.367498>, <-4.066339, 4.380690, 0.521112>,
				<0.574033, 0.731102, -0.353676>, <-4.020774, 4.413866, 0.589504>
			}
			smooth_triangle {
				<0.533012, 0.747072, -0.383272>, <-1.994030, 2.236033, 0.154264>,
				<0.550283, 0.734852, -0.382478>, <-2.665591, 2.971868, 0.248134>,
				<0.541536, 0.745182, -0.374903>, <-1.993806, 2.233178, 0.192775>
			}
			smooth_triangle {
				<0.572070, 0.725802, -0.367498>, <-4.066339, 4.380690, 0.521112>,
				<0.558778, 0.736432, -0.366801>, <-4.670777, 5.184137, 0.550910>,
				<0.561439, 0.728542, -0.378315>, <-2.023751, 2.202635, 0.228921>
			}
			smooth_triangle {
				<0.541536, 0.745182, -0.374903>, <-1.993806, 2.233178, 0.192775>,
				<0.550283, 0.734852, -0.382478>, <-2.665591, 2.971868, 0.248134>,
				<0.558778, 0.736432, -0.366801>, <-4.670777, 5.184137, 0.550910>
			}
			smooth_triangle {
				<0.550283, 0.734852, -0.382478>, <-2.665591, 2.971868, 0.248134>,
				<0.561439, 0.728542, -0.378315>, <-2.023751, 2.202635, 0.228921>,
				<0.558778, 0.736432, -0.366801>, <-4.670777, 5.184137, 0.550910>
			}
			smooth_triangle {
				<0.561439, 0.728542, -0.378315>, <-2.023751, 2.202635, 0.228921>,
				<0.570528, 0.720402, -0.380303>, <-2.049290, 2.176872, 0.247868>,
				<0.572070, 0.725802, -0.367498>, <-4.066339, 4.380690, 0.521112>
			}
			smooth_triangle {
				<0.605256, 0.700773, -0.362905>, <-4.203223, 4.228151, 0.672516>,
				<0.594941, 0.711372, -0.359314>, <-4.142271, 4.291669, 0.648300>,
				<0.592314, 0.707392, -0.371313>, <-4.178237, 4.266310, 0.581712>
			}
			smooth_triangle {
				<0.572070, 0.725802, -0.367498>, <-4.066339, 4.380690, 0.521112>,
				<0.570528, 0.720402, -0.380303>, <-2.049290, 2.176872, 0.247868>,
				<0.582675, 0.716652, -0.368799>, <-4.120490, 4.325514, 0.555775>
			}
			smooth_triangle {
				<0.570528, 0.720402, -0.380303>, <-2.049290, 2.176872, 0.247868>,
				<0.581286, 0.713362, -0.377267>, <-2.073640, 2.151495, 0.265812>,
				<0.582675, 0.716652, -0.368799>, <-4.120490, 4.325514, 0.555775>
			}
			smooth_triangle {
				<0.581286, 0.713362, -0.377267>, <-2.073640, 2.151495, 0.265812>,
				<0.592314, 0.707392, -0.371313>, <-4.178237, 4.266310, 0.581712>,
				<0.582675, 0.716652, -0.368799>, <-4.120490, 4.325514, 0.555775>
			}
			smooth_triangle {
				<0.572070, 0.725802, -0.367498>, <-4.066339, 4.380690, 0.521112>,
				<0.582675, 0.716652, -0.368799>, <-4.120490, 4.325514, 0.555775>,
				<0.584440, 0.721212, -0.356925>, <-4.085302, 4.350639, 0.616036>
			}
			smooth_triangle {
				<0.592314, 0.707392, -0.371313>, <-4.178237, 4.266310, 0.581712>,
				<0.594941, 0.711372, -0.359314>, <-4.142271, 4.291669, 0.648300>,
				<0.582675, 0.716652, -0.368799>, <-4.120490, 4.325514, 0.555775>
			}
			smooth_triangle {
				<0.582675, 0.716652, -0.368799>, <-4.120490, 4.325514, 0.555775>,
				<0.594941, 0.711372, -0.359314>, <-4.142271, 4.291669, 0.648300>,
				<0.584440, 0.721212, -0.356925>, <-4.085302, 4.350639, 0.616036>
			}
			smooth_triangle {
				<0.594138, 0.696442, -0.388678>, <-2.127854, 2.097516, 0.269008>,
				<0.600735, 0.686582, -0.396015>, <-2.880582, 2.753612, 0.345150>,
				<0.604356, 0.689353, -0.385556>, <-3.572876, 3.466124, 0.468109>
			}
			smooth_triangle {
				<0.600735, 0.686582, -0.396015>, <-2.880582, 2.753612, 0.345150>,
				<0.611994, 0.680692, -0.388884>, <-4.337587, 4.105053, 0.575702>,
				<0.604356, 0.689353, -0.385556>, <-3.572876, 3.466124, 0.468109>
			}
			smooth_triangle {
				<0.635659, 0.670163, -0.368678>, <-4.367381, 4.042310, 0.762926>,
				<0.623897, 0.682222, -0.366655>, <-4.306006, 4.113967, 0.728144>,
				<0.623346, 0.675573, -0.379664>, <-4.353224, 4.074911, 0.664637>
			}
			smooth_triangle {
				<0.623897, 0.682222, -0.366655>, <-4.306006, 4.113967, 0.728144>,
				<0.613099, 0.686082, -0.377501>, <-4.297863, 4.138115, 0.634051>,
				<0.623346, 0.675573, -0.379664>, <-4.353224, 4.074911, 0.664637>
			}
			smooth_triangle {
				<0.604356, 0.689353, -0.385556>, <-3.572876, 3.466124, 0.468109>,
				<0.611994, 0.680692, -0.388884>, <-4.337587, 4.105053, 0.575702>,
				<0.613099, 0.686082, -0.377501>, <-4.297863, 4.138115, 0.634051>
			}
			smooth_triangle {
				<0.611994, 0.680692, -0.388884>, <-4.337587, 4.105053, 0.575702>,
				<0.623346, 0.675573, -0.379664>, <-4.353224, 4.074911, 0.664637>,
				<0.613099, 0.686082, -0.377501>, <-4.297863, 4.138115, 0.634051>
			}
			smooth_triangle {
				<0.623897, 0.682222, -0.366655>, <-4.306006, 4.113967, 0.728144>,
				<0.613037, 0.691572, -0.367463>, <-3.547593, 3.477225, 0.566925>,
				<0.613099, 0.686082, -0.377501>, <-4.297863, 4.138115, 0.634051>
			}
			smooth_triangle {
				<0.613037, 0.691572, -0.367463>, <-3.547593, 3.477225, 0.566925>,
				<0.601511, 0.696732, -0.376641>, <-4.946150, 4.904660, 0.690230>,
				<0.613099, 0.686082, -0.377501>, <-4.297863, 4.138115, 0.634051>
			}
			smooth_triangle {
				<0.587759, 0.705032, -0.382855>, <-2.102445, 2.122453, 0.273205>,
				<0.594138, 0.696442, -0.388678>, <-2.127854, 2.097516, 0.269008>,
				<0.601511, 0.696732, -0.376641>, <-4.946150, 4.904660, 0.690230>
			}
			smooth_triangle {
				<0.594138, 0.696442, -0.388678>, <-2.127854, 2.097516, 0.269008>,
				<0.604356, 0.689353, -0.385556>, <-3.572876, 3.466124, 0.468109>,
				<0.601511, 0.696732, -0.376641>, <-4.946150, 4.904660, 0.690230>
			}
			smooth_triangle {
				<0.601511, 0.696732, -0.376641>, <-4.946150, 4.904660, 0.690230>,
				<0.604356, 0.689353, -0.385556>, <-3.572876, 3.466124, 0.468109>,
				<0.613099, 0.686082, -0.377501>, <-4.297863, 4.138115, 0.634051>
			}
			smooth_triangle {
				<0.613037, 0.691572, -0.367463>, <-3.547593, 3.477225, 0.566925>,
				<0.605256, 0.700773, -0.362905>, <-4.203223, 4.228151, 0.672516>,
				<0.601511, 0.696732, -0.376641>, <-4.946150, 4.904660, 0.690230>
			}
			smooth_triangle {
				<0.605256, 0.700773, -0.362905>, <-4.203223, 4.228151, 0.672516>,
				<0.592314, 0.707392, -0.371313>, <-4.178237, 4.266310, 0.581712>,
				<0.601511, 0.696732, -0.376641>, <-4.946150, 4.904660, 0.690230>
			}
			smooth_triangle {
				<0.581286, 0.713362, -0.377267>, <-2.073640, 2.151495, 0.265812>,
				<0.587759, 0.705032, -0.382855>, <-2.102445, 2.122453, 0.273205>,
				<0.592314, 0.707392, -0.371313>, <-4.178237, 4.266310, 0.581712>
			}
			smooth_triangle {
				<0.592314, 0.707392, -0.371313>, <-4.178237, 4.266310, 0.581712>,
				<0.587759, 0.705032, -0.382855>, <-2.102445, 2.122453, 0.273205>,
				<0.601511, 0.696732, -0.376641>, <-4.946150, 4.904660, 0.690230>
			}
			smooth_triangle {
				<0.528940, 0.743342, -0.395951>, <-0.663773, 0.746583, 0.044932>,
				<0.539838, 0.737442, -0.392250>, <-1.328529, 1.491590, 0.100297>,
				<0.533012, 0.747072, -0.383272>, <-1.994030, 2.236033, 0.154264>
			}
			smooth_triangle {
				<0.533012, 0.747072, -0.383272>, <-1.994030, 2.236033, 0.154264>,
				<0.539838, 0.737442, -0.392250>, <-1.328529, 1.491590, 0.100297>,
				<0.550283, 0.734852, -0.382478>, <-2.665591, 2.971868, 0.248134>
			}
			smooth_triangle {
				<0.562638, 0.742042, -0.349179>, <-3.954468, 4.475804, 0.570040>,
				<0.549970, 0.753262, -0.345312>, <-2.596396, 3.020741, 0.363530>,
				<0.548571, 0.746812, -0.361199>, <-2.625722, 3.000258, 0.319793>
			}
			smooth_triangle {
				<0.549970, 0.753262, -0.345312>, <-2.596396, 3.020741, 0.363530>,
				<0.534315, 0.758272, -0.358649>, <-0.647072, 0.758404, 0.078236>,
				<0.548571, 0.746812, -0.361199>, <-2.625722, 3.000258, 0.319793>
			}
			smooth_triangle {
				<0.630284, 0.637383, -0.430809>, <-4.583217, 3.845276, 0.451463>,
				<0.614779, 0.648792, -0.436140>, <-4.532273, 3.913918, 0.368035>,
				<0.621245, 0.635493, -0.446435>, <-4.601746, 3.834172, 0.344838>
			}
			smooth_triangle {
				<0.614779, 0.648792, -0.436140>, <-4.532273, 3.913918, 0.368035>,
				<0.598400, 0.660472, -0.441364>, <-4.477275, 3.983857, 0.279812>,
				<0.604967, 0.647102, -0.452096>, <-4.548959, 3.903377, 0.255989>
			}
			smooth_triangle {
				<0.604967, 0.647102, -0.452096>, <-4.548959, 3.903377, 0.255989>,
				<0.587487, 0.659192, -0.457636>, <-4.488752, 3.977411, 0.161428>,
				<0.595026, 0.644862, -0.468191>, <-4.565144, 3.890241, 0.143508>
			}
			smooth_triangle {
				<0.585415, 0.642162, -0.483768>, <-4.581070, 3.873992, 0.036264>,
				<0.595026, 0.644862, -0.468191>, <-4.565144, 3.890241, 0.143508>,
				<0.577318, 0.656682, -0.473893>, <-4.503565, 3.963626, 0.051521>
			}
			smooth_triangle {
				<0.595026, 0.644862, -0.468191>, <-4.565144, 3.890241, 0.143508>,
				<0.587487, 0.659192, -0.457636>, <-4.488752, 3.977411, 0.161428>,
				<0.577318, 0.656682, -0.473893>, <-4.503565, 3.963626, 0.051521>
			}
			smooth_triangle {
				<0.587487, 0.659192, -0.457636>, <-4.488752, 3.977411, 0.161428>,
				<0.566904, 0.672762, -0.463823>, <-5.155641, 4.733606, 0.063785>,
				<0.577318, 0.656682, -0.473893>, <-4.503565, 3.963626, 0.051521>
			}
			smooth_triangle {
				<0.585415, 0.642162, -0.483768>, <-4.581070, 3.873992, 0.036264>,
				<0.577318, 0.656682, -0.473893>, <-4.503565, 3.963626, 0.051521>,
				<0.569713, 0.653192, -0.487732>, <-2.264805, 1.967201, -0.003254>
			}
			smooth_triangle {
				<0.566904, 0.672762, -0.463823>, <-5.155641, 4.733606, 0.063785>,
				<0.558399, 0.667202, -0.481816>, <-2.225357, 2.011752, -0.002961>,
				<0.577318, 0.656682, -0.473893>, <-4.503565, 3.963626, 0.051521>
			}
			smooth_triangle {
				<0.577318, 0.656682, -0.473893>, <-4.503565, 3.963626, 0.051521>,
				<0.558399, 0.667202, -0.481816>, <-2.225357, 2.011752, -0.002961>,
				<0.569713, 0.653192, -0.487732>, <-2.264805, 1.967201, -0.003254>
			}
			smooth_triangle {
				<0.566904, 0.672762, -0.463823>, <-5.155641, 4.733606, 0.063785>,
				<0.587487, 0.659192, -0.457636>, <-4.488752, 3.977411, 0.161428>,
				<0.581297, 0.672502, -0.446033>, <-4.417830, 4.054835, 0.190208>
			}
			smooth_triangle {
				<0.604967, 0.647102, -0.452096>, <-4.548959, 3.903377, 0.255989>,
				<0.598400, 0.660472, -0.441364>, <-4.477275, 3.983857, 0.279812>,
				<0.587487, 0.659192, -0.457636>, <-4.488752, 3.977411, 0.161428>
			}
			smooth_triangle {
				<0.587487, 0.659192, -0.457636>, <-4.488752, 3.977411, 0.161428>,
				<0.598400, 0.660472, -0.441364>, <-4.477275, 3.983857, 0.279812>,
				<0.581297, 0.672502, -0.446033>, <-4.417830, 4.054835, 0.190208>
			}
			smooth_triangle {
				<0.614779, 0.648792, -0.436140>, <-4.532273, 3.913918, 0.368035>,
				<0.604967, 0.647102, -0.452096>, <-4.548959, 3.903377, 0.255989>,
				<0.621245, 0.635493, -0.446435>, <-4.601746, 3.834172, 0.344838>
			}
			smooth_triangle {
				<0.585415, 0.642162, -0.483768>, <-4.581070, 3.873992, 0.036264>,
				<0.602157, 0.630172, -0.478953>, <-4.640738, 3.800477, 0.121930>,
				<0.595026, 0.644862, -0.468191>, <-4.565144, 3.890241, 0.143508>
			}
			smooth_triangle {
				<0.602157, 0.630172, -0.478953>, <-4.640738, 3.800477, 0.121930>,
				<0.611877, 0.633132, -0.462437>, <-4.620718, 3.819623, 0.234538>,
				<0.595026, 0.644862, -0.468191>, <-4.565144, 3.890241, 0.143508>
			}
			smooth_triangle {
				<0.621245, 0.635493, -0.446435>, <-4.601746, 3.834172, 0.344838>,
				<0.604967, 0.647102, -0.452096>, <-4.548959, 3.903377, 0.255989>,
				<0.611877, 0.633132, -0.462437>, <-4.620718, 3.819623, 0.234538>
			}
			smooth_triangle {
				<0.604967, 0.647102, -0.452096>, <-4.548959, 3.903377, 0.255989>,
				<0.595026, 0.644862, -0.468191>, <-4.565144, 3.890241, 0.143508>,
				<0.611877, 0.633132, -0.462437>, <-4.620718, 3.819623, 0.234538>
			}
			smooth_triangle {
				<0.581297, 0.672502, -0.446033>, <-4.417830, 4.054835, 0.190208>,
				<0.564891, 0.684722, -0.448518>, <-2.190332, 2.048973, 0.058365>,
				<0.566904, 0.672762, -0.463823>, <-5.155641, 4.733606, 0.063785>
			}
			smooth_triangle {
				<0.564891, 0.684722, -0.448518>, <-2.190332, 2.048973, 0.058365>,
				<0.550473, 0.687732, -0.461641>, <-1.459040, 1.367860, 0.007313>,
				<0.566904, 0.672762, -0.463823>, <-5.155641, 4.733606, 0.063785>
			}
			smooth_triangle {
				<0.550473, 0.687732, -0.461641>, <-1.459040, 1.367860, 0.007313>,
				<0.547048, 0.680212, -0.476612>, <-1.465312, 1.361180, -0.004512>,
				<0.566904, 0.672762, -0.463823>, <-5.155641, 4.733606, 0.063785>
			}
			smooth_triangle {
				<0.547048, 0.680212, -0.476612>, <-1.465312, 1.361180, -0.004512>,
				<0.558399, 0.667202, -0.481816>, <-2.225357, 2.011752, -0.002961>,
				<0.566904, 0.672762, -0.463823>, <-5.155641, 4.733606, 0.063785>
			}
			smooth_triangle {
				<0.638997, 0.638543, -0.416007>, <-4.566197, 3.852180, 0.553846>,
				<0.624331, 0.650083, -0.420370>, <-4.514327, 3.922874, 0.477200>,
				<0.630284, 0.637383, -0.430809>, <-4.583217, 3.845276, 0.451463>
			}
			smooth_triangle {
				<0.564891, 0.684722, -0.448518>, <-2.190332, 2.048973, 0.058365>,
				<0.581297, 0.672502, -0.446033>, <-4.417830, 4.054835, 0.190208>,
				<0.576753, 0.684232, -0.433931>, <-2.188752, 2.048155, 0.117679>
			}
			smooth_triangle {
				<0.630284, 0.637383, -0.430809>, <-4.583217, 3.845276, 0.451463>,
				<0.624331, 0.650083, -0.420370>, <-4.514327, 3.922874, 0.477200>,
				<0.614779, 0.648792, -0.436140>, <-4.532273, 3.913918, 0.368035>
			}
			smooth_triangle {
				<0.624331, 0.650083, -0.420370>, <-4.514327, 3.922874, 0.477200>,
				<0.608582, 0.661632, -0.425418>, <-4.462428, 3.990818, 0.394497>,
				<0.614779, 0.648792, -0.436140>, <-4.532273, 3.913918, 0.368035>
			}
			smooth_triangle {
				<0.576753, 0.684232, -0.433931>, <-2.188752, 2.048155, 0.117679>,
				<0.581297, 0.672502, -0.446033>, <-4.417830, 4.054835, 0.190208>,
				<0.592402, 0.672942, -0.430496>, <-4.407954, 4.058465, 0.307177>
			}
			smooth_triangle {
				<0.581297, 0.672502, -0.446033>, <-4.417830, 4.054835, 0.190208>,
				<0.598400, 0.660472, -0.441364>, <-4.477275, 3.983857, 0.279812>,
				<0.592402, 0.672942, -0.430496>, <-4.407954, 4.058465, 0.307177>
			}
			smooth_triangle {
				<0.614779, 0.648792, -0.436140>, <-4.532273, 3.913918, 0.368035>,
				<0.608582, 0.661632, -0.425418>, <-4.462428, 3.990818, 0.394497>,
				<0.598400, 0.660472, -0.441364>, <-4.477275, 3.983857, 0.279812>
			}
			smooth_triangle {
				<0.608582, 0.661632, -0.425418>, <-4.462428, 3.990818, 0.394497>,
				<0.592402, 0.672942, -0.430496>, <-4.407954, 4.058465, 0.307177>,
				<0.598400, 0.660472, -0.441364>, <-4.477275, 3.983857, 0.279812>
			}
			smooth_triangle {
				<0.646763, 0.639453, -0.402380>, <-2.271167, 1.935490, 0.308379>,
				<0.643604, 0.650773, -0.389078>, <-2.980723, 2.629612, 0.446443>,
				<0.633890, 0.650383, -0.405338>, <-4.500701, 3.924211, 0.583423>
			}
			smooth_triangle {
				<0.597216, 0.683002, -0.407382>, <-2.180197, 2.048861, 0.219875>,
				<0.602108, 0.673682, -0.415600>, <-4.396716, 4.061273, 0.413787>,
				<0.608741, 0.676252, -0.401519>, <-4.373262, 4.076489, 0.504097>
			}
			smooth_triangle {
				<0.602108, 0.673682, -0.415600>, <-4.396716, 4.061273, 0.413787>,
				<0.618594, 0.663203, -0.408181>, <-5.183111, 4.666553, 0.594269>,
				<0.608741, 0.676252, -0.401519>, <-4.373262, 4.076489, 0.504097>
			}
			smooth_triangle {
				<0.608741, 0.676252, -0.401519>, <-4.373262, 4.076489, 0.504097>,
				<0.618594, 0.663203, -0.408181>, <-5.183111, 4.666553, 0.594269>,
				<0.621204, 0.669962, -0.392905>, <-4.394885, 4.041167, 0.592138>
			}
			smooth_triangle {
				<0.633890, 0.650383, -0.405338>, <-4.500701, 3.924211, 0.583423>,
				<0.643604, 0.650773, -0.389078>, <-2.980723, 2.629612, 0.446443>,
				<0.630285, 0.659703, -0.395773>, <-3.707646, 3.315042, 0.511593>
			}
			smooth_triangle {
				<0.643604, 0.650773, -0.389078>, <-2.980723, 2.629612, 0.446443>,
				<0.633676, 0.663883, -0.383175>, <-4.414040, 4.004735, 0.689192>,
				<0.630285, 0.659703, -0.395773>, <-3.707646, 3.315042, 0.511593>
			}
			smooth_triangle {
				<0.633676, 0.663883, -0.383175>, <-4.414040, 4.004735, 0.689192>,
				<0.621204, 0.669962, -0.392905>, <-4.394885, 4.041167, 0.592138>,
				<0.630285, 0.659703, -0.395773>, <-3.707646, 3.315042, 0.511593>
			}
			smooth_triangle {
				<0.633890, 0.650383, -0.405338>, <-4.500701, 3.924211, 0.583423>,
				<0.630285, 0.659703, -0.395773>, <-3.707646, 3.315042, 0.511593>,
				<0.618594, 0.663203, -0.408181>, <-5.183111, 4.666553, 0.594269>
			}
			smooth_triangle {
				<0.630285, 0.659703, -0.395773>, <-3.707646, 3.315042, 0.511593>,
				<0.621204, 0.669962, -0.392905>, <-4.394885, 4.041167, 0.592138>,
				<0.618594, 0.663203, -0.408181>, <-5.183111, 4.666553, 0.594269>
			}
			smooth_triangle {
				<0.597216, 0.683002, -0.407382>, <-2.180197, 2.048861, 0.219875>,
				<0.608741, 0.676252, -0.401519>, <-4.373262, 4.076489, 0.504097>,
				<0.600735, 0.686582, -0.396015>, <-2.880582, 2.753612, 0.345150>
			}
			smooth_triangle {
				<0.633676, 0.663883, -0.383175>, <-4.414040, 4.004735, 0.689192>,
				<0.623346, 0.675573, -0.379664>, <-4.353224, 4.074911, 0.664637>,
				<0.621204, 0.669962, -0.392905>, <-4.394885, 4.041167, 0.592138>
			}
			smooth_triangle {
				<0.623346, 0.675573, -0.379664>, <-4.353224, 4.074911, 0.664637>,
				<0.611994, 0.680692, -0.388884>, <-4.337587, 4.105053, 0.575702>,
				<0.621204, 0.669962, -0.392905>, <-4.394885, 4.041167, 0.592138>
			}
			smooth_triangle {
				<0.600735, 0.686582, -0.396015>, <-2.880582, 2.753612, 0.345150>,
				<0.608741, 0.676252, -0.401519>, <-4.373262, 4.076489, 0.504097>,
				<0.611994, 0.680692, -0.388884>, <-4.337587, 4.105053, 0.575702>
			}
			smooth_triangle {
				<0.608741, 0.676252, -0.401519>, <-4.373262, 4.076489, 0.504097>,
				<0.621204, 0.669962, -0.392905>, <-4.394885, 4.041167, 0.592138>,
				<0.611994, 0.680692, -0.388884>, <-4.337587, 4.105053, 0.575702>
			}
			smooth_triangle {
				<0.646763, 0.639453, -0.402380>, <-2.271167, 1.935490, 0.308379>,
				<0.633890, 0.650383, -0.405338>, <-4.500701, 3.924211, 0.583423>,
				<0.638997, 0.638543, -0.416007>, <-4.566197, 3.852180, 0.553846>
			}
			smooth_triangle {
				<0.602108, 0.673682, -0.415600>, <-4.396716, 4.061273, 0.413787>,
				<0.608582, 0.661632, -0.425418>, <-4.462428, 3.990818, 0.394497>,
				<0.618594, 0.663203, -0.408181>, <-5.183111, 4.666553, 0.594269>
			}
			smooth_triangle {
				<0.608582, 0.661632, -0.425418>, <-4.462428, 3.990818, 0.394497>,
				<0.624331, 0.650083, -0.420370>, <-4.514327, 3.922874, 0.477200>,
				<0.618594, 0.663203, -0.408181>, <-5.183111, 4.666553, 0.594269>
			}
			smooth_triangle {
				<0.638997, 0.638543, -0.416007>, <-4.566197, 3.852180, 0.553846>,
				<0.633890, 0.650383, -0.405338>, <-4.500701, 3.924211, 0.583423>,
				<0.624331, 0.650083, -0.420370>, <-4.514327, 3.922874, 0.477200>
			}
			smooth_triangle {
				<0.633890, 0.650383, -0.405338>, <-4.500701, 3.924211, 0.583423>,
				<0.618594, 0.663203, -0.408181>, <-5.183111, 4.666553, 0.594269>,
				<0.624331, 0.650083, -0.420370>, <-4.514327, 3.922874, 0.477200>
			}
			smooth_triangle {
				<0.643604, 0.650773, -0.389078>, <-2.980723, 2.629612, 0.446443>,
				<0.647305, 0.656643, -0.372720>, <-2.207658, 1.995320, 0.380123>,
				<0.633676, 0.663883, -0.383175>, <-4.414040, 4.004735, 0.689192>
			}
			smooth_triangle {
				<0.648385, 0.664443, -0.356669>, <-1.458076, 1.341761, 0.271287>,
				<0.635659, 0.670163, -0.368678>, <-4.367381, 4.042310, 0.762926>,
				<0.647305, 0.656643, -0.372720>, <-2.207658, 1.995320, 0.380123>
			}
			smooth_triangle {
				<0.623346, 0.675573, -0.379664>, <-4.353224, 4.074911, 0.664637>,
				<0.633676, 0.663883, -0.383175>, <-4.414040, 4.004735, 0.689192>,
				<0.635659, 0.670163, -0.368678>, <-4.367381, 4.042310, 0.762926>
			}
			smooth_triangle {
				<0.647305, 0.656643, -0.372720>, <-2.207658, 1.995320, 0.380123>,
				<0.635659, 0.670163, -0.368678>, <-4.367381, 4.042310, 0.762926>,
				<0.633676, 0.663883, -0.383175>, <-4.414040, 4.004735, 0.689192>
			}
			smooth_triangle {
				<0.597216, 0.683002, -0.407382>, <-2.180197, 2.048861, 0.219875>,
				<0.586442, 0.684502, -0.420299>, <-2.184939, 2.048550, 0.170450>,
				<0.602108, 0.673682, -0.415600>, <-4.396716, 4.061273, 0.413787>
			}
			smooth_triangle {
				<0.576753, 0.684232, -0.433931>, <-2.188752, 2.048155, 0.117679>,
				<0.592402, 0.672942, -0.430496>, <-4.407954, 4.058465, 0.307177>,
				<0.586442, 0.684502, -0.420299>, <-2.184939, 2.048550, 0.170450>
			}
			smooth_triangle {
				<0.608582, 0.661632, -0.425418>, <-4.462428, 3.990818, 0.394497>,
				<0.602108, 0.673682, -0.415600>, <-4.396716, 4.061273, 0.413787>,
				<0.592402, 0.672942, -0.430496>, <-4.407954, 4.058465, 0.307177>
			}
			smooth_triangle {
				<0.586442, 0.684502, -0.420299>, <-2.184939, 2.048550, 0.170450>,
				<0.592402, 0.672942, -0.430496>, <-4.407954, 4.058465, 0.307177>,
				<0.602108, 0.673682, -0.415600>, <-4.396716, 4.061273, 0.413787>
			}
			smooth_triangle {
				<0.653108, 0.626893, -0.411791>, <-2.303687, 1.898880, 0.294735>,
				<0.646763, 0.639453, -0.402380>, <-2.271167, 1.935490, 0.308379>,
				<0.638997, 0.638543, -0.416007>, <-4.566197, 3.852180, 0.553846>
			}
			smooth_triangle {
				<0.602157, 0.630172, -0.478953>, <-4.640738, 3.800477, 0.121930>,
				<0.618896, 0.618863, -0.472321>, <-4.690160, 3.735158, 0.215079>,
				<0.611877, 0.633132, -0.462437>, <-4.620718, 3.819623, 0.234538>
			}
			smooth_triangle {
				<0.618896, 0.618863, -0.472321>, <-4.690160, 3.735158, 0.215079>,
				<0.634993, 0.607753, -0.465334>, <-4.738593, 3.666477, 0.313384>,
				<0.628044, 0.621712, -0.456239>, <-4.670729, 3.751421, 0.326178>
			}
			smooth_triangle {
				<0.653108, 0.626893, -0.411791>, <-2.303687, 1.898880, 0.294735>,
				<0.644865, 0.626553, -0.425069>, <-4.629672, 3.778552, 0.534070>,
				<0.658520, 0.617923, -0.416698>, <-2.331214, 1.866220, 0.287123>
			}
			smooth_triangle {
				<0.651347, 0.595063, -0.459083>, <-2.380754, 1.814883, 0.194236>,
				<0.659301, 0.597523, -0.444284>, <-2.369947, 1.823417, 0.241261>,
				<0.643697, 0.610123, -0.450014>, <-4.720315, 3.679648, 0.417610>
			}
			smooth_triangle {
				<0.636656, 0.624273, -0.440529>, <-4.650187, 3.766222, 0.432475>,
				<0.643697, 0.610123, -0.450014>, <-4.720315, 3.679648, 0.417610>,
				<0.650939, 0.613823, -0.434290>, <-4.692758, 3.702498, 0.515225>
			}
			smooth_triangle {
				<0.643697, 0.610123, -0.450014>, <-4.720315, 3.679648, 0.417610>,
				<0.659301, 0.597523, -0.444284>, <-2.369947, 1.823417, 0.241261>,
				<0.650939, 0.613823, -0.434290>, <-4.692758, 3.702498, 0.515225>
			}
			smooth_triangle {
				<0.659301, 0.597523, -0.444284>, <-2.369947, 1.823417, 0.241261>,
				<0.661731, 0.606083, -0.428817>, <-1.569483, 1.226005, 0.182779>,
				<0.650939, 0.613823, -0.434290>, <-4.692758, 3.702498, 0.515225>
			}
			smooth_triangle {
				<0.636656, 0.624273, -0.440529>, <-4.650187, 3.766222, 0.432475>,
				<0.650939, 0.613823, -0.434290>, <-4.692758, 3.702498, 0.515225>,
				<0.644865, 0.626553, -0.425069>, <-4.629672, 3.778552, 0.534070>
			}
			smooth_triangle {
				<0.661731, 0.606083, -0.428817>, <-1.569483, 1.226005, 0.182779>,
				<0.658520, 0.617923, -0.416698>, <-2.331214, 1.866220, 0.287123>,
				<0.650939, 0.613823, -0.434290>, <-4.692758, 3.702498, 0.515225>
			}
			smooth_triangle {
				<0.650939, 0.613823, -0.434290>, <-4.692758, 3.702498, 0.515225>,
				<0.658520, 0.617923, -0.416698>, <-2.331214, 1.866220, 0.287123>,
				<0.644865, 0.626553, -0.425069>, <-4.629672, 3.778552, 0.534070>
			}
			smooth_triangle {
				<0.651347, 0.595063, -0.459083>, <-2.380754, 1.814883, 0.194236>,
				<0.643697, 0.610123, -0.450014>, <-4.720315, 3.679648, 0.417610>,
				<0.634993, 0.607753, -0.465334>, <-4.738593, 3.666477, 0.313384>
			}
			smooth_triangle {
				<0.636656, 0.624273, -0.440529>, <-4.650187, 3.766222, 0.432475>,
				<0.628044, 0.621712, -0.456239>, <-4.670729, 3.751421, 0.326178>,
				<0.643697, 0.610123, -0.450014>, <-4.720315, 3.679648, 0.417610>
			}
			smooth_triangle {
				<0.643697, 0.610123, -0.450014>, <-4.720315, 3.679648, 0.417610>,
				<0.628044, 0.621712, -0.456239>, <-4.670729, 3.751421, 0.326178>,
				<0.634993, 0.607753, -0.465334>, <-4.738593, 3.666477, 0.313384>
			}
			smooth_triangle {
				<0.618896, 0.618863, -0.472321>, <-4.690160, 3.735158, 0.215079>,
				<0.628044, 0.621712, -0.456239>, <-4.670729, 3.751421, 0.326178>,
				<0.611877, 0.633132, -0.462437>, <-4.620718, 3.819623, 0.234538>
			}
			smooth_triangle {
				<0.653108, 0.626893, -0.411791>, <-2.303687, 1.898880, 0.294735>,
				<0.638997, 0.638543, -0.416007>, <-4.566197, 3.852180, 0.553846>,
				<0.644865, 0.626553, -0.425069>, <-4.629672, 3.778552, 0.534070>
			}
			smooth_triangle {
				<0.638997, 0.638543, -0.416007>, <-4.566197, 3.852180, 0.553846>,
				<0.630284, 0.637383, -0.430809>, <-4.583217, 3.845276, 0.451463>,
				<0.644865, 0.626553, -0.425069>, <-4.629672, 3.778552, 0.534070>
			}
			smooth_triangle {
				<0.611877, 0.633132, -0.462437>, <-4.620718, 3.819623, 0.234538>,
				<0.628044, 0.621712, -0.456239>, <-4.670729, 3.751421, 0.326178>,
				<0.621245, 0.635493, -0.446435>, <-4.601746, 3.834172, 0.344838>
			}
			smooth_triangle {
				<0.628044, 0.621712, -0.456239>, <-4.670729, 3.751421, 0.326178>,
				<0.636656, 0.624273, -0.440529>, <-4.650187, 3.766222, 0.432475>,
				<0.621245, 0.635493, -0.446435>, <-4.601746, 3.834172, 0.344838>
			}
			smooth_triangle {
				<0.644865, 0.626553, -0.425069>, <-4.629672, 3.778552, 0.534070>,
				<0.630284, 0.637383, -0.430809>, <-4.583217, 3.845276, 0.451463>,
				<0.636656, 0.624273, -0.440529>, <-4.650187, 3.766222, 0.432475>
			}
			smooth_triangle {
				<0.636656, 0.624273, -0.440529>, <-4.650187, 3.766222, 0.432475>,
				<0.630284, 0.637383, -0.430809>, <-4.583217, 3.845276, 0.451463>,
				<0.621245, 0.635493, -0.446435>, <-4.601746, 3.834172, 0.344838>
			}
			smooth_triangle {
				<0.495909, 0.835532, -0.212303>, <-1.058031, 1.664954, 0.329385>,
				<0.520613, 0.820542, -0.211611>, <-2.155268, 3.301883, 0.670589>,
				<0.502497, 0.834552, -0.200313>, <-0.528426, 0.832683, 0.165544>
			}
			smooth_triangle {
				<0.495909, 0.835532, -0.212303>, <-1.058031, 1.664954, 0.329385>,
				<0.511567, 0.822252, -0.226499>, <-1.077658, 1.652189, 0.329284>,
				<0.520613, 0.820542, -0.211611>, <-2.155268, 3.301883, 0.670589>
			}
			smooth_triangle {
				<0.511567, 0.822252, -0.226499>, <-1.077658, 1.652189, 0.329284>,
				<0.533066, 0.807522, -0.229892>, <-2.233436, 3.246627, 0.684451>,
				<0.520613, 0.820542, -0.211611>, <-2.155268, 3.301883, 0.670589>
			}
			smooth_triangle {
				<0.533066, 0.807522, -0.229892>, <-2.233436, 3.246627, 0.684451>,
				<0.542679, 0.805182, -0.215153>, <-2.802116, 4.027826, 0.958161>,
				<0.520613, 0.820542, -0.211611>, <-2.155268, 3.301883, 0.670589>
			}
			smooth_triangle {
				<0.622871, 0.763323, -0.135936>, <-3.399065, 4.607544, 1.789544>,
				<0.602231, 0.781413, -0.125810>, <-3.269417, 4.712976, 1.755632>,
				<0.598350, 0.778103, -0.160149>, <-3.382538, 4.695481, 1.580172>
			}
			smooth_triangle {
				<0.558870, 0.814782, -0.113576>, <-1.999569, 3.271137, 1.137494>,
				<0.556190, 0.809892, -0.154418>, <-1.594135, 2.425525, 0.756692>,
				<0.580294, 0.798932, -0.118629>, <-3.133594, 4.823615, 1.701536>
			}
			smooth_triangle {
				<0.556190, 0.809892, -0.154418>, <-1.594135, 2.425525, 0.756692>,
				<0.576594, 0.795452, -0.154635>, <-3.264079, 4.798026, 1.519242>,
				<0.580294, 0.798932, -0.118629>, <-3.133594, 4.823615, 1.701536>
			}
			smooth_triangle {
				<0.598350, 0.778103, -0.160149>, <-3.382538, 4.695481, 1.580172>,
				<0.602231, 0.781413, -0.125810>, <-3.269417, 4.712976, 1.755632>,
				<0.576594, 0.795452, -0.154635>, <-3.264079, 4.798026, 1.519242>
			}
			smooth_triangle {
				<0.602231, 0.781413, -0.125810>, <-3.269417, 4.712976, 1.755632>,
				<0.580294, 0.798932, -0.118629>, <-3.133594, 4.823615, 1.701536>,
				<0.576594, 0.795452, -0.154635>, <-3.264079, 4.798026, 1.519242>
			}
			smooth_triangle {
				<0.542679, 0.805182, -0.215153>, <-2.802116, 4.027826, 0.958161>,
				<0.572537, 0.791672, -0.185902>, <-3.362925, 4.777938, 1.359015>,
				<0.547282, 0.810152, -0.182334>, <-1.647625, 2.415174, 0.671253>
			}
			smooth_triangle {
				<0.598350, 0.778103, -0.160149>, <-3.382538, 4.695481, 1.580172>,
				<0.576594, 0.795452, -0.154635>, <-3.264079, 4.798026, 1.519242>,
				<0.572537, 0.791672, -0.185902>, <-3.362925, 4.777938, 1.359015>
			}
			smooth_triangle {
				<0.572537, 0.791672, -0.185902>, <-3.362925, 4.777938, 1.359015>,
				<0.576594, 0.795452, -0.154635>, <-3.264079, 4.798026, 1.519242>,
				<0.547282, 0.810152, -0.182334>, <-1.647625, 2.415174, 0.671253>
			}
			smooth_triangle {
				<0.556190, 0.809892, -0.154418>, <-1.594135, 2.425525, 0.756692>,
				<0.547282, 0.810152, -0.182334>, <-1.647625, 2.415174, 0.671253>,
				<0.576594, 0.795452, -0.154635>, <-3.264079, 4.798026, 1.519242>
			}
			smooth_triangle {
				<0.641300, 0.593912, -0.474464>, <-3.189976, 2.406720, 0.174165>,
				<0.651347, 0.595063, -0.459083>, <-2.380754, 1.814883, 0.194236>,
				<0.634993, 0.607753, -0.465334>, <-4.738593, 3.666477, 0.313384>
			}
			smooth_triangle {
				<0.618896, 0.618863, -0.472321>, <-4.690160, 3.735158, 0.215079>,
				<0.625828, 0.606242, -0.479508>, <-3.960864, 3.045970, 0.173466>,
				<0.634993, 0.607753, -0.465334>, <-4.738593, 3.666477, 0.313384>
			}
			smooth_triangle {
				<0.634993, 0.607753, -0.465334>, <-4.738593, 3.666477, 0.313384>,
				<0.625828, 0.606242, -0.479508>, <-3.960864, 3.045970, 0.173466>,
				<0.641300, 0.593912, -0.474464>, <-3.189976, 2.406720, 0.174165>
			}
			smooth_triangle {
				<0.625828, 0.606242, -0.479508>, <-3.960864, 3.045970, 0.173466>,
				<0.623712, 0.596692, -0.494024>, <-3.185489, 2.416313, 0.111253>,
				<0.641300, 0.593912, -0.474464>, <-3.189976, 2.406720, 0.174165>
			}
			smooth_triangle {
				<0.623712, 0.596692, -0.494024>, <-3.185489, 2.416313, 0.111253>,
				<0.637827, 0.585713, -0.489120>, <-0.799349, 0.599785, 0.036060>,
				<0.641300, 0.593912, -0.474464>, <-3.189976, 2.406720, 0.174165>
			}
			smooth_triangle {
				<0.602157, 0.630172, -0.478953>, <-4.640738, 3.800477, 0.121930>,
				<0.609543, 0.613572, -0.491012>, <-5.506236, 4.319980, 0.107983>,
				<0.618896, 0.618863, -0.472321>, <-4.690160, 3.735158, 0.215079>
			}
			smooth_triangle {
				<0.610771, 0.600962, -0.504888>, <-2.375636, 1.831769, 0.015439>,
				<0.623712, 0.596692, -0.494024>, <-3.185489, 2.416313, 0.111253>,
				<0.609543, 0.613572, -0.491012>, <-5.506236, 4.319980, 0.107983>
			}
			smooth_triangle {
				<0.623712, 0.596692, -0.494024>, <-3.185489, 2.416313, 0.111253>,
				<0.625828, 0.606242, -0.479508>, <-3.960864, 3.045970, 0.173466>,
				<0.609543, 0.613572, -0.491012>, <-5.506236, 4.319980, 0.107983>
			}
			smooth_triangle {
				<0.618896, 0.618863, -0.472321>, <-4.690160, 3.735158, 0.215079>,
				<0.609543, 0.613572, -0.491012>, <-5.506236, 4.319980, 0.107983>,
				<0.625828, 0.606242, -0.479508>, <-3.960864, 3.045970, 0.173466>
			}
			smooth_triangle {
				<0.592909, 0.613412, -0.511178>, <-3.146195, 2.469824, -0.006886>,
				<0.599789, 0.599602, -0.519470>, <-0.793008, 0.609199, -0.003688>,
				<0.610771, 0.600962, -0.504888>, <-2.375636, 1.831769, 0.015439>
			}
			smooth_triangle {
				<0.585415, 0.642162, -0.483768>, <-4.581070, 3.873992, 0.036264>,
				<0.569713, 0.653192, -0.487732>, <-2.264805, 1.967201, -0.003254>,
				<0.576222, 0.639612, -0.497959>, <-2.301494, 1.924143, -0.015572>
			}
			smooth_triangle {
				<0.610771, 0.600962, -0.504888>, <-2.375636, 1.831769, 0.015439>,
				<0.609543, 0.613572, -0.491012>, <-5.506236, 4.319980, 0.107983>,
				<0.592909, 0.613412, -0.511178>, <-3.146195, 2.469824, -0.006886>
			}
			smooth_triangle {
				<0.609543, 0.613572, -0.491012>, <-5.506236, 4.319980, 0.107983>,
				<0.602157, 0.630172, -0.478953>, <-4.640738, 3.800477, 0.121930>,
				<0.591142, 0.627802, -0.495518>, <-4.655019, 3.784881, 0.004447>
			}
			smooth_triangle {
				<0.602157, 0.630172, -0.478953>, <-4.640738, 3.800477, 0.121930>,
				<0.585415, 0.642162, -0.483768>, <-4.581070, 3.873992, 0.036264>,
				<0.591142, 0.627802, -0.495518>, <-4.655019, 3.784881, 0.004447>
			}
			smooth_triangle {
				<0.585415, 0.642162, -0.483768>, <-4.581070, 3.873992, 0.036264>,
				<0.576222, 0.639612, -0.497959>, <-2.301494, 1.924143, -0.015572>,
				<0.591142, 0.627802, -0.495518>, <-4.655019, 3.784881, 0.004447>
			}
			smooth_triangle {
				<0.609543, 0.613572, -0.491012>, <-5.506236, 4.319980, 0.107983>,
				<0.591142, 0.627802, -0.495518>, <-4.655019, 3.784881, 0.004447>,
				<0.592909, 0.613412, -0.511178>, <-3.146195, 2.469824, -0.006886>
			}
			smooth_triangle {
				<0.576222, 0.639612, -0.497959>, <-2.301494, 1.924143, -0.015572>,
				<0.579535, 0.627192, -0.509786>, <-1.552036, 1.261227, -0.018207>,
				<0.591142, 0.627802, -0.495518>, <-4.655019, 3.784881, 0.004447>
			}
			smooth_triangle {
				<0.591142, 0.627802, -0.495518>, <-4.655019, 3.784881, 0.004447>,
				<0.579535, 0.627192, -0.509786>, <-1.552036, 1.261227, -0.018207>,
				<0.592909, 0.613412, -0.511178>, <-3.146195, 2.469824, -0.006886>
			}
			smooth_triangle {
				<0.487393, 0.866362, -0.031238>, <-1.575326, 3.486849, 1.162627>,
				<0.500168, 0.857602, -0.058796>, <-1.264456, 2.569760, 0.892610>,
				<0.506921, 0.855512, -0.015340>, <-2.403710, 5.157555, 1.898292>
			}
			smooth_triangle {
				<0.566717, 0.817133, -0.015688>, <-3.138730, 5.726877, 2.507623>,
				<0.581030, 0.803842, -0.073244>, <-2.957983, 4.847652, 1.928375>,
				<0.621815, 0.775473, -0.033241>, <-3.494897, 5.429190, 2.682261>
			}
			smooth_triangle {
				<0.581030, 0.803842, -0.073244>, <-2.957983, 4.847652, 1.928375>,
				<0.603509, 0.785423, -0.089391>, <-2.605793, 3.946640, 1.617497>,
				<0.621815, 0.775473, -0.033241>, <-3.494897, 5.429190, 2.682261>
			}
			smooth_triangle {
				<0.733286, 0.662703, -0.110590>, <-5.056551, 5.333336, 3.153069>,
				<0.699304, 0.699373, -0.104711>, <-3.625057, 4.215470, 2.250504>,
				<0.709040, 0.684793, -0.132018>, <-3.776755, 4.132424, 2.156052>
			}
			smooth_triangle {
				<0.628762, 0.764613, -0.095608>, <-3.265867, 4.608656, 2.016299>,
				<0.647588, 0.745813, -0.116234>, <-3.421364, 4.511337, 1.981153>,
				<0.669396, 0.731933, -0.072696>, <-4.456283, 5.887924, 3.060824>
			}
			smooth_triangle {
				<0.658856, 0.732913, -0.133640>, <-3.562986, 4.422084, 1.934395>,
				<0.671637, 0.718583, -0.147158>, <-3.672371, 4.335527, 1.925754>,
				<0.675789, 0.720183, -0.117302>, <-3.575414, 4.336943, 2.096005>
			}
			smooth_triangle {
				<0.675789, 0.720183, -0.117302>, <-3.575414, 4.336943, 2.096005>,
				<0.671637, 0.718583, -0.147158>, <-3.672371, 4.335527, 1.925754>,
				<0.689792, 0.703553, -0.135370>, <-3.706951, 4.245944, 2.054541>
			}
			smooth_triangle {
				<0.671637, 0.718583, -0.147158>, <-3.672371, 4.335527, 1.925754>,
				<0.683518, 0.704363, -0.160613>, <-3.779803, 4.251032, 1.906480>,
				<0.689792, 0.703553, -0.135370>, <-3.706951, 4.245944, 2.054541>
			}
			smooth_triangle {
				<0.683518, 0.704363, -0.160613>, <-3.779803, 4.251032, 1.906480>,
				<0.697678, 0.692663, -0.150224>, <-3.171166, 3.482190, 1.677532>,
				<0.689792, 0.703553, -0.135370>, <-3.706951, 4.245944, 2.054541>
			}
			smooth_triangle {
				<0.675789, 0.720183, -0.117302>, <-3.575414, 4.336943, 2.096005>,
				<0.689792, 0.703553, -0.135370>, <-3.706951, 4.245944, 2.054541>,
				<0.699304, 0.699373, -0.104711>, <-3.625057, 4.215470, 2.250504>
			}
			smooth_triangle {
				<0.699304, 0.699373, -0.104711>, <-3.625057, 4.215470, 2.250504>,
				<0.689792, 0.703553, -0.135370>, <-3.706951, 4.245944, 2.054541>,
				<0.709040, 0.684793, -0.132018>, <-3.776755, 4.132424, 2.156052>
			}
			smooth_triangle {
				<0.689792, 0.703553, -0.135370>, <-3.706951, 4.245944, 2.054541>,
				<0.697678, 0.692663, -0.150224>, <-3.171166, 3.482190, 1.677532>,
				<0.709040, 0.684793, -0.132018>, <-3.776755, 4.132424, 2.156052>
			}
			smooth_triangle {
				<0.699304, 0.699373, -0.104711>, <-3.625057, 4.215470, 2.250504>,
				<0.669396, 0.731933, -0.072696>, <-4.456283, 5.887924, 3.060824>,
				<0.675789, 0.720183, -0.117302>, <-3.575414, 4.336943, 2.096005>
			}
			smooth_triangle {
				<0.647588, 0.745813, -0.116234>, <-3.421364, 4.511337, 1.981153>,
				<0.658856, 0.732913, -0.133640>, <-3.562986, 4.422084, 1.934395>,
				<0.663206, 0.732913, -0.110020>, <-2.317035, 2.950229, 1.385916>
			}
			smooth_triangle {
				<0.658856, 0.732913, -0.133640>, <-3.562986, 4.422084, 1.934395>,
				<0.675789, 0.720183, -0.117302>, <-3.575414, 4.336943, 2.096005>,
				<0.663206, 0.732913, -0.110020>, <-2.317035, 2.950229, 1.385916>
			}
			smooth_triangle {
				<0.669396, 0.731933, -0.072696>, <-4.456283, 5.887924, 3.060824>,
				<0.663206, 0.732913, -0.110020>, <-2.317035, 2.950229, 1.385916>,
				<0.675789, 0.720183, -0.117302>, <-3.575414, 4.336943, 2.096005>
			}
			smooth_triangle {
				<0.669396, 0.731933, -0.072696>, <-4.456283, 5.887924, 3.060824>,
				<0.647588, 0.745813, -0.116234>, <-3.421364, 4.511337, 1.981153>,
				<0.663206, 0.732913, -0.110020>, <-2.317035, 2.950229, 1.385916>
			}
			smooth_triangle {
				<0.669396, 0.731933, -0.072696>, <-4.456283, 5.887924, 3.060824>,
				<0.621815, 0.775473, -0.033241>, <-3.494897, 5.429190, 2.682261>,
				<0.628762, 0.764613, -0.095608>, <-3.265867, 4.608656, 2.016299>
			}
			smooth_triangle {
				<0.628762, 0.764613, -0.095608>, <-3.265867, 4.608656, 2.016299>,
				<0.621815, 0.775473, -0.033241>, <-3.494897, 5.429190, 2.682261>,
				<0.603509, 0.785423, -0.089391>, <-2.605793, 3.946640, 1.617497>
			}
			smooth_triangle {
				<0.669396, 0.731933, -0.072696>, <-4.456283, 5.887924, 3.060824>,
				<0.699304, 0.699373, -0.104711>, <-3.625057, 4.215470, 2.250504>,
				<0.714111, 0.689563, -0.060416>, <-5.233683, 6.260978, 3.772792>
			}
			smooth_triangle {
				<0.766854, 0.629253, -0.071332>, <-1.883553, 1.975231, 1.244429>,
				<0.714111, 0.689563, -0.060416>, <-5.233683, 6.260978, 3.772792>,
				<0.733286, 0.662703, -0.110590>, <-5.056551, 5.333336, 3.153069>
			}
			smooth_triangle {
				<0.699304, 0.699373, -0.104711>, <-3.625057, 4.215470, 2.250504>,
				<0.733286, 0.662703, -0.110590>, <-5.056551, 5.333336, 3.153069>,
				<0.714111, 0.689563, -0.060416>, <-5.233683, 6.260978, 3.772792>
			}
			smooth_triangle {
				<0.697600, 0.707473, 0.044022>, <-2.560280, 3.726686, 2.130506>,
				<0.669396, 0.731933, -0.072696>, <-4.456283, 5.887924, 3.060824>,
				<0.714111, 0.689563, -0.060416>, <-5.233683, 6.260978, 3.772792>
			}
			smooth_triangle {
				<0.669396, 0.731933, -0.072696>, <-4.456283, 5.887924, 3.060824>,
				<0.697600, 0.707473, 0.044022>, <-2.560280, 3.726686, 2.130506>,
				<0.621815, 0.775473, -0.033241>, <-3.494897, 5.429190, 2.682261>
			}
			smooth_triangle {
				<0.697600, 0.707473, 0.044022>, <-2.560280, 3.726686, 2.130506>,
				<0.596609, 0.793703, 0.056587>, <-3.907951, 7.076840, 3.925373>,
				<0.621815, 0.775473, -0.033241>, <-3.494897, 5.429190, 2.682261>
			}
			smooth_triangle {
				<0.621815, 0.775473, -0.033241>, <-3.494897, 5.429190, 2.682261>,
				<0.596609, 0.793703, 0.056587>, <-3.907951, 7.076840, 3.925373>,
				<0.566717, 0.817133, -0.015688>, <-3.138730, 5.726877, 2.507623>
			}
			smooth_triangle {
				<0.596609, 0.793703, 0.056587>, <-3.907951, 7.076840, 3.925373>,
				<0.545192, 0.830602, 0.044473>, <-2.356210, 4.995224, 2.335282>,
				<0.566717, 0.817133, -0.015688>, <-3.138730, 5.726877, 2.507623>
			}
			smooth_triangle {
				<0.581030, 0.803842, -0.073244>, <-2.957983, 4.847652, 1.928375>,
				<0.566717, 0.817133, -0.015688>, <-3.138730, 5.726877, 2.507623>,
				<0.549290, 0.826242, -0.068660>, <-2.813064, 4.973517, 1.824202>
			}
			smooth_triangle {
				<0.545192, 0.830602, 0.044473>, <-2.356210, 4.995224, 2.335282>,
				<0.532169, 0.840182, 0.001292>, <-2.048416, 4.216378, 1.734692>,
				<0.566717, 0.817133, -0.015688>, <-3.138730, 5.726877, 2.507623>
			}
			smooth_triangle {
				<0.532169, 0.840182, 0.001292>, <-2.048416, 4.216378, 1.734692>,
				<0.530753, 0.840222, -0.037935>, <-2.602104, 5.063563, 1.889278>,
				<0.566717, 0.817133, -0.015688>, <-3.138730, 5.726877, 2.507623>
			}
			smooth_triangle {
				<0.566717, 0.817133, -0.015688>, <-3.138730, 5.726877, 2.507623>,
				<0.530753, 0.840222, -0.037935>, <-2.602104, 5.063563, 1.889278>,
				<0.549290, 0.826242, -0.068660>, <-2.813064, 4.973517, 1.824202>
			}
			smooth_triangle {
				<0.525973, 0.841112, -0.070685>, <-1.351132, 2.528721, 0.881451>,
				<0.549290, 0.826242, -0.068660>, <-2.813064, 4.973517, 1.824202>,
				<0.530753, 0.840222, -0.037935>, <-2.602104, 5.063563, 1.889278>
			}
			smooth_triangle {
				<0.532169, 0.840182, 0.001292>, <-2.048416, 4.216378, 1.734692>,
				<0.506921, 0.855512, -0.015340>, <-2.403710, 5.157555, 1.898292>,
				<0.530753, 0.840222, -0.037935>, <-2.602104, 5.063563, 1.889278>
			}
			smooth_triangle {
				<0.500168, 0.857602, -0.058796>, <-1.264456, 2.569760, 0.892610>,
				<0.530753, 0.840222, -0.037935>, <-2.602104, 5.063563, 1.889278>,
				<0.506921, 0.855512, -0.015340>, <-2.403710, 5.157555, 1.898292>
			}
			smooth_triangle {
				<0.500168, 0.857602, -0.058796>, <-1.264456, 2.569760, 0.892610>,
				<0.525973, 0.841112, -0.070685>, <-1.351132, 2.528721, 0.881451>,
				<0.530753, 0.840222, -0.037935>, <-2.602104, 5.063563, 1.889278>
			}
			smooth_triangle {
				<0.766854, 0.629253, -0.071332>, <-1.883553, 1.975231, 1.244429>,
				<0.733286, 0.662703, -0.110590>, <-5.056551, 5.333336, 3.153069>,
				<0.767527, 0.622163, -0.113670>, <-3.954149, 3.811131, 2.414552>
			}
			smooth_triangle {
				<0.683518, 0.704363, -0.160613>, <-3.779803, 4.251032, 1.906480>,
				<0.695367, 0.690443, -0.169890>, <-4.509824, 4.865749, 2.231373>,
				<0.697678, 0.692663, -0.150224>, <-3.171166, 3.482190, 1.677532>
			}
			smooth_triangle {
				<0.755654, 0.632653, -0.133576>, <-3.333420, 3.182003, 1.939083>,
				<0.767527, 0.622163, -0.113670>, <-3.954149, 3.811131, 2.414552>,
				<0.746494, 0.644283, -0.129479>, <-3.932158, 3.889748, 2.323588>
			}
			smooth_triangle {
				<0.767527, 0.622163, -0.113670>, <-3.954149, 3.811131, 2.414552>,
				<0.733286, 0.662703, -0.110590>, <-5.056551, 5.333336, 3.153069>,
				<0.746494, 0.644283, -0.129479>, <-3.932158, 3.889748, 2.323588>
			}
			smooth_triangle {
				<0.755654, 0.632653, -0.133576>, <-3.333420, 3.182003, 1.939083>,
				<0.746494, 0.644283, -0.129479>, <-3.932158, 3.889748, 2.323588>,
				<0.748027, 0.640193, -0.140425>, <-3.333034, 3.219259, 1.877727>
			}
			smooth_triangle {
				<0.748027, 0.640193, -0.140425>, <-3.333034, 3.219259, 1.877727>,
				<0.746494, 0.644283, -0.129479>, <-3.932158, 3.889748, 2.323588>,
				<0.739362, 0.649513, -0.143455>, <-4.634417, 4.570189, 2.575480>
			}
			smooth_triangle {
				<0.731678, 0.656483, -0.150948>, <-3.970822, 3.958056, 2.136579>,
				<0.727651, 0.662123, -0.145729>, <-3.924603, 3.997369, 2.148651>,
				<0.724304, 0.663493, -0.155753>, <-3.951476, 4.001905, 2.090363>
			}
			smooth_triangle {
				<0.695367, 0.690443, -0.169890>, <-4.509824, 4.865749, 2.231373>,
				<0.706947, 0.678613, -0.169764>, <-3.918440, 4.099478, 1.958916>,
				<0.709840, 0.679553, -0.153093>, <-4.509888, 4.790688, 2.388368>
			}
			smooth_triangle {
				<0.706947, 0.678613, -0.169764>, <-3.918440, 4.099478, 1.958916>,
				<0.716223, 0.670993, -0.160981>, <-3.930619, 4.050976, 2.034107>,
				<0.709840, 0.679553, -0.153093>, <-4.509888, 4.790688, 2.388368>
			}
			smooth_triangle {
				<0.716223, 0.670993, -0.160981>, <-3.930619, 4.050976, 2.034107>,
				<0.724304, 0.663493, -0.155753>, <-3.951476, 4.001905, 2.090363>,
				<0.720156, 0.669163, -0.150693>, <-3.254692, 3.368759, 1.748372>
			}
			smooth_triangle {
				<0.722467, 0.669423, -0.137920>, <-3.856613, 4.049148, 2.173757>,
				<0.720156, 0.669163, -0.150693>, <-3.254692, 3.368759, 1.748372>,
				<0.727651, 0.662123, -0.145729>, <-3.924603, 3.997369, 2.148651>
			}
			smooth_triangle {
				<0.724304, 0.663493, -0.155753>, <-3.951476, 4.001905, 2.090363>,
				<0.727651, 0.662123, -0.145729>, <-3.924603, 3.997369, 2.148651>,
				<0.720156, 0.669163, -0.150693>, <-3.254692, 3.368759, 1.748372>
			}
			smooth_triangle {
				<0.716223, 0.670993, -0.160981>, <-3.930619, 4.050976, 2.034107>,
				<0.720156, 0.669163, -0.150693>, <-3.254692, 3.368759, 1.748372>,
				<0.709840, 0.679553, -0.153093>, <-4.509888, 4.790688, 2.388368>
			}
			smooth_triangle {
				<0.720156, 0.669163, -0.150693>, <-3.254692, 3.368759, 1.748372>,
				<0.722467, 0.669423, -0.137920>, <-3.856613, 4.049148, 2.173757>,
				<0.709840, 0.679553, -0.153093>, <-4.509888, 4.790688, 2.388368>
			}
			smooth_triangle {
				<0.695367, 0.690443, -0.169890>, <-4.509824, 4.865749, 2.231373>,
				<0.709840, 0.679553, -0.153093>, <-4.509888, 4.790688, 2.388368>,
				<0.697678, 0.692663, -0.150224>, <-3.171166, 3.482190, 1.677532>
			}
			smooth_triangle {
				<0.722467, 0.669423, -0.137920>, <-3.856613, 4.049148, 2.173757>,
				<0.709040, 0.684793, -0.132018>, <-3.776755, 4.132424, 2.156052>,
				<0.709840, 0.679553, -0.153093>, <-4.509888, 4.790688, 2.388368>
			}
			smooth_triangle {
				<0.709840, 0.679553, -0.153093>, <-4.509888, 4.790688, 2.388368>,
				<0.709040, 0.684793, -0.132018>, <-3.776755, 4.132424, 2.156052>,
				<0.697678, 0.692663, -0.150224>, <-3.171166, 3.482190, 1.677532>
			}
			smooth_triangle {
				<0.709040, 0.684793, -0.132018>, <-3.776755, 4.132424, 2.156052>,
				<0.722467, 0.669423, -0.137920>, <-3.856613, 4.049148, 2.173757>,
				<0.733286, 0.662703, -0.110590>, <-5.056551, 5.333336, 3.153069>
			}
			smooth_triangle {
				<0.722467, 0.669423, -0.137920>, <-3.856613, 4.049148, 2.173757>,
				<0.727651, 0.662123, -0.145729>, <-3.924603, 3.997369, 2.148651>,
				<0.733854, 0.657493, -0.135178>, <-3.905241, 3.969943, 2.232636>
			}
			smooth_triangle {
				<0.746494, 0.644283, -0.129479>, <-3.932158, 3.889748, 2.323588>,
				<0.733854, 0.657493, -0.135178>, <-3.905241, 3.969943, 2.232636>,
				<0.739362, 0.649513, -0.143455>, <-4.634417, 4.570189, 2.575480>
			}
			smooth_triangle {
				<0.733854, 0.657493, -0.135178>, <-3.905241, 3.969943, 2.232636>,
				<0.727651, 0.662123, -0.145729>, <-3.924603, 3.997369, 2.148651>,
				<0.733170, 0.656423, -0.143833>, <-2.631803, 2.638170, 1.453594>
			}
			smooth_triangle {
				<0.727651, 0.662123, -0.145729>, <-3.924603, 3.997369, 2.148651>,
				<0.731678, 0.656483, -0.150948>, <-3.970822, 3.958056, 2.136579>,
				<0.733170, 0.656423, -0.143833>, <-2.631803, 2.638170, 1.453594>
			}
			smooth_triangle {
				<0.739362, 0.649513, -0.143455>, <-4.634417, 4.570189, 2.575480>,
				<0.733170, 0.656423, -0.143833>, <-2.631803, 2.638170, 1.453594>,
				<0.731678, 0.656483, -0.150948>, <-3.970822, 3.958056, 2.136579>
			}
			smooth_triangle {
				<0.739362, 0.649513, -0.143455>, <-4.634417, 4.570189, 2.575480>,
				<0.733854, 0.657493, -0.135178>, <-3.905241, 3.969943, 2.232636>,
				<0.733170, 0.656423, -0.143833>, <-2.631803, 2.638170, 1.453594>
			}
			smooth_triangle {
				<0.722467, 0.669423, -0.137920>, <-3.856613, 4.049148, 2.173757>,
				<0.733854, 0.657493, -0.135178>, <-3.905241, 3.969943, 2.232636>,
				<0.733286, 0.662703, -0.110590>, <-5.056551, 5.333336, 3.153069>
			}
			smooth_triangle {
				<0.733854, 0.657493, -0.135178>, <-3.905241, 3.969943, 2.232636>,
				<0.746494, 0.644283, -0.129479>, <-3.932158, 3.889748, 2.323588>,
				<0.733286, 0.662703, -0.110590>, <-5.056551, 5.333336, 3.153069>
			}
			smooth_triangle {
				<0.731678, 0.656483, -0.150948>, <-3.970822, 3.958056, 2.136579>,
				<0.737013, 0.649583, -0.154811>, <-4.005587, 3.919501, 2.142668>,
				<0.739362, 0.649513, -0.143455>, <-4.634417, 4.570189, 2.575480>
			}
			smooth_triangle {
				<0.739362, 0.649513, -0.143455>, <-4.634417, 4.570189, 2.575480>,
				<0.744873, 0.641833, -0.149410>, <-4.019306, 3.873461, 2.199996>,
				<0.748027, 0.640193, -0.140425>, <-3.333034, 3.219259, 1.877727>
			}
			smooth_triangle {
				<0.753503, 0.632443, -0.146143>, <-4.723151, 4.449671, 2.624855>,
				<0.762180, 0.623803, -0.138073>, <-4.053208, 3.765521, 2.321400>,
				<0.755654, 0.632653, -0.133576>, <-3.333420, 3.182003, 1.939083>
			}
			smooth_triangle {
				<0.762180, 0.623803, -0.138073>, <-4.053208, 3.765521, 2.321400>,
				<0.767527, 0.622163, -0.113670>, <-3.954149, 3.811131, 2.414552>,
				<0.755654, 0.632653, -0.133576>, <-3.333420, 3.182003, 1.939083>
			}
			smooth_triangle {
				<0.762180, 0.623803, -0.138073>, <-4.053208, 3.765521, 2.321400>,
				<0.768902, 0.616033, -0.135632>, <-2.023765, 1.871187, 1.184285>,
				<0.767527, 0.622163, -0.113670>, <-3.954149, 3.811131, 2.414552>
			}
			smooth_triangle {
				<0.768902, 0.616033, -0.135632>, <-2.023765, 1.871187, 1.184285>,
				<0.774787, 0.611673, -0.121120>, <-0.671984, 0.623382, 0.399790>,
				<0.767527, 0.622163, -0.113670>, <-3.954149, 3.811131, 2.414552>
			}
			smooth_triangle {
				<0.755654, 0.632653, -0.133576>, <-3.333420, 3.182003, 1.939083>,
				<0.748027, 0.640193, -0.140425>, <-3.333034, 3.219259, 1.877727>,
				<0.753503, 0.632443, -0.146143>, <-4.723151, 4.449671, 2.624855>
			}
			smooth_triangle {
				<0.748027, 0.640193, -0.140425>, <-3.333034, 3.219259, 1.877727>,
				<0.744873, 0.641833, -0.149410>, <-4.019306, 3.873461, 2.199996>,
				<0.753503, 0.632443, -0.146143>, <-4.723151, 4.449671, 2.624855>
			}
			smooth_triangle {
				<0.753503, 0.632443, -0.146143>, <-4.723151, 4.449671, 2.624855>,
				<0.744873, 0.641833, -0.149410>, <-4.019306, 3.873461, 2.199996>,
				<0.748577, 0.636493, -0.153693>, <-3.378855, 3.200081, 1.828100>
			}
			smooth_triangle {
				<0.748577, 0.636493, -0.153693>, <-3.378855, 3.200081, 1.828100>,
				<0.744873, 0.641833, -0.149410>, <-4.019306, 3.873461, 2.199996>,
				<0.742483, 0.642553, -0.157953>, <-4.042354, 3.878295, 2.148753>
			}
			smooth_triangle {
				<0.739362, 0.649513, -0.143455>, <-4.634417, 4.570189, 2.575480>,
				<0.737013, 0.649583, -0.154811>, <-4.005587, 3.919501, 2.142668>,
				<0.744873, 0.641833, -0.149410>, <-4.019306, 3.873461, 2.199996>
			}
			smooth_triangle {
				<0.744873, 0.641833, -0.149410>, <-4.019306, 3.873461, 2.199996>,
				<0.737013, 0.649583, -0.154811>, <-4.005587, 3.919501, 2.142668>,
				<0.742483, 0.642553, -0.157953>, <-4.042354, 3.878295, 2.148753>
			}
			smooth_triangle {
				<0.742483, 0.642553, -0.157953>, <-4.042354, 3.878295, 2.148753>,
				<0.747682, 0.636163, -0.159287>, <-2.033328, 1.922069, 1.082148>,
				<0.748577, 0.636493, -0.153693>, <-3.378855, 3.200081, 1.828100>
			}
			smooth_triangle {
				<0.747682, 0.636163, -0.159287>, <-2.033328, 1.922069, 1.082148>,
				<0.754198, 0.629343, -0.155629>, <-2.037337, 1.903235, 1.107581>,
				<0.748577, 0.636493, -0.153693>, <-3.378855, 3.200081, 1.828100>
			}
			smooth_triangle {
				<0.768902, 0.616033, -0.135632>, <-2.023765, 1.871187, 1.184285>,
				<0.762180, 0.623803, -0.138073>, <-4.053208, 3.765521, 2.321400>,
				<0.766313, 0.616613, -0.147180>, <-1.361922, 1.247562, 0.767270>
			}
			smooth_triangle {
				<0.748577, 0.636493, -0.153693>, <-3.378855, 3.200081, 1.828100>,
				<0.754198, 0.629343, -0.155629>, <-2.037337, 1.903235, 1.107581>,
				<0.753503, 0.632443, -0.146143>, <-4.723151, 4.449671, 2.624855>
			}
			smooth_triangle {
				<0.754198, 0.629343, -0.155629>, <-2.037337, 1.903235, 1.107581>,
				<0.760553, 0.622503, -0.152163>, <-2.039187, 1.886292, 1.132916>,
				<0.753503, 0.632443, -0.146143>, <-4.723151, 4.449671, 2.624855>
			}
			smooth_triangle {
				<0.766313, 0.616613, -0.147180>, <-1.361922, 1.247562, 0.767270>,
				<0.762180, 0.623803, -0.138073>, <-4.053208, 3.765521, 2.321400>,
				<0.760553, 0.622503, -0.152163>, <-2.039187, 1.886292, 1.132916>
			}
			smooth_triangle {
				<0.760553, 0.622503, -0.152163>, <-2.039187, 1.886292, 1.132916>,
				<0.762180, 0.623803, -0.138073>, <-4.053208, 3.765521, 2.321400>,
				<0.753503, 0.632443, -0.146143>, <-4.723151, 4.449671, 2.624855>
			}
			smooth_triangle {
				<0.731678, 0.656483, -0.150948>, <-3.970822, 3.958056, 2.136579>,
				<0.728321, 0.657563, -0.162074>, <-2.656941, 2.642469, 1.399148>,
				<0.737013, 0.649583, -0.154811>, <-4.005587, 3.919501, 2.142668>
			}
			smooth_triangle {
				<0.728321, 0.657563, -0.162074>, <-2.656941, 2.642469, 1.399148>,
				<0.735000, 0.649353, -0.164989>, <-2.013473, 1.956340, 1.057595>,
				<0.737013, 0.649583, -0.154811>, <-4.005587, 3.919501, 2.142668>
			}
			smooth_triangle {
				<0.747682, 0.636163, -0.159287>, <-2.033328, 1.922069, 1.082148>,
				<0.742483, 0.642553, -0.157953>, <-4.042354, 3.878295, 2.148753>,
				<0.741574, 0.641713, -0.165492>, <-1.350581, 1.292665, 0.710539>
			}
			smooth_triangle {
				<0.737013, 0.649583, -0.154811>, <-4.005587, 3.919501, 2.142668>,
				<0.735000, 0.649353, -0.164989>, <-2.013473, 1.956340, 1.057595>,
				<0.742483, 0.642553, -0.157953>, <-4.042354, 3.878295, 2.148753>
			}
			smooth_triangle {
				<0.735000, 0.649353, -0.164989>, <-2.013473, 1.956340, 1.057595>,
				<0.741574, 0.641713, -0.165492>, <-1.350581, 1.292665, 0.710539>,
				<0.742483, 0.642553, -0.157953>, <-4.042354, 3.878295, 2.148753>
			}
			smooth_triangle {
				<0.731678, 0.656483, -0.150948>, <-3.970822, 3.958056, 2.136579>,
				<0.724304, 0.663493, -0.155753>, <-3.951476, 4.001905, 2.090363>,
				<0.728321, 0.657563, -0.162074>, <-2.656941, 2.642469, 1.399148>
			}
			smooth_triangle {
				<0.716223, 0.670993, -0.160981>, <-3.930619, 4.050976, 2.034107>,
				<0.721584, 0.664483, -0.164004>, <-1.979552, 2.007644, 1.024895>,
				<0.724304, 0.663493, -0.155753>, <-3.951476, 4.001905, 2.090363>
			}
			smooth_triangle {
				<0.724304, 0.663493, -0.155753>, <-3.951476, 4.001905, 2.090363>,
				<0.721584, 0.664483, -0.164004>, <-1.979552, 2.007644, 1.024895>,
				<0.728321, 0.657563, -0.162074>, <-2.656941, 2.642469, 1.399148>
			}
			smooth_triangle {
				<0.706947, 0.678613, -0.169764>, <-3.918440, 4.099478, 1.958916>,
				<0.714117, 0.670363, -0.172529>, <-1.976085, 2.028796, 0.989306>,
				<0.716223, 0.670993, -0.160981>, <-3.930619, 4.050976, 2.034107>
			}
			smooth_triangle {
				<0.716223, 0.670993, -0.160981>, <-3.930619, 4.050976, 2.034107>,
				<0.714117, 0.670363, -0.172529>, <-1.976085, 2.028796, 0.989306>,
				<0.721584, 0.664483, -0.164004>, <-1.979552, 2.007644, 1.024895>
			}
			smooth_triangle {
				<0.505185, 0.841532, 0.160363>, <-2.234488, 6.735393, 3.665938>,
				<0.472478, 0.867062, 0.118646>, <-1.428675, 4.352661, 1.995011>,
				<0.509859, 0.849452, 0.087058>, <-2.015789, 5.117582, 2.388397>
			}
			smooth_triangle {
				<0.506921, 0.855512, -0.015340>, <-2.403710, 5.157555, 1.898292>,
				<0.479641, 0.871232, 0.003830>, <-2.184551, 5.260811, 1.877643>,
				<0.487393, 0.866362, -0.031238>, <-1.575326, 3.486849, 1.162627>
			}
			smooth_triangle {
				<0.411785, 0.904142, 0.045508>, <-1.733996, 5.450644, 1.807226>,
				<0.402396, 0.909482, 0.005569>, <-1.845182, 5.482132, 1.588086>,
				<0.440971, 0.891292, 0.015992>, <-2.315525, 6.265896, 2.082831>
			}
			smooth_triangle {
				<0.421165, 0.900482, -0.029330>, <-2.060903, 5.427600, 1.507304>,
				<0.440971, 0.891292, 0.015992>, <-2.315525, 6.265896, 2.082831>,
				<0.402396, 0.909482, 0.005569>, <-1.845182, 5.482132, 1.588086>
			}
			smooth_triangle {
				<0.421165, 0.900482, -0.029330>, <-2.060903, 5.427600, 1.507304>,
				<0.459422, 0.881232, -0.038405>, <-2.643565, 6.203174, 1.869901>,
				<0.440971, 0.891292, 0.015992>, <-2.315525, 6.265896, 2.082831>
			}
			smooth_triangle {
				<0.440971, 0.891292, 0.015992>, <-2.315525, 6.265896, 2.082831>,
				<0.459422, 0.881232, -0.038405>, <-2.643565, 6.203174, 1.869901>,
				<0.479641, 0.871232, 0.003830>, <-2.184551, 5.260811, 1.877643>
			}
			smooth_triangle {
				<0.459422, 0.881232, -0.038405>, <-2.643565, 6.203174, 1.869901>,
				<0.487393, 0.866362, -0.031238>, <-1.575326, 3.486849, 1.162627>,
				<0.479641, 0.871232, 0.003830>, <-2.184551, 5.260811, 1.877643>
			}
			smooth_triangle {
				<0.402396, 0.909482, 0.005569>, <-1.845182, 5.482132, 1.588086>,
				<0.411785, 0.904142, 0.045508>, <-1.733996, 5.450644, 1.807226>,
				<0.383252, 0.917152, 0.032677>, <-1.650890, 5.529922, 1.637093>
			}
			smooth_triangle {
				<0.411785, 0.904142, 0.045508>, <-1.733996, 5.450644, 1.807226>,
				<0.392084, 0.911382, 0.069089>, <-1.302560, 4.572668, 1.544152>,
				<0.383252, 0.917152, 0.032677>, <-1.650890, 5.529922, 1.637093>
			}
			smooth_triangle {
				<0.392084, 0.911382, 0.069089>, <-1.302560, 4.572668, 1.544152>,
				<0.369207, 0.921972, 0.052607>, <-0.524516, 1.848833, 0.553122>,
				<0.383252, 0.917152, 0.032677>, <-1.650890, 5.529922, 1.637093>
			}
			smooth_triangle {
				<0.421165, 0.900482, -0.029330>, <-2.060903, 5.427600, 1.507304>,
				<0.402396, 0.909482, 0.005569>, <-1.845182, 5.482132, 1.588086>,
				<0.385752, 0.916152, -0.031115>, <-1.904726, 5.525126, 1.351655>
			}
			smooth_triangle {
				<0.369207, 0.921972, 0.052607>, <-0.524516, 1.848833, 0.553122>,
				<0.353447, 0.929312, 0.023837>, <-0.801459, 2.792147, 0.747926>,
				<0.383252, 0.917152, 0.032677>, <-1.650890, 5.529922, 1.637093>
			}
			smooth_triangle {
				<0.353447, 0.929312, 0.023837>, <-0.801459, 2.792147, 0.747926>,
				<0.368619, 0.923702, -0.001035>, <-1.711771, 5.570498, 1.422603>,
				<0.383252, 0.917152, 0.032677>, <-1.650890, 5.529922, 1.637093>
			}
			smooth_triangle {
				<0.385752, 0.916152, -0.031115>, <-1.904726, 5.525126, 1.351655>,
				<0.402396, 0.909482, 0.005569>, <-1.845182, 5.482132, 1.588086>,
				<0.368619, 0.923702, -0.001035>, <-1.711771, 5.570498, 1.422603>
			}
			smooth_triangle {
				<0.402396, 0.909482, 0.005569>, <-1.845182, 5.482132, 1.588086>,
				<0.383252, 0.917152, 0.032677>, <-1.650890, 5.529922, 1.637093>,
				<0.368619, 0.923702, -0.001035>, <-1.711771, 5.570498, 1.422603>
			}
			smooth_triangle {
				<0.392084, 0.911382, 0.069089>, <-1.302560, 4.572668, 1.544152>,
				<0.411785, 0.904142, 0.045508>, <-1.733996, 5.450644, 1.807226>,
				<0.413369, 0.900452, 0.086148>, <-1.577785, 5.429714, 2.003141>
			}
			smooth_triangle {
				<0.506921, 0.855512, -0.015340>, <-2.403710, 5.157555, 1.898292>,
				<0.508191, 0.854352, 0.030511>, <-2.219586, 5.154211, 2.116441>,
				<0.479641, 0.871232, 0.003830>, <-2.184551, 5.260811, 1.877643>
			}
			smooth_triangle {
				<0.509859, 0.849452, 0.087058>, <-2.015789, 5.117582, 2.388397>,
				<0.472478, 0.867062, 0.118646>, <-1.428675, 4.352661, 1.995011>,
				<0.470562, 0.874052, 0.060871>, <-2.265636, 6.145682, 2.460254>
			}
			smooth_triangle {
				<0.472478, 0.867062, 0.118646>, <-1.428675, 4.352661, 1.995011>,
				<0.440068, 0.885612, 0.105583>, <-1.628588, 5.329342, 2.216565>,
				<0.470562, 0.874052, 0.060871>, <-2.265636, 6.145682, 2.460254>
			}
			smooth_triangle {
				<0.440068, 0.885612, 0.105583>, <-1.628588, 5.329342, 2.216565>,
				<0.413369, 0.900452, 0.086148>, <-1.577785, 5.429714, 2.003141>,
				<0.435871, 0.891722, 0.062932>, <-1.485242, 4.476197, 1.655924>
			}
			smooth_triangle {
				<0.413369, 0.900452, 0.086148>, <-1.577785, 5.429714, 2.003141>,
				<0.411785, 0.904142, 0.045508>, <-1.733996, 5.450644, 1.807226>,
				<0.435871, 0.891722, 0.062932>, <-1.485242, 4.476197, 1.655924>
			}
			smooth_triangle {
				<0.411785, 0.904142, 0.045508>, <-1.733996, 5.450644, 1.807226>,
				<0.440971, 0.891292, 0.015992>, <-2.315525, 6.265896, 2.082831>,
				<0.435871, 0.891722, 0.062932>, <-1.485242, 4.476197, 1.655924>
			}
			smooth_triangle {
				<0.440068, 0.885612, 0.105583>, <-1.628588, 5.329342, 2.216565>,
				<0.435871, 0.891722, 0.062932>, <-1.485242, 4.476197, 1.655924>,
				<0.470562, 0.874052, 0.060871>, <-2.265636, 6.145682, 2.460254>
			}
			smooth_triangle {
				<0.435871, 0.891722, 0.062932>, <-1.485242, 4.476197, 1.655924>,
				<0.440971, 0.891292, 0.015992>, <-2.315525, 6.265896, 2.082831>,
				<0.470562, 0.874052, 0.060871>, <-2.265636, 6.145682, 2.460254>
			}
			smooth_triangle {
				<0.509859, 0.849452, 0.087058>, <-2.015789, 5.117582, 2.388397>,
				<0.470562, 0.874052, 0.060871>, <-2.265636, 6.145682, 2.460254>,
				<0.508191, 0.854352, 0.030511>, <-2.219586, 5.154211, 2.116441>
			}
			smooth_triangle {
				<0.440971, 0.891292, 0.015992>, <-2.315525, 6.265896, 2.082831>,
				<0.479641, 0.871232, 0.003830>, <-2.184551, 5.260811, 1.877643>,
				<0.470562, 0.874052, 0.060871>, <-2.265636, 6.145682, 2.460254>
			}
			smooth_triangle {
				<0.470562, 0.874052, 0.060871>, <-2.265636, 6.145682, 2.460254>,
				<0.479641, 0.871232, 0.003830>, <-2.184551, 5.260811, 1.877643>,
				<0.508191, 0.854352, 0.030511>, <-2.219586, 5.154211, 2.116441>
			}
			smooth_triangle {
				<0.506921, 0.855512, -0.015340>, <-2.403710, 5.157555, 1.898292>,
				<0.532169, 0.840182, 0.001292>, <-2.048416, 4.216378, 1.734692>,
				<0.508191, 0.854352, 0.030511>, <-2.219586, 5.154211, 2.116441>
			}
			smooth_triangle {
				<0.505185, 0.841532, 0.160363>, <-2.234488, 6.735393, 3.665938>,
				<0.509859, 0.849452, 0.087058>, <-2.015789, 5.117582, 2.388397>,
				<0.550480, 0.821522, 0.105738>, <-1.782672, 4.108082, 2.212218>
			}
			smooth_triangle {
				<0.509859, 0.849452, 0.087058>, <-2.015789, 5.117582, 2.388397>,
				<0.545192, 0.830602, 0.044473>, <-2.356210, 4.995224, 2.335282>,
				<0.550480, 0.821522, 0.105738>, <-1.782672, 4.108082, 2.212218>
			}
			smooth_triangle {
				<0.545192, 0.830602, 0.044473>, <-2.356210, 4.995224, 2.335282>,
				<0.596609, 0.793703, 0.056587>, <-3.907951, 7.076840, 3.925373>,
				<0.550480, 0.821522, 0.105738>, <-1.782672, 4.108082, 2.212218>
			}
			smooth_triangle {
				<0.596609, 0.793703, 0.056587>, <-3.907951, 7.076840, 3.925373>,
				<0.599047, 0.776563, 0.164940>, <-1.422185, 3.222108, 1.892064>,
				<0.550480, 0.821522, 0.105738>, <-1.782672, 4.108082, 2.212218>
			}
			smooth_triangle {
				<0.505185, 0.841532, 0.160363>, <-2.234488, 6.735393, 3.665938>,
				<0.550480, 0.821522, 0.105738>, <-1.782672, 4.108082, 2.212218>,
				<0.599047, 0.776563, 0.164940>, <-1.422185, 3.222108, 1.892064>
			}
			smooth_triangle {
				<0.508191, 0.854352, 0.030511>, <-2.219586, 5.154211, 2.116441>,
				<0.545192, 0.830602, 0.044473>, <-2.356210, 4.995224, 2.335282>,
				<0.509859, 0.849452, 0.087058>, <-2.015789, 5.117582, 2.388397>
			}
			smooth_triangle {
				<0.508191, 0.854352, 0.030511>, <-2.219586, 5.154211, 2.116441>,
				<0.532169, 0.840182, 0.001292>, <-2.048416, 4.216378, 1.734692>,
				<0.545192, 0.830602, 0.044473>, <-2.356210, 4.995224, 2.335282>
			}
			smooth_triangle {
				<0.453475, 0.833852, 0.296920>, <-0.718492, 3.440915, 1.901268>,
				<0.505185, 0.841532, 0.160363>, <-2.234488, 6.735393, 3.665938>,
				<0.513481, 0.814972, 0.247522>, <-0.477332, 1.691012, 0.951767>
			}
			smooth_triangle {
				<0.392084, 0.911382, 0.069089>, <-1.302560, 4.572668, 1.544152>,
				<0.413369, 0.900452, 0.086148>, <-1.577785, 5.429714, 2.003141>,
				<0.386016, 0.910322, 0.106880>, <-1.596514, 6.401434, 2.334658>
			}
			smooth_triangle {
				<0.377445, 0.898192, 0.199747>, <-0.818568, 4.497717, 2.017691>,
				<0.385214, 0.903882, 0.154027>, <-1.181415, 5.448074, 2.212447>,
				<0.431216, 0.878422, 0.177564>, <-1.737034, 7.022621, 3.394000>
			}
			smooth_triangle {
				<0.385214, 0.903882, 0.154027>, <-1.181415, 5.448074, 2.212447>,
				<0.411746, 0.896472, 0.126202>, <-1.179898, 4.498233, 1.831519>,
				<0.431216, 0.878422, 0.177564>, <-1.737034, 7.022621, 3.394000>
			}
			smooth_triangle {
				<0.472478, 0.867062, 0.118646>, <-1.428675, 4.352661, 1.995011>,
				<0.431216, 0.878422, 0.177564>, <-1.737034, 7.022621, 3.394000>,
				<0.440068, 0.885612, 0.105583>, <-1.628588, 5.329342, 2.216565>
			}
			smooth_triangle {
				<0.411746, 0.896472, 0.126202>, <-1.179898, 4.498233, 1.831519>,
				<0.440068, 0.885612, 0.105583>, <-1.628588, 5.329342, 2.216565>,
				<0.431216, 0.878422, 0.177564>, <-1.737034, 7.022621, 3.394000>
			}
			smooth_triangle {
				<0.431216, 0.878422, 0.177564>, <-1.737034, 7.022621, 3.394000>,
				<0.376939, 0.882792, 0.260221>, <-0.763210, 5.291240, 2.706655>,
				<0.377445, 0.898192, 0.199747>, <-0.818568, 4.497717, 2.017691>
			}
			smooth_triangle {
				<0.431216, 0.878422, 0.177564>, <-1.737034, 7.022621, 3.394000>,
				<0.453475, 0.833852, 0.296920>, <-0.718492, 3.440915, 1.901268>,
				<0.376939, 0.882792, 0.260221>, <-0.763210, 5.291240, 2.706655>
			}
			smooth_triangle {
				<0.453475, 0.833852, 0.296920>, <-0.718492, 3.440915, 1.901268>,
				<0.431216, 0.878422, 0.177564>, <-1.737034, 7.022621, 3.394000>,
				<0.505185, 0.841532, 0.160363>, <-2.234488, 6.735393, 3.665938>
			}
			smooth_triangle {
				<0.431216, 0.878422, 0.177564>, <-1.737034, 7.022621, 3.394000>,
				<0.472478, 0.867062, 0.118646>, <-1.428675, 4.352661, 1.995011>,
				<0.505185, 0.841532, 0.160363>, <-2.234488, 6.735393, 3.665938>
			}
			smooth_triangle {
				<0.440068, 0.885612, 0.105583>, <-1.628588, 5.329342, 2.216565>,
				<0.411746, 0.896472, 0.126202>, <-1.179898, 4.498233, 1.831519>,
				<0.413369, 0.900452, 0.086148>, <-1.577785, 5.429714, 2.003141>
			}
			smooth_triangle {
				<0.385214, 0.903882, 0.154027>, <-1.181415, 5.448074, 2.212447>,
				<0.386016, 0.910322, 0.106880>, <-1.596514, 6.401434, 2.334658>,
				<0.411746, 0.896472, 0.126202>, <-1.179898, 4.498233, 1.831519>
			}
			smooth_triangle {
				<0.411746, 0.896472, 0.126202>, <-1.179898, 4.498233, 1.831519>,
				<0.386016, 0.910322, 0.106880>, <-1.596514, 6.401434, 2.334658>,
				<0.413369, 0.900452, 0.086148>, <-1.577785, 5.429714, 2.003141>
			}
			smooth_triangle {
				<0.525973, 0.841112, -0.070685>, <-1.351132, 2.528721, 0.881451>,
				<0.528211, 0.836632, -0.100734>, <-0.951469, 1.665704, 0.565575>,
				<0.549290, 0.826242, -0.068660>, <-2.813064, 4.973517, 1.824202>
			}
			smooth_triangle {
				<0.528211, 0.836632, -0.100734>, <-0.951469, 1.665704, 0.565575>,
				<0.558870, 0.814782, -0.113576>, <-1.999569, 3.271137, 1.137494>,
				<0.549290, 0.826242, -0.068660>, <-2.813064, 4.973517, 1.824202>
			}
			smooth_triangle {
				<0.714117, 0.670363, -0.172529>, <-1.976085, 2.028796, 0.989306>,
				<0.706947, 0.678613, -0.169764>, <-3.918440, 4.099478, 1.958916>,
				<0.706327, 0.676123, -0.181828>, <-1.976496, 2.045840, 0.952734>
			}
			smooth_triangle {
				<0.549290, 0.826242, -0.068660>, <-2.813064, 4.973517, 1.824202>,
				<0.558870, 0.814782, -0.113576>, <-1.999569, 3.271137, 1.137494>,
				<0.581030, 0.803842, -0.073244>, <-2.957983, 4.847652, 1.928375>
			}
			smooth_triangle {
				<0.558870, 0.814782, -0.113576>, <-1.999569, 3.271137, 1.137494>,
				<0.580294, 0.798932, -0.118629>, <-3.133594, 4.823615, 1.701536>,
				<0.581030, 0.803842, -0.073244>, <-2.957983, 4.847652, 1.928375>
			}
			smooth_triangle {
				<0.581030, 0.803842, -0.073244>, <-2.957983, 4.847652, 1.928375>,
				<0.580294, 0.798932, -0.118629>, <-3.133594, 4.823615, 1.701536>,
				<0.603509, 0.785423, -0.089391>, <-2.605793, 3.946640, 1.617497>
			}
			smooth_triangle {
				<0.580294, 0.798932, -0.118629>, <-3.133594, 4.823615, 1.701536>,
				<0.602231, 0.781413, -0.125810>, <-3.269417, 4.712976, 1.755632>,
				<0.603509, 0.785423, -0.089391>, <-2.605793, 3.946640, 1.617497>
			}
			smooth_triangle {
				<0.603509, 0.785423, -0.089391>, <-2.605793, 3.946640, 1.617497>,
				<0.602231, 0.781413, -0.125810>, <-3.269417, 4.712976, 1.755632>,
				<0.628762, 0.764613, -0.095608>, <-3.265867, 4.608656, 2.016299>
			}
			smooth_triangle {
				<0.602231, 0.781413, -0.125810>, <-3.269417, 4.712976, 1.755632>,
				<0.622871, 0.763323, -0.135936>, <-3.399065, 4.607544, 1.789544>,
				<0.628762, 0.764613, -0.095608>, <-3.265867, 4.608656, 2.016299>
			}
			smooth_triangle {
				<0.628762, 0.764613, -0.095608>, <-3.265867, 4.608656, 2.016299>,
				<0.622871, 0.763323, -0.135936>, <-3.399065, 4.607544, 1.789544>,
				<0.647588, 0.745813, -0.116234>, <-3.421364, 4.511337, 1.981153>
			}
			smooth_triangle {
				<0.622871, 0.763323, -0.135936>, <-3.399065, 4.607544, 1.789544>,
				<0.639604, 0.746863, -0.149037>, <-3.527838, 4.509248, 1.791804>,
				<0.647588, 0.745813, -0.116234>, <-3.421364, 4.511337, 1.981153>
			}
			smooth_triangle {
				<0.647588, 0.745813, -0.116234>, <-3.421364, 4.511337, 1.981153>,
				<0.639604, 0.746863, -0.149037>, <-3.527838, 4.509248, 1.791804>,
				<0.658856, 0.732913, -0.133640>, <-3.562986, 4.422084, 1.934395>
			}
			smooth_triangle {
				<0.639604, 0.746863, -0.149037>, <-3.527838, 4.509248, 1.791804>,
				<0.653663, 0.731903, -0.161748>, <-3.645687, 4.416510, 1.787392>,
				<0.658856, 0.732913, -0.133640>, <-3.562986, 4.422084, 1.934395>
			}
			smooth_triangle {
				<0.658856, 0.732913, -0.133640>, <-3.562986, 4.422084, 1.934395>,
				<0.653663, 0.731903, -0.161748>, <-3.645687, 4.416510, 1.787392>,
				<0.671637, 0.718583, -0.147158>, <-3.672371, 4.335527, 1.925754>
			}
			smooth_triangle {
				<0.653663, 0.731903, -0.161748>, <-3.645687, 4.416510, 1.787392>,
				<0.666534, 0.717333, -0.174023>, <-3.754050, 4.327765, 1.780387>,
				<0.671637, 0.718583, -0.147158>, <-3.672371, 4.335527, 1.925754>
			}
			smooth_triangle {
				<0.671637, 0.718583, -0.147158>, <-3.672371, 4.335527, 1.925754>,
				<0.666534, 0.717333, -0.174023>, <-3.754050, 4.327765, 1.780387>,
				<0.683518, 0.704363, -0.160613>, <-3.779803, 4.251032, 1.906480>
			}
			smooth_triangle {
				<0.666534, 0.717333, -0.174023>, <-3.754050, 4.327765, 1.780387>,
				<0.678692, 0.702583, -0.186744>, <-4.498689, 4.948538, 2.065127>,
				<0.683518, 0.704363, -0.160613>, <-3.779803, 4.251032, 1.906480>
			}
			smooth_triangle {
				<0.683518, 0.704363, -0.160613>, <-3.779803, 4.251032, 1.906480>,
				<0.678692, 0.702583, -0.186744>, <-4.498689, 4.948538, 2.065127>,
				<0.695367, 0.690443, -0.169890>, <-4.509824, 4.865749, 2.231373>
			}
			smooth_triangle {
				<0.678692, 0.702583, -0.186744>, <-4.498689, 4.948538, 2.065127>,
				<0.690408, 0.690613, -0.188416>, <-3.904930, 4.182111, 1.804842>,
				<0.695367, 0.690443, -0.169890>, <-4.509824, 4.865749, 2.231373>
			}
			smooth_triangle {
				<0.690408, 0.690613, -0.188416>, <-3.904930, 4.182111, 1.804842>,
				<0.697055, 0.683293, -0.190639>, <-1.973071, 2.065450, 0.916800>,
				<0.699285, 0.683863, -0.180109>, <-3.271770, 3.440473, 1.567519>
			}
			smooth_triangle {
				<0.697055, 0.683293, -0.190639>, <-1.973071, 2.065450, 0.916800>,
				<0.706327, 0.676123, -0.181828>, <-1.976496, 2.045840, 0.952734>,
				<0.699285, 0.683863, -0.180109>, <-3.271770, 3.440473, 1.567519>
			}
			smooth_triangle {
				<0.706327, 0.676123, -0.181828>, <-1.976496, 2.045840, 0.952734>,
				<0.706947, 0.678613, -0.169764>, <-3.918440, 4.099478, 1.958916>,
				<0.699285, 0.683863, -0.180109>, <-3.271770, 3.440473, 1.567519>
			}
			smooth_triangle {
				<0.690408, 0.690613, -0.188416>, <-3.904930, 4.182111, 1.804842>,
				<0.699285, 0.683863, -0.180109>, <-3.271770, 3.440473, 1.567519>,
				<0.695367, 0.690443, -0.169890>, <-4.509824, 4.865749, 2.231373>
			}
			smooth_triangle {
				<0.699285, 0.683863, -0.180109>, <-3.271770, 3.440473, 1.567519>,
				<0.706947, 0.678613, -0.169764>, <-3.918440, 4.099478, 1.958916>,
				<0.695367, 0.690443, -0.169890>, <-4.509824, 4.865749, 2.231373>
			}
			smooth_triangle {
				<0.421165, 0.900482, -0.029330>, <-2.060903, 5.427600, 1.507304>,
				<0.431715, 0.893532, -0.065793>, <-1.112400, 2.689057, 0.726924>,
				<0.459422, 0.881232, -0.038405>, <-2.643565, 6.203174, 1.869901>
			}
			smooth_triangle {
				<0.458375, 0.878112, -0.088985>, <-0.793807, 1.766602, 0.498728>,
				<0.459422, 0.881232, -0.038405>, <-2.643565, 6.203174, 1.869901>,
				<0.431715, 0.893532, -0.065793>, <-1.112400, 2.689057, 0.726924>
			}
			smooth_triangle {
				<0.458375, 0.878112, -0.088985>, <-0.793807, 1.766602, 0.498728>,
				<0.491011, 0.861712, -0.073971>, <-0.804842, 1.755354, 0.520377>,
				<0.459422, 0.881232, -0.038405>, <-2.643565, 6.203174, 1.869901>
			}
			smooth_triangle {
				<0.491011, 0.861712, -0.073971>, <-0.804842, 1.755354, 0.520377>,
				<0.487393, 0.866362, -0.031238>, <-1.575326, 3.486849, 1.162627>,
				<0.459422, 0.881232, -0.038405>, <-2.643565, 6.203174, 1.869901>
			}
			smooth_triangle {
				<0.385752, 0.916152, -0.031115>, <-1.904726, 5.525126, 1.351655>,
				<0.403267, 0.906932, -0.062887>, <-1.739163, 4.566279, 1.054258>,
				<0.421165, 0.900482, -0.029330>, <-2.060903, 5.427600, 1.507304>
			}
			smooth_triangle {
				<0.421165, 0.900482, -0.029330>, <-2.060903, 5.427600, 1.507304>,
				<0.403267, 0.906932, -0.062887>, <-1.739163, 4.566279, 1.054258>,
				<0.431715, 0.893532, -0.065793>, <-1.112400, 2.689057, 0.726924>
			}
			smooth_triangle {
				<0.363229, 0.920452, 0.099684>, <-0.862706, 3.694292, 1.266315>,
				<0.354664, 0.926402, 0.071508>, <-0.225630, 0.926939, 0.299791>,
				<0.377655, 0.916632, 0.079212>, <-0.700169, 2.761658, 0.938761>
			}
			smooth_triangle {
				<0.392084, 0.911382, 0.069089>, <-1.302560, 4.572668, 1.544152>,
				<0.386016, 0.910322, 0.106880>, <-1.596514, 6.401434, 2.334658>,
				<0.377655, 0.916632, 0.079212>, <-0.700169, 2.761658, 0.938761>
			}
			smooth_triangle {
				<0.376939, 0.882792, 0.260221>, <-0.763210, 5.291240, 2.706655>,
				<0.344332, 0.905272, 0.225874>, <-0.586189, 4.545112, 1.993455>,
				<0.377445, 0.898192, 0.199747>, <-0.818568, 4.497717, 2.017691>
			}
			smooth_triangle {
				<0.344332, 0.905272, 0.225874>, <-0.586189, 4.545112, 1.993455>,
				<0.345714, 0.915212, 0.178843>, <-1.056258, 6.436304, 2.535387>,
				<0.377445, 0.898192, 0.199747>, <-0.818568, 4.497717, 2.017691>
			}
			smooth_triangle {
				<0.377655, 0.916632, 0.079212>, <-0.700169, 2.761658, 0.938761>,
				<0.386016, 0.910322, 0.106880>, <-1.596514, 6.401434, 2.334658>,
				<0.363229, 0.920452, 0.099684>, <-0.862706, 3.694292, 1.266315>
			}
			smooth_triangle {
				<0.377445, 0.898192, 0.199747>, <-0.818568, 4.497717, 2.017691>,
				<0.345714, 0.915212, 0.178843>, <-1.056258, 6.436304, 2.535387>,
				<0.385214, 0.903882, 0.154027>, <-1.181415, 5.448074, 2.212447>
			}
			smooth_triangle {
				<0.345714, 0.915212, 0.178843>, <-1.056258, 6.436304, 2.535387>,
				<0.355614, 0.919222, 0.132940>, <-1.321849, 6.459411, 2.346844>,
				<0.385214, 0.903882, 0.154027>, <-1.181415, 5.448074, 2.212447>
			}
			smooth_triangle {
				<0.385214, 0.903882, 0.154027>, <-1.181415, 5.448074, 2.212447>,
				<0.355614, 0.919222, 0.132940>, <-1.321849, 6.459411, 2.346844>,
				<0.386016, 0.910322, 0.106880>, <-1.596514, 6.401434, 2.334658>
			}
			smooth_triangle {
				<0.386016, 0.910322, 0.106880>, <-1.596514, 6.401434, 2.334658>,
				<0.355614, 0.919222, 0.132940>, <-1.321849, 6.459411, 2.346844>,
				<0.363229, 0.920452, 0.099684>, <-0.862706, 3.694292, 1.266315>
			}
			smooth_triangle {
				<0.363229, 0.920452, 0.099684>, <-0.862706, 3.694292, 1.266315>,
				<0.355614, 0.919222, 0.132940>, <-1.321849, 6.459411, 2.346844>,
				<0.341904, 0.927532, 0.109040>, <-0.390482, 1.854727, 0.638295>
			}
			smooth_triangle {
				<0.345714, 0.915212, 0.178843>, <-1.056258, 6.436304, 2.535387>,
				<0.328214, 0.926272, 0.152994>, <-0.483141, 2.778011, 1.023406>,
				<0.355614, 0.919222, 0.132940>, <-1.321849, 6.459411, 2.346844>
			}
			smooth_triangle {
				<0.328214, 0.926272, 0.152994>, <-0.483141, 2.778011, 1.023406>,
				<0.336302, 0.927192, 0.127800>, <-0.361583, 1.856147, 0.650701>,
				<0.355614, 0.919222, 0.132940>, <-1.321849, 6.459411, 2.346844>
			}
			smooth_triangle {
				<0.336302, 0.927192, 0.127800>, <-0.361583, 1.856147, 0.650701>,
				<0.341904, 0.927532, 0.109040>, <-0.390482, 1.854727, 0.638295>,
				<0.355614, 0.919222, 0.132940>, <-1.321849, 6.459411, 2.346844>
			}
			smooth_triangle {
				<0.344332, 0.905272, 0.225874>, <-0.586189, 4.545112, 1.993455>,
				<0.313474, 0.919462, 0.213166>, <-0.620687, 5.538312, 2.216903>,
				<0.345714, 0.915212, 0.178843>, <-1.056258, 6.436304, 2.535387>
			}
			smooth_triangle {
				<0.312078, 0.928702, 0.170946>, <-0.502247, 3.720394, 1.378843>,
				<0.345714, 0.915212, 0.178843>, <-1.056258, 6.436304, 2.535387>,
				<0.313474, 0.919462, 0.213166>, <-0.620687, 5.538312, 2.216903>
			}
			smooth_triangle {
				<0.312078, 0.928702, 0.170946>, <-0.502247, 3.720394, 1.378843>,
				<0.328214, 0.926272, 0.152994>, <-0.483141, 2.778011, 1.023406>,
				<0.345714, 0.915212, 0.178843>, <-1.056258, 6.436304, 2.535387>
			}
			smooth_triangle {
				<0.313474, 0.919462, 0.213166>, <-0.620687, 5.538312, 2.216903>,
				<0.297069, 0.928602, 0.196385>, <-0.398135, 3.731776, 1.381190>,
				<0.312078, 0.928702, 0.170946>, <-0.502247, 3.720394, 1.378843>
			}
			smooth_triangle {
				<0.297069, 0.928602, 0.196385>, <-0.398135, 3.731776, 1.381190>,
				<0.293551, 0.937642, 0.154170>, <-0.111083, 0.939534, 0.323940>,
				<0.312078, 0.928702, 0.170946>, <-0.502247, 3.720394, 1.378843>
			}
			smooth_triangle {
				<0.376798, 0.850442, 0.351966>, <-0.194090, 2.631358, 1.421421>,
				<0.376939, 0.882792, 0.260221>, <-0.763210, 5.291240, 2.706655>,
				<0.453475, 0.833852, 0.296920>, <-0.718492, 3.440915, 1.901268>
			}
			smooth_triangle {
				<0.376939, 0.882792, 0.260221>, <-0.763210, 5.291240, 2.706655>,
				<0.376798, 0.850442, 0.351966>, <-0.194090, 2.631358, 1.421421>,
				<0.304812, 0.905772, 0.275262>, <-0.414468, 7.225702, 3.384852>
			}
			smooth_triangle {
				<0.278961, 0.861492, 0.411243>, <0.130643, 3.527350, 1.867146>,
				<0.251479, 0.904511, 0.328226>, <0.096178, 4.522292, 2.114795>,
				<0.304812, 0.905772, 0.275262>, <-0.414468, 7.225702, 3.384852>
			}
			smooth_triangle {
				<0.376939, 0.882792, 0.260221>, <-0.763210, 5.291240, 2.706655>,
				<0.304812, 0.905772, 0.275262>, <-0.414468, 7.225702, 3.384852>,
				<0.344332, 0.905272, 0.225874>, <-0.586189, 4.545112, 1.993455>
			}
			smooth_triangle {
				<0.297069, 0.928602, 0.196385>, <-0.398135, 3.731776, 1.381190>,
				<0.313474, 0.919462, 0.213166>, <-0.620687, 5.538312, 2.216903>,
				<0.273419, 0.928192, 0.229807>, <-0.423741, 6.520452, 2.503780>
			}
			smooth_triangle {
				<0.304812, 0.905772, 0.275262>, <-0.414468, 7.225702, 3.384852>,
				<0.313474, 0.919462, 0.213166>, <-0.620687, 5.538312, 2.216903>,
				<0.344332, 0.905272, 0.225874>, <-0.586189, 4.545112, 1.993455>
			}
			smooth_triangle {
				<0.304812, 0.905772, 0.275262>, <-0.414468, 7.225702, 3.384852>,
				<0.273419, 0.928192, 0.229807>, <-0.423741, 6.520452, 2.503780>,
				<0.313474, 0.919462, 0.213166>, <-0.620687, 5.538312, 2.216903>
			}
			smooth_triangle {
				<0.273419, 0.928192, 0.229807>, <-0.423741, 6.520452, 2.503780>,
				<0.304812, 0.905772, 0.275262>, <-0.414468, 7.225702, 3.384852>,
				<0.238916, 0.924941, 0.276617>, <-0.028948, 5.570954, 2.218135>
			}
			smooth_triangle {
				<0.304812, 0.905772, 0.275262>, <-0.414468, 7.225702, 3.384852>,
				<0.251479, 0.904511, 0.328226>, <0.096178, 4.522292, 2.114795>,
				<0.238916, 0.924941, 0.276617>, <-0.028948, 5.570954, 2.218135>
			}
			smooth_triangle {
				<0.297069, 0.928602, 0.196385>, <-0.398135, 3.731776, 1.381190>,
				<0.273419, 0.928192, 0.229807>, <-0.423741, 6.520452, 2.503780>,
				<0.277748, 0.935102, 0.193786>, <-0.225103, 2.818760, 1.001082>
			}
			smooth_triangle {
				<0.238916, 0.924941, 0.276617>, <-0.028948, 5.570954, 2.218135>,
				<0.229111, 0.938061, 0.238018>, <-0.116262, 5.649109, 2.013131>,
				<0.273419, 0.928192, 0.229807>, <-0.423741, 6.520452, 2.503780>
			}
			smooth_triangle {
				<0.229111, 0.938061, 0.238018>, <-0.116262, 5.649109, 2.013131>,
				<0.249405, 0.939081, 0.212218>, <-0.274533, 4.718721, 1.627328>,
				<0.273419, 0.928192, 0.229807>, <-0.423741, 6.520452, 2.503780>
			}
			smooth_triangle {
				<0.273419, 0.928192, 0.229807>, <-0.423741, 6.520452, 2.503780>,
				<0.249405, 0.939081, 0.212218>, <-0.274533, 4.718721, 1.627328>,
				<0.277748, 0.935102, 0.193786>, <-0.225103, 2.818760, 1.001082>
			}
			smooth_triangle {
				<0.229111, 0.938061, 0.238018>, <-0.116262, 5.649109, 2.013131>,
				<0.221661, 0.945431, 0.214781>, <-0.156051, 3.794798, 1.253347>,
				<0.249405, 0.939081, 0.212218>, <-0.274533, 4.718721, 1.627328>
			}
			smooth_triangle {
				<0.277748, 0.935102, 0.193786>, <-0.225103, 2.818760, 1.001082>,
				<0.249405, 0.939081, 0.212218>, <-0.274533, 4.718721, 1.627328>,
				<0.244080, 0.946481, 0.183594>, <-0.176011, 2.846219, 0.931027>
			}
			smooth_triangle {
				<0.244080, 0.946481, 0.183594>, <-0.176011, 2.846219, 0.931027>,
				<0.221661, 0.945431, 0.214781>, <-0.156051, 3.794798, 1.253347>,
				<0.225812, 0.950731, 0.185019>, <-0.051437, 0.950254, 0.307201>
			}
			smooth_triangle {
				<0.244080, 0.946481, 0.183594>, <-0.176011, 2.846219, 0.931027>,
				<0.249405, 0.939081, 0.212218>, <-0.274533, 4.718721, 1.627328>,
				<0.221661, 0.945431, 0.214781>, <-0.156051, 3.794798, 1.253347>
			}
			smooth_triangle {
				<0.156859, 0.862011, 0.470569>, <0.520635, 2.631389, 1.329674>,
				<0.194934, 0.898231, 0.379851>, <0.622462, 5.395866, 2.529353>,
				<0.278961, 0.861492, 0.411243>, <0.130643, 3.527350, 1.867146>
			}
			smooth_triangle {
				<0.278961, 0.861492, 0.411243>, <0.130643, 3.527350, 1.867146>,
				<0.194934, 0.898231, 0.379851>, <0.622462, 5.395866, 2.529353>,
				<0.251479, 0.904511, 0.328226>, <0.096178, 4.522292, 2.114795>
			}
			smooth_triangle {
				<0.194934, 0.898231, 0.379851>, <0.622462, 5.395866, 2.529353>,
				<0.188787, 0.923501, 0.317205>, <0.366440, 5.561568, 2.209908>,
				<0.251479, 0.904511, 0.328226>, <0.096178, 4.522292, 2.114795>
			}
			smooth_triangle {
				<0.251479, 0.904511, 0.328226>, <0.096178, 4.522292, 2.114795>,
				<0.188787, 0.923501, 0.317205>, <0.366440, 5.561568, 2.209908>,
				<0.238916, 0.924941, 0.276617>, <-0.028948, 5.570954, 2.218135>
			}
			smooth_triangle {
				<0.188787, 0.923501, 0.317205>, <0.366440, 5.561568, 2.209908>,
				<0.182317, 0.940841, 0.265887>, <0.227322, 6.611344, 2.279246>,
				<0.238916, 0.924941, 0.276617>, <-0.028948, 5.570954, 2.218135>
			}
			smooth_triangle {
				<0.238916, 0.924941, 0.276617>, <-0.028948, 5.570954, 2.218135>,
				<0.182317, 0.940841, 0.265887>, <0.227322, 6.611344, 2.279246>,
				<0.229111, 0.938061, 0.238018>, <-0.116262, 5.649109, 2.013131>
			}
			smooth_triangle {
				<0.182317, 0.940841, 0.265887>, <0.227322, 6.611344, 2.279246>,
				<0.196336, 0.946711, 0.233029>, <0.019775, 3.798337, 1.251579>,
				<0.229111, 0.938061, 0.238018>, <-0.116262, 5.649109, 2.013131>
			}
			smooth_triangle {
				<0.196336, 0.946711, 0.233029>, <0.019775, 3.798337, 1.251579>,
				<0.221661, 0.945431, 0.214781>, <-0.156051, 3.794798, 1.253347>,
				<0.229111, 0.938061, 0.238018>, <-0.116262, 5.649109, 2.013131>
			}
			smooth_triangle {
				<-0.242531, 0.857180, 0.442195>, <1.390113, 2.599359, 0.554970>,
				<-0.215260, 0.870350, 0.430434>, <2.212161, 4.376045, 0.969995>,
				<-0.197748, 0.855070, 0.467825>, <1.765261, 3.451625, 0.973348>
			}
			smooth_triangle {
				<0.002610, 0.950731, 0.291910>, <0.758322, 3.813563, 0.937123>,
				<-0.005036, 0.941811, 0.319512>, <1.470699, 6.624783, 1.711167>,
				<-0.017649, 0.948931, 0.297200>, <1.033748, 4.768069, 1.091563>
			}
			smooth_triangle {
				<-0.081719, 0.928560, 0.346719>, <1.723848, 5.600490, 1.284268>,
				<-0.071015, 0.918540, 0.374628>, <1.488020, 4.615831, 1.212534>,
				<-0.100589, 0.919170, 0.366234>, <1.891605, 5.541292, 1.303367>
			}
			smooth_triangle {
				<-0.122729, 0.908140, 0.386443>, <2.063260, 5.476349, 1.316643>,
				<-0.117041, 0.891140, 0.425767>, <2.204862, 5.364184, 1.526501>,
				<-0.149887, 0.898820, 0.398462>, <1.870966, 4.513364, 1.056177>
			}
			smooth_triangle {
				<-0.114188, 0.864390, 0.478436>, <2.417419, 5.170409, 1.819027>,
				<-0.170836, 0.881910, 0.426811>, <2.862424, 6.193275, 1.548947>,
				<-0.117041, 0.891140, 0.425767>, <2.204862, 5.364184, 1.526501>
			}
			smooth_triangle {
				<-0.170836, 0.881910, 0.426811>, <2.862424, 6.193275, 1.548947>,
				<-0.149887, 0.898820, 0.398462>, <1.870966, 4.513364, 1.056177>,
				<-0.117041, 0.891140, 0.425767>, <2.204862, 5.364184, 1.526501>
			}
			smooth_triangle {
				<-0.114188, 0.864390, 0.478436>, <2.417419, 5.170409, 1.819027>,
				<-0.197748, 0.855070, 0.467825>, <1.765261, 3.451625, 0.973348>,
				<-0.170836, 0.881910, 0.426811>, <2.862424, 6.193275, 1.548947>
			}
			smooth_triangle {
				<-0.170836, 0.881910, 0.426811>, <2.862424, 6.193275, 1.548947>,
				<-0.197748, 0.855070, 0.467825>, <1.765261, 3.451625, 0.973348>,
				<-0.215260, 0.870350, 0.430434>, <2.212161, 4.376045, 0.969995>
			}
			smooth_triangle {
				<-0.114188, 0.864390, 0.478436>, <2.417419, 5.170409, 1.819027>,
				<-0.117041, 0.891140, 0.425767>, <2.204862, 5.364184, 1.526501>,
				<-0.064797, 0.882420, 0.454145>, <1.735965, 4.411321, 1.572474>
			}
			smooth_triangle {
				<-0.122729, 0.908140, 0.386443>, <2.063260, 5.476349, 1.316643>,
				<-0.078834, 0.904800, 0.405260>, <2.272310, 6.358384, 1.836272>,
				<-0.117041, 0.891140, 0.425767>, <2.204862, 5.364184, 1.526501>
			}
			smooth_triangle {
				<-0.117041, 0.891140, 0.425767>, <2.204862, 5.364184, 1.526501>,
				<-0.078834, 0.904800, 0.405260>, <2.272310, 6.358384, 1.836272>,
				<-0.064797, 0.882420, 0.454145>, <1.735965, 4.411321, 1.572474>
			}
			smooth_triangle {
				<-0.100589, 0.919170, 0.366234>, <1.891605, 5.541292, 1.303367>,
				<-0.078834, 0.904800, 0.405260>, <2.272310, 6.358384, 1.836272>,
				<-0.122729, 0.908140, 0.386443>, <2.063260, 5.476349, 1.316643>
			}
			smooth_triangle {
				<-0.100589, 0.919170, 0.366234>, <1.891605, 5.541292, 1.303367>,
				<-0.071015, 0.918540, 0.374628>, <1.488020, 4.615831, 1.212534>,
				<-0.078834, 0.904800, 0.405260>, <2.272310, 6.358384, 1.836272>
			}
			smooth_triangle {
				<-0.064797, 0.882420, 0.454145>, <1.735965, 4.411321, 1.572474>,
				<-0.078834, 0.904800, 0.405260>, <2.272310, 6.358384, 1.836272>,
				<-0.027318, 0.895410, 0.431977>, <1.810801, 5.381477, 1.924049>
			}
			smooth_triangle {
				<-0.081719, 0.928560, 0.346719>, <1.723848, 5.600490, 1.284268>,
				<-0.046380, 0.925690, 0.360628>, <1.877024, 6.513844, 1.739458>,
				<-0.071015, 0.918540, 0.374628>, <1.488020, 4.615831, 1.212534>
			}
			smooth_triangle {
				<-0.078834, 0.904800, 0.405260>, <2.272310, 6.358384, 1.836272>,
				<-0.071015, 0.918540, 0.374628>, <1.488020, 4.615831, 1.212534>,
				<-0.047538, 0.912390, 0.392929>, <1.456012, 4.581670, 1.369174>
			}
			smooth_triangle {
				<-0.071015, 0.918540, 0.374628>, <1.488020, 4.615831, 1.212534>,
				<-0.046380, 0.925690, 0.360628>, <1.877024, 6.513844, 1.739458>,
				<-0.047538, 0.912390, 0.392929>, <1.456012, 4.581670, 1.369174>
			}
			smooth_triangle {
				<-0.046380, 0.925690, 0.360628>, <1.877024, 6.513844, 1.739458>,
				<-0.014144, 0.914690, 0.390193>, <1.580035, 5.513575, 1.755224>,
				<-0.047538, 0.912390, 0.392929>, <1.456012, 4.581670, 1.369174>
			}
			smooth_triangle {
				<-0.078834, 0.904800, 0.405260>, <2.272310, 6.358384, 1.836272>,
				<-0.047538, 0.912390, 0.392929>, <1.456012, 4.581670, 1.369174>,
				<-0.027318, 0.895410, 0.431977>, <1.810801, 5.381477, 1.924049>
			}
			smooth_triangle {
				<-0.047538, 0.912390, 0.392929>, <1.456012, 4.581670, 1.369174>,
				<-0.014144, 0.914690, 0.390193>, <1.580035, 5.513575, 1.755224>,
				<-0.027318, 0.895410, 0.431977>, <1.810801, 5.381477, 1.924049>
			}
			smooth_triangle {
				<-0.014144, 0.914690, 0.390193>, <1.580035, 5.513575, 1.755224>,
				<-0.046380, 0.925690, 0.360628>, <1.877024, 6.513844, 1.739458>,
				<-0.008899, 0.929201, 0.354423>, <1.415671, 5.603844, 1.604791>
			}
			smooth_triangle {
				<-0.081719, 0.928560, 0.346719>, <1.723848, 5.600490, 1.284268>,
				<-0.065123, 0.935820, 0.330326>, <1.588245, 5.641300, 1.281741>,
				<-0.046380, 0.925690, 0.360628>, <1.877024, 6.513844, 1.739458>
			}
			smooth_triangle {
				<-0.053852, 0.940540, 0.318727>, <0.749748, 2.832364, 0.643530>,
				<-0.040002, 0.944480, 0.308972>, <0.901202, 3.794569, 0.887041>,
				<-0.035976, 0.936660, 0.332407>, <1.457166, 5.647285, 1.404565>
			}
			smooth_triangle {
				<-0.008899, 0.929201, 0.354423>, <1.415671, 5.603844, 1.604791>,
				<-0.035976, 0.936660, 0.332407>, <1.457166, 5.647285, 1.404565>,
				<-0.005036, 0.941811, 0.319512>, <1.470699, 6.624783, 1.711167>
			}
			smooth_triangle {
				<-0.035976, 0.936660, 0.332407>, <1.457166, 5.647285, 1.404565>,
				<-0.040002, 0.944480, 0.308972>, <0.901202, 3.794569, 0.887041>,
				<-0.005036, 0.941811, 0.319512>, <1.470699, 6.624783, 1.711167>
			}
			smooth_triangle {
				<-0.040002, 0.944480, 0.308972>, <0.901202, 3.794569, 0.887041>,
				<-0.017649, 0.948931, 0.297200>, <1.033748, 4.768069, 1.091563>,
				<-0.005036, 0.941811, 0.319512>, <1.470699, 6.624783, 1.711167>
			}
			smooth_triangle {
				<-0.008899, 0.929201, 0.354423>, <1.415671, 5.603844, 1.604791>,
				<-0.046380, 0.925690, 0.360628>, <1.877024, 6.513844, 1.739458>,
				<-0.035976, 0.936660, 0.332407>, <1.457166, 5.647285, 1.404565>
			}
			smooth_triangle {
				<-0.046380, 0.925690, 0.360628>, <1.877024, 6.513844, 1.739458>,
				<-0.065123, 0.935820, 0.330326>, <1.588245, 5.641300, 1.281741>,
				<-0.035976, 0.936660, 0.332407>, <1.457166, 5.647285, 1.404565>
			}
			smooth_triangle {
				<-0.053852, 0.940540, 0.318727>, <0.749748, 2.832364, 0.643530>,
				<-0.035976, 0.936660, 0.332407>, <1.457166, 5.647285, 1.404565>,
				<-0.065123, 0.935820, 0.330326>, <1.588245, 5.641300, 1.281741>
			}
			smooth_triangle {
				<0.194934, 0.898231, 0.379851>, <0.622462, 5.395866, 2.529353>,
				<0.100330, 0.895521, 0.420828>, <1.192661, 5.368799, 2.373210>,
				<0.123127, 0.923221, 0.348725>, <0.919814, 6.477518, 2.474598>
			}
			smooth_triangle {
				<-0.027318, 0.895410, 0.431977>, <1.810801, 5.381477, 1.924049>,
				<-0.014144, 0.914690, 0.390193>, <1.580035, 5.513575, 1.755224>,
				<0.026264, 0.900751, 0.420800>, <1.519589, 5.404599, 2.099464>
			}
			smooth_triangle {
				<-0.008899, 0.929201, 0.354423>, <1.415671, 5.603844, 1.604791>,
				<-0.005036, 0.941811, 0.319512>, <1.470699, 6.624783, 1.711167>,
				<0.028998, 0.932691, 0.344032>, <1.193772, 5.625952, 1.703491>
			}
			smooth_triangle {
				<0.102739, 0.938781, 0.311828>, <0.615608, 4.713503, 1.546099>,
				<0.071299, 0.935301, 0.330520>, <0.959814, 5.635070, 1.816257>,
				<0.074950, 0.946631, 0.295605>, <0.808391, 5.708368, 1.657197>
			}
			smooth_triangle {
				<-0.005036, 0.941811, 0.319512>, <1.470699, 6.624783, 1.711167>,
				<0.002610, 0.950731, 0.291910>, <0.758322, 3.813563, 0.937123>,
				<0.035465, 0.946011, 0.304835>, <1.192357, 6.652917, 1.814468>
			}
			smooth_triangle {
				<0.002610, 0.950731, 0.291910>, <0.758322, 3.813563, 0.937123>,
				<0.022733, 0.954901, 0.277061>, <0.329436, 1.911689, 0.486305>,
				<0.035465, 0.946011, 0.304835>, <1.192357, 6.652917, 1.814468>
			}
			smooth_triangle {
				<0.074950, 0.946631, 0.295605>, <0.808391, 5.708368, 1.657197>,
				<0.035465, 0.946011, 0.304835>, <1.192357, 6.652917, 1.814468>,
				<0.051961, 0.955201, 0.272051>, <0.549855, 3.829990, 1.012217>
			}
			smooth_triangle {
				<0.022733, 0.954901, 0.277061>, <0.329436, 1.911689, 0.486305>,
				<0.051961, 0.955201, 0.272051>, <0.549855, 3.829990, 1.012217>,
				<0.035465, 0.946011, 0.304835>, <1.192357, 6.652917, 1.814468>
			}
			smooth_triangle {
				<-0.005036, 0.941811, 0.319512>, <1.470699, 6.624783, 1.711167>,
				<0.035465, 0.946011, 0.304835>, <1.192357, 6.652917, 1.814468>,
				<0.028998, 0.932691, 0.344032>, <1.193772, 5.625952, 1.703491>
			}
			smooth_triangle {
				<0.074950, 0.946631, 0.295605>, <0.808391, 5.708368, 1.657197>,
				<0.071299, 0.935301, 0.330520>, <0.959814, 5.635070, 1.816257>,
				<0.035465, 0.946011, 0.304835>, <1.192357, 6.652917, 1.814468>
			}
			smooth_triangle {
				<0.035465, 0.946011, 0.304835>, <1.192357, 6.652917, 1.814468>,
				<0.071299, 0.935301, 0.330520>, <0.959814, 5.635070, 1.816257>,
				<0.028998, 0.932691, 0.344032>, <1.193772, 5.625952, 1.703491>
			}
			smooth_triangle {
				<0.100330, 0.895521, 0.420828>, <1.192661, 5.368799, 2.373210>,
				<0.026264, 0.900751, 0.420800>, <1.519589, 5.404599, 2.099464>,
				<0.061765, 0.919231, 0.374589>, <1.159805, 5.535040, 1.994574>
			}
			smooth_triangle {
				<-0.014144, 0.914690, 0.390193>, <1.580035, 5.513575, 1.755224>,
				<-0.008899, 0.929201, 0.354423>, <1.415671, 5.603844, 1.604791>,
				<0.018900, 0.920011, 0.377270>, <1.145326, 4.620573, 1.523932>
			}
			smooth_triangle {
				<-0.008899, 0.929201, 0.354423>, <1.415671, 5.603844, 1.604791>,
				<0.028998, 0.932691, 0.344032>, <1.193772, 5.625952, 1.703491>,
				<0.018900, 0.920011, 0.377270>, <1.145326, 4.620573, 1.523932>
			}
			smooth_triangle {
				<0.028998, 0.932691, 0.344032>, <1.193772, 5.625952, 1.703491>,
				<0.061765, 0.919231, 0.374589>, <1.159805, 5.535040, 1.994574>,
				<0.018900, 0.920011, 0.377270>, <1.145326, 4.620573, 1.523932>
			}
			smooth_triangle {
				<-0.014144, 0.914690, 0.390193>, <1.580035, 5.513575, 1.755224>,
				<0.018900, 0.920011, 0.377270>, <1.145326, 4.620573, 1.523932>,
				<0.026264, 0.900751, 0.420800>, <1.519589, 5.404599, 2.099464>
			}
			smooth_triangle {
				<0.018900, 0.920011, 0.377270>, <1.145326, 4.620573, 1.523932>,
				<0.061765, 0.919231, 0.374589>, <1.159805, 5.535040, 1.994574>,
				<0.026264, 0.900751, 0.420800>, <1.519589, 5.404599, 2.099464>
			}
			smooth_triangle {
				<0.028998, 0.932691, 0.344032>, <1.193772, 5.625952, 1.703491>,
				<0.071299, 0.935301, 0.330520>, <0.959814, 5.635070, 1.816257>,
				<0.061765, 0.919231, 0.374589>, <1.159805, 5.535040, 1.994574>
			}
			smooth_triangle {
				<0.061765, 0.919231, 0.374589>, <1.159805, 5.535040, 1.994574>,
				<0.123127, 0.923221, 0.348725>, <0.919814, 6.477518, 2.474598>,
				<0.100330, 0.895521, 0.420828>, <1.192661, 5.368799, 2.373210>
			}
			smooth_triangle {
				<0.061765, 0.919231, 0.374589>, <1.159805, 5.535040, 1.994574>,
				<0.071299, 0.935301, 0.330520>, <0.959814, 5.635070, 1.816257>,
				<0.123127, 0.923221, 0.348725>, <0.919814, 6.477518, 2.474598>
			}
			smooth_triangle {
				<0.071299, 0.935301, 0.330520>, <0.959814, 5.635070, 1.816257>,
				<0.102739, 0.938781, 0.311828>, <0.615608, 4.713503, 1.546099>,
				<0.123127, 0.923221, 0.348725>, <0.919814, 6.477518, 2.474598>
			}
			smooth_triangle {
				<0.194934, 0.898231, 0.379851>, <0.622462, 5.395866, 2.529353>,
				<0.156859, 0.862011, 0.470569>, <0.520635, 2.631389, 1.329674>,
				<0.100330, 0.895521, 0.420828>, <1.192661, 5.368799, 2.373210>
			}
			smooth_triangle {
				<0.156859, 0.862011, 0.470569>, <0.520635, 2.631389, 1.329674>,
				<0.012032, 0.846221, 0.522385>, <1.912144, 5.189259, 2.296326>,
				<0.100330, 0.895521, 0.420828>, <1.192661, 5.368799, 2.373210>
			}
			smooth_triangle {
				<-0.197748, 0.855070, 0.467825>, <1.765261, 3.451625, 0.973348>,
				<-0.114188, 0.864390, 0.478436>, <2.417419, 5.170409, 1.819027>,
				<-0.146132, 0.810480, 0.557575>, <0.851693, 1.681796, 0.660992>
			}
			smooth_triangle {
				<0.100330, 0.895521, 0.420828>, <1.192661, 5.368799, 2.373210>,
				<0.012032, 0.846221, 0.522385>, <1.912144, 5.189259, 2.296326>,
				<0.026264, 0.900751, 0.420800>, <1.519589, 5.404599, 2.099464>
			}
			smooth_triangle {
				<-0.146132, 0.810480, 0.557575>, <0.851693, 1.681796, 0.660992>,
				<-0.114188, 0.864390, 0.478436>, <2.417419, 5.170409, 1.819027>,
				<0.012032, 0.846221, 0.522385>, <1.912144, 5.189259, 2.296326>
			}
			smooth_triangle {
				<-0.114188, 0.864390, 0.478436>, <2.417419, 5.170409, 1.819027>,
				<-0.064797, 0.882420, 0.454145>, <1.735965, 4.411321, 1.572474>,
				<0.012032, 0.846221, 0.522385>, <1.912144, 5.189259, 2.296326>
			}
			smooth_triangle {
				<-0.064797, 0.882420, 0.454145>, <1.735965, 4.411321, 1.572474>,
				<-0.027318, 0.895410, 0.431977>, <1.810801, 5.381477, 1.924049>,
				<0.012032, 0.846221, 0.522385>, <1.912144, 5.189259, 2.296326>
			}
			smooth_triangle {
				<0.012032, 0.846221, 0.522385>, <1.912144, 5.189259, 2.296326>,
				<-0.027318, 0.895410, 0.431977>, <1.810801, 5.381477, 1.924049>,
				<0.026264, 0.900751, 0.420800>, <1.519589, 5.404599, 2.099464>
			}
			smooth_triangle {
				<-0.040002, 0.944480, 0.308972>, <0.901202, 3.794569, 0.887041>,
				<-0.035823, 0.951770, 0.286276>, <0.418843, 1.911071, 0.414834>,
				<-0.017649, 0.948931, 0.297200>, <1.033748, 4.768069, 1.091563>
			}
			smooth_triangle {
				<-0.035823, 0.951770, 0.286276>, <0.418843, 1.911071, 0.414834>,
				<-0.010157, 0.954681, 0.278577>, <0.395846, 1.914222, 0.422893>,
				<-0.017649, 0.948931, 0.297200>, <1.033748, 4.768069, 1.091563>
			}
			smooth_triangle {
				<-0.010157, 0.954681, 0.278577>, <0.395846, 1.914222, 0.422893>,
				<0.002610, 0.950731, 0.291910>, <0.758322, 3.813563, 0.937123>,
				<-0.017649, 0.948931, 0.297200>, <1.033748, 4.768069, 1.091563>
			}
			smooth_triangle {
				<0.138486, 0.938881, 0.297380>, <0.502836, 5.656885, 1.927642>,
				<0.105205, 0.946971, 0.285099>, <0.506792, 4.760845, 1.437502>,
				<0.126773, 0.953731, 0.251872>, <0.521580, 7.666617, 2.215158>
			}
			smooth_triangle {
				<0.126773, 0.953731, 0.251872>, <0.521580, 7.666617, 2.215158>,
				<0.084470, 0.962391, 0.236196>, <0.525865, 5.803417, 1.423387>,
				<0.109566, 0.965801, 0.210582>, <0.188459, 2.901732, 0.736295>
			}
			smooth_triangle {
				<0.084470, 0.962391, 0.236196>, <0.525865, 5.803417, 1.423387>,
				<0.076758, 0.969771, 0.206782>, <0.156376, 1.942904, 0.447645>,
				<0.109566, 0.965801, 0.210582>, <0.188459, 2.901732, 0.736295>
			}
			smooth_triangle {
				<0.084470, 0.962391, 0.236196>, <0.525865, 5.803417, 1.423387>,
				<0.126773, 0.953731, 0.251872>, <0.521580, 7.666617, 2.215158>,
				<0.082422, 0.954391, 0.267313>, <0.644398, 5.758952, 1.550455>
			}
			smooth_triangle {
				<0.126773, 0.953731, 0.251872>, <0.521580, 7.666617, 2.215158>,
				<0.105205, 0.946971, 0.285099>, <0.506792, 4.760845, 1.437502>,
				<0.082422, 0.954391, 0.267313>, <0.644398, 5.758952, 1.550455>
			}
			smooth_triangle {
				<0.076758, 0.969771, 0.206782>, <0.156376, 1.942904, 0.447645>,
				<0.084470, 0.962391, 0.236196>, <0.525865, 5.803417, 1.423387>,
				<0.059783, 0.968581, 0.217697>, <0.305096, 2.908795, 0.666805>
			}
			smooth_triangle {
				<0.082422, 0.954391, 0.267313>, <0.644398, 5.758952, 1.550455>,
				<0.050561, 0.958381, 0.260877>, <0.447590, 3.863995, 0.931221>,
				<0.084470, 0.962391, 0.236196>, <0.525865, 5.803417, 1.423387>
			}
			smooth_triangle {
				<0.059783, 0.968581, 0.217697>, <0.305096, 2.908795, 0.666805>,
				<0.050561, 0.958381, 0.260877>, <0.447590, 3.863995, 0.931221>,
				<0.035138, 0.965761, 0.234904>, <0.110944, 0.968788, 0.221679>
			}
			smooth_triangle {
				<0.059783, 0.968581, 0.217697>, <0.305096, 2.908795, 0.666805>,
				<0.084470, 0.962391, 0.236196>, <0.525865, 5.803417, 1.423387>,
				<0.050561, 0.958381, 0.260877>, <0.447590, 3.863995, 0.931221>
			}
			smooth_triangle {
				<0.109566, 0.965801, 0.210582>, <0.188459, 2.901732, 0.736295>,
				<0.144231, 0.960991, 0.211662>, <0.111154, 2.888260, 0.802202>,
				<0.126773, 0.953731, 0.251872>, <0.521580, 7.666617, 2.215158>
			}
			smooth_triangle {
				<0.188787, 0.923501, 0.317205>, <0.366440, 5.561568, 2.209908>,
				<0.138486, 0.938881, 0.297380>, <0.502836, 5.656885, 1.927642>,
				<0.182317, 0.940841, 0.265887>, <0.227322, 6.611344, 2.279246>
			}
			smooth_triangle {
				<0.138486, 0.938881, 0.297380>, <0.502836, 5.656885, 1.927642>,
				<0.126773, 0.953731, 0.251872>, <0.521580, 7.666617, 2.215158>,
				<0.182317, 0.940841, 0.265887>, <0.227322, 6.611344, 2.279246>
			}
			smooth_triangle {
				<0.126773, 0.953731, 0.251872>, <0.521580, 7.666617, 2.215158>,
				<0.144231, 0.960991, 0.211662>, <0.111154, 2.888260, 0.802202>,
				<0.165510, 0.951771, 0.236337>, <0.142960, 4.781721, 1.450087>
			}
			smooth_triangle {
				<0.144231, 0.960991, 0.211662>, <0.111154, 2.888260, 0.802202>,
				<0.177319, 0.954061, 0.217786>, <0.029918, 1.917123, 0.568404>,
				<0.165510, 0.951771, 0.236337>, <0.142960, 4.781721, 1.450087>
			}
			smooth_triangle {
				<0.177319, 0.954061, 0.217786>, <0.029918, 1.917123, 0.568404>,
				<0.196336, 0.946711, 0.233029>, <0.019775, 3.798337, 1.251579>,
				<0.165510, 0.951771, 0.236337>, <0.142960, 4.781721, 1.450087>
			}
			smooth_triangle {
				<0.126773, 0.953731, 0.251872>, <0.521580, 7.666617, 2.215158>,
				<0.165510, 0.951771, 0.236337>, <0.142960, 4.781721, 1.450087>,
				<0.182317, 0.940841, 0.265887>, <0.227322, 6.611344, 2.279246>
			}
			smooth_triangle {
				<0.165510, 0.951771, 0.236337>, <0.142960, 4.781721, 1.450087>,
				<0.196336, 0.946711, 0.233029>, <0.019775, 3.798337, 1.251579>,
				<0.182317, 0.940841, 0.265887>, <0.227322, 6.611344, 2.279246>
			}
			smooth_triangle {
				<0.194934, 0.898231, 0.379851>, <0.622462, 5.395866, 2.529353>,
				<0.123127, 0.923221, 0.348725>, <0.919814, 6.477518, 2.474598>,
				<0.188787, 0.923501, 0.317205>, <0.366440, 5.561568, 2.209908>
			}
			smooth_triangle {
				<0.050561, 0.958381, 0.260877>, <0.447590, 3.863995, 0.931221>,
				<0.082422, 0.954391, 0.267313>, <0.644398, 5.758952, 1.550455>,
				<0.051961, 0.955201, 0.272051>, <0.549855, 3.829990, 1.012217>
			}
			smooth_triangle {
				<0.188787, 0.923501, 0.317205>, <0.366440, 5.561568, 2.209908>,
				<0.123127, 0.923221, 0.348725>, <0.919814, 6.477518, 2.474598>,
				<0.138486, 0.938881, 0.297380>, <0.502836, 5.656885, 1.927642>
			}
			smooth_triangle {
				<0.123127, 0.923221, 0.348725>, <0.919814, 6.477518, 2.474598>,
				<0.102739, 0.938781, 0.311828>, <0.615608, 4.713503, 1.546099>,
				<0.138486, 0.938881, 0.297380>, <0.502836, 5.656885, 1.927642>
			}
			smooth_triangle {
				<0.051961, 0.955201, 0.272051>, <0.549855, 3.829990, 1.012217>,
				<0.082422, 0.954391, 0.267313>, <0.644398, 5.758952, 1.550455>,
				<0.074950, 0.946631, 0.295605>, <0.808391, 5.708368, 1.657197>
			}
			smooth_triangle {
				<0.082422, 0.954391, 0.267313>, <0.644398, 5.758952, 1.550455>,
				<0.105205, 0.946971, 0.285099>, <0.506792, 4.760845, 1.437502>,
				<0.074950, 0.946631, 0.295605>, <0.808391, 5.708368, 1.657197>
			}
			smooth_triangle {
				<0.138486, 0.938881, 0.297380>, <0.502836, 5.656885, 1.927642>,
				<0.102739, 0.938781, 0.311828>, <0.615608, 4.713503, 1.546099>,
				<0.105205, 0.946971, 0.285099>, <0.506792, 4.760845, 1.437502>
			}
			smooth_triangle {
				<0.102739, 0.938781, 0.311828>, <0.615608, 4.713503, 1.546099>,
				<0.074950, 0.946631, 0.295605>, <0.808391, 5.708368, 1.657197>,
				<0.105205, 0.946971, 0.285099>, <0.506792, 4.760845, 1.437502>
			}
			smooth_triangle {
				<0.353447, 0.929312, 0.023837>, <-0.801459, 2.792147, 0.747926>,
				<0.334210, 0.936702, -0.003896>, <-0.820845, 2.811857, 0.646390>,
				<0.368619, 0.923702, -0.001035>, <-1.711771, 5.570498, 1.422603>
			}
			smooth_triangle {
				<0.403267, 0.906932, -0.062887>, <-1.739163, 4.566279, 1.054258>,
				<0.385752, 0.916152, -0.031115>, <-1.904726, 5.525126, 1.351655>,
				<0.365897, 0.922452, -0.065652>, <-1.947600, 5.563329, 1.111964>
			}
			smooth_triangle {
				<0.365897, 0.922452, -0.065652>, <-1.947600, 5.563329, 1.111964>,
				<0.385752, 0.916152, -0.031115>, <-1.904726, 5.525126, 1.351655>,
				<0.350546, 0.930092, -0.034039>, <-1.756229, 5.608790, 1.200050>
			}
			smooth_triangle {
				<0.385752, 0.916152, -0.031115>, <-1.904726, 5.525126, 1.351655>,
				<0.368619, 0.923702, -0.001035>, <-1.711771, 5.570498, 1.422603>,
				<0.350546, 0.930092, -0.034039>, <-1.756229, 5.608790, 1.200050>
			}
			smooth_triangle {
				<0.368619, 0.923702, -0.001035>, <-1.711771, 5.570498, 1.422603>,
				<0.334210, 0.936702, -0.003896>, <-0.820845, 2.811857, 0.646390>,
				<0.350546, 0.930092, -0.034039>, <-1.756229, 5.608790, 1.200050>
			}
			smooth_triangle {
				<0.365897, 0.922452, -0.065652>, <-1.947600, 5.563329, 1.111964>,
				<0.350546, 0.930092, -0.034039>, <-1.756229, 5.608790, 1.200050>,
				<0.326908, 0.936772, -0.068510>, <-0.909688, 2.810049, 0.523926>
			}
			smooth_triangle {
				<0.334210, 0.936702, -0.003896>, <-0.820845, 2.811857, 0.646390>,
				<0.319569, 0.941162, -0.034676>, <-0.562964, 1.881484, 0.377441>,
				<0.350546, 0.930092, -0.034039>, <-1.756229, 5.608790, 1.200050>
			}
			smooth_triangle {
				<0.350546, 0.930092, -0.034039>, <-1.756229, 5.608790, 1.200050>,
				<0.319569, 0.941162, -0.034676>, <-0.562964, 1.881484, 0.377441>,
				<0.326908, 0.936772, -0.068510>, <-0.909688, 2.810049, 0.523926>
			}
			smooth_triangle {
				<0.326908, 0.936772, -0.068510>, <-0.909688, 2.810049, 0.523926>,
				<0.340895, 0.929002, -0.099305>, <-1.000111, 2.785781, 0.487512>,
				<0.365897, 0.922452, -0.065652>, <-1.947600, 5.563329, 1.111964>
			}
			smooth_triangle {
				<0.447859, 0.880352, -0.116204>, <-1.263712, 2.659720, 0.569602>,
				<0.429704, 0.892842, -0.085396>, <-1.149839, 2.709468, 0.578594>,
				<0.415281, 0.895202, -0.123540>, <-2.392477, 5.400961, 1.042924>
			}
			smooth_triangle {
				<0.384136, 0.907492, -0.134179>, <-1.144508, 2.732298, 0.470994>,
				<0.385322, 0.911512, -0.098897>, <-2.522261, 6.413519, 1.215166>,
				<0.354714, 0.921012, -0.122571>, <-0.708162, 1.844560, 0.309315>
			}
			smooth_triangle {
				<0.365897, 0.922452, -0.065652>, <-1.947600, 5.563329, 1.111964>,
				<0.385322, 0.911512, -0.098897>, <-2.522261, 6.413519, 1.215166>,
				<0.403267, 0.906932, -0.062887>, <-1.739163, 4.566279, 1.054258>
			}
			smooth_triangle {
				<0.365897, 0.922452, -0.065652>, <-1.947600, 5.563329, 1.111964>,
				<0.340895, 0.929002, -0.099305>, <-1.000111, 2.785781, 0.487512>,
				<0.385322, 0.911512, -0.098897>, <-2.522261, 6.413519, 1.215166>
			}
			smooth_triangle {
				<0.340895, 0.929002, -0.099305>, <-1.000111, 2.785781, 0.487512>,
				<0.354714, 0.921012, -0.122571>, <-0.708162, 1.844560, 0.309315>,
				<0.385322, 0.911512, -0.098897>, <-2.522261, 6.413519, 1.215166>
			}
			smooth_triangle {
				<0.403267, 0.906932, -0.062887>, <-1.739163, 4.566279, 1.054258>,
				<0.385322, 0.911512, -0.098897>, <-2.522261, 6.413519, 1.215166>,
				<0.429704, 0.892842, -0.085396>, <-1.149839, 2.709468, 0.578594>
			}
			smooth_triangle {
				<0.384136, 0.907492, -0.134179>, <-1.144508, 2.732298, 0.470994>,
				<0.415281, 0.895202, -0.123540>, <-2.392477, 5.400961, 1.042924>,
				<0.385322, 0.911512, -0.098897>, <-2.522261, 6.413519, 1.215166>
			}
			smooth_triangle {
				<0.385322, 0.911512, -0.098897>, <-2.522261, 6.413519, 1.215166>,
				<0.415281, 0.895202, -0.123540>, <-2.392477, 5.400961, 1.042924>,
				<0.429704, 0.892842, -0.085396>, <-1.149839, 2.709468, 0.578594>
			}
			smooth_triangle {
				<0.384136, 0.907492, -0.134179>, <-1.144508, 2.732298, 0.470994>,
				<0.404071, 0.894512, -0.160266>, <-1.254507, 2.686306, 0.454904>,
				<0.415281, 0.895202, -0.123540>, <-2.392477, 5.400961, 1.042924>
			}
			smooth_triangle {
				<0.481479, 0.862642, -0.114625>, <-1.358720, 2.610289, 0.582831>,
				<0.447859, 0.880352, -0.116204>, <-1.263712, 2.659720, 0.569602>,
				<0.437757, 0.880872, -0.146786>, <-2.617386, 5.300412, 1.014173>
			}
			smooth_triangle {
				<0.447859, 0.880352, -0.116204>, <-1.263712, 2.659720, 0.569602>,
				<0.415281, 0.895202, -0.123540>, <-2.392477, 5.400961, 1.042924>,
				<0.437757, 0.880872, -0.146786>, <-2.617386, 5.300412, 1.014173>
			}
			smooth_triangle {
				<0.415281, 0.895202, -0.123540>, <-2.392477, 5.400961, 1.042924>,
				<0.404071, 0.894512, -0.160266>, <-1.254507, 2.686306, 0.454904>,
				<0.437757, 0.880872, -0.146786>, <-2.617386, 5.300412, 1.014173>
			}
			smooth_triangle {
				<0.437757, 0.880872, -0.146786>, <-2.617386, 5.300412, 1.014173>,
				<0.463406, 0.863072, -0.171649>, <-3.264806, 6.077037, 1.169523>,
				<0.481479, 0.862642, -0.114625>, <-1.358720, 2.610289, 0.582831>
			}
			smooth_triangle {
				<0.481479, 0.862642, -0.114625>, <-1.358720, 2.610289, 0.582831>,
				<0.463406, 0.863072, -0.171649>, <-3.264806, 6.077037, 1.169523>,
				<0.504759, 0.845712, -0.138220>, <-1.437786, 2.564354, 0.594852>
			}
			smooth_triangle {
				<0.463406, 0.863072, -0.171649>, <-3.264806, 6.077037, 1.169523>,
				<0.496972, 0.841792, -0.183079>, <-1.969602, 3.394726, 0.767945>,
				<0.504759, 0.845712, -0.138220>, <-1.437786, 2.564354, 0.594852>
			}
			smooth_triangle {
				<0.531841, 0.820142, -0.183358>, <-0.507302, 0.837656, 0.202429>,
				<0.532102, 0.826212, -0.152835>, <-1.005483, 1.680019, 0.407950>,
				<0.496972, 0.841792, -0.183079>, <-1.969602, 3.394726, 0.767945>
			}
			smooth_triangle {
				<0.496972, 0.841792, -0.183079>, <-1.969602, 3.394726, 0.767945>,
				<0.532102, 0.826212, -0.152835>, <-1.005483, 1.680019, 0.407950>,
				<0.504759, 0.845712, -0.138220>, <-1.437786, 2.564354, 0.594852>
			}
			smooth_triangle {
				<0.477995, 0.847862, -0.204373>, <-1.440958, 2.593370, 0.442448>,
				<0.496972, 0.841792, -0.183079>, <-1.969602, 3.394726, 0.767945>,
				<0.463406, 0.863072, -0.171649>, <-3.264806, 6.077037, 1.169523>
			}
			smooth_triangle {
				<0.404071, 0.894512, -0.160266>, <-1.254507, 2.686306, 0.454904>,
				<0.410856, 0.884672, -0.194091>, <-1.350703, 2.644474, 0.425801>,
				<0.437757, 0.880872, -0.146786>, <-2.617386, 5.300412, 1.014173>
			}
			smooth_triangle {
				<0.477995, 0.847862, -0.204373>, <-1.440958, 2.593370, 0.442448>,
				<0.427981, 0.870462, -0.219623>, <-1.415837, 2.612486, 0.411941>,
				<0.461016, 0.851322, -0.227656>, <-0.477399, 0.867940, 0.137002>
			}
			smooth_triangle {
				<0.477995, 0.847862, -0.204373>, <-1.440958, 2.593370, 0.442448>,
				<0.463406, 0.863072, -0.171649>, <-3.264806, 6.077037, 1.169523>,
				<0.427981, 0.870462, -0.219623>, <-1.415837, 2.612486, 0.411941>
			}
			smooth_triangle {
				<0.427981, 0.870462, -0.219623>, <-1.415837, 2.612486, 0.411941>,
				<0.463406, 0.863072, -0.171649>, <-3.264806, 6.077037, 1.169523>,
				<0.410856, 0.884672, -0.194091>, <-1.350703, 2.644474, 0.425801>
			}
			smooth_triangle {
				<0.463406, 0.863072, -0.171649>, <-3.264806, 6.077037, 1.169523>,
				<0.437757, 0.880872, -0.146786>, <-2.617386, 5.300412, 1.014173>,
				<0.410856, 0.884672, -0.194091>, <-1.350703, 2.644474, 0.425801>
			}
			smooth_triangle {
				<-0.289110, 0.897779, 0.315479>, <2.981925, 6.319307, 0.399461>,
				<-0.307123, 0.894859, 0.306614>, <1.735286, 3.600279, 0.154445>,
				<-0.305279, 0.901639, 0.288043>, <2.943088, 6.348016, 0.172622>
			}
			smooth_triangle {
				<-0.319933, 0.892879, 0.299204>, <2.207368, 4.484346, 0.113492>,
				<-0.305279, 0.901639, 0.288043>, <2.943088, 6.348016, 0.172622>,
				<-0.307123, 0.894859, 0.306614>, <1.735286, 3.600279, 0.154445>
			}
			smooth_triangle {
				<-0.289110, 0.897779, 0.315479>, <2.981925, 6.319307, 0.399461>,
				<-0.314014, 0.886559, 0.323309>, <3.165871, 6.233540, 0.323629>,
				<-0.307123, 0.894859, 0.306614>, <1.735286, 3.600279, 0.154445>
			}
			smooth_triangle {
				<-0.319933, 0.892879, 0.299204>, <2.207368, 4.484346, 0.113492>,
				<-0.307123, 0.894859, 0.306614>, <1.735286, 3.600279, 0.154445>,
				<-0.314014, 0.886559, 0.323309>, <3.165871, 6.233540, 0.323629>
			}
			smooth_triangle {
				<-0.289110, 0.897779, 0.315479>, <2.981925, 6.319307, 0.399461>,
				<-0.305279, 0.901639, 0.288043>, <2.943088, 6.348016, 0.172622>,
				<-0.281432, 0.909039, 0.289050>, <2.422268, 5.482890, 0.248640>
			}
			smooth_triangle {
				<-0.305279, 0.901639, 0.288043>, <2.943088, 6.348016, 0.172622>,
				<-0.295236, 0.910799, 0.269068>, <2.006855, 4.578273, 0.082135>,
				<-0.281432, 0.909039, 0.289050>, <2.422268, 5.482890, 0.248640>
			}
			smooth_triangle {
				<-0.289110, 0.897779, 0.315479>, <2.981925, 6.319307, 0.399461>,
				<-0.288526, 0.886499, 0.346371>, <2.674220, 5.348617, 0.479525>,
				<-0.314014, 0.886559, 0.323309>, <3.165871, 6.233540, 0.323629>
			}
			smooth_triangle {
				<-0.314014, 0.886559, 0.323309>, <3.165871, 6.233540, 0.323629>,
				<-0.288526, 0.886499, 0.346371>, <2.674220, 5.348617, 0.479525>,
				<-0.310061, 0.876399, 0.353424>, <2.325509, 4.411385, 0.352129>
			}
			smooth_triangle {
				<-0.295236, 0.910799, 0.269068>, <2.006855, 4.578273, 0.082135>,
				<-0.305279, 0.901639, 0.288043>, <2.943088, 6.348016, 0.172622>,
				<-0.314018, 0.907359, 0.259255>, <2.458823, 5.472174, -0.022592>
			}
			smooth_triangle {
				<-0.319933, 0.892879, 0.299204>, <2.207368, 4.484346, 0.113492>,
				<-0.329362, 0.896809, 0.276361>, <2.597805, 5.407479, -0.006679>,
				<-0.305279, 0.901639, 0.288043>, <2.943088, 6.348016, 0.172622>
			}
			smooth_triangle {
				<-0.305279, 0.901639, 0.288043>, <2.943088, 6.348016, 0.172622>,
				<-0.329362, 0.896809, 0.276361>, <2.597805, 5.407479, -0.006679>,
				<-0.314018, 0.907359, 0.259255>, <2.458823, 5.472174, -0.022592>
			}
			smooth_triangle {
				<-0.281432, 0.909039, 0.289050>, <2.422268, 5.482890, 0.248640>,
				<-0.295236, 0.910799, 0.269068>, <2.006855, 4.578273, 0.082135>,
				<-0.277634, 0.917939, 0.263489>, <2.300598, 5.538804, 0.141717>
			}
			smooth_triangle {
				<-0.314018, 0.907359, 0.259255>, <2.458823, 5.472174, -0.022592>,
				<-0.297501, 0.916899, 0.244744>, <2.317989, 5.533262, -0.026145>,
				<-0.295236, 0.910799, 0.269068>, <2.006855, 4.578273, 0.082135>
			}
			smooth_triangle {
				<-0.295236, 0.910799, 0.269068>, <2.006855, 4.578273, 0.082135>,
				<-0.297501, 0.916899, 0.244744>, <2.317989, 5.533262, -0.026145>,
				<-0.277634, 0.917939, 0.263489>, <2.300598, 5.538804, 0.141717>
			}
			smooth_triangle {
				<-0.297501, 0.916899, 0.244744>, <2.317989, 5.533262, -0.026145>,
				<-0.314018, 0.907359, 0.259255>, <2.458823, 5.472174, -0.022592>,
				<-0.319995, 0.913139, 0.229978>, <2.367991, 5.509188, -0.178258>
			}
			smooth_triangle {
				<-0.329362, 0.896809, 0.276361>, <2.597805, 5.407479, -0.006679>,
				<-0.336184, 0.903039, 0.246186>, <2.509485, 5.446562, -0.166469>,
				<-0.314018, 0.907359, 0.259255>, <2.458823, 5.472174, -0.022592>
			}
			smooth_triangle {
				<-0.314018, 0.907359, 0.259255>, <2.458823, 5.472174, -0.022592>,
				<-0.336184, 0.903039, 0.246186>, <2.509485, 5.446562, -0.166469>,
				<-0.319995, 0.913139, 0.229978>, <2.367991, 5.509188, -0.178258>
			}
			smooth_triangle {
				<-0.277634, 0.917939, 0.263489>, <2.300598, 5.538804, 0.141717>,
				<-0.297501, 0.916899, 0.244744>, <2.317989, 5.533262, -0.026145>,
				<-0.275466, 0.926649, 0.233590>, <2.548462, 6.518537, 0.007318>
			}
			smooth_triangle {
				<-0.319995, 0.913139, 0.229978>, <2.367991, 5.509188, -0.178258>,
				<-0.302078, 0.923569, 0.211863>, <2.588983, 6.498695, -0.222119>,
				<-0.297501, 0.916899, 0.244744>, <2.317989, 5.533262, -0.026145>
			}
			smooth_triangle {
				<-0.297501, 0.916899, 0.244744>, <2.317989, 5.533262, -0.026145>,
				<-0.302078, 0.923569, 0.211863>, <2.588983, 6.498695, -0.222119>,
				<-0.275466, 0.926649, 0.233590>, <2.548462, 6.518537, 0.007318>
			}
			smooth_triangle {
				<-0.275466, 0.926649, 0.233590>, <2.548462, 6.518537, 0.007318>,
				<-0.302078, 0.923569, 0.211863>, <2.588983, 6.498695, -0.222119>,
				<-0.278094, 0.933549, 0.200666>, <1.069436, 2.802110, -0.061196>
			}
			smooth_triangle {
				<-0.302078, 0.923569, 0.211863>, <2.588983, 6.498695, -0.222119>,
				<-0.297483, 0.929819, 0.189849>, <0.722980, 1.862860, -0.081390>,
				<-0.278094, 0.933549, 0.200666>, <1.069436, 2.802110, -0.061196>
			}
			smooth_triangle {
				<-0.297483, 0.929819, 0.189849>, <0.722980, 1.862860, -0.081390>,
				<-0.302078, 0.923569, 0.211863>, <2.588983, 6.498695, -0.222119>,
				<-0.317183, 0.924879, 0.181929>, <1.110059, 2.781864, -0.167551>
			}
			smooth_triangle {
				<-0.336184, 0.903039, 0.246186>, <2.509485, 5.446562, -0.166469>,
				<-0.341679, 0.908639, 0.216178>, <2.415891, 5.481756, -0.324308>,
				<-0.319995, 0.913139, 0.229978>, <2.367991, 5.509188, -0.178258>
			}
			smooth_triangle {
				<-0.341679, 0.908639, 0.216178>, <2.415891, 5.481756, -0.324308>,
				<-0.327834, 0.917299, 0.200474>, <2.290797, 5.534149, -0.341720>,
				<-0.319995, 0.913139, 0.229978>, <2.367991, 5.509188, -0.178258>
			}
			smooth_triangle {
				<-0.317183, 0.924879, 0.181929>, <1.110059, 2.781864, -0.167551>,
				<-0.302078, 0.923569, 0.211863>, <2.588983, 6.498695, -0.222119>,
				<-0.327834, 0.917299, 0.200474>, <2.290797, 5.534149, -0.341720>
			}
			smooth_triangle {
				<-0.302078, 0.923569, 0.211863>, <2.588983, 6.498695, -0.222119>,
				<-0.319995, 0.913139, 0.229978>, <2.367991, 5.509188, -0.178258>,
				<-0.327834, 0.917299, 0.200474>, <2.290797, 5.534149, -0.341720>
			}
			smooth_triangle {
				<-0.288526, 0.886499, 0.346371>, <2.674220, 5.348617, 0.479525>,
				<-0.285746, 0.875920, 0.374467>, <1.834985, 3.532292, 0.390177>,
				<-0.310061, 0.876399, 0.353424>, <2.325509, 4.411385, 0.352129>
			}
			smooth_triangle {
				<-0.285746, 0.875920, 0.374467>, <1.834985, 3.532292, 0.390177>,
				<-0.303665, 0.866519, 0.382142>, <0.469367, 0.878539, 0.088676>,
				<-0.310061, 0.876399, 0.353424>, <2.325509, 4.411385, 0.352129>
			}
			smooth_triangle {
				<-0.278094, 0.933549, 0.200666>, <1.069436, 2.802110, -0.061196>,
				<-0.261130, 0.934780, 0.217070>, <0.705344, 1.871395, -0.006098>,
				<-0.275466, 0.926649, 0.233590>, <2.548462, 6.518537, 0.007318>
			}
			smooth_triangle {
				<-0.261130, 0.934780, 0.217070>, <0.705344, 1.871395, -0.006098>,
				<-0.254280, 0.931790, 0.237104>, <1.067726, 2.802807, 0.054747>,
				<-0.275466, 0.926649, 0.233590>, <2.548462, 6.518537, 0.007318>
			}
			smooth_triangle {
				<-0.285746, 0.875920, 0.374467>, <1.834985, 3.532292, 0.390177>,
				<-0.288526, 0.886499, 0.346371>, <2.674220, 5.348617, 0.479525>,
				<-0.266746, 0.884180, 0.369046>, <2.661304, 5.334703, 0.669517>
			}
			smooth_triangle {
				<-0.266746, 0.884180, 0.369046>, <2.661304, 5.334703, 0.669517>,
				<-0.288526, 0.886499, 0.346371>, <2.674220, 5.348617, 0.479525>,
				<-0.264612, 0.896030, 0.340925>, <2.543662, 5.405270, 0.548555>
			}
			smooth_triangle {
				<-0.288526, 0.886499, 0.346371>, <2.674220, 5.348617, 0.479525>,
				<-0.289110, 0.897779, 0.315479>, <2.981925, 6.319307, 0.399461>,
				<-0.264612, 0.896030, 0.340925>, <2.543662, 5.405270, 0.548555>
			}
			smooth_triangle {
				<-0.264612, 0.896030, 0.340925>, <2.543662, 5.405270, 0.548555>,
				<-0.289110, 0.897779, 0.315479>, <2.981925, 6.319307, 0.399461>,
				<-0.261899, 0.907230, 0.312188>, <2.422072, 5.471676, 0.428080>
			}
			smooth_triangle {
				<-0.289110, 0.897779, 0.315479>, <2.981925, 6.319307, 0.399461>,
				<-0.281432, 0.909039, 0.289050>, <2.422268, 5.482890, 0.248640>,
				<-0.261899, 0.907230, 0.312188>, <2.422072, 5.471676, 0.428080>
			}
			smooth_triangle {
				<-0.261899, 0.907230, 0.312188>, <2.422072, 5.471676, 0.428080>,
				<-0.281432, 0.909039, 0.289050>, <2.422268, 5.482890, 0.248640>,
				<-0.258914, 0.917040, 0.284802>, <2.301150, 5.531485, 0.313463>
			}
			smooth_triangle {
				<-0.277634, 0.917939, 0.263489>, <2.300598, 5.538804, 0.141717>,
				<-0.258914, 0.917040, 0.284802>, <2.301150, 5.531485, 0.313463>,
				<-0.281432, 0.909039, 0.289050>, <2.422268, 5.482890, 0.248640>
			}
			smooth_triangle {
				<-0.258914, 0.917040, 0.284802>, <2.301150, 5.531485, 0.313463>,
				<-0.277634, 0.917939, 0.263489>, <2.300598, 5.538804, 0.141717>,
				<-0.256790, 0.925370, 0.258569>, <2.193024, 5.580594, 0.198395>
			}
			smooth_triangle {
				<-0.256790, 0.925370, 0.258569>, <2.193024, 5.580594, 0.198395>,
				<-0.275466, 0.926649, 0.233590>, <2.548462, 6.518537, 0.007318>,
				<-0.254280, 0.931790, 0.237104>, <1.067726, 2.802807, 0.054747>
			}
			smooth_triangle {
				<-0.256790, 0.925370, 0.258569>, <2.193024, 5.580594, 0.198395>,
				<-0.277634, 0.917939, 0.263489>, <2.300598, 5.538804, 0.141717>,
				<-0.275466, 0.926649, 0.233590>, <2.548462, 6.518537, 0.007318>
			}
			smooth_triangle {
				<-0.142930, 0.928690, 0.325918>, <1.600926, 4.668733, 0.795525>,
				<-0.161563, 0.921960, 0.336149>, <2.057711, 5.558464, 0.926030>,
				<-0.162806, 0.931500, 0.308081>, <1.948266, 5.618323, 0.793526>
			}
			smooth_triangle {
				<-0.266746, 0.884180, 0.369046>, <2.661304, 5.334703, 0.669517>,
				<-0.264612, 0.896030, 0.340925>, <2.543662, 5.405270, 0.548555>,
				<-0.241723, 0.892850, 0.365372>, <2.527004, 5.388006, 0.755591>
			}
			smooth_triangle {
				<-0.258914, 0.917040, 0.284802>, <2.301150, 5.531485, 0.313463>,
				<-0.237454, 0.924790, 0.278361>, <2.179530, 5.577401, 0.365948>,
				<-0.237762, 0.915970, 0.305903>, <2.285588, 5.524710, 0.493282>
			}
			smooth_triangle {
				<-0.237454, 0.924790, 0.278361>, <2.179530, 5.577401, 0.365948>,
				<-0.218848, 0.931750, 0.270307>, <1.388055, 3.740055, 0.287363>,
				<-0.215542, 0.924540, 0.296447>, <2.147536, 5.575767, 0.537528>
			}
			smooth_triangle {
				<-0.218848, 0.931750, 0.270307>, <1.388055, 3.740055, 0.287363>,
				<-0.197465, 0.932730, 0.283080>, <2.015567, 5.624297, 0.544898>,
				<-0.215542, 0.924540, 0.296447>, <2.147536, 5.575767, 0.537528>
			}
			smooth_triangle {
				<-0.161563, 0.921960, 0.336149>, <2.057711, 5.558464, 0.926030>,
				<-0.187970, 0.925110, 0.312970>, <2.436741, 6.507150, 0.838784>,
				<-0.162806, 0.931500, 0.308081>, <1.948266, 5.618323, 0.793526>
			}
			smooth_triangle {
				<-0.215542, 0.924540, 0.296447>, <2.147536, 5.575767, 0.537528>,
				<-0.197465, 0.932730, 0.283080>, <2.015567, 5.624297, 0.544898>,
				<-0.187970, 0.925110, 0.312970>, <2.436741, 6.507150, 0.838784>
			}
			smooth_triangle {
				<-0.197465, 0.932730, 0.283080>, <2.015567, 5.624297, 0.544898>,
				<-0.178749, 0.934300, 0.290247>, <1.629686, 4.695388, 0.540623>,
				<-0.187970, 0.925110, 0.312970>, <2.436741, 6.507150, 0.838784>
			}
			smooth_triangle {
				<-0.178749, 0.934300, 0.290247>, <1.629686, 4.695388, 0.540623>,
				<-0.162806, 0.931500, 0.308081>, <1.948266, 5.618323, 0.793526>,
				<-0.187970, 0.925110, 0.312970>, <2.436741, 6.507150, 0.838784>
			}
			smooth_triangle {
				<-0.237454, 0.924790, 0.278361>, <2.179530, 5.577401, 0.365948>,
				<-0.215542, 0.924540, 0.296447>, <2.147536, 5.575767, 0.537528>,
				<-0.237762, 0.915970, 0.305903>, <2.285588, 5.524710, 0.493282>
			}
			smooth_triangle {
				<-0.161563, 0.921960, 0.336149>, <2.057711, 5.558464, 0.926030>,
				<-0.185855, 0.912900, 0.348099>, <2.210029, 5.505686, 0.888150>,
				<-0.187970, 0.925110, 0.312970>, <2.436741, 6.507150, 0.838784>
			}
			smooth_triangle {
				<-0.185855, 0.912900, 0.348099>, <2.210029, 5.505686, 0.888150>,
				<-0.213312, 0.914810, 0.326703>, <2.251814, 5.517804, 0.685773>,
				<-0.187970, 0.925110, 0.312970>, <2.436741, 6.507150, 0.838784>
			}
			smooth_triangle {
				<-0.237762, 0.915970, 0.305903>, <2.285588, 5.524710, 0.493282>,
				<-0.215542, 0.924540, 0.296447>, <2.147536, 5.575767, 0.537528>,
				<-0.213312, 0.914810, 0.326703>, <2.251814, 5.517804, 0.685773>
			}
			smooth_triangle {
				<-0.215542, 0.924540, 0.296447>, <2.147536, 5.575767, 0.537528>,
				<-0.187970, 0.925110, 0.312970>, <2.436741, 6.507150, 0.838784>,
				<-0.213312, 0.914810, 0.326703>, <2.251814, 5.517804, 0.685773>
			}
			smooth_triangle {
				<-0.258914, 0.917040, 0.284802>, <2.301150, 5.531485, 0.313463>,
				<-0.237762, 0.915970, 0.305903>, <2.285588, 5.524710, 0.493282>,
				<-0.261899, 0.907230, 0.312188>, <2.422072, 5.471676, 0.428080>
			}
			smooth_triangle {
				<-0.185855, 0.912900, 0.348099>, <2.210029, 5.505686, 0.888150>,
				<-0.213336, 0.902380, 0.359593>, <2.380939, 5.441720, 0.838636>,
				<-0.213312, 0.914810, 0.326703>, <2.251814, 5.517804, 0.685773>
			}
			smooth_triangle {
				<-0.213336, 0.902380, 0.359593>, <2.380939, 5.441720, 0.838636>,
				<-0.238875, 0.905290, 0.335412>, <2.403531, 5.460690, 0.625893>,
				<-0.213312, 0.914810, 0.326703>, <2.251814, 5.517804, 0.685773>
			}
			smooth_triangle {
				<-0.261899, 0.907230, 0.312188>, <2.422072, 5.471676, 0.428080>,
				<-0.237762, 0.915970, 0.305903>, <2.285588, 5.524710, 0.493282>,
				<-0.238875, 0.905290, 0.335412>, <2.403531, 5.460690, 0.625893>
			}
			smooth_triangle {
				<-0.237762, 0.915970, 0.305903>, <2.285588, 5.524710, 0.493282>,
				<-0.213312, 0.914810, 0.326703>, <2.251814, 5.517804, 0.685773>,
				<-0.238875, 0.905290, 0.335412>, <2.403531, 5.460690, 0.625893>
			}
			smooth_triangle {
				<-0.261899, 0.907230, 0.312188>, <2.422072, 5.471676, 0.428080>,
				<-0.238875, 0.905290, 0.335412>, <2.403531, 5.460690, 0.625893>,
				<-0.264612, 0.896030, 0.340925>, <2.543662, 5.405270, 0.548555>
			}
			smooth_triangle {
				<-0.213336, 0.902380, 0.359593>, <2.380939, 5.441720, 0.838636>,
				<-0.241723, 0.892850, 0.365372>, <2.527004, 5.388006, 0.755591>,
				<-0.238875, 0.905290, 0.335412>, <2.403531, 5.460690, 0.625893>
			}
			smooth_triangle {
				<-0.238875, 0.905290, 0.335412>, <2.403531, 5.460690, 0.625893>,
				<-0.241723, 0.892850, 0.365372>, <2.527004, 5.388006, 0.755591>,
				<-0.264612, 0.896030, 0.340925>, <2.543662, 5.405270, 0.548555>
			}
			smooth_triangle {
				<-0.258914, 0.917040, 0.284802>, <2.301150, 5.531485, 0.313463>,
				<-0.256790, 0.925370, 0.258569>, <2.193024, 5.580594, 0.198395>,
				<-0.237454, 0.924790, 0.278361>, <2.179530, 5.577401, 0.365948>
			}
			smooth_triangle {
				<-0.254280, 0.931790, 0.237104>, <1.067726, 2.802807, 0.054747>,
				<-0.236448, 0.932310, 0.252988>, <1.062879, 2.802089, 0.132579>,
				<-0.256790, 0.925370, 0.258569>, <2.193024, 5.580594, 0.198395>
			}
			smooth_triangle {
				<-0.218848, 0.931750, 0.270307>, <1.388055, 3.740055, 0.287363>,
				<-0.237454, 0.924790, 0.278361>, <2.179530, 5.577401, 0.365948>,
				<-0.236448, 0.932310, 0.252988>, <1.062879, 2.802089, 0.132579>
			}
			smooth_triangle {
				<-0.256790, 0.925370, 0.258569>, <2.193024, 5.580594, 0.198395>,
				<-0.236448, 0.932310, 0.252988>, <1.062879, 2.802089, 0.132579>,
				<-0.237454, 0.924790, 0.278361>, <2.179530, 5.577401, 0.365948>
			}
			smooth_triangle {
				<-0.076261, 0.943330, 0.305665>, <0.789256, 2.836591, 0.574129>,
				<-0.091314, 0.938280, 0.316848>, <1.662090, 5.656753, 1.108399>,
				<-0.092686, 0.946140, 0.292126>, <0.810381, 2.844795, 0.499468>
			}
			smooth_triangle {
				<-0.162806, 0.931500, 0.308081>, <1.948266, 5.618323, 0.793526>,
				<-0.141273, 0.936900, 0.302270>, <1.816612, 5.653600, 0.851831>,
				<-0.142930, 0.928690, 0.325918>, <1.600926, 4.668733, 0.795525>
			}
			smooth_triangle {
				<-0.092686, 0.946140, 0.292126>, <0.810381, 2.844795, 0.499468>,
				<-0.091314, 0.938280, 0.316848>, <1.662090, 5.656753, 1.108399>,
				<-0.116432, 0.942540, 0.295237>, <1.979129, 6.627909, 1.067339>
			}
			smooth_triangle {
				<-0.091314, 0.938280, 0.316848>, <1.662090, 5.656753, 1.108399>,
				<-0.115429, 0.931180, 0.329694>, <2.110557, 6.553236, 1.257496>,
				<-0.116432, 0.942540, 0.295237>, <1.979129, 6.627909, 1.067339>
			}
			smooth_triangle {
				<-0.142930, 0.928690, 0.325918>, <1.600926, 4.668733, 0.795525>,
				<-0.141273, 0.936900, 0.302270>, <1.816612, 5.653600, 0.851831>,
				<-0.115429, 0.931180, 0.329694>, <2.110557, 6.553236, 1.257496>
			}
			smooth_triangle {
				<-0.115429, 0.931180, 0.329694>, <2.110557, 6.553236, 1.257496>,
				<-0.141273, 0.936900, 0.302270>, <1.816612, 5.653600, 0.851831>,
				<-0.116432, 0.942540, 0.295237>, <1.979129, 6.627909, 1.067339>
			}
			smooth_triangle {
				<-0.162806, 0.931500, 0.308081>, <1.948266, 5.618323, 0.793526>,
				<-0.164108, 0.940160, 0.279802>, <1.244815, 3.771670, 0.471737>,
				<-0.141273, 0.936900, 0.302270>, <1.816612, 5.653600, 0.851831>
			}
			smooth_triangle {
				<-0.164108, 0.940160, 0.279802>, <1.244815, 3.771670, 0.471737>,
				<-0.145445, 0.945080, 0.273449>, <0.881487, 2.839935, 0.396520>,
				<-0.141273, 0.936900, 0.302270>, <1.816612, 5.653600, 0.851831>
			}
			smooth_triangle {
				<-0.092686, 0.946140, 0.292126>, <0.810381, 2.844795, 0.499468>,
				<-0.116432, 0.942540, 0.295237>, <1.979129, 6.627909, 1.067339>,
				<-0.102977, 0.949810, 0.276362>, <0.539310, 1.902705, 0.297867>
			}
			smooth_triangle {
				<-0.141273, 0.936900, 0.302270>, <1.816612, 5.653600, 0.851831>,
				<-0.145445, 0.945080, 0.273449>, <0.881487, 2.839935, 0.396520>,
				<-0.116432, 0.942540, 0.295237>, <1.979129, 6.627909, 1.067339>
			}
			smooth_triangle {
				<-0.145445, 0.945080, 0.273449>, <0.881487, 2.839935, 0.396520>,
				<-0.125533, 0.947730, 0.274155>, <0.563291, 1.898454, 0.279389>,
				<-0.116432, 0.942540, 0.295237>, <1.979129, 6.627909, 1.067339>
			}
			smooth_triangle {
				<-0.125533, 0.947730, 0.274155>, <0.563291, 1.898454, 0.279389>,
				<-0.102977, 0.949810, 0.276362>, <0.539310, 1.902705, 0.297867>,
				<-0.116432, 0.942540, 0.295237>, <1.979129, 6.627909, 1.067339>
			}
			smooth_triangle {
				<-0.162806, 0.931500, 0.308081>, <1.948266, 5.618323, 0.793526>,
				<-0.178749, 0.934300, 0.290247>, <1.629686, 4.695388, 0.540623>,
				<-0.164108, 0.940160, 0.279802>, <1.244815, 3.771670, 0.471737>
			}
			smooth_triangle {
				<-0.218848, 0.931750, 0.270307>, <1.388055, 3.740055, 0.287363>,
				<-0.202059, 0.938210, 0.260866>, <0.659359, 1.881267, 0.160979>,
				<-0.197465, 0.932730, 0.283080>, <2.015567, 5.624297, 0.544898>
			}
			smooth_triangle {
				<-0.164108, 0.940160, 0.279802>, <1.244815, 3.771670, 0.471737>,
				<-0.178749, 0.934300, 0.290247>, <1.629686, 4.695388, 0.540623>,
				<-0.181380, 0.940820, 0.266607>, <0.963623, 2.827200, 0.278977>
			}
			smooth_triangle {
				<-0.178749, 0.934300, 0.290247>, <1.629686, 4.695388, 0.540623>,
				<-0.197465, 0.932730, 0.283080>, <2.015567, 5.624297, 0.544898>,
				<-0.181380, 0.940820, 0.266607>, <0.963623, 2.827200, 0.278977>
			}
			smooth_triangle {
				<-0.197465, 0.932730, 0.283080>, <2.015567, 5.624297, 0.544898>,
				<-0.202059, 0.938210, 0.260866>, <0.659359, 1.881267, 0.160979>,
				<-0.181380, 0.940820, 0.266607>, <0.963623, 2.827200, 0.278977>
			}
			smooth_triangle {
				<-0.341679, 0.908639, 0.216178>, <2.415891, 5.481756, -0.324308>,
				<-0.336184, 0.903039, 0.246186>, <2.509485, 5.446562, -0.166469>,
				<-0.354948, 0.899879, 0.230966>, <1.692297, 3.619105, -0.184922>
			}
			smooth_triangle {
				<-0.332450, 0.856999, 0.379652>, <1.489614, 2.592269, 0.245165>,
				<-0.339576, 0.861439, 0.362930>, <1.462853, 2.612676, 0.182112>,
				<-0.320348, 0.867749, 0.365372>, <1.943828, 3.484893, 0.272801>
			}
			smooth_triangle {
				<-0.354948, 0.899879, 0.230966>, <1.692297, 3.619105, -0.184922>,
				<-0.336184, 0.903039, 0.246186>, <2.509485, 5.446562, -0.166469>,
				<-0.356509, 0.890389, 0.263097>, <3.114004, 6.265079, -0.188976>
			}
			smooth_triangle {
				<-0.336184, 0.903039, 0.246186>, <2.509485, 5.446562, -0.166469>,
				<-0.329362, 0.896809, 0.276361>, <2.597805, 5.407479, -0.006679>,
				<-0.356509, 0.890389, 0.263097>, <3.114004, 6.265079, -0.188976>
			}
			smooth_triangle {
				<-0.310061, 0.876399, 0.353424>, <2.325509, 4.411385, 0.352129>,
				<-0.338728, 0.871429, 0.339112>, <3.815492, 7.022180, 0.328211>,
				<-0.314014, 0.886559, 0.323309>, <3.165871, 6.233540, 0.323629>
			}
			smooth_triangle {
				<-0.338728, 0.871429, 0.339112>, <3.815492, 7.022180, 0.328211>,
				<-0.343500, 0.883499, 0.300926>, <3.221014, 6.212947, 0.066641>,
				<-0.314014, 0.886559, 0.323309>, <3.165871, 6.233540, 0.323629>
			}
			smooth_triangle {
				<-0.314014, 0.886559, 0.323309>, <3.165871, 6.233540, 0.323629>,
				<-0.343500, 0.883499, 0.300926>, <3.221014, 6.212947, 0.066641>,
				<-0.319933, 0.892879, 0.299204>, <2.207368, 4.484346, 0.113492>
			}
			smooth_triangle {
				<-0.329362, 0.896809, 0.276361>, <2.597805, 5.407479, -0.006679>,
				<-0.343500, 0.883499, 0.300926>, <3.221014, 6.212947, 0.066641>,
				<-0.356509, 0.890389, 0.263097>, <3.114004, 6.265079, -0.188976>
			}
			smooth_triangle {
				<-0.329362, 0.896809, 0.276361>, <2.597805, 5.407479, -0.006679>,
				<-0.319933, 0.892879, 0.299204>, <2.207368, 4.484346, 0.113492>,
				<-0.343500, 0.883499, 0.300926>, <3.221014, 6.212947, 0.066641>
			}
			smooth_triangle {
				<-0.310061, 0.876399, 0.353424>, <2.325509, 4.411385, 0.352129>,
				<-0.320348, 0.867749, 0.365372>, <1.943828, 3.484893, 0.272801>,
				<-0.338728, 0.871429, 0.339112>, <3.815492, 7.022180, 0.328211>
			}
			smooth_triangle {
				<-0.338728, 0.871429, 0.339112>, <3.815492, 7.022180, 0.328211>,
				<-0.320348, 0.867749, 0.365372>, <1.943828, 3.484893, 0.272801>,
				<-0.339576, 0.861439, 0.362930>, <1.462853, 2.612676, 0.182112>
			}
			smooth_triangle {
				<-0.356509, 0.890389, 0.263097>, <3.114004, 6.265079, -0.188976>,
				<-0.343500, 0.883499, 0.300926>, <3.221014, 6.212947, 0.066641>,
				<-0.373908, 0.876049, 0.286078>, <1.390285, 2.657643, -0.044721>
			}
			smooth_triangle {
				<-0.373908, 0.876049, 0.286078>, <1.390285, 2.657643, -0.044721>,
				<-0.343500, 0.883499, 0.300926>, <3.221014, 6.212947, 0.066641>,
				<-0.370546, 0.866899, 0.316688>, <1.419449, 2.642509, 0.036672>
			}
			smooth_triangle {
				<-0.338728, 0.871429, 0.339112>, <3.815492, 7.022180, 0.328211>,
				<-0.370546, 0.866899, 0.316688>, <1.419449, 2.642509, 0.036672>,
				<-0.343500, 0.883499, 0.300926>, <3.221014, 6.212947, 0.066641>
			}
			smooth_triangle {
				<-0.338728, 0.871429, 0.339112>, <3.815492, 7.022180, 0.328211>,
				<-0.360989, 0.865079, 0.332324>, <0.961010, 1.752847, 0.054571>,
				<-0.370546, 0.866899, 0.316688>, <1.419449, 2.642509, 0.036672>
			}
			smooth_triangle {
				<-0.339576, 0.861439, 0.362930>, <1.462853, 2.612676, 0.182112>,
				<-0.349145, 0.860729, 0.355477>, <0.979218, 1.741543, 0.088861>,
				<-0.338728, 0.871429, 0.339112>, <3.815492, 7.022180, 0.328211>
			}
			smooth_triangle {
				<-0.338728, 0.871429, 0.339112>, <3.815492, 7.022180, 0.328211>,
				<-0.349145, 0.860729, 0.355477>, <0.979218, 1.741543, 0.088861>,
				<-0.360989, 0.865079, 0.332324>, <0.961010, 1.752847, 0.054571>
			}
			smooth_triangle {
				<-0.373908, 0.876049, 0.286078>, <1.390285, 2.657643, -0.044721>,
				<-0.381552, 0.882169, 0.255562>, <0.909191, 1.779842, -0.072814>,
				<-0.356509, 0.890389, 0.263097>, <3.114004, 6.265079, -0.188976>
			}
			smooth_triangle {
				<-0.381552, 0.882169, 0.255562>, <0.909191, 1.779842, -0.072814>,
				<-0.374972, 0.888339, 0.243631>, <0.885201, 1.791445, -0.083254>,
				<-0.356509, 0.890389, 0.263097>, <3.114004, 6.265079, -0.188976>
			}
			smooth_triangle {
				<-0.374972, 0.888339, 0.243631>, <0.885201, 1.791445, -0.083254>,
				<-0.354948, 0.899879, 0.230966>, <1.692297, 3.619105, -0.184922>,
				<-0.356509, 0.890389, 0.263097>, <3.114004, 6.265079, -0.188976>
			}
			smooth_triangle {
				<-0.285746, 0.875920, 0.374467>, <1.834985, 3.532292, 0.390177>,
				<-0.266746, 0.884180, 0.369046>, <2.661304, 5.334703, 0.669517>,
				<-0.270507, 0.870960, 0.396704>, <1.831883, 3.514862, 0.535429>
			}
			smooth_triangle {
				<-0.053852, 0.940540, 0.318727>, <0.749748, 2.832364, 0.643530>,
				<-0.065123, 0.935820, 0.330326>, <1.588245, 5.641300, 1.281741>,
				<-0.076261, 0.943330, 0.305665>, <0.789256, 2.836591, 0.574129>
			}
			smooth_triangle {
				<-0.076261, 0.943330, 0.305665>, <0.789256, 2.836591, 0.574129>,
				<-0.065123, 0.935820, 0.330326>, <1.588245, 5.641300, 1.281741>,
				<-0.091314, 0.938280, 0.316848>, <1.662090, 5.656753, 1.108399>
			}
			smooth_triangle {
				<-0.065123, 0.935820, 0.330326>, <1.588245, 5.641300, 1.281741>,
				<-0.081719, 0.928560, 0.346719>, <1.723848, 5.600490, 1.284268>,
				<-0.091314, 0.938280, 0.316848>, <1.662090, 5.656753, 1.108399>
			}
			smooth_triangle {
				<-0.091314, 0.938280, 0.316848>, <1.662090, 5.656753, 1.108399>,
				<-0.081719, 0.928560, 0.346719>, <1.723848, 5.600490, 1.284268>,
				<-0.115429, 0.931180, 0.329694>, <2.110557, 6.553236, 1.257496>
			}
			smooth_triangle {
				<-0.161563, 0.921960, 0.336149>, <2.057711, 5.558464, 0.926030>,
				<-0.156029, 0.910750, 0.367822>, <2.147522, 5.493284, 1.094504>,
				<-0.185855, 0.912900, 0.348099>, <2.210029, 5.505686, 0.888150>
			}
			smooth_triangle {
				<-0.149887, 0.898820, 0.398462>, <1.870966, 4.513364, 1.056177>,
				<-0.170836, 0.881910, 0.426811>, <2.862424, 6.193275, 1.548947>,
				<-0.182307, 0.899410, 0.383332>, <2.339039, 5.419775, 1.065610>
			}
			smooth_triangle {
				<-0.215260, 0.870350, 0.430434>, <2.212161, 4.376045, 0.969995>,
				<-0.247174, 0.868730, 0.416328>, <3.208230, 6.116366, 1.131994>,
				<-0.217222, 0.885890, 0.396390>, <2.955935, 6.235394, 1.164052>
			}
			smooth_triangle {
				<-0.213336, 0.902380, 0.359593>, <2.380939, 5.441720, 0.838636>,
				<-0.217222, 0.885890, 0.396390>, <2.955935, 6.235394, 1.164052>,
				<-0.241723, 0.892850, 0.365372>, <2.527004, 5.388006, 0.755591>
			}
			smooth_triangle {
				<-0.247174, 0.868730, 0.416328>, <3.208230, 6.116366, 1.131994>,
				<-0.270507, 0.870960, 0.396704>, <1.831883, 3.514862, 0.535429>,
				<-0.248754, 0.880850, 0.389025>, <2.210666, 4.428868, 0.700006>
			}
			smooth_triangle {
				<-0.270507, 0.870960, 0.396704>, <1.831883, 3.514862, 0.535429>,
				<-0.266746, 0.884180, 0.369046>, <2.661304, 5.334703, 0.669517>,
				<-0.248754, 0.880850, 0.389025>, <2.210666, 4.428868, 0.700006>
			}
			smooth_triangle {
				<-0.266746, 0.884180, 0.369046>, <2.661304, 5.334703, 0.669517>,
				<-0.241723, 0.892850, 0.365372>, <2.527004, 5.388006, 0.755591>,
				<-0.248754, 0.880850, 0.389025>, <2.210666, 4.428868, 0.700006>
			}
			smooth_triangle {
				<-0.247174, 0.868730, 0.416328>, <3.208230, 6.116366, 1.131994>,
				<-0.248754, 0.880850, 0.389025>, <2.210666, 4.428868, 0.700006>,
				<-0.217222, 0.885890, 0.396390>, <2.955935, 6.235394, 1.164052>
			}
			smooth_triangle {
				<-0.248754, 0.880850, 0.389025>, <2.210666, 4.428868, 0.700006>,
				<-0.241723, 0.892850, 0.365372>, <2.527004, 5.388006, 0.755591>,
				<-0.217222, 0.885890, 0.396390>, <2.955935, 6.235394, 1.164052>
			}
			smooth_triangle {
				<-0.215260, 0.870350, 0.430434>, <2.212161, 4.376045, 0.969995>,
				<-0.217222, 0.885890, 0.396390>, <2.955935, 6.235394, 1.164052>,
				<-0.170836, 0.881910, 0.426811>, <2.862424, 6.193275, 1.548947>
			}
			smooth_triangle {
				<-0.213336, 0.902380, 0.359593>, <2.380939, 5.441720, 0.838636>,
				<-0.182307, 0.899410, 0.383332>, <2.339039, 5.419775, 1.065610>,
				<-0.217222, 0.885890, 0.396390>, <2.955935, 6.235394, 1.164052>
			}
			smooth_triangle {
				<-0.217222, 0.885890, 0.396390>, <2.955935, 6.235394, 1.164052>,
				<-0.182307, 0.899410, 0.383332>, <2.339039, 5.419775, 1.065610>,
				<-0.170836, 0.881910, 0.426811>, <2.862424, 6.193275, 1.548947>
			}
			smooth_triangle {
				<-0.149887, 0.898820, 0.398462>, <1.870966, 4.513364, 1.056177>,
				<-0.182307, 0.899410, 0.383332>, <2.339039, 5.419775, 1.065610>,
				<-0.156029, 0.910750, 0.367822>, <2.147522, 5.493284, 1.094504>
			}
			smooth_triangle {
				<-0.213336, 0.902380, 0.359593>, <2.380939, 5.441720, 0.838636>,
				<-0.185855, 0.912900, 0.348099>, <2.210029, 5.505686, 0.888150>,
				<-0.182307, 0.899410, 0.383332>, <2.339039, 5.419775, 1.065610>
			}
			smooth_triangle {
				<-0.182307, 0.899410, 0.383332>, <2.339039, 5.419775, 1.065610>,
				<-0.185855, 0.912900, 0.348099>, <2.210029, 5.505686, 0.888150>,
				<-0.156029, 0.910750, 0.367822>, <2.147522, 5.493284, 1.094504>
			}
			smooth_triangle {
				<-0.149887, 0.898820, 0.398462>, <1.870966, 4.513364, 1.056177>,
				<-0.156029, 0.910750, 0.367822>, <2.147522, 5.493284, 1.094504>,
				<-0.122729, 0.908140, 0.386443>, <2.063260, 5.476349, 1.316643>
			}
			smooth_triangle {
				<-0.122729, 0.908140, 0.386443>, <2.063260, 5.476349, 1.316643>,
				<-0.133268, 0.920430, 0.352352>, <1.983122, 5.550472, 1.116433>,
				<-0.100589, 0.919170, 0.366234>, <1.891605, 5.541292, 1.303367>
			}
			smooth_triangle {
				<-0.100589, 0.919170, 0.366234>, <1.891605, 5.541292, 1.303367>,
				<-0.115429, 0.931180, 0.329694>, <2.110557, 6.553236, 1.257496>,
				<-0.081719, 0.928560, 0.346719>, <1.723848, 5.600490, 1.284268>
			}
			smooth_triangle {
				<-0.100589, 0.919170, 0.366234>, <1.891605, 5.541292, 1.303367>,
				<-0.133268, 0.920430, 0.352352>, <1.983122, 5.550472, 1.116433>,
				<-0.115429, 0.931180, 0.329694>, <2.110557, 6.553236, 1.257496>
			}
			smooth_triangle {
				<-0.133268, 0.920430, 0.352352>, <1.983122, 5.550472, 1.116433>,
				<-0.142930, 0.928690, 0.325918>, <1.600926, 4.668733, 0.795525>,
				<-0.115429, 0.931180, 0.329694>, <2.110557, 6.553236, 1.257496>
			}
			smooth_triangle {
				<-0.142930, 0.928690, 0.325918>, <1.600926, 4.668733, 0.795525>,
				<-0.133268, 0.920430, 0.352352>, <1.983122, 5.550472, 1.116433>,
				<-0.161563, 0.921960, 0.336149>, <2.057711, 5.558464, 0.926030>
			}
			smooth_triangle {
				<-0.122729, 0.908140, 0.386443>, <2.063260, 5.476349, 1.316643>,
				<-0.156029, 0.910750, 0.367822>, <2.147522, 5.493284, 1.094504>,
				<-0.133268, 0.920430, 0.352352>, <1.983122, 5.550472, 1.116433>
			}
			smooth_triangle {
				<-0.133268, 0.920430, 0.352352>, <1.983122, 5.550472, 1.116433>,
				<-0.156029, 0.910750, 0.367822>, <2.147522, 5.493284, 1.094504>,
				<-0.161563, 0.921960, 0.336149>, <2.057711, 5.558464, 0.926030>
			}
			smooth_triangle {
				<-0.215260, 0.870350, 0.430434>, <2.212161, 4.376045, 0.969995>,
				<-0.242531, 0.857180, 0.442195>, <1.390113, 2.599359, 0.554970>,
				<-0.247174, 0.868730, 0.416328>, <3.208230, 6.116366, 1.131994>
			}
			smooth_triangle {
				<-0.270507, 0.870960, 0.396704>, <1.831883, 3.514862, 0.535429>,
				<-0.247174, 0.868730, 0.416328>, <3.208230, 6.116366, 1.131994>,
				<-0.270329, 0.859070, 0.421932>, <0.940049, 1.737972, 0.308958>
			}
			smooth_triangle {
				<-0.247174, 0.868730, 0.416328>, <3.208230, 6.116366, 1.131994>,
				<-0.265153, 0.854000, 0.435304>, <0.944326, 1.731765, 0.330460>,
				<-0.270329, 0.859070, 0.421932>, <0.940049, 1.737972, 0.308958>
			}
			smooth_triangle {
				<-0.247174, 0.868730, 0.416328>, <3.208230, 6.116366, 1.131994>,
				<-0.242531, 0.857180, 0.442195>, <1.390113, 2.599359, 0.554970>,
				<-0.265153, 0.854000, 0.435304>, <0.944326, 1.731765, 0.330460>
			}
			smooth_triangle {
				<-0.342590, 0.788079, 0.500674>, <1.764401, 2.380131, 0.469779>,
				<-0.356033, 0.772399, 0.515504>, <0.598553, 0.784826, 0.160565>,
				<-0.362392, 0.783119, 0.494484>, <1.775862, 2.374797, 0.453580>
			}
			smooth_triangle {
				<-0.343132, 0.832109, 0.423052>, <3.756316, 5.859827, 0.736595>,
				<-0.328047, 0.824959, 0.448264>, <3.252651, 4.977072, 0.800300>,
				<-0.348872, 0.818849, 0.443716>, <3.329379, 4.941341, 0.701348>
			}
			smooth_triangle {
				<-0.348872, 0.818849, 0.443716>, <3.329379, 4.941341, 0.701348>,
				<-0.337374, 0.811609, 0.465385>, <3.361340, 4.897063, 0.844179>,
				<-0.358595, 0.806619, 0.458141>, <2.275971, 3.249887, 0.505869>
			}
			smooth_triangle {
				<-0.364434, 0.794399, 0.474580>, <1.166399, 1.601209, 0.274378>,
				<-0.358595, 0.806619, 0.458141>, <2.275971, 3.249887, 0.505869>,
				<-0.348788, 0.797969, 0.480314>, <3.472087, 4.814883, 0.868907>
			}
			smooth_triangle {
				<-0.358595, 0.806619, 0.458141>, <2.275971, 3.249887, 0.505869>,
				<-0.337374, 0.811609, 0.465385>, <3.361340, 4.897063, 0.844179>,
				<-0.348788, 0.797969, 0.480314>, <3.472087, 4.814883, 0.868907>
			}
			smooth_triangle {
				<-0.337374, 0.811609, 0.465385>, <3.361340, 4.897063, 0.844179>,
				<-0.326945, 0.802789, 0.487598>, <1.703961, 2.424981, 0.463635>,
				<-0.348788, 0.797969, 0.480314>, <3.472087, 4.814883, 0.868907>
			}
			smooth_triangle {
				<-0.364434, 0.794399, 0.474580>, <1.166399, 1.601209, 0.274378>,
				<-0.348788, 0.797969, 0.480314>, <3.472087, 4.814883, 0.868907>,
				<-0.362392, 0.783119, 0.494484>, <1.775862, 2.374797, 0.453580>
			}
			smooth_triangle {
				<-0.326945, 0.802789, 0.487598>, <1.703961, 2.424981, 0.463635>,
				<-0.342590, 0.788079, 0.500674>, <1.764401, 2.380131, 0.469779>,
				<-0.348788, 0.797969, 0.480314>, <3.472087, 4.814883, 0.868907>
			}
			smooth_triangle {
				<-0.348788, 0.797969, 0.480314>, <3.472087, 4.814883, 0.868907>,
				<-0.342590, 0.788079, 0.500674>, <1.764401, 2.380131, 0.469779>,
				<-0.362392, 0.783119, 0.494484>, <1.775862, 2.374797, 0.453580>
			}
			smooth_triangle {
				<-0.326945, 0.802789, 0.487598>, <1.703961, 2.424981, 0.463635>,
				<-0.337374, 0.811609, 0.465385>, <3.361340, 4.897063, 0.844179>,
				<-0.312365, 0.817159, 0.473066>, <1.646991, 2.466439, 0.450904>
			}
			smooth_triangle {
				<-0.348872, 0.818849, 0.443716>, <3.329379, 4.941341, 0.701348>,
				<-0.328047, 0.824959, 0.448264>, <3.252651, 4.977072, 0.800300>,
				<-0.337374, 0.811609, 0.465385>, <3.361340, 4.897063, 0.844179>
			}
			smooth_triangle {
				<-0.337374, 0.811609, 0.465385>, <3.361340, 4.897063, 0.844179>,
				<-0.328047, 0.824959, 0.448264>, <3.252651, 4.977072, 0.800300>,
				<-0.312365, 0.817159, 0.473066>, <1.646991, 2.466439, 0.450904>
			}
			smooth_triangle {
				<-0.312365, 0.817159, 0.473066>, <1.646991, 2.466439, 0.450904>,
				<-0.328047, 0.824959, 0.448264>, <3.252651, 4.977072, 0.800300>,
				<-0.304345, 0.830929, 0.453922>, <1.597949, 2.503274, 0.423543>
			}
			smooth_triangle {
				<-0.313665, 0.848409, 0.413442>, <1.543289, 2.550493, 0.334188>,
				<-0.303334, 0.841439, 0.434824>, <1.042205, 1.686333, 0.263993>,
				<-0.321520, 0.837589, 0.429159>, <3.154087, 5.050213, 0.733766>
			}
			smooth_triangle {
				<-0.328047, 0.824959, 0.448264>, <3.252651, 4.977072, 0.800300>,
				<-0.321520, 0.837589, 0.429159>, <3.154087, 5.050213, 0.733766>,
				<-0.304345, 0.830929, 0.453922>, <1.597949, 2.503274, 0.423543>
			}
			smooth_triangle {
				<-0.303334, 0.841439, 0.434824>, <1.042205, 1.686333, 0.263993>,
				<-0.304345, 0.830929, 0.453922>, <1.597949, 2.503274, 0.423543>,
				<-0.321520, 0.837589, 0.429159>, <3.154087, 5.050213, 0.733766>
			}
			smooth_triangle {
				<-0.328047, 0.824959, 0.448264>, <3.252651, 4.977072, 0.800300>,
				<-0.343132, 0.832109, 0.423052>, <3.756316, 5.859827, 0.736595>,
				<-0.321520, 0.837589, 0.429159>, <3.154087, 5.050213, 0.733766>
			}
			smooth_triangle {
				<-0.335837, 0.846229, 0.400273>, <2.586020, 4.249550, 0.499876>,
				<-0.321520, 0.837589, 0.429159>, <3.154087, 5.050213, 0.733766>,
				<-0.343132, 0.832109, 0.423052>, <3.756316, 5.859827, 0.736595>
			}
			smooth_triangle {
				<-0.335837, 0.846229, 0.400273>, <2.586020, 4.249550, 0.499876>,
				<-0.313665, 0.848409, 0.413442>, <1.543289, 2.550493, 0.334188>,
				<-0.321520, 0.837589, 0.429159>, <3.154087, 5.050213, 0.733766>
			}
			smooth_triangle {
				<-0.320348, 0.867749, 0.365372>, <1.943828, 3.484893, 0.272801>,
				<-0.315288, 0.858929, 0.389806>, <1.503713, 2.581145, 0.274578>,
				<-0.332450, 0.856999, 0.379652>, <1.489614, 2.592269, 0.245165>
			}
			smooth_triangle {
				<-0.313665, 0.848409, 0.413442>, <1.543289, 2.550493, 0.334188>,
				<-0.335837, 0.846229, 0.400273>, <2.586020, 4.249550, 0.499876>,
				<-0.315288, 0.858929, 0.389806>, <1.503713, 2.581145, 0.274578>
			}
			smooth_triangle {
				<-0.335837, 0.846229, 0.400273>, <2.586020, 4.249550, 0.499876>,
				<-0.332450, 0.856999, 0.379652>, <1.489614, 2.592269, 0.245165>,
				<-0.315288, 0.858929, 0.389806>, <1.503713, 2.581145, 0.274578>
			}
			smooth_triangle {
				<-0.335837, 0.846229, 0.400273>, <2.586020, 4.249550, 0.499876>,
				<-0.343132, 0.832109, 0.423052>, <3.756316, 5.859827, 0.736595>,
				<-0.350247, 0.840369, 0.400276>, <1.063498, 1.683358, 0.187604>
			}
			smooth_triangle {
				<-0.348872, 0.818849, 0.443716>, <3.329379, 4.941341, 0.701348>,
				<-0.355889, 0.824669, 0.427046>, <1.648131, 2.487323, 0.309570>,
				<-0.343132, 0.832109, 0.423052>, <3.756316, 5.859827, 0.736595>
			}
			smooth_triangle {
				<-0.355889, 0.824669, 0.427046>, <1.648131, 2.487323, 0.309570>,
				<-0.360961, 0.830109, 0.411995>, <1.077820, 1.674379, 0.186203>,
				<-0.343132, 0.832109, 0.423052>, <3.756316, 5.859827, 0.736595>
			}
			smooth_triangle {
				<-0.360961, 0.830109, 0.411995>, <1.077820, 1.674379, 0.186203>,
				<-0.350247, 0.840369, 0.400276>, <1.063498, 1.683358, 0.187604>,
				<-0.343132, 0.832109, 0.423052>, <3.756316, 5.859827, 0.736595>
			}
			smooth_triangle {
				<-0.358595, 0.806619, 0.458141>, <2.275971, 3.249887, 0.505869>,
				<-0.369629, 0.812279, 0.438955>, <1.124602, 1.639682, 0.215841>,
				<-0.348872, 0.818849, 0.443716>, <3.329379, 4.941341, 0.701348>
			}
			smooth_triangle {
				<-0.348872, 0.818849, 0.443716>, <3.329379, 4.941341, 0.701348>,
				<-0.369629, 0.812279, 0.438955>, <1.124602, 1.639682, 0.215841>,
				<-0.355889, 0.824669, 0.427046>, <1.648131, 2.487323, 0.309570>
			}
			smooth_triangle {
				<-0.336779, 0.919509, 0.173791>, <1.136821, 2.766126, -0.234406>,
				<-0.348518, 0.912309, 0.187975>, <2.338334, 5.503792, -0.482403>,
				<-0.354846, 0.915419, 0.158731>, <1.155567, 2.752019, -0.300563>
			}
			smooth_triangle {
				<-0.354846, 0.915419, 0.158731>, <1.155567, 2.752019, -0.300563>,
				<-0.348518, 0.912309, 0.187975>, <2.338334, 5.503792, -0.482403>,
				<-0.367443, 0.907009, 0.177291>, <2.381555, 5.473143, -0.605011>
			}
			smooth_triangle {
				<-0.348518, 0.912309, 0.187975>, <2.338334, 5.503792, -0.482403>,
				<-0.361820, 0.904439, 0.200482>, <1.618777, 3.643893, -0.313799>,
				<-0.367443, 0.907009, 0.177291>, <2.381555, 5.473143, -0.605011>
			}
			smooth_triangle {
				<-0.361820, 0.904439, 0.200482>, <1.618777, 3.643893, -0.313799>,
				<-0.381441, 0.898229, 0.191817>, <0.815427, 1.815776, -0.194809>,
				<-0.367443, 0.907009, 0.177291>, <2.381555, 5.473143, -0.605011>
			}
			smooth_triangle {
				<-0.354846, 0.915419, 0.158731>, <1.155567, 2.752019, -0.300563>,
				<-0.367443, 0.907009, 0.177291>, <2.381555, 5.473143, -0.605011>,
				<-0.374296, 0.909159, 0.149818>, <0.782410, 1.826514, -0.227219>
			}
			smooth_triangle {
				<-0.381441, 0.898229, 0.191817>, <0.815427, 1.815776, -0.194809>,
				<-0.383336, 0.901029, 0.174126>, <0.802099, 1.819092, -0.217160>,
				<-0.367443, 0.907009, 0.177291>, <2.381555, 5.473143, -0.605011>
			}
			smooth_triangle {
				<-0.367443, 0.907009, 0.177291>, <2.381555, 5.473143, -0.605011>,
				<-0.383336, 0.901029, 0.174126>, <0.802099, 1.819092, -0.217160>,
				<-0.374296, 0.909159, 0.149818>, <0.782410, 1.826514, -0.227219>
			}
			smooth_triangle {
				<-0.317183, 0.924879, 0.181929>, <1.110059, 2.781864, -0.167551>,
				<-0.327834, 0.917299, 0.200474>, <2.290797, 5.534149, -0.341720>,
				<-0.336779, 0.919509, 0.173791>, <1.136821, 2.766126, -0.234406>
			}
			smooth_triangle {
				<-0.354948, 0.899879, 0.230966>, <1.692297, 3.619105, -0.184922>,
				<-0.361820, 0.904439, 0.200482>, <1.618777, 3.643893, -0.313799>,
				<-0.341679, 0.908639, 0.216178>, <2.415891, 5.481756, -0.324308>
			}
			smooth_triangle {
				<-0.361820, 0.904439, 0.200482>, <1.618777, 3.643893, -0.313799>,
				<-0.348518, 0.912309, 0.187975>, <2.338334, 5.503792, -0.482403>,
				<-0.341679, 0.908639, 0.216178>, <2.415891, 5.481756, -0.324308>
			}
			smooth_triangle {
				<-0.336779, 0.919509, 0.173791>, <1.136821, 2.766126, -0.234406>,
				<-0.327834, 0.917299, 0.200474>, <2.290797, 5.534149, -0.341720>,
				<-0.348518, 0.912309, 0.187975>, <2.338334, 5.503792, -0.482403>
			}
			smooth_triangle {
				<-0.327834, 0.917299, 0.200474>, <2.290797, 5.534149, -0.341720>,
				<-0.341679, 0.908639, 0.216178>, <2.415891, 5.481756, -0.324308>,
				<-0.348518, 0.912309, 0.187975>, <2.338334, 5.503792, -0.482403>
			}
			smooth_triangle {
				<0.278961, 0.861492, 0.411243>, <0.130643, 3.527350, 1.867146>,
				<0.304812, 0.905772, 0.275262>, <-0.414468, 7.225702, 3.384852>,
				<0.376798, 0.850442, 0.351966>, <-0.194090, 2.631358, 1.421421>
			}
			smooth_triangle {
				<0.513481, 0.814972, 0.247522>, <-0.477332, 1.691012, 0.951767>,
				<0.505185, 0.841532, 0.160363>, <-2.234488, 6.735393, 3.665938>,
				<0.560921, 0.795592, 0.203746>, <-0.604250, 1.643690, 0.963833>
			}
			smooth_triangle {
				<0.560921, 0.795592, 0.203746>, <-0.604250, 1.643690, 0.963833>,
				<0.505185, 0.841532, 0.160363>, <-2.234488, 6.735393, 3.665938>,
				<0.599047, 0.776563, 0.164940>, <-1.422185, 3.222108, 1.892064>
			}
			smooth_triangle {
				<0.599047, 0.776563, 0.164940>, <-1.422185, 3.222108, 1.892064>,
				<0.596609, 0.793703, 0.056587>, <-3.907951, 7.076840, 3.925373>,
				<0.630272, 0.758213, 0.130293>, <-0.806451, 1.571417, 0.937015>
			}
			smooth_triangle {
				<0.630272, 0.758213, 0.130293>, <-0.806451, 1.571417, 0.937015>,
				<0.596609, 0.793703, 0.056587>, <-3.907951, 7.076840, 3.925373>,
				<0.656325, 0.740633, 0.099020>, <-0.886641, 1.537873, 0.920280>
			}
			smooth_triangle {
				<0.656325, 0.740633, 0.099020>, <-0.886641, 1.537873, 0.920280>,
				<0.596609, 0.793703, 0.056587>, <-3.907951, 7.076840, 3.925373>,
				<0.678465, 0.723763, 0.070456>, <-0.958852, 1.523817, 0.869686>
			}
			smooth_triangle {
				<0.678465, 0.723763, 0.070456>, <-0.958852, 1.523817, 0.869686>,
				<0.596609, 0.793703, 0.056587>, <-3.907951, 7.076840, 3.925373>,
				<0.697600, 0.707473, 0.044022>, <-2.560280, 3.726686, 2.130506>
			}
			smooth_triangle {
				<0.697600, 0.707473, 0.044022>, <-2.560280, 3.726686, 2.130506>,
				<0.714111, 0.689563, -0.060416>, <-5.233683, 6.260978, 3.772792>,
				<0.714420, 0.691623, 0.019216>, <-1.078824, 1.453475, 0.849216>
			}
			smooth_triangle {
				<0.714420, 0.691623, 0.019216>, <-1.078824, 1.453475, 0.849216>,
				<0.714111, 0.689563, -0.060416>, <-5.233683, 6.260978, 3.772792>,
				<0.729418, 0.676053, -0.004386>, <-1.131086, 1.395787, 0.878153>
			}
			smooth_triangle {
				<0.729418, 0.676053, -0.004386>, <-1.131086, 1.395787, 0.878153>,
				<0.714111, 0.689563, -0.060416>, <-5.233683, 6.260978, 3.772792>,
				<0.742970, 0.660583, -0.027128>, <-1.180995, 1.356870, 0.873638>
			}
			smooth_triangle {
				<0.742970, 0.660583, -0.027128>, <-1.180995, 1.356870, 0.873638>,
				<0.714111, 0.689563, -0.060416>, <-5.233683, 6.260978, 3.772792>,
				<0.755376, 0.645043, -0.049339>, <-1.228770, 1.335898, 0.839238>
			}
			smooth_triangle {
				<0.755376, 0.645043, -0.049339>, <-1.228770, 1.335898, 0.839238>,
				<0.714111, 0.689563, -0.060416>, <-5.233683, 6.260978, 3.772792>,
				<0.766854, 0.629253, -0.071332>, <-1.883553, 1.975231, 1.244429>
			}
			smooth_triangle {
				<-0.025187, -0.400690, 0.909907>, <3.647782, -2.417494, 4.103423>,
				<-0.053558, -0.389420, 0.913557>, <3.792790, -2.349377, 4.010124>,
				<-0.028219, -0.370770, 0.922411>, <3.709635, -2.232939, 4.152063>
			}
			smooth_triangle {
				<-0.210000, -0.483151, 0.843548>, <4.241985, -2.914518, 3.082632>,
				<-0.204392, -0.507851, 0.830318>, <4.165614, -3.062946, 3.042634>,
				<-0.227478, -0.496801, 0.830996>, <4.273849, -2.997182, 2.956681>
			}
			smooth_triangle {
				<-0.046875, -0.420670, 0.899974>, <3.709511, -2.535947, 3.974354>,
				<-0.053558, -0.389420, 0.913557>, <3.792790, -2.349377, 4.010124>,
				<-0.025187, -0.400690, 0.909907>, <3.647782, -2.417494, 4.103423>
			}
			smooth_triangle {
				<-0.046875, -0.420670, 0.899974>, <3.709511, -2.535947, 3.974354>,
				<-0.080327, -0.412270, 0.901491>, <4.510776, -2.896737, 4.499130>,
				<-0.053558, -0.389420, 0.913557>, <3.792790, -2.349377, 4.010124>
			}
			smooth_triangle {
				<-0.066002, -0.442430, 0.888257>, <3.748225, -2.666257, 3.851056>,
				<-0.080327, -0.412270, 0.901491>, <4.510776, -2.896737, 4.499130>,
				<-0.046875, -0.420670, 0.899974>, <3.709511, -2.535947, 3.974354>
			}
			smooth_triangle {
				<-0.109487, -0.453700, 0.878221>, <3.912904, -2.739811, 3.629210>,
				<-0.134476, -0.439280, 0.882075>, <4.038641, -2.650644, 3.556980>,
				<-0.110489, -0.424620, 0.892521>, <3.972280, -2.558470, 3.696387>
			}
			smooth_triangle {
				<-0.109487, -0.453700, 0.878221>, <3.912904, -2.739811, 3.629210>,
				<-0.134118, -0.470610, 0.865824>, <4.633388, -3.311639, 4.068074>,
				<-0.134476, -0.439280, 0.882075>, <4.038641, -2.650644, 3.556980>
			}
			smooth_triangle {
				<-0.103888, -0.484590, 0.862257>, <4.464092, -3.404665, 4.179106>,
				<-0.134118, -0.470610, 0.865824>, <4.633388, -3.311639, 4.068074>,
				<-0.109487, -0.453700, 0.878221>, <3.912904, -2.739811, 3.629210>
			}
			smooth_triangle {
				<-0.103888, -0.484590, 0.862257>, <4.464092, -3.404665, 4.179106>,
				<-0.127341, -0.500100, 0.850176>, <3.892601, -3.010523, 3.431336>,
				<-0.134118, -0.470610, 0.865824>, <4.633388, -3.311639, 4.068074>
			}
			smooth_triangle {
				<-0.103888, -0.484590, 0.862257>, <4.464092, -3.404665, 4.179106>,
				<-0.108816, -0.507430, 0.848404>, <3.161696, -2.546538, 2.917881>,
				<-0.127341, -0.500100, 0.850176>, <3.892601, -3.010523, 3.431336>
			}
			smooth_triangle {
				<-0.109487, -0.453700, 0.878221>, <3.912904, -2.739811, 3.629210>,
				<-0.083548, -0.463090, 0.876167>, <3.783403, -2.795842, 3.722743>,
				<-0.103888, -0.484590, 0.862257>, <4.464092, -3.404665, 4.179106>
			}
			smooth_triangle {
				<-0.090022, -0.439320, 0.887696>, <3.215009, -2.205862, 3.128988>,
				<-0.109487, -0.453700, 0.878221>, <3.912904, -2.739811, 3.629210>,
				<-0.110489, -0.424620, 0.892521>, <3.972280, -2.558470, 3.696387>
			}
			smooth_triangle {
				<-0.066002, -0.442430, 0.888257>, <3.748225, -2.666257, 3.851056>,
				<-0.083548, -0.463090, 0.876167>, <3.783403, -2.795842, 3.722743>,
				<-0.090022, -0.439320, 0.887696>, <3.215009, -2.205862, 3.128988>
			}
			smooth_triangle {
				<-0.083548, -0.463090, 0.876167>, <3.783403, -2.795842, 3.722743>,
				<-0.109487, -0.453700, 0.878221>, <3.912904, -2.739811, 3.629210>,
				<-0.090022, -0.439320, 0.887696>, <3.215009, -2.205862, 3.128988>
			}
			smooth_triangle {
				<-0.090022, -0.439320, 0.887696>, <3.215009, -2.205862, 3.128988>,
				<-0.080327, -0.412270, 0.901491>, <4.510776, -2.896737, 4.499130>,
				<-0.066002, -0.442430, 0.888257>, <3.748225, -2.666257, 3.851056>
			}
			smooth_triangle {
				<-0.080327, -0.412270, 0.901491>, <4.510776, -2.896737, 4.499130>,
				<-0.090022, -0.439320, 0.887696>, <3.215009, -2.205862, 3.128988>,
				<-0.110489, -0.424620, 0.892521>, <3.972280, -2.558470, 3.696387>
			}
			smooth_triangle {
				<-0.150187, -0.492651, 0.850797>, <3.986409, -2.976346, 3.352609>,
				<-0.134118, -0.470610, 0.865824>, <4.633388, -3.311639, 4.068074>,
				<-0.127341, -0.500100, 0.850176>, <3.892601, -3.010523, 3.431336>
			}
			smooth_triangle {
				<-0.134118, -0.470610, 0.865824>, <4.633388, -3.311639, 4.068074>,
				<-0.155716, -0.451320, 0.872459>, <4.097440, -2.720792, 3.435096>,
				<-0.134476, -0.439280, 0.882075>, <4.038641, -2.650644, 3.556980>
			}
			smooth_triangle {
				<-0.134118, -0.470610, 0.865824>, <4.633388, -3.311639, 4.068074>,
				<-0.157174, -0.471641, 0.861372>, <3.385149, -2.371937, 2.812444>,
				<-0.155716, -0.451320, 0.872459>, <4.097440, -2.720792, 3.435096>
			}
			smooth_triangle {
				<-0.150187, -0.492651, 0.850797>, <3.986409, -2.976346, 3.352609>,
				<-0.157174, -0.471641, 0.861372>, <3.385149, -2.371937, 2.812444>,
				<-0.134118, -0.470610, 0.865824>, <4.633388, -3.311639, 4.068074>
			}
			smooth_triangle {
				<-0.171493, -0.482831, 0.852396>, <4.098356, -2.914255, 3.271619>,
				<-0.157174, -0.471641, 0.861372>, <3.385149, -2.371937, 2.812444>,
				<-0.150187, -0.492651, 0.850797>, <3.986409, -2.976346, 3.352609>
			}
			smooth_triangle {
				<-0.157174, -0.471641, 0.861372>, <3.385149, -2.371937, 2.812444>,
				<-0.174140, -0.460481, 0.864147>, <4.157174, -2.778747, 3.315101>,
				<-0.155716, -0.451320, 0.872459>, <4.097440, -2.720792, 3.435096>
			}
			smooth_triangle {
				<-0.171493, -0.482831, 0.852396>, <4.098356, -2.914255, 3.271619>,
				<-0.174140, -0.460481, 0.864147>, <4.157174, -2.778747, 3.315101>,
				<-0.157174, -0.471641, 0.861372>, <3.385149, -2.371937, 2.812444>
			}
			smooth_triangle {
				<-0.122993, -0.520830, 0.838291>, <1.918965, -1.547325, 1.709457>,
				<-0.127341, -0.500100, 0.850176>, <3.892601, -3.010523, 3.431336>,
				<-0.108816, -0.507430, 0.848404>, <3.161696, -2.546538, 2.917881>
			}
			smooth_triangle {
				<-0.150187, -0.492651, 0.850797>, <3.986409, -2.976346, 3.352609>,
				<-0.167096, -0.506191, 0.839621>, <4.024378, -3.051770, 3.237742>,
				<-0.171493, -0.482831, 0.852396>, <4.098356, -2.914255, 3.271619>
			}
			smooth_triangle {
				<-0.127341, -0.500100, 0.850176>, <3.892601, -3.010523, 3.431336>,
				<-0.143434, -0.523811, 0.833160>, <2.623372, -2.055621, 2.211602>,
				<-0.150187, -0.492651, 0.850797>, <3.986409, -2.976346, 3.352609>
			}
			smooth_triangle {
				<-0.127341, -0.500100, 0.850176>, <3.892601, -3.010523, 3.431336>,
				<-0.122993, -0.520830, 0.838291>, <1.918965, -1.547325, 1.709457>,
				<-0.143434, -0.523811, 0.833160>, <2.623372, -2.055621, 2.211602>
			}
			smooth_triangle {
				<-0.143434, -0.523811, 0.833160>, <2.623372, -2.055621, 2.211602>,
				<-0.167096, -0.506191, 0.839621>, <4.024378, -3.051770, 3.237742>,
				<-0.150187, -0.492651, 0.850797>, <3.986409, -2.976346, 3.352609>
			}
			smooth_triangle {
				<-0.166125, -0.525381, 0.827945>, <2.000798, -1.566998, 1.593791>,
				<-0.167096, -0.506191, 0.839621>, <4.024378, -3.051770, 3.237742>,
				<-0.143434, -0.523811, 0.833160>, <2.623372, -2.055621, 2.211602>
			}
			smooth_triangle {
				<-0.183066, -0.517151, 0.829550>, <4.065797, -3.118181, 3.120856>,
				<-0.167096, -0.506191, 0.839621>, <4.024378, -3.051770, 3.237742>,
				<-0.166125, -0.525381, 0.827945>, <2.000798, -1.566998, 1.593791>
			}
			smooth_triangle {
				<-0.171493, -0.482831, 0.852396>, <4.098356, -2.914255, 3.271619>,
				<-0.191978, -0.470821, 0.854743>, <4.202908, -2.840500, 3.202994>,
				<-0.174140, -0.460481, 0.864147>, <4.157174, -2.778747, 3.315101>
			}
			smooth_triangle {
				<-0.171493, -0.482831, 0.852396>, <4.098356, -2.914255, 3.271619>,
				<-0.188066, -0.494751, 0.841996>, <4.135119, -2.983954, 3.160600>,
				<-0.191978, -0.470821, 0.854743>, <4.202908, -2.840500, 3.202994>
			}
			smooth_triangle {
				<-0.188066, -0.494751, 0.841996>, <4.135119, -2.983954, 3.160600>,
				<-0.167096, -0.506191, 0.839621>, <4.024378, -3.051770, 3.237742>,
				<-0.183066, -0.517151, 0.829550>, <4.065797, -3.118181, 3.120856>
			}
			smooth_triangle {
				<-0.188066, -0.494751, 0.841996>, <4.135119, -2.983954, 3.160600>,
				<-0.171493, -0.482831, 0.852396>, <4.098356, -2.914255, 3.271619>,
				<-0.167096, -0.506191, 0.839621>, <4.024378, -3.051770, 3.237742>
			}
			smooth_triangle {
				<-0.204392, -0.507851, 0.830318>, <4.165614, -3.062946, 3.042634>,
				<-0.188066, -0.494751, 0.841996>, <4.135119, -2.983954, 3.160600>,
				<-0.183066, -0.517151, 0.829550>, <4.065797, -3.118181, 3.120856>
			}
			smooth_triangle {
				<-0.188066, -0.494751, 0.841996>, <4.135119, -2.983954, 3.160600>,
				<-0.210000, -0.483151, 0.843548>, <4.241985, -2.914518, 3.082632>,
				<-0.191978, -0.470821, 0.854743>, <4.202908, -2.840500, 3.202994>
			}
			smooth_triangle {
				<-0.204392, -0.507851, 0.830318>, <4.165614, -3.062946, 3.042634>,
				<-0.210000, -0.483151, 0.843548>, <4.241985, -2.914518, 3.082632>,
				<-0.188066, -0.494751, 0.841996>, <4.135119, -2.983954, 3.160600>
			}
			smooth_triangle {
				<-0.100852, -0.523520, 0.839568>, <1.865127, -1.559038, 1.757766>,
				<-0.122993, -0.520830, 0.838291>, <1.918965, -1.547325, 1.709457>,
				<-0.108816, -0.507430, 0.848404>, <3.161696, -2.546538, 2.917881>
			}
			smooth_triangle {
				<-0.017971, -0.429090, 0.897037>, <3.560971, -2.589213, 4.074776>,
				<-0.046875, -0.420670, 0.899974>, <3.709511, -2.535947, 3.974354>,
				<-0.025187, -0.400690, 0.909907>, <3.647782, -2.417494, 4.103423>
			}
			smooth_triangle {
				<-0.083548, -0.463090, 0.876167>, <3.783403, -2.795842, 3.722743>,
				<-0.074544, -0.488690, 0.862986>, <3.692427, -2.946171, 3.698087>,
				<-0.103888, -0.484590, 0.862257>, <4.464092, -3.404665, 4.179106>
			}
			smooth_triangle {
				<-0.030295, -0.476710, 0.872316>, <3.521772, -2.874738, 3.914410>,
				<-0.010050, -0.457490, 0.883016>, <3.468666, -2.759878, 4.042222>,
				<-0.003463, -0.485890, 0.867764>, <3.377572, -2.929716, 3.999615>
			}
			smooth_triangle {
				<-0.066002, -0.442430, 0.888257>, <3.748225, -2.666257, 3.851056>,
				<-0.056922, -0.469280, 0.875012>, <3.655835, -2.829739, 3.823224>,
				<-0.083548, -0.463090, 0.876167>, <3.783403, -2.795842, 3.722743>
			}
			smooth_triangle {
				<-0.038029, -0.449400, 0.886403>, <3.612828, -2.710342, 3.948418>,
				<-0.056922, -0.469280, 0.875012>, <3.655835, -2.829739, 3.823224>,
				<-0.066002, -0.442430, 0.888257>, <3.748225, -2.666257, 3.851056>
			}
			smooth_triangle {
				<-0.038029, -0.449400, 0.886403>, <3.612828, -2.710342, 3.948418>,
				<-0.030295, -0.476710, 0.872316>, <3.521772, -2.874738, 3.914410>,
				<-0.056922, -0.469280, 0.875012>, <3.655835, -2.829739, 3.823224>
			}
			smooth_triangle {
				<-0.038029, -0.449400, 0.886403>, <3.612828, -2.710342, 3.948418>,
				<-0.010050, -0.457490, 0.883016>, <3.468666, -2.759878, 4.042222>,
				<-0.030295, -0.476710, 0.872316>, <3.521772, -2.874738, 3.914410>
			}
			smooth_triangle {
				<-0.046875, -0.420670, 0.899974>, <3.709511, -2.535947, 3.974354>,
				<-0.038029, -0.449400, 0.886403>, <3.612828, -2.710342, 3.948418>,
				<-0.066002, -0.442430, 0.888257>, <3.748225, -2.666257, 3.851056>
			}
			smooth_triangle {
				<-0.038029, -0.449400, 0.886403>, <3.612828, -2.710342, 3.948418>,
				<-0.017971, -0.429090, 0.897037>, <3.560971, -2.589213, 4.074776>,
				<-0.010050, -0.457490, 0.883016>, <3.468666, -2.759878, 4.042222>
			}
			smooth_triangle {
				<-0.046875, -0.420670, 0.899974>, <3.709511, -2.535947, 3.974354>,
				<-0.017971, -0.429090, 0.897037>, <3.560971, -2.589213, 4.074776>,
				<-0.038029, -0.449400, 0.886403>, <3.612828, -2.710342, 3.948418>
			}
			smooth_triangle {
				<-0.024323, -0.502760, 0.857762>, <3.437809, -3.031700, 3.870486>,
				<-0.030295, -0.476710, 0.872316>, <3.521772, -2.874738, 3.914410>,
				<-0.003463, -0.485890, 0.867764>, <3.377572, -2.929716, 3.999615>
			}
			smooth_triangle {
				<-0.056922, -0.469280, 0.875012>, <3.655835, -2.829739, 3.823224>,
				<-0.074544, -0.488690, 0.862986>, <3.692427, -2.946171, 3.698087>,
				<-0.083548, -0.463090, 0.876167>, <3.783403, -2.795842, 3.722743>
			}
			smooth_triangle {
				<-0.056922, -0.469280, 0.875012>, <3.655835, -2.829739, 3.823224>,
				<-0.048884, -0.494770, 0.861348>, <3.565719, -2.983374, 3.791554>,
				<-0.074544, -0.488690, 0.862986>, <3.692427, -2.946171, 3.698087>
			}
			smooth_triangle {
				<-0.048884, -0.494770, 0.861348>, <3.565719, -2.983374, 3.791554>,
				<-0.030295, -0.476710, 0.872316>, <3.521772, -2.874738, 3.914410>,
				<-0.024323, -0.502760, 0.857762>, <3.437809, -3.031700, 3.870486>
			}
			smooth_triangle {
				<-0.048884, -0.494770, 0.861348>, <3.565719, -2.983374, 3.791554>,
				<-0.056922, -0.469280, 0.875012>, <3.655835, -2.829739, 3.823224>,
				<-0.030295, -0.476710, 0.872316>, <3.521772, -2.874738, 3.914410>
			}
			smooth_triangle {
				<-0.041993, -0.518610, 0.847578>, <3.479639, -3.127420, 3.755435>,
				<-0.048884, -0.494770, 0.861348>, <3.565719, -2.983374, 3.791554>,
				<-0.024323, -0.502760, 0.857762>, <3.437809, -3.031700, 3.870486>
			}
			smooth_triangle {
				<-0.088758, -0.507770, 0.850528>, <3.706468, -3.060017, 3.590342>,
				<-0.079236, -0.529840, 0.837917>, <1.816149, -1.568882, 1.799864>,
				<-0.100852, -0.523520, 0.839568>, <1.865127, -1.559038, 1.757766>
			}
			smooth_triangle {
				<-0.065058, -0.512000, 0.850131>, <3.598079, -3.086785, 3.676669>,
				<-0.079236, -0.529840, 0.837917>, <1.816149, -1.568882, 1.799864>,
				<-0.088758, -0.507770, 0.850528>, <3.706468, -3.060017, 3.590342>
			}
			smooth_triangle {
				<-0.065058, -0.512000, 0.850131>, <3.598079, -3.086785, 3.676669>,
				<-0.056824, -0.531750, 0.838522>, <1.761598, -1.583372, 1.840797>,
				<-0.079236, -0.529840, 0.837917>, <1.816149, -1.568882, 1.799864>
			}
			smooth_triangle {
				<-0.065058, -0.512000, 0.850131>, <3.598079, -3.086785, 3.676669>,
				<-0.041993, -0.518610, 0.847578>, <3.479639, -3.127420, 3.755435>,
				<-0.056824, -0.531750, 0.838522>, <1.761598, -1.583372, 1.840797>
			}
			smooth_triangle {
				<-0.074544, -0.488690, 0.862986>, <3.692427, -2.946171, 3.698087>,
				<-0.065058, -0.512000, 0.850131>, <3.598079, -3.086785, 3.676669>,
				<-0.088758, -0.507770, 0.850528>, <3.706468, -3.060017, 3.590342>
			}
			smooth_triangle {
				<-0.065058, -0.512000, 0.850131>, <3.598079, -3.086785, 3.676669>,
				<-0.048884, -0.494770, 0.861348>, <3.565719, -2.983374, 3.791554>,
				<-0.041993, -0.518610, 0.847578>, <3.479639, -3.127420, 3.755435>
			}
			smooth_triangle {
				<-0.074544, -0.488690, 0.862986>, <3.692427, -2.946171, 3.698087>,
				<-0.048884, -0.494770, 0.861348>, <3.565719, -2.983374, 3.791554>,
				<-0.065058, -0.512000, 0.850131>, <3.598079, -3.086785, 3.676669>
			}
			smooth_triangle {
				<-0.108816, -0.507430, 0.848404>, <3.161696, -2.546538, 2.917881>,
				<-0.088758, -0.507770, 0.850528>, <3.706468, -3.060017, 3.590342>,
				<-0.100852, -0.523520, 0.839568>, <1.865127, -1.559038, 1.757766>
			}
			smooth_triangle {
				<-0.088758, -0.507770, 0.850528>, <3.706468, -3.060017, 3.590342>,
				<-0.103888, -0.484590, 0.862257>, <4.464092, -3.404665, 4.179106>,
				<-0.074544, -0.488690, 0.862986>, <3.692427, -2.946171, 3.698087>
			}
			smooth_triangle {
				<-0.108816, -0.507430, 0.848404>, <3.161696, -2.546538, 2.917881>,
				<-0.103888, -0.484590, 0.862257>, <4.464092, -3.404665, 4.179106>,
				<-0.088758, -0.507770, 0.850528>, <3.706468, -3.060017, 3.590342>
			}
			smooth_triangle {
				<-0.036522, -0.542130, 0.832987>, <1.700748, -1.610675, 1.874062>,
				<-0.056824, -0.531750, 0.838522>, <1.761598, -1.583372, 1.840797>,
				<-0.041993, -0.518610, 0.847578>, <3.479639, -3.127420, 3.755435>
			}
			smooth_triangle {
				<-0.000924, -0.512290, 0.852448>, <3.311522, -3.086235, 3.936984>,
				<-0.024323, -0.502760, 0.857762>, <3.437809, -3.031700, 3.870486>,
				<-0.003463, -0.485890, 0.867764>, <3.377572, -2.929716, 3.999615>
			}
			smooth_triangle {
				<-0.020269, -0.527710, 0.842742>, <3.360112, -3.183912, 3.816240>,
				<-0.036522, -0.542130, 0.832987>, <1.700748, -1.610675, 1.874062>,
				<-0.041993, -0.518610, 0.847578>, <3.479639, -3.127420, 3.755435>
			}
			smooth_triangle {
				<0.005552, -0.553340, 0.826376>, <1.596685, -1.648828, 1.931553>,
				<-0.017995, -0.554720, 0.825274>, <1.648239, -1.637267, 1.897974>,
				<0.000194, -0.535010, 0.838378>, <3.257265, -3.226511, 3.869452>
			}
			smooth_triangle {
				<-0.017995, -0.554720, 0.825274>, <1.648239, -1.637267, 1.897974>,
				<-0.020269, -0.527710, 0.842742>, <3.360112, -3.183912, 3.816240>,
				<0.000194, -0.535010, 0.838378>, <3.257265, -3.226511, 3.869452>
			}
			smooth_triangle {
				<-0.017995, -0.554720, 0.825274>, <1.648239, -1.637267, 1.897974>,
				<-0.036522, -0.542130, 0.832987>, <1.700748, -1.610675, 1.874062>,
				<-0.020269, -0.527710, 0.842742>, <3.360112, -3.183912, 3.816240>
			}
			smooth_triangle {
				<-0.024323, -0.502760, 0.857762>, <3.437809, -3.031700, 3.870486>,
				<-0.020269, -0.527710, 0.842742>, <3.360112, -3.183912, 3.816240>,
				<-0.041993, -0.518610, 0.847578>, <3.479639, -3.127420, 3.755435>
			}
			smooth_triangle {
				<-0.020269, -0.527710, 0.842742>, <3.360112, -3.183912, 3.816240>,
				<-0.000924, -0.512290, 0.852448>, <3.311522, -3.086235, 3.936984>,
				<0.000194, -0.535010, 0.838378>, <3.257265, -3.226511, 3.869452>
			}
			smooth_triangle {
				<-0.024323, -0.502760, 0.857762>, <3.437809, -3.031700, 3.870486>,
				<-0.000924, -0.512290, 0.852448>, <3.311522, -3.086235, 3.936984>,
				<-0.020269, -0.527710, 0.842742>, <3.360112, -3.183912, 3.816240>
			}
			smooth_triangle {
				<0.082934, -0.395710, 0.908655>, <3.138542, -2.385151, 4.521694>,
				<0.049881, -0.391780, 0.912762>, <3.307453, -2.363642, 4.411473>,
				<0.068915, -0.368580, 0.921149>, <3.249491, -2.229964, 4.522683>
			}
			smooth_triangle {
				<0.081536, -0.480180, 0.867115>, <2.986723, -2.899673, 4.319342>,
				<0.071698, -0.450050, 0.883985>, <3.095651, -2.715346, 4.362309>,
				<0.102009, -0.455310, 0.878290>, <2.937797, -2.741703, 4.454066>
			}
			smooth_triangle {
				<0.081536, -0.480180, 0.867115>, <2.986723, -2.899673, 4.319342>,
				<0.049898, -0.474000, 0.872893>, <3.153993, -2.861008, 4.225206>,
				<0.071698, -0.450050, 0.883985>, <3.095651, -2.715346, 4.362309>
			}
			smooth_triangle {
				<0.000194, -0.535010, 0.838378>, <3.257265, -3.226511, 3.869452>,
				<0.018374, -0.538790, 0.835759>, <2.623972, -2.710469, 3.280735>,
				<0.005552, -0.553340, 0.826376>, <1.596685, -1.648828, 1.931553>
			}
			smooth_triangle {
				<0.060475, -0.503520, 0.855520>, <3.038672, -3.034062, 4.188824>,
				<0.049898, -0.474000, 0.872893>, <3.153993, -2.861008, 4.225206>,
				<0.081536, -0.480180, 0.867115>, <2.986723, -2.899673, 4.319342>
			}
			smooth_triangle {
				<0.025898, -0.499100, 0.859848>, <3.745761, -3.508133, 4.758548>,
				<0.016630, -0.522680, 0.845956>, <2.668624, -2.621436, 3.316783>,
				<-0.000924, -0.512290, 0.852448>, <3.311522, -3.086235, 3.936984>
			}
			smooth_triangle {
				<0.049898, -0.474000, 0.872893>, <3.153993, -2.861008, 4.225206>,
				<0.060475, -0.503520, 0.855520>, <3.038672, -3.034062, 4.188824>,
				<0.025898, -0.499100, 0.859848>, <3.745761, -3.508133, 4.758548>
			}
			smooth_triangle {
				<0.039627, -0.527820, 0.841984>, <3.590904, -3.710979, 4.724327>,
				<0.025898, -0.499100, 0.859848>, <3.745761, -3.508133, 4.758548>,
				<0.060475, -0.503520, 0.855520>, <3.038672, -3.034062, 4.188824>
			}
			smooth_triangle {
				<0.039627, -0.527820, 0.841984>, <3.590904, -3.710979, 4.724327>,
				<0.016630, -0.522680, 0.845956>, <2.668624, -2.621436, 3.316783>,
				<0.025898, -0.499100, 0.859848>, <3.745761, -3.508133, 4.758548>
			}
			smooth_triangle {
				<0.018374, -0.538790, 0.835759>, <2.623972, -2.710469, 3.280735>,
				<0.016630, -0.522680, 0.845956>, <2.668624, -2.621436, 3.316783>,
				<0.039627, -0.527820, 0.841984>, <3.590904, -3.710979, 4.724327>
			}
			smooth_triangle {
				<0.016630, -0.522680, 0.845956>, <2.668624, -2.621436, 3.316783>,
				<0.000194, -0.535010, 0.838378>, <3.257265, -3.226511, 3.869452>,
				<-0.000924, -0.512290, 0.852448>, <3.311522, -3.086235, 3.936984>
			}
			smooth_triangle {
				<0.018374, -0.538790, 0.835759>, <2.623972, -2.710469, 3.280735>,
				<0.000194, -0.535010, 0.838378>, <3.257265, -3.226511, 3.869452>,
				<0.016630, -0.522680, 0.845956>, <2.668624, -2.621436, 3.316783>
			}
			smooth_triangle {
				<0.107393, -0.484690, 0.861775>, <1.449792, -1.444180, 2.193218>,
				<0.081536, -0.480180, 0.867115>, <2.986723, -2.899673, 4.319342>,
				<0.102009, -0.455310, 0.878290>, <2.937797, -2.741703, 4.454066>
			}
			smooth_triangle {
				<0.018374, -0.538790, 0.835759>, <2.623972, -2.710469, 3.280735>,
				<0.029928, -0.554750, 0.824902>, <2.035982, -2.203401, 2.645216>,
				<0.005552, -0.553340, 0.826376>, <1.596685, -1.648828, 1.931553>
			}
			smooth_triangle {
				<0.068321, -0.526630, 0.840896>, <2.455463, -2.643182, 3.460677>,
				<0.097264, -0.512490, 0.846764>, <1.940556, -2.042778, 2.838672>,
				<0.086524, -0.540460, 0.830386>, <1.903433, -2.186504, 2.755386>
			}
			smooth_triangle {
				<0.107393, -0.484690, 0.861775>, <1.449792, -1.444180, 2.193218>,
				<0.097264, -0.512490, 0.846764>, <1.940556, -2.042778, 2.838672>,
				<0.081536, -0.480180, 0.867115>, <2.986723, -2.899673, 4.319342>
			}
			smooth_triangle {
				<0.097264, -0.512490, 0.846764>, <1.940556, -2.042778, 2.838672>,
				<0.060475, -0.503520, 0.855520>, <3.038672, -3.034062, 4.188824>,
				<0.081536, -0.480180, 0.867115>, <2.986723, -2.899673, 4.319342>
			}
			smooth_triangle {
				<0.097264, -0.512490, 0.846764>, <1.940556, -2.042778, 2.838672>,
				<0.068321, -0.526630, 0.840896>, <2.455463, -2.643182, 3.460677>,
				<0.060475, -0.503520, 0.855520>, <3.038672, -3.034062, 4.188824>
			}
			smooth_triangle {
				<0.057676, -0.548320, 0.827727>, <2.941778, -3.307762, 4.048946>,
				<0.068321, -0.526630, 0.840896>, <2.455463, -2.643182, 3.460677>,
				<0.086524, -0.540460, 0.830386>, <1.903433, -2.186504, 2.755386>
			}
			smooth_triangle {
				<0.068321, -0.526630, 0.840896>, <2.455463, -2.643182, 3.460677>,
				<0.039627, -0.527820, 0.841984>, <3.590904, -3.710979, 4.724327>,
				<0.060475, -0.503520, 0.855520>, <3.038672, -3.034062, 4.188824>
			}
			smooth_triangle {
				<0.057676, -0.548320, 0.827727>, <2.941778, -3.307762, 4.048946>,
				<0.039627, -0.527820, 0.841984>, <3.590904, -3.710979, 4.724327>,
				<0.068321, -0.526630, 0.840896>, <2.455463, -2.643182, 3.460677>
			}
			smooth_triangle {
				<0.029928, -0.554750, 0.824902>, <2.035982, -2.203401, 2.645216>,
				<0.039627, -0.527820, 0.841984>, <3.590904, -3.710979, 4.724327>,
				<0.057676, -0.548320, 0.827727>, <2.941778, -3.307762, 4.048946>
			}
			smooth_triangle {
				<0.029928, -0.554750, 0.824902>, <2.035982, -2.203401, 2.645216>,
				<0.018374, -0.538790, 0.835759>, <2.623972, -2.710469, 3.280735>,
				<0.039627, -0.527820, 0.841984>, <3.590904, -3.710979, 4.724327>
			}
			smooth_triangle {
				<-0.003463, -0.485890, 0.867764>, <3.377572, -2.929716, 3.999615>,
				<0.025898, -0.499100, 0.859848>, <3.745761, -3.508133, 4.758548>,
				<-0.000924, -0.512290, 0.852448>, <3.311522, -3.086235, 3.936984>
			}
			smooth_triangle {
				<0.049898, -0.474000, 0.872893>, <3.153993, -2.861008, 4.225206>,
				<0.040613, -0.443900, 0.889052>, <3.258358, -2.678812, 4.265412>,
				<0.071698, -0.450050, 0.883985>, <3.095651, -2.715346, 4.362309>
			}
			smooth_triangle {
				<0.049898, -0.474000, 0.872893>, <3.153993, -2.861008, 4.225206>,
				<0.018939, -0.466350, 0.878220>, <3.314427, -2.814948, 4.132432>,
				<0.040613, -0.443900, 0.889052>, <3.258358, -2.678812, 4.265412>
			}
			smooth_triangle {
				<0.018939, -0.466350, 0.878220>, <3.314427, -2.814948, 4.132432>,
				<0.025898, -0.499100, 0.859848>, <3.745761, -3.508133, 4.758548>,
				<-0.003463, -0.485890, 0.867764>, <3.377572, -2.929716, 3.999615>
			}
			smooth_triangle {
				<0.018939, -0.466350, 0.878220>, <3.314427, -2.814948, 4.132432>,
				<0.049898, -0.474000, 0.872893>, <3.153993, -2.861008, 4.225206>,
				<0.025898, -0.499100, 0.859848>, <3.745761, -3.508133, 4.758548>
			}
			smooth_triangle {
				<0.061702, -0.420440, 0.899188>, <3.199735, -2.536594, 4.394736>,
				<0.071698, -0.450050, 0.883985>, <3.095651, -2.715346, 4.362309>,
				<0.040613, -0.443900, 0.889052>, <3.258358, -2.678812, 4.265412>
			}
			smooth_triangle {
				<0.071698, -0.450050, 0.883985>, <3.095651, -2.715346, 4.362309>,
				<0.094190, -0.425630, 0.893910>, <3.027672, -2.568658, 4.496706>,
				<0.102009, -0.455310, 0.878290>, <2.937797, -2.741703, 4.454066>
			}
			smooth_triangle {
				<0.061702, -0.420440, 0.899188>, <3.199735, -2.536594, 4.394736>,
				<0.094190, -0.425630, 0.893910>, <3.027672, -2.568658, 4.496706>,
				<0.071698, -0.450050, 0.883985>, <3.095651, -2.715346, 4.362309>
			}
			smooth_triangle {
				<-0.010050, -0.457490, 0.883016>, <3.468666, -2.759878, 4.042222>,
				<0.018939, -0.466350, 0.878220>, <3.314427, -2.814948, 4.132432>,
				<-0.003463, -0.485890, 0.867764>, <3.377572, -2.929716, 3.999615>
			}
			smooth_triangle {
				<0.040613, -0.443900, 0.889052>, <3.258358, -2.678812, 4.265412>,
				<0.030631, -0.414880, 0.903355>, <3.359259, -2.503486, 4.293665>,
				<0.061702, -0.420440, 0.899188>, <3.199735, -2.536594, 4.394736>
			}
			smooth_triangle {
				<0.040613, -0.443900, 0.889052>, <3.258358, -2.678812, 4.265412>,
				<0.010656, -0.436880, 0.893381>, <3.412755, -2.636813, 4.169931>,
				<0.030631, -0.414880, 0.903355>, <3.359259, -2.503486, 4.293665>
			}
			smooth_triangle {
				<0.010656, -0.436880, 0.893381>, <3.412755, -2.636813, 4.169931>,
				<0.018939, -0.466350, 0.878220>, <3.314427, -2.814948, 4.132432>,
				<-0.010050, -0.457490, 0.883016>, <3.468666, -2.759878, 4.042222>
			}
			smooth_triangle {
				<0.010656, -0.436880, 0.893381>, <3.412755, -2.636813, 4.169931>,
				<0.040613, -0.443900, 0.889052>, <3.258358, -2.678812, 4.265412>,
				<0.018939, -0.466350, 0.878220>, <3.314427, -2.814948, 4.132432>
			}
			smooth_triangle {
				<0.049881, -0.391780, 0.912762>, <3.307453, -2.363642, 4.411473>,
				<0.061702, -0.420440, 0.899188>, <3.199735, -2.536594, 4.394736>,
				<0.030631, -0.414880, 0.903355>, <3.359259, -2.503486, 4.293665>
			}
			smooth_triangle {
				<0.061702, -0.420440, 0.899188>, <3.199735, -2.536594, 4.394736>,
				<0.082934, -0.395710, 0.908655>, <3.138542, -2.385151, 4.521694>,
				<0.094190, -0.425630, 0.893910>, <3.027672, -2.568658, 4.496706>
			}
			smooth_triangle {
				<0.049881, -0.391780, 0.912762>, <3.307453, -2.363642, 4.411473>,
				<0.082934, -0.395710, 0.908655>, <3.138542, -2.385151, 4.521694>,
				<0.061702, -0.420440, 0.899188>, <3.199735, -2.536594, 4.394736>
			}
			smooth_triangle {
				<-0.017971, -0.429090, 0.897037>, <3.560971, -2.589213, 4.074776>,
				<0.010656, -0.436880, 0.893381>, <3.412755, -2.636813, 4.169931>,
				<-0.010050, -0.457490, 0.883016>, <3.468666, -2.759878, 4.042222>
			}
			smooth_triangle {
				<0.035915, -0.363650, 0.924977>, <3.421498, -2.195489, 4.411396>,
				<0.022474, -0.335700, 0.935903>, <1.765044, -1.040779, 2.190609>,
				<0.053168, -0.342430, 0.932221>, <1.680348, -1.065598, 2.244828>
			}
			smooth_triangle {
				<0.001776, -0.356110, 0.928598>, <4.194397, -2.500694, 5.013247>,
				<-0.006160, -0.384730, 0.917086>, <2.986926, -1.930529, 3.513423>,
				<-0.028219, -0.370770, 0.922411>, <3.709635, -2.232939, 4.152063>
			}
			smooth_triangle {
				<0.022474, -0.335700, 0.935903>, <1.765044, -1.040779, 2.190609>,
				<0.035915, -0.363650, 0.924977>, <3.421498, -2.195489, 4.411396>,
				<0.001776, -0.356110, 0.928598>, <4.194397, -2.500694, 5.013247>
			}
			smooth_triangle {
				<0.019015, -0.386780, 0.916052>, <3.462383, -2.330431, 4.309160>,
				<0.001776, -0.356110, 0.928598>, <4.194397, -2.500694, 5.013247>,
				<0.035915, -0.363650, 0.924977>, <3.421498, -2.195489, 4.411396>
			}
			smooth_triangle {
				<0.019015, -0.386780, 0.916052>, <3.462383, -2.330431, 4.309160>,
				<-0.006160, -0.384730, 0.917086>, <2.986926, -1.930529, 3.513423>,
				<0.001776, -0.356110, 0.928598>, <4.194397, -2.500694, 5.013247>
			}
			smooth_triangle {
				<0.001836, -0.408940, 0.906578>, <3.504453, -2.469276, 4.196502>,
				<-0.006160, -0.384730, 0.917086>, <2.986926, -1.930529, 3.513423>,
				<0.019015, -0.386780, 0.916052>, <3.462383, -2.330431, 4.309160>
			}
			smooth_triangle {
				<-0.006160, -0.384730, 0.917086>, <2.986926, -1.930529, 3.513423>,
				<-0.025187, -0.400690, 0.909907>, <3.647782, -2.417494, 4.103423>,
				<-0.028219, -0.370770, 0.922411>, <3.709635, -2.232939, 4.152063>
			}
			smooth_triangle {
				<0.001836, -0.408940, 0.906578>, <3.504453, -2.469276, 4.196502>,
				<-0.025187, -0.400690, 0.909907>, <3.647782, -2.417494, 4.103423>,
				<-0.006160, -0.384730, 0.917086>, <2.986926, -1.930529, 3.513423>
			}
			smooth_triangle {
				<0.068915, -0.368580, 0.921149>, <3.249491, -2.229964, 4.522683>,
				<0.035915, -0.363650, 0.924977>, <3.421498, -2.195489, 4.411396>,
				<0.053168, -0.342430, 0.932221>, <1.680348, -1.065598, 2.244828>
			}
			smooth_triangle {
				<0.019015, -0.386780, 0.916052>, <3.462383, -2.330431, 4.309160>,
				<0.030631, -0.414880, 0.903355>, <3.359259, -2.503486, 4.293665>,
				<0.001836, -0.408940, 0.906578>, <3.504453, -2.469276, 4.196502>
			}
			smooth_triangle {
				<0.019015, -0.386780, 0.916052>, <3.462383, -2.330431, 4.309160>,
				<0.049881, -0.391780, 0.912762>, <3.307453, -2.363642, 4.411473>,
				<0.030631, -0.414880, 0.903355>, <3.359259, -2.503486, 4.293665>
			}
			smooth_triangle {
				<0.049881, -0.391780, 0.912762>, <3.307453, -2.363642, 4.411473>,
				<0.035915, -0.363650, 0.924977>, <3.421498, -2.195489, 4.411396>,
				<0.068915, -0.368580, 0.921149>, <3.249491, -2.229964, 4.522683>
			}
			smooth_triangle {
				<0.049881, -0.391780, 0.912762>, <3.307453, -2.363642, 4.411473>,
				<0.019015, -0.386780, 0.916052>, <3.462383, -2.330431, 4.309160>,
				<0.035915, -0.363650, 0.924977>, <3.421498, -2.195489, 4.411396>
			}
			smooth_triangle {
				<0.010656, -0.436880, 0.893381>, <3.412755, -2.636813, 4.169931>,
				<0.001836, -0.408940, 0.906578>, <3.504453, -2.469276, 4.196502>,
				<0.030631, -0.414880, 0.903355>, <3.359259, -2.503486, 4.293665>
			}
			smooth_triangle {
				<0.001836, -0.408940, 0.906578>, <3.504453, -2.469276, 4.196502>,
				<-0.017971, -0.429090, 0.897037>, <3.560971, -2.589213, 4.074776>,
				<-0.025187, -0.400690, 0.909907>, <3.647782, -2.417494, 4.103423>
			}
			smooth_triangle {
				<0.010656, -0.436880, 0.893381>, <3.412755, -2.636813, 4.169931>,
				<-0.017971, -0.429090, 0.897037>, <3.560971, -2.589213, 4.074776>,
				<0.001836, -0.408940, 0.906578>, <3.504453, -2.469276, 4.196502>
			}
			smooth_triangle {
				<0.102009, -0.455310, 0.878290>, <2.937797, -2.741703, 4.454066>,
				<0.124860, -0.459659, 0.873070>, <0.958180, -0.917460, 1.496423>,
				<0.107393, -0.484690, 0.861775>, <1.449792, -1.444180, 2.193218>
			}
			smooth_triangle {
				<0.134660, -0.407099, 0.897351>, <0.971691, -0.815676, 1.545842>,
				<0.114113, -0.400649, 0.903092>, <2.981778, -2.421428, 4.607764>,
				<0.131424, -0.377369, 0.910732>, <0.986205, -0.780436, 1.554969>
			}
			smooth_triangle {
				<0.114113, -0.400649, 0.903092>, <2.981778, -2.421428, 4.607764>,
				<0.132288, -0.430819, 0.886574>, <1.943511, -1.728550, 3.038494>,
				<0.094190, -0.425630, 0.893910>, <3.027672, -2.568658, 4.496706>
			}
			smooth_triangle {
				<0.114113, -0.400649, 0.903092>, <2.981778, -2.421428, 4.607764>,
				<0.134660, -0.407099, 0.897351>, <0.971691, -0.815676, 1.545842>,
				<0.132288, -0.430819, 0.886574>, <1.943511, -1.728550, 3.038494>
			}
			smooth_triangle {
				<0.132288, -0.430819, 0.886574>, <1.943511, -1.728550, 3.038494>,
				<0.102009, -0.455310, 0.878290>, <2.937797, -2.741703, 4.454066>,
				<0.094190, -0.425630, 0.893910>, <3.027672, -2.568658, 4.496706>
			}
			smooth_triangle {
				<0.124860, -0.459659, 0.873070>, <0.958180, -0.917460, 1.496423>,
				<0.102009, -0.455310, 0.878290>, <2.937797, -2.741703, 4.454066>,
				<0.132288, -0.430819, 0.886574>, <1.943511, -1.728550, 3.038494>
			}
			smooth_triangle {
				<0.082934, -0.395710, 0.908655>, <3.138542, -2.385151, 4.521694>,
				<0.114113, -0.400649, 0.903092>, <2.981778, -2.421428, 4.607764>,
				<0.094190, -0.425630, 0.893910>, <3.027672, -2.568658, 4.496706>
			}
			smooth_triangle {
				<0.114113, -0.400649, 0.903092>, <2.981778, -2.421428, 4.607764>,
				<0.108607, -0.366479, 0.918155>, <2.061521, -1.521541, 3.071232>,
				<0.131424, -0.377369, 0.910732>, <0.986205, -0.780436, 1.554969>
			}
			smooth_triangle {
				<0.082934, -0.395710, 0.908655>, <3.138542, -2.385151, 4.521694>,
				<0.108607, -0.366479, 0.918155>, <2.061521, -1.521541, 3.071232>,
				<0.114113, -0.400649, 0.903092>, <2.981778, -2.421428, 4.607764>
			}
			smooth_triangle {
				<0.082638, -0.350950, 0.926892>, <1.074654, -0.725809, 1.522322>,
				<0.068915, -0.368580, 0.921149>, <3.249491, -2.229964, 4.522683>,
				<0.053168, -0.342430, 0.932221>, <1.680348, -1.065598, 2.244828>
			}
			smooth_triangle {
				<0.068915, -0.368580, 0.921149>, <3.249491, -2.229964, 4.522683>,
				<0.108607, -0.366479, 0.918155>, <2.061521, -1.521541, 3.071232>,
				<0.082934, -0.395710, 0.908655>, <3.138542, -2.385151, 4.521694>
			}
			smooth_triangle {
				<0.068915, -0.368580, 0.921149>, <3.249491, -2.229964, 4.522683>,
				<0.082638, -0.350950, 0.926892>, <1.074654, -0.725809, 1.522322>,
				<0.108607, -0.366479, 0.918155>, <2.061521, -1.521541, 3.071232>
			}
			smooth_triangle {
				<0.057676, -0.548320, 0.827727>, <2.941778, -3.307762, 4.048946>,
				<0.048367, -0.569510, 0.813895>, <0.978712, -1.124450, 1.333206>,
				<0.029928, -0.554750, 0.824902>, <2.035982, -2.203401, 2.645216>
			}
			smooth_triangle {
				<0.057676, -0.548320, 0.827727>, <2.941778, -3.307762, 4.048946>,
				<0.073133, -0.570020, 0.811689>, <1.424901, -1.680170, 2.036179>,
				<0.048367, -0.569510, 0.813895>, <0.978712, -1.124450, 1.333206>
			}
			smooth_triangle {
				<0.086524, -0.540460, 0.830386>, <1.903433, -2.186504, 2.755386>,
				<0.073133, -0.570020, 0.811689>, <1.424901, -1.680170, 2.036179>,
				<0.057676, -0.548320, 0.827727>, <2.941778, -3.307762, 4.048946>
			}
			smooth_triangle {
				<0.086524, -0.540460, 0.830386>, <1.903433, -2.186504, 2.755386>,
				<0.097023, -0.559720, 0.816342>, <0.469453, -0.558466, 0.683908>,
				<0.073133, -0.570020, 0.811689>, <1.424901, -1.680170, 2.036179>
			}
			smooth_triangle {
				<-0.231850, -0.240091, 0.936864>, <3.873052, -1.215779, 2.917888>,
				<-0.250851, -0.212451, 0.938645>, <0.787941, -0.222127, 0.574289>,
				<-0.217732, -0.210021, 0.947419>, <2.329664, -0.665530, 1.768336>
			}
			smooth_triangle {
				<-0.214169, -0.457331, 0.856797>, <4.313382, -2.757401, 3.127569>,
				<-0.191978, -0.470821, 0.854743>, <4.202908, -2.840500, 3.202994>,
				<-0.210000, -0.483151, 0.843548>, <4.241985, -2.914518, 3.082632>
			}
			smooth_triangle {
				<-0.225398, -0.365561, 0.897041>, <4.519252, -2.204695, 3.271292>,
				<-0.195400, -0.381161, 0.897585>, <4.382154, -2.300486, 3.389595>,
				<-0.220087, -0.398391, 0.884282>, <4.443959, -2.402909, 3.234738>
			}
			smooth_triangle {
				<-0.230990, -0.332351, 0.908455>, <4.589229, -2.005149, 3.302198>,
				<-0.200801, -0.347431, 0.909989>, <4.455680, -2.095564, 3.426543>,
				<-0.225398, -0.365561, 0.897041>, <4.519252, -2.204695, 3.271292>
			}
			smooth_triangle {
				<-0.238941, -0.265781, 0.928102>, <2.335443, -0.827160, 1.690833>,
				<-0.213991, -0.278791, 0.930377>, <4.592561, -1.675210, 3.476482>,
				<-0.236307, -0.298811, 0.918687>, <4.654101, -1.803259, 3.327727>
			}
			smooth_triangle {
				<-0.191021, -0.226291, 0.949430>, <4.563532, -1.374653, 3.642647>,
				<-0.217732, -0.210021, 0.947419>, <2.329664, -0.665530, 1.768336>,
				<-0.184167, -0.198720, 0.956928>, <1.522740, -0.426921, 1.224142>
			}
			smooth_triangle {
				<-0.231850, -0.240091, 0.936864>, <3.873052, -1.215779, 2.917888>,
				<-0.191021, -0.226291, 0.949430>, <4.563532, -1.374653, 3.642647>,
				<-0.188558, -0.259501, 0.941397>, <4.523678, -1.563532, 3.615725>
			}
			smooth_triangle {
				<-0.231850, -0.240091, 0.936864>, <3.873052, -1.215779, 2.917888>,
				<-0.217732, -0.210021, 0.947419>, <2.329664, -0.665530, 1.768336>,
				<-0.191021, -0.226291, 0.949430>, <4.563532, -1.374653, 3.642647>
			}
			smooth_triangle {
				<-0.213991, -0.278791, 0.930377>, <4.592561, -1.675210, 3.476482>,
				<-0.231850, -0.240091, 0.936864>, <3.873052, -1.215779, 2.917888>,
				<-0.188558, -0.259501, 0.941397>, <4.523678, -1.563532, 3.615725>
			}
			smooth_triangle {
				<-0.213991, -0.278791, 0.930377>, <4.592561, -1.675210, 3.476482>,
				<-0.238941, -0.265781, 0.928102>, <2.335443, -0.827160, 1.690833>,
				<-0.231850, -0.240091, 0.936864>, <3.873052, -1.215779, 2.917888>
			}
			smooth_triangle {
				<-0.163142, -0.207550, 0.958867>, <2.979282, -0.880295, 2.519156>,
				<-0.191021, -0.226291, 0.949430>, <4.563532, -1.374653, 3.642647>,
				<-0.184167, -0.198720, 0.956928>, <1.522740, -0.426921, 1.224142>
			}
			smooth_triangle {
				<-0.191021, -0.226291, 0.949430>, <4.563532, -1.374653, 3.642647>,
				<-0.159872, -0.241490, 0.951438>, <4.427421, -1.461839, 3.774333>,
				<-0.188558, -0.259501, 0.941397>, <4.523678, -1.563532, 3.615725>
			}
			smooth_triangle {
				<-0.163142, -0.207550, 0.958867>, <2.979282, -0.880295, 2.519156>,
				<-0.159872, -0.241490, 0.951438>, <4.427421, -1.461839, 3.774333>,
				<-0.191021, -0.226291, 0.949430>, <4.563532, -1.374653, 3.642647>
			}
			smooth_triangle {
				<-0.152840, -0.275420, 0.943343>, <4.362880, -1.659312, 3.767618>,
				<-0.188558, -0.259501, 0.941397>, <4.523678, -1.563532, 3.615725>,
				<-0.159872, -0.241490, 0.951438>, <4.427421, -1.461839, 3.774333>
			}
			smooth_triangle {
				<-0.213991, -0.278791, 0.930377>, <4.592561, -1.675210, 3.476482>,
				<-0.206544, -0.313531, 0.920957>, <4.524232, -1.891423, 3.455273>,
				<-0.236307, -0.298811, 0.918687>, <4.654101, -1.803259, 3.327727>
			}
			smooth_triangle {
				<-0.213991, -0.278791, 0.930377>, <4.592561, -1.675210, 3.476482>,
				<-0.181047, -0.294431, 0.932550>, <4.451623, -1.775148, 3.607804>,
				<-0.206544, -0.313531, 0.920957>, <4.524232, -1.891423, 3.455273>
			}
			smooth_triangle {
				<-0.181047, -0.294431, 0.932550>, <4.451623, -1.775148, 3.607804>,
				<-0.188558, -0.259501, 0.941397>, <4.523678, -1.563532, 3.615725>,
				<-0.152840, -0.275420, 0.943343>, <4.362880, -1.659312, 3.767618>
			}
			smooth_triangle {
				<-0.181047, -0.294431, 0.932550>, <4.451623, -1.775148, 3.607804>,
				<-0.213991, -0.278791, 0.930377>, <4.592561, -1.675210, 3.476482>,
				<-0.188558, -0.259501, 0.941397>, <4.523678, -1.563532, 3.615725>
			}
			smooth_triangle {
				<-0.148340, -0.309980, 0.933289>, <4.303777, -1.868896, 3.737507>,
				<-0.181047, -0.294431, 0.932550>, <4.451623, -1.775148, 3.607804>,
				<-0.152840, -0.275420, 0.943343>, <4.362880, -1.659312, 3.767618>
			}
			smooth_triangle {
				<-0.181047, -0.294431, 0.932550>, <4.451623, -1.775148, 3.607804>,
				<-0.175349, -0.328771, 0.922103>, <4.384926, -1.983210, 3.581125>,
				<-0.206544, -0.313531, 0.920957>, <4.524232, -1.891423, 3.455273>
			}
			smooth_triangle {
				<-0.148340, -0.309980, 0.933289>, <4.303777, -1.868896, 3.737507>,
				<-0.175349, -0.328771, 0.922103>, <4.384926, -1.983210, 3.581125>,
				<-0.181047, -0.294431, 0.932550>, <4.451623, -1.775148, 3.607804>
			}
			smooth_triangle {
				<-0.200801, -0.347431, 0.909989>, <4.455680, -2.095564, 3.426543>,
				<-0.206544, -0.313531, 0.920957>, <4.524232, -1.891423, 3.455273>,
				<-0.175349, -0.328771, 0.922103>, <4.384926, -1.983210, 3.581125>
			}
			smooth_triangle {
				<-0.206544, -0.313531, 0.920957>, <4.524232, -1.891423, 3.455273>,
				<-0.230990, -0.332351, 0.908455>, <4.589229, -2.005149, 3.302198>,
				<-0.236307, -0.298811, 0.918687>, <4.654101, -1.803259, 3.327727>
			}
			smooth_triangle {
				<-0.200801, -0.347431, 0.909989>, <4.455680, -2.095564, 3.426543>,
				<-0.230990, -0.332351, 0.908455>, <4.589229, -2.005149, 3.302198>,
				<-0.206544, -0.313531, 0.920957>, <4.524232, -1.891423, 3.455273>
			}
			smooth_triangle {
				<-0.144298, -0.344090, 0.921895>, <4.241011, -2.075475, 3.700200>,
				<-0.175349, -0.328771, 0.922103>, <4.384926, -1.983210, 3.581125>,
				<-0.148340, -0.309980, 0.933289>, <4.303777, -1.868896, 3.737507>
			}
			smooth_triangle {
				<-0.200801, -0.347431, 0.909989>, <4.455680, -2.095564, 3.426543>,
				<-0.195400, -0.381161, 0.897585>, <4.382154, -2.300486, 3.389595>,
				<-0.225398, -0.365561, 0.897041>, <4.519252, -2.204695, 3.271292>
			}
			smooth_triangle {
				<-0.200801, -0.347431, 0.909989>, <4.455680, -2.095564, 3.426543>,
				<-0.170412, -0.362531, 0.910298>, <4.316803, -2.186337, 3.545519>,
				<-0.195400, -0.381161, 0.897585>, <4.382154, -2.300486, 3.389595>
			}
			smooth_triangle {
				<-0.170412, -0.362531, 0.910298>, <4.316803, -2.186337, 3.545519>,
				<-0.175349, -0.328771, 0.922103>, <4.384926, -1.983210, 3.581125>,
				<-0.144298, -0.344090, 0.921895>, <4.241011, -2.075475, 3.700200>
			}
			smooth_triangle {
				<-0.170412, -0.362531, 0.910298>, <4.316803, -2.186337, 3.545519>,
				<-0.200801, -0.347431, 0.909989>, <4.455680, -2.095564, 3.426543>,
				<-0.175349, -0.328771, 0.922103>, <4.384926, -1.983210, 3.581125>
			}
			smooth_triangle {
				<-0.140445, -0.377510, 0.909328>, <4.174726, -2.276051, 3.657461>,
				<-0.170412, -0.362531, 0.910298>, <4.316803, -2.186337, 3.545519>,
				<-0.144298, -0.344090, 0.921895>, <4.241011, -2.075475, 3.700200>
			}
			smooth_triangle {
				<-0.216731, -0.429381, 0.870500>, <4.377484, -2.586598, 3.183613>,
				<-0.193583, -0.445891, 0.867656>, <4.263037, -2.686240, 3.255965>,
				<-0.214169, -0.457331, 0.856797>, <4.313382, -2.757401, 3.127569>
			}
			smooth_triangle {
				<-0.189448, -0.416691, 0.882945>, <5.019413, -2.926400, 3.901802>,
				<-0.193583, -0.445891, 0.867656>, <4.263037, -2.686240, 3.255965>,
				<-0.216731, -0.429381, 0.870500>, <4.377484, -2.586598, 3.183613>
			}
			smooth_triangle {
				<-0.189448, -0.416691, 0.882945>, <5.019413, -2.926400, 3.901802>,
				<-0.174527, -0.440041, 0.874653>, <3.500972, -2.208101, 2.803921>,
				<-0.193583, -0.445891, 0.867656>, <4.263037, -2.686240, 3.255965>
			}
			smooth_triangle {
				<-0.136989, -0.409400, 0.895959>, <4.106573, -2.468113, 3.609955>,
				<-0.165468, -0.395591, 0.897350>, <4.245728, -2.384813, 3.503254>,
				<-0.140445, -0.377510, 0.909328>, <4.174726, -2.276051, 3.657461>
			}
			smooth_triangle {
				<-0.159517, -0.425481, 0.884669>, <4.167849, -2.561554, 3.472281>,
				<-0.165468, -0.395591, 0.897350>, <4.245728, -2.384813, 3.503254>,
				<-0.136989, -0.409400, 0.895959>, <4.106573, -2.468113, 3.609955>
			}
			smooth_triangle {
				<-0.159517, -0.425481, 0.884669>, <4.167849, -2.561554, 3.472281>,
				<-0.189448, -0.416691, 0.882945>, <5.019413, -2.926400, 3.901802>,
				<-0.165468, -0.395591, 0.897350>, <4.245728, -2.384813, 3.503254>
			}
			smooth_triangle {
				<-0.189448, -0.416691, 0.882945>, <5.019413, -2.926400, 3.901802>,
				<-0.159517, -0.425481, 0.884669>, <4.167849, -2.561554, 3.472281>,
				<-0.174527, -0.440041, 0.874653>, <3.500972, -2.208101, 2.803921>
			}
			smooth_triangle {
				<-0.220087, -0.398391, 0.884282>, <4.443959, -2.402909, 3.234738>,
				<-0.189448, -0.416691, 0.882945>, <5.019413, -2.926400, 3.901802>,
				<-0.216731, -0.429381, 0.870500>, <4.377484, -2.586598, 3.183613>
			}
			smooth_triangle {
				<-0.165468, -0.395591, 0.897350>, <4.245728, -2.384813, 3.503254>,
				<-0.170412, -0.362531, 0.910298>, <4.316803, -2.186337, 3.545519>,
				<-0.140445, -0.377510, 0.909328>, <4.174726, -2.276051, 3.657461>
			}
			smooth_triangle {
				<-0.165468, -0.395591, 0.897350>, <4.245728, -2.384813, 3.503254>,
				<-0.195400, -0.381161, 0.897585>, <4.382154, -2.300486, 3.389595>,
				<-0.170412, -0.362531, 0.910298>, <4.316803, -2.186337, 3.545519>
			}
			smooth_triangle {
				<-0.195400, -0.381161, 0.897585>, <4.382154, -2.300486, 3.389595>,
				<-0.189448, -0.416691, 0.882945>, <5.019413, -2.926400, 3.901802>,
				<-0.220087, -0.398391, 0.884282>, <4.443959, -2.402909, 3.234738>
			}
			smooth_triangle {
				<-0.195400, -0.381161, 0.897585>, <4.382154, -2.300486, 3.389595>,
				<-0.165468, -0.395591, 0.897350>, <4.245728, -2.384813, 3.503254>,
				<-0.189448, -0.416691, 0.882945>, <5.019413, -2.926400, 3.901802>
			}
			smooth_triangle {
				<-0.134476, -0.439280, 0.882075>, <4.038641, -2.650644, 3.556980>,
				<-0.159517, -0.425481, 0.884669>, <4.167849, -2.561554, 3.472281>,
				<-0.136989, -0.409400, 0.895959>, <4.106573, -2.468113, 3.609955>
			}
			smooth_triangle {
				<-0.193583, -0.445891, 0.867656>, <4.263037, -2.686240, 3.255965>,
				<-0.191978, -0.470821, 0.854743>, <4.202908, -2.840500, 3.202994>,
				<-0.214169, -0.457331, 0.856797>, <4.313382, -2.757401, 3.127569>
			}
			smooth_triangle {
				<-0.193583, -0.445891, 0.867656>, <4.263037, -2.686240, 3.255965>,
				<-0.174140, -0.460481, 0.864147>, <4.157174, -2.778747, 3.315101>,
				<-0.191978, -0.470821, 0.854743>, <4.202908, -2.840500, 3.202994>
			}
			smooth_triangle {
				<-0.155716, -0.451320, 0.872459>, <4.097440, -2.720792, 3.435096>,
				<-0.159517, -0.425481, 0.884669>, <4.167849, -2.561554, 3.472281>,
				<-0.134476, -0.439280, 0.882075>, <4.038641, -2.650644, 3.556980>
			}
			smooth_triangle {
				<-0.155716, -0.451320, 0.872459>, <4.097440, -2.720792, 3.435096>,
				<-0.174527, -0.440041, 0.874653>, <3.500972, -2.208101, 2.803921>,
				<-0.159517, -0.425481, 0.884669>, <4.167849, -2.561554, 3.472281>
			}
			smooth_triangle {
				<-0.174527, -0.440041, 0.874653>, <3.500972, -2.208101, 2.803921>,
				<-0.174140, -0.460481, 0.864147>, <4.157174, -2.778747, 3.315101>,
				<-0.193583, -0.445891, 0.867656>, <4.263037, -2.686240, 3.255965>
			}
			smooth_triangle {
				<-0.155716, -0.451320, 0.872459>, <4.097440, -2.720792, 3.435096>,
				<-0.174140, -0.460481, 0.864147>, <4.157174, -2.778747, 3.315101>,
				<-0.174527, -0.440041, 0.874653>, <3.500972, -2.208101, 2.803921>
			}
			smooth_triangle {
				<-0.236307, -0.298811, 0.918687>, <4.654101, -1.803259, 3.327727>,
				<-0.265672, -0.284211, 0.915287>, <2.368662, -0.888632, 1.611770>,
				<-0.238941, -0.265781, 0.928102>, <2.335443, -0.827160, 1.690833>
			}
			smooth_triangle {
				<-0.265105, -0.429641, 0.856877>, <4.547868, -2.590631, 2.931545>,
				<-0.238712, -0.443321, 0.857667>, <4.429628, -2.672563, 3.037280>,
				<-0.258485, -0.458191, 0.844012>, <4.467802, -2.762734, 2.897515>
			}
			smooth_triangle {
				<-0.243662, -0.413981, 0.870841>, <4.502421, -2.495997, 3.079902>,
				<-0.216731, -0.429381, 0.870500>, <4.377484, -2.586598, 3.183613>,
				<-0.238712, -0.443321, 0.857667>, <4.429628, -2.672563, 3.037280>
			}
			smooth_triangle {
				<-0.243662, -0.413981, 0.870841>, <4.502421, -2.495997, 3.079902>,
				<-0.220087, -0.398391, 0.884282>, <4.443959, -2.402909, 3.234738>,
				<-0.216731, -0.429381, 0.870500>, <4.377484, -2.586598, 3.183613>
			}
			smooth_triangle {
				<-0.236307, -0.298811, 0.918687>, <4.654101, -1.803259, 3.327727>,
				<-0.260888, -0.317631, 0.905633>, <4.716441, -1.916211, 3.173155>,
				<-0.265672, -0.284211, 0.915287>, <2.368662, -0.888632, 1.611770>
			}
			smooth_triangle {
				<-0.249110, -0.382841, 0.883453>, <4.576193, -2.308756, 3.116860>,
				<-0.220087, -0.398391, 0.884282>, <4.443959, -2.402909, 3.234738>,
				<-0.243662, -0.413981, 0.870841>, <4.502421, -2.495997, 3.079902>
			}
			smooth_triangle {
				<-0.249110, -0.382841, 0.883453>, <4.576193, -2.308756, 3.116860>,
				<-0.225398, -0.365561, 0.897041>, <4.519252, -2.204695, 3.271292>,
				<-0.220087, -0.398391, 0.884282>, <4.443959, -2.402909, 3.234738>
			}
			smooth_triangle {
				<-0.230990, -0.332351, 0.908455>, <4.589229, -2.005149, 3.302198>,
				<-0.260888, -0.317631, 0.905633>, <4.716441, -1.916211, 3.173155>,
				<-0.236307, -0.298811, 0.918687>, <4.654101, -1.803259, 3.327727>
			}
			smooth_triangle {
				<-0.230990, -0.332351, 0.908455>, <4.589229, -2.005149, 3.302198>,
				<-0.255144, -0.350511, 0.895070>, <4.649326, -2.114026, 3.146578>,
				<-0.260888, -0.317631, 0.905633>, <4.716441, -1.916211, 3.173155>
			}
			smooth_triangle {
				<-0.255144, -0.350511, 0.895070>, <4.649326, -2.114026, 3.146578>,
				<-0.225398, -0.365561, 0.897041>, <4.519252, -2.204695, 3.271292>,
				<-0.249110, -0.382841, 0.883453>, <4.576193, -2.308756, 3.116860>
			}
			smooth_triangle {
				<-0.255144, -0.350511, 0.895070>, <4.649326, -2.114026, 3.146578>,
				<-0.230990, -0.332351, 0.908455>, <4.589229, -2.005149, 3.302198>,
				<-0.225398, -0.365561, 0.897041>, <4.519252, -2.204695, 3.271292>
			}
			smooth_triangle {
				<-0.265105, -0.429641, 0.856877>, <4.547868, -2.590631, 2.931545>,
				<-0.243662, -0.413981, 0.870841>, <4.502421, -2.495997, 3.079902>,
				<-0.238712, -0.443321, 0.857667>, <4.429628, -2.672563, 3.037280>
			}
			smooth_triangle {
				<-0.260888, -0.317631, 0.905633>, <4.716441, -1.916211, 3.173155>,
				<-0.290720, -0.303671, 0.901320>, <3.218518, -1.250081, 2.018113>,
				<-0.265672, -0.284211, 0.915287>, <2.368662, -0.888632, 1.611770>
			}
			smooth_triangle {
				<-0.260888, -0.317631, 0.905633>, <4.716441, -1.916211, 3.173155>,
				<-0.285510, -0.335671, 0.891583>, <4.777376, -2.024525, 3.010532>,
				<-0.290720, -0.303671, 0.901320>, <3.218518, -1.250081, 2.018113>
			}
			smooth_triangle {
				<-0.271454, -0.399601, 0.869332>, <4.625178, -2.409658, 2.964614>,
				<-0.243662, -0.413981, 0.870841>, <4.502421, -2.495997, 3.079902>,
				<-0.265105, -0.429641, 0.856877>, <4.547868, -2.590631, 2.931545>
			}
			smooth_triangle {
				<-0.271454, -0.399601, 0.869332>, <4.625178, -2.409658, 2.964614>,
				<-0.249110, -0.382841, 0.883453>, <4.576193, -2.308756, 3.116860>,
				<-0.243662, -0.413981, 0.870841>, <4.502421, -2.495997, 3.079902>
			}
			smooth_triangle {
				<-0.255144, -0.350511, 0.895070>, <4.649326, -2.114026, 3.146578>,
				<-0.285510, -0.335671, 0.891583>, <4.777376, -2.024525, 3.010532>,
				<-0.260888, -0.317631, 0.905633>, <4.716441, -1.916211, 3.173155>
			}
			smooth_triangle {
				<-0.255144, -0.350511, 0.895070>, <4.649326, -2.114026, 3.146578>,
				<-0.278087, -0.368341, 0.880968>, <4.700495, -2.221143, 2.993093>,
				<-0.285510, -0.335671, 0.891583>, <4.777376, -2.024525, 3.010532>
			}
			smooth_triangle {
				<-0.278087, -0.368341, 0.880968>, <4.700495, -2.221143, 2.993093>,
				<-0.249110, -0.382841, 0.883453>, <4.576193, -2.308756, 3.116860>,
				<-0.271454, -0.399601, 0.869332>, <4.625178, -2.409658, 2.964614>
			}
			smooth_triangle {
				<-0.278087, -0.368341, 0.880968>, <4.700495, -2.221143, 2.993093>,
				<-0.255144, -0.350511, 0.895070>, <4.649326, -2.114026, 3.146578>,
				<-0.249110, -0.382841, 0.883453>, <4.576193, -2.308756, 3.116860>
			}
			smooth_triangle {
				<-0.214169, -0.457331, 0.856797>, <4.313382, -2.757401, 3.127569>,
				<-0.238712, -0.443321, 0.857667>, <4.429628, -2.672563, 3.037280>,
				<-0.216731, -0.429381, 0.870500>, <4.377484, -2.586598, 3.183613>
			}
			smooth_triangle {
				<-0.233491, -0.470741, 0.844396>, <4.353828, -2.839074, 2.995658>,
				<-0.210000, -0.483151, 0.843548>, <4.241985, -2.914518, 3.082632>,
				<-0.227478, -0.496801, 0.830996>, <4.273849, -2.997182, 2.956681>
			}
			smooth_triangle {
				<-0.233491, -0.470741, 0.844396>, <4.353828, -2.839074, 2.995658>,
				<-0.214169, -0.457331, 0.856797>, <4.313382, -2.757401, 3.127569>,
				<-0.210000, -0.483151, 0.843548>, <4.241985, -2.914518, 3.082632>
			}
			smooth_triangle {
				<-0.233491, -0.470741, 0.844396>, <4.353828, -2.839074, 2.995658>,
				<-0.238712, -0.443321, 0.857667>, <4.429628, -2.672563, 3.037280>,
				<-0.214169, -0.457331, 0.856797>, <4.313382, -2.757401, 3.127569>
			}
			smooth_triangle {
				<-0.251495, -0.485001, 0.831045>, <4.384693, -2.925214, 2.864978>,
				<-0.233491, -0.470741, 0.844396>, <4.353828, -2.839074, 2.995658>,
				<-0.227478, -0.496801, 0.830996>, <4.273849, -2.997182, 2.956681>
			}
			smooth_triangle {
				<-0.233491, -0.470741, 0.844396>, <4.353828, -2.839074, 2.995658>,
				<-0.258485, -0.458191, 0.844012>, <4.467802, -2.762734, 2.897515>,
				<-0.238712, -0.443321, 0.857667>, <4.429628, -2.672563, 3.037280>
			}
			smooth_triangle {
				<-0.251495, -0.485001, 0.831045>, <4.384693, -2.925214, 2.864978>,
				<-0.258485, -0.458191, 0.844012>, <4.467802, -2.762734, 2.897515>,
				<-0.233491, -0.470741, 0.844396>, <4.353828, -2.839074, 2.995658>
			}
			smooth_triangle {
				<-0.136989, -0.409400, 0.895959>, <4.106573, -2.468113, 3.609955>,
				<-0.110489, -0.424620, 0.892521>, <3.972280, -2.558470, 3.696387>,
				<-0.134476, -0.439280, 0.882075>, <4.038641, -2.650644, 3.556980>
			}
			smooth_triangle {
				<-0.136989, -0.409400, 0.895959>, <4.106573, -2.468113, 3.609955>,
				<-0.111051, -0.393240, 0.906725>, <4.026321, -2.371527, 3.761617>,
				<-0.110489, -0.424620, 0.892521>, <3.972280, -2.558470, 3.696387>
			}
			smooth_triangle {
				<-0.119533, -0.255520, 0.953696>, <3.553080, -1.311528, 3.262680>,
				<-0.159872, -0.241490, 0.951438>, <4.427421, -1.461839, 3.774333>,
				<-0.143609, -0.224240, 0.958234>, <2.200056, -0.683836, 1.920792>
			}
			smooth_triangle {
				<-0.119533, -0.255520, 0.953696>, <3.553080, -1.311528, 3.262680>,
				<-0.152840, -0.275420, 0.943343>, <4.362880, -1.659312, 3.767618>,
				<-0.159872, -0.241490, 0.951438>, <4.427421, -1.461839, 3.774333>
			}
			smooth_triangle {
				<-0.140445, -0.377510, 0.909328>, <4.174726, -2.276051, 3.657461>,
				<-0.111051, -0.393240, 0.906725>, <4.026321, -2.371527, 3.761617>,
				<-0.136989, -0.409400, 0.895959>, <4.106573, -2.468113, 3.609955>
			}
			smooth_triangle {
				<-0.140445, -0.377510, 0.909328>, <4.174726, -2.276051, 3.657461>,
				<-0.113859, -0.359580, 0.920242>, <4.093555, -2.168889, 3.811045>,
				<-0.111051, -0.393240, 0.906725>, <4.026321, -2.371527, 3.761617>
			}
			smooth_triangle {
				<-0.119074, -0.291060, 0.943508>, <4.209242, -1.754032, 3.897418>,
				<-0.152840, -0.275420, 0.943343>, <4.362880, -1.659312, 3.767618>,
				<-0.119533, -0.255520, 0.953696>, <3.553080, -1.311528, 3.262680>
			}
			smooth_triangle {
				<-0.119074, -0.291060, 0.943508>, <4.209242, -1.754032, 3.897418>,
				<-0.148340, -0.309980, 0.933289>, <4.303777, -1.868896, 3.737507>,
				<-0.152840, -0.275420, 0.943343>, <4.362880, -1.659312, 3.767618>
			}
			smooth_triangle {
				<-0.144298, -0.344090, 0.921895>, <4.241011, -2.075475, 3.700200>,
				<-0.113859, -0.359580, 0.920242>, <4.093555, -2.168889, 3.811045>,
				<-0.140445, -0.377510, 0.909328>, <4.174726, -2.276051, 3.657461>
			}
			smooth_triangle {
				<-0.144298, -0.344090, 0.921895>, <4.241011, -2.075475, 3.700200>,
				<-0.116753, -0.325550, 0.932475>, <4.154704, -1.963410, 3.855893>,
				<-0.113859, -0.359580, 0.920242>, <4.093555, -2.168889, 3.811045>
			}
			smooth_triangle {
				<-0.116753, -0.325550, 0.932475>, <4.154704, -1.963410, 3.855893>,
				<-0.148340, -0.309980, 0.933289>, <4.303777, -1.868896, 3.737507>,
				<-0.119074, -0.291060, 0.943508>, <4.209242, -1.754032, 3.897418>
			}
			smooth_triangle {
				<-0.116753, -0.325550, 0.932475>, <4.154704, -1.963410, 3.855893>,
				<-0.144298, -0.344090, 0.921895>, <4.241011, -2.075475, 3.700200>,
				<-0.148340, -0.309980, 0.933289>, <4.303777, -1.868896, 3.737507>
			}
			smooth_triangle {
				<-0.143609, -0.224240, 0.958234>, <2.200056, -0.683836, 1.920792>,
				<-0.163142, -0.207550, 0.958867>, <2.979282, -0.880295, 2.519156>,
				<-0.144402, -0.196740, 0.964134>, <0.735322, -0.211536, 0.643859>
			}
			smooth_triangle {
				<-0.159872, -0.241490, 0.951438>, <4.427421, -1.461839, 3.774333>,
				<-0.163142, -0.207550, 0.958867>, <2.979282, -0.880295, 2.519156>,
				<-0.143609, -0.224240, 0.958234>, <2.200056, -0.683836, 1.920792>
			}
			smooth_triangle {
				<-0.001448, -0.313140, 0.943953>, <2.463012, -1.295876, 2.872201>,
				<0.022474, -0.335700, 0.935903>, <1.765044, -1.040779, 2.190609>,
				<0.001776, -0.356110, 0.928598>, <4.194397, -2.500694, 5.013247>
			}
			smooth_triangle {
				<-0.111051, -0.393240, 0.906725>, <4.026321, -2.371527, 3.761617>,
				<-0.080327, -0.412270, 0.901491>, <4.510776, -2.896737, 4.499130>,
				<-0.110489, -0.424620, 0.892521>, <3.972280, -2.558470, 3.696387>
			}
			smooth_triangle {
				<-0.088063, -0.306940, 0.941884>, <4.059019, -1.851314, 4.010218>,
				<-0.086347, -0.341080, 0.930223>, <4.005459, -2.057673, 3.963273>,
				<-0.116753, -0.325550, 0.932475>, <4.154704, -1.963410, 3.855893>
			}
			smooth_triangle {
				<-0.029248, -0.337040, 0.935232>, <3.757276, -2.033255, 4.211064>,
				<-0.001448, -0.313140, 0.943953>, <2.463012, -1.295876, 2.872201>,
				<0.001776, -0.356110, 0.928598>, <4.194397, -2.500694, 5.013247>
			}
			smooth_triangle {
				<-0.032237, -0.303110, 0.946683>, <3.818429, -1.833405, 4.247975>,
				<-0.001448, -0.313140, 0.943953>, <2.463012, -1.295876, 2.872201>,
				<-0.029248, -0.337040, 0.935232>, <3.757276, -2.033255, 4.211064>
			}
			smooth_triangle {
				<-0.032237, -0.303110, 0.946683>, <3.818429, -1.833405, 4.247975>,
				<-0.014720, -0.281540, 0.953745>, <1.258941, -0.592072, 1.436738>,
				<-0.001448, -0.313140, 0.943953>, <2.463012, -1.295876, 2.872201>
			}
			smooth_triangle {
				<-0.032237, -0.303110, 0.946683>, <3.818429, -1.833405, 4.247975>,
				<-0.030410, -0.275410, 0.955161>, <1.938425, -0.853540, 2.124260>,
				<-0.014720, -0.281540, 0.953745>, <1.258941, -0.592072, 1.436738>
			}
			smooth_triangle {
				<-0.058606, -0.322270, 0.939045>, <3.912337, -1.944855, 4.110617>,
				<-0.032237, -0.303110, 0.946683>, <3.818429, -1.833405, 4.247975>,
				<-0.029248, -0.337040, 0.935232>, <3.757276, -2.033255, 4.211064>
			}
			smooth_triangle {
				<-0.032237, -0.303110, 0.946683>, <3.818429, -1.833405, 4.247975>,
				<-0.058794, -0.288750, 0.949882>, <3.957959, -1.739597, 4.158611>,
				<-0.030410, -0.275410, 0.955161>, <1.938425, -0.853540, 2.124260>
			}
			smooth_triangle {
				<-0.058606, -0.322270, 0.939045>, <3.912337, -1.944855, 4.110617>,
				<-0.058794, -0.288750, 0.949882>, <3.957959, -1.739597, 4.158611>,
				<-0.032237, -0.303110, 0.946683>, <3.818429, -1.833405, 4.247975>
			}
			smooth_triangle {
				<-0.028219, -0.370770, 0.922411>, <3.709635, -2.232939, 4.152063>,
				<-0.029248, -0.337040, 0.935232>, <3.757276, -2.033255, 4.211064>,
				<0.001776, -0.356110, 0.928598>, <4.194397, -2.500694, 5.013247>
			}
			smooth_triangle {
				<-0.029248, -0.337040, 0.935232>, <3.757276, -2.033255, 4.211064>,
				<-0.056682, -0.356110, 0.926870>, <3.856075, -2.147754, 4.062407>,
				<-0.058606, -0.322270, 0.939045>, <3.912337, -1.944855, 4.110617>
			}
			smooth_triangle {
				<-0.028219, -0.370770, 0.922411>, <3.709635, -2.232939, 4.152063>,
				<-0.056682, -0.356110, 0.926870>, <3.856075, -2.147754, 4.062407>,
				<-0.029248, -0.337040, 0.935232>, <3.757276, -2.033255, 4.211064>
			}
			smooth_triangle {
				<-0.086347, -0.341080, 0.930223>, <4.005459, -2.057673, 3.963273>,
				<-0.058606, -0.322270, 0.939045>, <3.912337, -1.944855, 4.110617>,
				<-0.056682, -0.356110, 0.926870>, <3.856075, -2.147754, 4.062407>
			}
			smooth_triangle {
				<-0.058606, -0.322270, 0.939045>, <3.912337, -1.944855, 4.110617>,
				<-0.088063, -0.306940, 0.941884>, <4.059019, -1.851314, 4.010218>,
				<-0.058794, -0.288750, 0.949882>, <3.957959, -1.739597, 4.158611>
			}
			smooth_triangle {
				<-0.086347, -0.341080, 0.930223>, <4.005459, -2.057673, 3.963273>,
				<-0.088063, -0.306940, 0.941884>, <4.059019, -1.851314, 4.010218>,
				<-0.058606, -0.322270, 0.939045>, <3.912337, -1.944855, 4.110617>
			}
			smooth_triangle {
				<-0.053558, -0.389420, 0.913557>, <3.792790, -2.349377, 4.010124>,
				<-0.056682, -0.356110, 0.926870>, <3.856075, -2.147754, 4.062407>,
				<-0.028219, -0.370770, 0.922411>, <3.709635, -2.232939, 4.152063>
			}
			smooth_triangle {
				<-0.086347, -0.341080, 0.930223>, <4.005459, -2.057673, 3.963273>,
				<-0.113859, -0.359580, 0.920242>, <4.093555, -2.168889, 3.811045>,
				<-0.116753, -0.325550, 0.932475>, <4.154704, -1.963410, 3.855893>
			}
			smooth_triangle {
				<-0.083699, -0.375420, 0.917153>, <3.941936, -2.266316, 3.912709>,
				<-0.056682, -0.356110, 0.926870>, <3.856075, -2.147754, 4.062407>,
				<-0.053558, -0.389420, 0.913557>, <3.792790, -2.349377, 4.010124>
			}
			smooth_triangle {
				<-0.083699, -0.375420, 0.917153>, <3.941936, -2.266316, 3.912709>,
				<-0.086347, -0.341080, 0.930223>, <4.005459, -2.057673, 3.963273>,
				<-0.056682, -0.356110, 0.926870>, <3.856075, -2.147754, 4.062407>
			}
			smooth_triangle {
				<-0.083699, -0.375420, 0.917153>, <3.941936, -2.266316, 3.912709>,
				<-0.113859, -0.359580, 0.920242>, <4.093555, -2.168889, 3.811045>,
				<-0.086347, -0.341080, 0.930223>, <4.005459, -2.057673, 3.963273>
			}
			smooth_triangle {
				<-0.080327, -0.412270, 0.901491>, <4.510776, -2.896737, 4.499130>,
				<-0.083699, -0.375420, 0.917153>, <3.941936, -2.266316, 3.912709>,
				<-0.053558, -0.389420, 0.913557>, <3.792790, -2.349377, 4.010124>
			}
			smooth_triangle {
				<-0.083699, -0.375420, 0.917153>, <3.941936, -2.266316, 3.912709>,
				<-0.111051, -0.393240, 0.906725>, <4.026321, -2.371527, 3.761617>,
				<-0.113859, -0.359580, 0.920242>, <4.093555, -2.168889, 3.811045>
			}
			smooth_triangle {
				<-0.080327, -0.412270, 0.901491>, <4.510776, -2.896737, 4.499130>,
				<-0.111051, -0.393240, 0.906725>, <4.026321, -2.371527, 3.761617>,
				<-0.083699, -0.375420, 0.917153>, <3.941936, -2.266316, 3.912709>
			}
			smooth_triangle {
				<-0.058794, -0.288750, 0.949882>, <3.957959, -1.739597, 4.158611>,
				<-0.054795, -0.251870, 0.960559>, <2.002515, -0.800850, 2.084980>,
				<-0.030410, -0.275410, 0.955161>, <1.938425, -0.853540, 2.124260>
			}
			smooth_triangle {
				<-0.119074, -0.291060, 0.943508>, <4.209242, -1.754032, 3.897418>,
				<-0.088063, -0.306940, 0.941884>, <4.059019, -1.851314, 4.010218>,
				<-0.116753, -0.325550, 0.932475>, <4.154704, -1.963410, 3.855893>
			}
			smooth_triangle {
				<-0.088346, -0.272410, 0.952421>, <4.100046, -1.643642, 4.058567>,
				<-0.054795, -0.251870, 0.960559>, <2.002515, -0.800850, 2.084980>,
				<-0.058794, -0.288750, 0.949882>, <3.957959, -1.739597, 4.158611>
			}
			smooth_triangle {
				<-0.088346, -0.272410, 0.952421>, <4.100046, -1.643642, 4.058567>,
				<-0.089315, -0.239770, 0.961067>, <1.371978, -0.514968, 1.360845>,
				<-0.054795, -0.251870, 0.960559>, <2.002515, -0.800850, 2.084980>
			}
			smooth_triangle {
				<-0.088346, -0.272410, 0.952421>, <4.100046, -1.643642, 4.058567>,
				<-0.119533, -0.255520, 0.953696>, <3.553080, -1.311528, 3.262680>,
				<-0.089315, -0.239770, 0.961067>, <1.371978, -0.514968, 1.360845>
			}
			smooth_triangle {
				<-0.088063, -0.306940, 0.941884>, <4.059019, -1.851314, 4.010218>,
				<-0.088346, -0.272410, 0.952421>, <4.100046, -1.643642, 4.058567>,
				<-0.058794, -0.288750, 0.949882>, <3.957959, -1.739597, 4.158611>
			}
			smooth_triangle {
				<-0.088346, -0.272410, 0.952421>, <4.100046, -1.643642, 4.058567>,
				<-0.119074, -0.291060, 0.943508>, <4.209242, -1.754032, 3.897418>,
				<-0.119533, -0.255520, 0.953696>, <3.553080, -1.311528, 3.262680>
			}
			smooth_triangle {
				<-0.088063, -0.306940, 0.941884>, <4.059019, -1.851314, 4.010218>,
				<-0.119074, -0.291060, 0.943508>, <4.209242, -1.754032, 3.897418>,
				<-0.088346, -0.272410, 0.952421>, <4.100046, -1.643642, 4.058567>
			}
			smooth_triangle {
				<-0.186252, -0.552541, 0.805685>, <2.014146, -1.653530, 1.485897>,
				<-0.193167, -0.570481, 0.791423>, <0.668236, -0.561888, 0.487588>,
				<-0.210881, -0.553261, 0.799094>, <4.099892, -3.296246, 2.884152>
			}
			smooth_triangle {
				<-0.227478, -0.496801, 0.830996>, <4.273849, -2.997182, 2.956681>,
				<-0.244598, -0.510551, 0.817687>, <4.300390, -3.079663, 2.830816>,
				<-0.251495, -0.485001, 0.831045>, <4.384693, -2.925214, 2.864978>
			}
			smooth_triangle {
				<-0.220432, -0.522791, 0.816834>, <4.185288, -3.156173, 2.917457>,
				<-0.244598, -0.510551, 0.817687>, <4.300390, -3.079663, 2.830816>,
				<-0.227478, -0.496801, 0.830996>, <4.273849, -2.997182, 2.956681>
			}
			smooth_triangle {
				<-0.220432, -0.522791, 0.816834>, <4.185288, -3.156173, 2.917457>,
				<-0.237896, -0.535681, 0.803474>, <4.213059, -3.229919, 2.794289>,
				<-0.244598, -0.510551, 0.817687>, <4.300390, -3.079663, 2.830816>
			}
			smooth_triangle {
				<-0.220432, -0.522791, 0.816834>, <4.185288, -3.156173, 2.917457>,
				<-0.210881, -0.553261, 0.799094>, <4.099892, -3.296246, 2.884152>,
				<-0.237896, -0.535681, 0.803474>, <4.213059, -3.229919, 2.794289>
			}
			smooth_triangle {
				<-0.210881, -0.553261, 0.799094>, <4.099892, -3.296246, 2.884152>,
				<-0.233621, -0.557061, 0.790070>, <4.148179, -3.352882, 2.746658>,
				<-0.237896, -0.535681, 0.803474>, <4.213059, -3.229919, 2.794289>
			}
			smooth_triangle {
				<-0.210881, -0.553261, 0.799094>, <4.099892, -3.296246, 2.884152>,
				<-0.219758, -0.562571, 0.790147>, <2.719195, -2.275886, 1.850482>,
				<-0.233621, -0.557061, 0.790070>, <4.148179, -3.352882, 2.746658>
			}
			smooth_triangle {
				<-0.175541, -0.536491, 0.818823>, <2.013419, -1.604356, 1.539946>,
				<-0.183066, -0.517151, 0.829550>, <4.065797, -3.118181, 3.120856>,
				<-0.166125, -0.525381, 0.827945>, <2.000798, -1.566998, 1.593791>
			}
			smooth_triangle {
				<-0.204392, -0.507851, 0.830318>, <4.165614, -3.062946, 3.042634>,
				<-0.220432, -0.522791, 0.816834>, <4.185288, -3.156173, 2.917457>,
				<-0.227478, -0.496801, 0.830996>, <4.273849, -2.997182, 2.956681>
			}
			smooth_triangle {
				<-0.204392, -0.507851, 0.830318>, <4.165614, -3.062946, 3.042634>,
				<-0.196850, -0.531801, 0.817044>, <4.081429, -3.208722, 3.006202>,
				<-0.220432, -0.522791, 0.816834>, <4.185288, -3.156173, 2.917457>
			}
			smooth_triangle {
				<-0.196850, -0.531801, 0.817044>, <4.081429, -3.208722, 3.006202>,
				<-0.183066, -0.517151, 0.829550>, <4.065797, -3.118181, 3.120856>,
				<-0.175541, -0.536491, 0.818823>, <2.013419, -1.604356, 1.539946>
			}
			smooth_triangle {
				<-0.196850, -0.531801, 0.817044>, <4.081429, -3.208722, 3.006202>,
				<-0.204392, -0.507851, 0.830318>, <4.165614, -3.062946, 3.042634>,
				<-0.183066, -0.517151, 0.829550>, <4.065797, -3.118181, 3.120856>
			}
			smooth_triangle {
				<-0.196850, -0.531801, 0.817044>, <4.081429, -3.208722, 3.006202>,
				<-0.210881, -0.553261, 0.799094>, <4.099892, -3.296246, 2.884152>,
				<-0.220432, -0.522791, 0.816834>, <4.185288, -3.156173, 2.917457>
			}
			smooth_triangle {
				<-0.196850, -0.531801, 0.817044>, <4.081429, -3.208722, 3.006202>,
				<-0.186252, -0.552541, 0.805685>, <2.014146, -1.653530, 1.485897>,
				<-0.210881, -0.553261, 0.799094>, <4.099892, -3.296246, 2.884152>
			}
			smooth_triangle {
				<-0.196850, -0.531801, 0.817044>, <4.081429, -3.208722, 3.006202>,
				<-0.175541, -0.536491, 0.818823>, <2.013419, -1.604356, 1.539946>,
				<-0.186252, -0.552541, 0.805685>, <2.014146, -1.653530, 1.485897>
			}
			smooth_triangle {
				<-0.219758, -0.562571, 0.790147>, <2.719195, -2.275886, 1.850482>,
				<-0.229336, -0.576411, 0.777349>, <2.732485, -2.292406, 1.810262>,
				<-0.233621, -0.557061, 0.790070>, <4.148179, -3.352882, 2.746658>
			}
			smooth_triangle {
				<-0.215508, -0.582381, 0.776855>, <1.348189, -1.151219, 0.925781>,
				<-0.219758, -0.562571, 0.790147>, <2.719195, -2.275886, 1.850482>,
				<-0.207077, -0.580091, 0.780851>, <0.673190, -0.575580, 0.464244>
			}
			smooth_triangle {
				<-0.219758, -0.562571, 0.790147>, <2.719195, -2.275886, 1.850482>,
				<-0.215508, -0.582381, 0.776855>, <1.348189, -1.151219, 0.925781>,
				<-0.229336, -0.576411, 0.777349>, <2.732485, -2.292406, 1.810262>
			}
			smooth_triangle {
				<-0.258485, -0.458191, 0.844012>, <4.467802, -2.762734, 2.897515>,
				<-0.285034, -0.445831, 0.842087>, <4.583202, -2.688523, 2.784638>,
				<-0.265105, -0.429641, 0.856877>, <4.547868, -2.590631, 2.931545>
			}
			smooth_triangle {
				<-0.258302, -0.580541, 0.765091>, <4.163770, -3.500763, 2.530121>,
				<-0.247752, -0.567451, 0.778286>, <4.166087, -3.419433, 2.635375>,
				<-0.239247, -0.582871, 0.769505>, <2.061853, -1.746246, 1.303369>
			}
			smooth_triangle {
				<-0.270011, -0.560821, 0.775686>, <4.259052, -3.379964, 2.535248>,
				<-0.247752, -0.567451, 0.778286>, <4.166087, -3.419433, 2.635375>,
				<-0.258302, -0.580541, 0.765091>, <4.163770, -3.500763, 2.530121>
			}
			smooth_triangle {
				<-0.270011, -0.560821, 0.775686>, <4.259052, -3.379964, 2.535248>,
				<-0.255684, -0.546541, 0.790582>, <4.249742, -3.295413, 2.659288>,
				<-0.247752, -0.567451, 0.778286>, <4.166087, -3.419433, 2.635375>
			}
			smooth_triangle {
				<-0.270011, -0.560821, 0.775686>, <4.259052, -3.379964, 2.535248>,
				<-0.282550, -0.534501, 0.789679>, <5.096125, -3.764007, 2.974439>,
				<-0.255684, -0.546541, 0.790582>, <4.249742, -3.295413, 2.659288>
			}
			smooth_triangle {
				<-0.282550, -0.534501, 0.789679>, <5.096125, -3.764007, 2.974439>,
				<-0.261785, -0.523101, 0.804329>, <4.326512, -3.157274, 2.702644>,
				<-0.255684, -0.546541, 0.790582>, <4.249742, -3.295413, 2.659288>
			}
			smooth_triangle {
				<-0.282550, -0.534501, 0.789679>, <5.096125, -3.764007, 2.974439>,
				<-0.281397, -0.511541, 0.805148>, <3.685749, -2.572872, 2.188545>,
				<-0.261785, -0.523101, 0.804329>, <4.326512, -3.157274, 2.702644>
			}
			smooth_triangle {
				<-0.237896, -0.535681, 0.803474>, <4.213059, -3.229919, 2.794289>,
				<-0.255684, -0.546541, 0.790582>, <4.249742, -3.295413, 2.659288>,
				<-0.261785, -0.523101, 0.804329>, <4.326512, -3.157274, 2.702644>
			}
			smooth_triangle {
				<-0.247752, -0.567451, 0.778286>, <4.166087, -3.419433, 2.635375>,
				<-0.229336, -0.576411, 0.777349>, <2.732485, -2.292406, 1.810262>,
				<-0.239247, -0.582871, 0.769505>, <2.061853, -1.746246, 1.303369>
			}
			smooth_triangle {
				<-0.247752, -0.567451, 0.778286>, <4.166087, -3.419433, 2.635375>,
				<-0.233621, -0.557061, 0.790070>, <4.148179, -3.352882, 2.746658>,
				<-0.229336, -0.576411, 0.777349>, <2.732485, -2.292406, 1.810262>
			}
			smooth_triangle {
				<-0.233621, -0.557061, 0.790070>, <4.148179, -3.352882, 2.746658>,
				<-0.255684, -0.546541, 0.790582>, <4.249742, -3.295413, 2.659288>,
				<-0.237896, -0.535681, 0.803474>, <4.213059, -3.229919, 2.794289>
			}
			smooth_triangle {
				<-0.233621, -0.557061, 0.790070>, <4.148179, -3.352882, 2.746658>,
				<-0.247752, -0.567451, 0.778286>, <4.166087, -3.419433, 2.635375>,
				<-0.255684, -0.546541, 0.790582>, <4.249742, -3.295413, 2.659288>
			}
			smooth_triangle {
				<-0.268002, -0.499181, 0.817378>, <4.407053, -3.009382, 2.740983>,
				<-0.261785, -0.523101, 0.804329>, <4.326512, -3.157274, 2.702644>,
				<-0.281397, -0.511541, 0.805148>, <3.685749, -2.572872, 2.188545>
			}
			smooth_triangle {
				<-0.261785, -0.523101, 0.804329>, <4.326512, -3.157274, 2.702644>,
				<-0.244598, -0.510551, 0.817687>, <4.300390, -3.079663, 2.830816>,
				<-0.237896, -0.535681, 0.803474>, <4.213059, -3.229919, 2.794289>
			}
			smooth_triangle {
				<-0.268002, -0.499181, 0.817378>, <4.407053, -3.009382, 2.740983>,
				<-0.244598, -0.510551, 0.817687>, <4.300390, -3.079663, 2.830816>,
				<-0.261785, -0.523101, 0.804329>, <4.326512, -3.157274, 2.702644>
			}
			smooth_triangle {
				<-0.302445, -0.510031, 0.798437>, <4.495858, -3.077454, 2.511223>,
				<-0.281397, -0.511541, 0.805148>, <3.685749, -2.572872, 2.188545>,
				<-0.282550, -0.534501, 0.789679>, <5.096125, -3.764007, 2.974439>
			}
			smooth_triangle {
				<-0.281397, -0.511541, 0.805148>, <3.685749, -2.572872, 2.188545>,
				<-0.291773, -0.490421, 0.814532>, <4.510181, -2.954815, 2.630224>,
				<-0.268002, -0.499181, 0.817378>, <4.407053, -3.009382, 2.740983>
			}
			smooth_triangle {
				<-0.302445, -0.510031, 0.798437>, <4.495858, -3.077454, 2.511223>,
				<-0.291773, -0.490421, 0.814532>, <4.510181, -2.954815, 2.630224>,
				<-0.281397, -0.511541, 0.805148>, <3.685749, -2.572872, 2.188545>
			}
			smooth_triangle {
				<-0.276444, -0.473801, 0.829580>, <4.495168, -2.856646, 2.760967>,
				<-0.268002, -0.499181, 0.817378>, <4.407053, -3.009382, 2.740983>,
				<-0.291773, -0.490421, 0.814532>, <4.510181, -2.954815, 2.630224>
			}
			smooth_triangle {
				<-0.268002, -0.499181, 0.817378>, <4.407053, -3.009382, 2.740983>,
				<-0.251495, -0.485001, 0.831045>, <4.384693, -2.925214, 2.864978>,
				<-0.244598, -0.510551, 0.817687>, <4.300390, -3.079663, 2.830816>
			}
			smooth_triangle {
				<-0.276444, -0.473801, 0.829580>, <4.495168, -2.856646, 2.760967>,
				<-0.251495, -0.485001, 0.831045>, <4.384693, -2.925214, 2.864978>,
				<-0.268002, -0.499181, 0.817378>, <4.407053, -3.009382, 2.740983>
			}
			smooth_triangle {
				<-0.318463, -0.483801, 0.808471>, <4.609184, -2.917010, 2.496760>,
				<-0.291773, -0.490421, 0.814532>, <4.510181, -2.954815, 2.630224>,
				<-0.302445, -0.510031, 0.798437>, <4.495858, -3.077454, 2.511223>
			}
			smooth_triangle {
				<-0.291773, -0.490421, 0.814532>, <4.510181, -2.954815, 2.630224>,
				<-0.303194, -0.463471, 0.826061>, <4.605908, -2.794499, 2.639029>,
				<-0.276444, -0.473801, 0.829580>, <4.495168, -2.856646, 2.760967>
			}
			smooth_triangle {
				<-0.318463, -0.483801, 0.808471>, <4.609184, -2.917010, 2.496760>,
				<-0.303194, -0.463471, 0.826061>, <4.605908, -2.794499, 2.639029>,
				<-0.291773, -0.490421, 0.814532>, <4.510181, -2.954815, 2.630224>
			}
			smooth_triangle {
				<-0.285034, -0.445831, 0.842087>, <4.583202, -2.688523, 2.784638>,
				<-0.276444, -0.473801, 0.829580>, <4.495168, -2.856646, 2.760967>,
				<-0.303194, -0.463471, 0.826061>, <4.605908, -2.794499, 2.639029>
			}
			smooth_triangle {
				<-0.276444, -0.473801, 0.829580>, <4.495168, -2.856646, 2.760967>,
				<-0.258485, -0.458191, 0.844012>, <4.467802, -2.762734, 2.897515>,
				<-0.251495, -0.485001, 0.831045>, <4.384693, -2.925214, 2.864978>
			}
			smooth_triangle {
				<-0.285034, -0.445831, 0.842087>, <4.583202, -2.688523, 2.784638>,
				<-0.258485, -0.458191, 0.844012>, <4.467802, -2.762734, 2.897515>,
				<-0.276444, -0.473801, 0.829580>, <4.495168, -2.856646, 2.760967>
			}
			smooth_triangle {
				<-0.333031, -0.453051, 0.820342>, <4.721951, -2.730999, 2.495723>,
				<-0.303194, -0.463471, 0.826061>, <4.605908, -2.794499, 2.639029>,
				<-0.318463, -0.483801, 0.808471>, <4.609184, -2.917010, 2.496760>
			}
			smooth_triangle {
				<-0.333031, -0.453051, 0.820342>, <4.721951, -2.730999, 2.495723>,
				<-0.313558, -0.432971, 0.838648>, <4.702811, -2.611790, 2.654863>,
				<-0.303194, -0.463471, 0.826061>, <4.605908, -2.794499, 2.639029>
			}
			smooth_triangle {
				<-0.342323, -0.387731, 0.849469>, <4.063206, -1.952216, 2.161365>,
				<-0.346309, -0.416311, 0.834186>, <5.639956, -2.934735, 2.925230>,
				<-0.367132, -0.384601, 0.840484>, <4.956380, -2.322358, 2.454967>
			}
			smooth_triangle {
				<-0.333031, -0.453051, 0.820342>, <4.721951, -2.730999, 2.495723>,
				<-0.346309, -0.416311, 0.834186>, <5.639956, -2.934735, 2.925230>,
				<-0.313558, -0.432971, 0.838648>, <4.702811, -2.611790, 2.654863>
			}
			smooth_triangle {
				<-0.346309, -0.416311, 0.834186>, <5.639956, -2.934735, 2.925230>,
				<-0.320140, -0.402171, 0.851402>, <4.778443, -2.429936, 2.692520>,
				<-0.313558, -0.432971, 0.838648>, <4.702811, -2.611790, 2.654863>
			}
			smooth_triangle {
				<-0.346309, -0.416311, 0.834186>, <5.639956, -2.934735, 2.925230>,
				<-0.342323, -0.387731, 0.849469>, <4.063206, -1.952216, 2.161365>,
				<-0.320140, -0.402171, 0.851402>, <4.778443, -2.429936, 2.692520>
			}
			smooth_triangle {
				<-0.351618, -0.361841, 0.857060>, <4.952925, -2.176966, 2.591694>,
				<-0.342323, -0.387731, 0.849469>, <4.063206, -1.952216, 2.161365>,
				<-0.367132, -0.384601, 0.840484>, <4.956380, -2.322358, 2.454967>
			}
			smooth_triangle {
				<-0.342323, -0.387731, 0.849469>, <4.063206, -1.952216, 2.161365>,
				<-0.325699, -0.373301, 0.862372>, <4.846546, -2.252415, 2.725281>,
				<-0.320140, -0.402171, 0.851402>, <4.778443, -2.429936, 2.692520>
			}
			smooth_triangle {
				<-0.351618, -0.361841, 0.857060>, <4.952925, -2.176966, 2.591694>,
				<-0.325699, -0.373301, 0.862372>, <4.846546, -2.252415, 2.725281>,
				<-0.342323, -0.387731, 0.849469>, <4.063206, -1.952216, 2.161365>
			}
			smooth_triangle {
				<-0.299326, -0.385841, 0.866390>, <4.741268, -2.327460, 2.844553>,
				<-0.320140, -0.402171, 0.851402>, <4.778443, -2.429936, 2.692520>,
				<-0.325699, -0.373301, 0.862372>, <4.846546, -2.252415, 2.725281>
			}
			smooth_triangle {
				<-0.313558, -0.432971, 0.838648>, <4.702811, -2.611790, 2.654863>,
				<-0.285034, -0.445831, 0.842087>, <4.583202, -2.688523, 2.784638>,
				<-0.303194, -0.463471, 0.826061>, <4.605908, -2.794499, 2.639029>
			}
			smooth_triangle {
				<-0.292602, -0.416121, 0.854599>, <4.665755, -2.509755, 2.814182>,
				<-0.271454, -0.399601, 0.869332>, <4.625178, -2.409658, 2.964614>,
				<-0.265105, -0.429641, 0.856877>, <4.547868, -2.590631, 2.931545>
			}
			smooth_triangle {
				<-0.292602, -0.416121, 0.854599>, <4.665755, -2.509755, 2.814182>,
				<-0.299326, -0.385841, 0.866390>, <4.741268, -2.327460, 2.844553>,
				<-0.271454, -0.399601, 0.869332>, <4.625178, -2.409658, 2.964614>
			}
			smooth_triangle {
				<-0.292602, -0.416121, 0.854599>, <4.665755, -2.509755, 2.814182>,
				<-0.320140, -0.402171, 0.851402>, <4.778443, -2.429936, 2.692520>,
				<-0.299326, -0.385841, 0.866390>, <4.741268, -2.327460, 2.844553>
			}
			smooth_triangle {
				<-0.285034, -0.445831, 0.842087>, <4.583202, -2.688523, 2.784638>,
				<-0.292602, -0.416121, 0.854599>, <4.665755, -2.509755, 2.814182>,
				<-0.265105, -0.429641, 0.856877>, <4.547868, -2.590631, 2.931545>
			}
			smooth_triangle {
				<-0.292602, -0.416121, 0.854599>, <4.665755, -2.509755, 2.814182>,
				<-0.313558, -0.432971, 0.838648>, <4.702811, -2.611790, 2.654863>,
				<-0.320140, -0.402171, 0.851402>, <4.778443, -2.429936, 2.692520>
			}
			smooth_triangle {
				<-0.285034, -0.445831, 0.842087>, <4.583202, -2.688523, 2.784638>,
				<-0.313558, -0.432971, 0.838648>, <4.702811, -2.611790, 2.654863>,
				<-0.292602, -0.416121, 0.854599>, <4.665755, -2.509755, 2.814182>
			}
			smooth_triangle {
				<-0.332905, -0.346751, 0.870664>, <4.097384, -1.736455, 2.277460>,
				<-0.325699, -0.373301, 0.862372>, <4.846546, -2.252415, 2.725281>,
				<-0.351618, -0.361841, 0.857060>, <4.952925, -2.176966, 2.591694>
			}
			smooth_triangle {
				<-0.299326, -0.385841, 0.866390>, <4.741268, -2.327460, 2.844553>,
				<-0.278087, -0.368341, 0.880968>, <4.700495, -2.221143, 2.993093>,
				<-0.271454, -0.399601, 0.869332>, <4.625178, -2.409658, 2.964614>
			}
			smooth_triangle {
				<-0.299326, -0.385841, 0.866390>, <4.741268, -2.327460, 2.844553>,
				<-0.307100, -0.354831, 0.876868>, <4.817755, -2.136875, 2.865252>,
				<-0.278087, -0.368341, 0.880968>, <4.700495, -2.221143, 2.993093>
			}
			smooth_triangle {
				<-0.307100, -0.354831, 0.876868>, <4.817755, -2.136875, 2.865252>,
				<-0.325699, -0.373301, 0.862372>, <4.846546, -2.252415, 2.725281>,
				<-0.332905, -0.346751, 0.870664>, <4.097384, -1.736455, 2.277460>
			}
			smooth_triangle {
				<-0.307100, -0.354831, 0.876868>, <4.817755, -2.136875, 2.865252>,
				<-0.299326, -0.385841, 0.866390>, <4.741268, -2.327460, 2.844553>,
				<-0.325699, -0.373301, 0.862372>, <4.846546, -2.252415, 2.725281>
			}
			smooth_triangle {
				<-0.381370, -0.353081, 0.847941>, <5.050411, -2.128298, 2.438778>,
				<-0.351618, -0.361841, 0.857060>, <4.952925, -2.176966, 2.591694>,
				<-0.367132, -0.384601, 0.840484>, <4.956380, -2.322358, 2.454967>
			}
			smooth_triangle {
				<-0.351618, -0.361841, 0.857060>, <4.952925, -2.176966, 2.591694>,
				<-0.359163, -0.324911, 0.868651>, <5.866055, -2.277860, 3.061626>,
				<-0.332905, -0.346751, 0.870664>, <4.097384, -1.736455, 2.277460>
			}
			smooth_triangle {
				<-0.381370, -0.353081, 0.847941>, <5.050411, -2.128298, 2.438778>,
				<-0.359163, -0.324911, 0.868651>, <5.866055, -2.277860, 3.061626>,
				<-0.351618, -0.361841, 0.857060>, <4.952925, -2.176966, 2.591694>
			}
			smooth_triangle {
				<-0.280517, -0.578881, 0.758498>, <4.239494, -3.491841, 2.413467>,
				<-0.270011, -0.560821, 0.775686>, <4.259052, -3.379964, 2.535248>,
				<-0.258302, -0.580541, 0.765091>, <4.163770, -3.500763, 2.530121>
			}
			smooth_triangle {
				<-0.367132, -0.384601, 0.840484>, <4.956380, -2.322358, 2.454967>,
				<-0.398558, -0.378031, 0.829075>, <5.056218, -2.278820, 2.286054>,
				<-0.381370, -0.353081, 0.847941>, <5.050411, -2.128298, 2.438778>
			}
			smooth_triangle {
				<-0.319477, -0.553801, 0.761804>, <4.430099, -3.340099, 2.282111>,
				<-0.294709, -0.556251, 0.769962>, <4.348349, -3.353600, 2.415583>,
				<-0.303873, -0.576561, 0.751231>, <4.316312, -3.476976, 2.295830>
			}
			smooth_triangle {
				<-0.336404, -0.530181, 0.771269>, <4.544745, -3.197242, 2.261040>,
				<-0.310906, -0.532091, 0.780590>, <4.463109, -3.209098, 2.402382>,
				<-0.319477, -0.553801, 0.761804>, <4.430099, -3.340099, 2.282111>
			}
			smooth_triangle {
				<-0.346309, -0.416311, 0.834186>, <5.639956, -2.934735, 2.925230>,
				<-0.381348, -0.409781, 0.822049>, <4.947704, -2.473190, 2.321165>,
				<-0.367132, -0.384601, 0.840484>, <4.956380, -2.322358, 2.454967>
			}
			smooth_triangle {
				<-0.328996, -0.506901, 0.789882>, <4.584461, -3.055181, 2.374168>,
				<-0.318463, -0.483801, 0.808471>, <4.609184, -2.917010, 2.496760>,
				<-0.302445, -0.510031, 0.798437>, <4.495858, -3.077454, 2.511223>
			}
			smooth_triangle {
				<-0.333031, -0.453051, 0.820342>, <4.721951, -2.730999, 2.495723>,
				<-0.364926, -0.442601, 0.812434>, <4.834676, -2.668963, 2.342241>,
				<-0.346309, -0.416311, 0.834186>, <5.639956, -2.934735, 2.925230>
			}
			smooth_triangle {
				<-0.350470, -0.477921, 0.798672>, <5.500793, -3.360413, 2.725698>,
				<-0.333031, -0.453051, 0.820342>, <4.721951, -2.730999, 2.495723>,
				<-0.318463, -0.483801, 0.808471>, <4.609184, -2.917010, 2.496760>
			}
			smooth_triangle {
				<-0.333031, -0.453051, 0.820342>, <4.721951, -2.730999, 2.495723>,
				<-0.350470, -0.477921, 0.798672>, <5.500793, -3.360413, 2.725698>,
				<-0.364926, -0.442601, 0.812434>, <4.834676, -2.668963, 2.342241>
			}
			smooth_triangle {
				<-0.350470, -0.477921, 0.798672>, <5.500793, -3.360413, 2.725698>,
				<-0.380757, -0.463731, 0.793148>, <4.835310, -2.792300, 2.193339>,
				<-0.364926, -0.442601, 0.812434>, <4.834676, -2.668963, 2.342241>
			}
			smooth_triangle {
				<-0.350470, -0.477921, 0.798672>, <5.500793, -3.360413, 2.725698>,
				<-0.371184, -0.487661, 0.783274>, <3.959539, -2.449421, 1.820960>,
				<-0.380757, -0.463731, 0.793148>, <4.835310, -2.792300, 2.193339>
			}
			smooth_triangle {
				<-0.328996, -0.506901, 0.789882>, <4.584461, -3.055181, 2.374168>,
				<-0.350470, -0.477921, 0.798672>, <5.500793, -3.360413, 2.725698>,
				<-0.318463, -0.483801, 0.808471>, <4.609184, -2.917010, 2.496760>
			}
			smooth_triangle {
				<-0.350470, -0.477921, 0.798672>, <5.500793, -3.360413, 2.725698>,
				<-0.354277, -0.506491, 0.779139>, <4.655361, -3.054795, 2.232840>,
				<-0.371184, -0.487661, 0.783274>, <3.959539, -2.449421, 1.820960>
			}
			smooth_triangle {
				<-0.328996, -0.506901, 0.789882>, <4.584461, -3.055181, 2.374168>,
				<-0.354277, -0.506491, 0.779139>, <4.655361, -3.054795, 2.232840>,
				<-0.350470, -0.477921, 0.798672>, <5.500793, -3.360413, 2.725698>
			}
			smooth_triangle {
				<-0.396122, -0.433751, 0.802529>, <4.942079, -2.614821, 2.173578>,
				<-0.364926, -0.442601, 0.812434>, <4.834676, -2.668963, 2.342241>,
				<-0.380757, -0.463731, 0.793148>, <4.835310, -2.792300, 2.193339>
			}
			smooth_triangle {
				<-0.364926, -0.442601, 0.812434>, <4.834676, -2.668963, 2.342241>,
				<-0.381348, -0.409781, 0.822049>, <4.947704, -2.473190, 2.321165>,
				<-0.346309, -0.416311, 0.834186>, <5.639956, -2.934735, 2.925230>
			}
			smooth_triangle {
				<-0.396122, -0.433751, 0.802529>, <4.942079, -2.614821, 2.173578>,
				<-0.381348, -0.409781, 0.822049>, <4.947704, -2.473190, 2.321165>,
				<-0.364926, -0.442601, 0.812434>, <4.834676, -2.668963, 2.342241>
			}
			smooth_triangle {
				<-0.310906, -0.532091, 0.780590>, <4.463109, -3.209098, 2.402382>,
				<-0.328996, -0.506901, 0.789882>, <4.584461, -3.055181, 2.374168>,
				<-0.302445, -0.510031, 0.798437>, <4.495858, -3.077454, 2.511223>
			}
			smooth_triangle {
				<-0.328996, -0.506901, 0.789882>, <4.584461, -3.055181, 2.374168>,
				<-0.336404, -0.530181, 0.771269>, <4.544745, -3.197242, 2.261040>,
				<-0.354277, -0.506491, 0.779139>, <4.655361, -3.054795, 2.232840>
			}
			smooth_triangle {
				<-0.310906, -0.532091, 0.780590>, <4.463109, -3.209098, 2.402382>,
				<-0.336404, -0.530181, 0.771269>, <4.544745, -3.197242, 2.261040>,
				<-0.328996, -0.506901, 0.789882>, <4.584461, -3.055181, 2.374168>
			}
			smooth_triangle {
				<-0.413512, -0.402531, 0.809993>, <5.050954, -2.429360, 2.137951>,
				<-0.381348, -0.409781, 0.822049>, <4.947704, -2.473190, 2.321165>,
				<-0.396122, -0.433751, 0.802529>, <4.942079, -2.614821, 2.173578>
			}
			smooth_triangle {
				<-0.381348, -0.409781, 0.822049>, <4.947704, -2.473190, 2.321165>,
				<-0.398558, -0.378031, 0.829075>, <5.056218, -2.278820, 2.286054>,
				<-0.367132, -0.384601, 0.840484>, <4.956380, -2.322358, 2.454967>
			}
			smooth_triangle {
				<-0.413512, -0.402531, 0.809993>, <5.050954, -2.429360, 2.137951>,
				<-0.398558, -0.378031, 0.829075>, <5.056218, -2.278820, 2.286054>,
				<-0.381348, -0.409781, 0.822049>, <4.947704, -2.473190, 2.321165>
			}
			smooth_triangle {
				<-0.282550, -0.534501, 0.789679>, <5.096125, -3.764007, 2.974439>,
				<-0.310906, -0.532091, 0.780590>, <4.463109, -3.209098, 2.402382>,
				<-0.302445, -0.510031, 0.798437>, <4.495858, -3.077454, 2.511223>
			}
			smooth_triangle {
				<-0.310906, -0.532091, 0.780590>, <4.463109, -3.209098, 2.402382>,
				<-0.294709, -0.556251, 0.769962>, <4.348349, -3.353600, 2.415583>,
				<-0.319477, -0.553801, 0.761804>, <4.430099, -3.340099, 2.282111>
			}
			smooth_triangle {
				<-0.282550, -0.534501, 0.789679>, <5.096125, -3.764007, 2.974439>,
				<-0.294709, -0.556251, 0.769962>, <4.348349, -3.353600, 2.415583>,
				<-0.310906, -0.532091, 0.780590>, <4.463109, -3.209098, 2.402382>
			}
			smooth_triangle {
				<-0.270011, -0.560821, 0.775686>, <4.259052, -3.379964, 2.535248>,
				<-0.294709, -0.556251, 0.769962>, <4.348349, -3.353600, 2.415583>,
				<-0.282550, -0.534501, 0.789679>, <5.096125, -3.764007, 2.974439>
			}
			smooth_triangle {
				<-0.294709, -0.556251, 0.769962>, <4.348349, -3.353600, 2.415583>,
				<-0.280517, -0.578881, 0.758498>, <4.239494, -3.491841, 2.413467>,
				<-0.303873, -0.576561, 0.751231>, <4.316312, -3.476976, 2.295830>
			}
			smooth_triangle {
				<-0.270011, -0.560821, 0.775686>, <4.259052, -3.379964, 2.535248>,
				<-0.280517, -0.578881, 0.758498>, <4.239494, -3.491841, 2.413467>,
				<-0.294709, -0.556251, 0.769962>, <4.348349, -3.353600, 2.415583>
			}
			smooth_triangle {
				<-0.429071, -0.372692, 0.816156>, <2.554579, -1.146251, 1.076030>,
				<-0.398558, -0.378031, 0.829075>, <5.056218, -2.278820, 2.286054>,
				<-0.413512, -0.402531, 0.809993>, <5.050954, -2.429360, 2.137951>
			}
			smooth_triangle {
				<-0.381370, -0.353081, 0.847941>, <5.050411, -2.128298, 2.438778>,
				<-0.392716, -0.323711, 0.854458>, <2.546655, -0.993905, 1.234288>,
				<-0.359163, -0.324911, 0.868651>, <5.866055, -2.277860, 3.061626>
			}
			smooth_triangle {
				<-0.381370, -0.353081, 0.847941>, <5.050411, -2.128298, 2.438778>,
				<-0.417368, -0.344651, 0.834350>, <2.556289, -1.069188, 1.149135>,
				<-0.392716, -0.323711, 0.854458>, <2.546655, -0.993905, 1.234288>
			}
			smooth_triangle {
				<-0.417368, -0.344651, 0.834350>, <2.556289, -1.069188, 1.149135>,
				<-0.398558, -0.378031, 0.829075>, <5.056218, -2.278820, 2.286054>,
				<-0.429071, -0.372692, 0.816156>, <2.554579, -1.146251, 1.076030>
			}
			smooth_triangle {
				<-0.417368, -0.344651, 0.834350>, <2.556289, -1.069188, 1.149135>,
				<-0.381370, -0.353081, 0.847941>, <5.050411, -2.128298, 2.438778>,
				<-0.398558, -0.378031, 0.829075>, <5.056218, -2.278820, 2.286054>
			}
			smooth_triangle {
				<-0.343429, -0.551951, 0.752675>, <4.505093, -3.329702, 2.146455>,
				<-0.336404, -0.530181, 0.771269>, <4.544745, -3.197242, 2.261040>,
				<-0.319477, -0.553801, 0.761804>, <4.430099, -3.340099, 2.282111>
			}
			smooth_triangle {
				<-0.413512, -0.402531, 0.809993>, <5.050954, -2.429360, 2.137951>,
				<-0.447755, -0.393612, 0.796052>, <2.552024, -1.217555, 1.001602>,
				<-0.429071, -0.372692, 0.816156>, <2.554579, -1.146251, 1.076030>
			}
			smooth_triangle {
				<-0.430971, -0.527002, 0.725014>, <2.400723, -1.572290, 0.873672>,
				<-0.406899, -0.526212, 0.739357>, <4.748245, -3.172700, 1.838048>,
				<-0.411912, -0.546792, 0.721436>, <2.349702, -1.636352, 0.894323>
			}
			smooth_triangle {
				<-0.445115, -0.502472, 0.733827>, <2.449945, -1.501074, 0.861941>,
				<-0.423576, -0.502862, 0.746210>, <4.850882, -3.033422, 1.804572>,
				<-0.430971, -0.527002, 0.725014>, <2.400723, -1.572290, 0.873672>
			}
			smooth_triangle {
				<-0.426666, -0.426462, 0.790693>, <5.038158, -2.570252, 1.998964>,
				<-0.457864, -0.420112, 0.776521>, <2.539309, -1.290479, 0.940741>,
				<-0.447755, -0.393612, 0.796052>, <2.552024, -1.217555, 1.001602>
			}
			smooth_triangle {
				<-0.435001, -0.451472, 0.772048>, <5.004573, -2.720516, 1.881467>,
				<-0.457864, -0.420112, 0.776521>, <2.539309, -1.290479, 0.940741>,
				<-0.426666, -0.426462, 0.790693>, <5.038158, -2.570252, 1.998964>
			}
			smooth_triangle {
				<-0.435001, -0.451472, 0.772048>, <5.004573, -2.720516, 1.881467>,
				<-0.459196, -0.448602, 0.759611>, <2.515265, -1.370103, 0.891287>,
				<-0.457864, -0.420112, 0.776521>, <2.539309, -1.290479, 0.940741>
			}
			smooth_triangle {
				<-0.439926, -0.476972, 0.753702>, <4.955411, -2.876211, 1.777704>,
				<-0.459196, -0.448602, 0.759611>, <2.515265, -1.370103, 0.891287>,
				<-0.435001, -0.451472, 0.772048>, <5.004573, -2.720516, 1.881467>
			}
			smooth_triangle {
				<-0.439926, -0.476972, 0.753702>, <4.955411, -2.876211, 1.777704>,
				<-0.458579, -0.476222, 0.742984>, <1.659725, -0.957521, 0.572470>,
				<-0.459196, -0.448602, 0.759611>, <2.515265, -1.370103, 0.891287>
			}
			smooth_triangle {
				<-0.408200, -0.456451, 0.783670>, <4.925767, -2.750638, 2.039208>,
				<-0.435001, -0.451472, 0.772048>, <5.004573, -2.720516, 1.881467>,
				<-0.426666, -0.426462, 0.790693>, <5.038158, -2.570252, 1.998964>
			}
			smooth_triangle {
				<-0.435001, -0.451472, 0.772048>, <5.004573, -2.720516, 1.881467>,
				<-0.416796, -0.479352, 0.765258>, <4.894054, -2.890236, 1.919270>,
				<-0.439926, -0.476972, 0.753702>, <4.955411, -2.876211, 1.777704>
			}
			smooth_triangle {
				<-0.408200, -0.456451, 0.783670>, <4.925767, -2.750638, 2.039208>,
				<-0.416796, -0.479352, 0.765258>, <4.894054, -2.890236, 1.919270>,
				<-0.435001, -0.451472, 0.772048>, <5.004573, -2.720516, 1.881467>
			}
			smooth_triangle {
				<-0.423576, -0.502862, 0.746210>, <4.850882, -3.033422, 1.804572>,
				<-0.439926, -0.476972, 0.753702>, <4.955411, -2.876211, 1.777704>,
				<-0.416796, -0.479352, 0.765258>, <4.894054, -2.890236, 1.919270>
			}
			smooth_triangle {
				<-0.439926, -0.476972, 0.753702>, <4.955411, -2.876211, 1.777704>,
				<-0.445115, -0.502472, 0.733827>, <2.449945, -1.501074, 0.861941>,
				<-0.458579, -0.476222, 0.742984>, <1.659725, -0.957521, 0.572470>
			}
			smooth_triangle {
				<-0.423576, -0.502862, 0.746210>, <4.850882, -3.033422, 1.804572>,
				<-0.445115, -0.502472, 0.733827>, <2.449945, -1.501074, 0.861941>,
				<-0.439926, -0.476972, 0.753702>, <4.955411, -2.876211, 1.777704>
			}
			smooth_triangle {
				<-0.413512, -0.402531, 0.809993>, <5.050954, -2.429360, 2.137951>,
				<-0.426666, -0.426462, 0.790693>, <5.038158, -2.570252, 1.998964>,
				<-0.447755, -0.393612, 0.796052>, <2.552024, -1.217555, 1.001602>
			}
			smooth_triangle {
				<-0.426666, -0.426462, 0.790693>, <5.038158, -2.570252, 1.998964>,
				<-0.396122, -0.433751, 0.802529>, <4.942079, -2.614821, 2.173578>,
				<-0.408200, -0.456451, 0.783670>, <4.925767, -2.750638, 2.039208>
			}
			smooth_triangle {
				<-0.413512, -0.402531, 0.809993>, <5.050954, -2.429360, 2.137951>,
				<-0.396122, -0.433751, 0.802529>, <4.942079, -2.614821, 2.173578>,
				<-0.426666, -0.426462, 0.790693>, <5.038158, -2.570252, 1.998964>
			}
			smooth_triangle {
				<-0.380757, -0.463731, 0.793148>, <4.835310, -2.792300, 2.193339>,
				<-0.408200, -0.456451, 0.783670>, <4.925767, -2.750638, 2.039208>,
				<-0.396122, -0.433751, 0.802529>, <4.942079, -2.614821, 2.173578>
			}
			smooth_triangle {
				<-0.423576, -0.502862, 0.746210>, <4.850882, -3.033422, 1.804572>,
				<-0.406899, -0.526212, 0.739357>, <4.748245, -3.172700, 1.838048>,
				<-0.430971, -0.527002, 0.725014>, <2.400723, -1.572290, 0.873672>
			}
			smooth_triangle {
				<-0.423576, -0.502862, 0.746210>, <4.850882, -3.033422, 1.804572>,
				<-0.400319, -0.504371, 0.757933>, <4.789407, -3.042084, 1.948752>,
				<-0.406899, -0.526212, 0.739357>, <4.748245, -3.172700, 1.838048>
			}
			smooth_triangle {
				<-0.392582, -0.483121, 0.775617>, <4.823612, -2.912325, 2.059494>,
				<-0.408200, -0.456451, 0.783670>, <4.925767, -2.750638, 2.039208>,
				<-0.380757, -0.463731, 0.793148>, <4.835310, -2.792300, 2.193339>
			}
			smooth_triangle {
				<-0.392582, -0.483121, 0.775617>, <4.823612, -2.912325, 2.059494>,
				<-0.416796, -0.479352, 0.765258>, <4.894054, -2.890236, 1.919270>,
				<-0.408200, -0.456451, 0.783670>, <4.925767, -2.750638, 2.039208>
			}
			smooth_triangle {
				<-0.416796, -0.479352, 0.765258>, <4.894054, -2.890236, 1.919270>,
				<-0.400319, -0.504371, 0.757933>, <4.789407, -3.042084, 1.948752>,
				<-0.423576, -0.502862, 0.746210>, <4.850882, -3.033422, 1.804572>
			}
			smooth_triangle {
				<-0.392582, -0.483121, 0.775617>, <4.823612, -2.912325, 2.059494>,
				<-0.400319, -0.504371, 0.757933>, <4.789407, -3.042084, 1.948752>,
				<-0.416796, -0.479352, 0.765258>, <4.894054, -2.890236, 1.919270>
			}
			smooth_triangle {
				<-0.371184, -0.487661, 0.783274>, <3.959539, -2.449421, 1.820960>,
				<-0.392582, -0.483121, 0.775617>, <4.823612, -2.912325, 2.059494>,
				<-0.380757, -0.463731, 0.793148>, <4.835310, -2.792300, 2.193339>
			}
			smooth_triangle {
				<-0.406899, -0.526212, 0.739357>, <4.748245, -3.172700, 1.838048>,
				<-0.389702, -0.548061, 0.732720>, <4.641632, -3.305606, 1.875961>,
				<-0.411912, -0.546792, 0.721436>, <2.349702, -1.636352, 0.894323>
			}
			smooth_triangle {
				<-0.406899, -0.526212, 0.739357>, <4.748245, -3.172700, 1.838048>,
				<-0.383742, -0.527461, 0.750759>, <4.684101, -3.181944, 1.981173>,
				<-0.389702, -0.548061, 0.732720>, <4.641632, -3.305606, 1.875961>
			}
			smooth_triangle {
				<-0.377244, -0.506451, 0.768321>, <4.721915, -3.056487, 2.086183>,
				<-0.392582, -0.483121, 0.775617>, <4.823612, -2.912325, 2.059494>,
				<-0.371184, -0.487661, 0.783274>, <3.959539, -2.449421, 1.820960>
			}
			smooth_triangle {
				<-0.377244, -0.506451, 0.768321>, <4.721915, -3.056487, 2.086183>,
				<-0.400319, -0.504371, 0.757933>, <4.789407, -3.042084, 1.948752>,
				<-0.392582, -0.483121, 0.775617>, <4.823612, -2.912325, 2.059494>
			}
			smooth_triangle {
				<-0.400319, -0.504371, 0.757933>, <4.789407, -3.042084, 1.948752>,
				<-0.383742, -0.527461, 0.750759>, <4.684101, -3.181944, 1.981173>,
				<-0.406899, -0.526212, 0.739357>, <4.748245, -3.172700, 1.838048>
			}
			smooth_triangle {
				<-0.377244, -0.506451, 0.768321>, <4.721915, -3.056487, 2.086183>,
				<-0.383742, -0.527461, 0.750759>, <4.684101, -3.181944, 1.981173>,
				<-0.400319, -0.504371, 0.757933>, <4.789407, -3.042084, 1.948752>
			}
			smooth_triangle {
				<-0.354277, -0.506491, 0.779139>, <4.655361, -3.054795, 2.232840>,
				<-0.377244, -0.506451, 0.768321>, <4.721915, -3.056487, 2.086183>,
				<-0.371184, -0.487661, 0.783274>, <3.959539, -2.449421, 1.820960>
			}
			smooth_triangle {
				<-0.383742, -0.527461, 0.750759>, <4.684101, -3.181944, 1.981173>,
				<-0.366842, -0.550021, 0.742975>, <4.575233, -3.317954, 2.012235>,
				<-0.389702, -0.548061, 0.732720>, <4.641632, -3.305606, 1.875961>
			}
			smooth_triangle {
				<-0.360481, -0.528881, 0.761213>, <4.616447, -3.190740, 2.120866>,
				<-0.336404, -0.530181, 0.771269>, <4.544745, -3.197242, 2.261040>,
				<-0.343429, -0.551951, 0.752675>, <4.505093, -3.329702, 2.146455>
			}
			smooth_triangle {
				<-0.360481, -0.528881, 0.761213>, <4.616447, -3.190740, 2.120866>,
				<-0.354277, -0.506491, 0.779139>, <4.655361, -3.054795, 2.232840>,
				<-0.336404, -0.530181, 0.771269>, <4.544745, -3.197242, 2.261040>
			}
			smooth_triangle {
				<-0.360481, -0.528881, 0.761213>, <4.616447, -3.190740, 2.120866>,
				<-0.377244, -0.506451, 0.768321>, <4.721915, -3.056487, 2.086183>,
				<-0.354277, -0.506491, 0.779139>, <4.655361, -3.054795, 2.232840>
			}
			smooth_triangle {
				<-0.366842, -0.550021, 0.742975>, <4.575233, -3.317954, 2.012235>,
				<-0.360481, -0.528881, 0.761213>, <4.616447, -3.190740, 2.120866>,
				<-0.343429, -0.551951, 0.752675>, <4.505093, -3.329702, 2.146455>
			}
			smooth_triangle {
				<-0.360481, -0.528881, 0.761213>, <4.616447, -3.190740, 2.120866>,
				<-0.383742, -0.527461, 0.750759>, <4.684101, -3.181944, 1.981173>,
				<-0.377244, -0.506451, 0.768321>, <4.721915, -3.056487, 2.086183>
			}
			smooth_triangle {
				<-0.366842, -0.550021, 0.742975>, <4.575233, -3.317954, 2.012235>,
				<-0.383742, -0.527461, 0.750759>, <4.684101, -3.181944, 1.981173>,
				<-0.360481, -0.528881, 0.761213>, <4.616447, -3.190740, 2.120866>
			}
			smooth_triangle {
				<-0.389702, -0.548061, 0.732720>, <4.641632, -3.305606, 1.875961>,
				<-0.394912, -0.567252, 0.715108>, <2.296722, -1.700950, 0.911317>,
				<-0.411912, -0.546792, 0.721436>, <2.349702, -1.636352, 0.894323>
			}
			smooth_triangle {
				<-0.389702, -0.548061, 0.732720>, <4.641632, -3.305606, 1.875961>,
				<-0.372976, -0.569891, 0.724729>, <4.532958, -3.437447, 1.904534>,
				<-0.394912, -0.567252, 0.715108>, <2.296722, -1.700950, 0.911317>
			}
			smooth_triangle {
				<-0.326690, -0.574861, 0.742910>, <4.392554, -3.466999, 2.162359>,
				<-0.319477, -0.553801, 0.761804>, <4.430099, -3.340099, 2.282111>,
				<-0.303873, -0.576561, 0.751231>, <4.316312, -3.476976, 2.295830>
			}
			smooth_triangle {
				<-0.326690, -0.574861, 0.742910>, <4.392554, -3.466999, 2.162359>,
				<-0.343429, -0.551951, 0.752675>, <4.505093, -3.329702, 2.146455>,
				<-0.319477, -0.553801, 0.761804>, <4.430099, -3.340099, 2.282111>
			}
			smooth_triangle {
				<-0.366842, -0.550021, 0.742975>, <4.575233, -3.317954, 2.012235>,
				<-0.372976, -0.569891, 0.724729>, <4.532958, -3.437447, 1.904534>,
				<-0.389702, -0.548061, 0.732720>, <4.641632, -3.305606, 1.875961>
			}
			smooth_triangle {
				<-0.366842, -0.550021, 0.742975>, <4.575233, -3.317954, 2.012235>,
				<-0.349775, -0.573111, 0.733693>, <4.459176, -3.458322, 2.036119>,
				<-0.372976, -0.569891, 0.724729>, <4.532958, -3.437447, 1.904534>
			}
			smooth_triangle {
				<-0.349775, -0.573111, 0.733693>, <4.459176, -3.458322, 2.036119>,
				<-0.343429, -0.551951, 0.752675>, <4.505093, -3.329702, 2.146455>,
				<-0.326690, -0.574861, 0.742910>, <4.392554, -3.466999, 2.162359>
			}
			smooth_triangle {
				<-0.366842, -0.550021, 0.742975>, <4.575233, -3.317954, 2.012235>,
				<-0.343429, -0.551951, 0.752675>, <4.505093, -3.329702, 2.146455>,
				<-0.349775, -0.573111, 0.733693>, <4.459176, -3.458322, 2.036119>
			}
			smooth_triangle {
				<-0.307100, -0.354831, 0.876868>, <4.817755, -2.136875, 2.865252>,
				<-0.285510, -0.335671, 0.891583>, <4.777376, -2.024525, 3.010532>,
				<-0.278087, -0.368341, 0.880968>, <4.700495, -2.221143, 2.993093>
			}
			smooth_triangle {
				<-0.320115, -0.318351, 0.886171>, <5.738974, -2.236048, 3.322438>,
				<-0.359163, -0.324911, 0.868651>, <5.866055, -2.277860, 3.061626>,
				<-0.348498, -0.278721, 0.888813>, <5.898124, -1.965136, 3.212292>
			}
			smooth_triangle {
				<-0.320115, -0.318351, 0.886171>, <5.738974, -2.236048, 3.322438>,
				<-0.332905, -0.346751, 0.870664>, <4.097384, -1.736455, 2.277460>,
				<-0.359163, -0.324911, 0.868651>, <5.866055, -2.277860, 3.061626>
			}
			smooth_triangle {
				<-0.315070, -0.282891, 0.899900>, <2.484305, -0.870945, 1.437484>,
				<-0.320115, -0.318351, 0.886171>, <5.738974, -2.236048, 3.322438>,
				<-0.348498, -0.278721, 0.888813>, <5.898124, -1.965136, 3.212292>
			}
			smooth_triangle {
				<-0.315070, -0.282891, 0.899900>, <2.484305, -0.870945, 1.437484>,
				<-0.290720, -0.303671, 0.901320>, <3.218518, -1.250081, 2.018113>,
				<-0.320115, -0.318351, 0.886171>, <5.738974, -2.236048, 3.322438>
			}
			smooth_triangle {
				<-0.359163, -0.324911, 0.868651>, <5.866055, -2.277860, 3.061626>,
				<-0.384498, -0.290781, 0.869898>, <2.549757, -0.891090, 1.304503>,
				<-0.348498, -0.278721, 0.888813>, <5.898124, -1.965136, 3.212292>
			}
			smooth_triangle {
				<-0.392716, -0.323711, 0.854458>, <2.546655, -0.993905, 1.234288>,
				<-0.384498, -0.290781, 0.869898>, <2.549757, -0.891090, 1.304503>,
				<-0.359163, -0.324911, 0.868651>, <5.866055, -2.277860, 3.061626>
			}
			smooth_triangle {
				<-0.285510, -0.335671, 0.891583>, <4.777376, -2.024525, 3.010532>,
				<-0.320115, -0.318351, 0.886171>, <5.738974, -2.236048, 3.322438>,
				<-0.290720, -0.303671, 0.901320>, <3.218518, -1.250081, 2.018113>
			}
			smooth_triangle {
				<-0.320115, -0.318351, 0.886171>, <5.738974, -2.236048, 3.322438>,
				<-0.307100, -0.354831, 0.876868>, <4.817755, -2.136875, 2.865252>,
				<-0.332905, -0.346751, 0.870664>, <4.097384, -1.736455, 2.277460>
			}
			smooth_triangle {
				<-0.285510, -0.335671, 0.891583>, <4.777376, -2.024525, 3.010532>,
				<-0.307100, -0.354831, 0.876868>, <4.817755, -2.136875, 2.865252>,
				<-0.320115, -0.318351, 0.886171>, <5.738974, -2.236048, 3.322438>
			}
			smooth_triangle {
				<-0.378610, -0.252841, 0.884212>, <1.706306, -0.533631, 0.896130>,
				<-0.348498, -0.278721, 0.888813>, <5.898124, -1.965136, 3.212292>,
				<-0.384498, -0.290781, 0.869898>, <2.549757, -0.891090, 1.304503>
			}
			smooth_triangle {
				<-0.315070, -0.282891, 0.899900>, <2.484305, -0.870945, 1.437484>,
				<-0.348498, -0.278721, 0.888813>, <5.898124, -1.965136, 3.212292>,
				<-0.322962, -0.247421, 0.907514>, <2.527197, -0.755515, 1.428235>
			}
			smooth_triangle {
				<-0.348498, -0.278721, 0.888813>, <5.898124, -1.965136, 3.212292>,
				<-0.356460, -0.232631, 0.898848>, <3.395761, -0.961206, 1.881127>,
				<-0.322962, -0.247421, 0.907514>, <2.527197, -0.755515, 1.428235>
			}
			smooth_triangle {
				<-0.348498, -0.278721, 0.888813>, <5.898124, -1.965136, 3.212292>,
				<-0.378610, -0.252841, 0.884212>, <1.706306, -0.533631, 0.896130>,
				<-0.356460, -0.232631, 0.898848>, <3.395761, -0.961206, 1.881127>
			}
			smooth_triangle {
				<-0.356460, -0.232631, 0.898848>, <3.395761, -0.961206, 1.881127>,
				<-0.328670, -0.210201, 0.914823>, <1.698929, -0.447558, 0.955509>,
				<-0.322962, -0.247421, 0.907514>, <2.527197, -0.755515, 1.428235>
			}
			smooth_triangle {
				<-0.356460, -0.232631, 0.898848>, <3.395761, -0.961206, 1.881127>,
				<-0.348995, -0.194711, 0.910716>, <0.853543, -0.216574, 0.473878>,
				<-0.328670, -0.210201, 0.914823>, <1.698929, -0.447558, 0.955509>
			}
			smooth_triangle {
				<-0.289450, -0.600761, 0.737849>, <4.900234, -4.225850, 2.667779>,
				<-0.303873, -0.576561, 0.751231>, <4.316312, -3.476976, 2.295830>,
				<-0.280517, -0.578881, 0.758498>, <4.239494, -3.491841, 2.413467>
			}
			smooth_triangle {
				<-0.349775, -0.573111, 0.733693>, <4.459176, -3.458322, 2.036119>,
				<-0.356873, -0.592021, 0.715029>, <4.421080, -3.569811, 1.923950>,
				<-0.372976, -0.569891, 0.724729>, <4.532958, -3.437447, 1.904534>
			}
			smooth_triangle {
				<-0.330992, -0.598961, 0.721665>, <5.049235, -4.214909, 2.392717>,
				<-0.343026, -0.612191, 0.704741>, <2.167733, -1.827549, 0.979487>,
				<-0.356873, -0.592021, 0.715029>, <4.421080, -3.569811, 1.923950>
			}
			smooth_triangle {
				<-0.306550, -0.617851, 0.716521>, <2.821702, -2.449609, 1.426423>,
				<-0.311651, -0.593921, 0.734338>, <3.572048, -2.987132, 1.819556>,
				<-0.289450, -0.600761, 0.737849>, <4.900234, -4.225850, 2.667779>
			}
			smooth_triangle {
				<-0.343026, -0.612191, 0.704741>, <2.167733, -1.827549, 0.979487>,
				<-0.330992, -0.598961, 0.721665>, <5.049235, -4.214909, 2.392717>,
				<-0.321353, -0.627441, 0.701541>, <1.421589, -1.233352, 0.676699>
			}
			smooth_triangle {
				<-0.330992, -0.598961, 0.721665>, <5.049235, -4.214909, 2.392717>,
				<-0.306550, -0.617851, 0.716521>, <2.821702, -2.449609, 1.426423>,
				<-0.321353, -0.627441, 0.701541>, <1.421589, -1.233352, 0.676699>
			}
			smooth_triangle {
				<-0.330992, -0.598961, 0.721665>, <5.049235, -4.214909, 2.392717>,
				<-0.311651, -0.593921, 0.734338>, <3.572048, -2.987132, 1.819556>,
				<-0.306550, -0.617851, 0.716521>, <2.821702, -2.449609, 1.426423>
			}
			smooth_triangle {
				<-0.349775, -0.573111, 0.733693>, <4.459176, -3.458322, 2.036119>,
				<-0.330992, -0.598961, 0.721665>, <5.049235, -4.214909, 2.392717>,
				<-0.356873, -0.592021, 0.715029>, <4.421080, -3.569811, 1.923950>
			}
			smooth_triangle {
				<-0.311651, -0.593921, 0.734338>, <3.572048, -2.987132, 1.819556>,
				<-0.303873, -0.576561, 0.751231>, <4.316312, -3.476976, 2.295830>,
				<-0.289450, -0.600761, 0.737849>, <4.900234, -4.225850, 2.667779>
			}
			smooth_triangle {
				<-0.311651, -0.593921, 0.734338>, <3.572048, -2.987132, 1.819556>,
				<-0.326690, -0.574861, 0.742910>, <4.392554, -3.466999, 2.162359>,
				<-0.303873, -0.576561, 0.751231>, <4.316312, -3.476976, 2.295830>
			}
			smooth_triangle {
				<-0.326690, -0.574861, 0.742910>, <4.392554, -3.466999, 2.162359>,
				<-0.330992, -0.598961, 0.721665>, <5.049235, -4.214909, 2.392717>,
				<-0.349775, -0.573111, 0.733693>, <4.459176, -3.458322, 2.036119>
			}
			smooth_triangle {
				<-0.326690, -0.574861, 0.742910>, <4.392554, -3.466999, 2.162359>,
				<-0.311651, -0.593921, 0.734338>, <3.572048, -2.987132, 1.819556>,
				<-0.330992, -0.598961, 0.721665>, <5.049235, -4.214909, 2.392717>
			}
			smooth_triangle {
				<-0.356873, -0.592021, 0.715029>, <4.421080, -3.569811, 1.923950>,
				<-0.364743, -0.609161, 0.696425>, <1.468444, -1.207487, 0.620843>,
				<-0.378857, -0.588081, 0.706923>, <2.242894, -1.765198, 0.923099>
			}
			smooth_triangle {
				<-0.356873, -0.592021, 0.715029>, <4.421080, -3.569811, 1.923950>,
				<-0.343026, -0.612191, 0.704741>, <2.167733, -1.827549, 0.979487>,
				<-0.364743, -0.609161, 0.696425>, <1.468444, -1.207487, 0.620843>
			}
			smooth_triangle {
				<-0.378857, -0.588081, 0.706923>, <2.242894, -1.765198, 0.923099>,
				<-0.372976, -0.569891, 0.724729>, <4.532958, -3.437447, 1.904534>,
				<-0.356873, -0.592021, 0.715029>, <4.421080, -3.569811, 1.923950>
			}
			smooth_triangle {
				<-0.378857, -0.588081, 0.706923>, <2.242894, -1.765198, 0.923099>,
				<-0.394912, -0.567252, 0.715108>, <2.296722, -1.700950, 0.911317>,
				<-0.372976, -0.569891, 0.724729>, <4.532958, -3.437447, 1.904534>
			}
			smooth_triangle {
				<-0.269561, -0.616751, 0.732164>, <2.063078, -1.835815, 1.171603>,
				<-0.289450, -0.600761, 0.737849>, <4.900234, -4.225850, 2.667779>,
				<-0.265983, -0.597551, 0.749200>, <4.137185, -3.603877, 2.426592>
			}
			smooth_triangle {
				<-0.289450, -0.600761, 0.737849>, <4.900234, -4.225850, 2.667779>,
				<-0.286732, -0.622731, 0.720491>, <1.388324, -1.229940, 0.748082>,
				<-0.306550, -0.617851, 0.716521>, <2.821702, -2.449609, 1.426423>
			}
			smooth_triangle {
				<-0.269561, -0.616751, 0.732164>, <2.063078, -1.835815, 1.171603>,
				<-0.286732, -0.622731, 0.720491>, <1.388324, -1.229940, 0.748082>,
				<-0.289450, -0.600761, 0.737849>, <4.900234, -4.225850, 2.667779>
			}
			smooth_triangle {
				<-0.265983, -0.597551, 0.749200>, <4.137185, -3.603877, 2.426592>,
				<-0.251523, -0.612651, 0.741962>, <1.362418, -1.217189, 0.813658>,
				<-0.269561, -0.616751, 0.732164>, <2.063078, -1.835815, 1.171603>
			}
			smooth_triangle {
				<-0.265983, -0.597551, 0.749200>, <4.137185, -3.603877, 2.426592>,
				<-0.245790, -0.595131, 0.757973>, <2.053528, -1.788820, 1.257887>,
				<-0.251523, -0.612651, 0.741962>, <1.362418, -1.217189, 0.813658>
			}
			smooth_triangle {
				<-0.245790, -0.595131, 0.757973>, <2.053528, -1.788820, 1.257887>,
				<-0.258302, -0.580541, 0.765091>, <4.163770, -3.500763, 2.530121>,
				<-0.239247, -0.582871, 0.769505>, <2.061853, -1.746246, 1.303369>
			}
			smooth_triangle {
				<-0.280517, -0.578881, 0.758498>, <4.239494, -3.491841, 2.413467>,
				<-0.265983, -0.597551, 0.749200>, <4.137185, -3.603877, 2.426592>,
				<-0.289450, -0.600761, 0.737849>, <4.900234, -4.225850, 2.667779>
			}
			smooth_triangle {
				<-0.265983, -0.597551, 0.749200>, <4.137185, -3.603877, 2.426592>,
				<-0.258302, -0.580541, 0.765091>, <4.163770, -3.500763, 2.530121>,
				<-0.245790, -0.595131, 0.757973>, <2.053528, -1.788820, 1.257887>
			}
			smooth_triangle {
				<-0.265983, -0.597551, 0.749200>, <4.137185, -3.603877, 2.426592>,
				<-0.280517, -0.578881, 0.758498>, <4.239494, -3.491841, 2.413467>,
				<-0.258302, -0.580541, 0.765091>, <4.163770, -3.500763, 2.530121>
			}
			smooth_triangle {
				<-0.296968, -0.670671, 0.671655>, <3.978917, -4.045617, 1.949245>,
				<-0.298349, -0.661111, 0.680463>, <4.017584, -3.987807, 1.988631>,
				<-0.291161, -0.667671, 0.677160>, <1.991624, -2.011563, 0.993411>
			}
			smooth_triangle {
				<-0.306592, -0.663471, 0.674483>, <4.033045, -4.003620, 1.924389>,
				<-0.316959, -0.653931, 0.678991>, <2.039051, -1.986974, 0.945438>,
				<-0.306694, -0.654701, 0.682949>, <2.024522, -1.983623, 0.982962>
			}
			smooth_triangle {
				<-0.306592, -0.663471, 0.674483>, <4.033045, -4.003620, 1.924389>,
				<-0.317091, -0.664671, 0.668411>, <4.734900, -4.677455, 2.167485>,
				<-0.316959, -0.653931, 0.678991>, <2.039051, -1.986974, 0.945438>
			}
			smooth_triangle {
				<-0.322111, -0.672001, 0.658616>, <1.350109, -1.343654, 0.609621>,
				<-0.317091, -0.664671, 0.668411>, <4.734900, -4.677455, 2.167485>,
				<-0.311168, -0.678221, 0.657501>, <2.000156, -2.034375, 0.927515>
			}
			smooth_triangle {
				<-0.317091, -0.664671, 0.668411>, <4.734900, -4.677455, 2.167485>,
				<-0.303333, -0.675511, 0.663929>, <4.641701, -4.753127, 2.204261>,
				<-0.311168, -0.678221, 0.657501>, <2.000156, -2.034375, 0.927515>
			}
			smooth_triangle {
				<-0.317091, -0.664671, 0.668411>, <4.734900, -4.677455, 2.167485>,
				<-0.306592, -0.663471, 0.674483>, <4.033045, -4.003620, 1.924389>,
				<-0.303333, -0.675511, 0.663929>, <4.641701, -4.753127, 2.204261>
			}
			smooth_triangle {
				<-0.298349, -0.661111, 0.680463>, <4.017584, -3.987807, 1.988631>,
				<-0.306592, -0.663471, 0.674483>, <4.033045, -4.003620, 1.924389>,
				<-0.306694, -0.654701, 0.682949>, <2.024522, -1.983623, 0.982962>
			}
			smooth_triangle {
				<-0.306592, -0.663471, 0.674483>, <4.033045, -4.003620, 1.924389>,
				<-0.296968, -0.670671, 0.671655>, <3.978917, -4.045617, 1.949245>,
				<-0.303333, -0.675511, 0.663929>, <4.641701, -4.753127, 2.204261>
			}
			smooth_triangle {
				<-0.298349, -0.661111, 0.680463>, <4.017584, -3.987807, 1.988631>,
				<-0.296968, -0.670671, 0.671655>, <3.978917, -4.045617, 1.949245>,
				<-0.306592, -0.663471, 0.674483>, <4.033045, -4.003620, 1.924389>
			}
			smooth_triangle {
				<-0.317091, -0.664671, 0.668411>, <4.734900, -4.677455, 2.167485>,
				<-0.328782, -0.650121, 0.677020>, <1.367111, -1.322381, 0.618313>,
				<-0.316959, -0.653931, 0.678991>, <2.039051, -1.986974, 0.945438>
			}
			smooth_triangle {
				<-0.317091, -0.664671, 0.668411>, <4.734900, -4.677455, 2.167485>,
				<-0.330534, -0.659001, 0.667512>, <1.362939, -1.329599, 0.611894>,
				<-0.328782, -0.650121, 0.677020>, <1.367111, -1.322381, 0.618313>
			}
			smooth_triangle {
				<-0.317091, -0.664671, 0.668411>, <4.734900, -4.677455, 2.167485>,
				<-0.322111, -0.672001, 0.658616>, <1.350109, -1.343654, 0.609621>,
				<-0.330534, -0.659001, 0.667512>, <1.362939, -1.329599, 0.611894>
			}
			smooth_triangle {
				<-0.303333, -0.675511, 0.663929>, <4.641701, -4.753127, 2.204261>,
				<-0.303099, -0.685421, 0.653785>, <1.318514, -1.369367, 0.621572>,
				<-0.311168, -0.678221, 0.657501>, <2.000156, -2.034375, 0.927515>
			}
			smooth_triangle {
				<-0.303333, -0.675511, 0.663929>, <4.641701, -4.753127, 2.204261>,
				<-0.296456, -0.684601, 0.657688>, <1.316095, -1.368492, 0.628561>,
				<-0.303099, -0.685421, 0.653785>, <1.318514, -1.369367, 0.621572>
			}
			smooth_triangle {
				<-0.290466, -0.674891, 0.670272>, <1.319784, -1.354079, 0.651566>,
				<-0.296968, -0.670671, 0.671655>, <3.978917, -4.045617, 1.949245>,
				<-0.291161, -0.667671, 0.677160>, <1.991624, -2.011563, 0.993411>
			}
			smooth_triangle {
				<-0.290466, -0.674891, 0.670272>, <1.319784, -1.354079, 0.651566>,
				<-0.291772, -0.681191, 0.663301>, <1.975695, -2.042709, 0.961185>,
				<-0.296968, -0.670671, 0.671655>, <3.978917, -4.045617, 1.949245>
			}
			smooth_triangle {
				<-0.296456, -0.684601, 0.657688>, <1.316095, -1.368492, 0.628561>,
				<-0.303333, -0.675511, 0.663929>, <4.641701, -4.753127, 2.204261>,
				<-0.291772, -0.681191, 0.663301>, <1.975695, -2.042709, 0.961185>
			}
			smooth_triangle {
				<-0.303333, -0.675511, 0.663929>, <4.641701, -4.753127, 2.204261>,
				<-0.296968, -0.670671, 0.671655>, <3.978917, -4.045617, 1.949245>,
				<-0.291772, -0.681191, 0.663301>, <1.975695, -2.042709, 0.961185>
			}
			smooth_triangle {
				<-0.298349, -0.661111, 0.680463>, <4.017584, -3.987807, 1.988631>,
				<-0.290049, -0.660731, 0.684412>, <2.008893, -1.985896, 1.010111>,
				<-0.291161, -0.667671, 0.677160>, <1.991624, -2.011563, 0.993411>
			}
			smooth_triangle {
				<-0.298453, -0.649211, 0.691790>, <2.017090, -1.977383, 1.010581>,
				<-0.298349, -0.661111, 0.680463>, <4.017584, -3.987807, 1.988631>,
				<-0.306694, -0.654701, 0.682949>, <2.024522, -1.983623, 0.982962>
			}
			smooth_triangle {
				<-0.298453, -0.649211, 0.691790>, <2.017090, -1.977383, 1.010581>,
				<-0.290049, -0.660731, 0.684412>, <2.008893, -1.985896, 1.010111>,
				<-0.298349, -0.661111, 0.680463>, <4.017584, -3.987807, 1.988631>
			}
			smooth_triangle {
				<-0.298453, -0.649211, 0.691790>, <2.017090, -1.977383, 1.010581>,
				<-0.291364, -0.651521, 0.692630>, <0.671518, -0.659046, 0.338706>,
				<-0.290049, -0.660731, 0.684412>, <2.008893, -1.985896, 1.010111>
			}
			smooth_triangle {
				<-0.583902, -0.655832, 0.466964>, <2.238567, -1.996512, -0.046800>,
				<-0.573864, -0.672922, 0.454938>, <2.223411, -2.013332, -0.048358>,
				<-0.587130, -0.662542, 0.453238>, <0.743848, -0.668076, -0.019113>
			}
			smooth_triangle {
				<-0.560731, -0.682342, 0.457272>, <2.201896, -2.037406, 0.002353>,
				<-0.563621, -0.663282, 0.481146>, <2.948651, -2.702375, 0.004279>,
				<-0.546122, -0.692482, 0.459700>, <2.181022, -2.059289, 0.028221>
			}
			smooth_triangle {
				<-0.572603, -0.664792, 0.468279>, <3.715937, -3.344622, -0.038699>,
				<-0.583902, -0.655832, 0.466964>, <2.238567, -1.996512, -0.046800>,
				<-0.580201, -0.649132, 0.480725>, <1.500944, -1.321764, -0.009513>
			}
			smooth_triangle {
				<-0.572603, -0.664792, 0.468279>, <3.715937, -3.344622, -0.038699>,
				<-0.573864, -0.672922, 0.454938>, <2.223411, -2.013332, -0.048358>,
				<-0.583902, -0.655832, 0.466964>, <2.238567, -1.996512, -0.046800>
			}
			smooth_triangle {
				<-0.572603, -0.664792, 0.468279>, <3.715937, -3.344622, -0.038699>,
				<-0.560731, -0.682342, 0.457272>, <2.201896, -2.037406, 0.002353>,
				<-0.573864, -0.672922, 0.454938>, <2.223411, -2.013332, -0.048358>
			}
			smooth_triangle {
				<-0.563621, -0.663282, 0.481146>, <2.948651, -2.702375, 0.004279>,
				<-0.572603, -0.664792, 0.468279>, <3.715937, -3.344622, -0.038699>,
				<-0.580201, -0.649132, 0.480725>, <1.500944, -1.321764, -0.009513>
			}
			smooth_triangle {
				<-0.563621, -0.663282, 0.481146>, <2.948651, -2.702375, 0.004279>,
				<-0.560731, -0.682342, 0.457272>, <2.201896, -2.037406, 0.002353>,
				<-0.572603, -0.664792, 0.468279>, <3.715937, -3.344622, -0.038699>
			}
			smooth_triangle {
				<-0.546122, -0.692482, 0.459700>, <2.181022, -2.059289, 0.028221>,
				<-0.545981, -0.677712, 0.481369>, <2.169229, -2.071656, 0.031061>,
				<-0.530768, -0.704222, 0.459844>, <2.849350, -2.805731, 0.084244>
			}
			smooth_triangle {
				<-0.563621, -0.663282, 0.481146>, <2.948651, -2.702375, 0.004279>,
				<-0.545981, -0.677712, 0.481369>, <2.169229, -2.071656, 0.031061>,
				<-0.546122, -0.692482, 0.459700>, <2.181022, -2.059289, 0.028221>
			}
			smooth_triangle {
				<-0.516912, -0.691862, 0.493189>, <1.419905, -1.405952, 0.083012>,
				<-0.510368, -0.707152, 0.478103>, <4.916203, -4.975122, 0.262329>,
				<-0.529807, -0.687172, 0.486021>, <2.142236, -2.098720, 0.073120>
			}
			smooth_triangle {
				<-0.496307, -0.723892, 0.467728>, <1.386429, -1.439256, 0.079047>,
				<-0.510368, -0.707152, 0.478103>, <4.916203, -4.975122, 0.262329>,
				<-0.488576, -0.718422, 0.484020>, <1.390838, -1.434021, 0.095279>
			}
			smooth_triangle {
				<-0.510368, -0.707152, 0.478103>, <4.916203, -4.975122, 0.262329>,
				<-0.496404, -0.705032, 0.495601>, <1.405401, -1.419387, 0.099912>,
				<-0.488576, -0.718422, 0.484020>, <1.390838, -1.434021, 0.095279>
			}
			smooth_triangle {
				<-0.510368, -0.707152, 0.478103>, <4.916203, -4.975122, 0.262329>,
				<-0.516912, -0.691862, 0.493189>, <1.419905, -1.405952, 0.083012>,
				<-0.496404, -0.705032, 0.495601>, <1.405401, -1.419387, 0.099912>
			}
			smooth_triangle {
				<-0.529807, -0.687172, 0.486021>, <2.142236, -2.098720, 0.073120>,
				<-0.530768, -0.704222, 0.459844>, <2.849350, -2.805731, 0.084244>,
				<-0.545981, -0.677712, 0.481369>, <2.169229, -2.071656, 0.031061>
			}
			smooth_triangle {
				<-0.512289, -0.718572, 0.458607>, <1.394406, -1.432494, 0.057940>,
				<-0.510368, -0.707152, 0.478103>, <4.916203, -4.975122, 0.262329>,
				<-0.496307, -0.723892, 0.467728>, <1.386429, -1.439256, 0.079047>
			}
			smooth_triangle {
				<-0.510368, -0.707152, 0.478103>, <4.916203, -4.975122, 0.262329>,
				<-0.530768, -0.704222, 0.459844>, <2.849350, -2.805731, 0.084244>,
				<-0.529807, -0.687172, 0.486021>, <2.142236, -2.098720, 0.073120>
			}
			smooth_triangle {
				<-0.510368, -0.707152, 0.478103>, <4.916203, -4.975122, 0.262329>,
				<-0.512289, -0.718572, 0.458607>, <1.394406, -1.432494, 0.057940>,
				<-0.530768, -0.704222, 0.459844>, <2.849350, -2.805731, 0.084244>
			}
			smooth_triangle {
				<-0.647149, -0.620203, 0.430888>, <1.559918, -1.241888, -0.155548>,
				<-0.655387, -0.605533, 0.439210>, <0.783154, -0.616478, -0.081389>,
				<-0.642773, -0.612843, 0.447646>, <3.119921, -2.487659, -0.275624>
			}
			smooth_triangle {
				<-0.630231, -0.630203, 0.441326>, <2.321293, -1.890523, -0.190124>,
				<-0.647149, -0.620203, 0.430888>, <1.559918, -1.241888, -0.155548>,
				<-0.642773, -0.612843, 0.447646>, <3.119921, -2.487659, -0.275624>
			}
			smooth_triangle {
				<-0.622407, -0.625882, 0.458258>, <5.422445, -4.412338, -0.340119>,
				<-0.637658, -0.607783, 0.461630>, <2.360711, -1.844578, -0.153459>,
				<-0.628403, -0.606013, 0.476408>, <3.162400, -2.443133, -0.165414>
			}
			smooth_triangle {
				<-0.630231, -0.630203, 0.441326>, <2.321293, -1.890523, -0.190124>,
				<-0.622407, -0.625882, 0.458258>, <5.422445, -4.412338, -0.340119>,
				<-0.613691, -0.648092, 0.438713>, <2.288138, -1.935146, -0.138123>
			}
			smooth_triangle {
				<-0.630231, -0.630203, 0.441326>, <2.321293, -1.890523, -0.190124>,
				<-0.642773, -0.612843, 0.447646>, <3.119921, -2.487659, -0.275624>,
				<-0.622407, -0.625882, 0.458258>, <5.422445, -4.412338, -0.340119>
			}
			smooth_triangle {
				<-0.642773, -0.612843, 0.447646>, <3.119921, -2.487659, -0.275624>,
				<-0.637658, -0.607783, 0.461630>, <2.360711, -1.844578, -0.153459>,
				<-0.622407, -0.625882, 0.458258>, <5.422445, -4.412338, -0.340119>
			}
			smooth_triangle {
				<-0.609179, -0.626962, 0.474271>, <1.548243, -1.263398, -0.077622>,
				<-0.622407, -0.625882, 0.458258>, <5.422445, -4.412338, -0.340119>,
				<-0.628403, -0.606013, 0.476408>, <3.162400, -2.443133, -0.165414>
			}
			smooth_triangle {
				<-0.609179, -0.626962, 0.474271>, <1.548243, -1.263398, -0.077622>,
				<-0.593106, -0.648242, 0.465967>, <2.287680, -1.936790, -0.123079>,
				<-0.622407, -0.625882, 0.458258>, <5.422445, -4.412338, -0.340119>
			}
			smooth_triangle {
				<-0.593106, -0.648242, 0.465967>, <2.287680, -1.936790, -0.123079>,
				<-0.613691, -0.648092, 0.438713>, <2.288138, -1.935146, -0.138123>,
				<-0.622407, -0.625882, 0.458258>, <5.422445, -4.412338, -0.340119>
			}
			smooth_triangle {
				<-0.593106, -0.648242, 0.465967>, <2.287680, -1.936790, -0.123079>,
				<-0.596222, -0.660042, 0.444954>, <0.758314, -0.650550, -0.041765>,
				<-0.613691, -0.648092, 0.438713>, <2.288138, -1.935146, -0.138123>
			}
			smooth_triangle {
				<-0.632443, -0.584262, 0.497761>, <2.424387, -1.764273, -0.089602>,
				<-0.641613, -0.576553, 0.494999>, <1.624024, -1.165617, -0.057528>,
				<-0.635551, -0.563322, 0.517548>, <0.816777, -0.576618, -0.019682>
			}
			smooth_triangle {
				<-0.641177, -0.592383, 0.476540>, <2.402521, -1.792404, -0.118869>,
				<-0.628403, -0.606013, 0.476408>, <3.162400, -2.443133, -0.165414>,
				<-0.637658, -0.607783, 0.461630>, <2.360711, -1.844578, -0.153459>
			}
			smooth_triangle {
				<-0.641613, -0.576553, 0.494999>, <1.624024, -1.165617, -0.057528>,
				<-0.632443, -0.584262, 0.497761>, <2.424387, -1.764273, -0.089602>,
				<-0.641177, -0.592383, 0.476540>, <2.402521, -1.792404, -0.118869>
			}
			smooth_triangle {
				<-0.632443, -0.584262, 0.497761>, <2.424387, -1.764273, -0.089602>,
				<-0.628403, -0.606013, 0.476408>, <3.162400, -2.443133, -0.165414>,
				<-0.641177, -0.592383, 0.476540>, <2.402521, -1.792404, -0.118869>
			}
			smooth_triangle {
				<-0.615985, -0.379102, 0.682608>, <-1.837566, 0.749801, -0.245467>,
				<-0.633606, -0.382532, 0.664315>, <-0.914762, 0.387213, -0.115225>,
				<-0.621235, -0.397862, 0.667001>, <-0.914762, 0.387213, -0.115225>
			}
			smooth_triangle {
				<-0.615985, -0.379102, 0.682608>, <-1.837566, 0.749801, -0.245467>,
				<-0.605085, -0.359632, 0.702598>, <-1.848180, 0.713043, -0.274674>,
				<-0.623278, -0.341702, 0.695619>, <-1.848180, 0.713043, -0.274674>
			}
			smooth_triangle {
				<-0.605085, -0.359632, 0.702598>, <-1.848180, 0.713043, -0.274674>,
				<-0.606086, -0.340732, 0.711114>, <-0.925376, 0.350456, -0.144433>,
				<-0.623278, -0.341702, 0.695619>, <-1.848180, 0.713043, -0.274674>
			}
			smooth_triangle {
				<-0.945399, 0.291717, 0.101154>, <0.800327, 0.297873, -0.520335>,
				<-0.937494, 0.308807, 0.121870>, <1.604773, 0.593665, -1.035480>,
				<-0.946857, 0.282177, 0.113761>, <1.604773, 0.593665, -1.035480>
			}
			smooth_triangle {
				<-0.946857, 0.282177, 0.113761>, <1.604773, 0.593665, -1.035480>,
				<-0.937494, 0.308807, 0.121870>, <1.604773, 0.593665, -1.035480>,
				<-0.943524, 0.284677, 0.133508>, <0.804446, 0.295792, -0.515145>
			}
			smooth_triangle {
				<-0.330706, -0.063301, 0.935811>, <-6.018337, 0.455193, -3.544014>,
				<-0.313602, -0.091761, 0.939330>, <-5.941710, 0.646130, -3.642202>,
				<-0.307485, -0.068661, 0.943322>, <-2.549787, 0.221110, -1.564682>
			}
			smooth_triangle {
				<-0.313602, -0.091761, 0.939330>, <-5.941710, 0.646130, -3.642202>,
				<-0.310042, -0.119881, 0.937349>, <-3.362401, 0.451865, -2.118531>,
				<-0.287889, -0.104001, 0.946265>, <-5.001262, 0.629066, -3.253201>
			}
			smooth_triangle {
				<-0.287889, -0.104001, 0.946265>, <-5.001262, 0.629066, -3.253201>,
				<-0.310042, -0.119881, 0.937349>, <-3.362401, 0.451865, -2.118531>,
				<-0.281249, -0.127281, 0.945419>, <-2.498594, 0.354254, -1.621958>
			}
			smooth_triangle {
				<-0.310042, -0.119881, 0.937349>, <-3.362401, 0.451865, -2.118531>,
				<-0.299626, -0.134921, 0.938686>, <-0.836128, 0.121228, -0.534971>,
				<-0.281249, -0.127281, 0.945419>, <-2.498594, 0.354254, -1.621958>
			}
			smooth_triangle {
				<-0.287889, -0.104001, 0.946265>, <-5.001262, 0.629066, -3.253201>,
				<-0.289424, -0.081481, 0.947997>, <-2.514380, 0.269550, -1.613763>,
				<-0.313602, -0.091761, 0.939330>, <-5.941710, 0.646130, -3.642202>
			}
			smooth_triangle {
				<-0.313602, -0.091761, 0.939330>, <-5.941710, 0.646130, -3.642202>,
				<-0.289424, -0.081481, 0.947997>, <-2.514380, 0.269550, -1.613763>,
				<-0.307485, -0.068661, 0.943322>, <-2.549787, 0.221110, -1.564682>
			}
			smooth_triangle {
				<-0.281249, -0.127281, 0.945419>, <-2.498594, 0.354254, -1.621958>,
				<-0.262995, -0.112661, 0.952502>, <-1.651874, 0.218556, -1.106091>,
				<-0.287889, -0.104001, 0.946265>, <-5.001262, 0.629066, -3.253201>
			}
			smooth_triangle {
				<-0.262995, -0.112661, 0.952502>, <-1.651874, 0.218556, -1.106091>,
				<-0.269428, -0.090951, 0.953018>, <-1.656226, 0.197198, -1.103553>,
				<-0.287889, -0.104001, 0.946265>, <-5.001262, 0.629066, -3.253201>
			}
			smooth_triangle {
				<-0.269428, -0.090951, 0.953018>, <-1.656226, 0.197198, -1.103553>,
				<-0.289424, -0.081481, 0.947997>, <-2.514380, 0.269550, -1.613763>,
				<-0.287889, -0.104001, 0.946265>, <-5.001262, 0.629066, -3.253201>
			}
			smooth_triangle {
				<-0.358307, -0.060191, 0.925801>, <-5.245498, 0.370501, -2.887481>,
				<-0.343792, -0.090771, 0.928803>, <-6.069898, 0.620119, -3.428864>,
				<-0.330706, -0.063301, 0.935811>, <-6.018337, 0.455193, -3.544014>
			}
			smooth_triangle {
				<-0.310042, -0.119881, 0.937349>, <-3.362401, 0.451865, -2.118531>,
				<-0.313602, -0.091761, 0.939330>, <-5.941710, 0.646130, -3.642202>,
				<-0.324999, -0.114191, 0.932981>, <-1.704573, 0.204158, -1.025886>
			}
			smooth_triangle {
				<-0.330706, -0.063301, 0.935811>, <-6.018337, 0.455193, -3.544014>,
				<-0.343792, -0.090771, 0.928803>, <-6.069898, 0.620119, -3.428864>,
				<-0.313602, -0.091761, 0.939330>, <-5.941710, 0.646130, -3.642202>
			}
			smooth_triangle {
				<-0.343792, -0.090771, 0.928803>, <-6.069898, 0.620119, -3.428864>,
				<-0.324999, -0.114191, 0.932981>, <-1.704573, 0.204158, -1.025886>,
				<-0.313602, -0.091761, 0.939330>, <-5.941710, 0.646130, -3.642202>
			}
			smooth_triangle {
				<-0.377503, -0.075771, 0.916988>, <-2.629272, 0.233792, -1.425198>,
				<-0.374109, -0.103401, 0.915681>, <-1.748375, 0.183232, -0.953712>,
				<-0.343792, -0.090771, 0.928803>, <-6.069898, 0.620119, -3.428864>
			}
			smooth_triangle {
				<-0.374109, -0.103401, 0.915681>, <-1.748375, 0.183232, -0.953712>,
				<-0.356503, -0.111481, 0.921729>, <-1.739856, 0.197984, -0.966160>,
				<-0.343792, -0.090771, 0.928803>, <-6.069898, 0.620119, -3.428864>
			}
			smooth_triangle {
				<-0.356503, -0.111481, 0.921729>, <-1.739856, 0.197984, -0.966160>,
				<-0.338761, -0.111951, 0.928342>, <-0.866466, 0.103362, -0.488418>,
				<-0.343792, -0.090771, 0.928803>, <-6.069898, 0.620119, -3.428864>
			}
			smooth_triangle {
				<-0.343792, -0.090771, 0.928803>, <-6.069898, 0.620119, -3.428864>,
				<-0.358307, -0.060191, 0.925801>, <-5.245498, 0.370501, -2.887481>,
				<-0.377503, -0.075771, 0.916988>, <-2.629272, 0.233792, -1.425198>
			}
			smooth_triangle {
				<-0.358307, -0.060191, 0.925801>, <-5.245498, 0.370501, -2.887481>,
				<-0.380396, -0.056191, 0.917197>, <-2.643173, 0.156823, -1.410052>,
				<-0.377503, -0.075771, 0.916988>, <-2.629272, 0.233792, -1.425198>
			}
			smooth_triangle {
				<-0.314670, -0.046781, 0.942289>, <-2.563298, 0.151681, -1.551012>,
				<-0.312167, -0.030891, 0.943779>, <-0.853755, 0.038286, -0.519265>,
				<-0.326907, -0.040741, 0.938393>, <-2.574019, 0.141788, -1.534058>
			}
			smooth_triangle {
				<-0.358307, -0.060191, 0.925801>, <-5.245498, 0.370501, -2.887481>,
				<-0.330706, -0.063301, 0.935811>, <-6.018337, 0.455193, -3.544014>,
				<-0.349289, -0.044091, 0.930139>, <-2.607874, 0.154943, -1.474284>
			}
			smooth_triangle {
				<-0.307485, -0.068661, 0.943322>, <-2.549787, 0.221110, -1.564682>,
				<-0.314670, -0.046781, 0.942289>, <-2.563298, 0.151681, -1.551012>,
				<-0.330706, -0.063301, 0.935811>, <-6.018337, 0.455193, -3.544014>
			}
			smooth_triangle {
				<-0.314670, -0.046781, 0.942289>, <-2.563298, 0.151681, -1.551012>,
				<-0.326907, -0.040741, 0.938393>, <-2.574019, 0.141788, -1.534058>,
				<-0.330706, -0.063301, 0.935811>, <-6.018337, 0.455193, -3.544014>
			}
			smooth_triangle {
				<-0.330706, -0.063301, 0.935811>, <-6.018337, 0.455193, -3.544014>,
				<-0.326907, -0.040741, 0.938393>, <-2.574019, 0.141788, -1.534058>,
				<-0.349289, -0.044091, 0.930139>, <-2.607874, 0.154943, -1.474284>
			}
			smooth_triangle {
				<-0.380396, -0.056191, 0.917197>, <-2.643173, 0.156823, -1.410052>,
				<-0.367378, -0.030981, 0.923688>, <-2.640139, 0.138025, -1.417882>,
				<-0.384450, -0.035221, 0.916551>, <-0.882956, 0.044174, -0.467373>
			}
			smooth_triangle {
				<-0.380396, -0.056191, 0.917197>, <-2.643173, 0.156823, -1.410052>,
				<-0.358307, -0.060191, 0.925801>, <-5.245498, 0.370501, -2.887481>,
				<-0.367378, -0.030981, 0.923688>, <-2.640139, 0.138025, -1.417882>
			}
			smooth_triangle {
				<-0.358307, -0.060191, 0.925801>, <-5.245498, 0.370501, -2.887481>,
				<-0.349289, -0.044091, 0.930139>, <-2.607874, 0.154943, -1.474284>,
				<-0.367378, -0.030981, 0.923688>, <-2.640139, 0.138025, -1.417882>
			}
			smooth_triangle {
				<-0.539005, -0.089802, 0.830977>, <-1.907083, 0.155685, -0.581755>,
				<-0.522628, -0.082112, 0.842156>, <-0.950694, 0.080713, -0.299443>,
				<-0.534180, -0.068432, 0.836106>, <-3.819382, 0.303024, -1.148644>
			}
			smooth_triangle {
				<-0.534180, -0.068432, 0.836106>, <-3.819382, 0.303024, -1.148644>,
				<-0.563069, -0.078162, 0.816067>, <-1.912519, 0.151641, -0.565042>,
				<-0.539005, -0.089802, 0.830977>, <-1.907083, 0.155685, -0.581755>
			}
			smooth_triangle {
				<-0.563069, -0.078162, 0.816067>, <-1.912519, 0.151641, -0.565042>,
				<-0.534180, -0.068432, 0.836106>, <-3.819382, 0.303024, -1.148644>,
				<-0.557999, -0.062062, 0.820912>, <-1.912300, 0.147339, -0.566889>
			}
			smooth_triangle {
				<-0.534180, -0.068432, 0.836106>, <-3.819382, 0.303024, -1.148644>,
				<-0.544731, -0.054732, 0.830299>, <-0.956169, 0.070670, -0.284159>,
				<-0.557999, -0.062062, 0.820912>, <-1.912300, 0.147339, -0.566889>
			}
			smooth_triangle {
				<-0.443693, -0.124791, 0.881294>, <2.739745, -0.347962, 1.170885>,
				<-0.435715, -0.105421, 0.887784>, <5.455770, -0.644457, 2.410823>,
				<-0.417249, -0.126291, 0.893906>, <2.705825, -0.354333, 1.245801>
			}
			smooth_triangle {
				<-0.417249, -0.126291, 0.893906>, <2.705825, -0.354333, 1.245801>,
				<-0.414566, -0.106471, 0.897726>, <5.395556, -0.635612, 2.544835>,
				<-0.399665, -0.123811, 0.902245>, <1.789472, -0.229049, 0.863243>
			}
			smooth_triangle {
				<-0.411932, -0.085141, 0.901207>, <2.691036, -0.293263, 1.292755>,
				<-0.388825, -0.111651, 0.908552>, <3.570025, -0.407835, 1.757239>,
				<-0.414566, -0.106471, 0.897726>, <5.395556, -0.635612, 2.544835>
			}
			smooth_triangle {
				<-0.388825, -0.111651, 0.908552>, <3.570025, -0.407835, 1.757239>,
				<-0.399665, -0.123811, 0.902245>, <1.789472, -0.229049, 0.863243>,
				<-0.414566, -0.106471, 0.897726>, <5.395556, -0.635612, 2.544835>
			}
			smooth_triangle {
				<-0.393487, -0.084041, 0.909514>, <1.783420, -0.198357, 0.883161>,
				<-0.388825, -0.111651, 0.908552>, <3.570025, -0.407835, 1.757239>,
				<-0.411932, -0.085141, 0.901207>, <2.691036, -0.293263, 1.292755>
			}
			smooth_triangle {
				<-0.393487, -0.084041, 0.909514>, <1.783420, -0.198357, 0.883161>,
				<-0.382776, -0.089391, 0.913567>, <0.889628, -0.098506, 0.445935>,
				<-0.388825, -0.111651, 0.908552>, <3.570025, -0.407835, 1.757239>
			}
			smooth_triangle {
				<-0.411932, -0.085141, 0.901207>, <2.691036, -0.293263, 1.292755>,
				<-0.414566, -0.106471, 0.897726>, <5.395556, -0.635612, 2.544835>,
				<-0.433313, -0.086401, 0.891003>, <2.720731, -0.288031, 1.230447>
			}
			smooth_triangle {
				<-0.417249, -0.126291, 0.893906>, <2.705825, -0.354333, 1.245801>,
				<-0.435715, -0.105421, 0.887784>, <5.455770, -0.644457, 2.410823>,
				<-0.414566, -0.106471, 0.897726>, <5.395556, -0.635612, 2.544835>
			}
			smooth_triangle {
				<-0.414566, -0.106471, 0.897726>, <5.395556, -0.635612, 2.544835>,
				<-0.435715, -0.105421, 0.887784>, <5.455770, -0.644457, 2.410823>,
				<-0.433313, -0.086401, 0.891003>, <2.720731, -0.288031, 1.230447>
			}
			smooth_triangle {
				<-0.469180, -0.130512, 0.867146>, <2.767023, -0.355705, 1.102622>,
				<-0.455850, -0.096841, 0.878598>, <6.444087, -0.714729, 2.636510>,
				<-0.443693, -0.124791, 0.881294>, <2.739745, -0.347962, 1.170885>
			}
			smooth_triangle {
				<-0.433313, -0.086401, 0.891003>, <2.720731, -0.288031, 1.230447>,
				<-0.435715, -0.105421, 0.887784>, <5.455770, -0.644457, 2.410823>,
				<-0.448942, -0.091621, 0.882708>, <1.826264, -0.199483, 0.790446>
			}
			smooth_triangle {
				<-0.435715, -0.105421, 0.887784>, <5.455770, -0.644457, 2.410823>,
				<-0.455850, -0.096841, 0.878598>, <6.444087, -0.714729, 2.636510>,
				<-0.448942, -0.091621, 0.882708>, <1.826264, -0.199483, 0.790446>
			}
			smooth_triangle {
				<-0.435715, -0.105421, 0.887784>, <5.455770, -0.644457, 2.410823>,
				<-0.443693, -0.124791, 0.881294>, <2.739745, -0.347962, 1.170885>,
				<-0.455850, -0.096841, 0.878598>, <6.444087, -0.714729, 2.636510>
			}
			smooth_triangle {
				<-0.469180, -0.130512, 0.867146>, <2.767023, -0.355705, 1.102622>,
				<-0.480060, -0.110572, 0.863966>, <4.637371, -0.553553, 1.783761>,
				<-0.455850, -0.096841, 0.878598>, <6.444087, -0.714729, 2.636510>
			}
			smooth_triangle {
				<-0.455850, -0.096841, 0.878598>, <6.444087, -0.714729, 2.636510>,
				<-0.469879, -0.071782, 0.873594>, <1.848651, -0.174561, 0.742872>,
				<-0.452445, -0.073771, 0.882594>, <0.922552, -0.084102, 0.376595>
			}
			smooth_triangle {
				<-0.487206, -0.086182, 0.862730>, <2.784499, -0.285140, 1.079088>,
				<-0.455850, -0.096841, 0.878598>, <6.444087, -0.714729, 2.636510>,
				<-0.480060, -0.110572, 0.863966>, <4.637371, -0.553553, 1.783761>
			}
			smooth_triangle {
				<-0.487206, -0.086182, 0.862730>, <2.784499, -0.285140, 1.079088>,
				<-0.469879, -0.071782, 0.873594>, <1.848651, -0.174561, 0.742872>,
				<-0.455850, -0.096841, 0.878598>, <6.444087, -0.714729, 2.636510>
			}
			smooth_triangle {
				<-0.487206, -0.086182, 0.862730>, <2.784499, -0.285140, 1.079088>,
				<-0.480060, -0.110572, 0.863966>, <4.637371, -0.553553, 1.783761>,
				<-0.496258, -0.108282, 0.855053>, <1.863215, -0.219144, 0.692832>
			}
			smooth_triangle {
				<-0.469180, -0.130512, 0.867146>, <2.767023, -0.355705, 1.102622>,
				<-0.491008, -0.130902, 0.854916>, <1.858151, -0.244761, 0.698030>,
				<-0.480060, -0.110572, 0.863966>, <4.637371, -0.553553, 1.783761>
			}
			smooth_triangle {
				<-0.480060, -0.110572, 0.863966>, <4.637371, -0.553553, 1.783761>,
				<-0.491008, -0.130902, 0.854916>, <1.858151, -0.244761, 0.698030>,
				<-0.496258, -0.108282, 0.855053>, <1.863215, -0.219144, 0.692832>
			}
			smooth_triangle {
				<-0.287984, 0.008849, 0.951892>, <-2.508923, -0.034667, -1.643926>,
				<-0.277686, -0.017531, 0.954830>, <-0.836839, 0.006274, -0.547413>,
				<-0.280549, 0.006899, 0.954125>, <-1.670129, -0.012228, -1.099940>
			}
			smooth_triangle {
				<-0.280549, 0.006899, 0.954125>, <-1.670129, -0.012228, -1.099940>,
				<-0.279874, 0.030359, 0.953872>, <-2.512759, -0.077863, -1.636793>,
				<-0.287984, 0.008849, 0.951892>, <-2.508923, -0.034667, -1.643926>
			}
			smooth_triangle {
				<-0.287984, 0.008849, 0.951892>, <-2.508923, -0.034667, -1.643926>,
				<-0.279874, 0.030359, 0.953872>, <-2.512759, -0.077863, -1.636793>,
				<-0.304927, 0.022899, 0.946371>, <-2.522105, -0.098393, -1.621333>
			}
			smooth_triangle {
				<-0.288903, 0.052149, 0.950222>, <-3.366697, -0.204617, -2.149564>,
				<-0.304927, 0.022899, 0.946371>, <-2.522105, -0.098393, -1.621333>,
				<-0.279874, 0.030359, 0.953872>, <-2.512759, -0.077863, -1.636793>
			}
			smooth_triangle {
				<-0.288903, 0.052149, 0.950222>, <-3.366697, -0.204617, -2.149564>,
				<-0.309858, 0.050959, 0.943668>, <-1.684927, -0.102509, -1.072340>,
				<-0.304927, 0.022899, 0.946371>, <-2.522105, -0.098393, -1.621333>
			}
			smooth_triangle {
				<-0.307581, 0.076119, 0.942710>, <-1.683386, -0.128663, -1.072217>,
				<-0.288903, 0.052149, 0.950222>, <-3.366697, -0.204617, -2.149564>,
				<-0.287232, 0.076859, 0.949055>, <-0.841095, -0.065187, -0.536945>
			}
			smooth_triangle {
				<-0.307581, 0.076119, 0.942710>, <-1.683386, -0.128663, -1.072217>,
				<-0.309858, 0.050959, 0.943668>, <-1.684927, -0.102509, -1.072340>,
				<-0.288903, 0.052149, 0.950222>, <-3.366697, -0.204617, -2.149564>
			}
			smooth_triangle {
				<-0.222108, 0.011539, 0.969353>, <-2.406392, -0.043745, -1.790491>,
				<-0.207941, 0.029050, 0.972125>, <-0.795712, -0.024030, -0.605198>,
				<-0.227602, 0.033619, 0.967566>, <-2.412885, -0.061990, -1.781339>
			}
			smooth_triangle {
				<-0.265468, 0.012439, 0.958376>, <-1.633268, -0.014155, -1.154025>,
				<-0.264539, -0.017751, 0.958550>, <-0.819564, 0.002435, -0.572983>,
				<-0.242462, -0.000031, 0.964527>, <-4.052971, -0.053188, -2.926777>
			}
			smooth_triangle {
				<-0.218925, -0.005361, 0.970128>, <-0.802530, -0.001074, -0.596611>,
				<-0.222108, 0.011539, 0.969353>, <-2.406392, -0.043745, -1.790491>,
				<-0.242462, -0.000031, 0.964527>, <-4.052971, -0.053188, -2.926777>
			}
			smooth_triangle {
				<-0.242462, -0.000031, 0.964527>, <-4.052971, -0.053188, -2.926777>,
				<-0.253457, 0.033429, 0.961116>, <-1.622728, -0.035907, -1.168501>,
				<-0.265468, 0.012439, 0.958376>, <-1.633268, -0.014155, -1.154025>
			}
			smooth_triangle {
				<-0.253457, 0.033429, 0.961116>, <-1.622728, -0.035907, -1.168501>,
				<-0.242462, -0.000031, 0.964527>, <-4.052971, -0.053188, -2.926777>,
				<-0.227602, 0.033619, 0.967566>, <-2.412885, -0.061990, -1.781339>
			}
			smooth_triangle {
				<-0.242462, -0.000031, 0.964527>, <-4.052971, -0.053188, -2.926777>,
				<-0.222108, 0.011539, 0.969353>, <-2.406392, -0.043745, -1.790491>,
				<-0.227602, 0.033619, 0.967566>, <-2.412885, -0.061990, -1.781339>
			}
			smooth_triangle {
				<-0.240398, -0.041841, 0.964140>, <2.414426, -0.143239, 1.774523>,
				<-0.232936, -0.021401, 0.966638>, <0.805623, -0.032203, 0.591553>,
				<-0.228378, -0.040771, 0.967108>, <1.609268, -0.087269, 1.184108>
			}
			smooth_triangle {
				<-0.228378, -0.040771, 0.967108>, <1.609268, -0.087269, 1.184108>,
				<-0.230888, -0.069091, 0.964894>, <2.418911, -0.185440, 1.764509>,
				<-0.240398, -0.041841, 0.964140>, <2.414426, -0.143239, 1.774523>
			}
			smooth_triangle {
				<-0.230888, -0.069091, 0.964894>, <2.418911, -0.185440, 1.764509>,
				<-0.249794, -0.058561, 0.960876>, <4.075667, -0.320288, 2.877495>,
				<-0.240398, -0.041841, 0.964140>, <2.414426, -0.143239, 1.774523>
			}
			smooth_triangle {
				<-0.249794, -0.058561, 0.960876>, <4.075667, -0.320288, 2.877495>,
				<-0.242513, -0.089831, 0.960328>, <1.621629, -0.149352, 1.161038>,
				<-0.263484, -0.076121, 0.955980>, <1.635923, -0.132751, 1.142542>
			}
			smooth_triangle {
				<-0.249794, -0.058561, 0.960876>, <4.075667, -0.320288, 2.877495>,
				<-0.230888, -0.069091, 0.964894>, <2.418911, -0.185440, 1.764509>,
				<-0.242513, -0.089831, 0.960328>, <1.621629, -0.149352, 1.161038>
			}
			smooth_triangle {
				<-0.260879, -0.039521, 0.958898>, <1.647185, -0.117500, 1.128253>,
				<-0.249794, -0.058561, 0.960876>, <4.075667, -0.320288, 2.877495>,
				<-0.285755, -0.063071, 0.950518>, <3.302286, -0.224747, 2.245821>
			}
			smooth_triangle {
				<-0.249794, -0.058561, 0.960876>, <4.075667, -0.320288, 2.877495>,
				<-0.263484, -0.076121, 0.955980>, <1.635923, -0.132751, 1.142542>,
				<-0.285755, -0.063071, 0.950518>, <3.302286, -0.224747, 2.245821>
			}
			smooth_triangle {
				<-0.260879, -0.039521, 0.958898>, <1.647185, -0.117500, 1.128253>,
				<-0.285755, -0.063071, 0.950518>, <3.302286, -0.224747, 2.245821>,
				<-0.266947, -0.038681, 0.957267>, <1.653405, -0.109781, 1.119778>
			}
			smooth_triangle {
				<-0.285755, -0.063071, 0.950518>, <3.302286, -0.224747, 2.245821>,
				<-0.287049, -0.036471, 0.951513>, <0.830697, -0.049445, 0.554525>,
				<-0.266947, -0.038681, 0.957267>, <1.653405, -0.109781, 1.119778>
			}
			smooth_triangle {
				<-0.931051, 0.295067, 0.187608>, <0.840205, 0.289884, -0.458283>,
				<-0.931899, 0.287797, 0.194547>, <-0.000313, 0.002746, 0.001154>,
				<-0.933243, 0.291257, 0.182568>, <-0.000313, 0.002746, 0.001154>
			}
			smooth_triangle {
				<-0.933243, 0.291257, 0.182568>, <-0.000313, 0.002746, 0.001154>,
				<-0.933495, 0.282477, 0.194698>, <-0.840517, -0.287138, 0.459437>,
				<-0.931899, 0.287797, 0.194547>, <-0.000313, 0.002746, 0.001154>
			}
			smooth_triangle {
				<-0.935819, 0.295707, 0.160970>, <-0.822982, -0.296476, 0.484564>,
				<-0.935966, 0.298917, 0.154058>, <-1.642983, -0.592184, 0.974621>,
				<-0.937847, 0.292297, 0.155271>, <-1.642983, -0.592184, 0.974621>
			}
			smooth_triangle {
				<-0.935966, 0.298917, 0.154058>, <-1.642983, -0.592184, 0.974621>,
				<-0.939318, 0.292837, 0.145070>, <-0.820001, -0.295708, 0.490057>,
				<-0.937847, 0.292297, 0.155271>, <-1.642983, -0.592184, 0.974621>
			}
			smooth_triangle {
				<-0.788418, -0.308483, 0.521870>, <0.943199, -0.315804, -0.103163>,
				<-0.782819, -0.309043, 0.529912>, <1.886536, -0.632111, -0.203494>,
				<-0.780977, -0.320083, 0.526056>, <1.886536, -0.632111, -0.203494>
			}
			smooth_triangle {
				<-0.782819, -0.309043, 0.529912>, <1.886536, -0.632111, -0.203494>,
				<-0.779573, -0.313223, 0.532241>, <0.943336, -0.316307, -0.100331>,
				<-0.780977, -0.320083, 0.526056>, <1.886536, -0.632111, -0.203494>
			}
			smooth_triangle {
				<-0.919368, 0.295477, 0.237841>, <-1.723438, -0.582698, 0.830797>,
				<-0.920826, 0.296137, 0.231297>, <-0.861919, -0.290814, 0.415358>,
				<-0.922542, 0.293307, 0.228038>, <-1.723438, -0.582698, 0.830797>
			}
			smooth_triangle {
				<-0.919368, 0.295477, 0.237841>, <-1.723438, -0.582698, 0.830797>,
				<-0.922542, 0.293307, 0.228038>, <-1.723438, -0.582698, 0.830797>,
				<-0.924711, 0.286057, 0.228487>, <-0.861519, -0.291884, 0.415439>
			}
			smooth_triangle {
				<-0.468829, 0.876849, 0.021150>, <2.246749, 5.289031, -1.725171>,
				<-0.463092, 0.879689, 0.028345>, <2.629529, 6.192558, -1.932217>,
				<-0.477694, 0.871899, 0.026905>, <2.311383, 5.261392, -1.724260>
			}
			smooth_triangle {
				<-0.475232, 0.871539, 0.060751>, <2.439771, 5.260150, -1.540213>,
				<-0.481645, 0.868539, 0.052595>, <2.427497, 5.240086, -1.626745>,
				<-0.467104, 0.876499, 0.051659>, <1.971080, 4.407333, -1.298984>
			}
			smooth_triangle {
				<-0.467104, 0.876499, 0.051659>, <1.971080, 4.407333, -1.298984>,
				<-0.481645, 0.868539, 0.052595>, <2.427497, 5.240086, -1.626745>,
				<-0.472845, 0.873829, 0.044336>, <2.357944, 5.271593, -1.626946>
			}
			smooth_triangle {
				<-0.481645, 0.868539, 0.052595>, <2.427497, 5.240086, -1.626745>,
				<-0.489194, 0.864759, 0.044609>, <3.251052, 6.956472, -2.243584>,
				<-0.472845, 0.873829, 0.044336>, <2.357944, 5.271593, -1.626946>
			}
			smooth_triangle {
				<-0.472845, 0.873829, 0.044336>, <2.357944, 5.271593, -1.626946>,
				<-0.489194, 0.864759, 0.044609>, <3.251052, 6.956472, -2.243584>,
				<-0.478999, 0.870869, 0.035571>, <3.135044, 7.007102, -2.251127>
			}
			smooth_triangle {
				<-0.489194, 0.864759, 0.044609>, <3.251052, 6.956472, -2.243584>,
				<-0.488335, 0.865549, 0.038275>, <1.602546, 3.483527, -1.138604>,
				<-0.478999, 0.870869, 0.035571>, <3.135044, 7.007102, -2.251127>
			}
			smooth_triangle {
				<-0.490466, 0.864509, 0.034475>, <2.399205, 5.216325, -1.741398>,
				<-0.478999, 0.870869, 0.035571>, <3.135044, 7.007102, -2.251127>,
				<-0.488335, 0.865549, 0.038275>, <1.602546, 3.483527, -1.138604>
			}
			smooth_triangle {
				<-0.490466, 0.864509, 0.034475>, <2.399205, 5.216325, -1.741398>,
				<-0.488335, 0.865549, 0.038275>, <1.602546, 3.483527, -1.138604>,
				<-0.494585, 0.861989, 0.038480>, <1.620404, 3.470549, -1.152882>
			}
			smooth_triangle {
				<-0.488335, 0.865549, 0.038275>, <1.602546, 3.483527, -1.138604>,
				<-0.489194, 0.864759, 0.044609>, <3.251052, 6.956472, -2.243584>,
				<-0.494585, 0.861989, 0.038480>, <1.620404, 3.470549, -1.152882>
			}
			smooth_triangle {
				<-0.467104, 0.876499, 0.051659>, <1.971080, 4.407333, -1.298984>,
				<-0.472845, 0.873829, 0.044336>, <2.357944, 5.271593, -1.626946>,
				<-0.455816, 0.882829, 0.044250>, <2.278848, 5.327488, -1.555765>
			}
			smooth_triangle {
				<-0.478999, 0.870869, 0.035571>, <3.135044, 7.007102, -2.251127>,
				<-0.463795, 0.878989, 0.037277>, <1.903823, 4.419230, -1.357798>,
				<-0.472845, 0.873829, 0.044336>, <2.357944, 5.271593, -1.626946>
			}
			smooth_triangle {
				<-0.472845, 0.873829, 0.044336>, <2.357944, 5.271593, -1.626946>,
				<-0.463795, 0.878989, 0.037277>, <1.903823, 4.419230, -1.357798>,
				<-0.455816, 0.882829, 0.044250>, <2.278848, 5.327488, -1.555765>
			}
			smooth_triangle {
				<-0.463795, 0.878989, 0.037277>, <1.903823, 4.419230, -1.357798>,
				<-0.478999, 0.870869, 0.035571>, <3.135044, 7.007102, -2.251127>,
				<-0.463092, 0.879689, 0.028345>, <2.629529, 6.192558, -1.932217>
			}
			smooth_triangle {
				<-0.490466, 0.864509, 0.034475>, <2.399205, 5.216325, -1.741398>,
				<-0.485938, 0.867209, 0.030428>, <1.969522, 4.360238, -1.452116>,
				<-0.478999, 0.870869, 0.035571>, <3.135044, 7.007102, -2.251127>
			}
			smooth_triangle {
				<-0.463092, 0.879689, 0.028345>, <2.629529, 6.192558, -1.932217>,
				<-0.478999, 0.870869, 0.035571>, <3.135044, 7.007102, -2.251127>,
				<-0.477694, 0.871899, 0.026905>, <2.311383, 5.261392, -1.724260>
			}
			smooth_triangle {
				<-0.478999, 0.870869, 0.035571>, <3.135044, 7.007102, -2.251127>,
				<-0.485938, 0.867209, 0.030428>, <1.969522, 4.360238, -1.452116>,
				<-0.477694, 0.871899, 0.026905>, <2.311383, 5.261392, -1.724260>
			}
			smooth_triangle {
				<-0.455816, 0.882829, 0.044250>, <2.278848, 5.327488, -1.555765>,
				<-0.449537, 0.885359, 0.056291>, <2.687368, 6.233293, -1.705685>,
				<-0.467104, 0.876499, 0.051659>, <1.971080, 4.407333, -1.298984>
			}
			smooth_triangle {
				<-0.449537, 0.885359, 0.056291>, <2.687368, 6.233293, -1.705685>,
				<-0.430330, 0.893999, 0.068540>, <2.258379, 5.391628, -1.346735>,
				<-0.468196, 0.874249, 0.074846>, <2.867945, 6.153635, -1.699579>
			}
			smooth_triangle {
				<-0.430330, 0.893999, 0.068540>, <2.258379, 5.391628, -1.346735>,
				<-0.444031, 0.885579, 0.087791>, <2.393386, 5.342226, -1.308617>,
				<-0.468196, 0.874249, 0.074846>, <2.867945, 6.153635, -1.699579>
			}
			smooth_triangle {
				<-0.430330, 0.893999, 0.068540>, <2.258379, 5.391628, -1.346735>,
				<-0.405099, 0.904959, 0.077824>, <2.173894, 5.459436, -1.203258>,
				<-0.444031, 0.885579, 0.087791>, <2.393386, 5.342226, -1.308617>
			}
			smooth_triangle {
				<-0.444031, 0.885579, 0.087791>, <2.393386, 5.342226, -1.308617>,
				<-0.405099, 0.904959, 0.077824>, <2.173894, 5.459436, -1.203258>,
				<-0.416977, 0.897509, 0.098548>, <2.296056, 5.421348, -1.146217>
			}
			smooth_triangle {
				<-0.405099, 0.904959, 0.077824>, <2.173894, 5.459436, -1.203258>,
				<-0.376176, 0.916769, 0.084493>, <1.726815, 4.608434, -0.872943>,
				<-0.416977, 0.897509, 0.098548>, <2.296056, 5.421348, -1.146217>
			}
			smooth_triangle {
				<-0.468196, 0.874249, 0.074846>, <2.867945, 6.153635, -1.699579>,
				<-0.475232, 0.871539, 0.060751>, <2.439771, 5.260150, -1.540213>,
				<-0.449537, 0.885359, 0.056291>, <2.687368, 6.233293, -1.705685>
			}
			smooth_triangle {
				<-0.449537, 0.885359, 0.056291>, <2.687368, 6.233293, -1.705685>,
				<-0.475232, 0.871539, 0.060751>, <2.439771, 5.260150, -1.540213>,
				<-0.467104, 0.876499, 0.051659>, <1.971080, 4.407333, -1.298984>
			}
			smooth_triangle {
				<-0.494585, 0.861989, 0.038480>, <1.620404, 3.470549, -1.152882>,
				<-0.500371, 0.858819, 0.034276>, <1.622060, 3.457982, -1.187809>,
				<-0.490466, 0.864509, 0.034475>, <2.399205, 5.216325, -1.741398>
			}
			smooth_triangle {
				<-0.500371, 0.858819, 0.034276>, <1.622060, 3.457982, -1.187809>,
				<-0.494385, 0.862449, 0.029788>, <2.399416, 5.202960, -1.780676>,
				<-0.490466, 0.864509, 0.034475>, <2.399205, 5.216325, -1.741398>
			}
			smooth_triangle {
				<-0.473949, 0.874219, 0.014846>, <2.246566, 5.274940, -1.767987>,
				<-0.468829, 0.876849, 0.021150>, <2.246749, 5.289031, -1.725171>,
				<-0.480933, 0.870279, 0.020602>, <2.298890, 5.251554, -1.770603>
			}
			smooth_triangle {
				<-0.468829, 0.876849, 0.021150>, <2.246749, 5.289031, -1.725171>,
				<-0.477694, 0.871899, 0.026905>, <2.311383, 5.261392, -1.724260>,
				<-0.480933, 0.870279, 0.020602>, <2.298890, 5.251554, -1.770603>
			}
			smooth_triangle {
				<-0.490466, 0.864509, 0.034475>, <2.399205, 5.216325, -1.741398>,
				<-0.494385, 0.862449, 0.029788>, <2.399416, 5.202960, -1.780676>,
				<-0.485938, 0.867209, 0.030428>, <1.969522, 4.360238, -1.452116>
			}
			smooth_triangle {
				<-0.494385, 0.862449, 0.029788>, <2.399416, 5.202960, -1.780676>,
				<-0.488046, 0.866189, 0.025396>, <2.352691, 5.226119, -1.775199>,
				<-0.485938, 0.867209, 0.030428>, <1.969522, 4.360238, -1.452116>
			}
			smooth_triangle {
				<-0.480933, 0.870279, 0.020602>, <2.298890, 5.251554, -1.770603>,
				<-0.477694, 0.871899, 0.026905>, <2.311383, 5.261392, -1.724260>,
				<-0.488046, 0.866189, 0.025396>, <2.352691, 5.226119, -1.775199>
			}
			smooth_triangle {
				<-0.488046, 0.866189, 0.025396>, <2.352691, 5.226119, -1.775199>,
				<-0.477694, 0.871899, 0.026905>, <2.311383, 5.261392, -1.724260>,
				<-0.485938, 0.867209, 0.030428>, <1.969522, 4.360238, -1.452116>
			}
			smooth_triangle {
				<-0.390595, 0.904419, 0.136290>, <0.383407, 0.909189, -0.162402>,
				<-0.410118, 0.897979, 0.120584>, <1.119001, 2.734118, -0.520798>,
				<-0.381337, 0.910479, 0.121342>, <0.749708, 1.821373, -0.346098>
			}
			smooth_triangle {
				<-0.410118, 0.897979, 0.120584>, <1.119001, 2.734118, -0.520798>,
				<-0.368422, 0.918049, 0.102803>, <2.083799, 5.525816, -1.046220>,
				<-0.381337, 0.910479, 0.121342>, <0.749708, 1.821373, -0.346098>
			}
			smooth_triangle {
				<-0.368422, 0.918049, 0.102803>, <2.083799, 5.525816, -1.046220>,
				<-0.416977, 0.897509, 0.098548>, <2.296056, 5.421348, -1.146217>,
				<-0.376176, 0.916769, 0.084493>, <1.726815, 4.608434, -0.872943>
			}
			smooth_triangle {
				<-0.368422, 0.918049, 0.102803>, <2.083799, 5.525816, -1.046220>,
				<-0.410118, 0.897979, 0.120584>, <1.119001, 2.734118, -0.520798>,
				<-0.416977, 0.897509, 0.098548>, <2.296056, 5.421348, -1.146217>
			}
			smooth_triangle {
				<-0.480195, 0.870929, 0.002921>, <2.601812, 6.130488, -2.155060>,
				<-0.481042, 0.870409, 0.009924>, <2.256731, 5.253072, -1.819587>,
				<-0.490077, 0.865379, 0.007806>, <2.669600, 6.090999, -2.184336>
			}
			smooth_triangle {
				<-0.488046, 0.866189, 0.025396>, <2.352691, 5.226119, -1.775199>,
				<-0.490983, 0.864669, 0.020262>, <2.346265, 5.216798, -1.810688>,
				<-0.480933, 0.870279, 0.020602>, <2.298890, 5.251554, -1.770603>
			}
			smooth_triangle {
				<-0.473949, 0.874219, 0.014846>, <2.246566, 5.274940, -1.767987>,
				<-0.485922, 0.867619, 0.015076>, <2.689697, 6.107986, -2.111025>,
				<-0.481042, 0.870409, 0.009924>, <2.256731, 5.253072, -1.819587>
			}
			smooth_triangle {
				<-0.490077, 0.865379, 0.007806>, <2.669600, 6.090999, -2.184336>,
				<-0.492363, 0.864029, 0.012270>, <2.327616, 5.212002, -1.848371>,
				<-0.497523, 0.861099, 0.009668>, <1.160144, 2.602156, -0.939557>
			}
			smooth_triangle {
				<-0.492363, 0.864029, 0.012270>, <2.327616, 5.212002, -1.848371>,
				<-0.498593, 0.860429, 0.013464>, <1.174788, 2.599872, -0.927630>,
				<-0.497523, 0.861099, 0.009668>, <1.160144, 2.602156, -0.939557>
			}
			smooth_triangle {
				<-0.485922, 0.867619, 0.015076>, <2.689697, 6.107986, -2.111025>,
				<-0.492363, 0.864029, 0.012270>, <2.327616, 5.212002, -1.848371>,
				<-0.487370, 0.866869, 0.011266>, <1.528691, 3.487546, -1.224630>
			}
			smooth_triangle {
				<-0.492363, 0.864029, 0.012270>, <2.327616, 5.212002, -1.848371>,
				<-0.490077, 0.865379, 0.007806>, <2.669600, 6.090999, -2.184336>,
				<-0.487370, 0.866869, 0.011266>, <1.528691, 3.487546, -1.224630>
			}
			smooth_triangle {
				<-0.485922, 0.867619, 0.015076>, <2.689697, 6.107986, -2.111025>,
				<-0.487370, 0.866869, 0.011266>, <1.528691, 3.487546, -1.224630>,
				<-0.481042, 0.870409, 0.009924>, <2.256731, 5.253072, -1.819587>
			}
			smooth_triangle {
				<-0.487370, 0.866869, 0.011266>, <1.528691, 3.487546, -1.224630>,
				<-0.490077, 0.865379, 0.007806>, <2.669600, 6.090999, -2.184336>,
				<-0.481042, 0.870409, 0.009924>, <2.256731, 5.253072, -1.819587>
			}
			smooth_triangle {
				<-0.498593, 0.860429, 0.013464>, <1.174788, 2.599872, -0.927630>,
				<-0.492363, 0.864029, 0.012270>, <2.327616, 5.212002, -1.848371>,
				<-0.494593, 0.862679, 0.016334>, <2.347299, 5.205618, -1.841532>
			}
			smooth_triangle {
				<-0.473949, 0.874219, 0.014846>, <2.246566, 5.274940, -1.767987>,
				<-0.480933, 0.870279, 0.020602>, <2.298890, 5.251554, -1.770603>,
				<-0.485922, 0.867619, 0.015076>, <2.689697, 6.107986, -2.111025>
			}
			smooth_triangle {
				<-0.490983, 0.864669, 0.020262>, <2.346265, 5.216798, -1.810688>,
				<-0.485922, 0.867619, 0.015076>, <2.689697, 6.107986, -2.111025>,
				<-0.480933, 0.870279, 0.020602>, <2.298890, 5.251554, -1.770603>
			}
			smooth_triangle {
				<-0.485922, 0.867619, 0.015076>, <2.689697, 6.107986, -2.111025>,
				<-0.494593, 0.862679, 0.016334>, <2.347299, 5.205618, -1.841532>,
				<-0.492363, 0.864029, 0.012270>, <2.327616, 5.212002, -1.848371>
			}
			smooth_triangle {
				<-0.485922, 0.867619, 0.015076>, <2.689697, 6.107986, -2.111025>,
				<-0.490983, 0.864669, 0.020262>, <2.346265, 5.216798, -1.810688>,
				<-0.494593, 0.862679, 0.016334>, <2.347299, 5.205618, -1.841532>
			}
			smooth_triangle {
				<-0.487566, 0.866829, -0.001180>, <1.118899, 2.621068, -0.936867>,
				<-0.480195, 0.870929, 0.002921>, <2.601812, 6.130488, -2.155060>,
				<-0.493442, 0.863489, 0.002941>, <1.141517, 2.611106, -0.937428>
			}
			smooth_triangle {
				<-0.493442, 0.863489, 0.002941>, <1.141517, 2.611106, -0.937428>,
				<-0.480195, 0.870929, 0.002921>, <2.601812, 6.130488, -2.155060>,
				<-0.490077, 0.865379, 0.007806>, <2.669600, 6.090999, -2.184336>
			}
			smooth_triangle {
				<-0.497523, 0.861099, 0.009668>, <1.160144, 2.602156, -0.939557>,
				<-0.498439, 0.860599, 0.005698>, <0.770373, 1.734894, -0.629812>,
				<-0.490077, 0.865379, 0.007806>, <2.669600, 6.090999, -2.184336>
			}
			smooth_triangle {
				<-0.490077, 0.865379, 0.007806>, <2.669600, 6.090999, -2.184336>,
				<-0.498439, 0.860599, 0.005698>, <0.770373, 1.734894, -0.629812>,
				<-0.493442, 0.863489, 0.002941>, <1.141517, 2.611106, -0.937428>
			}
			smooth_triangle {
				<-0.498593, 0.860429, 0.013464>, <1.174788, 2.599872, -0.927630>,
				<-0.494593, 0.862679, 0.016334>, <2.347299, 5.205618, -1.841532>,
				<-0.501620, 0.858608, 0.017153>, <1.188439, 2.595522, -0.922344>
			}
			smooth_triangle {
				<-0.504750, 0.856678, 0.020875>, <1.204006, 2.589303, -0.919709>,
				<-0.498145, 0.860449, 0.024406>, <2.796785, 6.056000, -2.121682>,
				<-0.507442, 0.854989, 0.024962>, <1.214531, 2.585699, -0.915958>
			}
			smooth_triangle {
				<-0.509797, 0.853409, 0.030371>, <0.819657, 1.720709, -0.606064>,
				<-0.507442, 0.854989, 0.024962>, <1.214531, 2.585699, -0.915958>,
				<-0.503189, 0.857339, 0.029735>, <2.440730, 5.173172, -1.811192>
			}
			smooth_triangle {
				<-0.507442, 0.854989, 0.024962>, <1.214531, 2.585699, -0.915958>,
				<-0.498145, 0.860449, 0.024406>, <2.796785, 6.056000, -2.121682>,
				<-0.503189, 0.857339, 0.029735>, <2.440730, 5.173172, -1.811192>
			}
			smooth_triangle {
				<-0.498145, 0.860449, 0.024406>, <2.796785, 6.056000, -2.121682>,
				<-0.494385, 0.862449, 0.029788>, <2.399416, 5.202960, -1.780676>,
				<-0.503189, 0.857339, 0.029735>, <2.440730, 5.173172, -1.811192>
			}
			smooth_triangle {
				<-0.494385, 0.862449, 0.029788>, <2.399416, 5.202960, -1.780676>,
				<-0.500371, 0.858819, 0.034276>, <1.622060, 3.457982, -1.187809>,
				<-0.503189, 0.857339, 0.029735>, <2.440730, 5.173172, -1.811192>
			}
			smooth_triangle {
				<-0.500371, 0.858819, 0.034276>, <1.622060, 3.457982, -1.187809>,
				<-0.508828, 0.853819, 0.034636>, <0.821574, 1.721315, -0.601736>,
				<-0.503189, 0.857339, 0.029735>, <2.440730, 5.173172, -1.811192>
			}
			smooth_triangle {
				<-0.509797, 0.853409, 0.030371>, <0.819657, 1.720709, -0.606064>,
				<-0.503189, 0.857339, 0.029735>, <2.440730, 5.173172, -1.811192>,
				<-0.508828, 0.853819, 0.034636>, <0.821574, 1.721315, -0.601736>
			}
			smooth_triangle {
				<-0.494385, 0.862449, 0.029788>, <2.399416, 5.202960, -1.780676>,
				<-0.498145, 0.860449, 0.024406>, <2.796785, 6.056000, -2.121682>,
				<-0.488046, 0.866189, 0.025396>, <2.352691, 5.226119, -1.775199>
			}
			smooth_triangle {
				<-0.504750, 0.856678, 0.020875>, <1.204006, 2.589303, -0.919709>,
				<-0.498034, 0.860628, 0.019809>, <1.983651, 4.326555, -1.531532>,
				<-0.498145, 0.860449, 0.024406>, <2.796785, 6.056000, -2.121682>
			}
			smooth_triangle {
				<-0.488046, 0.866189, 0.025396>, <2.352691, 5.226119, -1.775199>,
				<-0.498145, 0.860449, 0.024406>, <2.796785, 6.056000, -2.121682>,
				<-0.490983, 0.864669, 0.020262>, <2.346265, 5.216798, -1.810688>
			}
			smooth_triangle {
				<-0.498145, 0.860449, 0.024406>, <2.796785, 6.056000, -2.121682>,
				<-0.498034, 0.860628, 0.019809>, <1.983651, 4.326555, -1.531532>,
				<-0.490983, 0.864669, 0.020262>, <2.346265, 5.216798, -1.810688>
			}
			smooth_triangle {
				<-0.490983, 0.864669, 0.020262>, <2.346265, 5.216798, -1.810688>,
				<-0.498034, 0.860628, 0.019809>, <1.983651, 4.326555, -1.531532>,
				<-0.494593, 0.862679, 0.016334>, <2.347299, 5.205618, -1.841532>
			}
			smooth_triangle {
				<-0.504750, 0.856678, 0.020875>, <1.204006, 2.589303, -0.919709>,
				<-0.501620, 0.858608, 0.017153>, <1.188439, 2.595522, -0.922344>,
				<-0.498034, 0.860628, 0.019809>, <1.983651, 4.326555, -1.531532>
			}
			smooth_triangle {
				<-0.498034, 0.860628, 0.019809>, <1.983651, 4.326555, -1.531532>,
				<-0.501620, 0.858608, 0.017153>, <1.188439, 2.595522, -0.922344>,
				<-0.494593, 0.862679, 0.016334>, <2.347299, 5.205618, -1.841532>
			}
			smooth_triangle {
				<-0.481645, 0.868539, 0.052595>, <2.427497, 5.240086, -1.626745>,
				<-0.475232, 0.871539, 0.060751>, <2.439771, 5.260150, -1.540213>,
				<-0.489499, 0.863679, 0.059772>, <2.079490, 4.343770, -1.343581>
			}
			smooth_triangle {
				<-0.450411, 0.874569, 0.146197>, <0.428148, 0.879136, -0.209309>,
				<-0.480087, 0.860199, 0.136687>, <1.310917, 2.626135, -0.617592>,
				<-0.430559, 0.888309, 0.120975>, <1.269380, 2.650002, -0.601823>
			}
			smooth_triangle {
				<-0.430559, 0.888309, 0.120975>, <1.269380, 2.650002, -0.601823>,
				<-0.459721, 0.874999, 0.110226>, <2.556257, 5.277582, -1.259763>,
				<-0.416977, 0.897509, 0.098548>, <2.296056, 5.421348, -1.146217>
			}
			smooth_triangle {
				<-0.416977, 0.897509, 0.098548>, <2.296056, 5.421348, -1.146217>,
				<-0.459721, 0.874999, 0.110226>, <2.556257, 5.277582, -1.259763>,
				<-0.444031, 0.885579, 0.087791>, <2.393386, 5.342226, -1.308617>
			}
			smooth_triangle {
				<-0.459721, 0.874999, 0.110226>, <2.556257, 5.277582, -1.259763>,
				<-0.481175, 0.865049, 0.096310>, <2.600461, 5.219447, -1.406771>,
				<-0.444031, 0.885579, 0.087791>, <2.393386, 5.342226, -1.308617>
			}
			smooth_triangle {
				<-0.444031, 0.885579, 0.087791>, <2.393386, 5.342226, -1.308617>,
				<-0.481175, 0.865049, 0.096310>, <2.600461, 5.219447, -1.406771>,
				<-0.468196, 0.874249, 0.074846>, <2.867945, 6.153635, -1.699579>
			}
			smooth_triangle {
				<-0.481175, 0.865049, 0.096310>, <2.600461, 5.219447, -1.406771>,
				<-0.499789, 0.855659, 0.084659>, <2.639727, 5.162734, -1.538561>,
				<-0.468196, 0.874249, 0.074846>, <2.867945, 6.153635, -1.699579>
			}
			smooth_triangle {
				<-0.499789, 0.855659, 0.084659>, <2.639727, 5.162734, -1.538561>,
				<-0.494572, 0.860059, 0.069408>, <2.993733, 6.054437, -1.836473>,
				<-0.468196, 0.874249, 0.074846>, <2.867945, 6.153635, -1.699579>
			}
			smooth_triangle {
				<-0.468196, 0.874249, 0.074846>, <2.867945, 6.153635, -1.699579>,
				<-0.494572, 0.860059, 0.069408>, <2.993733, 6.054437, -1.836473>,
				<-0.475232, 0.871539, 0.060751>, <2.439771, 5.260150, -1.540213>
			}
			smooth_triangle {
				<-0.494572, 0.860059, 0.069408>, <2.993733, 6.054437, -1.836473>,
				<-0.489499, 0.863679, 0.059772>, <2.079490, 4.343770, -1.343581>,
				<-0.475232, 0.871539, 0.060751>, <2.439771, 5.260150, -1.540213>
			}
			smooth_triangle {
				<-0.499789, 0.855659, 0.084659>, <2.639727, 5.162734, -1.538561>,
				<-0.481175, 0.865049, 0.096310>, <2.600461, 5.219447, -1.406771>,
				<-0.510554, 0.847659, 0.099553>, <1.346426, 2.573712, -0.749333>
			}
			smooth_triangle {
				<-0.430559, 0.888309, 0.120975>, <1.269380, 2.650002, -0.601823>,
				<-0.480087, 0.860199, 0.136687>, <1.310917, 2.626135, -0.617592>,
				<-0.459721, 0.874999, 0.110226>, <2.556257, 5.277582, -1.259763>
			}
			smooth_triangle {
				<-0.480087, 0.860199, 0.136687>, <1.310917, 2.626135, -0.617592>,
				<-0.502188, 0.849919, 0.120678>, <1.340682, 2.595752, -0.680911>,
				<-0.459721, 0.874999, 0.110226>, <2.556257, 5.277582, -1.259763>
			}
			smooth_triangle {
				<-0.510554, 0.847659, 0.099553>, <1.346426, 2.573712, -0.749333>,
				<-0.481175, 0.865049, 0.096310>, <2.600461, 5.219447, -1.406771>,
				<-0.502188, 0.849919, 0.120678>, <1.340682, 2.595752, -0.680911>
			}
			smooth_triangle {
				<-0.481175, 0.865049, 0.096310>, <2.600461, 5.219447, -1.406771>,
				<-0.459721, 0.874999, 0.110226>, <2.556257, 5.277582, -1.259763>,
				<-0.502188, 0.849919, 0.120678>, <1.340682, 2.595752, -0.680911>
			}
			smooth_triangle {
				<-0.510554, 0.847659, 0.099553>, <1.346426, 2.573712, -0.749333>,
				<-0.526536, 0.838878, 0.090276>, <2.307863, 4.226656, -1.343255>,
				<-0.499789, 0.855659, 0.084659>, <2.639727, 5.162734, -1.538561>
			}
			smooth_triangle {
				<-0.526536, 0.838878, 0.090276>, <2.307863, 4.226656, -1.343255>,
				<-0.516174, 0.846569, 0.077470>, <2.691051, 5.107958, -1.631102>,
				<-0.499789, 0.855659, 0.084659>, <2.639727, 5.162734, -1.538561>
			}
			smooth_triangle {
				<-0.494585, 0.861989, 0.038480>, <1.620404, 3.470549, -1.152882>,
				<-0.489194, 0.864759, 0.044609>, <3.251052, 6.956472, -2.243584>,
				<-0.499527, 0.858869, 0.043932>, <1.244166, 2.593027, -0.853117>
			}
			smooth_triangle {
				<-0.499789, 0.855659, 0.084659>, <2.639727, 5.162734, -1.538561>,
				<-0.516174, 0.846569, 0.077470>, <2.691051, 5.107958, -1.631102>,
				<-0.494572, 0.860059, 0.069408>, <2.993733, 6.054437, -1.836473>
			}
			smooth_triangle {
				<-0.516174, 0.846569, 0.077470>, <2.691051, 5.107958, -1.631102>,
				<-0.511824, 0.850129, 0.066614>, <2.629100, 5.128790, -1.667197>,
				<-0.494572, 0.860059, 0.069408>, <2.993733, 6.054437, -1.836473>
			}
			smooth_triangle {
				<-0.503885, 0.855959, 0.050344>, <2.525294, 5.165820, -1.713032>,
				<-0.495587, 0.860549, 0.054477>, <2.498128, 5.190831, -1.676914>,
				<-0.508813, 0.852558, 0.057990>, <2.575349, 5.143032, -1.707155>
			}
			smooth_triangle {
				<-0.511824, 0.850129, 0.066614>, <2.629100, 5.128790, -1.667197>,
				<-0.508813, 0.852558, 0.057990>, <2.575349, 5.143032, -1.707155>,
				<-0.500112, 0.857439, 0.061655>, <2.129071, 4.309320, -1.376712>
			}
			smooth_triangle {
				<-0.508813, 0.852558, 0.057990>, <2.575349, 5.143032, -1.707155>,
				<-0.495587, 0.860549, 0.054477>, <2.498128, 5.190831, -1.676914>,
				<-0.500112, 0.857439, 0.061655>, <2.129071, 4.309320, -1.376712>
			}
			smooth_triangle {
				<-0.495587, 0.860549, 0.054477>, <2.498128, 5.190831, -1.676914>,
				<-0.489499, 0.863679, 0.059772>, <2.079490, 4.343770, -1.343581>,
				<-0.500112, 0.857439, 0.061655>, <2.129071, 4.309320, -1.376712>
			}
			smooth_triangle {
				<-0.511824, 0.850129, 0.066614>, <2.629100, 5.128790, -1.667197>,
				<-0.500112, 0.857439, 0.061655>, <2.129071, 4.309320, -1.376712>,
				<-0.494572, 0.860059, 0.069408>, <2.993733, 6.054437, -1.836473>
			}
			smooth_triangle {
				<-0.500112, 0.857439, 0.061655>, <2.129071, 4.309320, -1.376712>,
				<-0.489499, 0.863679, 0.059772>, <2.079490, 4.343770, -1.343581>,
				<-0.494572, 0.860059, 0.069408>, <2.993733, 6.054437, -1.836473>
			}
			smooth_triangle {
				<-0.489499, 0.863679, 0.059772>, <2.079490, 4.343770, -1.343581>,
				<-0.495587, 0.860549, 0.054477>, <2.498128, 5.190831, -1.676914>,
				<-0.481645, 0.868539, 0.052595>, <2.427497, 5.240086, -1.626745>
			}
			smooth_triangle {
				<-0.481645, 0.868539, 0.052595>, <2.427497, 5.240086, -1.626745>,
				<-0.495587, 0.860549, 0.054477>, <2.498128, 5.190831, -1.676914>,
				<-0.489194, 0.864759, 0.044609>, <3.251052, 6.956472, -2.243584>
			}
			smooth_triangle {
				<-0.495587, 0.860549, 0.054477>, <2.498128, 5.190831, -1.676914>,
				<-0.503885, 0.855959, 0.050344>, <2.525294, 5.165820, -1.713032>,
				<-0.489194, 0.864759, 0.044609>, <3.251052, 6.956472, -2.243584>
			}
			smooth_triangle {
				<-0.503885, 0.855959, 0.050344>, <2.525294, 5.165820, -1.713032>,
				<-0.499527, 0.858869, 0.043932>, <1.244166, 2.593027, -0.853117>,
				<-0.489194, 0.864759, 0.044609>, <3.251052, 6.956472, -2.243584>
			}
			smooth_triangle {
				<-0.499527, 0.858869, 0.043932>, <1.244166, 2.593027, -0.853117>,
				<-0.503885, 0.855959, 0.050344>, <2.525294, 5.165820, -1.713032>,
				<-0.510038, 0.852508, 0.047009>, <0.847658, 1.717549, -0.575596>
			}
			smooth_triangle {
				<-0.516174, 0.846569, 0.077470>, <2.691051, 5.107958, -1.631102>,
				<-0.527323, 0.840188, 0.071604>, <1.349396, 2.544470, -0.839194>,
				<-0.511824, 0.850129, 0.066614>, <2.629100, 5.128790, -1.667197>
			}
			smooth_triangle {
				<-0.527323, 0.840188, 0.071604>, <1.349396, 2.544470, -0.839194>,
				<-0.523392, 0.843438, 0.061556>, <1.318254, 2.555501, -0.855199>,
				<-0.511824, 0.850129, 0.066614>, <2.629100, 5.128790, -1.667197>
			}
			smooth_triangle {
				<-0.511824, 0.850129, 0.066614>, <2.629100, 5.128790, -1.667197>,
				<-0.523392, 0.843438, 0.061556>, <1.318254, 2.555501, -0.855199>,
				<-0.508813, 0.852558, 0.057990>, <2.575349, 5.143032, -1.707155>
			}
			smooth_triangle {
				<-0.523392, 0.843438, 0.061556>, <1.318254, 2.555501, -0.855199>,
				<-0.517670, 0.847519, 0.053347>, <1.292434, 2.566510, -0.861567>,
				<-0.508813, 0.852558, 0.057990>, <2.575349, 5.143032, -1.707155>
			}
			smooth_triangle {
				<-0.508813, 0.852558, 0.057990>, <2.575349, 5.143032, -1.707155>,
				<-0.517670, 0.847519, 0.053347>, <1.292434, 2.566510, -0.861567>,
				<-0.503885, 0.855959, 0.050344>, <2.525294, 5.165820, -1.713032>
			}
			smooth_triangle {
				<-0.517670, 0.847519, 0.053347>, <1.292434, 2.566510, -0.861567>,
				<-0.510038, 0.852508, 0.047009>, <0.847658, 1.717549, -0.575596>,
				<-0.503885, 0.855959, 0.050344>, <2.525294, 5.165820, -1.713032>
			}
			smooth_triangle {
				<-0.526536, 0.838878, 0.090276>, <2.307863, 4.226656, -1.343255>,
				<-0.536048, 0.833658, 0.082332>, <1.386070, 2.528046, -0.829033>,
				<-0.516174, 0.846569, 0.077470>, <2.691051, 5.107958, -1.631102>
			}
			smooth_triangle {
				<-0.516174, 0.846569, 0.077470>, <2.691051, 5.107958, -1.631102>,
				<-0.536048, 0.833658, 0.082332>, <1.386070, 2.528046, -0.829033>,
				<-0.527323, 0.840188, 0.071604>, <1.349396, 2.544470, -0.839194>
			}
			smooth_triangle {
				<-0.484196, 0.868659, -0.010170>, <1.075362, 2.629472, -0.963647>,
				<-0.476355, 0.873029, -0.005040>, <1.815657, 4.389404, -1.560277>,
				<-0.487566, 0.866829, -0.001180>, <1.118899, 2.621068, -0.936867>
			}
			smooth_triangle {
				<-0.333907, 0.935719, 0.045226>, <1.195017, 3.746551, -0.729226>,
				<-0.374877, 0.919999, 0.046603>, <2.234349, 6.473870, -1.439823>,
				<-0.338327, 0.934549, 0.035463>, <0.891144, 2.800867, -0.599579>
			}
			smooth_triangle {
				<-0.338327, 0.934549, 0.035463>, <0.891144, 2.800867, -0.599579>,
				<-0.374877, 0.919999, 0.046603>, <2.234349, 6.473870, -1.439823>,
				<-0.369878, 0.922749, 0.028976>, <1.818489, 5.566847, -1.299659>
			}
			smooth_triangle {
				<-0.399899, 0.910339, 0.021871>, <1.927718, 5.493576, -1.447185>,
				<-0.425582, 0.898419, 0.029114>, <2.080962, 5.420691, -1.509381>,
				<-0.423156, 0.899859, 0.017771>, <1.682743, 4.523803, -1.303032>
			}
			smooth_triangle {
				<-0.473949, 0.874219, 0.014846>, <2.246566, 5.274940, -1.767987>,
				<-0.458142, 0.882609, 0.014689>, <2.531036, 6.212982, -1.997052>,
				<-0.468829, 0.876849, 0.021150>, <2.246749, 5.289031, -1.725171>
			}
			smooth_triangle {
				<-0.463092, 0.879689, 0.028345>, <2.629529, 6.192558, -1.932217>,
				<-0.458824, 0.882119, 0.021592>, <1.469994, 3.548975, -1.114696>,
				<-0.445044, 0.889139, 0.022209>, <2.500248, 6.259216, -1.887811>
			}
			smooth_triangle {
				<-0.458142, 0.882609, 0.014689>, <2.531036, 6.212982, -1.997052>,
				<-0.445044, 0.889139, 0.022209>, <2.500248, 6.259216, -1.887811>,
				<-0.458824, 0.882119, 0.021592>, <1.469994, 3.548975, -1.114696>
			}
			smooth_triangle {
				<-0.458142, 0.882609, 0.014689>, <2.531036, 6.212982, -1.997052>,
				<-0.458824, 0.882119, 0.021592>, <1.469994, 3.548975, -1.114696>,
				<-0.468829, 0.876849, 0.021150>, <2.246749, 5.289031, -1.725171>
			}
			smooth_triangle {
				<-0.458824, 0.882119, 0.021592>, <1.469994, 3.548975, -1.114696>,
				<-0.463092, 0.879689, 0.028345>, <2.629529, 6.192558, -1.932217>,
				<-0.468829, 0.876849, 0.021150>, <2.246749, 5.289031, -1.725171>
			}
			smooth_triangle {
				<-0.445044, 0.889139, 0.022209>, <2.500248, 6.259216, -1.887811>,
				<-0.447861, 0.887349, 0.033880>, <2.199039, 5.354297, -1.578296>,
				<-0.463092, 0.879689, 0.028345>, <2.629529, 6.192558, -1.932217>
			}
			smooth_triangle {
				<-0.463092, 0.879689, 0.028345>, <2.629529, 6.192558, -1.932217>,
				<-0.447861, 0.887349, 0.033880>, <2.199039, 5.354297, -1.578296>,
				<-0.463795, 0.878989, 0.037277>, <1.903823, 4.419230, -1.357798>
			}
			smooth_triangle {
				<-0.458142, 0.882609, 0.014689>, <2.531036, 6.212982, -1.997052>,
				<-0.473949, 0.874219, 0.014846>, <2.246566, 5.274940, -1.767987>,
				<-0.468530, 0.877229, 0.007676>, <2.194251, 5.292272, -1.781740>
			}
			smooth_triangle {
				<-0.473949, 0.874219, 0.014846>, <2.246566, 5.274940, -1.767987>,
				<-0.481042, 0.870409, 0.009924>, <2.256731, 5.253072, -1.819587>,
				<-0.468530, 0.877229, 0.007676>, <2.194251, 5.292272, -1.781740>
			}
			smooth_triangle {
				<-0.445044, 0.889139, 0.022209>, <2.500248, 6.259216, -1.887811>,
				<-0.458142, 0.882609, 0.014689>, <2.531036, 6.212982, -1.997052>,
				<-0.437711, 0.892979, 0.010116>, <2.049954, 5.389581, -1.656076>
			}
			smooth_triangle {
				<-0.468530, 0.877229, 0.007676>, <2.194251, 5.292272, -1.781740>,
				<-0.453494, 0.885119, 0.005215>, <1.759178, 4.450354, -1.447775>,
				<-0.458142, 0.882609, 0.014689>, <2.531036, 6.212982, -1.997052>
			}
			smooth_triangle {
				<-0.458142, 0.882609, 0.014689>, <2.531036, 6.212982, -1.997052>,
				<-0.453494, 0.885119, 0.005215>, <1.759178, 4.450354, -1.447775>,
				<-0.437711, 0.892979, 0.010116>, <2.049954, 5.389581, -1.656076>
			}
			smooth_triangle {
				<-0.453494, 0.885119, 0.005215>, <1.759178, 4.450354, -1.447775>,
				<-0.468530, 0.877229, 0.007676>, <2.194251, 5.292272, -1.781740>,
				<-0.463907, 0.879719, -0.001517>, <2.127020, 5.309503, -1.811003>
			}
			smooth_triangle {
				<-0.463907, 0.879719, -0.001517>, <2.127020, 5.309503, -1.811003>,
				<-0.468530, 0.877229, 0.007676>, <2.194251, 5.292272, -1.781740>,
				<-0.480195, 0.870929, 0.002921>, <2.601812, 6.130488, -2.155060>
			}
			smooth_triangle {
				<-0.468530, 0.877229, 0.007676>, <2.194251, 5.292272, -1.781740>,
				<-0.481042, 0.870409, 0.009924>, <2.256731, 5.253072, -1.819587>,
				<-0.480195, 0.870929, 0.002921>, <2.601812, 6.130488, -2.155060>
			}
			smooth_triangle {
				<-0.463907, 0.879719, -0.001517>, <2.127020, 5.309503, -1.811003>,
				<-0.480195, 0.870929, 0.002921>, <2.601812, 6.130488, -2.155060>,
				<-0.476355, 0.873029, -0.005040>, <1.815657, 4.389404, -1.560277>
			}
			smooth_triangle {
				<-0.480195, 0.870929, 0.002921>, <2.601812, 6.130488, -2.155060>,
				<-0.487566, 0.866829, -0.001180>, <1.118899, 2.621068, -0.936867>,
				<-0.476355, 0.873029, -0.005040>, <1.815657, 4.389404, -1.560277>
			}
			smooth_triangle {
				<-0.447861, 0.887349, 0.033880>, <2.199039, 5.354297, -1.578296>,
				<-0.445044, 0.889139, 0.022209>, <2.500248, 6.259216, -1.887811>,
				<-0.425582, 0.898419, 0.029114>, <2.080962, 5.420691, -1.509381>
			}
			smooth_triangle {
				<-0.437711, 0.892979, 0.010116>, <2.049954, 5.389581, -1.656076>,
				<-0.423156, 0.899859, 0.017771>, <1.682743, 4.523803, -1.303032>,
				<-0.445044, 0.889139, 0.022209>, <2.500248, 6.259216, -1.887811>
			}
			smooth_triangle {
				<-0.445044, 0.889139, 0.022209>, <2.500248, 6.259216, -1.887811>,
				<-0.423156, 0.899859, 0.017771>, <1.682743, 4.523803, -1.303032>,
				<-0.425582, 0.898419, 0.029114>, <2.080962, 5.420691, -1.509381>
			}
			smooth_triangle {
				<-0.399899, 0.910339, 0.021871>, <1.927718, 5.493576, -1.447185>,
				<-0.403359, 0.908329, 0.036836>, <2.011333, 5.480108, -1.382113>,
				<-0.425582, 0.898419, 0.029114>, <2.080962, 5.420691, -1.509381>
			}
			smooth_triangle {
				<-0.403359, 0.908329, 0.036836>, <2.011333, 5.480108, -1.382113>,
				<-0.433089, 0.894299, 0.042072>, <2.169253, 5.396433, -1.470991>,
				<-0.425582, 0.898419, 0.029114>, <2.080962, 5.420691, -1.509381>
			}
			smooth_triangle {
				<-0.425582, 0.898419, 0.029114>, <2.080962, 5.420691, -1.509381>,
				<-0.433089, 0.894299, 0.042072>, <2.169253, 5.396433, -1.470991>,
				<-0.447861, 0.887349, 0.033880>, <2.199039, 5.354297, -1.578296>
			}
			smooth_triangle {
				<-0.433089, 0.894299, 0.042072>, <2.169253, 5.396433, -1.470991>,
				<-0.455816, 0.882829, 0.044250>, <2.278848, 5.327488, -1.555765>,
				<-0.447861, 0.887349, 0.033880>, <2.199039, 5.354297, -1.578296>
			}
			smooth_triangle {
				<-0.455816, 0.882829, 0.044250>, <2.278848, 5.327488, -1.555765>,
				<-0.463795, 0.878989, 0.037277>, <1.903823, 4.419230, -1.357798>,
				<-0.447861, 0.887349, 0.033880>, <2.199039, 5.354297, -1.578296>
			}
			smooth_triangle {
				<-0.455816, 0.882829, 0.044250>, <2.278848, 5.327488, -1.555765>,
				<-0.433089, 0.894299, 0.042072>, <2.169253, 5.396433, -1.470991>,
				<-0.449537, 0.885359, 0.056291>, <2.687368, 6.233293, -1.705685>
			}
			smooth_triangle {
				<-0.403359, 0.908329, 0.036836>, <2.011333, 5.480108, -1.382113>,
				<-0.415156, 0.902239, 0.052087>, <2.118458, 5.443497, -1.365234>,
				<-0.433089, 0.894299, 0.042072>, <2.169253, 5.396433, -1.470991>
			}
			smooth_triangle {
				<-0.433089, 0.894299, 0.042072>, <2.169253, 5.396433, -1.470991>,
				<-0.415156, 0.902239, 0.052087>, <2.118458, 5.443497, -1.365234>,
				<-0.449537, 0.885359, 0.056291>, <2.687368, 6.233293, -1.705685>
			}
			smooth_triangle {
				<-0.399899, 0.910339, 0.021871>, <1.927718, 5.493576, -1.447185>,
				<-0.369878, 0.922749, 0.028976>, <1.818489, 5.566847, -1.299659>,
				<-0.403359, 0.908329, 0.036836>, <2.011333, 5.480108, -1.382113>
			}
			smooth_triangle {
				<-0.369878, 0.922749, 0.028976>, <1.818489, 5.566847, -1.299659>,
				<-0.374877, 0.919999, 0.046603>, <2.234349, 6.473870, -1.439823>,
				<-0.403359, 0.908329, 0.036836>, <2.011333, 5.480108, -1.382113>
			}
			smooth_triangle {
				<-0.415156, 0.902239, 0.052087>, <2.118458, 5.443497, -1.365234>,
				<-0.403359, 0.908329, 0.036836>, <2.011333, 5.480108, -1.382113>,
				<-0.374877, 0.919999, 0.046603>, <2.234349, 6.473870, -1.439823>
			}
			smooth_triangle {
				<-0.342919, 0.928609, 0.095906>, <0.654994, 1.856050, -0.351010>,
				<-0.347612, 0.924819, 0.114007>, <0.338916, 0.928559, -0.151376>,
				<-0.368422, 0.918049, 0.102803>, <2.083799, 5.525816, -1.046220>
			}
			smooth_triangle {
				<-0.449537, 0.885359, 0.056291>, <2.687368, 6.233293, -1.705685>,
				<-0.415156, 0.902239, 0.052087>, <2.118458, 5.443497, -1.365234>,
				<-0.430330, 0.893999, 0.068540>, <2.258379, 5.391628, -1.346735>
			}
			smooth_triangle {
				<-0.405099, 0.904959, 0.077824>, <2.173894, 5.459436, -1.203258>,
				<-0.397953, 0.909329, 0.062103>, <1.733530, 4.571467, -1.041452>,
				<-0.362804, 0.923709, 0.065192>, <2.260499, 6.498509, -1.277201>
			}
			smooth_triangle {
				<-0.333907, 0.935719, 0.045226>, <1.195017, 3.746551, -0.729226>,
				<-0.362804, 0.923709, 0.065192>, <2.260499, 6.498509, -1.277201>,
				<-0.374877, 0.919999, 0.046603>, <2.234349, 6.473870, -1.439823>
			}
			smooth_triangle {
				<-0.362804, 0.923709, 0.065192>, <2.260499, 6.498509, -1.277201>,
				<-0.397953, 0.909329, 0.062103>, <1.733530, 4.571467, -1.041452>,
				<-0.374877, 0.919999, 0.046603>, <2.234349, 6.473870, -1.439823>
			}
			smooth_triangle {
				<-0.322997, 0.938629, 0.061370>, <0.894697, 2.816720, -0.514176>,
				<-0.333907, 0.935719, 0.045226>, <1.195017, 3.746551, -0.729226>,
				<-0.314624, 0.942149, 0.049710>, <0.282535, 0.943861, -0.171175>
			}
			smooth_triangle {
				<-0.322997, 0.938629, 0.061370>, <0.894697, 2.816720, -0.514176>,
				<-0.362804, 0.923709, 0.065192>, <2.260499, 6.498509, -1.277201>,
				<-0.333907, 0.935719, 0.045226>, <1.195017, 3.746551, -0.729226>
			}
			smooth_triangle {
				<-0.374877, 0.919999, 0.046603>, <2.234349, 6.473870, -1.439823>,
				<-0.397953, 0.909329, 0.062103>, <1.733530, 4.571467, -1.041452>,
				<-0.415156, 0.902239, 0.052087>, <2.118458, 5.443497, -1.365234>
			}
			smooth_triangle {
				<-0.405099, 0.904959, 0.077824>, <2.173894, 5.459436, -1.203258>,
				<-0.430330, 0.893999, 0.068540>, <2.258379, 5.391628, -1.346735>,
				<-0.397953, 0.909329, 0.062103>, <1.733530, 4.571467, -1.041452>
			}
			smooth_triangle {
				<-0.397953, 0.909329, 0.062103>, <1.733530, 4.571467, -1.041452>,
				<-0.430330, 0.893999, 0.068540>, <2.258379, 5.391628, -1.346735>,
				<-0.415156, 0.902239, 0.052087>, <2.118458, 5.443497, -1.365234>
			}
			smooth_triangle {
				<-0.405099, 0.904959, 0.077824>, <2.173894, 5.459436, -1.203258>,
				<-0.362804, 0.923709, 0.065192>, <2.260499, 6.498509, -1.277201>,
				<-0.376176, 0.916769, 0.084493>, <1.726815, 4.608434, -0.872943>
			}
			smooth_triangle {
				<-0.376176, 0.916769, 0.084493>, <1.726815, 4.608434, -0.872943>,
				<-0.362804, 0.923709, 0.065192>, <2.260499, 6.498509, -1.277201>,
				<-0.325376, 0.936629, 0.077204>, <1.274701, 3.727798, -0.687670>
			}
			smooth_triangle {
				<-0.362804, 0.923709, 0.065192>, <2.260499, 6.498509, -1.277201>,
				<-0.322997, 0.938629, 0.061370>, <0.894697, 2.816720, -0.514176>,
				<-0.325376, 0.936629, 0.077204>, <1.274701, 3.727798, -0.687670>
			}
			smooth_triangle {
				<-0.368422, 0.918049, 0.102803>, <2.083799, 5.525816, -1.046220>,
				<-0.325376, 0.936629, 0.077204>, <1.274701, 3.727798, -0.687670>,
				<-0.342919, 0.928609, 0.095906>, <0.654994, 1.856050, -0.351010>
			}
			smooth_triangle {
				<-0.368422, 0.918049, 0.102803>, <2.083799, 5.525816, -1.046220>,
				<-0.376176, 0.916769, 0.084493>, <1.726815, 4.608434, -0.872943>,
				<-0.325376, 0.936629, 0.077204>, <1.274701, 3.727798, -0.687670>
			}
			smooth_triangle {
				<-0.494861, 0.861439, -0.046401>, <1.016260, 2.623453, -1.041128>,
				<-0.497494, 0.858568, -0.066854>, <0.971361, 2.616940, -1.098535>,
				<-0.463697, 0.878119, -0.054798>, <1.920726, 5.296658, -2.059397>
			}
			smooth_triangle {
				<-0.338327, 0.934549, 0.035463>, <0.891144, 2.800867, -0.599579>,
				<-0.369878, 0.922749, 0.028976>, <1.818489, 5.566847, -1.299659>,
				<-0.331711, 0.937379, 0.020199>, <0.847301, 2.806212, -0.638070>
			}
			smooth_triangle {
				<-0.433961, 0.893899, -0.041762>, <1.844165, 5.391059, -1.877079>,
				<-0.435895, 0.893619, -0.023547>, <1.923443, 5.390623, -1.797122>,
				<-0.464844, 0.878539, -0.034619>, <2.010650, 5.299491, -1.964885>
			}
			smooth_triangle {
				<-0.435895, 0.893619, -0.023547>, <1.923443, 5.390623, -1.797122>,
				<-0.438661, 0.892559, -0.004660>, <2.328709, 6.283749, -2.019381>,
				<-0.465498, 0.878749, -0.015064>, <2.423949, 6.186206, -2.200862>
			}
			smooth_triangle {
				<-0.438661, 0.892559, -0.004660>, <2.328709, 6.283749, -2.019381>,
				<-0.463907, 0.879719, -0.001517>, <2.127020, 5.309503, -1.811003>,
				<-0.465498, 0.878749, -0.015064>, <2.423949, 6.186206, -2.200862>
			}
			smooth_triangle {
				<-0.463907, 0.879719, -0.001517>, <2.127020, 5.309503, -1.811003>,
				<-0.476355, 0.873029, -0.005040>, <1.815657, 4.389404, -1.560277>,
				<-0.465498, 0.878749, -0.015064>, <2.423949, 6.186206, -2.200862>
			}
			smooth_triangle {
				<-0.476355, 0.873029, -0.005040>, <1.815657, 4.389404, -1.560277>,
				<-0.484196, 0.868659, -0.010170>, <1.075362, 2.629472, -0.963647>,
				<-0.465498, 0.878749, -0.015064>, <2.423949, 6.186206, -2.200862>
			}
			smooth_triangle {
				<-0.435895, 0.893619, -0.023547>, <1.923443, 5.390623, -1.797122>,
				<-0.465498, 0.878749, -0.015064>, <2.423949, 6.186206, -2.200862>,
				<-0.464844, 0.878539, -0.034619>, <2.010650, 5.299491, -1.964885>
			}
			smooth_triangle {
				<-0.484196, 0.868659, -0.010170>, <1.075362, 2.629472, -0.963647>,
				<-0.492793, 0.863479, -0.025984>, <1.047842, 2.628255, -0.996974>,
				<-0.465498, 0.878749, -0.015064>, <2.423949, 6.186206, -2.200862>
			}
			smooth_triangle {
				<-0.465498, 0.878749, -0.015064>, <2.423949, 6.186206, -2.200862>,
				<-0.492793, 0.863479, -0.025984>, <1.047842, 2.628255, -0.996974>,
				<-0.464844, 0.878539, -0.034619>, <2.010650, 5.299491, -1.964885>
			}
			smooth_triangle {
				<-0.433961, 0.893899, -0.041762>, <1.844165, 5.391059, -1.877079>,
				<-0.464844, 0.878539, -0.034619>, <2.010650, 5.299491, -1.964885>,
				<-0.463697, 0.878119, -0.054798>, <1.920726, 5.296658, -2.059397>
			}
			smooth_triangle {
				<-0.492793, 0.863479, -0.025984>, <1.047842, 2.628255, -0.996974>,
				<-0.494861, 0.861439, -0.046401>, <1.016260, 2.623453, -1.041128>,
				<-0.464844, 0.878539, -0.034619>, <2.010650, 5.299491, -1.964885>
			}
			smooth_triangle {
				<-0.464844, 0.878539, -0.034619>, <2.010650, 5.299491, -1.964885>,
				<-0.494861, 0.861439, -0.046401>, <1.016260, 2.623453, -1.041128>,
				<-0.463697, 0.878119, -0.054798>, <1.920726, 5.296658, -2.059397>
			}
			smooth_triangle {
				<-0.438661, 0.892559, -0.004660>, <2.328709, 6.283749, -2.019381>,
				<-0.435895, 0.893619, -0.023547>, <1.923443, 5.390623, -1.797122>,
				<-0.405257, 0.908129, -0.013513>, <1.822894, 5.478081, -1.629170>
			}
			smooth_triangle {
				<-0.433961, 0.893899, -0.041762>, <1.844165, 5.391059, -1.877079>,
				<-0.404949, 0.907829, -0.031317>, <1.753154, 5.476470, -1.709657>,
				<-0.435895, 0.893619, -0.023547>, <1.923443, 5.390623, -1.797122>
			}
			smooth_triangle {
				<-0.435895, 0.893619, -0.023547>, <1.923443, 5.390623, -1.797122>,
				<-0.404949, 0.907829, -0.031317>, <1.753154, 5.476470, -1.709657>,
				<-0.405257, 0.908129, -0.013513>, <1.822894, 5.478081, -1.629170>
			}
			smooth_triangle {
				<-0.463907, 0.879719, -0.001517>, <2.127020, 5.309503, -1.811003>,
				<-0.438661, 0.892559, -0.004660>, <2.328709, 6.283749, -2.019381>,
				<-0.453494, 0.885119, 0.005215>, <1.759178, 4.450354, -1.447775>
			}
			smooth_triangle {
				<-0.405257, 0.908129, -0.013513>, <1.822894, 5.478081, -1.629170>,
				<-0.406739, 0.907549, 0.005692>, <2.203920, 6.387832, -1.822167>,
				<-0.438661, 0.892559, -0.004660>, <2.328709, 6.283749, -2.019381>
			}
			smooth_triangle {
				<-0.406739, 0.907549, 0.005692>, <2.203920, 6.387832, -1.822167>,
				<-0.437711, 0.892979, 0.010116>, <2.049954, 5.389581, -1.656076>,
				<-0.438661, 0.892559, -0.004660>, <2.328709, 6.283749, -2.019381>
			}
			smooth_triangle {
				<-0.438661, 0.892559, -0.004660>, <2.328709, 6.283749, -2.019381>,
				<-0.437711, 0.892979, 0.010116>, <2.049954, 5.389581, -1.656076>,
				<-0.453494, 0.885119, 0.005215>, <1.759178, 4.450354, -1.447775>
			}
			smooth_triangle {
				<-0.406739, 0.907549, 0.005692>, <2.203920, 6.387832, -1.822167>,
				<-0.405257, 0.908129, -0.013513>, <1.822894, 5.478081, -1.629170>,
				<-0.370887, 0.922789, -0.004523>, <1.698647, 5.566241, -1.454806>
			}
			smooth_triangle {
				<-0.404949, 0.907829, -0.031317>, <1.753154, 5.476470, -1.709657>,
				<-0.372100, 0.922039, -0.022381>, <1.631967, 5.562248, -1.544046>,
				<-0.405257, 0.908129, -0.013513>, <1.822894, 5.478081, -1.629170>
			}
			smooth_triangle {
				<-0.405257, 0.908129, -0.013513>, <1.822894, 5.478081, -1.629170>,
				<-0.372100, 0.922039, -0.022381>, <1.631967, 5.562248, -1.544046>,
				<-0.370887, 0.922789, -0.004523>, <1.698647, 5.566241, -1.454806>
			}
			smooth_triangle {
				<-0.437711, 0.892979, 0.010116>, <2.049954, 5.389581, -1.656076>,
				<-0.406739, 0.907549, 0.005692>, <2.203920, 6.387832, -1.822167>,
				<-0.423156, 0.899859, 0.017771>, <1.682743, 4.523803, -1.303032>
			}
			smooth_triangle {
				<-0.370887, 0.922789, -0.004523>, <1.698647, 5.566241, -1.454806>,
				<-0.369095, 0.923429, 0.012719>, <1.749714, 5.570331, -1.376581>,
				<-0.406739, 0.907549, 0.005692>, <2.203920, 6.387832, -1.822167>
			}
			smooth_triangle {
				<-0.369095, 0.923429, 0.012719>, <1.749714, 5.570331, -1.376581>,
				<-0.399899, 0.910339, 0.021871>, <1.927718, 5.493576, -1.447185>,
				<-0.406739, 0.907549, 0.005692>, <2.203920, 6.387832, -1.822167>
			}
			smooth_triangle {
				<-0.406739, 0.907549, 0.005692>, <2.203920, 6.387832, -1.822167>,
				<-0.399899, 0.910339, 0.021871>, <1.927718, 5.493576, -1.447185>,
				<-0.423156, 0.899859, 0.017771>, <1.682743, 4.523803, -1.303032>
			}
			smooth_triangle {
				<-0.369095, 0.923429, 0.012719>, <1.749714, 5.570331, -1.376581>,
				<-0.370887, 0.922789, -0.004523>, <1.698647, 5.566241, -1.454806>,
				<-0.333231, 0.937049, 0.003747>, <0.821659, 2.806224, -0.670519>
			}
			smooth_triangle {
				<-0.372100, 0.922039, -0.022381>, <1.631967, 5.562248, -1.544046>,
				<-0.336521, 0.935779, -0.013257>, <0.792821, 2.803769, -0.713933>,
				<-0.370887, 0.922789, -0.004523>, <1.698647, 5.566241, -1.454806>
			}
			smooth_triangle {
				<-0.370887, 0.922789, -0.004523>, <1.698647, 5.566241, -1.454806>,
				<-0.336521, 0.935779, -0.013257>, <0.792821, 2.803769, -0.713933>,
				<-0.333231, 0.937049, 0.003747>, <0.821659, 2.806224, -0.670519>
			}
			smooth_triangle {
				<-0.399899, 0.910339, 0.021871>, <1.927718, 5.493576, -1.447185>,
				<-0.369095, 0.923429, 0.012719>, <1.749714, 5.570331, -1.376581>,
				<-0.369878, 0.922749, 0.028976>, <1.818489, 5.566847, -1.299659>
			}
			smooth_triangle {
				<-0.333231, 0.937049, 0.003747>, <0.821659, 2.806224, -0.670519>,
				<-0.331711, 0.937379, 0.020199>, <0.847301, 2.806212, -0.638070>,
				<-0.369095, 0.923429, 0.012719>, <1.749714, 5.570331, -1.376581>
			}
			smooth_triangle {
				<-0.369095, 0.923429, 0.012719>, <1.749714, 5.570331, -1.376581>,
				<-0.331711, 0.937379, 0.020199>, <0.847301, 2.806212, -0.638070>,
				<-0.369878, 0.922749, 0.028976>, <1.818489, 5.566847, -1.299659>
			}
			smooth_triangle {
				<-0.552745, 0.812888, 0.151000>, <1.030584, 1.645703, -0.478648>,
				<-0.543469, 0.821288, 0.138673>, <1.527386, 2.476923, -0.728172>,
				<-0.548658, 0.812988, 0.164724>, <0.514775, 0.826120, -0.229202>
			}
			smooth_triangle {
				<-0.552745, 0.812888, 0.151000>, <1.030584, 1.645703, -0.478648>,
				<-0.548948, 0.819048, 0.130074>, <1.509947, 2.479488, -0.755756>,
				<-0.543469, 0.821288, 0.138673>, <1.527386, 2.476923, -0.728172>
			}
			smooth_triangle {
				<-0.537511, 0.828948, 0.114145>, <1.954482, 3.331773, -1.037751>,
				<-0.548948, 0.819048, 0.130074>, <1.509947, 2.479488, -0.755756>,
				<-0.547215, 0.822938, 0.111557>, <0.982244, 1.661099, -0.525020>
			}
			smooth_triangle {
				<-0.537511, 0.828948, 0.114145>, <1.954482, 3.331773, -1.037751>,
				<-0.543469, 0.821288, 0.138673>, <1.527386, 2.476923, -0.728172>,
				<-0.548948, 0.819048, 0.130074>, <1.509947, 2.479488, -0.755756>
			}
			smooth_triangle {
				<-0.536048, 0.833658, 0.082332>, <1.386070, 2.528046, -0.829033>,
				<-0.526536, 0.838878, 0.090276>, <2.307863, 4.226656, -1.343255>,
				<-0.541303, 0.828798, 0.095905>, <1.431126, 2.510291, -0.806053>
			}
			smooth_triangle {
				<-0.537511, 0.828948, 0.114145>, <1.954482, 3.331773, -1.037751>,
				<-0.541303, 0.828798, 0.095905>, <1.431126, 2.510291, -0.806053>,
				<-0.526536, 0.838878, 0.090276>, <2.307863, 4.226656, -1.343255>
			}
			smooth_triangle {
				<-0.537511, 0.828948, 0.114145>, <1.954482, 3.331773, -1.037751>,
				<-0.547215, 0.822938, 0.111557>, <0.982244, 1.661099, -0.525020>,
				<-0.541303, 0.828798, 0.095905>, <1.431126, 2.510291, -0.806053>
			}
			smooth_triangle {
				<-0.480899, 0.835969, -0.242911>, <1.268173, 5.046514, -2.983828>,
				<-0.461403, 0.854929, -0.212863>, <1.286683, 5.159803, -2.773647>,
				<-0.499203, 0.829658, -0.227108>, <1.422266, 5.005960, -2.983194>
			}
			smooth_triangle {
				<-0.370657, 0.915969, -0.112791>, <1.278872, 5.524665, -1.953066>,
				<-0.419835, 0.893539, -0.120138>, <1.468682, 5.389221, -2.184187>,
				<-0.399337, 0.900389, -0.137652>, <1.307857, 5.427833, -2.190014>
			}
			smooth_triangle {
				<-0.499203, 0.829658, -0.227108>, <1.422266, 5.005960, -2.983194>,
				<-0.484576, 0.844968, -0.200793>, <1.460231, 5.096397, -2.806558>,
				<-0.518858, 0.821258, -0.213148>, <1.570706, 4.955194, -2.993797>
			}
			smooth_triangle {
				<-0.539905, 0.810838, -0.200395>, <1.983810, 5.710248, -3.527100>,
				<-0.529181, 0.822478, -0.180583>, <1.441212, 4.136069, -2.410196>,
				<-0.548974, 0.808608, -0.184118>, <1.822670, 4.878582, -2.978434>
			}
			smooth_triangle {
				<-0.536544, 0.826878, -0.132279>, <0.958371, 2.509761, -1.334582>,
				<-0.549548, 0.815088, -0.150779>, <0.949608, 2.475049, -1.404097>,
				<-0.523127, 0.832748, -0.148290>, <1.841704, 5.024845, -2.710805>
			}
			smooth_triangle {
				<-0.523127, 0.832748, -0.148290>, <1.841704, 5.024845, -2.710805>,
				<-0.549548, 0.815088, -0.150779>, <0.949608, 2.475049, -1.404097>,
				<-0.537004, 0.820348, -0.166617>, <1.837153, 4.950328, -2.848167>
			}
			smooth_triangle {
				<-0.549548, 0.815088, -0.150779>, <0.949608, 2.475049, -1.404097>,
				<-0.557030, 0.806168, -0.170087>, <0.939151, 2.441890, -1.467660>,
				<-0.537004, 0.820348, -0.166617>, <1.837153, 4.950328, -2.848167>
			}
			smooth_triangle {
				<-0.557030, 0.806168, -0.170087>, <0.939151, 2.441890, -1.467660>,
				<-0.548974, 0.808608, -0.184118>, <1.822670, 4.878582, -2.978434>,
				<-0.537004, 0.820348, -0.166617>, <1.837153, 4.950328, -2.848167>
			}
			smooth_triangle {
				<-0.523127, 0.832748, -0.148290>, <1.841704, 5.024845, -2.710805>,
				<-0.537004, 0.820348, -0.166617>, <1.837153, 4.950328, -2.848167>,
				<-0.512648, 0.836008, -0.165516>, <1.728098, 5.044808, -2.748482>
			}
			smooth_triangle {
				<-0.548974, 0.808608, -0.184118>, <1.822670, 4.878582, -2.978434>,
				<-0.529181, 0.822478, -0.180583>, <1.441212, 4.136069, -2.410196>,
				<-0.537004, 0.820348, -0.166617>, <1.837153, 4.950328, -2.848167>
			}
			smooth_triangle {
				<-0.537004, 0.820348, -0.166617>, <1.837153, 4.950328, -2.848167>,
				<-0.529181, 0.822478, -0.180583>, <1.441212, 4.136069, -2.410196>,
				<-0.512648, 0.836008, -0.165516>, <1.728098, 5.044808, -2.748482>
			}
			smooth_triangle {
				<-0.536544, 0.826878, -0.132279>, <0.958371, 2.509761, -1.334582>,
				<-0.523127, 0.832748, -0.148290>, <1.841704, 5.024845, -2.710805>,
				<-0.508944, 0.844918, -0.127281>, <2.165815, 5.950670, -2.979651>
			}
			smooth_triangle {
				<-0.512648, 0.836008, -0.165516>, <1.728098, 5.044808, -2.748482>,
				<-0.492012, 0.851779, -0.146632>, <1.706596, 5.141063, -2.577115>,
				<-0.523127, 0.832748, -0.148290>, <1.841704, 5.024845, -2.710805>
			}
			smooth_triangle {
				<-0.523127, 0.832748, -0.148290>, <1.841704, 5.024845, -2.710805>,
				<-0.492012, 0.851779, -0.146632>, <1.706596, 5.141063, -2.577115>,
				<-0.508944, 0.844918, -0.127281>, <2.165815, 5.950670, -2.979651>
			}
			smooth_triangle {
				<-0.492012, 0.851779, -0.146632>, <1.706596, 5.141063, -2.577115>,
				<-0.512648, 0.836008, -0.165516>, <1.728098, 5.044808, -2.748482>,
				<-0.486518, 0.851678, -0.164479>, <1.336818, 4.283632, -2.202836>
			}
			smooth_triangle {
				<-0.486518, 0.851678, -0.164479>, <1.336818, 4.283632, -2.202836>,
				<-0.512648, 0.836008, -0.165516>, <1.728098, 5.044808, -2.748482>,
				<-0.506155, 0.835668, -0.185937>, <1.869267, 5.881673, -3.299945>
			}
			smooth_triangle {
				<-0.512648, 0.836008, -0.165516>, <1.728098, 5.044808, -2.748482>,
				<-0.529181, 0.822478, -0.180583>, <1.441212, 4.136069, -2.410196>,
				<-0.506155, 0.835668, -0.185937>, <1.869267, 5.881673, -3.299945>
			}
			smooth_triangle {
				<-0.518858, 0.821258, -0.213148>, <1.570706, 4.955194, -2.993797>,
				<-0.506155, 0.835668, -0.185937>, <1.869267, 5.881673, -3.299945>,
				<-0.539905, 0.810838, -0.200395>, <1.983810, 5.710248, -3.527100>
			}
			smooth_triangle {
				<-0.529181, 0.822478, -0.180583>, <1.441212, 4.136069, -2.410196>,
				<-0.539905, 0.810838, -0.200395>, <1.983810, 5.710248, -3.527100>,
				<-0.506155, 0.835668, -0.185937>, <1.869267, 5.881673, -3.299945>
			}
			smooth_triangle {
				<-0.486518, 0.851678, -0.164479>, <1.336818, 4.283632, -2.202836>,
				<-0.506155, 0.835668, -0.185937>, <1.869267, 5.881673, -3.299945>,
				<-0.468127, 0.859699, -0.175760>, <1.480752, 5.186023, -2.625285>
			}
			smooth_triangle {
				<-0.518858, 0.821258, -0.213148>, <1.570706, 4.955194, -2.993797>,
				<-0.484576, 0.844968, -0.200793>, <1.460231, 5.096397, -2.806558>,
				<-0.506155, 0.835668, -0.185937>, <1.869267, 5.881673, -3.299945>
			}
			smooth_triangle {
				<-0.506155, 0.835668, -0.185937>, <1.869267, 5.881673, -3.299945>,
				<-0.484576, 0.844968, -0.200793>, <1.460231, 5.096397, -2.806558>,
				<-0.468127, 0.859699, -0.175760>, <1.480752, 5.186023, -2.625285>
			}
			smooth_triangle {
				<-0.468127, 0.859699, -0.175760>, <1.480752, 5.186023, -2.625285>,
				<-0.484576, 0.844968, -0.200793>, <1.460231, 5.096397, -2.806558>,
				<-0.450890, 0.866089, -0.188931>, <1.111650, 4.354289, -2.188125>
			}
			smooth_triangle {
				<-0.499203, 0.829658, -0.227108>, <1.422266, 5.005960, -2.983194>,
				<-0.461403, 0.854929, -0.212863>, <1.286683, 5.159803, -2.773647>,
				<-0.484576, 0.844968, -0.200793>, <1.460231, 5.096397, -2.806558>
			}
			smooth_triangle {
				<-0.484576, 0.844968, -0.200793>, <1.460231, 5.096397, -2.806558>,
				<-0.461403, 0.854929, -0.212863>, <1.286683, 5.159803, -2.773647>,
				<-0.450890, 0.866089, -0.188931>, <1.111650, 4.354289, -2.188125>
			}
			smooth_triangle {
				<-0.508944, 0.844918, -0.127281>, <2.165815, 5.950670, -2.979651>,
				<-0.492012, 0.851779, -0.146632>, <1.706596, 5.141063, -2.577115>,
				<-0.466490, 0.869439, -0.124774>, <1.670077, 5.244938, -2.382942>
			}
			smooth_triangle {
				<-0.450890, 0.866089, -0.188931>, <1.111650, 4.354289, -2.188125>,
				<-0.425864, 0.883399, -0.165391>, <1.318670, 5.331644, -2.409158>,
				<-0.468127, 0.859699, -0.175760>, <1.480752, 5.186023, -2.625285>
			}
			smooth_triangle {
				<-0.466490, 0.869439, -0.124774>, <1.670077, 5.244938, -2.382942>,
				<-0.492012, 0.851779, -0.146632>, <1.706596, 5.141063, -2.577115>,
				<-0.451829, 0.873519, -0.148107>, <1.764751, 6.149757, -2.834099>
			}
			smooth_triangle {
				<-0.492012, 0.851779, -0.146632>, <1.706596, 5.141063, -2.577115>,
				<-0.486518, 0.851678, -0.164479>, <1.336818, 4.283632, -2.202836>,
				<-0.451829, 0.873519, -0.148107>, <1.764751, 6.149757, -2.834099>
			}
			smooth_triangle {
				<-0.425864, 0.883399, -0.165391>, <1.318670, 5.331644, -2.409158>,
				<-0.451829, 0.873519, -0.148107>, <1.764751, 6.149757, -2.834099>,
				<-0.468127, 0.859699, -0.175760>, <1.480752, 5.186023, -2.625285>
			}
			smooth_triangle {
				<-0.486518, 0.851678, -0.164479>, <1.336818, 4.283632, -2.202836>,
				<-0.468127, 0.859699, -0.175760>, <1.480752, 5.186023, -2.625285>,
				<-0.451829, 0.873519, -0.148107>, <1.764751, 6.149757, -2.834099>
			}
			smooth_triangle {
				<-0.466490, 0.869439, -0.124774>, <1.670077, 5.244938, -2.382942>,
				<-0.451829, 0.873519, -0.148107>, <1.764751, 6.149757, -2.834099>,
				<-0.419835, 0.893539, -0.120138>, <1.468682, 5.389221, -2.184187>
			}
			smooth_triangle {
				<-0.425864, 0.883399, -0.165391>, <1.318670, 5.331644, -2.409158>,
				<-0.399337, 0.900389, -0.137652>, <1.307857, 5.427833, -2.190014>,
				<-0.451829, 0.873519, -0.148107>, <1.764751, 6.149757, -2.834099>
			}
			smooth_triangle {
				<-0.451829, 0.873519, -0.148107>, <1.764751, 6.149757, -2.834099>,
				<-0.399337, 0.900389, -0.137652>, <1.307857, 5.427833, -2.190014>,
				<-0.419835, 0.893539, -0.120138>, <1.468682, 5.389221, -2.184187>
			}
			smooth_triangle {
				<-0.557030, 0.806168, -0.170087>, <0.939151, 2.441890, -1.467660>,
				<-0.568803, 0.793868, -0.188039>, <0.932766, 2.405287, -1.530823>,
				<-0.548974, 0.808608, -0.184118>, <1.822670, 4.878582, -2.978434>
			}
			smooth_triangle {
				<-0.501050, 0.816509, -0.267175>, <1.047931, 4.105867, -2.651477>,
				<-0.480899, 0.835969, -0.242911>, <1.268173, 5.046514, -2.983828>,
				<-0.514554, 0.812608, -0.253010>, <1.399258, 4.902797, -3.160709>
			}
			smooth_triangle {
				<-0.480899, 0.835969, -0.242911>, <1.268173, 5.046514, -2.983828>,
				<-0.499203, 0.829658, -0.227108>, <1.422266, 5.005960, -2.983194>,
				<-0.514554, 0.812608, -0.253010>, <1.399258, 4.902797, -3.160709>
			}
			smooth_triangle {
				<-0.514554, 0.812608, -0.253010>, <1.399258, 4.902797, -3.160709>,
				<-0.499203, 0.829658, -0.227108>, <1.422266, 5.005960, -2.983194>,
				<-0.531968, 0.805648, -0.238868>, <1.531800, 4.859693, -3.165654>
			}
			smooth_triangle {
				<-0.499203, 0.829658, -0.227108>, <1.422266, 5.005960, -2.983194>,
				<-0.518858, 0.821258, -0.213148>, <1.570706, 4.955194, -2.993797>,
				<-0.531968, 0.805648, -0.238868>, <1.531800, 4.859693, -3.165654>
			}
			smooth_triangle {
				<-0.531968, 0.805648, -0.238868>, <1.531800, 4.859693, -3.165654>,
				<-0.518858, 0.821258, -0.213148>, <1.570706, 4.955194, -2.993797>,
				<-0.548530, 0.798508, -0.224971>, <1.650316, 4.819621, -3.167898>
			}
			smooth_triangle {
				<-0.518858, 0.821258, -0.213148>, <1.570706, 4.955194, -2.993797>,
				<-0.539905, 0.810838, -0.200395>, <1.983810, 5.710248, -3.527100>,
				<-0.548530, 0.798508, -0.224971>, <1.650316, 4.819621, -3.167898>
			}
			smooth_triangle {
				<-0.548530, 0.798508, -0.224971>, <1.650316, 4.819621, -3.167898>,
				<-0.539905, 0.810838, -0.200395>, <1.983810, 5.710248, -3.527100>,
				<-0.564445, 0.790198, -0.214737>, <1.770322, 4.768354, -3.181096>
			}
			smooth_triangle {
				<-0.548974, 0.808608, -0.184118>, <1.822670, 4.878582, -2.978434>,
				<-0.568803, 0.793868, -0.188039>, <0.932766, 2.405287, -1.530823>,
				<-0.560553, 0.797108, -0.198773>, <1.509920, 4.007647, -2.579529>
			}
			smooth_triangle {
				<-0.568803, 0.793868, -0.188039>, <0.932766, 2.405287, -1.530823>,
				<-0.579670, 0.781348, -0.206387>, <0.918141, 2.372259, -1.590100>,
				<-0.560553, 0.797108, -0.198773>, <1.509920, 4.007647, -2.579529>
			}
			smooth_triangle {
				<-0.579670, 0.781348, -0.206387>, <0.918141, 2.372259, -1.590100>,
				<-0.564445, 0.790198, -0.214737>, <1.770322, 4.768354, -3.181096>,
				<-0.560553, 0.797108, -0.198773>, <1.509920, 4.007647, -2.579529>
			}
			smooth_triangle {
				<-0.548974, 0.808608, -0.184118>, <1.822670, 4.878582, -2.978434>,
				<-0.560553, 0.797108, -0.198773>, <1.509920, 4.007647, -2.579529>,
				<-0.539905, 0.810838, -0.200395>, <1.983810, 5.710248, -3.527100>
			}
			smooth_triangle {
				<-0.560553, 0.797108, -0.198773>, <1.509920, 4.007647, -2.579529>,
				<-0.564445, 0.790198, -0.214737>, <1.770322, 4.768354, -3.181096>,
				<-0.539905, 0.810838, -0.200395>, <1.983810, 5.710248, -3.527100>
			}
			smooth_triangle {
				<-0.343110, 0.932119, -0.050466>, <0.737485, 2.790847, -0.816153>,
				<-0.385116, 0.915129, -0.057853>, <1.529778, 5.518460, -1.783777>,
				<-0.348781, 0.928629, -0.071490>, <0.944499, 3.697567, -1.195554>
			}
			smooth_triangle {
				<-0.518933, 0.841628, -0.107137>, <0.955984, 2.554546, -1.248352>,
				<-0.483961, 0.862539, -0.104461>, <1.826287, 5.204857, -2.356519>,
				<-0.505790, 0.851869, -0.087227>, <0.954558, 2.596337, -1.159983>
			}
			smooth_triangle {
				<-0.505790, 0.851869, -0.087227>, <0.954558, 2.596337, -1.159983>,
				<-0.483961, 0.862539, -0.104461>, <1.826287, 5.204857, -2.356519>,
				<-0.461433, 0.877469, -0.078967>, <2.118188, 6.175415, -2.518501>
			}
			smooth_triangle {
				<-0.388090, 0.910689, -0.095591>, <1.429983, 5.492343, -1.938540>,
				<-0.408795, 0.903309, -0.077656>, <1.574063, 5.448058, -1.950455>,
				<-0.438757, 0.886849, -0.100528>, <1.636156, 5.349945, -2.161647>
			}
			smooth_triangle {
				<-0.438757, 0.886849, -0.100528>, <1.636156, 5.349945, -2.161647>,
				<-0.461433, 0.877469, -0.078967>, <2.118188, 6.175415, -2.518501>,
				<-0.483961, 0.862539, -0.104461>, <1.826287, 5.204857, -2.356519>
			}
			smooth_triangle {
				<-0.438757, 0.886849, -0.100528>, <1.636156, 5.349945, -2.161647>,
				<-0.408795, 0.903309, -0.077656>, <1.574063, 5.448058, -1.950455>,
				<-0.461433, 0.877469, -0.078967>, <2.118188, 6.175415, -2.518501>
			}
			smooth_triangle {
				<-0.408795, 0.903309, -0.077656>, <1.574063, 5.448058, -1.950455>,
				<-0.426850, 0.896299, -0.059673>, <1.720019, 5.405064, -1.951117>,
				<-0.461433, 0.877469, -0.078967>, <2.118188, 6.175415, -2.518501>
			}
			smooth_triangle {
				<-0.426850, 0.896299, -0.059673>, <1.720019, 5.405064, -1.951117>,
				<-0.408795, 0.903309, -0.077656>, <1.574063, 5.448058, -1.950455>,
				<-0.385116, 0.915129, -0.057853>, <1.529778, 5.518460, -1.783777>
			}
			smooth_triangle {
				<-0.388090, 0.910689, -0.095591>, <1.429983, 5.492343, -1.938540>,
				<-0.348781, 0.928629, -0.071490>, <0.944499, 3.697567, -1.195554>,
				<-0.408795, 0.903309, -0.077656>, <1.574063, 5.448058, -1.950455>
			}
			smooth_triangle {
				<-0.408795, 0.903309, -0.077656>, <1.574063, 5.448058, -1.950455>,
				<-0.348781, 0.928629, -0.071490>, <0.944499, 3.697567, -1.195554>,
				<-0.385116, 0.915129, -0.057853>, <1.529778, 5.518460, -1.783777>
			}
			smooth_triangle {
				<-0.388090, 0.910689, -0.095591>, <1.429983, 5.492343, -1.938540>,
				<-0.438757, 0.886849, -0.100528>, <1.636156, 5.349945, -2.161647>,
				<-0.419835, 0.893539, -0.120138>, <1.468682, 5.389221, -2.184187>
			}
			smooth_triangle {
				<-0.518933, 0.841628, -0.107137>, <0.955984, 2.554546, -1.248352>,
				<-0.508944, 0.844918, -0.127281>, <2.165815, 5.950670, -2.979651>,
				<-0.483961, 0.862539, -0.104461>, <1.826287, 5.204857, -2.356519>
			}
			smooth_triangle {
				<-0.508944, 0.844918, -0.127281>, <2.165815, 5.950670, -2.979651>,
				<-0.466490, 0.869439, -0.124774>, <1.670077, 5.244938, -2.382942>,
				<-0.483961, 0.862539, -0.104461>, <1.826287, 5.204857, -2.356519>
			}
			smooth_triangle {
				<-0.419835, 0.893539, -0.120138>, <1.468682, 5.389221, -2.184187>,
				<-0.438757, 0.886849, -0.100528>, <1.636156, 5.349945, -2.161647>,
				<-0.466490, 0.869439, -0.124774>, <1.670077, 5.244938, -2.382942>
			}
			smooth_triangle {
				<-0.438757, 0.886849, -0.100528>, <1.636156, 5.349945, -2.161647>,
				<-0.483961, 0.862539, -0.104461>, <1.826287, 5.204857, -2.356519>,
				<-0.466490, 0.869439, -0.124774>, <1.670077, 5.244938, -2.382942>
			}
			smooth_triangle {
				<-0.508944, 0.844918, -0.127281>, <2.165815, 5.950670, -2.979651>,
				<-0.538377, 0.826628, -0.126264>, <0.646766, 1.681584, -0.868312>,
				<-0.536544, 0.826878, -0.132279>, <0.958371, 2.509761, -1.334582>
			}
			smooth_triangle {
				<-0.508944, 0.844918, -0.127281>, <2.165815, 5.950670, -2.979651>,
				<-0.518933, 0.841628, -0.107137>, <0.955984, 2.554546, -1.248352>,
				<-0.538377, 0.826628, -0.126264>, <0.646766, 1.681584, -0.868312>
			}
			smooth_triangle {
				<-0.419835, 0.893539, -0.120138>, <1.468682, 5.389221, -2.184187>,
				<-0.370657, 0.915969, -0.112791>, <1.278872, 5.524665, -1.953066>,
				<-0.388090, 0.910689, -0.095591>, <1.429983, 5.492343, -1.938540>
			}
			smooth_triangle {
				<-0.370657, 0.915969, -0.112791>, <1.278872, 5.524665, -1.953066>,
				<-0.337931, 0.931049, -0.089798>, <0.633629, 2.783504, -0.921003>,
				<-0.388090, 0.910689, -0.095591>, <1.429983, 5.492343, -1.938540>
			}
			smooth_triangle {
				<-0.337931, 0.931049, -0.089798>, <0.633629, 2.783504, -0.921003>,
				<-0.348781, 0.928629, -0.071490>, <0.944499, 3.697567, -1.195554>,
				<-0.388090, 0.910689, -0.095591>, <1.429983, 5.492343, -1.938540>
			}
			smooth_triangle {
				<-0.336521, 0.935779, -0.013257>, <0.792821, 2.803769, -0.713933>,
				<-0.372100, 0.922039, -0.022381>, <1.631967, 5.562248, -1.544046>,
				<-0.337624, 0.934959, -0.031155>, <0.762861, 2.800191, -0.759303>
			}
			smooth_triangle {
				<-0.505790, 0.851869, -0.087227>, <0.954558, 2.596337, -1.159983>,
				<-0.461433, 0.877469, -0.078967>, <2.118188, 6.175415, -2.518501>,
				<-0.497494, 0.858568, -0.066854>, <0.971361, 2.616940, -1.098535>
			}
			smooth_triangle {
				<-0.497494, 0.858568, -0.066854>, <0.971361, 2.616940, -1.098535>,
				<-0.461433, 0.877469, -0.078967>, <2.118188, 6.175415, -2.518501>,
				<-0.463697, 0.878119, -0.054798>, <1.920726, 5.296658, -2.059397>
			}
			smooth_triangle {
				<-0.461433, 0.877469, -0.078967>, <2.118188, 6.175415, -2.518501>,
				<-0.426850, 0.896299, -0.059673>, <1.720019, 5.405064, -1.951117>,
				<-0.463697, 0.878119, -0.054798>, <1.920726, 5.296658, -2.059397>
			}
			smooth_triangle {
				<-0.463697, 0.878119, -0.054798>, <1.920726, 5.296658, -2.059397>,
				<-0.426850, 0.896299, -0.059673>, <1.720019, 5.405064, -1.951117>,
				<-0.433961, 0.893899, -0.041762>, <1.844165, 5.391059, -1.877079>
			}
			smooth_triangle {
				<-0.372100, 0.922039, -0.022381>, <1.631967, 5.562248, -1.544046>,
				<-0.404949, 0.907829, -0.031317>, <1.753154, 5.476470, -1.709657>,
				<-0.375084, 0.920229, -0.040033>, <1.575130, 5.552263, -1.636226>
			}
			smooth_triangle {
				<-0.385116, 0.915129, -0.057853>, <1.529778, 5.518460, -1.783777>,
				<-0.375084, 0.920229, -0.040033>, <1.575130, 5.552263, -1.636226>,
				<-0.405463, 0.906959, -0.046211>, <1.406054, 4.559023, -1.493027>
			}
			smooth_triangle {
				<-0.375084, 0.920229, -0.040033>, <1.575130, 5.552263, -1.636226>,
				<-0.404949, 0.907829, -0.031317>, <1.753154, 5.476470, -1.709657>,
				<-0.405463, 0.906959, -0.046211>, <1.406054, 4.559023, -1.493027>
			}
			smooth_triangle {
				<-0.404949, 0.907829, -0.031317>, <1.753154, 5.476470, -1.709657>,
				<-0.433961, 0.893899, -0.041762>, <1.844165, 5.391059, -1.877079>,
				<-0.405463, 0.906959, -0.046211>, <1.406054, 4.559023, -1.493027>
			}
			smooth_triangle {
				<-0.385116, 0.915129, -0.057853>, <1.529778, 5.518460, -1.783777>,
				<-0.405463, 0.906959, -0.046211>, <1.406054, 4.559023, -1.493027>,
				<-0.426850, 0.896299, -0.059673>, <1.720019, 5.405064, -1.951117>
			}
			smooth_triangle {
				<-0.405463, 0.906959, -0.046211>, <1.406054, 4.559023, -1.493027>,
				<-0.433961, 0.893899, -0.041762>, <1.844165, 5.391059, -1.877079>,
				<-0.426850, 0.896299, -0.059673>, <1.720019, 5.405064, -1.951117>
			}
			smooth_triangle {
				<-0.372100, 0.922039, -0.022381>, <1.631967, 5.562248, -1.544046>,
				<-0.375084, 0.920229, -0.040033>, <1.575130, 5.552263, -1.636226>,
				<-0.337624, 0.934959, -0.031155>, <0.762861, 2.800191, -0.759303>
			}
			smooth_triangle {
				<-0.385116, 0.915129, -0.057853>, <1.529778, 5.518460, -1.783777>,
				<-0.343110, 0.932119, -0.050466>, <0.737485, 2.790847, -0.816153>,
				<-0.375084, 0.920229, -0.040033>, <1.575130, 5.552263, -1.636226>
			}
			smooth_triangle {
				<-0.375084, 0.920229, -0.040033>, <1.575130, 5.552263, -1.636226>,
				<-0.343110, 0.932119, -0.050466>, <0.737485, 2.790847, -0.816153>,
				<-0.337624, 0.934959, -0.031155>, <0.762861, 2.800191, -0.759303>
			}
			smooth_triangle {
				<-0.327028, 0.908619, -0.237868>, <0.512000, 4.530843, -2.046835>,
				<-0.346709, 0.906879, -0.215584>, <0.937264, 6.373900, -2.725201>,
				<-0.386005, 0.877099, -0.266118>, <0.769929, 5.288105, -2.718937>
			}
			smooth_triangle {
				<-0.425864, 0.883399, -0.165391>, <1.318670, 5.331644, -2.409158>,
				<-0.450890, 0.866089, -0.188931>, <1.111650, 4.354289, -2.188125>,
				<-0.412414, 0.885119, -0.188660>, <1.355474, 6.228475, -2.883853>
			}
			smooth_triangle {
				<-0.386005, 0.877099, -0.266118>, <0.769929, 5.288105, -2.718937>,
				<-0.346709, 0.906879, -0.215584>, <0.937264, 6.373900, -2.725201>,
				<-0.411923, 0.870959, -0.246693>, <0.925523, 5.252460, -2.739011>
			}
			smooth_triangle {
				<-0.346709, 0.906879, -0.215584>, <0.937264, 6.373900, -2.725201>,
				<-0.379973, 0.896499, -0.202566>, <0.928075, 5.407877, -2.413215>,
				<-0.411923, 0.870959, -0.246693>, <0.925523, 5.252460, -2.739011>
			}
			smooth_triangle {
				<-0.411923, 0.870959, -0.246693>, <0.925523, 5.252460, -2.739011>,
				<-0.379973, 0.896499, -0.202566>, <0.928075, 5.407877, -2.413215>,
				<-0.436864, 0.864059, -0.227318>, <1.113448, 5.212865, -2.747241>
			}
			smooth_triangle {
				<-0.379973, 0.896499, -0.202566>, <0.928075, 5.407877, -2.413215>,
				<-0.412414, 0.885119, -0.188660>, <1.355474, 6.228475, -2.883853>,
				<-0.436864, 0.864059, -0.227318>, <1.113448, 5.212865, -2.747241>
			}
			smooth_triangle {
				<-0.436864, 0.864059, -0.227318>, <1.113448, 5.212865, -2.747241>,
				<-0.412414, 0.885119, -0.188660>, <1.355474, 6.228475, -2.883853>,
				<-0.461403, 0.854929, -0.212863>, <1.286683, 5.159803, -2.773647>
			}
			smooth_triangle {
				<-0.412414, 0.885119, -0.188660>, <1.355474, 6.228475, -2.883853>,
				<-0.450890, 0.866089, -0.188931>, <1.111650, 4.354289, -2.188125>,
				<-0.461403, 0.854929, -0.212863>, <1.286683, 5.159803, -2.773647>
			}
			smooth_triangle {
				<-0.386005, 0.877099, -0.266118>, <0.769929, 5.288105, -2.718937>,
				<-0.411923, 0.870959, -0.246693>, <0.925523, 5.252460, -2.739011>,
				<-0.445902, 0.837879, -0.297067>, <1.044160, 5.898634, -3.612973>
			}
			smooth_triangle {
				<-0.461403, 0.854929, -0.212863>, <1.286683, 5.159803, -2.773647>,
				<-0.480899, 0.835969, -0.242911>, <1.268173, 5.046514, -2.983828>,
				<-0.436864, 0.864059, -0.227318>, <1.113448, 5.212865, -2.747241>
			}
			smooth_triangle {
				<-0.445902, 0.837879, -0.297067>, <1.044160, 5.898634, -3.612973>,
				<-0.411923, 0.870959, -0.246693>, <0.925523, 5.252460, -2.739011>,
				<-0.468780, 0.834969, -0.268653>, <1.286481, 5.879028, -3.568685>
			}
			smooth_triangle {
				<-0.411923, 0.870959, -0.246693>, <0.925523, 5.252460, -2.739011>,
				<-0.436864, 0.864059, -0.227318>, <1.113448, 5.212865, -2.747241>,
				<-0.468780, 0.834969, -0.268653>, <1.286481, 5.879028, -3.568685>
			}
			smooth_triangle {
				<-0.436864, 0.864059, -0.227318>, <1.113448, 5.212865, -2.747241>,
				<-0.480899, 0.835969, -0.242911>, <1.268173, 5.046514, -2.983828>,
				<-0.468780, 0.834969, -0.268653>, <1.286481, 5.879028, -3.568685>
			}
			smooth_triangle {
				<-0.480899, 0.835969, -0.242911>, <1.268173, 5.046514, -2.983828>,
				<-0.501050, 0.816509, -0.267175>, <1.047931, 4.105867, -2.651477>,
				<-0.468780, 0.834969, -0.268653>, <1.286481, 5.879028, -3.568685>
			}
			smooth_triangle {
				<-0.271651, 0.926909, -0.236949>, <0.036259, 0.916600, -0.398158>,
				<-0.295105, 0.920029, -0.235714>, <0.104241, 1.830715, -0.797874>,
				<-0.326763, 0.896469, -0.280490>, <0.265417, 3.613776, -1.687076>
			}
			smooth_triangle {
				<-0.386005, 0.877099, -0.266118>, <0.769929, 5.288105, -2.718937>,
				<-0.366496, 0.879869, -0.283924>, <0.496658, 4.422118, -2.273121>,
				<-0.327028, 0.908619, -0.237868>, <0.512000, 4.530843, -2.046835>
			}
			smooth_triangle {
				<-0.327028, 0.908619, -0.237868>, <0.512000, 4.530843, -2.046835>,
				<-0.326763, 0.896469, -0.280490>, <0.265417, 3.613776, -1.687076>,
				<-0.295105, 0.920029, -0.235714>, <0.104241, 1.830715, -0.797874>
			}
			smooth_triangle {
				<-0.327028, 0.908619, -0.237868>, <0.512000, 4.530843, -2.046835>,
				<-0.366496, 0.879869, -0.283924>, <0.496658, 4.422118, -2.273121>,
				<-0.326763, 0.896469, -0.280490>, <0.265417, 3.613776, -1.687076>
			}
			smooth_triangle {
				<-0.445902, 0.837879, -0.297067>, <1.044160, 5.898634, -3.612973>,
				<-0.411104, 0.849969, -0.312520>, <0.699804, 5.123627, -3.035585>,
				<-0.386005, 0.877099, -0.266118>, <0.769929, 5.288105, -2.718937>
			}
			smooth_triangle {
				<-0.326763, 0.896469, -0.280490>, <0.265417, 3.613776, -1.687076>,
				<-0.366496, 0.879869, -0.283924>, <0.496658, 4.422118, -2.273121>,
				<-0.378809, 0.861569, -0.321435>, <0.251866, 2.601884, -1.467746>
			}
			smooth_triangle {
				<-0.378809, 0.861569, -0.321435>, <0.251866, 2.601884, -1.467746>,
				<-0.366496, 0.879869, -0.283924>, <0.496658, 4.422118, -2.273121>,
				<-0.411104, 0.849969, -0.312520>, <0.699804, 5.123627, -3.035585>
			}
			smooth_triangle {
				<-0.386005, 0.877099, -0.266118>, <0.769929, 5.288105, -2.718937>,
				<-0.411104, 0.849969, -0.312520>, <0.699804, 5.123627, -3.035585>,
				<-0.366496, 0.879869, -0.283924>, <0.496658, 4.422118, -2.273121>
			}
			smooth_triangle {
				<-0.308816, 0.931029, -0.164095>, <0.561131, 3.690160, -1.433591>,
				<-0.311285, 0.933689, -0.142938>, <0.499203, 2.785325, -0.996133>,
				<-0.356878, 0.912549, -0.170329>, <0.802697, 4.584519, -1.815844>
			}
			smooth_triangle {
				<-0.337931, 0.931049, -0.089798>, <0.633629, 2.783504, -0.921003>,
				<-0.370657, 0.915969, -0.112791>, <1.278872, 5.524665, -1.953066>,
				<-0.320253, 0.935609, -0.105741>, <0.575472, 2.796029, -0.922006>
			}
			smooth_triangle {
				<-0.412414, 0.885119, -0.188660>, <1.355474, 6.228475, -2.883853>,
				<-0.368847, 0.911169, -0.151083>, <1.278234, 6.410310, -2.494149>,
				<-0.425864, 0.883399, -0.165391>, <1.318670, 5.331644, -2.409158>
			}
			smooth_triangle {
				<-0.425864, 0.883399, -0.165391>, <1.318670, 5.331644, -2.409158>,
				<-0.368847, 0.911169, -0.151083>, <1.278234, 6.410310, -2.494149>,
				<-0.399337, 0.900389, -0.137652>, <1.307857, 5.427833, -2.190014>
			}
			smooth_triangle {
				<-0.315632, 0.935029, -0.123352>, <0.508501, 2.791338, -0.973275>,
				<-0.320253, 0.935609, -0.105741>, <0.575472, 2.796029, -0.922006>,
				<-0.355391, 0.920249, -0.126319>, <0.949058, 4.625608, -1.637603>
			}
			smooth_triangle {
				<-0.320253, 0.935609, -0.105741>, <0.575472, 2.796029, -0.922006>,
				<-0.370657, 0.915969, -0.112791>, <1.278872, 5.524665, -1.953066>,
				<-0.355391, 0.920249, -0.126319>, <0.949058, 4.625608, -1.637603>
			}
			smooth_triangle {
				<-0.370657, 0.915969, -0.112791>, <1.278872, 5.524665, -1.953066>,
				<-0.399337, 0.900389, -0.137652>, <1.307857, 5.427833, -2.190014>,
				<-0.355391, 0.920249, -0.126319>, <0.949058, 4.625608, -1.637603>
			}
			smooth_triangle {
				<-0.315632, 0.935029, -0.123352>, <0.508501, 2.791338, -0.973275>,
				<-0.355391, 0.920249, -0.126319>, <0.949058, 4.625608, -1.637603>,
				<-0.368847, 0.911169, -0.151083>, <1.278234, 6.410310, -2.494149>
			}
			smooth_triangle {
				<-0.355391, 0.920249, -0.126319>, <0.949058, 4.625608, -1.637603>,
				<-0.399337, 0.900389, -0.137652>, <1.307857, 5.427833, -2.190014>,
				<-0.368847, 0.911169, -0.151083>, <1.278234, 6.410310, -2.494149>
			}
			smooth_triangle {
				<-0.315632, 0.935029, -0.123352>, <0.508501, 2.791338, -0.973275>,
				<-0.368847, 0.911169, -0.151083>, <1.278234, 6.410310, -2.494149>,
				<-0.311285, 0.933689, -0.142938>, <0.499203, 2.785325, -0.996133>
			}
			smooth_triangle {
				<-0.412414, 0.885119, -0.188660>, <1.355474, 6.228475, -2.883853>,
				<-0.356878, 0.912549, -0.170329>, <0.802697, 4.584519, -1.815844>,
				<-0.368847, 0.911169, -0.151083>, <1.278234, 6.410310, -2.494149>
			}
			smooth_triangle {
				<-0.368847, 0.911169, -0.151083>, <1.278234, 6.410310, -2.494149>,
				<-0.356878, 0.912549, -0.170329>, <0.802697, 4.584519, -1.815844>,
				<-0.311285, 0.933689, -0.142938>, <0.499203, 2.785325, -0.996133>
			}
			smooth_triangle {
				<-0.412414, 0.885119, -0.188660>, <1.355474, 6.228475, -2.883853>,
				<-0.379973, 0.896499, -0.202566>, <0.928075, 5.407877, -2.413215>,
				<-0.356878, 0.912549, -0.170329>, <0.802697, 4.584519, -1.815844>
			}
			smooth_triangle {
				<-0.327028, 0.908619, -0.237868>, <0.512000, 4.530843, -2.046835>,
				<-0.303740, 0.924769, -0.204109>, <0.244513, 1.843908, -0.734485>,
				<-0.346709, 0.906879, -0.215584>, <0.937264, 6.373900, -2.725201>
			}
			smooth_triangle {
				<-0.303740, 0.924769, -0.204109>, <0.244513, 1.843908, -0.734485>,
				<-0.301249, 0.929489, -0.185522>, <0.272542, 1.846581, -0.718214>,
				<-0.346709, 0.906879, -0.215584>, <0.937264, 6.373900, -2.725201>
			}
			smooth_triangle {
				<-0.308816, 0.931029, -0.164095>, <0.561131, 3.690160, -1.433591>,
				<-0.346709, 0.906879, -0.215584>, <0.937264, 6.373900, -2.725201>,
				<-0.301249, 0.929489, -0.185522>, <0.272542, 1.846581, -0.718214>
			}
			smooth_triangle {
				<-0.346709, 0.906879, -0.215584>, <0.937264, 6.373900, -2.725201>,
				<-0.308816, 0.931029, -0.164095>, <0.561131, 3.690160, -1.433591>,
				<-0.379973, 0.896499, -0.202566>, <0.928075, 5.407877, -2.413215>
			}
			smooth_triangle {
				<-0.308816, 0.931029, -0.164095>, <0.561131, 3.690160, -1.433591>,
				<-0.356878, 0.912549, -0.170329>, <0.802697, 4.584519, -1.815844>,
				<-0.379973, 0.896499, -0.202566>, <0.928075, 5.407877, -2.413215>
			}
			smooth_triangle {
				<-0.378809, 0.861569, -0.321435>, <0.251866, 2.601884, -1.467746>,
				<-0.411104, 0.849969, -0.312520>, <0.699804, 5.123627, -3.035585>,
				<-0.426471, 0.823509, -0.359257>, <0.309447, 2.492167, -1.638005>
			}
			smooth_triangle {
				<-0.426471, 0.823509, -0.359257>, <0.309447, 2.492167, -1.638005>,
				<-0.411104, 0.849969, -0.312520>, <0.699804, 5.123627, -3.035585>,
				<-0.458588, 0.812069, -0.345478>, <0.776629, 4.895737, -3.374215>
			}
			smooth_triangle {
				<-0.411104, 0.849969, -0.312520>, <0.699804, 5.123627, -3.035585>,
				<-0.445902, 0.837879, -0.297067>, <1.044160, 5.898634, -3.612973>,
				<-0.458588, 0.812069, -0.345478>, <0.776629, 4.895737, -3.374215>
			}
			smooth_triangle {
				<-0.458588, 0.812069, -0.345478>, <0.776629, 4.895737, -3.374215>,
				<-0.445902, 0.837879, -0.297067>, <1.044160, 5.898634, -3.612973>,
				<-0.489382, 0.799288, -0.332798>, <0.936997, 4.827258, -3.433314>
			}
			smooth_triangle {
				<-0.539205, 0.773738, -0.315742>, <1.255435, 4.669724, -3.549995>,
				<-0.538366, 0.782008, -0.296198>, <1.106511, 3.932337, -2.881713>,
				<-0.559175, 0.762768, -0.307587>, <1.386060, 4.600075, -3.592787>
			}
			smooth_triangle {
				<-0.531968, 0.805648, -0.238868>, <1.531800, 4.859693, -3.165654>,
				<-0.563657, 0.780308, -0.250030>, <1.895518, 5.493855, -3.899610>,
				<-0.544345, 0.789388, -0.263964>, <1.497706, 4.761523, -3.327220>
			}
			smooth_triangle {
				<-0.559175, 0.762768, -0.307587>, <1.386060, 4.600075, -3.592787>,
				<-0.553080, 0.775248, -0.286711>, <1.449154, 4.677806, -3.465197>,
				<-0.574476, 0.755348, -0.297554>, <1.490294, 4.559063, -3.603658>
			}
			smooth_triangle {
				<-0.563657, 0.780308, -0.250030>, <1.895518, 5.493855, -3.899610>,
				<-0.588828, 0.755958, -0.266322>, <0.818227, 2.303685, -1.738390>,
				<-0.572844, 0.764258, -0.277267>, <1.840439, 5.381809, -4.078466>
			}
			smooth_triangle {
				<-0.588828, 0.755958, -0.266322>, <0.818227, 2.303685, -1.738390>,
				<-0.596068, 0.743928, -0.283522>, <1.364481, 3.742990, -3.020610>,
				<-0.572844, 0.764258, -0.277267>, <1.840439, 5.381809, -4.078466>
			}
			smooth_triangle {
				<-0.596068, 0.743928, -0.283522>, <1.364481, 3.742990, -3.020610>,
				<-0.587020, 0.747858, -0.291937>, <1.322078, 3.761379, -3.016675>,
				<-0.572844, 0.764258, -0.277267>, <1.840439, 5.381809, -4.078466>
			}
			smooth_triangle {
				<-0.587020, 0.747858, -0.291937>, <1.322078, 3.761379, -3.016675>,
				<-0.574476, 0.755348, -0.297554>, <1.490294, 4.559063, -3.603658>,
				<-0.572844, 0.764258, -0.277267>, <1.840439, 5.381809, -4.078466>
			}
			smooth_triangle {
				<-0.563657, 0.780308, -0.250030>, <1.895518, 5.493855, -3.899610>,
				<-0.572844, 0.764258, -0.277267>, <1.840439, 5.381809, -4.078466>,
				<-0.544345, 0.789388, -0.263964>, <1.497706, 4.761523, -3.327220>
			}
			smooth_triangle {
				<-0.574476, 0.755348, -0.297554>, <1.490294, 4.559063, -3.603658>,
				<-0.553080, 0.775248, -0.286711>, <1.449154, 4.677806, -3.465197>,
				<-0.572844, 0.764258, -0.277267>, <1.840439, 5.381809, -4.078466>
			}
			smooth_triangle {
				<-0.572844, 0.764258, -0.277267>, <1.840439, 5.381809, -4.078466>,
				<-0.553080, 0.775248, -0.286711>, <1.449154, 4.677806, -3.465197>,
				<-0.544345, 0.789388, -0.263964>, <1.497706, 4.761523, -3.327220>
			}
			smooth_triangle {
				<-0.531968, 0.805648, -0.238868>, <1.531800, 4.859693, -3.165654>,
				<-0.544345, 0.789388, -0.263964>, <1.497706, 4.761523, -3.327220>,
				<-0.514554, 0.812608, -0.253010>, <1.399258, 4.902797, -3.160709>
			}
			smooth_triangle {
				<-0.559175, 0.762768, -0.307587>, <1.386060, 4.600075, -3.592787>,
				<-0.538366, 0.782008, -0.296198>, <1.106511, 3.932337, -2.881713>,
				<-0.553080, 0.775248, -0.286711>, <1.449154, 4.677806, -3.465197>
			}
			smooth_triangle {
				<-0.538366, 0.782008, -0.296198>, <1.106511, 3.932337, -2.881713>,
				<-0.527491, 0.796358, -0.276905>, <1.367362, 4.804292, -3.322310>,
				<-0.553080, 0.775248, -0.286711>, <1.449154, 4.677806, -3.465197>
			}
			smooth_triangle {
				<-0.514554, 0.812608, -0.253010>, <1.399258, 4.902797, -3.160709>,
				<-0.544345, 0.789388, -0.263964>, <1.497706, 4.761523, -3.327220>,
				<-0.527491, 0.796358, -0.276905>, <1.367362, 4.804292, -3.322310>
			}
			smooth_triangle {
				<-0.544345, 0.789388, -0.263964>, <1.497706, 4.761523, -3.327220>,
				<-0.553080, 0.775248, -0.286711>, <1.449154, 4.677806, -3.465197>,
				<-0.527491, 0.796358, -0.276905>, <1.367362, 4.804292, -3.322310>
			}
			smooth_triangle {
				<-0.514554, 0.812608, -0.253010>, <1.399258, 4.902797, -3.160709>,
				<-0.527491, 0.796358, -0.276905>, <1.367362, 4.804292, -3.322310>,
				<-0.501050, 0.816509, -0.267175>, <1.047931, 4.105867, -2.651477>
			}
			smooth_triangle {
				<-0.501050, 0.816509, -0.267175>, <1.047931, 4.105867, -2.651477>,
				<-0.527491, 0.796358, -0.276905>, <1.367362, 4.804292, -3.322310>,
				<-0.511581, 0.800878, -0.293245>, <1.409361, 5.640635, -3.894453>
			}
			smooth_triangle {
				<-0.527491, 0.796358, -0.276905>, <1.367362, 4.804292, -3.322310>,
				<-0.538366, 0.782008, -0.296198>, <1.106511, 3.932337, -2.881713>,
				<-0.511581, 0.800878, -0.293245>, <1.409361, 5.640635, -3.894453>
			}
			smooth_triangle {
				<-0.515525, 0.786718, -0.323132>, <1.128957, 4.745384, -3.491328>,
				<-0.511581, 0.800878, -0.293245>, <1.409361, 5.640635, -3.894453>,
				<-0.539205, 0.773738, -0.315742>, <1.255435, 4.669724, -3.549995>
			}
			smooth_triangle {
				<-0.538366, 0.782008, -0.296198>, <1.106511, 3.932337, -2.881713>,
				<-0.539205, 0.773738, -0.315742>, <1.255435, 4.669724, -3.549995>,
				<-0.511581, 0.800878, -0.293245>, <1.409361, 5.640635, -3.894453>
			}
			smooth_triangle {
				<-0.501050, 0.816509, -0.267175>, <1.047931, 4.105867, -2.651477>,
				<-0.511581, 0.800878, -0.293245>, <1.409361, 5.640635, -3.894453>,
				<-0.468780, 0.834969, -0.268653>, <1.286481, 5.879028, -3.568685>
			}
			smooth_triangle {
				<-0.468780, 0.834969, -0.268653>, <1.286481, 5.879028, -3.568685>,
				<-0.511581, 0.800878, -0.293245>, <1.409361, 5.640635, -3.894453>,
				<-0.486832, 0.812478, -0.303281>, <0.885280, 4.086707, -2.737765>
			}
			smooth_triangle {
				<-0.511581, 0.800878, -0.293245>, <1.409361, 5.640635, -3.894453>,
				<-0.515525, 0.786718, -0.323132>, <1.128957, 4.745384, -3.491328>,
				<-0.486832, 0.812478, -0.303281>, <0.885280, 4.086707, -2.737765>
			}
			smooth_triangle {
				<-0.515525, 0.786718, -0.323132>, <1.128957, 4.745384, -3.491328>,
				<-0.489382, 0.799288, -0.332798>, <0.936997, 4.827258, -3.433314>,
				<-0.486832, 0.812478, -0.303281>, <0.885280, 4.086707, -2.737765>
			}
			smooth_triangle {
				<-0.468780, 0.834969, -0.268653>, <1.286481, 5.879028, -3.568685>,
				<-0.486832, 0.812478, -0.303281>, <0.885280, 4.086707, -2.737765>,
				<-0.445902, 0.837879, -0.297067>, <1.044160, 5.898634, -3.612973>
			}
			smooth_triangle {
				<-0.486832, 0.812478, -0.303281>, <0.885280, 4.086707, -2.737765>,
				<-0.489382, 0.799288, -0.332798>, <0.936997, 4.827258, -3.433314>,
				<-0.445902, 0.837879, -0.297067>, <1.044160, 5.898634, -3.612973>
			}
			smooth_triangle {
				<-0.531968, 0.805648, -0.238868>, <1.531800, 4.859693, -3.165654>,
				<-0.548530, 0.798508, -0.224971>, <1.650316, 4.819621, -3.167898>,
				<-0.563657, 0.780308, -0.250030>, <1.895518, 5.493855, -3.899610>
			}
			smooth_triangle {
				<-0.548530, 0.798508, -0.224971>, <1.650316, 4.819621, -3.167898>,
				<-0.570034, 0.781178, -0.232226>, <1.439217, 3.928318, -2.737037>,
				<-0.563657, 0.780308, -0.250030>, <1.895518, 5.493855, -3.899610>
			}
			smooth_triangle {
				<-0.588828, 0.755958, -0.266322>, <0.818227, 2.303685, -1.738390>,
				<-0.563657, 0.780308, -0.250030>, <1.895518, 5.493855, -3.899610>,
				<-0.585976, 0.765048, -0.245857>, <0.852059, 2.328325, -1.688735>
			}
			smooth_triangle {
				<-0.570034, 0.781178, -0.232226>, <1.439217, 3.928318, -2.737037>,
				<-0.585976, 0.765048, -0.245857>, <0.852059, 2.328325, -1.688735>,
				<-0.563657, 0.780308, -0.250030>, <1.895518, 5.493855, -3.899610>
			}
			smooth_triangle {
				<-0.548530, 0.798508, -0.224971>, <1.650316, 4.819621, -3.167898>,
				<-0.564445, 0.790198, -0.214737>, <1.770322, 4.768354, -3.181096>,
				<-0.570034, 0.781178, -0.232226>, <1.439217, 3.928318, -2.737037>
			}
			smooth_triangle {
				<-0.579670, 0.781348, -0.206387>, <0.918141, 2.372259, -1.590100>,
				<-0.586400, 0.771038, -0.225267>, <0.896152, 2.346792, -1.639735>,
				<-0.564445, 0.790198, -0.214737>, <1.770322, 4.768354, -3.181096>
			}
			smooth_triangle {
				<-0.585976, 0.765048, -0.245857>, <0.852059, 2.328325, -1.688735>,
				<-0.570034, 0.781178, -0.232226>, <1.439217, 3.928318, -2.737037>,
				<-0.586400, 0.771038, -0.225267>, <0.896152, 2.346792, -1.639735>
			}
			smooth_triangle {
				<-0.564445, 0.790198, -0.214737>, <1.770322, 4.768354, -3.181096>,
				<-0.586400, 0.771038, -0.225267>, <0.896152, 2.346792, -1.639735>,
				<-0.570034, 0.781178, -0.232226>, <1.439217, 3.928318, -2.737037>
			}
			smooth_triangle {
				<-0.426471, 0.823509, -0.359257>, <0.309447, 2.492167, -1.638005>,
				<-0.458588, 0.812069, -0.345478>, <0.776629, 4.895737, -3.374215>,
				<-0.469024, 0.783648, -0.393743>, <0.355396, 2.372319, -1.799213>
			}
			smooth_triangle {
				<-0.685045, 0.643068, -0.326009>, <1.901066, 3.878266, -4.164310>,
				<-0.672873, 0.651418, -0.334669>, <1.811314, 3.931056, -4.154749>,
				<-0.675036, 0.656168, -0.320740>, <1.871211, 3.956834, -4.103549>
			}
			smooth_triangle {
				<-0.659978, 0.659538, -0.344301>, <1.707858, 3.981030, -4.150773>,
				<-0.644484, 0.669038, -0.355161>, <1.597622, 4.037371, -4.139855>,
				<-0.645536, 0.677948, -0.335833>, <1.673336, 4.088648, -4.059135>
			}
			smooth_triangle {
				<-0.539205, 0.773738, -0.315742>, <1.255435, 4.669724, -3.549995>,
				<-0.559175, 0.762768, -0.307587>, <1.386060, 4.600075, -3.592787>,
				<-0.564819, 0.748858, -0.330617>, <1.314461, 4.519283, -3.719496>
			}
			smooth_triangle {
				<-0.603765, 0.706498, -0.354162>, <1.404064, 4.260370, -3.983023>,
				<-0.586462, 0.728198, -0.338970>, <1.156685, 3.660637, -3.202245>,
				<-0.604052, 0.717258, -0.331324>, <1.501338, 4.326312, -3.875465>
			}
			smooth_triangle {
				<-0.564819, 0.748858, -0.330617>, <1.314461, 4.519283, -3.719496>,
				<-0.583425, 0.740168, -0.317616>, <1.699396, 5.210032, -4.353750>,
				<-0.586462, 0.728198, -0.338970>, <1.156685, 3.660637, -3.202245>
			}
			smooth_triangle {
				<-0.583425, 0.740168, -0.317616>, <1.699396, 5.210032, -4.353750>,
				<-0.604052, 0.717258, -0.331324>, <1.501338, 4.326312, -3.875465>,
				<-0.586462, 0.728198, -0.338970>, <1.156685, 3.660637, -3.202245>
			}
			smooth_triangle {
				<-0.604052, 0.717258, -0.331324>, <1.501338, 4.326312, -3.875465>,
				<-0.583425, 0.740168, -0.317616>, <1.699396, 5.210032, -4.353750>,
				<-0.603016, 0.726448, -0.312664>, <1.568002, 4.381470, -3.786489>
			}
			smooth_triangle {
				<-0.583425, 0.740168, -0.317616>, <1.699396, 5.210032, -4.353750>,
				<-0.589933, 0.740918, -0.303513>, <1.283594, 3.725166, -3.077728>,
				<-0.603016, 0.726448, -0.312664>, <1.568002, 4.381470, -3.786489>
			}
			smooth_triangle {
				<-0.589933, 0.740918, -0.303513>, <1.283594, 3.725166, -3.077728>,
				<-0.583425, 0.740168, -0.317616>, <1.699396, 5.210032, -4.353750>,
				<-0.574476, 0.755348, -0.297554>, <1.490294, 4.559063, -3.603658>
			}
			smooth_triangle {
				<-0.564819, 0.748858, -0.330617>, <1.314461, 4.519283, -3.719496>,
				<-0.559175, 0.762768, -0.307587>, <1.386060, 4.600075, -3.592787>,
				<-0.583425, 0.740168, -0.317616>, <1.699396, 5.210032, -4.353750>
			}
			smooth_triangle {
				<-0.583425, 0.740168, -0.317616>, <1.699396, 5.210032, -4.353750>,
				<-0.559175, 0.762768, -0.307587>, <1.386060, 4.600075, -3.592787>,
				<-0.574476, 0.755348, -0.297554>, <1.490294, 4.559063, -3.603658>
			}
			smooth_triangle {
				<-0.603016, 0.726448, -0.312664>, <1.568002, 4.381470, -3.786489>,
				<-0.620046, 0.707958, -0.321650>, <1.609859, 4.272476, -3.891976>,
				<-0.604052, 0.717258, -0.331324>, <1.501338, 4.326312, -3.875465>
			}
			smooth_triangle {
				<-0.604052, 0.717258, -0.331324>, <1.501338, 4.326312, -3.875465>,
				<-0.620046, 0.707958, -0.321650>, <1.609859, 4.272476, -3.891976>,
				<-0.625811, 0.693188, -0.341993>, <1.812857, 4.879003, -4.679314>
			}
			smooth_triangle {
				<-0.620046, 0.707958, -0.321650>, <1.609859, 4.272476, -3.891976>,
				<-0.634362, 0.692838, -0.326608>, <1.382026, 3.483037, -3.309850>,
				<-0.625811, 0.693188, -0.341993>, <1.812857, 4.879003, -4.679314>
			}
			smooth_triangle {
				<-0.644484, 0.669038, -0.355161>, <1.597622, 4.037371, -4.139855>,
				<-0.625811, 0.693188, -0.341993>, <1.812857, 4.879003, -4.679314>,
				<-0.645536, 0.677948, -0.335833>, <1.673336, 4.088648, -4.059135>
			}
			smooth_triangle {
				<-0.634362, 0.692838, -0.326608>, <1.382026, 3.483037, -3.309850>,
				<-0.645536, 0.677948, -0.335833>, <1.673336, 4.088648, -4.059135>,
				<-0.625811, 0.693188, -0.341993>, <1.812857, 4.879003, -4.679314>
			}
			smooth_triangle {
				<-0.604052, 0.717258, -0.331324>, <1.501338, 4.326312, -3.875465>,
				<-0.625811, 0.693188, -0.341993>, <1.812857, 4.879003, -4.679314>,
				<-0.603765, 0.706498, -0.354162>, <1.404064, 4.260370, -3.983023>
			}
			smooth_triangle {
				<-0.644484, 0.669038, -0.355161>, <1.597622, 4.037371, -4.139855>,
				<-0.626130, 0.679428, -0.368043>, <1.453246, 4.101641, -4.129315>,
				<-0.625811, 0.693188, -0.341993>, <1.812857, 4.879003, -4.679314>
			}
			smooth_triangle {
				<-0.625811, 0.693188, -0.341993>, <1.812857, 4.879003, -4.679314>,
				<-0.626130, 0.679428, -0.368043>, <1.453246, 4.101641, -4.129315>,
				<-0.603765, 0.706498, -0.354162>, <1.404064, 4.260370, -3.983023>
			}
			smooth_triangle {
				<-0.626130, 0.679428, -0.368043>, <1.453246, 4.101641, -4.129315>,
				<-0.602963, 0.692108, -0.382796>, <1.290502, 4.175728, -4.108114>,
				<-0.603765, 0.706498, -0.354162>, <1.404064, 4.260370, -3.983023>
			}
			smooth_triangle {
				<-0.489382, 0.799288, -0.332798>, <0.936997, 4.827258, -3.433314>,
				<-0.515525, 0.786718, -0.323132>, <1.128957, 4.745384, -3.491328>,
				<-0.519811, 0.772378, -0.349755>, <0.857747, 3.883882, -3.027580>
			}
			smooth_triangle {
				<-0.519811, 0.772378, -0.349755>, <0.857747, 3.883882, -3.027580>,
				<-0.543450, 0.759328, -0.342348>, <1.179247, 4.578829, -3.691266>,
				<-0.543494, 0.744668, -0.373079>, <1.049834, 4.489645, -3.836191>
			}
			smooth_triangle {
				<-0.573680, 0.708778, -0.397042>, <1.105451, 4.275613, -4.058452>,
				<-0.543494, 0.744668, -0.373079>, <1.049834, 4.489645, -3.836191>,
				<-0.574744, 0.727348, -0.360211>, <1.450709, 5.117906, -4.547008>
			}
			smooth_triangle {
				<-0.543450, 0.759328, -0.342348>, <1.179247, 4.578829, -3.691266>,
				<-0.574744, 0.727348, -0.360211>, <1.450709, 5.117906, -4.547008>,
				<-0.543494, 0.744668, -0.373079>, <1.049834, 4.489645, -3.836191>
			}
			smooth_triangle {
				<-0.543450, 0.759328, -0.342348>, <1.179247, 4.578829, -3.691266>,
				<-0.564819, 0.748858, -0.330617>, <1.314461, 4.519283, -3.719496>,
				<-0.574744, 0.727348, -0.360211>, <1.450709, 5.117906, -4.547008>
			}
			smooth_triangle {
				<-0.564819, 0.748858, -0.330617>, <1.314461, 4.519283, -3.719496>,
				<-0.586462, 0.728198, -0.338970>, <1.156685, 3.660637, -3.202245>,
				<-0.574744, 0.727348, -0.360211>, <1.450709, 5.117906, -4.547008>
			}
			smooth_triangle {
				<-0.573680, 0.708778, -0.397042>, <1.105451, 4.275613, -4.058452>,
				<-0.574744, 0.727348, -0.360211>, <1.450709, 5.117906, -4.547008>,
				<-0.602963, 0.692108, -0.382796>, <1.290502, 4.175728, -4.108114>
			}
			smooth_triangle {
				<-0.586462, 0.728198, -0.338970>, <1.156685, 3.660637, -3.202245>,
				<-0.603765, 0.706498, -0.354162>, <1.404064, 4.260370, -3.983023>,
				<-0.574744, 0.727348, -0.360211>, <1.450709, 5.117906, -4.547008>
			}
			smooth_triangle {
				<-0.574744, 0.727348, -0.360211>, <1.450709, 5.117906, -4.547008>,
				<-0.603765, 0.706498, -0.354162>, <1.404064, 4.260370, -3.983023>,
				<-0.602963, 0.692108, -0.382796>, <1.290502, 4.175728, -4.108114>
			}
			smooth_triangle {
				<-0.564819, 0.748858, -0.330617>, <1.314461, 4.519283, -3.719496>,
				<-0.543450, 0.759328, -0.342348>, <1.179247, 4.578829, -3.691266>,
				<-0.539205, 0.773738, -0.315742>, <1.255435, 4.669724, -3.549995>
			}
			smooth_triangle {
				<-0.519811, 0.772378, -0.349755>, <0.857747, 3.883882, -3.027580>,
				<-0.515525, 0.786718, -0.323132>, <1.128957, 4.745384, -3.491328>,
				<-0.543450, 0.759328, -0.342348>, <1.179247, 4.578829, -3.691266>
			}
			smooth_triangle {
				<-0.543450, 0.759328, -0.342348>, <1.179247, 4.578829, -3.691266>,
				<-0.515525, 0.786718, -0.323132>, <1.128957, 4.745384, -3.491328>,
				<-0.539205, 0.773738, -0.315742>, <1.255435, 4.669724, -3.549995>
			}
			smooth_triangle {
				<-0.573680, 0.708778, -0.397042>, <1.105451, 4.275613, -4.058452>,
				<-0.540453, 0.727158, -0.410199>, <0.897594, 4.387588, -3.988810>,
				<-0.543494, 0.744668, -0.373079>, <1.049834, 4.489645, -3.836191>
			}
			smooth_triangle {
				<-0.458588, 0.812069, -0.345478>, <0.776629, 4.895737, -3.374215>,
				<-0.489382, 0.799288, -0.332798>, <0.936997, 4.827258, -3.433314>,
				<-0.504672, 0.770078, -0.376036>, <0.995900, 5.419448, -4.311489>
			}
			smooth_triangle {
				<-0.489382, 0.799288, -0.332798>, <0.936997, 4.827258, -3.433314>,
				<-0.519811, 0.772378, -0.349755>, <0.857747, 3.883882, -3.027580>,
				<-0.504672, 0.770078, -0.376036>, <0.995900, 5.419448, -4.311489>
			}
			smooth_triangle {
				<-0.540453, 0.727158, -0.410199>, <0.897594, 4.387588, -3.988810>,
				<-0.504672, 0.770078, -0.376036>, <0.995900, 5.419448, -4.311489>,
				<-0.543494, 0.744668, -0.373079>, <1.049834, 4.489645, -3.836191>
			}
			smooth_triangle {
				<-0.519811, 0.772378, -0.349755>, <0.857747, 3.883882, -3.027580>,
				<-0.543494, 0.744668, -0.373079>, <1.049834, 4.489645, -3.836191>,
				<-0.504672, 0.770078, -0.376036>, <0.995900, 5.419448, -4.311489>
			}
			smooth_triangle {
				<-0.458588, 0.812069, -0.345478>, <0.776629, 4.895737, -3.374215>,
				<-0.504672, 0.770078, -0.376036>, <0.995900, 5.419448, -4.311489>,
				<-0.469024, 0.783648, -0.393743>, <0.355396, 2.372319, -1.799213>
			}
			smooth_triangle {
				<-0.540453, 0.727158, -0.410199>, <0.897594, 4.387588, -3.988810>,
				<-0.506297, 0.743098, -0.424956>, <0.385679, 2.248304, -1.946569>,
				<-0.504672, 0.770078, -0.376036>, <0.995900, 5.419448, -4.311489>
			}
			smooth_triangle {
				<-0.504672, 0.770078, -0.376036>, <0.995900, 5.419448, -4.311489>,
				<-0.506297, 0.743098, -0.424956>, <0.385679, 2.248304, -1.946569>,
				<-0.469024, 0.783648, -0.393743>, <0.355396, 2.372319, -1.799213>
			}
			smooth_triangle {
				<-0.574476, 0.755348, -0.297554>, <1.490294, 4.559063, -3.603658>,
				<-0.587020, 0.747858, -0.291937>, <1.322078, 3.761379, -3.016675>,
				<-0.589933, 0.740918, -0.303513>, <1.283594, 3.725166, -3.077728>
			}
			smooth_triangle {
				<-0.645536, 0.677948, -0.335833>, <1.673336, 4.088648, -4.059135>,
				<-0.634362, 0.692838, -0.326608>, <1.382026, 3.483037, -3.309850>,
				<-0.646399, 0.684728, -0.320044>, <1.744483, 4.129669, -3.987272>
			}
			smooth_triangle {
				<-0.645701, 0.691538, -0.306532>, <1.791924, 4.171703, -3.922048>,
				<-0.633300, 0.700048, -0.313021>, <1.710577, 4.224672, -3.901455>,
				<-0.634001, 0.705418, -0.299248>, <1.764495, 4.256021, -3.843026>
			}
			smooth_triangle {
				<-0.587020, 0.747858, -0.291937>, <1.322078, 3.761379, -3.016675>,
				<-0.596068, 0.743928, -0.283522>, <1.364481, 3.742990, -3.020610>,
				<-0.601104, 0.734378, -0.297442>, <1.625485, 4.428443, -3.707028>
			}
			smooth_triangle {
				<-0.596068, 0.743928, -0.283522>, <1.364481, 3.742990, -3.020610>,
				<-0.611336, 0.729268, -0.289039>, <1.702969, 4.401101, -3.704727>,
				<-0.601104, 0.734378, -0.297442>, <1.625485, 4.428443, -3.707028>
			}
			smooth_triangle {
				<-0.633300, 0.700048, -0.313021>, <1.710577, 4.224672, -3.901455>,
				<-0.618419, 0.717288, -0.303578>, <1.954130, 5.049070, -4.436377>,
				<-0.634001, 0.705418, -0.299248>, <1.764495, 4.256021, -3.843026>
			}
			smooth_triangle {
				<-0.601104, 0.734378, -0.297442>, <1.625485, 4.428443, -3.707028>,
				<-0.611336, 0.729268, -0.289039>, <1.702969, 4.401101, -3.704727>,
				<-0.618419, 0.717288, -0.303578>, <1.954130, 5.049070, -4.436377>
			}
			smooth_triangle {
				<-0.611336, 0.729268, -0.289039>, <1.702969, 4.401101, -3.704727>,
				<-0.624883, 0.716758, -0.291353>, <1.461745, 3.604687, -3.141224>,
				<-0.618419, 0.717288, -0.303578>, <1.954130, 5.049070, -4.436377>
			}
			smooth_triangle {
				<-0.624883, 0.716758, -0.291353>, <1.461745, 3.604687, -3.141224>,
				<-0.634001, 0.705418, -0.299248>, <1.764495, 4.256021, -3.843026>,
				<-0.618419, 0.717288, -0.303578>, <1.954130, 5.049070, -4.436377>
			}
			smooth_triangle {
				<-0.587020, 0.747858, -0.291937>, <1.322078, 3.761379, -3.016675>,
				<-0.601104, 0.734378, -0.297442>, <1.625485, 4.428443, -3.707028>,
				<-0.589933, 0.740918, -0.303513>, <1.283594, 3.725166, -3.077728>
			}
			smooth_triangle {
				<-0.633300, 0.700048, -0.313021>, <1.710577, 4.224672, -3.901455>,
				<-0.620046, 0.707958, -0.321650>, <1.609859, 4.272476, -3.891976>,
				<-0.618419, 0.717288, -0.303578>, <1.954130, 5.049070, -4.436377>
			}
			smooth_triangle {
				<-0.620046, 0.707958, -0.321650>, <1.609859, 4.272476, -3.891976>,
				<-0.603016, 0.726448, -0.312664>, <1.568002, 4.381470, -3.786489>,
				<-0.618419, 0.717288, -0.303578>, <1.954130, 5.049070, -4.436377>
			}
			smooth_triangle {
				<-0.589933, 0.740918, -0.303513>, <1.283594, 3.725166, -3.077728>,
				<-0.601104, 0.734378, -0.297442>, <1.625485, 4.428443, -3.707028>,
				<-0.603016, 0.726448, -0.312664>, <1.568002, 4.381470, -3.786489>
			}
			smooth_triangle {
				<-0.601104, 0.734378, -0.297442>, <1.625485, 4.428443, -3.707028>,
				<-0.618419, 0.717288, -0.303578>, <1.954130, 5.049070, -4.436377>,
				<-0.603016, 0.726448, -0.312664>, <1.568002, 4.381470, -3.786489>
			}
			smooth_triangle {
				<-0.620046, 0.707958, -0.321650>, <1.609859, 4.272476, -3.891976>,
				<-0.633300, 0.700048, -0.313021>, <1.710577, 4.224672, -3.901455>,
				<-0.634362, 0.692838, -0.326608>, <1.382026, 3.483037, -3.309850>
			}
			smooth_triangle {
				<-0.645701, 0.691538, -0.306532>, <1.791924, 4.171703, -3.922048>,
				<-0.646399, 0.684728, -0.320044>, <1.744483, 4.129669, -3.987272>,
				<-0.633300, 0.700048, -0.313021>, <1.710577, 4.224672, -3.901455>
			}
			smooth_triangle {
				<-0.633300, 0.700048, -0.313021>, <1.710577, 4.224672, -3.901455>,
				<-0.646399, 0.684728, -0.320044>, <1.744483, 4.129669, -3.987272>,
				<-0.634362, 0.692838, -0.326608>, <1.382026, 3.483037, -3.309850>
			}
			smooth_triangle {
				<-0.645701, 0.691538, -0.306532>, <1.791924, 4.171703, -3.922048>,
				<-0.657708, 0.677748, -0.311756>, <1.825743, 4.089865, -3.992040>,
				<-0.646399, 0.684728, -0.320044>, <1.744483, 4.129669, -3.987272>
			}
			smooth_triangle {
				<-0.646399, 0.684728, -0.320044>, <1.744483, 4.129669, -3.987272>,
				<-0.657708, 0.677748, -0.311756>, <1.825743, 4.089865, -3.992040>,
				<-0.660929, 0.667818, -0.326050>, <2.081247, 4.699710, -4.751290>
			}
			smooth_triangle {
				<-0.657708, 0.677748, -0.311756>, <1.825743, 4.089865, -3.992040>,
				<-0.667857, 0.666528, -0.314362>, <1.553876, 3.350299, -3.370319>,
				<-0.660929, 0.667818, -0.326050>, <2.081247, 4.699710, -4.751290>
			}
			smooth_triangle {
				<-0.672873, 0.651418, -0.334669>, <1.811314, 3.931056, -4.154749>,
				<-0.660929, 0.667818, -0.326050>, <2.081247, 4.699710, -4.751290>,
				<-0.675036, 0.656168, -0.320740>, <1.871211, 3.956834, -4.103549>
			}
			smooth_triangle {
				<-0.667857, 0.666528, -0.314362>, <1.553876, 3.350299, -3.370319>,
				<-0.675036, 0.656168, -0.320740>, <1.871211, 3.956834, -4.103549>,
				<-0.660929, 0.667818, -0.326050>, <2.081247, 4.699710, -4.751290>
			}
			smooth_triangle {
				<-0.646399, 0.684728, -0.320044>, <1.744483, 4.129669, -3.987272>,
				<-0.660929, 0.667818, -0.326050>, <2.081247, 4.699710, -4.751290>,
				<-0.645536, 0.677948, -0.335833>, <1.673336, 4.088648, -4.059135>
			}
			smooth_triangle {
				<-0.672873, 0.651418, -0.334669>, <1.811314, 3.931056, -4.154749>,
				<-0.659978, 0.659538, -0.344301>, <1.707858, 3.981030, -4.150773>,
				<-0.660929, 0.667818, -0.326050>, <2.081247, 4.699710, -4.751290>
			}
			smooth_triangle {
				<-0.660929, 0.667818, -0.326050>, <2.081247, 4.699710, -4.751290>,
				<-0.659978, 0.659538, -0.344301>, <1.707858, 3.981030, -4.150773>,
				<-0.645536, 0.677948, -0.335833>, <1.673336, 4.088648, -4.059135>
			}
			smooth_triangle {
				<-0.506297, 0.743098, -0.424956>, <0.385679, 2.248304, -1.946569>,
				<-0.540453, 0.727158, -0.410199>, <0.897594, 4.387588, -3.988810>,
				<-0.538809, 0.702658, -0.452842>, <0.405197, 2.125324, -2.076745>
			}
			smooth_triangle {
				<-0.640221, 0.548028, -0.528102>, <0.496142, 1.656064, -2.451061>,
				<-0.646909, 0.569278, -0.496526>, <1.058772, 3.431682, -4.804497>,
				<-0.671362, 0.531588, -0.505770>, <1.135268, 3.197268, -4.946131>
			}
			smooth_triangle {
				<-0.651202, 0.587668, -0.468708>, <1.186961, 3.542029, -4.693645>,
				<-0.653030, 0.605478, -0.442789>, <1.301296, 3.652925, -4.577000>,
				<-0.673038, 0.574788, -0.453597>, <1.347233, 3.466823, -4.706605>
			}
			smooth_triangle {
				<-0.685045, 0.643068, -0.326009>, <1.901066, 3.878266, -4.164310>,
				<-0.695230, 0.629168, -0.331535>, <1.926439, 3.796807, -4.227177>,
				<-0.683348, 0.636758, -0.341583>, <1.833867, 3.840783, -4.228647>
			}
			smooth_triangle {
				<-0.673038, 0.574788, -0.453597>, <1.347233, 3.466823, -4.706605>,
				<-0.673252, 0.593488, -0.428510>, <1.445651, 3.580830, -4.590769>,
				<-0.691345, 0.564258, -0.439057>, <1.487863, 3.403977, -4.710320>
			}
			smooth_triangle {
				<-0.705424, 0.614388, -0.337679>, <1.613117, 3.081632, -3.591363>,
				<-0.703295, 0.606038, -0.356658>, <1.555561, 3.044014, -3.648310>,
				<-0.693585, 0.621388, -0.349193>, <1.848169, 3.749537, -4.303527>
			}
			smooth_triangle {
				<-0.703295, 0.606038, -0.356658>, <1.555561, 3.044014, -3.648310>,
				<-0.708157, 0.588708, -0.375567>, <2.112966, 4.141746, -5.231597>,
				<-0.692670, 0.611178, -0.368498>, <1.767449, 3.686015, -4.391161>
			}
			smooth_triangle {
				<-0.708157, 0.588708, -0.375567>, <2.112966, 4.141746, -5.231597>,
				<-0.706235, 0.573478, -0.401839>, <1.704092, 3.461861, -4.593706>,
				<-0.691951, 0.598018, -0.390759>, <1.680379, 3.606909, -4.489686>
			}
			smooth_triangle {
				<-0.673252, 0.593488, -0.428510>, <1.445651, 3.580830, -4.590769>,
				<-0.674600, 0.609368, -0.403373>, <1.548827, 3.676633, -4.480206>,
				<-0.690927, 0.582648, -0.415037>, <1.580247, 3.515515, -4.597126>
			}
			smooth_triangle {
				<-0.674600, 0.609368, -0.403373>, <1.548827, 3.676633, -4.480206>,
				<-0.691951, 0.598018, -0.390759>, <1.680379, 3.606909, -4.489686>,
				<-0.690927, 0.582648, -0.415037>, <1.580247, 3.515515, -4.597126>
			}
			smooth_triangle {
				<-0.691951, 0.598018, -0.390759>, <1.680379, 3.606909, -4.489686>,
				<-0.706235, 0.573478, -0.401839>, <1.704092, 3.461861, -4.593706>,
				<-0.690927, 0.582648, -0.415037>, <1.580247, 3.515515, -4.597126>
			}
			smooth_triangle {
				<-0.673252, 0.593488, -0.428510>, <1.445651, 3.580830, -4.590769>,
				<-0.690927, 0.582648, -0.415037>, <1.580247, 3.515515, -4.597126>,
				<-0.691345, 0.564258, -0.439057>, <1.487863, 3.403977, -4.710320>
			}
			smooth_triangle {
				<-0.706235, 0.573478, -0.401839>, <1.704092, 3.461861, -4.593706>,
				<-0.705949, 0.556337, -0.425720>, <1.605889, 3.357731, -4.704999>,
				<-0.690927, 0.582648, -0.415037>, <1.580247, 3.515515, -4.597126>
			}
			smooth_triangle {
				<-0.690927, 0.582648, -0.415037>, <1.580247, 3.515515, -4.597126>,
				<-0.705949, 0.556337, -0.425720>, <1.605889, 3.357731, -4.704999>,
				<-0.691345, 0.564258, -0.439057>, <1.487863, 3.403977, -4.710320>
			}
			smooth_triangle {
				<-0.708157, 0.588708, -0.375567>, <2.112966, 4.141746, -5.231597>,
				<-0.691951, 0.598018, -0.390759>, <1.680379, 3.606909, -4.489686>,
				<-0.692670, 0.611178, -0.368498>, <1.767449, 3.686015, -4.391161>
			}
			smooth_triangle {
				<-0.674600, 0.609368, -0.403373>, <1.548827, 3.676633, -4.480206>,
				<-0.677051, 0.621908, -0.379411>, <1.651996, 3.753115, -4.379025>,
				<-0.691951, 0.598018, -0.390759>, <1.680379, 3.606909, -4.489686>
			}
			smooth_triangle {
				<-0.691951, 0.598018, -0.390759>, <1.680379, 3.606909, -4.489686>,
				<-0.677051, 0.621908, -0.379411>, <1.651996, 3.753115, -4.379025>,
				<-0.692670, 0.611178, -0.368498>, <1.767449, 3.686015, -4.391161>
			}
			smooth_triangle {
				<-0.703295, 0.606038, -0.356658>, <1.555561, 3.044014, -3.648310>,
				<-0.692670, 0.611178, -0.368498>, <1.767449, 3.686015, -4.391161>,
				<-0.693585, 0.621388, -0.349193>, <1.848169, 3.749537, -4.303527>
			}
			smooth_triangle {
				<-0.677051, 0.621908, -0.379411>, <1.651996, 3.753115, -4.379025>,
				<-0.680444, 0.630368, -0.358797>, <1.746481, 3.801989, -4.299898>,
				<-0.692670, 0.611178, -0.368498>, <1.767449, 3.686015, -4.391161>
			}
			smooth_triangle {
				<-0.692670, 0.611178, -0.368498>, <1.767449, 3.686015, -4.391161>,
				<-0.680444, 0.630368, -0.358797>, <1.746481, 3.801989, -4.299898>,
				<-0.693585, 0.621388, -0.349193>, <1.848169, 3.749537, -4.303527>
			}
			smooth_triangle {
				<-0.705424, 0.614388, -0.337679>, <1.613117, 3.081632, -3.591363>,
				<-0.693585, 0.621388, -0.349193>, <1.848169, 3.749537, -4.303527>,
				<-0.695230, 0.629168, -0.331535>, <1.926439, 3.796807, -4.227177>
			}
			smooth_triangle {
				<-0.680444, 0.630368, -0.358797>, <1.746481, 3.801989, -4.299898>,
				<-0.683348, 0.636758, -0.341583>, <1.833867, 3.840783, -4.228647>,
				<-0.693585, 0.621388, -0.349193>, <1.848169, 3.749537, -4.303527>
			}
			smooth_triangle {
				<-0.693585, 0.621388, -0.349193>, <1.848169, 3.749537, -4.303527>,
				<-0.683348, 0.636758, -0.341583>, <1.833867, 3.840783, -4.228647>,
				<-0.695230, 0.629168, -0.331535>, <1.926439, 3.796807, -4.227177>
			}
			smooth_triangle {
				<-0.685045, 0.643068, -0.326009>, <1.901066, 3.878266, -4.164310>,
				<-0.683348, 0.636758, -0.341583>, <1.833867, 3.840783, -4.228647>,
				<-0.672873, 0.651418, -0.334669>, <1.811314, 3.931056, -4.154749>
			}
			smooth_triangle {
				<-0.673038, 0.574788, -0.453597>, <1.347233, 3.466823, -4.706605>,
				<-0.653030, 0.605478, -0.442789>, <1.301296, 3.652925, -4.577000>,
				<-0.673252, 0.593488, -0.428510>, <1.445651, 3.580830, -4.590769>
			}
			smooth_triangle {
				<-0.653030, 0.605478, -0.442789>, <1.301296, 3.652925, -4.577000>,
				<-0.654102, 0.623168, -0.415847>, <1.403951, 3.762703, -4.456011>,
				<-0.673252, 0.593488, -0.428510>, <1.445651, 3.580830, -4.590769>
			}
			smooth_triangle {
				<-0.673252, 0.593488, -0.428510>, <1.445651, 3.580830, -4.590769>,
				<-0.654102, 0.623168, -0.415847>, <1.403951, 3.762703, -4.456011>,
				<-0.674600, 0.609368, -0.403373>, <1.548827, 3.676633, -4.480206>
			}
			smooth_triangle {
				<-0.654102, 0.623168, -0.415847>, <1.403951, 3.762703, -4.456011>,
				<-0.657992, 0.635928, -0.389555>, <1.521325, 3.835618, -4.354554>,
				<-0.674600, 0.609368, -0.403373>, <1.548827, 3.676633, -4.480206>
			}
			smooth_triangle {
				<-0.674600, 0.609368, -0.403373>, <1.548827, 3.676633, -4.480206>,
				<-0.657992, 0.635928, -0.389555>, <1.521325, 3.835618, -4.354554>,
				<-0.677051, 0.621908, -0.379411>, <1.651996, 3.753115, -4.379025>
			}
			smooth_triangle {
				<-0.657992, 0.635928, -0.389555>, <1.521325, 3.835618, -4.354554>,
				<-0.662737, 0.645718, -0.364609>, <1.916768, 4.544732, -4.965930>,
				<-0.677051, 0.621908, -0.379411>, <1.651996, 3.753115, -4.379025>
			}
			smooth_triangle {
				<-0.677051, 0.621908, -0.379411>, <1.651996, 3.753115, -4.379025>,
				<-0.662737, 0.645718, -0.364609>, <1.916768, 4.544732, -4.965930>,
				<-0.680444, 0.630368, -0.358797>, <1.746481, 3.801989, -4.299898>
			}
			smooth_triangle {
				<-0.659978, 0.659538, -0.344301>, <1.707858, 3.981030, -4.150773>,
				<-0.672873, 0.651418, -0.334669>, <1.811314, 3.931056, -4.154749>,
				<-0.672029, 0.644818, -0.348862>, <1.456936, 3.241895, -3.516261>
			}
			smooth_triangle {
				<-0.672873, 0.651418, -0.334669>, <1.811314, 3.931056, -4.154749>,
				<-0.683348, 0.636758, -0.341583>, <1.833867, 3.840783, -4.228647>,
				<-0.672029, 0.644818, -0.348862>, <1.456936, 3.241895, -3.516261>
			}
			smooth_triangle {
				<-0.683348, 0.636758, -0.341583>, <1.833867, 3.840783, -4.228647>,
				<-0.680444, 0.630368, -0.358797>, <1.746481, 3.801989, -4.299898>,
				<-0.672029, 0.644818, -0.348862>, <1.456936, 3.241895, -3.516261>
			}
			smooth_triangle {
				<-0.659978, 0.659538, -0.344301>, <1.707858, 3.981030, -4.150773>,
				<-0.672029, 0.644818, -0.348862>, <1.456936, 3.241895, -3.516261>,
				<-0.662737, 0.645718, -0.364609>, <1.916768, 4.544732, -4.965930>
			}
			smooth_triangle {
				<-0.672029, 0.644818, -0.348862>, <1.456936, 3.241895, -3.516261>,
				<-0.680444, 0.630368, -0.358797>, <1.746481, 3.801989, -4.299898>,
				<-0.662737, 0.645718, -0.364609>, <1.916768, 4.544732, -4.965930>
			}
			smooth_triangle {
				<-0.705949, 0.556337, -0.425720>, <1.605889, 3.357731, -4.704999>,
				<-0.708917, 0.534627, -0.448019>, <1.533520, 3.224942, -4.820398>,
				<-0.691345, 0.564258, -0.439057>, <1.487863, 3.403977, -4.710320>
			}
			smooth_triangle {
				<-0.671362, 0.531588, -0.505770>, <1.135268, 3.197268, -4.946131>,
				<-0.673153, 0.554038, -0.478564>, <1.247753, 3.338762, -4.824721>,
				<-0.699779, 0.516847, -0.481965>, <0.874085, 2.116516, -3.278757>
			}
			smooth_triangle {
				<-0.673153, 0.554038, -0.478564>, <1.247753, 3.338762, -4.824721>,
				<-0.673038, 0.574788, -0.453597>, <1.347233, 3.466823, -4.706605>,
				<-0.693641, 0.542517, -0.462221>, <1.408535, 3.271847, -4.826636>
			}
			smooth_triangle {
				<-0.673038, 0.574788, -0.453597>, <1.347233, 3.466823, -4.706605>,
				<-0.691345, 0.564258, -0.439057>, <1.487863, 3.403977, -4.710320>,
				<-0.693641, 0.542517, -0.462221>, <1.408535, 3.271847, -4.826636>
			}
			smooth_triangle {
				<-0.691345, 0.564258, -0.439057>, <1.487863, 3.403977, -4.710320>,
				<-0.708917, 0.534627, -0.448019>, <1.533520, 3.224942, -4.820398>,
				<-0.693641, 0.542517, -0.462221>, <1.408535, 3.271847, -4.826636>
			}
			smooth_triangle {
				<-0.673153, 0.554038, -0.478564>, <1.247753, 3.338762, -4.824721>,
				<-0.693641, 0.542517, -0.462221>, <1.408535, 3.271847, -4.826636>,
				<-0.699779, 0.516847, -0.481965>, <0.874085, 2.116516, -3.278757>
			}
			smooth_triangle {
				<-0.708917, 0.534627, -0.448019>, <1.533520, 3.224942, -4.820398>,
				<-0.713099, 0.509177, -0.470475>, <1.232075, 2.577888, -4.102213>,
				<-0.693641, 0.542517, -0.462221>, <1.408535, 3.271847, -4.826636>
			}
			smooth_triangle {
				<-0.693641, 0.542517, -0.462221>, <1.408535, 3.271847, -4.826636>,
				<-0.713099, 0.509177, -0.470475>, <1.232075, 2.577888, -4.102213>,
				<-0.699779, 0.516847, -0.481965>, <0.874085, 2.116516, -3.278757>
			}
			smooth_triangle {
				<-0.673038, 0.574788, -0.453597>, <1.347233, 3.466823, -4.706605>,
				<-0.673153, 0.554038, -0.478564>, <1.247753, 3.338762, -4.824721>,
				<-0.651202, 0.587668, -0.468708>, <1.186961, 3.542029, -4.693645>
			}
			smooth_triangle {
				<-0.671362, 0.531588, -0.505770>, <1.135268, 3.197268, -4.946131>,
				<-0.646909, 0.569278, -0.496526>, <1.058772, 3.431682, -4.804497>,
				<-0.673153, 0.554038, -0.478564>, <1.247753, 3.338762, -4.824721>
			}
			smooth_triangle {
				<-0.673153, 0.554038, -0.478564>, <1.247753, 3.338762, -4.824721>,
				<-0.646909, 0.569278, -0.496526>, <1.058772, 3.431682, -4.804497>,
				<-0.651202, 0.587668, -0.468708>, <1.186961, 3.542029, -4.693645>
			}
			smooth_triangle {
				<-0.659978, 0.659538, -0.344301>, <1.707858, 3.981030, -4.150773>,
				<-0.662737, 0.645718, -0.364609>, <1.916768, 4.544732, -4.965930>,
				<-0.644484, 0.669038, -0.355161>, <1.597622, 4.037371, -4.139855>
			}
			smooth_triangle {
				<-0.640221, 0.548028, -0.528102>, <0.496142, 1.656064, -2.451061>,
				<-0.618152, 0.585628, -0.513842>, <0.466535, 1.769168, -2.376651>,
				<-0.646909, 0.569278, -0.496526>, <1.058772, 3.431682, -4.804497>
			}
			smooth_triangle {
				<-0.657992, 0.635928, -0.389555>, <1.521325, 3.835618, -4.354554>,
				<-0.654102, 0.623168, -0.415847>, <1.403951, 3.762703, -4.456011>,
				<-0.632093, 0.656898, -0.397567>, <1.593234, 4.625321, -5.004377>
			}
			smooth_triangle {
				<-0.632093, 0.656898, -0.397567>, <1.593234, 4.625321, -5.004377>,
				<-0.654102, 0.623168, -0.415847>, <1.403951, 3.762703, -4.456011>,
				<-0.630667, 0.636448, -0.431634>, <1.237999, 3.844353, -4.435071>
			}
			smooth_triangle {
				<-0.654102, 0.623168, -0.415847>, <1.403951, 3.762703, -4.456011>,
				<-0.653030, 0.605478, -0.442789>, <1.301296, 3.652925, -4.577000>,
				<-0.630667, 0.636448, -0.431634>, <1.237999, 3.844353, -4.435071>
			}
			smooth_triangle {
				<-0.618152, 0.585628, -0.513842>, <0.466535, 1.769168, -2.376651>,
				<-0.625046, 0.605118, -0.481936>, <1.008780, 3.651865, -4.650355>,
				<-0.646909, 0.569278, -0.496526>, <1.058772, 3.431682, -4.804497>
			}
			smooth_triangle {
				<-0.630667, 0.636448, -0.431634>, <1.237999, 3.844353, -4.435071>,
				<-0.653030, 0.605478, -0.442789>, <1.301296, 3.652925, -4.577000>,
				<-0.633281, 0.615988, -0.456763>, <0.954896, 3.099112, -3.804264>
			}
			smooth_triangle {
				<-0.653030, 0.605478, -0.442789>, <1.301296, 3.652925, -4.577000>,
				<-0.651202, 0.587668, -0.468708>, <1.186961, 3.542029, -4.693645>,
				<-0.633281, 0.615988, -0.456763>, <0.954896, 3.099112, -3.804264>
			}
			smooth_triangle {
				<-0.646909, 0.569278, -0.496526>, <1.058772, 3.431682, -4.804497>,
				<-0.625046, 0.605118, -0.481936>, <1.008780, 3.651865, -4.650355>,
				<-0.651202, 0.587668, -0.468708>, <1.186961, 3.542029, -4.693645>
			}
			smooth_triangle {
				<-0.651202, 0.587668, -0.468708>, <1.186961, 3.542029, -4.693645>,
				<-0.625046, 0.605118, -0.481936>, <1.008780, 3.651865, -4.650355>,
				<-0.633281, 0.615988, -0.456763>, <0.954896, 3.099112, -3.804264>
			}
			smooth_triangle {
				<-0.632093, 0.656898, -0.397567>, <1.593234, 4.625321, -5.004377>,
				<-0.630667, 0.636448, -0.431634>, <1.237999, 3.844353, -4.435071>,
				<-0.603454, 0.671348, -0.417435>, <1.160545, 4.050860, -4.268335>
			}
			smooth_triangle {
				<-0.618152, 0.585628, -0.513842>, <0.466535, 1.769168, -2.376651>,
				<-0.594192, 0.623848, -0.496847>, <0.451010, 1.884776, -2.289056>,
				<-0.625046, 0.605118, -0.481936>, <1.008780, 3.651865, -4.650355>
			}
			smooth_triangle {
				<-0.594192, 0.623848, -0.496847>, <0.451010, 1.884776, -2.289056>,
				<-0.604418, 0.644068, -0.457119>, <1.178085, 4.536797, -5.195663>,
				<-0.625046, 0.605118, -0.481936>, <1.008780, 3.651865, -4.650355>
			}
			smooth_triangle {
				<-0.603454, 0.671348, -0.417435>, <1.160545, 4.050860, -4.268335>,
				<-0.630667, 0.636448, -0.431634>, <1.237999, 3.844353, -4.435071>,
				<-0.604418, 0.644068, -0.457119>, <1.178085, 4.536797, -5.195663>
			}
			smooth_triangle {
				<-0.630667, 0.636448, -0.431634>, <1.237999, 3.844353, -4.435071>,
				<-0.633281, 0.615988, -0.456763>, <0.954896, 3.099112, -3.804264>,
				<-0.604418, 0.644068, -0.457119>, <1.178085, 4.536797, -5.195663>
			}
			smooth_triangle {
				<-0.633281, 0.615988, -0.456763>, <0.954896, 3.099112, -3.804264>,
				<-0.625046, 0.605118, -0.481936>, <1.008780, 3.651865, -4.650355>,
				<-0.604418, 0.644068, -0.457119>, <1.178085, 4.536797, -5.195663>
			}
			smooth_triangle {
				<-0.603454, 0.671348, -0.417435>, <1.160545, 4.050860, -4.268335>,
				<-0.604418, 0.644068, -0.457119>, <1.178085, 4.536797, -5.195663>,
				<-0.572049, 0.687138, -0.435563>, <0.950285, 4.142451, -4.231687>
			}
			smooth_triangle {
				<-0.594192, 0.623848, -0.496847>, <0.451010, 1.884776, -2.289056>,
				<-0.567912, 0.662848, -0.476682>, <0.433990, 2.003305, -2.189350>,
				<-0.604418, 0.644068, -0.457119>, <1.178085, 4.536797, -5.195663>
			}
			smooth_triangle {
				<-0.604418, 0.644068, -0.457119>, <1.178085, 4.536797, -5.195663>,
				<-0.567912, 0.662848, -0.476682>, <0.433990, 2.003305, -2.189350>,
				<-0.572049, 0.687138, -0.435563>, <0.950285, 4.142451, -4.231687>
			}
			smooth_triangle {
				<-0.572049, 0.687138, -0.435563>, <0.950285, 4.142451, -4.231687>,
				<-0.573680, 0.708778, -0.397042>, <1.105451, 4.275613, -4.058452>,
				<-0.603454, 0.671348, -0.417435>, <1.160545, 4.050860, -4.268335>
			}
			smooth_triangle {
				<-0.573680, 0.708778, -0.397042>, <1.105451, 4.275613, -4.058452>,
				<-0.602963, 0.692108, -0.382796>, <1.290502, 4.175728, -4.108114>,
				<-0.603454, 0.671348, -0.417435>, <1.160545, 4.050860, -4.268335>
			}
			smooth_triangle {
				<-0.603454, 0.671348, -0.417435>, <1.160545, 4.050860, -4.268335>,
				<-0.602963, 0.692108, -0.382796>, <1.290502, 4.175728, -4.108114>,
				<-0.632093, 0.656898, -0.397567>, <1.593234, 4.625321, -5.004377>
			}
			smooth_triangle {
				<-0.602963, 0.692108, -0.382796>, <1.290502, 4.175728, -4.108114>,
				<-0.626130, 0.679428, -0.368043>, <1.453246, 4.101641, -4.129315>,
				<-0.632093, 0.656898, -0.397567>, <1.593234, 4.625321, -5.004377>
			}
			smooth_triangle {
				<-0.626130, 0.679428, -0.368043>, <1.453246, 4.101641, -4.129315>,
				<-0.644484, 0.669038, -0.355161>, <1.597622, 4.037371, -4.139855>,
				<-0.644992, 0.657548, -0.375151>, <1.266016, 3.305964, -3.529964>
			}
			smooth_triangle {
				<-0.644484, 0.669038, -0.355161>, <1.597622, 4.037371, -4.139855>,
				<-0.662737, 0.645718, -0.364609>, <1.916768, 4.544732, -4.965930>,
				<-0.644992, 0.657548, -0.375151>, <1.266016, 3.305964, -3.529964>
			}
			smooth_triangle {
				<-0.662737, 0.645718, -0.364609>, <1.916768, 4.544732, -4.965930>,
				<-0.657992, 0.635928, -0.389555>, <1.521325, 3.835618, -4.354554>,
				<-0.644992, 0.657548, -0.375151>, <1.266016, 3.305964, -3.529964>
			}
			smooth_triangle {
				<-0.626130, 0.679428, -0.368043>, <1.453246, 4.101641, -4.129315>,
				<-0.644992, 0.657548, -0.375151>, <1.266016, 3.305964, -3.529964>,
				<-0.632093, 0.656898, -0.397567>, <1.593234, 4.625321, -5.004377>
			}
			smooth_triangle {
				<-0.644992, 0.657548, -0.375151>, <1.266016, 3.305964, -3.529964>,
				<-0.657992, 0.635928, -0.389555>, <1.521325, 3.835618, -4.354554>,
				<-0.632093, 0.656898, -0.397567>, <1.593234, 4.625321, -5.004377>
			}
			smooth_triangle {
				<-0.573680, 0.708778, -0.397042>, <1.105451, 4.275613, -4.058452>,
				<-0.572049, 0.687138, -0.435563>, <0.950285, 4.142451, -4.231687>,
				<-0.540453, 0.727158, -0.410199>, <0.897594, 4.387588, -3.988810>
			}
			smooth_triangle {
				<-0.567912, 0.662848, -0.476682>, <0.433990, 2.003305, -2.189350>,
				<-0.538809, 0.702658, -0.452842>, <0.405197, 2.125324, -2.076745>,
				<-0.572049, 0.687138, -0.435563>, <0.950285, 4.142451, -4.231687>
			}
			smooth_triangle {
				<-0.572049, 0.687138, -0.435563>, <0.950285, 4.142451, -4.231687>,
				<-0.538809, 0.702658, -0.452842>, <0.405197, 2.125324, -2.076745>,
				<-0.540453, 0.727158, -0.410199>, <0.897594, 4.387588, -3.988810>
			}
			smooth_triangle {
				<-0.655738, 0.688958, -0.290617>, <0.942044, 2.079733, -1.945982>,
				<-0.665297, 0.679338, -0.291538>, <0.958963, 2.047287, -1.971976>,
				<-0.656473, 0.684298, -0.299830>, <1.868486, 4.127601, -3.933048>
			}
			smooth_triangle {
				<-0.675036, 0.656168, -0.320740>, <1.871211, 3.956834, -4.103549>,
				<-0.667857, 0.666528, -0.314362>, <1.553876, 3.350299, -3.370319>,
				<-0.677005, 0.659448, -0.309676>, <1.925958, 3.977491, -4.058111>
			}
			smooth_triangle {
				<-0.656473, 0.684298, -0.299830>, <1.868486, 4.127601, -3.933048>,
				<-0.665297, 0.679338, -0.291538>, <0.958963, 2.047287, -1.971976>,
				<-0.668183, 0.671298, -0.303332>, <2.228466, 4.725277, -4.658553>
			}
			smooth_triangle {
				<-0.665297, 0.679338, -0.291538>, <0.958963, 2.047287, -1.971976>,
				<-0.673669, 0.669848, -0.294251>, <0.648156, 1.348488, -1.327165>,
				<-0.668183, 0.671298, -0.303332>, <2.228466, 4.725277, -4.658553>
			}
			smooth_triangle {
				<-0.673669, 0.669848, -0.294251>, <0.648156, 1.348488, -1.327165>,
				<-0.678637, 0.661528, -0.301570>, <0.972458, 1.999633, -2.013813>,
				<-0.668183, 0.671298, -0.303332>, <2.228466, 4.725277, -4.658553>
			}
			smooth_triangle {
				<-0.678637, 0.661528, -0.301570>, <0.972458, 1.999633, -2.013813>,
				<-0.677005, 0.659448, -0.309676>, <1.925958, 3.977491, -4.058111>,
				<-0.668183, 0.671298, -0.303332>, <2.228466, 4.725277, -4.658553>
			}
			smooth_triangle {
				<-0.656473, 0.684298, -0.299830>, <1.868486, 4.127601, -3.933048>,
				<-0.668183, 0.671298, -0.303332>, <2.228466, 4.725277, -4.658553>,
				<-0.657708, 0.677748, -0.311756>, <1.825743, 4.089865, -3.992040>
			}
			smooth_triangle {
				<-0.677005, 0.659448, -0.309676>, <1.925958, 3.977491, -4.058111>,
				<-0.667857, 0.666528, -0.314362>, <1.553876, 3.350299, -3.370319>,
				<-0.668183, 0.671298, -0.303332>, <2.228466, 4.725277, -4.658553>
			}
			smooth_triangle {
				<-0.668183, 0.671298, -0.303332>, <2.228466, 4.725277, -4.658553>,
				<-0.667857, 0.666528, -0.314362>, <1.553876, 3.350299, -3.370319>,
				<-0.657708, 0.677748, -0.311756>, <1.825743, 4.089865, -3.992040>
			}
			smooth_triangle {
				<-0.657708, 0.677748, -0.311756>, <1.825743, 4.089865, -3.992040>,
				<-0.645701, 0.691538, -0.306532>, <1.791924, 4.171703, -3.922048>,
				<-0.656473, 0.684298, -0.299830>, <1.868486, 4.127601, -3.933048>
			}
			smooth_triangle {
				<-0.655738, 0.688958, -0.290617>, <0.942044, 2.079733, -1.945982>,
				<-0.656473, 0.684298, -0.299830>, <1.868486, 4.127601, -3.933048>,
				<-0.645655, 0.696628, -0.294888>, <1.835751, 4.203869, -3.867098>
			}
			smooth_triangle {
				<-0.656473, 0.684298, -0.299830>, <1.868486, 4.127601, -3.933048>,
				<-0.645701, 0.691538, -0.306532>, <1.791924, 4.171703, -3.922048>,
				<-0.645655, 0.696628, -0.294888>, <1.835751, 4.203869, -3.867098>
			}
			smooth_triangle {
				<-0.645701, 0.691538, -0.306532>, <1.791924, 4.171703, -3.922048>,
				<-0.634001, 0.705418, -0.299248>, <1.764495, 4.256021, -3.843026>,
				<-0.645655, 0.696628, -0.294888>, <1.835751, 4.203869, -3.867098>
			}
			smooth_triangle {
				<-0.655738, 0.688958, -0.290617>, <0.942044, 2.079733, -1.945982>,
				<-0.645655, 0.696628, -0.294888>, <1.835751, 4.203869, -3.867098>,
				<-0.646177, 0.699378, -0.287125>, <0.617046, 1.405637, -1.281872>
			}
			smooth_triangle {
				<-0.634001, 0.705418, -0.299248>, <1.764495, 4.256021, -3.843026>,
				<-0.635316, 0.709838, -0.285678>, <1.205434, 2.849953, -2.534504>,
				<-0.645655, 0.696628, -0.294888>, <1.835751, 4.203869, -3.867098>
			}
			smooth_triangle {
				<-0.645655, 0.696628, -0.294888>, <1.835751, 4.203869, -3.867098>,
				<-0.635316, 0.709838, -0.285678>, <1.205434, 2.849953, -2.534504>,
				<-0.646177, 0.699378, -0.287125>, <0.617046, 1.405637, -1.281872>
			}
			smooth_triangle {
				<-0.634001, 0.705418, -0.299248>, <1.764495, 4.256021, -3.843026>,
				<-0.624883, 0.716758, -0.291353>, <1.461745, 3.604687, -3.141224>,
				<-0.635316, 0.709838, -0.285678>, <1.205434, 2.849953, -2.534504>
			}
			smooth_triangle {
				<-0.624883, 0.716758, -0.291353>, <1.461745, 3.604687, -3.141224>,
				<-0.624848, 0.721718, -0.278928>, <1.175125, 2.917576, -2.470837>,
				<-0.635316, 0.709838, -0.285678>, <1.205434, 2.849953, -2.534504>
			}
			smooth_triangle {
				<-0.685045, 0.643068, -0.326009>, <1.901066, 3.878266, -4.164310>,
				<-0.675036, 0.656168, -0.320740>, <1.871211, 3.956834, -4.103549>,
				<-0.685863, 0.648518, -0.313247>, <1.951103, 3.910101, -4.111178>
			}
			smooth_triangle {
				<-0.675036, 0.656168, -0.320740>, <1.871211, 3.956834, -4.103549>,
				<-0.677005, 0.659448, -0.309676>, <1.925958, 3.977491, -4.058111>,
				<-0.685863, 0.648518, -0.313247>, <1.951103, 3.910101, -4.111178>
			}
			smooth_triangle {
				<-0.678637, 0.661528, -0.301570>, <0.972458, 1.999633, -2.013813>,
				<-0.686037, 0.652478, -0.304525>, <0.983874, 1.969026, -2.038288>,
				<-0.677005, 0.659448, -0.309676>, <1.925958, 3.977491, -4.058111>
			}
			smooth_triangle {
				<-0.677005, 0.659448, -0.309676>, <1.925958, 3.977491, -4.058111>,
				<-0.686037, 0.652478, -0.304525>, <0.983874, 1.969026, -2.038288>,
				<-0.685863, 0.648518, -0.313247>, <1.951103, 3.910101, -4.111178>
			}
			smooth_triangle {
				<-0.695230, 0.629168, -0.331535>, <1.926439, 3.796807, -4.227177>,
				<-0.685045, 0.643068, -0.326009>, <1.901066, 3.878266, -4.164310>,
				<-0.697149, 0.636088, -0.313816>, <1.311533, 2.564389, -2.775423>
			}
			smooth_triangle {
				<-0.685045, 0.643068, -0.326009>, <1.901066, 3.878266, -4.164310>,
				<-0.685863, 0.648518, -0.313247>, <1.951103, 3.910101, -4.111178>,
				<-0.697149, 0.636088, -0.313816>, <1.311533, 2.564389, -2.775423>
			}
			smooth_triangle {
				<-0.697149, 0.636088, -0.313816>, <1.311533, 2.564389, -2.775423>,
				<-0.685863, 0.648518, -0.313247>, <1.951103, 3.910101, -4.111178>,
				<-0.694420, 0.643628, -0.304357>, <0.663163, 1.296874, -1.370503>
			}
			smooth_triangle {
				<-0.686037, 0.652478, -0.304525>, <0.983874, 1.969026, -2.038288>,
				<-0.694420, 0.643628, -0.304357>, <0.663163, 1.296874, -1.370503>,
				<-0.685863, 0.648518, -0.313247>, <1.951103, 3.910101, -4.111178>
			}
			smooth_triangle {
				<-0.697149, 0.636088, -0.313816>, <1.311533, 2.564389, -2.775423>,
				<-0.705812, 0.623068, -0.320515>, <0.657633, 1.259109, -1.407836>,
				<-0.695230, 0.629168, -0.331535>, <1.926439, 3.796807, -4.227177>
			}
			smooth_triangle {
				<-0.705812, 0.623068, -0.320515>, <0.657633, 1.259109, -1.407836>,
				<-0.705424, 0.614388, -0.337679>, <1.613117, 3.081632, -3.591363>,
				<-0.695230, 0.629168, -0.331535>, <1.926439, 3.796807, -4.227177>
			}
			smooth_triangle {
				<-0.624883, 0.716758, -0.291353>, <1.461745, 3.604687, -3.141224>,
				<-0.611336, 0.729268, -0.289039>, <1.702969, 4.401101, -3.704727>,
				<-0.624848, 0.721718, -0.278928>, <1.175125, 2.917576, -2.470837>
			}
			smooth_triangle {
				<-0.596068, 0.743928, -0.283522>, <1.364481, 3.742990, -3.020610>,
				<-0.601895, 0.740978, -0.278907>, <1.151975, 2.954756, -2.437366>,
				<-0.611336, 0.729268, -0.289039>, <1.702969, 4.401101, -3.704727>
			}
			smooth_triangle {
				<-0.624848, 0.721718, -0.278928>, <1.175125, 2.917576, -2.470837>,
				<-0.611336, 0.729268, -0.289039>, <1.702969, 4.401101, -3.704727>,
				<-0.601895, 0.740978, -0.278907>, <1.151975, 2.954756, -2.437366>
			}
			smooth_triangle {
				<-0.604600, 0.744698, -0.262669>, <0.292579, 0.743991, -0.600729>,
				<-0.614720, 0.733778, -0.269829>, <0.579231, 1.477811, -1.216634>,
				<-0.601895, 0.740978, -0.278907>, <1.151975, 2.954756, -2.437366>
			}
			smooth_triangle {
				<-0.601895, 0.740978, -0.278907>, <1.151975, 2.954756, -2.437366>,
				<-0.614720, 0.733778, -0.269829>, <0.579231, 1.477811, -1.216634>,
				<-0.624848, 0.721718, -0.278928>, <1.175125, 2.917576, -2.470837>
			}
			smooth_triangle {
				<-0.697874, 0.465017, -0.534644>, <0.362950, 0.949878, -1.721670>,
				<-0.698608, 0.435977, -0.557656>, <0.175198, 0.457509, -0.871775>,
				<-0.680145, 0.473548, -0.549794>, <0.548405, 1.446991, -2.569305>
			}
			smooth_triangle {
				<-0.640221, 0.548028, -0.528102>, <0.496142, 1.656064, -2.451061>,
				<-0.671362, 0.531588, -0.505770>, <1.135268, 3.197268, -4.946131>,
				<-0.660773, 0.510768, -0.539994>, <0.541931, 1.538173, -2.517305>
			}
			smooth_triangle {
				<-0.680145, 0.473548, -0.549794>, <0.548405, 1.446991, -2.569305>,
				<-0.704057, 0.487377, -0.505841>, <0.766604, 2.009949, -3.371946>,
				<-0.697874, 0.465017, -0.534644>, <0.362950, 0.949878, -1.721670>
			}
			smooth_triangle {
				<-0.680145, 0.473548, -0.549794>, <0.548405, 1.446991, -2.569305>,
				<-0.660773, 0.510768, -0.539994>, <0.541931, 1.538173, -2.517305>,
				<-0.704057, 0.487377, -0.505841>, <0.766604, 2.009949, -3.371946>
			}
			smooth_triangle {
				<-0.660773, 0.510768, -0.539994>, <0.541931, 1.538173, -2.517305>,
				<-0.671362, 0.531588, -0.505770>, <1.135268, 3.197268, -4.946131>,
				<-0.704057, 0.487377, -0.505841>, <0.766604, 2.009949, -3.371946>
			}
			smooth_triangle {
				<-0.704057, 0.487377, -0.505841>, <0.766604, 2.009949, -3.371946>,
				<-0.671362, 0.531588, -0.505770>, <1.135268, 3.197268, -4.946131>,
				<-0.699779, 0.516847, -0.481965>, <0.874085, 2.116516, -3.278757>
			}
			smooth_triangle {
				<-0.725552, 0.429877, -0.527149>, <0.639160, 1.306909, -2.623120>,
				<-0.716774, 0.451507, -0.521043>, <0.653894, 1.352414, -2.596113>,
				<-0.732954, 0.448517, -0.500717>, <0.692355, 1.376785, -2.573614>
			}
			smooth_triangle {
				<-0.716774, 0.451507, -0.521043>, <0.653894, 1.352414, -2.596113>,
				<-0.716611, 0.480837, -0.494340>, <0.945377, 1.908090, -3.385441>,
				<-0.732954, 0.448517, -0.500717>, <0.692355, 1.376785, -2.573614>
			}
			smooth_triangle {
				<-0.732954, 0.448517, -0.500717>, <0.692355, 1.376785, -2.573614>,
				<-0.716611, 0.480837, -0.494340>, <0.945377, 1.908090, -3.385441>,
				<-0.735450, 0.463307, -0.483297>, <0.480168, 0.943076, -1.697013>
			}
			smooth_triangle {
				<-0.716611, 0.480837, -0.494340>, <0.945377, 1.908090, -3.385441>,
				<-0.726090, 0.483377, -0.477758>, <0.735479, 1.473647, -2.507087>,
				<-0.735450, 0.463307, -0.483297>, <0.480168, 0.943076, -1.697013>
			}
			smooth_triangle {
				<-0.716539, 0.389527, -0.569162>, <0.188730, 0.408259, -0.893143>,
				<-0.717557, 0.419437, -0.546168>, <0.599802, 1.272011, -2.649322>,
				<-0.726165, 0.407277, -0.543997>, <0.402308, 0.829171, -1.774743>
			}
			smooth_triangle {
				<-0.716774, 0.451507, -0.521043>, <0.653894, 1.352414, -2.596113>,
				<-0.725552, 0.429877, -0.527149>, <0.639160, 1.306909, -2.623120>,
				<-0.717557, 0.419437, -0.546168>, <0.599802, 1.272011, -2.649322>
			}
			smooth_triangle {
				<-0.725552, 0.429877, -0.527149>, <0.639160, 1.306909, -2.623120>,
				<-0.726165, 0.407277, -0.543997>, <0.402308, 0.829171, -1.774743>,
				<-0.717557, 0.419437, -0.546168>, <0.599802, 1.272011, -2.649322>
			}
			smooth_triangle {
				<-0.720278, 0.530117, -0.435066>, <0.804613, 1.615095, -2.396264>,
				<-0.726869, 0.504267, -0.454417>, <0.774785, 1.543891, -2.452423>,
				<-0.708917, 0.534627, -0.448019>, <1.533520, 3.224942, -4.820398>
			}
			smooth_triangle {
				<-0.716611, 0.480837, -0.494340>, <0.945377, 1.908090, -3.385441>,
				<-0.713099, 0.509177, -0.470475>, <1.232075, 2.577888, -4.102213>,
				<-0.726090, 0.483377, -0.477758>, <0.735479, 1.473647, -2.507087>
			}
			smooth_triangle {
				<-0.708917, 0.534627, -0.448019>, <1.533520, 3.224942, -4.820398>,
				<-0.726869, 0.504267, -0.454417>, <0.774785, 1.543891, -2.452423>,
				<-0.713099, 0.509177, -0.470475>, <1.232075, 2.577888, -4.102213>
			}
			smooth_triangle {
				<-0.726869, 0.504267, -0.454417>, <0.774785, 1.543891, -2.452423>,
				<-0.726090, 0.483377, -0.477758>, <0.735479, 1.473647, -2.507087>,
				<-0.713099, 0.509177, -0.470475>, <1.232075, 2.577888, -4.102213>
			}
			smooth_triangle {
				<-0.720278, 0.530117, -0.435066>, <0.804613, 1.615095, -2.396264>,
				<-0.705949, 0.556337, -0.425720>, <1.605889, 3.357731, -4.704999>,
				<-0.715882, 0.552477, -0.414004>, <0.842655, 1.678323, -2.339077>
			}
			smooth_triangle {
				<-0.720278, 0.530117, -0.435066>, <0.804613, 1.615095, -2.396264>,
				<-0.708917, 0.534627, -0.448019>, <1.533520, 3.224942, -4.820398>,
				<-0.705949, 0.556337, -0.425720>, <1.605889, 3.357731, -4.704999>
			}
			smooth_triangle {
				<-0.708157, 0.588708, -0.375567>, <2.112966, 4.141746, -5.231597>,
				<-0.722419, 0.561657, -0.389577>, <0.892937, 1.722539, -2.287899>,
				<-0.706235, 0.573478, -0.401839>, <1.704092, 3.461861, -4.593706>
			}
			smooth_triangle {
				<-0.708157, 0.588708, -0.375567>, <2.112966, 4.141746, -5.231597>,
				<-0.722399, 0.575588, -0.368721>, <0.618369, 1.168731, -1.500389>,
				<-0.722419, 0.561657, -0.389577>, <0.892937, 1.722539, -2.287899>
			}
			smooth_triangle {
				<-0.715619, 0.594168, -0.352100>, <1.278663, 2.403344, -2.930239>,
				<-0.708157, 0.588708, -0.375567>, <2.112966, 4.141746, -5.231597>,
				<-0.703295, 0.606038, -0.356658>, <1.555561, 3.044014, -3.648310>
			}
			smooth_triangle {
				<-0.715619, 0.594168, -0.352100>, <1.278663, 2.403344, -2.930239>,
				<-0.722399, 0.575588, -0.368721>, <0.618369, 1.168731, -1.500389>,
				<-0.708157, 0.588708, -0.375567>, <2.112966, 4.141746, -5.231597>
			}
			smooth_triangle {
				<-0.715882, 0.552477, -0.414004>, <0.842655, 1.678323, -2.339077>,
				<-0.706235, 0.573478, -0.401839>, <1.704092, 3.461861, -4.593706>,
				<-0.722419, 0.561657, -0.389577>, <0.892937, 1.722539, -2.287899>
			}
			smooth_triangle {
				<-0.715882, 0.552477, -0.414004>, <0.842655, 1.678323, -2.339077>,
				<-0.705949, 0.556337, -0.425720>, <1.605889, 3.357731, -4.704999>,
				<-0.706235, 0.573478, -0.401839>, <1.704092, 3.461861, -4.593706>
			}
			smooth_triangle {
				<-0.715619, 0.594168, -0.352100>, <1.278663, 2.403344, -2.930239>,
				<-0.705424, 0.614388, -0.337679>, <1.613117, 3.081632, -3.591363>,
				<-0.710206, 0.612297, -0.331383>, <0.328725, 0.606444, -0.723992>
			}
			smooth_triangle {
				<-0.715619, 0.594168, -0.352100>, <1.278663, 2.403344, -2.930239>,
				<-0.703295, 0.606038, -0.356658>, <1.555561, 3.044014, -3.648310>,
				<-0.705424, 0.614388, -0.337679>, <1.613117, 3.081632, -3.591363>
			}
			smooth_triangle {
				<-0.154877, -0.698681, -0.690628>, <-2.293912, -4.917777, -4.419981>,
				<-0.167468, -0.675701, -0.710284>, <-1.651533, -3.393096, -3.278651>,
				<-0.184197, -0.688081, -0.694066>, <-1.246221, -2.773728, -2.597940>
			}
			smooth_triangle {
				<-0.140034, -0.675771, -0.716125>, <-2.132208, -4.075473, -3.850943>,
				<-0.167468, -0.675701, -0.710284>, <-1.651533, -3.393096, -3.278651>,
				<-0.154877, -0.698681, -0.690628>, <-2.293912, -4.917777, -4.419981>
			}
			smooth_triangle {
				<-0.167468, -0.675701, -0.710284>, <-1.651533, -3.393096, -3.278651>,
				<-0.140034, -0.675771, -0.716125>, <-2.132208, -4.075473, -3.850943>,
				<-0.159146, -0.652291, -0.733689>, <-2.105996, -3.927584, -4.014904>
			}
			smooth_triangle {
				<-0.198484, -0.662781, -0.714452>, <-1.310771, -2.642189, -2.701185>,
				<-0.167468, -0.675701, -0.710284>, <-1.651533, -3.393096, -3.278651>,
				<-0.159146, -0.652291, -0.733689>, <-2.105996, -3.927584, -4.014904>
			}
			smooth_triangle {
				<-0.198484, -0.662781, -0.714452>, <-1.310771, -2.642189, -2.701185>,
				<-0.184197, -0.688081, -0.694066>, <-1.246221, -2.773728, -2.597940>,
				<-0.167468, -0.675701, -0.710284>, <-1.651533, -3.393096, -3.278651>
			}
			smooth_triangle {
				<-0.179159, -0.625051, -0.752546>, <-2.094923, -3.770942, -4.166971>,
				<-0.198484, -0.662781, -0.714452>, <-1.310771, -2.642189, -2.701185>,
				<-0.159146, -0.652291, -0.733689>, <-2.105996, -3.927584, -4.014904>
			}
			smooth_triangle {
				<-0.179159, -0.625051, -0.752546>, <-2.094923, -3.770942, -4.166971>,
				<-0.201574, -0.631081, -0.741766>, <-0.672481, -1.268496, -1.391515>,
				<-0.198484, -0.662781, -0.714452>, <-1.310771, -2.642189, -2.701185>
			}
			smooth_triangle {
				<-0.124324, -0.650611, -0.741865>, <-2.306169, -3.922798, -3.908184>,
				<-0.159146, -0.652291, -0.733689>, <-2.105996, -3.927584, -4.014904>,
				<-0.140034, -0.675771, -0.716125>, <-2.132208, -4.075473, -3.850943>
			}
			smooth_triangle {
				<-0.159146, -0.652291, -0.733689>, <-2.105996, -3.927584, -4.014904>,
				<-0.143668, -0.622201, -0.762459>, <-2.284936, -3.751593, -4.084547>,
				<-0.179159, -0.625051, -0.752546>, <-2.094923, -3.770942, -4.166971>
			}
			smooth_triangle {
				<-0.124324, -0.650611, -0.741865>, <-2.306169, -3.922798, -3.908184>,
				<-0.143668, -0.622201, -0.762459>, <-2.284936, -3.751593, -4.084547>,
				<-0.159146, -0.652291, -0.733689>, <-2.105996, -3.927584, -4.014904>
			}
			smooth_triangle {
				<-0.124218, -0.698401, -0.697074>, <-2.127660, -4.208342, -3.708191>,
				<-0.140034, -0.675771, -0.716125>, <-2.132208, -4.075473, -3.850943>,
				<-0.154877, -0.698681, -0.690628>, <-2.293912, -4.917777, -4.419981>
			}
			smooth_triangle {
				<-0.140034, -0.675771, -0.716125>, <-2.132208, -4.075473, -3.850943>,
				<-0.109142, -0.677571, -0.719789>, <-2.286301, -4.083768, -3.752290>,
				<-0.124324, -0.650611, -0.741865>, <-2.306169, -3.922798, -3.908184>
			}
			smooth_triangle {
				<-0.124218, -0.698401, -0.697074>, <-2.127660, -4.208342, -3.708191>,
				<-0.109142, -0.677571, -0.719789>, <-2.286301, -4.083768, -3.752290>,
				<-0.140034, -0.675771, -0.716125>, <-2.132208, -4.075473, -3.850943>
			}
			smooth_triangle {
				<-0.207543, -0.594341, -0.769928>, <-1.058175, -1.802656, -2.151000>,
				<-0.161996, -0.585171, -0.787678>, <-2.682868, -4.111560, -4.985675>,
				<-0.196773, -0.553761, -0.802333>, <-1.141284, -1.675827, -2.209670>
			}
			smooth_triangle {
				<-0.161996, -0.585171, -0.787678>, <-2.682868, -4.111560, -4.985675>,
				<-0.179159, -0.625051, -0.752546>, <-2.094923, -3.770942, -4.166971>,
				<-0.143668, -0.622201, -0.762459>, <-2.284936, -3.751593, -4.084547>
			}
			smooth_triangle {
				<-0.207543, -0.594341, -0.769928>, <-1.058175, -1.802656, -2.151000>,
				<-0.179159, -0.625051, -0.752546>, <-2.094923, -3.770942, -4.166971>,
				<-0.161996, -0.585171, -0.787678>, <-2.682868, -4.111560, -4.985675>
			}
			smooth_triangle {
				<-0.179159, -0.625051, -0.752546>, <-2.094923, -3.770942, -4.166971>,
				<-0.207543, -0.594341, -0.769928>, <-1.058175, -1.802656, -2.151000>,
				<-0.201574, -0.631081, -0.741766>, <-0.672481, -1.268496, -1.391515>
			}
			smooth_triangle {
				<-0.196773, -0.553761, -0.802333>, <-1.141284, -1.675827, -2.209670>,
				<-0.155427, -0.535541, -0.823502>, <-2.478727, -3.224329, -4.406621>,
				<-0.202656, -0.504251, -0.832929>, <-1.206605, -1.525484, -2.282846>
			}
			smooth_triangle {
				<-0.083860, -0.652921, -0.745494>, <-2.900151, -4.560603, -4.445644>,
				<-0.124324, -0.650611, -0.741865>, <-2.306169, -3.922798, -3.908184>,
				<-0.109142, -0.677571, -0.719789>, <-2.286301, -4.083768, -3.752290>
			}
			smooth_triangle {
				<-0.098291, -0.590121, -0.794491>, <-2.625148, -3.561253, -4.050895>,
				<-0.109025, -0.621181, -0.768997>, <-2.481934, -3.752148, -3.967591>,
				<-0.076039, -0.612451, -0.779888>, <-2.666537, -3.699461, -3.896731>
			}
			smooth_triangle {
				<-0.127062, -0.596991, -0.785218>, <-2.042737, -2.997924, -3.439007>,
				<-0.161996, -0.585171, -0.787678>, <-2.682868, -4.111560, -4.985675>,
				<-0.143668, -0.622201, -0.762459>, <-2.284936, -3.751593, -4.084547>
			}
			smooth_triangle {
				<-0.196773, -0.553761, -0.802333>, <-1.141284, -1.675827, -2.209670>,
				<-0.161996, -0.585171, -0.787678>, <-2.682868, -4.111560, -4.985675>,
				<-0.155427, -0.535541, -0.823502>, <-2.478727, -3.224329, -4.406621>
			}
			smooth_triangle {
				<-0.161996, -0.585171, -0.787678>, <-2.682868, -4.111560, -4.985675>,
				<-0.121592, -0.565141, -0.809285>, <-2.568750, -3.393250, -4.226089>,
				<-0.155427, -0.535541, -0.823502>, <-2.478727, -3.224329, -4.406621>
			}
			smooth_triangle {
				<-0.161996, -0.585171, -0.787678>, <-2.682868, -4.111560, -4.985675>,
				<-0.127062, -0.596991, -0.785218>, <-2.042737, -2.997924, -3.439007>,
				<-0.121592, -0.565141, -0.809285>, <-2.568750, -3.393250, -4.226089>
			}
			smooth_triangle {
				<-0.109025, -0.621181, -0.768997>, <-2.481934, -3.752148, -3.967591>,
				<-0.127062, -0.596991, -0.785218>, <-2.042737, -2.997924, -3.439007>,
				<-0.143668, -0.622201, -0.762459>, <-2.284936, -3.751593, -4.084547>
			}
			smooth_triangle {
				<-0.127062, -0.596991, -0.785218>, <-2.042737, -2.997924, -3.439007>,
				<-0.098291, -0.590121, -0.794491>, <-2.625148, -3.561253, -4.050895>,
				<-0.121592, -0.565141, -0.809285>, <-2.568750, -3.393250, -4.226089>
			}
			smooth_triangle {
				<-0.109025, -0.621181, -0.768997>, <-2.481934, -3.752148, -3.967591>,
				<-0.098291, -0.590121, -0.794491>, <-2.625148, -3.561253, -4.050895>,
				<-0.127062, -0.596991, -0.785218>, <-2.042737, -2.997924, -3.439007>
			}
			smooth_triangle {
				<-0.124324, -0.650611, -0.741865>, <-2.306169, -3.922798, -3.908184>,
				<-0.109025, -0.621181, -0.768997>, <-2.481934, -3.752148, -3.967591>,
				<-0.143668, -0.622201, -0.762459>, <-2.284936, -3.751593, -4.084547>
			}
			smooth_triangle {
				<-0.109025, -0.621181, -0.768997>, <-2.481934, -3.752148, -3.967591>,
				<-0.083860, -0.652921, -0.745494>, <-2.900151, -4.560603, -4.445644>,
				<-0.076039, -0.612451, -0.779888>, <-2.666537, -3.699461, -3.896731>
			}
			smooth_triangle {
				<-0.124324, -0.650611, -0.741865>, <-2.306169, -3.922798, -3.908184>,
				<-0.083860, -0.652921, -0.745494>, <-2.900151, -4.560603, -4.445644>,
				<-0.109025, -0.621181, -0.768997>, <-2.481934, -3.752148, -3.967591>
			}
			smooth_triangle {
				<-0.083860, -0.652921, -0.745494>, <-2.900151, -4.560603, -4.445644>,
				<-0.052816, -0.624971, -0.771830>, <-1.804486, -2.510449, -2.536636>,
				<-0.076039, -0.612451, -0.779888>, <-2.666537, -3.699461, -3.896731>
			}
			smooth_triangle {
				<-0.083860, -0.652921, -0.745494>, <-2.900151, -4.560603, -4.445644>,
				<-0.057036, -0.651921, -0.748904>, <-0.435645, -0.639516, -0.633430>,
				<-0.052816, -0.624971, -0.771830>, <-1.804486, -2.510449, -2.536636>
			}
			smooth_triangle {
				<-0.154877, -0.698681, -0.690628>, <-2.293912, -4.917777, -4.419981>,
				<-0.133305, -0.719671, -0.673366>, <-1.985515, -4.341755, -3.632299>,
				<-0.124218, -0.698401, -0.697074>, <-2.127660, -4.208342, -3.708191>
			}
			smooth_triangle {
				<-0.157958, -0.723871, -0.663449>, <-1.848668, -4.368536, -3.672257>,
				<-0.134859, -0.747041, -0.642533>, <-2.173933, -5.258307, -4.074621>,
				<-0.133305, -0.719671, -0.673366>, <-1.985515, -4.341755, -3.632299>
			}
			smooth_triangle {
				<-0.157958, -0.723871, -0.663449>, <-1.848668, -4.368536, -3.672257>,
				<-0.164942, -0.744841, -0.638060>, <-1.710822, -4.495610, -3.584339>,
				<-0.134859, -0.747041, -0.642533>, <-2.173933, -5.258307, -4.074621>
			}
			smooth_triangle {
				<-0.195488, -0.737021, -0.638510>, <-1.081923, -2.983225, -2.434402>,
				<-0.183112, -0.723921, -0.656898>, <-1.700333, -4.368332, -3.743871>,
				<-0.204070, -0.726411, -0.647914>, <-0.546410, -1.452796, -1.261107>
			}
			smooth_triangle {
				<-0.183112, -0.723921, -0.656898>, <-1.700333, -4.368332, -3.743871>,
				<-0.164942, -0.744841, -0.638060>, <-1.710822, -4.495610, -3.584339>,
				<-0.157958, -0.723871, -0.663449>, <-1.848668, -4.368536, -3.672257>
			}
			smooth_triangle {
				<-0.183112, -0.723921, -0.656898>, <-1.700333, -4.368332, -3.743871>,
				<-0.195488, -0.737021, -0.638510>, <-1.081923, -2.983225, -2.434402>,
				<-0.164942, -0.744841, -0.638060>, <-1.710822, -4.495610, -3.584339>
			}
			smooth_triangle {
				<-0.154877, -0.698681, -0.690628>, <-2.293912, -4.917777, -4.419981>,
				<-0.157958, -0.723871, -0.663449>, <-1.848668, -4.368536, -3.672257>,
				<-0.133305, -0.719671, -0.673366>, <-1.985515, -4.341755, -3.632299>
			}
			smooth_triangle {
				<-0.183112, -0.723921, -0.656898>, <-1.700333, -4.368332, -3.743871>,
				<-0.199570, -0.702751, -0.674848>, <-0.857649, -2.138402, -1.920993>,
				<-0.204070, -0.726411, -0.647914>, <-0.546410, -1.452796, -1.261107>
			}
			smooth_triangle {
				<-0.176032, -0.707611, -0.676323>, <-1.510120, -3.557395, -3.171344>,
				<-0.183112, -0.723921, -0.656898>, <-1.700333, -4.368332, -3.743871>,
				<-0.157958, -0.723871, -0.663449>, <-1.848668, -4.368536, -3.672257>
			}
			smooth_triangle {
				<-0.176032, -0.707611, -0.676323>, <-1.510120, -3.557395, -3.171344>,
				<-0.199570, -0.702751, -0.674848>, <-0.857649, -2.138402, -1.920993>,
				<-0.183112, -0.723921, -0.656898>, <-1.700333, -4.368332, -3.743871>
			}
			smooth_triangle {
				<-0.176032, -0.707611, -0.676323>, <-1.510120, -3.557395, -3.171344>,
				<-0.184197, -0.688081, -0.694066>, <-1.246221, -2.773728, -2.597940>,
				<-0.199570, -0.702751, -0.674848>, <-0.857649, -2.138402, -1.920993>
			}
			smooth_triangle {
				<-0.154877, -0.698681, -0.690628>, <-2.293912, -4.917777, -4.419981>,
				<-0.176032, -0.707611, -0.676323>, <-1.510120, -3.557395, -3.171344>,
				<-0.157958, -0.723871, -0.663449>, <-1.848668, -4.368536, -3.672257>
			}
			smooth_triangle {
				<-0.154877, -0.698681, -0.690628>, <-2.293912, -4.917777, -4.419981>,
				<-0.184197, -0.688081, -0.694066>, <-1.246221, -2.773728, -2.597940>,
				<-0.176032, -0.707611, -0.676323>, <-1.510120, -3.557395, -3.171344>
			}
			smooth_triangle {
				<-0.164942, -0.744841, -0.638060>, <-1.710822, -4.495610, -3.584339>,
				<-0.145812, -0.769801, -0.612586>, <-1.696376, -4.643401, -3.397665>,
				<-0.134859, -0.747041, -0.642533>, <-2.173933, -5.258307, -4.074621>
			}
			smooth_triangle {
				<-0.164942, -0.744841, -0.638060>, <-1.710822, -4.495610, -3.584339>,
				<-0.172130, -0.765621, -0.610985>, <-1.585408, -4.617178, -3.485656>,
				<-0.145812, -0.769801, -0.612586>, <-1.696376, -4.643401, -3.397665>
			}
			smooth_triangle {
				<-0.195488, -0.737021, -0.638510>, <-1.081923, -2.983225, -2.434402>,
				<-0.172130, -0.765621, -0.610985>, <-1.585408, -4.617178, -3.485656>,
				<-0.164942, -0.744841, -0.638060>, <-1.710822, -4.495610, -3.584339>
			}
			smooth_triangle {
				<-0.195488, -0.737021, -0.638510>, <-1.081923, -2.983225, -2.434402>,
				<-0.191587, -0.761071, -0.610884>, <-0.513825, -1.531012, -1.179245>,
				<-0.172130, -0.765621, -0.610985>, <-1.585408, -4.617178, -3.485656>
			}
			smooth_triangle {
				<-0.119734, -0.274901, -0.948266>, <-3.120635, -1.658159, -4.844345>,
				<-0.063545, -0.295091, -0.947623>, <-3.377001, -1.780711, -4.624147>,
				<-0.074250, -0.238991, -0.962543>, <-3.385746, -1.441576, -4.734568>
			}
			smooth_triangle {
				<0.003180, -0.561660, -0.820749>, <-3.179530, -3.384441, -3.797470>,
				<-0.034340, -0.573131, -0.812072>, <-2.990849, -3.458843, -3.882682>,
				<-0.012620, -0.594371, -0.797296>, <-3.032754, -3.582203, -3.735555>
			}
			smooth_triangle {
				<-0.198215, -0.396541, -0.890269>, <-1.324190, -1.198319, -2.409181>,
				<-0.151694, -0.367311, -0.911696>, <-2.839342, -2.218954, -4.792690>,
				<-0.196373, -0.340211, -0.913681>, <-1.356199, -1.023891, -2.470715>
			}
			smooth_triangle {
				<-0.197901, -0.451511, -0.863759>, <-1.272012, -1.366783, -2.346718>,
				<-0.149207, -0.425591, -0.886408>, <-2.750271, -2.566316, -4.669447>,
				<-0.198215, -0.396541, -0.890269>, <-1.324190, -1.198319, -2.409181>
			}
			smooth_triangle {
				<-0.150732, -0.482671, -0.856396>, <-2.626588, -2.912828, -4.535371>,
				<-0.149207, -0.425591, -0.886408>, <-2.750271, -2.566316, -4.669447>,
				<-0.197901, -0.451511, -0.863759>, <-1.272012, -1.366783, -2.346718>
			}
			smooth_triangle {
				<-0.150732, -0.482671, -0.856396>, <-2.626588, -2.912828, -4.535371>,
				<-0.100754, -0.456791, -0.877669>, <-2.925804, -2.757982, -4.448341>,
				<-0.149207, -0.425591, -0.886408>, <-2.750271, -2.566316, -4.669447>
			}
			smooth_triangle {
				<-0.096396, -0.519331, -0.842685>, <-3.754004, -4.160989, -5.702634>,
				<-0.100754, -0.456791, -0.877669>, <-2.925804, -2.757982, -4.448341>,
				<-0.150732, -0.482671, -0.856396>, <-2.626588, -2.912828, -4.535371>
			}
			smooth_triangle {
				<-0.096396, -0.519331, -0.842685>, <-3.754004, -4.160989, -5.702634>,
				<-0.053083, -0.478301, -0.870361>, <-3.119309, -2.890033, -4.228675>,
				<-0.100754, -0.456791, -0.877669>, <-2.925804, -2.757982, -4.448341>
			}
			smooth_triangle {
				<-0.039943, -0.519561, -0.847094>, <-3.095083, -3.120808, -4.080971>,
				<-0.096396, -0.519331, -0.842685>, <-3.754004, -4.160989, -5.702634>,
				<-0.058738, -0.550681, -0.826088>, <-2.928710, -3.312924, -4.053019>
			}
			smooth_triangle {
				<-0.039943, -0.519561, -0.847094>, <-3.095083, -3.120808, -4.080971>,
				<-0.053083, -0.478301, -0.870361>, <-3.119309, -2.890033, -4.228675>,
				<-0.096396, -0.519331, -0.842685>, <-3.754004, -4.160989, -5.702634>
			}
			smooth_triangle {
				<-0.039943, -0.519561, -0.847094>, <-3.095083, -3.120808, -4.080971>,
				<-0.026344, -0.547091, -0.830125>, <-2.581237, -2.749145, -3.281555>,
				<-0.001804, -0.529681, -0.841749>, <-3.253192, -3.189911, -3.901755>
			}
			smooth_triangle {
				<-0.058738, -0.550681, -0.826088>, <-2.928710, -3.312924, -4.053019>,
				<-0.026344, -0.547091, -0.830125>, <-2.581237, -2.749145, -3.281555>,
				<-0.039943, -0.519561, -0.847094>, <-3.095083, -3.120808, -4.080971>
			}
			smooth_triangle {
				<-0.026344, -0.547091, -0.830125>, <-2.581237, -2.749145, -3.281555>,
				<-0.058738, -0.550681, -0.826088>, <-2.928710, -3.312924, -4.053019>,
				<-0.034340, -0.573131, -0.812072>, <-2.990849, -3.458843, -3.882682>
			}
			smooth_triangle {
				<0.003180, -0.561660, -0.820749>, <-3.179530, -3.384441, -3.797470>,
				<-0.026344, -0.547091, -0.830125>, <-2.581237, -2.749145, -3.281555>,
				<-0.034340, -0.573131, -0.812072>, <-2.990849, -3.458843, -3.882682>
			}
			smooth_triangle {
				<0.003180, -0.561660, -0.820749>, <-3.179530, -3.384441, -3.797470>,
				<-0.001804, -0.529681, -0.841749>, <-3.253192, -3.189911, -3.901755>,
				<-0.026344, -0.547091, -0.830125>, <-2.581237, -2.749145, -3.281555>
			}
			smooth_triangle {
				<-0.002586, -0.490751, -0.865021>, <-3.893501, -3.445596, -4.683206>,
				<-0.039943, -0.519561, -0.847094>, <-3.095083, -3.120808, -4.080971>,
				<-0.001804, -0.529681, -0.841749>, <-3.253192, -3.189911, -3.901755>
			}
			smooth_triangle {
				<-0.002586, -0.490751, -0.865021>, <-3.893501, -3.445596, -4.683206>,
				<-0.053083, -0.478301, -0.870361>, <-3.119309, -2.890033, -4.228675>,
				<-0.039943, -0.519561, -0.847094>, <-3.095083, -3.120808, -4.080971>
			}
			smooth_triangle {
				<-0.017834, -0.445451, -0.889026>, <-3.364902, -2.688900, -4.173387>,
				<-0.053083, -0.478301, -0.870361>, <-3.119309, -2.890033, -4.228675>,
				<-0.002586, -0.490751, -0.865021>, <-3.893501, -3.445596, -4.683206>
			}
			smooth_triangle {
				<-0.149207, -0.425591, -0.886408>, <-2.750271, -2.566316, -4.669447>,
				<-0.151694, -0.367311, -0.911696>, <-2.839342, -2.218954, -4.792690>,
				<-0.198215, -0.396541, -0.890269>, <-1.324190, -1.198319, -2.409181>
			}
			smooth_triangle {
				<-0.093685, -0.396101, -0.907437>, <-3.591532, -2.781830, -5.319635>,
				<-0.059972, -0.435771, -0.891981>, <-2.644816, -2.187005, -3.633044>,
				<-0.034131, -0.400831, -0.909552>, <-3.366487, -2.410109, -4.338538>
			}
			smooth_triangle {
				<-0.151694, -0.367311, -0.911696>, <-2.839342, -2.218954, -4.792690>,
				<-0.149207, -0.425591, -0.886408>, <-2.750271, -2.566316, -4.669447>,
				<-0.093685, -0.396101, -0.907437>, <-3.591532, -2.781830, -5.319635>
			}
			smooth_triangle {
				<-0.100754, -0.456791, -0.877669>, <-2.925804, -2.757982, -4.448341>,
				<-0.093685, -0.396101, -0.907437>, <-3.591532, -2.781830, -5.319635>,
				<-0.149207, -0.425591, -0.886408>, <-2.750271, -2.566316, -4.669447>
			}
			smooth_triangle {
				<-0.100754, -0.456791, -0.877669>, <-2.925804, -2.757982, -4.448341>,
				<-0.059972, -0.435771, -0.891981>, <-2.644816, -2.187005, -3.633044>,
				<-0.093685, -0.396101, -0.907437>, <-3.591532, -2.781830, -5.319635>
			}
			smooth_triangle {
				<-0.053083, -0.478301, -0.870361>, <-3.119309, -2.890033, -4.228675>,
				<-0.059972, -0.435771, -0.891981>, <-2.644816, -2.187005, -3.633044>,
				<-0.100754, -0.456791, -0.877669>, <-2.925804, -2.757982, -4.448341>
			}
			smooth_triangle {
				<-0.059972, -0.435771, -0.891981>, <-2.644816, -2.187005, -3.633044>,
				<-0.017834, -0.445451, -0.889026>, <-3.364902, -2.688900, -4.173387>,
				<-0.034131, -0.400831, -0.909552>, <-3.366487, -2.410109, -4.338538>
			}
			smooth_triangle {
				<-0.053083, -0.478301, -0.870361>, <-3.119309, -2.890033, -4.228675>,
				<-0.017834, -0.445451, -0.889026>, <-3.364902, -2.688900, -4.173387>,
				<-0.059972, -0.435771, -0.891981>, <-2.644816, -2.187005, -3.633044>
			}
			smooth_triangle {
				<-0.050923, -0.350601, -0.929299>, <-3.360355, -2.114948, -4.493554>,
				<-0.093685, -0.396101, -0.907437>, <-3.591532, -2.781830, -5.319635>,
				<-0.034131, -0.400831, -0.909552>, <-3.366487, -2.410109, -4.338538>
			}
			smooth_triangle {
				<-0.151694, -0.367311, -0.911696>, <-2.839342, -2.218954, -4.792690>,
				<-0.163593, -0.310451, -0.930574>, <-2.854161, -1.866109, -4.932330>,
				<-0.196373, -0.340211, -0.913681>, <-1.356199, -1.023891, -2.470715>
			}
			smooth_triangle {
				<-0.151694, -0.367311, -0.911696>, <-2.839342, -2.218954, -4.792690>,
				<-0.107391, -0.332741, -0.931052>, <-3.111872, -2.010679, -4.714567>,
				<-0.163593, -0.310451, -0.930574>, <-2.854161, -1.866109, -4.932330>
			}
			smooth_triangle {
				<-0.107391, -0.332741, -0.931052>, <-3.111872, -2.010679, -4.714567>,
				<-0.093685, -0.396101, -0.907437>, <-3.591532, -2.781830, -5.319635>,
				<-0.050923, -0.350601, -0.929299>, <-3.360355, -2.114948, -4.493554>
			}
			smooth_triangle {
				<-0.107391, -0.332741, -0.931052>, <-3.111872, -2.010679, -4.714567>,
				<-0.151694, -0.367311, -0.911696>, <-2.839342, -2.218954, -4.792690>,
				<-0.093685, -0.396101, -0.907437>, <-3.591532, -2.781830, -5.319635>
			}
			smooth_triangle {
				<-0.063545, -0.295091, -0.947623>, <-3.377001, -1.780711, -4.624147>,
				<-0.107391, -0.332741, -0.931052>, <-3.111872, -2.010679, -4.714567>,
				<-0.050923, -0.350601, -0.929299>, <-3.360355, -2.114948, -4.493554>
			}
			smooth_triangle {
				<-0.107391, -0.332741, -0.931052>, <-3.111872, -2.010679, -4.714567>,
				<-0.119734, -0.274901, -0.948266>, <-3.120635, -1.658159, -4.844345>,
				<-0.163593, -0.310451, -0.930574>, <-2.854161, -1.866109, -4.932330>
			}
			smooth_triangle {
				<-0.063545, -0.295091, -0.947623>, <-3.377001, -1.780711, -4.624147>,
				<-0.119734, -0.274901, -0.948266>, <-3.120635, -1.658159, -4.844345>,
				<-0.107391, -0.332741, -0.931052>, <-3.111872, -2.010679, -4.714567>
			}
			smooth_triangle {
				<-0.202656, -0.504251, -0.832929>, <-1.206605, -1.525484, -2.282846>,
				<-0.150732, -0.482671, -0.856396>, <-2.626588, -2.912828, -4.535371>,
				<-0.197901, -0.451511, -0.863759>, <-1.272012, -1.366783, -2.346718>
			}
			smooth_triangle {
				<-0.155427, -0.535541, -0.823502>, <-2.478727, -3.224329, -4.406621>,
				<-0.150732, -0.482671, -0.856396>, <-2.626588, -2.912828, -4.535371>,
				<-0.202656, -0.504251, -0.832929>, <-1.206605, -1.525484, -2.282846>
			}
			smooth_triangle {
				<-0.155427, -0.535541, -0.823502>, <-2.478727, -3.224329, -4.406621>,
				<-0.096396, -0.519331, -0.842685>, <-3.754004, -4.160989, -5.702634>,
				<-0.150732, -0.482671, -0.856396>, <-2.626588, -2.912828, -4.535371>
			}
			smooth_triangle {
				<-0.121592, -0.565141, -0.809285>, <-2.568750, -3.393250, -4.226089>,
				<-0.096396, -0.519331, -0.842685>, <-3.754004, -4.160989, -5.702634>,
				<-0.155427, -0.535541, -0.823502>, <-2.478727, -3.224329, -4.406621>
			}
			smooth_triangle {
				<-0.066808, -0.581881, -0.803782>, <-2.808020, -3.510985, -3.971455>,
				<-0.034340, -0.573131, -0.812072>, <-2.990849, -3.458843, -3.882682>,
				<-0.058738, -0.550681, -0.826088>, <-2.928710, -3.312924, -4.053019>
			}
			smooth_triangle {
				<-0.044309, -0.601951, -0.790443>, <-2.860798, -3.628885, -3.825284>,
				<-0.076039, -0.612451, -0.779888>, <-2.666537, -3.699461, -3.896731>,
				<-0.052816, -0.624971, -0.771830>, <-1.804486, -2.510449, -2.536636>
			}
			smooth_triangle {
				<-0.044309, -0.601951, -0.790443>, <-2.860798, -3.628885, -3.825284>,
				<-0.066808, -0.581881, -0.803782>, <-2.808020, -3.510985, -3.971455>,
				<-0.076039, -0.612451, -0.779888>, <-2.666537, -3.699461, -3.896731>
			}
			smooth_triangle {
				<-0.044309, -0.601951, -0.790443>, <-2.860798, -3.628885, -3.825284>,
				<-0.034340, -0.573131, -0.812072>, <-2.990849, -3.458843, -3.882682>,
				<-0.066808, -0.581881, -0.803782>, <-2.808020, -3.510985, -3.971455>
			}
			smooth_triangle {
				<-0.022840, -0.623781, -0.774269>, <-1.460660, -1.843834, -1.861600>,
				<-0.044309, -0.601951, -0.790443>, <-2.860798, -3.628885, -3.825284>,
				<-0.052816, -0.624971, -0.771830>, <-1.804486, -2.510449, -2.536636>
			}
			smooth_triangle {
				<-0.044309, -0.601951, -0.790443>, <-2.860798, -3.628885, -3.825284>,
				<-0.012620, -0.594371, -0.797296>, <-3.032754, -3.582203, -3.735555>,
				<-0.034340, -0.573131, -0.812072>, <-2.990849, -3.458843, -3.882682>
			}
			smooth_triangle {
				<-0.022840, -0.623781, -0.774269>, <-1.460660, -1.843834, -1.861600>,
				<-0.012620, -0.594371, -0.797296>, <-3.032754, -3.582203, -3.735555>,
				<-0.044309, -0.601951, -0.790443>, <-2.860798, -3.628885, -3.825284>
			}
			smooth_triangle {
				<-0.066808, -0.581881, -0.803782>, <-2.808020, -3.510985, -3.971455>,
				<-0.098291, -0.590121, -0.794491>, <-2.625148, -3.561253, -4.050895>,
				<-0.076039, -0.612451, -0.779888>, <-2.666537, -3.699461, -3.896731>
			}
			smooth_triangle {
				<-0.088477, -0.561681, -0.815963>, <-2.292371, -2.813728, -3.437062>,
				<-0.066808, -0.581881, -0.803782>, <-2.808020, -3.510985, -3.971455>,
				<-0.058738, -0.550681, -0.826088>, <-2.928710, -3.312924, -4.053019>
			}
			smooth_triangle {
				<-0.088477, -0.561681, -0.815963>, <-2.292371, -2.813728, -3.437062>,
				<-0.098291, -0.590121, -0.794491>, <-2.625148, -3.561253, -4.050895>,
				<-0.066808, -0.581881, -0.803782>, <-2.808020, -3.510985, -3.971455>
			}
			smooth_triangle {
				<-0.088477, -0.561681, -0.815963>, <-2.292371, -2.813728, -3.437062>,
				<-0.121592, -0.565141, -0.809285>, <-2.568750, -3.393250, -4.226089>,
				<-0.098291, -0.590121, -0.794491>, <-2.625148, -3.561253, -4.050895>
			}
			smooth_triangle {
				<-0.096396, -0.519331, -0.842685>, <-3.754004, -4.160989, -5.702634>,
				<-0.088477, -0.561681, -0.815963>, <-2.292371, -2.813728, -3.437062>,
				<-0.058738, -0.550681, -0.826088>, <-2.928710, -3.312924, -4.053019>
			}
			smooth_triangle {
				<-0.096396, -0.519331, -0.842685>, <-3.754004, -4.160989, -5.702634>,
				<-0.121592, -0.565141, -0.809285>, <-2.568750, -3.393250, -4.226089>,
				<-0.088477, -0.561681, -0.815963>, <-2.292371, -2.813728, -3.437062>
			}
			smooth_triangle {
				<-0.012620, -0.594371, -0.797296>, <-3.032754, -3.582203, -3.735555>,
				<0.017717, -0.589190, -0.801030>, <-1.038290, -1.186067, -1.230645>,
				<0.003180, -0.561660, -0.820749>, <-3.179530, -3.384441, -3.797470>
			}
			smooth_triangle {
				<-0.012620, -0.594371, -0.797296>, <-3.032754, -3.582203, -3.735555>,
				<0.005273, -0.615141, -0.781463>, <-1.013461, -1.217050, -1.221142>,
				<0.017717, -0.589190, -0.801030>, <-1.038290, -1.186067, -1.230645>
			}
			smooth_triangle {
				<-0.012620, -0.594371, -0.797296>, <-3.032754, -3.582203, -3.735555>,
				<-0.022840, -0.623781, -0.774269>, <-1.460660, -1.843834, -1.861600>,
				<0.005273, -0.615141, -0.781463>, <-1.013461, -1.217050, -1.221142>
			}
			smooth_triangle {
				<-0.113556, -0.713521, -0.683450>, <-1.400059, -2.876412, -2.400461>,
				<-0.124218, -0.698401, -0.697074>, <-2.127660, -4.208342, -3.708191>,
				<-0.133305, -0.719671, -0.673366>, <-1.985515, -4.341755, -3.632299>
			}
			smooth_triangle {
				<-0.133305, -0.719671, -0.673366>, <-1.985515, -4.341755, -3.632299>,
				<-0.113652, -0.735001, -0.660276>, <-2.024949, -4.435408, -3.495135>,
				<-0.113556, -0.713521, -0.683450>, <-1.400059, -2.876412, -2.400461>
			}
			smooth_triangle {
				<-0.119332, -0.774821, -0.611988>, <-0.897041, -2.314526, -1.684199>,
				<-0.134859, -0.747041, -0.642533>, <-2.173933, -5.258307, -4.074621>,
				<-0.145812, -0.769801, -0.612586>, <-1.696376, -4.643401, -3.397665>
			}
			smooth_triangle {
				<-0.108349, -0.758831, -0.633670>, <-0.965906, -2.267954, -1.709305>,
				<-0.134859, -0.747041, -0.642533>, <-2.173933, -5.258307, -4.074621>,
				<-0.119332, -0.774821, -0.611988>, <-0.897041, -2.314526, -1.684199>
			}
			smooth_triangle {
				<-0.108349, -0.758831, -0.633670>, <-0.965906, -2.267954, -1.709305>,
				<-0.113652, -0.735001, -0.660276>, <-2.024949, -4.435408, -3.495135>,
				<-0.134859, -0.747041, -0.642533>, <-2.173933, -5.258307, -4.074621>
			}
			smooth_triangle {
				<-0.113652, -0.735001, -0.660276>, <-2.024949, -4.435408, -3.495135>,
				<-0.133305, -0.719671, -0.673366>, <-1.985515, -4.341755, -3.632299>,
				<-0.134859, -0.747041, -0.642533>, <-2.173933, -5.258307, -4.074621>
			}
			smooth_triangle {
				<-0.093724, -0.704031, -0.696188>, <-1.117506, -2.097808, -1.830214>,
				<-0.124218, -0.698401, -0.697074>, <-2.127660, -4.208342, -3.708191>,
				<-0.113556, -0.713521, -0.683450>, <-1.400059, -2.876412, -2.400461>
			}
			smooth_triangle {
				<-0.124218, -0.698401, -0.697074>, <-2.127660, -4.208342, -3.708191>,
				<-0.093724, -0.704031, -0.696188>, <-1.117506, -2.097808, -1.830214>,
				<-0.109142, -0.677571, -0.719789>, <-2.286301, -4.083768, -3.752290>
			}
			smooth_triangle {
				<-0.093724, -0.704031, -0.696188>, <-1.117506, -2.097808, -1.830214>,
				<-0.087741, -0.682131, -0.718414>, <-1.179461, -2.034470, -1.862071>,
				<-0.109142, -0.677571, -0.719789>, <-2.286301, -4.083768, -3.752290>
			}
			smooth_triangle {
				<-0.087741, -0.682131, -0.718414>, <-1.179461, -2.034470, -1.862071>,
				<-0.083860, -0.652921, -0.745494>, <-2.900151, -4.560603, -4.445644>,
				<-0.109142, -0.677571, -0.719789>, <-2.286301, -4.083768, -3.752290>
			}
			smooth_triangle {
				<-0.087741, -0.682131, -0.718414>, <-1.179461, -2.034470, -1.862071>,
				<-0.073105, -0.669691, -0.731635>, <-0.399940, -0.669877, -0.625550>,
				<-0.083860, -0.652921, -0.745494>, <-2.900151, -4.560603, -4.445644>
			}
			smooth_triangle {
				<-0.113652, -0.735001, -0.660276>, <-2.024949, -4.435408, -3.495135>,
				<-0.095589, -0.726811, -0.672104>, <-0.699094, -1.467264, -1.165373>,
				<-0.113556, -0.713521, -0.683450>, <-1.400059, -2.876412, -2.400461>
			}
			smooth_triangle {
				<-0.113652, -0.735001, -0.660276>, <-2.024949, -4.435408, -3.495135>,
				<-0.095617, -0.742901, -0.654262>, <-0.682862, -1.489930, -1.145987>,
				<-0.095589, -0.726811, -0.672104>, <-0.699094, -1.467264, -1.165373>
			}
			smooth_triangle {
				<-0.113652, -0.735001, -0.660276>, <-2.024949, -4.435408, -3.495135>,
				<-0.108349, -0.758831, -0.633670>, <-0.965906, -2.267954, -1.709305>,
				<-0.095617, -0.742901, -0.654262>, <-0.682862, -1.489930, -1.145987>
			}
			smooth_triangle {
				<0.098795, -0.110770, -0.983406>, <-4.267381, -0.668973, -4.160772>,
				<0.144391, -0.128320, -0.975598>, <-4.447842, -0.774217, -3.948300>,
				<0.138437, -0.081880, -0.981450>, <-4.443465, -0.494797, -3.997838>
			}
			smooth_triangle {
				<0.095244, -0.393490, -0.908406>, <-3.959531, -2.370977, -3.830756>,
				<0.051463, -0.378420, -0.918298>, <-3.795754, -2.279354, -4.045442>,
				<0.060349, -0.422640, -0.898249>, <-3.759068, -2.547153, -3.918501>
			}
			smooth_triangle {
				<0.058094, -0.140650, -0.982828>, <-4.076399, -0.850404, -4.315995>,
				<0.105455, -0.158640, -0.976123>, <-4.269224, -0.957910, -4.101961>,
				<0.098795, -0.110770, -0.983406>, <-4.267381, -0.668973, -4.160772>
			}
			smooth_triangle {
				<0.065520, -0.190500, -0.973916>, <-4.075670, -1.150422, -4.246468>,
				<0.113767, -0.206290, -0.966232>, <-4.268580, -1.244293, -4.025049>,
				<0.105455, -0.158640, -0.976123>, <-4.269224, -0.957910, -4.101961>
			}
			smooth_triangle {
				<0.091133, -0.348170, -0.927135>, <-4.012236, -2.094870, -3.934760>,
				<0.043819, -0.329410, -0.937379>, <-3.836360, -1.982320, -4.161202>,
				<0.051463, -0.378420, -0.918298>, <-3.795754, -2.279354, -4.045442>
			}
			smooth_triangle {
				<0.034512, -0.276980, -0.954568>, <-3.859380, -1.672162, -4.274312>,
				<0.075702, -0.240900, -0.961953>, <-4.074909, -1.456919, -4.151730>,
				<0.023900, -0.224060, -0.968678>, <-3.863079, -1.352750, -4.382875>
			}
			smooth_triangle {
				<0.091480, -0.294430, -0.945546>, <-4.759968, -2.072048, -4.690568>,
				<0.034512, -0.276980, -0.954568>, <-3.859380, -1.672162, -4.274312>,
				<0.043819, -0.329410, -0.937379>, <-3.836360, -1.982320, -4.161202>
			}
			smooth_triangle {
				<0.034512, -0.276980, -0.954568>, <-3.859380, -1.672162, -4.274312>,
				<0.091480, -0.294430, -0.945546>, <-4.759968, -2.072048, -4.690568>,
				<0.075702, -0.240900, -0.961953>, <-4.074909, -1.456919, -4.151730>
			}
			smooth_triangle {
				<0.091480, -0.294430, -0.945546>, <-4.759968, -2.072048, -4.690568>,
				<0.124310, -0.252080, -0.953995>, <-4.266995, -1.517205, -3.932282>,
				<0.075702, -0.240900, -0.961953>, <-4.074909, -1.456919, -4.151730>
			}
			smooth_triangle {
				<0.091480, -0.294430, -0.945546>, <-4.759968, -2.072048, -4.690568>,
				<0.137510, -0.287420, -0.942122>, <-3.568792, -1.445125, -3.187341>,
				<0.124310, -0.252080, -0.953995>, <-4.266995, -1.517205, -3.932282>
			}
			smooth_triangle {
				<0.091133, -0.348170, -0.927135>, <-4.012236, -2.094870, -3.934760>,
				<0.091480, -0.294430, -0.945546>, <-4.759968, -2.072048, -4.690568>,
				<0.043819, -0.329410, -0.937379>, <-3.836360, -1.982320, -4.161202>
			}
			smooth_triangle {
				<0.091480, -0.294430, -0.945546>, <-4.759968, -2.072048, -4.690568>,
				<0.132380, -0.324400, -0.930781>, <-4.214204, -1.959606, -3.791346>,
				<0.137510, -0.287420, -0.942122>, <-3.568792, -1.445125, -3.187341>
			}
			smooth_triangle {
				<0.091133, -0.348170, -0.927135>, <-4.012236, -2.094870, -3.934760>,
				<0.132380, -0.324400, -0.930781>, <-4.214204, -1.959606, -3.791346>,
				<0.091480, -0.294430, -0.945546>, <-4.759968, -2.072048, -4.690568>
			}
			smooth_triangle {
				<0.113767, -0.206290, -0.966232>, <-4.268580, -1.244293, -4.025049>,
				<0.075702, -0.240900, -0.961953>, <-4.074909, -1.456919, -4.151730>,
				<0.124310, -0.252080, -0.953995>, <-4.266995, -1.517205, -3.932282>
			}
			smooth_triangle {
				<0.075702, -0.240900, -0.961953>, <-4.074909, -1.456919, -4.151730>,
				<0.065520, -0.190500, -0.973916>, <-4.075670, -1.150422, -4.246468>,
				<0.023900, -0.224060, -0.968678>, <-3.863079, -1.352750, -4.382875>
			}
			smooth_triangle {
				<0.113767, -0.206290, -0.966232>, <-4.268580, -1.244293, -4.025049>,
				<0.065520, -0.190500, -0.973916>, <-4.075670, -1.150422, -4.246468>,
				<0.075702, -0.240900, -0.961953>, <-4.074909, -1.456919, -4.151730>
			}
			smooth_triangle {
				<0.095244, -0.393490, -0.908406>, <-3.959531, -2.370977, -3.830756>,
				<0.091133, -0.348170, -0.927135>, <-4.012236, -2.094870, -3.934760>,
				<0.051463, -0.378420, -0.918298>, <-3.795754, -2.279354, -4.045442>
			}
			smooth_triangle {
				<0.091133, -0.348170, -0.927135>, <-4.012236, -2.094870, -3.934760>,
				<0.131651, -0.367460, -0.914739>, <-4.151992, -2.214405, -3.719309>,
				<0.132380, -0.324400, -0.930781>, <-4.214204, -1.959606, -3.791346>
			}
			smooth_triangle {
				<0.095244, -0.393490, -0.908406>, <-3.959531, -2.370977, -3.830756>,
				<0.131651, -0.367460, -0.914739>, <-4.151992, -2.214405, -3.719309>,
				<0.091133, -0.348170, -0.927135>, <-4.012236, -2.094870, -3.934760>
			}
			smooth_triangle {
				<0.058094, -0.140650, -0.982828>, <-4.076399, -0.850404, -4.315995>,
				<0.065520, -0.190500, -0.973916>, <-4.075670, -1.150422, -4.246468>,
				<0.105455, -0.158640, -0.976123>, <-4.269224, -0.957910, -4.101961>
			}
			smooth_triangle {
				<0.065520, -0.190500, -0.973916>, <-4.075670, -1.150422, -4.246468>,
				<0.015617, -0.171670, -0.979482>, <-3.866425, -1.037371, -4.465354>,
				<0.023900, -0.224060, -0.968678>, <-3.863079, -1.352750, -4.382875>
			}
			smooth_triangle {
				<0.058094, -0.140650, -0.982828>, <-4.076399, -0.850404, -4.315995>,
				<0.015617, -0.171670, -0.979482>, <-3.866425, -1.037371, -4.465354>,
				<0.065520, -0.190500, -0.973916>, <-4.075670, -1.150422, -4.246468>
			}
			smooth_triangle {
				<0.169946, -0.344760, -0.917266>, <-4.342627, -2.076753, -3.578270>,
				<0.132380, -0.324400, -0.930781>, <-4.214204, -1.959606, -3.791346>,
				<0.131651, -0.367460, -0.914739>, <-4.151992, -2.214405, -3.719309>
			}
			smooth_triangle {
				<0.105455, -0.158640, -0.976123>, <-4.269224, -0.957910, -4.101961>,
				<0.144391, -0.128320, -0.975598>, <-4.447842, -0.774217, -3.948300>,
				<0.098795, -0.110770, -0.983406>, <-4.267381, -0.668973, -4.160772>
			}
			smooth_triangle {
				<0.105455, -0.158640, -0.976123>, <-4.269224, -0.957910, -4.101961>,
				<0.151347, -0.174720, -0.967309>, <-4.447345, -1.053903, -3.883547>,
				<0.144391, -0.128320, -0.975598>, <-4.447842, -0.774217, -3.948300>
			}
			smooth_triangle {
				<0.171522, -0.303140, -0.931552>, <-4.406523, -1.832101, -3.633547>,
				<0.132380, -0.324400, -0.930781>, <-4.214204, -1.959606, -3.791346>,
				<0.169946, -0.344760, -0.917266>, <-4.342627, -2.076753, -3.578270>
			}
			smooth_triangle {
				<0.171522, -0.303140, -0.931552>, <-4.406523, -1.832101, -3.633547>,
				<0.137510, -0.287420, -0.942122>, <-3.568792, -1.445125, -3.187341>,
				<0.132380, -0.324400, -0.930781>, <-4.214204, -1.959606, -3.791346>
			}
			smooth_triangle {
				<0.113767, -0.206290, -0.966232>, <-4.268580, -1.244293, -4.025049>,
				<0.151347, -0.174720, -0.967309>, <-4.447345, -1.053903, -3.883547>,
				<0.105455, -0.158640, -0.976123>, <-4.269224, -0.957910, -4.101961>
			}
			smooth_triangle {
				<0.113767, -0.206290, -0.966232>, <-4.268580, -1.244293, -4.025049>,
				<0.159299, -0.220070, -0.956712>, <-4.443634, -1.325925, -3.803858>,
				<0.151347, -0.174720, -0.967309>, <-4.447345, -1.053903, -3.883547>
			}
			smooth_triangle {
				<0.167268, -0.262480, -0.944587>, <-4.436828, -1.579053, -3.714517>,
				<0.137510, -0.287420, -0.942122>, <-3.568792, -1.445125, -3.187341>,
				<0.171522, -0.303140, -0.931552>, <-4.406523, -1.832101, -3.633547>
			}
			smooth_triangle {
				<0.167268, -0.262480, -0.944587>, <-4.436828, -1.579053, -3.714517>,
				<0.124310, -0.252080, -0.953995>, <-4.266995, -1.517205, -3.932282>,
				<0.137510, -0.287420, -0.942122>, <-3.568792, -1.445125, -3.187341>
			}
			smooth_triangle {
				<0.124310, -0.252080, -0.953995>, <-4.266995, -1.517205, -3.932282>,
				<0.159299, -0.220070, -0.956712>, <-4.443634, -1.325925, -3.803858>,
				<0.113767, -0.206290, -0.966232>, <-4.268580, -1.244293, -4.025049>
			}
			smooth_triangle {
				<0.167268, -0.262480, -0.944587>, <-4.436828, -1.579053, -3.714517>,
				<0.159299, -0.220070, -0.956712>, <-4.443634, -1.325925, -3.803858>,
				<0.124310, -0.252080, -0.953995>, <-4.266995, -1.517205, -3.932282>
			}
			smooth_triangle {
				<0.102149, -0.434860, -0.888587>, <-3.917044, -2.621925, -3.709144>,
				<0.095244, -0.393490, -0.908406>, <-3.959531, -2.370977, -3.830756>,
				<0.060349, -0.422640, -0.898249>, <-3.759068, -2.547153, -3.918501>
			}
			smooth_triangle {
				<0.131651, -0.367460, -0.914739>, <-4.151992, -2.214405, -3.719309>,
				<0.166352, -0.384720, -0.901901>, <-4.265575, -2.315547, -3.524726>,
				<0.169946, -0.344760, -0.917266>, <-4.342627, -2.076753, -3.578270>
			}
			smooth_triangle {
				<0.134053, -0.408080, -0.897004>, <-4.090830, -2.462475, -3.630356>,
				<0.095244, -0.393490, -0.908406>, <-3.959531, -2.370977, -3.830756>,
				<0.102149, -0.434860, -0.888587>, <-3.917044, -2.621925, -3.709144>
			}
			smooth_triangle {
				<0.134053, -0.408080, -0.897004>, <-4.090830, -2.462475, -3.630356>,
				<0.131651, -0.367460, -0.914739>, <-4.151992, -2.214405, -3.719309>,
				<0.095244, -0.393490, -0.908406>, <-3.959531, -2.370977, -3.830756>
			}
			smooth_triangle {
				<0.134053, -0.408080, -0.897004>, <-4.090830, -2.462475, -3.630356>,
				<0.166352, -0.384720, -0.901901>, <-4.265575, -2.315547, -3.524726>,
				<0.131651, -0.367460, -0.914739>, <-4.151992, -2.214405, -3.719309>
			}
			smooth_triangle {
				<0.145377, -0.448810, -0.875528>, <-2.674853, -1.783712, -2.378785>,
				<0.134053, -0.408080, -0.897004>, <-4.090830, -2.462475, -3.630356>,
				<0.102149, -0.434860, -0.888587>, <-3.917044, -2.621925, -3.709144>
			}
			smooth_triangle {
				<0.134053, -0.408080, -0.897004>, <-4.090830, -2.462475, -3.630356>,
				<0.162714, -0.417960, -0.887661>, <-2.092339, -1.237617, -1.756993>,
				<0.166352, -0.384720, -0.901901>, <-4.265575, -2.315547, -3.524726>
			}
			smooth_triangle {
				<0.145377, -0.448810, -0.875528>, <-2.674853, -1.783712, -2.378785>,
				<0.162714, -0.417960, -0.887661>, <-2.092339, -1.237617, -1.756993>,
				<0.134053, -0.408080, -0.897004>, <-4.090830, -2.462475, -3.630356>
			}
			smooth_triangle {
				<0.112476, -0.508370, -0.847360>, <-1.893904, -1.502573, -1.775765>,
				<0.078808, -0.498050, -0.857240>, <-3.688486, -3.001513, -3.656133>,
				<0.086006, -0.530560, -0.836792>, <-1.811820, -1.576122, -1.797358>
			}
			smooth_triangle {
				<0.069842, -0.462360, -0.877757>, <-3.724590, -2.785832, -3.787394>,
				<0.102149, -0.434860, -0.888587>, <-3.917044, -2.621925, -3.709144>,
				<0.060349, -0.422640, -0.898249>, <-3.759068, -2.547153, -3.918501>
			}
			smooth_triangle {
				<0.107261, -0.472460, -0.868556>, <-3.862819, -2.844830, -3.600745>,
				<0.102149, -0.434860, -0.888587>, <-3.917044, -2.621925, -3.709144>,
				<0.069842, -0.462360, -0.877757>, <-3.724590, -2.785832, -3.787394>
			}
			smooth_triangle {
				<0.107261, -0.472460, -0.868556>, <-3.862819, -2.844830, -3.600745>,
				<0.145377, -0.448810, -0.875528>, <-2.674853, -1.783712, -2.378785>,
				<0.102149, -0.434860, -0.888587>, <-3.917044, -2.621925, -3.709144>
			}
			smooth_triangle {
				<0.107261, -0.472460, -0.868556>, <-3.862819, -2.844830, -3.600745>,
				<0.134537, -0.481000, -0.860023>, <-1.304499, -0.957519, -1.174887>,
				<0.145377, -0.448810, -0.875528>, <-2.674853, -1.783712, -2.378785>
			}
			smooth_triangle {
				<0.078808, -0.498050, -0.857240>, <-3.688486, -3.001513, -3.656133>,
				<0.107261, -0.472460, -0.868556>, <-3.862819, -2.844830, -3.600745>,
				<0.069842, -0.462360, -0.877757>, <-3.724590, -2.785832, -3.787394>
			}
			smooth_triangle {
				<0.107261, -0.472460, -0.868556>, <-3.862819, -2.844830, -3.600745>,
				<0.112476, -0.508370, -0.847360>, <-1.893904, -1.502573, -1.775765>,
				<0.134537, -0.481000, -0.860023>, <-1.304499, -0.957519, -1.174887>
			}
			smooth_triangle {
				<0.078808, -0.498050, -0.857240>, <-3.688486, -3.001513, -3.656133>,
				<0.112476, -0.508370, -0.847360>, <-1.893904, -1.502573, -1.775765>,
				<0.107261, -0.472460, -0.868556>, <-3.862819, -2.844830, -3.600745>
			}
			smooth_triangle {
				<-0.028803, -0.204321, -0.972898>, <-3.635617, -1.232780, -4.606865>,
				<0.023900, -0.224060, -0.968678>, <-3.863079, -1.352750, -4.382875>,
				<0.015617, -0.171670, -0.979482>, <-3.866425, -1.037371, -4.465354>
			}
			smooth_triangle {
				<0.015088, -0.411200, -0.905424>, <-3.577795, -2.477963, -4.126585>,
				<0.060349, -0.422640, -0.898249>, <-3.759068, -2.547153, -3.918501>,
				<0.051463, -0.378420, -0.918298>, <-3.795754, -2.279354, -4.045442>
			}
			smooth_triangle {
				<0.042227, -0.490750, -0.863996>, <-3.544833, -2.953114, -3.833150>,
				<0.078808, -0.498050, -0.857240>, <-3.688486, -3.001513, -3.656133>,
				<0.069842, -0.462360, -0.877757>, <-3.724590, -2.785832, -3.787394>
			}
			smooth_triangle {
				<0.030152, -0.542400, -0.833069>, <-3.370651, -3.271694, -3.730921>,
				<-0.001804, -0.529681, -0.841749>, <-3.253192, -3.189911, -3.901755>,
				<0.003180, -0.561660, -0.820749>, <-3.179530, -3.384441, -3.797470>
			}
			smooth_triangle {
				<0.030152, -0.542400, -0.833069>, <-3.370651, -3.271694, -3.730921>,
				<0.024569, -0.515390, -0.850224>, <-2.840304, -2.586593, -3.198598>,
				<-0.001804, -0.529681, -0.841749>, <-3.253192, -3.189911, -3.901755>
			}
			smooth_triangle {
				<0.042227, -0.490750, -0.863996>, <-3.544833, -2.953114, -3.833150>,
				<0.054575, -0.522590, -0.844411>, <-3.527410, -3.153544, -3.687299>,
				<0.078808, -0.498050, -0.857240>, <-3.688486, -3.001513, -3.656133>
			}
			smooth_triangle {
				<0.054575, -0.522590, -0.844411>, <-3.527410, -3.153544, -3.687299>,
				<0.024569, -0.515390, -0.850224>, <-2.840304, -2.586593, -3.198598>,
				<0.030152, -0.542400, -0.833069>, <-3.370651, -3.271694, -3.730921>
			}
			smooth_triangle {
				<0.054575, -0.522590, -0.844411>, <-3.527410, -3.153544, -3.687299>,
				<0.042227, -0.490750, -0.863996>, <-3.544833, -2.953114, -3.833150>,
				<0.024569, -0.515390, -0.850224>, <-2.840304, -2.586593, -3.198598>
			}
			smooth_triangle {
				<0.034968, -0.566910, -0.816393>, <-1.117776, -1.115240, -1.227260>,
				<0.030152, -0.542400, -0.833069>, <-3.370651, -3.271694, -3.730921>,
				<0.003180, -0.561660, -0.820749>, <-3.179530, -3.384441, -3.797470>
			}
			smooth_triangle {
				<0.054575, -0.522590, -0.844411>, <-3.527410, -3.153544, -3.687299>,
				<0.086006, -0.530560, -0.836792>, <-1.811820, -1.576122, -1.797358>,
				<0.078808, -0.498050, -0.857240>, <-3.688486, -3.001513, -3.656133>
			}
			smooth_triangle {
				<0.054575, -0.522590, -0.844411>, <-3.527410, -3.153544, -3.687299>,
				<0.065164, -0.557220, -0.821197>, <-1.736784, -1.642101, -1.812750>,
				<0.086006, -0.530560, -0.836792>, <-1.811820, -1.576122, -1.797358>
			}
			smooth_triangle {
				<0.030152, -0.542400, -0.833069>, <-3.370651, -3.271694, -3.730921>,
				<0.065164, -0.557220, -0.821197>, <-1.736784, -1.642101, -1.812750>,
				<0.054575, -0.522590, -0.844411>, <-3.527410, -3.153544, -3.687299>
			}
			smooth_triangle {
				<0.034968, -0.566910, -0.816393>, <-1.117776, -1.115240, -1.227260>,
				<0.065164, -0.557220, -0.821197>, <-1.736784, -1.642101, -1.812750>,
				<0.030152, -0.542400, -0.833069>, <-3.370651, -3.271694, -3.730921>
			}
			smooth_triangle {
				<0.024569, -0.515390, -0.850224>, <-2.840304, -2.586593, -3.198598>,
				<-0.002586, -0.490751, -0.865021>, <-3.893501, -3.445596, -4.683206>,
				<-0.001804, -0.529681, -0.841749>, <-3.253192, -3.189911, -3.901755>
			}
			smooth_triangle {
				<-0.017834, -0.445451, -0.889026>, <-3.364902, -2.688900, -4.173387>,
				<0.027853, -0.454130, -0.884362>, <-3.552807, -2.737884, -3.981770>,
				<0.015088, -0.411200, -0.905424>, <-3.577795, -2.477963, -4.126585>
			}
			smooth_triangle {
				<-0.002586, -0.490751, -0.865021>, <-3.893501, -3.445596, -4.683206>,
				<0.027853, -0.454130, -0.884362>, <-3.552807, -2.737884, -3.981770>,
				<-0.017834, -0.445451, -0.889026>, <-3.364902, -2.688900, -4.173387>
			}
			smooth_triangle {
				<-0.002586, -0.490751, -0.865021>, <-3.893501, -3.445596, -4.683206>,
				<0.042227, -0.490750, -0.863996>, <-3.544833, -2.953114, -3.833150>,
				<0.027853, -0.454130, -0.884362>, <-3.552807, -2.737884, -3.981770>
			}
			smooth_triangle {
				<-0.002586, -0.490751, -0.865021>, <-3.893501, -3.445596, -4.683206>,
				<0.024569, -0.515390, -0.850224>, <-2.840304, -2.586593, -3.198598>,
				<0.042227, -0.490750, -0.863996>, <-3.544833, -2.953114, -3.833150>
			}
			smooth_triangle {
				<0.069842, -0.462360, -0.877757>, <-3.724590, -2.785832, -3.787394>,
				<0.027853, -0.454130, -0.884362>, <-3.552807, -2.737884, -3.981770>,
				<0.042227, -0.490750, -0.863996>, <-3.544833, -2.953114, -3.833150>
			}
			smooth_triangle {
				<0.027853, -0.454130, -0.884362>, <-3.552807, -2.737884, -3.981770>,
				<0.060349, -0.422640, -0.898249>, <-3.759068, -2.547153, -3.918501>,
				<0.015088, -0.411200, -0.905424>, <-3.577795, -2.477963, -4.126585>
			}
			smooth_triangle {
				<0.069842, -0.462360, -0.877757>, <-3.724590, -2.785832, -3.787394>,
				<0.060349, -0.422640, -0.898249>, <-3.759068, -2.547153, -3.918501>,
				<0.027853, -0.454130, -0.884362>, <-3.552807, -2.737884, -3.981770>
			}
			smooth_triangle {
				<0.015088, -0.411200, -0.905424>, <-3.577795, -2.477963, -4.126585>,
				<-0.034131, -0.400831, -0.909552>, <-3.366487, -2.410109, -4.338538>,
				<-0.017834, -0.445451, -0.889026>, <-3.364902, -2.688900, -4.173387>
			}
			smooth_triangle {
				<-0.050923, -0.350601, -0.929299>, <-3.360355, -2.114948, -4.493554>,
				<-0.008841, -0.312780, -0.944037>, <-3.616391, -1.885811, -4.396121>,
				<-0.063545, -0.295091, -0.947623>, <-3.377001, -1.780711, -4.624147>
			}
			smooth_triangle {
				<0.002730, -0.364150, -0.925471>, <-3.598058, -2.193424, -4.267004>,
				<0.043819, -0.329410, -0.937379>, <-3.836360, -1.982320, -4.161202>,
				<-0.008841, -0.312780, -0.944037>, <-3.616391, -1.885811, -4.396121>
			}
			smooth_triangle {
				<0.002730, -0.364150, -0.925471>, <-3.598058, -2.193424, -4.267004>,
				<0.051463, -0.378420, -0.918298>, <-3.795754, -2.279354, -4.045442>,
				<0.043819, -0.329410, -0.937379>, <-3.836360, -1.982320, -4.161202>
			}
			smooth_triangle {
				<0.002730, -0.364150, -0.925471>, <-3.598058, -2.193424, -4.267004>,
				<0.015088, -0.411200, -0.905424>, <-3.577795, -2.477963, -4.126585>,
				<0.051463, -0.378420, -0.918298>, <-3.795754, -2.279354, -4.045442>
			}
			smooth_triangle {
				<-0.050923, -0.350601, -0.929299>, <-3.360355, -2.114948, -4.493554>,
				<0.002730, -0.364150, -0.925471>, <-3.598058, -2.193424, -4.267004>,
				<-0.008841, -0.312780, -0.944037>, <-3.616391, -1.885811, -4.396121>
			}
			smooth_triangle {
				<0.002730, -0.364150, -0.925471>, <-3.598058, -2.193424, -4.267004>,
				<-0.034131, -0.400831, -0.909552>, <-3.366487, -2.410109, -4.338538>,
				<0.015088, -0.411200, -0.905424>, <-3.577795, -2.477963, -4.126585>
			}
			smooth_triangle {
				<-0.050923, -0.350601, -0.929299>, <-3.360355, -2.114948, -4.493554>,
				<-0.034131, -0.400831, -0.909552>, <-3.366487, -2.410109, -4.338538>,
				<0.002730, -0.364150, -0.925471>, <-3.598058, -2.193424, -4.267004>
			}
			smooth_triangle {
				<0.034512, -0.276980, -0.954568>, <-3.859380, -1.672162, -4.274312>,
				<-0.008841, -0.312780, -0.944037>, <-3.616391, -1.885811, -4.396121>,
				<0.043819, -0.329410, -0.937379>, <-3.836360, -1.982320, -4.161202>
			}
			smooth_triangle {
				<-0.019536, -0.258921, -0.960049>, <-3.629254, -1.562361, -4.510820>,
				<-0.008841, -0.312780, -0.944037>, <-3.616391, -1.885811, -4.396121>,
				<0.034512, -0.276980, -0.954568>, <-3.859380, -1.672162, -4.274312>
			}
			smooth_triangle {
				<-0.019536, -0.258921, -0.960049>, <-3.629254, -1.562361, -4.510820>,
				<-0.063545, -0.295091, -0.947623>, <-3.377001, -1.780711, -4.624147>,
				<-0.008841, -0.312780, -0.944037>, <-3.616391, -1.885811, -4.396121>
			}
			smooth_triangle {
				<-0.019536, -0.258921, -0.960049>, <-3.629254, -1.562361, -4.510820>,
				<-0.074250, -0.238991, -0.962543>, <-3.385746, -1.441576, -4.734568>,
				<-0.063545, -0.295091, -0.947623>, <-3.377001, -1.780711, -4.624147>
			}
			smooth_triangle {
				<0.023900, -0.224060, -0.968678>, <-3.863079, -1.352750, -4.382875>,
				<-0.019536, -0.258921, -0.960049>, <-3.629254, -1.562361, -4.510820>,
				<0.034512, -0.276980, -0.954568>, <-3.859380, -1.672162, -4.274312>
			}
			smooth_triangle {
				<-0.019536, -0.258921, -0.960049>, <-3.629254, -1.562361, -4.510820>,
				<-0.028803, -0.204321, -0.972898>, <-3.635617, -1.232780, -4.606865>,
				<-0.074250, -0.238991, -0.962543>, <-3.385746, -1.441576, -4.734568>
			}
			smooth_triangle {
				<0.023900, -0.224060, -0.968678>, <-3.863079, -1.352750, -4.382875>,
				<-0.028803, -0.204321, -0.972898>, <-3.635617, -1.232780, -4.606865>,
				<-0.019536, -0.258921, -0.960049>, <-3.629254, -1.562361, -4.510820>
			}
			smooth_triangle {
				<0.213686, -0.321740, -0.916478>, <-5.293429, -2.266428, -3.976042>,
				<0.171522, -0.303140, -0.931552>, <-4.406523, -1.832101, -3.633547>,
				<0.169946, -0.344760, -0.917266>, <-4.342627, -2.076753, -3.578270>
			}
			smooth_triangle {
				<0.240596, -0.289750, -0.920469>, <-3.897846, -1.456649, -2.769595>,
				<0.207325, -0.277160, -0.932366>, <-4.571133, -1.670542, -3.505661>,
				<0.213686, -0.321740, -0.916478>, <-5.293429, -2.266428, -3.976042>
			}
			smooth_triangle {
				<0.308628, -0.189369, -0.926279>, <-5.014151, -1.144491, -3.086792>,
				<0.315905, -0.230429, -0.914449>, <-3.318955, -0.905864, -2.038949>,
				<0.343723, -0.199459, -0.911696>, <-2.550332, -0.574921, -1.470456>
			}
			smooth_triangle {
				<0.278106, -0.216829, -0.929922>, <-4.888187, -1.304958, -3.221878>,
				<0.315905, -0.230429, -0.914449>, <-3.318955, -0.905864, -2.038949>,
				<0.308628, -0.189369, -0.926279>, <-5.014151, -1.144491, -3.086792>
			}
			smooth_triangle {
				<0.278106, -0.216829, -0.929922>, <-4.888187, -1.304958, -3.221878>,
				<0.285953, -0.250209, -0.919092>, <-4.069660, -1.256797, -2.616356>,
				<0.315905, -0.230429, -0.914449>, <-3.318955, -0.905864, -2.038949>
			}
			smooth_triangle {
				<0.240596, -0.289750, -0.920469>, <-3.897846, -1.456649, -2.769595>,
				<0.247003, -0.250739, -0.930180>, <-5.535276, -1.759236, -3.903026>,
				<0.207325, -0.277160, -0.932366>, <-4.571133, -1.670542, -3.505661>
			}
			smooth_triangle {
				<0.274644, -0.281489, -0.913480>, <-4.810447, -1.699606, -3.154618>,
				<0.247003, -0.250739, -0.930180>, <-5.535276, -1.759236, -3.903026>,
				<0.240596, -0.289750, -0.920469>, <-3.897846, -1.456649, -2.769595>
			}
			smooth_triangle {
				<0.274644, -0.281489, -0.913480>, <-4.810447, -1.699606, -3.154618>,
				<0.285953, -0.250209, -0.919092>, <-4.069660, -1.256797, -2.616356>,
				<0.247003, -0.250739, -0.930180>, <-5.535276, -1.759236, -3.903026>
			}
			smooth_triangle {
				<0.285953, -0.250209, -0.919092>, <-4.069660, -1.256797, -2.616356>,
				<0.278106, -0.216829, -0.929922>, <-4.888187, -1.304958, -3.221878>,
				<0.247003, -0.250739, -0.930180>, <-5.535276, -1.759236, -3.903026>
			}
			smooth_triangle {
				<0.271641, -0.175069, -0.940567>, <-4.899945, -1.054814, -3.294611>,
				<0.278106, -0.216829, -0.929922>, <-4.888187, -1.304958, -3.221878>,
				<0.308628, -0.189369, -0.926279>, <-5.014151, -1.144491, -3.086792>
			}
			smooth_triangle {
				<0.247003, -0.250739, -0.930180>, <-5.535276, -1.759236, -3.903026>,
				<0.202609, -0.234270, -0.945080>, <-4.600820, -1.412347, -3.579307>,
				<0.207325, -0.277160, -0.932366>, <-4.571133, -1.670542, -3.505661>
			}
			smooth_triangle {
				<0.247003, -0.250739, -0.930180>, <-5.535276, -1.759236, -3.903026>,
				<0.237933, -0.204580, -0.943743>, <-4.756249, -1.235720, -3.438753>,
				<0.202609, -0.234270, -0.945080>, <-4.600820, -1.412347, -3.579307>
			}
			smooth_triangle {
				<0.237933, -0.204580, -0.943743>, <-4.756249, -1.235720, -3.438753>,
				<0.278106, -0.216829, -0.929922>, <-4.888187, -1.304958, -3.221878>,
				<0.271641, -0.175069, -0.940567>, <-4.899945, -1.054814, -3.294611>
			}
			smooth_triangle {
				<0.237933, -0.204580, -0.943743>, <-4.756249, -1.235720, -3.438753>,
				<0.247003, -0.250739, -0.930180>, <-5.535276, -1.759236, -3.903026>,
				<0.278106, -0.216829, -0.929922>, <-4.888187, -1.304958, -3.221878>
			}
			smooth_triangle {
				<0.231237, -0.160080, -0.953946>, <-4.765797, -0.965332, -3.511339>,
				<0.237933, -0.204580, -0.943743>, <-4.756249, -1.235720, -3.438753>,
				<0.271641, -0.175069, -0.940567>, <-4.899945, -1.054814, -3.294611>
			}
			smooth_triangle {
				<0.237933, -0.204580, -0.943743>, <-4.756249, -1.235720, -3.438753>,
				<0.195396, -0.189820, -0.956507>, <-4.609985, -1.145137, -3.661954>,
				<0.202609, -0.234270, -0.945080>, <-4.600820, -1.412347, -3.579307>
			}
			smooth_triangle {
				<0.231237, -0.160080, -0.953946>, <-4.765797, -0.965332, -3.511339>,
				<0.195396, -0.189820, -0.956507>, <-4.609985, -1.145137, -3.661954>,
				<0.237933, -0.204580, -0.943743>, <-4.756249, -1.235720, -3.438753>
			}
			smooth_triangle {
				<0.271641, -0.175069, -0.940567>, <-4.899945, -1.054814, -3.294611>,
				<0.266828, -0.130949, -0.949086>, <-4.911676, -0.788433, -3.350843>,
				<0.231237, -0.160080, -0.953946>, <-4.765797, -0.965332, -3.511339>
			}
			smooth_triangle {
				<0.345602, -0.124779, -0.924173>, <-6.042374, -0.873509, -3.419055>,
				<0.388870, -0.127939, -0.906383>, <-1.748657, -0.256804, -0.935687>,
				<0.375026, -0.088929, -0.916815>, <-1.744141, -0.212478, -0.955026>
			}
			smooth_triangle {
				<0.345602, -0.124779, -0.924173>, <-6.042374, -0.873509, -3.419055>,
				<0.371966, -0.167309, -0.907067>, <-2.600022, -0.470424, -1.419837>,
				<0.388870, -0.127939, -0.906383>, <-1.748657, -0.256804, -0.935687>
			}
			smooth_triangle {
				<0.335331, -0.165859, -0.921494>, <-4.270495, -0.828053, -2.462324>,
				<0.343723, -0.199459, -0.911696>, <-2.550332, -0.574921, -1.470456>,
				<0.371966, -0.167309, -0.907067>, <-2.600022, -0.470424, -1.419837>
			}
			smooth_triangle {
				<0.335331, -0.165859, -0.921494>, <-4.270495, -0.828053, -2.462324>,
				<0.308628, -0.189369, -0.926279>, <-5.014151, -1.144491, -3.086792>,
				<0.343723, -0.199459, -0.911696>, <-2.550332, -0.574921, -1.470456>
			}
			smooth_triangle {
				<0.335331, -0.165859, -0.921494>, <-4.270495, -0.828053, -2.462324>,
				<0.305491, -0.148059, -0.934809>, <-5.034757, -0.886847, -3.137038>,
				<0.308628, -0.189369, -0.926279>, <-5.014151, -1.144491, -3.086792>
			}
			smooth_triangle {
				<0.345602, -0.124779, -0.924173>, <-6.042374, -0.873509, -3.419055>,
				<0.335331, -0.165859, -0.921494>, <-4.270495, -0.828053, -2.462324>,
				<0.371966, -0.167309, -0.907067>, <-2.600022, -0.470424, -1.419837>
			}
			smooth_triangle {
				<0.345602, -0.124779, -0.924173>, <-6.042374, -0.873509, -3.419055>,
				<0.305491, -0.148059, -0.934809>, <-5.034757, -0.886847, -3.137038>,
				<0.335331, -0.165859, -0.921494>, <-4.270495, -0.828053, -2.462324>
			}
			smooth_triangle {
				<0.336353, -0.072949, -0.933095>, <-2.572682, -0.274858, -1.517138>,
				<0.345602, -0.124779, -0.924173>, <-6.042374, -0.873509, -3.419055>,
				<0.375026, -0.088929, -0.916815>, <-1.744141, -0.212478, -0.955026>
			}
			smooth_triangle {
				<0.345602, -0.124779, -0.924173>, <-6.042374, -0.873509, -3.419055>,
				<0.303157, -0.101889, -0.941713>, <-5.051478, -0.612181, -3.174780>,
				<0.305491, -0.148059, -0.934809>, <-5.034757, -0.886847, -3.137038>
			}
			smooth_triangle {
				<0.336353, -0.072949, -0.933095>, <-2.572682, -0.274858, -1.517138>,
				<0.303157, -0.101889, -0.941713>, <-5.051478, -0.612181, -3.174780>,
				<0.345602, -0.124779, -0.924173>, <-6.042374, -0.873509, -3.419055>
			}
			smooth_triangle {
				<0.266828, -0.130949, -0.949086>, <-4.911676, -0.788433, -3.350843>,
				<0.305491, -0.148059, -0.934809>, <-5.034757, -0.886847, -3.137038>,
				<0.303157, -0.101889, -0.941713>, <-5.051478, -0.612181, -3.174780>
			}
			smooth_triangle {
				<0.305491, -0.148059, -0.934809>, <-5.034757, -0.886847, -3.137038>,
				<0.271641, -0.175069, -0.940567>, <-4.899945, -1.054814, -3.294611>,
				<0.308628, -0.189369, -0.926279>, <-5.014151, -1.144491, -3.086792>
			}
			smooth_triangle {
				<0.266828, -0.130949, -0.949086>, <-4.911676, -0.788433, -3.350843>,
				<0.271641, -0.175069, -0.940567>, <-4.899945, -1.054814, -3.294611>,
				<0.305491, -0.148059, -0.934809>, <-5.034757, -0.886847, -3.137038>
			}
			smooth_triangle {
				<0.159299, -0.220070, -0.956712>, <-4.443634, -1.325925, -3.803858>,
				<0.202609, -0.234270, -0.945080>, <-4.600820, -1.412347, -3.579307>,
				<0.195396, -0.189820, -0.956507>, <-4.609985, -1.145137, -3.661954>
			}
			smooth_triangle {
				<0.207325, -0.277160, -0.932366>, <-4.571133, -1.670542, -3.505661>,
				<0.171522, -0.303140, -0.931552>, <-4.406523, -1.832101, -3.633547>,
				<0.213686, -0.321740, -0.916478>, <-5.293429, -2.266428, -3.976042>
			}
			smooth_triangle {
				<0.207325, -0.277160, -0.932366>, <-4.571133, -1.670542, -3.505661>,
				<0.167268, -0.262480, -0.944587>, <-4.436828, -1.579053, -3.714517>,
				<0.171522, -0.303140, -0.931552>, <-4.406523, -1.832101, -3.633547>
			}
			smooth_triangle {
				<0.167268, -0.262480, -0.944587>, <-4.436828, -1.579053, -3.714517>,
				<0.202609, -0.234270, -0.945080>, <-4.600820, -1.412347, -3.579307>,
				<0.159299, -0.220070, -0.956712>, <-4.443634, -1.325925, -3.803858>
			}
			smooth_triangle {
				<0.167268, -0.262480, -0.944587>, <-4.436828, -1.579053, -3.714517>,
				<0.207325, -0.277160, -0.932366>, <-4.571133, -1.670542, -3.505661>,
				<0.202609, -0.234270, -0.945080>, <-4.600820, -1.412347, -3.579307>
			}
			smooth_triangle {
				<0.195396, -0.189820, -0.956507>, <-4.609985, -1.145137, -3.661954>,
				<0.151347, -0.174720, -0.967309>, <-4.447345, -1.053903, -3.883547>,
				<0.159299, -0.220070, -0.956712>, <-4.443634, -1.325925, -3.803858>
			}
			smooth_triangle {
				<0.300257, -0.049049, -0.946865>, <-2.512548, -0.214160, -1.624473>,
				<0.303157, -0.101889, -0.941713>, <-5.051478, -0.612181, -3.174780>,
				<0.336353, -0.072949, -0.933095>, <-2.572682, -0.274858, -1.517138>
			}
			smooth_triangle {
				<0.182603, -0.098820, -0.972624>, <-4.613234, -0.596020, -3.786251>,
				<0.225521, -0.114980, -0.961786>, <-4.770042, -0.693242, -3.569261>,
				<0.220068, -0.069890, -0.967366>, <-4.765286, -0.421902, -3.617707>
			}
			smooth_triangle {
				<0.188630, -0.144540, -0.965737>, <-4.614408, -0.871469, -3.731008>,
				<0.231237, -0.160080, -0.953946>, <-4.765797, -0.965332, -3.511339>,
				<0.225521, -0.114980, -0.961786>, <-4.770042, -0.693242, -3.569261>
			}
			smooth_triangle {
				<0.188630, -0.144540, -0.965737>, <-4.614408, -0.871469, -3.731008>,
				<0.195396, -0.189820, -0.956507>, <-4.609985, -1.145137, -3.661954>,
				<0.231237, -0.160080, -0.953946>, <-4.765797, -0.965332, -3.511339>
			}
			smooth_triangle {
				<0.188630, -0.144540, -0.965737>, <-4.614408, -0.871469, -3.731008>,
				<0.151347, -0.174720, -0.967309>, <-4.447345, -1.053903, -3.883547>,
				<0.195396, -0.189820, -0.956507>, <-4.609985, -1.145137, -3.661954>
			}
			smooth_triangle {
				<0.182603, -0.098820, -0.972624>, <-4.613234, -0.596020, -3.786251>,
				<0.188630, -0.144540, -0.965737>, <-4.614408, -0.871469, -3.731008>,
				<0.225521, -0.114980, -0.961786>, <-4.770042, -0.693242, -3.569261>
			}
			smooth_triangle {
				<0.188630, -0.144540, -0.965737>, <-4.614408, -0.871469, -3.731008>,
				<0.144391, -0.128320, -0.975598>, <-4.447842, -0.774217, -3.948300>,
				<0.151347, -0.174720, -0.967309>, <-4.447345, -1.053903, -3.883547>
			}
			smooth_triangle {
				<0.182603, -0.098820, -0.972624>, <-4.613234, -0.596020, -3.786251>,
				<0.144391, -0.128320, -0.975598>, <-4.447842, -0.774217, -3.948300>,
				<0.188630, -0.144540, -0.965737>, <-4.614408, -0.871469, -3.731008>
			}
			smooth_triangle {
				<0.266828, -0.130949, -0.949086>, <-4.911676, -0.788433, -3.350843>,
				<0.225521, -0.114980, -0.961786>, <-4.770042, -0.693242, -3.569261>,
				<0.231237, -0.160080, -0.953946>, <-4.765797, -0.965332, -3.511339>
			}
			smooth_triangle {
				<0.262219, -0.085179, -0.955559>, <-4.917716, -0.514891, -3.394696>,
				<0.266828, -0.130949, -0.949086>, <-4.911676, -0.788433, -3.350843>,
				<0.303157, -0.101889, -0.941713>, <-5.051478, -0.612181, -3.174780>
			}
			smooth_triangle {
				<0.262219, -0.085179, -0.955559>, <-4.917716, -0.514891, -3.394696>,
				<0.225521, -0.114980, -0.961786>, <-4.770042, -0.693242, -3.569261>,
				<0.266828, -0.130949, -0.949086>, <-4.911676, -0.788433, -3.350843>
			}
			smooth_triangle {
				<0.262219, -0.085179, -0.955559>, <-4.917716, -0.514891, -3.394696>,
				<0.220068, -0.069890, -0.967366>, <-4.765286, -0.421902, -3.617707>,
				<0.225521, -0.114980, -0.961786>, <-4.770042, -0.693242, -3.569261>
			}
			smooth_triangle {
				<0.300257, -0.049049, -0.946865>, <-2.512548, -0.214160, -1.624473>,
				<0.262219, -0.085179, -0.955559>, <-4.917716, -0.514891, -3.394696>,
				<0.303157, -0.101889, -0.941713>, <-5.051478, -0.612181, -3.174780>
			}
			smooth_triangle {
				<0.262219, -0.085179, -0.955559>, <-4.917716, -0.514891, -3.394696>,
				<0.255787, -0.044019, -0.960082>, <-2.440905, -0.175053, -1.734021>,
				<0.220068, -0.069890, -0.967366>, <-4.765286, -0.421902, -3.617707>
			}
			smooth_triangle {
				<0.300257, -0.049049, -0.946865>, <-2.512548, -0.214160, -1.624473>,
				<0.255787, -0.044019, -0.960082>, <-2.440905, -0.175053, -1.734021>,
				<0.262219, -0.085179, -0.955559>, <-4.917716, -0.514891, -3.394696>
			}
			smooth_triangle {
				<0.182603, -0.098820, -0.972624>, <-4.613234, -0.596020, -3.786251>,
				<0.138437, -0.081880, -0.981450>, <-4.443465, -0.494797, -3.997838>,
				<0.144391, -0.128320, -0.975598>, <-4.447842, -0.774217, -3.948300>
			}
			smooth_triangle {
				<0.182603, -0.098820, -0.972624>, <-4.613234, -0.596020, -3.786251>,
				<0.177363, -0.053010, -0.977157>, <-4.607249, -0.319836, -3.826730>,
				<0.138437, -0.081880, -0.981450>, <-4.443465, -0.494797, -3.997838>
			}
			smooth_triangle {
				<0.215478, -0.023080, -0.970643>, <-2.363813, -0.122698, -1.842285>,
				<0.220068, -0.069890, -0.967366>, <-4.765286, -0.421902, -3.617707>,
				<0.255787, -0.044019, -0.960082>, <-2.440905, -0.175053, -1.734021>
			}
			smooth_triangle {
				<0.220068, -0.069890, -0.967366>, <-4.765286, -0.421902, -3.617707>,
				<0.177363, -0.053010, -0.977157>, <-4.607249, -0.319836, -3.826730>,
				<0.182603, -0.098820, -0.972624>, <-4.613234, -0.596020, -3.786251>
			}
			smooth_triangle {
				<0.220068, -0.069890, -0.967366>, <-4.765286, -0.421902, -3.617707>,
				<0.215478, -0.023080, -0.970643>, <-2.363813, -0.122698, -1.842285>,
				<0.177363, -0.053010, -0.977157>, <-4.607249, -0.319836, -3.826730>
			}
			smooth_triangle {
				<0.203089, -0.366120, -0.902116>, <-4.436447, -2.202377, -3.383223>,
				<0.213686, -0.321740, -0.916478>, <-5.293429, -2.266428, -3.976042>,
				<0.169946, -0.344760, -0.917266>, <-4.342627, -2.076753, -3.578270>
			}
			smooth_triangle {
				<0.285953, -0.250209, -0.919092>, <-4.069660, -1.256797, -2.616356>,
				<0.313098, -0.271159, -0.904182>, <-2.453522, -0.812393, -1.522428>,
				<0.315905, -0.230429, -0.914449>, <-3.318955, -0.905864, -2.038949>
			}
			smooth_triangle {
				<0.259473, -0.317079, -0.906219>, <-4.710354, -1.916909, -3.180749>,
				<0.300272, -0.309359, -0.896240>, <-2.408860, -0.920214, -1.532285>,
				<0.274644, -0.281489, -0.913480>, <-4.810447, -1.699606, -3.154618>
			}
			smooth_triangle {
				<0.259473, -0.317079, -0.906219>, <-4.710354, -1.916909, -3.180749>,
				<0.284104, -0.346469, -0.887894>, <-2.356988, -1.024750, -1.546692>,
				<0.300272, -0.309359, -0.896240>, <-2.408860, -0.920214, -1.532285>
			}
			smooth_triangle {
				<0.261671, -0.376590, -0.882503>, <-1.540372, -0.732183, -1.044235>,
				<0.242136, -0.352910, -0.897741>, <-4.598525, -2.122501, -3.213649>,
				<0.229468, -0.388600, -0.886250>, <-2.251811, -1.132435, -1.626237>
			}
			smooth_triangle {
				<0.242136, -0.352910, -0.897741>, <-4.598525, -2.122501, -3.213649>,
				<0.284104, -0.346469, -0.887894>, <-2.356988, -1.024750, -1.546692>,
				<0.259473, -0.317079, -0.906219>, <-4.710354, -1.916909, -3.180749>
			}
			smooth_triangle {
				<0.242136, -0.352910, -0.897741>, <-4.598525, -2.122501, -3.213649>,
				<0.261671, -0.376590, -0.882503>, <-1.540372, -0.732183, -1.044235>,
				<0.284104, -0.346469, -0.887894>, <-2.356988, -1.024750, -1.546692>
			}
			smooth_triangle {
				<0.240596, -0.289750, -0.920469>, <-3.897846, -1.456649, -2.769595>,
				<0.259473, -0.317079, -0.906219>, <-4.710354, -1.916909, -3.180749>,
				<0.274644, -0.281489, -0.913480>, <-4.810447, -1.699606, -3.154618>
			}
			smooth_triangle {
				<0.242136, -0.352910, -0.897741>, <-4.598525, -2.122501, -3.213649>,
				<0.203089, -0.366120, -0.902116>, <-4.436447, -2.202377, -3.383223>,
				<0.229468, -0.388600, -0.886250>, <-2.251811, -1.132435, -1.626237>
			}
			smooth_triangle {
				<0.203089, -0.366120, -0.902116>, <-4.436447, -2.202377, -3.383223>,
				<0.242136, -0.352910, -0.897741>, <-4.598525, -2.122501, -3.213649>,
				<0.213686, -0.321740, -0.916478>, <-5.293429, -2.266428, -3.976042>
			}
			smooth_triangle {
				<0.240596, -0.289750, -0.920469>, <-3.897846, -1.456649, -2.769595>,
				<0.213686, -0.321740, -0.916478>, <-5.293429, -2.266428, -3.976042>,
				<0.259473, -0.317079, -0.906219>, <-4.710354, -1.916909, -3.180749>
			}
			smooth_triangle {
				<0.213686, -0.321740, -0.916478>, <-5.293429, -2.266428, -3.976042>,
				<0.242136, -0.352910, -0.897741>, <-4.598525, -2.122501, -3.213649>,
				<0.259473, -0.317079, -0.906219>, <-4.710354, -1.916909, -3.180749>
			}
			smooth_triangle {
				<0.313098, -0.271159, -0.904182>, <-2.453522, -0.812393, -1.522428>,
				<0.274644, -0.281489, -0.913480>, <-4.810447, -1.699606, -3.154618>,
				<0.300272, -0.309359, -0.896240>, <-2.408860, -0.920214, -1.532285>
			}
			smooth_triangle {
				<0.313098, -0.271159, -0.904182>, <-2.453522, -0.812393, -1.522428>,
				<0.285953, -0.250209, -0.919092>, <-4.069660, -1.256797, -2.616356>,
				<0.274644, -0.281489, -0.913480>, <-4.810447, -1.699606, -3.154618>
			}
			smooth_triangle {
				<0.203089, -0.366120, -0.902116>, <-4.436447, -2.202377, -3.383223>,
				<0.195889, -0.402970, -0.887889>, <-2.175608, -1.177068, -1.696733>,
				<0.229468, -0.388600, -0.886250>, <-2.251811, -1.132435, -1.626237>
			}
			smooth_triangle {
				<0.195889, -0.402970, -0.887889>, <-2.175608, -1.177068, -1.696733>,
				<0.166352, -0.384720, -0.901901>, <-4.265575, -2.315547, -3.524726>,
				<0.162714, -0.417960, -0.887661>, <-2.092339, -1.237617, -1.756993>
			}
			smooth_triangle {
				<0.166352, -0.384720, -0.901901>, <-4.265575, -2.315547, -3.524726>,
				<0.203089, -0.366120, -0.902116>, <-4.436447, -2.202377, -3.383223>,
				<0.169946, -0.344760, -0.917266>, <-4.342627, -2.076753, -3.578270>
			}
			smooth_triangle {
				<0.203089, -0.366120, -0.902116>, <-4.436447, -2.202377, -3.383223>,
				<0.166352, -0.384720, -0.901901>, <-4.265575, -2.315547, -3.524726>,
				<0.195889, -0.402970, -0.887889>, <-2.175608, -1.177068, -1.696733>
			}
			smooth_triangle {
				<-0.126696, -0.789361, -0.591579>, <-0.825700, -2.369025, -1.644580>,
				<-0.119332, -0.774821, -0.611988>, <-0.897041, -2.314526, -1.684199>,
				<-0.145812, -0.769801, -0.612586>, <-1.696376, -4.643401, -3.397665>
			}
			smooth_triangle {
				<-0.178602, -0.783701, -0.585686>, <-0.511180, -1.560629, -1.141192>,
				<-0.172130, -0.765621, -0.610985>, <-1.585408, -4.617178, -3.485656>,
				<-0.191587, -0.761071, -0.610884>, <-0.513825, -1.531012, -1.179245>
			}
			smooth_triangle {
				<-0.155968, -0.794971, -0.576899>, <-1.066180, -3.154017, -2.216624>,
				<-0.172130, -0.765621, -0.610985>, <-1.585408, -4.617178, -3.485656>,
				<-0.178602, -0.783701, -0.585686>, <-0.511180, -1.560629, -1.141192>
			}
			smooth_triangle {
				<-0.155968, -0.794971, -0.576899>, <-1.066180, -3.154017, -2.216624>,
				<-0.145812, -0.769801, -0.612586>, <-1.696376, -4.643401, -3.397665>,
				<-0.172130, -0.765621, -0.610985>, <-1.585408, -4.617178, -3.485656>
			}
			smooth_triangle {
				<-0.155968, -0.794971, -0.576899>, <-1.066180, -3.154017, -2.216624>,
				<-0.126696, -0.789361, -0.591579>, <-0.825700, -2.369025, -1.644580>,
				<-0.145812, -0.769801, -0.612586>, <-1.696376, -4.643401, -3.397665>
			}
			smooth_triangle {
				<-0.155968, -0.794971, -0.576899>, <-1.066180, -3.154017, -2.216624>,
				<-0.132042, -0.803021, -0.571689>, <-0.268687, -0.798007, -0.539437>,
				<-0.126696, -0.789361, -0.591579>, <-0.825700, -2.369025, -1.644580>
			}
			smooth_triangle {
				<0.047194, -0.042370, -0.992520>, <-4.065055, -0.254771, -4.402244>,
				<0.006088, -0.070480, -0.992020>, <-3.873957, -0.426378, -4.558577>,
				<0.052341, -0.091370, -0.988953>, <-4.074502, -0.551969, -4.366116>
			}
			smooth_triangle {
				<-0.169018, -0.006111, -0.980054>, <-3.016417, -0.039142, -5.183784>,
				<-0.173649, 0.041109, -0.978401>, <-2.987946, 0.248781, -5.194524>,
				<-0.212496, 0.011789, -0.971507>, <-2.783772, 0.070463, -5.311929>
			}
			smooth_triangle {
				<0.041747, 0.008140, -0.993628>, <-4.045933, 0.052332, -4.426600>,
				<0.000880, -0.021160, -0.994321>, <-3.859481, -0.126020, -4.588874>,
				<0.047194, -0.042370, -0.992520>, <-4.065055, -0.254771, -4.402244>
			}
			smooth_triangle {
				<0.033738, 0.060210, -0.992142>, <-4.007021, 0.358836, -4.447739>,
				<-0.006487, 0.029790, -0.994079>, <-3.821758, 0.181013, -4.618229>,
				<0.041747, 0.008140, -0.993628>, <-4.045933, 0.052332, -4.426600>
			}
			smooth_triangle {
				<-0.011826, 0.081170, -0.991153>, <-3.782845, 0.484638, -4.628694>,
				<0.033738, 0.060210, -0.992142>, <-4.007021, 0.358836, -4.447739>,
				<0.023531, 0.104680, -0.988734>, <-1.962920, 0.273137, -2.251155>
			}
			smooth_triangle {
				<-0.011826, 0.081170, -0.991153>, <-3.782845, 0.484638, -4.628694>,
				<-0.006487, 0.029790, -0.994079>, <-3.821758, 0.181013, -4.618229>,
				<0.033738, 0.060210, -0.992142>, <-4.007021, 0.358836, -4.447739>
			}
			smooth_triangle {
				<-0.011826, 0.081170, -0.991153>, <-3.782845, 0.484638, -4.628694>,
				<-0.057928, 0.052299, -0.991473>, <-4.178058, 0.368841, -5.600350>,
				<-0.006487, 0.029790, -0.994079>, <-3.821758, 0.181013, -4.618229>
			}
			smooth_triangle {
				<-0.011346, 0.131280, -0.985773>, <-1.863491, 0.347145, -2.324533>,
				<-0.011826, 0.081170, -0.991153>, <-3.782845, 0.484638, -4.628694>,
				<0.023531, 0.104680, -0.988734>, <-1.962920, 0.273137, -2.251155>
			}
			smooth_triangle {
				<-0.011826, 0.081170, -0.991153>, <-3.782845, 0.484638, -4.628694>,
				<-0.052338, 0.108450, -0.987222>, <-3.584636, 0.650632, -4.764073>,
				<-0.057928, 0.052299, -0.991473>, <-4.178058, 0.368841, -5.600350>
			}
			smooth_triangle {
				<-0.011346, 0.131280, -0.985773>, <-1.863491, 0.347145, -2.324533>,
				<-0.052338, 0.108450, -0.987222>, <-3.584636, 0.650632, -4.764073>,
				<-0.011826, 0.081170, -0.991153>, <-3.782845, 0.484638, -4.628694>
			}
			smooth_triangle {
				<-0.045492, -0.002020, -0.993502>, <-3.642436, -0.006947, -4.764661>,
				<-0.006487, 0.029790, -0.994079>, <-3.821758, 0.181013, -4.618229>,
				<-0.057928, 0.052299, -0.991473>, <-4.178058, 0.368841, -5.600350>
			}
			smooth_triangle {
				<-0.006487, 0.029790, -0.994079>, <-3.821758, 0.181013, -4.618229>,
				<0.000880, -0.021160, -0.994321>, <-3.859481, -0.126020, -4.588874>,
				<0.041747, 0.008140, -0.993628>, <-4.045933, 0.052332, -4.426600>
			}
			smooth_triangle {
				<-0.045492, -0.002020, -0.993502>, <-3.642436, -0.006947, -4.764661>,
				<0.000880, -0.021160, -0.994321>, <-3.859481, -0.126020, -4.588874>,
				<-0.006487, 0.029790, -0.994079>, <-3.821758, 0.181013, -4.618229>
			}
			smooth_triangle {
				<-0.095533, 0.088659, -0.985962>, <-3.384386, 0.539574, -4.922106>,
				<-0.057928, 0.052299, -0.991473>, <-4.178058, 0.368841, -5.600350>,
				<-0.052338, 0.108450, -0.987222>, <-3.584636, 0.650632, -4.764073>
			}
			smooth_triangle {
				<-0.057928, 0.052299, -0.991473>, <-4.178058, 0.368841, -5.600350>,
				<-0.090764, 0.011149, -0.990329>, <-3.424982, 0.065083, -4.923295>,
				<-0.045492, -0.002020, -0.993502>, <-3.642436, -0.006947, -4.764661>
			}
			smooth_triangle {
				<-0.102621, 0.048739, -0.988030>, <-2.801081, 0.246082, -4.132479>,
				<-0.132852, 0.023559, -0.985351>, <-3.202406, 0.138814, -5.069621>,
				<-0.090764, 0.011149, -0.990329>, <-3.424982, 0.065083, -4.923295>
			}
			smooth_triangle {
				<-0.102621, 0.048739, -0.988030>, <-2.801081, 0.246082, -4.132479>,
				<-0.135650, 0.067939, -0.982899>, <-3.178930, 0.415118, -5.069261>,
				<-0.132852, 0.023559, -0.985351>, <-3.202406, 0.138814, -5.069621>
			}
			smooth_triangle {
				<-0.102621, 0.048739, -0.988030>, <-2.801081, 0.246082, -4.132479>,
				<-0.095533, 0.088659, -0.985962>, <-3.384386, 0.539574, -4.922106>,
				<-0.135650, 0.067939, -0.982899>, <-3.178930, 0.415118, -5.069261>
			}
			smooth_triangle {
				<-0.057928, 0.052299, -0.991473>, <-4.178058, 0.368841, -5.600350>,
				<-0.102621, 0.048739, -0.988030>, <-2.801081, 0.246082, -4.132479>,
				<-0.090764, 0.011149, -0.990329>, <-3.424982, 0.065083, -4.923295>
			}
			smooth_triangle {
				<-0.057928, 0.052299, -0.991473>, <-4.178058, 0.368841, -5.600350>,
				<-0.095533, 0.088659, -0.985962>, <-3.384386, 0.539574, -4.922106>,
				<-0.102621, 0.048739, -0.988030>, <-2.801081, 0.246082, -4.132479>
			}
			smooth_triangle {
				<-0.124734, -0.021421, -0.986458>, <-3.246131, -0.131929, -5.041610>,
				<-0.090764, 0.011149, -0.990329>, <-3.424982, 0.065083, -4.923295>,
				<-0.132852, 0.023559, -0.985351>, <-3.202406, 0.138814, -5.069621>
			}
			smooth_triangle {
				<0.000880, -0.021160, -0.994321>, <-3.859481, -0.126020, -4.588874>,
				<0.006088, -0.070480, -0.992020>, <-3.873957, -0.426378, -4.558577>,
				<0.047194, -0.042370, -0.992520>, <-4.065055, -0.254771, -4.402244>
			}
			smooth_triangle {
				<0.000880, -0.021160, -0.994321>, <-3.859481, -0.126020, -4.588874>,
				<-0.037865, -0.049900, -0.992565>, <-3.676601, -0.298925, -4.729345>,
				<0.006088, -0.070480, -0.992020>, <-3.873957, -0.426378, -4.558577>
			}
			smooth_triangle {
				<-0.080640, -0.034121, -0.990678>, <-3.467010, -0.202249, -4.890144>,
				<-0.090764, 0.011149, -0.990329>, <-3.424982, 0.065083, -4.923295>,
				<-0.124734, -0.021421, -0.986458>, <-3.246131, -0.131929, -5.041610>
			}
			smooth_triangle {
				<-0.080640, -0.034121, -0.990678>, <-3.467010, -0.202249, -4.890144>,
				<-0.045492, -0.002020, -0.993502>, <-3.642436, -0.006947, -4.764661>,
				<-0.090764, 0.011149, -0.990329>, <-3.424982, 0.065083, -4.923295>
			}
			smooth_triangle {
				<-0.045492, -0.002020, -0.993502>, <-3.642436, -0.006947, -4.764661>,
				<-0.037865, -0.049900, -0.992565>, <-3.676601, -0.298925, -4.729345>,
				<0.000880, -0.021160, -0.994321>, <-3.859481, -0.126020, -4.588874>
			}
			smooth_triangle {
				<-0.080640, -0.034121, -0.990678>, <-3.467010, -0.202249, -4.890144>,
				<-0.037865, -0.049900, -0.992565>, <-3.676601, -0.298925, -4.729345>,
				<-0.045492, -0.002020, -0.993502>, <-3.642436, -0.006947, -4.764661>
			}
			smooth_triangle {
				<-0.173649, 0.041109, -0.978401>, <-2.987946, 0.248781, -5.194524>,
				<-0.132852, 0.023559, -0.985351>, <-3.202406, 0.138814, -5.069621>,
				<-0.135650, 0.067939, -0.982899>, <-3.178930, 0.415118, -5.069261>
			}
			smooth_triangle {
				<-0.132852, 0.023559, -0.985351>, <-3.202406, 0.138814, -5.069621>,
				<-0.169018, -0.006111, -0.980054>, <-3.016417, -0.039142, -5.183784>,
				<-0.124734, -0.021421, -0.986458>, <-3.246131, -0.131929, -5.041610>
			}
			smooth_triangle {
				<-0.173649, 0.041109, -0.978401>, <-2.987946, 0.248781, -5.194524>,
				<-0.169018, -0.006111, -0.980054>, <-3.016417, -0.039142, -5.183784>,
				<-0.132852, 0.023559, -0.985351>, <-3.202406, 0.138814, -5.069621>
			}
			smooth_triangle {
				<0.088369, -0.015850, -0.990479>, <-4.244869, -0.093016, -4.235835>,
				<0.041747, 0.008140, -0.993628>, <-4.045933, 0.052332, -4.426600>,
				<0.047194, -0.042370, -0.992520>, <-4.065055, -0.254771, -4.402244>
			}
			smooth_triangle {
				<0.033738, 0.060210, -0.992142>, <-4.007021, 0.358836, -4.447739>,
				<0.068852, 0.099030, -0.987196>, <-2.065392, 0.221980, -2.163856>,
				<0.023531, 0.104680, -0.988734>, <-1.962920, 0.273137, -2.251155>
			}
			smooth_triangle {
				<0.086265, 0.038320, -0.990046>, <-4.934096, 0.268737, -4.953477>,
				<0.068852, 0.099030, -0.987196>, <-2.065392, 0.221980, -2.163856>,
				<0.033738, 0.060210, -0.992142>, <-4.007021, 0.358836, -4.447739>
			}
			smooth_triangle {
				<0.086265, 0.038320, -0.990046>, <-4.934096, 0.268737, -4.953477>,
				<0.109528, 0.077420, -0.985455>, <-1.422455, 0.120501, -1.400293>,
				<0.068852, 0.099030, -0.987196>, <-2.065392, 0.221980, -2.163856>
			}
			smooth_triangle {
				<0.086265, 0.038320, -0.990046>, <-4.934096, 0.268737, -4.953477>,
				<0.132937, 0.038180, -0.984876>, <-1.445446, 0.073623, -1.380019>,
				<0.109528, 0.077420, -0.985455>, <-1.422455, 0.120501, -1.400293>
			}
			smooth_triangle {
				<0.086265, 0.038320, -0.990046>, <-4.934096, 0.268737, -4.953477>,
				<0.127893, 0.000890, -0.986283>, <-2.915339, -0.001364, -2.736799>,
				<0.132937, 0.038180, -0.984876>, <-1.445446, 0.073623, -1.380019>
			}
			smooth_triangle {
				<0.041747, 0.008140, -0.993628>, <-4.045933, 0.052332, -4.426600>,
				<0.086265, 0.038320, -0.990046>, <-4.934096, 0.268737, -4.953477>,
				<0.033738, 0.060210, -0.992142>, <-4.007021, 0.358836, -4.447739>
			}
			smooth_triangle {
				<0.086265, 0.038320, -0.990046>, <-4.934096, 0.268737, -4.953477>,
				<0.088369, -0.015850, -0.990479>, <-4.244869, -0.093016, -4.235835>,
				<0.127893, 0.000890, -0.986283>, <-2.915339, -0.001364, -2.736799>
			}
			smooth_triangle {
				<0.041747, 0.008140, -0.993628>, <-4.045933, 0.052332, -4.426600>,
				<0.088369, -0.015850, -0.990479>, <-4.244869, -0.093016, -4.235835>,
				<0.086265, 0.038320, -0.990046>, <-4.934096, 0.268737, -4.953477>
			}
			smooth_triangle {
				<0.088369, -0.015850, -0.990479>, <-4.244869, -0.093016, -4.235835>,
				<0.133223, -0.036780, -0.984894>, <-4.433058, -0.225563, -4.033626>,
				<0.127893, 0.000890, -0.986283>, <-2.915339, -0.001364, -2.736799>
			}
			smooth_triangle {
				<0.093176, -0.063210, -0.988142>, <-4.259802, -0.381761, -4.204709>,
				<0.133223, -0.036780, -0.984894>, <-4.433058, -0.225563, -4.033626>,
				<0.088369, -0.015850, -0.990479>, <-4.244869, -0.093016, -4.235835>
			}
			smooth_triangle {
				<0.093176, -0.063210, -0.988142>, <-4.259802, -0.381761, -4.204709>,
				<0.138437, -0.081880, -0.981450>, <-4.443465, -0.494797, -3.997838>,
				<0.133223, -0.036780, -0.984894>, <-4.433058, -0.225563, -4.033626>
			}
			smooth_triangle {
				<0.093176, -0.063210, -0.988142>, <-4.259802, -0.381761, -4.204709>,
				<0.098795, -0.110770, -0.983406>, <-4.267381, -0.668973, -4.160772>,
				<0.138437, -0.081880, -0.981450>, <-4.443465, -0.494797, -3.997838>
			}
			smooth_triangle {
				<0.047194, -0.042370, -0.992520>, <-4.065055, -0.254771, -4.402244>,
				<0.093176, -0.063210, -0.988142>, <-4.259802, -0.381761, -4.204709>,
				<0.088369, -0.015850, -0.990479>, <-4.244869, -0.093016, -4.235835>
			}
			smooth_triangle {
				<0.093176, -0.063210, -0.988142>, <-4.259802, -0.381761, -4.204709>,
				<0.052341, -0.091370, -0.988953>, <-4.074502, -0.551969, -4.366116>,
				<0.098795, -0.110770, -0.983406>, <-4.267381, -0.668973, -4.160772>
			}
			smooth_triangle {
				<0.047194, -0.042370, -0.992520>, <-4.065055, -0.254771, -4.402244>,
				<0.052341, -0.091370, -0.988953>, <-4.074502, -0.551969, -4.366116>,
				<0.093176, -0.063210, -0.988142>, <-4.259802, -0.381761, -4.204709>
			}
			smooth_triangle {
				<-0.046519, 0.159090, -0.980630>, <-1.771196, 0.426964, -2.382785>,
				<-0.052338, 0.108450, -0.987222>, <-3.584636, 0.650632, -4.764073>,
				<-0.011346, 0.131280, -0.985773>, <-1.863491, 0.347145, -2.324533>
			}
			smooth_triangle {
				<-0.215741, 0.060329, -0.968980>, <-2.758083, 0.365699, -5.313181>,
				<-0.216525, 0.109529, -0.964485>, <-2.741807, 0.661159, -5.292913>,
				<-0.260197, 0.080089, -0.956558>, <-2.932635, 0.557312, -6.328784>
			}
			smooth_triangle {
				<-0.175189, 0.089159, -0.974916>, <-2.968760, 0.539820, -5.183289>,
				<-0.174760, 0.139219, -0.969114>, <-2.951980, 0.837100, -5.152935>,
				<-0.216525, 0.109529, -0.964485>, <-2.741807, 0.661159, -5.292913>
			}
			smooth_triangle {
				<-0.133605, 0.116499, -0.978610>, <-3.174273, 0.709458, -5.038799>,
				<-0.174760, 0.139219, -0.969114>, <-2.951980, 0.837100, -5.152935>,
				<-0.175189, 0.089159, -0.974916>, <-2.968760, 0.539820, -5.183289>
			}
			smooth_triangle {
				<-0.086431, 0.178569, -0.974554>, <-1.125518, 0.318308, -1.621938>,
				<-0.090666, 0.137889, -0.980752>, <-3.378957, 0.828252, -4.885410>,
				<-0.046519, 0.159090, -0.980630>, <-1.771196, 0.426964, -2.382785>
			}
			smooth_triangle {
				<-0.174760, 0.139219, -0.969114>, <-2.951980, 0.837100, -5.152935>,
				<-0.133605, 0.116499, -0.978610>, <-3.174273, 0.709458, -5.038799>,
				<-0.128865, 0.175609, -0.970394>, <-2.113477, 0.614197, -3.339130>
			}
			smooth_triangle {
				<-0.090666, 0.137889, -0.980752>, <-3.378957, 0.828252, -4.885410>,
				<-0.128865, 0.175609, -0.970394>, <-2.113477, 0.614197, -3.339130>,
				<-0.133605, 0.116499, -0.978610>, <-3.174273, 0.709458, -5.038799>
			}
			smooth_triangle {
				<-0.090666, 0.137889, -0.980752>, <-3.378957, 0.828252, -4.885410>,
				<-0.086431, 0.178569, -0.974554>, <-1.125518, 0.318308, -1.621938>,
				<-0.128865, 0.175609, -0.970394>, <-2.113477, 0.614197, -3.339130>
			}
			smooth_triangle {
				<-0.135650, 0.067939, -0.982899>, <-3.178930, 0.415118, -5.069261>,
				<-0.133605, 0.116499, -0.978610>, <-3.174273, 0.709458, -5.038799>,
				<-0.175189, 0.089159, -0.974916>, <-2.968760, 0.539820, -5.183289>
			}
			smooth_triangle {
				<-0.090666, 0.137889, -0.980752>, <-3.378957, 0.828252, -4.885410>,
				<-0.052338, 0.108450, -0.987222>, <-3.584636, 0.650632, -4.764073>,
				<-0.046519, 0.159090, -0.980630>, <-1.771196, 0.426964, -2.382785>
			}
			smooth_triangle {
				<-0.090666, 0.137889, -0.980752>, <-3.378957, 0.828252, -4.885410>,
				<-0.095533, 0.088659, -0.985962>, <-3.384386, 0.539574, -4.922106>,
				<-0.052338, 0.108450, -0.987222>, <-3.584636, 0.650632, -4.764073>
			}
			smooth_triangle {
				<-0.095533, 0.088659, -0.985962>, <-3.384386, 0.539574, -4.922106>,
				<-0.133605, 0.116499, -0.978610>, <-3.174273, 0.709458, -5.038799>,
				<-0.135650, 0.067939, -0.982899>, <-3.178930, 0.415118, -5.069261>
			}
			smooth_triangle {
				<-0.095533, 0.088659, -0.985962>, <-3.384386, 0.539574, -4.922106>,
				<-0.090666, 0.137889, -0.980752>, <-3.378957, 0.828252, -4.885410>,
				<-0.133605, 0.116499, -0.978610>, <-3.174273, 0.709458, -5.038799>
			}
			smooth_triangle {
				<-0.215741, 0.060329, -0.968980>, <-2.758083, 0.365699, -5.313181>,
				<-0.175189, 0.089159, -0.974916>, <-2.968760, 0.539820, -5.183289>,
				<-0.216525, 0.109529, -0.964485>, <-2.741807, 0.661159, -5.292913>
			}
			smooth_triangle {
				<-0.175189, 0.089159, -0.974916>, <-2.968760, 0.539820, -5.183289>,
				<-0.173649, 0.041109, -0.978401>, <-2.987946, 0.248781, -5.194524>,
				<-0.135650, 0.067939, -0.982899>, <-3.178930, 0.415118, -5.069261>
			}
			smooth_triangle {
				<-0.215741, 0.060329, -0.968980>, <-2.758083, 0.365699, -5.313181>,
				<-0.173649, 0.041109, -0.978401>, <-2.987946, 0.248781, -5.194524>,
				<-0.175189, 0.089159, -0.974916>, <-2.968760, 0.539820, -5.183289>
			}
			smooth_triangle {
				<-0.328641, 0.101689, -0.933145>, <-1.445694, 0.422897, -3.704682>,
				<-0.308466, 0.138579, -0.935284>, <-2.198973, 0.810664, -5.521409>,
				<-0.343379, 0.142688, -0.922410>, <-1.341003, 0.574093, -3.721865>
			}
			smooth_triangle {
				<-0.172364, 0.179849, -0.962836>, <-1.447283, 0.503453, -2.578145>,
				<-0.174760, 0.139219, -0.969114>, <-2.951980, 0.837100, -5.152935>,
				<-0.128865, 0.175609, -0.970394>, <-2.113477, 0.614197, -3.339130>
			}
			smooth_triangle {
				<-0.286648, 0.112589, -0.945655>, <-2.341427, 0.679381, -5.480512>,
				<-0.251000, 0.123759, -0.954355>, <-2.123312, 0.622325, -4.481863>,
				<-0.269818, 0.151999, -0.945091>, <-2.423153, 0.920814, -5.409045>
			}
			smooth_triangle {
				<-0.216525, 0.109529, -0.964485>, <-2.741807, 0.661159, -5.292913>,
				<-0.251000, 0.123759, -0.954355>, <-2.123312, 0.622325, -4.481863>,
				<-0.260197, 0.080089, -0.956558>, <-2.932635, 0.557312, -6.328784>
			}
			smooth_triangle {
				<-0.286648, 0.112589, -0.945655>, <-2.341427, 0.679381, -5.480512>,
				<-0.260197, 0.080089, -0.956558>, <-2.932635, 0.557312, -6.328784>,
				<-0.251000, 0.123759, -0.954355>, <-2.123312, 0.622325, -4.481863>
			}
			smooth_triangle {
				<-0.286648, 0.112589, -0.945655>, <-2.341427, 0.679381, -5.480512>,
				<-0.300388, 0.079139, -0.944778>, <-1.896788, 0.397996, -4.607591>,
				<-0.260197, 0.080089, -0.956558>, <-2.932635, 0.557312, -6.328784>
			}
			smooth_triangle {
				<-0.308466, 0.138579, -0.935284>, <-2.198973, 0.810664, -5.521409>,
				<-0.286648, 0.112589, -0.945655>, <-2.341427, 0.679381, -5.480512>,
				<-0.269818, 0.151999, -0.945091>, <-2.423153, 0.920814, -5.409045>
			}
			smooth_triangle {
				<-0.328641, 0.101689, -0.933145>, <-1.445694, 0.422897, -3.704682>,
				<-0.286648, 0.112589, -0.945655>, <-2.341427, 0.679381, -5.480512>,
				<-0.308466, 0.138579, -0.935284>, <-2.198973, 0.810664, -5.521409>
			}
			smooth_triangle {
				<-0.328641, 0.101689, -0.933145>, <-1.445694, 0.422897, -3.704682>,
				<-0.300388, 0.079139, -0.944778>, <-1.896788, 0.397996, -4.607591>,
				<-0.286648, 0.112589, -0.945655>, <-2.341427, 0.679381, -5.480512>
			}
			smooth_triangle {
				<-0.251000, 0.123759, -0.954355>, <-2.123312, 0.622325, -4.481863>,
				<-0.220814, 0.164269, -0.955703>, <-3.587182, 1.311913, -7.025721>,
				<-0.269818, 0.151999, -0.945091>, <-2.423153, 0.920814, -5.409045>
			}
			smooth_triangle {
				<-0.172364, 0.179849, -0.962836>, <-1.447283, 0.503453, -2.578145>,
				<-0.220814, 0.164269, -0.955703>, <-3.587182, 1.311913, -7.025721>,
				<-0.174760, 0.139219, -0.969114>, <-2.951980, 0.837100, -5.152935>
			}
			smooth_triangle {
				<-0.220814, 0.164269, -0.955703>, <-3.587182, 1.311913, -7.025721>,
				<-0.216525, 0.109529, -0.964485>, <-2.741807, 0.661159, -5.292913>,
				<-0.174760, 0.139219, -0.969114>, <-2.951980, 0.837100, -5.152935>
			}
			smooth_triangle {
				<-0.220814, 0.164269, -0.955703>, <-3.587182, 1.311913, -7.025721>,
				<-0.251000, 0.123759, -0.954355>, <-2.123312, 0.622325, -4.481863>,
				<-0.216525, 0.109529, -0.964485>, <-2.741807, 0.661159, -5.292913>
			}
			smooth_triangle {
				<-0.215741, 0.060329, -0.968980>, <-2.758083, 0.365699, -5.313181>,
				<-0.212496, 0.011789, -0.971507>, <-2.783772, 0.070463, -5.311929>,
				<-0.173649, 0.041109, -0.978401>, <-2.987946, 0.248781, -5.194524>
			}
			smooth_triangle {
				<-0.215741, 0.060329, -0.968980>, <-2.758083, 0.365699, -5.313181>,
				<-0.254961, 0.030219, -0.960834>, <-2.549176, 0.183040, -5.425852>,
				<-0.212496, 0.011789, -0.971507>, <-2.783772, 0.070463, -5.311929>
			}
			smooth_triangle {
				<-0.331158, 0.056378, -0.936098>, <-1.434635, 0.216296, -3.726635>,
				<-0.300388, 0.079139, -0.944778>, <-1.896788, 0.397996, -4.607591>,
				<-0.328641, 0.101689, -0.933145>, <-1.445694, 0.422897, -3.704682>
			}
			smooth_triangle {
				<-0.260197, 0.080089, -0.956558>, <-2.932635, 0.557312, -6.328784>,
				<-0.254961, 0.030219, -0.960834>, <-2.549176, 0.183040, -5.425852>,
				<-0.215741, 0.060329, -0.968980>, <-2.758083, 0.365699, -5.313181>
			}
			smooth_triangle {
				<-0.260197, 0.080089, -0.956558>, <-2.932635, 0.557312, -6.328784>,
				<-0.294208, 0.044829, -0.948971>, <-2.327694, 0.268968, -5.521561>,
				<-0.254961, 0.030219, -0.960834>, <-2.549176, 0.183040, -5.425852>
			}
			smooth_triangle {
				<-0.294208, 0.044829, -0.948971>, <-2.327694, 0.268968, -5.521561>,
				<-0.300388, 0.079139, -0.944778>, <-1.896788, 0.397996, -4.607591>,
				<-0.331158, 0.056378, -0.936098>, <-1.434635, 0.216296, -3.726635>
			}
			smooth_triangle {
				<-0.260197, 0.080089, -0.956558>, <-2.932635, 0.557312, -6.328784>,
				<-0.300388, 0.079139, -0.944778>, <-1.896788, 0.397996, -4.607591>,
				<-0.294208, 0.044829, -0.948971>, <-2.327694, 0.268968, -5.521561>
			}
			smooth_triangle {
				<0.133223, -0.036780, -0.984894>, <-4.433058, -0.225563, -4.033626>,
				<0.173159, -0.007440, -0.979321>, <-2.284022, -0.076318, -1.942718>,
				<0.127893, 0.000890, -0.986283>, <-2.915339, -0.001364, -2.736799>
			}
			smooth_triangle {
				<0.173159, -0.007440, -0.979321>, <-2.284022, -0.076318, -1.942718>,
				<0.177363, -0.053010, -0.977157>, <-4.607249, -0.319836, -3.826730>,
				<0.215478, -0.023080, -0.970643>, <-2.363813, -0.122698, -1.842285>
			}
			smooth_triangle {
				<0.177363, -0.053010, -0.977157>, <-4.607249, -0.319836, -3.826730>,
				<0.133223, -0.036780, -0.984894>, <-4.433058, -0.225563, -4.033626>,
				<0.138437, -0.081880, -0.981450>, <-4.443465, -0.494797, -3.997838>
			}
			smooth_triangle {
				<0.133223, -0.036780, -0.984894>, <-4.433058, -0.225563, -4.033626>,
				<0.177363, -0.053010, -0.977157>, <-4.607249, -0.319836, -3.826730>,
				<0.173159, -0.007440, -0.979321>, <-2.284022, -0.076318, -1.942718>
			}
			smooth_triangle {
				<-0.252318, -0.017631, -0.961838>, <-2.563512, -0.108925, -5.420999>,
				<-0.212496, 0.011789, -0.971507>, <-2.783772, 0.070463, -5.311929>,
				<-0.254961, 0.030219, -0.960834>, <-2.549176, 0.183040, -5.425852>
			}
			smooth_triangle {
				<0.052341, -0.091370, -0.988953>, <-4.074502, -0.551969, -4.366116>,
				<0.058094, -0.140650, -0.982828>, <-4.076399, -0.850404, -4.315995>,
				<0.098795, -0.110770, -0.983406>, <-4.267381, -0.668973, -4.160772>
			}
			smooth_triangle {
				<-0.208168, -0.036941, -0.971810>, <-2.805210, -0.225789, -5.296109>,
				<-0.169018, -0.006111, -0.980054>, <-3.016417, -0.039142, -5.183784>,
				<-0.212496, 0.011789, -0.971507>, <-2.783772, 0.070463, -5.311929>
			}
			smooth_triangle {
				<-0.119734, -0.274901, -0.948266>, <-3.120635, -1.658159, -4.844345>,
				<-0.178274, -0.252981, -0.945160>, <-2.833758, -1.526717, -5.058637>,
				<-0.163593, -0.310451, -0.930574>, <-2.854161, -1.866109, -4.932330>
			}
			smooth_triangle {
				<-0.150149, -0.105321, -0.977481>, <-3.096850, -0.641279, -5.095085>,
				<-0.161507, -0.054381, -0.979830>, <-3.050497, -0.332347, -5.152907>,
				<-0.202575, -0.088061, -0.969702>, <-2.821026, -0.536882, -5.264657>
			}
			smooth_triangle {
				<0.010053, -0.120210, -0.987201>, <-3.871683, -0.728150, -4.521809>,
				<-0.035469, -0.149291, -0.982631>, <-3.639813, -0.902858, -4.679490>,
				<0.015617, -0.171670, -0.979482>, <-3.866425, -1.037371, -4.465354>
			}
			smooth_triangle {
				<-0.089981, -0.119571, -0.983219>, <-3.956408, -0.853456, -5.706441>,
				<-0.113250, -0.068171, -0.985716>, <-3.292117, -0.418651, -4.995615>,
				<-0.150149, -0.105321, -0.977481>, <-3.096850, -0.641279, -5.095085>
			}
			smooth_triangle {
				<-0.036522, -0.097291, -0.989097>, <-3.665060, -0.596278, -4.709570>,
				<-0.089981, -0.119571, -0.983219>, <-3.956408, -0.853456, -5.706441>,
				<-0.035469, -0.149291, -0.982631>, <-3.639813, -0.902858, -4.679490>
			}
			smooth_triangle {
				<-0.071720, -0.073851, -0.989195>, <-2.917581, -0.377869, -4.040637>,
				<-0.080640, -0.034121, -0.990678>, <-3.467010, -0.202249, -4.890144>,
				<-0.113250, -0.068171, -0.985716>, <-3.292117, -0.418651, -4.995615>
			}
			smooth_triangle {
				<-0.071720, -0.073851, -0.989195>, <-2.917581, -0.377869, -4.040637>,
				<-0.037865, -0.049900, -0.992565>, <-3.676601, -0.298925, -4.729345>,
				<-0.080640, -0.034121, -0.990678>, <-3.467010, -0.202249, -4.890144>
			}
			smooth_triangle {
				<-0.071720, -0.073851, -0.989195>, <-2.917581, -0.377869, -4.040637>,
				<-0.036522, -0.097291, -0.989097>, <-3.665060, -0.596278, -4.709570>,
				<-0.037865, -0.049900, -0.992565>, <-3.676601, -0.298925, -4.729345>
			}
			smooth_triangle {
				<-0.089981, -0.119571, -0.983219>, <-3.956408, -0.853456, -5.706441>,
				<-0.071720, -0.073851, -0.989195>, <-2.917581, -0.377869, -4.040637>,
				<-0.113250, -0.068171, -0.985716>, <-3.292117, -0.418651, -4.995615>
			}
			smooth_triangle {
				<-0.089981, -0.119571, -0.983219>, <-3.956408, -0.853456, -5.706441>,
				<-0.036522, -0.097291, -0.989097>, <-3.665060, -0.596278, -4.709570>,
				<-0.071720, -0.073851, -0.989195>, <-2.917581, -0.377869, -4.040637>
			}
			smooth_triangle {
				<0.010053, -0.120210, -0.987201>, <-3.871683, -0.728150, -4.521809>,
				<-0.036522, -0.097291, -0.989097>, <-3.665060, -0.596278, -4.709570>,
				<-0.035469, -0.149291, -0.982631>, <-3.639813, -0.902858, -4.679490>
			}
			smooth_triangle {
				<-0.036522, -0.097291, -0.989097>, <-3.665060, -0.596278, -4.709570>,
				<0.006088, -0.070480, -0.992020>, <-3.873957, -0.426378, -4.558577>,
				<-0.037865, -0.049900, -0.992565>, <-3.676601, -0.298925, -4.729345>
			}
			smooth_triangle {
				<0.010053, -0.120210, -0.987201>, <-3.871683, -0.728150, -4.521809>,
				<0.006088, -0.070480, -0.992020>, <-3.873957, -0.426378, -4.558577>,
				<-0.036522, -0.097291, -0.989097>, <-3.665060, -0.596278, -4.709570>
			}
			smooth_triangle {
				<-0.124734, -0.021421, -0.986458>, <-3.246131, -0.131929, -5.041610>,
				<-0.113250, -0.068171, -0.985716>, <-3.292117, -0.418651, -4.995615>,
				<-0.080640, -0.034121, -0.990678>, <-3.467010, -0.202249, -4.890144>
			}
			smooth_triangle {
				<-0.113250, -0.068171, -0.985716>, <-3.292117, -0.418651, -4.995615>,
				<-0.161507, -0.054381, -0.979830>, <-3.050497, -0.332347, -5.152907>,
				<-0.150149, -0.105321, -0.977481>, <-3.096850, -0.641279, -5.095085>
			}
			smooth_triangle {
				<-0.124734, -0.021421, -0.986458>, <-3.246131, -0.131929, -5.041610>,
				<-0.161507, -0.054381, -0.979830>, <-3.050497, -0.332347, -5.152907>,
				<-0.113250, -0.068171, -0.985716>, <-3.292117, -0.418651, -4.995615>
			}
			smooth_triangle {
				<0.058094, -0.140650, -0.982828>, <-4.076399, -0.850404, -4.315995>,
				<0.010053, -0.120210, -0.987201>, <-3.871683, -0.728150, -4.521809>,
				<0.015617, -0.171670, -0.979482>, <-3.866425, -1.037371, -4.465354>
			}
			smooth_triangle {
				<0.010053, -0.120210, -0.987201>, <-3.871683, -0.728150, -4.521809>,
				<0.052341, -0.091370, -0.988953>, <-4.074502, -0.551969, -4.366116>,
				<0.006088, -0.070480, -0.992020>, <-3.873957, -0.426378, -4.558577>
			}
			smooth_triangle {
				<0.058094, -0.140650, -0.982828>, <-4.076399, -0.850404, -4.315995>,
				<0.052341, -0.091370, -0.988953>, <-4.074502, -0.551969, -4.366116>,
				<0.010053, -0.120210, -0.987201>, <-3.871683, -0.728150, -4.521809>
			}
			smooth_triangle {
				<-0.169018, -0.006111, -0.980054>, <-3.016417, -0.039142, -5.183784>,
				<-0.161507, -0.054381, -0.979830>, <-3.050497, -0.332347, -5.152907>,
				<-0.124734, -0.021421, -0.986458>, <-3.246131, -0.131929, -5.041610>
			}
			smooth_triangle {
				<-0.161507, -0.054381, -0.979830>, <-3.050497, -0.332347, -5.152907>,
				<-0.208168, -0.036941, -0.971810>, <-2.805210, -0.225789, -5.296109>,
				<-0.202575, -0.088061, -0.969702>, <-2.821026, -0.536882, -5.264657>
			}
			smooth_triangle {
				<-0.169018, -0.006111, -0.980054>, <-3.016417, -0.039142, -5.183784>,
				<-0.208168, -0.036941, -0.971810>, <-2.805210, -0.225789, -5.296109>,
				<-0.161507, -0.054381, -0.979830>, <-3.050497, -0.332347, -5.152907>
			}
			smooth_triangle {
				<-0.193446, -0.140821, -0.965326>, <-2.849627, -0.846486, -5.208140>,
				<-0.150149, -0.105321, -0.977481>, <-3.096850, -0.641279, -5.095085>,
				<-0.202575, -0.088061, -0.969702>, <-2.821026, -0.536882, -5.264657>
			}
			smooth_triangle {
				<-0.035469, -0.149291, -0.982631>, <-3.639813, -0.902858, -4.679490>,
				<-0.028803, -0.204321, -0.972898>, <-3.635617, -1.232780, -4.606865>,
				<0.015617, -0.171670, -0.979482>, <-3.866425, -1.037371, -4.465354>
			}
			smooth_triangle {
				<-0.083114, -0.181821, -0.974242>, <-3.390211, -1.094295, -4.823395>,
				<-0.130266, -0.217531, -0.961673>, <-3.124431, -1.313175, -4.946695>,
				<-0.074250, -0.238991, -0.962543>, <-3.385746, -1.441576, -4.734568>
			}
			smooth_triangle {
				<-0.139053, -0.160161, -0.971662>, <-3.126643, -0.966208, -5.024643>,
				<-0.089981, -0.119571, -0.983219>, <-3.956408, -0.853456, -5.706441>,
				<-0.150149, -0.105321, -0.977481>, <-3.096850, -0.641279, -5.095085>
			}
			smooth_triangle {
				<-0.139053, -0.160161, -0.971662>, <-3.126643, -0.966208, -5.024643>,
				<-0.083114, -0.181821, -0.974242>, <-3.390211, -1.094295, -4.823395>,
				<-0.089981, -0.119571, -0.983219>, <-3.956408, -0.853456, -5.706441>
			}
			smooth_triangle {
				<-0.139053, -0.160161, -0.971662>, <-3.126643, -0.966208, -5.024643>,
				<-0.130266, -0.217531, -0.961673>, <-3.124431, -1.313175, -4.946695>,
				<-0.083114, -0.181821, -0.974242>, <-3.390211, -1.094295, -4.823395>
			}
			smooth_triangle {
				<-0.193446, -0.140821, -0.965326>, <-2.849627, -0.846486, -5.208140>,
				<-0.139053, -0.160161, -0.971662>, <-3.126643, -0.966208, -5.024643>,
				<-0.150149, -0.105321, -0.977481>, <-3.096850, -0.641279, -5.095085>
			}
			smooth_triangle {
				<-0.139053, -0.160161, -0.971662>, <-3.126643, -0.966208, -5.024643>,
				<-0.185809, -0.195061, -0.957361>, <-2.853201, -1.184945, -5.139304>,
				<-0.130266, -0.217531, -0.961673>, <-3.124431, -1.313175, -4.946695>
			}
			smooth_triangle {
				<-0.193446, -0.140821, -0.965326>, <-2.849627, -0.846486, -5.208140>,
				<-0.185809, -0.195061, -0.957361>, <-2.853201, -1.184945, -5.139304>,
				<-0.139053, -0.160161, -0.971662>, <-3.126643, -0.966208, -5.024643>
			}
			smooth_triangle {
				<-0.028803, -0.204321, -0.972898>, <-3.635617, -1.232780, -4.606865>,
				<-0.083114, -0.181821, -0.974242>, <-3.390211, -1.094295, -4.823395>,
				<-0.074250, -0.238991, -0.962543>, <-3.385746, -1.441576, -4.734568>
			}
			smooth_triangle {
				<-0.083114, -0.181821, -0.974242>, <-3.390211, -1.094295, -4.823395>,
				<-0.035469, -0.149291, -0.982631>, <-3.639813, -0.902858, -4.679490>,
				<-0.089981, -0.119571, -0.983219>, <-3.956408, -0.853456, -5.706441>
			}
			smooth_triangle {
				<-0.028803, -0.204321, -0.972898>, <-3.635617, -1.232780, -4.606865>,
				<-0.035469, -0.149291, -0.982631>, <-3.639813, -0.902858, -4.679490>,
				<-0.083114, -0.181821, -0.974242>, <-3.390211, -1.094295, -4.823395>
			}
			smooth_triangle {
				<-0.178274, -0.252981, -0.945160>, <-2.833758, -1.526717, -5.058637>,
				<-0.130266, -0.217531, -0.961673>, <-3.124431, -1.313175, -4.946695>,
				<-0.185809, -0.195061, -0.957361>, <-2.853201, -1.184945, -5.139304>
			}
			smooth_triangle {
				<-0.130266, -0.217531, -0.961673>, <-3.124431, -1.313175, -4.946695>,
				<-0.119734, -0.274901, -0.948266>, <-3.120635, -1.658159, -4.844345>,
				<-0.074250, -0.238991, -0.962543>, <-3.385746, -1.441576, -4.734568>
			}
			smooth_triangle {
				<-0.178274, -0.252981, -0.945160>, <-2.833758, -1.526717, -5.058637>,
				<-0.119734, -0.274901, -0.948266>, <-3.120635, -1.658159, -4.844345>,
				<-0.130266, -0.217531, -0.961673>, <-3.124431, -1.313175, -4.946695>
			}
			smooth_triangle {
				<-0.252318, -0.017631, -0.961838>, <-2.563512, -0.108925, -5.420999>,
				<-0.208168, -0.036941, -0.971810>, <-2.805210, -0.225789, -5.296109>,
				<-0.212496, 0.011789, -0.971507>, <-2.783772, 0.070463, -5.311929>
			}
			smooth_triangle {
				<-0.249635, -0.066941, -0.960368>, <-2.573940, -0.407285, -5.401550>,
				<-0.208168, -0.036941, -0.971810>, <-2.805210, -0.225789, -5.296109>,
				<-0.252318, -0.017631, -0.961838>, <-2.563512, -0.108925, -5.420999>
			}
			smooth_triangle {
				<-0.249635, -0.066941, -0.960368>, <-2.573940, -0.407285, -5.401550>,
				<-0.202575, -0.088061, -0.969702>, <-2.821026, -0.536882, -5.264657>,
				<-0.208168, -0.036941, -0.971810>, <-2.805210, -0.225789, -5.296109>
			}
			smooth_triangle {
				<-0.250950, -0.123351, -0.954422>, <-2.965234, -0.870773, -6.276673>,
				<-0.202575, -0.088061, -0.969702>, <-2.821026, -0.536882, -5.264657>,
				<-0.249635, -0.066941, -0.960368>, <-2.573940, -0.407285, -5.401550>
			}
			smooth_triangle {
				<-0.250950, -0.123351, -0.954422>, <-2.965234, -0.870773, -6.276673>,
				<-0.193446, -0.140821, -0.965326>, <-2.849627, -0.846486, -5.208140>,
				<-0.202575, -0.088061, -0.969702>, <-2.821026, -0.536882, -5.264657>
			}
			smooth_triangle {
				<-0.230542, -0.172171, -0.952004>, <-2.185178, -0.868003, -4.409659>,
				<-0.193446, -0.140821, -0.965326>, <-2.849627, -0.846486, -5.208140>,
				<-0.250950, -0.123351, -0.954422>, <-2.965234, -0.870773, -6.276673>
			}
			smooth_triangle {
				<-0.230542, -0.172171, -0.952004>, <-2.185178, -0.868003, -4.409659>,
				<-0.185809, -0.195061, -0.957361>, <-2.853201, -1.184945, -5.139304>,
				<-0.193446, -0.140821, -0.965326>, <-2.849627, -0.846486, -5.208140>
			}
			smooth_triangle {
				<-0.241366, -0.225621, -0.938052>, <-2.942951, -1.594018, -6.142718>,
				<-0.185809, -0.195061, -0.957361>, <-2.853201, -1.184945, -5.139304>,
				<-0.230542, -0.172171, -0.952004>, <-2.185178, -0.868003, -4.409659>
			}
			smooth_triangle {
				<-0.241366, -0.225621, -0.938052>, <-2.942951, -1.594018, -6.142718>,
				<-0.178274, -0.252981, -0.945160>, <-2.833758, -1.526717, -5.058637>,
				<-0.185809, -0.195061, -0.957361>, <-2.853201, -1.184945, -5.139304>
			}
			smooth_triangle {
				<-0.226667, -0.292861, -0.923025>, <-1.752943, -1.117414, -3.415345>,
				<-0.178274, -0.252981, -0.945160>, <-2.833758, -1.526717, -5.058637>,
				<-0.241366, -0.225621, -0.938052>, <-2.942951, -1.594018, -6.142718>
			}
			smooth_triangle {
				<-0.226667, -0.292861, -0.923025>, <-1.752943, -1.117414, -3.415345>,
				<-0.163593, -0.310451, -0.930574>, <-2.854161, -1.866109, -4.932330>,
				<-0.178274, -0.252981, -0.945160>, <-2.833758, -1.526717, -5.058637>
			}
			smooth_triangle {
				<-0.226667, -0.292861, -0.923025>, <-1.752943, -1.117414, -3.415345>,
				<-0.196373, -0.340211, -0.913681>, <-1.356199, -1.023891, -2.470715>,
				<-0.163593, -0.310451, -0.930574>, <-2.854161, -1.866109, -4.932330>
			}
			smooth_triangle {
				<-0.288502, -0.089431, -0.947571>, <-1.949050, -0.453202, -4.579633>,
				<-0.337095, -0.080952, -0.932160>, <-2.398784, -0.572011, -6.547507>,
				<-0.309494, -0.129942, -0.936183>, <-2.198629, -0.788489, -5.523256>
			}
			smooth_triangle {
				<-0.293671, -0.045691, -0.949095>, <-2.316616, -0.274422, -5.525024>,
				<-0.337095, -0.080952, -0.932160>, <-2.398784, -0.572011, -6.547507>,
				<-0.288502, -0.089431, -0.947571>, <-1.949050, -0.453202, -4.579633>
			}
			smooth_triangle {
				<-0.337095, -0.080952, -0.932160>, <-2.398784, -0.572011, -6.547507>,
				<-0.293671, -0.045691, -0.949095>, <-2.316616, -0.274422, -5.525024>,
				<-0.338801, -0.021002, -0.934815>, <-2.405005, -0.158106, -6.568790>
			}
			smooth_triangle {
				<-0.293274, 0.001969, -0.950316>, <-2.331397, 0.003444, -5.526110>,
				<-0.338801, -0.021002, -0.934815>, <-2.405005, -0.158106, -6.568790>,
				<-0.293671, -0.045691, -0.949095>, <-2.316616, -0.274422, -5.525024>
			}
			smooth_triangle {
				<-0.293274, 0.001969, -0.950316>, <-2.331397, 0.003444, -5.526110>,
				<-0.323838, 0.021148, -0.940100>, <-1.789041, 0.099973, -4.666297>,
				<-0.338801, -0.021002, -0.934815>, <-2.405005, -0.158106, -6.568790>
			}
			smooth_triangle {
				<-0.249635, -0.066941, -0.960368>, <-2.573940, -0.407285, -5.401550>,
				<-0.293671, -0.045691, -0.949095>, <-2.316616, -0.274422, -5.525024>,
				<-0.288502, -0.089431, -0.947571>, <-1.949050, -0.453202, -4.579633>
			}
			smooth_triangle {
				<-0.293671, -0.045691, -0.949095>, <-2.316616, -0.274422, -5.525024>,
				<-0.252318, -0.017631, -0.961838>, <-2.563512, -0.108925, -5.420999>,
				<-0.293274, 0.001969, -0.950316>, <-2.331397, 0.003444, -5.526110>
			}
			smooth_triangle {
				<-0.249635, -0.066941, -0.960368>, <-2.573940, -0.407285, -5.401550>,
				<-0.252318, -0.017631, -0.961838>, <-2.563512, -0.108925, -5.420999>,
				<-0.293671, -0.045691, -0.949095>, <-2.316616, -0.274422, -5.525024>
			}
			smooth_triangle {
				<-0.288502, -0.089431, -0.947571>, <-1.949050, -0.453202, -4.579633>,
				<-0.250950, -0.123351, -0.954422>, <-2.965234, -0.870773, -6.276673>,
				<-0.249635, -0.066941, -0.960368>, <-2.573940, -0.407285, -5.401550>
			}
			smooth_triangle {
				<-0.230542, -0.172171, -0.952004>, <-2.185178, -0.868003, -4.409659>,
				<-0.250950, -0.123351, -0.954422>, <-2.965234, -0.870773, -6.276673>,
				<-0.279735, -0.175191, -0.938165>, <-2.342641, -1.060461, -5.417225>
			}
			smooth_triangle {
				<-0.250950, -0.123351, -0.954422>, <-2.965234, -0.870773, -6.276673>,
				<-0.309494, -0.129942, -0.936183>, <-2.198629, -0.788489, -5.523256>,
				<-0.279735, -0.175191, -0.938165>, <-2.342641, -1.060461, -5.417225>
			}
			smooth_triangle {
				<-0.250950, -0.123351, -0.954422>, <-2.965234, -0.870773, -6.276673>,
				<-0.288502, -0.089431, -0.947571>, <-1.949050, -0.453202, -4.579633>,
				<-0.309494, -0.129942, -0.936183>, <-2.198629, -0.788489, -5.523256>
			}
			smooth_triangle {
				<-0.254961, 0.030219, -0.960834>, <-2.549176, 0.183040, -5.425852>,
				<-0.293274, 0.001969, -0.950316>, <-2.331397, 0.003444, -5.526110>,
				<-0.252318, -0.017631, -0.961838>, <-2.563512, -0.108925, -5.420999>
			}
			smooth_triangle {
				<-0.293274, 0.001969, -0.950316>, <-2.331397, 0.003444, -5.526110>,
				<-0.294208, 0.044829, -0.948971>, <-2.327694, 0.268968, -5.521561>,
				<-0.323838, 0.021148, -0.940100>, <-1.789041, 0.099973, -4.666297>
			}
			smooth_triangle {
				<-0.254961, 0.030219, -0.960834>, <-2.549176, 0.183040, -5.425852>,
				<-0.294208, 0.044829, -0.948971>, <-2.327694, 0.268968, -5.521561>,
				<-0.293274, 0.001969, -0.950316>, <-2.331397, 0.003444, -5.526110>
			}
			smooth_triangle {
				<-0.374406, -0.053892, -0.919794>, <-0.968423, -0.161548, -2.833907>,
				<-0.337095, -0.080952, -0.932160>, <-2.398784, -0.572011, -6.547507>,
				<-0.338801, -0.021002, -0.934815>, <-2.405005, -0.158106, -6.568790>
			}
			smooth_triangle {
				<-0.309494, -0.129942, -0.936183>, <-2.198629, -0.788489, -5.523256>,
				<-0.335190, -0.176702, -0.919529>, <-1.067499, -0.500906, -2.757684>,
				<-0.279735, -0.175191, -0.938165>, <-2.342641, -1.060461, -5.417225>
			}
			smooth_triangle {
				<-0.309494, -0.129942, -0.936183>, <-2.198629, -0.788489, -5.523256>,
				<-0.362547, -0.133392, -0.916443>, <-0.998545, -0.363473, -2.804737>,
				<-0.335190, -0.176702, -0.919529>, <-1.067499, -0.500906, -2.757684>
			}
			smooth_triangle {
				<-0.337095, -0.080952, -0.932160>, <-2.398784, -0.572011, -6.547507>,
				<-0.362547, -0.133392, -0.916443>, <-0.998545, -0.363473, -2.804737>,
				<-0.309494, -0.129942, -0.936183>, <-2.198629, -0.788489, -5.523256>
			}
			smooth_triangle {
				<-0.337095, -0.080952, -0.932160>, <-2.398784, -0.572011, -6.547507>,
				<-0.388537, -0.092732, -0.910795>, <-0.634016, -0.183815, -1.887797>,
				<-0.362547, -0.133392, -0.916443>, <-0.998545, -0.363473, -2.804737>
			}
			smooth_triangle {
				<-0.374406, -0.053892, -0.919794>, <-0.968423, -0.161548, -2.833907>,
				<-0.388537, -0.092732, -0.910795>, <-0.634016, -0.183815, -1.887797>,
				<-0.337095, -0.080952, -0.932160>, <-2.398784, -0.572011, -6.547507>
			}
			smooth_triangle {
				<-0.241366, -0.225621, -0.938052>, <-2.942951, -1.594018, -6.142718>,
				<-0.277227, -0.266821, -0.917099>, <-0.800651, -0.495914, -1.763867>,
				<-0.226667, -0.292861, -0.923025>, <-1.752943, -1.117414, -3.415345>
			}
			smooth_triangle {
				<-0.307933, -0.222492, -0.919125>, <-1.141542, -0.637834, -2.699130>,
				<-0.279735, -0.175191, -0.938165>, <-2.342641, -1.060461, -5.417225>,
				<-0.335190, -0.176702, -0.919529>, <-1.067499, -0.500906, -2.757684>
			}
			smooth_triangle {
				<-0.277227, -0.266821, -0.917099>, <-0.800651, -0.495914, -1.763867>,
				<-0.241366, -0.225621, -0.938052>, <-2.942951, -1.594018, -6.142718>,
				<-0.307933, -0.222492, -0.919125>, <-1.141542, -0.637834, -2.699130>
			}
			smooth_triangle {
				<-0.241366, -0.225621, -0.938052>, <-2.942951, -1.594018, -6.142718>,
				<-0.279735, -0.175191, -0.938165>, <-2.342641, -1.060461, -5.417225>,
				<-0.307933, -0.222492, -0.919125>, <-1.141542, -0.637834, -2.699130>
			}
			smooth_triangle {
				<-0.241366, -0.225621, -0.938052>, <-2.942951, -1.594018, -6.142718>,
				<-0.230542, -0.172171, -0.952004>, <-2.185178, -0.868003, -4.409659>,
				<-0.279735, -0.175191, -0.938165>, <-2.342641, -1.060461, -5.417225>
			}
			smooth_triangle {
				<-0.338801, -0.021002, -0.934815>, <-2.405005, -0.158106, -6.568790>,
				<-0.385752, -0.013052, -0.916592>, <-0.638965, -0.033570, -1.894733>,
				<-0.374406, -0.053892, -0.919794>, <-0.968423, -0.161548, -2.833907>
			}
			smooth_triangle {
				<-0.338801, -0.021002, -0.934815>, <-2.405005, -0.158106, -6.568790>,
				<-0.360501, 0.023608, -0.926606>, <-1.000774, 0.035307, -2.827330>,
				<-0.385752, -0.013052, -0.916592>, <-0.638965, -0.033570, -1.894733>
			}
			smooth_triangle {
				<-0.331158, 0.056378, -0.936098>, <-1.434635, 0.216296, -3.726635>,
				<-0.323838, 0.021148, -0.940100>, <-1.789041, 0.099973, -4.666297>,
				<-0.294208, 0.044829, -0.948971>, <-2.327694, 0.268968, -5.521561>
			}
			smooth_triangle {
				<-0.323838, 0.021148, -0.940100>, <-1.789041, 0.099973, -4.666297>,
				<-0.360501, 0.023608, -0.926606>, <-1.000774, 0.035307, -2.827330>,
				<-0.338801, -0.021002, -0.934815>, <-2.405005, -0.158106, -6.568790>
			}
			smooth_triangle {
				<-0.323838, 0.021148, -0.940100>, <-1.789041, 0.099973, -4.666297>,
				<-0.331158, 0.056378, -0.936098>, <-1.434635, 0.216296, -3.726635>,
				<-0.360501, 0.023608, -0.926606>, <-1.000774, 0.035307, -2.827330>
			}
			smooth_triangle {
				<-0.308466, 0.138579, -0.935284>, <-2.198973, 0.810664, -5.521409>,
				<-0.294382, 0.175169, -0.933683>, <-1.145426, 0.492389, -2.728039>,
				<-0.326773, 0.147139, -0.927729>, <-1.363226, 0.637591, -3.703682>
			}
			smooth_triangle {
				<-0.269818, 0.151999, -0.945091>, <-2.423153, 0.920814, -5.409045>,
				<-0.294382, 0.175169, -0.933683>, <-1.145426, 0.492389, -2.728039>,
				<-0.308466, 0.138579, -0.935284>, <-2.198973, 0.810664, -5.521409>
			}
			smooth_triangle {
				<-0.269818, 0.151999, -0.945091>, <-2.423153, 0.920814, -5.409045>,
				<-0.256310, 0.197289, -0.940474>, <-1.252174, 0.533206, -2.673126>,
				<-0.294382, 0.175169, -0.933683>, <-1.145426, 0.492389, -2.728039>
			}
			smooth_triangle {
				<-0.220814, 0.164269, -0.955703>, <-3.587182, 1.311913, -7.025721>,
				<-0.256310, 0.197289, -0.940474>, <-1.252174, 0.533206, -2.673126>,
				<-0.269818, 0.151999, -0.945091>, <-2.423153, 0.920814, -5.409045>
			}
			smooth_triangle {
				<-0.221004, 0.203379, -0.948104>, <-0.888790, 0.369769, -1.752822>,
				<-0.256310, 0.197289, -0.940474>, <-1.252174, 0.533206, -2.673126>,
				<-0.220814, 0.164269, -0.955703>, <-3.587182, 1.311913, -7.025721>
			}
			smooth_triangle {
				<-0.172364, 0.179849, -0.962836>, <-1.447283, 0.503453, -2.578145>,
				<-0.202646, 0.208279, -0.951133>, <-0.923122, 0.368318, -1.735545>,
				<-0.220814, 0.164269, -0.955703>, <-3.587182, 1.311913, -7.025721>
			}
			smooth_triangle {
				<-0.202646, 0.208279, -0.951133>, <-0.923122, 0.368318, -1.735545>,
				<-0.221004, 0.203379, -0.948104>, <-0.888790, 0.369769, -1.752822>,
				<-0.220814, 0.164269, -0.955703>, <-3.587182, 1.311913, -7.025721>
			}
			smooth_triangle {
				<-0.362620, 0.144548, -0.914724>, <-1.552440, 0.783678, -4.685456>,
				<-0.370498, 0.128218, -0.914001>, <-0.611004, 0.277069, -1.883783>,
				<-0.343379, 0.142688, -0.922410>, <-1.341003, 0.574093, -3.721865>
			}
			smooth_triangle {
				<-0.362620, 0.144548, -0.914724>, <-1.552440, 0.783678, -4.685456>,
				<-0.405001, 0.143188, -0.896982>, <-1.112073, 0.604842, -3.793678>,
				<-0.370498, 0.128218, -0.914001>, <-0.611004, 0.277069, -1.883783>
			}
			smooth_triangle {
				<-0.326773, 0.147139, -0.927729>, <-1.363226, 0.637591, -3.703682>,
				<-0.362620, 0.144548, -0.914724>, <-1.552440, 0.783678, -4.685456>,
				<-0.343379, 0.142688, -0.922410>, <-1.341003, 0.574093, -3.721865>
			}
			smooth_triangle {
				<-0.343379, 0.142688, -0.922410>, <-1.341003, 0.574093, -3.721865>,
				<-0.308466, 0.138579, -0.935284>, <-2.198973, 0.810664, -5.521409>,
				<-0.326773, 0.147139, -0.927729>, <-1.363226, 0.637591, -3.703682>
			}
			smooth_triangle {
				<-0.366577, 0.161468, -0.910308>, <-0.901946, 0.466856, -2.822110>,
				<-0.362620, 0.144548, -0.914724>, <-1.552440, 0.783678, -4.685456>,
				<-0.326773, 0.147139, -0.927729>, <-1.363226, 0.637591, -3.703682>
			}
			smooth_triangle {
				<-0.407609, 0.166128, -0.891829>, <-0.777920, 0.497039, -2.853597>,
				<-0.405001, 0.143188, -0.896982>, <-1.112073, 0.604842, -3.793678>,
				<-0.366577, 0.161468, -0.910308>, <-0.901946, 0.466856, -2.822110>
			}
			smooth_triangle {
				<-0.405001, 0.143188, -0.896982>, <-1.112073, 0.604842, -3.793678>,
				<-0.362620, 0.144548, -0.914724>, <-1.552440, 0.783678, -4.685456>,
				<-0.366577, 0.161468, -0.910308>, <-0.901946, 0.466856, -2.822110>
			}
			smooth_triangle {
				<-0.460705, 0.216468, -0.854404>, <-0.390177, 0.412298, -1.917264>,
				<-0.490073, 0.226598, -0.835218>, <-0.174438, 0.202119, -0.963701>,
				<-0.459163, 0.195508, -0.860267>, <-0.612600, 0.598253, -2.874315>
			}
			smooth_triangle {
				<-0.407609, 0.166128, -0.891829>, <-0.777920, 0.497039, -2.853597>,
				<-0.436220, 0.164298, -0.878539>, <-0.976764, 0.705079, -3.813453>,
				<-0.405001, 0.143188, -0.896982>, <-1.112073, 0.604842, -3.793678>
			}
			smooth_triangle {
				<-0.421176, 0.209318, -0.876307>, <-0.730337, 0.590059, -2.848388>,
				<-0.436220, 0.164298, -0.878539>, <-0.976764, 0.705079, -3.813453>,
				<-0.407609, 0.166128, -0.891829>, <-0.777920, 0.497039, -2.853597>
			}
			smooth_triangle {
				<-0.428803, 0.203088, -0.874072>, <-0.923179, 0.800654, -3.807482>,
				<-0.460705, 0.216468, -0.854404>, <-0.390177, 0.412298, -1.917264>,
				<-0.459163, 0.195508, -0.860267>, <-0.612600, 0.598253, -2.874315>
			}
			smooth_triangle {
				<-0.428803, 0.203088, -0.874072>, <-0.923179, 0.800654, -3.807482>,
				<-0.421176, 0.209318, -0.876307>, <-0.730337, 0.590059, -2.848388>,
				<-0.416453, 0.228588, -0.873743>, <-0.224675, 0.223152, -0.948538>
			}
			smooth_triangle {
				<-0.421176, 0.209318, -0.876307>, <-0.730337, 0.590059, -2.848388>,
				<-0.428803, 0.203088, -0.874072>, <-0.923179, 0.800654, -3.807482>,
				<-0.436220, 0.164298, -0.878539>, <-0.976764, 0.705079, -3.813453>
			}
			smooth_triangle {
				<-0.428803, 0.203088, -0.874072>, <-0.923179, 0.800654, -3.807482>,
				<-0.459163, 0.195508, -0.860267>, <-0.612600, 0.598253, -2.874315>,
				<-0.436220, 0.164298, -0.878539>, <-0.976764, 0.705079, -3.813453>
			}
			smooth_triangle {
				<-0.444243, 0.504618, -0.732886>, <-0.520783, 2.042348, -3.399413>,
				<-0.430673, 0.519468, -0.730606>, <-0.844709, 3.135727, -5.044598>,
				<-0.448401, 0.517128, -0.721552>, <-0.724137, 3.122670, -5.071397>
			}
			smooth_triangle {
				<-0.448401, 0.517128, -0.721552>, <-0.724137, 3.122670, -5.071397>,
				<-0.435822, 0.535968, -0.715476>, <-0.758524, 3.236238, -4.994442>,
				<-0.455338, 0.531068, -0.706919>, <-0.637403, 3.206810, -5.030279>
			}
			smooth_triangle {
				<-0.455338, 0.531068, -0.706919>, <-0.637403, 3.206810, -5.030279>,
				<-0.435822, 0.535968, -0.715476>, <-0.758524, 3.236238, -4.994442>,
				<-0.442822, 0.554308, -0.696966>, <-0.771405, 3.900137, -5.760509>
			}
			smooth_triangle {
				<-0.398549, 0.646709, -0.641901>, <-0.635912, 3.901573, -4.512307>,
				<-0.376263, 0.650409, -0.651543>, <-0.789352, 3.924261, -4.468478>,
				<-0.381200, 0.667209, -0.631369>, <-0.566885, 3.355325, -3.662335>
			}
			smooth_triangle {
				<-0.369978, 0.691019, -0.612145>, <-0.657978, 4.172128, -4.259680>,
				<-0.342029, 0.701479, -0.616486>, <-0.811377, 4.234702, -4.170296>,
				<-0.352617, 0.721069, -0.587224>, <-0.545194, 3.610073, -3.414316>
			}
			smooth_triangle {
				<-0.352617, 0.721069, -0.587224>, <-0.545194, 3.610073, -3.414316>,
				<-0.342029, 0.701479, -0.616486>, <-0.811377, 4.234702, -4.170296>,
				<-0.318892, 0.734509, -0.589846>, <-0.420759, 2.169548, -2.028661>
			}
			smooth_triangle {
				<-0.342029, 0.701479, -0.616486>, <-0.811377, 4.234702, -4.170296>,
				<-0.316213, 0.706889, -0.624037>, <-0.442415, 2.144701, -2.049765>,
				<-0.318892, 0.734509, -0.589846>, <-0.420759, 2.169548, -2.028661>
			}
			smooth_triangle {
				<-0.296302, 0.706479, -0.634191>, <-0.568875, 2.118526, -2.046309>,
				<-0.279024, 0.704699, -0.643937>, <-0.588113, 2.116101, -2.043301>,
				<-0.280950, 0.719949, -0.625978>, <-0.371841, 1.448733, -1.327461>
			}
			smooth_triangle {
				<-0.270442, 0.738789, -0.608413>, <-0.548884, 2.246208, -1.910634>,
				<-0.244934, 0.741999, -0.615274>, <-1.034841, 3.752084, -3.137534>,
				<-0.252423, 0.765069, -0.583143>, <-1.256896, 5.384089, -4.290484>
			}
			smooth_triangle {
				<-0.244934, 0.741999, -0.615274>, <-1.034841, 3.752084, -3.137534>,
				<-0.227916, 0.762079, -0.596984>, <-1.252663, 4.597092, -3.645323>,
				<-0.252423, 0.765069, -0.583143>, <-1.256896, 5.384089, -4.290484>
			}
			smooth_triangle {
				<-0.227916, 0.762079, -0.596984>, <-1.252663, 4.597092, -3.645323>,
				<-0.227827, 0.777179, -0.577230>, <-0.790354, 3.116961, -2.378153>,
				<-0.252423, 0.765069, -0.583143>, <-1.256896, 5.384089, -4.290484>
			}
			smooth_triangle {
				<-0.252423, 0.765069, -0.583143>, <-1.256896, 5.384089, -4.290484>,
				<-0.284633, 0.755119, -0.581284>, <-0.610539, 3.069061, -2.489805>,
				<-0.270442, 0.738789, -0.608413>, <-0.548884, 2.246208, -1.910634>
			}
			smooth_triangle {
				<-0.318892, 0.734509, -0.589846>, <-0.420759, 2.169548, -2.028661>,
				<-0.316213, 0.706889, -0.624037>, <-0.442415, 2.144701, -2.049765>,
				<-0.294821, 0.727199, -0.611036>, <-0.330489, 1.459039, -1.326885>
			}
			smooth_triangle {
				<-0.270442, 0.738789, -0.608413>, <-0.548884, 2.246208, -1.910634>,
				<-0.294821, 0.727199, -0.611036>, <-0.330489, 1.459039, -1.326885>,
				<-0.280950, 0.719949, -0.625978>, <-0.371841, 1.448733, -1.327461>
			}
			smooth_triangle {
				<-0.279024, 0.704699, -0.643937>, <-0.588113, 2.116101, -2.043301>,
				<-0.296302, 0.706479, -0.634191>, <-0.568875, 2.118526, -2.046309>,
				<-0.295156, 0.688509, -0.654186>, <-1.174255, 4.153194, -4.167071>
			}
			smooth_triangle {
				<-0.369978, 0.691019, -0.612145>, <-0.657978, 4.172128, -4.259680>,
				<-0.359611, 0.674099, -0.636692>, <-0.812412, 4.069101, -4.332461>,
				<-0.342029, 0.701479, -0.616486>, <-0.811377, 4.234702, -4.170296>
			}
			smooth_triangle {
				<-0.313001, 0.672289, -0.662696>, <-1.119105, 4.052774, -4.279466>,
				<-0.310832, 0.690819, -0.644413>, <-0.547592, 2.070809, -2.100126>,
				<-0.332815, 0.679269, -0.645705>, <-0.959752, 4.083667, -4.288360>
			}
			smooth_triangle {
				<-0.332815, 0.679269, -0.645705>, <-0.959752, 4.083667, -4.288360>,
				<-0.342029, 0.701479, -0.616486>, <-0.811377, 4.234702, -4.170296>,
				<-0.359611, 0.674099, -0.636692>, <-0.812412, 4.069101, -4.332461>
			}
			smooth_triangle {
				<-0.342029, 0.701479, -0.616486>, <-0.811377, 4.234702, -4.170296>,
				<-0.332815, 0.679269, -0.645705>, <-0.959752, 4.083667, -4.288360>,
				<-0.316213, 0.706889, -0.624037>, <-0.442415, 2.144701, -2.049765>
			}
			smooth_triangle {
				<-0.313001, 0.672289, -0.662696>, <-1.119105, 4.052774, -4.279466>,
				<-0.295156, 0.688509, -0.654186>, <-1.174255, 4.153194, -4.167071>,
				<-0.310832, 0.690819, -0.644413>, <-0.547592, 2.070809, -2.100126>
			}
			smooth_triangle {
				<-0.310832, 0.690819, -0.644413>, <-0.547592, 2.070809, -2.100126>,
				<-0.295156, 0.688509, -0.654186>, <-1.174255, 4.153194, -4.167071>,
				<-0.296302, 0.706479, -0.634191>, <-0.568875, 2.118526, -2.046309>
			}
			smooth_triangle {
				<-0.313001, 0.672289, -0.662696>, <-1.119105, 4.052774, -4.279466>,
				<-0.332815, 0.679269, -0.645705>, <-0.959752, 4.083667, -4.288360>,
				<-0.332217, 0.653639, -0.671937>, <-1.066105, 3.944491, -4.392436>
			}
			smooth_triangle {
				<-0.359611, 0.674099, -0.636692>, <-0.812412, 4.069101, -4.332461>,
				<-0.353958, 0.653889, -0.660494>, <-0.927364, 3.947206, -4.421360>,
				<-0.332815, 0.679269, -0.645705>, <-0.959752, 4.083667, -4.288360>
			}
			smooth_triangle {
				<-0.332815, 0.679269, -0.645705>, <-0.959752, 4.083667, -4.288360>,
				<-0.353958, 0.653889, -0.660494>, <-0.927364, 3.947206, -4.421360>,
				<-0.332217, 0.653639, -0.671937>, <-1.066105, 3.944491, -4.392436>
			}
			smooth_triangle {
				<-0.353958, 0.653889, -0.660494>, <-0.927364, 3.947206, -4.421360>,
				<-0.359611, 0.674099, -0.636692>, <-0.812412, 4.069101, -4.332461>,
				<-0.376263, 0.650409, -0.651543>, <-0.789352, 3.924261, -4.468478>
			}
			smooth_triangle {
				<-0.369978, 0.691019, -0.612145>, <-0.657978, 4.172128, -4.259680>,
				<-0.381200, 0.667209, -0.631369>, <-0.566885, 3.355325, -3.662335>,
				<-0.359611, 0.674099, -0.636692>, <-0.812412, 4.069101, -4.332461>
			}
			smooth_triangle {
				<-0.359611, 0.674099, -0.636692>, <-0.812412, 4.069101, -4.332461>,
				<-0.381200, 0.667209, -0.631369>, <-0.566885, 3.355325, -3.662335>,
				<-0.376263, 0.650409, -0.651543>, <-0.789352, 3.924261, -4.468478>
			}
			smooth_triangle {
				<-0.332217, 0.653639, -0.671937>, <-1.066105, 3.944491, -4.392436>,
				<-0.353958, 0.653889, -0.660494>, <-0.927364, 3.947206, -4.421360>,
				<-0.350645, 0.632689, -0.682542>, <-1.026834, 3.817895, -4.512189>
			}
			smooth_triangle {
				<-0.403519, 0.576578, -0.702741>, <-0.857174, 3.480175, -4.810863>,
				<-0.424504, 0.576058, -0.690693>, <-0.720102, 3.477027, -4.835574>,
				<-0.420690, 0.556108, -0.709141>, <-0.803532, 3.356186, -4.907341>
			}
			smooth_triangle {
				<-0.420690, 0.556108, -0.709141>, <-0.803532, 3.356186, -4.907341>,
				<-0.442822, 0.554308, -0.696966>, <-0.771405, 3.900137, -5.760509>,
				<-0.435822, 0.535968, -0.715476>, <-0.758524, 3.236238, -4.994442>
			}
			smooth_triangle {
				<-0.420690, 0.556108, -0.709141>, <-0.803532, 3.356186, -4.907341>,
				<-0.424504, 0.576058, -0.690693>, <-0.720102, 3.477027, -4.835574>,
				<-0.442822, 0.554308, -0.696966>, <-0.771405, 3.900137, -5.760509>
			}
			smooth_triangle {
				<-0.424504, 0.576058, -0.690693>, <-0.720102, 3.477027, -4.835574>,
				<-0.442261, 0.573778, -0.681393>, <-0.501637, 2.886627, -4.051014>,
				<-0.442822, 0.554308, -0.696966>, <-0.771405, 3.900137, -5.760509>
			}
			smooth_triangle {
				<-0.403519, 0.576578, -0.702741>, <-0.857174, 3.480175, -4.810863>,
				<-0.405487, 0.600719, -0.681051>, <-0.888718, 4.227393, -5.506794>,
				<-0.424504, 0.576058, -0.690693>, <-0.720102, 3.477027, -4.835574>
			}
			smooth_triangle {
				<-0.405487, 0.600719, -0.681051>, <-0.888718, 4.227393, -5.506794>,
				<-0.431138, 0.594108, -0.671015>, <-0.608693, 3.588301, -4.768982>,
				<-0.424504, 0.576058, -0.690693>, <-0.720102, 3.477027, -4.835574>
			}
			smooth_triangle {
				<-0.442261, 0.573778, -0.681393>, <-0.501637, 2.886627, -4.051014>,
				<-0.424504, 0.576058, -0.690693>, <-0.720102, 3.477027, -4.835574>,
				<-0.431138, 0.594108, -0.671015>, <-0.608693, 3.588301, -4.768982>
			}
			smooth_triangle {
				<-0.403519, 0.576578, -0.702741>, <-0.857174, 3.480175, -4.810863>,
				<-0.385337, 0.595349, -0.697268>, <-0.921960, 3.589845, -4.717509>,
				<-0.405487, 0.600719, -0.681051>, <-0.888718, 4.227393, -5.506794>
			}
			smooth_triangle {
				<-0.405487, 0.600719, -0.681051>, <-0.888718, 4.227393, -5.506794>,
				<-0.385337, 0.595349, -0.697268>, <-0.921960, 3.589845, -4.717509>,
				<-0.384472, 0.613859, -0.681519>, <-0.718937, 3.085486, -3.867495>
			}
			smooth_triangle {
				<-0.431138, 0.594108, -0.671015>, <-0.608693, 3.588301, -4.768982>,
				<-0.405487, 0.600719, -0.681051>, <-0.888718, 4.227393, -5.506794>,
				<-0.415678, 0.620329, -0.656900>, <-0.623707, 3.742263, -4.646939>
			}
			smooth_triangle {
				<-0.384472, 0.613859, -0.681519>, <-0.718937, 3.085486, -3.867495>,
				<-0.392105, 0.627519, -0.664527>, <-0.757628, 3.785255, -4.592118>,
				<-0.405487, 0.600719, -0.681051>, <-0.888718, 4.227393, -5.506794>
			}
			smooth_triangle {
				<-0.405487, 0.600719, -0.681051>, <-0.888718, 4.227393, -5.506794>,
				<-0.392105, 0.627519, -0.664527>, <-0.757628, 3.785255, -4.592118>,
				<-0.415678, 0.620329, -0.656900>, <-0.623707, 3.742263, -4.646939>
			}
			smooth_triangle {
				<-0.392105, 0.627519, -0.664527>, <-0.757628, 3.785255, -4.592118>,
				<-0.384472, 0.613859, -0.681519>, <-0.718937, 3.085486, -3.867495>,
				<-0.371027, 0.632049, -0.672280>, <-0.894347, 3.815307, -4.542605>
			}
			smooth_triangle {
				<-0.385337, 0.595349, -0.697268>, <-0.921960, 3.589845, -4.717509>,
				<-0.367769, 0.613099, -0.691344>, <-0.984230, 3.699000, -4.619638>,
				<-0.384472, 0.613859, -0.681519>, <-0.718937, 3.085486, -3.867495>
			}
			smooth_triangle {
				<-0.384472, 0.613859, -0.681519>, <-0.718937, 3.085486, -3.867495>,
				<-0.367769, 0.613099, -0.691344>, <-0.984230, 3.699000, -4.619638>,
				<-0.371027, 0.632049, -0.672280>, <-0.894347, 3.815307, -4.542605>
			}
			smooth_triangle {
				<-0.415678, 0.620329, -0.656900>, <-0.623707, 3.742263, -4.646939>,
				<-0.392105, 0.627519, -0.664527>, <-0.757628, 3.785255, -4.592118>,
				<-0.398549, 0.646709, -0.641901>, <-0.635912, 3.901573, -4.512307>
			}
			smooth_triangle {
				<-0.371027, 0.632049, -0.672280>, <-0.894347, 3.815307, -4.542605>,
				<-0.376263, 0.650409, -0.651543>, <-0.789352, 3.924261, -4.468478>,
				<-0.392105, 0.627519, -0.664527>, <-0.757628, 3.785255, -4.592118>
			}
			smooth_triangle {
				<-0.392105, 0.627519, -0.664527>, <-0.757628, 3.785255, -4.592118>,
				<-0.376263, 0.650409, -0.651543>, <-0.789352, 3.924261, -4.468478>,
				<-0.398549, 0.646709, -0.641901>, <-0.635912, 3.901573, -4.512307>
			}
			smooth_triangle {
				<-0.376263, 0.650409, -0.651543>, <-0.789352, 3.924261, -4.468478>,
				<-0.371027, 0.632049, -0.672280>, <-0.894347, 3.815307, -4.542605>,
				<-0.353958, 0.653889, -0.660494>, <-0.927364, 3.947206, -4.421360>
			}
			smooth_triangle {
				<-0.367769, 0.613099, -0.691344>, <-0.984230, 3.699000, -4.619638>,
				<-0.350645, 0.632689, -0.682542>, <-1.026834, 3.817895, -4.512189>,
				<-0.371027, 0.632049, -0.672280>, <-0.894347, 3.815307, -4.542605>
			}
			smooth_triangle {
				<-0.371027, 0.632049, -0.672280>, <-0.894347, 3.815307, -4.542605>,
				<-0.350645, 0.632689, -0.682542>, <-1.026834, 3.817895, -4.512189>,
				<-0.353958, 0.653889, -0.660494>, <-0.927364, 3.947206, -4.421360>
			}
			smooth_triangle {
				<-0.227827, 0.777179, -0.577230>, <-0.790354, 3.116961, -2.378153>,
				<-0.243277, 0.790689, -0.552035>, <-0.491866, 2.370763, -1.770169>,
				<-0.252423, 0.765069, -0.583143>, <-1.256896, 5.384089, -4.290484>
			}
			smooth_triangle {
				<-0.243277, 0.790689, -0.552035>, <-0.491866, 2.370763, -1.770169>,
				<-0.266572, 0.789959, -0.542226>, <-1.012698, 5.553831, -4.134722>,
				<-0.252423, 0.765069, -0.583143>, <-1.256896, 5.384089, -4.290484>
			}
			smooth_triangle {
				<-0.252423, 0.765069, -0.583143>, <-1.256896, 5.384089, -4.290484>,
				<-0.266572, 0.789959, -0.542226>, <-1.012698, 5.553831, -4.134722>,
				<-0.284633, 0.755119, -0.581284>, <-0.610539, 3.069061, -2.489805>
			}
			smooth_triangle {
				<-0.284633, 0.755119, -0.581284>, <-0.610539, 3.069061, -2.489805>,
				<-0.266572, 0.789959, -0.542226>, <-1.012698, 5.553831, -4.134722>,
				<-0.302182, 0.772349, -0.548883>, <-0.602204, 3.899534, -3.067802>
			}
			smooth_triangle {
				<-0.227916, 0.762079, -0.596984>, <-1.252663, 4.597092, -3.645323>,
				<-0.244934, 0.741999, -0.615274>, <-1.034841, 3.752084, -3.137534>,
				<-0.225144, 0.748699, -0.614714>, <-1.112958, 3.765021, -3.095436>
			}
			smooth_triangle {
				<-0.448401, 0.517128, -0.721552>, <-0.724137, 3.122670, -5.071397>,
				<-0.430673, 0.519468, -0.730606>, <-0.844709, 3.135727, -5.044598>,
				<-0.435822, 0.535968, -0.715476>, <-0.758524, 3.236238, -4.994442>
			}
			smooth_triangle {
				<-0.294168, 0.669389, -0.674166>, <-1.253893, 4.037537, -4.256506>,
				<-0.313001, 0.672289, -0.662696>, <-1.119105, 4.052774, -4.279466>,
				<-0.311842, 0.651259, -0.683903>, <-1.208367, 3.928227, -4.370349>
			}
			smooth_triangle {
				<-0.313001, 0.672289, -0.662696>, <-1.119105, 4.052774, -4.279466>,
				<-0.332217, 0.653639, -0.671937>, <-1.066105, 3.944491, -4.392436>,
				<-0.311842, 0.651259, -0.683903>, <-1.208367, 3.928227, -4.370349>
			}
			smooth_triangle {
				<-0.311842, 0.651259, -0.683903>, <-1.208367, 3.928227, -4.370349>,
				<-0.332217, 0.653639, -0.671937>, <-1.066105, 3.944491, -4.392436>,
				<-0.329786, 0.631309, -0.694118>, <-1.168416, 3.808012, -4.485959>
			}
			smooth_triangle {
				<-0.332217, 0.653639, -0.671937>, <-1.066105, 3.944491, -4.392436>,
				<-0.350645, 0.632689, -0.682542>, <-1.026834, 3.817895, -4.512189>,
				<-0.329786, 0.631309, -0.694118>, <-1.168416, 3.808012, -4.485959>
			}
			smooth_triangle {
				<-0.329786, 0.631309, -0.694118>, <-1.168416, 3.808012, -4.485959>,
				<-0.350645, 0.632689, -0.682542>, <-1.026834, 3.817895, -4.512189>,
				<-0.348073, 0.611249, -0.703093>, <-1.120021, 3.688454, -4.596888>
			}
			smooth_triangle {
				<-0.350645, 0.632689, -0.682542>, <-1.026834, 3.817895, -4.512189>,
				<-0.367769, 0.613099, -0.691344>, <-0.984230, 3.699000, -4.619638>,
				<-0.348073, 0.611249, -0.703093>, <-1.120021, 3.688454, -4.596888>
			}
			smooth_triangle {
				<-0.348073, 0.611249, -0.703093>, <-1.120021, 3.688454, -4.596888>,
				<-0.367769, 0.613099, -0.691344>, <-0.984230, 3.699000, -4.619638>,
				<-0.366201, 0.592659, -0.709761>, <-1.059534, 3.575495, -4.699484>
			}
			smooth_triangle {
				<-0.383624, 0.574499, -0.715466>, <-1.000808, 3.466793, -4.792900>,
				<-0.403519, 0.576578, -0.702741>, <-0.857174, 3.480175, -4.810863>,
				<-0.400352, 0.555858, -0.721011>, <-0.944774, 3.354389, -4.883406>
			}
			smooth_triangle {
				<-0.416078, 0.537198, -0.726234>, <-0.893117, 3.241803, -4.968490>,
				<-0.435822, 0.535968, -0.715476>, <-0.758524, 3.236238, -4.994442>,
				<-0.430673, 0.519468, -0.730606>, <-0.844709, 3.135727, -5.044598>
			}
			smooth_triangle {
				<-0.435822, 0.535968, -0.715476>, <-0.758524, 3.236238, -4.994442>,
				<-0.416078, 0.537198, -0.726234>, <-0.893117, 3.241803, -4.968490>,
				<-0.420690, 0.556108, -0.709141>, <-0.803532, 3.356186, -4.907341>
			}
			smooth_triangle {
				<-0.420690, 0.556108, -0.709141>, <-0.803532, 3.356186, -4.907341>,
				<-0.400352, 0.555858, -0.721011>, <-0.944774, 3.354389, -4.883406>,
				<-0.403519, 0.576578, -0.702741>, <-0.857174, 3.480175, -4.810863>
			}
			smooth_triangle {
				<-0.420690, 0.556108, -0.709141>, <-0.803532, 3.356186, -4.907341>,
				<-0.416078, 0.537198, -0.726234>, <-0.893117, 3.241803, -4.968490>,
				<-0.400352, 0.555858, -0.721011>, <-0.944774, 3.354389, -4.883406>
			}
			smooth_triangle {
				<-0.403519, 0.576578, -0.702741>, <-0.857174, 3.480175, -4.810863>,
				<-0.383624, 0.574499, -0.715466>, <-1.000808, 3.466793, -4.792900>,
				<-0.385337, 0.595349, -0.697268>, <-0.921960, 3.589845, -4.717509>
			}
			smooth_triangle {
				<-0.385337, 0.595349, -0.697268>, <-0.921960, 3.589845, -4.717509>,
				<-0.366201, 0.592659, -0.709761>, <-1.059534, 3.575495, -4.699484>,
				<-0.367769, 0.613099, -0.691344>, <-0.984230, 3.699000, -4.619638>
			}
			smooth_triangle {
				<-0.385337, 0.595349, -0.697268>, <-0.921960, 3.589845, -4.717509>,
				<-0.383624, 0.574499, -0.715466>, <-1.000808, 3.466793, -4.792900>,
				<-0.366201, 0.592659, -0.709761>, <-1.059534, 3.575495, -4.699484>
			}
			smooth_triangle {
				<-0.313001, 0.672289, -0.662696>, <-1.119105, 4.052774, -4.279466>,
				<-0.294168, 0.669389, -0.674166>, <-1.253893, 4.037537, -4.256506>,
				<-0.295156, 0.688509, -0.654186>, <-1.174255, 4.153194, -4.167071>
			}
			smooth_triangle {
				<-0.294168, 0.669389, -0.674166>, <-1.253893, 4.037537, -4.256506>,
				<-0.276851, 0.686559, -0.664154>, <-0.857234, 2.758714, -2.766079>,
				<-0.295156, 0.688509, -0.654186>, <-1.174255, 4.153194, -4.167071>
			}
			smooth_triangle {
				<-0.295156, 0.688509, -0.654186>, <-1.174255, 4.153194, -4.167071>,
				<-0.276851, 0.686559, -0.664154>, <-0.857234, 2.758714, -2.766079>,
				<-0.279024, 0.704699, -0.643937>, <-0.588113, 2.116101, -2.043301>
			}
			smooth_triangle {
				<-0.244816, 0.721179, -0.639589>, <-0.685281, 2.183428, -1.939485>,
				<-0.228782, 0.734609, -0.630173>, <-1.379917, 4.430002, -3.803321>,
				<-0.244934, 0.741999, -0.615274>, <-1.034841, 3.752084, -3.137534>
			}
			smooth_triangle {
				<-0.228782, 0.734609, -0.630173>, <-1.379917, 4.430002, -3.803321>,
				<-0.225144, 0.748699, -0.614714>, <-1.112958, 3.765021, -3.095436>,
				<-0.244934, 0.741999, -0.615274>, <-1.034841, 3.752084, -3.137534>
			}
			smooth_triangle {
				<-0.455338, 0.531068, -0.706919>, <-0.637403, 3.206810, -5.030279>,
				<-0.442822, 0.554308, -0.696966>, <-0.771405, 3.900137, -5.760509>,
				<-0.464222, 0.544008, -0.691137>, <-0.536256, 3.280450, -4.994432>
			}
			smooth_triangle {
				<-0.336269, 0.753879, -0.554704>, <-0.492812, 3.809142, -3.198336>,
				<-0.364281, 0.735629, -0.561485>, <-0.405011, 3.700373, -3.335946>,
				<-0.352617, 0.721069, -0.587224>, <-0.545194, 3.610073, -3.414316>
			}
			smooth_triangle {
				<-0.431138, 0.594108, -0.671015>, <-0.608693, 3.588301, -4.768982>,
				<-0.415678, 0.620329, -0.656900>, <-0.623707, 3.742263, -4.646939>,
				<-0.441373, 0.611128, -0.648707>, <-0.472977, 3.687496, -4.708000>
			}
			smooth_triangle {
				<-0.390006, 0.728249, -0.553762>, <-0.338311, 4.395231, -4.067389>,
				<-0.412641, 0.694319, -0.580302>, <-0.343543, 4.189114, -4.279270>,
				<-0.382081, 0.707579, -0.585202>, <-0.497492, 4.265345, -4.188107>
			}
			smooth_triangle {
				<-0.415678, 0.620329, -0.656900>, <-0.623707, 3.742263, -4.646939>,
				<-0.398549, 0.646709, -0.641901>, <-0.635912, 3.901573, -4.512307>,
				<-0.423883, 0.640489, -0.631831>, <-0.488181, 3.866440, -4.560312>
			}
			smooth_triangle {
				<-0.412641, 0.694319, -0.580302>, <-0.343543, 4.189114, -4.279270>,
				<-0.433272, 0.660869, -0.603862>, <-0.340207, 3.988372, -4.467444>,
				<-0.400633, 0.672949, -0.612974>, <-0.601709, 4.737644, -5.115491>
			}
			smooth_triangle {
				<-0.433272, 0.660869, -0.603862>, <-0.340207, 3.988372, -4.467444>,
				<-0.423883, 0.640489, -0.631831>, <-0.488181, 3.866440, -4.560312>,
				<-0.400633, 0.672949, -0.612974>, <-0.601709, 4.737644, -5.115491>
			}
			smooth_triangle {
				<-0.423883, 0.640489, -0.631831>, <-0.488181, 3.866440, -4.560312>,
				<-0.398549, 0.646709, -0.641901>, <-0.635912, 3.901573, -4.512307>,
				<-0.400633, 0.672949, -0.612974>, <-0.601709, 4.737644, -5.115491>
			}
			smooth_triangle {
				<-0.398549, 0.646709, -0.641901>, <-0.635912, 3.901573, -4.512307>,
				<-0.381200, 0.667209, -0.631369>, <-0.566885, 3.355325, -3.662335>,
				<-0.400633, 0.672949, -0.612974>, <-0.601709, 4.737644, -5.115491>
			}
			smooth_triangle {
				<-0.412641, 0.694319, -0.580302>, <-0.343543, 4.189114, -4.279270>,
				<-0.400633, 0.672949, -0.612974>, <-0.601709, 4.737644, -5.115491>,
				<-0.382081, 0.707579, -0.585202>, <-0.497492, 4.265345, -4.188107>
			}
			smooth_triangle {
				<-0.381200, 0.667209, -0.631369>, <-0.566885, 3.355325, -3.662335>,
				<-0.369978, 0.691019, -0.612145>, <-0.657978, 4.172128, -4.259680>,
				<-0.400633, 0.672949, -0.612974>, <-0.601709, 4.737644, -5.115491>
			}
			smooth_triangle {
				<-0.400633, 0.672949, -0.612974>, <-0.601709, 4.737644, -5.115491>,
				<-0.369978, 0.691019, -0.612145>, <-0.657978, 4.172128, -4.259680>,
				<-0.382081, 0.707579, -0.585202>, <-0.497492, 4.265345, -4.188107>
			}
			smooth_triangle {
				<-0.415678, 0.620329, -0.656900>, <-0.623707, 3.742263, -4.646939>,
				<-0.423883, 0.640489, -0.631831>, <-0.488181, 3.866440, -4.560312>,
				<-0.441373, 0.611128, -0.648707>, <-0.472977, 3.687496, -4.708000>
			}
			smooth_triangle {
				<-0.433272, 0.660869, -0.603862>, <-0.340207, 3.988372, -4.467444>,
				<-0.451855, 0.629268, -0.623659>, <-0.329512, 3.797705, -4.631831>,
				<-0.423883, 0.640489, -0.631831>, <-0.488181, 3.866440, -4.560312>
			}
			smooth_triangle {
				<-0.423883, 0.640489, -0.631831>, <-0.488181, 3.866440, -4.560312>,
				<-0.451855, 0.629268, -0.623659>, <-0.329512, 3.797705, -4.631831>,
				<-0.441373, 0.611128, -0.648707>, <-0.472977, 3.687496, -4.708000>
			}
			smooth_triangle {
				<-0.390006, 0.728249, -0.553762>, <-0.338311, 4.395231, -4.067389>,
				<-0.382081, 0.707579, -0.585202>, <-0.497492, 4.265345, -4.188107>,
				<-0.364281, 0.735629, -0.561485>, <-0.405011, 3.700373, -3.335946>
			}
			smooth_triangle {
				<-0.369978, 0.691019, -0.612145>, <-0.657978, 4.172128, -4.259680>,
				<-0.352617, 0.721069, -0.587224>, <-0.545194, 3.610073, -3.414316>,
				<-0.382081, 0.707579, -0.585202>, <-0.497492, 4.265345, -4.188107>
			}
			smooth_triangle {
				<-0.382081, 0.707579, -0.585202>, <-0.497492, 4.265345, -4.188107>,
				<-0.352617, 0.721069, -0.587224>, <-0.545194, 3.610073, -3.414316>,
				<-0.364281, 0.735629, -0.561485>, <-0.405011, 3.700373, -3.335946>
			}
			smooth_triangle {
				<-0.451855, 0.629268, -0.623659>, <-0.329512, 3.797705, -4.631831>,
				<-0.467598, 0.599628, -0.641021>, <-0.326438, 3.618901, -4.773253>,
				<-0.441373, 0.611128, -0.648707>, <-0.472977, 3.687496, -4.708000>
			}
			smooth_triangle {
				<-0.481839, 0.572138, -0.655441>, <-0.314801, 3.454044, -4.894878>,
				<-0.472820, 0.557148, -0.674641>, <-0.425672, 3.363791, -4.949321>,
				<-0.456363, 0.581608, -0.665265>, <-0.541354, 4.098983, -5.647235>
			}
			smooth_triangle {
				<-0.472820, 0.557148, -0.674641>, <-0.425672, 3.363791, -4.949321>,
				<-0.455831, 0.562258, -0.682055>, <-0.445626, 2.827265, -4.099194>,
				<-0.456363, 0.581608, -0.665265>, <-0.541354, 4.098983, -5.647235>
			}
			smooth_triangle {
				<-0.431138, 0.594108, -0.671015>, <-0.608693, 3.588301, -4.768982>,
				<-0.456363, 0.581608, -0.665265>, <-0.541354, 4.098983, -5.647235>,
				<-0.442261, 0.573778, -0.681393>, <-0.501637, 2.886627, -4.051014>
			}
			smooth_triangle {
				<-0.455831, 0.562258, -0.682055>, <-0.445626, 2.827265, -4.099194>,
				<-0.442261, 0.573778, -0.681393>, <-0.501637, 2.886627, -4.051014>,
				<-0.456363, 0.581608, -0.665265>, <-0.541354, 4.098983, -5.647235>
			}
			smooth_triangle {
				<-0.481839, 0.572138, -0.655441>, <-0.314801, 3.454044, -4.894878>,
				<-0.456363, 0.581608, -0.665265>, <-0.541354, 4.098983, -5.647235>,
				<-0.467598, 0.599628, -0.641021>, <-0.326438, 3.618901, -4.773253>
			}
			smooth_triangle {
				<-0.431138, 0.594108, -0.671015>, <-0.608693, 3.588301, -4.768982>,
				<-0.441373, 0.611128, -0.648707>, <-0.472977, 3.687496, -4.708000>,
				<-0.456363, 0.581608, -0.665265>, <-0.541354, 4.098983, -5.647235>
			}
			smooth_triangle {
				<-0.456363, 0.581608, -0.665265>, <-0.541354, 4.098983, -5.647235>,
				<-0.441373, 0.611128, -0.648707>, <-0.472977, 3.687496, -4.708000>,
				<-0.467598, 0.599628, -0.641021>, <-0.326438, 3.618901, -4.773253>
			}
			smooth_triangle {
				<-0.442261, 0.573778, -0.681393>, <-0.501637, 2.886627, -4.051014>,
				<-0.455831, 0.562258, -0.682055>, <-0.445626, 2.827265, -4.099194>,
				<-0.442822, 0.554308, -0.696966>, <-0.771405, 3.900137, -5.760509>
			}
			smooth_triangle {
				<-0.472820, 0.557148, -0.674641>, <-0.425672, 3.363791, -4.949321>,
				<-0.464222, 0.544008, -0.691137>, <-0.536256, 3.280450, -4.994432>,
				<-0.455831, 0.562258, -0.682055>, <-0.445626, 2.827265, -4.099194>
			}
			smooth_triangle {
				<-0.455831, 0.562258, -0.682055>, <-0.445626, 2.827265, -4.099194>,
				<-0.464222, 0.544008, -0.691137>, <-0.536256, 3.280450, -4.994432>,
				<-0.442822, 0.554308, -0.696966>, <-0.771405, 3.900137, -5.760509>
			}
			smooth_triangle {
				<-0.481839, 0.572138, -0.655441>, <-0.314801, 3.454044, -4.894878>,
				<-0.494174, 0.546888, -0.667700>, <-0.300839, 3.300658, -5.000618>,
				<-0.472820, 0.557148, -0.674641>, <-0.425672, 3.363791, -4.949321>
			}
			smooth_triangle {
				<-0.494174, 0.546888, -0.667700>, <-0.300839, 3.300658, -5.000618>,
				<-0.483537, 0.535238, -0.684706>, <-0.419053, 3.230243, -5.038181>,
				<-0.472820, 0.557148, -0.674641>, <-0.425672, 3.363791, -4.949321>
			}
			smooth_triangle {
				<-0.448361, 0.494748, -0.737093>, <-0.371428, 1.488088, -2.578234>,
				<-0.444243, 0.504618, -0.732886>, <-0.520783, 2.042348, -3.399413>,
				<-0.457937, 0.500228, -0.727440>, <-0.699036, 3.018181, -5.137899>
			}
			smooth_triangle {
				<-0.444243, 0.504618, -0.732886>, <-0.520783, 2.042348, -3.399413>,
				<-0.448401, 0.517128, -0.721552>, <-0.724137, 3.122670, -5.071397>,
				<-0.457937, 0.500228, -0.727440>, <-0.699036, 3.018181, -5.137899>
			}
			smooth_triangle {
				<-0.472820, 0.557148, -0.674641>, <-0.425672, 3.363791, -4.949321>,
				<-0.483537, 0.535238, -0.684706>, <-0.419053, 3.230243, -5.038181>,
				<-0.464222, 0.544008, -0.691137>, <-0.536256, 3.280450, -4.994432>
			}
			smooth_triangle {
				<-0.483537, 0.535238, -0.684706>, <-0.419053, 3.230243, -5.038181>,
				<-0.474160, 0.523438, -0.700211>, <-0.524230, 3.159188, -5.073339>,
				<-0.464222, 0.544008, -0.691137>, <-0.536256, 3.280450, -4.994432>
			}
			smooth_triangle {
				<-0.457937, 0.500228, -0.727440>, <-0.699036, 3.018181, -5.137899>,
				<-0.448401, 0.517128, -0.721552>, <-0.724137, 3.122670, -5.071397>,
				<-0.465810, 0.511018, -0.714841>, <-0.617855, 3.082936, -5.109592>
			}
			smooth_triangle {
				<-0.448401, 0.517128, -0.721552>, <-0.724137, 3.122670, -5.071397>,
				<-0.455338, 0.531068, -0.706919>, <-0.637403, 3.206810, -5.030279>,
				<-0.465810, 0.511018, -0.714841>, <-0.617855, 3.082936, -5.109592>
			}
			smooth_triangle {
				<-0.464222, 0.544008, -0.691137>, <-0.536256, 3.280450, -4.994432>,
				<-0.474160, 0.523438, -0.700211>, <-0.524230, 3.159188, -5.073339>,
				<-0.455338, 0.531068, -0.706919>, <-0.637403, 3.206810, -5.030279>
			}
			smooth_triangle {
				<-0.474160, 0.523438, -0.700211>, <-0.524230, 3.159188, -5.073339>,
				<-0.465810, 0.511018, -0.714841>, <-0.617855, 3.082936, -5.109592>,
				<-0.455338, 0.531068, -0.706919>, <-0.637403, 3.206810, -5.030279>
			}
			smooth_triangle {
				<-0.483537, 0.535238, -0.684706>, <-0.419053, 3.230243, -5.038181>,
				<-0.492420, 0.514678, -0.694079>, <-0.416076, 3.105803, -5.116145>,
				<-0.474160, 0.523438, -0.700211>, <-0.524230, 3.159188, -5.073339>
			}
			smooth_triangle {
				<-0.474160, 0.523438, -0.700211>, <-0.524230, 3.159188, -5.073339>,
				<-0.482906, 0.504078, -0.708394>, <-0.516703, 3.043527, -5.144375>,
				<-0.465810, 0.511018, -0.714841>, <-0.617855, 3.082936, -5.109592>
			}
			smooth_triangle {
				<-0.465810, 0.511018, -0.714841>, <-0.617855, 3.082936, -5.109592>,
				<-0.482906, 0.504078, -0.708394>, <-0.516703, 3.043527, -5.144375>,
				<-0.475406, 0.489728, -0.723368>, <-0.409012, 2.001175, -3.439057>
			}
			smooth_triangle {
				<-0.487843, 0.490728, -0.714355>, <-0.172030, 0.999880, -1.723484>,
				<-0.475406, 0.489728, -0.723368>, <-0.409012, 2.001175, -3.439057>,
				<-0.482906, 0.504078, -0.708394>, <-0.516703, 3.043527, -5.144375>
			}
			smooth_triangle {
				<-0.474160, 0.523438, -0.700211>, <-0.524230, 3.159188, -5.073339>,
				<-0.492420, 0.514678, -0.694079>, <-0.416076, 3.105803, -5.116145>,
				<-0.482906, 0.504078, -0.708394>, <-0.516703, 3.043527, -5.144375>
			}
			smooth_triangle {
				<-0.492420, 0.514678, -0.694079>, <-0.416076, 3.105803, -5.116145>,
				<-0.501096, 0.494488, -0.702490>, <-0.273635, 2.014005, -3.444937>,
				<-0.482906, 0.504078, -0.708394>, <-0.516703, 3.043527, -5.144375>
			}
			smooth_triangle {
				<-0.487843, 0.490728, -0.714355>, <-0.172030, 0.999880, -1.723484>,
				<-0.482906, 0.504078, -0.708394>, <-0.516703, 3.043527, -5.144375>,
				<-0.501096, 0.494488, -0.702490>, <-0.273635, 2.014005, -3.444937>
			}
			smooth_triangle {
				<-0.465810, 0.511018, -0.714841>, <-0.617855, 3.082936, -5.109592>,
				<-0.475406, 0.489728, -0.723368>, <-0.409012, 2.001175, -3.439057>,
				<-0.457937, 0.500228, -0.727440>, <-0.699036, 3.018181, -5.137899>
			}
			smooth_triangle {
				<-0.475406, 0.489728, -0.723368>, <-0.409012, 2.001175, -3.439057>,
				<-0.464960, 0.483828, -0.734052>, <-0.357655, 1.480691, -2.584435>,
				<-0.457937, 0.500228, -0.727440>, <-0.699036, 3.018181, -5.137899>
			}
			smooth_triangle {
				<-0.457937, 0.500228, -0.727440>, <-0.699036, 3.018181, -5.137899>,
				<-0.464960, 0.483828, -0.734052>, <-0.357655, 1.480691, -2.584435>,
				<-0.448361, 0.494748, -0.737093>, <-0.371428, 1.488088, -2.578234>
			}
			smooth_triangle {
				<-0.464960, 0.483828, -0.734052>, <-0.357655, 1.480691, -2.584435>,
				<-0.451365, 0.482168, -0.743567>, <-0.124923, 0.490747, -0.862300>,
				<-0.448361, 0.494748, -0.737093>, <-0.371428, 1.488088, -2.578234>
			}
			smooth_triangle {
				<-0.494174, 0.546888, -0.667700>, <-0.300839, 3.300658, -5.000618>,
				<-0.502572, 0.524688, -0.679138>, <-0.310402, 3.169517, -5.084464>,
				<-0.483537, 0.535238, -0.684706>, <-0.419053, 3.230243, -5.038181>
			}
			smooth_triangle {
				<-0.517354, 0.489338, -0.694266>, <-0.143269, 1.489953, -2.599753>,
				<-0.501096, 0.494488, -0.702490>, <-0.273635, 2.014005, -3.444937>,
				<-0.509452, 0.505698, -0.688365>, <-0.318205, 3.051678, -5.155694>
			}
			smooth_triangle {
				<-0.501096, 0.494488, -0.702490>, <-0.273635, 2.014005, -3.444937>,
				<-0.492420, 0.514678, -0.694079>, <-0.416076, 3.105803, -5.116145>,
				<-0.509452, 0.505698, -0.688365>, <-0.318205, 3.051678, -5.155694>
			}
			smooth_triangle {
				<-0.483537, 0.535238, -0.684706>, <-0.419053, 3.230243, -5.038181>,
				<-0.502572, 0.524688, -0.679138>, <-0.310402, 3.169517, -5.084464>,
				<-0.492420, 0.514678, -0.694079>, <-0.416076, 3.105803, -5.116145>
			}
			smooth_triangle {
				<-0.502572, 0.524688, -0.679138>, <-0.310402, 3.169517, -5.084464>,
				<-0.509452, 0.505698, -0.688365>, <-0.318205, 3.051678, -5.155694>,
				<-0.492420, 0.514678, -0.694079>, <-0.416076, 3.105803, -5.116145>
			}
			smooth_triangle {
				<-0.422491, 0.714079, -0.548356>, <-0.173787, 4.308374, -4.169518>,
				<-0.455513, 0.697828, -0.542813>, <0.001737, 4.209558, -4.272831>,
				<-0.444613, 0.679658, -0.574021>, <-0.169333, 4.101394, -4.373667>
			}
			smooth_triangle {
				<-0.680145, 0.473548, -0.549794>, <0.467769, 1.420984, -2.599749>,
				<-0.653544, 0.485148, -0.571516>, <0.803122, 2.928323, -5.172977>,
				<-0.660773, 0.510768, -0.539994>, <0.439327, 1.534306, -2.539603>
			}
			smooth_triangle {
				<-0.594192, 0.623848, -0.496847>, <0.369426, 1.881760, -2.306078>,
				<-0.585174, 0.603308, -0.531698>, <0.641143, 3.639149, -4.724453>,
				<-0.559965, 0.643018, -0.511939>, <0.601192, 3.879177, -4.534805>
			}
			smooth_triangle {
				<-0.455513, 0.697828, -0.542813>, <0.001737, 4.209558, -4.272831>,
				<-0.489539, 0.679878, -0.535945>, <0.187806, 4.098793, -4.374734>,
				<-0.477287, 0.662188, -0.568170>, <0.010438, 3.996062, -4.473178>
			}
			smooth_triangle {
				<-0.517013, 0.572858, -0.627415>, <-0.045220, 3.457419, -4.902419>,
				<-0.505270, 0.599858, -0.611538>, <-0.038223, 3.620008, -4.783538>,
				<-0.530052, 0.583718, -0.606161>, <0.110829, 3.521625, -4.855175>
			}
			smooth_triangle {
				<-0.550779, 0.621368, -0.547413>, <0.422168, 3.749114, -4.662601>,
				<-0.541618, 0.599228, -0.580243>, <0.266482, 3.615257, -4.778840>,
				<-0.514139, 0.638038, -0.563628>, <0.234388, 4.494609, -5.358232>
			}
			smooth_triangle {
				<-0.541618, 0.599228, -0.580243>, <0.266482, 3.615257, -4.778840>,
				<-0.517186, 0.610178, -0.591031>, <0.090472, 3.070297, -3.943945>,
				<-0.514139, 0.638038, -0.563628>, <0.234388, 4.494609, -5.358232>
			}
			smooth_triangle {
				<-0.477287, 0.662188, -0.568170>, <0.010438, 3.996062, -4.473178>,
				<-0.514139, 0.638038, -0.563628>, <0.234388, 4.494609, -5.358232>,
				<-0.493232, 0.628958, -0.591824>, <-0.014021, 3.798466, -4.642736>
			}
			smooth_triangle {
				<-0.517186, 0.610178, -0.591031>, <0.090472, 3.070297, -3.943945>,
				<-0.493232, 0.628958, -0.591824>, <-0.014021, 3.798466, -4.642736>,
				<-0.514139, 0.638038, -0.563628>, <0.234388, 4.494609, -5.358232>
			}
			smooth_triangle {
				<-0.550779, 0.621368, -0.547413>, <0.422168, 3.749114, -4.662601>,
				<-0.514139, 0.638038, -0.563628>, <0.234388, 4.494609, -5.358232>,
				<-0.524809, 0.661408, -0.525565>, <0.385274, 3.989387, -4.461973>
			}
			smooth_triangle {
				<-0.477287, 0.662188, -0.568170>, <0.010438, 3.996062, -4.473178>,
				<-0.489539, 0.679878, -0.535945>, <0.187806, 4.098793, -4.374734>,
				<-0.514139, 0.638038, -0.563628>, <0.234388, 4.494609, -5.358232>
			}
			smooth_triangle {
				<-0.514139, 0.638038, -0.563628>, <0.234388, 4.494609, -5.358232>,
				<-0.489539, 0.679878, -0.535945>, <0.187806, 4.098793, -4.374734>,
				<-0.524809, 0.661408, -0.525565>, <0.385274, 3.989387, -4.461973>
			}
			smooth_triangle {
				<-0.493232, 0.628958, -0.591824>, <-0.014021, 3.798466, -4.642736>,
				<-0.517186, 0.610178, -0.591031>, <0.090472, 3.070297, -3.943945>,
				<-0.505270, 0.599858, -0.611538>, <-0.038223, 3.620008, -4.783538>
			}
			smooth_triangle {
				<-0.541618, 0.599228, -0.580243>, <0.266482, 3.615257, -4.778840>,
				<-0.530052, 0.583718, -0.606161>, <0.110829, 3.521625, -4.855175>,
				<-0.517186, 0.610178, -0.591031>, <0.090472, 3.070297, -3.943945>
			}
			smooth_triangle {
				<-0.517186, 0.610178, -0.591031>, <0.090472, 3.070297, -3.943945>,
				<-0.530052, 0.583718, -0.606161>, <0.110829, 3.521625, -4.855175>,
				<-0.505270, 0.599858, -0.611538>, <-0.038223, 3.620008, -4.783538>
			}
			smooth_triangle {
				<-0.550779, 0.621368, -0.547413>, <0.422168, 3.749114, -4.662601>,
				<-0.574787, 0.580638, -0.567096>, <0.458434, 3.499532, -4.849347>,
				<-0.541618, 0.599228, -0.580243>, <0.266482, 3.615257, -4.778840>
			}
			smooth_triangle {
				<-0.574787, 0.580638, -0.567096>, <0.458434, 3.499532, -4.849347>,
				<-0.559647, 0.559318, -0.602553>, <0.311421, 3.936875, -5.777137>,
				<-0.541618, 0.599228, -0.580243>, <0.266482, 3.615257, -4.778840>
			}
			smooth_triangle {
				<-0.541618, 0.599228, -0.580243>, <0.266482, 3.615257, -4.778840>,
				<-0.559647, 0.559318, -0.602553>, <0.311421, 3.936875, -5.777137>,
				<-0.530052, 0.583718, -0.606161>, <0.110829, 3.521625, -4.855175>
			}
			smooth_triangle {
				<-0.552206, 0.534658, -0.631132>, <0.116155, 3.222016, -5.058761>,
				<-0.528764, 0.546578, -0.640921>, <-0.044249, 3.296144, -5.012299>,
				<-0.537786, 0.559558, -0.621928>, <0.068228, 2.813051, -4.132119>
			}
			smooth_triangle {
				<-0.528764, 0.546578, -0.640921>, <-0.044249, 3.296144, -5.012299>,
				<-0.517013, 0.572858, -0.627415>, <-0.045220, 3.457419, -4.902419>,
				<-0.537786, 0.559558, -0.621928>, <0.068228, 2.813051, -4.132119>
			}
			smooth_triangle {
				<-0.517013, 0.572858, -0.627415>, <-0.045220, 3.457419, -4.902419>,
				<-0.530052, 0.583718, -0.606161>, <0.110829, 3.521625, -4.855175>,
				<-0.537786, 0.559558, -0.621928>, <0.068228, 2.813051, -4.132119>
			}
			smooth_triangle {
				<-0.552206, 0.534658, -0.631132>, <0.116155, 3.222016, -5.058761>,
				<-0.537786, 0.559558, -0.621928>, <0.068228, 2.813051, -4.132119>,
				<-0.559647, 0.559318, -0.602553>, <0.311421, 3.936875, -5.777137>
			}
			smooth_triangle {
				<-0.537786, 0.559558, -0.621928>, <0.068228, 2.813051, -4.132119>,
				<-0.530052, 0.583718, -0.606161>, <0.110829, 3.521625, -4.855175>,
				<-0.559647, 0.559318, -0.602553>, <0.311421, 3.936875, -5.777137>
			}
			smooth_triangle {
				<-0.455513, 0.697828, -0.542813>, <0.001737, 4.209558, -4.272831>,
				<-0.477287, 0.662188, -0.568170>, <0.010438, 3.996062, -4.473178>,
				<-0.444613, 0.679658, -0.574021>, <-0.169333, 4.101394, -4.373667>
			}
			smooth_triangle {
				<-0.528764, 0.546578, -0.640921>, <-0.044249, 3.296144, -5.012299>,
				<-0.505642, 0.559648, -0.648261>, <-0.176588, 3.375707, -4.956061>,
				<-0.517013, 0.572858, -0.627415>, <-0.045220, 3.457419, -4.902419>
			}
			smooth_triangle {
				<-0.505642, 0.559648, -0.648261>, <-0.176588, 3.375707, -4.956061>,
				<-0.493061, 0.586798, -0.633780>, <-0.179683, 3.541387, -4.838853>,
				<-0.517013, 0.572858, -0.627415>, <-0.045220, 3.457419, -4.902419>
			}
			smooth_triangle {
				<-0.444613, 0.679658, -0.574021>, <-0.169333, 4.101394, -4.373667>,
				<-0.477287, 0.662188, -0.568170>, <0.010438, 3.996062, -4.473178>,
				<-0.463662, 0.646378, -0.596925>, <-0.170753, 3.901252, -4.553438>
			}
			smooth_triangle {
				<-0.477287, 0.662188, -0.568170>, <0.010438, 3.996062, -4.473178>,
				<-0.493232, 0.628958, -0.591824>, <-0.014021, 3.798466, -4.642736>,
				<-0.463662, 0.646378, -0.596925>, <-0.170753, 3.901252, -4.553438>
			}
			smooth_triangle {
				<-0.517013, 0.572858, -0.627415>, <-0.045220, 3.457419, -4.902419>,
				<-0.493061, 0.586798, -0.633780>, <-0.179683, 3.541387, -4.838853>,
				<-0.505270, 0.599858, -0.611538>, <-0.038223, 3.620008, -4.783538>
			}
			smooth_triangle {
				<-0.493061, 0.586798, -0.633780>, <-0.179683, 3.541387, -4.838853>,
				<-0.479442, 0.615398, -0.616881>, <-0.177165, 3.714518, -4.707083>,
				<-0.505270, 0.599858, -0.611538>, <-0.038223, 3.620008, -4.783538>
			}
			smooth_triangle {
				<-0.463662, 0.646378, -0.596925>, <-0.170753, 3.901252, -4.553438>,
				<-0.493232, 0.628958, -0.591824>, <-0.014021, 3.798466, -4.642736>,
				<-0.479442, 0.615398, -0.616881>, <-0.177165, 3.714518, -4.707083>
			}
			smooth_triangle {
				<-0.493232, 0.628958, -0.591824>, <-0.014021, 3.798466, -4.642736>,
				<-0.505270, 0.599858, -0.611538>, <-0.038223, 3.620008, -4.783538>,
				<-0.479442, 0.615398, -0.616881>, <-0.177165, 3.714518, -4.707083>
			}
			smooth_triangle {
				<-0.574787, 0.580638, -0.567096>, <0.458434, 3.499532, -4.849347>,
				<-0.550779, 0.621368, -0.547413>, <0.422168, 3.749114, -4.662601>,
				<-0.585174, 0.603308, -0.531698>, <0.641143, 3.639149, -4.724453>
			}
			smooth_triangle {
				<-0.524809, 0.661408, -0.525565>, <0.385274, 3.989387, -4.461973>,
				<-0.559965, 0.643018, -0.511939>, <0.601192, 3.879177, -4.534805>,
				<-0.550779, 0.621368, -0.547413>, <0.422168, 3.749114, -4.662601>
			}
			smooth_triangle {
				<-0.550779, 0.621368, -0.547413>, <0.422168, 3.749114, -4.662601>,
				<-0.559965, 0.643018, -0.511939>, <0.601192, 3.879177, -4.534805>,
				<-0.585174, 0.603308, -0.531698>, <0.641143, 3.639149, -4.724453>
			}
			smooth_triangle {
				<-0.552206, 0.534658, -0.631132>, <0.116155, 3.222016, -5.058761>,
				<-0.559647, 0.559318, -0.602553>, <0.311421, 3.936875, -5.777137>,
				<-0.578763, 0.519968, -0.619501>, <0.275335, 3.142450, -5.102060>
			}
			smooth_triangle {
				<-0.594192, 0.623848, -0.496847>, <0.369426, 1.881760, -2.306078>,
				<-0.618152, 0.585628, -0.513842>, <0.388952, 1.764316, -2.394143>,
				<-0.585174, 0.603308, -0.531698>, <0.641143, 3.639149, -4.724453>
			}
			smooth_triangle {
				<-0.660773, 0.510768, -0.539994>, <0.439327, 1.534306, -2.539603>,
				<-0.653544, 0.485148, -0.571516>, <0.803122, 2.928323, -5.172977>,
				<-0.631931, 0.523198, -0.562172>, <0.736113, 3.158568, -5.045635>
			}
			smooth_triangle {
				<-0.653544, 0.485148, -0.571516>, <0.803122, 2.928323, -5.172977>,
				<-0.625668, 0.495448, -0.593445>, <0.593740, 2.991398, -5.165123>,
				<-0.631931, 0.523198, -0.562172>, <0.736113, 3.158568, -5.045635>
			}
			smooth_triangle {
				<-0.559647, 0.559318, -0.602553>, <0.311421, 3.936875, -5.777137>,
				<-0.598261, 0.535048, -0.587292>, <0.572673, 3.771872, -5.866095>,
				<-0.578763, 0.519968, -0.619501>, <0.275335, 3.142450, -5.102060>
			}
			smooth_triangle {
				<-0.631931, 0.523198, -0.562172>, <0.736113, 3.158568, -5.045635>,
				<-0.625668, 0.495448, -0.593445>, <0.593740, 2.991398, -5.165123>,
				<-0.598261, 0.535048, -0.587292>, <0.572673, 3.771872, -5.866095>
			}
			smooth_triangle {
				<-0.625668, 0.495448, -0.593445>, <0.593740, 2.991398, -5.165123>,
				<-0.602805, 0.501278, -0.611937>, <0.350464, 2.521850, -4.301793>,
				<-0.598261, 0.535048, -0.587292>, <0.572673, 3.771872, -5.866095>
			}
			smooth_triangle {
				<-0.602805, 0.501278, -0.611937>, <0.350464, 2.521850, -4.301793>,
				<-0.578763, 0.519968, -0.619501>, <0.275335, 3.142450, -5.102060>,
				<-0.598261, 0.535048, -0.587292>, <0.572673, 3.771872, -5.866095>
			}
			smooth_triangle {
				<-0.660773, 0.510768, -0.539994>, <0.439327, 1.534306, -2.539603>,
				<-0.631931, 0.523198, -0.562172>, <0.736113, 3.158568, -5.045635>,
				<-0.640221, 0.548028, -0.528102>, <0.411759, 1.648234, -2.471869>
			}
			smooth_triangle {
				<-0.559647, 0.559318, -0.602553>, <0.311421, 3.936875, -5.777137>,
				<-0.574787, 0.580638, -0.567096>, <0.458434, 3.499532, -4.849347>,
				<-0.598261, 0.535048, -0.587292>, <0.572673, 3.771872, -5.866095>
			}
			smooth_triangle {
				<-0.574787, 0.580638, -0.567096>, <0.458434, 3.499532, -4.849347>,
				<-0.608855, 0.562998, -0.549030>, <0.679392, 3.395840, -4.897074>,
				<-0.598261, 0.535048, -0.587292>, <0.572673, 3.771872, -5.866095>
			}
			smooth_triangle {
				<-0.640221, 0.548028, -0.528102>, <0.411759, 1.648234, -2.471869>,
				<-0.631931, 0.523198, -0.562172>, <0.736113, 3.158568, -5.045635>,
				<-0.608855, 0.562998, -0.549030>, <0.679392, 3.395840, -4.897074>
			}
			smooth_triangle {
				<-0.631931, 0.523198, -0.562172>, <0.736113, 3.158568, -5.045635>,
				<-0.598261, 0.535048, -0.587292>, <0.572673, 3.771872, -5.866095>,
				<-0.608855, 0.562998, -0.549030>, <0.679392, 3.395840, -4.897074>
			}
			smooth_triangle {
				<-0.640221, 0.548028, -0.528102>, <0.411759, 1.648234, -2.471869>,
				<-0.608855, 0.562998, -0.549030>, <0.679392, 3.395840, -4.897074>,
				<-0.618152, 0.585628, -0.513842>, <0.388952, 1.764316, -2.394143>
			}
			smooth_triangle {
				<-0.574787, 0.580638, -0.567096>, <0.458434, 3.499532, -4.849347>,
				<-0.585174, 0.603308, -0.531698>, <0.641143, 3.639149, -4.724453>,
				<-0.608855, 0.562998, -0.549030>, <0.679392, 3.395840, -4.897074>
			}
			smooth_triangle {
				<-0.608855, 0.562998, -0.549030>, <0.679392, 3.395840, -4.897074>,
				<-0.585174, 0.603308, -0.531698>, <0.641143, 3.639149, -4.724453>,
				<-0.618152, 0.585628, -0.513842>, <0.388952, 1.764316, -2.394143>
			}
			smooth_triangle {
				<-0.505642, 0.559648, -0.648261>, <-0.176588, 3.375707, -4.956061>,
				<-0.528764, 0.546578, -0.640921>, <-0.044249, 3.296144, -5.012299>,
				<-0.517563, 0.531538, -0.662343>, <-0.200337, 3.745764, -5.909092>
			}
			smooth_triangle {
				<-0.698608, 0.435977, -0.557656>, <0.321872, 0.889261, -1.762052>,
				<-0.690202, 0.410827, -0.586484>, <0.428204, 1.270081, -2.683430>,
				<-0.672840, 0.447867, -0.579500>, <0.861900, 2.702286, -5.285433>
			}
			smooth_triangle {
				<-0.690202, 0.410827, -0.586484>, <0.428204, 1.270081, -2.683430>,
				<-0.664860, 0.421888, -0.607513>, <0.717361, 2.545043, -5.384278>,
				<-0.672840, 0.447867, -0.579500>, <0.861900, 2.702286, -5.285433>
			}
			smooth_triangle {
				<-0.531952, 0.508208, -0.669223>, <-0.132319, 3.069573, -5.153067>,
				<-0.548258, 0.498578, -0.663282>, <-0.024065, 2.506521, -4.325680>,
				<-0.541566, 0.487708, -0.676729>, <-0.119260, 2.943367, -5.226532>
			}
			smooth_triangle {
				<-0.672840, 0.447867, -0.579500>, <0.861900, 2.702286, -5.285433>,
				<-0.664860, 0.421888, -0.607513>, <0.717361, 2.545043, -5.384278>,
				<-0.646158, 0.458568, -0.601093>, <0.654484, 2.767280, -5.281527>
			}
			smooth_triangle {
				<-0.664860, 0.421888, -0.607513>, <0.717361, 2.545043, -5.384278>,
				<-0.638846, 0.431918, -0.628036>, <0.520105, 2.607304, -5.377245>,
				<-0.646158, 0.458568, -0.601093>, <0.654484, 2.767280, -5.281527>
			}
			smooth_triangle {
				<-0.615395, 0.438048, -0.646931>, <0.345175, 2.640216, -5.375618>,
				<-0.594937, 0.443338, -0.662283>, <0.181485, 2.672925, -5.367788>,
				<-0.600508, 0.461288, -0.644763>, <0.234401, 2.320012, -4.422149>
			}
			smooth_triangle {
				<-0.594937, 0.443338, -0.662283>, <0.181485, 2.672925, -5.367788>,
				<-0.575758, 0.449278, -0.675100>, <0.045715, 2.710011, -5.352108>,
				<-0.581738, 0.469668, -0.655826>, <0.142996, 2.837260, -5.283824>
			}
			smooth_triangle {
				<-0.575758, 0.449278, -0.675100>, <0.045715, 2.710011, -5.352108>,
				<-0.561950, 0.451608, -0.685107>, <-0.008092, 1.372684, -2.667274>,
				<-0.560834, 0.475358, -0.669791>, <0.006772, 3.345893, -6.147580>
			}
			smooth_triangle {
				<-0.561950, 0.451608, -0.685107>, <-0.008092, 1.372684, -2.667274>,
				<-0.549622, 0.468828, -0.683546>, <-0.042924, 1.427983, -2.637779>,
				<-0.560834, 0.475358, -0.669791>, <0.006772, 3.345893, -6.147580>
			}
			smooth_triangle {
				<-0.549622, 0.468828, -0.683546>, <-0.042924, 1.427983, -2.637779>,
				<-0.541566, 0.487708, -0.676729>, <-0.119260, 2.943367, -5.226532>,
				<-0.560834, 0.475358, -0.669791>, <0.006772, 3.345893, -6.147580>
			}
			smooth_triangle {
				<-0.541566, 0.487708, -0.676729>, <-0.119260, 2.943367, -5.226532>,
				<-0.548258, 0.498578, -0.663282>, <-0.024065, 2.506521, -4.325680>,
				<-0.560834, 0.475358, -0.669791>, <0.006772, 3.345893, -6.147580>
			}
			smooth_triangle {
				<-0.575758, 0.449278, -0.675100>, <0.045715, 2.710011, -5.352108>,
				<-0.560834, 0.475358, -0.669791>, <0.006772, 3.345893, -6.147580>,
				<-0.581738, 0.469668, -0.655826>, <0.142996, 2.837260, -5.283824>
			}
			smooth_triangle {
				<-0.548258, 0.498578, -0.663282>, <-0.024065, 2.506521, -4.325680>,
				<-0.565253, 0.500968, -0.647024>, <0.129543, 3.527444, -6.043359>,
				<-0.560834, 0.475358, -0.669791>, <0.006772, 3.345893, -6.147580>
			}
			smooth_triangle {
				<-0.560834, 0.475358, -0.669791>, <0.006772, 3.345893, -6.147580>,
				<-0.565253, 0.500968, -0.647024>, <0.129543, 3.527444, -6.043359>,
				<-0.581738, 0.469668, -0.655826>, <0.142996, 2.837260, -5.283824>
			}
			smooth_triangle {
				<-0.594937, 0.443338, -0.662283>, <0.181485, 2.672925, -5.367788>,
				<-0.581738, 0.469668, -0.655826>, <0.142996, 2.837260, -5.283824>,
				<-0.600508, 0.461288, -0.644763>, <0.234401, 2.320012, -4.422149>
			}
			smooth_triangle {
				<-0.565253, 0.500968, -0.647024>, <0.129543, 3.527444, -6.043359>,
				<-0.591475, 0.486998, -0.634106>, <0.274603, 2.942271, -5.220634>,
				<-0.581738, 0.469668, -0.655826>, <0.142996, 2.837260, -5.283824>
			}
			smooth_triangle {
				<-0.581738, 0.469668, -0.655826>, <0.142996, 2.837260, -5.283824>,
				<-0.591475, 0.486998, -0.634106>, <0.274603, 2.942271, -5.220634>,
				<-0.600508, 0.461288, -0.644763>, <0.234401, 2.320012, -4.422149>
			}
			smooth_triangle {
				<-0.591475, 0.486998, -0.634106>, <0.274603, 2.942271, -5.220634>,
				<-0.617760, 0.467848, -0.623381>, <0.522030, 3.291321, -6.154093>,
				<-0.600508, 0.461288, -0.644763>, <0.234401, 2.320012, -4.422149>
			}
			smooth_triangle {
				<-0.638846, 0.431918, -0.628036>, <0.520105, 2.607304, -5.377245>,
				<-0.617760, 0.467848, -0.623381>, <0.522030, 3.291321, -6.154093>,
				<-0.646158, 0.458568, -0.601093>, <0.654484, 2.767280, -5.281527>
			}
			smooth_triangle {
				<-0.638846, 0.431918, -0.628036>, <0.520105, 2.607304, -5.377245>,
				<-0.615395, 0.438048, -0.646931>, <0.345175, 2.640216, -5.375618>,
				<-0.617760, 0.467848, -0.623381>, <0.522030, 3.291321, -6.154093>
			}
			smooth_triangle {
				<-0.615395, 0.438048, -0.646931>, <0.345175, 2.640216, -5.375618>,
				<-0.600508, 0.461288, -0.644763>, <0.234401, 2.320012, -4.422149>,
				<-0.617760, 0.467848, -0.623381>, <0.522030, 3.291321, -6.154093>
			}
			smooth_triangle {
				<-0.698608, 0.435977, -0.557656>, <0.321872, 0.889261, -1.762052>,
				<-0.672840, 0.447867, -0.579500>, <0.861900, 2.702286, -5.285433>,
				<-0.680145, 0.473548, -0.549794>, <0.467769, 1.420984, -2.599749>
			}
			smooth_triangle {
				<-0.531952, 0.508208, -0.669223>, <-0.132319, 3.069573, -5.153067>,
				<-0.540885, 0.520218, -0.652629>, <-0.024364, 3.141637, -5.110756>,
				<-0.548258, 0.498578, -0.663282>, <-0.024065, 2.506521, -4.325680>
			}
			smooth_triangle {
				<-0.680145, 0.473548, -0.549794>, <0.467769, 1.420984, -2.599749>,
				<-0.672840, 0.447867, -0.579500>, <0.861900, 2.702286, -5.285433>,
				<-0.653544, 0.485148, -0.571516>, <0.803122, 2.928323, -5.172977>
			}
			smooth_triangle {
				<-0.672840, 0.447867, -0.579500>, <0.861900, 2.702286, -5.285433>,
				<-0.646158, 0.458568, -0.601093>, <0.654484, 2.767280, -5.281527>,
				<-0.653544, 0.485148, -0.571516>, <0.803122, 2.928323, -5.172977>
			}
			smooth_triangle {
				<-0.653544, 0.485148, -0.571516>, <0.803122, 2.928323, -5.172977>,
				<-0.646158, 0.458568, -0.601093>, <0.654484, 2.767280, -5.281527>,
				<-0.625668, 0.495448, -0.593445>, <0.593740, 2.991398, -5.165123>
			}
			smooth_triangle {
				<-0.646158, 0.458568, -0.601093>, <0.654484, 2.767280, -5.281527>,
				<-0.617760, 0.467848, -0.623381>, <0.522030, 3.291321, -6.154093>,
				<-0.625668, 0.495448, -0.593445>, <0.593740, 2.991398, -5.165123>
			}
			smooth_triangle {
				<-0.625668, 0.495448, -0.593445>, <0.593740, 2.991398, -5.165123>,
				<-0.617760, 0.467848, -0.623381>, <0.522030, 3.291321, -6.154093>,
				<-0.602805, 0.501278, -0.611937>, <0.350464, 2.521850, -4.301793>
			}
			smooth_triangle {
				<-0.617760, 0.467848, -0.623381>, <0.522030, 3.291321, -6.154093>,
				<-0.591475, 0.486998, -0.634106>, <0.274603, 2.942271, -5.220634>,
				<-0.602805, 0.501278, -0.611937>, <0.350464, 2.521850, -4.301793>
			}
			smooth_triangle {
				<-0.602805, 0.501278, -0.611937>, <0.350464, 2.521850, -4.301793>,
				<-0.591475, 0.486998, -0.634106>, <0.274603, 2.942271, -5.220634>,
				<-0.578763, 0.519968, -0.619501>, <0.275335, 3.142450, -5.102060>
			}
			smooth_triangle {
				<-0.591475, 0.486998, -0.634106>, <0.274603, 2.942271, -5.220634>,
				<-0.565253, 0.500968, -0.647024>, <0.129543, 3.527444, -6.043359>,
				<-0.578763, 0.519968, -0.619501>, <0.275335, 3.142450, -5.102060>
			}
			smooth_triangle {
				<-0.578763, 0.519968, -0.619501>, <0.275335, 3.142450, -5.102060>,
				<-0.565253, 0.500968, -0.647024>, <0.129543, 3.527444, -6.043359>,
				<-0.552206, 0.534658, -0.631132>, <0.116155, 3.222016, -5.058761>
			}
			smooth_triangle {
				<-0.540885, 0.520218, -0.652629>, <-0.024364, 3.141637, -5.110756>,
				<-0.565253, 0.500968, -0.647024>, <0.129543, 3.527444, -6.043359>,
				<-0.548258, 0.498578, -0.663282>, <-0.024065, 2.506521, -4.325680>
			}
			smooth_triangle {
				<-0.540885, 0.520218, -0.652629>, <-0.024364, 3.141637, -5.110756>,
				<-0.552206, 0.534658, -0.631132>, <0.116155, 3.222016, -5.058761>,
				<-0.565253, 0.500968, -0.647024>, <0.129543, 3.527444, -6.043359>
			}
			smooth_triangle {
				<-0.552206, 0.534658, -0.631132>, <0.116155, 3.222016, -5.058761>,
				<-0.540885, 0.520218, -0.652629>, <-0.024364, 3.141637, -5.110756>,
				<-0.528764, 0.546578, -0.640921>, <-0.044249, 3.296144, -5.012299>
			}
			smooth_triangle {
				<-0.531952, 0.508208, -0.669223>, <-0.132319, 3.069573, -5.153067>,
				<-0.517563, 0.531538, -0.662343>, <-0.200337, 3.745764, -5.909092>,
				<-0.540885, 0.520218, -0.652629>, <-0.024364, 3.141637, -5.110756>
			}
			smooth_triangle {
				<-0.540885, 0.520218, -0.652629>, <-0.024364, 3.141637, -5.110756>,
				<-0.517563, 0.531538, -0.662343>, <-0.200337, 3.745764, -5.909092>,
				<-0.528764, 0.546578, -0.640921>, <-0.044249, 3.296144, -5.012299>
			}
			smooth_triangle {
				<-0.549622, 0.468828, -0.683546>, <-0.042924, 1.427983, -2.637779>,
				<-0.532817, 0.477718, -0.690650>, <-0.095812, 1.460650, -2.618542>,
				<-0.541566, 0.487708, -0.676729>, <-0.119260, 2.943367, -5.226532>
			}
			smooth_triangle {
				<-0.390006, 0.728249, -0.553762>, <-0.338311, 4.395231, -4.067389>,
				<-0.422491, 0.714079, -0.548356>, <-0.173787, 4.308374, -4.169518>,
				<-0.412641, 0.694319, -0.580302>, <-0.343543, 4.189114, -4.279270>
			}
			smooth_triangle {
				<-0.422491, 0.714079, -0.548356>, <-0.173787, 4.308374, -4.169518>,
				<-0.444613, 0.679658, -0.574021>, <-0.169333, 4.101394, -4.373667>,
				<-0.412641, 0.694319, -0.580302>, <-0.343543, 4.189114, -4.279270>
			}
			smooth_triangle {
				<-0.412641, 0.694319, -0.580302>, <-0.343543, 4.189114, -4.279270>,
				<-0.444613, 0.679658, -0.574021>, <-0.169333, 4.101394, -4.373667>,
				<-0.433272, 0.660869, -0.603862>, <-0.340207, 3.988372, -4.467444>
			}
			smooth_triangle {
				<-0.444613, 0.679658, -0.574021>, <-0.169333, 4.101394, -4.373667>,
				<-0.463662, 0.646378, -0.596925>, <-0.170753, 3.901252, -4.553438>,
				<-0.433272, 0.660869, -0.603862>, <-0.340207, 3.988372, -4.467444>
			}
			smooth_triangle {
				<-0.433272, 0.660869, -0.603862>, <-0.340207, 3.988372, -4.467444>,
				<-0.463662, 0.646378, -0.596925>, <-0.170753, 3.901252, -4.553438>,
				<-0.451855, 0.629268, -0.623659>, <-0.329512, 3.797705, -4.631831>
			}
			smooth_triangle {
				<-0.463662, 0.646378, -0.596925>, <-0.170753, 3.901252, -4.553438>,
				<-0.479442, 0.615398, -0.616881>, <-0.177165, 3.714518, -4.707083>,
				<-0.451855, 0.629268, -0.623659>, <-0.329512, 3.797705, -4.631831>
			}
			smooth_triangle {
				<-0.451855, 0.629268, -0.623659>, <-0.329512, 3.797705, -4.631831>,
				<-0.479442, 0.615398, -0.616881>, <-0.177165, 3.714518, -4.707083>,
				<-0.467598, 0.599628, -0.641021>, <-0.326438, 3.618901, -4.773253>
			}
			smooth_triangle {
				<-0.479442, 0.615398, -0.616881>, <-0.177165, 3.714518, -4.707083>,
				<-0.493061, 0.586798, -0.633780>, <-0.179683, 3.541387, -4.838853>,
				<-0.467598, 0.599628, -0.641021>, <-0.326438, 3.618901, -4.773253>
			}
			smooth_triangle {
				<-0.467598, 0.599628, -0.641021>, <-0.326438, 3.618901, -4.773253>,
				<-0.493061, 0.586798, -0.633780>, <-0.179683, 3.541387, -4.838853>,
				<-0.481839, 0.572138, -0.655441>, <-0.314801, 3.454044, -4.894878>
			}
			smooth_triangle {
				<-0.493061, 0.586798, -0.633780>, <-0.179683, 3.541387, -4.838853>,
				<-0.505642, 0.559648, -0.648261>, <-0.176588, 3.375707, -4.956061>,
				<-0.481839, 0.572138, -0.655441>, <-0.314801, 3.454044, -4.894878>
			}
			smooth_triangle {
				<-0.481839, 0.572138, -0.655441>, <-0.314801, 3.454044, -4.894878>,
				<-0.505642, 0.559648, -0.648261>, <-0.176588, 3.375707, -4.956061>,
				<-0.494174, 0.546888, -0.667700>, <-0.300839, 3.300658, -5.000618>
			}
			smooth_triangle {
				<-0.502572, 0.524688, -0.679138>, <-0.310402, 3.169517, -5.084464>,
				<-0.517459, 0.513498, -0.676516>, <-0.190080, 2.584687, -4.275454>,
				<-0.509452, 0.505698, -0.688365>, <-0.318205, 3.051678, -5.155694>
			}
			smooth_triangle {
				<-0.517354, 0.489338, -0.694266>, <-0.143269, 1.489953, -2.599753>,
				<-0.509452, 0.505698, -0.688365>, <-0.318205, 3.051678, -5.155694>,
				<-0.525202, 0.497088, -0.682772>, <-0.217701, 2.997317, -5.192702>
			}
			smooth_triangle {
				<-0.509452, 0.505698, -0.688365>, <-0.318205, 3.051678, -5.155694>,
				<-0.517459, 0.513498, -0.676516>, <-0.190080, 2.584687, -4.275454>,
				<-0.525202, 0.497088, -0.682772>, <-0.217701, 2.997317, -5.192702>
			}
			smooth_triangle {
				<-0.517459, 0.513498, -0.676516>, <-0.190080, 2.584687, -4.275454>,
				<-0.531952, 0.508208, -0.669223>, <-0.132319, 3.069573, -5.153067>,
				<-0.525202, 0.497088, -0.682772>, <-0.217701, 2.997317, -5.192702>
			}
			smooth_triangle {
				<-0.517354, 0.489338, -0.694266>, <-0.143269, 1.489953, -2.599753>,
				<-0.525202, 0.497088, -0.682772>, <-0.217701, 2.997317, -5.192702>,
				<-0.532817, 0.477718, -0.690650>, <-0.095812, 1.460650, -2.618542>
			}
			smooth_triangle {
				<-0.531952, 0.508208, -0.669223>, <-0.132319, 3.069573, -5.153067>,
				<-0.541566, 0.487708, -0.676729>, <-0.119260, 2.943367, -5.226532>,
				<-0.525202, 0.497088, -0.682772>, <-0.217701, 2.997317, -5.192702>
			}
			smooth_triangle {
				<-0.525202, 0.497088, -0.682772>, <-0.217701, 2.997317, -5.192702>,
				<-0.541566, 0.487708, -0.676729>, <-0.119260, 2.943367, -5.226532>,
				<-0.532817, 0.477718, -0.690650>, <-0.095812, 1.460650, -2.618542>
			}
			smooth_triangle {
				<-0.531952, 0.508208, -0.669223>, <-0.132319, 3.069573, -5.153067>,
				<-0.517459, 0.513498, -0.676516>, <-0.190080, 2.584687, -4.275454>,
				<-0.517563, 0.531538, -0.662343>, <-0.200337, 3.745764, -5.909092>
			}
			smooth_triangle {
				<-0.517563, 0.531538, -0.662343>, <-0.200337, 3.745764, -5.909092>,
				<-0.494174, 0.546888, -0.667700>, <-0.300839, 3.300658, -5.000618>,
				<-0.505642, 0.559648, -0.648261>, <-0.176588, 3.375707, -4.956061>
			}
			smooth_triangle {
				<-0.494174, 0.546888, -0.667700>, <-0.300839, 3.300658, -5.000618>,
				<-0.517563, 0.531538, -0.662343>, <-0.200337, 3.745764, -5.909092>,
				<-0.502572, 0.524688, -0.679138>, <-0.310402, 3.169517, -5.084464>
			}
			smooth_triangle {
				<-0.517563, 0.531538, -0.662343>, <-0.200337, 3.745764, -5.909092>,
				<-0.517459, 0.513498, -0.676516>, <-0.190080, 2.584687, -4.275454>,
				<-0.502572, 0.524688, -0.679138>, <-0.310402, 3.169517, -5.084464>
			}
			smooth_triangle {
				<-0.594192, 0.623848, -0.496847>, <0.369426, 1.881760, -2.306078>,
				<-0.559965, 0.643018, -0.511939>, <0.601192, 3.879177, -4.534805>,
				<-0.567912, 0.662848, -0.476682>, <0.350528, 2.000467, -2.206804>
			}
			smooth_triangle {
				<-0.567912, 0.662848, -0.476682>, <0.350528, 2.000467, -2.206804>,
				<-0.559965, 0.643018, -0.511939>, <0.601192, 3.879177, -4.534805>,
				<-0.532669, 0.682578, -0.489350>, <0.563763, 4.117899, -4.324051>
			}
			smooth_triangle {
				<-0.559965, 0.643018, -0.511939>, <0.601192, 3.879177, -4.534805>,
				<-0.524809, 0.661408, -0.525565>, <0.385274, 3.989387, -4.461973>,
				<-0.532669, 0.682578, -0.489350>, <0.563763, 4.117899, -4.324051>
			}
			smooth_triangle {
				<-0.532669, 0.682578, -0.489350>, <0.563763, 4.117899, -4.324051>,
				<-0.524809, 0.661408, -0.525565>, <0.385274, 3.989387, -4.461973>,
				<-0.497543, 0.700508, -0.500849>, <0.360298, 4.225260, -4.241523>
			}
			smooth_triangle {
				<-0.524809, 0.661408, -0.525565>, <0.385274, 3.989387, -4.461973>,
				<-0.489539, 0.679878, -0.535945>, <0.187806, 4.098793, -4.374734>,
				<-0.497543, 0.700508, -0.500849>, <0.360298, 4.225260, -4.241523>
			}
			smooth_triangle {
				<-0.497543, 0.700508, -0.500849>, <0.360298, 4.225260, -4.241523>,
				<-0.489539, 0.679878, -0.535945>, <0.187806, 4.098793, -4.374734>,
				<-0.464263, 0.716228, -0.510473>, <0.169818, 4.317902, -4.159853>
			}
			smooth_triangle {
				<-0.489539, 0.679878, -0.535945>, <0.187806, 4.098793, -4.374734>,
				<-0.455513, 0.697828, -0.542813>, <0.001737, 4.209558, -4.272831>,
				<-0.464263, 0.716228, -0.510473>, <0.169818, 4.317902, -4.159853>
			}
			smooth_triangle {
				<-0.464263, 0.716228, -0.510473>, <0.169818, 4.317902, -4.159853>,
				<-0.455513, 0.697828, -0.542813>, <0.001737, 4.209558, -4.272831>,
				<-0.431935, 0.732179, -0.516191>, <-0.011602, 4.416977, -4.057968>
			}
			smooth_triangle {
				<-0.455513, 0.697828, -0.542813>, <0.001737, 4.209558, -4.272831>,
				<-0.422491, 0.714079, -0.548356>, <-0.173787, 4.308374, -4.169518>,
				<-0.431935, 0.732179, -0.516191>, <-0.011602, 4.416977, -4.057968>
			}
			smooth_triangle {
				<-0.302182, 0.772349, -0.548883>, <-0.602204, 3.899534, -3.067802>,
				<-0.317617, 0.790929, -0.512500>, <-0.510606, 4.774476, -3.591904>,
				<-0.336269, 0.753879, -0.554704>, <-0.492812, 3.809142, -3.198336>
			}
			smooth_triangle {
				<-0.390006, 0.728249, -0.553762>, <-0.338311, 4.395231, -4.067389>,
				<-0.364281, 0.735629, -0.561485>, <-0.405011, 3.700373, -3.335946>,
				<-0.358494, 0.765449, -0.524111>, <-0.430344, 5.390854, -4.439295>
			}
			smooth_triangle {
				<-0.358494, 0.765449, -0.524111>, <-0.430344, 5.390854, -4.439295>,
				<-0.336269, 0.753879, -0.554704>, <-0.492812, 3.809142, -3.198336>,
				<-0.317617, 0.790929, -0.512500>, <-0.510606, 4.774476, -3.591904>
			}
			smooth_triangle {
				<-0.358494, 0.765449, -0.524111>, <-0.430344, 5.390854, -4.439295>,
				<-0.364281, 0.735629, -0.561485>, <-0.405011, 3.700373, -3.335946>,
				<-0.336269, 0.753879, -0.554704>, <-0.492812, 3.809142, -3.198336>
			}
			smooth_triangle {
				<-0.358494, 0.765449, -0.524111>, <-0.430344, 5.390854, -4.439295>,
				<-0.397413, 0.749389, -0.519232>, <-0.180371, 4.522028, -3.935784>,
				<-0.390006, 0.728249, -0.553762>, <-0.338311, 4.395231, -4.067389>
			}
			smooth_triangle {
				<-0.422491, 0.714079, -0.548356>, <-0.173787, 4.308374, -4.169518>,
				<-0.397413, 0.749389, -0.519232>, <-0.180371, 4.522028, -3.935784>,
				<-0.431935, 0.732179, -0.516191>, <-0.011602, 4.416977, -4.057968>
			}
			smooth_triangle {
				<-0.422491, 0.714079, -0.548356>, <-0.173787, 4.308374, -4.169518>,
				<-0.390006, 0.728249, -0.553762>, <-0.338311, 4.395231, -4.067389>,
				<-0.397413, 0.749389, -0.519232>, <-0.180371, 4.522028, -3.935784>
			}
			smooth_triangle {
				<-0.317617, 0.790929, -0.512500>, <-0.510606, 4.774476, -3.591904>,
				<-0.302182, 0.772349, -0.548883>, <-0.602204, 3.899534, -3.067802>,
				<-0.285414, 0.805959, -0.508022>, <-0.616682, 4.853072, -3.469306>
			}
			smooth_triangle {
				<-0.258269, 0.817559, -0.503986>, <-0.384236, 2.438535, -1.703941>,
				<-0.285414, 0.805959, -0.508022>, <-0.616682, 4.853072, -3.469306>,
				<-0.266572, 0.789959, -0.542226>, <-1.012698, 5.553831, -4.134722>
			}
			smooth_triangle {
				<-0.285414, 0.805959, -0.508022>, <-0.616682, 4.853072, -3.469306>,
				<-0.302182, 0.772349, -0.548883>, <-0.602204, 3.899534, -3.067802>,
				<-0.266572, 0.789959, -0.542226>, <-1.012698, 5.553831, -4.134722>
			}
			smooth_triangle {
				<-0.258269, 0.817559, -0.503986>, <-0.384236, 2.438535, -1.703941>,
				<-0.266572, 0.789959, -0.542226>, <-1.012698, 5.553831, -4.134722>,
				<-0.234533, 0.816089, -0.517781>, <-0.294607, 1.616403, -1.140335>
			}
			smooth_triangle {
				<-0.266572, 0.789959, -0.542226>, <-1.012698, 5.553831, -4.134722>,
				<-0.243277, 0.790689, -0.552035>, <-0.491866, 2.370763, -1.770169>,
				<-0.234533, 0.816089, -0.517781>, <-0.294607, 1.616403, -1.140335>
			}
			smooth_triangle {
				<-0.258269, 0.817559, -0.503986>, <-0.384236, 2.438535, -1.703941>,
				<-0.273829, 0.826809, -0.480121>, <-0.182011, 1.640150, -1.129360>,
				<-0.285414, 0.805959, -0.508022>, <-0.616682, 4.853072, -3.469306>
			}
			smooth_triangle {
				<-0.567912, 0.662848, -0.476682>, <0.350528, 2.000467, -2.206804>,
				<-0.532669, 0.682578, -0.489350>, <0.563763, 4.117899, -4.324051>,
				<-0.538809, 0.702658, -0.452842>, <0.332402, 2.120361, -2.094624>
			}
			smooth_triangle {
				<-0.538809, 0.702658, -0.452842>, <0.332402, 2.120361, -2.094624>,
				<-0.532669, 0.682578, -0.489350>, <0.563763, 4.117899, -4.324051>,
				<-0.502561, 0.721968, -0.464016>, <0.525306, 4.355795, -4.089109>
			}
			smooth_triangle {
				<-0.532669, 0.682578, -0.489350>, <0.563763, 4.117899, -4.324051>,
				<-0.497543, 0.700508, -0.500849>, <0.360298, 4.225260, -4.241523>,
				<-0.502561, 0.721968, -0.464016>, <0.525306, 4.355795, -4.089109>
			}
			smooth_triangle {
				<-0.502561, 0.721968, -0.464016>, <0.525306, 4.355795, -4.089109>,
				<-0.497543, 0.700508, -0.500849>, <0.360298, 4.225260, -4.241523>,
				<-0.467369, 0.737888, -0.475609>, <0.324250, 4.453340, -4.004171>
			}
			smooth_triangle {
				<-0.497543, 0.700508, -0.500849>, <0.360298, 4.225260, -4.241523>,
				<-0.464263, 0.716228, -0.510473>, <0.169818, 4.317902, -4.159853>,
				<-0.467369, 0.737888, -0.475609>, <0.324250, 4.453340, -4.004171>
			}
			smooth_triangle {
				<-0.467369, 0.737888, -0.475609>, <0.324250, 4.453340, -4.004171>,
				<-0.464263, 0.716228, -0.510473>, <0.169818, 4.317902, -4.159853>,
				<-0.440394, 0.746409, -0.487892>, <0.125910, 3.754198, -3.297468>
			}
			smooth_triangle {
				<-0.464263, 0.716228, -0.510473>, <0.169818, 4.317902, -4.159853>,
				<-0.431935, 0.732179, -0.516191>, <-0.011602, 4.416977, -4.057968>,
				<-0.440394, 0.746409, -0.487892>, <0.125910, 3.754198, -3.297468>
			}
			smooth_triangle {
				<-0.440394, 0.746409, -0.487892>, <0.125910, 3.754198, -3.297468>,
				<-0.431935, 0.732179, -0.516191>, <-0.011602, 4.416977, -4.057968>,
				<-0.408548, 0.766329, -0.484695>, <0.005462, 4.625169, -3.818338>
			}
			smooth_triangle {
				<-0.431935, 0.732179, -0.516191>, <-0.011602, 4.416977, -4.057968>,
				<-0.397413, 0.749389, -0.519232>, <-0.180371, 4.522028, -3.935784>,
				<-0.408548, 0.766329, -0.484695>, <0.005462, 4.625169, -3.818338>
			}
			smooth_triangle {
				<-0.408548, 0.766329, -0.484695>, <0.005462, 4.625169, -3.818338>,
				<-0.397413, 0.749389, -0.519232>, <-0.180371, 4.522028, -3.935784>,
				<-0.369595, 0.786569, -0.483544>, <-0.148287, 3.935574, -3.076680>
			}
			smooth_triangle {
				<-0.397413, 0.749389, -0.519232>, <-0.180371, 4.522028, -3.935784>,
				<-0.358494, 0.765449, -0.524111>, <-0.430344, 5.390854, -4.439295>,
				<-0.369595, 0.786569, -0.483544>, <-0.148287, 3.935574, -3.076680>
			}
			smooth_triangle {
				<-0.369595, 0.786569, -0.483544>, <-0.148287, 3.935574, -3.076680>,
				<-0.358494, 0.765449, -0.524111>, <-0.430344, 5.390854, -4.439295>,
				<-0.329552, 0.808069, -0.477003>, <-0.311333, 4.061757, -2.894179>
			}
			smooth_triangle {
				<-0.358494, 0.765449, -0.524111>, <-0.430344, 5.390854, -4.439295>,
				<-0.317617, 0.790929, -0.512500>, <-0.510606, 4.774476, -3.591904>,
				<-0.329552, 0.808069, -0.477003>, <-0.311333, 4.061757, -2.894179>
			}
			smooth_triangle {
				<-0.317617, 0.790929, -0.512500>, <-0.510606, 4.774476, -3.591904>,
				<-0.289305, 0.834569, -0.457057>, <-0.282902, 3.284647, -2.264055>,
				<-0.329552, 0.808069, -0.477003>, <-0.311333, 4.061757, -2.894179>
			}
			smooth_triangle {
				<-0.317617, 0.790929, -0.512500>, <-0.510606, 4.774476, -3.591904>,
				<-0.285414, 0.805959, -0.508022>, <-0.616682, 4.853072, -3.469306>,
				<-0.289305, 0.834569, -0.457057>, <-0.282902, 3.284647, -2.264055>
			}
			smooth_triangle {
				<-0.285414, 0.805959, -0.508022>, <-0.616682, 4.853072, -3.469306>,
				<-0.273829, 0.826809, -0.480121>, <-0.182011, 1.640150, -1.129360>,
				<-0.289305, 0.834569, -0.457057>, <-0.282902, 3.284647, -2.264055>
			}
			smooth_triangle {
				<-0.416078, 0.537198, -0.726234>, <-0.893117, 3.241803, -4.968490>,
				<-0.396402, 0.536029, -0.738006>, <-1.030336, 3.233139, -4.947513>,
				<-0.400352, 0.555858, -0.721011>, <-0.944774, 3.354389, -4.883406>
			}
			smooth_triangle {
				<-0.313807, 0.577859, -0.746141>, <-1.444381, 3.484564, -4.665325>,
				<-0.329633, 0.583639, -0.734727>, <-1.320397, 3.522104, -4.673758>,
				<-0.329464, 0.563359, -0.750456>, <-1.386123, 3.399192, -4.745329>
			}
			smooth_triangle {
				<-0.344778, 0.548199, -0.754798>, <-1.331616, 3.308339, -4.824468>,
				<-0.346405, 0.568059, -0.739204>, <-1.263900, 3.427429, -4.759029>,
				<-0.362301, 0.551489, -0.744115>, <-1.210394, 3.327816, -4.842916>
			}
			smooth_triangle {
				<-0.346405, 0.568059, -0.739204>, <-1.263900, 3.427429, -4.759029>,
				<-0.346961, 0.589289, -0.722132>, <-1.196728, 3.556442, -4.680918>,
				<-0.364541, 0.571789, -0.727510>, <-1.135730, 3.450337, -4.774720>
			}
			smooth_triangle {
				<-0.346961, 0.589289, -0.722132>, <-1.196728, 3.556442, -4.680918>,
				<-0.366201, 0.592659, -0.709761>, <-1.059534, 3.575495, -4.699484>,
				<-0.364541, 0.571789, -0.727510>, <-1.135730, 3.450337, -4.774720>
			}
			smooth_triangle {
				<-0.366201, 0.592659, -0.709761>, <-1.059534, 3.575495, -4.699484>,
				<-0.383624, 0.574499, -0.715466>, <-1.000808, 3.466793, -4.792900>,
				<-0.364541, 0.571789, -0.727510>, <-1.135730, 3.450337, -4.774720>
			}
			smooth_triangle {
				<-0.346405, 0.568059, -0.739204>, <-1.263900, 3.427429, -4.759029>,
				<-0.364541, 0.571789, -0.727510>, <-1.135730, 3.450337, -4.774720>,
				<-0.362301, 0.551489, -0.744115>, <-1.210394, 3.327816, -4.842916>
			}
			smooth_triangle {
				<-0.383624, 0.574499, -0.715466>, <-1.000808, 3.466793, -4.792900>,
				<-0.380879, 0.554119, -0.732808>, <-1.080954, 3.343632, -4.862510>,
				<-0.364541, 0.571789, -0.727510>, <-1.135730, 3.450337, -4.774720>
			}
			smooth_triangle {
				<-0.364541, 0.571789, -0.727510>, <-1.135730, 3.450337, -4.774720>,
				<-0.380879, 0.554119, -0.732808>, <-1.080954, 3.343632, -4.862510>,
				<-0.362301, 0.551489, -0.744115>, <-1.210394, 3.327816, -4.842916>
			}
			smooth_triangle {
				<-0.346961, 0.589289, -0.722132>, <-1.196728, 3.556442, -4.680918>,
				<-0.346405, 0.568059, -0.739204>, <-1.263900, 3.427429, -4.759029>,
				<-0.329633, 0.583639, -0.734727>, <-1.320397, 3.522104, -4.673758>
			}
			smooth_triangle {
				<-0.344778, 0.548199, -0.754798>, <-1.331616, 3.308339, -4.824468>,
				<-0.329464, 0.563359, -0.750456>, <-1.386123, 3.399192, -4.745329>,
				<-0.346405, 0.568059, -0.739204>, <-1.263900, 3.427429, -4.759029>
			}
			smooth_triangle {
				<-0.346405, 0.568059, -0.739204>, <-1.263900, 3.427429, -4.759029>,
				<-0.329464, 0.563359, -0.750456>, <-1.386123, 3.399192, -4.745329>,
				<-0.329633, 0.583639, -0.734727>, <-1.320397, 3.522104, -4.673758>
			}
			smooth_triangle {
				<-0.344778, 0.548199, -0.754798>, <-1.331616, 3.308339, -4.824468>,
				<-0.362301, 0.551489, -0.744115>, <-1.210394, 3.327816, -4.842916>,
				<-0.359242, 0.531809, -0.759762>, <-1.287297, 3.207585, -4.903831>
			}
			smooth_triangle {
				<-0.380879, 0.554119, -0.732808>, <-1.080954, 3.343632, -4.862510>,
				<-0.377176, 0.534419, -0.749165>, <-1.159575, 3.224601, -4.924499>,
				<-0.362301, 0.551489, -0.744115>, <-1.210394, 3.327816, -4.842916>
			}
			smooth_triangle {
				<-0.362301, 0.551489, -0.744115>, <-1.210394, 3.327816, -4.842916>,
				<-0.377176, 0.534419, -0.749165>, <-1.159575, 3.224601, -4.924499>,
				<-0.359242, 0.531809, -0.759762>, <-1.287297, 3.207585, -4.903831>
			}
			smooth_triangle {
				<-0.359242, 0.531809, -0.759762>, <-1.287297, 3.207585, -4.903831>,
				<-0.342313, 0.529669, -0.769020>, <-1.393192, 3.194617, -4.883411>,
				<-0.344778, 0.548199, -0.754798>, <-1.331616, 3.308339, -4.824468>
			}
			smooth_triangle {
				<-0.297069, 0.573379, -0.756374>, <-1.564055, 3.457840, -4.646437>,
				<-0.313807, 0.577859, -0.746141>, <-1.444381, 3.484564, -4.665325>,
				<-0.313206, 0.557649, -0.761604>, <-1.508604, 3.364763, -4.732436>
			}
			smooth_triangle {
				<-0.313807, 0.577859, -0.746141>, <-1.444381, 3.484564, -4.665325>,
				<-0.329464, 0.563359, -0.750456>, <-1.386123, 3.399192, -4.745329>,
				<-0.313206, 0.557649, -0.761604>, <-1.508604, 3.364763, -4.732436>
			}
			smooth_triangle {
				<-0.342313, 0.529669, -0.769020>, <-1.393192, 3.194617, -4.883411>,
				<-0.328293, 0.544309, -0.764897>, <-1.448133, 3.286757, -4.805693>,
				<-0.344778, 0.548199, -0.754798>, <-1.331616, 3.308339, -4.824468>
			}
			smooth_triangle {
				<-0.313206, 0.557649, -0.761604>, <-1.508604, 3.364763, -4.732436>,
				<-0.329464, 0.563359, -0.750456>, <-1.386123, 3.399192, -4.745329>,
				<-0.328293, 0.544309, -0.764897>, <-1.448133, 3.286757, -4.805693>
			}
			smooth_triangle {
				<-0.329464, 0.563359, -0.750456>, <-1.386123, 3.399192, -4.745329>,
				<-0.344778, 0.548199, -0.754798>, <-1.331616, 3.308339, -4.824468>,
				<-0.328293, 0.544309, -0.764897>, <-1.448133, 3.286757, -4.805693>
			}
			smooth_triangle {
				<-0.297069, 0.573379, -0.756374>, <-1.564055, 3.457840, -4.646437>,
				<-0.313206, 0.557649, -0.761604>, <-1.508604, 3.364763, -4.732436>,
				<-0.297736, 0.548889, -0.774064>, <-1.061938, 2.244274, -3.135970>
			}
			smooth_triangle {
				<-0.342313, 0.529669, -0.769020>, <-1.393192, 3.194617, -4.883411>,
				<-0.327266, 0.529029, -0.775980>, <-0.733475, 1.606306, -2.425086>,
				<-0.328293, 0.544309, -0.764897>, <-1.448133, 3.286757, -4.805693>
			}
			smooth_triangle {
				<-0.327266, 0.529029, -0.775980>, <-0.733475, 1.606306, -2.425086>,
				<-0.312149, 0.537519, -0.776368>, <-0.763213, 1.642387, -2.391575>,
				<-0.328293, 0.544309, -0.764897>, <-1.448133, 3.286757, -4.805693>
			}
			smooth_triangle {
				<-0.297736, 0.548889, -0.774064>, <-1.061938, 2.244274, -3.135970>,
				<-0.313206, 0.557649, -0.761604>, <-1.508604, 3.364763, -4.732436>,
				<-0.312149, 0.537519, -0.776368>, <-0.763213, 1.642387, -2.391575>
			}
			smooth_triangle {
				<-0.313206, 0.557649, -0.761604>, <-1.508604, 3.364763, -4.732436>,
				<-0.328293, 0.544309, -0.764897>, <-1.448133, 3.286757, -4.805693>,
				<-0.312149, 0.537519, -0.776368>, <-0.763213, 1.642387, -2.391575>
			}
			smooth_triangle {
				<-0.377176, 0.534419, -0.749165>, <-1.159575, 3.224601, -4.924499>,
				<-0.380879, 0.554119, -0.732808>, <-1.080954, 3.343632, -4.862510>,
				<-0.396402, 0.536029, -0.738006>, <-1.030336, 3.233139, -4.947513>
			}
			smooth_triangle {
				<-0.383624, 0.574499, -0.715466>, <-1.000808, 3.466793, -4.792900>,
				<-0.400352, 0.555858, -0.721011>, <-0.944774, 3.354389, -4.883406>,
				<-0.380879, 0.554119, -0.732808>, <-1.080954, 3.343632, -4.862510>
			}
			smooth_triangle {
				<-0.380879, 0.554119, -0.732808>, <-1.080954, 3.343632, -4.862510>,
				<-0.400352, 0.555858, -0.721011>, <-0.944774, 3.354389, -4.883406>,
				<-0.396402, 0.536029, -0.738006>, <-1.030336, 3.233139, -4.947513>
			}
			smooth_triangle {
				<-0.267076, 0.567059, -0.772155>, <-0.866435, 1.720942, -2.299360>,
				<-0.280870, 0.569779, -0.765228>, <-1.656947, 3.440238, -4.627409>,
				<-0.281817, 0.556139, -0.774850>, <-0.555270, 1.130939, -1.553167>
			}
			smooth_triangle {
				<-0.297069, 0.573379, -0.756374>, <-1.564055, 3.457840, -4.646437>,
				<-0.297736, 0.548889, -0.774064>, <-1.061938, 2.244274, -3.135970>,
				<-0.280870, 0.569779, -0.765228>, <-1.656947, 3.440238, -4.627409>
			}
			smooth_triangle {
				<-0.297736, 0.548889, -0.774064>, <-1.061938, 2.244274, -3.135970>,
				<-0.281817, 0.556139, -0.774850>, <-0.555270, 1.130939, -1.553167>,
				<-0.280870, 0.569779, -0.765228>, <-1.656947, 3.440238, -4.627409>
			}
			smooth_triangle {
				<-0.366201, 0.592659, -0.709761>, <-1.059534, 3.575495, -4.699484>,
				<-0.346961, 0.589289, -0.722132>, <-1.196728, 3.556442, -4.680918>,
				<-0.348073, 0.611249, -0.703093>, <-1.120021, 3.688454, -4.596888>
			}
			smooth_triangle {
				<-0.348073, 0.611249, -0.703093>, <-1.120021, 3.688454, -4.596888>,
				<-0.346961, 0.589289, -0.722132>, <-1.196728, 3.556442, -4.680918>,
				<-0.326042, 0.607649, -0.716632>, <-1.478403, 4.279051, -5.337783>
			}
			smooth_triangle {
				<-0.346961, 0.589289, -0.722132>, <-1.196728, 3.556442, -4.680918>,
				<-0.329633, 0.583639, -0.734727>, <-1.320397, 3.522104, -4.673758>,
				<-0.326042, 0.607649, -0.716632>, <-1.478403, 4.279051, -5.337783>
			}
			smooth_triangle {
				<-0.244254, 0.614769, -0.742639>, <-1.142453, 2.472847, -2.928826>,
				<-0.263923, 0.613089, -0.737283>, <-1.637151, 3.697656, -4.431709>,
				<-0.255856, 0.598329, -0.752094>, <-1.728412, 3.609492, -4.469769>
			}
			smooth_triangle {
				<-0.303461, 0.611639, -0.723139>, <-1.398723, 3.692367, -4.516902>,
				<-0.298482, 0.593679, -0.739980>, <-1.494533, 3.581661, -4.575074>,
				<-0.283765, 0.611939, -0.730842>, <-1.523226, 3.691523, -4.477141>
			}
			smooth_triangle {
				<-0.283765, 0.611939, -0.730842>, <-1.523226, 3.691523, -4.477141>,
				<-0.298482, 0.593679, -0.739980>, <-1.494533, 3.581661, -4.575074>,
				<-0.277732, 0.591719, -0.749572>, <-1.891096, 4.165177, -5.297591>
			}
			smooth_triangle {
				<-0.298482, 0.593679, -0.739980>, <-1.494533, 3.581661, -4.575074>,
				<-0.297069, 0.573379, -0.756374>, <-1.564055, 3.457840, -4.646437>,
				<-0.277732, 0.591719, -0.749572>, <-1.891096, 4.165177, -5.297591>
			}
			smooth_triangle {
				<-0.297069, 0.573379, -0.756374>, <-1.564055, 3.457840, -4.646437>,
				<-0.280870, 0.569779, -0.765228>, <-1.656947, 3.440238, -4.627409>,
				<-0.277732, 0.591719, -0.749572>, <-1.891096, 4.165177, -5.297591>
			}
			smooth_triangle {
				<-0.280870, 0.569779, -0.765228>, <-1.656947, 3.440238, -4.627409>,
				<-0.263462, 0.580979, -0.762995>, <-1.736619, 3.508485, -4.546400>,
				<-0.277732, 0.591719, -0.749572>, <-1.891096, 4.165177, -5.297591>
			}
			smooth_triangle {
				<-0.297069, 0.573379, -0.756374>, <-1.564055, 3.457840, -4.646437>,
				<-0.298482, 0.593679, -0.739980>, <-1.494533, 3.581661, -4.575074>,
				<-0.313807, 0.577859, -0.746141>, <-1.444381, 3.484564, -4.665325>
			}
			smooth_triangle {
				<-0.329633, 0.583639, -0.734727>, <-1.320397, 3.522104, -4.673758>,
				<-0.313807, 0.577859, -0.746141>, <-1.444381, 3.484564, -4.665325>,
				<-0.314385, 0.594969, -0.732314>, <-1.151979, 2.992233, -3.836045>
			}
			smooth_triangle {
				<-0.313807, 0.577859, -0.746141>, <-1.444381, 3.484564, -4.665325>,
				<-0.298482, 0.593679, -0.739980>, <-1.494533, 3.581661, -4.575074>,
				<-0.314385, 0.594969, -0.732314>, <-1.151979, 2.992233, -3.836045>
			}
			smooth_triangle {
				<-0.298482, 0.593679, -0.739980>, <-1.494533, 3.581661, -4.575074>,
				<-0.303461, 0.611639, -0.723139>, <-1.398723, 3.692367, -4.516902>,
				<-0.314385, 0.594969, -0.732314>, <-1.151979, 2.992233, -3.836045>
			}
			smooth_triangle {
				<-0.329633, 0.583639, -0.734727>, <-1.320397, 3.522104, -4.673758>,
				<-0.314385, 0.594969, -0.732314>, <-1.151979, 2.992233, -3.836045>,
				<-0.326042, 0.607649, -0.716632>, <-1.478403, 4.279051, -5.337783>
			}
			smooth_triangle {
				<-0.314385, 0.594969, -0.732314>, <-1.151979, 2.992233, -3.836045>,
				<-0.303461, 0.611639, -0.723139>, <-1.398723, 3.692367, -4.516902>,
				<-0.326042, 0.607649, -0.716632>, <-1.478403, 4.279051, -5.337783>
			}
			smooth_triangle {
				<-0.283765, 0.611939, -0.730842>, <-1.523226, 3.691523, -4.477141>,
				<-0.277732, 0.591719, -0.749572>, <-1.891096, 4.165177, -5.297591>,
				<-0.263923, 0.613089, -0.737283>, <-1.637151, 3.697656, -4.431709>
			}
			smooth_triangle {
				<-0.263462, 0.580979, -0.762995>, <-1.736619, 3.508485, -4.546400>,
				<-0.255856, 0.598329, -0.752094>, <-1.728412, 3.609492, -4.469769>,
				<-0.277732, 0.591719, -0.749572>, <-1.891096, 4.165177, -5.297591>
			}
			smooth_triangle {
				<-0.277732, 0.591719, -0.749572>, <-1.891096, 4.165177, -5.297591>,
				<-0.255856, 0.598329, -0.752094>, <-1.728412, 3.609492, -4.469769>,
				<-0.263923, 0.613089, -0.737283>, <-1.637151, 3.697656, -4.431709>
			}
			smooth_triangle {
				<-0.244254, 0.614769, -0.742639>, <-1.142453, 2.472847, -2.928826>,
				<-0.255856, 0.598329, -0.752094>, <-1.728412, 3.609492, -4.469769>,
				<-0.241020, 0.602129, -0.753969>, <-0.589781, 1.207054, -1.481526>
			}
			smooth_triangle {
				<-0.280870, 0.569779, -0.765228>, <-1.656947, 3.440238, -4.627409>,
				<-0.267076, 0.567059, -0.772155>, <-0.866435, 1.720942, -2.299360>,
				<-0.263462, 0.580979, -0.762995>, <-1.736619, 3.508485, -4.546400>
			}
			smooth_triangle {
				<-0.263462, 0.580979, -0.762995>, <-1.736619, 3.508485, -4.546400>,
				<-0.244368, 0.586829, -0.764867>, <-0.894150, 1.773642, -2.248155>,
				<-0.255856, 0.598329, -0.752094>, <-1.728412, 3.609492, -4.469769>
			}
			smooth_triangle {
				<-0.244368, 0.586829, -0.764867>, <-0.894150, 1.773642, -2.248155>,
				<-0.241020, 0.602129, -0.753969>, <-0.589781, 1.207054, -1.481526>,
				<-0.255856, 0.598329, -0.752094>, <-1.728412, 3.609492, -4.469769>
			}
			smooth_triangle {
				<-0.244368, 0.586829, -0.764867>, <-0.894150, 1.773642, -2.248155>,
				<-0.263462, 0.580979, -0.762995>, <-1.736619, 3.508485, -4.546400>,
				<-0.254532, 0.571789, -0.772903>, <-0.595429, 1.161009, -1.515713>
			}
			smooth_triangle {
				<-0.263462, 0.580979, -0.762995>, <-1.736619, 3.508485, -4.546400>,
				<-0.267076, 0.567059, -0.772155>, <-0.866435, 1.720942, -2.299360>,
				<-0.254532, 0.571789, -0.772903>, <-0.595429, 1.161009, -1.515713>
			}
			smooth_triangle {
				<-0.416078, 0.537198, -0.726234>, <-0.893117, 3.241803, -4.968490>,
				<-0.411678, 0.519218, -0.741649>, <-0.974429, 3.135230, -5.021410>,
				<-0.396402, 0.536029, -0.738006>, <-1.030336, 3.233139, -4.947513>
			}
			smooth_triangle {
				<-0.327266, 0.529029, -0.775980>, <-0.733475, 1.606306, -2.425086>,
				<-0.342313, 0.529669, -0.769020>, <-1.393192, 3.194617, -4.883411>,
				<-0.337901, 0.515389, -0.780580>, <-0.712496, 1.559307, -2.461742>
			}
			smooth_triangle {
				<-0.377176, 0.534419, -0.749165>, <-1.159575, 3.224601, -4.924499>,
				<-0.391254, 0.514849, -0.755627>, <-1.309396, 3.624597, -5.842749>,
				<-0.372155, 0.517769, -0.763234>, <-1.034064, 2.601922, -4.142003>
			}
			smooth_triangle {
				<-0.396535, 0.492289, -0.767801>, <-0.382325, 1.012371, -1.681915>,
				<-0.391254, 0.514849, -0.755627>, <-1.309396, 3.624597, -5.842749>,
				<-0.407437, 0.505028, -0.753693>, <-0.522228, 1.536167, -2.523141>
			}
			smooth_triangle {
				<-0.396535, 0.492289, -0.767801>, <-0.382325, 1.012371, -1.681915>,
				<-0.376557, 0.498599, -0.773769>, <-0.835795, 2.028196, -3.344434>,
				<-0.391254, 0.514849, -0.755627>, <-1.309396, 3.624597, -5.842749>
			}
			smooth_triangle {
				<-0.376557, 0.498599, -0.773769>, <-0.835795, 2.028196, -3.344434>,
				<-0.372155, 0.517769, -0.763234>, <-1.034064, 2.601922, -4.142003>,
				<-0.391254, 0.514849, -0.755627>, <-1.309396, 3.624597, -5.842749>
			}
			smooth_triangle {
				<-0.377176, 0.534419, -0.749165>, <-1.159575, 3.224601, -4.924499>,
				<-0.372155, 0.517769, -0.763234>, <-1.034064, 2.601922, -4.142003>,
				<-0.359242, 0.531809, -0.759762>, <-1.287297, 3.207585, -4.903831>
			}
			smooth_triangle {
				<-0.359242, 0.531809, -0.759762>, <-1.287297, 3.207585, -4.903831>,
				<-0.372155, 0.517769, -0.763234>, <-1.034064, 2.601922, -4.142003>,
				<-0.355929, 0.508829, -0.776862>, <-1.817027, 4.093772, -6.627816>
			}
			smooth_triangle {
				<-0.372155, 0.517769, -0.763234>, <-1.034064, 2.601922, -4.142003>,
				<-0.376557, 0.498599, -0.773769>, <-0.835795, 2.028196, -3.344434>,
				<-0.355929, 0.508829, -0.776862>, <-1.817027, 4.093772, -6.627816>
			}
			smooth_triangle {
				<-0.359242, 0.531809, -0.759762>, <-1.287297, 3.207585, -4.903831>,
				<-0.355929, 0.508829, -0.776862>, <-1.817027, 4.093772, -6.627816>,
				<-0.342313, 0.529669, -0.769020>, <-1.393192, 3.194617, -4.883411>
			}
			smooth_triangle {
				<-0.355929, 0.508829, -0.776862>, <-1.817027, 4.093772, -6.627816>,
				<-0.337901, 0.515389, -0.780580>, <-0.712496, 1.559307, -2.461742>,
				<-0.342313, 0.529669, -0.769020>, <-1.393192, 3.194617, -4.883411>
			}
			smooth_triangle {
				<-0.407437, 0.505028, -0.753693>, <-0.522228, 1.536167, -2.523141>,
				<-0.391254, 0.514849, -0.755627>, <-1.309396, 3.624597, -5.842749>,
				<-0.411678, 0.519218, -0.741649>, <-0.974429, 3.135230, -5.021410>
			}
			smooth_triangle {
				<-0.377176, 0.534419, -0.749165>, <-1.159575, 3.224601, -4.924499>,
				<-0.396402, 0.536029, -0.738006>, <-1.030336, 3.233139, -4.947513>,
				<-0.391254, 0.514849, -0.755627>, <-1.309396, 3.624597, -5.842749>
			}
			smooth_triangle {
				<-0.391254, 0.514849, -0.755627>, <-1.309396, 3.624597, -5.842749>,
				<-0.396402, 0.536029, -0.738006>, <-1.030336, 3.233139, -4.947513>,
				<-0.411678, 0.519218, -0.741649>, <-0.974429, 3.135230, -5.021410>
			}
			smooth_triangle {
				<-0.416078, 0.537198, -0.726234>, <-0.893117, 3.241803, -4.968490>,
				<-0.430673, 0.519468, -0.730606>, <-0.844709, 3.135727, -5.044598>,
				<-0.411678, 0.519218, -0.741649>, <-0.974429, 3.135230, -5.021410>
			}
			smooth_triangle {
				<-0.444243, 0.504618, -0.732886>, <-0.520783, 2.042348, -3.399413>,
				<-0.427092, 0.502278, -0.744602>, <-0.455503, 1.540158, -2.533728>,
				<-0.430673, 0.519468, -0.730606>, <-0.844709, 3.135727, -5.044598>
			}
			smooth_triangle {
				<-0.407437, 0.505028, -0.753693>, <-0.522228, 1.536167, -2.523141>,
				<-0.411678, 0.519218, -0.741649>, <-0.974429, 3.135230, -5.021410>,
				<-0.427092, 0.502278, -0.744602>, <-0.455503, 1.540158, -2.533728>
			}
			smooth_triangle {
				<-0.430673, 0.519468, -0.730606>, <-0.844709, 3.135727, -5.044598>,
				<-0.427092, 0.502278, -0.744602>, <-0.455503, 1.540158, -2.533728>,
				<-0.411678, 0.519218, -0.741649>, <-0.974429, 3.135230, -5.021410>
			}
			smooth_triangle {
				<-0.376557, 0.498599, -0.773769>, <-0.835795, 2.028196, -3.344434>,
				<-0.366596, 0.484179, -0.787584>, <-0.921958, 1.964220, -3.360038>,
				<-0.355929, 0.508829, -0.776862>, <-1.817027, 4.093772, -6.627816>
			}
			smooth_triangle {
				<-0.366596, 0.484179, -0.787584>, <-0.921958, 1.964220, -3.360038>,
				<-0.350828, 0.491769, -0.790058>, <-1.194675, 2.473756, -4.177356>,
				<-0.355929, 0.508829, -0.776862>, <-1.817027, 4.093772, -6.627816>
			}
			smooth_triangle {
				<-0.337901, 0.515389, -0.780580>, <-0.712496, 1.559307, -2.461742>,
				<-0.355929, 0.508829, -0.776862>, <-1.817027, 4.093772, -6.627816>,
				<-0.340783, 0.500699, -0.788853>, <-0.723100, 1.510142, -2.489154>
			}
			smooth_triangle {
				<-0.350828, 0.491769, -0.790058>, <-1.194675, 2.473756, -4.177356>,
				<-0.340783, 0.500699, -0.788853>, <-0.723100, 1.510142, -2.489154>,
				<-0.355929, 0.508829, -0.776862>, <-1.817027, 4.093772, -6.627816>
			}
			smooth_triangle {
				<-0.260543, 0.704029, -0.652357>, <-0.459385, 1.396372, -1.356108>,
				<-0.276851, 0.686559, -0.664154>, <-0.857234, 2.758714, -2.766079>,
				<-0.256225, 0.684689, -0.674282>, <-0.700757, 2.094165, -2.030515>
			}
			smooth_triangle {
				<-0.348073, 0.611249, -0.703093>, <-1.120021, 3.688454, -4.596888>,
				<-0.326042, 0.607649, -0.716632>, <-1.478403, 4.279051, -5.337783>,
				<-0.329786, 0.631309, -0.694118>, <-1.168416, 3.808012, -4.485959>
			}
			smooth_triangle {
				<-0.311842, 0.651259, -0.683903>, <-1.208367, 3.928227, -4.370349>,
				<-0.292129, 0.649659, -0.694061>, <-1.338834, 3.918725, -4.340847>,
				<-0.294168, 0.669389, -0.674166>, <-1.253893, 4.037537, -4.256506>
			}
			smooth_triangle {
				<-0.294168, 0.669389, -0.674166>, <-1.253893, 4.037537, -4.256506>,
				<-0.275225, 0.667259, -0.684199>, <-0.912282, 2.666710, -2.837910>,
				<-0.276851, 0.686559, -0.664154>, <-0.857234, 2.758714, -2.766079>
			}
			smooth_triangle {
				<-0.257932, 0.664159, -0.693880>, <-1.008924, 2.651649, -2.819401>,
				<-0.275225, 0.667259, -0.684199>, <-0.912282, 2.666710, -2.837910>,
				<-0.273343, 0.648269, -0.702958>, <-1.460520, 3.910757, -4.308791>
			}
			smooth_triangle {
				<-0.294168, 0.669389, -0.674166>, <-1.253893, 4.037537, -4.256506>,
				<-0.292129, 0.649659, -0.694061>, <-1.338834, 3.918725, -4.340847>,
				<-0.275225, 0.667259, -0.684199>, <-0.912282, 2.666710, -2.837910>
			}
			smooth_triangle {
				<-0.275225, 0.667259, -0.684199>, <-0.912282, 2.666710, -2.837910>,
				<-0.292129, 0.649659, -0.694061>, <-1.338834, 3.918725, -4.340847>,
				<-0.273343, 0.648269, -0.702958>, <-1.460520, 3.910757, -4.308791>
			}
			smooth_triangle {
				<-0.273343, 0.648269, -0.702958>, <-1.460520, 3.910757, -4.308791>,
				<-0.292129, 0.649659, -0.694061>, <-1.338834, 3.918725, -4.340847>,
				<-0.288640, 0.630499, -0.712927>, <-1.428492, 3.803879, -4.413913>
			}
			smooth_triangle {
				<-0.311842, 0.651259, -0.683903>, <-1.208367, 3.928227, -4.370349>,
				<-0.308795, 0.630479, -0.704448>, <-1.300080, 3.802817, -4.454159>,
				<-0.292129, 0.649659, -0.694061>, <-1.338834, 3.918725, -4.340847>
			}
			smooth_triangle {
				<-0.292129, 0.649659, -0.694061>, <-1.338834, 3.918725, -4.340847>,
				<-0.308795, 0.630479, -0.704448>, <-1.300080, 3.802817, -4.454159>,
				<-0.288640, 0.630499, -0.712927>, <-1.428492, 3.803879, -4.413913>
			}
			smooth_triangle {
				<-0.244213, 0.675519, -0.687860>, <-0.785973, 2.030724, -2.063374>,
				<-0.257932, 0.664159, -0.693880>, <-1.008924, 2.651649, -2.819401>,
				<-0.242230, 0.661619, -0.701925>, <-1.603452, 3.990276, -4.183468>
			}
			smooth_triangle {
				<-0.288640, 0.630499, -0.712927>, <-1.428492, 3.803879, -4.413913>,
				<-0.269626, 0.630369, -0.720449>, <-1.545495, 3.802674, -4.375453>,
				<-0.273343, 0.648269, -0.702958>, <-1.460520, 3.910757, -4.308791>
			}
			smooth_triangle {
				<-0.269626, 0.630369, -0.720449>, <-1.545495, 3.802674, -4.375453>,
				<-0.255844, 0.646979, -0.710683>, <-1.571222, 3.902873, -4.277043>,
				<-0.273343, 0.648269, -0.702958>, <-1.460520, 3.910757, -4.308791>
			}
			smooth_triangle {
				<-0.242230, 0.661619, -0.701925>, <-1.603452, 3.990276, -4.183468>,
				<-0.257932, 0.664159, -0.693880>, <-1.008924, 2.651649, -2.819401>,
				<-0.255844, 0.646979, -0.710683>, <-1.571222, 3.902873, -4.277043>
			}
			smooth_triangle {
				<-0.257932, 0.664159, -0.693880>, <-1.008924, 2.651649, -2.819401>,
				<-0.273343, 0.648269, -0.702958>, <-1.460520, 3.910757, -4.308791>,
				<-0.255844, 0.646979, -0.710683>, <-1.571222, 3.902873, -4.277043>
			}
			smooth_triangle {
				<-0.269626, 0.630369, -0.720449>, <-1.545495, 3.802674, -4.375453>,
				<-0.288640, 0.630499, -0.712927>, <-1.428492, 3.803879, -4.413913>,
				<-0.283765, 0.611939, -0.730842>, <-1.523226, 3.691523, -4.477141>
			}
			smooth_triangle {
				<-0.308795, 0.630479, -0.704448>, <-1.300080, 3.802817, -4.454159>,
				<-0.303461, 0.611639, -0.723139>, <-1.398723, 3.692367, -4.516902>,
				<-0.288640, 0.630499, -0.712927>, <-1.428492, 3.803879, -4.413913>
			}
			smooth_triangle {
				<-0.288640, 0.630499, -0.712927>, <-1.428492, 3.803879, -4.413913>,
				<-0.303461, 0.611639, -0.723139>, <-1.398723, 3.692367, -4.516902>,
				<-0.283765, 0.611939, -0.730842>, <-1.523226, 3.691523, -4.477141>
			}
			smooth_triangle {
				<-0.303461, 0.611639, -0.723139>, <-1.398723, 3.692367, -4.516902>,
				<-0.308795, 0.630479, -0.704448>, <-1.300080, 3.802817, -4.454159>,
				<-0.326042, 0.607649, -0.716632>, <-1.478403, 4.279051, -5.337783>
			}
			smooth_triangle {
				<-0.311842, 0.651259, -0.683903>, <-1.208367, 3.928227, -4.370349>,
				<-0.329786, 0.631309, -0.694118>, <-1.168416, 3.808012, -4.485959>,
				<-0.308795, 0.630479, -0.704448>, <-1.300080, 3.802817, -4.454159>
			}
			smooth_triangle {
				<-0.308795, 0.630479, -0.704448>, <-1.300080, 3.802817, -4.454159>,
				<-0.329786, 0.631309, -0.694118>, <-1.168416, 3.808012, -4.485959>,
				<-0.326042, 0.607649, -0.716632>, <-1.478403, 4.279051, -5.337783>
			}
			smooth_triangle {
				<-0.242230, 0.661619, -0.701925>, <-1.603452, 3.990276, -4.183468>,
				<-0.255844, 0.646979, -0.710683>, <-1.571222, 3.902873, -4.277043>,
				<-0.239728, 0.646119, -0.717052>, <-1.669870, 3.898772, -4.243415>
			}
			smooth_triangle {
				<-0.283765, 0.611939, -0.730842>, <-1.523226, 3.691523, -4.477141>,
				<-0.263923, 0.613089, -0.737283>, <-1.637151, 3.697656, -4.431709>,
				<-0.269626, 0.630369, -0.720449>, <-1.545495, 3.802674, -4.375453>
			}
			smooth_triangle {
				<-0.239728, 0.646119, -0.717052>, <-1.669870, 3.898772, -4.243415>,
				<-0.255844, 0.646979, -0.710683>, <-1.571222, 3.902873, -4.277043>,
				<-0.251710, 0.630789, -0.726540>, <-1.651748, 3.804837, -4.334648>
			}
			smooth_triangle {
				<-0.255844, 0.646979, -0.710683>, <-1.571222, 3.902873, -4.277043>,
				<-0.269626, 0.630369, -0.720449>, <-1.545495, 3.802674, -4.375453>,
				<-0.251710, 0.630789, -0.726540>, <-1.651748, 3.804837, -4.334648>
			}
			smooth_triangle {
				<-0.269626, 0.630369, -0.720449>, <-1.545495, 3.802674, -4.375453>,
				<-0.263923, 0.613089, -0.737283>, <-1.637151, 3.697656, -4.431709>,
				<-0.251710, 0.630789, -0.726540>, <-1.651748, 3.804837, -4.334648>
			}
			smooth_triangle {
				<-0.239728, 0.646119, -0.717052>, <-1.669870, 3.898772, -4.243415>,
				<-0.251710, 0.630789, -0.726540>, <-1.651748, 3.804837, -4.334648>,
				<-0.236385, 0.632869, -0.729870>, <-1.152866, 2.552391, -2.855545>
			}
			smooth_triangle {
				<-0.263923, 0.613089, -0.737283>, <-1.637151, 3.697656, -4.431709>,
				<-0.244254, 0.614769, -0.742639>, <-1.142453, 2.472847, -2.928826>,
				<-0.251710, 0.630789, -0.726540>, <-1.651748, 3.804837, -4.334648>
			}
			smooth_triangle {
				<-0.251710, 0.630789, -0.726540>, <-1.651748, 3.804837, -4.334648>,
				<-0.244254, 0.614769, -0.742639>, <-1.142453, 2.472847, -2.928826>,
				<-0.236385, 0.632869, -0.729870>, <-1.152866, 2.552391, -2.855545>
			}
			smooth_triangle {
				<-0.236385, 0.632869, -0.729870>, <-1.152866, 2.552391, -2.855545>,
				<-0.224963, 0.644269, -0.723476>, <-1.769458, 3.886676, -4.214005>,
				<-0.239728, 0.646119, -0.717052>, <-1.669870, 3.898772, -4.243415>
			}
			smooth_triangle {
				<-0.228782, 0.734609, -0.630173>, <-1.379917, 4.430002, -3.803321>,
				<-0.244816, 0.721179, -0.639589>, <-0.685281, 2.183428, -1.939485>,
				<-0.228407, 0.719339, -0.647679>, <-1.450625, 4.339159, -3.881016>
			}
			smooth_triangle {
				<-0.244213, 0.675519, -0.687860>, <-0.785973, 2.030724, -2.063374>,
				<-0.242230, 0.661619, -0.701925>, <-1.603452, 3.990276, -4.183468>,
				<-0.228278, 0.676699, -0.692159>, <-1.897598, 4.762433, -4.765656>
			}
			smooth_triangle {
				<-0.212036, 0.657379, -0.715538>, <-1.793496, 3.965439, -4.129713>,
				<-0.214073, 0.671959, -0.701258>, <-1.729616, 4.051306, -4.073217>,
				<-0.226947, 0.659759, -0.708744>, <-1.698014, 3.980039, -4.155868>
			}
			smooth_triangle {
				<-0.214073, 0.671959, -0.701258>, <-1.729616, 4.051306, -4.073217>,
				<-0.228278, 0.676699, -0.692159>, <-1.897598, 4.762433, -4.765656>,
				<-0.226947, 0.659759, -0.708744>, <-1.698014, 3.980039, -4.155868>
			}
			smooth_triangle {
				<-0.228278, 0.676699, -0.692159>, <-1.897598, 4.762433, -4.765656>,
				<-0.242230, 0.661619, -0.701925>, <-1.603452, 3.990276, -4.183468>,
				<-0.226947, 0.659759, -0.708744>, <-1.698014, 3.980039, -4.155868>
			}
			smooth_triangle {
				<-0.212036, 0.657379, -0.715538>, <-1.793496, 3.965439, -4.129713>,
				<-0.226947, 0.659759, -0.708744>, <-1.698014, 3.980039, -4.155868>,
				<-0.224963, 0.644269, -0.723476>, <-1.769458, 3.886676, -4.214005>
			}
			smooth_triangle {
				<-0.242230, 0.661619, -0.701925>, <-1.603452, 3.990276, -4.183468>,
				<-0.239728, 0.646119, -0.717052>, <-1.669870, 3.898772, -4.243415>,
				<-0.226947, 0.659759, -0.708744>, <-1.698014, 3.980039, -4.155868>
			}
			smooth_triangle {
				<-0.226947, 0.659759, -0.708744>, <-1.698014, 3.980039, -4.155868>,
				<-0.239728, 0.646119, -0.717052>, <-1.669870, 3.898772, -4.243415>,
				<-0.224963, 0.644269, -0.723476>, <-1.769458, 3.886676, -4.214005>
			}
			smooth_triangle {
				<-0.244213, 0.675519, -0.687860>, <-0.785973, 2.030724, -2.063374>,
				<-0.228278, 0.676699, -0.692159>, <-1.897598, 4.762433, -4.765656>,
				<-0.236022, 0.690069, -0.676170>, <-1.019880, 2.775722, -2.693077>
			}
			smooth_triangle {
				<-0.214073, 0.671959, -0.701258>, <-1.729616, 4.051306, -4.073217>,
				<-0.214085, 0.684159, -0.689355>, <-1.400280, 3.440192, -3.346898>,
				<-0.228278, 0.676699, -0.692159>, <-1.897598, 4.762433, -4.765656>
			}
			smooth_triangle {
				<-0.236022, 0.690069, -0.676170>, <-1.019880, 2.775722, -2.693077>,
				<-0.228278, 0.676699, -0.692159>, <-1.897598, 4.762433, -4.765656>,
				<-0.219898, 0.693189, -0.678408>, <-0.813287, 2.073251, -2.009913>
			}
			smooth_triangle {
				<-0.228278, 0.676699, -0.692159>, <-1.897598, 4.762433, -4.765656>,
				<-0.214085, 0.684159, -0.689355>, <-1.400280, 3.440192, -3.346898>,
				<-0.219898, 0.693189, -0.678408>, <-0.813287, 2.073251, -2.009913>
			}
			smooth_triangle {
				<-0.260543, 0.704029, -0.652357>, <-0.459385, 1.396372, -1.356108>,
				<-0.256225, 0.684689, -0.674282>, <-0.700757, 2.094165, -2.030515>,
				<-0.241948, 0.704269, -0.659227>, <-1.204924, 3.532326, -3.326587>
			}
			smooth_triangle {
				<-0.256225, 0.684689, -0.674282>, <-0.700757, 2.094165, -2.030515>,
				<-0.236022, 0.690069, -0.676170>, <-1.019880, 2.775722, -2.693077>,
				<-0.241948, 0.704269, -0.659227>, <-1.204924, 3.532326, -3.326587>
			}
			smooth_triangle {
				<-0.244816, 0.721179, -0.639589>, <-0.685281, 2.183428, -1.939485>,
				<-0.241948, 0.704269, -0.659227>, <-1.204924, 3.532326, -3.326587>,
				<-0.228407, 0.719339, -0.647679>, <-1.450625, 4.339159, -3.881016>
			}
			smooth_triangle {
				<-0.236022, 0.690069, -0.676170>, <-1.019880, 2.775722, -2.693077>,
				<-0.225102, 0.705489, -0.663872>, <-1.006778, 2.849794, -2.619799>,
				<-0.241948, 0.704269, -0.659227>, <-1.204924, 3.532326, -3.326587>
			}
			smooth_triangle {
				<-0.241948, 0.704269, -0.659227>, <-1.204924, 3.532326, -3.326587>,
				<-0.225102, 0.705489, -0.663872>, <-1.006778, 2.849794, -2.619799>,
				<-0.228407, 0.719339, -0.647679>, <-1.450625, 4.339159, -3.881016>
			}
			smooth_triangle {
				<-0.212036, 0.657379, -0.715538>, <-1.793496, 3.965439, -4.129713>,
				<-0.224963, 0.644269, -0.723476>, <-1.769458, 3.886676, -4.214005>,
				<-0.208568, 0.643139, -0.729375>, <-0.912296, 1.947129, -2.091780>
			}
			smooth_triangle {
				<-0.208568, 0.643139, -0.729375>, <-0.912296, 1.947129, -2.091780>,
				<-0.224963, 0.644269, -0.723476>, <-1.769458, 3.886676, -4.214005>,
				<-0.225774, 0.625889, -0.739192>, <-0.603907, 1.278228, -1.414710>
			}
			smooth_triangle {
				<-0.236385, 0.632869, -0.729870>, <-1.152866, 2.552391, -2.855545>,
				<-0.225774, 0.625889, -0.739192>, <-0.603907, 1.278228, -1.414710>,
				<-0.224963, 0.644269, -0.723476>, <-1.769458, 3.886676, -4.214005>
			}
			smooth_triangle {
				<-0.334818, 0.460969, -0.815176>, <-0.788094, 1.383639, -2.542445>,
				<-0.346679, 0.447409, -0.817768>, <-1.565971, 2.697364, -5.125207>,
				<-0.333445, 0.447149, -0.823403>, <-0.536075, 0.897907, -1.704748>
			}
			smooth_triangle {
				<-0.346679, 0.447409, -0.817768>, <-1.565971, 2.697364, -5.125207>,
				<-0.338193, 0.431899, -0.829575>, <-0.798389, 1.315190, -2.575395>,
				<-0.333445, 0.447149, -0.823403>, <-0.536075, 0.897907, -1.704748>
			}
			smooth_triangle {
				<-0.346679, 0.447409, -0.817768>, <-1.565971, 2.697364, -5.125207>,
				<-0.358880, 0.432959, -0.820284>, <-0.782168, 1.318408, -2.578663>,
				<-0.338193, 0.431899, -0.829575>, <-0.798389, 1.315190, -2.575395>
			}
			smooth_triangle {
				<-0.358880, 0.432959, -0.820284>, <-0.782168, 1.318408, -2.578663>,
				<-0.351142, 0.421319, -0.829636>, <-0.264975, 0.433829, -0.861151>,
				<-0.338193, 0.431899, -0.829575>, <-0.798389, 1.315190, -2.575395>
			}
			smooth_triangle {
				<-0.358880, 0.432959, -0.820284>, <-0.782168, 1.318408, -2.578663>,
				<-0.346679, 0.447409, -0.817768>, <-1.565971, 2.697364, -5.125207>,
				<-0.364116, 0.448709, -0.809442>, <-0.747201, 1.363090, -2.565738>
			}
			smooth_triangle {
				<-0.334818, 0.460969, -0.815176>, <-0.788094, 1.383639, -2.542445>,
				<-0.350164, 0.462549, -0.807795>, <-1.512433, 2.789780, -5.091725>,
				<-0.346679, 0.447409, -0.817768>, <-1.565971, 2.697364, -5.125207>
			}
			smooth_triangle {
				<-0.346679, 0.447409, -0.817768>, <-1.565971, 2.697364, -5.125207>,
				<-0.350164, 0.462549, -0.807795>, <-1.512433, 2.789780, -5.091725>,
				<-0.364116, 0.448709, -0.809442>, <-0.747201, 1.363090, -2.565738>
			}
			smooth_triangle {
				<-0.334818, 0.460969, -0.815176>, <-0.788094, 1.383639, -2.542445>,
				<-0.335388, 0.474549, -0.807113>, <-0.768894, 1.424384, -2.525777>,
				<-0.350164, 0.462549, -0.807795>, <-1.512433, 2.789780, -5.091725>
			}
			smooth_triangle {
				<-0.338834, 0.487209, -0.798073>, <-0.750083, 1.465424, -2.507884>,
				<-0.351686, 0.477709, -0.798268>, <-1.468990, 2.879385, -5.054389>,
				<-0.335388, 0.474549, -0.807113>, <-0.768894, 1.424384, -2.525777>
			}
			smooth_triangle {
				<-0.335388, 0.474549, -0.807113>, <-0.768894, 1.424384, -2.525777>,
				<-0.351686, 0.477709, -0.798268>, <-1.468990, 2.879385, -5.054389>,
				<-0.350164, 0.462549, -0.807795>, <-1.512433, 2.789780, -5.091725>
			}
			smooth_triangle {
				<-0.340783, 0.500699, -0.788853>, <-0.723100, 1.510142, -2.489154>,
				<-0.350828, 0.491769, -0.790058>, <-1.194675, 2.473756, -4.177356>,
				<-0.338834, 0.487209, -0.798073>, <-0.750083, 1.465424, -2.507884>
			}
			smooth_triangle {
				<-0.364116, 0.448709, -0.809442>, <-0.747201, 1.363090, -2.565738>,
				<-0.350164, 0.462549, -0.807795>, <-1.512433, 2.789780, -5.091725>,
				<-0.367889, 0.465729, -0.798039>, <-0.719346, 1.410599, -2.547965>
			}
			smooth_triangle {
				<-0.366596, 0.484179, -0.787584>, <-0.921958, 1.964220, -3.360038>,
				<-0.351686, 0.477709, -0.798268>, <-1.468990, 2.879385, -5.054389>,
				<-0.350828, 0.491769, -0.790058>, <-1.194675, 2.473756, -4.177356>
			}
			smooth_triangle {
				<-0.351686, 0.477709, -0.798268>, <-1.468990, 2.879385, -5.054389>,
				<-0.338834, 0.487209, -0.798073>, <-0.750083, 1.465424, -2.507884>,
				<-0.350828, 0.491769, -0.790058>, <-1.194675, 2.473756, -4.177356>
			}
			smooth_triangle {
				<-0.366596, 0.484179, -0.787584>, <-0.921958, 1.964220, -3.360038>,
				<-0.367889, 0.465729, -0.798039>, <-0.719346, 1.410599, -2.547965>,
				<-0.351686, 0.477709, -0.798268>, <-1.468990, 2.879385, -5.054389>
			}
			smooth_triangle {
				<-0.351686, 0.477709, -0.798268>, <-1.468990, 2.879385, -5.054389>,
				<-0.367889, 0.465729, -0.798039>, <-0.719346, 1.410599, -2.547965>,
				<-0.350164, 0.462549, -0.807795>, <-1.512433, 2.789780, -5.091725>
			}
			smooth_triangle {
				<-0.482178, 0.283508, -0.822340>, <-0.742022, 1.415262, -4.737350>,
				<-0.471773, 0.306008, -0.820301>, <-0.472180, 0.933573, -2.811508>,
				<-0.492974, 0.306458, -0.807576>, <-0.856008, 1.842665, -5.644863>
			}
			smooth_triangle {
				<-0.505259, 0.334898, -0.788457>, <-0.376998, 1.006314, -2.800824>,
				<-0.490841, 0.339958, -0.795372>, <-0.820340, 2.050361, -5.578390>,
				<-0.498410, 0.351828, -0.785444>, <-0.260826, 0.696215, -1.856636>
			}
			smooth_triangle {
				<-0.498410, 0.351828, -0.785444>, <-0.260826, 0.696215, -1.856636>,
				<-0.490841, 0.339958, -0.795372>, <-0.820340, 2.050361, -5.578390>,
				<-0.485018, 0.360338, -0.789958>, <-0.426414, 1.061069, -2.773427>
			}
			smooth_triangle {
				<-0.490841, 0.339958, -0.795372>, <-0.820340, 2.050361, -5.578390>,
				<-0.473966, 0.344548, -0.803592>, <-0.928321, 2.079065, -5.550628>,
				<-0.485018, 0.360338, -0.789958>, <-0.426414, 1.061069, -2.773427>
			}
			smooth_triangle {
				<-0.485018, 0.360338, -0.789958>, <-0.426414, 1.061069, -2.773427>,
				<-0.473966, 0.344548, -0.803592>, <-0.928321, 2.079065, -5.550628>,
				<-0.468175, 0.364878, -0.797982>, <-0.477038, 1.073138, -2.760493>
			}
			smooth_triangle {
				<-0.473966, 0.344548, -0.803592>, <-0.928321, 2.079065, -5.550628>,
				<-0.454087, 0.349268, -0.812976>, <-0.495273, 1.057432, -2.763319>,
				<-0.468175, 0.364878, -0.797982>, <-0.477038, 1.073138, -2.760493>
			}
			smooth_triangle {
				<-0.454087, 0.349268, -0.812976>, <-0.495273, 1.057432, -2.763319>,
				<-0.450725, 0.364818, -0.808004>, <-0.165222, 0.359224, -0.918509>,
				<-0.468175, 0.364878, -0.797982>, <-0.477038, 1.073138, -2.760493>
			}
			smooth_triangle {
				<-0.454087, 0.349268, -0.812976>, <-0.495273, 1.057432, -2.763319>,
				<-0.473966, 0.344548, -0.803592>, <-0.928321, 2.079065, -5.550628>,
				<-0.462757, 0.327858, -0.816992>, <-0.489049, 0.996674, -2.786852>
			}
			smooth_triangle {
				<-0.505259, 0.334898, -0.788457>, <-0.376998, 1.006314, -2.800824>,
				<-0.499669, 0.323208, -0.796855>, <-0.784300, 1.948235, -5.620053>,
				<-0.490841, 0.339958, -0.795372>, <-0.820340, 2.050361, -5.578390>
			}
			smooth_triangle {
				<-0.499669, 0.323208, -0.796855>, <-0.784300, 1.948235, -5.620053>,
				<-0.482124, 0.324718, -0.806982>, <-0.904404, 1.957100, -5.598759>,
				<-0.490841, 0.339958, -0.795372>, <-0.820340, 2.050361, -5.578390>
			}
			smooth_triangle {
				<-0.462757, 0.327858, -0.816992>, <-0.489049, 0.996674, -2.786852>,
				<-0.473966, 0.344548, -0.803592>, <-0.928321, 2.079065, -5.550628>,
				<-0.482124, 0.324718, -0.806982>, <-0.904404, 1.957100, -5.598759>
			}
			smooth_triangle {
				<-0.473966, 0.344548, -0.803592>, <-0.928321, 2.079065, -5.550628>,
				<-0.490841, 0.339958, -0.795372>, <-0.820340, 2.050361, -5.578390>,
				<-0.482124, 0.324718, -0.806982>, <-0.904404, 1.957100, -5.598759>
			}
			smooth_triangle {
				<-0.462757, 0.327858, -0.816992>, <-0.489049, 0.996674, -2.786852>,
				<-0.482124, 0.324718, -0.806982>, <-0.904404, 1.957100, -5.598759>,
				<-0.471773, 0.306008, -0.820301>, <-0.472180, 0.933573, -2.811508>
			}
			smooth_triangle {
				<-0.499669, 0.323208, -0.796855>, <-0.784300, 1.948235, -5.620053>,
				<-0.492974, 0.306458, -0.807576>, <-0.856008, 1.842665, -5.644863>,
				<-0.482124, 0.324718, -0.806982>, <-0.904404, 1.957100, -5.598759>
			}
			smooth_triangle {
				<-0.482124, 0.324718, -0.806982>, <-0.904404, 1.957100, -5.598759>,
				<-0.492974, 0.306458, -0.807576>, <-0.856008, 1.842665, -5.644863>,
				<-0.471773, 0.306008, -0.820301>, <-0.472180, 0.933573, -2.811508>
			}
			smooth_triangle {
				<-0.505259, 0.334898, -0.788457>, <-0.376998, 1.006314, -2.800824>,
				<-0.514630, 0.322938, -0.787381>, <-0.350705, 0.964527, -2.818880>,
				<-0.499669, 0.323208, -0.796855>, <-0.784300, 1.948235, -5.620053>
			}
			smooth_triangle {
				<-0.514630, 0.322938, -0.787381>, <-0.350705, 0.964527, -2.818880>,
				<-0.511618, 0.310148, -0.794464>, <-0.716942, 1.868144, -5.656056>,
				<-0.499669, 0.323208, -0.796855>, <-0.784300, 1.948235, -5.620053>
			}
			smooth_triangle {
				<-0.514100, 0.237298, -0.817616>, <-0.409429, 0.745246, -2.876677>,
				<-0.490818, 0.254778, -0.826616>, <-0.928797, 1.536600, -5.724161>,
				<-0.511598, 0.265438, -0.810512>, <-0.776828, 1.601540, -5.728799>
			}
			smooth_triangle {
				<-0.482178, 0.283508, -0.822340>, <-0.742022, 1.415262, -4.737350>,
				<-0.492974, 0.306458, -0.807576>, <-0.856008, 1.842665, -5.644863>,
				<-0.509497, 0.290938, -0.803045>, <-0.764545, 1.745008, -5.688734>
			}
			smooth_triangle {
				<-0.509497, 0.290938, -0.803045>, <-0.764545, 1.745008, -5.688734>,
				<-0.492974, 0.306458, -0.807576>, <-0.856008, 1.842665, -5.644863>,
				<-0.511618, 0.310148, -0.794464>, <-0.716942, 1.868144, -5.656056>
			}
			smooth_triangle {
				<-0.492974, 0.306458, -0.807576>, <-0.856008, 1.842665, -5.644863>,
				<-0.499669, 0.323208, -0.796855>, <-0.784300, 1.948235, -5.620053>,
				<-0.511618, 0.310148, -0.794464>, <-0.716942, 1.868144, -5.656056>
			}
			smooth_triangle {
				<-0.509497, 0.290938, -0.803045>, <-0.764545, 1.745008, -5.688734>,
				<-0.511598, 0.265438, -0.810512>, <-0.776828, 1.601540, -5.728799>,
				<-0.482178, 0.283508, -0.822340>, <-0.742022, 1.415262, -4.737350>
			}
			smooth_triangle {
				<-0.511598, 0.265438, -0.810512>, <-0.776828, 1.601540, -5.728799>,
				<-0.490818, 0.254778, -0.826616>, <-0.928797, 1.536600, -5.724161>,
				<-0.482178, 0.283508, -0.822340>, <-0.742022, 1.415262, -4.737350>
			}
			smooth_triangle {
				<-0.482178, 0.283508, -0.822340>, <-0.742022, 1.415262, -4.737350>,
				<-0.490818, 0.254778, -0.826616>, <-0.928797, 1.536600, -5.724161>,
				<-0.476911, 0.268828, -0.830297>, <-0.507504, 0.790506, -2.848840>
			}
			smooth_triangle {
				<-0.410004, 0.258228, -0.868516>, <-0.463211, 0.502912, -1.879455>,
				<-0.430648, 0.271748, -0.854287>, <-0.436712, 0.517082, -1.881884>,
				<-0.438879, 0.242298, -0.858947>, <-1.514874, 1.699042, -6.618059>
			}
			smooth_triangle {
				<-0.514100, 0.237298, -0.817616>, <-0.409429, 0.745246, -2.876677>,
				<-0.490073, 0.226598, -0.835218>, <-0.498391, 0.712941, -2.870795>,
				<-0.490818, 0.254778, -0.826616>, <-0.928797, 1.536600, -5.724161>
			}
			smooth_triangle {
				<-0.490073, 0.226598, -0.835218>, <-0.498391, 0.712941, -2.870795>,
				<-0.460705, 0.216468, -0.854404>, <-0.599920, 0.687528, -2.857415>,
				<-0.468882, 0.246678, -0.841669>, <-1.102029, 1.482988, -5.707450>
			}
			smooth_triangle {
				<-0.460705, 0.216468, -0.854404>, <-0.599920, 0.687528, -2.857415>,
				<-0.438879, 0.242298, -0.858947>, <-1.514874, 1.699042, -6.618059>,
				<-0.468882, 0.246678, -0.841669>, <-1.102029, 1.482988, -5.707450>
			}
			smooth_triangle {
				<-0.468882, 0.246678, -0.841669>, <-1.102029, 1.482988, -5.707450>,
				<-0.438879, 0.242298, -0.858947>, <-1.514874, 1.699042, -6.618059>,
				<-0.454524, 0.270768, -0.842137>, <-0.591919, 0.777480, -2.836192>
			}
			smooth_triangle {
				<-0.438879, 0.242298, -0.858947>, <-1.514874, 1.699042, -6.618059>,
				<-0.430648, 0.271748, -0.854287>, <-0.436712, 0.517082, -1.881884>,
				<-0.454524, 0.270768, -0.842137>, <-0.591919, 0.777480, -2.836192>
			}
			smooth_triangle {
				<-0.490073, 0.226598, -0.835218>, <-0.498391, 0.712941, -2.870795>,
				<-0.468882, 0.246678, -0.841669>, <-1.102029, 1.482988, -5.707450>,
				<-0.490818, 0.254778, -0.826616>, <-0.928797, 1.536600, -5.724161>
			}
			smooth_triangle {
				<-0.454524, 0.270768, -0.842137>, <-0.591919, 0.777480, -2.836192>,
				<-0.476911, 0.268828, -0.830297>, <-0.507504, 0.790506, -2.848840>,
				<-0.468882, 0.246678, -0.841669>, <-1.102029, 1.482988, -5.707450>
			}
			smooth_triangle {
				<-0.468882, 0.246678, -0.841669>, <-1.102029, 1.482988, -5.707450>,
				<-0.476911, 0.268828, -0.830297>, <-0.507504, 0.790506, -2.848840>,
				<-0.490818, 0.254778, -0.826616>, <-0.928797, 1.536600, -5.724161>
			}
			smooth_triangle {
				<-0.460705, 0.216468, -0.854404>, <-0.599920, 0.687528, -2.857415>,
				<-0.428803, 0.203088, -0.874072>, <-0.443484, 0.444717, -1.898820>,
				<-0.438879, 0.242298, -0.858947>, <-1.514874, 1.699042, -6.618059>
			}
			smooth_triangle {
				<-0.428803, 0.203088, -0.874072>, <-0.443484, 0.444717, -1.898820>,
				<-0.416453, 0.228588, -0.873743>, <-0.459105, 0.469391, -1.888967>,
				<-0.438879, 0.242298, -0.858947>, <-1.514874, 1.699042, -6.618059>
			}
			smooth_triangle {
				<-0.416453, 0.228588, -0.873743>, <-0.459105, 0.469391, -1.888967>,
				<-0.410004, 0.258228, -0.868516>, <-0.463211, 0.502912, -1.879455>,
				<-0.438879, 0.242298, -0.858947>, <-1.514874, 1.699042, -6.618059>
			}
			smooth_triangle {
				<-0.514100, 0.237298, -0.817616>, <-0.409429, 0.745246, -2.876677>,
				<-0.511598, 0.265438, -0.810512>, <-0.776828, 1.601540, -5.728799>,
				<-0.538331, 0.245858, -0.799293>, <-0.327709, 0.780715, -2.877851>
			}
			smooth_triangle {
				<-0.554218, 0.307508, -0.766420>, <-0.276788, 1.211953, -3.801721>,
				<-0.553887, 0.288928, -0.773852>, <-0.440574, 1.738283, -5.725124>,
				<-0.539207, 0.301328, -0.779474>, <-0.531510, 1.811215, -5.694880>
			}
			smooth_triangle {
				<-0.511598, 0.265438, -0.810512>, <-0.776828, 1.601540, -5.728799>,
				<-0.509497, 0.290938, -0.803045>, <-0.764545, 1.745008, -5.688734>,
				<-0.533109, 0.279888, -0.791560>, <-0.709876, 1.960036, -6.681442>
			}
			smooth_triangle {
				<-0.509497, 0.290938, -0.803045>, <-0.764545, 1.745008, -5.688734>,
				<-0.524376, 0.299938, -0.790051>, <-0.534147, 1.504296, -4.737920>,
				<-0.533109, 0.279888, -0.791560>, <-0.709876, 1.960036, -6.681442>
			}
			smooth_triangle {
				<-0.553887, 0.288928, -0.773852>, <-0.440574, 1.738283, -5.725124>,
				<-0.533109, 0.279888, -0.791560>, <-0.709876, 1.960036, -6.681442>,
				<-0.539207, 0.301328, -0.779474>, <-0.531510, 1.811215, -5.694880>
			}
			smooth_triangle {
				<-0.524376, 0.299938, -0.790051>, <-0.534147, 1.504296, -4.737920>,
				<-0.539207, 0.301328, -0.779474>, <-0.531510, 1.811215, -5.694880>,
				<-0.533109, 0.279888, -0.791560>, <-0.709876, 1.960036, -6.681442>
			}
			smooth_triangle {
				<-0.511598, 0.265438, -0.810512>, <-0.776828, 1.601540, -5.728799>,
				<-0.533109, 0.279888, -0.791560>, <-0.709876, 1.960036, -6.681442>,
				<-0.538331, 0.245858, -0.799293>, <-0.327709, 0.780715, -2.877851>
			}
			smooth_triangle {
				<-0.553887, 0.288928, -0.773852>, <-0.440574, 1.738283, -5.725124>,
				<-0.553181, 0.266368, -0.782407>, <-0.252071, 0.823301, -2.873475>,
				<-0.533109, 0.279888, -0.791560>, <-0.709876, 1.960036, -6.681442>
			}
			smooth_triangle {
				<-0.533109, 0.279888, -0.791560>, <-0.709876, 1.960036, -6.681442>,
				<-0.553181, 0.266368, -0.782407>, <-0.252071, 0.823301, -2.873475>,
				<-0.538331, 0.245858, -0.799293>, <-0.327709, 0.780715, -2.877851>
			}
			smooth_triangle {
				<-0.563848, 0.313008, -0.757113>, <-0.103128, 0.618196, -1.899192>,
				<-0.570803, 0.301128, -0.756720>, <-0.341797, 2.109812, -6.665080>,
				<-0.554218, 0.307508, -0.766420>, <-0.276788, 1.211953, -3.801721>
			}
			smooth_triangle {
				<-0.553181, 0.266368, -0.782407>, <-0.252071, 0.823301, -2.873475>,
				<-0.553887, 0.288928, -0.773852>, <-0.440574, 1.738283, -5.725124>,
				<-0.571706, 0.277178, -0.765139>, <-0.211051, 1.139612, -3.828053>
			}
			smooth_triangle {
				<-0.554218, 0.307508, -0.766420>, <-0.276788, 1.211953, -3.801721>,
				<-0.570803, 0.301128, -0.756720>, <-0.341797, 2.109812, -6.665080>,
				<-0.553887, 0.288928, -0.773852>, <-0.440574, 1.738283, -5.725124>
			}
			smooth_triangle {
				<-0.570803, 0.301128, -0.756720>, <-0.341797, 2.109812, -6.665080>,
				<-0.571706, 0.277178, -0.765139>, <-0.211051, 1.139612, -3.828053>,
				<-0.553887, 0.288928, -0.773852>, <-0.440574, 1.738283, -5.725124>
			}
			smooth_triangle {
				<-0.554218, 0.307508, -0.766420>, <-0.276788, 1.211953, -3.801721>,
				<-0.539207, 0.301328, -0.779474>, <-0.531510, 1.811215, -5.694880>,
				<-0.541038, 0.314258, -0.773068>, <-0.170943, 0.619334, -1.893936>
			}
			smooth_triangle {
				<-0.524376, 0.299938, -0.790051>, <-0.534147, 1.504296, -4.737920>,
				<-0.527881, 0.317248, -0.780896>, <-0.406224, 1.248989, -3.778116>,
				<-0.539207, 0.301328, -0.779474>, <-0.531510, 1.811215, -5.694880>
			}
			smooth_triangle {
				<-0.527881, 0.317248, -0.780896>, <-0.406224, 1.248989, -3.778116>,
				<-0.541038, 0.314258, -0.773068>, <-0.170943, 0.619334, -1.893936>,
				<-0.539207, 0.301328, -0.779474>, <-0.531510, 1.811215, -5.694880>
			}
			smooth_triangle {
				<-0.509497, 0.290938, -0.803045>, <-0.764545, 1.745008, -5.688734>,
				<-0.511618, 0.310148, -0.794464>, <-0.716942, 1.868144, -5.656056>,
				<-0.524376, 0.299938, -0.790051>, <-0.534147, 1.504296, -4.737920>
			}
			smooth_triangle {
				<-0.514630, 0.322938, -0.787381>, <-0.350705, 0.964527, -2.818880>,
				<-0.527881, 0.317248, -0.780896>, <-0.406224, 1.248989, -3.778116>,
				<-0.511618, 0.310148, -0.794464>, <-0.716942, 1.868144, -5.656056>
			}
			smooth_triangle {
				<-0.524376, 0.299938, -0.790051>, <-0.534147, 1.504296, -4.737920>,
				<-0.511618, 0.310148, -0.794464>, <-0.716942, 1.868144, -5.656056>,
				<-0.527881, 0.317248, -0.780896>, <-0.406224, 1.248989, -3.778116>
			}
			smooth_triangle {
				<-0.625162, 0.283798, -0.719540>, <0.058236, 1.201849, -3.814492>,
				<-0.610069, 0.274628, -0.735873>, <-0.031263, 0.859784, -2.873833>,
				<-0.603854, 0.301418, -0.730488>, <-0.033848, 1.818205, -5.716986>
			}
			smooth_triangle {
				<-0.586277, 0.312118, -0.740251>, <-0.156457, 1.879531, -5.695318>,
				<-0.589395, 0.289228, -0.747047>, <-0.171931, 1.744979, -5.737385>,
				<-0.570803, 0.301128, -0.756720>, <-0.341797, 2.109812, -6.665080>
			}
			smooth_triangle {
				<-0.570803, 0.301128, -0.756720>, <-0.341797, 2.109812, -6.665080>,
				<-0.589395, 0.289228, -0.747047>, <-0.171931, 1.744979, -5.737385>,
				<-0.571706, 0.277178, -0.765139>, <-0.211051, 1.139612, -3.828053>
			}
			smooth_triangle {
				<-0.592441, 0.268638, -0.752310>, <-0.059132, 0.561179, -1.918639>,
				<-0.571706, 0.277178, -0.765139>, <-0.211051, 1.139612, -3.828053>,
				<-0.589395, 0.289228, -0.747047>, <-0.171931, 1.744979, -5.737385>
			}
			smooth_triangle {
				<-0.592441, 0.268638, -0.752310>, <-0.059132, 0.561179, -1.918639>,
				<-0.589395, 0.289228, -0.747047>, <-0.171931, 1.744979, -5.737385>,
				<-0.610069, 0.274628, -0.735873>, <-0.031263, 0.859784, -2.873833>
			}
			smooth_triangle {
				<-0.586277, 0.312118, -0.740251>, <-0.156457, 1.879531, -5.695318>,
				<-0.603854, 0.301418, -0.730488>, <-0.033848, 1.818205, -5.716986>,
				<-0.589395, 0.289228, -0.747047>, <-0.171931, 1.744979, -5.737385>
			}
			smooth_triangle {
				<-0.589395, 0.289228, -0.747047>, <-0.171931, 1.744979, -5.737385>,
				<-0.603854, 0.301418, -0.730488>, <-0.033848, 1.818205, -5.716986>,
				<-0.610069, 0.274628, -0.735873>, <-0.031263, 0.859784, -2.873833>
			}
			smooth_triangle {
				<-0.586277, 0.312118, -0.740251>, <-0.156457, 1.879531, -5.695318>,
				<-0.570803, 0.301128, -0.756720>, <-0.341797, 2.109812, -6.665080>,
				<-0.575110, 0.319628, -0.745783>, <-0.111028, 0.946499, -2.844472>
			}
			smooth_triangle {
				<-0.570803, 0.301128, -0.756720>, <-0.341797, 2.109812, -6.665080>,
				<-0.563848, 0.313008, -0.757113>, <-0.103128, 0.618196, -1.899192>,
				<-0.575110, 0.319628, -0.745783>, <-0.111028, 0.946499, -2.844472>
			}
			smooth_triangle {
				<-0.664860, 0.421888, -0.607513>, <0.717361, 2.545043, -5.384278>,
				<-0.690202, 0.410827, -0.586484>, <0.428204, 1.270081, -2.683430>,
				<-0.682449, 0.383637, -0.613353>, <0.478481, 1.570700, -3.646826>
			}
			smooth_triangle {
				<-0.585957, 0.385878, -0.704881>, <0.010860, 1.164745, -2.764436>,
				<-0.597056, 0.399198, -0.687958>, <0.097318, 2.407871, -5.493970>,
				<-0.602470, 0.372688, -0.698035>, <0.086210, 2.244797, -5.562688>
			}
			smooth_triangle {
				<-0.602470, 0.372688, -0.698035>, <0.086210, 2.244797, -5.562688>,
				<-0.618335, 0.385698, -0.676773>, <0.241914, 2.322147, -5.525835>,
				<-0.624578, 0.349078, -0.690763>, <0.249642, 2.457359, -6.548171>
			}
			smooth_triangle {
				<-0.624578, 0.349078, -0.690763>, <0.249642, 2.457359, -6.548171>,
				<-0.645439, 0.369438, -0.660334>, <0.485526, 2.601237, -6.478836>,
				<-0.650324, 0.332188, -0.675164>, <0.384442, 2.011694, -5.638374>
			}
			smooth_triangle {
				<-0.650324, 0.332188, -0.675164>, <0.384442, 2.011694, -5.638374>,
				<-0.645439, 0.369438, -0.660334>, <0.485526, 2.601237, -6.478836>,
				<-0.667679, 0.344187, -0.651803>, <0.550944, 2.075910, -5.601346>
			}
			smooth_triangle {
				<-0.655424, 0.397368, -0.633746>, <0.570593, 2.401201, -5.467398>,
				<-0.682449, 0.383637, -0.613353>, <0.478481, 1.570700, -3.646826>,
				<-0.667483, 0.369837, -0.637817>, <0.506611, 1.862458, -4.611486>
			}
			smooth_triangle {
				<-0.682449, 0.383637, -0.613353>, <0.478481, 1.570700, -3.646826>,
				<-0.684727, 0.354127, -0.628373>, <0.334124, 1.074096, -2.780830>,
				<-0.667483, 0.369837, -0.637817>, <0.506611, 1.862458, -4.611486>
			}
			smooth_triangle {
				<-0.684727, 0.354127, -0.628373>, <0.334124, 1.074096, -2.780830>,
				<-0.667679, 0.344187, -0.651803>, <0.550944, 2.075910, -5.601346>,
				<-0.667483, 0.369837, -0.637817>, <0.506611, 1.862458, -4.611486>
			}
			smooth_triangle {
				<-0.655424, 0.397368, -0.633746>, <0.570593, 2.401201, -5.467398>,
				<-0.667483, 0.369837, -0.637817>, <0.506611, 1.862458, -4.611486>,
				<-0.645439, 0.369438, -0.660334>, <0.485526, 2.601237, -6.478836>
			}
			smooth_triangle {
				<-0.667483, 0.369837, -0.637817>, <0.506611, 1.862458, -4.611486>,
				<-0.667679, 0.344187, -0.651803>, <0.550944, 2.075910, -5.601346>,
				<-0.645439, 0.369438, -0.660334>, <0.485526, 2.601237, -6.478836>
			}
			smooth_triangle {
				<-0.650324, 0.332188, -0.675164>, <0.384442, 2.011694, -5.638374>,
				<-0.667679, 0.344187, -0.651803>, <0.550944, 2.075910, -5.601346>,
				<-0.671824, 0.311127, -0.664055>, <0.249340, 0.979321, -2.824503>
			}
			smooth_triangle {
				<-0.684727, 0.354127, -0.628373>, <0.334124, 1.074096, -2.780830>,
				<-0.684103, 0.327877, -0.643126>, <0.202942, 0.674645, -1.871653>,
				<-0.667679, 0.344187, -0.651803>, <0.550944, 2.075910, -5.601346>
			}
			smooth_triangle {
				<-0.667679, 0.344187, -0.651803>, <0.550944, 2.075910, -5.601346>,
				<-0.684103, 0.327877, -0.643126>, <0.202942, 0.674645, -1.871653>,
				<-0.671824, 0.311127, -0.664055>, <0.249340, 0.979321, -2.824503>
			}
			smooth_triangle {
				<-0.655424, 0.397368, -0.633746>, <0.570593, 2.401201, -5.467398>,
				<-0.645439, 0.369438, -0.660334>, <0.485526, 2.601237, -6.478836>,
				<-0.630599, 0.406618, -0.652776>, <0.387194, 2.450400, -5.461750>
			}
			smooth_triangle {
				<-0.624578, 0.349078, -0.690763>, <0.249642, 2.457359, -6.548171>,
				<-0.618335, 0.385698, -0.676773>, <0.241914, 2.322147, -5.525835>,
				<-0.645439, 0.369438, -0.660334>, <0.485526, 2.601237, -6.478836>
			}
			smooth_triangle {
				<-0.645439, 0.369438, -0.660334>, <0.485526, 2.601237, -6.478836>,
				<-0.618335, 0.385698, -0.676773>, <0.241914, 2.322147, -5.525835>,
				<-0.630599, 0.406618, -0.652776>, <0.387194, 2.450400, -5.461750>
			}
			smooth_triangle {
				<-0.630599, 0.406618, -0.652776>, <0.387194, 2.450400, -5.461750>,
				<-0.618335, 0.385698, -0.676773>, <0.241914, 2.322147, -5.525835>,
				<-0.607542, 0.416378, -0.668298>, <0.222020, 2.510334, -5.444115>
			}
			smooth_triangle {
				<-0.602470, 0.372688, -0.698035>, <0.086210, 2.244797, -5.562688>,
				<-0.597056, 0.399198, -0.687958>, <0.097318, 2.407871, -5.493970>,
				<-0.618335, 0.385698, -0.676773>, <0.241914, 2.322147, -5.525835>
			}
			smooth_triangle {
				<-0.618335, 0.385698, -0.676773>, <0.241914, 2.322147, -5.525835>,
				<-0.597056, 0.399198, -0.687958>, <0.097318, 2.407871, -5.493970>,
				<-0.607542, 0.416378, -0.668298>, <0.222020, 2.510334, -5.444115>
			}
			smooth_triangle {
				<-0.607542, 0.416378, -0.668298>, <0.222020, 2.510334, -5.444115>,
				<-0.597056, 0.399198, -0.687958>, <0.097318, 2.407871, -5.493970>,
				<-0.587121, 0.424718, -0.681190>, <0.074462, 2.563290, -5.423588>
			}
			smooth_triangle {
				<-0.585957, 0.385878, -0.704881>, <0.010860, 1.164745, -2.764436>,
				<-0.579493, 0.409268, -0.696990>, <0.008818, 1.237852, -2.732457>,
				<-0.597056, 0.399198, -0.687958>, <0.097318, 2.407871, -5.493970>
			}
			smooth_triangle {
				<-0.597056, 0.399198, -0.687958>, <0.097318, 2.407871, -5.493970>,
				<-0.579493, 0.409268, -0.696990>, <0.008818, 1.237852, -2.732457>,
				<-0.587121, 0.424718, -0.681190>, <0.074462, 2.563290, -5.423588>
			}
			smooth_triangle {
				<-0.682449, 0.383637, -0.613353>, <0.478481, 1.570700, -3.646826>,
				<-0.655424, 0.397368, -0.633746>, <0.570593, 2.401201, -5.467398>,
				<-0.664860, 0.421888, -0.607513>, <0.717361, 2.545043, -5.384278>
			}
			smooth_triangle {
				<-0.587121, 0.424718, -0.681190>, <0.074462, 2.563290, -5.423588>,
				<-0.594937, 0.443338, -0.662283>, <0.181485, 2.672925, -5.367788>,
				<-0.607542, 0.416378, -0.668298>, <0.222020, 2.510334, -5.444115>
			}
			smooth_triangle {
				<-0.594937, 0.443338, -0.662283>, <0.181485, 2.672925, -5.367788>,
				<-0.615395, 0.438048, -0.646931>, <0.345175, 2.640216, -5.375618>,
				<-0.607542, 0.416378, -0.668298>, <0.222020, 2.510334, -5.444115>
			}
			smooth_triangle {
				<-0.664860, 0.421888, -0.607513>, <0.717361, 2.545043, -5.384278>,
				<-0.655424, 0.397368, -0.633746>, <0.570593, 2.401201, -5.467398>,
				<-0.638846, 0.431918, -0.628036>, <0.520105, 2.607304, -5.377245>
			}
			smooth_triangle {
				<-0.655424, 0.397368, -0.633746>, <0.570593, 2.401201, -5.467398>,
				<-0.630599, 0.406618, -0.652776>, <0.387194, 2.450400, -5.461750>,
				<-0.638846, 0.431918, -0.628036>, <0.520105, 2.607304, -5.377245>
			}
			smooth_triangle {
				<-0.607542, 0.416378, -0.668298>, <0.222020, 2.510334, -5.444115>,
				<-0.615395, 0.438048, -0.646931>, <0.345175, 2.640216, -5.375618>,
				<-0.630599, 0.406618, -0.652776>, <0.387194, 2.450400, -5.461750>
			}
			smooth_triangle {
				<-0.630599, 0.406618, -0.652776>, <0.387194, 2.450400, -5.461750>,
				<-0.615395, 0.438048, -0.646931>, <0.345175, 2.640216, -5.375618>,
				<-0.638846, 0.431918, -0.628036>, <0.520105, 2.607304, -5.377245>
			}
			smooth_triangle {
				<-0.579493, 0.409268, -0.696990>, <0.008818, 1.237852, -2.732457>,
				<-0.566539, 0.430318, -0.694963>, <-0.003359, 1.305243, -2.701036>,
				<-0.587121, 0.424718, -0.681190>, <0.074462, 2.563290, -5.423588>
			}
			smooth_triangle {
				<-0.594937, 0.443338, -0.662283>, <0.181485, 2.672925, -5.367788>,
				<-0.587121, 0.424718, -0.681190>, <0.074462, 2.563290, -5.423588>,
				<-0.575758, 0.449278, -0.675100>, <0.045715, 2.710011, -5.352108>
			}
			smooth_triangle {
				<-0.587121, 0.424718, -0.681190>, <0.074462, 2.563290, -5.423588>,
				<-0.566539, 0.430318, -0.694963>, <-0.003359, 1.305243, -2.701036>,
				<-0.575758, 0.449278, -0.675100>, <0.045715, 2.710011, -5.352108>
			}
			smooth_triangle {
				<-0.566539, 0.430318, -0.694963>, <-0.003359, 1.305243, -2.701036>,
				<-0.561950, 0.451608, -0.685107>, <-0.008092, 1.372684, -2.667274>,
				<-0.575758, 0.449278, -0.675100>, <0.045715, 2.710011, -5.352108>
			}
			smooth_triangle {
				<-0.596017, 0.327618, -0.725629>, <-0.052248, 1.974179, -5.665047>,
				<-0.581480, 0.333438, -0.734720>, <-0.064970, 0.988816, -2.831474>,
				<-0.586669, 0.349678, -0.722951>, <-0.026167, 1.040712, -2.813408>
			}
			smooth_triangle {
				<-0.585957, 0.385878, -0.704881>, <0.010860, 1.164745, -2.764436>,
				<-0.602470, 0.372688, -0.698035>, <0.086210, 2.244797, -5.562688>,
				<-0.585448, 0.367768, -0.714916>, <-0.002282, 1.099590, -2.791102>
			}
			smooth_triangle {
				<-0.671824, 0.311127, -0.664055>, <0.249340, 0.979321, -2.824503>,
				<-0.654556, 0.304857, -0.683910>, <0.174618, 0.945282, -2.841553>,
				<-0.650324, 0.332188, -0.675164>, <0.384442, 2.011694, -5.638374>
			}
			smooth_triangle {
				<-0.654556, 0.304857, -0.683910>, <0.174618, 0.945282, -2.841553>,
				<-0.635468, 0.313818, -0.697721>, <0.220131, 1.900707, -5.685594>,
				<-0.650324, 0.332188, -0.675164>, <0.384442, 2.011694, -5.638374>
			}
			smooth_triangle {
				<-0.650324, 0.332188, -0.675164>, <0.384442, 2.011694, -5.638374>,
				<-0.635468, 0.313818, -0.697721>, <0.220131, 1.900707, -5.685594>,
				<-0.624578, 0.349078, -0.690763>, <0.249642, 2.457359, -6.548171>
			}
			smooth_triangle {
				<-0.635468, 0.313818, -0.697721>, <0.220131, 1.900707, -5.685594>,
				<-0.614826, 0.320728, -0.712901>, <0.086186, 1.932877, -5.678397>,
				<-0.624578, 0.349078, -0.690763>, <0.249642, 2.457359, -6.548171>
			}
			smooth_triangle {
				<-0.596017, 0.327618, -0.725629>, <-0.052248, 1.974179, -5.665047>,
				<-0.586669, 0.349678, -0.722951>, <-0.026167, 1.040712, -2.813408>,
				<-0.601899, 0.347998, -0.711138>, <0.035072, 2.098232, -5.620260>
			}
			smooth_triangle {
				<-0.602470, 0.372688, -0.698035>, <0.086210, 2.244797, -5.562688>,
				<-0.601899, 0.347998, -0.711138>, <0.035072, 2.098232, -5.620260>,
				<-0.585448, 0.367768, -0.714916>, <-0.002282, 1.099590, -2.791102>
			}
			smooth_triangle {
				<-0.586669, 0.349678, -0.722951>, <-0.026167, 1.040712, -2.813408>,
				<-0.585448, 0.367768, -0.714916>, <-0.002282, 1.099590, -2.791102>,
				<-0.601899, 0.347998, -0.711138>, <0.035072, 2.098232, -5.620260>
			}
			smooth_triangle {
				<-0.596017, 0.327618, -0.725629>, <-0.052248, 1.974179, -5.665047>,
				<-0.601899, 0.347998, -0.711138>, <0.035072, 2.098232, -5.620260>,
				<-0.614826, 0.320728, -0.712901>, <0.086186, 1.932877, -5.678397>
			}
			smooth_triangle {
				<-0.614826, 0.320728, -0.712901>, <0.086186, 1.932877, -5.678397>,
				<-0.601899, 0.347998, -0.711138>, <0.035072, 2.098232, -5.620260>,
				<-0.624578, 0.349078, -0.690763>, <0.249642, 2.457359, -6.548171>
			}
			smooth_triangle {
				<-0.601899, 0.347998, -0.711138>, <0.035072, 2.098232, -5.620260>,
				<-0.602470, 0.372688, -0.698035>, <0.086210, 2.244797, -5.562688>,
				<-0.624578, 0.349078, -0.690763>, <0.249642, 2.457359, -6.548171>
			}
			smooth_triangle {
				<-0.654556, 0.304857, -0.683910>, <0.174618, 0.945282, -2.841553>,
				<-0.641248, 0.291737, -0.701996>, <0.070874, 0.608101, -1.903831>,
				<-0.635468, 0.313818, -0.697721>, <0.220131, 1.900707, -5.685594>
			}
			smooth_triangle {
				<-0.596017, 0.327618, -0.725629>, <-0.052248, 1.974179, -5.665047>,
				<-0.614826, 0.320728, -0.712901>, <0.086186, 1.932877, -5.678397>,
				<-0.603854, 0.301418, -0.730488>, <-0.033848, 1.818205, -5.716986>
			}
			smooth_triangle {
				<-0.614826, 0.320728, -0.712901>, <0.086186, 1.932877, -5.678397>,
				<-0.625162, 0.283798, -0.719540>, <0.058236, 1.201849, -3.814492>,
				<-0.603854, 0.301418, -0.730488>, <-0.033848, 1.818205, -5.716986>
			}
			smooth_triangle {
				<-0.614826, 0.320728, -0.712901>, <0.086186, 1.932877, -5.678397>,
				<-0.635468, 0.313818, -0.697721>, <0.220131, 1.900707, -5.685594>,
				<-0.625162, 0.283798, -0.719540>, <0.058236, 1.201849, -3.814492>
			}
			smooth_triangle {
				<-0.635468, 0.313818, -0.697721>, <0.220131, 1.900707, -5.685594>,
				<-0.641248, 0.291737, -0.701996>, <0.070874, 0.608101, -1.903831>,
				<-0.625162, 0.283798, -0.719540>, <0.058236, 1.201849, -3.814492>
			}
			smooth_triangle {
				<-0.603854, 0.301418, -0.730488>, <-0.033848, 1.818205, -5.716986>,
				<-0.586277, 0.312118, -0.740251>, <-0.156457, 1.879531, -5.695318>,
				<-0.596017, 0.327618, -0.725629>, <-0.052248, 1.974179, -5.665047>
			}
			smooth_triangle {
				<-0.596017, 0.327618, -0.725629>, <-0.052248, 1.974179, -5.665047>,
				<-0.586277, 0.312118, -0.740251>, <-0.156457, 1.879531, -5.695318>,
				<-0.581480, 0.333438, -0.734720>, <-0.064970, 0.988816, -2.831474>
			}
			smooth_triangle {
				<-0.586277, 0.312118, -0.740251>, <-0.156457, 1.879531, -5.695318>,
				<-0.575110, 0.319628, -0.745783>, <-0.111028, 0.946499, -2.844472>,
				<-0.581480, 0.333438, -0.734720>, <-0.064970, 0.988816, -2.831474>
			}
			smooth_triangle {
				<-0.538809, 0.702658, -0.452842>, <0.332402, 2.120361, -2.094624>,
				<-0.502561, 0.721968, -0.464016>, <0.525306, 4.355795, -4.089109>,
				<-0.506297, 0.743098, -0.424956>, <0.311414, 2.241312, -1.967821>
			}
			smooth_triangle {
				<-0.289305, 0.834569, -0.457057>, <-0.282902, 3.284647, -2.264055>,
				<-0.300072, 0.842439, -0.435165>, <-0.126138, 2.503499, -1.647353>,
				<-0.329552, 0.808069, -0.477003>, <-0.311333, 4.061757, -2.894179>
			}
			smooth_triangle {
				<-0.300072, 0.842439, -0.435165>, <-0.126138, 2.503499, -1.647353>,
				<-0.339002, 0.822849, -0.443958>, <-0.122987, 4.152073, -2.779008>,
				<-0.329552, 0.808069, -0.477003>, <-0.311333, 4.061757, -2.894179>
			}
			smooth_triangle {
				<-0.506297, 0.743098, -0.424956>, <0.311414, 2.241312, -1.967821>,
				<-0.502561, 0.721968, -0.464016>, <0.525306, 4.355795, -4.089109>,
				<-0.468100, 0.761398, -0.436186>, <0.470447, 4.593510, -3.826735>
			}
			smooth_triangle {
				<-0.502561, 0.721968, -0.464016>, <0.525306, 4.355795, -4.089109>,
				<-0.467369, 0.737888, -0.475609>, <0.324250, 4.453340, -4.004171>,
				<-0.468100, 0.761398, -0.436186>, <0.470447, 4.593510, -3.826735>
			}
			smooth_triangle {
				<-0.339002, 0.822849, -0.443958>, <-0.122987, 4.152073, -2.779008>,
				<-0.380755, 0.802699, -0.447014>, <0.035005, 4.842588, -3.537037>,
				<-0.369595, 0.786569, -0.483544>, <-0.148287, 3.935574, -3.076680>
			}
			smooth_triangle {
				<-0.468100, 0.761398, -0.436186>, <0.470447, 4.593510, -3.826735>,
				<-0.467369, 0.737888, -0.475609>, <0.324250, 4.453340, -4.004171>,
				<-0.427468, 0.777099, -0.450008>, <0.277537, 5.471673, -4.351376>
			}
			smooth_triangle {
				<-0.467369, 0.737888, -0.475609>, <0.324250, 4.453340, -4.004171>,
				<-0.440394, 0.746409, -0.487892>, <0.125910, 3.754198, -3.297468>,
				<-0.427468, 0.777099, -0.450008>, <0.277537, 5.471673, -4.351376>
			}
			smooth_triangle {
				<-0.369595, 0.786569, -0.483544>, <-0.148287, 3.935574, -3.076680>,
				<-0.380755, 0.802699, -0.447014>, <0.035005, 4.842588, -3.537037>,
				<-0.408548, 0.766329, -0.484695>, <0.005462, 4.625169, -3.818338>
			}
			smooth_triangle {
				<-0.380755, 0.802699, -0.447014>, <0.035005, 4.842588, -3.537037>,
				<-0.427468, 0.777099, -0.450008>, <0.277537, 5.471673, -4.351376>,
				<-0.408548, 0.766329, -0.484695>, <0.005462, 4.625169, -3.818338>
			}
			smooth_triangle {
				<-0.440394, 0.746409, -0.487892>, <0.125910, 3.754198, -3.297468>,
				<-0.408548, 0.766329, -0.484695>, <0.005462, 4.625169, -3.818338>,
				<-0.427468, 0.777099, -0.450008>, <0.277537, 5.471673, -4.351376>
			}
			smooth_triangle {
				<-0.300072, 0.842439, -0.435165>, <-0.126138, 2.503499, -1.647353>,
				<-0.305681, 0.853179, -0.409584>, <-0.051053, 3.421633, -2.068292>,
				<-0.339002, 0.822849, -0.443958>, <-0.122987, 4.152073, -2.779008>
			}
			smooth_triangle {
				<-0.305681, 0.853179, -0.409584>, <-0.051053, 3.421633, -2.068292>,
				<-0.345615, 0.839569, -0.405930>, <0.031747, 5.066603, -3.207040>,
				<-0.339002, 0.822849, -0.443958>, <-0.122987, 4.152073, -2.779008>
			}
			smooth_triangle {
				<-0.506297, 0.743098, -0.424956>, <0.311414, 2.241312, -1.967821>,
				<-0.468100, 0.761398, -0.436186>, <0.470447, 4.593510, -3.826735>,
				<-0.469024, 0.783648, -0.393743>, <0.288372, 2.361948, -1.824694>
			}
			smooth_triangle {
				<-0.339002, 0.822849, -0.443958>, <-0.122987, 4.152073, -2.779008>,
				<-0.345615, 0.839569, -0.405930>, <0.031747, 5.066603, -3.207040>,
				<-0.380755, 0.802699, -0.447014>, <0.035005, 4.842588, -3.537037>
			}
			smooth_triangle {
				<-0.345615, 0.839569, -0.405930>, <0.031747, 5.066603, -3.207040>,
				<-0.390191, 0.818759, -0.408041>, <0.213959, 4.937156, -3.396869>,
				<-0.380755, 0.802699, -0.447014>, <0.035005, 4.842588, -3.537037>
			}
			smooth_triangle {
				<-0.469024, 0.783648, -0.393743>, <0.288372, 2.361948, -1.824694>,
				<-0.468100, 0.761398, -0.436186>, <0.470447, 4.593510, -3.826735>,
				<-0.430670, 0.800309, -0.403916>, <0.421701, 4.824826, -3.536467>
			}
			smooth_triangle {
				<-0.468100, 0.761398, -0.436186>, <0.470447, 4.593510, -3.826735>,
				<-0.427468, 0.777099, -0.450008>, <0.277537, 5.471673, -4.351376>,
				<-0.430670, 0.800309, -0.403916>, <0.421701, 4.824826, -3.536467>
			}
			smooth_triangle {
				<-0.380755, 0.802699, -0.447014>, <0.035005, 4.842588, -3.537037>,
				<-0.390191, 0.818759, -0.408041>, <0.213959, 4.937156, -3.396869>,
				<-0.427468, 0.777099, -0.450008>, <0.277537, 5.471673, -4.351376>
			}
			smooth_triangle {
				<-0.390191, 0.818759, -0.408041>, <0.213959, 4.937156, -3.396869>,
				<-0.430670, 0.800309, -0.403916>, <0.421701, 4.824826, -3.536467>,
				<-0.427468, 0.777099, -0.450008>, <0.277537, 5.471673, -4.351376>
			}
			smooth_triangle {
				<-0.149137, 0.718350, -0.671444>, <-1.918888, 4.332798, -3.680030>,
				<-0.144997, 0.728230, -0.661641>, <-0.960836, 2.185987, -1.816032>,
				<-0.154158, 0.725130, -0.662975>, <-1.552888, 3.639122, -3.056869>
			}
			smooth_triangle {
				<-0.227827, 0.777179, -0.577230>, <-0.790354, 3.116961, -2.378153>,
				<-0.227916, 0.762079, -0.596984>, <-1.252663, 4.597092, -3.645323>,
				<-0.206145, 0.778829, -0.583127>, <-1.528985, 5.483112, -4.072319>
			}
			smooth_triangle {
				<-0.227916, 0.762079, -0.596984>, <-1.252663, 4.597092, -3.645323>,
				<-0.210433, 0.759669, -0.606407>, <-1.375737, 4.585917, -3.615246>,
				<-0.206145, 0.778829, -0.583127>, <-1.528985, 5.483112, -4.072319>
			}
			smooth_triangle {
				<-0.149827, 0.765690, -0.616742>, <-1.694365, 4.621448, -3.430607>,
				<-0.160325, 0.768510, -0.610570>, <-1.619740, 4.639653, -3.441830>,
				<-0.159437, 0.758140, -0.623638>, <-1.679082, 4.575422, -3.499103>
			}
			smooth_triangle {
				<-0.206145, 0.778829, -0.583127>, <-1.528985, 5.483112, -4.072319>,
				<-0.210433, 0.759669, -0.606407>, <-1.375737, 4.585917, -3.615246>,
				<-0.193483, 0.769719, -0.599338>, <-1.192865, 3.871592, -2.929475>
			}
			smooth_triangle {
				<-0.210433, 0.759669, -0.606407>, <-1.375737, 4.585917, -3.615246>,
				<-0.195986, 0.753209, -0.619169>, <-1.745626, 5.304179, -4.220291>,
				<-0.193483, 0.769719, -0.599338>, <-1.192865, 3.871592, -2.929475>
			}
			smooth_triangle {
				<-0.167991, 0.750140, -0.631016>, <-1.667904, 4.526216, -3.567836>,
				<-0.168930, 0.758960, -0.620124>, <-1.343459, 3.816391, -2.937311>,
				<-0.180073, 0.750129, -0.627679>, <-1.853843, 5.283165, -4.200696>
			}
			smooth_triangle {
				<-0.195986, 0.753209, -0.619169>, <-1.745626, 5.304179, -4.220291>,
				<-0.176646, 0.767589, -0.607213>, <-1.782444, 5.404823, -4.074350>,
				<-0.193483, 0.769719, -0.599338>, <-1.192865, 3.871592, -2.929475>
			}
			smooth_triangle {
				<-0.195986, 0.753209, -0.619169>, <-1.745626, 5.304179, -4.220291>,
				<-0.180073, 0.750129, -0.627679>, <-1.853843, 5.283165, -4.200696>,
				<-0.176646, 0.767589, -0.607213>, <-1.782444, 5.404823, -4.074350>
			}
			smooth_triangle {
				<-0.180073, 0.750129, -0.627679>, <-1.853843, 5.283165, -4.200696>,
				<-0.168930, 0.758960, -0.620124>, <-1.343459, 3.816391, -2.937311>,
				<-0.176646, 0.767589, -0.607213>, <-1.782444, 5.404823, -4.074350>
			}
			smooth_triangle {
				<-0.176646, 0.767589, -0.607213>, <-1.782444, 5.404823, -4.074350>,
				<-0.168930, 0.758960, -0.620124>, <-1.343459, 3.816391, -2.937311>,
				<-0.160325, 0.768510, -0.610570>, <-1.619740, 4.639653, -3.441830>
			}
			smooth_triangle {
				<-0.167991, 0.750140, -0.631016>, <-1.667904, 4.526216, -3.567836>,
				<-0.159437, 0.758140, -0.623638>, <-1.679082, 4.575422, -3.499103>,
				<-0.168930, 0.758960, -0.620124>, <-1.343459, 3.816391, -2.937311>
			}
			smooth_triangle {
				<-0.168930, 0.758960, -0.620124>, <-1.343459, 3.816391, -2.937311>,
				<-0.159437, 0.758140, -0.623638>, <-1.679082, 4.575422, -3.499103>,
				<-0.160325, 0.768510, -0.610570>, <-1.619740, 4.639653, -3.441830>
			}
			smooth_triangle {
				<-0.227827, 0.777179, -0.577230>, <-0.790354, 3.116961, -2.378153>,
				<-0.206145, 0.778829, -0.583127>, <-1.528985, 5.483112, -4.072319>,
				<-0.214279, 0.790809, -0.563743>, <-0.617572, 2.388057, -1.706923>
			}
			smooth_triangle {
				<-0.149827, 0.765690, -0.616742>, <-1.694365, 4.621448, -3.430607>,
				<-0.147679, 0.777290, -0.602592>, <-1.645002, 4.691103, -3.359085>,
				<-0.160325, 0.768510, -0.610570>, <-1.619740, 4.639653, -3.441830>
			}
			smooth_triangle {
				<-0.147679, 0.777290, -0.602592>, <-1.645002, 4.691103, -3.359085>,
				<-0.159312, 0.782890, -0.592296>, <-1.548751, 4.724671, -3.357227>,
				<-0.160325, 0.768510, -0.610570>, <-1.619740, 4.639653, -3.441830>
			}
			smooth_triangle {
				<-0.214279, 0.790809, -0.563743>, <-0.617572, 2.388057, -1.706923>,
				<-0.206145, 0.778829, -0.583127>, <-1.528985, 5.483112, -4.072319>,
				<-0.190751, 0.802349, -0.555851>, <-1.277460, 4.840578, -3.304722>
			}
			smooth_triangle {
				<-0.160325, 0.768510, -0.610570>, <-1.619740, 4.639653, -3.441830>,
				<-0.159312, 0.782890, -0.592296>, <-1.548751, 4.724671, -3.357227>,
				<-0.176646, 0.767589, -0.607213>, <-1.782444, 5.404823, -4.074350>
			}
			smooth_triangle {
				<-0.190751, 0.802349, -0.555851>, <-1.277460, 4.840578, -3.304722>,
				<-0.206145, 0.778829, -0.583127>, <-1.528985, 5.483112, -4.072319>,
				<-0.177903, 0.788469, -0.579463>, <-1.656673, 5.551768, -3.926306>
			}
			smooth_triangle {
				<-0.206145, 0.778829, -0.583127>, <-1.528985, 5.483112, -4.072319>,
				<-0.193483, 0.769719, -0.599338>, <-1.192865, 3.871592, -2.929475>,
				<-0.177903, 0.788469, -0.579463>, <-1.656673, 5.551768, -3.926306>
			}
			smooth_triangle {
				<-0.193483, 0.769719, -0.599338>, <-1.192865, 3.871592, -2.929475>,
				<-0.176646, 0.767589, -0.607213>, <-1.782444, 5.404823, -4.074350>,
				<-0.177903, 0.788469, -0.579463>, <-1.656673, 5.551768, -3.926306>
			}
			smooth_triangle {
				<-0.176646, 0.767589, -0.607213>, <-1.782444, 5.404823, -4.074350>,
				<-0.159312, 0.782890, -0.592296>, <-1.548751, 4.724671, -3.357227>,
				<-0.177903, 0.788469, -0.579463>, <-1.656673, 5.551768, -3.926306>
			}
			smooth_triangle {
				<-0.149827, 0.765690, -0.616742>, <-1.694365, 4.621448, -3.430607>,
				<-0.159437, 0.758140, -0.623638>, <-1.679082, 4.575422, -3.499103>,
				<-0.150632, 0.755950, -0.628468>, <-1.739678, 4.561562, -3.487635>
			}
			smooth_triangle {
				<-0.167991, 0.750140, -0.631016>, <-1.667904, 4.526216, -3.567836>,
				<-0.158796, 0.749240, -0.634463>, <-1.723525, 4.520243, -3.548954>,
				<-0.159437, 0.758140, -0.623638>, <-1.679082, 4.575422, -3.499103>
			}
			smooth_triangle {
				<-0.159437, 0.758140, -0.623638>, <-1.679082, 4.575422, -3.499103>,
				<-0.158796, 0.749240, -0.634463>, <-1.723525, 4.520243, -3.548954>,
				<-0.150632, 0.755950, -0.628468>, <-1.739678, 4.561562, -3.487635>
			}
			smooth_triangle {
				<-0.147679, 0.777290, -0.602592>, <-1.645002, 4.691103, -3.359085>,
				<-0.149827, 0.765690, -0.616742>, <-1.694365, 4.621448, -3.430607>,
				<-0.139397, 0.772110, -0.611173>, <-1.723926, 4.657935, -3.365856>
			}
			smooth_triangle {
				<-0.150632, 0.755950, -0.628468>, <-1.739678, 4.561562, -3.487635>,
				<-0.141329, 0.761780, -0.623573>, <-1.764910, 4.596661, -3.428296>,
				<-0.149827, 0.765690, -0.616742>, <-1.694365, 4.621448, -3.430607>
			}
			smooth_triangle {
				<-0.149827, 0.765690, -0.616742>, <-1.694365, 4.621448, -3.430607>,
				<-0.141329, 0.761780, -0.623573>, <-1.764910, 4.596661, -3.428296>,
				<-0.139397, 0.772110, -0.611173>, <-1.723926, 4.657935, -3.365856>
			}
			smooth_triangle {
				<-0.141329, 0.761780, -0.623573>, <-1.764910, 4.596661, -3.428296>,
				<-0.150632, 0.755950, -0.628468>, <-1.739678, 4.561562, -3.487635>,
				<-0.143341, 0.752800, -0.633920>, <-1.794111, 4.542697, -3.484807>
			}
			smooth_triangle {
				<-0.158796, 0.749240, -0.634463>, <-1.723525, 4.520243, -3.548954>,
				<-0.150952, 0.747750, -0.638121>, <-1.775759, 4.511783, -3.534015>,
				<-0.150632, 0.755950, -0.628468>, <-1.739678, 4.561562, -3.487635>
			}
			smooth_triangle {
				<-0.150632, 0.755950, -0.628468>, <-1.739678, 4.561562, -3.487635>,
				<-0.150952, 0.747750, -0.638121>, <-1.775759, 4.511783, -3.534015>,
				<-0.143341, 0.752800, -0.633920>, <-1.794111, 4.542697, -3.484807>
			}
			smooth_triangle {
				<-0.150952, 0.747750, -0.638121>, <-1.775759, 4.511783, -3.534015>,
				<-0.158796, 0.749240, -0.634463>, <-1.723525, 4.520243, -3.548954>,
				<-0.157504, 0.741940, -0.643301>, <-1.767089, 4.476143, -3.583333>
			}
			smooth_triangle {
				<-0.227916, 0.762079, -0.596984>, <-1.252663, 4.597092, -3.645323>,
				<-0.225144, 0.748699, -0.614714>, <-1.112958, 3.765021, -3.095436>,
				<-0.210433, 0.759669, -0.606407>, <-1.375737, 4.585917, -3.615246>
			}
			smooth_triangle {
				<-0.225144, 0.748699, -0.614714>, <-1.112958, 3.765021, -3.095436>,
				<-0.213392, 0.744629, -0.623780>, <-1.431116, 4.493638, -3.708720>,
				<-0.210433, 0.759669, -0.606407>, <-1.375737, 4.585917, -3.615246>
			}
			smooth_triangle {
				<-0.195986, 0.753209, -0.619169>, <-1.745626, 5.304179, -4.220291>,
				<-0.193224, 0.740019, -0.635729>, <-1.570223, 4.466891, -3.684788>,
				<-0.180073, 0.750129, -0.627679>, <-1.853843, 5.283165, -4.200696>
			}
			smooth_triangle {
				<-0.193224, 0.740019, -0.635729>, <-1.570223, 4.466891, -3.684788>,
				<-0.182983, 0.737519, -0.641633>, <-1.636523, 4.450932, -3.675391>,
				<-0.180073, 0.750129, -0.627679>, <-1.853843, 5.283165, -4.200696>
			}
			smooth_triangle {
				<-0.158796, 0.749240, -0.634463>, <-1.723525, 4.520243, -3.548954>,
				<-0.167991, 0.750140, -0.631016>, <-1.667904, 4.526216, -3.567836>,
				<-0.166161, 0.741220, -0.641950>, <-2.005132, 5.217880, -4.213199>
			}
			smooth_triangle {
				<-0.182983, 0.737519, -0.641633>, <-1.636523, 4.450932, -3.675391>,
				<-0.174746, 0.734800, -0.647031>, <-1.699705, 4.432611, -3.668970>,
				<-0.174414, 0.742799, -0.637923>, <-1.385221, 3.735301, -3.021112>
			}
			smooth_triangle {
				<-0.174746, 0.734800, -0.647031>, <-1.699705, 4.432611, -3.668970>,
				<-0.166161, 0.741220, -0.641950>, <-2.005132, 5.217880, -4.213199>,
				<-0.174414, 0.742799, -0.637923>, <-1.385221, 3.735301, -3.021112>
			}
			smooth_triangle {
				<-0.166161, 0.741220, -0.641950>, <-2.005132, 5.217880, -4.213199>,
				<-0.167991, 0.750140, -0.631016>, <-1.667904, 4.526216, -3.567836>,
				<-0.174414, 0.742799, -0.637923>, <-1.385221, 3.735301, -3.021112>
			}
			smooth_triangle {
				<-0.182983, 0.737519, -0.641633>, <-1.636523, 4.450932, -3.675391>,
				<-0.174414, 0.742799, -0.637923>, <-1.385221, 3.735301, -3.021112>,
				<-0.180073, 0.750129, -0.627679>, <-1.853843, 5.283165, -4.200696>
			}
			smooth_triangle {
				<-0.174414, 0.742799, -0.637923>, <-1.385221, 3.735301, -3.021112>,
				<-0.167991, 0.750140, -0.631016>, <-1.667904, 4.526216, -3.567836>,
				<-0.180073, 0.750129, -0.627679>, <-1.853843, 5.283165, -4.200696>
			}
			smooth_triangle {
				<-0.158796, 0.749240, -0.634463>, <-1.723525, 4.520243, -3.548954>,
				<-0.166161, 0.741220, -0.641950>, <-2.005132, 5.217880, -4.213199>,
				<-0.157504, 0.741940, -0.643301>, <-1.767089, 4.476143, -3.583333>
			}
			smooth_triangle {
				<-0.174746, 0.734800, -0.647031>, <-1.699705, 4.432611, -3.668970>,
				<-0.167663, 0.732800, -0.651160>, <-1.746479, 4.422113, -3.659723>,
				<-0.166161, 0.741220, -0.641950>, <-2.005132, 5.217880, -4.213199>
			}
			smooth_triangle {
				<-0.167663, 0.732800, -0.651160>, <-1.746479, 4.422113, -3.659723>,
				<-0.161891, 0.736600, -0.648327>, <-1.472172, 3.702695, -3.020270>,
				<-0.166161, 0.741220, -0.641950>, <-2.005132, 5.217880, -4.213199>
			}
			smooth_triangle {
				<-0.166161, 0.741220, -0.641950>, <-2.005132, 5.217880, -4.213199>,
				<-0.161891, 0.736600, -0.648327>, <-1.472172, 3.702695, -3.020270>,
				<-0.157504, 0.741940, -0.643301>, <-1.767089, 4.476143, -3.583333>
			}
			smooth_triangle {
				<-0.193224, 0.740019, -0.635729>, <-1.570223, 4.466891, -3.684788>,
				<-0.195986, 0.753209, -0.619169>, <-1.745626, 5.304179, -4.220291>,
				<-0.204313, 0.739829, -0.632468>, <-1.255450, 3.721335, -3.094047>
			}
			smooth_triangle {
				<-0.213392, 0.744629, -0.623780>, <-1.431116, 4.493638, -3.708720>,
				<-0.195986, 0.753209, -0.619169>, <-1.745626, 5.304179, -4.220291>,
				<-0.210433, 0.759669, -0.606407>, <-1.375737, 4.585917, -3.615246>
			}
			smooth_triangle {
				<-0.213392, 0.744629, -0.623780>, <-1.431116, 4.493638, -3.708720>,
				<-0.204313, 0.739829, -0.632468>, <-1.255450, 3.721335, -3.094047>,
				<-0.195986, 0.753209, -0.619169>, <-1.745626, 5.304179, -4.220291>
			}
			smooth_triangle {
				<-0.143341, 0.752800, -0.633920>, <-1.794111, 4.542697, -3.484807>,
				<-0.150952, 0.747750, -0.638121>, <-1.775759, 4.511783, -3.534015>,
				<-0.144599, 0.745540, -0.642172>, <-1.819638, 4.498413, -3.528735>
			}
			smooth_triangle {
				<-0.167663, 0.732800, -0.651160>, <-1.746479, 4.422113, -3.659723>,
				<-0.161741, 0.731070, -0.654588>, <-1.793417, 4.411371, -3.650038>,
				<-0.161891, 0.736600, -0.648327>, <-1.472172, 3.702695, -3.020270>
			}
			smooth_triangle {
				<-0.161741, 0.731070, -0.654588>, <-1.793417, 4.411371, -3.650038>,
				<-0.156374, 0.735830, -0.650541>, <-1.802156, 4.438784, -3.612317>,
				<-0.161891, 0.736600, -0.648327>, <-1.472172, 3.702695, -3.020270>
			}
			smooth_triangle {
				<-0.144599, 0.745540, -0.642172>, <-1.819638, 4.498413, -3.528735>,
				<-0.150952, 0.747750, -0.638121>, <-1.775759, 4.511783, -3.534015>,
				<-0.150777, 0.740810, -0.646204>, <-1.807769, 4.468111, -3.573092>
			}
			smooth_triangle {
				<-0.150952, 0.747750, -0.638121>, <-1.775759, 4.511783, -3.534015>,
				<-0.157504, 0.741940, -0.643301>, <-1.767089, 4.476143, -3.583333>,
				<-0.150777, 0.740810, -0.646204>, <-1.807769, 4.468111, -3.573092>
			}
			smooth_triangle {
				<-0.161891, 0.736600, -0.648327>, <-1.472172, 3.702695, -3.020270>,
				<-0.156374, 0.735830, -0.650541>, <-1.802156, 4.438784, -3.612317>,
				<-0.157504, 0.741940, -0.643301>, <-1.767089, 4.476143, -3.583333>
			}
			smooth_triangle {
				<-0.157504, 0.741940, -0.643301>, <-1.767089, 4.476143, -3.583333>,
				<-0.156374, 0.735830, -0.650541>, <-1.802156, 4.438784, -3.612317>,
				<-0.150777, 0.740810, -0.646204>, <-1.807769, 4.468111, -3.573092>
			}
			smooth_triangle {
				<-0.144599, 0.745540, -0.642172>, <-1.819638, 4.498413, -3.528735>,
				<-0.150777, 0.740810, -0.646204>, <-1.807769, 4.468111, -3.573092>,
				<-0.144671, 0.739100, -0.649553>, <-1.849399, 4.457795, -3.564667>
			}
			smooth_triangle {
				<-0.161741, 0.731070, -0.654588>, <-1.793417, 4.411371, -3.650038>,
				<-0.155811, 0.729920, -0.657306>, <-1.827749, 4.405226, -3.640401>,
				<-0.156374, 0.735830, -0.650541>, <-1.802156, 4.438784, -3.612317>
			}
			smooth_triangle {
				<-0.155811, 0.729920, -0.657306>, <-1.827749, 4.405226, -3.640401>,
				<-0.150459, 0.734530, -0.653402>, <-1.837618, 4.431007, -3.603965>,
				<-0.156374, 0.735830, -0.650541>, <-1.802156, 4.438784, -3.612317>
			}
			smooth_triangle {
				<-0.144671, 0.739100, -0.649553>, <-1.849399, 4.457795, -3.564667>,
				<-0.150777, 0.740810, -0.646204>, <-1.807769, 4.468111, -3.573092>,
				<-0.150459, 0.734530, -0.653402>, <-1.837618, 4.431007, -3.603965>
			}
			smooth_triangle {
				<-0.150777, 0.740810, -0.646204>, <-1.807769, 4.468111, -3.573092>,
				<-0.156374, 0.735830, -0.650541>, <-1.802156, 4.438784, -3.612317>,
				<-0.150459, 0.734530, -0.653402>, <-1.837618, 4.431007, -3.603965>
			}
			smooth_triangle {
				<-0.144671, 0.739100, -0.649553>, <-1.849399, 4.457795, -3.564667>,
				<-0.150459, 0.734530, -0.653402>, <-1.837618, 4.431007, -3.603965>,
				<-0.144541, 0.733130, -0.656306>, <-0.930586, 2.215246, -1.796269>
			}
			smooth_triangle {
				<-0.155811, 0.729920, -0.657306>, <-1.827749, 4.405226, -3.640401>,
				<-0.150562, 0.728280, -0.660339>, <-0.925789, 2.202960, -1.813781>,
				<-0.150459, 0.734530, -0.653402>, <-1.837618, 4.431007, -3.603965>
			}
			smooth_triangle {
				<-0.150459, 0.734530, -0.653402>, <-1.837618, 4.431007, -3.603965>,
				<-0.150562, 0.728280, -0.660339>, <-0.925789, 2.202960, -1.813781>,
				<-0.144541, 0.733130, -0.656306>, <-0.930586, 2.215246, -1.796269>
			}
			smooth_triangle {
				<-0.190751, 0.802349, -0.555851>, <-1.277460, 4.840578, -3.304722>,
				<-0.177903, 0.788469, -0.579463>, <-1.656673, 5.551768, -3.926306>,
				<-0.165275, 0.813660, -0.547503>, <-1.351327, 4.908323, -3.172760>
			}
			smooth_triangle {
				<-0.139397, 0.772110, -0.611173>, <-1.723926, 4.657935, -3.365856>,
				<-0.137120, 0.781690, -0.599390>, <-1.401135, 3.930636, -2.754067>,
				<-0.147679, 0.777290, -0.602592>, <-1.645002, 4.691103, -3.359085>
			}
			smooth_triangle {
				<-0.165275, 0.813660, -0.547503>, <-1.351327, 4.908323, -3.172760>,
				<-0.177903, 0.788469, -0.579463>, <-1.656673, 5.551768, -3.926306>,
				<-0.153081, 0.802130, -0.567695>, <-1.484634, 4.839592, -3.219107>
			}
			smooth_triangle {
				<-0.177903, 0.788469, -0.579463>, <-1.656673, 5.551768, -3.926306>,
				<-0.159312, 0.782890, -0.592296>, <-1.548751, 4.724671, -3.357227>,
				<-0.153081, 0.802130, -0.567695>, <-1.484634, 4.839592, -3.219107>
			}
			smooth_triangle {
				<-0.153081, 0.802130, -0.567695>, <-1.484634, 4.839592, -3.219107>,
				<-0.159312, 0.782890, -0.592296>, <-1.548751, 4.724671, -3.357227>,
				<-0.139987, 0.792290, -0.584636>, <-1.877810, 5.578996, -3.786718>
			}
			smooth_triangle {
				<-0.139987, 0.792290, -0.584636>, <-1.877810, 5.578996, -3.786718>,
				<-0.147679, 0.777290, -0.602592>, <-1.645002, 4.691103, -3.359085>,
				<-0.137120, 0.781690, -0.599390>, <-1.401135, 3.930636, -2.754067>
			}
			smooth_triangle {
				<-0.139987, 0.792290, -0.584636>, <-1.877810, 5.578996, -3.786718>,
				<-0.159312, 0.782890, -0.592296>, <-1.548751, 4.724671, -3.357227>,
				<-0.147679, 0.777290, -0.602592>, <-1.645002, 4.691103, -3.359085>
			}
			smooth_triangle {
				<-0.144541, 0.733130, -0.656306>, <-0.930586, 2.215246, -1.796269>,
				<-0.138634, 0.737080, -0.653156>, <-0.935804, 2.228523, -1.777035>,
				<-0.144671, 0.739100, -0.649553>, <-1.849399, 4.457795, -3.564667>
			}
			smooth_triangle {
				<-0.139987, 0.792290, -0.584636>, <-1.877810, 5.578996, -3.786718>,
				<-0.137120, 0.781690, -0.599390>, <-1.401135, 3.930636, -2.754067>,
				<-0.129127, 0.788100, -0.592743>, <-1.419895, 3.964176, -2.695644>
			}
			smooth_triangle {
				<-0.129127, 0.788100, -0.592743>, <-1.419895, 3.964176, -2.695644>,
				<-0.137120, 0.781690, -0.599390>, <-1.401135, 3.930636, -2.754067>,
				<-0.129249, 0.778340, -0.605473>, <-1.755968, 4.695169, -3.296829>
			}
			smooth_triangle {
				<-0.137120, 0.781690, -0.599390>, <-1.401135, 3.930636, -2.754067>,
				<-0.139397, 0.772110, -0.611173>, <-1.723926, 4.657935, -3.365856>,
				<-0.129249, 0.778340, -0.605473>, <-1.755968, 4.695169, -3.296829>
			}
			smooth_triangle {
				<-0.129249, 0.778340, -0.605473>, <-1.755968, 4.695169, -3.296829>,
				<-0.139397, 0.772110, -0.611173>, <-1.723926, 4.657935, -3.365856>,
				<-0.131004, 0.767460, -0.618829>, <-1.796624, 4.630664, -3.365498>
			}
			smooth_triangle {
				<-0.139397, 0.772110, -0.611173>, <-1.723926, 4.657935, -3.365856>,
				<-0.141329, 0.761780, -0.623573>, <-1.764910, 4.596661, -3.428296>,
				<-0.131004, 0.767460, -0.618829>, <-1.796624, 4.630664, -3.365498>
			}
			smooth_triangle {
				<-0.131004, 0.767460, -0.618829>, <-1.796624, 4.630664, -3.365498>,
				<-0.141329, 0.761780, -0.623573>, <-1.764910, 4.596661, -3.428296>,
				<-0.133656, 0.756320, -0.631852>, <-2.138591, 5.324702, -4.008873>
			}
			smooth_triangle {
				<-0.141329, 0.761780, -0.623573>, <-1.764910, 4.596661, -3.428296>,
				<-0.143341, 0.752800, -0.633920>, <-1.794111, 4.542697, -3.484807>,
				<-0.133656, 0.756320, -0.631852>, <-2.138591, 5.324702, -4.008873>
			}
			smooth_triangle {
				<-0.144671, 0.739100, -0.649553>, <-1.849399, 4.457795, -3.564667>,
				<-0.138998, 0.743360, -0.645919>, <-1.862637, 4.484822, -3.523652>,
				<-0.144599, 0.745540, -0.642172>, <-1.819638, 4.498413, -3.528735>
			}
			smooth_triangle {
				<-0.143341, 0.752800, -0.633920>, <-1.794111, 4.542697, -3.484807>,
				<-0.144599, 0.745540, -0.642172>, <-1.819638, 4.498413, -3.528735>,
				<-0.138774, 0.749230, -0.639149>, <-1.531618, 3.767947, -2.907916>
			}
			smooth_triangle {
				<-0.144599, 0.745540, -0.642172>, <-1.819638, 4.498413, -3.528735>,
				<-0.138998, 0.743360, -0.645919>, <-1.862637, 4.484822, -3.523652>,
				<-0.138774, 0.749230, -0.639149>, <-1.531618, 3.767947, -2.907916>
			}
			smooth_triangle {
				<-0.138998, 0.743360, -0.645919>, <-1.862637, 4.484822, -3.523652>,
				<-0.133247, 0.748040, -0.641711>, <-1.872228, 4.514513, -3.480363>,
				<-0.138774, 0.749230, -0.639149>, <-1.531618, 3.767947, -2.907916>
			}
			smooth_triangle {
				<-0.143341, 0.752800, -0.633920>, <-1.794111, 4.542697, -3.484807>,
				<-0.138774, 0.749230, -0.639149>, <-1.531618, 3.767947, -2.907916>,
				<-0.133656, 0.756320, -0.631852>, <-2.138591, 5.324702, -4.008873>
			}
			smooth_triangle {
				<-0.138774, 0.749230, -0.639149>, <-1.531618, 3.767947, -2.907916>,
				<-0.133247, 0.748040, -0.641711>, <-1.872228, 4.514513, -3.480363>,
				<-0.133656, 0.756320, -0.631852>, <-2.138591, 5.324702, -4.008873>
			}
			smooth_triangle {
				<-0.133247, 0.748040, -0.641711>, <-1.872228, 4.514513, -3.480363>,
				<-0.138998, 0.743360, -0.645919>, <-1.862637, 4.484822, -3.523652>,
				<-0.134004, 0.741060, -0.649613>, <-0.939772, 2.242359, -1.757417>
			}
			smooth_triangle {
				<-0.144671, 0.739100, -0.649553>, <-1.849399, 4.457795, -3.564667>,
				<-0.138634, 0.737080, -0.653156>, <-0.935804, 2.228523, -1.777035>,
				<-0.138998, 0.743360, -0.645919>, <-1.862637, 4.484822, -3.523652>
			}
			smooth_triangle {
				<-0.138998, 0.743360, -0.645919>, <-1.862637, 4.484822, -3.523652>,
				<-0.138634, 0.737080, -0.653156>, <-0.935804, 2.228523, -1.777035>,
				<-0.134004, 0.741060, -0.649613>, <-0.939772, 2.242359, -1.757417>
			}
			smooth_triangle {
				<-0.225144, 0.748699, -0.614714>, <-1.112958, 3.765021, -3.095436>,
				<-0.228782, 0.734609, -0.630173>, <-1.379917, 4.430002, -3.803321>,
				<-0.213392, 0.744629, -0.623780>, <-1.431116, 4.493638, -3.708720>
			}
			smooth_triangle {
				<-0.228782, 0.734609, -0.630173>, <-1.379917, 4.430002, -3.803321>,
				<-0.215425, 0.731229, -0.638757>, <-1.476291, 4.411059, -3.789346>,
				<-0.213392, 0.744629, -0.623780>, <-1.431116, 4.493638, -3.708720>
			}
			smooth_triangle {
				<-0.150562, 0.728280, -0.660339>, <-0.925789, 2.202960, -1.813781>,
				<-0.155811, 0.729920, -0.657306>, <-1.827749, 4.405226, -3.640401>,
				<-0.154158, 0.725130, -0.662975>, <-1.552888, 3.639122, -3.056869>
			}
			smooth_triangle {
				<-0.213392, 0.744629, -0.623780>, <-1.431116, 4.493638, -3.708720>,
				<-0.215425, 0.731229, -0.638757>, <-1.476291, 4.411059, -3.789346>,
				<-0.204313, 0.739829, -0.632468>, <-1.255450, 3.721335, -3.094047>
			}
			smooth_triangle {
				<-0.215425, 0.731229, -0.638757>, <-1.476291, 4.411059, -3.789346>,
				<-0.203385, 0.729749, -0.644369>, <-1.557299, 4.402212, -3.767290>,
				<-0.204313, 0.739829, -0.632468>, <-1.255450, 3.721335, -3.094047>
			}
			smooth_triangle {
				<-0.154158, 0.725130, -0.662975>, <-1.552888, 3.639122, -3.056869>,
				<-0.155811, 0.729920, -0.657306>, <-1.827749, 4.405226, -3.640401>,
				<-0.161490, 0.724580, -0.661835>, <-1.821883, 4.369482, -3.686039>
			}
			smooth_triangle {
				<-0.155811, 0.729920, -0.657306>, <-1.827749, 4.405226, -3.640401>,
				<-0.161741, 0.731070, -0.654588>, <-1.793417, 4.411371, -3.650038>,
				<-0.161490, 0.724580, -0.661835>, <-1.821883, 4.369482, -3.686039>
			}
			smooth_triangle {
				<-0.204313, 0.739829, -0.632468>, <-1.255450, 3.721335, -3.094047>,
				<-0.203385, 0.729749, -0.644369>, <-1.557299, 4.402212, -3.767290>,
				<-0.193224, 0.740019, -0.635729>, <-1.570223, 4.466891, -3.684788>
			}
			smooth_triangle {
				<-0.203385, 0.729749, -0.644369>, <-1.557299, 4.402212, -3.767290>,
				<-0.192360, 0.729209, -0.648359>, <-1.621861, 4.400044, -3.742546>,
				<-0.193224, 0.740019, -0.635729>, <-1.570223, 4.466891, -3.684788>
			}
			smooth_triangle {
				<-0.161490, 0.724580, -0.661835>, <-1.821883, 4.369482, -3.686039>,
				<-0.161741, 0.731070, -0.654588>, <-1.793417, 4.411371, -3.650038>,
				<-0.167119, 0.726560, -0.658260>, <-1.483138, 3.651480, -3.076675>
			}
			smooth_triangle {
				<-0.161741, 0.731070, -0.654588>, <-1.793417, 4.411371, -3.650038>,
				<-0.167663, 0.732800, -0.651160>, <-1.746479, 4.422113, -3.659723>,
				<-0.167119, 0.726560, -0.658260>, <-1.483138, 3.651480, -3.076675>
			}
			smooth_triangle {
				<-0.193224, 0.740019, -0.635729>, <-1.570223, 4.466891, -3.684788>,
				<-0.192360, 0.729209, -0.648359>, <-1.621861, 4.400044, -3.742546>,
				<-0.182983, 0.737519, -0.641633>, <-1.636523, 4.450932, -3.675391>
			}
			smooth_triangle {
				<-0.192360, 0.729209, -0.648359>, <-1.621861, 4.400044, -3.742546>,
				<-0.182901, 0.727829, -0.652628>, <-1.684390, 4.391373, -3.725163>,
				<-0.182983, 0.737519, -0.641633>, <-1.636523, 4.450932, -3.675391>
			}
			smooth_triangle {
				<-0.167119, 0.726560, -0.658260>, <-1.483138, 3.651480, -3.076675>,
				<-0.167663, 0.732800, -0.651160>, <-1.746479, 4.422113, -3.659723>,
				<-0.174219, 0.726370, -0.656624>, <-1.738562, 4.380767, -3.712741>
			}
			smooth_triangle {
				<-0.167663, 0.732800, -0.651160>, <-1.746479, 4.422113, -3.659723>,
				<-0.174746, 0.734800, -0.647031>, <-1.699705, 4.432611, -3.668970>,
				<-0.174219, 0.726370, -0.656624>, <-1.738562, 4.380767, -3.712741>
			}
			smooth_triangle {
				<-0.182983, 0.737519, -0.641633>, <-1.636523, 4.450932, -3.675391>,
				<-0.182901, 0.727829, -0.652628>, <-1.684390, 4.391373, -3.725163>,
				<-0.174746, 0.734800, -0.647031>, <-1.699705, 4.432611, -3.668970>
			}
			smooth_triangle {
				<-0.182901, 0.727829, -0.652628>, <-1.684390, 4.391373, -3.725163>,
				<-0.174219, 0.726370, -0.656624>, <-1.738562, 4.380767, -3.712741>,
				<-0.174746, 0.734800, -0.647031>, <-1.699705, 4.432611, -3.668970>
			}
			smooth_triangle {
				<-0.129127, 0.788100, -0.592743>, <-1.419895, 3.964176, -2.695644>,
				<-0.129249, 0.778340, -0.605473>, <-1.755968, 4.695169, -3.296829>,
				<-0.118753, 0.786440, -0.597088>, <-1.769842, 4.745608, -3.215991>
			}
			smooth_triangle {
				<-0.134004, 0.741060, -0.649613>, <-0.939772, 2.242359, -1.757417>,
				<-0.128578, 0.745520, -0.645590>, <-0.947425, 2.255749, -1.736034>,
				<-0.133247, 0.748040, -0.641711>, <-1.872228, 4.514513, -3.480363>
			}
			smooth_triangle {
				<-0.128578, 0.745520, -0.645590>, <-0.947425, 2.255749, -1.736034>,
				<-0.125438, 0.752560, -0.637990>, <-1.895022, 4.542099, -3.431713>,
				<-0.133247, 0.748040, -0.641711>, <-1.872228, 4.514513, -3.480363>
			}
			smooth_triangle {
				<-0.118753, 0.786440, -0.597088>, <-1.769842, 4.745608, -3.215991>,
				<-0.129249, 0.778340, -0.605473>, <-1.755968, 4.695169, -3.296829>,
				<-0.119968, 0.773800, -0.613143>, <-1.825896, 4.669333, -3.295465>
			}
			smooth_triangle {
				<-0.129249, 0.778340, -0.605473>, <-1.755968, 4.695169, -3.296829>,
				<-0.131004, 0.767460, -0.618829>, <-1.796624, 4.630664, -3.365498>,
				<-0.119968, 0.773800, -0.613143>, <-1.825896, 4.669333, -3.295465>
			}
			smooth_triangle {
				<-0.133247, 0.748040, -0.641711>, <-1.872228, 4.514513, -3.480363>,
				<-0.125438, 0.752560, -0.637990>, <-1.895022, 4.542099, -3.431713>,
				<-0.133656, 0.756320, -0.631852>, <-2.138591, 5.324702, -4.008873>
			}
			smooth_triangle {
				<-0.125438, 0.752560, -0.637990>, <-1.895022, 4.542099, -3.431713>,
				<-0.122311, 0.761990, -0.627325>, <-1.869716, 4.598549, -3.369591>,
				<-0.133656, 0.756320, -0.631852>, <-2.138591, 5.324702, -4.008873>
			}
			smooth_triangle {
				<-0.119968, 0.773800, -0.613143>, <-1.825896, 4.669333, -3.295465>,
				<-0.131004, 0.767460, -0.618829>, <-1.796624, 4.630664, -3.365498>,
				<-0.122311, 0.761990, -0.627325>, <-1.869716, 4.598549, -3.369591>
			}
			smooth_triangle {
				<-0.131004, 0.767460, -0.618829>, <-1.796624, 4.630664, -3.365498>,
				<-0.133656, 0.756320, -0.631852>, <-2.138591, 5.324702, -4.008873>,
				<-0.122311, 0.761990, -0.627325>, <-1.869716, 4.598549, -3.369591>
			}
			smooth_triangle {
				<-0.128578, 0.745520, -0.645590>, <-0.947425, 2.255749, -1.736034>,
				<-0.121726, 0.749150, -0.642697>, <-0.639323, 1.510115, -1.144878>,
				<-0.125438, 0.752560, -0.637990>, <-1.895022, 4.542099, -3.431713>
			}
			smooth_triangle {
				<-0.118753, 0.786440, -0.597088>, <-1.769842, 4.745608, -3.215991>,
				<-0.119968, 0.773800, -0.613143>, <-1.825896, 4.669333, -3.295465>,
				<-0.107737, 0.780940, -0.606331>, <-1.854572, 4.711197, -3.218757>
			}
			smooth_triangle {
				<-0.107737, 0.780940, -0.606331>, <-1.854572, 4.711197, -3.218757>,
				<-0.119968, 0.773800, -0.613143>, <-1.825896, 4.669333, -3.295465>,
				<-0.110562, 0.767200, -0.623124>, <-1.907894, 4.629158, -3.305585>
			}
			smooth_triangle {
				<-0.119968, 0.773800, -0.613143>, <-1.825896, 4.669333, -3.295465>,
				<-0.122311, 0.761990, -0.627325>, <-1.869716, 4.598549, -3.369591>,
				<-0.110562, 0.767200, -0.623124>, <-1.907894, 4.629158, -3.305585>
			}
			smooth_triangle {
				<-0.110562, 0.767200, -0.623124>, <-1.907894, 4.629158, -3.305585>,
				<-0.122311, 0.761990, -0.627325>, <-1.869716, 4.598549, -3.369591>,
				<-0.113084, 0.754200, -0.638357>, <-1.282177, 3.047710, -2.250981>
			}
			smooth_triangle {
				<-0.122311, 0.761990, -0.627325>, <-1.869716, 4.598549, -3.369591>,
				<-0.125438, 0.752560, -0.637990>, <-1.895022, 4.542099, -3.431713>,
				<-0.113084, 0.754200, -0.638357>, <-1.282177, 3.047710, -2.250981>
			}
			smooth_triangle {
				<-0.121726, 0.749150, -0.642697>, <-0.639323, 1.510115, -1.144878>,
				<-0.113084, 0.754200, -0.638357>, <-1.282177, 3.047710, -2.250981>,
				<-0.125438, 0.752560, -0.637990>, <-1.895022, 4.542099, -3.431713>
			}
			smooth_triangle {
				<-0.165275, 0.813660, -0.547503>, <-1.351327, 4.908323, -3.172760>,
				<-0.176634, 0.827500, -0.522646>, <-1.034401, 4.162284, -2.567278>,
				<-0.190751, 0.802349, -0.555851>, <-1.277460, 4.840578, -3.304722>
			}
			smooth_triangle {
				<-0.176634, 0.827500, -0.522646>, <-1.034401, 4.162284, -2.567278>,
				<-0.203764, 0.812729, -0.535780>, <-0.403117, 1.625842, -1.092314>,
				<-0.190751, 0.802349, -0.555851>, <-1.277460, 4.840578, -3.304722>
			}
			smooth_triangle {
				<-0.203764, 0.812729, -0.535780>, <-0.403117, 1.625842, -1.092314>,
				<-0.214279, 0.790809, -0.563743>, <-0.617572, 2.388057, -1.706923>,
				<-0.190751, 0.802349, -0.555851>, <-1.277460, 4.840578, -3.304722>
			}
			smooth_triangle {
				<-0.107737, 0.780940, -0.606331>, <-1.854572, 4.711197, -3.218757>,
				<-0.105691, 0.795580, -0.587371>, <-1.786960, 4.800619, -3.123212>,
				<-0.118753, 0.786440, -0.597088>, <-1.769842, 4.745608, -3.215991>
			}
			smooth_triangle {
				<-0.092865, 0.849850, -0.508177>, <-0.767107, 2.547438, -1.385842>,
				<-0.098820, 0.860020, -0.489604>, <-0.710759, 2.580464, -1.354536>,
				<-0.110317, 0.841780, -0.518022>, <-1.748580, 5.924536, -3.290392>
			}
			smooth_triangle {
				<-0.098820, 0.860020, -0.489604>, <-0.710759, 2.580464, -1.354536>,
				<-0.114871, 0.858130, -0.489411>, <-1.356361, 5.175755, -2.713045>,
				<-0.110317, 0.841780, -0.518022>, <-1.748580, 5.924536, -3.290392>
			}
			smooth_triangle {
				<-0.153718, 0.855950, -0.482531>, <-1.355367, 6.021746, -3.297226>,
				<-0.150032, 0.836880, -0.515975>, <-1.290915, 5.049647, -2.969454>,
				<-0.132005, 0.858150, -0.485047>, <-1.257786, 5.176789, -2.757422>
			}
			smooth_triangle {
				<-0.132005, 0.858150, -0.485047>, <-1.257786, 5.176789, -2.757422>,
				<-0.150032, 0.836880, -0.515975>, <-1.290915, 5.049647, -2.969454>,
				<-0.129389, 0.841150, -0.514616>, <-1.387195, 5.075537, -2.881588>
			}
			smooth_triangle {
				<-0.150032, 0.836880, -0.515975>, <-1.290915, 5.049647, -2.969454>,
				<-0.142827, 0.822450, -0.540649>, <-1.425326, 4.962343, -3.054804>,
				<-0.129389, 0.841150, -0.514616>, <-1.387195, 5.075537, -2.881588>
			}
			smooth_triangle {
				<-0.142827, 0.822450, -0.540649>, <-1.425326, 4.962343, -3.054804>,
				<-0.126006, 0.827840, -0.536579>, <-1.250772, 4.162319, -2.470614>,
				<-0.129389, 0.841150, -0.514616>, <-1.387195, 5.075537, -2.881588>
			}
			smooth_triangle {
				<-0.153718, 0.855950, -0.482531>, <-1.355367, 6.021746, -3.297226>,
				<-0.176634, 0.827500, -0.522646>, <-1.034401, 4.162284, -2.567278>,
				<-0.150032, 0.836880, -0.515975>, <-1.290915, 5.049647, -2.969454>
			}
			smooth_triangle {
				<-0.176634, 0.827500, -0.522646>, <-1.034401, 4.162284, -2.567278>,
				<-0.165275, 0.813660, -0.547503>, <-1.351327, 4.908323, -3.172760>,
				<-0.150032, 0.836880, -0.515975>, <-1.290915, 5.049647, -2.969454>
			}
			smooth_triangle {
				<-0.142827, 0.822450, -0.540649>, <-1.425326, 4.962343, -3.054804>,
				<-0.150032, 0.836880, -0.515975>, <-1.290915, 5.049647, -2.969454>,
				<-0.165275, 0.813660, -0.547503>, <-1.351327, 4.908323, -3.172760>
			}
			smooth_triangle {
				<-0.132005, 0.858150, -0.485047>, <-1.257786, 5.176789, -2.757422>,
				<-0.129389, 0.841150, -0.514616>, <-1.387195, 5.075537, -2.881588>,
				<-0.114871, 0.858130, -0.489411>, <-1.356361, 5.175755, -2.713045>
			}
			smooth_triangle {
				<-0.114871, 0.858130, -0.489411>, <-1.356361, 5.175755, -2.713045>,
				<-0.129389, 0.841150, -0.514616>, <-1.387195, 5.075537, -2.881588>,
				<-0.110317, 0.841780, -0.518022>, <-1.748580, 5.924536, -3.290392>
			}
			smooth_triangle {
				<-0.129389, 0.841150, -0.514616>, <-1.387195, 5.075537, -2.881588>,
				<-0.126006, 0.827840, -0.536579>, <-1.250772, 4.162319, -2.470614>,
				<-0.110317, 0.841780, -0.518022>, <-1.748580, 5.924536, -3.290392>
			}
			smooth_triangle {
				<-0.178123, 0.847090, -0.489727>, <-0.394028, 1.702203, -0.972898>,
				<-0.153718, 0.855950, -0.482531>, <-1.355367, 6.021746, -3.297226>,
				<-0.166432, 0.858570, -0.473586>, <-0.558152, 2.604305, -1.379633>
			}
			smooth_triangle {
				<-0.178123, 0.847090, -0.489727>, <-0.394028, 1.702203, -0.972898>,
				<-0.176634, 0.827500, -0.522646>, <-1.034401, 4.162284, -2.567278>,
				<-0.153718, 0.855950, -0.482531>, <-1.355367, 6.021746, -3.297226>
			}
			smooth_triangle {
				<-0.092865, 0.849850, -0.508177>, <-0.767107, 2.547438, -1.385842>,
				<-0.110317, 0.841780, -0.518022>, <-1.748580, 5.924536, -3.290392>,
				<-0.095170, 0.832040, -0.536437>, <-1.905557, 5.854986, -3.327799>
			}
			smooth_triangle {
				<-0.165275, 0.813660, -0.547503>, <-1.351327, 4.908323, -3.172760>,
				<-0.153081, 0.802130, -0.567695>, <-1.484634, 4.839592, -3.219107>,
				<-0.142827, 0.822450, -0.540649>, <-1.425326, 4.962343, -3.054804>
			}
			smooth_triangle {
				<-0.153081, 0.802130, -0.567695>, <-1.484634, 4.839592, -3.219107>,
				<-0.132867, 0.811440, -0.559489>, <-1.555739, 4.894259, -3.101037>,
				<-0.142827, 0.822450, -0.540649>, <-1.425326, 4.962343, -3.054804>
			}
			smooth_triangle {
				<-0.095170, 0.832040, -0.536437>, <-1.905557, 5.854986, -3.327799>,
				<-0.110317, 0.841780, -0.518022>, <-1.748580, 5.924536, -3.290392>,
				<-0.114517, 0.821360, -0.548961>, <-1.603241, 4.955665, -2.976573>
			}
			smooth_triangle {
				<-0.110317, 0.841780, -0.518022>, <-1.748580, 5.924536, -3.290392>,
				<-0.126006, 0.827840, -0.536579>, <-1.250772, 4.162319, -2.470614>,
				<-0.114517, 0.821360, -0.548961>, <-1.603241, 4.955665, -2.976573>
			}
			smooth_triangle {
				<-0.142827, 0.822450, -0.540649>, <-1.425326, 4.962343, -3.054804>,
				<-0.132867, 0.811440, -0.559489>, <-1.555739, 4.894259, -3.101037>,
				<-0.126006, 0.827840, -0.536579>, <-1.250772, 4.162319, -2.470614>
			}
			smooth_triangle {
				<-0.126006, 0.827840, -0.536579>, <-1.250772, 4.162319, -2.470614>,
				<-0.132867, 0.811440, -0.559489>, <-1.555739, 4.894259, -3.101037>,
				<-0.114517, 0.821360, -0.548961>, <-1.603241, 4.955665, -2.976573>
			}
			smooth_triangle {
				<-0.095170, 0.832040, -0.536437>, <-1.905557, 5.854986, -3.327799>,
				<-0.114517, 0.821360, -0.548961>, <-1.603241, 4.955665, -2.976573>,
				<-0.102042, 0.812260, -0.564742>, <-1.711593, 4.902138, -3.005059>
			}
			smooth_triangle {
				<-0.153081, 0.802130, -0.567695>, <-1.484634, 4.839592, -3.219107>,
				<-0.139987, 0.792290, -0.584636>, <-1.877810, 5.578996, -3.786718>,
				<-0.132867, 0.811440, -0.559489>, <-1.555739, 4.894259, -3.101037>
			}
			smooth_triangle {
				<-0.132867, 0.811440, -0.559489>, <-1.555739, 4.894259, -3.101037>,
				<-0.139987, 0.792290, -0.584636>, <-1.877810, 5.578996, -3.786718>,
				<-0.120465, 0.801260, -0.576710>, <-1.955558, 5.642873, -3.650003>
			}
			smooth_triangle {
				<-0.139987, 0.792290, -0.584636>, <-1.877810, 5.578996, -3.786718>,
				<-0.129127, 0.788100, -0.592743>, <-1.419895, 3.964176, -2.695644>,
				<-0.120465, 0.801260, -0.576710>, <-1.955558, 5.642873, -3.650003>
			}
			smooth_triangle {
				<-0.105691, 0.795580, -0.587371>, <-1.786960, 4.800619, -3.123212>,
				<-0.120465, 0.801260, -0.576710>, <-1.955558, 5.642873, -3.650003>,
				<-0.118753, 0.786440, -0.597088>, <-1.769842, 4.745608, -3.215991>
			}
			smooth_triangle {
				<-0.129127, 0.788100, -0.592743>, <-1.419895, 3.964176, -2.695644>,
				<-0.118753, 0.786440, -0.597088>, <-1.769842, 4.745608, -3.215991>,
				<-0.120465, 0.801260, -0.576710>, <-1.955558, 5.642873, -3.650003>
			}
			smooth_triangle {
				<-0.132867, 0.811440, -0.559489>, <-1.555739, 4.894259, -3.101037>,
				<-0.120465, 0.801260, -0.576710>, <-1.955558, 5.642873, -3.650003>,
				<-0.114517, 0.821360, -0.548961>, <-1.603241, 4.955665, -2.976573>
			}
			smooth_triangle {
				<-0.105691, 0.795580, -0.587371>, <-1.786960, 4.800619, -3.123212>,
				<-0.102042, 0.812260, -0.564742>, <-1.711593, 4.902138, -3.005059>,
				<-0.120465, 0.801260, -0.576710>, <-1.955558, 5.642873, -3.650003>
			}
			smooth_triangle {
				<-0.120465, 0.801260, -0.576710>, <-1.955558, 5.642873, -3.650003>,
				<-0.102042, 0.812260, -0.564742>, <-1.711593, 4.902138, -3.005059>,
				<-0.114517, 0.821360, -0.548961>, <-1.603241, 4.955665, -2.976573>
			}
			smooth_triangle {
				<-0.153718, 0.855950, -0.482531>, <-1.355367, 6.021746, -3.297226>,
				<-0.132005, 0.858150, -0.485047>, <-1.257786, 5.176789, -2.757422>,
				<-0.128554, 0.878130, -0.448871>, <-0.574051, 2.618760, -1.346054>
			}
			smooth_triangle {
				<-0.098820, 0.860020, -0.489604>, <-0.710759, 2.580464, -1.354536>,
				<-0.102925, 0.869830, -0.471082>, <-0.438633, 1.739522, -0.883926>,
				<-0.114871, 0.858130, -0.489411>, <-1.356361, 5.175755, -2.713045>
			}
			smooth_triangle {
				<-0.102925, 0.869830, -0.471082>, <-0.438633, 1.739522, -0.883926>,
				<-0.115125, 0.876140, -0.456328>, <-0.625183, 2.615673, -1.329336>,
				<-0.114871, 0.858130, -0.489411>, <-1.356361, 5.175755, -2.713045>
			}
			smooth_triangle {
				<-0.128554, 0.878130, -0.448871>, <-0.574051, 2.618760, -1.346054>,
				<-0.132005, 0.858150, -0.485047>, <-1.257786, 5.176789, -2.757422>,
				<-0.115125, 0.876140, -0.456328>, <-0.625183, 2.615673, -1.329336>
			}
			smooth_triangle {
				<-0.132005, 0.858150, -0.485047>, <-1.257786, 5.176789, -2.757422>,
				<-0.114871, 0.858130, -0.489411>, <-1.356361, 5.175755, -2.713045>,
				<-0.115125, 0.876140, -0.456328>, <-0.625183, 2.615673, -1.329336>
			}
			smooth_triangle {
				<-0.128554, 0.878130, -0.448871>, <-0.574051, 2.618760, -1.346054>,
				<-0.144284, 0.881290, -0.437748>, <-0.553433, 2.621352, -1.349876>,
				<-0.153718, 0.855950, -0.482531>, <-1.355367, 6.021746, -3.297226>
			}
			smooth_triangle {
				<-0.153718, 0.855950, -0.482531>, <-1.355367, 6.021746, -3.297226>,
				<-0.144284, 0.881290, -0.437748>, <-0.553433, 2.621352, -1.349876>,
				<-0.166432, 0.858570, -0.473586>, <-0.558152, 2.604305, -1.379633>
			}
			smooth_triangle {
				<-0.144284, 0.881290, -0.437748>, <-0.553433, 2.621352, -1.349876>,
				<-0.161293, 0.876350, -0.441699>, <-0.186168, 0.873858, -0.449125>,
				<-0.166432, 0.858570, -0.473586>, <-0.558152, 2.604305, -1.379633>
			}
			smooth_triangle {
				<-0.215425, 0.731229, -0.638757>, <-1.476291, 4.411059, -3.789346>,
				<-0.213917, 0.718709, -0.653311>, <-1.541552, 4.335206, -3.850399>,
				<-0.203385, 0.729749, -0.644369>, <-1.557299, 4.402212, -3.767290>
			}
			smooth_triangle {
				<-0.182901, 0.727829, -0.652628>, <-1.684390, 4.391373, -3.725163>,
				<-0.182302, 0.718129, -0.663456>, <-1.731680, 4.330431, -3.774382>,
				<-0.174219, 0.726370, -0.656624>, <-1.738562, 4.380767, -3.712741>
			}
			smooth_triangle {
				<-0.156795, 0.696519, -0.692378>, <-2.296950, 4.899189, -4.440176>,
				<-0.155158, 0.709190, -0.679771>, <-1.601001, 3.563734, -3.120013>,
				<-0.167212, 0.705280, -0.680975>, <-2.176026, 4.965868, -4.427293>
			}
			smooth_triangle {
				<-0.167212, 0.705280, -0.680975>, <-2.176026, 4.965868, -4.427293>,
				<-0.155158, 0.709190, -0.679771>, <-1.601001, 3.563734, -3.120013>,
				<-0.159611, 0.716760, -0.670734>, <-1.862001, 4.321583, -3.722208>
			}
			smooth_triangle {
				<-0.155158, 0.709190, -0.679771>, <-1.601001, 3.563734, -3.120013>,
				<-0.149137, 0.718350, -0.671444>, <-1.918888, 4.332798, -3.680030>,
				<-0.159611, 0.716760, -0.670734>, <-1.862001, 4.321583, -3.722208>
			}
			smooth_triangle {
				<-0.149137, 0.718350, -0.671444>, <-1.918888, 4.332798, -3.680030>,
				<-0.154158, 0.725130, -0.662975>, <-1.552888, 3.639122, -3.056869>,
				<-0.159611, 0.716760, -0.670734>, <-1.862001, 4.321583, -3.722208>
			}
			smooth_triangle {
				<-0.156795, 0.696519, -0.692378>, <-2.296950, 4.899189, -4.440176>,
				<-0.173057, 0.682629, -0.702269>, <-2.257775, 4.797609, -4.569125>,
				<-0.156302, 0.681689, -0.707099>, <-1.331297, 2.734992, -2.596904>
			}
			smooth_triangle {
				<-0.178492, 0.694659, -0.688989>, <-1.844767, 4.190516, -3.877230>,
				<-0.173057, 0.682629, -0.702269>, <-2.257775, 4.797609, -4.569125>,
				<-0.168905, 0.694820, -0.691238>, <-1.270288, 2.792958, -2.565963>
			}
			smooth_triangle {
				<-0.173057, 0.682629, -0.702269>, <-2.257775, 4.797609, -4.569125>,
				<-0.156795, 0.696519, -0.692378>, <-2.296950, 4.899189, -4.440176>,
				<-0.168905, 0.694820, -0.691238>, <-1.270288, 2.792958, -2.565963>
			}
			smooth_triangle {
				<-0.178492, 0.694659, -0.688989>, <-1.844767, 4.190516, -3.877230>,
				<-0.168905, 0.694820, -0.691238>, <-1.270288, 2.792958, -2.565963>,
				<-0.167212, 0.705280, -0.680975>, <-2.176026, 4.965868, -4.427293>
			}
			smooth_triangle {
				<-0.168905, 0.694820, -0.691238>, <-1.270288, 2.792958, -2.565963>,
				<-0.156795, 0.696519, -0.692378>, <-2.296950, 4.899189, -4.440176>,
				<-0.167212, 0.705280, -0.680975>, <-2.176026, 4.965868, -4.427293>
			}
			smooth_triangle {
				<-0.178492, 0.694659, -0.688989>, <-1.844767, 4.190516, -3.877230>,
				<-0.167212, 0.705280, -0.680975>, <-2.176026, 4.965868, -4.427293>,
				<-0.180856, 0.706779, -0.675922>, <-1.785753, 4.263500, -3.824919>
			}
			smooth_triangle {
				<-0.154158, 0.725130, -0.662975>, <-1.552888, 3.639122, -3.056869>,
				<-0.161490, 0.724580, -0.661835>, <-1.821883, 4.369482, -3.686039>,
				<-0.159611, 0.716760, -0.670734>, <-1.862001, 4.321583, -3.722208>
			}
			smooth_triangle {
				<-0.159611, 0.716760, -0.670734>, <-1.862001, 4.321583, -3.722208>,
				<-0.161490, 0.724580, -0.661835>, <-1.821883, 4.369482, -3.686039>,
				<-0.170429, 0.717829, -0.666918>, <-2.100059, 5.047592, -4.371329>
			}
			smooth_triangle {
				<-0.161490, 0.724580, -0.661835>, <-1.821883, 4.369482, -3.686039>,
				<-0.167119, 0.726560, -0.658260>, <-1.483138, 3.651480, -3.076675>,
				<-0.170429, 0.717829, -0.666918>, <-2.100059, 5.047592, -4.371329>
			}
			smooth_triangle {
				<-0.182302, 0.718129, -0.663456>, <-1.731680, 4.330431, -3.774382>,
				<-0.170429, 0.717829, -0.666918>, <-2.100059, 5.047592, -4.371329>,
				<-0.174219, 0.726370, -0.656624>, <-1.738562, 4.380767, -3.712741>
			}
			smooth_triangle {
				<-0.167119, 0.726560, -0.658260>, <-1.483138, 3.651480, -3.076675>,
				<-0.174219, 0.726370, -0.656624>, <-1.738562, 4.380767, -3.712741>,
				<-0.170429, 0.717829, -0.666918>, <-2.100059, 5.047592, -4.371329>
			}
			smooth_triangle {
				<-0.159611, 0.716760, -0.670734>, <-1.862001, 4.321583, -3.722208>,
				<-0.170429, 0.717829, -0.666918>, <-2.100059, 5.047592, -4.371329>,
				<-0.167212, 0.705280, -0.680975>, <-2.176026, 4.965868, -4.427293>
			}
			smooth_triangle {
				<-0.182302, 0.718129, -0.663456>, <-1.731680, 4.330431, -3.774382>,
				<-0.180856, 0.706779, -0.675922>, <-1.785753, 4.263500, -3.824919>,
				<-0.170429, 0.717829, -0.666918>, <-2.100059, 5.047592, -4.371329>
			}
			smooth_triangle {
				<-0.170429, 0.717829, -0.666918>, <-2.100059, 5.047592, -4.371329>,
				<-0.180856, 0.706779, -0.675922>, <-1.785753, 4.263500, -3.824919>,
				<-0.167212, 0.705280, -0.680975>, <-2.176026, 4.965868, -4.427293>
			}
			smooth_triangle {
				<-0.173057, 0.682629, -0.702269>, <-2.257775, 4.797609, -4.569125>,
				<-0.178492, 0.694659, -0.688989>, <-1.844767, 4.190516, -3.877230>,
				<-0.188879, 0.682679, -0.698131>, <-1.835529, 4.117614, -3.958812>
			}
			smooth_triangle {
				<-0.213917, 0.718709, -0.653311>, <-1.541552, 4.335206, -3.850399>,
				<-0.210036, 0.706879, -0.667324>, <-0.799615, 2.148779, -1.934679>,
				<-0.200874, 0.719099, -0.657011>, <-1.617463, 4.336890, -3.817336>
			}
			smooth_triangle {
				<-0.202493, 0.683329, -0.693665>, <-1.756173, 4.122519, -3.989630>,
				<-0.191860, 0.695369, -0.684664>, <-1.765940, 4.195551, -3.908320>,
				<-0.205540, 0.695379, -0.680665>, <-1.138052, 2.787097, -2.633574>
			}
			smooth_triangle {
				<-0.180856, 0.706779, -0.675922>, <-1.785753, 4.263500, -3.824919>,
				<-0.182302, 0.718129, -0.663456>, <-1.731680, 4.330431, -3.774382>,
				<-0.194626, 0.708979, -0.669759>, <-1.700410, 4.280675, -3.844623>
			}
			smooth_triangle {
				<-0.182302, 0.718129, -0.663456>, <-1.731680, 4.330431, -3.774382>,
				<-0.190638, 0.720689, -0.658316>, <-1.392863, 3.621560, -3.153187>,
				<-0.194626, 0.708979, -0.669759>, <-1.700410, 4.280675, -3.844623>
			}
			smooth_triangle {
				<-0.210036, 0.706879, -0.667324>, <-0.799615, 2.148779, -1.934679>,
				<-0.194626, 0.708979, -0.669759>, <-1.700410, 4.280675, -3.844623>,
				<-0.200874, 0.719099, -0.657011>, <-1.617463, 4.336890, -3.817336>
			}
			smooth_triangle {
				<-0.190638, 0.720689, -0.658316>, <-1.392863, 3.621560, -3.153187>,
				<-0.200874, 0.719099, -0.657011>, <-1.617463, 4.336890, -3.817336>,
				<-0.194626, 0.708979, -0.669759>, <-1.700410, 4.280675, -3.844623>
			}
			smooth_triangle {
				<-0.180856, 0.706779, -0.675922>, <-1.785753, 4.263500, -3.824919>,
				<-0.194626, 0.708979, -0.669759>, <-1.700410, 4.280675, -3.844623>,
				<-0.191860, 0.695369, -0.684664>, <-1.765940, 4.195551, -3.908320>
			}
			smooth_triangle {
				<-0.194626, 0.708979, -0.669759>, <-1.700410, 4.280675, -3.844623>,
				<-0.205540, 0.695379, -0.680665>, <-1.138052, 2.787097, -2.633574>,
				<-0.191860, 0.695369, -0.684664>, <-1.765940, 4.195551, -3.908320>
			}
			smooth_triangle {
				<-0.180856, 0.706779, -0.675922>, <-1.785753, 4.263500, -3.824919>,
				<-0.191860, 0.695369, -0.684664>, <-1.765940, 4.195551, -3.908320>,
				<-0.178492, 0.694659, -0.688989>, <-1.844767, 4.190516, -3.877230>
			}
			smooth_triangle {
				<-0.202493, 0.683329, -0.693665>, <-1.756173, 4.122519, -3.989630>,
				<-0.188879, 0.682679, -0.698131>, <-1.835529, 4.117614, -3.958812>,
				<-0.191860, 0.695369, -0.684664>, <-1.765940, 4.195551, -3.908320>
			}
			smooth_triangle {
				<-0.191860, 0.695369, -0.684664>, <-1.765940, 4.195551, -3.908320>,
				<-0.188879, 0.682679, -0.698131>, <-1.835529, 4.117614, -3.958812>,
				<-0.178492, 0.694659, -0.688989>, <-1.844767, 4.190516, -3.877230>
			}
			smooth_triangle {
				<-0.213917, 0.718709, -0.653311>, <-1.541552, 4.335206, -3.850399>,
				<-0.200874, 0.719099, -0.657011>, <-1.617463, 4.336890, -3.817336>,
				<-0.203385, 0.729749, -0.644369>, <-1.557299, 4.402212, -3.767290>
			}
			smooth_triangle {
				<-0.182302, 0.718129, -0.663456>, <-1.731680, 4.330431, -3.774382>,
				<-0.182901, 0.727829, -0.652628>, <-1.684390, 4.391373, -3.725163>,
				<-0.190638, 0.720689, -0.658316>, <-1.392863, 3.621560, -3.153187>
			}
			smooth_triangle {
				<-0.182901, 0.727829, -0.652628>, <-1.684390, 4.391373, -3.725163>,
				<-0.192360, 0.729209, -0.648359>, <-1.621861, 4.400044, -3.742546>,
				<-0.190638, 0.720689, -0.658316>, <-1.392863, 3.621560, -3.153187>
			}
			smooth_triangle {
				<-0.203385, 0.729749, -0.644369>, <-1.557299, 4.402212, -3.767290>,
				<-0.200874, 0.719099, -0.657011>, <-1.617463, 4.336890, -3.817336>,
				<-0.192360, 0.729209, -0.648359>, <-1.621861, 4.400044, -3.742546>
			}
			smooth_triangle {
				<-0.200874, 0.719099, -0.657011>, <-1.617463, 4.336890, -3.817336>,
				<-0.190638, 0.720689, -0.658316>, <-1.392863, 3.621560, -3.153187>,
				<-0.192360, 0.729209, -0.648359>, <-1.621861, 4.400044, -3.742546>
			}
			smooth_triangle {
				<-0.202493, 0.683329, -0.693665>, <-1.756173, 4.122519, -3.989630>,
				<-0.200291, 0.670019, -0.707157>, <-1.817940, 4.040924, -4.044975>,
				<-0.188879, 0.682679, -0.698131>, <-1.835529, 4.117614, -3.958812>
			}
			smooth_triangle {
				<-0.197076, 0.654709, -0.722243>, <-1.246615, 2.651614, -2.722742>,
				<-0.174905, 0.657639, -0.725287>, <-1.318044, 2.687242, -2.653336>,
				<-0.186885, 0.669619, -0.711187>, <-1.587280, 3.365527, -3.339158>
			}
			smooth_triangle {
				<-0.156302, 0.681689, -0.707099>, <-1.331297, 2.734992, -2.596904>,
				<-0.174905, 0.657639, -0.725287>, <-1.318044, 2.687242, -2.653336>,
				<-0.154498, 0.663169, -0.724878>, <-0.333413, 0.674074, -0.659136>
			}
			smooth_triangle {
				<-0.156302, 0.681689, -0.707099>, <-1.331297, 2.734992, -2.596904>,
				<-0.173057, 0.682629, -0.702269>, <-2.257775, 4.797609, -4.569125>,
				<-0.174905, 0.657639, -0.725287>, <-1.318044, 2.687242, -2.653336>
			}
			smooth_triangle {
				<-0.173057, 0.682629, -0.702269>, <-2.257775, 4.797609, -4.569125>,
				<-0.186885, 0.669619, -0.711187>, <-1.587280, 3.365527, -3.339158>,
				<-0.174905, 0.657639, -0.725287>, <-1.318044, 2.687242, -2.653336>
			}
			smooth_triangle {
				<-0.197076, 0.654709, -0.722243>, <-1.246615, 2.651614, -2.722742>,
				<-0.186885, 0.669619, -0.711187>, <-1.587280, 3.365527, -3.339158>,
				<-0.200291, 0.670019, -0.707157>, <-1.817940, 4.040924, -4.044975>
			}
			smooth_triangle {
				<-0.173057, 0.682629, -0.702269>, <-2.257775, 4.797609, -4.569125>,
				<-0.188879, 0.682679, -0.698131>, <-1.835529, 4.117614, -3.958812>,
				<-0.186885, 0.669619, -0.711187>, <-1.587280, 3.365527, -3.339158>
			}
			smooth_triangle {
				<-0.186885, 0.669619, -0.711187>, <-1.587280, 3.365527, -3.339158>,
				<-0.188879, 0.682679, -0.698131>, <-1.835529, 4.117614, -3.958812>,
				<-0.200291, 0.670019, -0.707157>, <-1.817940, 4.040924, -4.044975>
			}
			smooth_triangle {
				<-0.228782, 0.734609, -0.630173>, <-1.379917, 4.430002, -3.803321>,
				<-0.228407, 0.719339, -0.647679>, <-1.450625, 4.339159, -3.881016>,
				<-0.215425, 0.731229, -0.638757>, <-1.476291, 4.411059, -3.789346>
			}
			smooth_triangle {
				<-0.208568, 0.643139, -0.729375>, <-0.912296, 1.947129, -2.091780>,
				<-0.197076, 0.654709, -0.722243>, <-1.246615, 2.651614, -2.722742>,
				<-0.212036, 0.657379, -0.715538>, <-1.793496, 3.965439, -4.129713>
			}
			smooth_triangle {
				<-0.197076, 0.654709, -0.722243>, <-1.246615, 2.651614, -2.722742>,
				<-0.200291, 0.670019, -0.707157>, <-1.817940, 4.040924, -4.044975>,
				<-0.212036, 0.657379, -0.715538>, <-1.793496, 3.965439, -4.129713>
			}
			smooth_triangle {
				<-0.215425, 0.731229, -0.638757>, <-1.476291, 4.411059, -3.789346>,
				<-0.228407, 0.719339, -0.647679>, <-1.450625, 4.339159, -3.881016>,
				<-0.213917, 0.718709, -0.653311>, <-1.541552, 4.335206, -3.850399>
			}
			smooth_triangle {
				<-0.228407, 0.719339, -0.647679>, <-1.450625, 4.339159, -3.881016>,
				<-0.225102, 0.705489, -0.663872>, <-1.006778, 2.849794, -2.619799>,
				<-0.213917, 0.718709, -0.653311>, <-1.541552, 4.335206, -3.850399>
			}
			smooth_triangle {
				<-0.212036, 0.657379, -0.715538>, <-1.793496, 3.965439, -4.129713>,
				<-0.200291, 0.670019, -0.707157>, <-1.817940, 4.040924, -4.044975>,
				<-0.214073, 0.671959, -0.701258>, <-1.729616, 4.051306, -4.073217>
			}
			smooth_triangle {
				<-0.200291, 0.670019, -0.707157>, <-1.817940, 4.040924, -4.044975>,
				<-0.202493, 0.683329, -0.693665>, <-1.756173, 4.122519, -3.989630>,
				<-0.214073, 0.671959, -0.701258>, <-1.729616, 4.051306, -4.073217>
			}
			smooth_triangle {
				<-0.213917, 0.718709, -0.653311>, <-1.541552, 4.335206, -3.850399>,
				<-0.225102, 0.705489, -0.663872>, <-1.006778, 2.849794, -2.619799>,
				<-0.210036, 0.706879, -0.667324>, <-0.799615, 2.148779, -1.934679>
			}
			smooth_triangle {
				<-0.214073, 0.671959, -0.701258>, <-1.729616, 4.051306, -4.073217>,
				<-0.202493, 0.683329, -0.693665>, <-1.756173, 4.122519, -3.989630>,
				<-0.214085, 0.684159, -0.689355>, <-1.400280, 3.440192, -3.346898>
			}
			smooth_triangle {
				<-0.202493, 0.683329, -0.693665>, <-1.756173, 4.122519, -3.989630>,
				<-0.205540, 0.695379, -0.680665>, <-1.138052, 2.787097, -2.633574>,
				<-0.214085, 0.684159, -0.689355>, <-1.400280, 3.440192, -3.346898>
			}
			smooth_triangle {
				<-0.219898, 0.693189, -0.678408>, <-0.813287, 2.073251, -2.009913>,
				<-0.214085, 0.684159, -0.689355>, <-1.400280, 3.440192, -3.346898>,
				<-0.205540, 0.695379, -0.680665>, <-1.138052, 2.787097, -2.633574>
			}
			smooth_triangle {
				<-0.113084, 0.754200, -0.638357>, <-1.282177, 3.047710, -2.250981>,
				<-0.102750, 0.758220, -0.635345>, <-0.977105, 2.305481, -1.652157>,
				<-0.110562, 0.767200, -0.623124>, <-1.907894, 4.629158, -3.305585>
			}
			smooth_triangle {
				<-0.102750, 0.758220, -0.635345>, <-0.977105, 2.305481, -1.652157>,
				<-0.097289, 0.773500, -0.617526>, <-1.947043, 4.666363, -3.229387>,
				<-0.110562, 0.767200, -0.623124>, <-1.907894, 4.629158, -3.305585>
			}
			smooth_triangle {
				<-0.092865, 0.849850, -0.508177>, <-0.767107, 2.547438, -1.385842>,
				<-0.095170, 0.832040, -0.536437>, <-1.905557, 5.854986, -3.327799>,
				<-0.081881, 0.846200, -0.516088>, <-1.103247, 3.383884, -1.824820>
			}
			smooth_triangle {
				<-0.110562, 0.767200, -0.623124>, <-1.907894, 4.629158, -3.305585>,
				<-0.097289, 0.773500, -0.617526>, <-1.947043, 4.666363, -3.229387>,
				<-0.107737, 0.780940, -0.606331>, <-1.854572, 4.711197, -3.218757>
			}
			smooth_triangle {
				<-0.097289, 0.773500, -0.617526>, <-1.947043, 4.666363, -3.229387>,
				<-0.094015, 0.788420, -0.598891>, <-1.888040, 4.756266, -3.131714>,
				<-0.107737, 0.780940, -0.606331>, <-1.854572, 4.711197, -3.218757>
			}
			smooth_triangle {
				<-0.081881, 0.846200, -0.516088>, <-1.103247, 3.383884, -1.824820>,
				<-0.095170, 0.832040, -0.536437>, <-1.905557, 5.854986, -3.327799>,
				<-0.078701, 0.832220, -0.538808>, <-1.436887, 4.184858, -2.327568>
			}
			smooth_triangle {
				<-0.107737, 0.780940, -0.606331>, <-1.854572, 4.711197, -3.218757>,
				<-0.094015, 0.788420, -0.598891>, <-1.888040, 4.756266, -3.131714>,
				<-0.105691, 0.795580, -0.587371>, <-1.786960, 4.800619, -3.123212>
			}
			smooth_triangle {
				<-0.094015, 0.788420, -0.598891>, <-1.888040, 4.756266, -3.131714>,
				<-0.090867, 0.803290, -0.579288>, <-1.821916, 4.846752, -3.030482>,
				<-0.105691, 0.795580, -0.587371>, <-1.786960, 4.800619, -3.123212>
			}
			smooth_triangle {
				<-0.105691, 0.795580, -0.587371>, <-1.786960, 4.800619, -3.123212>,
				<-0.090867, 0.803290, -0.579288>, <-1.821916, 4.846752, -3.030482>,
				<-0.102042, 0.812260, -0.564742>, <-1.711593, 4.902138, -3.005059>
			}
			smooth_triangle {
				<-0.090867, 0.803290, -0.579288>, <-1.821916, 4.846752, -3.030482>,
				<-0.085339, 0.818750, -0.558106>, <-1.762641, 4.939151, -2.913847>,
				<-0.102042, 0.812260, -0.564742>, <-1.711593, 4.902138, -3.005059>
			}
			smooth_triangle {
				<-0.095170, 0.832040, -0.536437>, <-1.905557, 5.854986, -3.327799>,
				<-0.085339, 0.818750, -0.558106>, <-1.762641, 4.939151, -2.913847>,
				<-0.078701, 0.832220, -0.538808>, <-1.436887, 4.184858, -2.327568>
			}
			smooth_triangle {
				<-0.095170, 0.832040, -0.536437>, <-1.905557, 5.854986, -3.327799>,
				<-0.102042, 0.812260, -0.564742>, <-1.711593, 4.902138, -3.005059>,
				<-0.085339, 0.818750, -0.558106>, <-1.762641, 4.939151, -2.913847>
			}
			smooth_triangle {
				<-0.116001, 0.724580, -0.671299>, <-1.721187, 3.640377, -2.963560>,
				<-0.107081, 0.728810, -0.668197>, <-1.749373, 3.663205, -2.918626>,
				<-0.116397, 0.736100, -0.658578>, <-2.351716, 5.180414, -4.077844>
			}
			smooth_triangle {
				<-0.107081, 0.728810, -0.668197>, <-1.749373, 3.663205, -2.918626>,
				<-0.094996, 0.728130, -0.670753>, <-2.521086, 5.122260, -4.049907>,
				<-0.103314, 0.738900, -0.657625>, <-2.075088, 4.458624, -3.436758>
			}
			smooth_triangle {
				<-0.098740, 0.751530, -0.643866>, <-1.036380, 2.250233, -1.691800>,
				<-0.103314, 0.738900, -0.657625>, <-2.075088, 4.458624, -3.436758>,
				<-0.092297, 0.740640, -0.657300>, <-2.118351, 4.469246, -3.396328>
			}
			smooth_triangle {
				<-0.103314, 0.738900, -0.657625>, <-2.075088, 4.458624, -3.436758>,
				<-0.094996, 0.728130, -0.670753>, <-2.521086, 5.122260, -4.049907>,
				<-0.092297, 0.740640, -0.657300>, <-2.118351, 4.469246, -3.396328>
			}
			smooth_triangle {
				<-0.094996, 0.728130, -0.670753>, <-2.521086, 5.122260, -4.049907>,
				<-0.087780, 0.732850, -0.666587>, <-1.079821, 2.211243, -1.715775>,
				<-0.092297, 0.740640, -0.657300>, <-2.118351, 4.469246, -3.396328>
			}
			smooth_triangle {
				<-0.098740, 0.751530, -0.643866>, <-1.036380, 2.250233, -1.691800>,
				<-0.092297, 0.740640, -0.657300>, <-2.118351, 4.469246, -3.396328>,
				<-0.086470, 0.753060, -0.643836>, <-1.417766, 3.003856, -2.228580>
			}
			smooth_triangle {
				<-0.087780, 0.732850, -0.666587>, <-1.079821, 2.211243, -1.715775>,
				<-0.082295, 0.738920, -0.660563>, <-1.070453, 2.241613, -1.681938>,
				<-0.092297, 0.740640, -0.657300>, <-2.118351, 4.469246, -3.396328>
			}
			smooth_triangle {
				<-0.092297, 0.740640, -0.657300>, <-2.118351, 4.469246, -3.396328>,
				<-0.082295, 0.738920, -0.660563>, <-1.070453, 2.241613, -1.681938>,
				<-0.086470, 0.753060, -0.643836>, <-1.417766, 3.003856, -2.228580>
			}
			smooth_triangle {
				<-0.107081, 0.728810, -0.668197>, <-1.749373, 3.663205, -2.918626>,
				<-0.103314, 0.738900, -0.657625>, <-2.075088, 4.458624, -3.436758>,
				<-0.116397, 0.736100, -0.658578>, <-2.351716, 5.180414, -4.077844>
			}
			smooth_triangle {
				<-0.098740, 0.751530, -0.643866>, <-1.036380, 2.250233, -1.691800>,
				<-0.110159, 0.747760, -0.646399>, <-1.012912, 2.241460, -1.717443>,
				<-0.103314, 0.738900, -0.657625>, <-2.075088, 4.458624, -3.436758>
			}
			smooth_triangle {
				<-0.103314, 0.738900, -0.657625>, <-2.075088, 4.458624, -3.436758>,
				<-0.110159, 0.747760, -0.646399>, <-1.012912, 2.241460, -1.717443>,
				<-0.116397, 0.736100, -0.658578>, <-2.351716, 5.180414, -4.077844>
			}
			smooth_triangle {
				<-0.082295, 0.738920, -0.660563>, <-1.070453, 2.241613, -1.681938>,
				<-0.076347, 0.743370, -0.656260>, <-0.711978, 1.501997, -1.112236>,
				<-0.086470, 0.753060, -0.643836>, <-1.417766, 3.003856, -2.228580>
			}
			smooth_triangle {
				<-0.076347, 0.743370, -0.656260>, <-0.711978, 1.501997, -1.112236>,
				<-0.074445, 0.751490, -0.647164>, <-0.356947, 0.751961, -0.554205>,
				<-0.086470, 0.753060, -0.643836>, <-1.417766, 3.003856, -2.228580>
			}
			smooth_triangle {
				<-0.110168, 0.701160, -0.696675>, <-1.077593, 2.131491, -1.815046>,
				<-0.090112, 0.701720, -0.698988>, <-1.520768, 2.831931, -2.379998>,
				<-0.104475, 0.716070, -0.682237>, <-2.525978, 5.035886, -4.153585>
			}
			smooth_triangle {
				<-0.090112, 0.701720, -0.698988>, <-1.520768, 2.831931, -2.379998>,
				<-0.087671, 0.714020, -0.686729>, <-2.264642, 4.306667, -3.509673>,
				<-0.104475, 0.716070, -0.682237>, <-2.525978, 5.035886, -4.153585>
			}
			smooth_triangle {
				<-0.087671, 0.714020, -0.686729>, <-2.264642, 4.306667, -3.509673>,
				<-0.094996, 0.728130, -0.670753>, <-2.521086, 5.122260, -4.049907>,
				<-0.104475, 0.716070, -0.682237>, <-2.525978, 5.035886, -4.153585>
			}
			smooth_triangle {
				<-0.087671, 0.714020, -0.686729>, <-2.264642, 4.306667, -3.509673>,
				<-0.081984, 0.725110, -0.675719>, <-1.111833, 2.179824, -1.735459>,
				<-0.094996, 0.728130, -0.670753>, <-2.521086, 5.122260, -4.049907>
			}
			smooth_triangle {
				<-0.081984, 0.725110, -0.675719>, <-1.111833, 2.179824, -1.735459>,
				<-0.087780, 0.732850, -0.666587>, <-1.079821, 2.211243, -1.715775>,
				<-0.094996, 0.728130, -0.670753>, <-2.521086, 5.122260, -4.049907>
			}
			smooth_triangle {
				<-0.094996, 0.728130, -0.670753>, <-2.521086, 5.122260, -4.049907>,
				<-0.107081, 0.728810, -0.668197>, <-1.749373, 3.663205, -2.918626>,
				<-0.104475, 0.716070, -0.682237>, <-2.525978, 5.035886, -4.153585>
			}
			smooth_triangle {
				<-0.133762, 0.692710, -0.700975>, <-1.373410, 2.810947, -2.492071>,
				<-0.110168, 0.701160, -0.696675>, <-1.077593, 2.131491, -1.815046>,
				<-0.124683, 0.713430, -0.681598>, <-2.412777, 5.016111, -4.243759>
			}
			smooth_triangle {
				<-0.110168, 0.701160, -0.696675>, <-1.077593, 2.131491, -1.815046>,
				<-0.104475, 0.716070, -0.682237>, <-2.525978, 5.035886, -4.15