//------ Persian Pool


#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "planter.inc"
#include "palace.inc"
#include "dragon.inc"


camera {
   location <0 60 -460>
   direction <0 0 4>
   up  <0 1 0>
   right <1.3 0 0>
   look_at <0 28 0>
}


object { 
    sphere { <0 0 0> 1 inverse }
       texture {
	gradient <0 1 0>
	color_map {
	[0 .01 color Black color Black]
	[.01 .06 color Black color MidnightBlue]
	[.06 .19 color MidnightBlue color MidnightBlue]
	[.19 .3 color MidnightBlue color Black]
	[.3 1 color Black color Black]
	}
	ambient 1
        translate <0 -.01 0>
       }
scale <100000 100000 100000>
}

object { light_source { <2000 70 -460 > color Gray }}
object { light_source { <-6050 80 -700 > color Gold }}
object { light_source { <-50 400 -200 > color Gold }}
object { light_source {
	<0 10 450>
	color White
	spotlight
	point_at <0 70 600>
	tightness 5
	radius 10
	falloff 45
	}
}




#declare GlassBall =
object {
    sphere { <0 0 0> 1 }
	texture { 
	Glass3 }
}




object { GlassBall scale <15 15 15> translate <-40 -1 290> }
object { GlassBall scale <15 15 15> translate <-55 -15 115> }
 
//--- Place Dragon on Pool Sill
composite { Dragon
	scale <1.2 1.2 1.2>
	rotate <0 145 0>
	translate <62 -30 122>
}


//---  Dragon by entrance
composite { Dragon
	scale <1.2 1.2 1.2>
	rotate <0 40 0>
	translate <70 0 420>
}


composite { Planter scale <.4 .4 .4> translate <-80 -14 222> }


object { plane { <0 0 1> -2000 }
   texture { color Violet ambient 1 diffuse .9 }
}










