//----- Pursian Room Back Drop .....      9/3/92 M.Miller




//---- Textures For Pursian Pool

//--------- White Marble with Gray feather Viens
#declare Grnt20 = texture {
   granite
   turbulence 0.0
   color_map {
      [0.0 0.3 color Mica color White]
      [0.2 0.4 color White color White]
      [0.4 0.6 color White color White]
      [0.6 1.0 color White color White]
   }
   0.02
}

//--------- Light Grays
#declare Grnt24 = texture {
   marble
   turbulence 0.6
   colour_map {
      [0.000 0.154   colour red  0.894  green  0.886  blue  0.886  alpha  0.000
      colour red  0.745  green  0.745  blue  0.753  alpha  0.000]
      [0.154 0.308   colour red  0.745  green  0.745  blue  0.753  alpha  0.000
      colour red  0.902  green  0.902  blue  0.859  alpha  0.000]
      [0.308 0.444   colour red  0.902  green  0.902  blue  0.859  alpha  0.000
      colour red  0.729  green  0.706  blue  0.694  alpha  0.000]
      [0.444 0.615   colour red  0.729  green  0.706  blue  0.694  alpha  0.000
      colour red  0.588  green  0.592  blue  0.635  alpha  0.000]
      [0.615 0.803   colour red  0.588  green  0.592  blue  0.635  alpha  0.000
      colour red  0.608  green  0.616  blue  0.659  alpha  0.000]
      [0.803 1.001   colour red  0.608  green  0.616  blue  0.659  alpha  0.000
      colour red  0.894  green  0.886  blue  0.886  alpha  0.000]
   }
}

//-----Aqua Tints
#declare Grnt8a = texture {
   granite
   turbulence 0.6
   colour_map {
      [0.000 0.119   colour red  0.310  green  0.384  blue  0.420  alpha  0.631
      colour red  0.322  green  0.369  blue  0.416  alpha  0.847]
      [0.119 0.322   colour red  0.322  green  0.369  blue  0.416  alpha  0.847
      colour red  0.424  green  0.369  blue  0.420  alpha  0.549]
      [0.322 0.449   colour red  0.424  green  0.369  blue  0.420  alpha  0.549
      colour red  0.373  green  0.424  blue  0.518  alpha  0.965]
      [0.449 0.729   colour red  0.373  green  0.424  blue  0.518  alpha  0.965
      colour red  0.482  green  0.573  blue  0.533  alpha  0.741]
      [0.729 1.001   colour red  0.482  green  0.573  blue  0.533  alpha  0.741
      colour red  0.310  green  0.384  blue  0.420  alpha  0.631]
   }
}

//---------- Overtint Green with Black Cracks
#declare Crack3 = texture {
   marble
   turbulence 0.85
   color_map {
      [0.0 0.04 color Black alpha 0.6 color Black alpha 1.0]
      [0.04 0.97 color DarkGreen alpha 0.80 color DarkGreen alpha 0.90]
      [0.97 1.001 color Black alpha 0.9 color Black alpha 1.0]
   }
}

//------------- White Marble with gray veining
#declare Stone17 =
texture { Grnt20 scale <1 2 2> rotate <0 0 -30> ambient 0.2 diffuse 0.8 0.03 }
texture { Crack3 scale <1 2 1.4> rotate <10 0 -20>  }

//------------- Medium Gray Blue Marble
#declare Stone13 =
texture { Grnt24 scale <2 5 2> rotate <0 0 50> ambient 0.2 0.03 }
texture { Grnt8a scale <1 3 2> rotate <0 0 -30>  }

//----- Column Base Texture
#declare BaseTexture =
texture { Stone17 scale <8 8 4> }
texture {
	color Gray
	alpha .4
	phong .2
	phong_size 150
	ambient .15
	diffuse .7
}

#declare CapTexture =
texture { Stone17 scale <8 8 4> }
texture {
	color Gray
	alpha .6
	phong .2
	phong_size 150
	ambient .15
	diffuse .7
}

#declare ColumnTexture =
texture { Stone13 scale <5 7 5> }
texture {
	color Gray
	alpha .5
	phong .5
	phong_size 150
	ambient .15
	diffuse .6
}

#declare PoolTexture =
texture { Stone13 scale <25 17 25> }
texture {
	color Gray
	alpha .3
	phong 1
	phong_size 100
	ambient .25
	diffuse .5
	reflection .2
}



#declare TopPanelTexture =
texture {
	color Gray50
	ambient .3
	diffuse .5
	.07
}

#declare AWallTexture =
texture {
	color Gray30
	ambient .3
	diffuse .5
	.08
}

#declare BMoldingTexture =
texture {
	color Gray70
	ambient .3
	diffuse .5
	.06
}


#declare CWallTexture =
texture {
Stone13 scale <10 10 5>
}
texture {
	color Gray40
	alpha .4
	ambient .3
	diffuse .5
	.06
}


#declare DMoldingTexture =
texture {
	color Gray70
	ambient .3
	diffuse .5
	.06
}



#declare MosacPanelTexture =
texture {
	image_map {
	<1 -1 0> gif "mosac2.gif"
        }
	  scale <47 9 1>
	  translate <-23 -4.5 0>
	  ambient .4
	  diffuse .2
}

#declare ArchTexture =
texture { Stone17 scale <8 8 4> }
texture {
	color Gray
	alpha .6
	ambient .15
	diffuse .7
}

#declare FloorTexture =
	texture { 
	color Gray25
	ambient .2
	diffuse .4
	reflection .2
	phong 1
	phong_size 100
	.05
	}






#declare Lob1Texture =
texture {
	color Gray20
	ambient .4
	diffuse .3
	reflection .25
	.05
}

#declare Lob2Texture =
texture {
	color Gray30
	ambient .7
	diffuse .4
	phong 1
	.05
}






//-------------------------------------------------------------------


//--- Start Constuction
#declare Arch =
object {
  union {
    difference {
      union {
        intersection { Disk_Z scale <21.5 18 10> translate <-9.5 90 0> }
        intersection { Disk_Z scale <21.5 18 10> translate <9.5 90 0> }
      }
	quadric { Cylinder_Z scale <17.5 14 1> translate <-9.5 90 0> }
	quadric { Cylinder_Z scale <17.5 14 1> translate <9.5 90 0> }
	box { UnitBox scale <13 20 12> translate <0 90 0> }
	box { UnitBox scale <19 7 12> translate <0 74 0> }
    }
    difference {
      union {
        intersection { Disk_Z scale <25 14 10> translate <-21 117 0> }
        intersection { Disk_Z scale <25 14 10> translate <21 117 0> }
      }
	quadric { Cylinder_Z scale <21 10 1> translate <-21 117 0> }
	quadric { Cylinder_Z scale <21 10 1> translate <21 117 0> }
	plane { <0 1 0> 117 inverse }
	plane { <1 0 0> -13 }
	plane { <1 0 0> 13 inverse }
    }
	box { UnitBox scale <2 3.875 10> translate <-21 73.8 0> }
	box { UnitBox scale <2 3.875 10> translate <21 73.8 0> }
  }
	   texture { ArchTexture }
		bounded_by {
		box { UnitBox scale <48 23 12> translate <0 94 0> }
		}
translate <0 0 -11>
}

//--- Wall Panel 
#declare TopWall =
object {
   difference {
      box { UnitBox scale <66 22 9> translate <0 96 .5> }
      quadric { Cylinder_Z scale <29 18 1> translate <0 90 0> }
      quadric { Cylinder_Z scale <5 2.5 1> translate <0 108.5 0> }
      box { UnitBox scale <20 6 11> translate <0 74 0> }       	   
   }
        texture { TopPanelTexture }
		bounded_by {
		box { UnitBox scale <67 23 10> translate <0 96 .5> }
		}
translate <0 0 -11>
}



//--- Column

//---Torus for Base
#declare T9 =
quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -84.500000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        59.500000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -84.500000 0.000000 885.062500 >
sturm
}


//--- Base
//--- Leaf Section of Base
#declare B1 =
object {
  union {
   difference { 
    quadric { Sphere scale <2 6.5 2.5> }
    quadric { Sphere scale <2 8 3> translate <-1.5 0 0> }
   }
   difference { 
    quadric { Sphere scale <1 5.75 1.75> }
    quadric { Sphere scale <1 4.75 1> translate <-1 0 0> }
   }
    quadric { Sphere scale <.5 3 .5> translate <-.5 0 0> }
  }
    texture { BaseTexture }
	bounded_by {
	box { UnitBox scale <2.5 7 3> }
	}
translate <-5.5 0 0>
}


//--- Base Mass
#declare B2 =
object {
   union {
     intersection { Disk_Y scale <6.5 3 6.5> translate <0 8 0> }
     intersection { Disk_Y scale <5.5 6 5.5> translate <0 11 0> }
     intersection { Disk_Y scale <9.5 1 9.5> translate <0 1 0> }
     quartic { T9 translate <0 2.5 0> }
   }
    texture { BaseTexture }
}

//--- Complete Base
#declare Base =
composite {
 composite {
   object { B1 rotate <0 0 0> }
   object { B1 rotate <0 45 0> }
   object { B1 rotate <0 90 0> }
   object { B1 rotate <0 135 0> }
   object { B1 rotate <0 180 0> }
   object { B1 rotate <0 225 0> }
   object { B1 rotate <0 270 0> }
   object { B1 rotate <0 315 0> }
 translate <0 11.5 0>
 }
   object { B2 }
      bounded_by {
      box { UnitBox scale <10 9.5 10> translate <0 9 0> }
      }
}

//----- Column Caps


#declare Rib1 =
union {
   sphere { <-6.5 11 0> 1 }
   sphere { <-5.5 6 0> 1 }
   intersection { Disk_Y scale <1 2.5 1> translate <-5.5 8.5 0> }
}

#declare Cap =
object {
  union {
    union { Rib1 rotate <0 30 0> }
    union { Rib1 rotate <0 5 0> }
    union { Rib1 rotate <0 30 0> }
    union { Rib1 rotate <0 -15 0> }
    union { Rib1 rotate <0 -30 0> }
    union { Rib1 rotate <0 -45 0> }
    union { Rib1 rotate <0 -60 0> }
    union { Rib1 rotate <0 -75 0> }
    union { Rib1 rotate <0 -90 0> }
    union { Rib1 rotate <0 -105 0> }
    union { Rib1 rotate <0 -120 0> }
    union { Rib1 rotate <0 -135 0> }
    union { Rib1 rotate <0 -150 0> }
    union { Rib1 rotate <0 -165 0> }
    union { Rib1 rotate <0 -180 0> }
    union { Rib1 rotate <0 -210 0> }
    union { Rib1 rotate <0 -225 0> }
    intersection { Disk_Y scale <6.5 .5 6.5> translate <0 .5 0> }
    intersection { Disk_Y scale <5.5 2.5 5.5> translate <0 3.5 0> }
    box { UnitBox scale <8.5 2 8.5> translate <0 14 0> }
  } 
      texture { CapTexture }
	bounded_by {
	box { UnitBox scale <10 7.5 10> translate <0 7 0> }
	}
}

//--- Main Column Section
#declare Column1 =
object {
   intersection { Disk_Y scale <5.5 20 5.5> }
      texture { ColumnTexture }
}


//--- Complet Column
#declare Column =
composite {
   object { Column1 translate <0 37 0> }
   object { Cap translate <0 56 0> }
   composite { Base }   
	bounded_by {
	box { UnitBox scale <11.5 37 11.5> translate <0 35 0> }
	}
}



//----- Wall

#declare AWall =
object {
   box { UnitBox scale <23 21 2> }
     texture { AWallTexture }
}

#declare BMolding =
object {
   box { UnitBox scale <24 1.5 3> }
     texture { BMoldingTexture }
}

#declare CWall =
object {
   box { UnitBox scale <23 9 2> }
     texture { CWallTexture }
}

#declare DMolding =
object {
   box { UnitBox scale <24 3.7 3> }
     texture { DMoldingTexture }
}

#declare EMolding =
object {
   box { UnitBox scale <24 2 12> }
     texture { ArchTexture }
}

#declare MosacPanel =
object {
   box { UnitBox scale <23.5 4.5 2.5> }
    texture { MosacPanelTexture }
}

//--- Complete Wall with Arch opening & 4 Columns
#declare Wall =
composite {
  composite {
     object { AWall translate <-43 49 0> }
     object { BMolding translate <-43 26.6 0> }
     object { CWall translate <-43 16 0> }
     object { DMolding translate <-43 3.5 0> }
     object { EMolding translate <-43 72 -9> }
     object { MosacPanel translate <-43 32.5 0> }
         bounded_by {
         box { UnitBox scale <25 38 14> translate <-43 37 -8.5> }
         }
  }
  composite {
     object { AWall translate <43 49 0> }
     object { BMolding translate <43 26.6 0> }
     object { CWall translate <43 16 0> }
     object { DMolding translate <43 3.5 0> }
     object { EMolding translate <43 72 -9> }
     object { MosacPanel translate <43 32.5 0> }
         bounded_by {
         box { UnitBox scale <25 38 14> translate <43 37 -8.5> }
         }
  }
     object { TopWall }
     object { Arch }

   composite { Column translate <28.5 0 -11.5> }
   composite { Column translate <-28.5 0 -11.5> }
   composite { Column translate <57.5 0 -11.5> }
   composite { Column translate <-57.5 0 -11.5> }
         bounded_by {
         box { UnitBox scale <68 60 14> translate <0 59 -8.5> }
         }
}

//----- Scaleable Wall

#declare SWall =
composite {
	object {
	box { UnitBox scale <1 3.5 3> translate <0 3.5 0> }
	texture { DMoldingTexture }
        }

	object {
	box { UnitBox scale <1 9 2> translate <0  16 0> }
	texture { CWallTexture scale <.1 1 1> }
	}
	
	object {
	box { UnitBox scale <1 1.5 3> translate <0  26.5 0> }
	texture { BMoldingTexture }
	}
   
	object {
	box { UnitBox scale <1 21 2> translate <0 49 0> }
	texture { AWallTexture }
	}

	object {
	box { UnitBox scale <1 2 12> translate <0 72 -9> }
	texture { ArchTexture scale <.05 1 1> }
	}

	object {
	box { UnitBox scale <1 22 9> translate <0  96 -11> }
	texture { TopPanelTexture }
	}
	    bounded_by {
	    box { UnitBox scale <1.1 60 14> translate <0 59 -8.5> }
	    }
}


//---- Floor & Pool



//--- Floor outside Door
object {
     box { UnitBox scale <260 2 300> translate <0 -2 880> }
	texture { Lob1Texture }
}


#declare Lob1 =
object {
   union {
 	triangle { <-260 2 -125> <-100 2 -125> <-260 2 125> }
 	triangle { <-100 2 -125> <-60 2 -85> <-260 2 125> }
 	triangle { <-260 2 125> <-60 2 -85> <260 2 125> }
 	triangle { <-60 2 -85> <60 2 -85> <260 2 125> }
 	triangle { <260 2 125> <60 2 -85> <100 2 -125> }
 	triangle { <100 2 -125> <260 2 125> <260 2 -125> }
   }
	   texture { Lob1Texture }
		bounded_by {
		box { UnitBox scale <260 1 126> translate <0 2 0> }
		}
}



#declare Lob2 =
object {
   union {
 	triangle { <-260 2 -125> <-260 -2 -125> <-100 2 -125> }
 	triangle { <-260 -2 -125> <-100 -2 -125> <-100 2 -125> }
 	triangle { <-100 2 -125> <-100 -2 -125> <-60 2 -85> }
 	triangle { <-100 -2 -125> <-60 -2 -85> <-60 2 -85> }
	triangle { <-60 2 -85> <-60 -2 -85> <60 2 -85> }
 	triangle { <-60 -2 -85> <60 -2 -85> <60 2 -85> }
 	triangle { <100 2 -125> <100 -2 -125> <60 2 -85> }
 	triangle { <100 -2 -125> <60 -2 -85> <60 2 -85> }
 	triangle { <260 2 -125> <260 -2 -125> <100 2 -125> }
 	triangle { <260 -2 -125> <100 -2 -125> <100 2 -125> }
   }
	   texture { Lob2Texture }
		bounded_by {
		box { UnitBox scale <270 3 30> translate <0 0 -103> }
		}
}


#declare Lob =
composite {
  object { Lob1 }
  object { Lob2 }
		bounded_by {
		box { UnitBox scale <260 3 126> translate <0 0 0> }
		}
}







composite {
	composite { Lob translate <0 -2 480> }
	composite { Lob translate <0 -6 460> }
	composite { Lob translate <0 -10 440> }
	composite { Lob translate <0 -14 420> }

	composite { Lob translate <0 -18 300> }
	composite { Lob translate <0 -22 280> }
	composite { Lob translate <0 -26 260> }
	composite { Lob translate <0 -30 240> }
}




//--- Pool Floor
#declare PoolFloor =
object {
   difference {
     box { UnitBox scale <260 5 230> }
       quadric { Cylinder_Y scale <64 1 64> translate <0 0 69> }
   }
	 texture { Lob1Texture }
	    bounded_by {
	    box { UnitBox scale <260 6 230> }
	    }
}



//--- Pool Wall
#declare PoolWall =
object {
   difference {
     intersection { Disk_Y scale <81 7 81> translate <0 0 69> }
       quadric { Cylinder_Y scale <63 1 63> translate <0 0 69> }
   }
	 texture { PoolTexture }
	    bounded_by {
	    box { UnitBox scale <85 8 85> translate <0 0 69> }
	    }
}




//--- Pool Water
#declare Water =
object {
    box { UnitBox scale <100 1 100> }
       texture {
	color CadetBlue
	ambient .5
	diffuse .2
	phong 1
	reflection .8

       }
}




//--- Pool Bottom
#declare PBottom =
object {
    box { UnitBox scale <100 1 100> }
       texture {
	color MidnightBlue
	ambient .3
	diffuse .4
       }
}

//----- Complete Pursian Backdrop
composite { Wall translate <0 0 600> }
composite { Wall translate <-170 0 500> }
composite { Wall translate <170 0 500> }
composite { SWall scale <50 1 1> rotate <0 -90 0> translate <-106 0 552> }
composite { SWall scale <50 1 1> rotate <0 90 0> translate <106 0 552> }
composite { SWall scale <18.5 1 1> translate <-85.5 0 600> } 
composite { SWall scale <18.5 1 1> translate <85.5 0 600> } 
composite { Column scale <1.7 1.7 1.7> translate <-56 -16 250> }
composite { Column scale <1.7 1.7 1.7> translate <56 -16 250> }


composite {
   object { PoolFloor }
   object { PoolWall }
   object { Water translate <0 1 69> }
//   object { PBottom translate <0 0 0> }
	    bounded_by {
	    box { UnitBox scale <260 8 230> }
	    }
translate <0 -37 0> 
}





 









