//          Canon AE-1 35MM Camera ...............10/15/92 M.Miller








//--- Camera Textures & common shapes


#declare Dot = 
quadric { < 1.0  1.0  1.0> < 0.0  0.0  0.0> < 0.0  0.0  0.0> -1.0 }

#declare Connector_1 = 
intersection {
   quadric { < 0.0  1.0  1.0> < 0.0  0.0  0.0> < 0.0  0.0  0.0> -1.0 }
   plane { < 1.0  0.0  0.0> 1.0 }
   plane { <-1.0  0.0  0.0> 0.0 }
}

#declare Null = texture { color Black }

//----Brush Silver
#declare Tex2 =
texture { 
	color LightGray
	ambient .3
	diffuse .6
	phong 1
	phong_size 10
	.01
	brilliance 8
	reflection .2
	metallic
}

//---- Gloss Black
#declare Tex3 =
texture { 
	color Black
	ambient .1
	diffuse .5
	phong 1
	phong_size 120
	reflection .2
}

//--- Deep Green
#declare Tex4 =
texture { 
	color DarkGreen
	ambient .4
	diffuse .5
	phong 1
}

//--- Red
#declare Tex5 =
texture { 
	color Red
	ambient .3
	diffuse .4
	phong 1
}

//----Brush Silver
#declare B_Silver =
texture { 
	color LightGray
	ambient .3
	diffuse .6
	phong 1
	phong_size 10
	.01
	brilliance 8
	reflection .2
	metallic
}

//---- Gloss Black
#declare G_Black =
texture { 
	color Gray05
	ambient .1
	diffuse .25
	phong 1
	phong_size 50
	reflection .2
}

#declare Crown_Texture =
texture {
     material_map { <1 -1 0> gif "canon.gif" interpolate 4 
	texture { Null }
	texture { Tex5 }
	texture { B_Silver }
	texture { G_Black } 	
      }
	scale <51 19.3 1>
	translate <-25.5 0 0>
}

//--- Better Wrinkle Texture
#declare W1 =
texture {
     bump_map { <1 -1 0> gif "wrinkle.gif" bump_size 4 interpolate 4 
      }
	color Gray05
	scale <13 8 10>
	phong .5
	phong_size 55
	ambient .15
	diffuse .45
}

//--- Camera Body
#declare Camera_Body_Texture =
texture {
     material_map { <1 -1 0> gif "cambody.gif" interpolate 4 
	texture { Null }
	texture { G_Black }
	texture { Tex2 }
	texture { Tex3 } 	
	texture { Tex4 }         
      }
	scale <141 70 1>
	translate <-70 -1 0>
}

#declare Dial_Texture =
texture {
    image_map { <1 -1 0> gif "dial1.gif" interpolate 4 }
      ambient .5
      diffuse 5
      phong 1
      phong_size 120
      reflection .1
      scale <23 23 1>
      translate <-11.5 -11.5 0>
}

//--- Deep Gray
#declare D_Gray =
texture { 
	color DimGray
	ambient .1
	diffuse .3
	phong 1
	phong_size 10
	.01
}

//---- Chrome Silver
#declare C_Silver =
texture { 
	color LightGray
	ambient .2
	diffuse .5
	phong 1
	phong_size 120
	.03
	brilliance 12
	reflection .7
}


//---- F_Stops
#declare F_RING_TEXTURE =
texture {
	image_map { 2 gif "fstop2.gif" interpolate 4 }
	scale <1 37.5 1>
	rotate <0 -90 0>
	translate <0 -37.5 0>
	phong 1
	phong_size 80
	ambient .8
	diffuse .3 
	reflection .2
}

//---- Rubber Lens Grip
#declare GRIP_TEXTURE =
texture {
	image_map { 2 gif "grip.gif" interpolate 4 }
	scale <1 38.5 1>
	rotate <0 -90 0>
	translate <0 -19.5 0>
	phong .3
	phong_size 30
	ambient .1
	diffuse .3 
}

//---- Lens Plate Texture
#declare Plate_Texture =
texture {
	image_map { <1 -1 0>  gif "plate.gif" interpolate 4 }
	scale <60 60 1>
	translate <-30 -30 0>
	phong .7
	phong_size 70
	ambient .5
	diffuse .3 
}

//--- Lens Glass
#declare Glass =
texture {
	color red .99 green .99 blue .99 alpha .95
	ambient .1
	diffuse .2
	phong 1
	phong_size 200
	reflection .15
	ior 1.2
}

#declare Lens_Back =
texture {
	wood
	color_map {
	[0 .2 color Gray40 color Gray40]
	[.2 .4 color Gray30 color Gray30]
	[.4 .7 color Gray10 color Violet]
	[.7 1.1 color Gray05 color Gray05]
        }
	ambient .3
	diffuse .3
	scale <30 30 1>
}


//--- Camera Frame & Body


//--- Round Corner Frame
#declare C_FRAME =
union {
         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate <-57.000000  0.000000 -14.000000>
         }
 
         intersection { Connector_1
         scale     < 12.083046  2.000000  2.000000>
         rotate    < 0.000000 -155.556045  0.000000>
         translate <-57.000000  0.000000 -14.000000>
           }
      
         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate <-68.000000  0.000000 -9.000000>
         }
 
         intersection { Connector_1
         scale     < 18.000000  2.000000  2.000000>
         rotate    < 0.000000 -90.000000  0.000000>
         translate <-68.000000  0.000000 -9.000000>
 	}

         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate <-68.000000  0.000000  9.000000>
         }
 

         intersection { Connector_1
         scale     < 12.083046  2.000000  2.000000>
         rotate    < 0.000000 -24.443955  0.000000>
         translate <-68.000000  0.000000  9.000000>
 	 }

         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate <-57.000000  0.000000  14.000000>
         }
 
         intersection { Connector_1
         scale     < 114.000000  2.000000  2.000000>
         translate <-57.000000  0.000000  14.000000>
 	}

         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate < 57.000000  0.000000  14.000000>
         }
 

         intersection { Connector_1
         scale     < 12.083046  2.000000  2.000000>
         rotate    < 0.000000  24.443955  0.000000>
         translate < 57.000000  0.000000  14.000000>
 	}

         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate < 68.000000  0.000000  9.000000>
         }
 

         intersection { Connector_1
         scale     < 18.000000  2.000000  2.000000>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 68.000000  0.000000  9.000000>
 	}

         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate < 68.000000  0.000000 -9.000000>
         }
 

         intersection { Connector_1
         scale     < 12.083046  2.000000  2.000000>
         rotate    < 0.000000  155.556045  0.000000>
         translate < 68.000000  0.000000 -9.000000>
 	}

         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate < 57.000000  0.000000 -14.000000>
         }
 
 
         intersection { Connector_1
         scale     < 114.000000  2.000000  2.000000>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 57.000000  0.000000 -14.000000>
 	}

         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate <-57.000000  0.000000 -14.000000>
         }
}
 

#declare S_CORNER =
intersection { 
	Disk_Y 
	scale <2 32 2> 
	translate <0 34 0> 
}

#declare BODY_FRAME =
composite {
 object {
  union {
     union { C_FRAME translate <0 2 0> }
     union { C_FRAME translate <0 66 0> }
     intersection { S_CORNER translate <-57 0 -14> }
     intersection { S_CORNER translate <-68 0 -9> }
     intersection { S_CORNER translate <-68 0 9> }
     intersection { S_CORNER translate <-57 0 14> }
     intersection { S_CORNER translate <57 0 14> }
     intersection { S_CORNER translate <68 0 9> }
     intersection { S_CORNER translate <68 0 -9> }
     intersection { S_CORNER translate <57 0 -14> }
     triangle { <-57 66 -16> <-57 2 -16> <57 66 -16> }
     triangle { <-57 2 -16> <57 66 -16> <57 2 -16> }
     triangle { <-57 66 16> <-57 2 16> <57 66 16> }
     triangle { <-57 2 16> <57 66 16> <57 2 16> }
     triangle { <-70 66 -9> <-70 2 -9> <-70 66 9> }
     triangle { <-70 66 9> <-70 2 9> <-70 2 -9> }
     triangle { <70 66 -9> <70 2 -9> <70 66 9> }
     triangle { <70 66 9> <70 2 9> <70 2 -9> }
     triangle { <-57.684040 66 -15.879385> <-57.684040 2 -15.879385> <-68.684044 66 -10.879385> }
     triangle { <-57.684040 2 -15.879385> <-68.684044 2 -10.879385> <-68.684044 66 -10.879385> }
     triangle { <-57.684040 66 15.879385> <-57.684040 2 15.879385> <-68.684044 66 10.879385> }
     triangle { <-57.684040 2 15.879385> <-68.684044 2 10.879385> <-68.684044 66 10.879385> }
     triangle { <57.684040 66 -15.879385> <57.684040 2 -15.879385> <68.684044 66 -10.879385> }
     triangle { <57.684040 2 -15.879385> <68.684044 2 -10.879385> <68.684044 66 -10.879385> }
     triangle { <57.684040 66 15.879385> <57.684040 2 15.879385> <68.684044 66 10.879385> }
     triangle { <57.684040 2 15.879385> <68.684044 2 10.879385> <68.684044 66 10.879385> }
     triangle { <-68 68 -9> <-68 68 9> <-57 68 14> }
     triangle { <-68 68 -9> <-57 68 14> <-57 68 -14> }
     triangle { <68 68 -9> <68 68 9> <57 68 14> }
     triangle { <68 68 -9> <57 68 14> <57 68 -14> }
     triangle { <-57 68 -14> <-57 68 14> <57 68 14> }
     triangle { <-57 68 -14> <57 68 -14> <57 68 14> }
     triangle { <-68 0 -9> <-68 0 9> <-57 0 14> }
     triangle { <-68 0 -9> <-57 0 14> <-57 0 -14> }
     triangle { <68 0 -9> <68 0 9> <57 0 14> }
     triangle { <68 0 -9> <57 0 14> <57 0 -14> }
     triangle { <-57 0 -14> <-57 0 14> <57 0 14> }
     triangle { <-57 0 -14> <57 0 -14> <57 0 14> }
  }
	texture { Camera_Body_Texture }
	   bounded_by {
	   box { UnitBox scale <72 35 18> translate <0 34 0> }
	   }
 }


 object {
  union {
     triangle { <-57 66 -16> <-57 2 -16> <57 66 -16> }
     triangle { <-57 2 -16> <57 66 -16> <57 2 -16> }
     triangle { <-57 66 16> <-57 2 16> <57 66 16> }
     triangle { <-57 2 16> <57 66 16> <57 2 16> }
    }	
        texture { W1 }
	   bounded_by {
	   box { UnitBox scale <72 35 18> translate <0 34 0> }
	   }	
 scale <1.003 1 1.003>
		clipped_by {
		box { UnitBox scale <75 20 20> translate <0 27 0> }
		}
 }


 object {
  union {
     triangle { <-57.684040 66 -15.879385> <-57.684040 2 -15.879385> <-68.684044 66 -10.879385> }
     triangle { <-57.684040 2 -15.879385> <-68.684044 2 -10.879385> <-68.684044 66 -10.879385> }
     triangle { <57.684040 66 15.879385> <57.684040 2 15.879385> <68.684044 66 10.879385> }
     triangle { <57.684040 2 15.879385> <68.684044 2 10.879385> <68.684044 66 10.879385> }
    }	
        texture { W1 rotate <0 30 0> }
	   bounded_by {
	   box { UnitBox scale <72 35 18> translate <0 34 0> }
	   }	
 scale <1.003 1 1.003>
		clipped_by {
		box { UnitBox scale <75 20 20> translate <0 27 0> }
		}
 }


 object {
  union {
     triangle { <-57.684040 66 15.879385> <-57.684040 2 15.879385> <-68.684044 66 10.879385> }
     triangle { <-57.684040 2 15.879385> <-68.684044 2 10.879385> <-68.684044 66 10.879385> }
     triangle { <57.684040 66 -15.879385> <57.684040 2 -15.879385> <68.684044 66 -10.879385> }
     triangle { <57.684040 2 -15.879385> <68.684044 2 -10.879385> <68.684044 66 -10.879385> }
    }	
        texture { W1 rotate <0 -30 0> }
	   bounded_by {
	   box { UnitBox scale <72 35 18> translate <0 34 0> }
	   }	
 scale <1.003 1 1.003>
		clipped_by {
		box { UnitBox scale <75 20 20> translate <0 27 0> }
		}
 }

 object {
  union {
     triangle { <-70 66 -9> <-70 2 -9> <-70 66 9> }
     triangle { <-70 66 9> <-70 2 9> <-70 2 -9> }
     triangle { <70 66 -9> <70 2 -9> <70 66 9> }
     triangle { <70 66 9> <70 2 9> <70 2 -9> }
    }	
        texture { W1 rotate <0 90 0> }
	   bounded_by {
	   box { UnitBox scale <72 35 18> translate <0 34 0> }
	   }	
 scale <1.003 1 1.003>
		clipped_by {
		box { UnitBox scale <75 20 20> translate <0 27 0> }
		}
 }

	   bounded_by {
	   box { UnitBox scale <72 35 18> translate <0 34 0> }
	   }	
}


//--- Camera Crown, Flash Clip, Lens Base, Shutter Trigger & Speed Dial




#declare Crown =
object {
  intersection {
	plane { <0 1 0> 0 inverse }
	plane { <1 0 0> 0 rotate <0 0 -21> translate <-25.5 0 0> inverse }
	plane { <1 0 0> 0 rotate <0 0 21> translate <25.5 0 0> }
	plane { <1 0 0> 0 rotate <0 0 -48.7> translate <-24 4 0> inverse }
	plane { <1 0 0> 0 rotate <0 0 48.7> translate <24 4 0> }
	plane { <0 0 1> 0  }
	plane { <0 0 1> 0 rotate <14 0 0> translate <0 0 -46.5> inverse }
	plane { <0 0 1> 0 rotate <35 0 0> translate <0 4 -46> inverse }
	plane { <0 0 1> 0 rotate <-77 0 0> translate <0 11 0>  }
   }
         texture { Crown_Texture }
            bounded_by {
	    box { UnitBox scale <27 11 25> translate <0 9 -23> }
	    }
}

//--- Flash Clip
#declare Clip =
composite {
 object {
   union {
    difference {
      union {
	box { UnitBox scale <10 1 9> translate <0 1 0> }
	intersection { Disk_Z scale <2 2 9> translate <-8 2 0> }
	intersection { Disk_Z scale <2 2 9> translate <8 2 0> }
      }
	box { UnitBox scale <9 1 10> translate <0 2 0> }
	quadric { Cylinder_Y scale <4 1 4> }
	box { UnitBox scale <2 8 3.5> translate <0 0 6> }	
    }
	intersection { Disk_Y scale <2 1.2 2> }
	box { UnitBox scale <1 .5 9> translate <7 3.5 0> }	
	box { UnitBox scale <1 .5 9> translate <-7 3.5 0> }	
   }
	   texture { B_Silver }
            bounded_by {
	    box { UnitBox scale <11 2.5 10> translate <0 2 0> }
	    }
 }

 object {
   box { UnitBox scale <10 2.5 10> translate <0 -2 .5> }
      texture { G_Black }
 }
}


//--- Lens Base
#declare Lens_Base =
object {
   union {
     intersection { Disk_Z scale <22 22 5> translate <-8 22 -5> }
     intersection { Disk_Z scale <22 22 5> translate <8 22 -5> }
     box { UnitBox scale <8 11 5> translate <0 11 -5> } 
     intersection {
	plane { <0 1 0> 22 inverse }
	plane { <0 1 0> 67.5 }
	plane { <0 0 1> 0 }
	plane { <0 0 1> -10 inverse }
	plane { <1 0 0> 0 rotate <0 0 -5.6> translate <-30 22 0> inverse }
	plane { <1 0 0> 0 rotate <0 0 5.6> translate <30 22 0> }	
      }
     intersection {
	quadric { Cylinder_X scale <1 7 4.5> translate <0 68 -10> }
	plane { <1 0 0> 0 rotate <0 0 -5.6> translate <-30 22 0> inverse }
	plane { <1 0 0> 0 rotate <0 0 5.6> translate <30 22 0> }	
	plane { <0 1 0> 67.5 }	
	quadric { Cylinder_Z scale <32 32 1> translate <0 33.5 0> inverse}
     }
//     intersection { Disk_Z scale <26 26 2.5> translate <0 33.5 -12.5>   }

   } 
	  texture { B_Silver }
            bounded_by {
	    box { UnitBox scale <32 37 9> translate <0 34 -5> }
	    }
}


#declare Trigger =
composite {
composite {
 object { 
   union {
     intersection {
	plane { <0 1 0> 0 inverse }
	plane { <0 1 0> 7 }
	plane { <1 0 0> -17.5 inverse }
	plane { <1 0 0> 7.5 }
	plane { <0 0 1> 15 }
	plane { <0 0 1> -7.5 inverse }
	plane { <1 0 0> 0 rotate <0 53 0> translate <-17.5 0 7.5> inverse }
	plane { <1 0 0> 0 rotate <0 45 0> translate <7.5 0 0>  }
     }
	intersection { Disk_Y scale <7.5 3.5 7.5> translate <-17.5 3.5 0> }
	intersection { Disk_Y scale <7.5 3.5 7.5> translate <0 3.5 0> }
	intersection { Disk_Y scale <13 3.5 13> translate <2.5 3.5 20> }	

      difference {
	box { UnitBox scale <3 1 3.5> translate <-17.5 1 -9> }
	box { UnitBox scale <1.5 2 2.75> translate <-17.5 1 -8.2> }
      }
      difference {
	quadric { Sphere scale <7 2 7> translate <0 7 0> }
	quadric { Cylinder_Y scale <2.2 1 2.2> }
      }
   }
	   texture { G_Black }
}

//--- Shutter speed dial
 object {
  union { 
   intersection { Disk_Y scale <12 3.5 12> translate <2.5 5 20> }
   intersection { 
      intersection { Disk_Y scale <2.5 2.1 2.5> translate <0 7 0> }
      quadric { Cylinder_Y scale <1.2 1 1.2> inverse } 
   } 
  }
    texture { B_Silver }
 }

 object {
   intersection { Disk_Z scale <11.5 11.5 2> }
    texture { Dial_Texture }
     rotate <90 0 0>
     translate <2.5 6.9 20>
 }
	bounded_by {
	box { UnitBox scale <21 5 23> translate <-5.7 4 9.3> }
	}
}
 
//---- Film Advance 
  object {
    difference {
      union {
	box { UnitBox scale <9 4 9> translate <-8.5 4 9> }
	intersection { Disk_Y scale <23 4 24> translate <-17.5 4 24> }
      }
	plane { <1 0 0> 0 inverse }
	quadric { Cylinder_Y scale <20 1 11.1> translate <-17.5 0 20> }
	plane { <1 0 0> 0 rotate <0 75 0> translate <-37.5 0 15> }
	box { UnitBox scale <10 5 20> translate <-7.5 9 0> }
	quadric { Cylinder_Z scale <10.5 4 1> translate <-17.5 8 0> }
     }
	  texture { G_Black }
	bounded_by {
	box { UnitBox scale <20 5 10> translate <-19 4 9> }
	}
 rotate <0 90 0> translate <-25 0 0>  
 }

//--- Finger Grip
 object {
   union {
    intersection { Disk_Y scale <6.5 1 6.5> translate <-17.5 6.5 0> }
    box { UnitBox scale <6.9 1 6.5> translate <-10.6 6.5 0> }
   }
      texture { D_Gray }
 }
}






//----- Round Corner Tous for Strap Clip
#declare R1 = 
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -61.780000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        59.220000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -61.780000 0.000000 876.752100 >
rotate <90 0 0> 
  }

//--- Strap Clip, Battery Door & Film Door Hinge

//--- 3 sided clip
#declare Clip1 =
object {
  union {
    difference {
      quartic { R1 translate <-4.3 -2.8 0> }
      plane { <1 0 0> -4.3 inverse }
      plane { <0 1 0> 0 rotate <0 0 30> translate <-4.3 -2.8 0> }
    }
    difference {
      quartic { R1 translate <4.3 -2.8 0> }
      plane { <1 0 0> 4.3  }
      plane { <0 1 0> 0 rotate <0 0 -30> translate <4.3 -2.8 0> }
    }
    difference {
      quartic { R1 translate <0 -10 0> }
      plane { <0 1 0> 0 rotate <0 0 30> translate <0 -10 0> inverse  }
      plane { <0 1 0> 0 rotate <0 0 -30> translate <0 -10 0> inverse }
    }
    difference {
      quadric { Cylinder_Y scale <.8 1 .8> rotate <0 0 30.6> translate <-4.763140 -12.750000 0> }
      plane { <0 1 0> 0 rotate <0 0 30> translate <0 -10 0> }
      plane { <0 1 0> 0 rotate <0 0 30> translate <-4.3 -2.8 0> inverse }
    }
    difference {
      quadric { Cylinder_Y scale <.8 1 .8> rotate <0 0 -30.6> translate <4.763140 -12.750000 0> }
      plane { <0 1 0> 0 rotate <0 0 -30> translate <0 -10 0> }
      plane { <0 1 0> 0 rotate <0 0 -30> translate <4.3 -2.8 0> inverse }
    }
    intersection { Disk_X scale <4.3 .8 .8> translate <0 2.7 0> }
   }
       texture { C_Silver }
	bounded_by {
	quadric { Sphere scale <12 12 12> translate <0 -5 0> }
	}
}

//-- Triangle Strap Clip
#declare Strap_Clip =
composite {
  object { Clip1 translate <0 -4 -.8> }
  object { Clip1 translate <0 -4 .8> }
  object {
    intersection {
      quadric { Sphere scale <3 4.5 3> }
      plane { <1 0 0> 2 }
      plane { <1 0 0> -2 inverse }
    }
       texture { C_Silver }
  }
	bounded_by {
	quadric { Sphere scale <14 14 14> translate <0 -5 0> }
	}
scale <.7 .8 1>
}



#declare Hinge =
composite {
  object {
    intersection { Disk_Y scale <2.5 25 2.5> translate <0 28.5 0> }
      texture { G_Black }
  }
  object {
    intersection {
	quadric { Cylinder_Y scale <2 1 2> }
	plane { <0 1 0> 0 rotate <0 0 -42> inverse }
	plane { <0 1 0> 0 rotate <0 0 60> translate <2 64.5 0> }
    }
	   texture { B_Silver }
   }
	bounded_by {
	box { UnitBox scale <3 30 3> translate <0 29 0> }
	}
}

#declare Battery_Door =
object {
  union {
   difference {
    box { UnitBox scale <9 15 1> }
    box { UnitBox scale <7.5 13.5 2> }
   }
    intersection { Disk_Y scale <2.5 15 2.5> translate <-6.5 0 -1> }
    intersection { Disk_Z scale <2 2 2> translate <-12.5 0 0> }
   }
      texture { G_Black }
	bounded_by {
	box { UnitBox scale <13 16 4> translate <-3 0 0> }
	}
}

//--- Camera Lens


#declare Lens =
composite {

 //--- fStop rings
 object {
   union {
     intersection { Disk_Y scale <31 7.5 31> translate <0 -7.5 0> }
     intersection { Disk_Y scale <32 3.5 32> translate <0 -6 0> }
     intersection { Disk_Y scale <30 7.5 30> translate <0 -22.8 0> }
     intersection { Disk_Y scale <32 4.5 32> translate <0 -35 0> }
   }
     texture { F_RING_TEXTURE }
	bounded_by {
	box { UnitBox scale <35 21 35> translate <0 -18.5 0> }         
	}
 }

 //--- Rubber Grip
 object {
   intersection { Disk_Y scale <33 19 33> }
     texture { GRIP_TEXTURE }
 translate  <0 -59 0>
 }

 //--- Front Rim 
 object {
   difference {
     intersection { Disk_Y scale <32 6 32> translate <0 -83.5 0> }
     quadric { Cylinder_Y scale <30 1 30> }
   }
      texture { G_Black }
	bounded_by {
	box { UnitBox scale <33 7 33> translate <0 -83.5 0> }         
	}
 }    
  
//--- Lens PLate
composite {
  object {
   difference {
     intersection { Disk_Z scale <30 30 1> }
     quadric { Cylinder_Z scale <24 24 1> }
   }
      texture { Plate_Texture }
	bounded_by {
	box { UnitBox scale <33 33 2> }
	}
  }

//--- Inner lens walls
  object {
    intersection { Disk_Z scale <30 30 1> translate <0 0 8> }
      texture { Lens_Back }
  }

//--- Glass lens
 object {
   union {
     quadric { Sphere scale <30 30 4> translate <0 0 3> }
     quadric { Sphere scale <10 10 6> translate <0 0 7> }
   }
       texture { Glass }
 }
 rotate <-90 0 0> translate <0 -86 0>
}
	bounded_by {
	box { UnitBox scale <37 50 37> translate <0 -45 0> }
	}
 }


//--- Some Camera Buttons

#declare Buttons =
composite {
 composite {
  object {
    union {
      intersection { Disk_Y scale <4 1 4> translate <36 69 -7.7> }
      quadric { Sphere scale <2 1 2> translate <41 71 9.5> }
    }
      texture { B_Silver }
  }

  object {
    union {
      intersection { Disk_Y scale <3 1.5 3> translate <41 69.5 9.5> }
      quadric { Sphere scale <3 .5 3> translate <36 70 -7.7> }
    }
      texture { G_Black }
  }
	bounded_by {
	box { UnitBox scale <7.5 2.5 16> translate <38 70 0> }
	}
 }

//--- Film Rewind Crank
composite {
  object {
   union {
    intersection { 
      quadric { QCone_Y scale <13 35 13> translate <0 35 0> }
      plane { <0 1 0> 6 }
      plane { <0 1 0> 0 inverse }
    }
   intersection { Disk_Y scale <2.5 2.5 2.5> translate <-9 8.5 0> }
   }
	texture { G_Black }
          bounded_by {
	  box { UnitBox scale <14 7 14> translate <0 6.5 0> }
	  }
   }

  object {
   union {
    intersection { 
      quadric { QCone_Y scale <13 35 13> translate <0 35 0> }
      plane { <0 1 0> 6.5 inverse }
      plane { <0 1 0> 12 }
      box { UnitBox scale <15 2.5 3> translate <0 10.2 0> inverse }
    }
      box { UnitBox scale <10 .5 2.5> translate <-1 11.2 0> inverse }
   }
	texture { B_Silver }
          bounded_by {
	  box { UnitBox scale <15 4 15> translate <0 9.3 0> }
	  }
   }
   translate <55.3 68 0>
  }

//--- Front Button
 composite {
   object {
    intersection { Disk_Z scale <4.5 4.5 1> }
     texture { B_Silver }
   }
   object {
    quadric { Sphere scale <4.5 4.5 1> translate <0 0 -1.1> }
     texture { G_Black }
   }
	bounded_by {
	box { UnitBox scale <5 5 3> }
	}
 translate <43.8 59.5 -17>
 }
          bounded_by {
	  box { UnitBox scale <22.5 15 18> translate <50 67 -1> }
	  }
 }

//-- Complete Camera
#declare Camera =
composite {
  composite { 	BODY_FRAME }
  object { 	Crown translate <0 68 16> } 
  composite { 	Clip translate <0 83.5 5.5> }
  object { 	Lens_Base translate <0 .5 -16> }
  composite { 	Trigger scale <.92 .92 .92> rotate <0 33 0> translate <-44 68 -10.8> }
  composite { 	Strap_Clip rotate <0 23 0> translate <-64 57.8 -13.8> }
  composite { 	Strap_Clip rotate <0 -23 0> translate <64 57.8 -13.8> }
  composite { 	Hinge translate <-71.3 1.5 0> }
  object { 	Battery_Door translate <-42.2 31 -16> }
  composite { 	Lens rotate <90 0 0> translate <0  33.5 -26.4> }
  composite { 	Buttons }
}




