// Persistence Of Vision raytracer version 1.0 sample file.
// written by Paul Cotterill
// lots of help from various sample pov files.
// Demonstrates blob sculpture and various mappings.
// For the sake of simplicity the same gif image has been used for most textures.
// I used 5 different gifs for the original picture,though some restraint might well improve it.

#include "colors.inc"
#include "textures.inc"
#include "shapes2.inc"
#include "shapes.inc"

#declare Bi = 2

#declare Texture0 = /* Planar image map */
texture { image_map { 0 gif "miro1.gif" once interpolate Bi } }

#declare Texture1 = /* Planar image map */
texture { image_map { 0 gif "miro1.gif"  interpolate Bi } }

#declare Texture2 = /* Planar image map */
texture { image_map { 0 gif "miro1.gif" once interpolate Bi } }

#declare Texture3 = /* Planar image map */
texture { image_map { 0 gif "miro1.gif" once interpolate Bi } }

#declare Texture4 = /* Planar image map */
texture { material_map { <1.0 -1.0 0> gif "miro1.gif"  interpolate 2
	texture { color White }
	texture { color MidnightBlue }
	texture { color BrightGold } }
	specular 0.4
	roughness 0.5
	translate <-0.5 -0.5 0>     // Center the image
	scale < 2.0 1.5 2.0>
	}

#declare Texture5 = /* Cylindrical image map */
texture { image_map { 2 gif "miro1.gif" 
	alpha 0 1.0
	once interpolate Bi } }


#declare DMF_Hyperboloid = quadric {  /* Like Hyperboloid_Y, but more curvy */
   <1.0 -1.0  1.0>
   <0.0  0.0  0.0>
   <0.0  0.0  0.0>
   -0.5
}


camera {
   location  <-5  0 -30.0>
   direction <0.0  0.0  2.0>
   up        <0.0  1.0  0.0>
   right     <1.33 0.0  0.0>
   look_at <-1.0 -1.0 1.0>
}

object {
    light_source { <-14.0 2.0 -35>
      colour White
	spotlight
	point_at <2.0 -2.0 2.0>
	tightness 20
	radius 30
	falloff 30
   }
}


object {
	plane { <0  1 0> -9.5 }
	texture { White_Marble }
}

object {
	plane { <0  1 0> 20.0 }
	texture { White_Marble }
}

object {
	plane { <1 0 0> -15.0 }
	texture { PinkAlabaster }
}

object {
   plane { <0 0 1> 0 }
   clipped_by {
      box { <0 0 -1> <1 1 1> }
   }
   texture { Texture0 }
   translate <0 0 2.5>
   scale <20 20 20>
   translate <0 10.0 2.0>
   color Red
}

object {
   plane { <0 0 1> 0 }
   clipped_by {
      box { <0 0 -1> <1 1 1> }
   }
   texture { Texture1 }
   translate <0 0 2.5>
   scale <20 20 20>
   translate <0 -10 2.0>
   color Red
}

object {
   plane { <0 0 1> 0 }
   clipped_by {
      box { <0 0 -1> <1 1 1> }
   }
   texture { Texture2 }
   translate <0 0 2.5>
   scale <20 20 20>
   translate <-20 10 2.0>
   color Red
}

object {
   plane { <0 0 1> 0 }
   clipped_by {
      box { <0 0 -1> <1 1 1> }
   }
   texture { Texture3 }
   translate <0 0 2.5>
   scale <20 20 20>
   translate <-20 -10 2.0>
   color Red
}



// The image map has not been correctly applied to these planes
// at the right side of the picture,but I thought I would leave them for the different effect.
object {
   plane { <1 0 0> 0 } 
   clipped_by {
      box { <0 0 -1> <1 1 1> }
   }
   texture { Texture3 }
   translate <0 0 2.0>
   scale <20 20 20>
   translate <20 10 2.0>
   color Red
}

object {
   plane { <1 0 0> 0 } 
   clipped_by {
      box { <0 0 -1> <1 1 1> }
   }
   texture { Texture1 }
   translate <0 0 2.0>
   scale <20 20 20>
   translate <20 -10 2.0>
   color Red
}


// The blob sculpture.
object {
   blob {
      threshold 0.4
      component 1.0 0.65 <0.25 0.25 0>
      component 1.0 0.65 <-0.25 0.25 0>
      component 1.0 0.75 <0 1.0 0>		
      component 1.0 0.5 <0 1.5 0>
      component 1.0 0.75 <0 1.5 0.75>
      component 1.0 0.65 <0 1.65 1.25>
      component 1.0 0.65 <0.5  1.5 0>
      component 1.0 0.65 <-0.5 1.5 0>
      component 1.0 0.75 <0 1.5 -0.75>
      component 1.0 0.65 <0 1.65 -1.25>
      component -1.0 0.5 <0 1.75 0.75>
      component -1.0 0.5 <0 1.85 1.250>	
      component -1.0 0.5 <0 1.75 -0.75>
      component -1.0 0.5 <0 1.85 -1.25> 
	sturm
   }
   texture {
    
      Silver_Metal
      
   }
    scale <2.0 1.5 1.25>
    bounded_by {
		sphere { <0 0 0> 4.0 }
	}
   rotate <0 -60 0>
   scale <3.0 3.0 3.0>
   translate <-0.5 -8.25 2.5>
	
}

// This is the vase,the concept borrowed from Skyvase.pov.
// The vase is painted with a texture map.
composite {
   object {

      union {
         intersection {
            plane { <0 1 0> 0.7 }
            quadric { DMF_Hyperboloid scale <0.75 1.25 0.75> }
            quadric { DMF_Hyperboloid scale <0.70 1.25 0.70> inverse }
            plane { <0.0 1.0 0.0> -1.0 inverse }
         }
         quadric { Ellipsoid scale <1.5 1.75 1.5 > translate <0 -1.15 0> }
      }

      scale <1.5 1.5 1.5>
      texture {
        

	Texture4
      }
      color Green
   }



   bounded_by {
      intersection {
         Disk_Y
         translate <0.0 -0.5 0.0> 
         scale <5 15 5>
      }
   }
	translate <-7.5 -2.50 1.0>
}

object {  /* Stand for the vase */
   intersection { Hexagon
      rotate <0.0 0.0 -90.0>	/* Stand it on end (vertical)*/
      rotate<0.0 -45.0 0.0>	/* Turn it to a pleasing angle */
      scale<2.5 1.5 2.5>
      translate<-7.5 -8.0 1.0>
   }
   texture {
      Sapphire_Agate
      scale <2.0 2.0 2.0>
      ambient 0.2
      diffuse 0.75
      reflection 0.85
   }
   color red 1.0         
}

// This demonstrates a simple bump map.
composite {
object {
   sphere { <0.0  0.0  0.0>  5.0 }

   texture {	
      color OldGold 
      bump_map { <1.0 -1.0 0.0> gif "miro1.gif"
         bump_size 20.0
         interpolate 2.0
      }
      scale < 10.0 10.0 10.0 >	 
      translate < 5.0 -5.0 0.0 >	
      ambient 0.2
      diffuse 0.7
      specular 0.6
   }
   translate <0.0 2.5 0.0>
}

// A cylindrical image map,which tends to get lost in the larger picture.
// The alpha value in the texture gives some resemblance to a chain.
object {
   quadric { Cylinder_Y }
   clipped_by { box {<-2 0 -2> <2 1 2> } }
   texture {
      Texture5
   }
 
   scale <1.25 25 1.25>
   rotate <0 -45 0>
 
   color Red
}
scale <0.25 0.25 0.25>
translate <5.0 2.5 2.5>
}

