// Persistence of Vision Raytracer
//
// sample file using the letters from alphabet.inc
//

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "alphabet.inc"

camera {
	location <13 14 -11>
	up <0 1 0>
	right <1.333 0 0>
	look_at <0 0 3>
 }

/* light sources along the three axes to make the center widget cast the 
     apropriate shadows */

object {light_source { <0 0 -1000> colour Gray60  }}
object {light_source { <1000 0 0> colour Gray70  }}
object {light_source { <0 1000 0> colour Gray80  }}

object { /* sky - not in direct view, but useful for giving the shiny 
          bits something to reflect */
     sphere { <0 0 0> 1100  }
	texture {
		gradient <0 1 0> 
		colour_map {
			[0 1.01 colour red 0.8 green 0.8 blue 1.0
				colour red 0.5 green 0.5 blue 0.8]
	          }
		scale <1 1100 1>
	     }
	texture { Clouds
		scale <100 100 100>
	     }
     } /* end of sky object */

object { /* Brass plate with cutout letters "TRACE" (and raised border) */
          /* this object takes a csg shape and subtracts the letters from 
          it like a cookie cutter.  Although this example uses 
          infinitely deep letters to cut all the way through, 
          there should be no problem using another plane on the 
          letters to limit how deep they cut into the base object. */
     difference {
          intersection { /* basic rectangular plate */
               plane { <1 0 0> 33  }
               plane { <-1 0 0> 0  }
               plane { <0 1 0> 9  }
               plane { <0 -1 0> 0  }
               plane { <0 0 1> 1.2  }
               plane { <0 0 -1> 0  }
               }
          intersection { /* subtract a smaller rectangle of limited depth 
                         from the base to create the raised edges */
               plane { <1 0 0> 32  }
               plane { <-1 0 0> -1  }
               plane { <0 1 0> 8  }
               plane { <0 -1 0> -1  }
               plane { <0 0 1> 0.2  }
               }
          /* now cut out the letters */
          intersection { al_letter_t 
               translate <2 2 0>
               }
          intersection { al_letter_r
               translate <8 2 0>
               }
          intersection { al_letter_a
               translate <14 2 0>
               }
          intersection { al_letter_c
               translate <20 2 0>
               }
          intersection { al_letter_e 
               translate <26 2 0>
               }
          }
     texture { Brass_Texture }
     bounded_by {
          intersection {
               quadric { Cylinder_X scale <1 5 3> translate <0 5 3>  }
               plane { <1 0 0> 34  }
               plane { <-1 0 0> 1  }
               }
          }
 	scale <0.25 0.25 0.25> 
	translate <-8.25 0 0> 
	rotate <45 -45 0>
	translate <4.5 6.8 4.5> 
     } /* end brass plate */

object { /* a Goedelian widget consisting of a cube which has 
          been jig-sawed into a different letter along each axis - in this
          case the initials "GEB" for "Goedel, Escher, Bach" the wonderul 
          book from which this idea came. A rather complex looking object, 
          but quite simple to make.  For the best appreciation of the thing, 
          look at the shadows it casts. */
     intersection {
          intersection { al_letter_e  }
          intersection { al_letter_b
               translate <-2.5 -2.5 0>
               rotate <90 -90 0>
               translate <2.5 0 2.5>
               }
          intersection { al_letter_g
               translate <-2.5 -2.5 0>
               rotate <0 -90 0>
               translate <0 2.5 2.5>
               }
          }
     bounded_by {
          sphere { <2.5 2.5 2.5> 7.7  }
          }
	texture { Tom_Wood  reflection 0.1 phong 1.0 phong_size 5 
		scale <0.5 1 10>
		rotate <5 15 0>
	     }
	translate <-4 -4 3>
     } /* end block widget */

object { /* a last example, "extruded" letters - "POV" in this case 
          (running out of clever ideas) */
	intersection {
		union {
			difference { al_letter_p }
			difference { al_letter_o translate <6 0 0>  }
			difference { al_letter_v translate <12 0 0>  }
		     }
		plane { <0 0 -1> 0  }
		plane { <0 0 1> 3 rotate <30 0 0>  }
	     }
	texture { gradient <0 1 0>
		colour_map {
			[0 1.01 colour red 0.5 green 0.5 blue 1 
				colour red 0.5 green 1 blue 0.5]
		     }
		scale <5 5 5>
	     }
	bounded_by {
		intersection {
			quadric { Cylinder_X scale <1 5 5>  }
			plane { <1 0 0> 17.01  }
			plane { <-1 0 0> 0.01  }
		     }
	     }
	translate <-6.5 -2.5 0>
	rotate <90 0 0>
	translate <0 -7.6 -2.5>
	rotate <0 -45 0>
     } /* end extruded letters */

/* now for some interesting background surfaces to cast the shadows on */
object { plane { <1 0 0> -10  } 
     texture { Brown_Agate
          scale <2 20 15>
          reflection 0.1
          specular 1.0
          roughness 0.01
          }
     }

object { plane { <0 1 0> -10  } 
	texture { Sapphire_Agate 
		reflection 0.1 
		specular 1.0
		roughness 0.01
		scale <10 15 20>
	     }
     }

object { plane { <0 0 1> 15  } 
	texture { Blood_Marble 
		reflection 0.1 
		specular 1.0
		roughness 0.01
		scale <4 6 10>
	     }
     }


