// Persistence of Vision Raytracer
//
// alphabet.inc
//
// CSG Alphabet file.  Using several standard shapes and cut-outs, this file 
// implements a 3 dimensional alphabet for use in POV traces.  These letters 
// can be created, scaled, rotated, combined with other objects, subtracted 
// from other objects, etc, to your heart's content.  As the "font" is 
// relatively simple, it traces pretty fast, provided you bound the 
// letters properly.
//
// Usage Notes:
//
// Due to some reason I can't remember anymore, the letters are created as
// infinitely long objects along the Z axis. Each letter is 5 by 5 units 
// in the x and y directions, with the bottom left corner of the 5 by 5 
// square at the origin (0,0). 
// 
// Unfortunately, I haven't had the need or the time to create a lower 
// case font to match, only upper case letters are supplied.
//
// For examples on how to use the font, see the examples in sample.inc
//
// Future (?) Improvements:
//
// It would probably make sense to truncate the things at z = 0 and z = 5, 
// and rescale the result to make it 1 by 1.  If someone wishes to do so 
// and upload the result, please be my guest. This would also make it 
// easier to include each in an appropriately sized bounding sphere as 
// part of the definition.  Unfortunately, I think this would probably 
// break my sample file so it would have to be reworked also.  Rather than 
// continue to hold back until some possible future time when the thing is 
// perfect, I decided to release it with all its warts now, in the hopes
// that someone may find it useful.
//

#declare al_base = intersection {
	plane { <-1 0 0> 0  }
	plane { <1 0 0> 5  }
	plane { <0 1 0> 5  }
	plane { <0 -1 0> 0  }
 }

#declare al_bot_clip = intersection {
	plane { <1 0 0> 4  }
	plane { <-1 0 0> -1  }
	plane { <0 1 0> 2  }
 }

#declare al_top_clip = intersection {
	plane { <1 0 0> 4  }
	plane { <-1 0 0> -1  }
	plane { <0 -1 0> -3  }
 }

#declare al_left_clip = intersection {
	plane { <1 0 0> 2  }
	plane { <0 1 0> 4  }
	plane { <0 -1 0> -1  }
 }

#declare al_right_clip = intersection {
	plane { <-1 0 0> -3  }
	plane { <0 1 0> 4  }
	plane { <0 -1 0> -1  }
 }

#declare al_center_punch = intersection {
	plane { <-1 0 0> -1  }
	plane { <1 0 0> 4  }
	plane { <0 1 0> 4  }
	plane { <0 -1 0> -1  }
 }

#declare al_top_punch = intersection {
	plane { <-1 0 0> -1  }
	plane { <1 0 0> 4  }
	plane { <0 1 0> 4  }
	plane { <0 -1 0> -3  }
 }

#declare al_bot_punch = intersection {
	plane { <-1 0 0> -1  }
	plane { <1 0 0> 4  }
	plane { <0 1 0> 2  }
	plane { <0 -1 0> -1  }
 }

#declare al_tl_out_corner = intersection {
	quadric { Cylinder_Z inverse translate <1 4 0>  }
	plane { <1 0 0> 1  }
	plane { <0 -1 0> -4  }
 }

#declare al_tr_out_corner = intersection {
	quadric { Cylinder_Z inverse translate <4 4 0>  }
	plane { <-1 0 0> -4  }
	plane { <0 -1 0> -4  }
 }

#declare al_bl_out_corner = intersection {
	quadric { Cylinder_Z inverse translate <1 1 0>  }
	plane { <1 0 0> 1  }
	plane { <0 1 0> 1  }
 }

#declare al_br_out_corner = intersection {
	quadric { Cylinder_Z inverse translate <4 1 0>  }
	plane { <-1 0 0> -4  }
	plane { <0 1 0> 1  }
 }

#declare al_tl_in_corner = intersection {
	quadric { Cylinder_Z scale <0.5 0.5 1> inverse translate <1.5 3.5 0>  }
	plane { <1 0 0> 1.5  }
	plane { <0 -1 0> -3.5  }
 }

#declare al_tr_in_corner = intersection {
	quadric { Cylinder_Z scale <0.5 0.5 1> inverse translate <3.5 3.5 0>  }
	plane { <-1 0 0> -3.5  }
	plane { <0 -1 0> -3.5  }
 }

#declare al_bl_in_corner = intersection {
	quadric { Cylinder_Z scale <0.5 0.5 1> inverse translate <1.5 1.5 0>  }
	plane { <1 0 0> 1.5  }
	plane { <0 1 0> 1.5  }
 }

#declare al_br_in_corner = intersection {
	quadric { Cylinder_Z scale <0.5 0.5 1> inverse translate <3.5 1.5 0>  }
	plane { <-1 0 0> -3.5  }
	plane { <0 1 0> 1.5  }
 }


/* now for the letters */

#declare al_letter_o = difference {
	intersection { al_base  }
	intersection { al_tl_out_corner  }
	intersection { al_tr_out_corner  }
	intersection { al_bl_out_corner  }
	intersection { al_br_out_corner  }
	difference {
		intersection { al_center_punch  }
		intersection { al_tl_in_corner  }
		intersection { al_tr_in_corner  }
		intersection { al_bl_in_corner  }
		intersection { al_br_in_corner  }
	 }
 }

#declare al_letter_a = difference {
	intersection { al_base  }
	intersection { al_tl_out_corner  }
	intersection { al_tr_out_corner  }
	intersection { al_bot_clip  }
	difference {
		intersection { al_top_punch  }
		intersection { al_tl_in_corner  }
		intersection { al_tr_in_corner  }
	 }
 }

#declare al_letter_b = difference {
	intersection { al_base  }
	intersection { al_br_out_corner  }
	intersection { al_tr_out_corner  }
	difference {
		intersection { al_top_punch  }
		intersection {
			quadric { Cylinder_Z scale <0.5 0.5 1> inverse 
					translate <3.5 3.5 0>  }
			plane { <-1 0 0> -3.5  }
		 }
	 }
	difference {
		intersection { al_bot_punch  }
		intersection {
			quadric { Cylinder_Z scale <0.5 0.5 1> inverse 
					translate <3.5 1.5 0>  }
			plane { <-1 0 0> -3.5  }
		 }
	 }
	intersection {
		quadric { Cylinder_Z scale <0.5 0.5 1> inverse
				translate <4.5 3 0>  }
		quadric { Cylinder_Z scale <0.5 0.5 1> inverse
				translate <4.5 2 0>  }
		plane { <-1 0 0> -4.5  }
		plane { <0 1 0> 3  }
		plane { <0 -1 0> -2  }
	 }
 }

#declare al_letter_c = difference {
	difference { al_letter_o  }
	intersection {
		plane { <-1 0 0> -3  }
		plane { <0 1 0> 3.5  }
		plane { <0 -1 0> -1.5  }
	 }
 }

#declare al_letter_d = difference {
	intersection { al_base  }
	intersection { al_tr_out_corner  }
	intersection { al_br_out_corner  }
	difference {
		intersection { al_center_punch  }
		intersection { al_tr_in_corner  }
		intersection { al_br_in_corner  }
	 }
 }

#declare al_letter_e = difference {
	intersection { al_base  }
	intersection { al_top_punch  }
	intersection { al_bot_punch  }
	intersection { al_right_clip  }
 }

#declare al_letter_f = difference {
	intersection { al_base  }
	intersection { al_top_punch  }
	intersection { al_right_clip  }
	intersection {
		plane { <-1 0 0> -1  }
		plane { <0 1 0> 2  }
	 }
 }

#declare al_letter_g = difference {
	intersection { al_base  }
	intersection { al_tl_out_corner  }
	intersection { al_tr_out_corner  }
	intersection { al_bl_out_corner  }
	intersection { al_br_out_corner  }
	difference {
		intersection { al_center_punch  }
		intersection { al_tl_in_corner  }
		intersection { al_tr_in_corner  }
		intersection { al_bl_in_corner  }
		intersection { al_br_in_corner  }
		intersection { 
			plane { <1 0 0> 5  }
			plane { <-1 0 0> -3  }
			plane { <0 1 0> 3  }
			plane { <0 -1 0> -2  }
		 }
	 }
	intersection {
		plane { <-1 0 0> -3  }
		plane { <0 1 0> 3.5  }
		plane { <0 -1 0> -3  }
	 }
 }

#declare al_letter_h = difference {
	intersection { al_base  }
	intersection { al_top_clip  }
	intersection { al_bot_clip  }
 }

#declare al_letter_i = difference {
	intersection { al_base  }
	intersection { al_right_clip  }
	intersection { al_left_clip  }
 }

#declare al_letter_j = difference {
	intersection { al_base  }
	intersection { al_br_out_corner  }
	intersection { al_bl_out_corner  }
	difference {
		intersection { al_center_punch  }
		intersection { al_br_out_corner  }
		intersection { al_bl_out_corner  }
	 }
	intersection {
		plane { <1 0 0> 4  }
		plane { <0 -1 0> -2  }
	 }
 }

#declare al_letter_k = difference {
	intersection { al_base  }
	difference { 
		intersection { al_top_clip  }
		intersection {
			quadric { Cylinder_Z scale <0.5 0.5 1> inverse 
					translate <3.5 3.5 0>  }
			plane { <-1 0 0> -3.5  }
			plane { <0 1 0> 3.5  }
		 }
	 }
	difference { 
		intersection { al_bot_clip  }
		intersection {
			quadric { Cylinder_Z scale <0.5 0.5 1> inverse 
					translate <3.5 1.5 0>  }
			plane { <-1 0 0> -3.5  }
			plane { <0 -1 0> -1.5  }
		 }
	 }
	intersection {
		quadric { Cylinder_Z scale <0.5 0.5 1> inverse
				translate <4.5 3 0>  }
		quadric { Cylinder_Z scale <0.5 0.5 1> inverse
				translate <4.5 2 0>  }
		plane { <-1 0 0> -4.5  }
		plane { <0 1 0> 3  }
		plane { <0 -1 0> -2  }
	 }
 }

#declare al_letter_l = difference {
	intersection { al_base  }
	intersection { 
		plane { <-1 0 0> -1  }
		plane { <0 -1 0> -1  }
	 }
 }

#declare al_letter_m = difference {
	intersection { al_base  }
	intersection { al_tl_out_corner  }
	intersection { al_tr_out_corner  }
	difference {
		intersection { 
			plane { <1 0 0> 2  }
			plane { <-1 0 0> -1  }
			plane { < 0 1 0> 4  }
		 }
		intersection {
			quadric { Cylinder_Z scale <0.5 0.5 1> inverse 
					translate <1.5 3.5 0>  }
			plane { <0 -1 0> -3.5  }
		 }
	 }
	difference {
		intersection { 
			plane { <1 0 0> 4  }
			plane { <-1 0 0> -3  }
			plane { < 0 1 0> 4  }
		 }
		intersection {
			quadric { Cylinder_Z scale <0.5 0.5 1> inverse 
					translate <3.5 3.5 0>  }
			plane { <0 -1 0> -3.5  }
		 }
	 }
	intersection {
		quadric { Cylinder_Z scale <0.5 0.5 1> inverse
				translate <2 4.5 0>  }
		quadric { Cylinder_Z scale <0.5 0.5 1> inverse
				translate <3 4.5 0>  }
		plane { <0 -1 0> -4.5  }
		plane { <1 0 0> 3  }
		plane { <-1 0 0> -2  }
	 }
 }

#declare al_letter_n = difference {
	intersection { al_base  }
	intersection {
		plane { <1 0 0> 4  }
		plane { <-1 0 0> 0 rotate <0 0 45> translate <1 5 0>  }
	 }
	intersection { 
		plane { <-1 0 0> -1  }
		plane { <1 0 0> 0 rotate <0 0 45> translate <1 3 0>  }
	 }
 }

#declare al_letter_p = difference {
	intersection { al_base  }
	intersection { al_tr_out_corner  }
	intersection {
		quadric { Cylinder_Z inverse translate <4 3 0>  }
		plane { <-1 0 0> -4  }
		plane { <0 1 0> 3  }
	 }
	intersection { 
		plane { <-1 0 0> -1  } 
		plane { <0 1 0> 2  }
	 }
	difference {
		intersection { al_top_punch  }
		intersection {
			quadric { Cylinder_Z scale <0.5 0.5 1> inverse 
					translate <3.5 3.5 0>  }
			plane { <-1 0 0> -3.5  }
		 }
	 }
 }

#declare al_letter_q = difference {
	intersection { al_base  }
	intersection { al_tl_out_corner  }
	intersection { al_tr_out_corner  }
	intersection { al_bl_out_corner  }
	intersection { al_br_out_corner  }
	difference {
		intersection { al_center_punch  }
		intersection { al_tl_in_corner  }
		intersection { al_tr_in_corner  }
		intersection { al_bl_in_corner  }
		intersection { al_br_in_corner  }
		intersection { 
			plane { <1 0 0> 3.5  }
			plane { <-1 0 0> -2.5  }
			plane { <0 1 0> 2  }
			plane { <0 -1 0> -1  }
		 }
	 }
 }

#declare al_letter_r = difference {
	intersection { al_base  }
	intersection { al_tr_out_corner  }
	intersection {
		quadric { Cylinder_Z inverse translate <4 3 0>  }
		plane { <-1 0 0> -4  }
		plane { <0 1 0> 3  }
		plane { <0 -1 0> -1.99  }
	 }
	difference {
		intersection { 
			plane { <-1 0 0> -1  } 
			plane { <0 1 0> 2  }
		 }
		intersection {
			plane { <-1 0 0> 0 rotate <0 0 27> translate <4 0 0>  }
			plane { <1 0 0> 0 rotate <0 0 27> translate <5 0 0>  }
		 }
	 }
	difference {
		intersection { al_top_punch  }
		intersection {
			quadric { Cylinder_Z scale <0.5 0.5 1> inverse 
					translate <3.5 3.5 0>  }
			plane { <-1 0 0> -3.5  }
		 }
	 }
 }

#declare al_letter_s = difference {
	intersection { al_base  }
	intersection { al_tl_out_corner  }
	intersection { al_bl_out_corner  }
	intersection { al_br_out_corner  }
	intersection { al_tr_out_corner  }
	difference {
		intersection { al_top_punch  }
		intersection {
			quadric { Cylinder_Z scale <0.5 0.5 1> inverse 
					translate <3.5 3.5 0>  }
			plane { <-1 0 0> -3.5  }
			plane { <0 -1 0> -3.5  }
		 }
		intersection {
			quadric { Cylinder_Z scale <0.5 0.5 1> inverse 
					translate <1.5 3.5 0>  }
			plane { <1 0 0> 1.5  }
		 }
	 }
	difference {
		intersection { al_bot_punch  }
		intersection {
			quadric { Cylinder_Z scale <0.5 0.5 1> inverse 
					translate <3.5 1.5 0>  }
			plane { <-1 0 0> -3.5  }
		 }
		intersection {
			quadric { Cylinder_Z scale <0.5 0.5 1> inverse 
					translate <1.5 1.5 0>  }
			plane { <1 0 0> 1.5  }
			plane { <0 1 0> 1.5  }
		 }
	 }
	intersection {
		quadric { Cylinder_Z inverse translate <1 3 0>  }
		plane { <1 0 0> 1.01  }
		plane { <0 1 0> 3  }
		plane { <0 -1 0> -1.5  }
	 }
	intersection {
		quadric { Cylinder_Z inverse translate <4 2 0>  }
		plane { <-1 0 0> -3.99  }
		plane { <0 1 0> 3.5  }
		plane { <0 -1 0> -2  }
	 }
 }

#declare al_letter_t = difference {
	intersection { al_base  }
	intersection { 
		plane { <1 0 0> 2  }
		plane { <0 1 0> 4  }
	 }
	intersection { 
		plane { <-1 0 0> -3  }
		plane { <0 1 0> 4  }
	 }
 }

#declare al_letter_u = difference {
	intersection { al_base  }
	intersection { al_bl_out_corner  }
	intersection { al_br_out_corner  }
	difference {
		intersection { 
			plane { <1 0 0> 4  }
			plane { <-1 0 0> -1  }
			plane { <0 -1 0> -1  }
		 }
		intersection { al_bl_in_corner  }
		intersection { al_br_in_corner  }
	 }
 }

#declare al_letter_v = difference {
	intersection { al_base  }
	plane { <1 0 0> 0 rotate <0 0 21.8> translate <2 0 0>  }
	plane { <-1 0 0> 0 rotate <0 0 -21.8> translate <3 0 0>  }
	intersection {
		plane { <-1 0 0> 0 rotate <0 0 21.8> translate <3 0 0>  }
		plane { <1 0 0> 0 rotate <0 0 -21.8> translate <2 0 0>  }
	 }
 }

#declare al_letter_w = difference {
	intersection { al_base  }
	intersection { al_bl_out_corner  }
	intersection { al_br_out_corner  }
	difference {
		intersection { 
			plane { <1 0 0> 2  }
			plane { <-1 0 0> -1  }
			plane { <0 -1 0> -1  }
		 }
		intersection {
			quadric { Cylinder_Z scale <0.5 0.5 1> inverse 
					translate <1.5 1.5 0>  }
			plane { <0 1 0> 1.5  }
		 }
	 }
	difference {
		intersection { 
			plane { <1 0 0> 4  }
			plane { <-1 0 0> -3  }
			plane { <0 -1 0> -1  }
		 }
		intersection {
			quadric { Cylinder_Z scale <0.5 0.5 1> inverse 
					translate <3.5 1.5 0>  }
			plane { <0 1 0> 1.5  }
		 }
	 }
	intersection {
		quadric { Cylinder_Z scale <0.5 0.5 1> inverse
				translate <2 0.5 0>  }
		quadric { Cylinder_Z scale <0.5 0.5 1> inverse
				translate <3 0.5 0>  }
		plane { <0 1 0> 0.5  }
		plane { <1 0 0> 3  }
		plane { <-1 0 0> -2  }
	 }
	intersection {
		plane { <1 0 0> 4  }
		plane { <-1 0 0> -1  }
		plane { <0 -1 0> -4  }
	 }
 }

#declare al_letter_x = difference {
	intersection { al_base  }
	intersection {
		plane { <-1 0 0> 0 rotate <0 0 45> translate <6 0 0>  }
		plane { <1 0 0> 0 rotate <0 0 -45> translate <-1 0 0>  }
	 }
	intersection {
		plane { <-1 0 0> 0 rotate <0 0 -45> translate <1 0 0>  }
		plane { <1 0 0> 0 rotate <0 0 45> translate <4 0 0>  }
	 }
	intersection {
		plane { <1 0 0> 0 rotate <0 0 45> translate <4 0 0>  }
		plane { <1 0 0> 0 rotate <0 0 -45> translate <-1 0 0>  }
	 }
	intersection {
		plane { <-1 0 0> 0 rotate <0 0 45> translate <6 0 0>  }
		plane { <-1 0 0> 0 rotate <0 0 -45> translate <1 0 0>  }
	 }
 }

#declare al_letter_y = difference {
	intersection { al_base  }
	intersection {
		plane { <1 0 0> 0 rotate <0 0 33.7> translate <0 5 0>  }
		plane { <1 0 0> 2  }
	 }
	intersection {
		plane { <-1 0 0> 0 rotate <0 0 -33.7> translate <5 5 0>  }
		plane { <-1 0 0> -3  }
	 }
	intersection {
		plane { <-1 0 0> 0 rotate <0 0 33.7> translate <1 5 0>  }
		plane { <1 0 0> 0 rotate <0 0 -33.7> translate <4 5 0>  }
	 }
 }

#declare al_letter_z = difference {
	intersection { al_base  }
	intersection {
		plane { <0 1 0> 4  }
		plane { <1 0 0> 0 rotate <0 0 -45> translate <0 1 0>  }
	 }
	intersection { 
		plane { <0 -1 0> -1  }
		plane { <-1 0 0> 0 rotate <0 0 -45> translate <2 1 0>  }
	 }
 }

